#!/bin/bash

set -e
set -o pipefail

# This script is able to track obsolete and missing copyright entries
# It works only with DEP-5 formated copyright files.
# It is unable to track copyright holders info, so modified files have to be checked by hand.


# path to NUR sources
SRC=${1:-.}

LIST=$(grep '^Files: ' debian/copyright | cut -d: -f2- | sed 's/,/\n/g; s/ //g' | grep -Ev '^\*$')

echo "### Projects removed:"
UNSORTED_LISTED=$(tempfile)
for P in ${LIST}; do
  if echo ${P} | grep -qE "^debian"; then
    continue
  fi

  if ls ${SRC}/${P} >/dev/null 2>/dev/null; then
    # catch wilcard patterns and whole directories too
    find ${SRC} \( -wholename "${SRC}/${P}" -o -wholename "${SRC}/${P}/*" \) -printf '%P\n' >>${UNSORTED_LISTED} 2>/dev/null
  else
    echo ${P}
  fi
done

SORTED_LISTED=$(tempfile)
cat ${UNSORTED_LISTED} | sort | uniq >${SORTED_LISTED}

SORTED_FULL_NEW=$(tempfile)
#find ${SRC} -type f -wholename '${SRC}/lib/*' -printf '%P\n' | sort >${SORTED_FULL_NEW}
find ${SRC} -mindepth 2 -type f -printf '%P\n' | sort >${SORTED_FULL_NEW}

echo "### Projects new or with default copyright attribution ('Files: *' in 'debian/copyright'):"
comm -1 -3 ${SORTED_LISTED} ${SORTED_FULL_NEW} | grep -v svn

# cleanup
rm -f ${UNSORTED_LISTED} ${SORTED_LISTED} ${SORTED_FULL_NEW}

