package org.jboss.cache.optimistic;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import static org.testng.AssertJUnit.assertFalse;
import static org.testng.AssertJUnit.assertTrue;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

/**
 * Tests the hasChild() API
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.0.0
 */
@Test(groups = "functional")
public class HasChildTest extends AbstractOptimisticTestCase
{
   private CacheSPI<Object, Object> cache;
   private TransactionManager txMgr;
   private Fqn f = Fqn.fromString("/a");

   @BeforeMethod(alwaysRun = true)
   public void setUp() throws Exception
   {
      cache = createCache();
      txMgr = cache.getTransactionManager();
   }

   @AfterMethod(alwaysRun = true)
   public void tearDown()
   {
      super.tearDown();
      destroyCache(cache);
   }

   public void testExists() throws Exception
   {
      cache.put(f, "k", "v");

      assertTrue(cache.getRoot().hasChild(f));

      cache.removeNode(f);

      assertFalse(cache.getRoot().hasChild(f));

      txMgr.begin();

      cache.put(f, "k", "v");
      assertTrue(cache.getRoot().hasChild(f));

      Transaction t = txMgr.suspend();
      assertFalse(cache.getRoot().hasChild(f));

      txMgr.resume(t);
      assertTrue(cache.getRoot().hasChild(f));
      txMgr.commit();

      assertTrue(cache.getRoot().hasChild(f));

      txMgr.begin();
      assertTrue(cache.getRoot().hasChild(f));
      cache.removeNode(f);
      assertFalse(cache.getRoot().hasChild(f));

      t = txMgr.suspend();
      assertTrue(cache.getRoot().hasChild(f));
      txMgr.resume(t);
      assertFalse(cache.getRoot().hasChild(f));
      txMgr.commit();

      assertFalse(cache.getRoot().hasChild(f));
   }
}
