/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.loader;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * ConnectionFactory interface defining the operations to be defined by connection providers
 *
 * @author <a href="mailto:hmesha@novell.com">Hany Mesha </a>
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 */
public interface ConnectionFactory
{
    void setConfig(AdjListJDBCCacheLoaderConfig config);

    void start() throws Exception;

    Connection getConnection() throws SQLException;

    void prepare(Object tx);

    void commit(Object tx);

    void rollback(Object tx);

    void close(Connection con);

    void stop();
}
