/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttrColor;
import org.eclipse.swt.internal.gtk.PangoAttrInt;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    boolean inComposition;

    IME() {
    }

    public IME(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] result = new int[this.ranges.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.ranges[i] + this.startOffset;
            ++i;
        }
        return result;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] result = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, result, 0, this.styles.length);
        return result;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        this.checkWidget();
        return false;
    }

    long gtk_button_press_event(long widget, long event) {
        if (!this.isInlineEnabled()) {
            return 0L;
        }
        long imHandle = this.imHandle();
        if (imHandle != 0L) {
            OS.gtk_im_context_reset(imHandle);
        }
        return 0L;
    }

    long gtk_commit(long imcontext, long textPtr) {
        int length;
        if (!this.isInlineEnabled()) {
            return 0L;
        }
        boolean doit = true;
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        this.caretOffset = 0;
        if (textPtr != 0L && this.inComposition && (length = OS.strlen(textPtr)) != 0) {
            byte[] buffer = new byte[length];
            OS.memmove(buffer, textPtr, (long)length);
            char[] chars = Converter.mbcsToWcs(null, buffer);
            Event event = new Event();
            event.detail = 1;
            event.start = this.startOffset;
            event.end = this.startOffset + this.text.length();
            this.text = chars != null ? new String(chars) : "";
            event.text = this.text;
            this.commitCount = this.text.length();
            this.sendEvent(43, event);
            doit = event.doit;
            this.text = "";
            this.startOffset = -1;
            this.commitCount = 0;
        }
        this.inComposition = false;
        return doit ? 0 : 1;
    }

    long gtk_preedit_changed(long imcontext) {
        if (!this.isInlineEnabled()) {
            return 0L;
        }
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        long imHandle = this.imHandle();
        long[] preeditString = new long[1];
        long[] pangoAttrs = new long[1];
        int[] cursorPos = new int[1];
        OS.gtk_im_context_get_preedit_string(imHandle, preeditString, pangoAttrs, cursorPos);
        this.caretOffset = cursorPos[0];
        char[] chars = null;
        if (preeditString[0] != 0L) {
            int length = OS.strlen(preeditString[0]);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, preeditString[0], (long)length);
            chars = Converter.mbcsToWcs(null, buffer);
            if (pangoAttrs[0] != 0L) {
                int count = 0;
                long iterator = OS.pango_attr_list_get_iterator(pangoAttrs[0]);
                while (OS.pango_attr_iterator_next(iterator)) {
                    ++count;
                }
                OS.pango_attr_iterator_destroy(iterator);
                this.ranges = new int[count * 2];
                this.styles = new TextStyle[count];
                iterator = OS.pango_attr_list_get_iterator(pangoAttrs[0]);
                PangoAttrColor attrColor = new PangoAttrColor();
                PangoAttrInt attrInt = new PangoAttrInt();
                int[] start = new int[1];
                int[] end = new int[1];
                int i = 0;
                while (i < count) {
                    GdkColor color;
                    OS.pango_attr_iterator_range(iterator, start, end);
                    this.ranges[i * 2] = (int)OS.g_utf8_pointer_to_offset(preeditString[0], preeditString[0] + (long)start[0]);
                    this.ranges[i * 2 + 1] = (int)OS.g_utf8_pointer_to_offset(preeditString[0], preeditString[0] + (long)end[0]) - 1;
                    this.styles[i] = new TextStyle(null, null, null);
                    long attr = OS.pango_attr_iterator_get(iterator, 9);
                    if (attr != 0L) {
                        OS.memmove(attrColor, attr, (long)PangoAttrColor.sizeof);
                        color = new GdkColor();
                        color.red = attrColor.color_red;
                        color.green = attrColor.color_green;
                        color.blue = attrColor.color_blue;
                        this.styles[i].foreground = Color.gtk_new(this.display, color);
                    }
                    if ((attr = OS.pango_attr_iterator_get(iterator, 10)) != 0L) {
                        OS.memmove(attrColor, attr, (long)PangoAttrColor.sizeof);
                        color = new GdkColor();
                        color.red = attrColor.color_red;
                        color.green = attrColor.color_green;
                        color.blue = attrColor.color_blue;
                        this.styles[i].background = Color.gtk_new(this.display, color);
                    }
                    if ((attr = OS.pango_attr_iterator_get(iterator, 11)) != 0L) {
                        OS.memmove(attrInt, attr, (long)PangoAttrInt.sizeof);
                        this.styles[i].underline = attrInt.value != 0;
                        this.styles[i].underlineStyle = 0;
                        switch (attrInt.value) {
                            case 2: {
                                this.styles[i].underlineStyle = 1;
                                break;
                            }
                            case 4: {
                                this.styles[i].underlineStyle = 2;
                            }
                        }
                        if (this.styles[i].underline && (attr = OS.pango_attr_iterator_get(iterator, 18)) != 0L) {
                            OS.memmove(attrColor, attr, (long)PangoAttrColor.sizeof);
                            color = new GdkColor();
                            color.red = attrColor.color_red;
                            color.green = attrColor.color_green;
                            color.blue = attrColor.color_blue;
                            this.styles[i].underlineColor = Color.gtk_new(this.display, color);
                        }
                    }
                    OS.pango_attr_iterator_next(iterator);
                    ++i;
                }
                OS.pango_attr_iterator_destroy(iterator);
                OS.pango_attr_list_unref(pangoAttrs[0]);
            }
            OS.g_free(preeditString[0]);
        }
        if (chars != null) {
            Event event;
            if (this.text.length() == 0) {
                if (chars.length == 0) {
                    return 0L;
                }
                this.startOffset = -1;
            }
            int end = this.startOffset + this.text.length();
            if (this.startOffset == -1) {
                event = new Event();
                event.detail = 3;
                this.sendEvent(43, event);
                this.startOffset = event.start;
                end = event.end;
            }
            this.inComposition = true;
            event = new Event();
            event.detail = 1;
            event.start = this.startOffset;
            event.end = end;
            this.text = chars != null ? new String(chars) : "";
            event.text = this.text;
            this.sendEvent(43, event);
        }
        return 1L;
    }

    long imHandle() {
        return this.parent.imHandle();
    }

    boolean isInlineEnabled() {
        return this.hooks(43);
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.styles = null;
        this.ranges = null;
    }

    public void setCompositionOffset(int offset) {
        this.checkWidget();
        if (offset < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = offset;
        }
    }
}

