/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBundle;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSDirectoryEnumerator;
import org.eclipse.swt.internal.cocoa.NSEnumerator;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMutableSet;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSWorkspace;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Display;

public final class Program {
    String name;
    String fullPath;
    String identifier;
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";

    Program() {
    }

    public static Program findProgram(String extension) {
        int url;
        byte[] fsRef;
        char[] chars;
        NSAutoreleasePool pool;
        block8: {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            try {
                if (extension == null) {
                    SWT.error(4);
                }
                if (extension.length() != 0) break block8;
                Object var9_2 = null;
            }
            catch (Throwable throwable) {
                Object var9_4 = null;
                pool.release();
                throw throwable;
            }
            pool.release();
            return null;
        }
        Program program = null;
        if (extension.charAt(0) != '.') {
            chars = new char[extension.length()];
            extension.getChars(0, chars.length, chars, 0);
        } else {
            chars = new char[extension.length() - 1];
            extension.getChars(1, extension.length(), chars, 0);
        }
        NSString ext = NSString.stringWithCharacters(chars, chars.length);
        if (ext != null && OS.LSGetApplicationForInfo(0, 0, ext.id, -1, fsRef = new byte[80], null) == 0 && (url = OS.CFURLCreateFromFSRef(OS.kCFAllocatorDefault(), fsRef)) != 0) {
            NSString bundlePath = new NSURL(url).path();
            NSBundle bundle = NSBundle.bundleWithPath(bundlePath);
            if (bundle != null) {
                program = Program.getProgram(bundle);
            }
            OS.CFRelease(url);
        }
        Program program2 = program;
        Object var9_3 = null;
        pool.release();
        return program2;
    }

    public static String[] getExtensions() {
        String[] stringArray;
        NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            id id2;
            NSMutableSet supportedDocumentTypes = (NSMutableSet)NSMutableSet.set();
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            NSString CFBundleDocumentTypes = NSString.stringWith("CFBundleDocumentTypes");
            NSString CFBundleTypeExtensions = NSString.stringWith("CFBundleTypeExtensions");
            NSArray array = new NSArray(OS.NSSearchPathForDirectoriesInDomains(100, 65535, true));
            int count = array.count();
            int i = 0;
            while (i < count) {
                NSString path = new NSString(array.objectAtIndex(i));
                NSFileManager fileManager = NSFileManager.defaultManager();
                NSDirectoryEnumerator enumerator = fileManager.enumeratorAtPath(path);
                if (enumerator != null) {
                    id id3;
                    while ((id3 = enumerator.nextObject()) != null) {
                        enumerator.skipDescendents();
                        NSString filePath = new NSString(id3.id);
                        NSString fullPath = path.stringByAppendingPathComponent(filePath);
                        if (!workspace.isFilePackageAtPath(fullPath)) continue;
                        NSBundle bundle = NSBundle.bundleWithPath(fullPath);
                        id id4 = id3 = bundle != null ? bundle.infoDictionary().objectForKey(CFBundleDocumentTypes) : null;
                        if (id3 == null) continue;
                        NSDictionary documentTypes = new NSDictionary(id3.id);
                        NSEnumerator documentTypesEnumerator = documentTypes.objectEnumerator();
                        while ((id3 = documentTypesEnumerator.nextObject()) != null) {
                            NSDictionary documentType = new NSDictionary(id3.id);
                            id3 = documentType.objectForKey(CFBundleTypeExtensions);
                            if (id3 == null) continue;
                            supportedDocumentTypes.addObjectsFromArray(new NSArray(id3.id));
                        }
                    }
                }
                ++i;
            }
            i = 0;
            String[] exts = new String[supportedDocumentTypes.count()];
            NSEnumerator enumerator = supportedDocumentTypes.objectEnumerator();
            while ((id2 = enumerator.nextObject()) != null) {
                String ext = new NSString(id2.id).getString();
                if (ext.equals("*")) continue;
                exts[i++] = "." + ext;
            }
            if (i != exts.length) {
                String[] temp = new String[i];
                System.arraycopy(exts, 0, temp, 0, i);
                exts = temp;
            }
            stringArray = exts;
            Object var18_19 = null;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            pool.release();
            throw throwable;
        }
        pool.release();
        return stringArray;
    }

    static Program getProgram(NSBundle bundle) {
        NSString CFBundleName = NSString.stringWith("CFBundleName");
        NSString CFBundleDisplayName = NSString.stringWith("CFBundleDisplayName");
        NSString fullPath = bundle.bundlePath();
        NSString identifier = bundle.bundleIdentifier();
        id bundleName = bundle.objectForInfoDictionaryKey(CFBundleDisplayName);
        if (bundleName == null) {
            bundleName = bundle.objectForInfoDictionaryKey(CFBundleName);
        }
        if (bundleName == null) {
            bundleName = fullPath.lastPathComponent().stringByDeletingPathExtension();
        }
        NSString name = new NSString(bundleName.id);
        Program program = new Program();
        program.name = name.getString();
        program.fullPath = fullPath.getString();
        program.identifier = identifier != null ? identifier.getString() : "";
        return program;
    }

    public static Program[] getPrograms() {
        Object[] objectArray;
        NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            Vector<Program> vector = new Vector<Program>();
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            NSArray array = new NSArray(OS.NSSearchPathForDirectoriesInDomains(100, 65535, true));
            int count = array.count();
            int i = 0;
            while (i < count) {
                NSString path = new NSString(array.objectAtIndex(i));
                NSFileManager fileManager = NSFileManager.defaultManager();
                NSDirectoryEnumerator enumerator = fileManager.enumeratorAtPath(path);
                if (enumerator != null) {
                    id id2;
                    while ((id2 = enumerator.nextObject()) != null) {
                        NSBundle bundle;
                        enumerator.skipDescendents();
                        NSString fullPath = path.stringByAppendingPathComponent(new NSString(id2.id));
                        if (!workspace.isFilePackageAtPath(fullPath) || (bundle = NSBundle.bundleWithPath(fullPath)) == null) continue;
                        vector.addElement(Program.getProgram(bundle));
                    }
                }
                ++i;
            }
            Object[] programs = new Program[vector.size()];
            vector.copyInto(programs);
            objectArray = programs;
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            pool.release();
            throw throwable;
        }
        pool.release();
        return objectArray;
    }

    static NSURL getURL(String fileName) {
        String lowercaseName = fileName.toLowerCase();
        NSString unescapedStr = lowercaseName.startsWith(PREFIX_HTTP) || lowercaseName.startsWith(PREFIX_HTTPS) ? NSString.stringWith("%#") : NSString.stringWith("%");
        NSString fullPath = NSString.stringWith(fileName);
        if (NSFileManager.defaultManager().fileExistsAtPath(fullPath)) {
            fullPath = NSURL.fileURLWithPath(fullPath).absoluteString();
        }
        int ptr = OS.CFURLCreateStringByAddingPercentEscapes(0, fullPath.id, unescapedStr.id, 0, 0x8000100);
        NSString escapedString = new NSString(ptr);
        NSURL url = NSURL.URLWithString(escapedString);
        OS.CFRelease(ptr);
        return url;
    }

    static boolean isExecutable(String fileName) {
        int ptr = OS.malloc(1);
        NSString path = NSString.stringWith(fileName);
        boolean result = false;
        NSFileManager manager = NSFileManager.defaultManager();
        if (manager.fileExistsAtPath(path, ptr)) {
            byte[] isDirectory = new byte[1];
            OS.memmove(isDirectory, ptr, 1);
            if (isDirectory[0] == 0 && manager.isExecutableFileAtPath(path)) {
                NSWorkspace ws = NSWorkspace.sharedWorkspace();
                NSString type = ws.typeOfFile(path, 0);
                result = type != null && (ws.type(type, NSString.stringWith("public.unix-executable")) || OS.UTTypeEqual(type.id, NSString.stringWith((String)"public.shell-script").id));
            }
        }
        OS.free(ptr);
        return result;
    }

    public static boolean launch(String fileName) {
        return Program.launch(fileName, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean launch(String fileName, String workingDir) {
        boolean bl;
        NSAutoreleasePool pool;
        block8: {
            block7: {
                if (fileName == null) {
                    SWT.error(4);
                }
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                try {
                    if (workingDir != null && Program.isExecutable(fileName)) {
                        try {
                            Compatibility.exec(new String[]{fileName}, null, workingDir);
                        }
                        catch (IOException iOException) {
                            Object var5_4 = null;
                            pool.release();
                            return false;
                        }
                        Object var5_3 = null;
                        break block7;
                    }
                    NSURL url = Program.getURL(fileName);
                    NSWorkspace workspace = NSWorkspace.sharedWorkspace();
                    bl = workspace.openURL(url);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    pool.release();
                    throw throwable;
                }
            }
            pool.release();
            return true;
        }
        Object var5_5 = null;
        pool.release();
        return bl;
    }

    public boolean execute(String fileName) {
        boolean bl;
        if (fileName == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            NSURL url = Program.getURL(fileName);
            NSArray urls = NSArray.arrayWithObject(url);
            bl = workspace.openURLs(urls, NSString.stringWith(this.identifier), 0, null, 0);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            pool.release();
            throw throwable;
        }
        pool.release();
        return bl;
    }

    public ImageData getImageData() {
        NSAutoreleasePool pool;
        block3: {
            ImageData imageData;
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            try {
                NSImage nsImage;
                NSWorkspace workspace = NSWorkspace.sharedWorkspace();
                NSString fullPath = this.fullPath != null ? NSString.stringWith(this.fullPath) : workspace.fullPathForApplication(NSString.stringWith(this.name));
                if (fullPath == null || (nsImage = workspace.iconForFile(fullPath)) == null) break block3;
                NSSize size = new NSSize();
                size.height = 16.0f;
                size.width = 16.0f;
                nsImage.setSize(size);
                nsImage.retain();
                Image image = Image.cocoa_new(Display.getCurrent(), 0, nsImage);
                ImageData imageData2 = image.getImageData();
                image.dispose();
                imageData = imageData2;
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                pool.release();
                throw throwable;
            }
            pool.release();
            return imageData;
        }
        Object var8_10 = null;
        pool.release();
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.name.equals(program.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

