/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    static final int UNDERLINE_THICK = 65536;

    IME() {
    }

    public IME(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    int attributedSubstringFromRange(int id2, int sel, int rangePtr) {
        Event event = new Event();
        event.detail = 3;
        this.sendEvent(43, event);
        NSRange range = new NSRange();
        OS.memmove(range, rangePtr, NSRange.sizeof);
        int start = range.location;
        int end = range.location + range.length;
        if (event.start <= start && start <= event.end && event.start <= end && end <= event.end) {
            NSString str = (NSString)new NSString().alloc();
            str = str.initWithString(event.text.substring(start - event.start, end - event.start));
            NSAttributedString attriStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(str, null);
            str.release();
            attriStr.autorelease();
            return attriStr.id;
        }
        return 0;
    }

    int characterIndexForPoint(int id2, int sel, int point) {
        if (!this.isInlineEnabled()) {
            return Integer.MAX_VALUE;
        }
        NSPoint pt = new NSPoint();
        OS.memmove(pt, point, NSPoint.sizeof);
        NSView view = this.parent.view;
        pt = view.window().convertScreenToBase(pt);
        pt = view.convertPoint_fromView_(pt, null);
        Event event = new Event();
        event.detail = 2;
        event.x = (int)pt.x;
        event.y = (int)pt.y;
        this.sendEvent(43, event);
        int offset = event.index + event.count;
        return offset != -1 ? offset : Integer.MAX_VALUE;
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    NSRect firstRectForCharacterRange(int id2, int sel, int range) {
        NSRect rect = new NSRect();
        Caret caret = this.parent.caret;
        if (caret != null) {
            NSView view = this.parent.view;
            NSPoint pt = new NSPoint();
            pt.x = caret.x;
            pt.y = caret.y + caret.height;
            pt = view.convertPoint_toView_(pt, null);
            pt = view.window().convertBaseToScreen(pt);
            rect.x = pt.x;
            rect.y = pt.y;
            rect.width = caret.width;
            rect.height = caret.height;
        }
        return rect;
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] result = new int[this.ranges.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.ranges[i] + this.startOffset;
            ++i;
        }
        return result;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] result = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, result, 0, this.styles.length);
        return result;
    }

    TextStyle getStyle(NSDictionary attribs) {
        NSArray keys = attribs.allKeys();
        int count = keys.count();
        TextStyle style = new TextStyle();
        int j = 0;
        while (j < count) {
            NSNumber value;
            float[] rgbColor;
            NSColor color;
            NSString key = new NSString(keys.objectAtIndex(j));
            if (key.isEqualTo(OS.NSBackgroundColorAttributeName)) {
                color = new NSColor(attribs.objectForKey(key)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                rgbColor = new float[]{color.redComponent(), color.greenComponent(), color.blueComponent(), color.alphaComponent()};
                style.background = Color.cocoa_new(this.display, rgbColor);
            } else if (key.isEqualTo(OS.NSForegroundColorAttributeName)) {
                color = new NSColor(attribs.objectForKey(key)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                rgbColor = new float[]{color.redComponent(), color.greenComponent(), color.blueComponent(), color.alphaComponent()};
                style.foreground = Color.cocoa_new(this.display, rgbColor);
            } else if (key.isEqualTo(OS.NSUnderlineColorAttributeName)) {
                color = new NSColor(attribs.objectForKey(key)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                rgbColor = new float[]{color.redComponent(), color.greenComponent(), color.blueComponent(), color.alphaComponent()};
                style.underlineColor = Color.cocoa_new(this.display, rgbColor);
            } else if (key.isEqualTo(OS.NSUnderlineStyleAttributeName)) {
                value = new NSNumber(attribs.objectForKey(key));
                switch (value.intValue()) {
                    case 1: {
                        style.underlineStyle = 0;
                        break;
                    }
                    case 9: {
                        style.underlineStyle = 1;
                        break;
                    }
                    case 2: {
                        style.underlineStyle = 65536;
                    }
                }
                style.underline = value.intValue() != 0;
            } else if (key.isEqualTo(OS.NSStrikethroughColorAttributeName)) {
                color = new NSColor(attribs.objectForKey(key)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                rgbColor = new float[]{color.redComponent(), color.greenComponent(), color.blueComponent(), color.alphaComponent()};
                style.strikeoutColor = Color.cocoa_new(this.display, rgbColor);
            } else if (key.isEqualTo(OS.NSStrikethroughStyleAttributeName)) {
                value = new NSNumber(attribs.objectForKey(key));
                style.strikeout = value.intValue() != 0;
            } else if (key.isEqualTo(OS.NSFontAttributeName)) {
                NSFont font = new NSFont(attribs.objectForKey(key));
                font.retain();
                style.font = Font.cocoa_new(this.display, font);
            }
            ++j;
        }
        return style;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        return false;
    }

    boolean hasMarkedText(int id2, int sel) {
        return this.text.length() != 0;
    }

    boolean insertText(int id2, int sel, int string) {
        if (this.startOffset == -1) {
            return true;
        }
        NSString str = new NSString(string);
        if (str.isKindOfClass(OS.class_NSAttributedString)) {
            str = new NSAttributedString(string).string();
        }
        int length = str.length();
        int end = this.startOffset + this.text.length();
        this.resetStyles();
        this.caretOffset = this.commitCount = length;
        Event event = new Event();
        event.detail = 1;
        event.start = this.startOffset;
        event.end = end;
        event.text = this.text = str.getString();
        this.sendEvent(43, event);
        this.text = "";
        this.commitCount = 0;
        this.caretOffset = 0;
        this.startOffset = -1;
        return event.doit;
    }

    boolean isInlineEnabled() {
        return this.hooks(43);
    }

    NSRange markedRange(int id2, int sel) {
        NSRange range = new NSRange();
        if (this.startOffset != -1) {
            range.location = this.startOffset;
            range.length = this.text.length();
        } else {
            range.location = Integer.MAX_VALUE;
        }
        return range;
    }

    void resetStyles() {
        if (this.styles != null) {
            int i = 0;
            while (i < this.styles.length) {
                TextStyle style = this.styles[i];
                Font font = style.font;
                if (font != null) {
                    font.handle.release();
                }
                ++i;
            }
        }
        this.styles = null;
        this.ranges = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.resetStyles();
    }

    NSRange selectedRange(int id2, int sel) {
        Event event = new Event();
        event.detail = 3;
        this.sendEvent(43, event);
        NSRange range = new NSRange();
        range.location = event.start;
        range.length = event.text.length();
        return range;
    }

    public void setCompositionOffset(int offset) {
        this.checkWidget();
        if (offset < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = offset;
        }
    }

    boolean setMarkedText_selectedRange(int id2, int sel, int string, int selRange) {
        NSString str;
        if (!this.isInlineEnabled()) {
            return true;
        }
        this.resetStyles();
        this.commitCount = 0;
        this.caretOffset = 0;
        int end = this.startOffset + this.text.length();
        if (this.startOffset == -1) {
            Event event = new Event();
            event.detail = 3;
            this.sendEvent(43, event);
            this.startOffset = event.start;
            end = event.end;
        }
        if ((str = new NSString(string)).isKindOfClass(OS.class_NSAttributedString)) {
            NSAttributedString attribStr = new NSAttributedString(string);
            str = attribStr.string();
            int length = str.length();
            this.styles = new TextStyle[length];
            this.ranges = new int[length * 2];
            NSRange rangeLimit = new NSRange();
            NSRange effectiveRange = new NSRange();
            rangeLimit.length = length;
            int rangeCount = 0;
            int ptr = OS.malloc(NSRange.sizeof);
            int i = 0;
            while (i < length) {
                NSDictionary attribs = attribStr.attributesAtIndex(i, ptr, rangeLimit);
                OS.memmove(effectiveRange, ptr, NSRange.sizeof);
                i = effectiveRange.location + effectiveRange.length;
                this.ranges[rangeCount * 2] = effectiveRange.location;
                this.ranges[rangeCount * 2 + 1] = effectiveRange.location + effectiveRange.length - 1;
                this.styles[rangeCount++] = this.getStyle(attribs);
            }
            OS.free(ptr);
            if (rangeCount != this.styles.length) {
                TextStyle[] newStyles = new TextStyle[rangeCount];
                System.arraycopy(this.styles, 0, newStyles, 0, newStyles.length);
                this.styles = newStyles;
                int[] newRanges = new int[rangeCount * 2];
                System.arraycopy(this.ranges, 0, newRanges, 0, newRanges.length);
                this.ranges = newRanges;
            }
        }
        int length = str.length();
        if (this.ranges == null && length > 0) {
            this.styles = new TextStyle[]{this.getStyle(this.display.markedAttributes)};
            int[] nArray = new int[2];
            nArray[1] = length - 1;
            this.ranges = nArray;
        }
        NSRange range = new NSRange();
        OS.memmove(range, selRange, NSRange.sizeof);
        this.caretOffset = range.location;
        Event event = new Event();
        event.detail = 1;
        event.start = this.startOffset;
        event.end = end;
        event.text = this.text = str.getString();
        this.sendEvent(43, event);
        if (this.isDisposed()) {
            return false;
        }
        if (this.text.length() == 0) {
            Shell s = this.parent.getShell();
            s.keyInputHappened = true;
            this.startOffset = -1;
            this.resetStyles();
        }
        return true;
    }

    int validAttributesForMarkedText(int id2, int sel) {
        NSMutableArray attribs = NSMutableArray.arrayWithCapacity(6);
        attribs.addObject(new NSString(OS.NSForegroundColorAttributeName()));
        attribs.addObject(new NSString(OS.NSBackgroundColorAttributeName()));
        attribs.addObject(new NSString(OS.NSUnderlineStyleAttributeName()));
        attribs.addObject(new NSString(OS.NSUnderlineColorAttributeName()));
        attribs.addObject(new NSString(OS.NSStrikethroughStyleAttributeName()));
        attribs.addObject(new NSString(OS.NSStrikethroughColorAttributeName()));
        return attribs.id;
    }
}

