/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    private static RTFTransfer _instance = new RTFTransfer();
    private static final String CF_RTF = "Rich Text Format";
    private static final int CF_RTFID = RTFTransfer.registerType("Rich Text Format");

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int count = string.length();
        char[] chars = new char[count + 1];
        string.getChars(0, count, chars, 0);
        int codePage = OS.GetACP();
        int cchMultiByte = OS.WideCharToMultiByte(codePage, 0, chars, -1, null, 0, null, null);
        if (cchMultiByte == 0) {
            transferData.stgmedium = new STGMEDIUM();
            transferData.result = -2147221402;
            return;
        }
        long lpMultiByteStr = OS.GlobalAlloc(64, cchMultiByte);
        OS.WideCharToMultiByte(codePage, 0, chars, -1, lpMultiByteStr, cchMultiByte, null, null);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = lpMultiByteStr;
        transferData.stgmedium.pUnkForRelease = 0L;
        transferData.result = 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        block14: {
            block13: {
                if (this.isSupportedType(transferData) == false) return null;
                if (transferData.pIDataObject == 0L) {
                    return null;
                }
                data = new IDataObject(transferData.pIDataObject);
                data.AddRef();
                stgmedium = new STGMEDIUM();
                formatetc = transferData.formatetc;
                stgmedium.tymed = 1;
                transferData.result = this.getData(data, formatetc, stgmedium);
                data.Release();
                if (transferData.result != 0) {
                    return null;
                }
                hMem = stgmedium.unionField;
                try {
                    block12: {
                        lpMultiByteStr = OS.GlobalLock(hMem);
                        if (lpMultiByteStr == 0L) {
                        } else {
                            try {
                                codePage = OS.GetACP();
                                cchWideChar = OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, null, 0);
                                if (cchWideChar == 0) {
                                    var12_12 = null;
                                    break block12;
                                }
                                lpWideCharStr = new char[cchWideChar - 1];
                                OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, lpWideCharStr, lpWideCharStr.length);
                                var14_16 = new String(lpWideCharStr);
                            }
                            catch (Throwable var13_17) {
                                var12_14 = null;
                                OS.GlobalUnlock(hMem);
                                throw var13_17;
                            }
                        }
lbl40:
                        // 2 sources

                        while (true) {
                            var15_7 = null;
                            break block13;
                            break;
                        }
                    }
                    OS.GlobalUnlock(hMem);
                    ** continue;
                    var12_13 = null;
                    OS.GlobalUnlock(hMem);
                    break block14;
                }
                catch (Throwable var16_18) {
                    var15_9 = null;
                    OS.GlobalFree(hMem);
                    throw var16_18;
                }
            }
            OS.GlobalFree(hMem);
            return null;
        }
        var15_8 = null;
        OS.GlobalFree(hMem);
        return var14_16;
    }

    protected int[] getTypeIds() {
        return new int[]{CF_RTFID};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_RTF};
    }

    boolean checkRTF(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }
}

