/*
 * Copyright (C) 2012  Christian Mollekopf <mollekopf@kolabsys.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "kolabconversion.h"
#include "commonconversion.h"
#include <akonadi/notes/noteutils.h>

namespace Kolab {
    namespace Conversion {
        
Note fromNote(const KMime::Message::Ptr &m)
{
    Akonadi::NoteUtils::NoteMessageWrapper note(m);
    Note n;
    n.setSummary(note.title().toStdString());
    n.setDescription(note.text().toStdString());
    n.setCreated(fromDate(note.creationDate()));
    return n;
}

KMime::Message::Ptr toNote(const Note &n)
{
    Akonadi::NoteUtils::NoteMessageWrapper note;
    note.setTitle(QString::fromStdString(n.summary()));
    note.setText(QString::fromStdString(n.description()));
    note.setFrom("kolab@kde4");
    note.setCreationDate(toDate(n.created()));
    return note.message();
}

        
    }
}

