/*
 * Copyright (C) 2012  Christian Mollekopf <mollekopf@kolabsys.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KOLABDEFINITIONS_H
#define KOLABDEFINITIONS_H

#include <QString>

namespace Kolab {

#define KOLAB_FOLDER_TYPE_MAIL    "mail"
#define KOLAB_FOLDER_TYPE_CONTACT "contact"
#define KOLAB_FOLDER_TYPE_EVENT   "event"
#define KOLAB_FOLDER_TYPE_TASK    "task"
#define KOLAB_FOLDER_TYPE_JOURNAL "journal"
#define KOLAB_FOLDER_TYPE_NOTE    "note"

#define KOLAB_FOLDER_TYPE_DEFAULT_SUFFIX ".default"

#define KOLAB_FOLDER_TYPE_ANNOTATION "/vendor/kolab/folder-type"

#define X_KOLAB_TYPE_HEADER "X-Kolab-Type"
#define X_KOLAB_VERSION_HEADER "X-Kolab-Version"
#define KOLAB_VERSION_V3 "v3"

#define KOLAB_OBJECT_FILENAME "kolab.xml"

static QString eventKolabType() { return QString::fromLatin1("application/x-vnd.kolab.event"); };
static QString todoKolabType() { return QString::fromLatin1("application/x-vnd.kolab.task"); };
static QString journalKolabType() { return QString::fromLatin1("application/x-vnd.kolab.journal"); };
static QString contactKolabType() { return QString::fromLatin1("application/x-vnd.kolab.contact"); };
static QString distlistKolabType() { return QString::fromLatin1("application/x-vnd.kolab.contact.distlist"); }
static QString distlistKolabTypeCompat() { return QString::fromLatin1("application/x-vnd.kolab.distribution-list"); }
static QString noteKolabType() { return QString::fromLatin1("application/x-vnd.kolab.note"); }

static QString xCalMimeType() { return QString::fromLatin1("application/calendar+xml"); };
static QString xCardMimeType() { return QString::fromLatin1("application/vcard+xml"); };
static QString noteMimeType() { return QString::fromLatin1("application/x-vnd.kolab.*"); };

}

#endif
