/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax2.OutputContentHandler;
import com.jclark.xsl.sax2.RawCharactersHandler;
import java.io.IOException;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Indenter
implements OutputContentHandler,
CommentHandler,
RawCharactersHandler {
    private ContentHandler _contentHandler = null;
    private CommentHandler _commentHandler = null;
    private RawCharactersHandler _rawCharactersHandler;
    private char[] _newline = new char[]{'\n'};
    private static final byte IN_PCDATA_CHUNK = 0;
    private static final byte JUST_HAD_START_TAG = 1;
    private static final byte OTHER = 2;
    private byte _state = 0;

    public Indenter(ContentHandler handler, RawCharactersHandler rawCharactersHandler) {
        this._contentHandler = handler;
        this._commentHandler = handler instanceof CommentHandler ? (CommentHandler)((Object)handler) : null;
        this._rawCharactersHandler = rawCharactersHandler;
    }

    public ContentHandler init(Destination dest, Properties atts) throws IOException, SAXException {
        if (this._contentHandler instanceof OutputContentHandler) {
            this._contentHandler = ((OutputContentHandler)this._contentHandler).init(dest, atts);
        }
        return this;
    }

    public void setDocumentLocator(Locator locator) {
        this._contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this._contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.maybeNewline();
        this._contentHandler.endDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.maybeNewline();
        this._state = 1;
        this._contentHandler.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this._state == 1) {
            this._state = (byte)2;
        } else {
            this.maybeNewline();
        }
        this._contentHandler.endElement(namespaceURI, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            this._contentHandler.characters(ch, start, length);
            this._state = 0;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            this._contentHandler.ignorableWhitespace(ch, start, length);
            this._state = 0;
        }
    }

    public void rawCharacters(String chars) throws SAXException {
        if (chars.length() > 0) {
            this._rawCharactersHandler.rawCharacters(chars);
            this._state = 0;
        }
    }

    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        this._contentHandler.startPrefixMapping(prefix, namespaceURI);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this._contentHandler.endPrefixMapping(prefix);
    }

    public void skippedEntity(String name) throws SAXException {
        this._contentHandler.skippedEntity(name);
    }

    private final void maybeNewline() throws SAXException {
        if (this._state != 0) {
            this._contentHandler.characters(this._newline, 0, 1);
            this._newline[0] = 10;
        }
        this._state = (byte)2;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.maybeNewline();
        this._contentHandler.processingInstruction(target, data);
    }

    public void comment(String contents) throws SAXException {
        if (this._commentHandler != null) {
            this.maybeNewline();
            this._commentHandler.comment(contents);
        }
    }
}

