/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HistogramAttributes.cc
    \brief Implementation of Histogram Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed Dec  5 12:07:13 2012
*/    

#include "HistogramAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


HistogramAttributes::HistogramAttributes():
	levels_(MagTranslator<string, LevelSelection>().magics("histogram_selection_type")),
	min_(ParameterManager::getDouble("histogram_min_value")),
	max_(ParameterManager::getDouble("histogram_max_value")),
	count_(ParameterManager::getInt("histogram_level_count")),
	tolerance_(ParameterManager::getInt("histogram_level_tolerance")),
	reference_(ParameterManager::getDouble("histogram_reference_level")),
	interval_(ParameterManager::getDouble("histogram_interval")),
	list_(ParameterManager::getDoubleArray("histogram_level_list")),
	colour_(MagTranslator<string, Colour>().magics("histogram_bar_colour")),
	width_(ParameterManager::getDouble("histogram_bar_width"))
{
} 



HistogramAttributes::~HistogramAttributes()
{
}

    
void HistogramAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(0);

	setMember(prefix, "histogram_selection_type", levels_, params);
	setAttribute(prefix, "histogram_min_value", min_, params);
	setAttribute(prefix, "histogram_max_value", max_, params);
	setAttribute(prefix, "histogram_level_count", count_, params);
	setAttribute(prefix, "histogram_level_tolerance", tolerance_, params);
	setAttribute(prefix, "histogram_reference_level", reference_, params);
	setAttribute(prefix, "histogram_interval", interval_, params);
	setAttribute(prefix, "histogram_level_list", list_, params);
	setAttribute(prefix, "histogram_bar_colour", colour_, params);
	setAttribute(prefix, "histogram_bar_width", width_, params);
}

void HistogramAttributes::copy(const HistogramAttributes& other)
{
	levels_ = auto_ptr<LevelSelection>(other.levels_->clone());
	min_ = other.min_;
	max_ = other.max_;
	count_ = other.count_;
	tolerance_ = other.tolerance_;
	reference_ = other.reference_;
	interval_ = other.interval_;
	list_ = other.list_;
	colour_ = auto_ptr<Colour>(other.colour_->clone());
	width_ = other.width_;
} 


bool HistogramAttributes::accept(const string& node)
{	
	if ( magCompare(node, "histogram")  )
		return true;

	if ( acceptNode(node, levels_) )
		return true;
	return false;
}

void HistogramAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "histogram") )
		set(node.attributes());
	else {
		setMember(node.name(), levels_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), levels_, *(*elt)); 
	}
}

void HistogramAttributes::print(ostream& out)  const
{
	out << "HistogramAttributes[";
	out << "levels = " << *levels_;
	out << ", min = " << min_;
	out << ", max = " << max_;
	out << ", count = " << count_;
	out << ", tolerance = " << tolerance_;
	out << ", reference = " << reference_;
	out << ", interval = " << interval_;
	out << ", list = " << list_;
	out << ", colour = " << *colour_;
	out << ", width = " << width_;
	out << "]" << "\n";
}


void HistogramAttributes::toxml(ostream& out)  const
{
     out <<  "\"histogram\"";
	 out << ", \"histogram_selection_type\":";
	 levels_->toxml(out);
	 out << ", \"histogram_min_value\":";
	 niceprint(out,min_);
	 out << ", \"histogram_max_value\":";
	 niceprint(out,max_);
	 out << ", \"histogram_level_count\":";
	 niceprint(out,count_);
	 out << ", \"histogram_level_tolerance\":";
	 niceprint(out,tolerance_);
	 out << ", \"histogram_reference_level\":";
	 niceprint(out,reference_);
	 out << ", \"histogram_interval\":";
	 niceprint(out,interval_);
	 out << ", \"histogram_level_list\":";
	 niceprint(out,list_);
	 out << ", \"histogram_bar_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"histogram_bar_width\":";
	 niceprint(out,width_);
}
static MagicsParameter<string> histogram_selection_type("histogram_selection_type", "count", "");
static MagicsParameter<double> histogram_min_value("histogram_min_value", -1.e21, "");
static MagicsParameter<double> histogram_max_value("histogram_max_value", 1.e21, "");
static MagicsParameter<int> histogram_level_count("histogram_level_count", 10, "");
static MagicsParameter<int> histogram_level_tolerance("histogram_level_tolerance", 2, "");
static MagicsParameter<double> histogram_reference_level("histogram_reference_level", 0.0, "");
static MagicsParameter<double> histogram_interval("histogram_interval", 8.0, "");
static MagicsParameter<floatarray> histogram_level_list("histogram_level_list", floatarray(), "");
static MagicsParameter<string> histogram_bar_colour("histogram_bar_colour", "evergreen", "");
static MagicsParameter<double> histogram_bar_width("histogram_bar_width", 1, "");
#include "CountSelectionType.h"
#include "IntervalSelectionType.h"
#include "LevelListSelectionType.h"
static SimpleObjectMaker<CountSelectionType, LevelSelection> count_CountSelectionType("count");
static SimpleObjectMaker<IntervalSelectionType, LevelSelection> interval_IntervalSelectionType("interval");
static SimpleObjectMaker<LevelListSelectionType, LevelSelection> list_LevelListSelectionType("list");
