/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BoxPlotWhiskerLineAttributes.cc
    \brief Implementation of BoxPlotWhiskerLine Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed Dec  5 12:07:16 2012
*/    

#include "BoxPlotWhiskerLineAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


BoxPlotWhiskerLineAttributes::BoxPlotWhiskerLineAttributes():
	colour_(MagTranslator<string, Colour>().magics("boxplot_whisker_line_colour")),
	thickness_(ParameterManager::getInt("boxplot_whisker_line_thickness")),
	style_(MagTranslator<string, LineStyle>().magics("boxplot_whisker_line_style"))
{
} 



BoxPlotWhiskerLineAttributes::~BoxPlotWhiskerLineAttributes()
{
}

    
void BoxPlotWhiskerLineAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	prefix[0] = "boxplot_whisker_line";
	prefix[1] = "boxplot_whisker";
	prefix[2] = "boxplot";

	setAttribute(prefix, "boxplot_whisker_line_colour", colour_, params);
	setAttribute(prefix, "boxplot_whisker_line_thickness", thickness_, params);
	setAttribute(prefix, "boxplot_whisker_line_style", style_, params);
}

void BoxPlotWhiskerLineAttributes::copy(const BoxPlotWhiskerLineAttributes& other)
{
	colour_ = auto_ptr<Colour>(other.colour_->clone());
	thickness_ = other.thickness_;
	style_ = other.style_;
} 


bool BoxPlotWhiskerLineAttributes::accept(const string& node)
{	
	if ( magCompare(node, "whisker_line")  )
		return true;
	return false;
}

void BoxPlotWhiskerLineAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "whisker_line") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void BoxPlotWhiskerLineAttributes::print(ostream& out)  const
{
	out << "BoxPlotWhiskerLineAttributes[";
	out << "colour = " << *colour_;
	out << ", thickness = " << thickness_;
	out << ", style = " << style_;
	out << "]" << "\n";
}


void BoxPlotWhiskerLineAttributes::toxml(ostream& out)  const
{
     out <<  "\"whisker_line\"";
	 out << ", \"boxplot_whisker_line_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"boxplot_whisker_line_thickness\":";
	 niceprint(out,thickness_);
	 out << ", \"boxplot_whisker_line_style\":";
	 niceprint(out,style_);
}
static MagicsParameter<string> boxplot_whisker_line_colour("boxplot_whisker_line_colour", "navy", "");
static MagicsParameter<int> boxplot_whisker_line_thickness("boxplot_whisker_line_thickness", 3, "");
static MagicsParameter<string> boxplot_whisker_line_style("boxplot_whisker_line_style", "solid", "");
