"""
Standalone installation program for pykdedocs

Must be run as root

The following files are installed in the indicated locations:
(all require root privileges, except as noted)

Permissions should be read-only for all users/groups, incl owner

examples/*          /usr/share/doc/packages/PyKDE4/examples
tutorials/*         /usr/share/doc/packages/PyKDE4/tutorials
documentation/*     /usr/share/doc/packages/PyKDE4/doc

pykdesdocs.py       /usr/bin/pykdedocs

indexof.py          PyKDE4 module directory (from pykdeconfig)
pykdedocscfg.py     PyKDE4 module directory
setprogramlogo.py   PyKDE4 module directory

pykdedocsui.rc      in KDE app directory structure
poster*.png         /usr/share/doc/packages/PyKDE4/documentation/html/images
aboutkde.png        /usr/share/doc/packages/PyKDE4/documentation/html/images

HTML copies of licenses are in /usr/share/doc/packages/PyKDE/doc/html
        
        --- Not installed here ---
userindex.txt       in user's .kde4/share at intial run
                    initial copy in /usr/share/doc/packages/PyKDE4
                    must be user-writable
pykdedocsrc         in user's .kde4/share/config at initial run
                    must be user-writable
"""

import sys, os, os.path

import PyQt4.pyqtconfig
pyqtcfg  = PyQt4.pyqtconfig.Configuration ()

import PyKDE4.pykdeconfig
pykdecfg = PyKDE4.pykdeconfig.Configuration ()

if os.getuid ():
    print "Must be root to install pykdedocs"
    sys.exit (-1)

docDir = os.path.join ("/", "usr", "share", "doc", "packages", "PyKDE4")
exeDir = os.path.join ("/", "usr", "bin")
apiDir = os.path.join (pyqtcfg.qt_data_dir, 'qsci', 'api', 'python')

print "installing pykdedocs and supporting files"
os.system ("cp pykdedocs/pykdedocs.py %s" % os.path.join (exeDir,  "pykdedocs"))
os.system ("cp tools/pykdeuic/pykdeuic4 %s" % os.path.join (exeDir))
os.system ("chmod a+x %s" % os.path.join (exeDir, "pykdedocs"))
os.system ("chmod a+x %s" % os.path.join (exeDir, "pykdeuic4"))
os.system ("cp -f pykdedocs/pykdedocscfg.py %s" % pykdecfg.pykde_mod_dir)
os.system ("cp -f pykdedocs/indexof.py %s" % pykdecfg.pykde_mod_dir)
os.system ("cp -f pykdedocs/setprogramlogo.py %s" % pykdecfg.pykde_mod_dir)

print "installing documentation"
os.system ("cp -Rf %s %s" % ("doc", docDir))

print "installing examples"
os.system ("cp -Rf %s %s" % ("examples", docDir))

print "installing tutorials"
os.system ("cp -Rf %s %s" % ("tutorials", docDir))

os.system ("cp -f pykdedocs/userindex.txt %s" % docDir)
os.system ("cp -f pykdedocs/pykdedocsui.rc %s" % docDir)    
os.system ("cp -f pykdedocs/CREATIVECOMMONS.html %s" % docDir)
os.system ("cp -f pykdedocs/COPYING %s" % docDir)
os.system ("cp -f pykdedocs/COPYING.LESSER %s" % docDir)

# api strings
print 'installing api file'

apifile = open (os.path.join (apiDir, 'PyKDE4.api'), 'w')

for mod in pykdecfg.pykde_modules.split():
    modapi = open ('%s.api' % mod, 'r')
    for line in modapi:
        apifile.write (line)
    modapi.close ()

apifile.close ()
