#
#     Copyright 2007-2008 Jim Bublitz <jbublitz@nwinternet.com>
#

# This software is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.

# This software is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public
# License along with this library; see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

from PyQt4.QtCore import SIGNAL, Qt,  QString

from PyQt4.QtGui import QLabel, QSpinBox, QPushButton, QCheckBox, QRadioButton
from PyQt4.QtGui import QTabWidget,  QTreeWidget,  QTreeWidgetItem

from PyKDE4.kdecore import KConfigGroup, ki18n, i18n, KUrl

from PyKDE4.kdeui import KTabWidget, KDialog, KVBox, KHBox, KIcon, KLineEdit
from PyKDE4.kdeui import KMessageBox

from PyKDE4.kio import KFileDialog

import indexof

paths = None

class ConfigDialog (KDialog):
    def __init__ (self, parent, configFile,  _paths):        
        KDialog.__init__ (self, parent)       
        global paths
        paths = _paths
        
        self.mainWin    = parent
        self.configFile = configFile
        
        buttonCode = KDialog.ButtonCodes (KDialog.Ok) | KDialog.ButtonCodes (KDialog.Cancel)
        self.setButtons (buttonCode)
        self.connect (self, SIGNAL ("okClicked ()"), self.slotOKClicked)
        
        self.tabs = KTabWidget (self)
        self.setMainWidget (self.tabs)            

        self.pathEdit    = {}
        
        self.General     = KConfigGroup (self.configFile, "General")
        
        self.basePath       = self.General.readEntry ("BasePath")
        self.userPath       = self.General.readEntry ("UserPath")
        self.expandValue    = int (self.General.readEntry ("ExpandValue", "2"))
        self.historyLength  = int (self.General.readEntry ("History Length", "20"))
        self.tabOrient      = int (self.General.readEntry ("TabPosition", "3"))
        self.samplesEnabled = int (self.General.readEntry ("Samples Enabled",  "1"))
        self.favor          = int (self.General.readEntry ("Favor",  "0"))
        
        self.tabs.insertTab(0, self.behaviorTab (), 'Behavior')
        self.tabs.insertTab(1, self.pathsTab (), 'Paths')
        
    def slotOKClicked (self):
        global paths
        self.expandValue = self.expandLevel.value ()

        for path in self.pathEdit:
            if path == "basePath":
                self.basePath = self.pathEdit [path].text ()
            elif path == "user":
                self.userPath = self.pathEdit [path].text ()
                
        if self.enableSamples.checkState () == Qt.Checked:
            self.samplesEnabled  = 1
        else:
            self.samplesEnabled  = 0
            
        if self.favorSamples.isChecked ():
            self.favor = 0
        else:
            self.favor = 2
                       
        self.jsEnabled   = self.jsEnabledCB.checkState () == Qt.Checked              
        self.javaEnabled = self.javaEnabledCB.checkState () == Qt.Checked

        for i in range (len (self.tabPos)):
            if self.tabPos [i].isChecked ():
                self.tabOrient = i
        

    def behaviorTab (self):
        layout = KVBox (self)
        layout.setMargin (15)

        hBox  = KHBox (layout)
        vBox1 = KVBox (hBox)
        hBox.layout ().setAlignment (vBox1, Qt.AlignTop)
        vBox2 = KVBox (hBox)
        hBox.layout ().setAlignment (vBox2, Qt.AlignTop)
        vBox3 = KVBox (hBox)
        hBox.layout ().setAlignment (vBox3, Qt.AlignTop)
        tlabel = QLabel ("Tab Position", vBox1)
        self.tabPos = []
        self.tabPos.append (QRadioButton ("Above", vBox1))
        self.tabPos.append (QRadioButton ("Below", vBox1))
        self.tabPos.append (QRadioButton ("Left", vBox1))
        self.tabPos.append (QRadioButton ("Right", vBox1))
        self.tabPos [self.tabOrient].setChecked (True)

        esLable = QLabel ("Samples",  vBox2)
        self.enableSamples = QCheckBox ("Enable", vBox2)
        vBox2.layout ().insertSpacing (2,  10)
        if self.samplesEnabled:
            self.enableSamples.setCheckState (Qt.Checked)
        self.connect (self.enableSamples,  SIGNAL ("clicked (bool)"),  self.slotEnableClicked)

        fLable = QLabel ("Favor",  vBox2)
        self.favorSamples = QRadioButton ("Sample page", vBox2)
        self.favorDocs = QRadioButton ("Docs page", vBox2)
        self.favorSamples.setChecked (self.favor == 0)

        bLabel = QLabel ("Browsers", vBox3)
        self.jsEnabledCB = QCheckBox ("Enable Java Script", vBox3)
        jsState = self.General.readEntry ("EnableJS", "False") == "True"
        if jsState:
            self.jsEnabledCB.setCheckState (Qt.Checked)
        else:            
            self.jsEnabledCB.setCheckState (Qt.Unchecked)
        
        self.javaEnabledCB = QCheckBox ("Enable Java Applets", vBox3)
        javaState = self.General.readEntry ("EnableJava", "False") == "True"
        if javaState:
            self.javaEnabledCB.setCheckState (Qt.Checked)
        else:            
            self.javaEnabledCB.setCheckState (Qt.Unchecked)


        layout.layout ().insertSpacing (1, 10)
        hBox1 = KHBox (layout)
        hBox1.setSpacing (10)
        exLabel = QLabel ("Characters typed in search box before tree expands", hBox1)
        exLabel.setFixedWidth (300)
        hBox1.layout ().setAlignment (exLabel, Qt.AlignRight)
        
        self.expandLevel = QSpinBox (hBox1)
        self.expandLevel.setFixedWidth (50)
        self.expandLevel.setMinimum (1)
        self.expandLevel.setValue (self.expandValue)
        hBox1.layout ().setAlignment (self.expandLevel, Qt.AlignLeft)
        
        hLabel = QLabel ("Url History Length",  hBox1)
        self.hLength = QSpinBox (hBox1)
        self.hLength.setFixedWidth (50)
        self.hLength.setMinimum (0)
        self.hLength.setValue (self.historyLength)
        hBox1.layout ().setAlignment (hLabel, Qt.AlignLeft)
        hBox1.layout ().setAlignment (self.hLength, Qt.AlignLeft)

        self.slotEnableClicked (self.enableSamples.checkState ()== Qt.Checked)
        return layout
        
    def slotEnableClicked (self, checked):
        if not checked:
            self.favorDocs.setChecked (True)
        self.favorDocs.setEnabled (checked)
        self.favorSamples.setEnabled (checked)

    def pathsTab (self):
        layout = KVBox (self.tabs)
        layout.setSpacing (20)
        layout.setMargin (15)
        
        self.pathEdit ["basePath"] = PathEdit (layout, "pykdedocs", self.basePath)
        self.pathEdit ["user"]     = PathEdit (layout, "User", self.userPath)
                      
        return layout
        
class PathEdit (KHBox):
    def __init__ (self, parent, name, initPath):
        KHBox.__init__ (self, parent)
                            
        self.name     = name
        self.initPath = initPath

        self.label    = QLabel (name, self)
        self.label.setFixedWidth (75)
        self.layout ().setAlignment (self.label, Qt.AlignRight)
        self.edit     = KLineEdit (self)
        self.edit.setFixedWidth (550)
        self.edit.setText (initPath)
        self.button   = QPushButton (KIcon ("folder-open"), "", self)

        self.connect (self.button, SIGNAL ("clicked ()"), self.buttonClicked)

    def buttonClicked (self):
        if self.name == "pykdedocs" or self.name == "User":
            result = str (KFileDialog.getExistingDirectory (KUrl (self.initPath), self.parent (), "Path for %s" % self.name))
        else:
            result = str (KFileDialog.getOpenFileName (KUrl (self.initPath), "", self.parent (), "Path for %s docs" % self.name))

        if result:
            self.edit.setText (result)

    def text (self):
        return str (self.edit.text ())

class BookmarkEditor (KDialog):
    def __init__ (self,  basePath, parent = None):
        KDialog.__init__ (self, parent)
        self.setMinimumWidth (640)
        self.setCaption ("Edit Bookmarks")
        self.setDefaultButton (KDialog.None)
        self.connect (self, SIGNAL ("okClicked ()"), self.slotOKClicked)
      
        self.basePath = basePath
        self.new = False
        self.newItem = None
        
        treeBox = KVBox (self)
        self.setMainWidget (treeBox)
        treeBox.setSpacing (10)        
        
        self.paths, self.userTitleList, self.bookmarkFile = indexof.user (basePath)        
        self.tree = QTreeWidget (treeBox)
        self.tree.setColumnCount (2)
        self.tree.setHeaderLabels (["Title","URL"])
        self.tree.setColumnWidth (0, 200)
        self.tree.setColumnWidth (1, 400)
        self.connect (self.tree,  SIGNAL ("itemSelectionChanged ()"),  self.slotSelectionChanged)
        
        for title in self.userTitleList:
            item = QTreeWidgetItem (self.tree, [title, self.paths [title][0]])
            for bookmark in self.paths [title][1]:
                item1 = QTreeWidgetItem (item,  [bookmark,  self.bookmarkFile [bookmark]])
 
        editBox  = KHBox (treeBox)
        editBox.setSpacing (10)
        titleLbl = QLabel ("Title", editBox)
        self.titleEdit = KLineEdit (editBox)
        self.connect (self.titleEdit,  SIGNAL ("textChanged (const QString&)"),  self.slotTextChanged)
        self.connect (self.titleEdit,  SIGNAL ("returnPressed ()"),  self.slotApplyClicked)
        urlLbl   = QLabel ("URL", editBox)
        self.urlEdit = KLineEdit (editBox)
        self.urlEdit.setMinimumWidth (400)
        self.connect (self.urlEdit,  SIGNAL ("textChanged (const QString&)"),  self.slotTextChanged)
        self.connect (self.urlEdit,  SIGNAL ("returnPressed ()"),  self.slotApplyClicked)
 
        buttonBox  = KHBox (treeBox)
        btnWidth   = 75
        delBtn     = QPushButton ("Delete",  buttonBox)
        delBtn.setFixedWidth (btnWidth)
        newBtn = QPushButton ("New",  buttonBox)
        newBtn.setFixedWidth (btnWidth)
        self.applyBtn = QPushButton ("Apply",  buttonBox)
        self.applyBtn.setFixedWidth (btnWidth)        
        browseBtn = QPushButton (KIcon ("folder-open"), "Browse", buttonBox)
        browseBtn.setFixedWidth (btnWidth)
       
        treeBox.layout ().insertSpacing (2,  10)
        treeBox.layout ().insertSpacing (-1,  30)
        
        self.connect (newBtn,  SIGNAL ("clicked ()"), self.slotNewClicked)
        self.connect (delBtn,  SIGNAL ("clicked ()"), self.slotDelClicked)
        self.connect (self.applyBtn,  SIGNAL ("clicked ()"), self.slotApplyClicked)
        self.connect (browseBtn, SIGNAL ("clicked ()"), self.slotBrowseClicked)
        
        self.applyBtn.setEnabled (False)

    def slotSelectionChanged (self):
        item = self.tree.selectedItems () [0]
        self.titleEdit.setText (item.text (0))
        self.urlEdit.setText (item.text (1))
        if self.new:
            self.titleEdit.selectAll ()
            
    def slotTextChanged (self, s):
        self.applyBtn.setEnabled (self.titleEdit.text () != QString ())
        
    def slotNewClicked (self):
        self.new = True
        self.newItem = QTreeWidgetItem (self.tree, ["New Item"])
        self.tree.setCurrentItem (self.newItem)
        
    def slotDelClicked (self):
        item = self.tree.currentItem ()
        title = str (item.text (0))
        if not item.parent ():
            if item.childCount ():
                result = KMessageBox.questionYesNo (self, "The item being deleted has additional bookmarks.\n"\
                            "Delete them?",  "Delete all?")
                if result == KMessageBox.No:
                    return

            del self.paths [title]
            self.userTitleList.remove (title)
            self.tree.takeTopLevelItem (self.tree.indexOfTopLevelItem (item))
        else:
            item.parent ().removeChild (item)
            bookmark = item 
            self.paths [str (item.parent ().text (0))][1].remove (bookmark)
            del self.bookmarkFile [bookmark]

    def slotApplyClicked (self):
        item = self.tree.currentItem ()        
        oldTitle = str (item.text (0))
        newTitle = str (self.titleEdit.text ())
        newPath  = str (self.urlEdit.text ())
        if not item.parent ():
            if self.new:
                data = []
            else:
                data = self.paths [oldTitle][1]
                del self.paths [oldTitle]
                self.userTitleList.remove (oldTitle)
            self.paths [newTitle] = (newPath,  data)
            self.userTitleList.append (newTitle)
            self.userTitleList.sort ()
        else:
            parent = item.parent ()
            parentTitle = str (parent.text (0))
            self.paths [parentTitle][1].remove (oldTitle)
            del self.bookmarkFile [oldTitle]
            self.bookmarkFile [newTitle] = newPath
            self.paths [parentTitle][1].append (newTitle)
            self.paths [parentTitle][1].sort ()

        item.setText (0, newTitle)
        item.setText (1, newPath)       
        self.new = False
        self.applyBtn.setEnabled (False)
        
    def slotBrowseClicked (self):
        result = str (KFileDialog.getOpenFileName (KUrl (), "", self.parent (), "Path"))

        if result:
            self.urlEdit.setText (result)
 
    def slotOKClicked (self):
        indexof.writeUser (self.basePath, self.paths, self.userTitleList, self.bookmarkFile)
        
        
class AddBookmarkFolder (KDialog):
    def __init__ (self, parent = None):
        KDialog.__init__ (self, parent)
        self.setCaption ("Add Bookmark Folder")
        self.connect (self, SIGNAL ("okClicked ()"), self.slotOKClicked)

        self.name = ""
        self.url  = ""
        
        vBox = KVBox (self)
        self.setMainWidget (vBox)
        vBox.setSpacing (10)        
        vBox.layout ().insertSpacing (-1,  30)

        hBox1 = KHBox (vBox)
        hBox1.setSpacing (2)
        hBox2 = KHBox (vBox)
        hBox2.setSpacing (2)
        
        nameLbl = QLabel ("Name",  hBox1)
        nameLbl.setFixedWidth (40)
        self.nameEdit = KLineEdit (hBox1)
        self.nameEdit.setFixedWidth (200)
        hBox1.layout ().setAlignment (nameLbl, Qt.AlignLeft)
        hBox1.layout ().setAlignment (self.nameEdit, Qt.AlignLeft)
        hBox1.layout ().insertSpacing (-1,  232)
        
        urlLbl = QLabel ("URL",  hBox2)
        urlLbl.setFixedWidth (40)
        self.urlEdit = KLineEdit (hBox2)
        self.urlEdit.setFixedWidth (400)
        browseBtn = QPushButton (KIcon ("folder-open"), "", hBox2)
        browseBtn.setFixedWidth (30)
        self.connect (browseBtn, SIGNAL ("clicked ()"), self.slotBrowseClicked)

    def slotOKClicked (self):
        self.name = str (self.nameEdit.text ())
        self.url  = str (self.urlEdit.text ())

    def slotBrowseClicked (self):
        result = str (KFileDialog.getOpenFileName (KUrl (), "", self.parent (), "Path"))

        if result:
            self.urlEdit.setText (result)
        
