//
//	SimpleOBEXServer.h
//
//	Shows how the BTUtil framework can be used to run a simple OBEX server that
//	allows clients to send and retrieve files through the server.
//
//	To receive files through this server, you'll need to get the remote device 
//	to specifically send them to the channel that's being used by this OBEX 
//	service; that is, the integer value passed to the BBOBEXServer 
//	startOnChannelID: method. (In this example, the SimpleOBEXServer start: 
//  method logs this value to the screen.)
//
//	If you can't specify a channel when sending files from the remote device --
//  for example, the Mac OS X "Send File..." Bluetooth utility only lets you 
//  select a device, and not the channel -- this probably means that the device 
//  is just sending the files to the first OBEX service it can find. So if you 
//  switch off all other OBEX services, e.g. the Mac OS X system OBEX services, 
//  this demo's OBEX service should automatically receive the files. 
//	
//	To switch off the system services, go to Bluetooth Preferences, and go to
//  the "File Exchange" tab. For "When receiving items", select "Refuse all", 
//  and also uncheck "Allow other devices to browse files on this computer". 
//  This switches off the system's OBEX Object Push service and OBEX File 
//  Transfer service, respectively.
//
//	If you want to specify the channel, and the remote device is a Mac, the 
//  included FileClient example, as well as Apple's OBEXSample (in 
//	/Developer/Examples/Bluetooth) and the IOBluetooth OBEXFileTransferServices
//	class all let you connect to a specific channel when connecting to an OBEX
//	service.
//


#import <Cocoa/Cocoa.h>

@class BBOBEXServer;

@interface SimpleOBEXServer : NSObject
{
	BBOBEXServer *myOBEXServer;
	BluetoothSDPServiceRecordHandle serviceRecordHandle;
	
    IBOutlet id logTextView;
    IBOutlet id rootDirectory;
    IBOutlet id serviceName;
    IBOutlet id startOrStopButton;
}

- (IBAction)startOrStop:(id)sender;

- (IBAction)start:(id)sender;
- (IBAction)stop:(id)sender;
- (void)log:(NSString *)logText;

@end