.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "xpainet n"
.TH xpainet n "April 14, 2011" "version 2.1.13" "SAORD Documentation"
.SH "NAME"
\&\fBXPAInet: XPA Communication Between Hosts\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\s-1XPA\s0 uses standard inet sockets to support communication between two or
more host computers.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
When the Communication Method is set to
\&\fBinet\fR (as it is by default), \s-1XPA\s0 can be used to communicate
between different computers on the Internet.  \s-1INET\s0 sockets utilize the
\&\s-1IP\s0 address of the given machine and a (usually random) port number to
communicate between processes on the same machine or between different
machines on the Internet.  These standard Internet sockets are also
used by programs such as Netscape, ftp. etc.
.PP
\&\s-1XPA\s0 supports a host-based Access Control mechanism
to prevent unauthorized access of \s-1XPA\s0 access points by other computers
on the Net.  By default, only the machine on which the \s-1XPA\s0 server is
running can access \s-1XPA\s0 services. Therefore, setting up communication
between a local \s-1XPA\s0 server machine and a remote client machine
requires a two-part registration process:
.IP "\(bu" 4
the \s-1XPA\s0 service on the local machine must be made known to the 
remote machine
.IP "\(bu" 4
the remote machine must be given permission to access the local
\&\s-1XPA\s0 service
.PP
Three methods by which this remote registration can be accomplished
are described below.
.PP
\&\fBManual Registration\fR
.PP
The first method is the most basic and does not require the remote
client to have xpans running.  To use it, the local server simply
gives a remote client machine access to one or more \s-1XPA\s0 access points
using xpaset and the \fB\-acl\fR sub\-command. For example,
consider the \s-1XPA\s0 test program \*(L"stest\*(R" running on a local machine.  By
default the access control for the access point named \*(L"xpa\*(R" is
restricted to that machine:
.PP
.Vb 3
\&  [sh]$ xpaget xpa -acl
\&  *:* 123.456.78.910 gisa
\&  *:* localhost gisa
.Ve
.PP
Using xpaset and the \fB\-acl\fR sub\-command, a remote client
machine can be given permission to perform xpaget, xpaset, xpaaccess,
or xpainfo operations.  For example, to allow the xpaget operation, the
following command can be issued on the local machine:
.PP
.Vb 1
\&  [sh]$ xpaset -p xpa -acl "remote_machine g"
.Ve
.PP
This results in the following access permissions on the local machine:
.PP
.Vb 4
\&  [sh]$ xpaget xpa -acl
\&  XPA:xpa 234.567.89.012 g
\&  *:* 123.456.78.910 gisa
\&  *:* localhost gisa
.Ve
.PP
The remote client can now use the local server's xpans name server to
establish communication with the local \s-1XPA\s0 service. This can be done
on a call-by-call basis using the \fB\-i\fR switch on xpaset, xpaget, etc:
.PP
.Vb 6
\&  [sh]$ xpaget -i "local_machine:12345" xpa
\&  class: XPA
\&  name: xpa
\&  method: 88877766:2778
\&  sendian: little
\&  cendian: big
.Ve
.PP
Alternatively, the \s-1XPA_NSINET\s0 variable on the remote machine can be
set to point directly to xpans on the local machine, removing
the need to override this value each time an \s-1XPA\s0 program is run:
.PP
.Vb 7
\&  [csh]$ setenv XPA_NSINET 'karapet:$port'
\&  [csh]$ xpaget xpa
\&  class: XPA
\&  name: xpa
\&  method: 88877766:2778
\&  sendian: little
\&  cendian: big
.Ve
.PP
Here, '$port' means to use the default \s-1XPA\s0 name service port (14285).
not a port environment variable.
.PP
Access permission for remote client machines can be stored in a file
on the local machine pointed to by the \fB\s-1XPA_ACLFILE\s0\fR environment
variable or using the \fB\s-1XPA_DEFACL\s0\fR environment variable. See <A
HREF=\*(L"./acl.html\*(R">\s-1XPA\s0 Access Control for more information.
.PP
\&\fBRemote Registration\fR
.PP
If xpans is running on the remote client machine, then a local xpaset
command can be used with the \fB\-remote\fR sub-command to
register the local \s-1XPA\s0 service in the remote name service, while at
the same time giving the remote machine permission to access the local
service.  For example, assume again that \*(L"stest\*(R" is running on the
local machine and that xpans is also running on the remote machine.
To register access of this local xpa on the remote machine, use 
the xpaset and the \fB\-remote\fR sub\-command:
.PP
.Vb 1
\&  [sh]$ ./xpaset -p xpa -remote 'remote_machine:$port' +
.Ve
.PP
To register the local xpa access point on the remote machine with xpaget
access only, execute:
.PP
.Vb 1
\&  [sh]$ ./xpaset -p xpa -remote 'remote_machine:$port' g
.Ve
.PP
Once the remote registration command is executed, the remote client
machine will have an entry such as the following in its own xpans name
service:
.PP
.Vb 2
\&  [csh]$ xpaget xpans
\&  XPA xpa gs 88877766:2839 eric
.Ve
.PP
The xpa access point can now be utilized on the remote machine without
further setup:
.PP
.Vb 6
\&  [csh]$ xpaget xpa
\&  class: XPA
\&  name: xpa
\&  method: 838e2f68:2839
\&  sendian: little
\&  cendian: big
.Ve
.PP
To unregister remote access from the local machine, use the same
command but with a '\-' argument:
.PP
.Vb 1
\&  [sh]$ xpaset -p xpa -remote 'remote_machine:$port' -
.Ve
.PP
The benefit of using remote registration is that communication with
remote access points can be mixed with that of other access points
on the remote machine.  Using Access Point
Names and Templates, one \s-1XPA\s0 command can be used to send or
receive messages to the remote and local services.
.PP
\&\fB\s-1XPANS\s0 Proxy Registration\fR
.PP
The two methods described above are useful when the local and remote
machines are able to communicate freely to one another. This would be
the case on most Local Area Networks (LANs) where all machines are
behind the same firewall and there is no port blocking between
machines on the same \s-1LAN\s0.  The situation is more complicated when the
\&\s-1XPA\s0 server is behind a firewall, where outgoing connections are
allowed, but incoming port blocking is implemented to prevent machines
outside the firewall from connecting to machines inside the
firewall. Such incoming port blocking will prevent xpaset and xpaget
from connecting to an \s-1XPA\s0 server inside a firewall.
.PP
To allow locally fire-walled \s-1XPA\s0 services to register with remote
machines, we have implemented a proxy service within the xpans name
server. To register remote proxy service, xpaset and the
\&\fB\-remote\fR sub-command is again used, but with an additional
\&\fB\-proxy\fR argument added to the end of the command:
.PP
.Vb 1
\&  [sh]$ ./xpaset -p xpa -remote 'remote_machine:$port' g -proxy
.Ve
.PP
Once a remote proxy registration command is executed, the remote
machine will have an entry such as the following in its own xpans name
service:
.PP
.Vb 2
\&  [csh]$ xpaget xpans
\&  XPA xpa gs @88877766:2839 eric
.Ve
.PP
The '@' sign in the name service entry indicates that xpans proxy
processing is being used for this access point. Other than that, from
the user's point of view, there is no difference in how this \s-1XPA\s0
access point is contacted using \s-1XPA\s0 programs (xpaset, xpaget, etc.) or
libraries:
.PP
.Vb 6
\&  [csh]$ xpaget xpa
\&  class: XPA
\&  name: xpa
\&  method: 88877766:3053
\&  sendian: little
\&  cendian: big
.Ve
.PP
Of course, the underlying processing of the \s-1XPA\s0 requests is very much
different when xpans proxy is involved. Instead of an \s-1XPA\s0 program such
contacting the \s-1XPA\s0 service directly, it contacts the local xpans.
Acting as a proxy server, xpans communicates with the \s-1XPA\s0 service
using the command channel established at registration time. Commands
(including establishing a new data channel) are sent between xpans and
the \s-1XPA\s0 service to set up a new message transfer, and then data is fed
to/from the xpa request, through xpans, from/to the \s-1XPA\s0 service. In
this way, it can be arranged so that connections between the
fire-walled \s-1XPA\s0 service and the remote client are always initiated by
the \s-1XPA\s0 service itself. Thus, incoming connections that would be
blocked by the firewall are avoided. Note that there is a performance
penalty for using the xpans/proxy service.  Aside from extra overhead
to set up proxy communication, all data must be sent through the
intermediate proxy process.
.PP
The xpans proxy scheme requires that the remote client allow the local
\&\s-1XPA\s0 server machine to connect to the remote xpans/proxy server. If the
remote client machine also is behind a port-blocking firewall, such
connections will be disallowed. In this case, the only solution is to
open up some ports on the remote client machine to allow incoming
connections to xpans/proxy. Two ports must be opened (for command and
data channel connections). By default, these two ports are 14285 and
14287. The port numbers can be changed using the \fB\s-1XPA_NSINET\s0\fR
environment variable. This variable takes the form:
.PP
.Vb 1
\&  setenv XPA_NSINET machine:port1[,port2[,port3]]
.Ve
.PP
where port1 is the main connecting port, port2 is the \s-1XPA\s0 access port,
and port3 is the secondary data connecting port. The second and third
ports are optional and default to port1+1 and port1+2, respectively.
It is port1 and port3 that must be left open for incoming connections.
.PP
For example, to change the port assignments so that xpans listens
for registration commands on port 12345 and data commands on port 28573:
.PP
.Vb 1
\&  setenv XPA_NSINET myhost:12345
.Ve
.PP
Alternatively, all three ports can be assigned explicitly:
.PP
.Vb 1
\&  setenv XPA_NSINET remote:12345,3000,12346
.Ve
.PP
In this case 12345 and 12346 should be open for incoming connections.
The \s-1XPA\s0 access port (which need not be open to the outside
world) is set to 3000.
.PP
Finally, note that we currently have no mechanism to cope with
Internet proxy servers (such as \s-1SOCKS\s0 servers). If an \s-1XPA\s0 service is
running on a machine that cannot connect directly to outside machines,
but goes through a proxy server instead, there currently is no way to
register that \s-1XPA\s0 service with a remote machine.  We hope to implement
support for \s-1SOCKS\s0 proxy in a future release.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See xpa(n) for a list of \s-1XPA\s0 help pages
