from solverPaths import solverPaths

##################################################################
def getSolverFromStringName(p, solver_str):
    if p.debug:
        solverClass =  getattr(my_import(solverPaths[solver_str]), solver_str)
    else:
        try:
            solverClass = getattr(my_import(solverPaths[solver_str]), solver_str)
        except:
            p.err('incorrect solver is called, maybe the solver "' + solver_str +'" is not installed. Maybe setting p.debug=1 could specify the matter more precisely')
    return solverClass()

##################################################################
def my_import(name):
    mod = __import__(name)
    components = name.split('.')
    for comp in components[1:]:
        mod = getattr(mod, comp)
    return mod
