# -*- coding: utf-8 -*-

# Copyright (C) 2010 by Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
# 
# Python X2go is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Python X2go is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

import sys
import unittest
import tempfile
import time

# Python X2go modules
import x2go

class TestX2goClientPrinting(unittest.TestCase):

    def test_client_printing_dialog(self):
        _printing = """\
[General]
pdfview=true
showdialog=true
[print]
startcmd=false
command=lpr
[view]
open=true
command=xpdf
[CUPS]
defaultprinter=PDF
"""
        tf = tempfile.NamedTemporaryFile()
        print >> tf, _printing
        tf.seek(0)
        p_action = x2go.backends.printing.X2goClientPrinting(config_files=tf.name, client_instance='DUMMY')
        self.assertEqual(type(p_action.print_action), x2go.printactions.X2goPrintActionDIALOG)
        tf.close()

    def test_client_printing_pdfview(self):
        _printing = """\
[General]
pdfview=true
[print]
startcmd=false
command=lpr
[view]
open=true
command=xpdf
[CUPS]
defaultprinter=PDF
"""
        tf = tempfile.NamedTemporaryFile()
        print >> tf, _printing
        tf.seek(0)
        p_action = x2go.backends.printing.X2goClientPrinting(config_files=tf.name)
        self.assertEqual(type(p_action.print_action), x2go.printactions.X2goPrintActionPDFVIEW)
        tf.close()

    def test_client_printing_pdfsave(self):
        _printing = """\
[General]
pdfview=true
[print]
startcmd=false
command=lpr
[view]
open=false
command=xpdf
[CUPS]
defaultprinter=PDF
"""
        tf = tempfile.NamedTemporaryFile()
        print >> tf, _printing
        tf.seek(0)
        p_action = x2go.backends.printing.X2goClientPrinting(config_files=tf.name)
        self.assertEqual(type(p_action.print_action), x2go.printactions.X2goPrintActionPDFSAVE)
        tf.close()

    def test_client_printing_print(self):
        _printing = """\
[General]
pdfview=false
[print]
startcmd=false
command=lpr
[view]
open=false
command=xpdf
[CUPS]
defaultprinter=PDF
"""
        tf = tempfile.NamedTemporaryFile()
        print >> tf, _printing
        tf.seek(0)
        p_action = x2go.backends.printing.X2goClientPrinting(config_files=tf.name)
        self.assertEqual(type(p_action.print_action), x2go.printactions.X2goPrintActionPRINT)
        tf.close()

    def test_client_printing_printcmd(self):
        _printing = """\
[General]
pdfview=false
[print]
startcmd=true
command=lpr
[view]
open=false
command=xpdf
[CUPS]
defaultprinter=PDF
"""
        tf = tempfile.NamedTemporaryFile()
        print >> tf, _printing
        tf.seek(0)
        p_action = x2go.backends.printing.X2goClientPrinting(config_files=tf.name)
        self.assertEqual(type(p_action.print_action), x2go.printactions.X2goPrintActionPRINTCMD)
        tf.close()

def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestX2goClientPrinting))
    return suite
