% File src/library/utils/man/windows/memory.size.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2007 R Core Development Team
% Distributed under GPL 2 or later

\name{memory.size}
\alias{memory.size}
\alias{memory.limit}
\title{Report on Memory Allocation}
\description{
  \code{memory.size} reports the current or maximum memory allocation of
  the \code{malloc} function used in this version of \R.

  \code{memory.limit} reports or increases the limit in force
  on the total allocation.
}
\usage{
memory.size(max = FALSE)

memory.limit(size = NA)
}
\arguments{
  \item{max}{logical.  If true the maximum amount of memory obtained from
    the OS is reported, otherwise the amount currently in use.}
  \item{size}{numeric.  If \code{NA} report the memory size, otherwise
    request a new limit, in Mb.  Values of up to 4095 are allowed, but
    see Details.}
}
\details{
  Command-line flag \code{--max-mem-size} sets the maximum value of
  obtainable memory (including a very small amount of housekeeping
  overhead).  This cannot exceed 3Gb on 32-bit Windows, and most versions of
  Windows are limited to 2Gb.  The minimum is currently 32Mb.

  If 32-bit \R is run on some 64-bit versions of Windows the maximum
  value of obtainable memory is 4GB.

  Memory limits can only be increased.
}
\value{
  Size in Mb (1048576 bytes).
}
\seealso{
  \link{Memory-limits} for other limits.

  The rw-FAQ for more details and references.
}
\examples{
memory.size()
memory.size(TRUE)
round(memory.limit(), 2)
}
\keyword{utilities}
