/* -*-objc-*-
 *
 * Grr - Guenther's RSS Reader
 * Copyright (C) 2004-2006 Guenther Noack
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation;
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#import <AppKit/AppKit.h>
#import "ErrorLogController.h"

#import "MainController.h"

ErrorLogController* inst;

@implementation ErrorLogController

+(ErrorLogController*) instance {
  if (inst == nil) {
    inst = [[ErrorLogController alloc] init];
  }
  
  return inst;
}

-init
{
  self = [super init];
  if (self != nil) {
    inst = self;
    [getMainController() errorLogController: self];
  }
  
  return self;
}

/**
 * Clear the log window. Only execute this from the main
 * thread!
 */
- (void) clearLog: (id)sender
{
  // usually called directly from the GUI, I assume it's executed from
  // the main thread.
  [logWidget setString: @""];
}

/**
 * Don't call this! It's 'private' and may break stuff when called directly.
 * Use the thread-safe logString: method instead.
 */
- (void) _logStringInMainThread: (NSString*) aString
{
  [logWidget
    setString: [[logWidget string] stringByAppendingString: aString]];
  [logWidget display];
  
  // Finally we don't need the string any more.
  RELEASE(aString);
  
  [logWindow orderFront: self];
}

/**
 * Logs a string to the log window.
 */
- (void) logString: (NSString*) aString
{
  RETAIN(aString); // Needed to be held (seems not to be done by GS)
  [self performSelectorOnMainThread: @selector(_logStringInMainThread:)
	withObject: aString
	waitUntilDone: NO];
}

@end
