/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomEx;
import gnu.xml.dom.DomNode;
import org.w3c.dom.Document;

public abstract class DomNsNode
extends DomNode {
    private String name;
    private final String namespace;

    DomNsNode(Document document, String string, String string2) {
        super(document);
        this.name = string2;
        if ("".equals(string)) {
            string = null;
        }
        this.namespace = string;
    }

    public final String getNodeName() {
        return this.name;
    }

    public final String getNamespaceURI() {
        return this.namespace;
    }

    public String getPrefix() {
        if (this.namespace == null) {
            return null;
        }
        int n = this.name.indexOf(58);
        if (n < 0) {
            return null;
        }
        return this.name.substring(0, n);
    }

    public void setPrefix(String string) {
        String string2 = this.getLocalName();
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (string == null) {
            this.name = string2;
            return;
        }
        if (this.namespace == null) {
            throw new DomEx(14, "can't set prefix, node has no namespace URI", this, 0);
        }
        DomDocument.verifyXmlName(string);
        if (string.indexOf(58) != -1) {
            throw new DomEx(14, "illegal prefix " + string, this, 0);
        }
        if ("xml".equals(string) && !"http://www.w3.org/XML/1998/namespace".equals(this.namespace)) {
            throw new DomEx(14, "xml namespace is always http://www.w3.org/XML/1998/namespace", this, 0);
        }
        if ("xmlns".equals(string)) {
            if (this.namespace != null || this.getNodeType() != 2) {
                throw new DomEx(14, "xmlns attribute prefix is reserved", this, 0);
            }
        } else if (this.getNodeType() == 2 && ("xmlns".equals(this.name) || this.name.startsWith("xmlns:"))) {
            throw new DomEx(14, "namespace declarations can't change names", this, 0);
        }
        this.name = string + ':' + string2;
    }

    public String getLocalName() {
        if (this.namespace == null) {
            return null;
        }
        int n = this.name.indexOf(58);
        if (n < 0) {
            return this.name;
        }
        return this.name.substring(n + 1);
    }
}

