
/*
 * Copyright (c) 1999-2006, Regents of the University of California
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *  Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 * 
 *  Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 * 
 *  Neither the name of the University of California, Berkeley nor the
 *  names of its contributors may be used to endorse or promote products
 *  derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * Automatically generated library file csrc

 * The drivers embedded in this file may be covered by a different
 * license.  Scroll down to see the license appearing before each
 * driver, or see sfront/src/lib/ directories for driver source file.

 */

#include "tree.h"



void makeruntime(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Main loop for runtime";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int main(int argc, char *argv[])";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  system_init(argc, argv);";
  z[lc++]="  effects_init();";
  z[lc++]="  main_initpass();";
  z[lc++]="  for (kcycleidx=kbase; kcycleidx<=endkcycle; kcycleidx++)";
  z[lc++]="    {";
  z[lc++]="      pass = IPASS;";
  z[lc++]="      scorebeats = scoremult*(kcycleidx - kbase) + scorebase;";
  z[lc++]="      absolutetime = (kcycleidx - 1)*KTIME;";
  z[lc++]="      main_ipass();";
  z[lc++]="      pass = KPASS;";
  z[lc++]="      main_control();";
  z[lc++]="      if (main_kpass())";
  z[lc++]="	break;";
  z[lc++]="      pass = APASS;";
  z[lc++]="      for (acycleidx=0; acycleidx<ACYCLE; acycleidx++)";
  z[lc++]="	{";
  z[lc++]="	  for (busidx=0; busidx<ENDBUS;busidx++)";
  z[lc++]="	    bus[busidx]=0.0F;";
  z[lc++]="	  main_apass();";
  z[lc++]="	  for (busidx=BUS_output_bus; busidx<ENDBUS_output_bus;busidx++)";
  z[lc++]="	    {";
  z[lc++]="	      bus[busidx] = (bus[busidx] >  1.0F) ?  1.0F : bus[busidx];";
  z[lc++]="	      bus[busidx] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];";
  z[lc++]="	      asys_obuf[obusidx++] = (short) (32767.0F * bus[busidx]);";
  z[lc++]="	    }";
  z[lc++]="	  if (obusidx >= asys_osize)";
  z[lc++]="	    {";
  z[lc++]="	      obusidx = 0;";
  z[lc++]="	      if (asys_putbuf(&asys_obuf, &asys_osize))";
  z[lc++]="		{";
  z[lc++]="		  fprintf(stderr,\"  Sfront: Audio output device problem\\n\\n\");";
  z[lc++]="		  kcycleidx = endkcycle;";
  z[lc++]="		  break;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      acycleidx = 0; ";
  z[lc++]="      cpuload = ksync();";
  z[lc++]="    }";
  z[lc++]="  shut_down();";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makeruntimef(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Main loop for runtime";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int main(int argc, char *argv[])";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  system_init(argc, argv);";
  z[lc++]="  effects_init();";
  z[lc++]="  main_initpass();";
  z[lc++]="  for (kcycleidx=kbase; kcycleidx<=endkcycle; kcycleidx++)";
  z[lc++]="    {";
  z[lc++]="      pass = IPASS;";
  z[lc++]="      scorebeats = scoremult*(kcycleidx - kbase) + scorebase;";
  z[lc++]="      absolutetime = (kcycleidx - 1)*KTIME;";
  z[lc++]="      main_ipass();";
  z[lc++]="      pass = KPASS;";
  z[lc++]="      main_control();";
  z[lc++]="      if (main_kpass())";
  z[lc++]="	break;";
  z[lc++]="      pass = APASS;";
  z[lc++]="      for (acycleidx=0; acycleidx<ACYCLE; acycleidx++)";
  z[lc++]="	{";
  z[lc++]="	  for (busidx=0; busidx<ENDBUS;busidx++)";
  z[lc++]="	    bus[busidx]=0.0F;";
  z[lc++]="	  main_apass();";
  z[lc++]="	  for (busidx=BUS_output_bus; busidx<ENDBUS_output_bus;busidx++)";
  z[lc++]="	    {";
  z[lc++]="	      bus[busidx] = (bus[busidx] >  1.0F) ?  1.0F : bus[busidx];";
  z[lc++]="	      asys_obuf[obusidx++] = (bus[busidx] < -1.0F) ? -1.0F:bus[busidx];";
  z[lc++]="	    }";
  z[lc++]="	  if (obusidx >= asys_osize)";
  z[lc++]="	    {";
  z[lc++]="	      obusidx = 0;";
  z[lc++]="	      if (asys_putbuf(&asys_obuf, &asys_osize))";
  z[lc++]="		{";
  z[lc++]="		  fprintf(stderr,\"  Sfront: Audio output device problem\\n\\n\");";
  z[lc++]="		  kcycleidx = endkcycle;";
  z[lc++]="		  break;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      acycleidx = 0; ";
  z[lc++]="      cpuload = ksync();";
  z[lc++]="    }";
  z[lc++]="  shut_down();";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makecallback(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Main loop for runtime: active driver, shorts";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_O)";
  z[lc++]="";
  z[lc++]="int asys_orun(ASYS_OTYPE obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int obusidx = 0;";
  z[lc++]="  int busidx;";
  z[lc++]="";
  z[lc++]="  if (asys_exit_status == ASYS_EXIT)";
  z[lc++]="    return ASYS_EXIT;";
  z[lc++]="";
  z[lc++]="  while (obusidx < *osize)";
  z[lc++]="    if (acycleidx < ACYCLE)";
  z[lc++]="      {";
  z[lc++]="	for (busidx=0; busidx<ENDBUS;busidx++)";
  z[lc++]="	  bus[busidx]=0.0F;";
  z[lc++]="	main_apass();";
  z[lc++]="	for (busidx=BUS_output_bus; busidx<ENDBUS_output_bus;busidx++)";
  z[lc++]="	  {";
  z[lc++]="	    bus[busidx] = (bus[busidx] >  1.0F) ?  1.0F : bus[busidx];";
  z[lc++]="";
  z[lc++]="#if (ASYS_OTYPENAME == ASYS_SHORT)";
  z[lc++]="	    bus[busidx] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];";
  z[lc++]="	    obuf[obusidx++] = (short) (32767.0F * bus[busidx]);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (ASYS_OTYPENAME == ASYS_FLOAT)";
  z[lc++]="	    obuf[obusidx++] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="	  }";
  z[lc++]="	acycleidx++;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	acycleidx = 0;";
  z[lc++]="	if (pass == APASS)";
  z[lc++]="	  {      ";
  z[lc++]="	    cpuload = ksync();";
  z[lc++]="	    kcycleidx++;";
  z[lc++]="	  }";
  z[lc++]="	if (kcycleidx > endkcycle)";
  z[lc++]="	  {";
  z[lc++]="	    *osize = obusidx;";
  z[lc++]="	    return (asys_exit_status = ASYS_EXIT);";
  z[lc++]="	  }";
  z[lc++]="	pass = IPASS;";
  z[lc++]="	scorebeats = scoremult*(kcycleidx - kbase) + scorebase;";
  z[lc++]="	absolutetime = (kcycleidx - 1)*KTIME;";
  z[lc++]="	main_ipass();";
  z[lc++]="	pass = KPASS;";
  z[lc++]="	main_control();";
  z[lc++]="	if (main_kpass())";
  z[lc++]="	  {";
  z[lc++]="	    *osize = obusidx;";
  z[lc++]="	    return (asys_exit_status = ASYS_EXIT);";
  z[lc++]="	  }";
  z[lc++]="	pass = APASS;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif  /* ASYS_ACTIVE_O */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO)";
  z[lc++]="";
  z[lc++]="int asys_iorun(ASYS_ITYPE ibuf[], long * isize,ASYS_OTYPE obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  int ibusidx = 0;";
  z[lc++]="  int obusidx = 0;";
  z[lc++]="  int busidx;";
  z[lc++]="";
  z[lc++]="  if (asys_exit_status == ASYS_EXIT)";
  z[lc++]="    return ASYS_EXIT;";
  z[lc++]="";
  z[lc++]="  while ((obusidx < *osize) && (ibusidx < *isize))";
  z[lc++]="    if (acycleidx < ACYCLE)";
  z[lc++]="      {";
  z[lc++]="	for (busidx=0; busidx<ENDBUS;busidx++)";
  z[lc++]="	  bus[busidx] = 0.0F;";
  z[lc++]="";
  z[lc++]="#if (ASYS_ITYPENAME == ASYS_SHORT)";
  z[lc++]="	for(busidx=BUS_input_bus;busidx<ENDBUS_input_bus;busidx++)";
  z[lc++]="	  bus[busidx] = 3.051851e-5F*ibuf[ibusidx++];";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (ASYS_ITYPENAME == ASYS_FLOAT)";
  z[lc++]="	for(busidx=BUS_input_bus;busidx<ENDBUS_input_bus;busidx++)";
  z[lc++]="	  bus[busidx] = ibuf[ibusidx++];";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="	main_apass();";
  z[lc++]="	for (busidx=BUS_output_bus; busidx<ENDBUS_output_bus;busidx++)";
  z[lc++]="	  {";
  z[lc++]="	    bus[busidx] = (bus[busidx] >  1.0F) ?  1.0F : bus[busidx];";
  z[lc++]="";
  z[lc++]="#if (ASYS_OTYPENAME == ASYS_SHORT)";
  z[lc++]="	    bus[busidx] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];";
  z[lc++]="	    obuf[obusidx++] = (short) (32767.0F * bus[busidx]);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (ASYS_OTYPENAME == ASYS_FLOAT)";
  z[lc++]="	    obuf[obusidx++] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];";
  z[lc++]="#endif";
  z[lc++]="	  }";
  z[lc++]="	acycleidx++;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	acycleidx = 0;";
  z[lc++]="	if (pass == APASS)";
  z[lc++]="	  {      ";
  z[lc++]="	    cpuload = ksync();";
  z[lc++]="	    kcycleidx++;";
  z[lc++]="	  }";
  z[lc++]="	if (kcycleidx > endkcycle)";
  z[lc++]="	  {";
  z[lc++]="	    *osize = obusidx;";
  z[lc++]="	    *isize = ibusidx;";
  z[lc++]="	    return (asys_exit_status = ASYS_EXIT);";
  z[lc++]="	  }";
  z[lc++]="	pass = IPASS;";
  z[lc++]="	scorebeats = scoremult*(kcycleidx - kbase) + scorebase;";
  z[lc++]="	absolutetime = (kcycleidx - 1)*KTIME;";
  z[lc++]="	main_ipass();";
  z[lc++]="	pass = KPASS;";
  z[lc++]="	main_control();";
  z[lc++]="	if (main_kpass())";
  z[lc++]="	  {";
  z[lc++]="	    *osize = obusidx;";
  z[lc++]="	    *isize = ibusidx;";
  z[lc++]="	    return (asys_exit_status = ASYS_EXIT);";
  z[lc++]="	  }";
  z[lc++]="	pass = APASS;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  if (obusidx < *osize)";
  z[lc++]="    *osize = obusidx;";
  z[lc++]="  if (ibusidx < *isize)";
  z[lc++]="    *isize = ibusidx;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_ACTIVE_IO */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int main(int argc, char *argv[])";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  system_init(argc, argv);";
  z[lc++]="  effects_init();";
  z[lc++]="  main_initpass();";
  z[lc++]="";
  z[lc++]="  kcycleidx = kbase;";
  z[lc++]="  acycleidx = ACYCLE;";
  z[lc++]="  pass = IPASS;";
  z[lc++]="";
  z[lc++]="  asys_main();";
  z[lc++]="  shut_down();";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makerobust(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Robust file I/O, termination function";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/* handles termination in case of error */";
  z[lc++]="";
  z[lc++]="void epr(int linenum, char * filename, char * token, char * message)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"\\nRuntime Error.\\n\");";
  z[lc++]="  if (filename != NULL)";
  z[lc++]="    fprintf(stderr, \"Location: File %s near line %i.\\n\",filename, linenum);";
  z[lc++]="  if (token != NULL)";
  z[lc++]="    fprintf(stderr, \"While executing: %s.\\n\",token);";
  z[lc++]="  if (message != NULL)";
  z[lc++]="    fprintf(stderr, \"Potential problem: %s.\\n\",message);";
  z[lc++]="  fprintf(stderr, \"Exiting program.\\n\\n\");";
  z[lc++]="  exit(-1);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* robust replacement for fread() */";
  z[lc++]="";
  z[lc++]="size_t rread(void * ptr, size_t size, size_t nmemb, FILE * stream)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long recv;";
  z[lc++]="  long len;";
  z[lc++]="  long retry;";
  z[lc++]="  char * c;";
  z[lc++]="";
  z[lc++]="  /* fast path */";
  z[lc++]="";
  z[lc++]="  if ((recv = fread(ptr, size, nmemb, stream)) == nmemb)";
  z[lc++]="    return nmemb;";
  z[lc++]="";
  z[lc++]="  /* error recovery */";
  z[lc++]="     ";
  z[lc++]="  c = (char *) ptr;";
  z[lc++]="  len = retry = 0;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      if (++retry > IOERROR_RETRY)";
  z[lc++]="	{";
  z[lc++]="	  len = recv = 0;";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (feof(stream))";
  z[lc++]="	{";
  z[lc++]="	  clearerr(stream);";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /* ANSI, not POSIX, so can't look for EINTR/EAGAIN  */";
  z[lc++]="      /* Assume it was one of these and retry.            */";
  z[lc++]="";
  z[lc++]="      clearerr(stream);";
  z[lc++]="      len += recv;";
  z[lc++]="      nmemb -= recv;";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="  while ((recv = fread(&(c[len]), size, nmemb, stream)) != nmemb);";
  z[lc++]="";
  z[lc++]="  return (len += recv);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* robust replacement for fwrite() */";
  z[lc++]="";
  z[lc++]="size_t rwrite(void * ptr, size_t size, size_t nmemb, FILE * stream)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long recv;";
  z[lc++]="  long len;";
  z[lc++]="  long retry;";
  z[lc++]="  char * c;";
  z[lc++]="";
  z[lc++]="  /* fast path */";
  z[lc++]="";
  z[lc++]="  if ((recv = fwrite(ptr, size, nmemb, stream)) == nmemb)";
  z[lc++]="    return nmemb;";
  z[lc++]="";
  z[lc++]="  /* error recovery */";
  z[lc++]="     ";
  z[lc++]="  c = (char *) ptr;";
  z[lc++]="  len = retry = 0;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      if (++retry > IOERROR_RETRY)";
  z[lc++]="	{";
  z[lc++]="	  len = recv = 0;";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /* ANSI, not POSIX, so can't look for EINTR/EAGAIN  */";
  z[lc++]="      /* Assume it was one of these and retry.            */";
  z[lc++]="";
  z[lc++]="      len += recv;";
  z[lc++]="      nmemb -= recv;";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="  while ((recv = fwrite(&(c[len]), size, nmemb, stream)) != nmemb);";
  z[lc++]="";
  z[lc++]="  return (len += recv);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  printlib(lc);
}


void makepreamble(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Included file in sfront runtime";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <stdlib.h>";
  z[lc++]="#include <math.h>";
  z[lc++]="#include <float.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="#include <errno.h>";
  z[lc++]="#include <time.h>";
  z[lc++]="#include <signal.h>";
  z[lc++]="";
  z[lc++]="/********************************/";
  z[lc++]="/* readabiliy-improving defines */";
  z[lc++]="/********************************/";
  z[lc++]="";
  z[lc++]="#define NV(x)   nstate->v[x].f";
  z[lc++]="#define NVI(x)  nstate->v[x].i";
  z[lc++]="#define NVUI(x) nstate->v[x].ui";
  z[lc++]="#define NVU(x)  nstate->v[x]";
  z[lc++]="#define NT(x)   nstate->t[x]";
  z[lc++]="#define NS(x)   nstate->x";
  z[lc++]="#define NSP     nstate";
  z[lc++]="#define NP(x)   nstate->v[x].f";
  z[lc++]="#define NPI(x)  nstate->v[x].i";
  z[lc++]="#define NPUI(x) nstate->v[x].ui";
  z[lc++]="#define NG(x)   global[x].f";
  z[lc++]="#define NGI(x)  global[x].i";
  z[lc++]="#define NGUI(x) global[x].ui";
  z[lc++]="#define NGU(x)  global[x]";
  z[lc++]="";
  z[lc++]="#define TB(x)   bus[x]";
  z[lc++]="#define STB(x)  sbus[x]";
  z[lc++]="#define ROUND(x) ( ((x) > 0.0F) ? ((int) ((x) + 0.5F)) :  ((int) ((x) - 0.5F)))";
  z[lc++]="#define POS(x)   (((x) > 0.0F) ? x : 0.0F)";
  z[lc++]="#define RMULT ((float)(1.0F/(RAND_MAX + 1.0F)))";
  z[lc++]="";
  z[lc++]="#define NOTUSEDYET 0";
  z[lc++]="#define TOBEPLAYED 1";
  z[lc++]="#define PAUSED     2";
  z[lc++]="#define PLAYING    3";
  z[lc++]="#define ALLDONE    4";
  z[lc++]="";
  z[lc++]="#define NOTLAUNCHED 0";
  z[lc++]="#define LAUNCHED 1";
  z[lc++]="";
  z[lc++]="#define ASYS_DONE        0";
  z[lc++]="#define ASYS_EXIT        1";
  z[lc++]="#define ASYS_ERROR       2";
  z[lc++]="";
  z[lc++]="#define IPASS 1";
  z[lc++]="#define KPASS 2";
  z[lc++]="#define APASS 3";
  z[lc++]="";
  z[lc++]="#define IOERROR_RETRY 256 ";
  z[lc++]="";
  z[lc++]="/************************************/";
  z[lc++]="/* externs for system functions     */";
  z[lc++]="/************************************/";
  z[lc++]="";
  z[lc++]="extern void epr(int, char *, char *, char *);";
  z[lc++]="extern size_t rread(void * ptr, size_t len, size_t nmemb, FILE * stream);";
  z[lc++]="extern size_t rwrite(void * ptr, size_t len, size_t nmemb, FILE * stream);";
  z[lc++]="";
  z[lc++]="/************************************/";
  z[lc++]="/*  union for a data stack element  */";
  z[lc++]="/************************************/";
  z[lc++]="";
  z[lc++]="typedef union {";
  z[lc++]="";
  z[lc++]="float f;";
  z[lc++]="long  i;";
  z[lc++]="unsigned long ui;";
  z[lc++]="";
  z[lc++]="} dstack;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/************************************/";
  z[lc++]="/* ntables: table entries for notes */";
  z[lc++]="/************************************/";
  z[lc++]="";
  z[lc++]="typedef struct tableinfo {";
  z[lc++]="";
  z[lc++]="int    len;                /* length of table */";
  z[lc++]="float  lenf;               /* length of table, as a float */";
  z[lc++]="";
  z[lc++]="int    start;              /* loop start position */";
  z[lc++]="int    end;                /* loop end position */";
  z[lc++]="float  sr;                 /* table sampling rate  */";
  z[lc++]="float  base;               /* table base frequency */";
  z[lc++]="";
  z[lc++]="                           /* precomputed constants       */";
  z[lc++]="int tend;                  /* len -1 if end==0            */";
  z[lc++]="float oconst;              /* len*ATIME                   */";
  z[lc++]="";
  z[lc++]="unsigned long dint;        /* doscil: 64-bit phase incr   */";
  z[lc++]="unsigned long dfrac;";
  z[lc++]="                           /* doscil: sinc interpolation        */";
  z[lc++]="unsigned long sfui;        /* scale_factor as unsigned long     */";
  z[lc++]="float sffl;                /* scale_factor as a float           */";
  z[lc++]="unsigned long dsincr;      /* sinc pointer increment (d=doscil) */";
  z[lc++]="";
  z[lc++]="float  *t;                 /* pointer to table entries    */";
  z[lc++]="float stamp;               /* timestamp on table contents */";
  z[lc++]="char llmem;                /* 1 if *t was malloced        */";
  z[lc++]="} tableinfo; ";
  z[lc++]="";
  z[lc++]="/********************/";
  z[lc++]="/*  control lines   */";
  z[lc++]="/********************/";
  z[lc++]="";
  z[lc++]="typedef struct scontrol_lines {";
  z[lc++]="";
  z[lc++]="float t;                  /* trigger time */";
  z[lc++]="int label;                /* index into label array */";
  z[lc++]="int siptr;                /* score instr line to control */";
  z[lc++]="struct instr_line *iline; /* pointer to score line */";
  z[lc++]="int imptr;                /* position of variable in v[] */";
  z[lc++]="float imval;              /* value to import into v[] */";
  z[lc++]="";
  z[lc++]="} scontrol_lines;";
  z[lc++]="";
  z[lc++]="/********************/";
  z[lc++]="/*   tempo lines    */";
  z[lc++]="/********************/";
  z[lc++]="";
  z[lc++]="typedef struct stempo_lines {";
  z[lc++]="";
  z[lc++]="  float t;          /* trigger time */";
  z[lc++]="  float newtempo;   /* new tempo */ ";
  z[lc++]="";
  z[lc++]="} stempo_lines;";
  z[lc++]="";
  z[lc++]="/********************/";
  z[lc++]="/*   table lines    */";
  z[lc++]="/********************/";
  z[lc++]="";
  z[lc++]="typedef struct stable_lines {";
  z[lc++]="";
  z[lc++]="  float t;          /* trigger time */";
  z[lc++]="  int gindex;       /* global table to target */";
  z[lc++]="  int size;         /* size of data */";
  z[lc++]="  void (*tmake) (); /* function   */";
  z[lc++]="  void * data;      /* data block */";
  z[lc++]="";
  z[lc++]="} stable_lines;";
  z[lc++]="";
  z[lc++]="/********************/";
  z[lc++]="/* system variables */";
  z[lc++]="/********************/";
  z[lc++]="";
  z[lc++]="/* audio and control rates */";
  z[lc++]="";
  z[lc++]="float globaltune = 440.0F;";
  z[lc++]="float invglobaltune = 2.272727e-03F;";
  z[lc++]="float scorebeats = 0.0F;              /* current score beat */";
  z[lc++]="float absolutetime = 0.0F;            /* current absolute time */";
  z[lc++]="int kbase = 1;                        /* kcycle of last tempo change */";
  z[lc++]="float scorebase = 0.0F;               /* scorebeat of last tempo change */";
  z[lc++]="";
  z[lc++]="/* counters & bounds acycles and kcycles */";
  z[lc++]="";
  z[lc++]="int endkcycle;";
  z[lc++]="int kcycleidx = 1;";
  z[lc++]="int acycleidx = 0;";
  z[lc++]="int pass = IPASS;";
  z[lc++]="int beginflag;";
  z[lc++]="sig_atomic_t graceful_exit;";
  z[lc++]="";
  z[lc++]="struct instr_line * sysidx;";
  z[lc++]="";
  z[lc++]="int busidx;        /* counter for buses                   */";
  z[lc++]="int nextstate = 0; /* counter for active instrument state */";
  z[lc++]="int oldstate;      /* detects loops in nextstate updates  */";
  z[lc++]="int tstate;        /* flag for turnoff state machine      */";
  z[lc++]="float cpuload;     /* current cpu-time value              */";
  z[lc++]="";
  printlib(lc);
}


void makerunspt(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Runtime for speedt core opcode";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/* for speedt core opcode */";
  z[lc++]="";
  z[lc++]="void picola(struct tableinfo * in, struct tableinfo * out,";
  z[lc++]="	    float factor)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i,j, p0, lw, l, p1, over, pmin, pmax, cyc, cidx;";
  z[lc++]="  float minerr, newerr, awin, bwin, scale;";
  z[lc++]="  float window[2048]; ";
  z[lc++]="";
  z[lc++]="  if (factor == 1.0F) ";
  z[lc++]="    {";
  z[lc++]="      i = 0;";
  z[lc++]="      while (i <= in->len)";
  z[lc++]="	{";
  z[lc++]="	  out->t[i] = in->t[i];";
  z[lc++]="	  i++;";
  z[lc++]="	}";
  z[lc++]="      out->len = in->len;";
  z[lc++]="      out->lenf = in->lenf;";
  z[lc++]="      out->start = in->start;";
  z[lc++]="      out->end = in->end;";
  z[lc++]="      out->sr = in->sr;";
  z[lc++]="      out->dint = in->dint;";
  z[lc++]="      out->dfrac = in->dfrac;";
  z[lc++]="      out->sffl = in->sffl;";
  z[lc++]="      out->sfui = in->sfui;";
  z[lc++]="      out->dsincr = in->dsincr;";
  z[lc++]="      out->base = in->base;";
  z[lc++]="      out->stamp = in->stamp;";
  z[lc++]="      out->oconst = in->oconst;";
  z[lc++]="      out->tend = in->tend;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (factor <= 0.0F)";
  z[lc++]="    factor = 0.001F;";
  z[lc++]="  cyc = 1;";
  z[lc++]="  while (factor > 2.0F)";
  z[lc++]="    {";
  z[lc++]="      factor--;";
  z[lc++]="      cyc++;";
  z[lc++]="    }";
  z[lc++]="  factor = 1/factor;";
  z[lc++]="";
  z[lc++]="  over = p1 = p0 = 0;";
  z[lc++]="  pmin = 5.0e-3F*ARATE;";
  z[lc++]="  pmax = 2.0e-2F*ARATE;";
  z[lc++]="  while (!over)";
  z[lc++]="  {";
  z[lc++]="    i = pmin;";
  z[lc++]="    while ((i<= pmax) && (p0 + 2*i < in->len))";
  z[lc++]="      {";
  z[lc++]="	newerr = 0;";
  z[lc++]="	for (j = p0; j < p0 + i; j++)";
  z[lc++]="	  newerr += (in->t[j]-in->t[j+i])*(in->t[j]-in->t[j+i]);";
  z[lc++]="	newerr /= (float) lw;";
  z[lc++]="	if ((i == pmin) || (newerr < minerr))";
  z[lc++]="	  {";
  z[lc++]="	    minerr = newerr;";
  z[lc++]="	    lw = i;";
  z[lc++]="	  }";
  z[lc++]="	i++;";
  z[lc++]="      }";
  z[lc++]="    if (i == pmin)";
  z[lc++]="      {";
  z[lc++]="	over = 1;";
  z[lc++]="	lw = 0;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	newerr = 0;";
  z[lc++]="	for (i = p0; i < p0 + lw; i++)";
  z[lc++]="	  newerr += in->t[i]*in->t[i+lw];";
  z[lc++]="	if (newerr < 0)";
  z[lc++]="	  lw = pmin - 1;";
  z[lc++]="	awin = 1.0F;";
  z[lc++]="	bwin = 0.0F;";
  z[lc++]="	scale = 1.0F/(lw-1.0F);";
  z[lc++]="	for (i = 0; i < lw; i++)";
  z[lc++]="	  {";
  z[lc++]="	    if (factor > 1)";
  z[lc++]="	      window[i] = awin*in->t[p0+i] + ";
  z[lc++]="		bwin*in->t[p0+i+lw];";
  z[lc++]="	    else";
  z[lc++]="	      window[i] = bwin*in->t[p0+i] + ";
  z[lc++]="		awin*in->t[p0+i+lw];";
  z[lc++]="	    awin -= scale;";
  z[lc++]="	    bwin += scale;";
  z[lc++]="	  }";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    if (factor > 1)";
  z[lc++]="      {";
  z[lc++]="	p0 += lw;";
  z[lc++]="	l = ((int)((float)lw/(factor - 1)));";
  z[lc++]="	i = 0;";
  z[lc++]="	while ((l>0) && (i<lw) && !(over))";
  z[lc++]="	  {";
  z[lc++]="	    out->t[p1] = window[i];";
  z[lc++]="	    p0++;";
  z[lc++]="	    p1++;";
  z[lc++]="	    if (p1 == out->len)";
  z[lc++]="	      over = 1;";
  z[lc++]="	    i++;";
  z[lc++]="	    l--;";
  z[lc++]="	  }";
  z[lc++]="	while ((l>0) && !(over))";
  z[lc++]="	  {";
  z[lc++]="	    if (p0 == in->len)";
  z[lc++]="	      out->t[p1] = 0.0F;";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		out->t[p1] = in->t[p0];";
  z[lc++]="		p0++;";
  z[lc++]="	      }";
  z[lc++]="	    p1++;";
  z[lc++]="	    if (p1 == out->len)";
  z[lc++]="	      over = 1;";
  z[lc++]="	    l--;";
  z[lc++]="	  }";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	i = 0;";
  z[lc++]="	while ((i < lw) && !(over))";
  z[lc++]="	  {";
  z[lc++]="	    if (p0 == in->len)";
  z[lc++]="	      out->t[p1] = 0.0F;";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		out->t[p1] = in->t[p0];";
  z[lc++]="		p0++;";
  z[lc++]="	      }";
  z[lc++]="	    i++;";
  z[lc++]="	    p1++;";
  z[lc++]="	    if (p1 == out->len)";
  z[lc++]="	      over = 1;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	l = (int)(((float)lw*factor)/(1 - factor));";
  z[lc++]="	cidx = cyc;";
  z[lc++]="	while ((cidx > 0) && (!over))";
  z[lc++]="	  {";
  z[lc++]="	    i = 0;";
  z[lc++]="	    while ((l>0) && (i<lw) && (!over))";
  z[lc++]="	      {";
  z[lc++]="		out->t[p1] = window[i];";
  z[lc++]="		p1++;";
  z[lc++]="		if (p1 == out->len)";
  z[lc++]="		  over = 1;";
  z[lc++]="		i++;";
  z[lc++]="		if (cidx == 1)";
  z[lc++]="		  l--;";
  z[lc++]="	      }";
  z[lc++]="	    cidx--;";
  z[lc++]="	  }";
  z[lc++]="	while ((l>0) && (!over))";
  z[lc++]="	  {	    ";
  z[lc++]="	    if (p0 == in->len)";
  z[lc++]="	      out->t[p1] = 0.0F;";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		out->t[p1] = in->t[p0];";
  z[lc++]="		p0++;";
  z[lc++]="	      }";
  z[lc++]="	    p1++;";
  z[lc++]="	    if (p1 == out->len)";
  z[lc++]="	      over = 1;";
  z[lc++]="	    l--;";
  z[lc++]="	  }";
  z[lc++]="      }";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (p1 < out->len)";
  z[lc++]="    {";
  z[lc++]="      out->len = p1;";
  z[lc++]="      out->lenf = (float)p1;";
  z[lc++]="      out->oconst = ((float)p1)*ATIME;";
  z[lc++]="    }";
  z[lc++]="  out->t[out->len] = out->t[0]; ";
  z[lc++]="  out->base = in->base;";
  z[lc++]="  out->stamp = in->stamp;";
  z[lc++]="  out->sr = in->sr;";
  z[lc++]="  out->start = in->start/factor;";
  z[lc++]="  if (in->end == 0)";
  z[lc++]="    {";
  z[lc++]="      out->end = 0;";
  z[lc++]="      out->tend = out->len - 1;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      out->tend = out->end = in->end/factor;";
  z[lc++]="    }";
  z[lc++]="  out->dint = in->dint;";
  z[lc++]="  out->dfrac = in->dfrac;";
  z[lc++]="  out->sffl = in->sffl;";
  z[lc++]="  out->sfui = in->sfui;";
  z[lc++]="  out->dsincr = in->dsincr;";
  z[lc++]="  return;";
  z[lc++]="}";
  printlib(lc);
}


void maketsync(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Time synchronization routines for real-time input.";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*                                                                */";
  z[lc++]="/* This file defines two functions ksyncinit(), called before     */";
  z[lc++]="/* the first ipass begins, and ksync(), called at the start      */";
  z[lc++]="/* of every ipass. These routines act to ensure that each         */";
  z[lc++]="/* sequence of IPASS/KPASS/APASS takes at least KUTIME. ksync     */";
  z[lc++]="/* returns an estimate of cpuload, range [0.0:1.0], which codes   */";
  z[lc++]="/* what fraction of the kcycle was used for computing audio.      */";
  z[lc++]="/*                                                                */";
  z[lc++]="/*                                                                */";
  z[lc++]="/* Rules for writing your own timesync sync.c file:               */";
  z[lc++]="/*                                                                */";
  z[lc++]="/* (1) all globals and functions must begin with sync_, all defs  */";
  z[lc++]="/*     must begin with SYNC_.                                     */";
  z[lc++]="/* (2) Define both ksync() and ksyncinit().                       */";
  z[lc++]="/*                                                                */";
  z[lc++]="/* Note that:                                                     */";
  z[lc++]="/*  KUTIME: a long,  defines k-cycle length in microseconds       */";
  z[lc++]="/*  KMTIME: a float, defines k-cycle length in milliseconds       */";
  z[lc++]="/*  KTIME:  a float, defines k-cycle length in seconds            */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#include <sys/time.h>";
  z[lc++]="";
  z[lc++]="#define SYNC_ONESECOND 1000000L";
  z[lc++]="#define SYNC_SELDELAY 1000L";
  z[lc++]="#define SYNC_NORM (1.0F/KUTIME)";
  z[lc++]="";
  z[lc++]="struct timeval sync_last, sync_this, sync_delay;";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret = 1.0F;";
  z[lc++]="";
  z[lc++]="  if ((sync_last.tv_usec += KUTIME) < SYNC_ONESECOND) /* non-rollover case */";
  z[lc++]="    {";
  z[lc++]="      gettimeofday(&sync_this, NULL);";
  z[lc++]="      if (((sync_delay.tv_usec = sync_last.tv_usec - sync_this.tv_usec) >= 0)";
  z[lc++]="	  && (sync_last.tv_sec == sync_this.tv_sec))";
  z[lc++]="	{";
  z[lc++]="	  ret -= SYNC_NORM*sync_delay.tv_usec;";
  z[lc++]="	  ret = (ret > 0.0F) ? ret : 0.0F;";
  z[lc++]="";
  z[lc++]="	  if ((sync_delay.tv_usec -= SYNC_SELDELAY) > 0)";
  z[lc++]="	    select(0, NULL, NULL, NULL, &sync_delay);";
  z[lc++]="";
  z[lc++]="	  do ";
  z[lc++]="	    gettimeofday(&sync_this, NULL);";
  z[lc++]="	  while (((sync_this.tv_sec == sync_last.tv_sec))";
  z[lc++]="		 &&(sync_last.tv_usec > sync_this.tv_usec));";
  z[lc++]="	}";
  z[lc++]="      return ret;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  sync_last.tv_sec++;";
  z[lc++]="  sync_last.tv_usec %= SYNC_ONESECOND;";
  z[lc++]="";
  z[lc++]="  gettimeofday(&sync_this, NULL);";
  z[lc++]="  if ((sync_last.tv_sec > sync_this.tv_sec) ||";
  z[lc++]="      ((sync_last.tv_sec == sync_this.tv_sec) &&";
  z[lc++]="       ((sync_delay.tv_usec = sync_last.tv_usec - sync_this.tv_usec) >= 0)))";
  z[lc++]="    {";
  z[lc++]="      if (sync_last.tv_sec > sync_this.tv_sec)";
  z[lc++]="	sync_delay.tv_usec = SYNC_ONESECOND  - sync_this.tv_usec";
  z[lc++]="	  + sync_last.tv_usec;";
  z[lc++]="";
  z[lc++]="      ret -= SYNC_NORM*sync_delay.tv_usec;";
  z[lc++]="      ret = (ret > 0.0F) ? ret : 0.0F;";
  z[lc++]="";
  z[lc++]="      if ((sync_delay.tv_usec -= SYNC_SELDELAY) > 0)";
  z[lc++]="	select(0, NULL, NULL, NULL, &sync_delay);";
  z[lc++]="";
  z[lc++]="      do";
  z[lc++]="	gettimeofday(&sync_this, NULL);";
  z[lc++]="      while ((sync_last.tv_sec > sync_this.tv_sec) || ";
  z[lc++]="	     ((sync_last.tv_sec == sync_this.tv_sec) &&";
  z[lc++]="	      (sync_last.tv_usec > sync_this.tv_usec)));";
  z[lc++]="    }";
  z[lc++]="  return ret;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  sync_delay.tv_sec = 0;";
  z[lc++]="  gettimeofday(&sync_last, NULL);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makepsync(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Time synchronization routines for file playback.";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*                                                                */";
  z[lc++]="/* Playback synchronization routines act to estimate the cpuload  */";
  z[lc++]="/* for each k-cycle. Two functions are must be defined:           */";
  z[lc++]="/*                                                                */";
  z[lc++]="/* void ksyncinit() { }                                           */";
  z[lc++]="/*                                                                */";
  z[lc++]="/*   called before first ipass begins, lets sync routines         */";
  z[lc++]="/*   initialize state.                                            */";
  z[lc++]="/*                                                                */";
  z[lc++]="/* float ksync()  { }                                             */";
  z[lc++]="/*                                                                */";
  z[lc++]="/*   returns the current estimate of cpuload, the SA standard     */";
  z[lc++]="/*   name.                                                        */";
  z[lc++]="/*                                                                */";
  z[lc++]="/* Rules for writing your own playback sync.c file:               */";
  z[lc++]="/*                                                                */";
  z[lc++]="/* (1) all globals and functions must begin with sync_, all defs  */";
  z[lc++]="/*     must begin with SYNC_.                                     */";
  z[lc++]="/* (2) Define both ksync() and ksyncinit().                       */";
  z[lc++]="/*                                                                */";
  z[lc++]="/* Note that:                                                     */";
  z[lc++]="/*  KUTIME: a long,  defines k-cycle length in microseconds       */";
  z[lc++]="/*  KMTIME: a float, defines k-cycle length in milliseconds       */";
  z[lc++]="/*  KTIME:  a float, defines k-cycle length in seconds            */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#include <sys/time.h>";
  z[lc++]="";
  z[lc++]="#define SYNC_ONESECOND 1000000L";
  z[lc++]="#define SYNC_SELDELAY 1000L";
  z[lc++]="#define SYNC_NORM (1.0F/KUTIME)";
  z[lc++]="struct timeval sync_last, sync_this;";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret = 1.0F;";
  z[lc++]="";
  z[lc++]="  gettimeofday(&sync_this, NULL);";
  z[lc++]="";
  z[lc++]="  if ((sync_last.tv_usec += KUTIME) < SYNC_ONESECOND) /* non-rollover case */";
  z[lc++]="    {";
  z[lc++]="      if ((sync_last.tv_usec >= sync_this.tv_usec) &&";
  z[lc++]="	  (sync_last.tv_sec == sync_this.tv_sec))";
  z[lc++]="	ret -= SYNC_NORM*(sync_last.tv_usec - sync_this.tv_usec);";
  z[lc++]="";
  z[lc++]="      sync_last = sync_this;";
  z[lc++]="      ret = (ret > 0.0F) ? ret : 0.0F;";
  z[lc++]="      return ret;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  sync_last.tv_sec++;";
  z[lc++]="  sync_last.tv_usec %= SYNC_ONESECOND;";
  z[lc++]="";
  z[lc++]="  if (sync_last.tv_sec >= sync_this.tv_sec)";
  z[lc++]="    {";
  z[lc++]="      if (sync_last.tv_sec > sync_this.tv_sec)";
  z[lc++]="	{";
  z[lc++]="	  ret -= SYNC_NORM*(sync_last.tv_usec + ";
  z[lc++]="			    SYNC_ONESECOND - sync_this.tv_usec);";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if (sync_last.tv_usec > sync_this.tv_usec)";
  z[lc++]="	    ret -= SYNC_NORM*(sync_last.tv_usec - sync_this.tv_usec);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  sync_last = sync_this;";
  z[lc++]="  ret = (ret > 0.0F) ? ret : 0.0F;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  gettimeofday(&sync_last, NULL);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void maketgen(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Code for table generators";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int tgen_init(tableinfo * ti, int pnum, float * p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if (ti->llmem)";
  z[lc++]="    free(ti->t); ";
  z[lc++]="  ti->start = 0;";
  z[lc++]="  ti->end = 0;";
  z[lc++]="  ti->sr = 0;";
  z[lc++]="  ti->dint = 0;";
  z[lc++]="  ti->dfrac = 0;";
  z[lc++]="  ti->base = 0;";
  z[lc++]="  ti->stamp = scorebeats;";
  z[lc++]="  if ((pnum < 1) || ((i = ti->len = ROUND(p[0])) < 1))";
  z[lc++]="    epr(0,\"control driver\",\"tgen_init\",\"Table length < 1\");";
  z[lc++]="  ti->lenf = (float) i;";
  z[lc++]="  ti->oconst = ((float) i)*ATIME;";
  z[lc++]="  ti->tend = i - 1;";
  z[lc++]="  ti->t = (float *) calloc(i+1, sizeof(float));";
  z[lc++]="  ti->llmem = 1;";
  z[lc++]="";
  z[lc++]="#if INTERP_TYPE == INTERP_SINC  ";
  z[lc++]="  ti->sffl = 1.0F;";
  z[lc++]="  ti->sfui = 0x00010000;";
  z[lc++]="  ti->dsincr = SINC_PILEN;";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return i;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="void tgen_buzz(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int size, nharm, loharm, i, j;";
  z[lc++]="  float scale, base, index, acc, f;";
  z[lc++]="";
  z[lc++]="  if (pnum < 4)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_buzzwave\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  size = ROUND(p[0]);";
  z[lc++]="  nharm = ROUND(p[1]);";
  z[lc++]="  loharm = ROUND(p[2]);";
  z[lc++]="";
  z[lc++]="  if (loharm < 0)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_buzzwave\",\"Loharm must be >= 0\");";
  z[lc++]="";
  z[lc++]="  if ((size < 1) && (nharm < 1))";
  z[lc++]="    epr(0,\"control driver\",\"tgen_buzzwave\",\"Size or nharm must be given\");";
  z[lc++]="  if (nharm < 1)";
  z[lc++]="    nharm = (int) floor(size/2.0 - loharm);";
  z[lc++]="  else";
  z[lc++]="    if (size < 1)";
  z[lc++]="      size = 2*(loharm + nharm);";
  z[lc++]="";
  z[lc++]="  if (((f = fabs(p[3])) < 1.0F) && (f != 0.0F))";
  z[lc++]="    {";
  z[lc++]="      j = -(int)(17.0F/log(f)) + loharm + 1;";
  z[lc++]="      nharm = (nharm > j) ? j : nharm;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  p[0] = (float) size;";
  z[lc++]="  p[1] = (float) nharm;";
  z[lc++]="  p[2] = (float) loharm;";
  z[lc++]="";
  z[lc++]="  tgen_init(ti, pnum, p);";
  z[lc++]="";
  z[lc++]="  if ((p[3] == 1.0F)||(p[3] == -1.0F))";
  z[lc++]="    scale = 1.0F;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if (p[3] == 0.0F)";
  z[lc++]="	scale = 1.0F;";
  z[lc++]="      else";
  z[lc++]="	scale = (1.0F-(float)fabs(p[3]))/";
  z[lc++]="	  (1-(float)fabs((float)pow(p[3],p[1]+1.0F)));";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="   base = 6.283185F/p[0];";
  z[lc++]="   for (i = 0; i < size; i++)";
  z[lc++]="     {";
  z[lc++]="       index = i*base;";
  z[lc++]="       acc = 1.0F;";
  z[lc++]="       j = loharm + 1;";
  z[lc++]="       while (j <= (loharm + nharm))";
  z[lc++]="	 {";
  z[lc++]="	   ti->t[i] += acc*(float)cos(index*j);";
  z[lc++]="	   acc *= p[3];";
  z[lc++]="	   j++;";
  z[lc++]="	 }";
  z[lc++]="       ti->t[i] *= scale;";
  z[lc++]="     }";
  z[lc++]="   ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="void tgen_concat_global(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, k, len, tidx;";
  z[lc++]="";
  z[lc++]="  if (pnum < 2)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_concat\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  len = 0;";
  z[lc++]="  for (j = 1; j < pnum; j++)";
  z[lc++]="    {";
  z[lc++]="      i = ROUND(p[j]);";
  z[lc++]="      if ( (!gtables[i].t) || (gtables[i].len < 1))";
  z[lc++]="	epr(0,\"control driver\",\"tgen_concat\",\"Uninitialized/zero-lenth table\");";
  z[lc++]="      len += gtables[i].len;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (p[0] <= 0.0F)";
  z[lc++]="    {";
  z[lc++]="      p[0] = len;";
  z[lc++]="      tgen_init(ti, pnum, p);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      j = tgen_init(ti, pnum, p);";
  z[lc++]="      len = (j < len) ? j : len; ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  tidx = ROUND(p[k = 1]);";
  z[lc++]="  j = 0;";
  z[lc++]="  while ((i < len) && (k < pnum))";
  z[lc++]="    {";
  z[lc++]="      if (j < gtables[tidx].len)";
  z[lc++]="	ti->t[i++] = gtables[tidx].t[j++];";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  j = 0;";
  z[lc++]="	  if (++k < pnum)";
  z[lc++]="	    tidx = ROUND(p[k]);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="void tgen_cubicseg(tableinfo * ti, int pnum, float * p) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, len, endpoint;";
  z[lc++]="  float Q, R, S, T, a, b, c, d, xf;";
  z[lc++]="";
  z[lc++]="  if (pnum < 7)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_cubicseg\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  if ((pnum - 3) % 4)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_cubicseg\",";
  z[lc++]="	\"Parmeter list must end with (infl, y)\");";
  z[lc++]="    ";
  z[lc++]="  if ((len = ROUND(p[1])) != 0)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_cubicseg\",\"x0 != 0\");";
  z[lc++]="  i = 3;";
  z[lc++]="";
  z[lc++]="  while (i < pnum)";
  z[lc++]="    {";
  z[lc++]="      j = ROUND(p[i]);";
  z[lc++]="      if (j < len)";
  z[lc++]="	epr(0,\"control driver\",\"tgen_cubicseg\",";
  z[lc++]="	    \"Consecutive x and infl values decreasing.\"); ";
  z[lc++]="      p[i] = (float)(len = j);";
  z[lc++]="      i += 2;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (p[0] <= 0.0F)";
  z[lc++]="    {";
  z[lc++]="      p[0] = len;";
  z[lc++]="      tgen_init(ti, pnum, p);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      j = tgen_init(ti, pnum, p);";
  z[lc++]="      len = (j < len) ? j : len; ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  xf = 0.0F;";
  z[lc++]="";
  z[lc++]="  for (j = 1; j < pnum; j += 4)";
  z[lc++]="    {";
  z[lc++]="      endpoint = p[j+4];";
  z[lc++]="";
  z[lc++]="      Q = p[j]*p[j]*p[j] - p[j+2]*p[j+2]*p[j+2] ";
  z[lc++]="	- 3.0F*p[j+2]*p[j+2]*(p[j]-p[j+2]);";
  z[lc++]="      if (Q == 0.0F)";
  z[lc++]="	epr(0,\"control driver\",\"tgen_cubicseg\",";
  z[lc++]="	    \"No cubic solution for these parameters\");";
  z[lc++]="      R = p[j]*p[j] - p[j+2]*p[j+2] - 2.0F*p[j+2]*(p[j]-p[j+2]);";
  z[lc++]="      if (R == 0.0F)";
  z[lc++]="	epr(0,\"control driver\",\"tgen_cubicseg\",";
  z[lc++]="	    \"No cubic solution for these parameters\");";
  z[lc++]="      ";
  z[lc++]="      S = p[j+2]*p[j+2]*p[j+2] - p[j+4]*p[j+4]*p[j+4]";
  z[lc++]="	- 3.0F*p[j+2]*p[j+2]*(p[j+2]-p[j+4]);";
  z[lc++]="";
  z[lc++]="      if (S == 0.0F)";
  z[lc++]="	epr(0,\"control driver\",\"tgen_cubicseg\",";
  z[lc++]="	    \"No cubic solution for these parameters\");";
  z[lc++]="";
  z[lc++]="      T = p[j+2]*p[j+2] - p[j+4]*p[j+4] - 2.0F*p[j+2]*(p[j+2]-p[j+4]);";
  z[lc++]="";
  z[lc++]="      if ((T == 0.0F) || ((Q/R) == (S/T)))";
  z[lc++]="	epr(0,\"control driver\",\"tgen_cubicseg\",";
  z[lc++]="	    \"No cubic solution for these parameters\");";
  z[lc++]="";
  z[lc++]="      a = 1.0F/((Q/R) - (S/T));";
  z[lc++]="      a *= (p[j+1]-p[j+3])/R - (p[j+3]-p[j+5])/T;";
  z[lc++]="      b = 1.0F/((R/Q) - (T/S));";
  z[lc++]="      b *= (p[j+1]-p[j+3])/Q - (p[j+3]-p[j+5])/S;";
  z[lc++]="      c = - 3.0F*a*p[j+2]*p[j+2] - 2.0F*b*p[j+2];";
  z[lc++]="      d = p[j+3] - a*p[j+2]*p[j+2]*p[j+2];";
  z[lc++]="      d += - b*p[j+2]*p[j+2] - c*p[j+2];";
  z[lc++]="    ";
  z[lc++]="      while (i < endpoint)";
  z[lc++]="	{";
  z[lc++]="	  ti->t[i] =  xf*xf*xf*a + xf*xf*b + xf*c + d;";
  z[lc++]="	  xf = (++i);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="void tgen_data(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  int len, i;";
  z[lc++]="  ";
  z[lc++]="  if (pnum < 1)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_data\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  if (p[0] <= 0.0F)";
  z[lc++]="    p[0] = pnum - 1;";
  z[lc++]="";
  z[lc++]="  len = tgen_init(ti, pnum, p);";
  z[lc++]="  len = (pnum - 1 < len) ? pnum - 1 : len;";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  while (i < len)";
  z[lc++]="    {";
  z[lc++]="      ti->t[i] = p[i+1];";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="void tgen_destroy(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  ti->len = ti->start = ti->end = ti->tend = 0;";
  z[lc++]="  ti->lenf = ti->oconst = ti->sr = ti->base = 0.0F;";
  z[lc++]="  ti->dint = ti->dfrac = 0;";
  z[lc++]="  ti->sffl = 0;";
  z[lc++]="  ti->sfui = 0;";
  z[lc++]="  ti->dsincr = 0;";
  z[lc++]="  if (ti->llmem)";
  z[lc++]="    free(ti->t); ";
  z[lc++]="  ti->llmem = 0;";
  z[lc++]="  ti->stamp = scorebeats;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="void tgen_empty(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  tgen_init(ti, pnum, p);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="void tgen_expseg(tableinfo * ti, int pnum, float * p) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, len, dx, nx, sgn;";
  z[lc++]="  float diff;";
  z[lc++]="";
  z[lc++]="  if (pnum < 5)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_expseg\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  if (!(pnum % 2))";
  z[lc++]="    epr(0,\"control driver\",\"tgen_expseg\",\"Last parameter is an xval\");";
  z[lc++]="  ";
  z[lc++]="  if ((len = ROUND(p[1])) != 0)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_expseg\",\"x0 != 0\");";
  z[lc++]="";
  z[lc++]="  if (p[2] == 0.0F)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_expseg\",\"illegal yval\");";
  z[lc++]="  sgn = (p[2] > 0);";
  z[lc++]="";
  z[lc++]="  i = 3;";
  z[lc++]="";
  z[lc++]="  while (i < pnum)";
  z[lc++]="    {";
  z[lc++]="      if ((p[i+1] == 0.0F) || ((p[i-1] > 0) != sgn))";
  z[lc++]="	epr(0,\"control driver\",\"tgen_expseg\",\"illegal yval\");";
  z[lc++]="";
  z[lc++]="      j = ROUND(p[i]);";
  z[lc++]="      if (j < len)";
  z[lc++]="	epr(0,\"control driver\",\"tgen_expseg\",\"Decreasing xval in sequence\");";
  z[lc++]="      len = j;";
  z[lc++]="      i += 2;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (p[0] <= 0.0F)";
  z[lc++]="    {";
  z[lc++]="      p[0] = len;";
  z[lc++]="      tgen_init(ti, pnum, p);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      j = tgen_init(ti, pnum, p);";
  z[lc++]="      len = (j < len) ? j : len; ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  i = j = 1;";
  z[lc++]="  while ((j + 2) < pnum)";
  z[lc++]="    if (!(dx = ((nx = ROUND(p[j+2])) - ROUND(p[j]))))";
  z[lc++]="      j += 2;";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	diff = (float)pow(p[j+3]/p[j+1], 1.0F/dx);";
  z[lc++]="	ti->t[ti->len] = ti->t[0] = p[j+1];";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  while ((i < len) && ((j + 2) < pnum))";
  z[lc++]="    {";
  z[lc++]="      if (nx > i)";
  z[lc++]="	{";
  z[lc++]="	  ti->t[i] = ti->t[i-1]*diff;";
  z[lc++]="	  i++;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  j += 2;";
  z[lc++]="	  while ((j + 2) < pnum)";
  z[lc++]="	    if (!(dx = ((nx =ROUND(p[j+2])) - ROUND(p[j]))))";
  z[lc++]="	      j += 2;";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		diff = (float)pow(p[j+3]/p[j+1], 1.0F/dx);";
  z[lc++]="		ti->t[i++] = p[j+1];";
  z[lc++]="		break;";
  z[lc++]="	      }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="void tgen_harm(tableinfo * ti, int pnum, float * p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="  float base, index;";
  z[lc++]="";
  z[lc++]="  i = tgen_init(ti, pnum, p);";
  z[lc++]="  base = 6.283185F/i;";
  z[lc++]="  i--;";
  z[lc++]="";
  z[lc++]="  while (i >= 0)";
  z[lc++]="    {";
  z[lc++]="      j = 0;";
  z[lc++]="      index = i*base;";
  z[lc++]="      while (++j < pnum)";
  z[lc++]="	ti->t[i] += p[j]*(float)sin(j*index);";
  z[lc++]="      i--;";
  z[lc++]="    }";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="void tgen_harm_phase(tableinfo * ti, int pnum, float * p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="  float base, index, k;";
  z[lc++]="";
  z[lc++]="  i = tgen_init(ti, pnum, p);";
  z[lc++]="  base = 6.283185F/i;";
  z[lc++]="  i--;";
  z[lc++]="";
  z[lc++]="  if (!(pnum % 2))";
  z[lc++]="    epr(0,\"control driver\",\"tgen_harm_phase\",\"Must have (f1, ph1) pairs.\");";
  z[lc++]="";
  z[lc++]="  while (i >= 0)";
  z[lc++]="    {";
  z[lc++]="      j = -1;";
  z[lc++]="      k = 1.0F;";
  z[lc++]="      index = i*base;";
  z[lc++]="      while ((j += 2) < pnum)";
  z[lc++]="	ti->t[i] += p[j]*(float)sin((k++)*index + p[j+1]);";
  z[lc++]="      i--;";
  z[lc++]="    }";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="void tgen_lineseg(tableinfo * ti, int pnum, float * p) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, len, dx, nx;";
  z[lc++]="  float diff;";
  z[lc++]="";
  z[lc++]="  if (pnum < 5)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_lineseg\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  if (!(pnum % 2))";
  z[lc++]="    epr(0,\"control driver\",\"tgen_lineseg\",\"Last parameter is an xval\");";
  z[lc++]="  ";
  z[lc++]="  if ((len = ROUND(p[1])) != 0)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_lineseg\",\"x0 != 0\");";
  z[lc++]="  i = 3;";
  z[lc++]="";
  z[lc++]="  while (i < pnum)";
  z[lc++]="    {";
  z[lc++]="      j = ROUND(p[i]);";
  z[lc++]="      if (j < len)";
  z[lc++]="	epr(0,\"control driver\",\"tgen_lineseg\",\"Decreasing xval in sequence\");";
  z[lc++]="      len = j;";
  z[lc++]="      i += 2;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (p[0] <= 0.0F)";
  z[lc++]="    {";
  z[lc++]="      p[0] = len;";
  z[lc++]="      tgen_init(ti, pnum, p);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      j = tgen_init(ti, pnum, p);";
  z[lc++]="      len = (j < len) ? j : len; ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  i = j = 1;";
  z[lc++]="  while ((j + 2) < pnum)";
  z[lc++]="    if (!(dx = ((nx = ROUND(p[j+2])) - ROUND(p[j]))))";
  z[lc++]="      j += 2;";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	diff = (p[j+3]-p[j+1])/dx;";
  z[lc++]="	ti->t[ti->len] = ti->t[0] = p[j+1];";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  while ((i < len) && ((j + 2) < pnum))";
  z[lc++]="    {";
  z[lc++]="      if (nx > i)";
  z[lc++]="	{";
  z[lc++]="	  ti->t[i] = ti->t[i-1] + diff;";
  z[lc++]="	  i++;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  j += 2;";
  z[lc++]="	  while ((j + 2) < pnum)";
  z[lc++]="	    if (!(dx = ((nx =ROUND(p[j+2])) - ROUND(p[j]))))";
  z[lc++]="	      j += 2;";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		diff = (p[j+3]-p[j+1])/dx;";
  z[lc++]="		ti->t[i++] = p[j+1];";
  z[lc++]="		break;";
  z[lc++]="	      }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="void tgen_periodic(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="  float base, index;";
  z[lc++]="";
  z[lc++]="  i = tgen_init(ti, pnum, p);";
  z[lc++]="  base = 6.283185F/i;";
  z[lc++]="  i--;";
  z[lc++]="";
  z[lc++]="  if ((pnum-1) % 3)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_periodic\",\"Must have (p1, f1, ph1) triplets.\");";
  z[lc++]="";
  z[lc++]="  while (i >= 0)";
  z[lc++]="    {";
  z[lc++]="      j = -2;";
  z[lc++]="      index = i*base;";
  z[lc++]="      while ((j += 3) < pnum)";
  z[lc++]="	ti->t[i] += p[j+1]*(float)sin(p[j]*index + p[j+2]);";
  z[lc++]="      i--;";
  z[lc++]="    }";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="void tgen_polynomial(tableinfo * ti, int pnum, float * p) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float scale, yval, ynth;";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  if (pnum < 4)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_polynomial\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  tgen_init(ti, pnum, p);";
  z[lc++]="    ";
  z[lc++]="  scale = (1.0F/p[0])*(p[2]-p[1]);";
  z[lc++]="";
  z[lc++]="  for (i=0; i < ti->len; i++)";
  z[lc++]="    {";
  z[lc++]="      yval = p[1] + scale*(p[0] - i);";
  z[lc++]="      ynth = 1.0F;";
  z[lc++]="      ti->t[i] = p[3];";
  z[lc++]="      j = 3;";
  z[lc++]="      while (++j < pnum)";
  z[lc++]="	{";
  z[lc++]="	  ynth *= yval;";
  z[lc++]="	  ti->t[i] += p[j]*ynth;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#define RAN_UNIFORM 1";
  z[lc++]="#define RAN_LINRAMP 2";
  z[lc++]="#define RAN_EXPO    3";
  z[lc++]="#define RAN_GAUSS   4";
  z[lc++]="#define RAN_PPROC   5";
  z[lc++]="";
  z[lc++]="void tgen_random(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int dist, i, j;";
  z[lc++]="  float c1, x, y;";
  z[lc++]="";
  z[lc++]="  if (pnum < 3)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_random\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  tgen_init(ti, pnum, p);";
  z[lc++]="";
  z[lc++]="  dist = ROUND(p[1]);";
  z[lc++]="    ";
  z[lc++]="  switch(dist) {";
  z[lc++]="  case RAN_UNIFORM:";
  z[lc++]="  case RAN_LINRAMP:";
  z[lc++]="    if (pnum < 4)";
  z[lc++]="      epr(0,\"control driver\",\"tgen_random\",\"Too few parameters\");";
  z[lc++]="    c1 = p[3] - p[2];";
  z[lc++]="    if ((dist == 2) && !(c1))";
  z[lc++]="      epr(0,\"control driver\",\"tgen_random\",\"p1 == p2 (dist 2)\");";
  z[lc++]="    break;";
  z[lc++]="  case RAN_GAUSS:";
  z[lc++]="    if (pnum < 4)";
  z[lc++]="      epr(0,\"control driver\",\"tgen_random\",\"Too few parameters\");";
  z[lc++]="    if (p[3] <= 0.0F)";
  z[lc++]="      epr(0,\"control driver\",\"tgen_random\",\"p2 <= 0 (dist 4)\");";
  z[lc++]="    c1 = (float)sqrt(2.0*p[3]);";
  z[lc++]="    break;";
  z[lc++]="  case RAN_EXPO:";
  z[lc++]="  case RAN_PPROC:";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    epr(0,\"control driver\",\"tgen_random\",\"Distribution not 1,2,3,4 or 5.\");";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  j = 0; i = 0;";
  z[lc++]="  while (i < ti->len)";
  z[lc++]="    {";
  z[lc++]="      switch(dist) {";
  z[lc++]="      case RAN_UNIFORM:";
  z[lc++]="        ti->t[i] = c1*RMULT*((float)rand()) + p[2];";
  z[lc++]="        break;";
  z[lc++]="      case RAN_LINRAMP:";
  z[lc++]="        x = RMULT*((float)rand());";
  z[lc++]="        y = RMULT*((float)rand());";
  z[lc++]="        if (x > y)";
  z[lc++]="          ti->t[i] =  c1*x + p[2];";
  z[lc++]="        else";
  z[lc++]="          ti->t[i] =  c1*y + p[2];";
  z[lc++]="        break;";
  z[lc++]="      case RAN_EXPO:";
  z[lc++]="        ti->t[i] = -p[2]*(float)log(RMULT*((float)rand())+1e-45F);";
  z[lc++]="        break;";
  z[lc++]="      case RAN_GAUSS:";
  z[lc++]="        ti->t[i] = p[2]+c1*";
  z[lc++]="	  (float)sqrt(-2.0F*(float)log(RMULT*((float)rand())+1e-45F))";
  z[lc++]="	  *(float)cos(6.283185F*RMULT*((float)rand()));";
  z[lc++]="        break;";
  z[lc++]="      case RAN_PPROC:";
  z[lc++]="        ti->t[i] = 0;";
  z[lc++]="        if (j == 0)";
  z[lc++]="	  {";
  z[lc++]="	    j = ROUND(-p[2]*(float)log(RMULT*((float)rand())+1e-45F))+1;";
  z[lc++]="	    if (i != 0)";
  z[lc++]="	      ti->t[i] = 1.0F;";
  z[lc++]="	  }";
  z[lc++]="	j--;";
  z[lc++]="        break;";
  z[lc++]="      }";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#undef RAN_UNIFORM ";
  z[lc++]="#undef RAN_LINRAMP ";
  z[lc++]="#undef RAN_EXPO    ";
  z[lc++]="#undef RAN_GAUSS   ";
  z[lc++]="#undef RAN_PPROC   ";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#define SAMP_SR        5";
  z[lc++]="#define SAMP_LOOPSTART 4";
  z[lc++]="#define SAMP_LOOPEND   3";
  z[lc++]="#define SAMP_BASEFREQ  2";
  z[lc++]="#define SAMP_LLMEM     1";
  z[lc++]="#define SAMP_DATABLOCK 5";
  z[lc++]="";
  z[lc++]="void tgen_sample(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="  double intdummy;";
  z[lc++]="";
  z[lc++]="  if (pnum < SAMP_DATABLOCK + 1)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_sample\",\"Zero-length sample\");";
  z[lc++]="";
  z[lc++]="  ti->len = pnum - SAMP_DATABLOCK;";
  z[lc++]="  ti->lenf = (float)(pnum - SAMP_DATABLOCK);";
  z[lc++]="  ti->oconst = ti->lenf*ATIME;";
  z[lc++]="";
  z[lc++]="  if (ti->llmem)";
  z[lc++]="    free(ti->t); ";
  z[lc++]="  ti->t = p;";
  z[lc++]="";
  z[lc++]="  ti->stamp = scorebeats;";
  z[lc++]="";
  z[lc++]="  if (p[pnum - SAMP_SR] > 0)";
  z[lc++]="    {";
  z[lc++]="      ti->sr = p[pnum - SAMP_SR];";
  z[lc++]="      if (p[pnum - SAMP_SR] == ARATE)";
  z[lc++]="	{";
  z[lc++]="	  ti->dint = 1;";
  z[lc++]="	  ti->dfrac = 0;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  ti->dfrac = 4294967296.0*";
  z[lc++]="	    modf(((double)p[pnum - SAMP_SR])/((double)ARATE), &intdummy);";
  z[lc++]="	  ti->dint = intdummy;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      ti->sr = ARATE;";
  z[lc++]="      ti->dint = 1;";
  z[lc++]="      ti->dfrac = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if (INTERP_TYPE == INTERP_SINC)";
  z[lc++]="";
  z[lc++]="  if (p[pnum - SAMP_SR] > 0)";
  z[lc++]="    {";
  z[lc++]="      if (ARATE >= p[pnum - SAMP_SR])";
  z[lc++]="	{";
  z[lc++]="	  ti->sffl = 1.0F;";
  z[lc++]="	  ti->sfui = 0x00010000;";
  z[lc++]="	  ti->dsincr = SINC_PILEN;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if ((ARATE*SINC_UPMAX) >= p[pnum - SAMP_SR])";
  z[lc++]="	    ti->sffl = (ARATE/ti->sr);";
  z[lc++]="	  else";
  z[lc++]="	    ti->sffl = (1.0F/SINC_UPMAX);";
  z[lc++]="	  ti->sfui = ((float)(pow(2,16)))*ti->sffl + 0.5F;";
  z[lc++]="	  ti->dsincr = (SINC_PILEN*ti->sfui) >> 16;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      ti->sffl = 1.0F;";
  z[lc++]="      ti->sfui = 0x00010000;";
  z[lc++]="      ti->dsincr = SINC_PILEN;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  if (p[pnum - SAMP_BASEFREQ] > 0)";
  z[lc++]="    {";
  z[lc++]="      ti->base = p[pnum - SAMP_BASEFREQ];";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {  ";
  z[lc++]="      ti->base = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (p[pnum - SAMP_LOOPSTART] > 0)";
  z[lc++]="    {";
  z[lc++]="      ti->start = p[pnum - SAMP_LOOPSTART];";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      ti->start = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (p[pnum - SAMP_LOOPEND] > 0)";
  z[lc++]="    {";
  z[lc++]="      ti->tend = ti->end = p[pnum - SAMP_LOOPEND];";
  z[lc++]="      if (ti->end==0)";
  z[lc++]="	{";
  z[lc++]="	  ti->tend = ti->len - 1;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      ti->end = 0;";
  z[lc++]="      ti->tend = i - 1;";
  z[lc++]="    }";
  z[lc++]="  ti->llmem = (int)(p[pnum - SAMP_LLMEM]);";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#undef SAMP_SR ";
  z[lc++]="#undef SAMP_LOOPSTART ";
  z[lc++]="#undef SAMP_LOOPEND ";
  z[lc++]="#undef SAMP_BASEFREQ ";
  z[lc++]="#undef SAMP_DATABLOCK ";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="void tgen_spline(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, len, endpoint, newpoint;";
  z[lc++]="  float Q, R, S, a, b, c, d, k1, k2, xf;";
  z[lc++]="";
  z[lc++]="  if (pnum < 6)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_spline\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  if ((pnum - 3) % 3)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_spline\",";
  z[lc++]="	\"Parmeter list must end with (x, y)\");";
  z[lc++]="    ";
  z[lc++]="  if ((len = ROUND(p[1])) != 0)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_cubicseg\",\"x0 != 0\");";
  z[lc++]="  i = 4;";
  z[lc++]="";
  z[lc++]="  while (i < pnum)";
  z[lc++]="    {";
  z[lc++]="      j = ROUND(p[i]);";
  z[lc++]="      if (j < len)";
  z[lc++]="	epr(0,\"control driver\",\"tgen_spline\",";
  z[lc++]="	    \"Consecutive x values decreasing.\");";
  z[lc++]="      p[i] = (float)(len = j);";
  z[lc++]="      i += 3;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (p[0] <= 0.0F)";
  z[lc++]="    {";
  z[lc++]="      p[0] = len;";
  z[lc++]="      tgen_init(ti, pnum, p);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      j = tgen_init(ti, pnum, p);";
  z[lc++]="      len = (j < len) ? j : len; ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  endpoint = i = 0;";
  z[lc++]="  xf = 0.0F;";
  z[lc++]="";
  z[lc++]="  for (j = 1; (j+4) < pnum; j += 3)";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="      if ((newpoint = p[j+3]) != endpoint)";
  z[lc++]="	{";
  z[lc++]="	  endpoint = newpoint;";
  z[lc++]="";
  z[lc++]="	  if (j == 1)";
  z[lc++]="	    k1 = 0.0F;";
  z[lc++]="	  else";
  z[lc++]="	    k1 = p[j-1];";
  z[lc++]="	  if ((j+5) == pnum)";
  z[lc++]="	    k2 = 0;";
  z[lc++]="	  else";
  z[lc++]="	    k2 = p[j+2];";
  z[lc++]="";
  z[lc++]="	  Q = 1.0F/(p[j] - p[j+3]);";
  z[lc++]="	  R = Q*(p[j]*p[j] - p[j+3]*p[j+3]) - 2.0F*p[j];";
  z[lc++]="	  if (R == 0.0F)";
  z[lc++]="	    epr(0,\"control driver\",\"tgen_splice\",";
  z[lc++]="		\"No spline solution for these parameters\");";
  z[lc++]="	  R =1.0F/R;";
  z[lc++]="	  S = Q*(p[j]*p[j] - p[j+3]*p[j+3]) - 2.0F*p[j+3];";
  z[lc++]="	  if (S == 0.0F)";
  z[lc++]="	    epr(0,\"control driver\",\"tgen_splice\",";
  z[lc++]="		\"No spline solution for these parameters\");";
  z[lc++]="	  S =1.0F/S;";
  z[lc++]="	  ";
  z[lc++]="	  a = Q*(p[j]*p[j]*p[j]-p[j+3]*p[j+3]*p[j+3])*(R-S);";
  z[lc++]="	  a += -3.0F*(R*p[j]*p[j] - S*p[j+3]*p[j+3]);";
  z[lc++]="	  if (a==0.0F)";
  z[lc++]="	    epr(0,\"control driver\",\"tgen_spline\",";
  z[lc++]="		\"No spline solution for these parameters\");";
  z[lc++]="	  a =1.0F/a;";
  z[lc++]="	  a *= Q*(p[j+1]-p[j+4])*(R-S) - R*k1 + S*k2;";
  z[lc++]="	  b = Q*(k1-k2)*0.5F;";
  z[lc++]="	  b += - 1.5F*a*Q*(p[j]*p[j] - p[j+3]*p[j+3]);";
  z[lc++]="	  c = k1 - 3.0F*a*p[j]*p[j] -2.0F*b*p[j];";
  z[lc++]="	  d=p[j+1]-a*p[j]*p[j]*p[j]-b*p[j]*p[j]-c*p[j];";
  z[lc++]="";
  z[lc++]="	  while (i < endpoint)";
  z[lc++]="	    {";
  z[lc++]="	      ti->t[i] =  xf*xf*xf*a + xf*xf*b + xf*c + d;";
  z[lc++]="	      xf = (++i);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="void tgen_step(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, len, nx;";
  z[lc++]="";
  z[lc++]="  if (pnum < 4)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_step\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  if (pnum % 2)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_step\",\"Last parameter is a yval\");";
  z[lc++]="  ";
  z[lc++]="  if ((len = ROUND(p[1])) != 0)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_step\",\"x0 != 0\");";
  z[lc++]="  i = 3;";
  z[lc++]="";
  z[lc++]="  while (i < pnum)";
  z[lc++]="    {";
  z[lc++]="      j = ROUND(p[i]);";
  z[lc++]="      if (j < len)";
  z[lc++]="	epr(0,\"control driver\",\"tgen_step\",\"Decreasing xval in sequence\");";
  z[lc++]="      len = j;";
  z[lc++]="      i += 2;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (p[0] <= 0.0F)";
  z[lc++]="    {";
  z[lc++]="      p[0] = len;";
  z[lc++]="      tgen_init(ti, pnum, p);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      j = tgen_init(ti, pnum, p);";
  z[lc++]="      len = (j < len) ? j : len; ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  i = 0; ";
  z[lc++]="  j = 2;";
  z[lc++]="  nx = ROUND(p[3]);";
  z[lc++]="  while (i < len)";
  z[lc++]="    {";
  z[lc++]="      if (nx > i)";
  z[lc++]="	{";
  z[lc++]="	  ti->t[i] = p[j];";
  z[lc++]="	  i++;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if ((j += 2) == pnum)";
  z[lc++]="	    break;";
  z[lc++]="	  nx = ROUND(p[j+1]);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="double tgen_bessel(double x)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  double sum,a;";
  z[lc++]="";
  z[lc++]="  sum = a = 1.0;";
  z[lc++]="  a *= x*x; sum += a*2.5e-1;";
  z[lc++]="  a *= x*x; sum += a*1.5625e-2;";
  z[lc++]="  a *= x*x; sum += a*4.340278e-4;";
  z[lc++]="  a *= x*x; sum += a*6.781684e-6;";
  z[lc++]="  a *= x*x; sum += a*6.781684e-8; ";
  z[lc++]="  a *= x*x; sum += a*4.709503e-10;";
  z[lc++]="  a *= x*x; sum += a*2.402808e-12; ";
  z[lc++]="  a *= x*x; sum += a*9.385967e-15;";
  z[lc++]="  a *= x*x; sum += a*2.896903e-17;";
  z[lc++]="  a *= x*x; sum += a*7.242258e-20;";
  z[lc++]="";
  z[lc++]="  return sum;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#define WIN_HAMMING  1";
  z[lc++]="#define WIN_HANNING  2";
  z[lc++]="#define WIN_BARTLETT 3";
  z[lc++]="#define WIN_GAUSSIAN 4";
  z[lc++]="#define WIN_KAISER   5";
  z[lc++]="#define WIN_BOXCAR   6";
  z[lc++]="";
  z[lc++]="void tgen_window(tableinfo * ti, int pnum, float * p)  ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int type,i;";
  z[lc++]="  float c1, c2;";
  z[lc++]="  double d1, d2, d3;";
  z[lc++]="";
  z[lc++]="  if (pnum < 2)";
  z[lc++]="    epr(0,\"control driver\",\"tgen_window\",\"Too few parameters\");";
  z[lc++]="";
  z[lc++]="  tgen_init(ti, pnum, p);";
  z[lc++]="";
  z[lc++]="  type = ROUND(p[1]);";
  z[lc++]="    ";
  z[lc++]="  switch(type) {";
  z[lc++]="  case WIN_HAMMING:";
  z[lc++]="  case WIN_HANNING:";
  z[lc++]="    c1 = 6.283185F/(p[0]-1.0F);";
  z[lc++]="    break;";
  z[lc++]="  case WIN_BARTLETT:";
  z[lc++]="    c1 = 2.0F/(p[0]-1.0F);";
  z[lc++]="    c2 = 1.0F/c1;";
  z[lc++]="    break;";
  z[lc++]="  case WIN_GAUSSIAN:";
  z[lc++]="    c1 = - 18.0F/(p[0]*p[0]);";
  z[lc++]="    c2 = - 0.5F*p[0];";
  z[lc++]="    break;";
  z[lc++]="  case WIN_KAISER:     ";
  z[lc++]="    if (pnum < 3)";
  z[lc++]="      epr(0,\"control driver\",\"tgen_window\",\"Parameter p needed (type 5)\");";
  z[lc++]="    d1 = (p[0]-1.0)/2.0;";
  z[lc++]="    d2 = d1*d1;";
  z[lc++]="    d3 = 1.0/tgen_bessel(p[2]*d1);";
  z[lc++]="    break;";
  z[lc++]="  case WIN_BOXCAR:";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    epr(0,\"control driver\",\"tgen_window\",\"Window type not 1,2,3,4,5 or 6\");";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  for (i=0; i < ti->len; i++)";
  z[lc++]="    switch(type) {";
  z[lc++]="    case WIN_HAMMING:";
  z[lc++]="      ti->t[i] = 0.54F - 0.46F*(float)cos(c1*i);";
  z[lc++]="      break;";
  z[lc++]="    case WIN_HANNING:";
  z[lc++]="      ti->t[i] = 0.5F*(1.0F - (float)cos(c1*i));";
  z[lc++]="      break;";
  z[lc++]="    case WIN_BARTLETT:";
  z[lc++]="      ti->t[i] = 1.0F - c1*(float)fabs(i - c2);";
  z[lc++]="      break;";
  z[lc++]="    case WIN_GAUSSIAN:";
  z[lc++]="      ti->t[i] = ";
  z[lc++]="	(float)exp(c1*(c2+i)*(c2+i));";
  z[lc++]="      break;";
  z[lc++]="    case WIN_KAISER:";
  z[lc++]="      ti->t[i] = (float)(d3*tgen_bessel(p[2]*sqrt(d2 - (i-d1)*(i-d1))));";
  z[lc++]="      break;";
  z[lc++]="    case WIN_BOXCAR:";
  z[lc++]="      ti->t[i] = 1.0F;";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="  ti->t[ti->len] = ti->t[0];";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#undef WIN_HAMMING  ";
  z[lc++]="#undef WIN_HANNING  ";
  z[lc++]="#undef WIN_BARTLETT ";
  z[lc++]="#undef WIN_GAUSSIAN ";
  z[lc++]="#undef WIN_KAISER   ";
  z[lc++]="#undef WIN_BOXCAR   ";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/* ************************* */";
  z[lc++]="/* end of  table generators  */";
  z[lc++]="/* ************************* */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


