/*
 * This file is part of Soprano Project.
 *
 * Copyright (C) 2007 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_RDFS_H_
#define _SOPRANO_RDFS_H_

#include <QtCore/QUrl>
#include "soprano_export.h"

namespace Soprano {
    namespace Vocabulary {
        namespace RDFS {
            /**
             * http://www.w3.org/2000/01/rdf-schema#
             */
            SOPRANO_EXPORT QUrl rdfsNamespace();

            /**
             * http://www.w3.org/2000/01/rdf-schema#Resource
             */
            SOPRANO_EXPORT QUrl Resource();

            /**
             * http://www.w3.org/2000/01/rdf-schema#Class
             */
            SOPRANO_EXPORT QUrl Class();

            /**
             * http://www.w3.org/2000/01/rdf-schema#subClassOf
             */
            SOPRANO_EXPORT QUrl subClassOf();

            /**
             * http://www.w3.org/2000/01/rdf-schema#subPropertyOf
             */
            SOPRANO_EXPORT QUrl subPropertyOf();

            /**
             * http://www.w3.org/2000/01/rdf-schema#comment
             */
            SOPRANO_EXPORT QUrl comment();

            /**
             * http://www.w3.org/2000/01/rdf-schema#label
             */
            SOPRANO_EXPORT QUrl label();

            /**
             * http://www.w3.org/2000/01/rdf-schema#domain
             */
            SOPRANO_EXPORT QUrl domain();

            /**
             * http://www.w3.org/2000/01/rdf-schema#range
             */
            SOPRANO_EXPORT QUrl range();

            /**
             * http://www.w3.org/2000/01/rdf-schema#seeAlso
             */
            SOPRANO_EXPORT QUrl seeAlso();

            /**
             * http://www.w3.org/2000/01/rdf-schema#isDefinedBy
             */
            SOPRANO_EXPORT QUrl isDefinedBy();

            /**
             * http://www.w3.org/2000/01/rdf-schema#Literal
             */
            SOPRANO_EXPORT QUrl Literal();

            /**
             * http://www.w3.org/2000/01/rdf-schema#Container
             */
            SOPRANO_EXPORT QUrl Container();

            /**
             * http://www.w3.org/2000/01/rdf-schema#ContainerMembershipProperty
             */
            SOPRANO_EXPORT QUrl ContainerMembershipProperty();

            /**
             * http://www.w3.org/2000/01/rdf-schema#member
             */
            SOPRANO_EXPORT QUrl member();

            /**
             * http://www.w3.org/2000/01/rdf-schema#Datatype
             */
            SOPRANO_EXPORT QUrl Datatype();
        }
    }
}

#endif
