/* sqlheavy-profiling-database.c generated by valac 0.12.1, the Vala compiler
 * generated from sqlheavy-profiling-database.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <stdlib.h>
#include <string.h>
#include <config.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SQLHeavyProfilingDatabasePrivate {
	SQLHeavyQuery* query;
	GStaticRecMutex __lock_query;
};


static gpointer sql_heavy_profiling_database_parent_class = NULL;

#define SQL_HEAVY_PROFILING_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_PROFILING_DATABASE, SQLHeavyProfilingDatabasePrivate))
enum  {
	SQL_HEAVY_PROFILING_DATABASE_DUMMY_PROPERTY
};
void sql_heavy_profiling_database_insert (SQLHeavyProfilingDatabase* self, SQLHeavyQueryResult* query_result);
static GObject * sql_heavy_profiling_database_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sql_heavy_profiling_database_finalize (GObject* obj);


void sql_heavy_profiling_database_insert (SQLHeavyProfilingDatabase* self, SQLHeavyQueryResult* query_result) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query_result != NULL);
	{
		SQLHeavyQuery* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gdouble _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		SQLHeavyQueryResult* _tmp5_ = NULL;
		SQLHeavyQueryResult* _tmp6_;
		g_static_rec_mutex_lock (&self->priv->__lock_query);
		_tmp0_ = sql_heavy_query_result_get_query (query_result);
		_tmp1_ = sql_heavy_query_get_sql (_tmp0_);
		sql_heavy_query_set_string (self->priv->query, ":sql", _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch18_sql_heavy_error;
			}
			g_static_rec_mutex_unlock (&self->priv->__lock_query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = sql_heavy_query_result_get_execution_time (query_result);
		sql_heavy_query_set_double (self->priv->query, ":clock", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch18_sql_heavy_error;
			}
			g_static_rec_mutex_unlock (&self->priv->__lock_query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = sql_heavy_query_result_get_full_scan_steps (query_result);
		sql_heavy_query_set_int64 (self->priv->query, ":fullscan_step", (gint64) _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch18_sql_heavy_error;
			}
			g_static_rec_mutex_unlock (&self->priv->__lock_query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = sql_heavy_query_result_get_sort_operations (query_result);
		sql_heavy_query_set_int64 (self->priv->query, ":sort", (gint64) _tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch18_sql_heavy_error;
			}
			g_static_rec_mutex_unlock (&self->priv->__lock_query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = sql_heavy_query_execute (self->priv->query, NULL, &_inner_error_, NULL);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch18_sql_heavy_error;
			}
			g_static_rec_mutex_unlock (&self->priv->__lock_query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		goto __finally18;
		__catch18_sql_heavy_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("sqlheavy-profiling-database.vala:29: Unable to insert entry into profi" \
"ling database: %s", e->message);
			_g_error_free0 (e);
		}
		__finally18:
		if (_inner_error_ != NULL) {
			g_static_rec_mutex_unlock (&self->priv->__lock_query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		__finally17:
		g_static_rec_mutex_unlock (&self->priv->__lock_query);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Create a new ProfilingDatabase
     *
     * @param filename the location of the database
     */
SQLHeavyProfilingDatabase* sql_heavy_profiling_database_construct (GType object_type, const gchar* filename, GError** error) {
	SQLHeavyProfilingDatabase * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* schema;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_build_filename (SQL_HEAVY_CONFIG_PATH_PACKAGE_DATA, SQL_HEAVY_VERSION_API, "schemas", "profiling", NULL);
	schema = _tmp0_;
	self = (SQLHeavyProfilingDatabase*) g_object_new (object_type, "filename", filename, "schema", schema, NULL);
	sql_heavy_database_init ((SQLHeavyDatabase*) self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (schema);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (schema);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_free0 (schema);
	return self;
}


SQLHeavyProfilingDatabase* sql_heavy_profiling_database_new (const gchar* filename, GError** error) {
	return sql_heavy_profiling_database_construct (SQL_HEAVY_TYPE_PROFILING_DATABASE, filename, error);
}


static GObject * sql_heavy_profiling_database_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SQLHeavyProfilingDatabase * self;
	SQLHeavyQuery* _tmp0_ = NULL;
	SQLHeavyQuery* _tmp1_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (sql_heavy_profiling_database_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SQL_HEAVY_PROFILING_DATABASE (obj);
	sql_heavy_database_set_synchronous ((SQLHeavyDatabase*) self, SQL_HEAVY_SYNCHRONOUS_MODE_OFF);
	sql_heavy_database_set_journal_mode ((SQLHeavyDatabase*) self, SQL_HEAVY_JOURNAL_MODE_OFF);
	_tmp0_ = sql_heavy_query_new ((SQLHeavyQueryable*) self, "INSERT INTO `queries` (`sql`, `clock`, `fullscan_step`, `sort`) VALUES" \
" (:sql, :clock, :fullscan_step, :sort);", &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			goto __catch19_sql_heavy_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_object_unref0 (self->priv->query);
	self->priv->query = _tmp1_;
	sql_heavy_query_set_auto_clear (self->priv->query, TRUE);
	goto __finally19;
	__catch19_sql_heavy_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("sqlheavy-profiling-database.vala:43: Unable to insert profiling inform" \
"ation: %s (%d)", e->message, e->code);
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void sql_heavy_profiling_database_class_init (SQLHeavyProfilingDatabaseClass * klass) {
	sql_heavy_profiling_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyProfilingDatabasePrivate));
	G_OBJECT_CLASS (klass)->constructor = sql_heavy_profiling_database_constructor;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_profiling_database_finalize;
}


static void sql_heavy_profiling_database_instance_init (SQLHeavyProfilingDatabase * self) {
	self->priv = SQL_HEAVY_PROFILING_DATABASE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_query);
}


static void sql_heavy_profiling_database_finalize (GObject* obj) {
	SQLHeavyProfilingDatabase * self;
	self = SQL_HEAVY_PROFILING_DATABASE (obj);
	g_static_rec_mutex_free (&self->priv->__lock_query);
	_g_object_unref0 (self->priv->query);
	G_OBJECT_CLASS (sql_heavy_profiling_database_parent_class)->finalize (obj);
}


/**
   * Database used to hold profiling information.
   *
   * Note that this database will have {@link Database.synchronous}
   * property set to OFF. This provides a drastic performance increase
   * but means that sudden power loss could lead to a corrupt
   * profiling database.
   *
   * This database will also have {@link Database.journal_mode} set to
   * OFF. This will approximately halve the amount of time time spent
   * inserting profiling data, but the database will likely become
   * corrupt if the application crashes.
   *
   * @see Database.profiling_data
   */
GType sql_heavy_profiling_database_get_type (void) {
	static volatile gsize sql_heavy_profiling_database_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_profiling_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyProfilingDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_profiling_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyProfilingDatabase), 0, (GInstanceInitFunc) sql_heavy_profiling_database_instance_init, NULL };
		GType sql_heavy_profiling_database_type_id;
		sql_heavy_profiling_database_type_id = g_type_register_static (SQL_HEAVY_TYPE_VERSIONED_DATABASE, "SQLHeavyProfilingDatabase", &g_define_type_info, 0);
		g_once_init_leave (&sql_heavy_profiling_database_type_id__volatile, sql_heavy_profiling_database_type_id);
	}
	return sql_heavy_profiling_database_type_id__volatile;
}



