/* sqlheavy-query.c generated by valac 0.12.1, the Vala compiler
 * generated from sqlheavy-query.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include "SQLHeavy.h"
#include <stdarg.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SqlHeavyQueryExecuteAsyncData SqlHeavyQueryExecuteAsyncData;
typedef struct _SqlHeavyQueryExecuteInsertAsyncData SqlHeavyQueryExecuteInsertAsyncData;
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _SQLHeavyQueryPrivate {
	SQLHeavyQueryable* _queryable;
	gchar* _sql;
	gint _sql_length;
	sqlite3_stmt* stmt;
	GStaticRecMutex __lock_stmt;
	gboolean stmt_in_use;
	SQLHeavyValueArray* bindings;
	gboolean _auto_clear;
	gint _parameter_count;
};

struct _SqlHeavyQueryExecuteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyQuery* self;
	GCancellable* cancellable;
	SQLHeavyQueryResult* result;
	SQLHeavyQueryResult* _tmp0_;
	SQLHeavyQueryResult* res;
	GError * _inner_error_;
};

struct _SqlHeavyQueryExecuteInsertAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyQuery* self;
	GCancellable* cancellable;
	gint64 result;
	SQLHeavyQueryResult* _tmp0_;
	SQLHeavyQueryResult* res;
	gint64 insert_id;
	gint64 _tmp1_;
	GError * _inner_error_;
};


static gpointer sql_heavy_query_parent_class = NULL;
static GInitableIface* sql_heavy_query_g_initable_parent_iface = NULL;

gint sqlite3_prepare_v2 (sqlite3* db, const gchar* sql, gint n_bytes, sqlite3_stmt** stmt, const gchar** tail);
gint sqlite3_finalize (sqlite3_stmt* stmt);
#define SQL_HEAVY_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_QUERY, SQLHeavyQueryPrivate))
enum  {
	SQL_HEAVY_QUERY_DUMMY_PROPERTY,
	SQL_HEAVY_QUERY_QUERYABLE,
	SQL_HEAVY_QUERY_SQL,
	SQL_HEAVY_QUERY_SQL_LENGTH,
	SQL_HEAVY_QUERY_AUTO_CLEAR,
	SQL_HEAVY_QUERY_PARAMETER_COUNT
};
SQLHeavyValueArray* sql_heavy_query_get_bindings (SQLHeavyQuery* self);
sqlite3_stmt* sql_heavy_query_try_to_steal_stmt (SQLHeavyQuery* self);
void sql_heavy_query_return_stmt (SQLHeavyQuery* self);
static gint sql_heavy_query_parameter_check_index (SQLHeavyQuery* self, gint parameter, GError** error);
const gchar* sql_heavy_sqlite_errstr (gint ec);
void sql_heavy_query_set_list (SQLHeavyQuery* self, gboolean has_first_parameter, const gchar* first_parameter, va_list args, GError** error);
static void sql_heavy_query_execute_async_data_free (gpointer _data);
static gboolean sql_heavy_query_execute_async_co (SqlHeavyQueryExecuteAsyncData* data);
SQLHeavyQueryResult* sql_heavy_query_result_new_no_exec (SQLHeavyQuery* query, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_exec (GType object_type, SQLHeavyQuery* query, GError** error);
static void sql_heavy_query_execute_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
SQLHeavyQueryResult* sql_heavy_query_result_new_insert (SQLHeavyQuery* query, gint64* insert_id, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_insert (GType object_type, SQLHeavyQuery* query, gint64* insert_id, GError** error);
static void sql_heavy_query_execute_insert_async_data_free (gpointer _data);
static gboolean sql_heavy_query_execute_insert_async_co (SqlHeavyQueryExecuteInsertAsyncData* data);
void sql_heavy_query_result_next_internal_async (SQLHeavyQueryResult* self, GCancellable* cancellable, gint steps, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean sql_heavy_query_result_next_internal_finish (SQLHeavyQueryResult* self, GAsyncResult* _res_, gint64* last_insert_id, GError** error);
static void sql_heavy_query_execute_insert_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean sql_heavy_check_type (GType gtype);
static void _g_ptr_array_unref0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void _g_free0_ (gpointer var);
static gboolean sql_heavy_query_real_init (SQLHeavyQuery* self, GCancellable* cancellable, GError** error);
sqlite3* sql_heavy_database_get_sqlite_db (SQLHeavyDatabase* self);
gboolean sql_heavy_error_if_not_ok (gint ec, SQLHeavyQueryable* queryable, GError** error);
static gint sql_heavy_query_get_sql_length (SQLHeavyQuery* self);
static void sql_heavy_query_set_parameter_count (SQLHeavyQuery* self, gint value);
static void sql_heavy_query_set_queryable (SQLHeavyQuery* self, SQLHeavyQueryable* value);
static void sql_heavy_query_finalize (GObject* obj);
static void _vala_sql_heavy_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sql_heavy_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Retrive the bindings for the query
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SQLHeavyValueArray* sql_heavy_query_get_bindings (SQLHeavyQuery* self) {
	SQLHeavyValueArray* result = NULL;
	SQLHeavyValueArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->bindings);
	result = _tmp0_;
	return result;
}


/**
     * Attempt to steal the {@link stmt}
     *
     * We want to be able to create multiple {@link QueryResult}
     * instances from a single {@link Query}, but compiling a
     * statement is not cheap, so we want to be able to reuse the
     * statement we created for the query.
     *
     * This function will try to steal the statement, but if it is
     * already in use by another {@link QueryResult} it will return
     * null and let the {@link QueryResult} compile a new statement.
     *
     * @return the statement or null
     */
sqlite3_stmt* sql_heavy_query_try_to_steal_stmt (SQLHeavyQuery* self) {
	sqlite3_stmt* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->stmt_in_use) {
		{
			g_static_rec_mutex_lock (&self->priv->__lock_stmt);
			if (!self->priv->stmt_in_use) {
				self->priv->stmt_in_use = TRUE;
				result = self->priv->stmt;
				g_static_rec_mutex_unlock (&self->priv->__lock_stmt);
				return result;
			}
			__finally20:
			g_static_rec_mutex_unlock (&self->priv->__lock_stmt);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = NULL;
	return result;
}


/**
     * Return ownership of a statement which was acquired from the
     * {@link try_to_steal_stmt} method
     */
void sql_heavy_query_return_stmt (SQLHeavyQuery* self) {
	g_return_if_fail (self != NULL);
	self->priv->stmt_in_use = FALSE;
}


/**
     * Check to make sure that specified parameter is valid
     *
     * @param parameter the parameter to check
     * @return the parameter
     */
static gint sql_heavy_query_parameter_check_index (SQLHeavyQuery* self, gint parameter, GError** error) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	if (parameter < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = parameter > self->priv->_parameter_count;
	}
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = sql_heavy_sqlite_errstr (SQLITE_RANGE);
		_tmp2_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, _tmp1_);
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = parameter;
	return result;
}


/**
     * Return the name of the specified parameter
     *
     * @param parameter the parameter to look up
     * @return string representation of the parameter
     */
const gchar* sql_heavy_query_parameter_name (SQLHeavyQuery* self, gint parameter, GError** error) {
	const gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sql_heavy_query_parameter_check_index (self, parameter, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = sqlite3_bind_parameter_name (self->priv->stmt, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
     * Return the numeric offset of the specified parameter
     *
     * @param parameter the parameter to look up
     * @return offset of the parameter
     */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


gint sql_heavy_query_parameter_index (SQLHeavyQuery* self, const gchar* parameter, GError** error) {
	gint result = 0;
	gint idx;
	gchar _tmp0_;
	gchar first_char;
	gboolean _tmp1_ = FALSE;
	GError* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (parameter != NULL, 0);
	idx = 0;
	_tmp0_ = string_get (parameter, (glong) 0);
	first_char = _tmp0_;
	if (first_char == ':') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = first_char == '@';
	}
	if (_tmp1_) {
		gint _tmp2_;
		_tmp2_ = sqlite3_bind_parameter_index (self->priv->stmt, parameter);
		idx = _tmp2_;
		if (idx != 0) {
			result = idx - 1;
			return result;
		}
	} else {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gint _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = g_strconcat (":", parameter, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = sqlite3_bind_parameter_index (self->priv->stmt, _tmp4_);
		idx = _tmp5_;
		_tmp6_ = idx != 0;
		_g_free0 (_tmp4_);
		if (_tmp6_) {
			result = idx - 1;
			return result;
		} else {
			gchar* _tmp7_;
			gchar* _tmp8_;
			gint _tmp9_;
			gboolean _tmp10_;
			_tmp7_ = g_strconcat ("@", parameter, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = sqlite3_bind_parameter_index (self->priv->stmt, _tmp8_);
			idx = _tmp9_;
			_tmp10_ = idx != 0;
			_g_free0 (_tmp8_);
			if (_tmp10_) {
				result = idx - 1;
				return result;
			}
		}
	}
	_tmp11_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, "Could not find parameter '%s'.", parameter);
	_inner_error_ = _tmp11_;
	if (_inner_error_->domain == SQL_HEAVY_ERROR) {
		g_propagate_error (error, _inner_error_);
		return 0;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
}


/**
     * Bind a list of parameters
     *
     * These are in groups of three, with the first argument being the
     * named parameter, the second being the type (GType), and the
     * third being the value.
     *
     * @param has_first_parameter whether the first_parameter argument should be used
     * @param first_parameter the name of the first parameter
     * @param args the remaining parameters
     */
void sql_heavy_query_set_list (SQLHeavyQuery* self, gboolean has_first_parameter, const gchar* first_parameter, va_list args, GError** error) {
	const gchar* current_parameter;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	current_parameter = first_parameter;
	if (!has_first_parameter) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = va_arg (args, gchar*);
		current_parameter = _tmp0_;
	}
	while (TRUE) {
		GType _tmp1_;
		GType current_parameter_type;
		const gchar* _tmp10_ = NULL;
		if (!(current_parameter != NULL)) {
			break;
		}
		_tmp1_ = va_arg (args, GType);
		current_parameter_type = _tmp1_;
		if (current_parameter_type == G_TYPE_STRING) {
			const gchar* _tmp2_ = NULL;
			_tmp2_ = va_arg (args, gchar*);
			sql_heavy_query_set_string (self, current_parameter, _tmp2_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SQL_HEAVY_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			if (current_parameter_type == G_TYPE_INT) {
				gint _tmp3_;
				_tmp3_ = va_arg (args, gint);
				sql_heavy_query_set_int (self, current_parameter, _tmp3_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == SQL_HEAVY_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			} else {
				if (current_parameter_type == G_TYPE_INT64) {
					gint64 _tmp4_;
					_tmp4_ = va_arg (args, gint64);
					sql_heavy_query_set_int64 (self, current_parameter, _tmp4_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				} else {
					gboolean _tmp5_ = FALSE;
					if (current_parameter_type == G_TYPE_DOUBLE) {
						_tmp5_ = TRUE;
					} else {
						_tmp5_ = current_parameter_type == G_TYPE_FLOAT;
					}
					if (_tmp5_) {
						gdouble _tmp6_;
						_tmp6_ = va_arg (args, gdouble);
						sql_heavy_query_set_double (self, current_parameter, _tmp6_, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == SQL_HEAVY_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					} else {
						if (current_parameter_type == G_TYPE_POINTER) {
							sql_heavy_query_set_null (self, current_parameter, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == SQL_HEAVY_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						} else {
							if (current_parameter_type == G_TYPE_BYTE_ARRAY) {
								GByteArray* _tmp7_ = NULL;
								_tmp7_ = va_arg (args, GByteArray*);
								sql_heavy_query_set_byte_array (self, current_parameter, _tmp7_, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										return;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							} else {
								const gchar* _tmp8_ = NULL;
								GError* _tmp9_ = NULL;
								_tmp8_ = g_type_name (current_parameter_type);
								_tmp9_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_DATA_TYPE, "Data type `%s' unsupported.", _tmp8_);
								_inner_error_ = _tmp9_;
								if (_inner_error_->domain == SQL_HEAVY_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
				}
			}
		}
		_tmp10_ = va_arg (args, gchar*);
		current_parameter = _tmp10_;
	}
}


/**
     * Execute the query
     *
     * This function accepts an arbitrary number of groups of
     * arguments for binding values. The first argument in the group
     * must be the name of the parameter to bind, the second a GType,
     * and the third the value.
     *
     * @param first_parameter the name of the first parameter to bind, or null
     * @return the result
     */
SQLHeavyQueryResult* sql_heavy_query_execute (SQLHeavyQuery* self, const gchar* first_parameter, GError** error, ...) {
	SQLHeavyQueryResult* result = NULL;
	va_list args;
	SQLHeavyQueryResult* _tmp0_ = NULL;
	SQLHeavyQueryResult* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	va_start (args, first_parameter);
	sql_heavy_query_set_list (self, TRUE, first_parameter, args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			return NULL;
		} else {
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = sql_heavy_query_result_new (self, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			return NULL;
		} else {
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	va_end (args);
	return result;
}


static void sql_heavy_query_execute_async_data_free (gpointer _data) {
	SqlHeavyQueryExecuteAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SqlHeavyQueryExecuteAsyncData, data);
}


void sql_heavy_query_execute_async (SQLHeavyQuery* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyQueryExecuteAsyncData* _data_;
	_data_ = g_slice_new0 (SqlHeavyQueryExecuteAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_query_execute_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_query_execute_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	sql_heavy_query_execute_async_co (_data_);
}


SQLHeavyQueryResult* sql_heavy_query_execute_finish (SQLHeavyQuery* self, GAsyncResult* _res_, GError** error) {
	SQLHeavyQueryResult* result;
	SqlHeavyQueryExecuteAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Execute the query asynchronously
     *
     * @param cancellable optional cancellable for aborting the operation
     * @return the result
     */
static void sql_heavy_query_execute_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyQueryExecuteAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	sql_heavy_query_execute_async_co (data);
}


static gboolean sql_heavy_query_execute_async_co (SqlHeavyQueryExecuteAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = sql_heavy_query_result_new_no_exec (data->self, &data->_inner_error_);
	data->res = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_state_ = 1;
	sql_heavy_query_result_next_async (data->res, data->cancellable, sql_heavy_query_execute_async_ready, data);
	return FALSE;
	_state_1:
	sql_heavy_query_result_next_finish (data->res, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->res);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->res;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->res);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


/**
     * Execute the INSERT query
     *
     * This function accepts an arbitrary number of groups of
     * arguments for binding values. The first argument in the group
     * must be the name of the parameter to bind, the second a GType,
     * and the third the value.
     *
     * @return the inserted row ID
     */
gint64 sql_heavy_query_execute_insert (SQLHeavyQuery* self, const gchar* first_parameter, GError** error, ...) {
	gint64 result = 0LL;
	gint64 insert_id;
	va_list args;
	SQLHeavyQueryResult* _tmp0_ = NULL;
	SQLHeavyQueryResult* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0LL);
	insert_id = (gint64) 0;
	va_start (args, first_parameter);
	sql_heavy_query_set_list (self, TRUE, first_parameter, args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			return 0LL;
		} else {
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	_tmp0_ = sql_heavy_query_result_new_insert (self, &insert_id, &_inner_error_);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			return 0LL;
		} else {
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	result = insert_id;
	va_end (args);
	return result;
}


static void sql_heavy_query_execute_insert_async_data_free (gpointer _data) {
	SqlHeavyQueryExecuteInsertAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (SqlHeavyQueryExecuteInsertAsyncData, data);
}


void sql_heavy_query_execute_insert_async (SQLHeavyQuery* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyQueryExecuteInsertAsyncData* _data_;
	_data_ = g_slice_new0 (SqlHeavyQueryExecuteInsertAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_query_execute_insert_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_query_execute_insert_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	sql_heavy_query_execute_insert_async_co (_data_);
}


gint64 sql_heavy_query_execute_insert_finish (SQLHeavyQuery* self, GAsyncResult* _res_, GError** error) {
	gint64 result;
	SqlHeavyQueryExecuteInsertAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0LL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
     * Execute the INSERT query asynchronously
     *
     * @param cancellable optional cancellable for aborting the operation
     * @return the inserted row ID
     */
static void sql_heavy_query_execute_insert_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyQueryExecuteInsertAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	sql_heavy_query_execute_insert_async_co (data);
}


static gboolean sql_heavy_query_execute_insert_async_co (SqlHeavyQueryExecuteInsertAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = sql_heavy_query_result_new_no_exec (data->self, &data->_inner_error_);
	data->res = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->insert_id = (gint64) 0;
	data->_state_ = 1;
	sql_heavy_query_result_next_internal_async (data->res, data->cancellable, 1, sql_heavy_query_execute_insert_async_ready, data);
	return FALSE;
	_state_1:
	sql_heavy_query_result_next_internal_finish (data->res, data->_res_, &data->_tmp1_, &data->_inner_error_);
	data->insert_id = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->res);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->insert_id;
	_g_object_unref0 (data->res);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->res);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


/**
     * Bind a value to the specified parameter index
     *
     * @param parameter name of the parameter
     * @param value value to bind
     * @see set
     */
void sql_heavy_query_bind (SQLHeavyQuery* self, gint parameter, GValue* value, GError** error) {
	GType _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	sql_heavy_query_parameter_check_index (self, parameter, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = G_VALUE_TYPE (value);
	_tmp1_ = sql_heavy_check_type (_tmp0_);
	if (!_tmp1_) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_DATA_TYPE, "Data type unsupported.");
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_value_array_set (self->priv->bindings, parameter, value);
}


/**
     * Bind a value to the specified parameter
     *
     * @param name name of the parameter
     * @param value value to bind
     * @see bind
     */
void sql_heavy_query_set (SQLHeavyQuery* self, const gchar* name, GValue* value, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = sql_heavy_query_parameter_index (self, name, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_query_bind (self, _tmp1_, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind an int value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_int
     * @see set
     */
void sql_heavy_query_bind_int (SQLHeavyQuery* self, gint field, gint value, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_query_parameter_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_value_array_set_int (self->priv->bindings, _tmp1_, value);
}


/**
     * Bind an int value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_int
     * @see set
     */
void sql_heavy_query_set_int (SQLHeavyQuery* self, const gchar* field, gint value, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = sql_heavy_query_parameter_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_query_bind_int (self, _tmp1_, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind an int64 value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_int64
     * @see bind
     */
void sql_heavy_query_bind_int64 (SQLHeavyQuery* self, gint field, gint64 value, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_query_parameter_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_value_array_set_int64 (self->priv->bindings, _tmp1_, value);
}


/**
     * Bind an int64 value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_int64
     * @see set
     */
void sql_heavy_query_set_int64 (SQLHeavyQuery* self, const gchar* field, gint64 value, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = sql_heavy_query_parameter_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_query_bind_int64 (self, _tmp1_, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind a string value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_string
     * @see bind
     */
void sql_heavy_query_bind_string (SQLHeavyQuery* self, gint field, const gchar* value, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		sql_heavy_query_bind_null (self, field, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = sql_heavy_query_parameter_check_index (self, field, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		sql_heavy_value_array_set_string (self->priv->bindings, _tmp1_, value);
	}
}


/**
     * Bind a string value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_string
     * @see set
     */
void sql_heavy_query_set_string (SQLHeavyQuery* self, const gchar* field, const gchar* value, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = sql_heavy_query_parameter_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_query_bind_string (self, _tmp1_, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind null to the specified parameter index
     *
     * @param field index of the parameter
     * @see set_null
     * @see bind
     */
void sql_heavy_query_bind_null (SQLHeavyQuery* self, gint field, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_query_parameter_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_value_array_set_null (self->priv->bindings, _tmp1_);
}


/**
     * Bind null to the specified parameter
     *
     * @param field name of the parameter
     * @see bind_null
     * @see set
     */
void sql_heavy_query_set_null (SQLHeavyQuery* self, const gchar* field, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = sql_heavy_query_parameter_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_query_bind_null (self, _tmp1_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind a double value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_double
     * @see bind
     */
void sql_heavy_query_bind_double (SQLHeavyQuery* self, gint field, gdouble value, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_query_parameter_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_value_array_set_double (self->priv->bindings, _tmp1_, value);
}


/**
     * Bind an double value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_double
     * @see set
     */
void sql_heavy_query_set_double (SQLHeavyQuery* self, const gchar* field, gdouble value, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = sql_heavy_query_parameter_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_query_bind_double (self, _tmp1_, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind a byte array value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_blob
     * @see bind
     */
void sql_heavy_query_bind_blob (SQLHeavyQuery* self, gint field, guint8* value, int value_length1, GError** error) {
	GByteArray* _tmp0_ = NULL;
	GByteArray* ba;
	gint _tmp1_;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_byte_array_sized_new ((guint) value_length1);
	ba = _tmp0_;
	g_byte_array_append (ba, value, value_length1);
	_tmp1_ = sql_heavy_query_parameter_check_index (self, field, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_byte_array_unref0 (ba);
			return;
		} else {
			_g_byte_array_unref0 (ba);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_query_bind_byte_array (self, _tmp2_, ba, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_byte_array_unref0 (ba);
			return;
		} else {
			_g_byte_array_unref0 (ba);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_byte_array_unref0 (ba);
}


/**
     * Bind a byte array value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_blob
     * @see set
     */
void sql_heavy_query_set_blob (SQLHeavyQuery* self, const gchar* field, guint8* value, int value_length1, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = sql_heavy_query_parameter_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_query_bind_blob (self, _tmp1_, value, value_length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind a byte array value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_blob
     * @see bind
     */
void sql_heavy_query_bind_byte_array (SQLHeavyQuery* self, gint field, GByteArray* value, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = sql_heavy_query_parameter_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_value_array_set_byte_array (self->priv->bindings, _tmp1_, value);
}


/**
     * Bind a byte array value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_blob
     * @see set
     */
void sql_heavy_query_set_byte_array (SQLHeavyQuery* self, const gchar* field, GByteArray* value, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = sql_heavy_query_parameter_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_query_bind_byte_array (self, _tmp1_, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Clear the bindings
     */
void sql_heavy_query_clear (SQLHeavyQuery* self) {
	g_return_if_fail (self != NULL);
	sql_heavy_value_array_clear (self->priv->bindings);
}


/**
     * Retrieve the entire result set
     *
     * @return the result set
     * @see print_table
     */
static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	g_return_if_fail (self != NULL);
	g_ptr_array_set_size (self, value);
}


static void g_ptr_array_set (GPtrArray* self, guint index, gpointer data) {
	gpointer _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	g_ptr_array_remove_index_fast (self, index);
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


GPtrArray* sql_heavy_query_get_table (SQLHeavyQuery* self, GError** error) {
	GPtrArray* result = NULL;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* values;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_ptr_array_unref0_);
	values = _tmp0_;
	{
		SQLHeavyQueryResult* _tmp1_ = NULL;
		SQLHeavyQueryResult* results;
		_tmp1_ = sql_heavy_query_execute (self, NULL, &_inner_error_, NULL);
		results = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_ptr_array_unref0 (values);
				return NULL;
			} else {
				_g_ptr_array_unref0 (values);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp4_;
				gint column_l;
				GPtrArray* _tmp5_ = NULL;
				GPtrArray* row;
				GPtrArray* _tmp12_;
				if (!_tmp2_) {
					sql_heavy_record_set_next ((SQLHeavyRecordSet*) results, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (results);
							_g_ptr_array_unref0 (values);
							return NULL;
						} else {
							_g_object_unref0 (results);
							_g_ptr_array_unref0 (values);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
				_tmp2_ = FALSE;
				_tmp3_ = sql_heavy_query_result_get_finished (results);
				if (!(!_tmp3_)) {
					break;
				}
				_tmp4_ = sql_heavy_record_get_field_count ((SQLHeavyRecord*) results);
				column_l = _tmp4_;
				_tmp5_ = g_ptr_array_new_with_free_func (__vala_GValue_free0_);
				row = _tmp5_;
				g_ptr_array_set_length (row, column_l);
				{
					gint c;
					c = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							GValue _tmp7_ = {0};
							GValue _tmp8_ = {0};
							GValue _tmp9_;
							GValue _tmp10_;
							GValue* _tmp11_;
							if (!_tmp6_) {
								c++;
							}
							_tmp6_ = FALSE;
							if (!(c < column_l)) {
								break;
							}
							sql_heavy_record_fetch ((SQLHeavyRecord*) results, c, &_tmp7_, &_inner_error_);
							_tmp8_ = _tmp7_;
							_tmp9_ = _tmp8_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == SQL_HEAVY_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_ptr_array_unref0 (row);
									_g_object_unref0 (results);
									_g_ptr_array_unref0 (values);
									return NULL;
								} else {
									_g_ptr_array_unref0 (row);
									_g_object_unref0 (results);
									_g_ptr_array_unref0 (values);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							_tmp10_ = _tmp9_;
							_tmp11_ = __g_value_dup0 (&_tmp10_);
							g_ptr_array_set (row, (guint) c, _tmp11_);
							G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
						}
					}
				}
				_tmp12_ = _g_ptr_array_ref0 (row);
				g_ptr_array_add (values, _tmp12_);
				_g_ptr_array_unref0 (row);
			}
		}
		_g_object_unref0 (results);
	}
	result = values;
	return result;
}


/**
     * Print the result set to a file stream
     *
     * @param fd the stream to print to
     * @see Queryable.print_table
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


void sql_heavy_query_print_table (SQLHeavyQuery* self, FILE* fd, GError** error) {
	SQLHeavyQueryResult* _tmp0_ = NULL;
	SQLHeavyQueryResult* _result_;
	gint _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** field_names;
	gint field_names_length1;
	gint _field_names_size_;
	glong* _tmp3_ = NULL;
	glong* field_lengths;
	gint field_lengths_length1;
	gint _field_lengths_size_;
	GPtrArray* _tmp4_ = NULL;
	GPtrArray* data;
	gint field;
	GString* _tmp14_ = NULL;
	GString* sep;
	gchar** _tmp17_ = NULL;
	gchar** field_fmt;
	gint field_fmt_length1;
	gint _field_fmt_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_query_execute (self, NULL, &_inner_error_, NULL);
	_result_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = sql_heavy_record_field_names ((SQLHeavyRecord*) _result_, &_tmp1_);
	field_names = _tmp2_;
	field_names_length1 = _tmp1_;
	_field_names_size_ = _tmp1_;
	_tmp3_ = g_new0 (glong, field_names_length1);
	field_lengths = _tmp3_;
	field_lengths_length1 = field_names_length1;
	_field_lengths_size_ = field_names_length1;
	_tmp4_ = g_ptr_array_new_with_free_func (_g_ptr_array_unref0_);
	data = _tmp4_;
	if (fd == NULL) {
		fd = stderr;
	}
	field = 0;
	{
		gboolean _tmp5_;
		field = 0;
		_tmp5_ = TRUE;
		while (TRUE) {
			gint _tmp6_;
			if (!_tmp5_) {
				field++;
			}
			_tmp5_ = FALSE;
			if (!(field < field_lengths_length1)) {
				break;
			}
			_tmp6_ = strlen (field_names[field]);
			field_lengths[field] = (glong) _tmp6_;
		}
	}
	while (TRUE) {
		gboolean _tmp7_;
		GPtrArray* _tmp8_ = NULL;
		GPtrArray* row_data;
		GPtrArray* _tmp9_;
		_tmp7_ = sql_heavy_query_result_get_finished (_result_);
		if (!(!_tmp7_)) {
			break;
		}
		_tmp8_ = g_ptr_array_new_with_free_func (_g_free0_);
		row_data = _tmp8_;
		_tmp9_ = _g_ptr_array_ref0 (row_data);
		g_ptr_array_add (data, _tmp9_);
		{
			gboolean _tmp10_;
			field = 0;
			_tmp10_ = TRUE;
			while (TRUE) {
				gchar* _tmp11_ = NULL;
				gchar* cell;
				gint _tmp12_;
				gint cell_l;
				gchar* _tmp13_;
				if (!_tmp10_) {
					field++;
				}
				_tmp10_ = FALSE;
				if (!(field < field_names_length1)) {
					break;
				}
				_tmp11_ = sql_heavy_record_fetch_string ((SQLHeavyRecord*) _result_, field, &_inner_error_);
				cell = _tmp11_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == SQL_HEAVY_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_ptr_array_unref0 (row_data);
						_g_ptr_array_unref0 (data);
						field_lengths = (g_free (field_lengths), NULL);
						field_names = (_vala_array_free (field_names, field_names_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (_result_);
						return;
					} else {
						_g_ptr_array_unref0 (row_data);
						_g_ptr_array_unref0 (data);
						field_lengths = (g_free (field_lengths), NULL);
						field_names = (_vala_array_free (field_names, field_names_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp12_ = strlen (cell);
				cell_l = _tmp12_;
				if (field_lengths[field] < cell_l) {
					field_lengths[field] = (glong) cell_l;
				}
				_tmp13_ = g_strdup (cell);
				g_ptr_array_add (row_data, _tmp13_);
				_g_free0 (cell);
			}
		}
		sql_heavy_record_set_next ((SQLHeavyRecordSet*) _result_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_ptr_array_unref0 (row_data);
				_g_ptr_array_unref0 (data);
				field_lengths = (g_free (field_lengths), NULL);
				field_names = (_vala_array_free (field_names, field_names_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (_result_);
				return;
			} else {
				_g_ptr_array_unref0 (row_data);
				_g_ptr_array_unref0 (data);
				field_lengths = (g_free (field_lengths), NULL);
				field_names = (_vala_array_free (field_names, field_names_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_ptr_array_unref0 (row_data);
	}
	_tmp14_ = g_string_new ("+");
	sep = _tmp14_;
	{
		gboolean _tmp15_;
		field = 0;
		_tmp15_ = TRUE;
		while (TRUE) {
			if (!_tmp15_) {
				field++;
			}
			_tmp15_ = FALSE;
			if (!(field < field_names_length1)) {
				break;
			}
			{
				gint c;
				c = 0;
				{
					gboolean _tmp16_;
					_tmp16_ = TRUE;
					while (TRUE) {
						if (!_tmp16_) {
							c++;
						}
						_tmp16_ = FALSE;
						if (!(c < (field_lengths[field] + 2))) {
							break;
						}
						g_string_append_c (sep, '-');
					}
				}
			}
			g_string_append_c (sep, '+');
		}
	}
	g_string_append_c (sep, '\n');
	_tmp17_ = g_new0 (gchar*, field_names_length1 + 1);
	field_fmt = _tmp17_;
	field_fmt_length1 = field_names_length1;
	_field_fmt_size_ = field_names_length1;
	fputs (sep->str, fd);
	fputc ('|', fd);
	{
		gboolean _tmp18_;
		field = 0;
		_tmp18_ = TRUE;
		while (TRUE) {
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			if (!_tmp18_) {
				field++;
			}
			_tmp18_ = FALSE;
			if (!(field < field_names_length1)) {
				break;
			}
			_tmp19_ = g_strdup_printf (" %%%lds |", field_lengths[field]);
			_tmp20_ = _tmp19_;
			_g_free0 (field_fmt[field]);
			field_fmt[field] = _tmp20_;
			fprintf (fd, field_fmt[field], field_names[field]);
		}
	}
	fputc ('\n', fd);
	fputs (sep->str, fd);
	{
		gint row_n;
		row_n = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gint _tmp22_;
				gconstpointer _tmp23_ = NULL;
				GPtrArray* _tmp24_;
				GPtrArray* row_data;
				if (!_tmp21_) {
					row_n++;
				}
				_tmp21_ = FALSE;
				_tmp22_ = g_ptr_array_get_length (data);
				if (!(row_n < _tmp22_)) {
					break;
				}
				_tmp23_ = g_ptr_array_index (data, (guint) row_n);
				_tmp24_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp23_);
				row_data = _tmp24_;
				fputc ('|', fd);
				{
					gint col_n;
					col_n = 0;
					{
						gboolean _tmp25_;
						_tmp25_ = TRUE;
						while (TRUE) {
							gint _tmp26_;
							gconstpointer _tmp27_ = NULL;
							if (!_tmp25_) {
								col_n++;
							}
							_tmp25_ = FALSE;
							_tmp26_ = g_ptr_array_get_length (row_data);
							if (!(col_n < _tmp26_)) {
								break;
							}
							_tmp27_ = g_ptr_array_index (row_data, (guint) col_n);
							fprintf (fd, field_fmt[col_n], (const gchar*) _tmp27_);
						}
					}
				}
				fputc ('\n', fd);
				fputs (sep->str, fd);
				_g_ptr_array_unref0 (row_data);
			}
		}
	}
	field_fmt = (_vala_array_free (field_fmt, field_fmt_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (sep);
	_g_ptr_array_unref0 (data);
	field_lengths = (g_free (field_lengths), NULL);
	field_names = (_vala_array_free (field_names, field_names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_result_);
}


static gboolean sql_heavy_query_real_init (SQLHeavyQuery* self, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	SQLHeavyDatabase* _tmp0_ = NULL;
	SQLHeavyDatabase* _tmp1_;
	sqlite3* _tmp2_ = NULL;
	sqlite3* _tmp3_;
	sqlite3* db;
	const gchar* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gint _tmp9_;
	SQLHeavyValueArray* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sql_heavy_queryable_get_database (self->priv->_queryable);
	_tmp1_ = _tmp0_;
	_tmp2_ = sql_heavy_database_get_sqlite_db (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	db = _tmp3_;
	_tmp4_ = sql_heavy_query_get_sql (self);
	_tmp6_ = sqlite3_prepare_v2 (db, _tmp4_, self->priv->_sql_length, &_tmp5_, NULL);
	self->priv->stmt = _tmp5_;
	sql_heavy_error_if_not_ok (_tmp6_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp7_ = sqlite3_sql (self->priv->stmt);
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->_sql);
	self->priv->_sql = _tmp8_;
	_tmp9_ = sqlite3_bind_parameter_count (self->priv->stmt);
	sql_heavy_query_set_parameter_count (self, _tmp9_);
	_tmp10_ = sql_heavy_value_array_new (self->priv->_parameter_count);
	_g_object_unref0 (self->priv->bindings);
	self->priv->bindings = _tmp10_;
	result = TRUE;
	return result;
}


gboolean sql_heavy_query_init (SQLHeavyQuery* self, GCancellable* cancellable, GError** error) {
	return SQL_HEAVY_QUERY_GET_CLASS (self)->init (self, cancellable, error);
}


/**
     * Create a new Query
     *
     * @param queryable the queryable to create the query
     * @param sql the SQL to use to create the query
     */
SQLHeavyQuery* sql_heavy_query_construct (GType object_type, SQLHeavyQueryable* queryable, const gchar* sql, GError** error) {
	SQLHeavyQuery * self = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (queryable != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	self = (SQLHeavyQuery*) g_object_new (object_type, "sql", sql, NULL);
	sql_heavy_query_set_queryable (self, queryable);
	sql_heavy_query_init (self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


SQLHeavyQuery* sql_heavy_query_new (SQLHeavyQueryable* queryable, const gchar* sql, GError** error) {
	return sql_heavy_query_construct (SQL_HEAVY_TYPE_QUERY, queryable, sql, error);
}


/**
     * Create a new Query
     *
     * @param queryable the queryable to create the query
     * @param sql the SQL to use to create the query
     * @param sql_max_len the maximum length of the SQL
     * @param tail unused portion of the SQL
     */
SQLHeavyQuery* sql_heavy_query_construct_full (GType object_type, SQLHeavyQueryable* queryable, const gchar* sql, gint sql_max_len, const gchar** tail, GError** error) {
	const gchar* _tail = NULL;
	SQLHeavyQuery * self = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (queryable != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	self = (SQLHeavyQuery*) g_object_new (object_type, "sql", sql, "sql-length", sql_max_len, NULL);
	sql_heavy_query_set_queryable (self, queryable);
	sql_heavy_query_init (self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if ((&_tail) != NULL) {
		if (self->priv->_sql != NULL) {
			gint _tmp0_;
			_tmp0_ = strlen (self->priv->_sql);
			_tail = (const gchar*) (((gsize) sql) + _tmp0_);
		} else {
			gint _tmp1_;
			GError* _tmp2_ = NULL;
			_tmp1_ = strlen (sql);
			_tail = (const gchar*) (((gsize) sql) + _tmp1_);
			_tmp2_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NO_SQL, "No SQL was provided");
			_inner_error_ = _tmp2_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (self);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	if (tail) {
		*tail = _tail;
	}
	return self;
}


SQLHeavyQuery* sql_heavy_query_new_full (SQLHeavyQueryable* queryable, const gchar* sql, gint sql_max_len, const gchar** tail, GError** error) {
	return sql_heavy_query_construct_full (SQL_HEAVY_TYPE_QUERY, queryable, sql, sql_max_len, tail, error);
}


SQLHeavyQueryable* sql_heavy_query_get_queryable (SQLHeavyQuery* self) {
	SQLHeavyQueryable* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_queryable;
	return result;
}


static void sql_heavy_query_set_queryable (SQLHeavyQuery* self, SQLHeavyQueryable* value) {
	SQLHeavyQueryable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_queryable);
	self->priv->_queryable = _tmp0_;
	g_object_notify ((GObject *) self, "queryable");
}


const gchar* sql_heavy_query_get_sql (SQLHeavyQuery* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sql;
	return result;
}


static void sql_heavy_query_set_sql (SQLHeavyQuery* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_sql);
	self->priv->_sql = _tmp0_;
	g_object_notify ((GObject *) self, "sql");
}


static gint sql_heavy_query_get_sql_length (SQLHeavyQuery* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sql_length;
	return result;
}


static void sql_heavy_query_set_sql_length (SQLHeavyQuery* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_sql_length = value;
	g_object_notify ((GObject *) self, "sql-length");
}


gboolean sql_heavy_query_get_auto_clear (SQLHeavyQuery* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_auto_clear;
	return result;
}


void sql_heavy_query_set_auto_clear (SQLHeavyQuery* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_auto_clear = value;
	g_object_notify ((GObject *) self, "auto-clear");
}


gint sql_heavy_query_get_parameter_count (SQLHeavyQuery* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_parameter_count;
	return result;
}


static void sql_heavy_query_set_parameter_count (SQLHeavyQuery* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_parameter_count = value;
	g_object_notify ((GObject *) self, "parameter-count");
}


static void sql_heavy_query_class_init (SQLHeavyQueryClass * klass) {
	sql_heavy_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyQueryPrivate));
	SQL_HEAVY_QUERY_CLASS (klass)->init = sql_heavy_query_real_init;
	G_OBJECT_CLASS (klass)->get_property = _vala_sql_heavy_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sql_heavy_query_set_property;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_query_finalize;
	/**
	     * The queryable asscociated with this query
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_QUERYABLE, g_param_spec_object ("queryable", "queryable", "queryable", SQL_HEAVY_TYPE_QUERYABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The SQL used to create this query 
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_SQL, g_param_spec_string ("sql", "sql", "sql", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The maximum length of the SQL used to create this query
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_SQL_LENGTH, g_param_spec_int ("sql-length", "sql-length", "sql-length", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * When set the bindings will automatically be cleared when an
	     * associated {@link QueryResult} is destroyed.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_AUTO_CLEAR, g_param_spec_boolean ("auto-clear", "auto-clear", "auto-clear", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The number of parameters in the query.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_PARAMETER_COUNT, g_param_spec_int ("parameter-count", "parameter-count", "parameter-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sql_heavy_query_g_initable_interface_init (GInitableIface * iface) {
	sql_heavy_query_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*)(GInitable* ,GCancellable* ,GError**)) sql_heavy_query_init;
}


static void sql_heavy_query_instance_init (SQLHeavyQuery * self) {
	self->priv = SQL_HEAVY_QUERY_GET_PRIVATE (self);
	self->priv->_sql_length = -1;
	g_static_rec_mutex_init (&self->priv->__lock_stmt);
	self->priv->stmt = NULL;
	self->priv->stmt_in_use = FALSE;
	self->priv->bindings = NULL;
	self->priv->_auto_clear = FALSE;
	self->priv->_parameter_count = 0;
}


static void sql_heavy_query_finalize (GObject* obj) {
	SQLHeavyQuery * self;
	self = SQL_HEAVY_QUERY (obj);
	_g_object_unref0 (self->priv->_queryable);
	_g_free0 (self->priv->_sql);
	g_static_rec_mutex_free (&self->priv->__lock_stmt);
	_g_object_unref0 (self->priv->bindings);
	G_OBJECT_CLASS (sql_heavy_query_parent_class)->finalize (obj);
}


/**
   * A prepared statement
   */
GType sql_heavy_query_get_type (void) {
	static volatile gsize sql_heavy_query_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyQuery), 0, (GInstanceInitFunc) sql_heavy_query_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) sql_heavy_query_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sql_heavy_query_type_id;
		sql_heavy_query_type_id = g_type_register_static (G_TYPE_OBJECT, "SQLHeavyQuery", &g_define_type_info, 0);
		g_type_add_interface_static (sql_heavy_query_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&sql_heavy_query_type_id__volatile, sql_heavy_query_type_id);
	}
	return sql_heavy_query_type_id__volatile;
}


static void _vala_sql_heavy_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SQLHeavyQuery * self;
	self = SQL_HEAVY_QUERY (object);
	switch (property_id) {
		case SQL_HEAVY_QUERY_QUERYABLE:
		g_value_set_object (value, sql_heavy_query_get_queryable (self));
		break;
		case SQL_HEAVY_QUERY_SQL:
		g_value_set_string (value, sql_heavy_query_get_sql (self));
		break;
		case SQL_HEAVY_QUERY_SQL_LENGTH:
		g_value_set_int (value, sql_heavy_query_get_sql_length (self));
		break;
		case SQL_HEAVY_QUERY_AUTO_CLEAR:
		g_value_set_boolean (value, sql_heavy_query_get_auto_clear (self));
		break;
		case SQL_HEAVY_QUERY_PARAMETER_COUNT:
		g_value_set_int (value, sql_heavy_query_get_parameter_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sql_heavy_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SQLHeavyQuery * self;
	self = SQL_HEAVY_QUERY (object);
	switch (property_id) {
		case SQL_HEAVY_QUERY_QUERYABLE:
		sql_heavy_query_set_queryable (self, g_value_get_object (value));
		break;
		case SQL_HEAVY_QUERY_SQL:
		sql_heavy_query_set_sql (self, g_value_get_string (value));
		break;
		case SQL_HEAVY_QUERY_SQL_LENGTH:
		sql_heavy_query_set_sql_length (self, g_value_get_int (value));
		break;
		case SQL_HEAVY_QUERY_AUTO_CLEAR:
		sql_heavy_query_set_auto_clear (self, g_value_get_boolean (value));
		break;
		case SQL_HEAVY_QUERY_PARAMETER_COUNT:
		sql_heavy_query_set_parameter_count (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



