/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2009 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBSTATS_SEEN
#define PDBSTATS_SEEN

#include "pdbMalloc.h"

void
CalcStats(CoordsArray *cdsA);

void
CalcPreStats(CoordsArray *cdsA);

void
CopyStats(CoordsArray *cdsA1, CoordsArray *cdsA2);

void
CalcDf(CoordsArray *cdsA);

double
VarianceCoords(CoordsArray *cdsA);

double
VarianceCoordsOcc(CoordsArray *cdsA);

double
VarianceCoordsFullAx(CoordsArray *cdsA);

void
WriteTransformations(CoordsArray *cdsA, char *outfile_name);

void
WriteVariance(CoordsArray *cdsA, char *outfile_name);

void
Bfacts2PrVars(CoordsArray *cdsA, int coord);

double
CalcPRMSD(CoordsArray *cdsA);

double
CalcMLRMSD(CoordsArray *cdsA);

double
SqrCoordsDist(const Coords *coords1, const int atom1, const Coords *coords2, const int atom2);

double
SqrCoordsDistMahal(const Coords *coords1, const int atom1,
                   const Coords *coords2, const int atom2,
                   const double *weights);

double
SqrCoordsDistMahal2(const Coords *coords1, const int atom1,
                    const Coords *coords2, const int atom2,
                    const double weight);

double
SqrPDBCoordsDist(PDBCoords *coords1, int atom1, PDBCoords *coords2, int atom2);

double
CoordsDist(Coords *coords1, int atom1, Coords *coords2, int atom2);

double
VecMag(const double *vec);

double
CoordMag(const Coords *coords, const int vec);

double
SqrCoordMag(const Coords *coords, const int vec);

double
CoordMult(const Coords *coords1, const Coords *coords2, const int vec);

double
RadiusGyration(Coords *coords, const double *weights);

double
TraceCoords(const Coords *coords1, const Coords *coords2, const double *weights);

void
CalcResiduals(CoordsArray *cdsA);

void
StudentizeResiduals(CoordsArray *cdsA);

void
PrintResiduals(CoordsArray *cdsA);

void
WriteResiduals(CoordsArray *cdsA, char *outfile_name);

double
Durbin_Watson(CoordsArray *cdsA);

void
ExpectationVector(CoordsArray *cdsA);

void
MomentsCoords(CoordsArray *cdsA);

void
SkewnessCoords(CoordsArray *cdsA);

void
KurtosisCoords(CoordsArray *cdsA);

double
CoordxMatxCoord(const double *v1, const double *v2, const double **sigma);

double
CalcANOVAF(CoordsArray *cdsA);

double
CalcHierarchLogL(CoordsArray *cdsA);

double
CalcLogL(CoordsArray *cdsA);

double
CalcParamNum(CoordsArray *cdsA);

void
CalcAIC(CoordsArray *cdsA);

void
CalcBIC(CoordsArray *cdsA);

double
TrCoordsInnerProd(Coords *coords, const int len);

double
TrCoordsInnerProdWt(Coords *coords, const int len, const double *w);

double
TrCoordsInnerProd2(Coords *cds1, Coords *cds2, const int len);

double
TrCoordsInnerProdWt2(Coords *cds1, Coords *cds2, const int len, const double *w);

void
UnbiasMean(CoordsArray *scratchA);

void
CalcNormResiduals(CoordsArray *cdsA);

void
CalcNormResidualsLS(CoordsArray *cdsA);

double
FrobTerm(CoordsArray *cdsA);

#endif
