/*	$NetBSD: octeon_corereg.h,v 1.5 2020/08/04 01:59:46 simonb Exp $	*/

/*
 * Copyright (c) 2007 Internet Initiative Japan, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _OCTEON_COREREG_H_
#define _OCTEON_COREREG_H_

/* ---- register bits */

/*
 * Cavium Networks-Specific Coprocessor 0 Registers
 */

/* CacheErr (Icache) */

#define	CP0_CACHEERRI_XXX_63_55			UINT64_C(0xff80000000000000)
#define	CP0_CACHEERRI_BADCOLF			UINT64_C(0x007f000000000000)
#define	CP0_CACHEERRI_XXX_47			UINT64_C(0x0000800000000000)
#define	CP0_CACHEERRI_BADCOL			UINT64_C(0x00007f0000000000)
#define	CP0_CACHEERRI_XXX_39_37			UINT64_C(0x000000e000000000)
#define	CP0_CACHEERRI_LRUFAIL			UINT64_C(0x0000001000000000)
#define	CP0_CACHEERRI_AESFAIL			UINT64_C(0x0000000800000000)
#define	CP0_CACHEERRI_HSHFAIL			UINT64_C(0x0000000400000000)
#define	CP0_CACHEERRI_BHTBROKE			UINT64_C(0x0000000200000000)
#define	CP0_CACHEERRI_ICBROKE			UINT64_C(0x0000000100000000)
#define	CP0_CACHEERRI_XXX_31_15			UINT64_C(0x00000000ffff8000)
#define	CP0_CACHEERRI_QW			UINT64_C(0x0000000000006000)
#define	CP0_CACHEERRI_ROW			UINT64_C(0x0000000000001800)
#define	CP0_CACHEERRI_SET			UINT64_C(0x00000000000007e0)
#define	CP0_CACHEERRI_WAY			UINT64_C(0x0000000000000018)
#define	CP0_CACHEERRI_XXX_2_1			UINT64_C(0x0000000000000006)
#define	CP0_CACHEERRI_DPERR			UINT64_C(0x0000000000000001)

/* CacheErr (Dcache) */

#define	CP0_CACHEERRD_XXX_63_13			UINT64_C(0xffffffffffffe000)
#define	CP0_CACHEERRD_SET			UINT64_C(0x0000000000001f80)
#define	CP0_CACHEERRD_VA63			UINT64_C(0x0000000000000078)
#define	CP0_CACHEERRD_XXX_2_1			UINT64_C(0x0000000000000006)
#define	CP0_CACHEERRD_PERR			UINT64_C(0x0000000000000001)

/* TagLo Register (Icache) */

#define	CP0_TAGLOI_R				UINT64_C(0xc000000000000000)
#define	CP0_TAGLOI_XXX_61_60			UINT64_C(0x3000000000000000)
#define	CP0_TAGLOI_ASID				UINT64_C(0x0f00000000000000)
#define	CP0_TAGLOI_XXX_51_49			UINT64_C(0x00f0000000000000)
#define	CP0_TAGLOI_TAG				UINT64_C(0x000fffffffffe000)
#define	CP0_TAGLOI_INDEX			UINT64_C(0x0000000000001f80)
#define	CP0_TAGLOI_XXX_6_2			UINT64_C(0x000000000000007c)
#define	CP0_TAGLOI_G				UINT64_C(0x0000000000000002)
#define	CP0_TAGLOI_VALID			UINT64_C(0x0000000000000001)

/* TagLo Register (Dcache) */

#define	CP0_TAGLOD_R				UINT64_C(0xc000000000000000)
#define	CP0_TAGLOD_XXX_61_60			UINT64_C(0x3000000000000000)
#define	CP0_TAGLOD_ASID				UINT64_C(0x0f00000000000000)
#define	CP0_TAGLOD_XXX_51_49			UINT64_C(0x00f0000000000000)
#define	CP0_TAGLOD_TAG				UINT64_C(0x000fffffffffff80)
#define	CP0_TAGLOD_XXX_6_2			UINT64_C(0x000000000000007c)
#define	CP0_TAGLOD_G				UINT64_C(0x0000000000000002)
#define	CP0_TAGLOD_VALID			UINT64_C(0x0000000000000001)

/* CvmCtl Register */
/* CVMCTL_STEPRATE to CVMCTL_TLBBRFTDIS are available on cnMIPS III cores */

#define	CP0_CVMCTL_XXX_63_43			UINT64_C(0xfffff80000000000)
#define	CP0_CVMCTL_STEPRATE			UINT64_C(0x0000078000000000)
#define	CP0_CVMCTL_ZUC				UINT64_C(0x0000004000000000)
#define	CP0_CVMCTL_CAMELLIA			UINT64_C(0x0000002000000000)
#define	CP0_CVMCTL_USEMAK			UINT64_C(0x0000001000000000)
#define	CP0_CVMCTL_SMS4				UINT64_C(0x0000000800000000)
#define	CP0_CVMCTL_DISABLEPAUSE			UINT64_C(0x0000000400000000)
#define	CP0_CVMCTL_SNOW3G			UINT64_C(0x0000000200000000)
#define	CP0_CVMCTL_TLBBRFTDIS			UINT64_C(0x0000000100000000)
#define	CP0_CVMCTL_FUSE_STARTBIT		UINT64_C(0x0000000080000000)
#define	CP0_CVMCTL_XXX_30			UINT64_C(0x0000000040000000)
#define	CP0_CVMCTL_KASUMI			UINT64_C(0x0000000020000000)
#define	CP0_CVMCTL_NODFA_CP21			UINT64_C(0x0000000010000000)
#define	CP0_CVMCTL_NOMUL			UINT64_C(0x0000000008000000)
#define	CP0_CVMCTL_NOCRYPTO			UINT64_C(0x0000000004000000)
#define	CP0_CVMCTL_RST_SHT			UINT64_C(0x0000000002000000)
#define	CP0_CVMCTL_BIST_DIS			UINT64_C(0x0000000001000000)
#define	CP0_CVMCTL_DISSETPRED			UINT64_C(0x0000000000800000)
#define	CP0_CVMCTL_DISJRPRED			UINT64_C(0x0000000000400000)
#define	CP0_CVMCTL_DISICACHE			UINT64_C(0x0000000000200000)
#define	CP0_CVMCTL_DISWAIT			UINT64_C(0x0000000000100000)
#define	CP0_CVMCTL_DEFET			UINT64_C(0x0000000000080000)
#define	CP0_CVMCTL_DISCO			UINT64_C(0x0000000000040000)
#define	CP0_CVMCTL_DISCE			UINT64_C(0x0000000000020000)
#define	CP0_CVMCTL_DDCLK			UINT64_C(0x0000000000010000)
#define	CP0_CVMCTL_DCICLK			UINT64_C(0x0000000000008000)
#define	CP0_CVMCTL_REPUN			UINT64_C(0x0000000000004000)
#define	CP0_CVMCTL_IPREF			UINT64_C(0x0000000000002000)
#define	CP0_CVMCTL_USEUN			UINT64_C(0x0000000000001000)
#define	CP0_CVMCTL_DISIOCACHE			UINT64_C(0x0000000000000800)
#define	CP0_CVMCTL_IRAND			UINT64_C(0x0000000000000400)
#define	CP0_CVMCTL_IPPCI			UINT64_C(0x0000000000000380)
#define	CP0_CVMCTL_IPTI				UINT64_C(0x0000000000000070)
#define	CP0_CVMCTL_XXX_3_2			UINT64_C(0x000000000000000c)
#define	CP0_CVMCTL_LE				UINT64_C(0x0000000000000002)
#define	CP0_CVMCTL_USELY			UINT64_C(0x0000000000000001)

/* CvmMemCtl Register */

#define	CP0_CVMMEMCTL_TLBBIST			UINT64_C(0x8000000000000000)
#define	CP0_CVMMEMCTL_L1CBIST			UINT64_C(0x4000000000000000)
#define	CP0_CVMMEMCTL_L1DBIST			UINT64_C(0x2000000000000000)
#define	CP0_CVMMEMCTL_DCMBIST			UINT64_C(0x1000000000000000)
#define	CP0_CVMMEMCTL_PTGBIST			UINT64_C(0x0800000000000000)
#define	CP0_CVMMEMCTL_WBFBIST			UINT64_C(0x0400000000000000)
#define	CP0_CVMMEMCTL_XXX_57_36			UINT64_C(0x03fffff000000000)
#define	CP0_CVMMEMCTL_DISMARKWBLONGTO		UINT64_C(0x0000000800000000)
#define	CP0_CVMMEMCTL_DISMRGCLRWBTO		UINT64_C(0x0000000400000000)
#define	CP0_CVMMEMCTL_IOBDMASCRMSB		UINT64_C(0x0000000300000000)
#define	CP0_CVMMEMCTL_SYNCWSMARKED		UINT64_C(0x0000000080000000)
#define	CP0_CVMMEMCTL_DISSYNCWS			UINT64_C(0x0000000040000000)
#define	CP0_CVMMEMCTL_DISWBFST			UINT64_C(0x0000000020000000)
#define	CP0_CVMMEMCTL_XKMEMENAS			UINT64_C(0x0000000010000000)
#define	CP0_CVMMEMCTL_XKMEMENAU			UINT64_C(0x0000000008000000)
#define	CP0_CVMMEMCTL_XKIOENAS			UINT64_C(0x0000000004000000)
#define	CP0_CVMMEMCTL_XKIOENAU			UINT64_C(0x0000000002000000)
#define	CP0_CVMMEMCTL_ALLSYNCW			UINT64_C(0x0000000001000000)
#define	CP0_CVMMEMCTL_NOMERGE			UINT64_C(0x0000000000800000)
#define	CP0_CVMMEMCTL_DIDTTO			UINT64_C(0x0000000000600000)
#define	CP0_CVMMEMCTL_CSRCLKALWYS		UINT64_C(0x0000000000100000)
#define	CP0_CVMMEMCTL_MCLKALWYS			UINT64_C(0x0000000000080000)
#define	CP0_CVMMEMCTL_WBFLTIME			UINT64_C(0x0000000000070000)
#define	CP0_CVMMEMCTL_ISTRNOL2			UINT64_C(0x0000000000008000)
#define	CP0_CVMMEMCTL_WBTHRESH			UINT64_C(0x0000000000007800)
#define	CP0_CVMMEMCTL_XXX_10_9			UINT64_C(0x0000000000000600)
#define	CP0_CVMMEMCTL_CVMSEGENAK		UINT64_C(0x0000000000000100)
#define	CP0_CVMMEMCTL_CVMSEGENAS		UINT64_C(0x0000000000000080)
#define	CP0_CVMMEMCTL_CVMSEGENAU		UINT64_C(0x0000000000000040)
#define	CP0_CVMMEMCTL_LMEMSZ			UINT64_C(0x000000000000003f)

/* CvmCount Register */

/* Multi-Core Debug Register */

#define	CP0_MCD_XXX_63_17			UINT64_C(0xfffffffffffe0000)
#define	CP0_MCD_DEXCC				UINT64_C(0x0000000000010000)
#define	CP0_MCD_CGSTP				UINT64_C(0x0000000000008000)
#define	CP0_MCD_CVGSTP				UINT64_C(0x0000000000004000)
#define	CP0_MCD_CVDM				UINT64_C(0x0000000000002000)
#define	CP0_MCD_GSDB				UINT64_C(0x0000000000001000)
#define	CP0_MCD_XXX_11				UINT64_C(0x0000000000000800)
#define	CP0_MCD_MSKM2				UINT64_C(0x0000000000000400)
#define	CP0_MCD_MSKM1				UINT64_C(0x0000000000000200)
#define	CP0_MCD_MMC0				UINT64_C(0x0000000000000100)
#define	CP0_MCD_XXX_7				UINT64_C(0x0000000000000080)
#define	CP0_MCD_PLS2				UINT64_C(0x0000000000000040)
#define	CP0_MCD_PLS1				UINT64_C(0x0000000000000020)
#define	CP0_MCD_PLS0				UINT64_C(0x0000000000000010)
#define	CP0_MCD_XXX_3				UINT64_C(0x0000000000000008)
#define	CP0_MCD_MCD2				UINT64_C(0x0000000000000004)
#define	CP0_MCD_MCD1				UINT64_C(0x0000000000000002)
#define	CP0_MCD_MCD0				UINT64_C(0x0000000000000001)

/* ---- operations */

/*
 * OCTEON Configuration and Status Registers (CSRs)
 */

#define	CSR_COP0			/* Core coprosessor 0 registers */
#define	CSR_COP2			/* Core coprosessor 2 registers */
#define	CSR_COREEJTAG			/* Core EJTAG registers */
#define	CSR_COREEJTAGTAP		/* Core EJTAG TAP registers */
#define	CSR_NCB				/* NCB registers */
#define	CSR_RSL				/* RSL registers */
#define	CSR_PCICONFIG			/* PCICONFIG registers */
#define	CSR_PCI				/* PCI registers */
#define	CSR_PCINCB			/* PCI_NCB registers */
#define	CSR_JTAGTAP			/* JTAG TAP registers */
#define	CSR_TWSICORE			/* TWSI Core registers */

/* XXX */

#endif /* _OCTEON_COREREG_H_ */
