/*	$NetBSD: uvd_5_0_sh_mask.h,v 1.3 2021/12/18 23:45:24 riastradh Exp $	*/

/*
 * UVD_5_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef UVD_5_0_SH_MASK_H
#define UVD_5_0_SH_MASK_H

#define UVD_SEMA_ADDR_LOW__ADDR_22_3_MASK 0xfffff
#define UVD_SEMA_ADDR_LOW__ADDR_22_3__SHIFT 0x0
#define UVD_SEMA_ADDR_HIGH__ADDR_42_23_MASK 0xfffff
#define UVD_SEMA_ADDR_HIGH__ADDR_42_23__SHIFT 0x0
#define UVD_SEMA_CMD__REQ_CMD_MASK 0xf
#define UVD_SEMA_CMD__REQ_CMD__SHIFT 0x0
#define UVD_SEMA_CMD__WR_PHASE_MASK 0x30
#define UVD_SEMA_CMD__WR_PHASE__SHIFT 0x4
#define UVD_SEMA_CMD__MODE_MASK 0x40
#define UVD_SEMA_CMD__MODE__SHIFT 0x6
#define UVD_SEMA_CMD__VMID_EN_MASK 0x80
#define UVD_SEMA_CMD__VMID_EN__SHIFT 0x7
#define UVD_SEMA_CMD__VMID_MASK 0xf00
#define UVD_SEMA_CMD__VMID__SHIFT 0x8
#define UVD_GPCOM_VCPU_CMD__CMD_SEND_MASK 0x1
#define UVD_GPCOM_VCPU_CMD__CMD_SEND__SHIFT 0x0
#define UVD_GPCOM_VCPU_CMD__CMD_MASK 0x7ffffffe
#define UVD_GPCOM_VCPU_CMD__CMD__SHIFT 0x1
#define UVD_GPCOM_VCPU_CMD__CMD_SOURCE_MASK 0x80000000
#define UVD_GPCOM_VCPU_CMD__CMD_SOURCE__SHIFT 0x1f
#define UVD_GPCOM_VCPU_DATA0__DATA0_MASK 0xffffffff
#define UVD_GPCOM_VCPU_DATA0__DATA0__SHIFT 0x0
#define UVD_GPCOM_VCPU_DATA1__DATA1_MASK 0xffffffff
#define UVD_GPCOM_VCPU_DATA1__DATA1__SHIFT 0x0
#define UVD_ENGINE_CNTL__ENGINE_START_MASK 0x1
#define UVD_ENGINE_CNTL__ENGINE_START__SHIFT 0x0
#define UVD_ENGINE_CNTL__ENGINE_START_MODE_MASK 0x2
#define UVD_ENGINE_CNTL__ENGINE_START_MODE__SHIFT 0x1
#define UVD_UDEC_ADDR_CONFIG__NUM_PIPES_MASK 0x7
#define UVD_UDEC_ADDR_CONFIG__NUM_PIPES__SHIFT 0x0
#define UVD_UDEC_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define UVD_UDEC_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define UVD_UDEC_ADDR_CONFIG__BANK_INTERLEAVE_SIZE_MASK 0x700
#define UVD_UDEC_ADDR_CONFIG__BANK_INTERLEAVE_SIZE__SHIFT 0x8
#define UVD_UDEC_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK 0x3000
#define UVD_UDEC_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT 0xc
#define UVD_UDEC_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE_MASK 0x70000
#define UVD_UDEC_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE__SHIFT 0x10
#define UVD_UDEC_ADDR_CONFIG__NUM_GPUS_MASK 0x700000
#define UVD_UDEC_ADDR_CONFIG__NUM_GPUS__SHIFT 0x14
#define UVD_UDEC_ADDR_CONFIG__MULTI_GPU_TILE_SIZE_MASK 0x3000000
#define UVD_UDEC_ADDR_CONFIG__MULTI_GPU_TILE_SIZE__SHIFT 0x18
#define UVD_UDEC_ADDR_CONFIG__ROW_SIZE_MASK 0x30000000
#define UVD_UDEC_ADDR_CONFIG__ROW_SIZE__SHIFT 0x1c
#define UVD_UDEC_ADDR_CONFIG__NUM_LOWER_PIPES_MASK 0x40000000
#define UVD_UDEC_ADDR_CONFIG__NUM_LOWER_PIPES__SHIFT 0x1e
#define UVD_UDEC_DB_ADDR_CONFIG__NUM_PIPES_MASK 0x7
#define UVD_UDEC_DB_ADDR_CONFIG__NUM_PIPES__SHIFT 0x0
#define UVD_UDEC_DB_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define UVD_UDEC_DB_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define UVD_UDEC_DB_ADDR_CONFIG__BANK_INTERLEAVE_SIZE_MASK 0x700
#define UVD_UDEC_DB_ADDR_CONFIG__BANK_INTERLEAVE_SIZE__SHIFT 0x8
#define UVD_UDEC_DB_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK 0x3000
#define UVD_UDEC_DB_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT 0xc
#define UVD_UDEC_DB_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE_MASK 0x70000
#define UVD_UDEC_DB_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE__SHIFT 0x10
#define UVD_UDEC_DB_ADDR_CONFIG__NUM_GPUS_MASK 0x700000
#define UVD_UDEC_DB_ADDR_CONFIG__NUM_GPUS__SHIFT 0x14
#define UVD_UDEC_DB_ADDR_CONFIG__MULTI_GPU_TILE_SIZE_MASK 0x3000000
#define UVD_UDEC_DB_ADDR_CONFIG__MULTI_GPU_TILE_SIZE__SHIFT 0x18
#define UVD_UDEC_DB_ADDR_CONFIG__ROW_SIZE_MASK 0x30000000
#define UVD_UDEC_DB_ADDR_CONFIG__ROW_SIZE__SHIFT 0x1c
#define UVD_UDEC_DB_ADDR_CONFIG__NUM_LOWER_PIPES_MASK 0x40000000
#define UVD_UDEC_DB_ADDR_CONFIG__NUM_LOWER_PIPES__SHIFT 0x1e
#define UVD_UDEC_DBW_ADDR_CONFIG__NUM_PIPES_MASK 0x7
#define UVD_UDEC_DBW_ADDR_CONFIG__NUM_PIPES__SHIFT 0x0
#define UVD_UDEC_DBW_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define UVD_UDEC_DBW_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define UVD_UDEC_DBW_ADDR_CONFIG__BANK_INTERLEAVE_SIZE_MASK 0x700
#define UVD_UDEC_DBW_ADDR_CONFIG__BANK_INTERLEAVE_SIZE__SHIFT 0x8
#define UVD_UDEC_DBW_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK 0x3000
#define UVD_UDEC_DBW_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT 0xc
#define UVD_UDEC_DBW_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE_MASK 0x70000
#define UVD_UDEC_DBW_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE__SHIFT 0x10
#define UVD_UDEC_DBW_ADDR_CONFIG__NUM_GPUS_MASK 0x700000
#define UVD_UDEC_DBW_ADDR_CONFIG__NUM_GPUS__SHIFT 0x14
#define UVD_UDEC_DBW_ADDR_CONFIG__MULTI_GPU_TILE_SIZE_MASK 0x3000000
#define UVD_UDEC_DBW_ADDR_CONFIG__MULTI_GPU_TILE_SIZE__SHIFT 0x18
#define UVD_UDEC_DBW_ADDR_CONFIG__ROW_SIZE_MASK 0x30000000
#define UVD_UDEC_DBW_ADDR_CONFIG__ROW_SIZE__SHIFT 0x1c
#define UVD_UDEC_DBW_ADDR_CONFIG__NUM_LOWER_PIPES_MASK 0x40000000
#define UVD_UDEC_DBW_ADDR_CONFIG__NUM_LOWER_PIPES__SHIFT 0x1e
#define UVD_LMI_RBC_RB_64BIT_BAR_LOW__BITS_31_0_MASK 0xffffffff
#define UVD_LMI_RBC_RB_64BIT_BAR_LOW__BITS_31_0__SHIFT 0x0
#define UVD_LMI_RBC_RB_64BIT_BAR_HIGH__BITS_63_32_MASK 0xffffffff
#define UVD_LMI_RBC_RB_64BIT_BAR_HIGH__BITS_63_32__SHIFT 0x0
#define UVD_LMI_RBC_IB_64BIT_BAR_LOW__BITS_31_0_MASK 0xffffffff
#define UVD_LMI_RBC_IB_64BIT_BAR_LOW__BITS_31_0__SHIFT 0x0
#define UVD_LMI_RBC_IB_64BIT_BAR_HIGH__BITS_63_32_MASK 0xffffffff
#define UVD_LMI_RBC_IB_64BIT_BAR_HIGH__BITS_63_32__SHIFT 0x0
#define UVD_LMI_VCPU_CACHE_64BIT_BAR_LOW__BITS_31_0_MASK 0xffffffff
#define UVD_LMI_VCPU_CACHE_64BIT_BAR_LOW__BITS_31_0__SHIFT 0x0
#define UVD_LMI_VCPU_CACHE_64BIT_BAR_HIGH__BITS_63_32_MASK 0xffffffff
#define UVD_LMI_VCPU_CACHE_64BIT_BAR_HIGH__BITS_63_32__SHIFT 0x0
#define UVD_SEMA_CNTL__SEMAPHORE_EN_MASK 0x1
#define UVD_SEMA_CNTL__SEMAPHORE_EN__SHIFT 0x0
#define UVD_SEMA_CNTL__ADVANCED_MODE_DIS_MASK 0x2
#define UVD_SEMA_CNTL__ADVANCED_MODE_DIS__SHIFT 0x1
#define UVD_LMI_EXT40_ADDR__ADDR_MASK 0xff
#define UVD_LMI_EXT40_ADDR__ADDR__SHIFT 0x0
#define UVD_LMI_EXT40_ADDR__INDEX_MASK 0x1f0000
#define UVD_LMI_EXT40_ADDR__INDEX__SHIFT 0x10
#define UVD_LMI_EXT40_ADDR__WRITE_ADDR_MASK 0x80000000
#define UVD_LMI_EXT40_ADDR__WRITE_ADDR__SHIFT 0x1f
#define UVD_CTX_INDEX__INDEX_MASK 0x1ff
#define UVD_CTX_INDEX__INDEX__SHIFT 0x0
#define UVD_CTX_DATA__DATA_MASK 0xffffffff
#define UVD_CTX_DATA__DATA__SHIFT 0x0
#define UVD_CGC_GATE__SYS_MASK 0x1
#define UVD_CGC_GATE__SYS__SHIFT 0x0
#define UVD_CGC_GATE__UDEC_MASK 0x2
#define UVD_CGC_GATE__UDEC__SHIFT 0x1
#define UVD_CGC_GATE__MPEG2_MASK 0x4
#define UVD_CGC_GATE__MPEG2__SHIFT 0x2
#define UVD_CGC_GATE__REGS_MASK 0x8
#define UVD_CGC_GATE__REGS__SHIFT 0x3
#define UVD_CGC_GATE__RBC_MASK 0x10
#define UVD_CGC_GATE__RBC__SHIFT 0x4
#define UVD_CGC_GATE__LMI_MC_MASK 0x20
#define UVD_CGC_GATE__LMI_MC__SHIFT 0x5
#define UVD_CGC_GATE__LMI_UMC_MASK 0x40
#define UVD_CGC_GATE__LMI_UMC__SHIFT 0x6
#define UVD_CGC_GATE__IDCT_MASK 0x80
#define UVD_CGC_GATE__IDCT__SHIFT 0x7
#define UVD_CGC_GATE__MPRD_MASK 0x100
#define UVD_CGC_GATE__MPRD__SHIFT 0x8
#define UVD_CGC_GATE__MPC_MASK 0x200
#define UVD_CGC_GATE__MPC__SHIFT 0x9
#define UVD_CGC_GATE__LBSI_MASK 0x400
#define UVD_CGC_GATE__LBSI__SHIFT 0xa
#define UVD_CGC_GATE__LRBBM_MASK 0x800
#define UVD_CGC_GATE__LRBBM__SHIFT 0xb
#define UVD_CGC_GATE__UDEC_RE_MASK 0x1000
#define UVD_CGC_GATE__UDEC_RE__SHIFT 0xc
#define UVD_CGC_GATE__UDEC_CM_MASK 0x2000
#define UVD_CGC_GATE__UDEC_CM__SHIFT 0xd
#define UVD_CGC_GATE__UDEC_IT_MASK 0x4000
#define UVD_CGC_GATE__UDEC_IT__SHIFT 0xe
#define UVD_CGC_GATE__UDEC_DB_MASK 0x8000
#define UVD_CGC_GATE__UDEC_DB__SHIFT 0xf
#define UVD_CGC_GATE__UDEC_MP_MASK 0x10000
#define UVD_CGC_GATE__UDEC_MP__SHIFT 0x10
#define UVD_CGC_GATE__WCB_MASK 0x20000
#define UVD_CGC_GATE__WCB__SHIFT 0x11
#define UVD_CGC_GATE__VCPU_MASK 0x40000
#define UVD_CGC_GATE__VCPU__SHIFT 0x12
#define UVD_CGC_GATE__SCPU_MASK 0x80000
#define UVD_CGC_GATE__SCPU__SHIFT 0x13
#define UVD_CGC_GATE__JPEG_MASK 0x100000
#define UVD_CGC_GATE__JPEG__SHIFT 0x14
#define UVD_CGC_GATE__JPEG2_MASK 0x200000
#define UVD_CGC_GATE__JPEG2__SHIFT 0x15
#define UVD_CGC_STATUS__SYS_SCLK_MASK 0x1
#define UVD_CGC_STATUS__SYS_SCLK__SHIFT 0x0
#define UVD_CGC_STATUS__SYS_DCLK_MASK 0x2
#define UVD_CGC_STATUS__SYS_DCLK__SHIFT 0x1
#define UVD_CGC_STATUS__SYS_VCLK_MASK 0x4
#define UVD_CGC_STATUS__SYS_VCLK__SHIFT 0x2
#define UVD_CGC_STATUS__UDEC_SCLK_MASK 0x8
#define UVD_CGC_STATUS__UDEC_SCLK__SHIFT 0x3
#define UVD_CGC_STATUS__UDEC_DCLK_MASK 0x10
#define UVD_CGC_STATUS__UDEC_DCLK__SHIFT 0x4
#define UVD_CGC_STATUS__UDEC_VCLK_MASK 0x20
#define UVD_CGC_STATUS__UDEC_VCLK__SHIFT 0x5
#define UVD_CGC_STATUS__MPEG2_SCLK_MASK 0x40
#define UVD_CGC_STATUS__MPEG2_SCLK__SHIFT 0x6
#define UVD_CGC_STATUS__MPEG2_DCLK_MASK 0x80
#define UVD_CGC_STATUS__MPEG2_DCLK__SHIFT 0x7
#define UVD_CGC_STATUS__MPEG2_VCLK_MASK 0x100
#define UVD_CGC_STATUS__MPEG2_VCLK__SHIFT 0x8
#define UVD_CGC_STATUS__REGS_SCLK_MASK 0x200
#define UVD_CGC_STATUS__REGS_SCLK__SHIFT 0x9
#define UVD_CGC_STATUS__REGS_VCLK_MASK 0x400
#define UVD_CGC_STATUS__REGS_VCLK__SHIFT 0xa
#define UVD_CGC_STATUS__RBC_SCLK_MASK 0x800
#define UVD_CGC_STATUS__RBC_SCLK__SHIFT 0xb
#define UVD_CGC_STATUS__LMI_MC_SCLK_MASK 0x1000
#define UVD_CGC_STATUS__LMI_MC_SCLK__SHIFT 0xc
#define UVD_CGC_STATUS__LMI_UMC_SCLK_MASK 0x2000
#define UVD_CGC_STATUS__LMI_UMC_SCLK__SHIFT 0xd
#define UVD_CGC_STATUS__IDCT_SCLK_MASK 0x4000
#define UVD_CGC_STATUS__IDCT_SCLK__SHIFT 0xe
#define UVD_CGC_STATUS__IDCT_VCLK_MASK 0x8000
#define UVD_CGC_STATUS__IDCT_VCLK__SHIFT 0xf
#define UVD_CGC_STATUS__MPRD_SCLK_MASK 0x10000
#define UVD_CGC_STATUS__MPRD_SCLK__SHIFT 0x10
#define UVD_CGC_STATUS__MPRD_DCLK_MASK 0x20000
#define UVD_CGC_STATUS__MPRD_DCLK__SHIFT 0x11
#define UVD_CGC_STATUS__MPRD_VCLK_MASK 0x40000
#define UVD_CGC_STATUS__MPRD_VCLK__SHIFT 0x12
#define UVD_CGC_STATUS__MPC_SCLK_MASK 0x80000
#define UVD_CGC_STATUS__MPC_SCLK__SHIFT 0x13
#define UVD_CGC_STATUS__MPC_DCLK_MASK 0x100000
#define UVD_CGC_STATUS__MPC_DCLK__SHIFT 0x14
#define UVD_CGC_STATUS__LBSI_SCLK_MASK 0x200000
#define UVD_CGC_STATUS__LBSI_SCLK__SHIFT 0x15
#define UVD_CGC_STATUS__LBSI_VCLK_MASK 0x400000
#define UVD_CGC_STATUS__LBSI_VCLK__SHIFT 0x16
#define UVD_CGC_STATUS__LRBBM_SCLK_MASK 0x800000
#define UVD_CGC_STATUS__LRBBM_SCLK__SHIFT 0x17
#define UVD_CGC_STATUS__WCB_SCLK_MASK 0x1000000
#define UVD_CGC_STATUS__WCB_SCLK__SHIFT 0x18
#define UVD_CGC_STATUS__VCPU_SCLK_MASK 0x2000000
#define UVD_CGC_STATUS__VCPU_SCLK__SHIFT 0x19
#define UVD_CGC_STATUS__VCPU_VCLK_MASK 0x4000000
#define UVD_CGC_STATUS__VCPU_VCLK__SHIFT 0x1a
#define UVD_CGC_STATUS__SCPU_SCLK_MASK 0x8000000
#define UVD_CGC_STATUS__SCPU_SCLK__SHIFT 0x1b
#define UVD_CGC_STATUS__SCPU_VCLK_MASK 0x10000000
#define UVD_CGC_STATUS__SCPU_VCLK__SHIFT 0x1c
#define UVD_CGC_STATUS__JPEG_ACTIVE_MASK 0x40000000
#define UVD_CGC_STATUS__JPEG_ACTIVE__SHIFT 0x1e
#define UVD_CGC_STATUS__ALL_DEC_ACTIVE_MASK 0x80000000
#define UVD_CGC_STATUS__ALL_DEC_ACTIVE__SHIFT 0x1f
#define UVD_CGC_CTRL__DYN_CLOCK_MODE_MASK 0x1
#define UVD_CGC_CTRL__DYN_CLOCK_MODE__SHIFT 0x0
#define UVD_CGC_CTRL__JPEG2_MODE_MASK 0x2
#define UVD_CGC_CTRL__JPEG2_MODE__SHIFT 0x1
#define UVD_CGC_CTRL__CLK_GATE_DLY_TIMER_MASK 0x3c
#define UVD_CGC_CTRL__CLK_GATE_DLY_TIMER__SHIFT 0x2
#define UVD_CGC_CTRL__CLK_OFF_DELAY_MASK 0x7c0
#define UVD_CGC_CTRL__CLK_OFF_DELAY__SHIFT 0x6
#define UVD_CGC_CTRL__UDEC_RE_MODE_MASK 0x800
#define UVD_CGC_CTRL__UDEC_RE_MODE__SHIFT 0xb
#define UVD_CGC_CTRL__UDEC_CM_MODE_MASK 0x1000
#define UVD_CGC_CTRL__UDEC_CM_MODE__SHIFT 0xc
#define UVD_CGC_CTRL__UDEC_IT_MODE_MASK 0x2000
#define UVD_CGC_CTRL__UDEC_IT_MODE__SHIFT 0xd
#define UVD_CGC_CTRL__UDEC_DB_MODE_MASK 0x4000
#define UVD_CGC_CTRL__UDEC_DB_MODE__SHIFT 0xe
#define UVD_CGC_CTRL__UDEC_MP_MODE_MASK 0x8000
#define UVD_CGC_CTRL__UDEC_MP_MODE__SHIFT 0xf
#define UVD_CGC_CTRL__SYS_MODE_MASK 0x10000
#define UVD_CGC_CTRL__SYS_MODE__SHIFT 0x10
#define UVD_CGC_CTRL__UDEC_MODE_MASK 0x20000
#define UVD_CGC_CTRL__UDEC_MODE__SHIFT 0x11
#define UVD_CGC_CTRL__MPEG2_MODE_MASK 0x40000
#define UVD_CGC_CTRL__MPEG2_MODE__SHIFT 0x12
#define UVD_CGC_CTRL__REGS_MODE_MASK 0x80000
#define UVD_CGC_CTRL__REGS_MODE__SHIFT 0x13
#define UVD_CGC_CTRL__RBC_MODE_MASK 0x100000
#define UVD_CGC_CTRL__RBC_MODE__SHIFT 0x14
#define UVD_CGC_CTRL__LMI_MC_MODE_MASK 0x200000
#define UVD_CGC_CTRL__LMI_MC_MODE__SHIFT 0x15
#define UVD_CGC_CTRL__LMI_UMC_MODE_MASK 0x400000
#define UVD_CGC_CTRL__LMI_UMC_MODE__SHIFT 0x16
#define UVD_CGC_CTRL__IDCT_MODE_MASK 0x800000
#define UVD_CGC_CTRL__IDCT_MODE__SHIFT 0x17
#define UVD_CGC_CTRL__MPRD_MODE_MASK 0x1000000
#define UVD_CGC_CTRL__MPRD_MODE__SHIFT 0x18
#define UVD_CGC_CTRL__MPC_MODE_MASK 0x2000000
#define UVD_CGC_CTRL__MPC_MODE__SHIFT 0x19
#define UVD_CGC_CTRL__LBSI_MODE_MASK 0x4000000
#define UVD_CGC_CTRL__LBSI_MODE__SHIFT 0x1a
#define UVD_CGC_CTRL__LRBBM_MODE_MASK 0x8000000
#define UVD_CGC_CTRL__LRBBM_MODE__SHIFT 0x1b
#define UVD_CGC_CTRL__WCB_MODE_MASK 0x10000000
#define UVD_CGC_CTRL__WCB_MODE__SHIFT 0x1c
#define UVD_CGC_CTRL__VCPU_MODE_MASK 0x20000000
#define UVD_CGC_CTRL__VCPU_MODE__SHIFT 0x1d
#define UVD_CGC_CTRL__SCPU_MODE_MASK 0x40000000
#define UVD_CGC_CTRL__SCPU_MODE__SHIFT 0x1e
#define UVD_CGC_CTRL__JPEG_MODE_MASK 0x80000000
#define UVD_CGC_CTRL__JPEG_MODE__SHIFT 0x1f
#define UVD_CGC_UDEC_STATUS__RE_SCLK_MASK 0x1
#define UVD_CGC_UDEC_STATUS__RE_SCLK__SHIFT 0x0
#define UVD_CGC_UDEC_STATUS__RE_DCLK_MASK 0x2
#define UVD_CGC_UDEC_STATUS__RE_DCLK__SHIFT 0x1
#define UVD_CGC_UDEC_STATUS__RE_VCLK_MASK 0x4
#define UVD_CGC_UDEC_STATUS__RE_VCLK__SHIFT 0x2
#define UVD_CGC_UDEC_STATUS__CM_SCLK_MASK 0x8
#define UVD_CGC_UDEC_STATUS__CM_SCLK__SHIFT 0x3
#define UVD_CGC_UDEC_STATUS__CM_DCLK_MASK 0x10
#define UVD_CGC_UDEC_STATUS__CM_DCLK__SHIFT 0x4
#define UVD_CGC_UDEC_STATUS__CM_VCLK_MASK 0x20
#define UVD_CGC_UDEC_STATUS__CM_VCLK__SHIFT 0x5
#define UVD_CGC_UDEC_STATUS__IT_SCLK_MASK 0x40
#define UVD_CGC_UDEC_STATUS__IT_SCLK__SHIFT 0x6
#define UVD_CGC_UDEC_STATUS__IT_DCLK_MASK 0x80
#define UVD_CGC_UDEC_STATUS__IT_DCLK__SHIFT 0x7
#define UVD_CGC_UDEC_STATUS__IT_VCLK_MASK 0x100
#define UVD_CGC_UDEC_STATUS__IT_VCLK__SHIFT 0x8
#define UVD_CGC_UDEC_STATUS__DB_SCLK_MASK 0x200
#define UVD_CGC_UDEC_STATUS__DB_SCLK__SHIFT 0x9
#define UVD_CGC_UDEC_STATUS__DB_DCLK_MASK 0x400
#define UVD_CGC_UDEC_STATUS__DB_DCLK__SHIFT 0xa
#define UVD_CGC_UDEC_STATUS__DB_VCLK_MASK 0x800
#define UVD_CGC_UDEC_STATUS__DB_VCLK__SHIFT 0xb
#define UVD_CGC_UDEC_STATUS__MP_SCLK_MASK 0x1000
#define UVD_CGC_UDEC_STATUS__MP_SCLK__SHIFT 0xc
#define UVD_CGC_UDEC_STATUS__MP_DCLK_MASK 0x2000
#define UVD_CGC_UDEC_STATUS__MP_DCLK__SHIFT 0xd
#define UVD_CGC_UDEC_STATUS__MP_VCLK_MASK 0x4000
#define UVD_CGC_UDEC_STATUS__MP_VCLK__SHIFT 0xe
#define UVD_CGC_UDEC_STATUS__JPEG_VCLK_MASK 0x8000
#define UVD_CGC_UDEC_STATUS__JPEG_VCLK__SHIFT 0xf
#define UVD_CGC_UDEC_STATUS__JPEG_SCLK_MASK 0x10000
#define UVD_CGC_UDEC_STATUS__JPEG_SCLK__SHIFT 0x10
#define UVD_CGC_UDEC_STATUS__JPEG2_VCLK_MASK 0x20000
#define UVD_CGC_UDEC_STATUS__JPEG2_VCLK__SHIFT 0x11
#define UVD_CGC_UDEC_STATUS__JPEG2_SCLK_MASK 0x40000
#define UVD_CGC_UDEC_STATUS__JPEG2_SCLK__SHIFT 0x12
#define UVD_LMI_CTRL2__SPH_DIS_MASK 0x1
#define UVD_LMI_CTRL2__SPH_DIS__SHIFT 0x0
#define UVD_LMI_CTRL2__STALL_ARB_MASK 0x2
#define UVD_LMI_CTRL2__STALL_ARB__SHIFT 0x1
#define UVD_LMI_CTRL2__ASSERT_UMC_URGENT_MASK 0x4
#define UVD_LMI_CTRL2__ASSERT_UMC_URGENT__SHIFT 0x2
#define UVD_LMI_CTRL2__MASK_UMC_URGENT_MASK 0x8
#define UVD_LMI_CTRL2__MASK_UMC_URGENT__SHIFT 0x3
#define UVD_LMI_CTRL2__MCIF_WR_WATERMARK_MASK 0x70
#define UVD_LMI_CTRL2__MCIF_WR_WATERMARK__SHIFT 0x4
#define UVD_LMI_CTRL2__DRCITF_BUBBLE_FIX_DIS_MASK 0x80
#define UVD_LMI_CTRL2__DRCITF_BUBBLE_FIX_DIS__SHIFT 0x7
#define UVD_LMI_CTRL2__STALL_ARB_UMC_MASK 0x100
#define UVD_LMI_CTRL2__STALL_ARB_UMC__SHIFT 0x8
#define UVD_LMI_CTRL2__MC_READ_ID_SEL_MASK 0x600
#define UVD_LMI_CTRL2__MC_READ_ID_SEL__SHIFT 0x9
#define UVD_LMI_CTRL2__MC_WRITE_ID_SEL_MASK 0x1800
#define UVD_LMI_CTRL2__MC_WRITE_ID_SEL__SHIFT 0xb
#define UVD_LMI_CTRL2__VCPU_NC0_EXT_EN_MASK 0x2000
#define UVD_LMI_CTRL2__VCPU_NC0_EXT_EN__SHIFT 0xd
#define UVD_LMI_CTRL2__VCPU_NC1_EXT_EN_MASK 0x4000
#define UVD_LMI_CTRL2__VCPU_NC1_EXT_EN__SHIFT 0xe
#define UVD_LMI_CTRL2__SPU_EXTRA_CID_EN_MASK 0x8000
#define UVD_LMI_CTRL2__SPU_EXTRA_CID_EN__SHIFT 0xf
#define UVD_LMI_CTRL2__RE_OFFLOAD_EN_MASK 0x10000
#define UVD_LMI_CTRL2__RE_OFFLOAD_EN__SHIFT 0x10
#define UVD_LMI_CTRL2__RE_OFLD_MIF_WR_REQ_NUM_MASK 0x1fe0000
#define UVD_LMI_CTRL2__RE_OFLD_MIF_WR_REQ_NUM__SHIFT 0x11
#define UVD_MASTINT_EN__OVERRUN_RST_MASK 0x1
#define UVD_MASTINT_EN__OVERRUN_RST__SHIFT 0x0
#define UVD_MASTINT_EN__VCPU_EN_MASK 0x2
#define UVD_MASTINT_EN__VCPU_EN__SHIFT 0x1
#define UVD_MASTINT_EN__SYS_EN_MASK 0x4
#define UVD_MASTINT_EN__SYS_EN__SHIFT 0x2
#define UVD_MASTINT_EN__INT_OVERRUN_MASK 0x7ffff0
#define UVD_MASTINT_EN__INT_OVERRUN__SHIFT 0x4
#define UVD_LMI_ADDR_EXT__VCPU_ADDR_EXT_MASK 0xf
#define UVD_LMI_ADDR_EXT__VCPU_ADDR_EXT__SHIFT 0x0
#define UVD_LMI_ADDR_EXT__CM_ADDR_EXT_MASK 0xf0
#define UVD_LMI_ADDR_EXT__CM_ADDR_EXT__SHIFT 0x4
#define UVD_LMI_ADDR_EXT__IT_ADDR_EXT_MASK 0xf00
#define UVD_LMI_ADDR_EXT__IT_ADDR_EXT__SHIFT 0x8
#define UVD_LMI_ADDR_EXT__VCPU_VM_ADDR_EXT_MASK 0xf000
#define UVD_LMI_ADDR_EXT__VCPU_VM_ADDR_EXT__SHIFT 0xc
#define UVD_LMI_ADDR_EXT__RE_ADDR_EXT_MASK 0xf0000
#define UVD_LMI_ADDR_EXT__RE_ADDR_EXT__SHIFT 0x10
#define UVD_LMI_ADDR_EXT__MP_ADDR_EXT_MASK 0xf00000
#define UVD_LMI_ADDR_EXT__MP_ADDR_EXT__SHIFT 0x14
#define UVD_LMI_ADDR_EXT__VCPU_NC0_ADDR_EXT_MASK 0xf000000
#define UVD_LMI_ADDR_EXT__VCPU_NC0_ADDR_EXT__SHIFT 0x18
#define UVD_LMI_ADDR_EXT__VCPU_NC1_ADDR_EXT_MASK 0xf0000000
#define UVD_LMI_ADDR_EXT__VCPU_NC1_ADDR_EXT__SHIFT 0x1c
#define UVD_LMI_CTRL__WRITE_CLEAN_TIMER_MASK 0xff
#define UVD_LMI_CTRL__WRITE_CLEAN_TIMER__SHIFT 0x0
#define UVD_LMI_CTRL__WRITE_CLEAN_TIMER_EN_MASK 0x100
#define UVD_LMI_CTRL__WRITE_CLEAN_TIMER_EN__SHIFT 0x8
#define UVD_LMI_CTRL__REQ_MODE_MASK 0x200
#define UVD_LMI_CTRL__REQ_MODE__SHIFT 0x9
#define UVD_LMI_CTRL__ASSERT_MC_URGENT_MASK 0x800
#define UVD_LMI_CTRL__ASSERT_MC_URGENT__SHIFT 0xb
#define UVD_LMI_CTRL__MASK_MC_URGENT_MASK 0x1000
#define UVD_LMI_CTRL__MASK_MC_URGENT__SHIFT 0xc
#define UVD_LMI_CTRL__DATA_COHERENCY_EN_MASK 0x2000
#define UVD_LMI_CTRL__DATA_COHERENCY_EN__SHIFT 0xd
#define UVD_LMI_CTRL__CRC_RESET_MASK 0x4000
#define UVD_LMI_CTRL__CRC_RESET__SHIFT 0xe
#define UVD_LMI_CTRL__CRC_SEL_MASK 0xf8000
#define UVD_LMI_CTRL__CRC_SEL__SHIFT 0xf
#define UVD_LMI_CTRL__DISABLE_ON_FWV_FAIL_MASK 0x100000
#define UVD_LMI_CTRL__DISABLE_ON_FWV_FAIL__SHIFT 0x14
#define UVD_LMI_CTRL__VCPU_DATA_COHERENCY_EN_MASK 0x200000
#define UVD_LMI_CTRL__VCPU_DATA_COHERENCY_EN__SHIFT 0x15
#define UVD_LMI_CTRL__CM_DATA_COHERENCY_EN_MASK 0x400000
#define UVD_LMI_CTRL__CM_DATA_COHERENCY_EN__SHIFT 0x16
#define UVD_LMI_CTRL__DB_DB_DATA_COHERENCY_EN_MASK 0x800000
#define UVD_LMI_CTRL__DB_DB_DATA_COHERENCY_EN__SHIFT 0x17
#define UVD_LMI_CTRL__DB_IT_DATA_COHERENCY_EN_MASK 0x1000000
#define UVD_LMI_CTRL__DB_IT_DATA_COHERENCY_EN__SHIFT 0x18
#define UVD_LMI_CTRL__IT_IT_DATA_COHERENCY_EN_MASK 0x2000000
#define UVD_LMI_CTRL__IT_IT_DATA_COHERENCY_EN__SHIFT 0x19
#define UVD_LMI_CTRL__MIF_MIF_DATA_COHERENCY_EN_MASK 0x4000000
#define UVD_LMI_CTRL__MIF_MIF_DATA_COHERENCY_EN__SHIFT 0x1a
#define UVD_LMI_CTRL__RFU_MASK 0xf8000000
#define UVD_LMI_CTRL__RFU__SHIFT 0x1b
#define UVD_LMI_STATUS__READ_CLEAN_MASK 0x1
#define UVD_LMI_STATUS__READ_CLEAN__SHIFT 0x0
#define UVD_LMI_STATUS__WRITE_CLEAN_MASK 0x2
#define UVD_LMI_STATUS__WRITE_CLEAN__SHIFT 0x1
#define UVD_LMI_STATUS__WRITE_CLEAN_RAW_MASK 0x4
#define UVD_LMI_STATUS__WRITE_CLEAN_RAW__SHIFT 0x2
#define UVD_LMI_STATUS__VCPU_LMI_WRITE_CLEAN_MASK 0x8
#define UVD_LMI_STATUS__VCPU_LMI_WRITE_CLEAN__SHIFT 0x3
#define UVD_LMI_STATUS__UMC_READ_CLEAN_MASK 0x10
#define UVD_LMI_STATUS__UMC_READ_CLEAN__SHIFT 0x4
#define UVD_LMI_STATUS__UMC_WRITE_CLEAN_MASK 0x20
#define UVD_LMI_STATUS__UMC_WRITE_CLEAN__SHIFT 0x5
#define UVD_LMI_STATUS__UMC_WRITE_CLEAN_RAW_MASK 0x40
#define UVD_LMI_STATUS__UMC_WRITE_CLEAN_RAW__SHIFT 0x6
#define UVD_LMI_STATUS__PENDING_UVD_MC_WRITE_MASK 0x80
#define UVD_LMI_STATUS__PENDING_UVD_MC_WRITE__SHIFT 0x7
#define UVD_LMI_STATUS__READ_CLEAN_RAW_MASK 0x100
#define UVD_LMI_STATUS__READ_CLEAN_RAW__SHIFT 0x8
#define UVD_LMI_STATUS__UMC_READ_CLEAN_RAW_MASK 0x200
#define UVD_LMI_STATUS__UMC_READ_CLEAN_RAW__SHIFT 0x9
#define UVD_LMI_STATUS__UMC_UVD_IDLE_MASK 0x400
#define UVD_LMI_STATUS__UMC_UVD_IDLE__SHIFT 0xa
#define UVD_LMI_STATUS__UMC_AVP_IDLE_MASK 0x800
#define UVD_LMI_STATUS__UMC_AVP_IDLE__SHIFT 0xb
#define UVD_LMI_STATUS__ADP_MC_READ_CLEAN_MASK 0x1000
#define UVD_LMI_STATUS__ADP_MC_READ_CLEAN__SHIFT 0xc
#define UVD_LMI_STATUS__ADP_UMC_READ_CLEAN_MASK 0x2000
#define UVD_LMI_STATUS__ADP_UMC_READ_CLEAN__SHIFT 0xd
#define UVD_LMI_SWAP_CNTL__RB_MC_SWAP_MASK 0x3
#define UVD_LMI_SWAP_CNTL__RB_MC_SWAP__SHIFT 0x0
#define UVD_LMI_SWAP_CNTL__IB_MC_SWAP_MASK 0xc
#define UVD_LMI_SWAP_CNTL__IB_MC_SWAP__SHIFT 0x2
#define UVD_LMI_SWAP_CNTL__RB_RPTR_MC_SWAP_MASK 0x30
#define UVD_LMI_SWAP_CNTL__RB_RPTR_MC_SWAP__SHIFT 0x4
#define UVD_LMI_SWAP_CNTL__VCPU_R_MC_SWAP_MASK 0xc0
#define UVD_LMI_SWAP_CNTL__VCPU_R_MC_SWAP__SHIFT 0x6
#define UVD_LMI_SWAP_CNTL__VCPU_W_MC_SWAP_MASK 0x300
#define UVD_LMI_SWAP_CNTL__VCPU_W_MC_SWAP__SHIFT 0x8
#define UVD_LMI_SWAP_CNTL__CM_MC_SWAP_MASK 0xc00
#define UVD_LMI_SWAP_CNTL__CM_MC_SWAP__SHIFT 0xa
#define UVD_LMI_SWAP_CNTL__IT_MC_SWAP_MASK 0x3000
#define UVD_LMI_SWAP_CNTL__IT_MC_SWAP__SHIFT 0xc
#define UVD_LMI_SWAP_CNTL__DB_R_MC_SWAP_MASK 0xc000
#define UVD_LMI_SWAP_CNTL__DB_R_MC_SWAP__SHIFT 0xe
#define UVD_LMI_SWAP_CNTL__DB_W_MC_SWAP_MASK 0x30000
#define UVD_LMI_SWAP_CNTL__DB_W_MC_SWAP__SHIFT 0x10
#define UVD_LMI_SWAP_CNTL__CSM_MC_SWAP_MASK 0xc0000
#define UVD_LMI_SWAP_CNTL__CSM_MC_SWAP__SHIFT 0x12
#define UVD_LMI_SWAP_CNTL__MP_REF16_MC_SWAP_MASK 0xc00000
#define UVD_LMI_SWAP_CNTL__MP_REF16_MC_SWAP__SHIFT 0x16
#define UVD_LMI_SWAP_CNTL__DBW_MC_SWAP_MASK 0x3000000
#define UVD_LMI_SWAP_CNTL__DBW_MC_SWAP__SHIFT 0x18
#define UVD_LMI_SWAP_CNTL__RB_WR_MC_SWAP_MASK 0xc000000
#define UVD_LMI_SWAP_CNTL__RB_WR_MC_SWAP__SHIFT 0x1a
#define UVD_LMI_SWAP_CNTL__RE_MC_SWAP_MASK 0x30000000
#define UVD_LMI_SWAP_CNTL__RE_MC_SWAP__SHIFT 0x1c
#define UVD_LMI_SWAP_CNTL__MP_MC_SWAP_MASK 0xc0000000
#define UVD_LMI_SWAP_CNTL__MP_MC_SWAP__SHIFT 0x1e
#define UVD_MP_SWAP_CNTL__MP_REF0_MC_SWAP_MASK 0x3
#define UVD_MP_SWAP_CNTL__MP_REF0_MC_SWAP__SHIFT 0x0
#define UVD_MP_SWAP_CNTL__MP_REF1_MC_SWAP_MASK 0xc
#define UVD_MP_SWAP_CNTL__MP_REF1_MC_SWAP__SHIFT 0x2
#define UVD_MP_SWAP_CNTL__MP_REF2_MC_SWAP_MASK 0x30
#define UVD_MP_SWAP_CNTL__MP_REF2_MC_SWAP__SHIFT 0x4
#define UVD_MP_SWAP_CNTL__MP_REF3_MC_SWAP_MASK 0xc0
#define UVD_MP_SWAP_CNTL__MP_REF3_MC_SWAP__SHIFT 0x6
#define UVD_MP_SWAP_CNTL__MP_REF4_MC_SWAP_MASK 0x300
#define UVD_MP_SWAP_CNTL__MP_REF4_MC_SWAP__SHIFT 0x8
#define UVD_MP_SWAP_CNTL__MP_REF5_MC_SWAP_MASK 0xc00
#define UVD_MP_SWAP_CNTL__MP_REF5_MC_SWAP__SHIFT 0xa
#define UVD_MP_SWAP_CNTL__MP_REF6_MC_SWAP_MASK 0x3000
#define UVD_MP_SWAP_CNTL__MP_REF6_MC_SWAP__SHIFT 0xc
#define UVD_MP_SWAP_CNTL__MP_REF7_MC_SWAP_MASK 0xc000
#define UVD_MP_SWAP_CNTL__MP_REF7_MC_SWAP__SHIFT 0xe
#define UVD_MP_SWAP_CNTL__MP_REF8_MC_SWAP_MASK 0x30000
#define UVD_MP_SWAP_CNTL__MP_REF8_MC_SWAP__SHIFT 0x10
#define UVD_MP_SWAP_CNTL__MP_REF9_MC_SWAP_MASK 0xc0000
#define UVD_MP_SWAP_CNTL__MP_REF9_MC_SWAP__SHIFT 0x12
#define UVD_MP_SWAP_CNTL__MP_REF10_MC_SWAP_MASK 0x300000
#define UVD_MP_SWAP_CNTL__MP_REF10_MC_SWAP__SHIFT 0x14
#define UVD_MP_SWAP_CNTL__MP_REF11_MC_SWAP_MASK 0xc00000
#define UVD_MP_SWAP_CNTL__MP_REF11_MC_SWAP__SHIFT 0x16
#define UVD_MP_SWAP_CNTL__MP_REF12_MC_SWAP_MASK 0x3000000
#define UVD_MP_SWAP_CNTL__MP_REF12_MC_SWAP__SHIFT 0x18
#define UVD_MP_SWAP_CNTL__MP_REF13_MC_SWAP_MASK 0xc000000
#define UVD_MP_SWAP_CNTL__MP_REF13_MC_SWAP__SHIFT 0x1a
#define UVD_MP_SWAP_CNTL__MP_REF14_MC_SWAP_MASK 0x30000000
#define UVD_MP_SWAP_CNTL__MP_REF14_MC_SWAP__SHIFT 0x1c
#define UVD_MP_SWAP_CNTL__MP_REF15_MC_SWAP_MASK 0xc0000000
#define UVD_MP_SWAP_CNTL__MP_REF15_MC_SWAP__SHIFT 0x1e
#define UVD_MPC_CNTL__REPLACEMENT_MODE_MASK 0x38
#define UVD_MPC_CNTL__REPLACEMENT_MODE__SHIFT 0x3
#define UVD_MPC_CNTL__PERF_RST_MASK 0x40
#define UVD_MPC_CNTL__PERF_RST__SHIFT 0x6
#define UVD_MPC_CNTL__DBG_MUX_MASK 0xf00
#define UVD_MPC_CNTL__DBG_MUX__SHIFT 0x8
#define UVD_MPC_CNTL__AVE_WEIGHT_MASK 0x30000
#define UVD_MPC_CNTL__AVE_WEIGHT__SHIFT 0x10
#define UVD_MPC_CNTL__URGENT_EN_MASK 0x40000
#define UVD_MPC_CNTL__URGENT_EN__SHIFT 0x12
#define UVD_MPC_SET_MUXA0__VARA_0_MASK 0x3f
#define UVD_MPC_SET_MUXA0__VARA_0__SHIFT 0x0
#define UVD_MPC_SET_MUXA0__VARA_1_MASK 0xfc0
#define UVD_MPC_SET_MUXA0__VARA_1__SHIFT 0x6
#define UVD_MPC_SET_MUXA0__VARA_2_MASK 0x3f000
#define UVD_MPC_SET_MUXA0__VARA_2__SHIFT 0xc
#define UVD_MPC_SET_MUXA0__VARA_3_MASK 0xfc0000
#define UVD_MPC_SET_MUXA0__VARA_3__SHIFT 0x12
#define UVD_MPC_SET_MUXA0__VARA_4_MASK 0x3f000000
#define UVD_MPC_SET_MUXA0__VARA_4__SHIFT 0x18
#define UVD_MPC_SET_MUXA1__VARA_5_MASK 0x3f
#define UVD_MPC_SET_MUXA1__VARA_5__SHIFT 0x0
#define UVD_MPC_SET_MUXA1__VARA_6_MASK 0xfc0
#define UVD_MPC_SET_MUXA1__VARA_6__SHIFT 0x6
#define UVD_MPC_SET_MUXA1__VARA_7_MASK 0x3f000
#define UVD_MPC_SET_MUXA1__VARA_7__SHIFT 0xc
#define UVD_MPC_SET_MUXB0__VARB_0_MASK 0x3f
#define UVD_MPC_SET_MUXB0__VARB_0__SHIFT 0x0
#define UVD_MPC_SET_MUXB0__VARB_1_MASK 0xfc0
#define UVD_MPC_SET_MUXB0__VARB_1__SHIFT 0x6
#define UVD_MPC_SET_MUXB0__VARB_2_MASK 0x3f000
#define UVD_MPC_SET_MUXB0__VARB_2__SHIFT 0xc
#define UVD_MPC_SET_MUXB0__VARB_3_MASK 0xfc0000
#define UVD_MPC_SET_MUXB0__VARB_3__SHIFT 0x12
#define UVD_MPC_SET_MUXB0__VARB_4_MASK 0x3f000000
#define UVD_MPC_SET_MUXB0__VARB_4__SHIFT 0x18
#define UVD_MPC_SET_MUXB1__VARB_5_MASK 0x3f
#define UVD_MPC_SET_MUXB1__VARB_5__SHIFT 0x0
#define UVD_MPC_SET_MUXB1__VARB_6_MASK 0xfc0
#define UVD_MPC_SET_MUXB1__VARB_6__SHIFT 0x6
#define UVD_MPC_SET_MUXB1__VARB_7_MASK 0x3f000
#define UVD_MPC_SET_MUXB1__VARB_7__SHIFT 0xc
#define UVD_MPC_SET_MUX__SET_0_MASK 0x7
#define UVD_MPC_SET_MUX__SET_0__SHIFT 0x0
#define UVD_MPC_SET_MUX__SET_1_MASK 0x38
#define UVD_MPC_SET_MUX__SET_1__SHIFT 0x3
#define UVD_MPC_SET_MUX__SET_2_MASK 0x1c0
#define UVD_MPC_SET_MUX__SET_2__SHIFT 0x6
#define UVD_MPC_SET_ALU__FUNCT_MASK 0x7
#define UVD_MPC_SET_ALU__FUNCT__SHIFT 0x0
#define UVD_MPC_SET_ALU__OPERAND_MASK 0xff0
#define UVD_MPC_SET_ALU__OPERAND__SHIFT 0x4
#define UVD_VCPU_CACHE_OFFSET0__CACHE_OFFSET0_MASK 0x1ffffff
#define UVD_VCPU_CACHE_OFFSET0__CACHE_OFFSET0__SHIFT 0x0
#define UVD_VCPU_CACHE_SIZE0__CACHE_SIZE0_MASK 0x1fffff
#define UVD_VCPU_CACHE_SIZE0__CACHE_SIZE0__SHIFT 0x0
#define UVD_VCPU_CACHE_OFFSET1__CACHE_OFFSET1_MASK 0x1ffffff
#define UVD_VCPU_CACHE_OFFSET1__CACHE_OFFSET1__SHIFT 0x0
#define UVD_VCPU_CACHE_SIZE1__CACHE_SIZE1_MASK 0x1fffff
#define UVD_VCPU_CACHE_SIZE1__CACHE_SIZE1__SHIFT 0x0
#define UVD_VCPU_CACHE_OFFSET2__CACHE_OFFSET2_MASK 0x1ffffff
#define UVD_VCPU_CACHE_OFFSET2__CACHE_OFFSET2__SHIFT 0x0
#define UVD_VCPU_CACHE_SIZE2__CACHE_SIZE2_MASK 0x1fffff
#define UVD_VCPU_CACHE_SIZE2__CACHE_SIZE2__SHIFT 0x0
#define UVD_VCPU_CNTL__IRQ_ERR_MASK 0xf
#define UVD_VCPU_CNTL__IRQ_ERR__SHIFT 0x0
#define UVD_VCPU_CNTL__AXI_MAX_BRST_SIZE_IS_4_MASK 0x10
#define UVD_VCPU_CNTL__AXI_MAX_BRST_SIZE_IS_4__SHIFT 0x4
#define UVD_VCPU_CNTL__PMB_ED_ENABLE_MASK 0x20
#define UVD_VCPU_CNTL__PMB_ED_ENABLE__SHIFT 0x5
#define UVD_VCPU_CNTL__PMB_SOFT_RESET_MASK 0x40
#define UVD_VCPU_CNTL__PMB_SOFT_RESET__SHIFT 0x6
#define UVD_VCPU_CNTL__RBBM_SOFT_RESET_MASK 0x80
#define UVD_VCPU_CNTL__RBBM_SOFT_RESET__SHIFT 0x7
#define UVD_VCPU_CNTL__ABORT_REQ_MASK 0x100
#define UVD_VCPU_CNTL__ABORT_REQ__SHIFT 0x8
#define UVD_VCPU_CNTL__CLK_EN_MASK 0x200
#define UVD_VCPU_CNTL__CLK_EN__SHIFT 0x9
#define UVD_VCPU_CNTL__TRCE_EN_MASK 0x400
#define UVD_VCPU_CNTL__TRCE_EN__SHIFT 0xa
#define UVD_VCPU_CNTL__TRCE_MUX_MASK 0x1800
#define UVD_VCPU_CNTL__TRCE_MUX__SHIFT 0xb
#define UVD_VCPU_CNTL__DBG_MUX_MASK 0xe000
#define UVD_VCPU_CNTL__DBG_MUX__SHIFT 0xd
#define UVD_VCPU_CNTL__JTAG_EN_MASK 0x10000
#define UVD_VCPU_CNTL__JTAG_EN__SHIFT 0x10
#define UVD_VCPU_CNTL__MIF_WR_LOW_THRESHOLD_BP_MASK 0x20000
#define UVD_VCPU_CNTL__MIF_WR_LOW_THRESHOLD_BP__SHIFT 0x11
#define UVD_VCPU_CNTL__TIMEOUT_DIS_MASK 0x40000
#define UVD_VCPU_CNTL__TIMEOUT_DIS__SHIFT 0x12
#define UVD_VCPU_CNTL__SUVD_EN_MASK 0x80000
#define UVD_VCPU_CNTL__SUVD_EN__SHIFT 0x13
#define UVD_VCPU_CNTL__PRB_TIMEOUT_VAL_MASK 0xff00000
#define UVD_VCPU_CNTL__PRB_TIMEOUT_VAL__SHIFT 0x14
#define UVD_VCPU_CNTL__CABAC_MB_ACC_MASK 0x10000000
#define UVD_VCPU_CNTL__CABAC_MB_ACC__SHIFT 0x1c
#define UVD_VCPU_CNTL__WMV9_EN_MASK 0x40000000
#define UVD_VCPU_CNTL__WMV9_EN__SHIFT 0x1e
#define UVD_VCPU_CNTL__RE_OFFLOAD_EN_MASK 0x80000000
#define UVD_VCPU_CNTL__RE_OFFLOAD_EN__SHIFT 0x1f
#define UVD_SOFT_RESET__RBC_SOFT_RESET_MASK 0x1
#define UVD_SOFT_RESET__RBC_SOFT_RESET__SHIFT 0x0
#define UVD_SOFT_RESET__LBSI_SOFT_RESET_MASK 0x2
#define UVD_SOFT_RESET__LBSI_SOFT_RESET__SHIFT 0x1
#define UVD_SOFT_RESET__LMI_SOFT_RESET_MASK 0x4
#define UVD_SOFT_RESET__LMI_SOFT_RESET__SHIFT 0x2
#define UVD_SOFT_RESET__VCPU_SOFT_RESET_MASK 0x8
#define UVD_SOFT_RESET__VCPU_SOFT_RESET__SHIFT 0x3
#define UVD_SOFT_RESET__UDEC_SOFT_RESET_MASK 0x10
#define UVD_SOFT_RESET__UDEC_SOFT_RESET__SHIFT 0x4
#define UVD_SOFT_RESET__CSM_SOFT_RESET_MASK 0x20
#define UVD_SOFT_RESET__CSM_SOFT_RESET__SHIFT 0x5
#define UVD_SOFT_RESET__CXW_SOFT_RESET_MASK 0x40
#define UVD_SOFT_RESET__CXW_SOFT_RESET__SHIFT 0x6
#define UVD_SOFT_RESET__TAP_SOFT_RESET_MASK 0x80
#define UVD_SOFT_RESET__TAP_SOFT_RESET__SHIFT 0x7
#define UVD_SOFT_RESET__MPC_SOFT_RESET_MASK 0x100
#define UVD_SOFT_RESET__MPC_SOFT_RESET__SHIFT 0x8
#define UVD_SOFT_RESET__JPEG_SCLK_RESET_STATUS_MASK 0x200
#define UVD_SOFT_RESET__JPEG_SCLK_RESET_STATUS__SHIFT 0x9
#define UVD_SOFT_RESET__IH_SOFT_RESET_MASK 0x400
#define UVD_SOFT_RESET__IH_SOFT_RESET__SHIFT 0xa
#define UVD_SOFT_RESET__MPRD_SOFT_RESET_MASK 0x800
#define UVD_SOFT_RESET__MPRD_SOFT_RESET__SHIFT 0xb
#define UVD_SOFT_RESET__IDCT_SOFT_RESET_MASK 0x1000
#define UVD_SOFT_RESET__IDCT_SOFT_RESET__SHIFT 0xc
#define UVD_SOFT_RESET__LMI_UMC_SOFT_RESET_MASK 0x2000
#define UVD_SOFT_RESET__LMI_UMC_SOFT_RESET__SHIFT 0xd
#define UVD_SOFT_RESET__SPH_SOFT_RESET_MASK 0x4000
#define UVD_SOFT_RESET__SPH_SOFT_RESET__SHIFT 0xe
#define UVD_SOFT_RESET__MIF_SOFT_RESET_MASK 0x8000
#define UVD_SOFT_RESET__MIF_SOFT_RESET__SHIFT 0xf
#define UVD_SOFT_RESET__LCM_SOFT_RESET_MASK 0x10000
#define UVD_SOFT_RESET__LCM_SOFT_RESET__SHIFT 0x10
#define UVD_SOFT_RESET__SUVD_SOFT_RESET_MASK 0x20000
#define UVD_SOFT_RESET__SUVD_SOFT_RESET__SHIFT 0x11
#define UVD_SOFT_RESET__LBSI_VCLK_RESET_STATUS_MASK 0x40000
#define UVD_SOFT_RESET__LBSI_VCLK_RESET_STATUS__SHIFT 0x12
#define UVD_SOFT_RESET__VCPU_VCLK_RESET_STATUS_MASK 0x80000
#define UVD_SOFT_RESET__VCPU_VCLK_RESET_STATUS__SHIFT 0x13
#define UVD_SOFT_RESET__UDEC_VCLK_RESET_STATUS_MASK 0x100000
#define UVD_SOFT_RESET__UDEC_VCLK_RESET_STATUS__SHIFT 0x14
#define UVD_SOFT_RESET__UDEC_DCLK_RESET_STATUS_MASK 0x200000
#define UVD_SOFT_RESET__UDEC_DCLK_RESET_STATUS__SHIFT 0x15
#define UVD_SOFT_RESET__MPC_DCLK_RESET_STATUS_MASK 0x400000
#define UVD_SOFT_RESET__MPC_DCLK_RESET_STATUS__SHIFT 0x16
#define UVD_SOFT_RESET__MPRD_VCLK_RESET_STATUS_MASK 0x800000
#define UVD_SOFT_RESET__MPRD_VCLK_RESET_STATUS__SHIFT 0x17
#define UVD_SOFT_RESET__MPRD_DCLK_RESET_STATUS_MASK 0x1000000
#define UVD_SOFT_RESET__MPRD_DCLK_RESET_STATUS__SHIFT 0x18
#define UVD_SOFT_RESET__IDCT_VCLK_RESET_STATUS_MASK 0x2000000
#define UVD_SOFT_RESET__IDCT_VCLK_RESET_STATUS__SHIFT 0x19
#define UVD_SOFT_RESET__MIF_DCLK_RESET_STATUS_MASK 0x4000000
#define UVD_SOFT_RESET__MIF_DCLK_RESET_STATUS__SHIFT 0x1a
#define UVD_SOFT_RESET__LCM_DCLK_RESET_STATUS_MASK 0x8000000
#define UVD_SOFT_RESET__LCM_DCLK_RESET_STATUS__SHIFT 0x1b
#define UVD_SOFT_RESET__SUVD_VCLK_RESET_STATUS_MASK 0x10000000
#define UVD_SOFT_RESET__SUVD_VCLK_RESET_STATUS__SHIFT 0x1c
#define UVD_SOFT_RESET__SUVD_DCLK_RESET_STATUS_MASK 0x20000000
#define UVD_SOFT_RESET__SUVD_DCLK_RESET_STATUS__SHIFT 0x1d
#define UVD_SOFT_RESET__RE_DCLK_RESET_STATUS_MASK 0x40000000
#define UVD_SOFT_RESET__RE_DCLK_RESET_STATUS__SHIFT 0x1e
#define UVD_SOFT_RESET__SRE_DCLK_RESET_STATUS_MASK 0x80000000
#define UVD_SOFT_RESET__SRE_DCLK_RESET_STATUS__SHIFT 0x1f
#define UVD_LMI_RBC_IB_VMID__IB_VMID_MASK 0xf
#define UVD_LMI_RBC_IB_VMID__IB_VMID__SHIFT 0x0
#define UVD_RBC_IB_SIZE__IB_SIZE_MASK 0x7ffff0
#define UVD_RBC_IB_SIZE__IB_SIZE__SHIFT 0x4
#define UVD_LMI_RBC_RB_VMID__RB_VMID_MASK 0xf
#define UVD_LMI_RBC_RB_VMID__RB_VMID__SHIFT 0x0
#define UVD_RBC_RB_RPTR__RB_RPTR_MASK 0x7ffff0
#define UVD_RBC_RB_RPTR__RB_RPTR__SHIFT 0x4
#define UVD_RBC_RB_WPTR__RB_WPTR_MASK 0x7ffff0
#define UVD_RBC_RB_WPTR__RB_WPTR__SHIFT 0x4
#define UVD_RBC_RB_CNTL__RB_BUFSZ_MASK 0x1f
#define UVD_RBC_RB_CNTL__RB_BUFSZ__SHIFT 0x0
#define UVD_RBC_RB_CNTL__RB_BLKSZ_MASK 0x1f00
#define UVD_RBC_RB_CNTL__RB_BLKSZ__SHIFT 0x8
#define UVD_RBC_RB_CNTL__RB_NO_FETCH_MASK 0x10000
#define UVD_RBC_RB_CNTL__RB_NO_FETCH__SHIFT 0x10
#define UVD_RBC_RB_CNTL__RB_WPTR_POLL_EN_MASK 0x100000
#define UVD_RBC_RB_CNTL__RB_WPTR_POLL_EN__SHIFT 0x14
#define UVD_RBC_RB_CNTL__RB_NO_UPDATE_MASK 0x1000000
#define UVD_RBC_RB_CNTL__RB_NO_UPDATE__SHIFT 0x18
#define UVD_RBC_RB_CNTL__RB_RPTR_WR_EN_MASK 0x10000000
#define UVD_RBC_RB_CNTL__RB_RPTR_WR_EN__SHIFT 0x1c
#define UVD_RBC_RB_RPTR_ADDR__RB_RPTR_ADDR_MASK 0xffffffff
#define UVD_RBC_RB_RPTR_ADDR__RB_RPTR_ADDR__SHIFT 0x0
#define UVD_STATUS__RBC_BUSY_MASK 0x1
#define UVD_STATUS__RBC_BUSY__SHIFT 0x0
#define UVD_STATUS__VCPU_REPORT_MASK 0xfe
#define UVD_STATUS__VCPU_REPORT__SHIFT 0x1
#define UVD_SEMA_TIMEOUT_STATUS__SEMAPHORE_WAIT_INCOMPLETE_TIMEOUT_STAT_MASK 0x1
#define UVD_SEMA_TIMEOUT_STATUS__SEMAPHORE_WAIT_INCOMPLETE_TIMEOUT_STAT__SHIFT 0x0
#define UVD_SEMA_TIMEOUT_STATUS__SEMAPHORE_WAIT_FAULT_TIMEOUT_STAT_MASK 0x2
#define UVD_SEMA_TIMEOUT_STATUS__SEMAPHORE_WAIT_FAULT_TIMEOUT_STAT__SHIFT 0x1
#define UVD_SEMA_TIMEOUT_STATUS__SEMAPHORE_SIGNAL_INCOMPLETE_TIMEOUT_STAT_MASK 0x4
#define UVD_SEMA_TIMEOUT_STATUS__SEMAPHORE_SIGNAL_INCOMPLETE_TIMEOUT_STAT__SHIFT 0x2
#define UVD_SEMA_TIMEOUT_STATUS__SEMAPHORE_TIMEOUT_CLEAR_MASK 0x8
#define UVD_SEMA_TIMEOUT_STATUS__SEMAPHORE_TIMEOUT_CLEAR__SHIFT 0x3
#define UVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL__WAIT_INCOMPLETE_EN_MASK 0x1
#define UVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL__WAIT_INCOMPLETE_EN__SHIFT 0x0
#define UVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL__WAIT_INCOMPLETE_COUNT_MASK 0x1ffffe
#define UVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL__WAIT_INCOMPLETE_COUNT__SHIFT 0x1
#define UVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL__RESEND_TIMER_MASK 0x7000000
#define UVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL__RESEND_TIMER__SHIFT 0x18
#define UVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL__WAIT_FAULT_EN_MASK 0x1
#define UVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL__WAIT_FAULT_EN__SHIFT 0x0
#define UVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL__WAIT_FAULT_COUNT_MASK 0x1ffffe
#define UVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL__WAIT_FAULT_COUNT__SHIFT 0x1
#define UVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL__RESEND_TIMER_MASK 0x7000000
#define UVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL__RESEND_TIMER__SHIFT 0x18
#define UVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL__SIGNAL_INCOMPLETE_EN_MASK 0x1
#define UVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL__SIGNAL_INCOMPLETE_EN__SHIFT 0x0
#define UVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL__SIGNAL_INCOMPLETE_COUNT_MASK 0x1ffffe
#define UVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL__SIGNAL_INCOMPLETE_COUNT__SHIFT 0x1
#define UVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL__RESEND_TIMER_MASK 0x7000000
#define UVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL__RESEND_TIMER__SHIFT 0x18
#define UVD_CONTEXT_ID__CONTEXT_ID_MASK 0xffffffff
#define UVD_CONTEXT_ID__CONTEXT_ID__SHIFT 0x0
#define UVD_SUVD_CGC_GATE__SRE_MASK 0x1
#define UVD_SUVD_CGC_GATE__SRE__SHIFT 0x0
#define UVD_SUVD_CGC_GATE__SIT_MASK 0x2
#define UVD_SUVD_CGC_GATE__SIT__SHIFT 0x1
#define UVD_SUVD_CGC_GATE__SMP_MASK 0x4
#define UVD_SUVD_CGC_GATE__SMP__SHIFT 0x2
#define UVD_SUVD_CGC_GATE__SCM_MASK 0x8
#define UVD_SUVD_CGC_GATE__SCM__SHIFT 0x3
#define UVD_SUVD_CGC_GATE__SDB_MASK 0x10
#define UVD_SUVD_CGC_GATE__SDB__SHIFT 0x4
#define UVD_SUVD_CGC_GATE__SRE_H264_MASK 0x20
#define UVD_SUVD_CGC_GATE__SRE_H264__SHIFT 0x5
#define UVD_SUVD_CGC_GATE__SRE_HEVC_MASK 0x40
#define UVD_SUVD_CGC_GATE__SRE_HEVC__SHIFT 0x6
#define UVD_SUVD_CGC_GATE__SIT_H264_MASK 0x80
#define UVD_SUVD_CGC_GATE__SIT_H264__SHIFT 0x7
#define UVD_SUVD_CGC_GATE__SIT_HEVC_MASK 0x100
#define UVD_SUVD_CGC_GATE__SIT_HEVC__SHIFT 0x8
#define UVD_SUVD_CGC_GATE__SCM_H264_MASK 0x200
#define UVD_SUVD_CGC_GATE__SCM_H264__SHIFT 0x9
#define UVD_SUVD_CGC_GATE__SCM_HEVC_MASK 0x400
#define UVD_SUVD_CGC_GATE__SCM_HEVC__SHIFT 0xa
#define UVD_SUVD_CGC_GATE__SDB_H264_MASK 0x800
#define UVD_SUVD_CGC_GATE__SDB_H264__SHIFT 0xb
#define UVD_SUVD_CGC_GATE__SDB_HEVC_MASK 0x1000
#define UVD_SUVD_CGC_GATE__SDB_HEVC__SHIFT 0xc
#define UVD_SUVD_CGC_GATE__SCLR_MASK 0x2000
#define UVD_SUVD_CGC_GATE__SCLR__SHIFT 0xd
#define UVD_SUVD_CGC_GATE__UVD_SC_MASK 0x4000
#define UVD_SUVD_CGC_GATE__UVD_SC__SHIFT 0xe
#define UVD_SUVD_CGC_STATUS__SRE_VCLK_MASK 0x1
#define UVD_SUVD_CGC_STATUS__SRE_VCLK__SHIFT 0x0
#define UVD_SUVD_CGC_STATUS__SRE_DCLK_MASK 0x2
#define UVD_SUVD_CGC_STATUS__SRE_DCLK__SHIFT 0x1
#define UVD_SUVD_CGC_STATUS__SIT_DCLK_MASK 0x4
#define UVD_SUVD_CGC_STATUS__SIT_DCLK__SHIFT 0x2
#define UVD_SUVD_CGC_STATUS__SMP_DCLK_MASK 0x8
#define UVD_SUVD_CGC_STATUS__SMP_DCLK__SHIFT 0x3
#define UVD_SUVD_CGC_STATUS__SCM_DCLK_MASK 0x10
#define UVD_SUVD_CGC_STATUS__SCM_DCLK__SHIFT 0x4
#define UVD_SUVD_CGC_STATUS__SDB_DCLK_MASK 0x20
#define UVD_SUVD_CGC_STATUS__SDB_DCLK__SHIFT 0x5
#define UVD_SUVD_CGC_STATUS__SRE_H264_VCLK_MASK 0x40
#define UVD_SUVD_CGC_STATUS__SRE_H264_VCLK__SHIFT 0x6
#define UVD_SUVD_CGC_STATUS__SRE_HEVC_VCLK_MASK 0x80
#define UVD_SUVD_CGC_STATUS__SRE_HEVC_VCLK__SHIFT 0x7
#define UVD_SUVD_CGC_STATUS__SIT_H264_DCLK_MASK 0x100
#define UVD_SUVD_CGC_STATUS__SIT_H264_DCLK__SHIFT 0x8
#define UVD_SUVD_CGC_STATUS__SIT_HEVC_DCLK_MASK 0x200
#define UVD_SUVD_CGC_STATUS__SIT_HEVC_DCLK__SHIFT 0x9
#define UVD_SUVD_CGC_STATUS__SCM_H264_DCLK_MASK 0x400
#define UVD_SUVD_CGC_STATUS__SCM_H264_DCLK__SHIFT 0xa
#define UVD_SUVD_CGC_STATUS__SCM_HEVC_DCLK_MASK 0x800
#define UVD_SUVD_CGC_STATUS__SCM_HEVC_DCLK__SHIFT 0xb
#define UVD_SUVD_CGC_STATUS__SDB_H264_DCLK_MASK 0x1000
#define UVD_SUVD_CGC_STATUS__SDB_H264_DCLK__SHIFT 0xc
#define UVD_SUVD_CGC_STATUS__SDB_HEVC_DCLK_MASK 0x2000
#define UVD_SUVD_CGC_STATUS__SDB_HEVC_DCLK__SHIFT 0xd
#define UVD_SUVD_CGC_STATUS__SCLR_DCLK_MASK 0x4000
#define UVD_SUVD_CGC_STATUS__SCLR_DCLK__SHIFT 0xe
#define UVD_SUVD_CGC_STATUS__UVD_SC_MASK 0x8000
#define UVD_SUVD_CGC_STATUS__UVD_SC__SHIFT 0xf
#define UVD_SUVD_CGC_CTRL__SRE_MODE_MASK 0x1
#define UVD_SUVD_CGC_CTRL__SRE_MODE__SHIFT 0x0
#define UVD_SUVD_CGC_CTRL__SIT_MODE_MASK 0x2
#define UVD_SUVD_CGC_CTRL__SIT_MODE__SHIFT 0x1
#define UVD_SUVD_CGC_CTRL__SMP_MODE_MASK 0x4
#define UVD_SUVD_CGC_CTRL__SMP_MODE__SHIFT 0x2
#define UVD_SUVD_CGC_CTRL__SCM_MODE_MASK 0x8
#define UVD_SUVD_CGC_CTRL__SCM_MODE__SHIFT 0x3
#define UVD_SUVD_CGC_CTRL__SDB_MODE_MASK 0x10
#define UVD_SUVD_CGC_CTRL__SDB_MODE__SHIFT 0x4
#define UVD_SUVD_CGC_CTRL__SCLR_MODE_MASK 0x20
#define UVD_SUVD_CGC_CTRL__SCLR_MODE__SHIFT 0x5
#define UVD_SUVD_CGC_CTRL__UVD_SC_MODE_MASK 0x40
#define UVD_SUVD_CGC_CTRL__UVD_SC_MODE__SHIFT 0x6
#define UVD_LMI_VMID_INTERNAL__VCPU_NC0_VMID_MASK 0xf
#define UVD_LMI_VMID_INTERNAL__VCPU_NC0_VMID__SHIFT 0x0
#define UVD_LMI_VMID_INTERNAL__VCPU_NC1_VMID_MASK 0xf0
#define UVD_LMI_VMID_INTERNAL__VCPU_NC1_VMID__SHIFT 0x4
#define UVD_LMI_VMID_INTERNAL__DPB_VMID_MASK 0xf00
#define UVD_LMI_VMID_INTERNAL__DPB_VMID__SHIFT 0x8
#define UVD_LMI_VMID_INTERNAL__DBW_VMID_MASK 0xf000
#define UVD_LMI_VMID_INTERNAL__DBW_VMID__SHIFT 0xc
#define UVD_LMI_VMID_INTERNAL__LBSI_VMID_MASK 0xf0000
#define UVD_LMI_VMID_INTERNAL__LBSI_VMID__SHIFT 0x10
#define UVD_LMI_VMID_INTERNAL__IDCT_VMID_MASK 0xf00000
#define UVD_LMI_VMID_INTERNAL__IDCT_VMID__SHIFT 0x14
#define UVD_LMI_VMID_INTERNAL__JPEG_VMID_MASK 0xf000000
#define UVD_LMI_VMID_INTERNAL__JPEG_VMID__SHIFT 0x18
#define UVD_LMI_VMID_INTERNAL__JPEG2_VMID_MASK 0xf0000000
#define UVD_LMI_VMID_INTERNAL__JPEG2_VMID__SHIFT 0x1c
#define UVD_LMI_VMID_INTERNAL2__MIF_GPGPU_VMID_MASK 0xf
#define UVD_LMI_VMID_INTERNAL2__MIF_GPGPU_VMID__SHIFT 0x0
#define UVD_LMI_VMID_INTERNAL2__MIF_CURR_VMID_MASK 0xf0
#define UVD_LMI_VMID_INTERNAL2__MIF_CURR_VMID__SHIFT 0x4
#define UVD_LMI_VMID_INTERNAL2__MIF_REF_VMID_MASK 0xf00
#define UVD_LMI_VMID_INTERNAL2__MIF_REF_VMID__SHIFT 0x8
#define UVD_LMI_VMID_INTERNAL2__MIF_DBW_VMID_MASK 0xf000
#define UVD_LMI_VMID_INTERNAL2__MIF_DBW_VMID__SHIFT 0xc
#define UVD_LMI_VMID_INTERNAL2__MIF_CM_COLOC_VMID_MASK 0xf0000
#define UVD_LMI_VMID_INTERNAL2__MIF_CM_COLOC_VMID__SHIFT 0x10
#define UVD_LMI_VMID_INTERNAL2__MIF_BSD_VMID_MASK 0xf00000
#define UVD_LMI_VMID_INTERNAL2__MIF_BSD_VMID__SHIFT 0x14
#define UVD_LMI_VMID_INTERNAL2__MIF_BSP_VMID_MASK 0xf000000
#define UVD_LMI_VMID_INTERNAL2__MIF_BSP_VMID__SHIFT 0x18
#define UVD_LMI_VMID_INTERNAL2__VDMA_VMID_MASK 0xf0000000
#define UVD_LMI_VMID_INTERNAL2__VDMA_VMID__SHIFT 0x1c
#define UVD_LMI_CACHE_CTRL__IT_EN_MASK 0x1
#define UVD_LMI_CACHE_CTRL__IT_EN__SHIFT 0x0
#define UVD_LMI_CACHE_CTRL__IT_FLUSH_MASK 0x2
#define UVD_LMI_CACHE_CTRL__IT_FLUSH__SHIFT 0x1
#define UVD_LMI_CACHE_CTRL__CM_EN_MASK 0x4
#define UVD_LMI_CACHE_CTRL__CM_EN__SHIFT 0x2
#define UVD_LMI_CACHE_CTRL__CM_FLUSH_MASK 0x8
#define UVD_LMI_CACHE_CTRL__CM_FLUSH__SHIFT 0x3
#define UVD_LMI_CACHE_CTRL__VCPU_EN_MASK 0x10
#define UVD_LMI_CACHE_CTRL__VCPU_EN__SHIFT 0x4
#define UVD_LMI_CACHE_CTRL__VCPU_FLUSH_MASK 0x20
#define UVD_LMI_CACHE_CTRL__VCPU_FLUSH__SHIFT 0x5
#define UVD_LMI_SWAP_CNTL2__SCPU_R_MC_SWAP_MASK 0x3
#define UVD_LMI_SWAP_CNTL2__SCPU_R_MC_SWAP__SHIFT 0x0
#define UVD_LMI_SWAP_CNTL2__SCPU_W_MC_SWAP_MASK 0xc
#define UVD_LMI_SWAP_CNTL2__SCPU_W_MC_SWAP__SHIFT 0x2
#define UVD_LMI_ADDR_EXT2__SCPU_ADDR_EXT_MASK 0xf
#define UVD_LMI_ADDR_EXT2__SCPU_ADDR_EXT__SHIFT 0x0
#define UVD_LMI_ADDR_EXT2__SCPU_VM_ADDR_EXT_MASK 0xf0
#define UVD_LMI_ADDR_EXT2__SCPU_VM_ADDR_EXT__SHIFT 0x4
#define UVD_LMI_ADDR_EXT2__SCPU_NC0_ADDR_EXT_MASK 0xf00
#define UVD_LMI_ADDR_EXT2__SCPU_NC0_ADDR_EXT__SHIFT 0x8
#define UVD_LMI_ADDR_EXT2__SCPU_NC1_ADDR_EXT_MASK 0xf000
#define UVD_LMI_ADDR_EXT2__SCPU_NC1_ADDR_EXT__SHIFT 0xc
#define UVD_CGC_MEM_CTRL__LMI_MC_LS_EN_MASK 0x1
#define UVD_CGC_MEM_CTRL__LMI_MC_LS_EN__SHIFT 0x0
#define UVD_CGC_MEM_CTRL__MPC_LS_EN_MASK 0x2
#define UVD_CGC_MEM_CTRL__MPC_LS_EN__SHIFT 0x1
#define UVD_CGC_MEM_CTRL__MPRD_LS_EN_MASK 0x4
#define UVD_CGC_MEM_CTRL__MPRD_LS_EN__SHIFT 0x2
#define UVD_CGC_MEM_CTRL__WCB_LS_EN_MASK 0x8
#define UVD_CGC_MEM_CTRL__WCB_LS_EN__SHIFT 0x3
#define UVD_CGC_MEM_CTRL__UDEC_RE_LS_EN_MASK 0x10
#define UVD_CGC_MEM_CTRL__UDEC_RE_LS_EN__SHIFT 0x4
#define UVD_CGC_MEM_CTRL__UDEC_CM_LS_EN_MASK 0x20
#define UVD_CGC_MEM_CTRL__UDEC_CM_LS_EN__SHIFT 0x5
#define UVD_CGC_MEM_CTRL__UDEC_IT_LS_EN_MASK 0x40
#define UVD_CGC_MEM_CTRL__UDEC_IT_LS_EN__SHIFT 0x6
#define UVD_CGC_MEM_CTRL__UDEC_DB_LS_EN_MASK 0x80
#define UVD_CGC_MEM_CTRL__UDEC_DB_LS_EN__SHIFT 0x7
#define UVD_CGC_MEM_CTRL__UDEC_MP_LS_EN_MASK 0x100
#define UVD_CGC_MEM_CTRL__UDEC_MP_LS_EN__SHIFT 0x8
#define UVD_CGC_MEM_CTRL__SYS_LS_EN_MASK 0x200
#define UVD_CGC_MEM_CTRL__SYS_LS_EN__SHIFT 0x9
#define UVD_CGC_MEM_CTRL__VCPU_LS_EN_MASK 0x400
#define UVD_CGC_MEM_CTRL__VCPU_LS_EN__SHIFT 0xa
#define UVD_CGC_MEM_CTRL__SCPU_LS_EN_MASK 0x800
#define UVD_CGC_MEM_CTRL__SCPU_LS_EN__SHIFT 0xb
#define UVD_CGC_MEM_CTRL__MIF_LS_EN_MASK 0x1000
#define UVD_CGC_MEM_CTRL__MIF_LS_EN__SHIFT 0xc
#define UVD_CGC_MEM_CTRL__LCM_LS_EN_MASK 0x2000
#define UVD_CGC_MEM_CTRL__LCM_LS_EN__SHIFT 0xd
#define UVD_CGC_MEM_CTRL__JPEG_LS_EN_MASK 0x4000
#define UVD_CGC_MEM_CTRL__JPEG_LS_EN__SHIFT 0xe
#define UVD_CGC_MEM_CTRL__JPEG2_LS_EN_MASK 0x8000
#define UVD_CGC_MEM_CTRL__JPEG2_LS_EN__SHIFT 0xf
#define UVD_CGC_MEM_CTRL__LS_SET_DELAY_MASK 0xf0000
#define UVD_CGC_MEM_CTRL__LS_SET_DELAY__SHIFT 0x10
#define UVD_CGC_MEM_CTRL__LS_CLEAR_DELAY_MASK 0xf00000
#define UVD_CGC_MEM_CTRL__LS_CLEAR_DELAY__SHIFT 0x14
#define UVD_CGC_CTRL2__DYN_OCLK_RAMP_EN_MASK 0x1
#define UVD_CGC_CTRL2__DYN_OCLK_RAMP_EN__SHIFT 0x0
#define UVD_CGC_CTRL2__DYN_RCLK_RAMP_EN_MASK 0x2
#define UVD_CGC_CTRL2__DYN_RCLK_RAMP_EN__SHIFT 0x1
#define UVD_CGC_CTRL2__GATER_DIV_ID_MASK 0x1c
#define UVD_CGC_CTRL2__GATER_DIV_ID__SHIFT 0x2
#define UVD_LMI_VMID_INTERNAL3__MIF_GEN_RD0_VMID_MASK 0xf
#define UVD_LMI_VMID_INTERNAL3__MIF_GEN_RD0_VMID__SHIFT 0x0
#define UVD_LMI_VMID_INTERNAL3__MIF_GEN_RD1_VMID_MASK 0xf0
#define UVD_LMI_VMID_INTERNAL3__MIF_GEN_RD1_VMID__SHIFT 0x4
#define UVD_LMI_VMID_INTERNAL3__MIF_GEN_WR0_VMID_MASK 0xf00
#define UVD_LMI_VMID_INTERNAL3__MIF_GEN_WR0_VMID__SHIFT 0x8
#define UVD_LMI_VMID_INTERNAL3__MIF_GEN_WR1_VMID_MASK 0xf000
#define UVD_LMI_VMID_INTERNAL3__MIF_GEN_WR1_VMID__SHIFT 0xc
#define UVD_LMI_VMID_INTERNAL3__MIF_SCLR_VMID_MASK 0xf0000
#define UVD_LMI_VMID_INTERNAL3__MIF_SCLR_VMID__SHIFT 0x10
#define UVD_PGFSM_CONFIG__UVD_PGFSM_FSM_ADDR_MASK 0xff
#define UVD_PGFSM_CONFIG__UVD_PGFSM_FSM_ADDR__SHIFT 0x0
#define UVD_PGFSM_CONFIG__UVD_PGFSM_POWER_DOWN_MASK 0x100
#define UVD_PGFSM_CONFIG__UVD_PGFSM_POWER_DOWN__SHIFT 0x8
#define UVD_PGFSM_CONFIG__UVD_PGFSM_POWER_UP_MASK 0x200
#define UVD_PGFSM_CONFIG__UVD_PGFSM_POWER_UP__SHIFT 0x9
#define UVD_PGFSM_CONFIG__UVD_PGFSM_P1_SELECT_MASK 0x400
#define UVD_PGFSM_CONFIG__UVD_PGFSM_P1_SELECT__SHIFT 0xa
#define UVD_PGFSM_CONFIG__UVD_PGFSM_P2_SELECT_MASK 0x800
#define UVD_PGFSM_CONFIG__UVD_PGFSM_P2_SELECT__SHIFT 0xb
#define UVD_PGFSM_CONFIG__UVD_PGFSM_WRITE_MASK 0x1000
#define UVD_PGFSM_CONFIG__UVD_PGFSM_WRITE__SHIFT 0xc
#define UVD_PGFSM_CONFIG__UVD_PGFSM_READ_MASK 0x2000
#define UVD_PGFSM_CONFIG__UVD_PGFSM_READ__SHIFT 0xd
#define UVD_PGFSM_CONFIG__UVD_PGFSM_REG_ADDR_MASK 0xf0000000
#define UVD_PGFSM_CONFIG__UVD_PGFSM_REG_ADDR__SHIFT 0x1c
#define UVD_PGFSM_READ_TILE1__UVD_PGFSM_READ_TILE1_VALUE_MASK 0xffffff
#define UVD_PGFSM_READ_TILE1__UVD_PGFSM_READ_TILE1_VALUE__SHIFT 0x0
#define UVD_PGFSM_READ_TILE2__UVD_PGFSM_READ_TILE2_VALUE_MASK 0xffffff
#define UVD_PGFSM_READ_TILE2__UVD_PGFSM_READ_TILE2_VALUE__SHIFT 0x0
#define UVD_POWER_STATUS__UVD_POWER_STATUS_MASK 0x3
#define UVD_POWER_STATUS__UVD_POWER_STATUS__SHIFT 0x0
#define UVD_POWER_STATUS__UVD_PG_MODE_MASK 0x4
#define UVD_POWER_STATUS__UVD_PG_MODE__SHIFT 0x2
#define UVD_POWER_STATUS__UVD_STATUS_CHECK_TIMEOUT_MASK 0x8
#define UVD_POWER_STATUS__UVD_STATUS_CHECK_TIMEOUT__SHIFT 0x3
#define UVD_POWER_STATUS__PWR_ON_CHECK_TIMEOUT_MASK 0x10
#define UVD_POWER_STATUS__PWR_ON_CHECK_TIMEOUT__SHIFT 0x4
#define UVD_POWER_STATUS__PWR_OFF_CHECK_TIMEOUT_MASK 0x20
#define UVD_POWER_STATUS__PWR_OFF_CHECK_TIMEOUT__SHIFT 0x5
#define UVD_POWER_STATUS__UVD_PGFSM_TIMEOUT_MODE_MASK 0xc0
#define UVD_POWER_STATUS__UVD_PGFSM_TIMEOUT_MODE__SHIFT 0x6
#define UVD_POWER_STATUS__UVD_PG_EN_MASK 0x100
#define UVD_POWER_STATUS__UVD_PG_EN__SHIFT 0x8
#define UVD_POWER_STATUS__PAUSE_DPG_REQ_MASK 0x200
#define UVD_POWER_STATUS__PAUSE_DPG_REQ__SHIFT 0x9
#define UVD_POWER_STATUS__PAUSE_DPG_ACK_MASK 0x400
#define UVD_POWER_STATUS__PAUSE_DPG_ACK__SHIFT 0xa
#define UVD_PGFSM_READ_TILE3__UVD_PGFSM_READ_TILE3_VALUE_MASK 0xffffff
#define UVD_PGFSM_READ_TILE3__UVD_PGFSM_READ_TILE3_VALUE__SHIFT 0x0
#define UVD_PGFSM_READ_TILE4__UVD_PGFSM_READ_TILE4_VALUE_MASK 0xffffff
#define UVD_PGFSM_READ_TILE4__UVD_PGFSM_READ_TILE4_VALUE__SHIFT 0x0
#define UVD_PGFSM_READ_TILE5__UVD_PGFSM_READ_TILE5_VALUE_MASK 0xffffff
#define UVD_PGFSM_READ_TILE5__UVD_PGFSM_READ_TILE5_VALUE__SHIFT 0x0
#define UVD_PGFSM_READ_TILE6__UVD_PGFSM_READ_TILE6_VALUE_MASK 0xffffff
#define UVD_PGFSM_READ_TILE6__UVD_PGFSM_READ_TILE6_VALUE__SHIFT 0x0
#define UVD_PGFSM_READ_TILE7__UVD_PGFSM_READ_TILE7_VALUE_MASK 0xffffff
#define UVD_PGFSM_READ_TILE7__UVD_PGFSM_READ_TILE7_VALUE__SHIFT 0x0
#define UVD_MIF_CURR_ADDR_CONFIG__NUM_PIPES_MASK 0x7
#define UVD_MIF_CURR_ADDR_CONFIG__NUM_PIPES__SHIFT 0x0
#define UVD_MIF_CURR_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define UVD_MIF_CURR_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define UVD_MIF_CURR_ADDR_CONFIG__BANK_INTERLEAVE_SIZE_MASK 0x700
#define UVD_MIF_CURR_ADDR_CONFIG__BANK_INTERLEAVE_SIZE__SHIFT 0x8
#define UVD_MIF_CURR_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK 0x3000
#define UVD_MIF_CURR_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT 0xc
#define UVD_MIF_CURR_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE_MASK 0x70000
#define UVD_MIF_CURR_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE__SHIFT 0x10
#define UVD_MIF_CURR_ADDR_CONFIG__NUM_GPUS_MASK 0x700000
#define UVD_MIF_CURR_ADDR_CONFIG__NUM_GPUS__SHIFT 0x14
#define UVD_MIF_CURR_ADDR_CONFIG__MULTI_GPU_TILE_SIZE_MASK 0x3000000
#define UVD_MIF_CURR_ADDR_CONFIG__MULTI_GPU_TILE_SIZE__SHIFT 0x18
#define UVD_MIF_CURR_ADDR_CONFIG__ROW_SIZE_MASK 0x30000000
#define UVD_MIF_CURR_ADDR_CONFIG__ROW_SIZE__SHIFT 0x1c
#define UVD_MIF_CURR_ADDR_CONFIG__NUM_LOWER_PIPES_MASK 0x40000000
#define UVD_MIF_CURR_ADDR_CONFIG__NUM_LOWER_PIPES__SHIFT 0x1e
#define UVD_MIF_REF_ADDR_CONFIG__NUM_PIPES_MASK 0x7
#define UVD_MIF_REF_ADDR_CONFIG__NUM_PIPES__SHIFT 0x0
#define UVD_MIF_REF_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define UVD_MIF_REF_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define UVD_MIF_REF_ADDR_CONFIG__BANK_INTERLEAVE_SIZE_MASK 0x700
#define UVD_MIF_REF_ADDR_CONFIG__BANK_INTERLEAVE_SIZE__SHIFT 0x8
#define UVD_MIF_REF_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK 0x3000
#define UVD_MIF_REF_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT 0xc
#define UVD_MIF_REF_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE_MASK 0x70000
#define UVD_MIF_REF_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE__SHIFT 0x10
#define UVD_MIF_REF_ADDR_CONFIG__NUM_GPUS_MASK 0x700000
#define UVD_MIF_REF_ADDR_CONFIG__NUM_GPUS__SHIFT 0x14
#define UVD_MIF_REF_ADDR_CONFIG__MULTI_GPU_TILE_SIZE_MASK 0x3000000
#define UVD_MIF_REF_ADDR_CONFIG__MULTI_GPU_TILE_SIZE__SHIFT 0x18
#define UVD_MIF_REF_ADDR_CONFIG__ROW_SIZE_MASK 0x30000000
#define UVD_MIF_REF_ADDR_CONFIG__ROW_SIZE__SHIFT 0x1c
#define UVD_MIF_REF_ADDR_CONFIG__NUM_LOWER_PIPES_MASK 0x40000000
#define UVD_MIF_REF_ADDR_CONFIG__NUM_LOWER_PIPES__SHIFT 0x1e
#define UVD_MIF_RECON1_ADDR_CONFIG__NUM_PIPES_MASK 0x7
#define UVD_MIF_RECON1_ADDR_CONFIG__NUM_PIPES__SHIFT 0x0
#define UVD_MIF_RECON1_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define UVD_MIF_RECON1_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define UVD_MIF_RECON1_ADDR_CONFIG__BANK_INTERLEAVE_SIZE_MASK 0x700
#define UVD_MIF_RECON1_ADDR_CONFIG__BANK_INTERLEAVE_SIZE__SHIFT 0x8
#define UVD_MIF_RECON1_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK 0x3000
#define UVD_MIF_RECON1_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT 0xc
#define UVD_MIF_RECON1_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE_MASK 0x70000
#define UVD_MIF_RECON1_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE__SHIFT 0x10
#define UVD_MIF_RECON1_ADDR_CONFIG__NUM_GPUS_MASK 0x700000
#define UVD_MIF_RECON1_ADDR_CONFIG__NUM_GPUS__SHIFT 0x14
#define UVD_MIF_RECON1_ADDR_CONFIG__MULTI_GPU_TILE_SIZE_MASK 0x3000000
#define UVD_MIF_RECON1_ADDR_CONFIG__MULTI_GPU_TILE_SIZE__SHIFT 0x18
#define UVD_MIF_RECON1_ADDR_CONFIG__ROW_SIZE_MASK 0x30000000
#define UVD_MIF_RECON1_ADDR_CONFIG__ROW_SIZE__SHIFT 0x1c
#define UVD_MIF_RECON1_ADDR_CONFIG__NUM_LOWER_PIPES_MASK 0x40000000
#define UVD_MIF_RECON1_ADDR_CONFIG__NUM_LOWER_PIPES__SHIFT 0x1e
#define UVD_MIF_SCLR_ADDR_CONFIG__NUM_PIPES_MASK 0x7
#define UVD_MIF_SCLR_ADDR_CONFIG__NUM_PIPES__SHIFT 0x0
#define UVD_MIF_SCLR_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define UVD_MIF_SCLR_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define UVD_MIF_SCLR_ADDR_CONFIG__BANK_INTERLEAVE_SIZE_MASK 0x700
#define UVD_MIF_SCLR_ADDR_CONFIG__BANK_INTERLEAVE_SIZE__SHIFT 0x8
#define UVD_MIF_SCLR_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK 0x3000
#define UVD_MIF_SCLR_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT 0xc
#define UVD_MIF_SCLR_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE_MASK 0x70000
#define UVD_MIF_SCLR_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE__SHIFT 0x10
#define UVD_MIF_SCLR_ADDR_CONFIG__NUM_GPUS_MASK 0x700000
#define UVD_MIF_SCLR_ADDR_CONFIG__NUM_GPUS__SHIFT 0x14
#define UVD_MIF_SCLR_ADDR_CONFIG__MULTI_GPU_TILE_SIZE_MASK 0x3000000
#define UVD_MIF_SCLR_ADDR_CONFIG__MULTI_GPU_TILE_SIZE__SHIFT 0x18
#define UVD_MIF_SCLR_ADDR_CONFIG__ROW_SIZE_MASK 0x30000000
#define UVD_MIF_SCLR_ADDR_CONFIG__ROW_SIZE__SHIFT 0x1c
#define UVD_MIF_SCLR_ADDR_CONFIG__NUM_LOWER_PIPES_MASK 0x40000000
#define UVD_MIF_SCLR_ADDR_CONFIG__NUM_LOWER_PIPES__SHIFT 0x1e
#define UVD_JPEG_ADDR_CONFIG__NUM_PIPES_MASK 0x7
#define UVD_JPEG_ADDR_CONFIG__NUM_PIPES__SHIFT 0x0
#define UVD_JPEG_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define UVD_JPEG_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define UVD_JPEG_ADDR_CONFIG__BANK_INTERLEAVE_SIZE_MASK 0x700
#define UVD_JPEG_ADDR_CONFIG__BANK_INTERLEAVE_SIZE__SHIFT 0x8
#define UVD_JPEG_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK 0x3000
#define UVD_JPEG_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT 0xc
#define UVD_JPEG_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE_MASK 0x70000
#define UVD_JPEG_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE__SHIFT 0x10
#define UVD_JPEG_ADDR_CONFIG__NUM_GPUS_MASK 0x700000
#define UVD_JPEG_ADDR_CONFIG__NUM_GPUS__SHIFT 0x14
#define UVD_JPEG_ADDR_CONFIG__MULTI_GPU_TILE_SIZE_MASK 0x3000000
#define UVD_JPEG_ADDR_CONFIG__MULTI_GPU_TILE_SIZE__SHIFT 0x18
#define UVD_JPEG_ADDR_CONFIG__ROW_SIZE_MASK 0x30000000
#define UVD_JPEG_ADDR_CONFIG__ROW_SIZE__SHIFT 0x1c
#define UVD_JPEG_ADDR_CONFIG__NUM_LOWER_PIPES_MASK 0x40000000
#define UVD_JPEG_ADDR_CONFIG__NUM_LOWER_PIPES__SHIFT 0x1e

#endif /* UVD_5_0_SH_MASK_H */
