/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JExpressionImpl;
import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JType;
import java.util.ArrayList;
import java.util.List;

public final class JArray
extends JExpressionImpl {
    private final JType type;
    private final JExpression size;
    private List<JExpression> exprs = null;

    public JArray add(JExpression jExpression) {
        if (this.exprs == null) {
            this.exprs = new ArrayList<JExpression>();
        }
        this.exprs.add(jExpression);
        return this;
    }

    JArray(JType jType, JExpression jExpression) {
        this.type = jType;
        this.size = jExpression;
    }

    public void generate(JFormatter jFormatter) {
        int n = 0;
        JType jType = this.type;
        while (jType.isArray()) {
            jType = jType.elementType();
            ++n;
        }
        jFormatter.p("new").g(jType).p('[');
        if (this.size != null) {
            jFormatter.g(this.size);
        }
        jFormatter.p(']');
        for (int i = 0; i < n; ++i) {
            jFormatter.p("[]");
        }
        if (this.size == null || this.exprs != null) {
            jFormatter.p('{');
        }
        if (this.exprs != null) {
            jFormatter.g(this.exprs);
        } else {
            jFormatter.p(' ');
        }
        if (this.size == null || this.exprs != null) {
            jFormatter.p('}');
        }
    }
}

