/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.document;

import com.sun.tools.internal.ws.wsdl.document.Documentation;
import com.sun.tools.internal.ws.wsdl.document.Kinds;
import com.sun.tools.internal.ws.wsdl.document.Operation;
import com.sun.tools.internal.ws.wsdl.document.WSDLConstants;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocumentVisitor;
import com.sun.tools.internal.ws.wsdl.framework.Defining;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import com.sun.tools.internal.ws.wsdl.framework.EntityAction;
import com.sun.tools.internal.ws.wsdl.framework.ExtensibilityHelper;
import com.sun.tools.internal.ws.wsdl.framework.Extensible;
import com.sun.tools.internal.ws.wsdl.framework.Extension;
import com.sun.tools.internal.ws.wsdl.framework.GlobalEntity;
import com.sun.tools.internal.ws.wsdl.framework.Kind;
import com.sun.tools.internal.ws.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

public class PortType
extends GlobalEntity
implements Extensible {
    private Documentation _documentation;
    private List _operations = new ArrayList();
    private Set _operationKeys = new HashSet();
    private ExtensibilityHelper _helper = new ExtensibilityHelper();

    public PortType(Defining defining) {
        super(defining);
    }

    public void add(Operation operation) {
        String string = operation.getUniqueKey();
        if (this._operationKeys.contains(string)) {
            throw new ValidationException("validation.ambiguousName", operation.getName());
        }
        this._operationKeys.add(string);
        this._operations.add(operation);
    }

    public Iterator operations() {
        return this._operations.iterator();
    }

    public Set getOperationsNamed(String string) {
        HashSet<Operation> hashSet = new HashSet<Operation>();
        for (Operation operation : this._operations) {
            if (!operation.getName().equals(string)) continue;
            hashSet.add(operation);
        }
        return hashSet;
    }

    public Kind getKind() {
        return Kinds.PORT_TYPE;
    }

    public QName getElementName() {
        return WSDLConstants.QNAME_PORT_TYPE;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation documentation) {
        this._documentation = documentation;
    }

    public void withAllSubEntitiesDo(EntityAction entityAction) {
        super.withAllSubEntitiesDo(entityAction);
        Iterator iterator = this._operations.iterator();
        while (iterator.hasNext()) {
            entityAction.perform((Entity)iterator.next());
        }
        this._helper.withAllSubEntitiesDo(entityAction);
    }

    public void accept(WSDLDocumentVisitor wSDLDocumentVisitor) throws Exception {
        wSDLDocumentVisitor.preVisit(this);
        this._helper.accept(wSDLDocumentVisitor);
        Iterator iterator = this._operations.iterator();
        while (iterator.hasNext()) {
            ((Operation)iterator.next()).accept(wSDLDocumentVisitor);
        }
        wSDLDocumentVisitor.postVisit(this);
    }

    public void validateThis() {
        if (this.getName() == null) {
            this.failValidation("validation.missingRequiredAttribute", "name");
        }
    }

    public void addExtension(Extension extension) {
        this._helper.addExtension(extension);
    }

    public Iterator extensions() {
        return this._helper.extensions();
    }
}

