/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.dtd;

import com.sun.tools.internal.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CElementPropertyInfo;
import com.sun.tools.internal.xjc.model.CNonElement;
import com.sun.tools.internal.xjc.model.CPropertyInfo;
import com.sun.tools.internal.xjc.model.CReferencePropertyInfo;
import com.sun.tools.internal.xjc.model.CTypeInfo;
import com.sun.tools.internal.xjc.model.CTypeRef;
import com.sun.tools.internal.xjc.model.CValuePropertyInfo;
import com.sun.tools.internal.xjc.model.TypeUse;
import com.sun.tools.internal.xjc.reader.dtd.Block;
import com.sun.tools.internal.xjc.reader.dtd.TDTDReader;
import com.sun.tools.internal.xjc.reader.dtd.Term;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BIConversion;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BIElement;
import com.sun.xml.internal.bind.v2.model.core.ID;
import com.sun.xml.internal.bind.v2.model.core.WildcardMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Element
extends Term
implements Comparable<Element> {
    final String name;
    private final TDTDReader owner;
    private short contentModelType;
    private Term contentModel;
    boolean isReferenced;
    private CClassInfo classInfo;
    private boolean classInfoComputed;
    final List<CPropertyInfo> attributes = new ArrayList<CPropertyInfo>();
    private final List<Block> normalizedBlocks = new ArrayList<Block>();
    private boolean mustBeClass;
    private Locator locator;

    public Element(TDTDReader tDTDReader, String string) {
        this.owner = tDTDReader;
        this.name = string;
    }

    @Override
    void normalize(List<Block> list, boolean bl) {
        Block block = new Block(bl, false);
        block.elements.add(this);
        list.add(block);
    }

    @Override
    void addAllElements(Block block) {
        block.elements.add(this);
    }

    @Override
    boolean isOptional() {
        return false;
    }

    @Override
    boolean isRepeated() {
        return false;
    }

    void define(short s, Term term, Locator locator) {
        assert (this.contentModel == null);
        this.contentModelType = s;
        this.contentModel = term;
        this.locator = locator;
        term.normalize(this.normalizedBlocks, false);
        for (Block block : this.normalizedBlocks) {
            if (!block.isRepeated && block.elements.size() <= 1) continue;
            for (Element element : block.elements) {
                this.owner.getOrCreateElement((String)element.name).mustBeClass = true;
            }
        }
    }

    private TypeUse getConversion() {
        BIConversion bIConversion;
        assert (this.contentModel == Term.EMPTY);
        BIElement bIElement = this.owner.bindInfo.element(this.name);
        if (bIElement != null && (bIConversion = bIElement.getConversion()) != null) {
            return bIConversion.getTransducer();
        }
        return CBuiltinLeafInfo.STRING;
    }

    CClassInfo getClassInfo() {
        if (!this.classInfoComputed) {
            this.classInfoComputed = true;
            this.classInfo = this.calcClass();
        }
        return this.classInfo;
    }

    private CClassInfo calcClass() {
        BIElement bIElement = this.owner.bindInfo.element(this.name);
        if (bIElement == null) {
            if (this.contentModelType != 2 || !this.attributes.isEmpty() || this.mustBeClass) {
                return this.createDefaultClass();
            }
            if (this.contentModel != Term.EMPTY) {
                throw new UnsupportedOperationException("mixed content model not supported");
            }
            if (this.isReferenced) {
                return null;
            }
            return this.createDefaultClass();
        }
        return bIElement.clazz;
    }

    private CClassInfo createDefaultClass() {
        String string = this.owner.model.getNameConverter().toClassName(this.name);
        QName qName = new QName("", this.name);
        return new CClassInfo(this.owner.model, this.owner.getTargetPackage(), string, this.locator, null, qName, null, null);
    }

    /*
     * WARNING - void declaration
     */
    void bind() {
        Iterator<Element> iterator;
        Object object;
        Object object2;
        CClassInfo cClassInfo = this.getClassInfo();
        assert (cClassInfo != null || this.attributes.isEmpty());
        for (CPropertyInfo iterator22 : this.attributes) {
            cClassInfo.addProperty(iterator22);
        }
        switch (this.contentModelType) {
            case 1: {
                object2 = new CReferencePropertyInfo("Content", true, true, null, null, this.locator);
                ((CReferencePropertyInfo)object2).setWildcard(WildcardMode.SKIP);
                cClassInfo.addProperty((CPropertyInfo)object2);
                return;
            }
            case 3: {
                break;
            }
            case 2: {
                if (this.contentModel != Term.EMPTY) {
                    throw new UnsupportedOperationException("mixed content model unsupported yet");
                }
                if (cClassInfo != null) {
                    CValuePropertyInfo cValuePropertyInfo = new CValuePropertyInfo("value", null, null, this.locator, this.getConversion());
                    cClassInfo.addProperty(cValuePropertyInfo);
                }
                return;
            }
            case 0: {
                assert (cClassInfo != null);
                return;
            }
        }
        object2 = new ArrayList();
        this.contentModel.normalize((List<Block>)object2, false);
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        Object object3 = object2.iterator();
        block7: while (object3.hasNext()) {
            object = (Block)object3.next();
            for (Element element : ((Block)object).elements) {
                if (hashSet.add(element.name)) continue;
                bl = true;
                break block7;
            }
        }
        if (bl) {
            object3 = new Block(true, true);
            object = object2.iterator();
            while (object.hasNext()) {
                iterator = (Block)object.next();
                ((Block)object3).elements.addAll(((Block)((Object)iterator)).elements);
            }
            object2.clear();
            object2.add(object3);
        }
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Object object4;
            Block block = (Block)iterator2.next();
            if (block.isRepeated || block.elements.size() > 1) {
                object = new StringBuilder();
                for (Element element : block.elements) {
                    if (((StringBuilder)object).length() > 0) {
                        ((StringBuilder)object).append("Or");
                    }
                    ((StringBuilder)object).append(this.owner.model.getNameConverter().toPropertyName(element.name));
                }
                object3 = new CElementPropertyInfo(((StringBuilder)object).toString(), CElementPropertyInfo.CollectionMode.REPEATED_ELEMENT, ID.NONE, null, null, null, this.locator, !block.isOptional);
                for (Element element : block.elements) {
                    object4 = this.owner.getOrCreateElement(element.name).getClassInfo();
                    assert (object4 != null);
                    ((CElementPropertyInfo)object3).getTypes().add(new CTypeRef((CNonElement)object4, new QName("", element.name), false, null));
                }
            } else {
                void var8_18;
                object = block.elements.iterator().next().name;
                iterator = this.owner.model.getNameConverter().toPropertyName((String)object);
                object4 = this.owner.getOrCreateElement((String)object);
                if (((Element)object4).getClassInfo() != null) {
                    CClassInfo cClassInfo2 = ((Element)object4).getClassInfo();
                } else {
                    CTypeInfo cTypeInfo = ((Element)object4).getConversion().getInfo();
                }
                object3 = new CElementPropertyInfo((String)((Object)iterator), var8_18.isCollection() ? CElementPropertyInfo.CollectionMode.REPEATED_VALUE : CElementPropertyInfo.CollectionMode.NOT_REPEATED, ID.NONE, null, null, null, this.locator, !block.isOptional);
                ((CElementPropertyInfo)object3).getTypes().add(new CTypeRef((CNonElement)var8_18.getInfo(), new QName("", (String)object), false, null));
            }
            cClassInfo.addProperty((CPropertyInfo)object3);
        }
    }

    @Override
    public int compareTo(Element element) {
        return this.name.compareTo(element.name);
    }
}

