/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.AttributeException;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.DescriptorException;
import com.sun.tools.javap.Context;
import java.io.PrintWriter;

public class BasicWriter {
    private LineWriter lineWriter;
    private PrintWriter out;

    protected BasicWriter(Context context) {
        this.lineWriter = LineWriter.instance(context);
        this.out = context.get(PrintWriter.class);
    }

    protected void print(String string) {
        this.lineWriter.print(string);
    }

    protected void print(Object object) {
        this.lineWriter.print(object == null ? null : object.toString());
    }

    protected void println() {
        this.lineWriter.println();
    }

    protected void println(String string) {
        this.lineWriter.print(string);
        this.lineWriter.println();
    }

    protected void println(Object object) {
        this.lineWriter.print(object == null ? null : object.toString());
        this.lineWriter.println();
    }

    protected String report(AttributeException attributeException) {
        this.out.println("Error: " + attributeException.getMessage());
        return "???";
    }

    protected String report(ConstantPoolException constantPoolException) {
        this.out.println("Error: " + constantPoolException.getMessage());
        return "???";
    }

    protected String report(DescriptorException descriptorException) {
        this.out.println("Error: " + descriptorException.getMessage());
        return "???";
    }

    protected String report(String string) {
        this.out.println("Error: " + string);
        return "???";
    }

    private static class LineWriter {
        private PrintWriter out;
        private StringBuilder buffer;

        static LineWriter instance(Context context) {
            LineWriter lineWriter = context.get(LineWriter.class);
            if (lineWriter == null) {
                lineWriter = new LineWriter(context);
            }
            return lineWriter;
        }

        protected LineWriter(Context context) {
            context.put(LineWriter.class, this);
            this.out = context.get(PrintWriter.class);
            this.buffer = new StringBuilder();
        }

        protected void print(String string) {
            if (string == null) {
                string = "null";
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    this.println();
                    continue;
                }
                this.buffer.append(c);
            }
        }

        protected void println() {
            this.out.println(this.buffer);
            this.buffer.setLength(0);
        }
    }
}

