/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.script.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class Main {
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_CMD_NO_CLASSPATH = 1;
    private static final int EXIT_CMD_NO_FILE = 2;
    private static final int EXIT_CMD_NO_SCRIPT = 3;
    private static final int EXIT_CMD_NO_LANG = 4;
    private static final int EXIT_CMD_NO_ENCODING = 5;
    private static final int EXIT_CMD_NO_PROPNAME = 6;
    private static final int EXIT_UNKNOWN_OPTION = 7;
    private static final int EXIT_ENGINE_NOT_FOUND = 8;
    private static final int EXIT_NO_ENCODING_FOUND = 9;
    private static final int EXIT_SCRIPT_ERROR = 10;
    private static final int EXIT_FILE_NOT_FOUND = 11;
    private static final int EXIT_MULTIPLE_STDIN = 12;
    private static final String DEFAULT_LANGUAGE = "js";
    private static List<Command> scripts;
    private static ScriptEngineManager engineManager;
    private static Map<String, ScriptEngine> engines;
    private static ResourceBundle msgRes;
    private static String BUNDLE_NAME;
    private static String PROGRAM_NAME;

    public static void main(String[] stringArray) {
        String[] stringArray2 = Main.processOptions(stringArray);
        for (Command command : scripts) {
            command.run(stringArray2);
        }
        System.exit(0);
    }

    private static String[] processOptions(String[] stringArray) {
        String string = DEFAULT_LANGUAGE;
        String string2 = null;
        Main.checkClassPath(stringArray);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            int n;
            String string3 = stringArray[i];
            if (string3.equals("-classpath") || string3.equals("-cp")) {
                ++i;
                continue;
            }
            if (!string3.startsWith("-")) {
                String[] stringArray2;
                int n2;
                if (bl) {
                    n2 = stringArray.length - i;
                    n = i;
                } else {
                    n2 = stringArray.length - i - 1;
                    n = i + 1;
                    stringArray2 = Main.getScriptEngine(string);
                    Main.addFileSource((ScriptEngine)stringArray2, stringArray[i], string2);
                }
                stringArray2 = new String[n2];
                System.arraycopy(stringArray, n, stringArray2, 0, n2);
                return stringArray2;
            }
            if (string3.startsWith("-D")) {
                object = string3.substring(2);
                n = ((String)object).indexOf(61);
                if (n != -1) {
                    System.setProperty(((String)object).substring(0, n), ((String)object).substring(n + 1));
                    continue;
                }
                if (!((String)object).equals("")) {
                    System.setProperty((String)object, "");
                    continue;
                }
                Main.usage(6);
                continue;
            }
            if (string3.equals("-?") || string3.equals("-help")) {
                Main.usage(0);
            } else {
                if (string3.equals("-e")) {
                    bl = true;
                    if (++i == stringArray.length) {
                        Main.usage(3);
                    }
                    object = Main.getScriptEngine(string);
                    Main.addStringSource((ScriptEngine)object, stringArray[i]);
                    continue;
                }
                if (string3.equals("-encoding")) {
                    if (++i == stringArray.length) {
                        Main.usage(5);
                    }
                    string2 = stringArray[i];
                    continue;
                }
                if (string3.equals("-f")) {
                    bl = true;
                    if (++i == stringArray.length) {
                        Main.usage(2);
                    }
                    object = Main.getScriptEngine(string);
                    if (stringArray[i].equals("-")) {
                        if (bl2) {
                            Main.usage(12);
                        } else {
                            bl2 = true;
                        }
                        Main.addInteractiveMode((ScriptEngine)object);
                        continue;
                    }
                    Main.addFileSource((ScriptEngine)object, stringArray[i], string2);
                    continue;
                }
                if (string3.equals("-l")) {
                    if (++i == stringArray.length) {
                        Main.usage(4);
                    }
                    string = stringArray[i];
                    continue;
                }
                if (string3.equals("-q")) {
                    Main.listScriptEngines();
                }
            }
            Main.usage(7);
        }
        if (!bl) {
            ScriptEngine scriptEngine = Main.getScriptEngine(string);
            Main.addInteractiveMode(scriptEngine);
        }
        return new String[0];
    }

    private static void addInteractiveMode(final ScriptEngine scriptEngine) {
        scripts.add(new Command(){

            public void run(String[] stringArray) {
                Main.setScriptArguments(scriptEngine, stringArray);
                Main.processSource(scriptEngine, "-", null);
            }
        });
    }

    private static void addFileSource(final ScriptEngine scriptEngine, final String string, final String string2) {
        scripts.add(new Command(){

            public void run(String[] stringArray) {
                Main.setScriptArguments(scriptEngine, stringArray);
                Main.processSource(scriptEngine, string, string2);
            }
        });
    }

    private static void addStringSource(final ScriptEngine scriptEngine, final String string) {
        scripts.add(new Command(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(String[] stringArray) {
                Main.setScriptArguments(scriptEngine, stringArray);
                String string2 = Main.setScriptFilename(scriptEngine, "<string>");
                try {
                    Main.evaluateString(scriptEngine, string);
                }
                finally {
                    Main.setScriptFilename(scriptEngine, string2);
                }
            }
        });
    }

    private static void listScriptEngines() {
        List<ScriptEngineFactory> list = engineManager.getEngineFactories();
        for (ScriptEngineFactory scriptEngineFactory : list) {
            Main.getError().println(Main.getMessage("engine.info", new Object[]{scriptEngineFactory.getLanguageName(), scriptEngineFactory.getLanguageVersion(), scriptEngineFactory.getEngineName(), scriptEngineFactory.getEngineVersion()}));
        }
        System.exit(0);
    }

    private static void processSource(ScriptEngine scriptEngine, String string, String string2) {
        if (string.equals("-")) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Main.getIn()));
            boolean bl = false;
            String string3 = Main.getPrompt(scriptEngine);
            scriptEngine.put("javax.script.filename", "<STDIN>");
            while (!bl) {
                Main.getError().print(string3);
                String string4 = "";
                try {
                    string4 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    Main.getError().println(iOException.toString());
                }
                if (string4 == null) {
                    bl = true;
                    break;
                }
                Object object = Main.evaluateString(scriptEngine, string4, false);
                if (object == null) continue;
                if ((object = object.toString()) == null) {
                    object = "null";
                }
                Main.getError().println(object);
            }
        } else {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Main.getError().println(Main.getMessage("file.not.found", new Object[]{string}));
                System.exit(11);
            }
            Main.evaluateStream(scriptEngine, fileInputStream, string, string2);
        }
    }

    private static Object evaluateString(ScriptEngine scriptEngine, String string, boolean bl) {
        block4: {
            try {
                return scriptEngine.eval(string);
            }
            catch (ScriptException scriptException) {
                Main.getError().println(Main.getMessage("string.script.error", new Object[]{scriptException.getMessage()}));
                if (bl) {
                    System.exit(10);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Main.getError());
                if (!bl) break block4;
                System.exit(10);
            }
        }
        return null;
    }

    private static void evaluateString(ScriptEngine scriptEngine, String string) {
        Main.evaluateString(scriptEngine, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object evaluateReader(ScriptEngine scriptEngine, Reader reader, String string) {
        String string2 = Main.setScriptFilename(scriptEngine, string);
        try {
            Object object = scriptEngine.eval(reader);
            return object;
        }
        catch (ScriptException scriptException) {
            Main.getError().println(Main.getMessage("file.script.error", new Object[]{string, scriptException.getMessage()}));
            System.exit(10);
        }
        catch (Exception exception) {
            exception.printStackTrace(Main.getError());
            System.exit(10);
        }
        finally {
            Main.setScriptFilename(scriptEngine, string2);
        }
        return null;
    }

    private static Object evaluateStream(ScriptEngine scriptEngine, InputStream inputStream, String string, String string2) {
        BufferedReader bufferedReader = null;
        if (string2 != null) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Main.getError().println(Main.getMessage("encoding.unsupported", new Object[]{string2}));
                System.exit(9);
            }
        } else {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        return Main.evaluateReader(scriptEngine, bufferedReader, string);
    }

    private static void usage(int n) {
        Main.getError().println(Main.getMessage("main.usage", new Object[]{PROGRAM_NAME}));
        System.exit(n);
    }

    private static String getPrompt(ScriptEngine scriptEngine) {
        List<String> list = scriptEngine.getFactory().getNames();
        return list.get(0) + "> ";
    }

    private static String getMessage(String string, Object[] objectArray) {
        return MessageFormat.format(msgRes.getString(string), objectArray);
    }

    private static InputStream getIn() {
        return System.in;
    }

    private static PrintStream getError() {
        return System.err;
    }

    private static ScriptEngine getScriptEngine(String string) {
        ScriptEngine scriptEngine = engines.get(string);
        if (scriptEngine == null) {
            scriptEngine = engineManager.getEngineByName(string);
            if (scriptEngine == null) {
                Main.getError().println(Main.getMessage("engine.not.found", new Object[]{string}));
                System.exit(8);
            }
            Main.initScriptEngine(scriptEngine);
            engines.put(string, scriptEngine);
        }
        return scriptEngine;
    }

    private static void initScriptEngine(ScriptEngine scriptEngine) {
        scriptEngine.put("engine", scriptEngine);
        List<String> list = scriptEngine.getFactory().getExtensions();
        InputStream inputStream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String string : list) {
            inputStream = classLoader.getResourceAsStream("com/sun/tools/script/shell/init." + string);
            if (inputStream == null) continue;
            break;
        }
        if (inputStream != null) {
            Main.evaluateStream(scriptEngine, inputStream, "<system-init>", null);
        }
    }

    private static void checkClassPath(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-classpath") && !stringArray[i].equals("-cp")) continue;
            if (++i == stringArray.length) {
                Main.usage(1);
                continue;
            }
            string = stringArray[i];
        }
        if (string != null) {
            ClassLoader classLoader = Main.class.getClassLoader();
            URL[] uRLArray = Main.pathToURLs(string);
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
        }
        engineManager = new ScriptEngineManager();
    }

    private static URL[] pathToURLs(String string) {
        Object object;
        String[] stringArray = string.split(File.pathSeparator);
        URL[] uRLArray = new URL[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            object = Main.fileToURL(new File(stringArray[n]));
            if (object == null) continue;
            uRLArray[n++] = object;
        }
        if (uRLArray.length != n) {
            object = new URL[n];
            System.arraycopy(uRLArray, 0, object, 0, n);
            uRLArray = object;
        }
        return uRLArray;
    }

    private static URL fileToURL(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!file.isFile()) {
            string = string + "/";
        }
        try {
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("file");
        }
    }

    private static void setScriptArguments(ScriptEngine scriptEngine, String[] stringArray) {
        scriptEngine.put("arguments", stringArray);
        scriptEngine.put("javax.script.argv", stringArray);
    }

    private static String setScriptFilename(ScriptEngine scriptEngine, String string) {
        String string2 = (String)scriptEngine.get("javax.script.filename");
        scriptEngine.put("javax.script.filename", string);
        return string2;
    }

    static {
        BUNDLE_NAME = "com.sun.tools.script.shell.messages";
        PROGRAM_NAME = "jrunscript";
        scripts = new ArrayList<Command>();
        engines = new HashMap<String, ScriptEngine>();
        msgRes = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    }

    private static interface Command {
        public void run(String[] var1);
    }
}

