/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashSet;
import java.util.Set;
import sun.tools.jstat.Alignment;
import sun.tools.jstat.ColumnFormat;
import sun.tools.jstat.Expression;
import sun.tools.jstat.Identifier;
import sun.tools.jstat.Literal;
import sun.tools.jstat.Operator;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.ParserException;
import sun.tools.jstat.Scale;
import sun.tools.jstat.SyntaxException;
import sun.tools.jstat.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static boolean pdebug = Boolean.getBoolean("jstat.parser.debug");
    private static boolean ldebug = Boolean.getBoolean("jstat.lex.debug");
    private static final char OPENBLOCK = '{';
    private static final char CLOSEBLOCK = '}';
    private static final char DOUBLEQUOTE = '\"';
    private static final char PERCENT_CHAR = '%';
    private static final char OPENPAREN = '(';
    private static final char CLOSEPAREN = ')';
    private static final char OPERATOR_PLUS = '+';
    private static final char OPERATOR_MINUS = '-';
    private static final char OPERATOR_MULTIPLY = '*';
    private static final char OPERATOR_DIVIDE = '/';
    private static final String OPTION = "option";
    private static final String COLUMN = "column";
    private static final String DATA = "data";
    private static final String HEADER = "header";
    private static final String WIDTH = "width";
    private static final String FORMAT = "format";
    private static final String ALIGN = "align";
    private static final String SCALE = "scale";
    private static final String START = "option";
    private static final Set scaleKeyWords = Scale.keySet();
    private static final Set alignKeyWords = Alignment.keySet();
    private static String[] otherKeyWords = new String[]{"option", "column", "data", "header", "width", "format", "align", "scale"};
    private static char[] infixOps = new char[]{'+', '-', '*', '/'};
    private static char[] delimiters = new char[]{'{', '}', '%', '(', ')'};
    private static Set<String> reservedWords;
    private StreamTokenizer st;
    private String filename;
    private Token lookahead;
    private Token previous;
    private int columnCount;
    private OptionFormat optionFormat;

    public Parser(String string) throws FileNotFoundException {
        this.filename = string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
    }

    public Parser(Reader reader) {
        int n;
        this.st = new StreamTokenizer(reader);
        this.st.ordinaryChar(47);
        this.st.wordChars(95, 95);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        reservedWords = new HashSet<String>();
        for (n = 0; n < otherKeyWords.length; ++n) {
            reservedWords.add(otherKeyWords[n]);
        }
        for (n = 0; n < delimiters.length; ++n) {
            this.st.ordinaryChar(delimiters[n]);
        }
        for (n = 0; n < infixOps.length; ++n) {
            this.st.ordinaryChar(infixOps[n]);
        }
    }

    private void pushBack() {
        this.lookahead = this.previous;
        this.st.pushBack();
    }

    private void nextToken() throws ParserException, IOException {
        int n = this.st.nextToken();
        this.previous = this.lookahead;
        this.lookahead = new Token(this.st.ttype, this.st.sval, this.st.nval);
        this.log(ldebug, "lookahead = " + this.lookahead);
    }

    private Token matchOne(Set set) throws ParserException, IOException {
        if (this.lookahead.ttype == -3 && set.contains(this.lookahead.sval)) {
            Token token = this.lookahead;
            this.nextToken();
            return token;
        }
        throw new SyntaxException(this.st.lineno(), set, this.lookahead);
    }

    private void match(int n, String string) throws ParserException, IOException {
        if (this.lookahead.ttype != n || this.lookahead.sval.compareTo(string) != 0) {
            throw new SyntaxException(this.st.lineno(), new Token(n, string), this.lookahead);
        }
        this.nextToken();
    }

    private void match(int n) throws ParserException, IOException {
        if (this.lookahead.ttype != n) {
            throw new SyntaxException(this.st.lineno(), new Token(n), this.lookahead);
        }
        this.nextToken();
    }

    private void match(char c) throws ParserException, IOException {
        if (this.lookahead.ttype != c) {
            throw new SyntaxException(this.st.lineno(), new Token(c), this.lookahead);
        }
        this.nextToken();
    }

    private void matchQuotedString() throws ParserException, IOException {
        this.match('\"');
    }

    private void matchNumber() throws ParserException, IOException {
        this.match(-2);
    }

    private void matchID() throws ParserException, IOException {
        this.match(-3);
    }

    private void match(String string) throws ParserException, IOException {
        this.match(-3, string);
    }

    private boolean isReservedWord(String string) {
        return reservedWords.contains(string);
    }

    private boolean isInfixOperator(char c) {
        for (int i = 0; i < infixOps.length; ++i) {
            if (c != infixOps[i]) continue;
            return true;
        }
        return false;
    }

    private void scaleStmt(ColumnFormat columnFormat) throws ParserException, IOException {
        this.match(SCALE);
        Token token = this.matchOne(scaleKeyWords);
        columnFormat.setScale(Scale.toScale(token.sval));
        String string = token.sval;
        this.log(pdebug, "Parsed: scale -> " + string);
    }

    private void alignStmt(ColumnFormat columnFormat) throws ParserException, IOException {
        this.match(ALIGN);
        Token token = this.matchOne(alignKeyWords);
        columnFormat.setAlignment(Alignment.toAlignment(token.sval));
        String string = token.sval;
        this.log(pdebug, "Parsed: align -> " + string);
    }

    private void headerStmt(ColumnFormat columnFormat) throws ParserException, IOException {
        this.match(HEADER);
        String string = this.lookahead.sval;
        this.matchQuotedString();
        columnFormat.setHeader(string);
        this.log(pdebug, "Parsed: header -> " + string);
    }

    private void widthStmt(ColumnFormat columnFormat) throws ParserException, IOException {
        this.match(WIDTH);
        double d = this.lookahead.nval;
        this.matchNumber();
        columnFormat.setWidth((int)d);
        this.log(pdebug, "Parsed: width -> " + d);
    }

    private void formatStmt(ColumnFormat columnFormat) throws ParserException, IOException {
        this.match(FORMAT);
        String string = this.lookahead.sval;
        this.matchQuotedString();
        columnFormat.setFormat(string);
        this.log(pdebug, "Parsed: format -> " + string);
    }

    private Expression primary() throws ParserException, IOException {
        Expression expression = null;
        switch (this.lookahead.ttype) {
            case 40: {
                this.match('(');
                expression = this.expression();
                this.match(')');
                break;
            }
            case -3: {
                String string = this.lookahead.sval;
                if (this.isReservedWord(string)) {
                    throw new SyntaxException(this.st.lineno(), "IDENTIFIER", "Reserved Word: " + this.lookahead.sval);
                }
                this.matchID();
                expression = new Identifier(string);
                this.log(pdebug, "Parsed: ID -> " + string);
                break;
            }
            case -2: {
                double d = this.lookahead.nval;
                this.matchNumber();
                expression = new Literal(new Double(d));
                this.log(pdebug, "Parsed: number -> " + d);
                break;
            }
            default: {
                throw new SyntaxException(this.st.lineno(), "IDENTIFIER", this.lookahead);
            }
        }
        this.log(pdebug, "Parsed: primary -> " + expression);
        return expression;
    }

    private Expression unary() throws ParserException, IOException {
        Expression expression = null;
        Operator operator = null;
        while (true) {
            switch (this.lookahead.ttype) {
                case 43: {
                    this.match('+');
                    operator = Operator.PLUS;
                    break;
                }
                case 45: {
                    this.match('-');
                    operator = Operator.MINUS;
                    break;
                }
                default: {
                    expression = this.primary();
                    this.log(pdebug, "Parsed: unary -> " + expression);
                    return expression;
                }
            }
            Expression expression2 = new Expression();
            expression2.setOperator(operator);
            expression2.setRight(expression);
            this.log(pdebug, "Parsed: unary -> " + expression2);
            expression2.setLeft(new Literal(new Double(0.0)));
            expression = expression2;
        }
    }

    private Expression multExpression() throws ParserException, IOException {
        Expression expression = this.unary();
        Operator operator = null;
        while (true) {
            switch (this.lookahead.ttype) {
                case 42: {
                    this.match('*');
                    operator = Operator.MULTIPLY;
                    break;
                }
                case 47: {
                    this.match('/');
                    operator = Operator.DIVIDE;
                    break;
                }
                default: {
                    this.log(pdebug, "Parsed: multExpression -> " + expression);
                    return expression;
                }
            }
            Expression expression2 = new Expression();
            expression2.setOperator(operator);
            expression2.setLeft(expression);
            expression2.setRight(this.unary());
            expression = expression2;
            this.log(pdebug, "Parsed: multExpression -> " + expression);
        }
    }

    private Expression addExpression() throws ParserException, IOException {
        Expression expression = this.multExpression();
        Operator operator = null;
        while (true) {
            switch (this.lookahead.ttype) {
                case 43: {
                    this.match('+');
                    operator = Operator.PLUS;
                    break;
                }
                case 45: {
                    this.match('-');
                    operator = Operator.MINUS;
                    break;
                }
                default: {
                    this.log(pdebug, "Parsed: addExpression -> " + expression);
                    return expression;
                }
            }
            Expression expression2 = new Expression();
            expression2.setOperator(operator);
            expression2.setLeft(expression);
            expression2.setRight(this.multExpression());
            expression = expression2;
            this.log(pdebug, "Parsed: addExpression -> " + expression);
        }
    }

    private Expression expression() throws ParserException, IOException {
        Expression expression = this.addExpression();
        this.log(pdebug, "Parsed: expression -> " + expression);
        return expression;
    }

    private void dataStmt(ColumnFormat columnFormat) throws ParserException, IOException {
        this.match(DATA);
        Expression expression = this.expression();
        columnFormat.setExpression(expression);
        this.log(pdebug, "Parsed: data -> " + expression);
    }

    private void statementList(ColumnFormat columnFormat) throws ParserException, IOException {
        while (true) {
            if (this.lookahead.ttype != -3) {
                return;
            }
            if (this.lookahead.sval.compareTo(DATA) == 0) {
                this.dataStmt(columnFormat);
                continue;
            }
            if (this.lookahead.sval.compareTo(HEADER) == 0) {
                this.headerStmt(columnFormat);
                continue;
            }
            if (this.lookahead.sval.compareTo(WIDTH) == 0) {
                this.widthStmt(columnFormat);
                continue;
            }
            if (this.lookahead.sval.compareTo(FORMAT) == 0) {
                this.formatStmt(columnFormat);
                continue;
            }
            if (this.lookahead.sval.compareTo(ALIGN) == 0) {
                this.alignStmt(columnFormat);
                continue;
            }
            if (this.lookahead.sval.compareTo(SCALE) != 0) break;
            this.scaleStmt(columnFormat);
        }
    }

    private void optionList(OptionFormat optionFormat) throws ParserException, IOException {
        while (this.lookahead.ttype == -3) {
            this.match(COLUMN);
            this.match('{');
            ColumnFormat columnFormat = new ColumnFormat(this.columnCount++);
            this.statementList(columnFormat);
            this.match('}');
            columnFormat.validate();
            optionFormat.addSubFormat(columnFormat);
        }
        return;
    }

    private OptionFormat optionStmt() throws ParserException, IOException {
        this.match("option");
        String string = this.lookahead.sval;
        this.matchID();
        this.match('{');
        OptionFormat optionFormat = new OptionFormat(string);
        this.optionList(optionFormat);
        this.match('}');
        return optionFormat;
    }

    public OptionFormat parse(String string) throws ParserException, IOException {
        this.nextToken();
        while (this.lookahead.ttype != -1) {
            if (this.lookahead.ttype != -3 || this.lookahead.sval.compareTo("option") != 0) {
                this.nextToken();
                continue;
            }
            this.match("option");
            if (this.lookahead.ttype == -3 && this.lookahead.sval.compareTo(string) == 0) {
                this.pushBack();
                return this.optionStmt();
            }
            this.nextToken();
        }
        return null;
    }

    public Set<OptionFormat> parseOptions() throws ParserException, IOException {
        HashSet<OptionFormat> hashSet = new HashSet<OptionFormat>();
        this.nextToken();
        while (this.lookahead.ttype != -1) {
            if (this.lookahead.ttype != -3 || this.lookahead.sval.compareTo("option") != 0) {
                this.nextToken();
                continue;
            }
            OptionFormat optionFormat = this.optionStmt();
            hashSet.add(optionFormat);
        }
        return hashSet;
    }

    OptionFormat getOptionFormat() {
        return this.optionFormat;
    }

    private void log(boolean bl, String string) {
        if (bl) {
            System.out.println(string);
        }
    }
}

