/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AuthProvider;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import sun.security.util.Password;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreLoginModule
implements LoginModule {
    static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.AuthResources");
    private static final int UNINITIALIZED = 0;
    private static final int INITIALIZED = 1;
    private static final int AUTHENTICATED = 2;
    private static final int LOGGED_IN = 3;
    private static final int PROTECTED_PATH = 0;
    private static final int TOKEN = 1;
    private static final int NORMAL = 2;
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final TextOutputCallback bannerCallback = new TextOutputCallback(0, rb.getString("Please enter keystore information"));
    private final ConfirmationCallback confirmationCallback = new ConfirmationCallback(0, 2, 3);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map<String, ?> options;
    private char[] keyStorePassword;
    private char[] privateKeyPassword;
    private KeyStore keyStore;
    private String keyStoreURL;
    private String keyStoreType;
    private String keyStoreProvider;
    private String keyStoreAlias;
    private String keyStorePasswordURL;
    private String privateKeyPasswordURL;
    private boolean debug;
    private X500Principal principal;
    private Certificate[] fromKeyStore;
    private CertPath certP = null;
    private X500PrivateCredential privateCredential;
    private int status = 0;
    private boolean nullStream = false;
    private boolean token = false;
    private boolean protectedPath = false;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.processOptions();
        this.status = 1;
    }

    private void processOptions() {
        this.keyStoreURL = (String)this.options.get("keyStoreURL");
        if (this.keyStoreURL == null) {
            this.keyStoreURL = "file:" + System.getProperty("user.home").replace(File.separatorChar, '/') + '/' + ".keystore";
        } else if (NONE.equals(this.keyStoreURL)) {
            this.nullStream = true;
        }
        this.keyStoreType = (String)this.options.get("keyStoreType");
        if (this.keyStoreType == null) {
            this.keyStoreType = KeyStore.getDefaultType();
        }
        if (P11KEYSTORE.equalsIgnoreCase(this.keyStoreType)) {
            this.token = true;
        }
        this.keyStoreProvider = (String)this.options.get("keyStoreProvider");
        this.keyStoreAlias = (String)this.options.get("keyStoreAlias");
        this.keyStorePasswordURL = (String)this.options.get("keyStorePasswordURL");
        this.privateKeyPasswordURL = (String)this.options.get("privateKeyPasswordURL");
        this.protectedPath = "true".equalsIgnoreCase((String)this.options.get("protected"));
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug) {
            this.debugPrint(null);
            this.debugPrint("keyStoreURL=" + this.keyStoreURL);
            this.debugPrint("keyStoreType=" + this.keyStoreType);
            this.debugPrint("keyStoreProvider=" + this.keyStoreProvider);
            this.debugPrint("keyStoreAlias=" + this.keyStoreAlias);
            this.debugPrint("keyStorePasswordURL=" + this.keyStorePasswordURL);
            this.debugPrint("privateKeyPasswordURL=" + this.privateKeyPasswordURL);
            this.debugPrint("protectedPath=" + this.protectedPath);
            this.debugPrint(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login() throws LoginException {
        switch (this.status) {
            default: {
                throw new LoginException("The login module is not initialized");
            }
            case 1: 
            case 2: {
                if (this.token && !this.nullStream) {
                    throw new LoginException("if keyStoreType is PKCS11 then keyStoreURL must be NONE");
                }
                if (this.token && this.privateKeyPasswordURL != null) {
                    throw new LoginException("if keyStoreType is PKCS11 then privateKeyPasswordURL must not be specified");
                }
                if (this.protectedPath && (this.keyStorePasswordURL != null || this.privateKeyPasswordURL != null)) {
                    throw new LoginException("if protected is true then keyStorePasswordURL and privateKeyPasswordURL must not be specified");
                }
                if (this.protectedPath) {
                    this.getAliasAndPasswords(0);
                } else if (this.token) {
                    this.getAliasAndPasswords(1);
                } else {
                    this.getAliasAndPasswords(2);
                }
                try {
                    this.getKeyStoreInfo();
                }
                finally {
                    if (this.privateKeyPassword != null && this.privateKeyPassword != this.keyStorePassword) {
                        Arrays.fill(this.privateKeyPassword, '\u0000');
                        this.privateKeyPassword = null;
                    }
                    if (this.keyStorePassword != null) {
                        Arrays.fill(this.keyStorePassword, '\u0000');
                        this.keyStorePassword = null;
                    }
                }
                this.status = 2;
                return true;
            }
            case 3: 
        }
        return true;
    }

    private void getAliasAndPasswords(int n) throws LoginException {
        if (this.callbackHandler == null) {
            switch (n) {
                case 0: {
                    this.checkAlias();
                    break;
                }
                case 1: {
                    this.checkAlias();
                    this.checkStorePass();
                    break;
                }
                case 2: {
                    this.checkAlias();
                    this.checkStorePass();
                    this.checkKeyPass();
                }
            }
        } else {
            NameCallback nameCallback = this.keyStoreAlias == null || this.keyStoreAlias.length() == 0 ? new NameCallback(rb.getString("Keystore alias: ")) : new NameCallback(rb.getString("Keystore alias: "), this.keyStoreAlias);
            PasswordCallback passwordCallback = null;
            PasswordCallback passwordCallback2 = null;
            switch (n) {
                case 0: {
                    break;
                }
                case 2: {
                    passwordCallback2 = new PasswordCallback(rb.getString("Private key password (optional): "), false);
                }
                case 1: {
                    passwordCallback = new PasswordCallback(rb.getString("Keystore password: "), false);
                }
            }
            this.prompt(nameCallback, passwordCallback, passwordCallback2);
        }
        if (this.debug) {
            this.debugPrint("alias=" + this.keyStoreAlias);
        }
    }

    private void checkAlias() throws LoginException {
        if (this.keyStoreAlias == null) {
            throw new LoginException("Need to specify an alias option to use KeyStoreLoginModule non-interactively.");
        }
    }

    private void checkStorePass() throws LoginException {
        if (this.keyStorePasswordURL == null) {
            throw new LoginException("Need to specify keyStorePasswordURL option to use KeyStoreLoginModule non-interactively.");
        }
        InputStream inputStream = null;
        try {
            inputStream = new URL(this.keyStorePasswordURL).openStream();
            this.keyStorePassword = Password.readPassword(inputStream);
        }
        catch (IOException iOException) {
            LoginException loginException = new LoginException("Problem accessing keystore password \"" + this.keyStorePasswordURL + "\"");
            loginException.initCause(iOException);
            throw loginException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LoginException loginException = new LoginException("Problem closing the keystore password stream");
                    loginException.initCause(iOException);
                    throw loginException;
                }
            }
        }
    }

    private void checkKeyPass() throws LoginException {
        if (this.privateKeyPasswordURL == null) {
            this.privateKeyPassword = this.keyStorePassword;
        } else {
            InputStream inputStream = null;
            try {
                inputStream = new URL(this.privateKeyPasswordURL).openStream();
                this.privateKeyPassword = Password.readPassword(inputStream);
            }
            catch (IOException iOException) {
                LoginException loginException = new LoginException("Problem accessing private key password \"" + this.privateKeyPasswordURL + "\"");
                loginException.initCause(iOException);
                throw loginException;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        LoginException loginException = new LoginException("Problem closing the private key password stream");
                        loginException.initCause(iOException);
                        throw loginException;
                    }
                }
            }
        }
    }

    private void prompt(NameCallback nameCallback, PasswordCallback passwordCallback, PasswordCallback passwordCallback2) throws LoginException {
        if (passwordCallback == null) {
            try {
                this.callbackHandler.handle(new Callback[]{bannerCallback, nameCallback, this.confirmationCallback});
            }
            catch (IOException iOException) {
                LoginException loginException = new LoginException("Problem retrieving keystore alias");
                loginException.initCause(iOException);
                throw loginException;
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " is not available to retrieve authentication " + " information from the user");
            }
            int n = this.confirmationCallback.getSelectedIndex();
            if (n == 2) {
                throw new LoginException("Login cancelled");
            }
            this.saveAlias(nameCallback);
        } else if (passwordCallback2 == null) {
            try {
                this.callbackHandler.handle(new Callback[]{bannerCallback, nameCallback, passwordCallback, this.confirmationCallback});
            }
            catch (IOException iOException) {
                LoginException loginException = new LoginException("Problem retrieving keystore alias and password");
                loginException.initCause(iOException);
                throw loginException;
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " is not available to retrieve authentication " + " information from the user");
            }
            int n = this.confirmationCallback.getSelectedIndex();
            if (n == 2) {
                throw new LoginException("Login cancelled");
            }
            this.saveAlias(nameCallback);
            this.saveStorePass(passwordCallback);
        } else {
            try {
                this.callbackHandler.handle(new Callback[]{bannerCallback, nameCallback, passwordCallback, passwordCallback2, this.confirmationCallback});
            }
            catch (IOException iOException) {
                LoginException loginException = new LoginException("Problem retrieving keystore alias and passwords");
                loginException.initCause(iOException);
                throw loginException;
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " is not available to retrieve authentication " + " information from the user");
            }
            int n = this.confirmationCallback.getSelectedIndex();
            if (n == 2) {
                throw new LoginException("Login cancelled");
            }
            this.saveAlias(nameCallback);
            this.saveStorePass(passwordCallback);
            this.saveKeyPass(passwordCallback2);
        }
    }

    private void saveAlias(NameCallback nameCallback) {
        this.keyStoreAlias = nameCallback.getName();
    }

    private void saveStorePass(PasswordCallback passwordCallback) {
        this.keyStorePassword = passwordCallback.getPassword();
        if (this.keyStorePassword == null) {
            this.keyStorePassword = new char[0];
        }
        passwordCallback.clearPassword();
    }

    private void saveKeyPass(PasswordCallback passwordCallback) {
        this.privateKeyPassword = passwordCallback.getPassword();
        if (this.privateKeyPassword == null || this.privateKeyPassword.length == 0) {
            this.privateKeyPassword = this.keyStorePassword;
        }
        passwordCallback.clearPassword();
    }

    private void getKeyStoreInfo() throws LoginException {
        Object object;
        Serializable serializable;
        try {
            this.keyStore = this.keyStoreProvider == null ? KeyStore.getInstance(this.keyStoreType) : KeyStore.getInstance(this.keyStoreType, this.keyStoreProvider);
        }
        catch (KeyStoreException keyStoreException) {
            LoginException loginException = new LoginException("The specified keystore type was not available");
            loginException.initCause(keyStoreException);
            throw loginException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            LoginException loginException = new LoginException("The specified keystore provider was not available");
            loginException.initCause(noSuchProviderException);
            throw loginException;
        }
        InputStream inputStream = null;
        try {
            if (this.nullStream) {
                this.keyStore.load(null, this.keyStorePassword);
            } else {
                inputStream = new URL(this.keyStoreURL).openStream();
                this.keyStore.load(inputStream, this.keyStorePassword);
            }
        }
        catch (MalformedURLException malformedURLException) {
            LoginException loginException = new LoginException("Incorrect keyStoreURL option");
            loginException.initCause(malformedURLException);
            throw loginException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            LoginException loginException = new LoginException("Error initializing keystore");
            loginException.initCause(generalSecurityException);
            throw loginException;
        }
        catch (IOException iOException) {
            LoginException loginException = new LoginException("Error initializing keystore");
            loginException.initCause(iOException);
            throw loginException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LoginException loginException = new LoginException("Error initializing keystore");
                    loginException.initCause(iOException);
                    throw loginException;
                }
            }
        }
        try {
            this.fromKeyStore = this.keyStore.getCertificateChain(this.keyStoreAlias);
            if (this.fromKeyStore == null || this.fromKeyStore.length == 0 || !(this.fromKeyStore[0] instanceof X509Certificate)) {
                throw new FailedLoginException("Unable to find X.509 certificate chain in keystore");
            }
            serializable = new LinkedList<Certificate>();
            for (int i = 0; i < this.fromKeyStore.length; ++i) {
                ((LinkedList)serializable).add(this.fromKeyStore[i]);
            }
            object = CertificateFactory.getInstance("X.509");
            this.certP = ((CertificateFactory)object).generateCertPath((List<? extends Certificate>)((Object)serializable));
        }
        catch (KeyStoreException keyStoreException) {
            LoginException loginException = new LoginException("Error using keystore");
            loginException.initCause(keyStoreException);
            throw loginException;
        }
        catch (CertificateException certificateException) {
            LoginException loginException = new LoginException("Error: X.509 Certificate type unavailable");
            loginException.initCause(certificateException);
            throw loginException;
        }
        try {
            serializable = (X509Certificate)this.fromKeyStore[0];
            this.principal = new X500Principal(((X509Certificate)serializable).getSubjectDN().getName());
            object = this.keyStore.getKey(this.keyStoreAlias, this.privateKeyPassword);
            if (object == null || !(object instanceof PrivateKey)) {
                throw new FailedLoginException("Unable to recover key from keystore");
            }
            this.privateCredential = new X500PrivateCredential((X509Certificate)serializable, (PrivateKey)object, this.keyStoreAlias);
        }
        catch (KeyStoreException keyStoreException) {
            object = new LoginException("Error using keystore");
            ((Throwable)object).initCause(keyStoreException);
            throw object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            object = new LoginException("Error using keystore");
            ((Throwable)object).initCause(noSuchAlgorithmException);
            throw object;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            object = new FailedLoginException("Unable to recover key from keystore");
            ((Throwable)object).initCause(unrecoverableKeyException);
            throw object;
        }
        if (this.debug) {
            this.debugPrint("principal=" + this.principal + "\n certificate=" + this.privateCredential.getCertificate() + "\n alias =" + this.privateCredential.getAlias());
        }
    }

    @Override
    public boolean commit() throws LoginException {
        switch (this.status) {
            default: {
                throw new LoginException("The login module is not initialized");
            }
            case 1: {
                this.logoutInternal();
                throw new LoginException("Authentication failed");
            }
            case 2: {
                if (this.commitInternal()) {
                    return true;
                }
                this.logoutInternal();
                throw new LoginException("Unable to retrieve certificates");
            }
            case 3: 
        }
        return true;
    }

    private boolean commitInternal() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is set readonly");
        }
        this.subject.getPrincipals().add(this.principal);
        this.subject.getPublicCredentials().add(this.certP);
        this.subject.getPrivateCredentials().add(this.privateCredential);
        this.status = 3;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        switch (this.status) {
            default: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                this.logoutInternal();
                return true;
            }
            case 3: 
        }
        this.logoutInternal();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.debug) {
            this.debugPrint("Entering logout " + this.status);
        }
        switch (this.status) {
            case 0: {
                throw new LoginException("The login module is not initialized");
            }
            default: {
                return false;
            }
            case 3: 
        }
        this.logoutInternal();
        return true;
    }

    private void logoutInternal() throws LoginException {
        if (this.debug) {
            this.debugPrint("Entering logoutInternal");
        }
        LoginException loginException = null;
        Provider provider = this.keyStore.getProvider();
        if (provider instanceof AuthProvider) {
            AuthProvider authProvider = (AuthProvider)provider;
            try {
                authProvider.logout();
                if (this.debug) {
                    this.debugPrint("logged out of KeyStore AuthProvider");
                }
            }
            catch (LoginException loginException2) {
                loginException = loginException2;
            }
        }
        if (this.subject.isReadOnly()) {
            this.principal = null;
            this.certP = null;
            this.status = 1;
            for (Object e : this.subject.getPrivateCredentials()) {
                if (!this.privateCredential.equals(e)) continue;
                this.privateCredential = null;
                try {
                    ((Destroyable)e).destroy();
                    if (!this.debug) break;
                    this.debugPrint("Destroyed private credential, " + e.getClass().getName());
                    break;
                }
                catch (DestroyFailedException destroyFailedException) {
                    LoginException loginException2 = new LoginException("Unable to destroy private credential, " + e.getClass().getName());
                    loginException2.initCause(destroyFailedException);
                    throw loginException2;
                }
            }
            throw new LoginException("Unable to remove Principal (X500Principal ) and public credential (certificatepath) from read-only Subject");
        }
        if (this.principal != null) {
            this.subject.getPrincipals().remove(this.principal);
            this.principal = null;
        }
        if (this.certP != null) {
            this.subject.getPublicCredentials().remove(this.certP);
            this.certP = null;
        }
        if (this.privateCredential != null) {
            this.subject.getPrivateCredentials().remove(this.privateCredential);
            this.privateCredential = null;
        }
        if (loginException != null) {
            throw loginException;
        }
        this.status = 1;
    }

    private void debugPrint(String string) {
        if (string == null) {
            System.err.println();
        } else {
            System.err.println("Debug KeyStoreLoginModule: " + string);
        }
    }
}

