/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.FontFormatException;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import sun.font.AttributeMap;
import sun.font.AttributeValues;
import sun.font.CompositeFont;
import sun.font.CoreMetrics;
import sun.font.EAttribute;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontLineMetrics;
import sun.font.FontManager;
import sun.font.GlyphLayout;
import sun.font.StandardGlyphVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
implements Serializable {
    private Hashtable fRequestedAttributes;
    public static final String DIALOG = "Dialog";
    public static final String DIALOG_INPUT = "DialogInput";
    public static final String SANS_SERIF = "SansSerif";
    public static final String SERIF = "Serif";
    public static final String MONOSPACED = "Monospaced";
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    public static final int TYPE1_FONT = 1;
    protected String name;
    protected int style;
    protected int size;
    protected float pointSize;
    private transient FontPeer peer;
    private transient long pData;
    private transient Font2DHandle font2DHandle;
    private transient AttributeValues values;
    private transient boolean hasLayoutAttributes;
    private transient boolean createdFont = false;
    private transient boolean nonIdentityTx;
    private static final AffineTransform identityTx;
    private static final long serialVersionUID = -4206021311591459213L;
    private static final int RECOGNIZED_MASK;
    private static final int PRIMARY_MASK;
    private static final int SECONDARY_MASK;
    private static final int LAYOUT_MASK;
    private static final int EXTRA_MASK;
    private static final float[] ssinfo;
    transient int hash;
    private int fontSerializedDataVersion = 1;
    private transient SoftReference flmref;
    public static final int LAYOUT_LEFT_TO_RIGHT = 0;
    public static final int LAYOUT_RIGHT_TO_LEFT = 1;
    public static final int LAYOUT_NO_START_CONTEXT = 2;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 4;

    @Deprecated
    public FontPeer getPeer() {
        return this.getPeer_NoClientCode();
    }

    final FontPeer getPeer_NoClientCode() {
        if (this.peer == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.peer = toolkit.getFontPeer(this.name, this.style);
        }
        return this.peer;
    }

    private AttributeValues getAttributeValues() {
        if (this.values == null) {
            this.values = new AttributeValues();
            this.values.setFamily(this.name);
            this.values.setSize(this.pointSize);
            if ((this.style & 1) != 0) {
                this.values.setWeight(2.0f);
            }
            if ((this.style & 2) != 0) {
                this.values.setPosture(0.2f);
            }
            this.values.defineAll(PRIMARY_MASK);
        }
        return this.values;
    }

    private Font2D getFont2D() {
        if (FontManager.usingPerAppContextComposites && this.font2DHandle != null && this.font2DHandle.font2D instanceof CompositeFont && ((CompositeFont)this.font2DHandle.font2D).isStdComposite()) {
            return FontManager.findFont2D(this.name, this.style, 2);
        }
        if (this.font2DHandle == null) {
            this.font2DHandle = FontManager.findFont2D((String)this.name, (int)this.style, (int)2).handle;
        }
        return this.font2DHandle.font2D;
    }

    public Font(String string, int n, int n2) {
        this.name = string != null ? string : "Default";
        this.style = (n & 0xFFFFFFFC) == 0 ? n : 0;
        this.size = n2;
        this.pointSize = n2;
    }

    private Font(String string, int n, float f) {
        this.name = string != null ? string : "Default";
        this.style = (n & 0xFFFFFFFC) == 0 ? n : 0;
        this.size = (int)((double)f + 0.5);
        this.pointSize = f;
    }

    private Font(String string, int n, float f, boolean bl, Font2DHandle font2DHandle) {
        this(string, n, f);
        this.createdFont = bl;
        if (bl) {
            this.font2DHandle = font2DHandle.font2D instanceof CompositeFont && font2DHandle.font2D.getStyle() != n ? FontManager.getNewComposite(null, n, font2DHandle) : font2DHandle;
        }
    }

    private Font(File file, int n, boolean bl) throws FontFormatException {
        this.createdFont = true;
        this.font2DHandle = FontManager.createFont2D((File)file, (int)n, (boolean)bl).handle;
        this.name = this.font2DHandle.font2D.getFontName(Locale.getDefault());
        this.style = 0;
        this.size = 1;
        this.pointSize = 1.0f;
    }

    private Font(AttributeValues attributeValues, String string, int n, boolean bl, Font2DHandle font2DHandle) {
        this.createdFont = bl;
        if (bl) {
            this.font2DHandle = font2DHandle;
            String string2 = null;
            if (string != null && string.equals(string2 = attributeValues.getFamily())) {
                string2 = null;
            }
            int n2 = 0;
            if (n == -1) {
                n2 = -1;
            } else {
                if (attributeValues.getWeight() >= 2.0f) {
                    n2 = 1;
                }
                if (attributeValues.getPosture() >= 0.2f) {
                    n2 |= 2;
                }
                if (n == n2) {
                    n2 = -1;
                }
            }
            if (font2DHandle.font2D instanceof CompositeFont) {
                if (n2 != -1 || string2 != null) {
                    this.font2DHandle = FontManager.getNewComposite(string2, n2, font2DHandle);
                }
            } else if (string2 != null) {
                this.createdFont = false;
                this.font2DHandle = null;
            }
        }
        this.initFromValues(attributeValues);
    }

    public Font(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        this.initFromValues(AttributeValues.fromMap(map, RECOGNIZED_MASK));
    }

    protected Font(Font font) {
        if (font.values != null) {
            this.initFromValues(font.getAttributeValues().clone());
        } else {
            this.name = font.name;
            this.style = font.style;
            this.size = font.size;
            this.pointSize = font.pointSize;
        }
        this.font2DHandle = font.font2DHandle;
        this.createdFont = font.createdFont;
    }

    private void initFromValues(AttributeValues attributeValues) {
        this.values = attributeValues;
        attributeValues.defineAll(PRIMARY_MASK);
        this.name = attributeValues.getFamily();
        this.pointSize = attributeValues.getSize();
        this.size = (int)((double)attributeValues.getSize() + 0.5);
        if (attributeValues.getWeight() >= 2.0f) {
            this.style |= 1;
        }
        if (attributeValues.getPosture() >= 0.2f) {
            this.style |= 2;
        }
        this.nonIdentityTx = attributeValues.anyNonDefault(EXTRA_MASK);
        this.hasLayoutAttributes = attributeValues.anyNonDefault(LAYOUT_MASK);
    }

    public static Font getFont(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        if (map instanceof AttributeMap && ((AttributeMap)map).getValues() != null) {
            AttributeValues attributeValues = ((AttributeMap)map).getValues();
            if (attributeValues.isNonDefault(EAttribute.EFONT)) {
                Font font = attributeValues.getFont();
                if (!attributeValues.anyDefined(SECONDARY_MASK)) {
                    return font;
                }
                attributeValues = font.getAttributeValues().clone();
                attributeValues.merge(map, SECONDARY_MASK);
                return new Font(attributeValues, font.name, font.style, font.createdFont, font.font2DHandle);
            }
            return new Font(map);
        }
        Font font = (Font)map.get(TextAttribute.FONT);
        if (font != null) {
            if (map.size() > 1) {
                AttributeValues attributeValues = font.getAttributeValues().clone();
                attributeValues.merge(map, SECONDARY_MASK);
                return new Font(attributeValues, font.name, font.style, font.createdFont, font.font2DHandle);
            }
            return font;
        }
        return new Font(map);
    }

    public static Font createFont(int n, InputStream inputStream) throws FontFormatException, IOException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("font format not recognized");
        }
        final InputStream inputStream2 = inputStream;
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file = null;
                FileOutputStream fileOutputStream = null;
                try {
                    file = File.createTempFile("+~JF", ".tmp", null);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream2);
                    fileOutputStream = new FileOutputStream(file);
                    int n = 0;
                    int n2 = 8192;
                    byte[] byArray = new byte[n2];
                    while (n != -1) {
                        try {
                            n = bufferedInputStream.read(byArray, 0, n2);
                        }
                        catch (Throwable throwable) {
                            throw new IOException();
                        }
                        if (n == -1) continue;
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (file != null) {
                        try {
                            file.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return iOException;
                }
                return file;
            }
        });
        if (t instanceof File) {
            return new Font((File)t, n, true);
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new FontFormatException("Couldn't access font stream");
    }

    public static Font createFont(int n, File file) throws FontFormatException, IOException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("font format not recognized");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            FilePermission filePermission = new FilePermission(file.getPath(), "read");
            securityManager.checkPermission(filePermission);
        }
        if (!file.canRead()) {
            throw new IOException("Can't read " + file);
        }
        return new Font(file, n, false);
    }

    public AffineTransform getTransform() {
        if (this.nonIdentityTx) {
            AffineTransform affineTransform;
            AttributeValues attributeValues = this.getAttributeValues();
            AffineTransform affineTransform2 = affineTransform = attributeValues.isNonDefault(EAttribute.ETRANSFORM) ? new AffineTransform(attributeValues.getTransform()) : new AffineTransform();
            if (attributeValues.getSuperscript() != 0) {
                int n;
                int n2 = attributeValues.getSuperscript();
                double d = 0.0;
                int n3 = 0;
                boolean bl = n2 > 0;
                int n4 = bl ? -1 : 1;
                int n5 = n = bl ? n2 : -n2;
                while ((n & 7) > n3) {
                    int n6 = n & 7;
                    d += (double)((float)n4 * (ssinfo[n6] - ssinfo[n3]));
                    n >>= 3;
                    n4 = -n4;
                    n3 = n6;
                }
                double d2 = Math.pow(0.6666666666666666, n3);
                affineTransform.preConcatenate(AffineTransform.getTranslateInstance(0.0, d *= (double)this.pointSize));
                affineTransform.scale(d2, d2);
            }
            if (attributeValues.isNonDefault(EAttribute.EWIDTH)) {
                affineTransform.scale(attributeValues.getWidth(), 1.0);
            }
            return affineTransform;
        }
        return new AffineTransform();
    }

    public String getFamily() {
        return this.getFamily_NoClientCode();
    }

    final String getFamily_NoClientCode() {
        return this.getFamily(Locale.getDefault());
    }

    public String getFamily(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("null locale doesn't mean default");
        }
        return this.getFont2D().getFamilyName(locale);
    }

    public String getPSName() {
        return this.getFont2D().getPostscriptName();
    }

    public String getName() {
        return this.name;
    }

    public String getFontName() {
        return this.getFontName(Locale.getDefault());
    }

    public String getFontName(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("null locale doesn't mean default");
        }
        return this.getFont2D().getFontName(locale);
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public float getSize2D() {
        return this.pointSize;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isTransformed() {
        return this.nonIdentityTx;
    }

    public boolean hasLayoutAttributes() {
        return this.hasLayoutAttributes;
    }

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    public static Font decode(String string) {
        int n;
        int n2;
        int n3;
        char c;
        int n4;
        int n5;
        String string2;
        String string3;
        block20: {
            int n6;
            string3 = string;
            string2 = "";
            n5 = 12;
            n4 = 0;
            if (string == null) {
                return new Font(DIALOG, n4, n5);
            }
            int n7 = string.lastIndexOf(45);
            c = n7 > (n6 = string.lastIndexOf(32)) ? (char)'-' : ' ';
            n3 = string.lastIndexOf(c);
            n2 = string.lastIndexOf(c, n3 - 1);
            n = string.length();
            if (n3 > 0 && n3 + 1 < n) {
                try {
                    n5 = Integer.valueOf(string.substring(n3 + 1));
                    if (n5 <= 0) {
                        n5 = 12;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n3;
                    n3 = n;
                    if (string.charAt(n3 - 1) != c) break block20;
                    --n3;
                }
            }
        }
        if (n2 >= 0 && n2 + 1 < n) {
            string2 = string.substring(n2 + 1, n3);
            if ((string2 = string2.toLowerCase(Locale.ENGLISH)).equals("bolditalic")) {
                n4 = 3;
            } else if (string2.equals("italic")) {
                n4 = 2;
            } else if (string2.equals("bold")) {
                n4 = 1;
            } else if (string2.equals("plain")) {
                n4 = 0;
            } else {
                n2 = n3;
                if (string.charAt(n2 - 1) == c) {
                    --n2;
                }
            }
            string3 = string.substring(0, n2);
        } else {
            int n8 = n;
            if (n2 > 0) {
                n8 = n2;
            } else if (n3 > 0) {
                n8 = n3;
            }
            if (n8 > 0 && string.charAt(n8 - 1) == c) {
                --n8;
            }
            string3 = string.substring(0, n8);
        }
        return new Font(string3, n4, n5);
    }

    public static Font getFont(String string, Font font) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 == null) {
            return font;
        }
        return Font.decode(string2);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.name.hashCode() ^ this.style ^ this.size;
            if (this.nonIdentityTx && this.values != null && this.values.getTransform() != null) {
                this.hash ^= this.values.getTransform().hashCode();
            }
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            try {
                Font font = (Font)object;
                if (this.size == font.size && this.style == font.style && this.nonIdentityTx == font.nonIdentityTx && this.hasLayoutAttributes == font.hasLayoutAttributes && this.pointSize == font.pointSize && this.name.equals(font.name)) {
                    if (this.values == null) {
                        if (font.values == null) {
                            return true;
                        }
                        return this.getAttributeValues().equals(font.values);
                    }
                    return this.values.equals(font.getAttributeValues());
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return this.getClass().getName() + "[family=" + this.getFamily() + ",name=" + this.name + ",style=" + string + ",size=" + this.size + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        if (this.values != null) {
            AttributeValues attributeValues = this.values;
            synchronized (attributeValues) {
                this.fRequestedAttributes = this.values.toSerializableHashtable();
                objectOutputStream.defaultWriteObject();
                this.fRequestedAttributes = null;
            }
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.pointSize == 0.0f) {
            this.pointSize = this.size;
        }
        if (this.fRequestedAttributes != null) {
            this.values = this.getAttributeValues();
            AttributeValues attributeValues = AttributeValues.fromSerializableHashtable(this.fRequestedAttributes);
            if (!AttributeValues.is16Hashtable(this.fRequestedAttributes)) {
                attributeValues.unsetDefault();
            }
            this.values = this.getAttributeValues().merge(attributeValues);
            this.nonIdentityTx = this.values.anyNonDefault(EXTRA_MASK);
            this.hasLayoutAttributes = this.values.anyNonDefault(LAYOUT_MASK);
            this.fRequestedAttributes = null;
        }
    }

    public int getNumGlyphs() {
        return this.getFont2D().getNumGlyphs();
    }

    public int getMissingGlyphCode() {
        return this.getFont2D().getMissingGlyphCode();
    }

    public byte getBaselineFor(char c) {
        return this.getFont2D().getBaselineFor(c);
    }

    public Map<TextAttribute, ?> getAttributes() {
        return new AttributeMap(this.getAttributeValues());
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        AttributedCharacterIterator.Attribute[] attributeArray = new AttributedCharacterIterator.Attribute[]{TextAttribute.FAMILY, TextAttribute.WEIGHT, TextAttribute.WIDTH, TextAttribute.POSTURE, TextAttribute.SIZE, TextAttribute.TRANSFORM, TextAttribute.SUPERSCRIPT, TextAttribute.CHAR_REPLACEMENT, TextAttribute.FOREGROUND, TextAttribute.BACKGROUND, TextAttribute.UNDERLINE, TextAttribute.STRIKETHROUGH, TextAttribute.RUN_DIRECTION, TextAttribute.BIDI_EMBEDDING, TextAttribute.JUSTIFICATION, TextAttribute.INPUT_METHOD_HIGHLIGHT, TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.SWAP_COLORS, TextAttribute.NUMERIC_SHAPING, TextAttribute.KERNING, TextAttribute.LIGATURES, TextAttribute.TRACKING};
        return attributeArray;
    }

    public Font deriveFont(int n, float f) {
        if (this.values == null) {
            return new Font(this.name, n, f, this.createdFont, this.font2DHandle);
        }
        AttributeValues attributeValues = this.getAttributeValues().clone();
        int n2 = this.style != n ? this.style : -1;
        Font.applyStyle(n, attributeValues);
        attributeValues.setSize(f);
        return new Font(attributeValues, null, n2, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(int n, AffineTransform affineTransform) {
        AttributeValues attributeValues = this.getAttributeValues().clone();
        int n2 = this.style != n ? this.style : -1;
        Font.applyStyle(n, attributeValues);
        Font.applyTransform(affineTransform, attributeValues);
        return new Font(attributeValues, null, n2, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(float f) {
        if (this.values == null) {
            return new Font(this.name, this.style, f, this.createdFont, this.font2DHandle);
        }
        AttributeValues attributeValues = this.getAttributeValues().clone();
        attributeValues.setSize(f);
        return new Font(attributeValues, null, -1, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(AffineTransform affineTransform) {
        AttributeValues attributeValues = this.getAttributeValues().clone();
        Font.applyTransform(affineTransform, attributeValues);
        return new Font(attributeValues, null, -1, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(int n) {
        if (this.values == null) {
            return new Font(this.name, n, (float)this.size, this.createdFont, this.font2DHandle);
        }
        AttributeValues attributeValues = this.getAttributeValues().clone();
        int n2 = this.style != n ? this.style : -1;
        Font.applyStyle(n, attributeValues);
        return new Font(attributeValues, null, n2, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        if (map == null) {
            return this;
        }
        AttributeValues attributeValues = this.getAttributeValues().clone();
        attributeValues.merge(map, RECOGNIZED_MASK);
        return new Font(attributeValues, this.name, this.style, this.createdFont, this.font2DHandle);
    }

    public boolean canDisplay(char c) {
        return this.getFont2D().canDisplay(c);
    }

    public boolean canDisplay(int n) {
        if (!Character.isValidCodePoint(n)) {
            throw new IllegalArgumentException("invalid code point: " + Integer.toHexString(n));
        }
        return this.getFont2D().canDisplay(n);
    }

    public int canDisplayUpTo(String string) {
        return this.canDisplayUpTo(new StringCharacterIterator(string), 0, string.length());
    }

    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        while (n < n2 && this.canDisplay(cArray[n])) {
            ++n;
        }
        return n == n2 ? -1 : n;
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        int n3 = characterIterator.setIndex(n);
        while (characterIterator.getIndex() < n2 && this.canDisplay((char)n3)) {
            n3 = characterIterator.next();
        }
        n3 = characterIterator.getIndex();
        return n3 == n2 ? -1 : n3;
    }

    public float getItalicAngle() {
        return this.getItalicAngle(null);
    }

    private float getItalicAngle(FontRenderContext fontRenderContext) {
        Object object;
        Object object2;
        if (fontRenderContext == null) {
            object2 = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            object = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        } else {
            object2 = fontRenderContext.getAntiAliasingHint();
            object = fontRenderContext.getFractionalMetricsHint();
        }
        return this.getFont2D().getItalicAngle(this, identityTx, object2, object);
    }

    public boolean hasUniformLineMetrics() {
        return false;
    }

    private FontLineMetrics defaultLineMetrics(FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = null;
        if (this.flmref == null || (fontLineMetrics = (FontLineMetrics)this.flmref.get()) == null || !fontLineMetrics.frc.equals(fontRenderContext)) {
            Object object;
            float[] fArray = new float[8];
            this.getFont2D().getFontMetrics(this, identityTx, fontRenderContext.getAntiAliasingHint(), fontRenderContext.getFractionalMetricsHint(), fArray);
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = 0.0f;
            if (this.values != null && this.values.getSuperscript() != 0) {
                f4 = (float)this.getTransform().getTranslateY();
                f -= f4;
                f2 += f4;
            }
            float f5 = f + f2 + f3;
            int n = 0;
            float[] fArray2 = new float[]{0.0f, (f2 / 2.0f - f) / 2.0f, -f};
            float f6 = fArray[4];
            float f7 = fArray[5];
            float f8 = fArray[6];
            float f9 = fArray[7];
            float f10 = this.getItalicAngle(fontRenderContext);
            if (this.isTransformed() && (object = this.values.getCharTransform()) != null) {
                Point2D.Float float_ = new Point2D.Float();
                float_.setLocation(0.0f, f6);
                ((AffineTransform)object).deltaTransform(float_, float_);
                f6 = float_.y;
                float_.setLocation(0.0f, f7);
                ((AffineTransform)object).deltaTransform(float_, float_);
                f7 = float_.y;
                float_.setLocation(0.0f, f8);
                ((AffineTransform)object).deltaTransform(float_, float_);
                f8 = float_.y;
                float_.setLocation(0.0f, f9);
                ((AffineTransform)object).deltaTransform(float_, float_);
                f9 = float_.y;
            }
            object = new CoreMetrics(f, f2, f3, f5, n, fArray2, f6 += f4, f7, f8 += f4, f9, f4, f10);
            fontLineMetrics = new FontLineMetrics(0, (CoreMetrics)object, fontRenderContext);
            this.flmref = new SoftReference<FontLineMetrics>(fontLineMetrics);
        }
        return (FontLineMetrics)fontLineMetrics.clone();
    }

    public LineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        fontLineMetrics.numchars = string.length();
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext) {
        char[] cArray = string.toCharArray();
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getStringBounds(String string, int n, int n2, FontRenderContext fontRenderContext) {
        String string2 = string.substring(n, n2);
        return this.getStringBounds(string2, fontRenderContext);
    }

    public Rectangle2D getStringBounds(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        boolean bl;
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginIndex: " + n);
        }
        if (n2 > cArray.length) {
            throw new IndexOutOfBoundsException("limit: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("range length: " + (n2 - n));
        }
        boolean bl2 = bl = this.values == null || this.values.getKerning() == 0 && this.values.getLigatures() == 0 && this.values.getBaselineTransform() == null;
        if (bl) {
            boolean bl3 = bl = !FontManager.isComplexText(cArray, n, n2);
        }
        if (bl) {
            StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this, cArray, n, n2 - n, fontRenderContext);
            return ((GlyphVector)standardGlyphVector).getLogicalBounds();
        }
        String string = new String(cArray, n, n2 - n);
        TextLayout textLayout = new TextLayout(string, this, fontRenderContext);
        return new Rectangle2D.Float(0.0f, -textLayout.getAscent(), textLayout.getAdvance(), textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading());
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        int n3 = characterIterator.getBeginIndex();
        int n4 = characterIterator.getEndIndex();
        if (n < n3) {
            throw new IndexOutOfBoundsException("beginIndex: " + n);
        }
        if (n2 > n4) {
            throw new IndexOutOfBoundsException("limit: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("range length: " + (n2 - n));
        }
        char[] cArray = new char[n2 - n];
        characterIterator.setIndex(n);
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = characterIterator.current();
            characterIterator.next();
        }
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext fontRenderContext) {
        float[] fArray = new float[4];
        this.getFont2D().getFontMetrics(this, fontRenderContext, fArray);
        return new Rectangle2D.Float(0.0f, -fArray[0], fArray[3], fArray[0] + fArray[1] + fArray[2]);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        return new StandardGlyphVector(this, string, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        return new StandardGlyphVector(this, cArray, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return new StandardGlyphVector(this, characterIterator, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray) {
        return new StandardGlyphVector(this, nArray, fontRenderContext);
    }

    public GlyphVector layoutGlyphVector(FontRenderContext fontRenderContext, char[] cArray, int n, int n2, int n3) {
        GlyphLayout glyphLayout = GlyphLayout.get(null);
        StandardGlyphVector standardGlyphVector = glyphLayout.layout(this, fontRenderContext, cArray, n, n2 - n, n3, null);
        GlyphLayout.done(glyphLayout);
        return standardGlyphVector;
    }

    private static void applyTransform(AffineTransform affineTransform, AttributeValues attributeValues) {
        if (affineTransform == null) {
            throw new IllegalArgumentException("transform must not be null");
        }
        attributeValues.setTransform(affineTransform);
    }

    private static void applyStyle(int n, AttributeValues attributeValues) {
        attributeValues.setWeight((n & 1) != 0 ? 2.0f : 1.0f);
        attributeValues.setPosture((n & 2) != 0 ? 0.2f : 0.0f);
    }

    private static native void initIDs();

    static {
        Toolkit.loadLibraries();
        Font.initIDs();
        identityTx = new AffineTransform();
        RECOGNIZED_MASK = AttributeValues.MASK_ALL & ~AttributeValues.getMask(EAttribute.EFONT);
        PRIMARY_MASK = AttributeValues.getMask(EAttribute.EFAMILY, EAttribute.EWEIGHT, EAttribute.EWIDTH, EAttribute.EPOSTURE, EAttribute.ESIZE, EAttribute.ETRANSFORM, EAttribute.ESUPERSCRIPT, EAttribute.ETRACKING);
        SECONDARY_MASK = RECOGNIZED_MASK & ~PRIMARY_MASK;
        LAYOUT_MASK = AttributeValues.getMask(EAttribute.ECHAR_REPLACEMENT, EAttribute.EFOREGROUND, EAttribute.EBACKGROUND, EAttribute.EUNDERLINE, EAttribute.ESTRIKETHROUGH, EAttribute.ERUN_DIRECTION, EAttribute.EBIDI_EMBEDDING, EAttribute.EJUSTIFICATION, EAttribute.EINPUT_METHOD_HIGHLIGHT, EAttribute.EINPUT_METHOD_UNDERLINE, EAttribute.ESWAP_COLORS, EAttribute.ENUMERIC_SHAPING, EAttribute.EKERNING, EAttribute.ELIGATURES, EAttribute.ETRACKING, EAttribute.ESUPERSCRIPT);
        EXTRA_MASK = AttributeValues.getMask(EAttribute.ETRANSFORM, EAttribute.ESUPERSCRIPT, EAttribute.EWIDTH);
        ssinfo = new float[]{0.0f, 0.375f, 0.625f, 0.7916667f, 0.9027778f, 0.9768519f, 1.0262346f, 1.0591564f};
    }
}

