/*
 * Decompiled with CFR 0.152.
 */
package sun.net.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import sun.misc.REException;
import sun.misc.RegexpPool;
import sun.net.NetProperties;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxySelector
extends ProxySelector {
    static final String[][] props = new String[][]{{"http", "http.proxy", "proxy", "socksProxy"}, {"https", "https.proxy", "proxy", "socksProxy"}, {"ftp", "ftp.proxy", "ftpProxy", "proxy", "socksProxy"}, {"gopher", "gopherProxy", "socksProxy"}, {"socket", "socksProxy"}};
    private static boolean hasSystemProxies = false;
    private static Properties defprops = new Properties();
    private static NonProxyInfo ftpNonProxyInfo;
    private static NonProxyInfo httpNonProxyInfo;
    private static final Pattern p6;
    private static final long L_DIGIT;
    private static final long H_DIGIT = 0L;
    private int number;

    @Override
    public List<Proxy> select(URI uRI) {
        Object object;
        if (uRI == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        String string = uRI.getScheme();
        Object object2 = uRI.getHost();
        int n = uRI.getPort();
        if (object2 == null && (object = uRI.getAuthority()) != null) {
            int n2 = ((String)object).indexOf(64);
            if (n2 >= 0) {
                object = ((String)object).substring(n2 + 1);
            }
            if ((n2 = ((String)object).lastIndexOf(58)) >= 0) {
                try {
                    n = Integer.parseInt(((String)object).substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                object = ((String)object).substring(0, n2);
            }
            object2 = object;
        }
        if (string == null || object2 == null) {
            throw new IllegalArgumentException("protocol = " + string + " host = " + (String)object2);
        }
        object = new ArrayList(1);
        if (this.isLoopback((String)object2)) {
            object.add(Proxy.NO_PROXY);
            return object;
        }
        NonProxyInfo nonProxyInfo = null;
        if ("http".equalsIgnoreCase(string)) {
            nonProxyInfo = httpNonProxyInfo;
        } else if ("https".equalsIgnoreCase(string)) {
            nonProxyInfo = httpNonProxyInfo;
        } else if ("ftp".equalsIgnoreCase(string)) {
            nonProxyInfo = ftpNonProxyInfo;
        }
        final String string2 = string;
        final NonProxyInfo nonProxyInfo2 = nonProxyInfo;
        final String string3 = ((String)object2).toLowerCase();
        Proxy proxy = AccessController.doPrivileged(new PrivilegedAction<Proxy>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Proxy run() {
                String string = null;
                int n = 0;
                String string22 = null;
                InetSocketAddress inetSocketAddress = null;
                for (int i = 0; i < props.length; ++i) {
                    int n2;
                    if (!props[i][0].equalsIgnoreCase(string2)) continue;
                    for (n2 = 1; n2 < props[i].length && ((string = NetProperties.get(props[i][n2] + "Host")) == null || string.length() == 0); ++n2) {
                    }
                    if (string == null || string.length() == 0) {
                        String string32;
                        Proxy proxy;
                        if (hasSystemProxies && (proxy = DefaultProxySelector.this.getSystemProxy(string32 = string2.equalsIgnoreCase("socket") ? "socks" : string2, string3)) != null) {
                            return proxy;
                        }
                        return Proxy.NO_PROXY;
                    }
                    if (nonProxyInfo2 != null) {
                        string22 = NetProperties.get(nonProxyInfo2.property);
                        NonProxyInfo nonProxyInfo = nonProxyInfo2;
                        synchronized (nonProxyInfo) {
                            if (string22 == null) {
                                nonProxyInfo2.hostsSource = null;
                                nonProxyInfo2.hostsPool = null;
                            } else if (!string22.equals(nonProxyInfo2.hostsSource)) {
                                RegexpPool regexpPool = new RegexpPool();
                                StringTokenizer stringTokenizer = new StringTokenizer(string22, "|", false);
                                try {
                                    while (stringTokenizer.hasMoreTokens()) {
                                        regexpPool.add(stringTokenizer.nextToken().toLowerCase(), Boolean.TRUE);
                                    }
                                }
                                catch (REException rEException) {
                                    // empty catch block
                                }
                                nonProxyInfo2.hostsPool = regexpPool;
                                nonProxyInfo2.hostsSource = string22;
                            }
                            if (nonProxyInfo2.hostsPool != null && nonProxyInfo2.hostsPool.match(string3) != null) {
                                return Proxy.NO_PROXY;
                            }
                        }
                    }
                    if ((n = NetProperties.getInteger(props[i][n2] + "Port", 0).intValue()) == 0 && n2 < props[i].length - 1) {
                        for (int j = 1; j < props[i].length - 1; ++j) {
                            if (j == n2 || n != 0) continue;
                            n = NetProperties.getInteger(props[i][j] + "Port", 0);
                        }
                    }
                    if (n == 0) {
                        n = n2 == props[i].length - 1 ? DefaultProxySelector.this.defaultPort("socket") : DefaultProxySelector.this.defaultPort(string2);
                    }
                    inetSocketAddress = InetSocketAddress.createUnresolved(string, n);
                    if (n2 == props[i].length - 1) {
                        return new Proxy(Proxy.Type.SOCKS, inetSocketAddress);
                    }
                    return new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                }
                return Proxy.NO_PROXY;
            }
        });
        object.add(proxy);
        return object;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        if (uRI == null || socketAddress == null || iOException == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
    }

    private int defaultPort(String string) {
        if ("http".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(string)) {
            return 443;
        }
        if ("ftp".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("socket".equalsIgnoreCase(string)) {
            return 1080;
        }
        if ("gopher".equalsIgnoreCase(string)) {
            return 80;
        }
        return -1;
    }

    private boolean isLoopback(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.equalsIgnoreCase("localhost")) {
            return true;
        }
        if (string.startsWith("127.")) {
            int n = 4;
            int n2 = string.length();
            int n3 = this.scanByte(string, n, n2);
            if (n3 <= n) {
                return false;
            }
            n = n3;
            if ((n3 = this.scan(string, n, n2, '.')) <= n) {
                return n3 == n2 && this.number > 0;
            }
            n = n3;
            if ((n3 = this.scanByte(string, n, n2)) <= n) {
                return false;
            }
            n = n3;
            if ((n3 = this.scan(string, n, n2, '.')) <= n) {
                return n3 == n2 && this.number > 0;
            }
            n = n3;
            if ((n3 = this.scanByte(string, n, n2)) <= n) {
                return false;
            }
            return n3 == n2 && this.number > 0;
        }
        if (string.endsWith(":1")) {
            return p6.matcher(string).matches();
        }
        return false;
    }

    private static long lowMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 63), 0);
        int n2 = Math.max(Math.min(c2, 63), 0);
        for (int i = n; i <= n2; ++i) {
            l |= 1L << i;
        }
        return l;
    }

    private int scanByte(String string, int n, int n2) {
        int n3 = n;
        int n4 = this.scan(string, n3, n2, L_DIGIT, 0L);
        if (n4 <= n3) {
            return n4;
        }
        this.number = Integer.parseInt(string.substring(n3, n4));
        if (this.number > 255) {
            return n3;
        }
        return n4;
    }

    private int scan(String string, int n, int n2, char c) {
        if (n < n2 && string.charAt(n) == c) {
            return n + 1;
        }
        return n;
    }

    private int scan(String string, int n, int n2, long l, long l2) {
        char c;
        int n3;
        for (n3 = n; n3 < n2 && this.match(c = string.charAt(n3), l, l2); ++n3) {
        }
        return n3;
    }

    private boolean match(char c, long l, long l2) {
        if (c < '@') {
            return (1L << c & l) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & l2) != 0L;
        }
        return false;
    }

    private static native boolean init();

    private native Proxy getSystemProxy(String var1, String var2);

    static {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return NetProperties.getBoolean("java.net.useSystemProxies");
            }
        });
        if (bl != null && bl.booleanValue()) {
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            hasSystemProxies = DefaultProxySelector.init();
        }
        ftpNonProxyInfo = new NonProxyInfo("ftp.nonProxyHosts", null, null);
        httpNonProxyInfo = new NonProxyInfo("http.nonProxyHosts", null, null);
        p6 = Pattern.compile("::1|(0:){7}1|(0:){1,6}:1");
        L_DIGIT = DefaultProxySelector.lowMask('0', '9');
    }

    static class NonProxyInfo {
        String hostsSource;
        RegexpPool hostsPool;
        String property;

        NonProxyInfo(String string, String string2, RegexpPool regexpPool) {
            this.property = string;
            this.hostsSource = string2;
            this.hostsPool = regexpPool;
        }
    }
}

