/*	$Id: lukemftp.h,v 1.12 1999/10/27 06:56:26 lukem Exp $	*/

#define	VERSION	"lukemftp 1.0"

#include "config.h"

#ifdef __STDC__
# define __P(protos)	protos
# define __STRING(x)	#x
#else
# define __P(protos)	()
# define __STRING(x)	"x"
#endif

#include <sys/types.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/utsname.h>
#include <sys/wait.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>

#include <arpa/ftp.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <netdb.h>
#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>

#ifdef __STDC__
# include <stdarg.h>
# define VA_START(a, f)		va_start(a, f)
# define VA_ARG(v, a, t)	/* no-op */
#else
# include <varargs.h>
# define VA_START(a, f)		va_start(a)
# define VA_ARG(v, a, t)	v = va_arg(a, t)
#endif

#if HAVE_POLL
# if HAVE_POLL_H
#  include <poll.h>
# elif HAVE_SYS_POLL_H
#  include <sys/poll.h>
# endif
#elif HAVE_SELECT
# define __USE_SELECT
#else
# error "no poll() or select() found"
#endif

#if HAVE_DIRENT_H
# include <dirent.h>
#else
# define dirent direct
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_ERR_H
# include <err.h>
#endif

#if HAVE_GLOB_BRACE
# include <glob.h>
#else
# include "ftpglob.h"
#endif

#if HAVE_PATHS_H
# include <paths.h>
#else
# define _PATH_BSHELL	"/bin/sh"
# define _PATH_TMP	"/tmp/"
#endif

#if HAVE_STRINGLIST_H
# include <stringlist.h>
#else	/* ! HAVE_STRINGLIST_H */
typedef struct _stringlist {
	char	**sl_str;
	size_t	  sl_max;
	size_t	  sl_cur;
} StringList;

StringList *sl_init	__P((void));
void	 sl_add		__P((StringList *, char *));
void	 sl_free	__P((StringList *, int));
char	*sl_find	__P((StringList *, char *));
#endif	/* ! HAVE_STRINGLIST_H */

#if HAVE_TERMCAP_H
# include <termcap.h>
#else
int	 tgetent	__P((char *, const char *));
char	*tgetstr	__P((const char *, char **));
int	 tgetflag	__P((const char *));
int	 tgetnum	__P((const char *));
char	*tgoto		__P((const char *, int, int));
void	 tputs		__P((const char *, int, int (*)(int)));
#endif

#if HAVE_UTIL_H
# include <util.h>
#endif

#if HAVE_VIS_H
# include <vis.h>
#else
# include "ftpvis.h"
#endif

#if ! HAVE_SIG_T
typedef RETSIGTYPE (*sig_t) __P((int));
#endif

#if ! HAVE_IN_PORT_T
typedef unsigned short in_port_t;
#endif

#if HAVE_AF_INET6 && HAVE_SOCKADDR_IN6
# define INET6
#endif

#if ! HAVE_D_NAMLEN
#define DIRENT_MISSING_D_NAMLEN
#endif

#if ! HAVE_H_ERRNO_D
extern int	h_errno;
#endif

#if ! HAVE_FCLOSE_D
int	fclose	__P((FILE *));
#endif

#if ! HAVE_OPTARG_D
extern char    *optarg;
#endif

#if ! HAVE_OPTIND_D
extern int	optind;
#endif

#if ! HAVE_PCLOSE_D
int	pclose	__P((FILE *));
#endif

#if ! HAVE_ERR
void	err		__P((int, const char *, ...));
void	errx		__P((int, const char *, ...));
void	warn		__P((const char *, ...));
void	warnx		__P((const char *, ...));
#endif

#if ! HAVE_FGETLN
char   *fgetln		__P((FILE *, size_t *));
#endif

#if ! HAVE_FPARSELN
# define FPARSELN_UNESCESC	0x01
# define FPARSELN_UNESCCONT	0x02
# define FPARSELN_UNESCCOMM	0x04
# define FPARSELN_UNESCREST	0x08
# define FPARSELN_UNESCALL	0x0f
char   *fparseln	__P((FILE *, size_t *, size_t *, const char[3], int));
#endif

#if ! HAVE_INET_ATON
int	inet_aton	__P((const char *, struct in_addr *));
#endif

#if ! HAVE_MKSTEMP
int	mkstemp		__P((const char *));
#endif

#if ! HAVE_SNPRINTF
int	snprintf	__P((char *, size_t, const char *, ...));
#endif

#if ! HAVE_STRSUP
char   *strdup		__P((const char *));
#endif

#if ! HAVE_STRERROR
char   *strerror	__P((int));
#endif

#if ! HAVE_STRPTIME
char   *strptime	__P((const char *, const char *, struct tm *));
#endif

#if HAVE_QUAD_SUPPORT
# if ! HAVE_STRTOQ && HAVE_LONG_LONG
long long strtoq	__P((const char *, char **, int));
#  if ! defined(QUAD_MIN)
#   define QUAD_MIN	(-0x7fffffffffffffffL-1)
#  endif
#  if ! defined(QUAD_MAX)
#   define QUAD_MAX	(0x7fffffffffffffffL)
#  endif
# endif
#else	/* ! HAVE_QUAD_SUPPORT */
# define NO_QUAD
#endif	/* ! HAVE_QUAD_SUPPORT */

#if ! HAVE_TIMEGM
time_t	timegm		__P((struct tm *));
#endif

#if ! HAVE_HSTRERROR
char   *strerror	__P((int));
#endif

#if ! HAVE_STRLCAT
size_t	strlcat		__P((char *, const char *, size_t));
#endif

#if ! HAVE_STRLCPY
size_t	strlcpy		__P((char *, const char *, size_t));
#endif

#if ! HAVE_STRSEP
char   *strsep		__P((char **stringp, const char *delim));
#endif


#if ! HAVE_MEMMOVE
# define memmove(a,b,c)	bcopy((b),(a),(c))
	/* XXX: add others #defines for borken systems? */
#endif

#if HAVE_GETPASSPHRASE
# define getpass getpassphrase
#endif


#if ! defined(MIN)
# define MIN(a, b)	((a) < (b) ? (a) : (b))
#endif
#if ! defined(MAX)
# define MAX(a, b)	((a) < (b) ? (b) : (a))
#endif

#if ! defined(timersub)
# define timersub(tvp, uvp, vvp)					\
	do {								\
		(vvp)->tv_sec = (tvp)->tv_sec - (uvp)->tv_sec;		\
		(vvp)->tv_usec = (tvp)->tv_usec - (uvp)->tv_usec;	\
		if ((vvp)->tv_usec < 0) {				\
			(vvp)->tv_sec--;				\
			(vvp)->tv_usec += 1000000;			\
		}							\
	} while (0)
#endif

#if ! defined(S_ISLNK)
# define S_ISLNK(m)	((m & S_IFMT) == S_IFLNK)
#endif

#define EPOCH_YEAR	1970
#define SECSPERHOUR	3600
#define SECSPERDAY	86400
#define TM_YEAR_BASE	1900

			/* provided by src/utilc, used in libedit/sig.c */
sig_t	xsignal_restart __P((int, void (func) __P((int)), int));
