% ROOTS ROOTS Find Roots of Polynomial
% 
% Usage
% 
% The roots routine will return a column vector containing the
% roots of a polynomial.  The general syntax is
% 
%    z = roots(p)
% 
% where p is a vector containing the coefficients of the polynomial
% ordered in descending powers.  
function z = roots(p)
  p = vec(p);
  n = numel(p)-1;
  A = diag(ones(n-1,1),-1);
  A(1,:) = -p(2:n+1)./p(1);
  z = eig(A);
  
