/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.fasttrack.AssignmentColumn;
import net.sf.mpxj.fasttrack.BooleanColumn;
import net.sf.mpxj.fasttrack.CalendarColumn;
import net.sf.mpxj.fasttrack.DateColumn;
import net.sf.mpxj.fasttrack.DoubleColumn;
import net.sf.mpxj.fasttrack.DurationColumn;
import net.sf.mpxj.fasttrack.EnumColumn;
import net.sf.mpxj.fasttrack.FastTrackColumn;
import net.sf.mpxj.fasttrack.FastTrackField;
import net.sf.mpxj.fasttrack.FastTrackTable;
import net.sf.mpxj.fasttrack.FastTrackTableType;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.IdentifierColumn;
import net.sf.mpxj.fasttrack.IntegerColumn;
import net.sf.mpxj.fasttrack.NumberColumn;
import net.sf.mpxj.fasttrack.PercentColumn;
import net.sf.mpxj.fasttrack.RelationColumn;
import net.sf.mpxj.fasttrack.ShortColumn;
import net.sf.mpxj.fasttrack.StringColumn;
import net.sf.mpxj.fasttrack.TimeColumn;
import net.sf.mpxj.fasttrack.UnexpectedStructureException;
import net.sf.mpxj.fasttrack.UnknownColumn;

class FastTrackData {
    private byte[] m_buffer;
    private String m_logFile;
    private PrintWriter m_log;
    private final Map<FastTrackTableType, FastTrackTable> m_tables = new EnumMap<FastTrackTableType, FastTrackTable>(FastTrackTableType.class);
    private FastTrackTable m_currentTable;
    private FastTrackColumn m_currentColumn;
    private final Set<FastTrackField> m_currentFields = new TreeSet<FastTrackField>();
    private TimeUnit m_durationTimeUnit;
    private TimeUnit m_workTimeUnit;
    private static final byte[][] PARENT_BLOCK_PATTERNS = new byte[][]{{-5, 1, 2, 0, 2, 0, -1, -1, 0, 0, 0}, {-4, 1, 2, 0, 2, 0, -1, -1, 0, 0, 0}, {-3, 1, 2, 0, 2, 0, -1, -1, 0, 0, 0}, {0, 0, 2, 0, 2, 0, -1, -1, 0, 0, 0}};
    private static final byte[][] CHILD_BLOCK_PATTERNS = new byte[][]{{5, 0, 0, 0, 1, 0}};
    private static final byte[][] TABLE_BLOCK_PATTERNS = new byte[][]{{0, 0, 0, 101, 0, 1, 0}};
    private static final Class<?>[] COLUMN_MAP = new Class[256];
    private static final Map<String, FastTrackTableType> REQUIRED_TABLES;
    private static final FastTrackTable EMPTY_TABLE;

    FastTrackData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File file) throws Exception {
        int n;
        this.openLogFile();
        int n2 = 0;
        int n3 = (int)file.length();
        this.m_buffer = new byte[n3];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n4 = fileInputStream.read(this.m_buffer);
            if (n4 != n3) {
                throw new RuntimeException("Read count different");
            }
        }
        finally {
            fileInputStream.close();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 64; n < this.m_buffer.length - 11; ++n) {
            if (!this.matchPattern(PARENT_BLOCK_PATTERNS, n)) continue;
            arrayList.add(n);
        }
        n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            int n6 = n5 - n;
            this.readBlock(n2, n, n6);
            n = n5;
            ++n2;
        }
        int n7 = this.m_buffer.length - n;
        this.readBlock(n2, n, n7);
        this.closeLogFile();
    }

    public FastTrackTable getTable(FastTrackTableType fastTrackTableType) {
        FastTrackTable fastTrackTable = this.m_tables.get((Object)fastTrackTableType);
        if (fastTrackTable == null) {
            fastTrackTable = EMPTY_TABLE;
        }
        return fastTrackTable;
    }

    TimeUnit getDurationTimeUnit() {
        return this.m_durationTimeUnit == null ? TimeUnit.DAYS : this.m_durationTimeUnit;
    }

    TimeUnit getWorkTimeUnit() {
        return this.m_workTimeUnit == null ? TimeUnit.HOURS : this.m_workTimeUnit;
    }

    private void readBlock(int n, int n2, int n3) throws Exception {
        this.logBlock(n, n2, n3);
        if (n3 < 128) {
            this.readTableBlock(n2, n3);
        } else {
            this.readColumnBlock(n2, n3);
        }
    }

    private void readTableBlock(int n, int n2) {
        for (int i = n; i < n + n2 - 11; ++i) {
            int n3;
            String string;
            FastTrackTableType fastTrackTableType;
            if (!this.matchPattern(TABLE_BLOCK_PATTERNS, i)) continue;
            int n4 = i + 7;
            if ((fastTrackTableType = REQUIRED_TABLES.get(string = new String(this.m_buffer, n4 += 4, n3 = FastTrackUtility.getInt(this.m_buffer, n4), CharsetHelper.UTF16LE).toUpperCase())) != null) {
                this.m_currentTable = new FastTrackTable(fastTrackTableType, this);
                this.m_tables.put(fastTrackTableType, this.m_currentTable);
            } else {
                this.m_currentTable = null;
            }
            this.m_currentFields.clear();
            break;
        }
    }

    private void readColumnBlock(int n, int n2) throws Exception {
        int n3;
        int n4 = n + n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = n; n3 < n4 - 11; ++n3) {
            if (!this.matchPattern(CHILD_BLOCK_PATTERNS, n3)) continue;
            int n5 = n3 - 2;
            arrayList.add(n5);
        }
        arrayList.add(n4);
        n3 = -1;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n6 = (Integer)iterator.next();
            if (n3 != -1) {
                int n7 = n6 - n3;
                try {
                    this.readColumn(n3, n7);
                }
                catch (UnexpectedStructureException unexpectedStructureException) {
                    this.logUnexpectedStructure();
                }
            }
            n3 = n6;
        }
    }

    private void readColumn(int n, int n2) throws Exception {
        if (this.m_currentTable != null) {
            FastTrackColumn fastTrackColumn;
            int n3 = FastTrackUtility.getByte(this.m_buffer, n);
            Class<Object> clazz = COLUMN_MAP[n3];
            if (clazz == null) {
                clazz = UnknownColumn.class;
            }
            this.m_currentColumn = fastTrackColumn = (FastTrackColumn)clazz.newInstance();
            this.logColumnData(n, n2);
            fastTrackColumn.read(this.m_currentTable.getType(), this.m_buffer, n, n2);
            FastTrackField fastTrackField = fastTrackColumn.getType();
            if (fastTrackField != null && !this.m_currentFields.contains(fastTrackField)) {
                this.m_currentFields.add(fastTrackField);
                this.m_currentTable.addColumn(fastTrackColumn);
                this.updateDurationTimeUnit(fastTrackColumn);
                this.updateWorkTimeUnit(fastTrackColumn);
                this.logColumn(fastTrackColumn);
            }
        }
    }

    private final boolean matchPattern(byte[][] byArray, int n) {
        boolean bl = false;
        for (byte[] byArray2 : byArray) {
            int n2 = 0;
            bl = true;
            for (byte by : byArray2) {
                if (by != this.m_buffer[n + n2]) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) break;
        }
        return bl;
    }

    private void updateDurationTimeUnit(FastTrackColumn fastTrackColumn) {
        int n;
        if (this.m_durationTimeUnit == null && this.isDurationColumn(fastTrackColumn) && (n = ((DurationColumn)fastTrackColumn).getTimeUnitValue()) != 1) {
            this.m_durationTimeUnit = FastTrackUtility.getTimeUnit(n);
        }
    }

    private void updateWorkTimeUnit(FastTrackColumn fastTrackColumn) {
        int n;
        if (this.m_workTimeUnit == null && this.isWorkColumn(fastTrackColumn) && (n = ((DurationColumn)fastTrackColumn).getTimeUnitValue()) != 1) {
            this.m_workTimeUnit = FastTrackUtility.getTimeUnit(n);
        }
    }

    private boolean isDurationColumn(FastTrackColumn fastTrackColumn) {
        return fastTrackColumn instanceof DurationColumn && fastTrackColumn.getName().indexOf("Duration") != -1;
    }

    private boolean isWorkColumn(FastTrackColumn fastTrackColumn) {
        return fastTrackColumn instanceof DurationColumn && fastTrackColumn.getName().indexOf("Work") != -1;
    }

    public void setLogFile(String string) {
        this.m_logFile = string;
    }

    private void openLogFile() throws IOException {
        if (this.m_logFile != null) {
            this.m_log = new PrintWriter(new FileWriter(this.m_logFile));
        }
    }

    private void closeLogFile() {
        if (this.m_logFile != null) {
            this.m_log.flush();
            this.m_log.close();
        }
    }

    private void logBlock(int n, int n2, int n3) {
        if (this.m_log != null) {
            this.m_log.println("Block Index: " + n);
            this.m_log.println("Length: " + n3 + " (" + Integer.toHexString(n3) + ")");
            this.m_log.println();
            this.m_log.println(FastTrackUtility.hexdump(this.m_buffer, n2, n3, true, 16, ""));
            this.m_log.flush();
        }
    }

    private void logColumnData(int n, int n2) {
        if (this.m_log != null) {
            this.m_log.println();
            this.m_log.println(FastTrackUtility.hexdump(this.m_buffer, n, n2, true, 16, ""));
            this.m_log.println();
            this.m_log.flush();
        }
    }

    private void logUnexpectedStructure() {
        if (this.m_log != null) {
            this.m_log.println("ABORTED COLUMN - unexpected structure: " + this.m_currentColumn.getClass().getSimpleName() + " " + this.m_currentColumn.getName());
        }
    }

    private void logColumn(FastTrackColumn fastTrackColumn) {
        if (this.m_log != null) {
            this.m_log.println("TABLE: " + (Object)((Object)this.m_currentTable.getType()));
            this.m_log.println(fastTrackColumn.toString());
            this.m_log.flush();
        }
    }

    static {
        FastTrackData.COLUMN_MAP[110] = DateColumn.class;
        FastTrackData.COLUMN_MAP[111] = TimeColumn.class;
        FastTrackData.COLUMN_MAP[113] = DurationColumn.class;
        FastTrackData.COLUMN_MAP[70] = PercentColumn.class;
        FastTrackData.COLUMN_MAP[108] = ShortColumn.class;
        FastTrackData.COLUMN_MAP[115] = ShortColumn.class;
        FastTrackData.COLUMN_MAP[109] = IdentifierColumn.class;
        FastTrackData.COLUMN_MAP[112] = NumberColumn.class;
        FastTrackData.COLUMN_MAP[92] = CalendarColumn.class;
        FastTrackData.COLUMN_MAP[75] = IntegerColumn.class;
        FastTrackData.COLUMN_MAP[73] = AssignmentColumn.class;
        FastTrackData.COLUMN_MAP[89] = EnumColumn.class;
        FastTrackData.COLUMN_MAP[83] = BooleanColumn.class;
        FastTrackData.COLUMN_MAP[91] = DoubleColumn.class;
        FastTrackData.COLUMN_MAP[74] = DoubleColumn.class;
        FastTrackData.COLUMN_MAP[84] = DoubleColumn.class;
        FastTrackData.COLUMN_MAP[87] = RelationColumn.class;
        FastTrackData.COLUMN_MAP[88] = RelationColumn.class;
        FastTrackData.COLUMN_MAP[104] = StringColumn.class;
        FastTrackData.COLUMN_MAP[105] = StringColumn.class;
        REQUIRED_TABLES = new HashMap<String, FastTrackTableType>();
        REQUIRED_TABLES.put("ACTBARS", FastTrackTableType.ACTBARS);
        REQUIRED_TABLES.put("ACTIVITIES", FastTrackTableType.ACTIVITIES);
        REQUIRED_TABLES.put("RESOURCES", FastTrackTableType.RESOURCES);
        EMPTY_TABLE = new FastTrackTable(null, null);
    }
}

