/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiceNetlistReader {
    private File file;
    BufferedReader reader = null;
    private StringBuffer lines = null;
    private int lineno;
    private HashMap<String, String> options = new LinkedHashMap<String, String>();
    private HashMap<String, String> globalParams = new LinkedHashMap<String, String>();
    private List<Instance> topLevelInstances = new ArrayList<Instance>();
    private HashMap<String, Subckt> subckts = new LinkedHashMap<String, Subckt>();
    private List<String> globalNets = new ArrayList<String>();
    private Subckt currentSubckt;
    private static final boolean DEBUG = true;

    public HashMap<String, String> getOptions() {
        return this.options;
    }

    public HashMap<String, String> getGlobalParams() {
        return this.globalParams;
    }

    public List<Instance> getTopLevelInstances() {
        return this.topLevelInstances;
    }

    public HashMap<String, Subckt> getSubckts() {
        return this.subckts;
    }

    public List<String> getGlobalNets() {
        return this.globalNets;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFile(String fileName, boolean verbose) throws FileNotFoundException {
        this.file = new File(fileName);
        this.reader = new BufferedReader(new FileReader(fileName));
        this.lines = new StringBuffer();
        this.currentSubckt = null;
        this.lineno = 0;
        try {
            block4: while (true) {
                String line;
                if ((line = this.readLine()) == null) {
                    this.reader.close();
                    return;
                }
                String[] tokens = this.getTokens(line = line.trim());
                if (tokens.length == 0) continue;
                String keyword = tokens[0];
                if (keyword.equals(".include")) {
                    if (tokens.length < 2) {
                        this.prErr("No file specified for .include");
                        continue;
                    }
                    String ifile = tokens[1];
                    if (!ifile.startsWith("/") && !ifile.startsWith("\\")) {
                        File newFile = new File(this.file.getParent(), ifile);
                        ifile = newFile.getPath();
                    }
                    File saveFile = this.file;
                    BufferedReader saveReader = this.reader;
                    StringBuffer saveLines = this.lines;
                    int saveLine = this.lineno;
                    try {
                        if (verbose) {
                            System.out.println("Reading include file " + ifile);
                        }
                        this.readFile(ifile, verbose);
                    }
                    catch (FileNotFoundException e) {
                        this.file = saveFile;
                        this.lineno = saveLine;
                        this.prErr("Include file does not exist: " + ifile);
                    }
                    this.file = saveFile;
                    this.reader = saveReader;
                    this.lines = saveLines;
                    this.lineno = saveLine;
                    continue;
                }
                if (keyword.startsWith(".opt")) {
                    this.parseOptions(this.options, 1, tokens);
                    continue;
                }
                if (keyword.equals(".param")) {
                    this.parseParams(this.globalParams, 1, tokens);
                    continue;
                }
                if (keyword.equals(".subckt")) {
                    this.currentSubckt = this.parseSubckt(tokens);
                    if (this.currentSubckt != null && this.subckts.containsKey(this.currentSubckt.getName())) {
                        this.prErr("Subckt " + this.currentSubckt.getName() + " already defined");
                        continue;
                    }
                    this.subckts.put(this.currentSubckt.getName(), this.currentSubckt);
                    continue;
                }
                if (keyword.equals(".global")) {
                    int i = 1;
                    while (true) {
                        if (i >= tokens.length) continue block4;
                        if (!this.globalNets.contains(tokens[i])) {
                            this.globalNets.add(tokens[i]);
                        }
                        ++i;
                    }
                }
                if (keyword.startsWith(".ends")) {
                    this.currentSubckt = null;
                    continue;
                }
                if (keyword.startsWith(".end")) continue;
                if (keyword.startsWith("x")) {
                    Instance inst = this.parseSubcktInstance(tokens);
                    this.addInstance(inst);
                    continue;
                }
                if (keyword.startsWith("r")) {
                    Instance inst = this.parseResistor(tokens);
                    this.addInstance(inst);
                    continue;
                }
                if (keyword.startsWith("c")) {
                    Instance inst = this.parseCapacitor(tokens);
                    this.addInstance(inst);
                    continue;
                }
                if (keyword.startsWith("m")) {
                    Instance inst = this.parseMosfet(tokens);
                    this.addInstance(inst);
                    continue;
                }
                if (keyword.equals(".protect") || keyword.equals(".unprotect")) continue;
                this.prWarn("Parser does not recognize: " + line);
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file " + this.file.getPath() + ": " + e.getMessage());
        }
    }

    private void prErr(String msg) {
        System.out.println("Error (" + this.getLocation() + "): " + msg);
    }

    private void prWarn(String msg) {
        System.out.println("Warning (" + this.getLocation() + "): " + msg);
    }

    private String getLocation() {
        return this.file.getName() + ":" + this.lineno;
    }

    private String[] getTokens(String line) {
        int i;
        ArrayList<String> tokens = new ArrayList<String>();
        int start = 0;
        boolean inquotes = false;
        int inparens = 0;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (inquotes) {
                if (c != '\'' || inparens > 0) continue;
                tokens.add(line.substring(start, i));
                start = i + 1;
                inquotes = false;
                continue;
            }
            if (c == '\'') {
                if (inparens > 0) continue;
                inquotes = true;
                if (start != i) {
                    this.prErr("Improper use of open quote '");
                    break;
                }
                start = i + 1;
                continue;
            }
            if (Character.isWhitespace(c) && inparens == 0) {
                if (start < i) {
                    tokens.add(line.substring(start, i).toLowerCase());
                }
                start = i + 1;
                continue;
            }
            if (c == '(') {
                ++inparens;
                continue;
            }
            if (c == ')') {
                if (inparens == 0) {
                    this.prErr("Too many ')'s");
                    break;
                }
                --inparens;
                continue;
            }
            if (c == '=') {
                if (start < i) {
                    tokens.add(line.substring(start, i).toLowerCase());
                }
                tokens.add("=");
                start = i + 1;
                continue;
            }
            if (c == '*') break;
        }
        if (start < i) {
            tokens.add(line.substring(start, i).toLowerCase());
        }
        if (inparens != 0) {
            this.prErr("Unmatched parentheses");
        }
        ArrayList<String> joined = new ArrayList<String>();
        for (int j = 0; j < tokens.size(); ++j) {
            if (((String)tokens.get(j)).equals("=")) {
                if (j == 0) {
                    this.prErr("No right hand side to assignment");
                    continue;
                }
                if (j == tokens.size() - 1) {
                    this.prErr("No left hand side to assignment");
                    continue;
                }
                int last = joined.size() - 1;
                joined.set(last, (String)joined.get(last) + "=" + (String)tokens.get(++j));
                continue;
            }
            joined.add((String)tokens.get(j));
        }
        String[] ret = new String[joined.size()];
        for (int k = 0; k < joined.size(); ++k) {
            ret[k] = (String)joined.get(k);
        }
        return ret;
    }

    private void parseOptions(HashMap<String, String> map, int start, String[] tokens) {
        for (int i = start; i < tokens.length; ++i) {
            int e = tokens[i].indexOf(61);
            String pname = tokens[i];
            String value = "true";
            if (e > 0) {
                pname = tokens[i].substring(0, e);
                value = tokens[i].substring(e + 1);
            }
            if (pname == null || value == null) {
                this.prErr("Bad option value: " + tokens[i]);
                continue;
            }
            map.put(pname, value);
        }
    }

    private void parseParams(HashMap<String, String> map, int start, String[] tokens) {
        for (int i = start; i < tokens.length; ++i) {
            this.parseParam(map, tokens[i], null);
        }
    }

    private void parseParam(HashMap<String, String> map, String parval, String defaultParName) {
        int e = parval.indexOf(61);
        String pname = defaultParName;
        String value = parval;
        if (e > 0) {
            pname = parval.substring(0, e);
            value = parval.substring(e + 1);
            if (defaultParName != null && !defaultParName.equals(pname)) {
                this.prWarn("Expected param " + defaultParName + ", but got " + pname);
            }
        }
        if (pname == null || value == null) {
            this.prErr("Badly formatted param=val: " + parval);
            return;
        }
        map.put(pname, value);
    }

    private Subckt parseSubckt(String[] parts) {
        int i;
        Subckt subckt = new Subckt(parts[1]);
        for (i = 2; i < parts.length && parts[i].indexOf(61) <= 0; ++i) {
            subckt.addPort(parts[i]);
        }
        this.parseParams(subckt.getParams(), i, parts);
        return subckt;
    }

    private Instance parseSubcktInstance(String[] parts) {
        int i;
        String name = parts[0].substring(1);
        ArrayList<String> nets = new ArrayList<String>();
        for (i = 1; i < parts.length && !parts[i].contains("="); ++i) {
            nets.add(parts[i]);
        }
        String subcktName = (String)nets.remove(nets.size() - 1);
        Subckt subckt = this.subckts.get(subcktName);
        if (subckt == null) {
            this.prErr("Cannot find subckt for " + subcktName);
            return null;
        }
        Instance inst = new Instance(subckt, name);
        for (String net : nets) {
            inst.addNet(net);
        }
        this.parseParams(inst.getParams(), i, parts);
        if (inst.getNets().size() != subckt.getPorts().size()) {
            this.prErr("Number of ports do not match: " + inst.getNets().size() + " (instance " + name + ") vs " + subckt.getPorts().size() + " (subckt " + subckt.getName() + ")");
        }
        return inst;
    }

    private void addInstance(Instance inst) {
        if (inst == null) {
            return;
        }
        if (this.currentSubckt != null) {
            this.currentSubckt.addInstance(inst);
        } else {
            this.topLevelInstances.add(inst);
        }
    }

    private Instance parseResistor(String[] parts) {
        if (parts.length < 4) {
            this.prErr("Not enough arguments for resistor");
            return null;
        }
        Instance inst = new Instance(parts[0]);
        for (int i = 1; i < 3; ++i) {
            inst.addNet(parts[i]);
        }
        this.parseParam(inst.getParams(), parts[3], "r");
        return inst;
    }

    private Instance parseCapacitor(String[] parts) {
        if (parts.length < 4) {
            this.prErr("Not enough arguments for capacitor");
            return null;
        }
        Instance inst = new Instance(parts[0]);
        for (int i = 1; i < 3; ++i) {
            inst.addNet(parts[i]);
        }
        this.parseParam(inst.getParams(), parts[3], "c");
        return inst;
    }

    private Instance parseMosfet(String[] parts) {
        int i;
        if (parts.length < 8) {
            this.prErr("Not enough arguments for mosfet");
            return null;
        }
        Instance inst = new Instance(parts[0]);
        for (i = 1; i < 5; ++i) {
            inst.addNet(parts[i]);
        }
        String model = parts[i];
        inst.getParams().put("model", model);
        this.parseParams(inst.getParams(), ++i, parts);
        return inst;
    }

    private String readLine() throws IOException {
        String line;
        while (true) {
            ++this.lineno;
            line = this.reader.readLine();
            if (line == null) {
                if (this.lines.length() == 0) {
                    return null;
                }
                return this.removeString();
            }
            if ((line = line.trim()).startsWith("*")) continue;
            if (line.startsWith("+")) {
                this.lines.append(" ");
                this.lines.append(line.substring(1));
                continue;
            }
            if (this.lines.length() != 0) break;
            this.lines.append(line);
        }
        String ret = this.removeString();
        this.lines.append(line);
        return ret;
    }

    private String removeString() {
        String ret = this.lines.toString();
        this.lines.delete(0, this.lines.length());
        return ret;
    }

    public void writeFile(String fileName) {
        if (fileName == null) {
            this.write(System.out);
        } else {
            try {
                PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileName)));
                this.write(out);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public void write(PrintStream out) {
        out.println("* Spice netlist");
        for (String key : this.options.keySet()) {
            String value = this.options.get(key);
            if (value == null) {
                out.println(".option " + key);
                continue;
            }
            out.println(".option " + key + "=" + this.options.get(key));
        }
        out.println();
        for (String key : this.globalParams.keySet()) {
            out.println(".param " + key + "=" + this.globalParams.get(key));
        }
        out.println();
        for (String net : this.globalNets) {
            out.println(".global " + net);
        }
        out.println();
        for (String subcktName : this.subckts.keySet()) {
            Subckt subckt = this.subckts.get(subcktName);
            subckt.write(out);
            out.println();
        }
        for (Instance inst : this.topLevelInstances) {
            inst.write(out);
        }
        out.println();
        out.println(".end");
        if (out != System.out) {
            out.close();
        }
    }

    private static void multiLinePrint(PrintStream out, boolean isComment, String str) {
        char contChar = '+';
        if (isComment) {
            contChar = '*';
        }
        int lastSpace = -1;
        int count = 0;
        boolean insideQuotes = false;
        int lineStart = 0;
        for (int pt = 0; pt < str.length(); ++pt) {
            char chr = str.charAt(pt);
            if (chr == '\n') {
                out.print(str.substring(lineStart, pt + 1));
                count = 0;
                lastSpace = -1;
                lineStart = pt + 1;
                continue;
            }
            if (chr == ' ' && !insideQuotes) {
                lastSpace = pt;
            }
            if (chr == '\'') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (++count < 78 || insideQuotes || lastSpace <= -1) continue;
            String partial = str.substring(lineStart, lastSpace + 1);
            out.print(partial + "\n" + contChar);
            count -= partial.length();
            lineStart = lastSpace + 1;
            lastSpace = -1;
        }
        if (lineStart < str.length()) {
            String partial = str.substring(lineStart);
            out.print(partial);
        }
    }

    public static void main(String[] args) {
        SpiceNetlistReader reader = new SpiceNetlistReader();
        try {
            reader.readFile("/import/async/cad/2006/bic/jkg/bic/testSims/test_clk_regen.spi", true);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        reader.writeFile("/tmp/output.spi");
    }

    private static void testLineParserTests() {
        SpiceNetlistReader reader = new SpiceNetlistReader();
        reader = new SpiceNetlistReader();
        reader.file = new File("/none");
        reader.lineno = 1;
        SpiceNetlistReader.testLineParser(reader, ".measure tran vmin min v( data) from=0ns to=1.25ns  ");
        SpiceNetlistReader.testLineParser(reader, ".param poly_res_corner='1.0 * p' * 0.8 corner");
        SpiceNetlistReader.testLineParser(reader, ".param poly_res_corner   =    '1.0 * p' * 0.8 corner");
        SpiceNetlistReader.testLineParser(reader, ".param AVT0N = AGAUSS(0.0,  '0.01 / 0.1' , 1)");
    }

    private static void testLineParser(SpiceNetlistReader reader, String line) {
        System.out.println("Parsing: " + line);
        String[] tokens = reader.getTokens(line);
        for (int i = 0; i < tokens.length; ++i) {
            System.out.println(i + ": " + tokens[i]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Subckt {
        private String name;
        private List<String> ports;
        private HashMap<String, String> params;
        private List<Instance> instances;

        private Subckt(String name) {
            this.name = name;
            this.ports = new ArrayList<String>();
            this.params = new LinkedHashMap<String, String>();
            this.instances = new ArrayList<Instance>();
        }

        public String getName() {
            return this.name;
        }

        private void addPort(String port) {
            this.ports.add(port);
        }

        public List<String> getPorts() {
            return this.ports;
        }

        public HashMap<String, String> getParams() {
            return this.params;
        }

        private void addInstance(Instance inst) {
            this.instances.add(inst);
        }

        public List<Instance> getInstances() {
            return this.instances;
        }

        public void write(PrintStream out) {
            StringBuffer buf = new StringBuffer(".subckt ");
            buf.append(this.name);
            buf.append(" ");
            for (String port : this.ports) {
                buf.append(port);
                buf.append(" ");
            }
            for (String key : this.params.keySet()) {
                buf.append(key);
                buf.append("=");
                buf.append(this.params.get(key));
                buf.append(" ");
            }
            buf.append("\n");
            SpiceNetlistReader.multiLinePrint(out, false, buf.toString());
            for (Instance inst : this.instances) {
                inst.write(out);
            }
            out.println(".ends " + this.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Instance {
        private char type;
        private String name;
        private List<String> nets;
        private Subckt subckt;
        private HashMap<String, String> params;

        public Instance(String typeAndName) {
            this.type = typeAndName.charAt(0);
            this.name = typeAndName.substring(1);
            this.nets = new ArrayList<String>();
            this.subckt = null;
            this.params = new LinkedHashMap<String, String>();
        }

        public Instance(Subckt subckt, String name) {
            this.type = (char)120;
            this.name = name;
            this.nets = new ArrayList<String>();
            this.subckt = subckt;
            this.params = new LinkedHashMap<String, String>();
            for (String key : subckt.getParams().keySet()) {
                this.params.put(key, subckt.getParams().get(key));
            }
        }

        public char getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getNets() {
            return this.nets;
        }

        private void addNet(String net) {
            this.nets.add(net);
        }

        public HashMap<String, String> getParams() {
            return this.params;
        }

        public Subckt getSubckt() {
            return this.subckt;
        }

        public void write(PrintStream out) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.type);
            buf.append(this.name);
            buf.append(" ");
            for (String net : this.nets) {
                buf.append(net);
                buf.append(" ");
            }
            if (this.subckt != null) {
                buf.append(this.subckt.getName());
                buf.append(" ");
            }
            for (String key : this.params.keySet()) {
                buf.append(key);
                String value = this.params.get(key);
                if (value != null) {
                    buf.append("=");
                    buf.append(value);
                }
                buf.append(" ");
            }
            buf.append("\n");
            SpiceNetlistReader.multiLinePrint(out, false, buf.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TType {
        PAR,
        PARVAL,
        WORD;

    }
}

