/**
 * Common behavior for monsters, animals and NPC

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/brains.c,v 1.3 2004/01/16 19:55:45 Beuc Exp $
 */

#include "dink.h"

void
duck_brain (int h)
{
  int hold;

/* UNREFERENCED start: */

  if ((spr[h].damage > 0) && (in_this_base (spr[h].pseq, 110)))

    {
      int crap2;
      check_for_duck_script (h);

      /* hit a dead duck */
      crap2 = add_sprite (spr[h].x, spr[h].y, 7, 164, 1);

      spr[crap2].speed = 0;
      spr[crap2].base_walk = 0;
      spr[crap2].seq = 164;
      draw_damage (h);
      spr[h].damage = 0;
      add_exp (spr[h].exp, h);

      kill_sprite_all (h);

      return;
    }


  if ((spr[h].damage > 0) && (in_this_base (spr[h].pseq, spr[h].base_walk)))
    {
      int crap;
      /* SoundPlayEffect( 1,3000, 800 );   */
      draw_damage (h);
      add_exp (spr[h].exp, h);
      spr[h].damage = 0;

      /* lets kill the duck here, ha. */
      check_for_kill_script (h);
      spr[h].follow = 0;
      crap = add_sprite (spr[h].x, spr[h].y, 5, 1, 1);

      spr[crap].speed = 0;
      spr[crap].base_walk = 0;
      spr[crap].size = spr[h].size;
      spr[crap].speed = ((rand () % 3) + 1);


      spr[h].base_walk = 110;
      spr[h].speed = 1;
      spr[h].timer = 0;
      spr[h].wait = 0;
      spr[h].frame = 0;

      if (spr[h].dir == 0)
	spr[h].dir = 1;
      if (spr[h].dir == 4)
	spr[h].dir = 7;
      if (spr[h].dir == 6)
	spr[h].dir = 3;

      changedir (spr[h].dir, h, spr[h].base_walk);
      spr[crap].dir = spr[h].dir;
      spr[crap].base_walk = 120;
      changedir (spr[crap].dir, crap, spr[crap].base_walk);


      automove (h);
      return;
    }


  if (spr[h].move_active)
    {
      process_move (h);
      return;
    }

  if (spr[h].freeze)
    {
      return;
    }


  if (spr[h].follow > 0)
    {
      process_follow (h);
      return;
    }


  if (spr[h].base_walk == 110)
    {
      if ((rand () % 100) + 1 == 1)
	random_blood (spr[h].x, spr[h].y - 18, h);
      goto walk;
    }


  if (spr[h].seq == 0)
    {
      if (((rand () % 12) + 1) == 1)
	{
	  hold = ((rand () % 9) + 1);
	  if ((hold != 2) && (hold != 8) && (hold != 5))
	    {
	      /* Msg(("random dir change started.. %d", hold)); */
	      changedir (hold, h, spr[h].base_walk);
	    }
	  else
	    {
	      int junk = spr[h].size;

	      if (junk >= 100)
		junk = 18000 - (junk * 50);

	      if (junk < 100)
		junk = 16000 + (junk * 100);

	      SoundPlayEffect (1, junk, 800, h, 0);
	      spr[h].mx = 0;
	      spr[h].my = 0;
	      spr[h].wait = thisTickCount + (rand () % 300) + 200;
	    }
	  return;
	}

      if ((spr[h].mx != 0) || (spr[h].my != 0))
	{
	  spr[h].seq = spr[h].seq_orig;

	}
    }


walk:
  if (spr[h].y > playy)
    {
      changedir (9, h, spr[h].base_walk);
    }

  if (spr[h].x > playx - 30)
    {
      changedir (7, h, spr[h].base_walk);
    }
  if (spr[h].y < 10)
    {
      changedir (1, h, spr[h].base_walk);
    }
  if (spr[h].x < 30)
    {
      changedir (3, h, spr[h].base_walk);
    }

  /* Msg(("Duck dir is %d, seq is %d.", spr[h].dir, spr[h].seq));        */
  automove (h);

  if (check_if_move_is_legal (h) != 0)
    {
      if (spr[h].dir != 0)
	changedir (autoreverse_diag (h), h, spr[h].base_walk);
    }
}

/* end duck_brain */


void
pill_brain (int h)
{
  int hold;

  if (spr[h].damage > 0)
    {
      /* got hit */
      /* SoundPlayEffect( 1,3000, 800 );   */
      if (spr[h].hitpoints > 0)
	{
	  draw_damage (h);
	  if (spr[h].damage > spr[h].hitpoints)
	    spr[h].damage = spr[h].hitpoints;
	  spr[h].hitpoints -= spr[h].damage;

	  if (spr[h].hitpoints < 1)
	    {
	      /* they killed it */
	      check_for_kill_script (h);

	      if (spr[h].brain == 9)
		{
		  if (spr[h].dir == 0)
		    spr[h].dir = 3;
		  change_dir_to_diag (&spr[h].dir);
		  add_kill_sprite (h);
		  spr[h].active = 0;
		}
	      return;

	    }
	}
      spr[h].damage = 0;

    }

  if (spr[h].move_active)
    {
      process_move (h);
      return;
    }

  if (spr[h].freeze)
    return;

  if (spr[h].follow > 0)
    {
      process_follow (h);
    }

  if (spr[h].target != 0)
    {
      int dir, distance;

      if (in_this_base (spr[h].seq, spr[h].base_attack))
	{
	  /* still attacking */
	  return;
	}

      if (spr[h].distance == 0)
	spr[h].distance = 5;
      distance = get_distance_and_dir (h, spr[h].target, &dir);


      if (distance < spr[h].distance)
	if (spr[h].attack_wait < thisTickCount)
	  {
	    /* Msg(("base attack is %d.",spr[h].base_attack)); */
	    if (spr[h].base_attack != -1)
	      {

		/* Msg(("attacking with %d..", spr[h].base_attack+dir)); */

		spr[h].dir = dir;
		spr[h].seq = spr[h].base_attack + spr[h].dir;
		spr[h].frame = 0;

		if (spr[h].script != 0) {
		  if (locate (spr[h].script, "ATTACK"))
		    run_script (spr[h].script);
		  else
		    spr[h].move_wait =
		      thisTickCount + ((rand () % 300) + 10);;
		}
		return;
	      }
	  }

      if (spr[h].move_wait < thisTickCount)
	{
	  process_target (h);
	  spr[h].move_wait = thisTickCount + 200;
	}
      else
	{
	  goto walk_normal;
	}
      return;
    }

walk_normal:
  if (spr[h].base_walk != -1)
    {
      if (spr[h].seq == 0)
	goto recal;
    }

  if ((spr[h].seq == 0) && (spr[h].move_wait < thisTickCount))
    {
    recal:
      if (((rand () % 12) + 1) == 1)
	{
	  hold = ((rand () % 9) + 1);
	  if ((hold != 4) && (hold != 6) && (hold != 2) && (hold != 8)
	      && (hold != 5))
	    {
	      changedir (hold, h, spr[h].base_walk);
	      spr[h].move_wait = thisTickCount + ((rand () % 2000) + 200);
	    }
	}
      else
	{
	  /* keep going the same way */
	  if (in_this_base (spr[h].seq_orig, spr[h].base_attack))
	    goto recal;
	  spr[h].seq = spr[h].seq_orig;
	  if (spr[h].seq_orig == 0)
	    goto recal;
	}
    }

  if (spr[h].y > (playy - 15))
    {
      changedir (9, h, spr[h].base_walk);
    }
  if (spr[h].x > (playx - 15))
    {
      changedir (1, h, spr[h].base_walk);
    }


  if (spr[h].y < 18)
    {
      changedir (1, h, spr[h].base_walk);
    }

  if (spr[h].x < 18)
    {
      changedir (3, h, spr[h].base_walk);
    }

  automove (h);
  if (check_if_move_is_legal (h) != 0)
    {
      spr[h].move_wait = thisTickCount + 400;
      changedir (autoreverse_diag (h), h, spr[h].base_walk);
    }
  /* changedir(hold,h,spr[h].base_walk); */
}				/* End Pill Brain */


void
people_brain (int h)
{
/* UNREFERENCED   int hold; */
  if (spr[h].damage > 0)
    {
      /* got hit */
      /* SoundPlayEffect( 1,3000, 800 );   */

      if (spr[h].hitpoints > 0)
	{
	  draw_damage (h);
	  if (spr[h].damage > spr[h].hitpoints)
	    spr[h].damage = spr[h].hitpoints;
	  spr[h].hitpoints -= spr[h].damage;

	  if (spr[h].hitpoints < 1)
	    {
	      /* they killed it */
	      check_for_kill_script (h);

	      if (spr[h].brain == 16)
		{
		  if (spr[h].dir == 0)
		    spr[h].dir = 3;
		  spr[h].brain = 0;
		  change_dir_to_diag (&spr[h].dir);
		  add_kill_sprite (h);
		  spr[h].active = 0;
		}
	      return;
	    }
	}
      spr[h].damage = 0;
    }

  if (spr[h].move_active)
    {
      process_move (h);
      return;
    }

  if (spr[h].freeze)
    return;

  if (spr[h].follow > 0)
    {
      process_follow (h);
      return;
    }

  if ((spr[h].move_wait < thisTickCount) && (spr[h].seq == 0))
    {
      spr[h].action = 0;
    }

  if (spr[h].action == 0)
    find_action (h);

  if (spr[h].action != 2)
    {
      spr[h].seq = 0;
      return;
    }

  if (spr[h].seq_orig != 0)
    if (spr[h].seq == 0)
      spr[h].seq = spr[h].seq_orig;

  if (spr[h].y > playy)
    {
      if (((rand () % 2) + 1) == 1)
	changedir (9, h, spr[h].base_walk);
      else
	changedir (7, h, spr[h].base_walk);
    }

  if (spr[h].x > playx)
    {
      if (((rand () % 2) + 1) == 1)
	changedir (1, h, spr[h].base_walk);
      else
	changedir (7, h, spr[h].base_walk);
    }

  if (spr[h].y < 20)
    {
      if (((rand () % 2) + 1) == 1)
	changedir (1, h, spr[h].base_walk);
      else
	changedir (3, h, spr[h].base_walk);
    }

  if (spr[h].x < 30)
    {
      if (((rand () % 2) + 1) == 1)
	changedir (3, h, spr[h].base_walk);
      else
	changedir (9, h, spr[h].base_walk);
    }

  automove (h);

  if (check_if_move_is_legal (h) != 0)
    {
      if ((rand () % 3) == 2)
	{
	  changedir (autoreverse_diag (h), h, spr[h].base_walk);
	}
      else
	{
	  spr[h].move_wait = 0;
	  spr[h].pframe = 1;
	  spr[h].seq = 0;
	}
    }
  /* changedir(hold,h,spr[h].base_walk); */
}


void
no_brain (int h)
{
/* UNREFERENCED   int hold; */
  if (spr[h].move_active)
    {
      process_move (h);
      return;
    }

  if (spr[h].freeze)
    return;

  if (spr[h].follow > 0)
    {
      process_follow (h);
      return;
    }
}


void
shadow_brain (int h)
{
/* UNREFERENCED   int hold; */
  if (spr[spr[h].brain_parm].active == 0)
    {
      spr[h].active = 0;
      return;
    }

  spr[h].x = spr[spr[h].brain_parm].x;
  spr[h].y = spr[spr[h].brain_parm].y;
  spr[h].size = spr[spr[h].brain_parm].size;

  if (spr[h].seq == 0)
    if (spr[h].seq_orig != 0)
      spr[h].seq = spr[h].seq_orig;
}


void
dragon_brain (int h)
{
  int hold;

  if (spr[h].damage > 0)
    {
      /* got hit */
      /* SoundPlayEffect( 1,3000, 800 );   */
      if (spr[h].hitpoints > 0)
	{
	  draw_damage (h);
	  if (spr[h].damage > spr[h].hitpoints)
	    spr[h].damage = spr[h].hitpoints;
	  spr[h].hitpoints -= spr[h].damage;

	  if (spr[h].hitpoints < 1)
	    {
	      /* they killed it */
	      check_for_kill_script (h);
	      if (spr[h].brain == 10)
		{
		  add_kill_sprite (h);
		  spr[h].active = 0;
		}
	      return;
	    }
	}
      spr[h].damage = 0;
    }

  if (spr[h].move_active)
    {
      process_move (h);
      return;
    }

  if (spr[h].freeze)
    return;

  if (spr[h].follow > 0)
    {
      process_follow (h);
      return;
    }

  if (spr[h].target != 0)
    if (spr[h].attack_wait < thisTickCount)
      {
	if (spr[h].script != 0)
	  {
	    if (locate (spr[h].script, "ATTACK"))
	      run_script (spr[h].script);
	  }
      }

  if (spr[h].seq == 0)
    {
    recal:
      if (((rand () % 12) + 1) == 1)
	{
	  hold = ((rand () % 9) + 1);
	  if ((hold != 1) && (hold != 3) && (hold != 7) && (hold != 9)
	      && (hold != 5))
	    {
	      changedir (hold, h, spr[h].base_walk);
	    }
	}
      else
	{
	  /* keep going the same way */
	  spr[h].seq = spr[h].seq_orig;
	  if (spr[h].seq_orig == 0)
	    goto recal;
	}
    }


  if (spr[h].y > playy)
    {
      changedir (8, h, spr[h].base_walk);
    }

  if (spr[h].x > x)
    {
      changedir (4, h, spr[h].base_walk);
    }

  if (spr[h].y < 0)
    {
      changedir (2, h, spr[h].base_walk);
    }

  if (spr[h].x < 0)
    {
      changedir (6, h, spr[h].base_walk);
    }

  automove (h);

  if (check_if_move_is_legal (h) != 0)
    {
      int mydir = autoreverse (h);

      /* Msg(("Real dir now is %d, autoresver changed to %d.",spr[h].dir, mydir)); */
      changedir (mydir, h, spr[h].base_walk);
      Msg (("real dir changed to %d", spr[h].dir));
    }
}


void
pig_brain (int h)
{
  int hold;

/* UNREFERENCED start: */

  if (spr[h].move_active)
    {
      process_move (h);
      return;
    }

  if ((spr[h].damage > 0))
    {
      /* SoundPlayEffect( 1,3000, 800 );   */
      draw_damage (h);
      spr[h].hitpoints -= spr[h].damage;
      spr[h].damage = 0;
      if (spr[h].hitpoints < 1)
	{
	  add_exp (spr[h].exp, h);
	  spr[h].damage = 0;
	  /* lets kill the duck here, ha. */
	  check_for_kill_script (h);
	  spr[h].speed = 0;
	  spr[h].base_walk = -1;
	  spr[h].seq = 164;
	  spr[h].brain = 7;
	}
      return;
    }

  if (spr[h].freeze)
    return;

  if (spr[h].seq == 0)
    {
      if (((rand () % 12) + 1) == 1)
	{
	  hold = ((rand () % 9) + 1);

	  if ((hold != 4) && (hold != 6) && (hold != 2) && (hold != 8)
	      && (hold != 5))
	    {
	      changedir (hold, h, spr[h].base_walk);
	    }
	  else
	    {
	      int junk = spr[h].size;

	      if (junk >= 100)
		junk = 18000 - (junk * 50);

	      if (junk < 100)
		junk = 16000 + (junk * 100);

	      hold = ((rand () % 4) + 1);

	      if (!playing (spr[h].last_sound))
		spr[h].last_sound = 0;

	      if (spr[h].last_sound == 0)
		{
		  if (hold == 1)
		    spr[h].last_sound = SoundPlayEffect (2, junk, 800, h, 0);
		  if (hold == 2)
		    spr[h].last_sound = SoundPlayEffect (3, junk, 800, h, 0);
		  if (hold == 3)
		    spr[h].last_sound = SoundPlayEffect (4, junk, 800, h, 0);
		  if (hold == 4)
		    spr[h].last_sound = SoundPlayEffect (5, junk, 800, h, 0);
		}
	      spr[h].mx = 0;
	      spr[h].my = 0;
	      spr[h].wait = thisTickCount + (rand () % 300) + 200;
	    }
	}
      else
	{
	  if ((spr[h].mx != 0) || (spr[h].my != 0))
	    {
	      spr[h].seq = spr[h].seq_orig;
	    }
	}
    }

  if (spr[h].y > (playy - k[getpic (h)].box.bottom / 4))
    {
      changedir (9, h, spr[h].base_walk);
    }

  if (spr[h].x > (x - k[getpic (h)].box.right - 10))
    {
      changedir (1, h, spr[h].base_walk);
    }

  if (spr[h].y < 10)
    {
      changedir (1, h, spr[h].base_walk);
    }

  if (spr[h].x < 10)
    {
      changedir (3, h, spr[h].base_walk);
    }

  automove (h);

  if (check_if_move_is_legal (h) != 0)
    {
      changedir (autoreverse_diag (h), h, spr[h].base_walk);
    }
}

/* end duck_brain */


void
bounce_brain (int h)
{
  if (spr[h].y > (playy - k[getpic (h)].box.bottom))
    {
      spr[h].my -= (spr[h].my * 2);
    }

  if (spr[h].x > (x - k[getpic (h)].box.right))
    {
      spr[h].mx -= (spr[h].mx * 2);
    }

  if (spr[h].y < 0)
    {
      spr[h].my -= (spr[h].my * 2);
    }

  if (spr[h].x < 0)
    {
      spr[h].mx -= (spr[h].mx * 2);
    }

  spr[h].x += spr[h].mx;
  spr[h].y += spr[h].my;
}

/* end bounce brain       */


void
missile_brain (int h, /*bool*/int repeat)
{
  struct rect box;
  int hard;
  automove (h);

  *pmissle_source = h;
  hard = check_if_move_is_legal (h);

  if (repeat)
    if (spr[h].seq == 0)
      spr[h].seq = spr[h].seq_orig;

  spr[1].hitpoints = *plife;

  if (hard > 0)
    if (hard != 2)
      {
	/* lets check to see if they hit a sprites hardness */
	if (hard > 100)
	  {
	    int ii;
	    for (ii = 1; ii < last_sprite_created; ii++)
	      {
		if (spr[ii].sp_index == hard - 100)
		  {
		    if (spr[ii].script > 0)
		      {
			*pmissile_target = 1;
			*penemy_sprite = 1;

			if (locate (spr[ii].script, "HIT"))
			  {
			    kill_returning_stuff (spr[ii].script);

			    run_script (spr[ii].script);
			  }
		      }

		    if (spr[h].script > 0)
		      {
			*pmissile_target = ii;
			*penemy_sprite = 1;

			if (locate (spr[h].script, "DAMAGE"))
			  {
			    kill_returning_stuff (spr[h].script);
			    run_script (spr[h].script);
			  }
		      }
		    else
		      {
			if (spr[h].attack_hit_sound == 0)
			  {
			    SoundPlayEffect (9, 22050, 0, 0, 0);
			  }
			else
			  {
			    SoundPlayEffect (spr[h].attack_hit_sound,
					     spr[h].attack_hit_sound_speed, 0,
					     0, 0);
			  }
			spr[h].active = 0;
		      }

		    /* run missile end        */
		    return;
		  }
	      }
	  }
	/* run missile end        */

	if (spr[h].script > 0)
	  {
	    *pmissile_target = 0;
	    if (locate (spr[h].script, "DAMAGE"))
	      run_script (spr[h].script);
	  }
	else
	  {
	    if (spr[h].attack_hit_sound == 0)
	      {
		SoundPlayEffect (9, 22050, 0, 0, 0);
	      }
	    else
	      {
		SoundPlayEffect (spr[h].attack_hit_sound,
				 spr[h].attack_hit_sound_speed, 0, 0, 0);
	      }
	    spr[h].active = 0;
	    return;
	  }
      }

  if (spr[h].x > 1000)
    spr[h].active = 0;
  if (spr[h].y > 700)
    spr[h].active = 0;
  if (spr[h].y < -500)
    spr[h].active = 0;
  if (spr[h].x < -500)
    spr[h].active = 0;

  /* did we hit anything that can die? */
  {
    int j;
    for (j = 1; j <= last_sprite_created; j++)
      {
	if ((spr[j].active) && (h != j) && (spr[j].nohit != 1)
	    && (spr[j].notouch == 0) && (spr[h].brain_parm != j)
	    && (spr[h].brain_parm2 != j))
	  /* if (spr[j].brain != 15) if */
	  /* (spr[j].brain != 11) */
	  {
	    CopyRect (&box, &k[getpic (j)].hardbox);
	    OffsetRect (&box, spr[j].x, spr[j].y);
	    
	    if (spr[h].range != 0)
	      InflateRect (&box, spr[h].range, spr[h].range);
	    
	    if (debug_mode)
	      draw_box (box, 33);
	    
	    if (inside_box (spr[h].x, spr[h].y, box))
	      {
		spr[j].notouch = 1;
		spr[j].notouch_timer = thisTickCount + 100;
		spr[j].target = 1;
		*penemy_sprite = 1;
		
		/* change later to reflect REAL target */
		if (spr[h].script > 0)
		  {
		    *pmissile_target = j;
		    
		    if (locate (spr[h].script, "DAMAGE"))
		      run_script (spr[h].script);
		  }
		else
		  {
		    if (spr[h].attack_hit_sound == 0)
		      {
			SoundPlayEffect (9, 22050, 0, 0, 0);
		      }
		    else
		      {
			SoundPlayEffect (spr[h].attack_hit_sound,
					 spr[h].
					 attack_hit_sound_speed, 0, 0,
					 0);
		      }
		  }
		
		if (spr[j].hitpoints > 0)
		  if (spr[h].strength != 0)
		    {
		      int hit = 0;
		      
		      if (spr[h].strength == 1)
			hit = spr[h].strength - spr[j].defense;
		      else
			hit =
			  (spr[h].strength / 2) +
			  ((rand () % (spr[h].strength / 2)) + 1) -
			  spr[j].defense;
		      
		      if (hit < 0)
			hit = 0;
		      
		      spr[j].damage += hit;
		      
		      if (hit > 0)
			{
			  random_blood (spr[j].x, spr[j].y - 40, j);
			}
		      
		      spr[j].last_hit = 1;
		      /* Msg(("Damage done is %d..", spr[j].damage)); */
		    }
		
		
		if (spr[j].script > 0)
		  {
		    /* CHANGED did = h */
		    *pmissile_target = 1;
		    
		    if (locate (spr[j].script, "HIT"))
		      {
			kill_returning_stuff (spr[j].script);
			run_script (spr[j].script);
		      }
		  }
	      }
		      
	    /* run missile end        */
	  }
      }
  }
}


void
missile_brain_expire (int h)
{
  missile_brain (h, 0);

  if (spr[h].seq == 0)
    spr[h].active = 0;
}

void
mouse_brain (int h)
{
  int diag;
  if (spr[h].move_active)
    {
      process_move (h);
      return;
    }
  diag = 0;

  if (sjoy.right)
    diag++;
  if (sjoy.left)
    diag++;
  if (sjoy.down)
    diag++;
  if (sjoy.up)
    diag++;

  /* *********************************PROCESS MOVEMENT */
  if (diag == 1)
    {
      if (sjoy.right)
	{
	  move (h, spr[h].speed, '+', '0');
	  changedir (6, h, spr[h].base_walk);
	}

      if (sjoy.left)
	{
	  move (h, spr[h].speed, '-', '0');
	  changedir (4, h, spr[h].base_walk);
	}

      if (sjoy.down)
	{
	  move (h, spr[h].speed, '0', '+');

	  changedir (2, h, spr[h].base_walk);
	}

      if (sjoy.up)
	{
	  move (h, spr[h].speed, '0', '-');

	  changedir (8, h, spr[h].base_walk);
	}
    }

  /* ***************** DIAGONAL!!!! */
  if (diag > 1)
    {
      if ((sjoy.up) & (sjoy.left))
	{
	  changedir (7, h, spr[h].base_walk);
	  move (h, spr[h].speed - (spr[h].speed / 3), '-', '-');
	}

      if ((sjoy.down) & (sjoy.left))
	{
	  changedir (1, h, spr[h].base_walk);
	  move (h, spr[h].speed - (spr[h].speed / 3), '-', '+');
	}

      if ((sjoy.down) & (sjoy.right))
	{
	  changedir (3, h, spr[h].base_walk);
	  move (h, spr[h].speed - (spr[h].speed / 3), '+', '+');
	}

      if ((sjoy.up) & (sjoy.right))
	{
	  changedir (9, h, spr[h].base_walk);
	  move (h, spr[h].speed - (spr[h].speed / 3), '+', '-');
	}
    }

  if ((sjoy.button[1] == 1) | (mouse1))
    {
      Msg (("running through mouse list.."));
      run_through_mouse_list (h, 1);
      sjoy.button[1] = 0;
      mouse1 = 0;
    }
}

/*********  HUMAN BRAIN ***************/
void
human_brain (int h)
{



  int diag, x5;

  int crap;

  BOOL bad;



  if (mode == 0)
    goto b1end;





  if (spr[h].move_active)

    {

      process_move (h);

      return;

    }





  if (spr[h].damage > 0)
    {
      int hurt;

      draw_damage (h);
      *plife -= spr[h].damage;
      spr[h].damage = 0;

      if (*plife < 0)
	*plife = 0;

      hurt = (rand () % 2) + 1;

      if (hurt == 1)
	SoundPlayEffect (15, 25050, 2000, 0, 0);

      if (hurt == 2)
	SoundPlayEffect (16, 25050, 2000, 0, 0);

      /* draw blood */
    }

  if (play.push_active)
    {
      if (play.push_dir == 2)
	if (!sjoy.down)
	  {
	    spr[h].nocontrol = 0;
	    play.push_active = 0;
	  }

      if (play.push_dir == 4)
	if (!sjoy.left)
	  {
	    spr[h].nocontrol = 0;
	    play.push_active = 0;
	  }

      if (play.push_dir == 6)
	if (!sjoy.right)
	  {
	    spr[h].nocontrol = 0;
	    play.push_active = 0;
	  }

      if (play.push_dir == 8)
	if (!sjoy.up)
	  {
	    spr[h].nocontrol = 0;
	    play.push_active = 0;
	  }
    }

  if (spr[h].nocontrol)
    return;

  if (talk.active)
    goto freeze;

  if (spr[h].freeze)
    {
      /* they are frozen */
      if ((sjoy.button[2] == 1) || (sjoy.key[32]))
	{
	  /* they hit the talk button while frozen, lets hurry up the process */
	  int jj;
	  for (jj = 1; jj <= last_sprite_created; jj++)
	    {
	      /* Msg(("Checking %d, brain %d, script %d, my freeze is %d",jj, spr[jj].brain, spr[jj].script, spr[h].freeze)); */
	      if (spr[jj].brain == 8)
		if (spr[jj].script == play.last_talk)
		  {
		    /* this sprite owns its freeze */
		    spr[jj].kill_timer = 1;
		    /* force the message to be over */
		  }
	    }
	}
      goto freeze;
    }

  /* ******************************  KEYS THAT CAN BE PRESSED AT ANY TIME ************** */
  /* if (GetKeyboard(127) PostMessage(hWnd, WM_CLOSE, 0, 0); */
  if (bow.active)
    {
      /* bow is active!! */
      process_bow (h);
      return;
    }

  if (play.push_active)
    if (play.push_timer + 600 < thisTickCount)
      {
	spr[h].seq = 310 + spr[h].dir;
	spr[h].frame = 1;
	spr[h].nocontrol = 1;
	/* play.push_active = 0; */
	run_through_tag_list_push (h);
	return;
      }

  if ((sjoy.button[2] == 1))
    {
      if (!run_through_tag_list_talk (h))
	{
	  int randy;
	  kill_text_owned_by (h);
	  randy = (rand () % 6) + 1;
/*			

			

#ifdef __GERMAN

			if (randy == 1) say_text("`$Hier ist nichts.",h,0);

			if (randy == 2) say_text("`$Huh?",h,0);

			if (randy == 3) say_text("`$Ich bin mir ziemlich sicher ich kann dies weder ansprechen, noch benutzen.",h,0);

			if (randy == 4) say_text("`$Was?",h,0);

			if (randy == 5) say_text("`$Bah, LANGWEILIG.",h,0);

			if (randy == 6) say_text("`$Hier passiert nichts.",h,0);

			

#endif

  */



#ifdef __ENGLISH

	  if (randy == 1)
	    say_text ("`$I don't see anything here.", h, 0);

	  if (randy == 2)
	    say_text ("`$Huh?", h, 0);

	  if (randy == 3)
	    say_text ("`$I'm fairly sure I can't talk to or use that.", h, 0);

	  if (randy == 4)
	    say_text ("`$What?", h, 0);

	  if (randy == 5)
	    say_text ("`$I'm bored.", h, 0);

	  if (randy == 6)
	    say_text ("`$Not much happening here.", h, 0);

#endif

	}





    }





  if ((sjoy.button[1] == 1) && (weapon_script != 0))

    {







      if (spr[h].base_hit > 0)

	{





	  if (locate (weapon_script, "USE"))
	    run_script (weapon_script);



	  goto b1end;



	}



    }





  /* added AGAIN 10-19-99 */

  /* Let's check keys for getting hit */

  if (but_timer < thisTickCount)
    {
      for (x5 = 29; x5 < 256; x5++)
	{
	  if (x5 == 32)
	    x5++;
	  if (x5 == 54)
	    x5++;
	  if (x5 == 55)
	    x5++;
	  if (x5 == 37)
	    x5++;
	  if (x5 == 38)
	    x5++;
	  if (x5 == 39)
	    x5++;
	  if (x5 == 40)
	    x5++;
	  if (x5 == 77)
	    x5++;

	  {
	    char msg[30];
	    if (GetKeyboard (x5))
	      {
		int mycrap;
		sprintf (msg, "key-%d", x5);
		but_timer = thisTickCount + 200;
		
		mycrap = load_script (msg, 1, 0);
		if (locate (mycrap, "main"))
		  {
		    run_script (mycrap);
		    goto b1end;
		  }
	      }
	  }
	}
    }

  if ((sjoy.button[6] == 1)
      || ((GetKeyboard (SDLK_m)) && (but_timer < thisTickCount)))
    {
      int mycrap;
      but_timer = thisTickCount + 200;
      mycrap = load_script ("button6", 1, 0);

      if (locate (mycrap, "main"))
	run_script (mycrap);

      goto b1end;

    }



  if (magic_script != 0)
    if (sjoy.joybit[3])
      goto shootm;

  if ((sjoy.button[3] == 1))

    {

      if (magic_script == 0)

	{

	  int randy = (rand () % 6) + 1;

	  kill_text_owned_by (h);



/*		

#ifdef __GERMAN

			

			if (randy == 3) 

				

				

				if (randy == 1) say_text("`$Ich mu erst die Magie erlernen, bevor ich dies ausprobieren kann..",h,0);

				if (randy == 2) say_text("`$Ich gestikuliere hier wie wirr!",h,0);

				if (randy == 3) say_text("`$Ich gestikuliere hier wie wirr!",h,0);

				if (randy == 4) say_text("`$Ich gestikuliere hier wie wirr!",h,0);

				if (randy == 5) say_text("`$Nichts ist passiert.",h,0);

				

				if (randy == 6) say_text("`$Hokus pokus!",h,0);							 	    

				

#endif

*/



#ifdef __ENGLISH



	  if (randy == 1)
	    say_text ("`$I don't know any magic.", h, 0);

	  if (randy == 2)
	    say_text ("`$I'm no wizard!", h, 0);

	  if (randy == 3)
	    say_text ("`$I need to learn magic before trying this.", h, 0);

	  if (randy == 4)
	    say_text ("`$I'm gesturing wildly to  no avail!", h, 0);

	  if (randy == 5)
	    say_text ("`$Nothing happened.", h, 0);

	  if (randy == 6)
	    say_text ("`$Hocus pocus!", h, 0);



#endif







	  goto b1end;

	}



      /* player pressed 1 */

      /* lets magiced something */

    shootm:

      if (*pmagic_level >= *pmagic_cost)

	{

	  if (locate (magic_script, "USE"))
	    run_script (magic_script);



	  goto b1end;

	}

    }



  if (sjoy.button[4])

    {

      item_screen = 1;

      SoundPlayEffect (18, 22050, 0, 0, 0);



      return;

    }







  if (GetKeyboard (SDLK_2))

    {



      if (!no_cheat)

	{

	  /* player pressed 2 */

	  /* lets add a duck with brain 2 */



	  crap = add_sprite (spr[h].x - 20, spr[h].y - 50, 3, 26, 1);

	  spr[crap].speed = 1;

	  spr[crap].base_walk = 20;

	  spr[crap].exp = 11;

	  spr[crap].hitpoints = 5;

	}

    }





  if ((sjoy.button[5] == 1))

    {



      if (!showb.active)
	if (!bow.active)
	  if (!talk.active)

	    {

	      int sc = load_script ("escape", 1000, 0);

	      if (sc != 0)
		if (locate (sc, "main"))
		  run_script (sc);

	      return;

	    }

    }





  if (GetKeyboard (SDLK_b))

    {

      ResumeMidi ();

    }



  if (GetKeyboard (SDLK_n))

    {

      PauseMidi ();

    }



  if (spr[h].skip > 0)



    if (spr[h].skip <= spr[h].skiptimer)

      {

	spr[h].skiptimer = 0;

	goto b1end;

      }





  diag = 0;

  if (sjoy.right)
    diag++;

  if (sjoy.left)
    diag++;

  if (sjoy.down)
    diag++;

  if (sjoy.up)
    diag++;





  /* *********************************PROCESS MOVEMENT                                                      */



  if (diag == 1)

    {



      if (sjoy.right)

	{

	  move (h, spr[h].speed, '+', '0');

	  changedir (6, h, spr[h].base_walk);

	}





      if (sjoy.left)

	{

	  move (h, spr[h].speed, '-', '0');

	  changedir (4, h, spr[h].base_walk);

	}





      if (sjoy.down)

	{

	  move (h, spr[h].speed, '0', '+');

	  changedir (2, h, spr[h].base_walk);



	}





      if (sjoy.up)

	{

	  move (h, spr[h].speed, '0', '-');

	  changedir (8, h, spr[h].base_walk);

	}



    }

  /* ***************** DIAGONAL!!!! */
  if (diag > 1)
    if (diag < 3)
      {
	if ((sjoy.up) & (sjoy.left))
	  {
	    changedir (7, h, spr[h].base_walk);
	    move (h, spr[h].speed - (spr[h].speed / 3), '-', '-');
	  }

	if ((sjoy.down) & (sjoy.left))
	  {
	    changedir (1, h, spr[h].base_walk);
	    move (h, spr[h].speed - (spr[h].speed / 3), '-', '+');
	  }

	if ((sjoy.down) & (sjoy.right))
	  {
	    changedir (3, h, spr[h].base_walk);
	    move (h, spr[h].speed - (spr[h].speed / 3), '+', '+');
	  }

	if ((sjoy.up) & (sjoy.right))
	  {
	    changedir (9, h, spr[h].base_walk);
	    move (h, spr[h].speed - (spr[h].speed / 3), '+', '-');
	  }
      }

  bad = 0;
  if (sjoy.right)
    bad = 1;
  if (sjoy.left)
    bad = 1;
  if (sjoy.up)
    bad = 1;
  if (sjoy.down)
    bad = 1;

  if (bad)
    {
      if (spr[h].idle)
	{
	  spr[h].frame = 1;
	  spr[h].idle = 0;
	}
      goto badboy;
    }

  if (not_in_this_base (spr[h].seq, spr[h].base_idle))	/* unccoment to allow walk anim to end before idle anim to start */
    {
    freeze:
      if (spr[h].dir == 1)
	spr[h].dir = 2;

      if (spr[h].dir == 3)
	spr[h].dir = 2;

      if (spr[h].dir == 7)
	spr[h].dir = 8;

      if (spr[h].dir == 9)
	spr[h].dir = 8;

      if (spr[h].base_idle != 0)
	changedir (spr[h].dir, h, spr[h].base_idle);

      spr[h].idle = 1;
    }

badboy:

b1end:

  if ((spr[h].dir == 2) | (spr[h].dir == 4) | (spr[h].dir ==
					       6) | (spr[h].dir == 8))
    goto smoothend;
  crap = check_if_move_is_legal (h);

  if (crap != 0)
    {
      if (pam.sprite[crap - 100].prop != 0)
	flub_mode = crap;
      /* hit something, can we move around it? */
      if ((spr[h].seq == spr[h].base_walk + 4) | (spr[h].seq ==
						  spr[h].base_walk + 6))
	{
	  int hardm = get_hard_play (h, spr[h].x, spr[h].y - 1);

	  if (hardm == 0)
	    {
	      spr[h].y -= 1;
	    }
	}

      if ((spr[h].seq == spr[h].base_walk + 8) | (spr[h].seq ==
						  spr[h].base_walk + 2))

	{
	  int hardm = get_hard_play (h, spr[h].x - 1, spr[h].y);
	  if (hardm == 0)
	    {
	      spr[h].x -= 1;
	    }
	}

      if (spr[h].seq == spr[h].base_walk + 9)
	{
	  int hardm = get_hard_play (h, spr[h].x + 1, spr[h].y);

	  if (hardm == 0)
	    {
	      spr[h].x += 1;
	    }
	  else
	    {
	      int hardm = get_hard_play (h, spr[h].x + 1, spr[h].y + 1);

	      if (hardm == 0)
		{
		  spr[h].x += 1;
		  spr[h].y += 1;
		}
	      else
		{
		  int hardm = get_hard_play (h, spr[h].x + 1, spr[h].y + 2);

		  if (hardm == 0)
		    {
		      spr[h].x += 1;
		      spr[h].y += 2;
		    }
		  else
		    {
		      int hardm = get_hard_play (h, spr[h].x, spr[h].y - 1);

		      if (hardm == 0)
			{
			  spr[h].y -= 1;
			}
		      else
			{
			  int hardm =
			    get_hard_play (h, spr[h].x - 1, spr[h].y - 1);

			  if (hardm == 0)
			    {
			      spr[h].x -= 1;
			      spr[h].y -= 1;
			    }
			}
		    }
		}
	    }
	}

      if (spr[h].seq == spr[h].base_walk + 7)
	{
	  int hardm = get_hard_play (h, spr[h].x - 1, spr[h].y);

	  if (hardm == 0)
	    {
	      spr[h].x -= 1;
	    }
	  else
	    {
	      int hardm = get_hard_play (h, spr[h].x - 1, spr[h].y + 1);

	      if (hardm == 0)
		{
		  spr[h].x -= 1;
		  spr[h].y += 1;
		}
	      else
		{
		  int hardm = get_hard_play (h, spr[h].x - 1, spr[h].y + 2);

		  if (hardm == 0)
		    {
		      spr[h].x -= 1;
		      spr[h].y += 2;
		    }
		  else
		    {
		      int hardm = get_hard_play (h, spr[h].x, spr[h].y - 1);
		      if (hardm == 0)
			{
			  spr[h].y -= 1;
			}
		      else
			{
			  int hardm =
			    get_hard_play (h, spr[h].x + 1, spr[h].y - 1);

			  if (hardm == 0)
			    {
			      spr[h].x += 1;
			      spr[h].y -= 1;
			    }
			}
		    }
		}
	    }
	}

      if (spr[h].seq == spr[h].base_walk + 1)
	{
	  int hardm = get_hard_play (h, spr[h].x - 1, spr[h].y);

	  if (hardm == 0)
	    {
	      spr[h].x -= 1;
	    }
	  else
	    {
	      int hardm = get_hard_play (h, spr[h].x - 1, spr[h].y - 1);

	      if (hardm == 0)
		{
		  spr[h].x -= 1;
		  spr[h].y -= 1;
		}
	      else
		{
		  int hardm = get_hard_play (h, spr[h].x - 1, spr[h].y - 2);

		  if (hardm == 0)
		    {
		      spr[h].x -= 1;
		      spr[h].y -= 2;
		    }
		  else
		    {
		      int hardm = get_hard_play (h, spr[h].x, spr[h].y + 1);

		      if (hardm == 0)
			{
			  spr[h].y += 1;
			}
		      else
			{
			  int hardm =
			    get_hard_play (h, spr[h].x + 1, spr[h].y + 1);

			  if (hardm == 0)
			    {
			      spr[h].x += 1;
			      spr[h].y += 1;
			    }
			}
		    }
		}
	    }
	}

      if (spr[h].seq == spr[h].base_walk + 3)
	{
	  int hardm = get_hard_play (h, spr[h].x + 1, spr[h].y);

	  if (hardm == 0)
	    {
	      spr[h].x += 1;
	    }
	  else
	    {
	      int hardm = get_hard_play (h, spr[h].x + 1, spr[h].y - 1);

	      if (hardm == 0)
		{
		  spr[h].x += 1;
		  spr[h].y -= 1;
		}
	      else
		{
		  int hardm = get_hard_play (h, spr[h].x + 1, spr[h].y - 2);

		  if (hardm == 0)
		    {
		      spr[h].x += 1;
		      spr[h].y -= 2;
		    }
		  else
		    {
		      int hardm = get_hard_play (h, spr[h].x, spr[h].y + 1);

		      if (hardm == 0)
			{
			  spr[h].y += 1;
			}
		      else
			{
			  int hardm =
			    get_hard_play (h, spr[h].x - 1, spr[h].y + 1);
			  if (hardm == 0)
			    {
			      spr[h].x -= 1;
			      spr[h].y += 1;
			    }
			}
		    }
		}
	    }
	}
    }
smoothend:;
}


void
one_time_brain_for_real (int h)
{
  if (spr[h].move_active)
    {
      process_move (h);
    }

  if (spr[h].follow > 0)
    {
      process_follow (h);
    }

  if (spr[h].seq == 0)
    {
      spr[h].active = 0;
      return;
    }

  if (spr[h].dir > 0)
    {
      changedir (spr[h].dir, h, -1);
      automove (h);
    }
}


void
scale_brain (int h)
{
  int num;

  if (spr[h].size == spr[h].brain_parm)
    {
      spr[h].active = 0;
      return;
    }

  num = 5 * (base_timing / 4);

  if (spr[h].size > spr[h].brain_parm)
    {
      if (spr[h].size - num < spr[h].brain_parm)
	num = spr[h].size - spr[h].brain_parm;
      spr[h].size -= num;
    }

  if (spr[h].size < spr[h].brain_parm)
    {
      if (spr[h].size + num > spr[h].brain_parm)
	num = spr[h].brain_parm - spr[h].size;
      spr[h].size += num;
    }

  if (spr[h].move_active)
    {
      process_move (h);
      return;
    }

  if (spr[h].dir > 0)
    {
      changedir (spr[h].dir, h, -1);
      automove (h);
    }
}


void
repeat_brain (int h)
{
  if (spr[h].move_active)
    {
      process_move (h);
      /* return; */
    }

  if (spr[h].seq_orig == 0)
    if (spr[h].sp_index != 0)
      {
	spr[h].seq_orig = pam.sprite[spr[h].sp_index].seq;
	spr[h].frame = pam.sprite[spr[h].sp_index].frame;
	spr[h].wait = 0;
	/* pam.sprite[spr[h].sp_index].frame; */
      }
  if (spr[h].seq == 0)
    spr[h].seq = spr[h].seq_orig;
}


void
text_brain (int h)
{
  if ((spr[h].damage == -1) && (spr[h].owner != 1000))
    {
      if (spr[spr[h].owner].active == 0)
	{
	  /* msg("Killing text brain %d, because owner %d is dead.",h, spr[h].owner); */
	  spr[h].active = 0;
	  return;
	}
      /* give this text the cords from it's owner sprite */
      spr[h].x = spr[spr[h].owner].x - spr[h].strength;
      spr[h].y = spr[spr[h].owner].y - spr[h].defense;

      if (spr[h].x < 1)
	spr[h].x = 1;
      if (spr[h].y < 1)
	spr[h].y = 1;
    }
  else
    {
      /* Msg(("automoving %d.. ", h)); */
      if (spr[h].move_active)
	{
	  process_move (h);
	  return;
	}
      automove (h);
    }
}


void
button_brain (int h)
{
  struct rect box;

  if (spr[h].move_active)
    {
      process_move (h);
      return;
    }

  if (spr[h].script == 0)
    return;

  CopyRect (&box, &k[getpic (h)].hardbox);
  OffsetRect (&box, spr[h].x, spr[h].y);

  if (spr[h].brain_parm == 0)
    {
      if (inside_box (spr[1].x, spr[1].y, box))
	{
	  spr[h].brain_parm = 1;
	  if (locate (spr[h].script, "BUTTONON"))
	    {
	      run_script (spr[h].script);
	      return;
	    }
	}
    }
  else
    {
      if (!inside_box (spr[1].x, spr[1].y, box))
	{
	  spr[h].brain_parm = 0;
	  if (locate (spr[h].script, "BUTTONOFF"))
	    {
	      run_script (spr[h].script);
	      return;
	    }
	}
    }
}


void
one_time_brain (int h)
{
  /* goes once then draws last frame to background */
  if (spr[h].move_active)
    {
      process_move (h);
      return;
    }

  if (spr[h].follow > 0)
    {
      process_follow (h);
    }


  if (spr[h].seq == 0)
    {
      draw_sprite_game (lpDDSTwo, h);
      spr[h].active = 0;
      return;
    }
  changedir (spr[h].dir, h, -1);
  automove (h);
}


/**
 * Find and execute DinkC "die()" procedure of sprite #i
 */
/*bool*/int
check_for_kill_script (int i)
{

  if (spr[i].script > 0)

    {

      /* if (  (spr[i].brain == 0) | (spr[i].brain == 5) | (spr[i].brain == 6) | (spr[i].brain == 7)) */
      if (locate (spr[i].script, "DIE"))
	run_script (spr[i].script);
      return (1);

    }

  return (0);
}


/**
 * Find and execute DinkC "duckdie()" procedure of a duck whose sprite
 * is #i
 */
/*bool*/int
check_for_duck_script (int i)
{
  if (spr[i].script > 0)
    {
      /* if (  (spr[i].brain == 0) | (spr[i].brain == 5) | (spr[i].brain == 6) | (spr[i].brain == 7)) */
      if (locate (spr[i].script, "DUCKDIE"))
	run_script (spr[i].script);
      return (1);
    }
  return (0);
}
