/**
 * Some system and generic functions

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/util.h,v 1.5 2004/01/16 19:55:45 Beuc Exp $
 */

#ifndef UTIL_H
#define UTIL_H

#include "SDL.h"
#include "SDL_ttf.h"

/* #define bool unsigned char */
#define TRUE true
#define FALSE false

struct rect
{
  long left, top, right, bottom;
};

struct mouse_status_t
{
  /*bool*/int new_event;
  int x, y;
  /*bool*/int button;
};

/* Moved to globals.h */
/* extern struct mouse_status_t mouse_status; */

void init_mouse_status (struct mouse_status_t *ms);
char *ltoa (int l, char *buf, int base);
void strupper (char *s);
void strdown (char *s);
void BltFast (SDL_Surface * dest, int x, int y, SDL_Surface * src,
	      struct rect * bound);
void Blt (SDL_Surface * dest, struct rect * dest_rect, SDL_Surface * src,
	  struct rect * src_rect);
SDL_Surface *load_image (char *file, /*bool*/int key, Uint8 r, Uint8 g, Uint8 b);
Uint32 map_rgb (SDL_Surface * surface, Uint8 r, Uint8 g, Uint8 b);
void InflateRect (struct rect * r, int x, int y);
void CopyRect (struct rect * dest, struct rect * src);
void CopyRect2 (SDL_Rect * dest, struct rect * src);
void CopyRect3 (struct rect * dest, SDL_Rect * src);
void Offset_Right (SDL_Rect * r, int a);
void Offset_Bottom (SDL_Rect * r, int a);
void Offset_Top (SDL_Rect * r, int a);
void Offset_Left (SDL_Rect * r, int a);
int Right (SDL_Rect * r);
int Bottom (SDL_Rect * r);
int Left (SDL_Rect * r);
int Top (SDL_Rect * r);
void OffsetRect (struct rect * rec, int ofsx, int ofsy);
void SetRect (struct rect * rec, int l, int t, int r, int b);
void print_text (TTF_Font * font, char *str, int x, int y, SDL_Color /*&*/ color,
		 /*bool*/int hcenter/*= false*/);
SDL_Color /*&*/ GetTextColor ();
void SetTextColor (Uint8 r, Uint8 g, Uint8 b);
void fill_rect (SDL_Surface * surface, struct rect * box, int color);
void load_palette_from_bmp (char *file, SDL_Color * palette);
void dink_getcwd (char *buf, int len);
int dink_chdir (char *buf);
void setup_palette ();
int init_video ();
int process_text_for_wrapping (TTF_Font * font, char *str, struct rect * box);
int print_text_wrap (TTF_Font * font, char *str, struct rect * box,
		     SDL_Color /*&*/ color, /*bool*/int hcenter/*= false*/, /*bool*/int vcenter/*= false*/);
void process_string (char *s);

/* Helpful debugging macros */
#ifdef WIN32
#include "windebug.h"
#define PRINT print_debug
#else
#define PRINT printf
#endif

#define PRINT_LINE(type) PRINT ("dink:%s:%d: ",__FILE__,  __LINE__)

#define Msg(fmt)				\
do {						\
  PRINT_LINE (debug);				\
  PRINT fmt;					\
  PRINT ("\n");				\
} while (0)

#define TRACE Msg


#endif
