/* Assembly code template for system call stubs.
   Copyright (C) 2009 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/* The real guts of this work are in the macros defined in the
   machine- and kernel-specific sysdep.h header file.  When we
   are defining a cancellable system call, the sysdep-cancel.h
   versions of those macros are what we really use.

   Each system call's object is built by a rule in sysd-syscalls
   generated by make-syscalls.sh that #include's this file after
   defining a few macros:
	SYSCALL_NAME		syscall name
	SYSCALL_NARGS		number of arguments this call takes
	SYSCALL_SYMBOL		primary symbol name
	SYSCALL_CANCELLABLE	1 if the call is a cancelation point
	SYSCALL_NOERRNO		1 to define a no-errno version (see below)
	SYSCALL_ERRVAL		1 to define an error-value version (see below)

   We used to simply pipe the correct three lines below through cpp into
   the assembler.  The main reason to have this file instead is so that
   stub objects can be assembled with -g and get source line information
   that leads a user back to a source file and these fine comments.  The
   average user otherwise has a hard time knowing which "syscall-like"
   functions in libc are plain stubs and which have nontrivial C wrappers.
   Some versions of the "plain" stub generation macros are more than a few
   instructions long and the untrained eye might not distinguish them from
   some compiled code that inexplicably lacks source line information.  */

#if SYSCALL_CANCELLABLE
# include <sysdep-cancel.h>
#else
# include <sysdep.h>
#endif

#define T_PSEUDO(SYMBOL, NAME, N)		PSEUDO (SYMBOL, NAME, N)
#define T_PSEUDO_NOERRNO(SYMBOL, NAME, N)	PSEUDO_NOERRNO (SYMBOL, NAME, N)
#define T_PSEUDO_ERRVAL(SYMBOL, NAME, N)	PSEUDO_ERRVAL (SYMBOL, NAME, N)
#define T_PSEUDO_END(SYMBOL)			PSEUDO_END (SYMBOL)
#define T_PSEUDO_END_NOERRNO(SYMBOL)		PSEUDO_END_NOERRNO (SYMBOL)
#define T_PSEUDO_END_ERRVAL(SYMBOL)		PSEUDO_END_ERRVAL (SYMBOL)

#if SYSCALL_NOERRNO

/* This kind of system call stub never returns an error.
   We return the return value register to the caller unexamined.  */

T_PSEUDO_NOERRNO (SYSCALL_SYMBOL, SYSCALL_NAME, SYSCALL_NARGS)
	ret_NOERRNO
T_PSEUDO_END_NOERRNO (SYSCALL_SYMBOL)

#elif SYSCALL_ERRVAL

/* This kind of system call stub returns the errno code as its return
   value, or zero for success.  We may massage the kernel's return value
   to meet that ABI, but we never set errno here.  */

T_PSEUDO_ERRVAL (SYSCALL_SYMBOL, SYSCALL_NAME, SYSCALL_NARGS)
	ret_ERRVAL
T_PSEUDO_END_ERRVAL (SYSCALL_SYMBOL)

#else

/* This is a "normal" system call stub: if there is an error,
   it returns -1 and sets errno.  */

T_PSEUDO (SYSCALL_SYMBOL, SYSCALL_NAME, SYSCALL_NARGS)
	ret
T_PSEUDO_END (SYSCALL_SYMBOL)

#endif

libc_hidden_def (SYSCALL_SYMBOL)
