/* -*- buffer-read-only: t -*- vi: set ro:
 *
 *  This file is part of gnu-pw-mgr.
 *
 *  Copyright (C) 2013-2018 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 * This file is generated.  gnu-pw-mgr is built with most all symbols
 * having static scope and is compiled all at once.  So all the static
 * functions are declared here and all the C files that are part of it
 * are #included here at the bottom (with two exceptions: the main code
 * gnu-pw-mgr.c and gpw-str.c, which is needed early).
 */

#ifndef GPW_FWD_GUARD
#define GPW_FWD_GUARD 1

////HEADER-FILES:

#include "config.h"

#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <inttypes.h>
#include <pwd.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdnoreturn.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <termios.h>
#include <time.h>
#include <unistd.h>

#include "base64.h"
#include "gc.h"
#include "nonblocking.h"
#include "sha256.h"
#include "timespec.h"
#include "sort-opts.h"

////DEFINES:
#ifndef PVT_static
#define PVT_static static
#endif

#ifdef __GNUC__
# define UNLIKELY(_e) __builtin_expect ((_e), 0)
# define ISLIKELY(_e) __builtin_expect ((_e), 1)
#else
# define UNLIKELY(_e) (_e)
# define ISLIKELY(_e) (_e)
#endif

#define MIN_PW_LEN            	 8
#define MIN_SEED_TEXT_LEN     	64
#define MARK_TEXT_LEN         	24
#define CONFIRM_LEN           	12
#define MAX_CFG_NAME_SIZE     	32
#define MIN_BUF_LEN           	((256 / NBBY) + (256 / (NBBY * 2))) // 48
#define VER_TO_INT(_maj, _min, _rev) \
	(((_maj)<<20) + ((_min)<<10) + (_rev))
#define CCLASS_NO_THREE 	(CCLASS_NO_TRIPLETS | CCLASS_NO_SEQUENCE)
#define SECONDS_IN_DAY  	(60UL * 60UL * 24UL)

#define MAX_REHASH_CT   	100000

#ifndef MAXPATHLEN
# define MAXPATHLEN 4096
#endif

#ifndef   ACCESSPERMS
# define  ACCESSPERMS 0777
#endif // ACCESSPERMS

typedef enum {
    HOME_DIR_IX = 0,
    XDG_DATA_HOME_IX = 1,
    XDG_CONFIG_HOME_IX = 2,
#ifdef __APPLE__
    APPLE_LOCAL_IX = 3,
#endif // __APPLE__
    HOME_IX_CT
} home_ix_t;

typedef struct str_list str_list_t;
struct str_list {
    str_list_t *    next;
    char            buf[0];
};


#endif //  GPW_FWD_GUARD
