/** @file

Copyright (c) 2016, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

#pragma pack(push, 1)


/** Fsp M Configuration
**/
typedef struct {

/** Offset 0x0040 - RmuBaseAddress
  RMU microcode binary base address in SPI flash'
**/
  UINT32                      RmuBaseAddress;

/** Offset 0x0044 - RmuLength
  RMU microcode binary length in bytes
**/
  UINT32                      RmuLength;

/** Offset 0x0048 - SerialPortBaseAddress
  Debug serial port base address set by BIOS. Zero disables debug serial output.
**/
  UINT32                      Reserved_48;

/** Offset 0x004C - tRAS
  ACT to PRE command period in picoseconds.
**/
  UINT32                      tRAS;

/** Offset 0x0050 - tWTR
  Delay from start of internal write transaction to internal read command in picoseconds.
**/
  UINT32                      tWTR;

/** Offset 0x0054 - tRRD
  ACT to ACT command period (JESD79 specific to page size 1K/2K) in picoseconds.
**/
  UINT32                      tRRD;

/** Offset 0x0058 - tFAW
  Four activate window (JESD79 specific to page size 1K/2K) in picoseconds.
**/
  UINT32                      tFAW;

/** Offset 0x005C - Flags
  Bitmap of MRC_FLAG_XXX: ECC_EN            BIT0, SCRAMBLE_EN       BIT1, MEMTEST_EN
  BIT2, TOP_TREE_EN       BIT3  0b DDR "fly-by" topology else 1b DDR "tree"
  topology, WR_ODT_EN         BIT4  If set ODR signal is asserted to DRAM devices
  on writes.
**/
  UINT32                      Flags;

/** Offset 0x0060 - DramWidth
  0=x8, 1=x16, others=RESERVED.
**/
  UINT8                       DramWidth;

/** Offset 0x0061 - DramSpeed
  0=DDRFREQ_800, 1=DDRFREQ_1066, others=RESERVED. Only 533MHz SKU support 1066 memory.
**/
  UINT8                       DramSpeed;

/** Offset 0x0062 - DramType
  0=DDR3, 1=DDR3L, others=RESERVED.
**/
  UINT8                       DramType;

/** Offset 0x0063 - RankMask
  bit[0] RANK0_EN, bit[1] RANK1_EN, others=RESERVED.
**/
  UINT8                       RankMask;

/** Offset 0x0064 - ChanMask
  bit[0] CHAN0_EN, others=RESERVED.
**/
  UINT8                       ChanMask;

/** Offset 0x0065 - ChanWidth
  1=x16, others=RESERVED.
**/
  UINT8                       ChanWidth;

/** Offset 0x0066 - AddrMode
  0, 1, 2 (mode 2 forced if ecc enabled), others=RESERVED.
**/
  UINT8                       AddrMode;

/** Offset 0x0067 - SrInt
  1=1.95us, 2=3.9us, 3=7.8us, others=RESERVED. REFRESH_RATE.
**/
  UINT8                       SrInt;

/** Offset 0x0068 - SrTemp
  0=normal, 1=extended, others=RESERVED.
**/
  UINT8                       SrTemp;

/** Offset 0x0069 - DramRonVal
  0=34ohm, 1=40ohm, others=RESERVED. RON_VALUE Select MRS1.DIC driver impedance control.
**/
  UINT8                       DramRonVal;

/** Offset 0x006A - DramRttNomVal
  0=40ohm, 1=60ohm, 2=120ohm, others=RESERVED.
**/
  UINT8                       DramRttNomVal;

/** Offset 0x006B - DramRttWrVal
  0=off others=RESERVED.
**/
  UINT8                       DramRttWrVal;

/** Offset 0x006C - SocRdOdtVal
  0=off, 1=60ohm, 2=120ohm, 3=180ohm, others=RESERVED.
**/
  UINT8                       SocRdOdtVal;

/** Offset 0x006D - SocWrRonVal
  0=27ohm, 1=32ohm, 2=40ohm, others=RESERVED.
**/
  UINT8                       SocWrRonVal;

/** Offset 0x006E - SocWrSlewRate
  0=2.5V/ns, 1=4V/ns, others=RESERVED.
**/
  UINT8                       SocWrSlewRate;

/** Offset 0x006F - DramDensity
  0=512Mb, 1=1Gb, 2=2Gb, 3=4Gb, others=RESERVED.
**/
  UINT8                       DramDensity;

/** Offset 0x0070 - tCL
  DRAM CAS Latency in clocks
**/
  UINT8                       tCL;

/** Offset 0x0071 - EccScrubInterval
  ECC scrub interval in miliseconds 1..255 (0 works as feature disable
**/
  UINT8                       EccScrubInterval;

/** Offset 0x0072 - EccScrubBlkSize
  Number of 32B blocks read for ECC scrub 2..16
**/
  UINT8                       EccScrubBlkSize;

/** Offset 0x0073 - SmmTsegSize
  Size of the SMM region in 1 MiB chunks
**/
  UINT8                       SmmTsegSize;

/** Offset 0x0074 - FspReservedMemoryLength
  FSP reserved memory length in bytes
**/
  UINT32                      FspReservedMemoryLength;

/** Offset 0x0078 - MrcDataPtr
  Pointer to saved MRC data
**/
  UINT32                      MrcDataPtr;

/** Offset 0x007C - MrcDataLength
  Length of saved MRC data
**/
  UINT32                      MrcDataLength;

/** Offset 0x0080
**/
  UINT32                      SerialPortPollForChar;

/** Offset 0x0084
**/
  UINT32                      SerialPortReadChar;

/** Offset 0x0088
**/
  UINT32                      SerialPortWriteChar;

/** Offset 0x008C
**/
  UINT16                      UpdTerminator;
} FSP_M_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSP_M_CONFIG                FspmConfig;
} FSPM_UPD;

#pragma pack(pop)

#endif
