/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.allsolutions;

import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.term.TermUtils;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.buildins.allsolutions.Predicate_findall;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicate_bagof
extends ExecuteOnlyCode {
    static final CompoundTermTag plusTag = CompoundTermTag.get("+", 2);

    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (backtrackMode) {
            BagOfBacktrackInfo bi = (BagOfBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return this.nextSolution(interpreter, bi);
        }
        Term ptemplate = args[0];
        Term pgoal = args[1];
        Term pinstances = args[2];
        Predicate_findall.checkList(pinstances);
        HashSet<Term> wset = new HashSet<Term>();
        Term findallGoal = TermUtils.getFreeVariableSet(pgoal, ptemplate, wset);
        Term witness = TermUtils.getWitness(wset);
        CompoundTerm findallTemplate = new CompoundTerm(plusTag, witness, ptemplate);
        ArrayList<Term> list = new ArrayList<Term>();
        int rc = Predicate_findall.findall(interpreter, false, findallTemplate, findallGoal, list);
        if (rc == -1 || list.size() == 0) {
            return -1;
        }
        BagOfBacktrackInfo bi = new BagOfBacktrackInfo();
        bi.startUndoPosition = interpreter.getUndoPosition();
        bi.solutionList = list;
        bi.witness = witness;
        bi.instances = pinstances;
        return this.nextSolution(interpreter, bi);
    }

    public int nextSolution(Interpreter interpreter, BagOfBacktrackInfo bi) throws PrologException {
        ArrayList<Term> curTList = new ArrayList<Term>();
        int undoPos = interpreter.getUndoPosition();
        while (bi.solutionList.size() != 0) {
            CompoundTerm curInstance = (CompoundTerm)bi.solutionList.remove(0).dereference();
            Term curWitness = curInstance.args[0].dereference();
            int rc = interpreter.simpleUnify(bi.witness, curWitness);
            if (rc == -1) {
                throw new IllegalStateException("unexpected unify fail");
            }
            curTList.add(curInstance.args[1].dereference());
            ListIterator<Term> isol = bi.solutionList.listIterator();
            while (isol.hasNext()) {
                CompoundTerm ct = (CompoundTerm)isol.next();
                Term w = ct.args[0].dereference();
                if (!TermUtils.isVariant(curWitness, w)) continue;
                rc = interpreter.simpleUnify(bi.witness, w);
                if (rc == -1) {
                    throw new IllegalStateException("unexpected unify fail");
                }
                curTList.add(ct.args[1].dereference());
                isol.remove();
            }
            this.processList(curTList);
            rc = interpreter.unify(CompoundTerm.getList(curTList), bi.instances.dereference());
            if (rc == 1) {
                if (bi.solutionList.size() != 0) {
                    interpreter.pushBacktrackInfo(bi);
                    return 0;
                }
                return 1;
            }
            interpreter.undo(undoPos);
            curTList.clear();
        }
        return -1;
    }

    protected void processList(List<Term> curTList) {
    }

    private static class BagOfBacktrackInfo
    extends BacktrackInfo {
        int startUndoPosition;
        List<Term> solutionList;
        Term witness;
        Term instances;

        BagOfBacktrackInfo() {
            super(-1, -1);
        }
    }
}

