/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.termcomparsion;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.TermComparator;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;

public class Predicate_compare
extends ExecuteOnlyCode {
    public static final AtomTerm EQ_ATOM = AtomTerm.get("=");
    public static final AtomTerm LT_ATOM = AtomTerm.get("<");
    public static final AtomTerm GT_ATOM = AtomTerm.get(">");
    protected TermComparator comp = new TermComparator();

    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        int rc;
        Term order = args[0];
        if (!(order instanceof VariableTerm)) {
            if (!(order instanceof AtomTerm)) {
                PrologException.typeError(TermConstants.atomAtom, order);
            } else if (order != EQ_ATOM & order != LT_ATOM & order != GT_ATOM) {
                PrologException.domainError(TermConstants.orderAtom, order);
            }
        }
        if ((rc = this.comp.compare(args[1], args[2])) == 0) {
            return interpreter.unify(EQ_ATOM, order);
        }
        if (rc > 0) {
            return interpreter.unify(GT_ATOM, order);
        }
        if (rc < 0) {
            return interpreter.unify(LT_ATOM, order);
        }
        return -1;
    }
}

