/*******************************************************************************
 *
 *  Copyright (c) 1991-2012 David R. Hill, Leonard Manzara, Craig Schock
 *  
 *  Contributors: 
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *******************************************************************************
 *
 *  number_pronuncuations_english.h
 *  GnuSpeech
 *
 *  Version: 0.9.1
 *
 ******************************************************************************/


/*  number_pronunciations_english.h CONTAINS PRONUNCIATIONS FOR
    number_parser() AND degenerate_string() in non-phonetic form  */

/*  CARDINAL NUMBER NAMES  */
#define OH                     "oh "
#define ZERO                   "zero "
#define ONE                    "one "
#define TWO                    "two "
#define THREE                  "three "
#define FOUR                   "four "
#define FIVE                   "five "
#define SIX                    "six "
#define SEVEN                  "seven "
#define EIGHT                  "eight "
#define NINE                   "nine "
#define TEN                    "ten "
#define ELEVEN                 "eleven "
#define TWELVE                 "twelve "
#define THIRTEEN               "thirteen "
#define FOURTEEN               "fourteen "
#define FIFTEEN                "fifteen "
#define SIXTEEN                "sixteen "
#define SEVENTEEN              "seventeen "
#define EIGHTEEN               "eighteen "
#define NINETEEN               "nineteen "
#define TWENTY                 "twenty "
#define THIRTY                 "thirty "
#define FORTY                  "forty "
#define FIFTY                  "fifty "
#define SIXTY                  "sixty "
#define SEVENTY                "seventy "
#define EIGHTY                 "eighty "
#define NINETY                 "ninety "

#define TRIADS_MAX             22
/*  THERE MUST BE THIS MANY TRIAD NAMES BELOW  */
#define HUNDRED                "hundred "
#define THOUSAND               "thousand "
#define MILLION                "million "
#define BILLION                "billion "
#define TRILLION               "trillion "
#define QUADRILLION            "quadrillion "
#define QUINTILLION            "quintillion "
#define SEXTILLION             "sextillion "
#define SEPTILLION             "septillion "
#define OCTILLION              "octillion "
#define NONILLION              "nonillion "
#define DECILLION              "decillion "
#define UNDECILLION            "undecillion "
#define DUODECILLION           "duodecillion "
#define TREDECILLION           "tredecillion "
#define QUATTUORDECILLION      "quattuordecillion "
#define QUINDECILLION          "quindecillion "
#define SEXDECILLION           "sexdecillion "
#define SEPTENDECILLION        "septendecillion "
#define OCTODECILLION          "octodecillion "
#define NOVEMDECILLION         "novemdecillion "
#define VIGINTILLION           "vigintillion "


/*  ORDINAL NUMBER NAMES  */
#define ZEROETH                "zeroeth "
#define FIRST                  "first "
#define SECOND                 "second "
#define THIRD                  "third "
#define FOURTH                 "fourth "
#define FIFTH                  "fifth "
#define SIXTH                  "sixth "
#define SEVENTH                "seventh "
#define EIGHTH                 "eighth "
#define NINTH                  "ninth "
#define TENTH                  "tenth "
#define ELEVENTH               "eleventh "
#define TWELFTH                "twelfth "
#define THIRTEENTH             "thirteenth "
#define FOURTEENTH             "fourteenth "
#define FIFTEENTH              "fifteenth "
#define SIXTEENTH              "sixteenth "
#define SEVENTEENTH            "seventeenth "
#define EIGHTEENTH             "eighteenth "
#define NINETEENTH             "nineteenth "
#define TWENTIETH              "twentieth "
#define THIRTIETH              "thirtieth "
#define FORTIETH               "fortieth "
#define FIFTIETH               "fiftieth "
#define SIXTIETH               "sixtieth "
#define SEVENTIETH             "seventieth "
#define EIGHTIETH              "eightieth "
#define NINETIETH              "ninetieth "

/* THESE MUST MATCH THE TRIAD NAMES ABOVE */
#define HUNDREDTH              "hundredth "  
#define THOUSANDTH             "thousandth "
#define MILLIONTH              "millionth "
#define BILLIONTH              "billionth "
#define TRILLIONTH             "trillionth "
#define QUADRILLIONTH          "quadrillionth "
#define QUINTILLIONTH          "quintillionth "
#define SEXTILLIONTH           "sextillionth "
#define SEPTILLIONTH           "septillionth "
#define OCTILLIONTH            "octillionth "
#define NONILLIONTH            "nonillionth "
#define DECILLIONTH            "decillionth "
#define UNDECILLIONTH          "undecillionth "
#define DUODECILLIONTH         "duodecillionth "
#define TREDECILLIONTH         "tredecillionth "
#define QUATTUORDECILLIONTH    "quattuordecillionth "
#define QUINDECILLIONTH        "quindecillionth "
#define SEXDECILLIONTH         "sexdecillionth "
#define SEPTENDECILLIONTH      "septendecillionth "
#define OCTODECILLIONTH        "octodecillionth "
#define NOVEMDECILLIONTH       "novemdecillionth "
#define VIGINTILLIONTH         "vigintillionth "

/*  PLURAL ORDINAL NUMBER NAMES FOR FRACTIONS  */
#define HALF                   "half "
#define HALVES                 "halves "
#define SECONDTH               "secondth "
#define SECONDTHS              "secondths "
#define THIRDS                 "thirds "
#define QUARTER                "quarter "
#define QUARTERS               "quarters "
#define FOURTHS                "fourths "
#define FIFTHS                 "fifths "
#define SIXTHS                 "sixths "
#define SEVENTHS               "sevenths "
#define EIGHTHS                "eighths "
#define NINTHS                 "ninths "
#define TENTHS                 "tenths "
#define ELEVENTHS              "elevenths "
#define TWELFTHS               "twelfths "
#define THIRTEENTHS            "thirteenths "
#define FOURTEENTHS            "fourteenths "
#define FIFTEENTHS             "fifteenths "
#define SIXTEENTHS             "sixteenths "
#define SEVENTEENTHS           "seventeenths "
#define EIGHTEENTHS            "eighteenths "
#define NINETEENTHS            "nineteenths "
#define TWENTIETHS             "twentieths "
#define THIRTIETHS             "thirtieths "
#define FORTIETHS              "fortieths "
#define FIFTIETHS              "fiftieths "
#define SIXTIETHS              "sixtieths "
#define SEVENTIETHS            "seventieths "
#define EIGHTIETHS             "eightieths "
#define NINETIETHS             "ninetieths "

/* THESE MUST MATCH THE TRIAD NAMES ABOVE */
#define HUNDREDTHS             "hundredths "  
#define THOUSANDTHS            "thousandths "
#define MILLIONTHS             "millionths "
#define BILLIONTHS             "billionths "
#define TRILLIONTHS            "trillionths "
#define QUADRILLIONTHS         "quadrillionths "
#define QUINTILLIONTHS         "quintillionths "
#define SEXTILLIONTHS          "sextillionths "
#define SEPTILLIONTHS          "septillionths "
#define OCTILLIONTHS           "octillionths "
#define NONILLIONTHS           "nonillionths "
#define DECILLIONTHS           "decillionths "
#define UNDECILLIONTHS         "undecillionths "
#define DUODECILLIONTHS        "duodecillionths "
#define TREDECILLIONTHS        "tredecillionths "
#define QUATTUORDECILLIONTHS   "quattuordecillionths "
#define QUINDECILLIONTHS       "quindecillionths "
#define SEXDECILLIONTHS        "sexdecillionths "
#define SEPTENDECILLIONTHS     "septendecillionths "
#define OCTODECILLIONTHS       "octodecillionths "
#define NOVEMDECILLIONTHS      "novemdecillionths "
#define VIGINTILLIONTHS        "vigintillionths "


/*  MISCELLANEOUS SYMBOL NAMES  */
#define AND                    "and "
#define DOLLAR                 "dollar "
#define DOLLARS                "dollars "
#define NEGATIVE               "negative "
#define POSITIVE               "positive "
#define POINT                  "point "
#define CENT                   "cent "
#define CENTS                  "cents "
#define PERCENT                "percent "
#define OVER                   "over "
#define AREA                   "area "
#define CODE                   "code "
#define PAUSE                  "pause "
#define SECONDS                "seconds "
#define OCLOCK                 "oclock "
#define NULL_STRING            ""

#define BLANK                  "blank "
#define EXCLAMATION_POINT      "exclamation point "
#define DOUBLE_QUOTE           "double quote "
#define NUMBER_SIGN            "number sign "
#define DOLLAR_SIGN            "dollar sign "
#define PERCENT_SIGN           "percent sign "
#define AMPERSAND              "ampersand "
#define SINGLE_QUOTE           "single quote "
#define OPEN_PARENTHESIS       "open parenthesis "
#define CLOSE_PARENTHESIS      "close parenthesis "
#define ASTERISK               "asterisk "
#define PLUS_SIGN              "plus sign "
#define COMMA                  "comma "
#define HYPHEN                 "hyphen "
#define PERIOD                 "period "
#define SLASH                  "slash "
#define COLON                  "colon "
#define SEMICOLON              "semicolon "
#define OPEN_ANGLE_BRACKET     "open angle bracket "
#define EQUAL_SIGN             "equal sign "
#define CLOSE_ANGLE_BRACKET    "close angle bracket "
#define QUESTION_MARK          "question mark "
#define AT_SIGN                "at sign "
#define A                      "A "
#define B                      "B "
#define C                      "C "
#define D                      "D "
#define E                      "E "
#define F                      "F "
#define G                      "G "
#define H                      "H "
#define I                      "I "
#define J                      "J "
#define K                      "K "
#define L                      "L "
#define M                      "M "
#define N                      "N "
#define O                      "O "
#define P                      "P "
#define Q                      "Q "
#define R                      "R "
#define S                      "S "
#define T                      "T "
#define U                      "U "
#define V                      "V "
#define W                      "W "
#define X                      "X "
#define Y                      "Y "
#define Z                      "Z "
#define OPEN_SQUARE_BRACKET    "open square bracket "
#define BACKSLASH              "back slash "
#define CLOSE_SQUARE_BRACKET   "close square bracket "
#define CARET                  "caret "
#define UNDERSCORE             "underscore "
#define GRAVE_ACCENT           "grave accent "
#define OPEN_BRACE             "open brace "
#define VERTICAL_BAR           "vertical bar "
#define CLOSE_BRACE            "close brace "
#define TILDE                  "tilde "
#define UNKNOWN                "unknown "
