// Copyright 2012-2015 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "scripts/unicode.py", do not edit directly

#![allow(missing_docs, non_upper_case_globals, non_snake_case)]

    // official Unicode test data
    // http://www.unicode.org/Public/UNIDATA/NormalizationTest.txt
    pub const TEST_NORM: &'static [(&'static str, &'static str, &'static str, &'static str, &'static str)] = &[
        ("\u{1e0a}", "\u{1e0a}", "\u{44}\u{307}", "\u{1e0a}", "\u{44}\u{307}"), ("\u{1e0c}",
        "\u{1e0c}", "\u{44}\u{323}", "\u{1e0c}", "\u{44}\u{323}"), ("\u{1e0a}\u{323}",
        "\u{1e0c}\u{307}", "\u{44}\u{323}\u{307}", "\u{1e0c}\u{307}", "\u{44}\u{323}\u{307}"),
        ("\u{1e0c}\u{307}", "\u{1e0c}\u{307}", "\u{44}\u{323}\u{307}", "\u{1e0c}\u{307}",
        "\u{44}\u{323}\u{307}"), ("\u{44}\u{307}\u{323}", "\u{1e0c}\u{307}", "\u{44}\u{323}\u{307}",
        "\u{1e0c}\u{307}", "\u{44}\u{323}\u{307}"), ("\u{44}\u{323}\u{307}", "\u{1e0c}\u{307}",
        "\u{44}\u{323}\u{307}", "\u{1e0c}\u{307}", "\u{44}\u{323}\u{307}"), ("\u{1e0a}\u{31b}",
        "\u{1e0a}\u{31b}", "\u{44}\u{31b}\u{307}", "\u{1e0a}\u{31b}", "\u{44}\u{31b}\u{307}"),
        ("\u{1e0c}\u{31b}", "\u{1e0c}\u{31b}", "\u{44}\u{31b}\u{323}", "\u{1e0c}\u{31b}",
        "\u{44}\u{31b}\u{323}"), ("\u{1e0a}\u{31b}\u{323}", "\u{1e0c}\u{31b}\u{307}",
        "\u{44}\u{31b}\u{323}\u{307}", "\u{1e0c}\u{31b}\u{307}", "\u{44}\u{31b}\u{323}\u{307}"),
        ("\u{1e0c}\u{31b}\u{307}", "\u{1e0c}\u{31b}\u{307}", "\u{44}\u{31b}\u{323}\u{307}",
        "\u{1e0c}\u{31b}\u{307}", "\u{44}\u{31b}\u{323}\u{307}"), ("\u{44}\u{31b}\u{307}\u{323}",
        "\u{1e0c}\u{31b}\u{307}", "\u{44}\u{31b}\u{323}\u{307}", "\u{1e0c}\u{31b}\u{307}",
        "\u{44}\u{31b}\u{323}\u{307}"), ("\u{44}\u{31b}\u{323}\u{307}", "\u{1e0c}\u{31b}\u{307}",
        "\u{44}\u{31b}\u{323}\u{307}", "\u{1e0c}\u{31b}\u{307}", "\u{44}\u{31b}\u{323}\u{307}"),
        ("\u{c8}", "\u{c8}", "\u{45}\u{300}", "\u{c8}", "\u{45}\u{300}"), ("\u{112}", "\u{112}",
        "\u{45}\u{304}", "\u{112}", "\u{45}\u{304}"), ("\u{45}\u{300}", "\u{c8}", "\u{45}\u{300}",
        "\u{c8}", "\u{45}\u{300}"), ("\u{45}\u{304}", "\u{112}", "\u{45}\u{304}", "\u{112}",
        "\u{45}\u{304}"), ("\u{1e14}", "\u{1e14}", "\u{45}\u{304}\u{300}", "\u{1e14}",
        "\u{45}\u{304}\u{300}"), ("\u{112}\u{300}", "\u{1e14}", "\u{45}\u{304}\u{300}", "\u{1e14}",
        "\u{45}\u{304}\u{300}"), ("\u{1e14}\u{304}", "\u{1e14}\u{304}",
        "\u{45}\u{304}\u{300}\u{304}", "\u{1e14}\u{304}", "\u{45}\u{304}\u{300}\u{304}"),
        ("\u{45}\u{304}\u{300}", "\u{1e14}", "\u{45}\u{304}\u{300}", "\u{1e14}",
        "\u{45}\u{304}\u{300}"), ("\u{45}\u{300}\u{304}", "\u{c8}\u{304}", "\u{45}\u{300}\u{304}",
        "\u{c8}\u{304}", "\u{45}\u{300}\u{304}"),
        ("\u{5b8}\u{5b9}\u{5b1}\u{591}\u{5c3}\u{5b0}\u{5ac}\u{59f}",
        "\u{5b1}\u{5b8}\u{5b9}\u{591}\u{5c3}\u{5b0}\u{5ac}\u{59f}",
        "\u{5b1}\u{5b8}\u{5b9}\u{591}\u{5c3}\u{5b0}\u{5ac}\u{59f}",
        "\u{5b1}\u{5b8}\u{5b9}\u{591}\u{5c3}\u{5b0}\u{5ac}\u{59f}",
        "\u{5b1}\u{5b8}\u{5b9}\u{591}\u{5c3}\u{5b0}\u{5ac}\u{59f}"),
        ("\u{592}\u{5b7}\u{5bc}\u{5a5}\u{5b0}\u{5c0}\u{5c4}\u{5ad}",
        "\u{5b0}\u{5b7}\u{5bc}\u{5a5}\u{592}\u{5c0}\u{5ad}\u{5c4}",
        "\u{5b0}\u{5b7}\u{5bc}\u{5a5}\u{592}\u{5c0}\u{5ad}\u{5c4}",
        "\u{5b0}\u{5b7}\u{5bc}\u{5a5}\u{592}\u{5c0}\u{5ad}\u{5c4}",
        "\u{5b0}\u{5b7}\u{5bc}\u{5a5}\u{592}\u{5c0}\u{5ad}\u{5c4}"), ("\u{a0}", "\u{a0}", "\u{a0}",
        "\u{20}", "\u{20}"), ("\u{a8}", "\u{a8}", "\u{a8}", "\u{20}\u{308}", "\u{20}\u{308}"),
        ("\u{aa}", "\u{aa}", "\u{aa}", "\u{61}", "\u{61}"), ("\u{af}", "\u{af}", "\u{af}",
        "\u{20}\u{304}", "\u{20}\u{304}"), ("\u{b2}", "\u{b2}", "\u{b2}", "\u{32}", "\u{32}"),
        ("\u{b3}", "\u{b3}", "\u{b3}", "\u{33}", "\u{33}"), ("\u{b4}", "\u{b4}", "\u{b4}",
        "\u{20}\u{301}", "\u{20}\u{301}"), ("\u{b5}", "\u{b5}", "\u{b5}", "\u{3bc}", "\u{3bc}"),
        ("\u{b8}", "\u{b8}", "\u{b8}", "\u{20}\u{327}", "\u{20}\u{327}"), ("\u{b9}", "\u{b9}",
        "\u{b9}", "\u{31}", "\u{31}"), ("\u{ba}", "\u{ba}", "\u{ba}", "\u{6f}", "\u{6f}"),
        ("\u{bc}", "\u{bc}", "\u{bc}", "\u{31}\u{2044}\u{34}", "\u{31}\u{2044}\u{34}"), ("\u{bd}",
        "\u{bd}", "\u{bd}", "\u{31}\u{2044}\u{32}", "\u{31}\u{2044}\u{32}"), ("\u{be}", "\u{be}",
        "\u{be}", "\u{33}\u{2044}\u{34}", "\u{33}\u{2044}\u{34}"), ("\u{c0}", "\u{c0}",
        "\u{41}\u{300}", "\u{c0}", "\u{41}\u{300}"), ("\u{c1}", "\u{c1}", "\u{41}\u{301}", "\u{c1}",
        "\u{41}\u{301}"), ("\u{c2}", "\u{c2}", "\u{41}\u{302}", "\u{c2}", "\u{41}\u{302}"),
        ("\u{c3}", "\u{c3}", "\u{41}\u{303}", "\u{c3}", "\u{41}\u{303}"), ("\u{c4}", "\u{c4}",
        "\u{41}\u{308}", "\u{c4}", "\u{41}\u{308}"), ("\u{c5}", "\u{c5}", "\u{41}\u{30a}", "\u{c5}",
        "\u{41}\u{30a}"), ("\u{c7}", "\u{c7}", "\u{43}\u{327}", "\u{c7}", "\u{43}\u{327}"),
        ("\u{c8}", "\u{c8}", "\u{45}\u{300}", "\u{c8}", "\u{45}\u{300}"), ("\u{c9}", "\u{c9}",
        "\u{45}\u{301}", "\u{c9}", "\u{45}\u{301}"), ("\u{ca}", "\u{ca}", "\u{45}\u{302}", "\u{ca}",
        "\u{45}\u{302}"), ("\u{cb}", "\u{cb}", "\u{45}\u{308}", "\u{cb}", "\u{45}\u{308}"),
        ("\u{cc}", "\u{cc}", "\u{49}\u{300}", "\u{cc}", "\u{49}\u{300}"), ("\u{cd}", "\u{cd}",
        "\u{49}\u{301}", "\u{cd}", "\u{49}\u{301}"), ("\u{ce}", "\u{ce}", "\u{49}\u{302}", "\u{ce}",
        "\u{49}\u{302}"), ("\u{cf}", "\u{cf}", "\u{49}\u{308}", "\u{cf}", "\u{49}\u{308}"),
        ("\u{d1}", "\u{d1}", "\u{4e}\u{303}", "\u{d1}", "\u{4e}\u{303}"), ("\u{d2}", "\u{d2}",
        "\u{4f}\u{300}", "\u{d2}", "\u{4f}\u{300}"), ("\u{d3}", "\u{d3}", "\u{4f}\u{301}", "\u{d3}",
        "\u{4f}\u{301}"), ("\u{d4}", "\u{d4}", "\u{4f}\u{302}", "\u{d4}", "\u{4f}\u{302}"),
        ("\u{d5}", "\u{d5}", "\u{4f}\u{303}", "\u{d5}", "\u{4f}\u{303}"), ("\u{d6}", "\u{d6}",
        "\u{4f}\u{308}", "\u{d6}", "\u{4f}\u{308}"), ("\u{d9}", "\u{d9}", "\u{55}\u{300}", "\u{d9}",
        "\u{55}\u{300}"), ("\u{da}", "\u{da}", "\u{55}\u{301}", "\u{da}", "\u{55}\u{301}"),
        ("\u{db}", "\u{db}", "\u{55}\u{302}", "\u{db}", "\u{55}\u{302}"), ("\u{dc}", "\u{dc}",
        "\u{55}\u{308}", "\u{dc}", "\u{55}\u{308}"), ("\u{dd}", "\u{dd}", "\u{59}\u{301}", "\u{dd}",
        "\u{59}\u{301}"), ("\u{e0}", "\u{e0}", "\u{61}\u{300}", "\u{e0}", "\u{61}\u{300}"),
        ("\u{e1}", "\u{e1}", "\u{61}\u{301}", "\u{e1}", "\u{61}\u{301}"), ("\u{e2}", "\u{e2}",
        "\u{61}\u{302}", "\u{e2}", "\u{61}\u{302}"), ("\u{e3}", "\u{e3}", "\u{61}\u{303}", "\u{e3}",
        "\u{61}\u{303}"), ("\u{e4}", "\u{e4}", "\u{61}\u{308}", "\u{e4}", "\u{61}\u{308}"),
        ("\u{e5}", "\u{e5}", "\u{61}\u{30a}", "\u{e5}", "\u{61}\u{30a}"), ("\u{e7}", "\u{e7}",
        "\u{63}\u{327}", "\u{e7}", "\u{63}\u{327}"), ("\u{e8}", "\u{e8}", "\u{65}\u{300}", "\u{e8}",
        "\u{65}\u{300}"), ("\u{e9}", "\u{e9}", "\u{65}\u{301}", "\u{e9}", "\u{65}\u{301}"),
        ("\u{ea}", "\u{ea}", "\u{65}\u{302}", "\u{ea}", "\u{65}\u{302}"), ("\u{eb}", "\u{eb}",
        "\u{65}\u{308}", "\u{eb}", "\u{65}\u{308}"), ("\u{ec}", "\u{ec}", "\u{69}\u{300}", "\u{ec}",
        "\u{69}\u{300}"), ("\u{ed}", "\u{ed}", "\u{69}\u{301}", "\u{ed}", "\u{69}\u{301}"),
        ("\u{ee}", "\u{ee}", "\u{69}\u{302}", "\u{ee}", "\u{69}\u{302}"), ("\u{ef}", "\u{ef}",
        "\u{69}\u{308}", "\u{ef}", "\u{69}\u{308}"), ("\u{f1}", "\u{f1}", "\u{6e}\u{303}", "\u{f1}",
        "\u{6e}\u{303}"), ("\u{f2}", "\u{f2}", "\u{6f}\u{300}", "\u{f2}", "\u{6f}\u{300}"),
        ("\u{f3}", "\u{f3}", "\u{6f}\u{301}", "\u{f3}", "\u{6f}\u{301}"), ("\u{f4}", "\u{f4}",
        "\u{6f}\u{302}", "\u{f4}", "\u{6f}\u{302}"), ("\u{f5}", "\u{f5}", "\u{6f}\u{303}", "\u{f5}",
        "\u{6f}\u{303}"), ("\u{f6}", "\u{f6}", "\u{6f}\u{308}", "\u{f6}", "\u{6f}\u{308}"),
        ("\u{f9}", "\u{f9}", "\u{75}\u{300}", "\u{f9}", "\u{75}\u{300}"), ("\u{fa}", "\u{fa}",
        "\u{75}\u{301}", "\u{fa}", "\u{75}\u{301}"), ("\u{fb}", "\u{fb}", "\u{75}\u{302}", "\u{fb}",
        "\u{75}\u{302}"), ("\u{fc}", "\u{fc}", "\u{75}\u{308}", "\u{fc}", "\u{75}\u{308}"),
        ("\u{fd}", "\u{fd}", "\u{79}\u{301}", "\u{fd}", "\u{79}\u{301}"), ("\u{ff}", "\u{ff}",
        "\u{79}\u{308}", "\u{ff}", "\u{79}\u{308}"), ("\u{100}", "\u{100}", "\u{41}\u{304}",
        "\u{100}", "\u{41}\u{304}"), ("\u{101}", "\u{101}", "\u{61}\u{304}", "\u{101}",
        "\u{61}\u{304}"), ("\u{102}", "\u{102}", "\u{41}\u{306}", "\u{102}", "\u{41}\u{306}"),
        ("\u{103}", "\u{103}", "\u{61}\u{306}", "\u{103}", "\u{61}\u{306}"), ("\u{104}", "\u{104}",
        "\u{41}\u{328}", "\u{104}", "\u{41}\u{328}"), ("\u{105}", "\u{105}", "\u{61}\u{328}",
        "\u{105}", "\u{61}\u{328}"), ("\u{106}", "\u{106}", "\u{43}\u{301}", "\u{106}",
        "\u{43}\u{301}"), ("\u{107}", "\u{107}", "\u{63}\u{301}", "\u{107}", "\u{63}\u{301}"),
        ("\u{108}", "\u{108}", "\u{43}\u{302}", "\u{108}", "\u{43}\u{302}"), ("\u{109}", "\u{109}",
        "\u{63}\u{302}", "\u{109}", "\u{63}\u{302}"), ("\u{10a}", "\u{10a}", "\u{43}\u{307}",
        "\u{10a}", "\u{43}\u{307}"), ("\u{10b}", "\u{10b}", "\u{63}\u{307}", "\u{10b}",
        "\u{63}\u{307}"), ("\u{10c}", "\u{10c}", "\u{43}\u{30c}", "\u{10c}", "\u{43}\u{30c}"),
        ("\u{10d}", "\u{10d}", "\u{63}\u{30c}", "\u{10d}", "\u{63}\u{30c}"), ("\u{10e}", "\u{10e}",
        "\u{44}\u{30c}", "\u{10e}", "\u{44}\u{30c}"), ("\u{10f}", "\u{10f}", "\u{64}\u{30c}",
        "\u{10f}", "\u{64}\u{30c}"), ("\u{112}", "\u{112}", "\u{45}\u{304}", "\u{112}",
        "\u{45}\u{304}"), ("\u{113}", "\u{113}", "\u{65}\u{304}", "\u{113}", "\u{65}\u{304}"),
        ("\u{114}", "\u{114}", "\u{45}\u{306}", "\u{114}", "\u{45}\u{306}"), ("\u{115}", "\u{115}",
        "\u{65}\u{306}", "\u{115}", "\u{65}\u{306}"), ("\u{116}", "\u{116}", "\u{45}\u{307}",
        "\u{116}", "\u{45}\u{307}"), ("\u{117}", "\u{117}", "\u{65}\u{307}", "\u{117}",
        "\u{65}\u{307}"), ("\u{118}", "\u{118}", "\u{45}\u{328}", "\u{118}", "\u{45}\u{328}"),
        ("\u{119}", "\u{119}", "\u{65}\u{328}", "\u{119}", "\u{65}\u{328}"), ("\u{11a}", "\u{11a}",
        "\u{45}\u{30c}", "\u{11a}", "\u{45}\u{30c}"), ("\u{11b}", "\u{11b}", "\u{65}\u{30c}",
        "\u{11b}", "\u{65}\u{30c}"), ("\u{11c}", "\u{11c}", "\u{47}\u{302}", "\u{11c}",
        "\u{47}\u{302}"), ("\u{11d}", "\u{11d}", "\u{67}\u{302}", "\u{11d}", "\u{67}\u{302}"),
        ("\u{11e}", "\u{11e}", "\u{47}\u{306}", "\u{11e}", "\u{47}\u{306}"), ("\u{11f}", "\u{11f}",
        "\u{67}\u{306}", "\u{11f}", "\u{67}\u{306}"), ("\u{120}", "\u{120}", "\u{47}\u{307}",
        "\u{120}", "\u{47}\u{307}"), ("\u{121}", "\u{121}", "\u{67}\u{307}", "\u{121}",
        "\u{67}\u{307}"), ("\u{122}", "\u{122}", "\u{47}\u{327}", "\u{122}", "\u{47}\u{327}"),
        ("\u{123}", "\u{123}", "\u{67}\u{327}", "\u{123}", "\u{67}\u{327}"), ("\u{124}", "\u{124}",
        "\u{48}\u{302}", "\u{124}", "\u{48}\u{302}"), ("\u{125}", "\u{125}", "\u{68}\u{302}",
        "\u{125}", "\u{68}\u{302}"), ("\u{128}", "\u{128}", "\u{49}\u{303}", "\u{128}",
        "\u{49}\u{303}"), ("\u{129}", "\u{129}", "\u{69}\u{303}", "\u{129}", "\u{69}\u{303}"),
        ("\u{12a}", "\u{12a}", "\u{49}\u{304}", "\u{12a}", "\u{49}\u{304}"), ("\u{12b}", "\u{12b}",
        "\u{69}\u{304}", "\u{12b}", "\u{69}\u{304}"), ("\u{12c}", "\u{12c}", "\u{49}\u{306}",
        "\u{12c}", "\u{49}\u{306}"), ("\u{12d}", "\u{12d}", "\u{69}\u{306}", "\u{12d}",
        "\u{69}\u{306}"), ("\u{12e}", "\u{12e}", "\u{49}\u{328}", "\u{12e}", "\u{49}\u{328}"),
        ("\u{12f}", "\u{12f}", "\u{69}\u{328}", "\u{12f}", "\u{69}\u{328}"), ("\u{130}", "\u{130}",
        "\u{49}\u{307}", "\u{130}", "\u{49}\u{307}"), ("\u{132}", "\u{132}", "\u{132}",
        "\u{49}\u{4a}", "\u{49}\u{4a}"), ("\u{133}", "\u{133}", "\u{133}", "\u{69}\u{6a}",
        "\u{69}\u{6a}"), ("\u{134}", "\u{134}", "\u{4a}\u{302}", "\u{134}", "\u{4a}\u{302}"),
        ("\u{135}", "\u{135}", "\u{6a}\u{302}", "\u{135}", "\u{6a}\u{302}"), ("\u{136}", "\u{136}",
        "\u{4b}\u{327}", "\u{136}", "\u{4b}\u{327}"), ("\u{137}", "\u{137}", "\u{6b}\u{327}",
        "\u{137}", "\u{6b}\u{327}"), ("\u{139}", "\u{139}", "\u{4c}\u{301}", "\u{139}",
        "\u{4c}\u{301}"), ("\u{13a}", "\u{13a}", "\u{6c}\u{301}", "\u{13a}", "\u{6c}\u{301}"),
        ("\u{13b}", "\u{13b}", "\u{4c}\u{327}", "\u{13b}", "\u{4c}\u{327}"), ("\u{13c}", "\u{13c}",
        "\u{6c}\u{327}", "\u{13c}", "\u{6c}\u{327}"), ("\u{13d}", "\u{13d}", "\u{4c}\u{30c}",
        "\u{13d}", "\u{4c}\u{30c}"), ("\u{13e}", "\u{13e}", "\u{6c}\u{30c}", "\u{13e}",
        "\u{6c}\u{30c}"), ("\u{13f}", "\u{13f}", "\u{13f}", "\u{4c}\u{b7}", "\u{4c}\u{b7}"),
        ("\u{140}", "\u{140}", "\u{140}", "\u{6c}\u{b7}", "\u{6c}\u{b7}"), ("\u{143}", "\u{143}",
        "\u{4e}\u{301}", "\u{143}", "\u{4e}\u{301}"), ("\u{144}", "\u{144}", "\u{6e}\u{301}",
        "\u{144}", "\u{6e}\u{301}"), ("\u{145}", "\u{145}", "\u{4e}\u{327}", "\u{145}",
        "\u{4e}\u{327}"), ("\u{146}", "\u{146}", "\u{6e}\u{327}", "\u{146}", "\u{6e}\u{327}"),
        ("\u{147}", "\u{147}", "\u{4e}\u{30c}", "\u{147}", "\u{4e}\u{30c}"), ("\u{148}", "\u{148}",
        "\u{6e}\u{30c}", "\u{148}", "\u{6e}\u{30c}"), ("\u{149}", "\u{149}", "\u{149}",
        "\u{2bc}\u{6e}", "\u{2bc}\u{6e}"), ("\u{14c}", "\u{14c}", "\u{4f}\u{304}", "\u{14c}",
        "\u{4f}\u{304}"), ("\u{14d}", "\u{14d}", "\u{6f}\u{304}", "\u{14d}", "\u{6f}\u{304}"),
        ("\u{14e}", "\u{14e}", "\u{4f}\u{306}", "\u{14e}", "\u{4f}\u{306}"), ("\u{14f}", "\u{14f}",
        "\u{6f}\u{306}", "\u{14f}", "\u{6f}\u{306}"), ("\u{150}", "\u{150}", "\u{4f}\u{30b}",
        "\u{150}", "\u{4f}\u{30b}"), ("\u{151}", "\u{151}", "\u{6f}\u{30b}", "\u{151}",
        "\u{6f}\u{30b}"), ("\u{154}", "\u{154}", "\u{52}\u{301}", "\u{154}", "\u{52}\u{301}"),
        ("\u{155}", "\u{155}", "\u{72}\u{301}", "\u{155}", "\u{72}\u{301}"), ("\u{156}", "\u{156}",
        "\u{52}\u{327}", "\u{156}", "\u{52}\u{327}"), ("\u{157}", "\u{157}", "\u{72}\u{327}",
        "\u{157}", "\u{72}\u{327}"), ("\u{158}", "\u{158}", "\u{52}\u{30c}", "\u{158}",
        "\u{52}\u{30c}"), ("\u{159}", "\u{159}", "\u{72}\u{30c}", "\u{159}", "\u{72}\u{30c}"),
        ("\u{15a}", "\u{15a}", "\u{53}\u{301}", "\u{15a}", "\u{53}\u{301}"), ("\u{15b}", "\u{15b}",
        "\u{73}\u{301}", "\u{15b}", "\u{73}\u{301}"), ("\u{15c}", "\u{15c}", "\u{53}\u{302}",
        "\u{15c}", "\u{53}\u{302}"), ("\u{15d}", "\u{15d}", "\u{73}\u{302}", "\u{15d}",
        "\u{73}\u{302}"), ("\u{15e}", "\u{15e}", "\u{53}\u{327}", "\u{15e}", "\u{53}\u{327}"),
        ("\u{15f}", "\u{15f}", "\u{73}\u{327}", "\u{15f}", "\u{73}\u{327}"), ("\u{160}", "\u{160}",
        "\u{53}\u{30c}", "\u{160}", "\u{53}\u{30c}"), ("\u{161}", "\u{161}", "\u{73}\u{30c}",
        "\u{161}", "\u{73}\u{30c}"), ("\u{162}", "\u{162}", "\u{54}\u{327}", "\u{162}",
        "\u{54}\u{327}"), ("\u{163}", "\u{163}", "\u{74}\u{327}", "\u{163}", "\u{74}\u{327}"),
        ("\u{164}", "\u{164}", "\u{54}\u{30c}", "\u{164}", "\u{54}\u{30c}"), ("\u{165}", "\u{165}",
        "\u{74}\u{30c}", "\u{165}", "\u{74}\u{30c}"), ("\u{168}", "\u{168}", "\u{55}\u{303}",
        "\u{168}", "\u{55}\u{303}"), ("\u{169}", "\u{169}", "\u{75}\u{303}", "\u{169}",
        "\u{75}\u{303}"), ("\u{16a}", "\u{16a}", "\u{55}\u{304}", "\u{16a}", "\u{55}\u{304}"),
        ("\u{16b}", "\u{16b}", "\u{75}\u{304}", "\u{16b}", "\u{75}\u{304}"), ("\u{16c}", "\u{16c}",
        "\u{55}\u{306}", "\u{16c}", "\u{55}\u{306}"), ("\u{16d}", "\u{16d}", "\u{75}\u{306}",
        "\u{16d}", "\u{75}\u{306}"), ("\u{16e}", "\u{16e}", "\u{55}\u{30a}", "\u{16e}",
        "\u{55}\u{30a}"), ("\u{16f}", "\u{16f}", "\u{75}\u{30a}", "\u{16f}", "\u{75}\u{30a}"),
        ("\u{170}", "\u{170}", "\u{55}\u{30b}", "\u{170}", "\u{55}\u{30b}"), ("\u{171}", "\u{171}",
        "\u{75}\u{30b}", "\u{171}", "\u{75}\u{30b}"), ("\u{172}", "\u{172}", "\u{55}\u{328}",
        "\u{172}", "\u{55}\u{328}"), ("\u{173}", "\u{173}", "\u{75}\u{328}", "\u{173}",
        "\u{75}\u{328}"), ("\u{174}", "\u{174}", "\u{57}\u{302}", "\u{174}", "\u{57}\u{302}"),
        ("\u{175}", "\u{175}", "\u{77}\u{302}", "\u{175}", "\u{77}\u{302}"), ("\u{176}", "\u{176}",
        "\u{59}\u{302}", "\u{176}", "\u{59}\u{302}"), ("\u{177}", "\u{177}", "\u{79}\u{302}",
        "\u{177}", "\u{79}\u{302}"), ("\u{178}", "\u{178}", "\u{59}\u{308}", "\u{178}",
        "\u{59}\u{308}"), ("\u{179}", "\u{179}", "\u{5a}\u{301}", "\u{179}", "\u{5a}\u{301}"),
        ("\u{17a}", "\u{17a}", "\u{7a}\u{301}", "\u{17a}", "\u{7a}\u{301}"), ("\u{17b}", "\u{17b}",
        "\u{5a}\u{307}", "\u{17b}", "\u{5a}\u{307}"), ("\u{17c}", "\u{17c}", "\u{7a}\u{307}",
        "\u{17c}", "\u{7a}\u{307}"), ("\u{17d}", "\u{17d}", "\u{5a}\u{30c}", "\u{17d}",
        "\u{5a}\u{30c}"), ("\u{17e}", "\u{17e}", "\u{7a}\u{30c}", "\u{17e}", "\u{7a}\u{30c}"),
        ("\u{17f}", "\u{17f}", "\u{17f}", "\u{73}", "\u{73}"), ("\u{1a0}", "\u{1a0}",
        "\u{4f}\u{31b}", "\u{1a0}", "\u{4f}\u{31b}"), ("\u{1a1}", "\u{1a1}", "\u{6f}\u{31b}",
        "\u{1a1}", "\u{6f}\u{31b}"), ("\u{1af}", "\u{1af}", "\u{55}\u{31b}", "\u{1af}",
        "\u{55}\u{31b}"), ("\u{1b0}", "\u{1b0}", "\u{75}\u{31b}", "\u{1b0}", "\u{75}\u{31b}"),
        ("\u{1c4}", "\u{1c4}", "\u{1c4}", "\u{44}\u{17d}", "\u{44}\u{5a}\u{30c}"), ("\u{1c5}",
        "\u{1c5}", "\u{1c5}", "\u{44}\u{17e}", "\u{44}\u{7a}\u{30c}"), ("\u{1c6}", "\u{1c6}",
        "\u{1c6}", "\u{64}\u{17e}", "\u{64}\u{7a}\u{30c}"), ("\u{1c7}", "\u{1c7}", "\u{1c7}",
        "\u{4c}\u{4a}", "\u{4c}\u{4a}"), ("\u{1c8}", "\u{1c8}", "\u{1c8}", "\u{4c}\u{6a}",
        "\u{4c}\u{6a}"), ("\u{1c9}", "\u{1c9}", "\u{1c9}", "\u{6c}\u{6a}", "\u{6c}\u{6a}"),
        ("\u{1ca}", "\u{1ca}", "\u{1ca}", "\u{4e}\u{4a}", "\u{4e}\u{4a}"), ("\u{1cb}", "\u{1cb}",
        "\u{1cb}", "\u{4e}\u{6a}", "\u{4e}\u{6a}"), ("\u{1cc}", "\u{1cc}", "\u{1cc}",
        "\u{6e}\u{6a}", "\u{6e}\u{6a}"), ("\u{1cd}", "\u{1cd}", "\u{41}\u{30c}", "\u{1cd}",
        "\u{41}\u{30c}"), ("\u{1ce}", "\u{1ce}", "\u{61}\u{30c}", "\u{1ce}", "\u{61}\u{30c}"),
        ("\u{1cf}", "\u{1cf}", "\u{49}\u{30c}", "\u{1cf}", "\u{49}\u{30c}"), ("\u{1d0}", "\u{1d0}",
        "\u{69}\u{30c}", "\u{1d0}", "\u{69}\u{30c}"), ("\u{1d1}", "\u{1d1}", "\u{4f}\u{30c}",
        "\u{1d1}", "\u{4f}\u{30c}"), ("\u{1d2}", "\u{1d2}", "\u{6f}\u{30c}", "\u{1d2}",
        "\u{6f}\u{30c}"), ("\u{1d3}", "\u{1d3}", "\u{55}\u{30c}", "\u{1d3}", "\u{55}\u{30c}"),
        ("\u{1d4}", "\u{1d4}", "\u{75}\u{30c}", "\u{1d4}", "\u{75}\u{30c}"), ("\u{1d5}", "\u{1d5}",
        "\u{55}\u{308}\u{304}", "\u{1d5}", "\u{55}\u{308}\u{304}"), ("\u{1d6}", "\u{1d6}",
        "\u{75}\u{308}\u{304}", "\u{1d6}", "\u{75}\u{308}\u{304}"), ("\u{1d7}", "\u{1d7}",
        "\u{55}\u{308}\u{301}", "\u{1d7}", "\u{55}\u{308}\u{301}"), ("\u{1d8}", "\u{1d8}",
        "\u{75}\u{308}\u{301}", "\u{1d8}", "\u{75}\u{308}\u{301}"), ("\u{1d9}", "\u{1d9}",
        "\u{55}\u{308}\u{30c}", "\u{1d9}", "\u{55}\u{308}\u{30c}"), ("\u{1da}", "\u{1da}",
        "\u{75}\u{308}\u{30c}", "\u{1da}", "\u{75}\u{308}\u{30c}"), ("\u{1db}", "\u{1db}",
        "\u{55}\u{308}\u{300}", "\u{1db}", "\u{55}\u{308}\u{300}"), ("\u{1dc}", "\u{1dc}",
        "\u{75}\u{308}\u{300}", "\u{1dc}", "\u{75}\u{308}\u{300}"), ("\u{1de}", "\u{1de}",
        "\u{41}\u{308}\u{304}", "\u{1de}", "\u{41}\u{308}\u{304}"), ("\u{1df}", "\u{1df}",
        "\u{61}\u{308}\u{304}", "\u{1df}", "\u{61}\u{308}\u{304}"), ("\u{1e0}", "\u{1e0}",
        "\u{41}\u{307}\u{304}", "\u{1e0}", "\u{41}\u{307}\u{304}"), ("\u{1e1}", "\u{1e1}",
        "\u{61}\u{307}\u{304}", "\u{1e1}", "\u{61}\u{307}\u{304}"), ("\u{1e2}", "\u{1e2}",
        "\u{c6}\u{304}", "\u{1e2}", "\u{c6}\u{304}"), ("\u{1e3}", "\u{1e3}", "\u{e6}\u{304}",
        "\u{1e3}", "\u{e6}\u{304}"), ("\u{1e6}", "\u{1e6}", "\u{47}\u{30c}", "\u{1e6}",
        "\u{47}\u{30c}"), ("\u{1e7}", "\u{1e7}", "\u{67}\u{30c}", "\u{1e7}", "\u{67}\u{30c}"),
        ("\u{1e8}", "\u{1e8}", "\u{4b}\u{30c}", "\u{1e8}", "\u{4b}\u{30c}"), ("\u{1e9}", "\u{1e9}",
        "\u{6b}\u{30c}", "\u{1e9}", "\u{6b}\u{30c}"), ("\u{1ea}", "\u{1ea}", "\u{4f}\u{328}",
        "\u{1ea}", "\u{4f}\u{328}"), ("\u{1eb}", "\u{1eb}", "\u{6f}\u{328}", "\u{1eb}",
        "\u{6f}\u{328}"), ("\u{1ec}", "\u{1ec}", "\u{4f}\u{328}\u{304}", "\u{1ec}",
        "\u{4f}\u{328}\u{304}"), ("\u{1ed}", "\u{1ed}", "\u{6f}\u{328}\u{304}", "\u{1ed}",
        "\u{6f}\u{328}\u{304}"), ("\u{1ee}", "\u{1ee}", "\u{1b7}\u{30c}", "\u{1ee}",
        "\u{1b7}\u{30c}"), ("\u{1ef}", "\u{1ef}", "\u{292}\u{30c}", "\u{1ef}", "\u{292}\u{30c}"),
        ("\u{1f0}", "\u{1f0}", "\u{6a}\u{30c}", "\u{1f0}", "\u{6a}\u{30c}"), ("\u{1f1}", "\u{1f1}",
        "\u{1f1}", "\u{44}\u{5a}", "\u{44}\u{5a}"), ("\u{1f2}", "\u{1f2}", "\u{1f2}",
        "\u{44}\u{7a}", "\u{44}\u{7a}"), ("\u{1f3}", "\u{1f3}", "\u{1f3}", "\u{64}\u{7a}",
        "\u{64}\u{7a}"), ("\u{1f4}", "\u{1f4}", "\u{47}\u{301}", "\u{1f4}", "\u{47}\u{301}"),
        ("\u{1f5}", "\u{1f5}", "\u{67}\u{301}", "\u{1f5}", "\u{67}\u{301}"), ("\u{1f8}", "\u{1f8}",
        "\u{4e}\u{300}", "\u{1f8}", "\u{4e}\u{300}"), ("\u{1f9}", "\u{1f9}", "\u{6e}\u{300}",
        "\u{1f9}", "\u{6e}\u{300}"), ("\u{1fa}", "\u{1fa}", "\u{41}\u{30a}\u{301}", "\u{1fa}",
        "\u{41}\u{30a}\u{301}"), ("\u{1fb}", "\u{1fb}", "\u{61}\u{30a}\u{301}", "\u{1fb}",
        "\u{61}\u{30a}\u{301}"), ("\u{1fc}", "\u{1fc}", "\u{c6}\u{301}", "\u{1fc}",
        "\u{c6}\u{301}"), ("\u{1fd}", "\u{1fd}", "\u{e6}\u{301}", "\u{1fd}", "\u{e6}\u{301}"),
        ("\u{1fe}", "\u{1fe}", "\u{d8}\u{301}", "\u{1fe}", "\u{d8}\u{301}"), ("\u{1ff}", "\u{1ff}",
        "\u{f8}\u{301}", "\u{1ff}", "\u{f8}\u{301}"), ("\u{200}", "\u{200}", "\u{41}\u{30f}",
        "\u{200}", "\u{41}\u{30f}"), ("\u{201}", "\u{201}", "\u{61}\u{30f}", "\u{201}",
        "\u{61}\u{30f}"), ("\u{202}", "\u{202}", "\u{41}\u{311}", "\u{202}", "\u{41}\u{311}"),
        ("\u{203}", "\u{203}", "\u{61}\u{311}", "\u{203}", "\u{61}\u{311}"), ("\u{204}", "\u{204}",
        "\u{45}\u{30f}", "\u{204}", "\u{45}\u{30f}"), ("\u{205}", "\u{205}", "\u{65}\u{30f}",
        "\u{205}", "\u{65}\u{30f}"), ("\u{206}", "\u{206}", "\u{45}\u{311}", "\u{206}",
        "\u{45}\u{311}"), ("\u{207}", "\u{207}", "\u{65}\u{311}", "\u{207}", "\u{65}\u{311}"),
        ("\u{208}", "\u{208}", "\u{49}\u{30f}", "\u{208}", "\u{49}\u{30f}"), ("\u{209}", "\u{209}",
        "\u{69}\u{30f}", "\u{209}", "\u{69}\u{30f}"), ("\u{20a}", "\u{20a}", "\u{49}\u{311}",
        "\u{20a}", "\u{49}\u{311}"), ("\u{20b}", "\u{20b}", "\u{69}\u{311}", "\u{20b}",
        "\u{69}\u{311}"), ("\u{20c}", "\u{20c}", "\u{4f}\u{30f}", "\u{20c}", "\u{4f}\u{30f}"),
        ("\u{20d}", "\u{20d}", "\u{6f}\u{30f}", "\u{20d}", "\u{6f}\u{30f}"), ("\u{20e}", "\u{20e}",
        "\u{4f}\u{311}", "\u{20e}", "\u{4f}\u{311}"), ("\u{20f}", "\u{20f}", "\u{6f}\u{311}",
        "\u{20f}", "\u{6f}\u{311}"), ("\u{210}", "\u{210}", "\u{52}\u{30f}", "\u{210}",
        "\u{52}\u{30f}"), ("\u{211}", "\u{211}", "\u{72}\u{30f}", "\u{211}", "\u{72}\u{30f}"),
        ("\u{212}", "\u{212}", "\u{52}\u{311}", "\u{212}", "\u{52}\u{311}"), ("\u{213}", "\u{213}",
        "\u{72}\u{311}", "\u{213}", "\u{72}\u{311}"), ("\u{214}", "\u{214}", "\u{55}\u{30f}",
        "\u{214}", "\u{55}\u{30f}"), ("\u{215}", "\u{215}", "\u{75}\u{30f}", "\u{215}",
        "\u{75}\u{30f}"), ("\u{216}", "\u{216}", "\u{55}\u{311}", "\u{216}", "\u{55}\u{311}"),
        ("\u{217}", "\u{217}", "\u{75}\u{311}", "\u{217}", "\u{75}\u{311}"), ("\u{218}", "\u{218}",
        "\u{53}\u{326}", "\u{218}", "\u{53}\u{326}"), ("\u{219}", "\u{219}", "\u{73}\u{326}",
        "\u{219}", "\u{73}\u{326}"), ("\u{21a}", "\u{21a}", "\u{54}\u{326}", "\u{21a}",
        "\u{54}\u{326}"), ("\u{21b}", "\u{21b}", "\u{74}\u{326}", "\u{21b}", "\u{74}\u{326}"),
        ("\u{21e}", "\u{21e}", "\u{48}\u{30c}", "\u{21e}", "\u{48}\u{30c}"), ("\u{21f}", "\u{21f}",
        "\u{68}\u{30c}", "\u{21f}", "\u{68}\u{30c}"), ("\u{226}", "\u{226}", "\u{41}\u{307}",
        "\u{226}", "\u{41}\u{307}"), ("\u{227}", "\u{227}", "\u{61}\u{307}", "\u{227}",
        "\u{61}\u{307}"), ("\u{228}", "\u{228}", "\u{45}\u{327}", "\u{228}", "\u{45}\u{327}"),
        ("\u{229}", "\u{229}", "\u{65}\u{327}", "\u{229}", "\u{65}\u{327}"), ("\u{22a}", "\u{22a}",
        "\u{4f}\u{308}\u{304}", "\u{22a}", "\u{4f}\u{308}\u{304}"), ("\u{22b}", "\u{22b}",
        "\u{6f}\u{308}\u{304}", "\u{22b}", "\u{6f}\u{308}\u{304}"), ("\u{22c}", "\u{22c}",
        "\u{4f}\u{303}\u{304}", "\u{22c}", "\u{4f}\u{303}\u{304}"), ("\u{22d}", "\u{22d}",
        "\u{6f}\u{303}\u{304}", "\u{22d}", "\u{6f}\u{303}\u{304}"), ("\u{22e}", "\u{22e}",
        "\u{4f}\u{307}", "\u{22e}", "\u{4f}\u{307}"), ("\u{22f}", "\u{22f}", "\u{6f}\u{307}",
        "\u{22f}", "\u{6f}\u{307}"), ("\u{230}", "\u{230}", "\u{4f}\u{307}\u{304}", "\u{230}",
        "\u{4f}\u{307}\u{304}"), ("\u{231}", "\u{231}", "\u{6f}\u{307}\u{304}", "\u{231}",
        "\u{6f}\u{307}\u{304}"), ("\u{232}", "\u{232}", "\u{59}\u{304}", "\u{232}",
        "\u{59}\u{304}"), ("\u{233}", "\u{233}", "\u{79}\u{304}", "\u{233}", "\u{79}\u{304}"),
        ("\u{2b0}", "\u{2b0}", "\u{2b0}", "\u{68}", "\u{68}"), ("\u{2b1}", "\u{2b1}", "\u{2b1}",
        "\u{266}", "\u{266}"), ("\u{2b2}", "\u{2b2}", "\u{2b2}", "\u{6a}", "\u{6a}"), ("\u{2b3}",
        "\u{2b3}", "\u{2b3}", "\u{72}", "\u{72}"), ("\u{2b4}", "\u{2b4}", "\u{2b4}", "\u{279}",
        "\u{279}"), ("\u{2b5}", "\u{2b5}", "\u{2b5}", "\u{27b}", "\u{27b}"), ("\u{2b6}", "\u{2b6}",
        "\u{2b6}", "\u{281}", "\u{281}"), ("\u{2b7}", "\u{2b7}", "\u{2b7}", "\u{77}", "\u{77}"),
        ("\u{2b8}", "\u{2b8}", "\u{2b8}", "\u{79}", "\u{79}"), ("\u{2d8}", "\u{2d8}", "\u{2d8}",
        "\u{20}\u{306}", "\u{20}\u{306}"), ("\u{2d9}", "\u{2d9}", "\u{2d9}", "\u{20}\u{307}",
        "\u{20}\u{307}"), ("\u{2da}", "\u{2da}", "\u{2da}", "\u{20}\u{30a}", "\u{20}\u{30a}"),
        ("\u{2db}", "\u{2db}", "\u{2db}", "\u{20}\u{328}", "\u{20}\u{328}"), ("\u{2dc}", "\u{2dc}",
        "\u{2dc}", "\u{20}\u{303}", "\u{20}\u{303}"), ("\u{2dd}", "\u{2dd}", "\u{2dd}",
        "\u{20}\u{30b}", "\u{20}\u{30b}"), ("\u{2e0}", "\u{2e0}", "\u{2e0}", "\u{263}", "\u{263}"),
        ("\u{2e1}", "\u{2e1}", "\u{2e1}", "\u{6c}", "\u{6c}"), ("\u{2e2}", "\u{2e2}", "\u{2e2}",
        "\u{73}", "\u{73}"), ("\u{2e3}", "\u{2e3}", "\u{2e3}", "\u{78}", "\u{78}"), ("\u{2e4}",
        "\u{2e4}", "\u{2e4}", "\u{295}", "\u{295}"), ("\u{340}", "\u{300}", "\u{300}", "\u{300}",
        "\u{300}"), ("\u{341}", "\u{301}", "\u{301}", "\u{301}", "\u{301}"), ("\u{343}", "\u{313}",
        "\u{313}", "\u{313}", "\u{313}"), ("\u{344}", "\u{308}\u{301}", "\u{308}\u{301}",
        "\u{308}\u{301}", "\u{308}\u{301}"), ("\u{374}", "\u{2b9}", "\u{2b9}", "\u{2b9}",
        "\u{2b9}"), ("\u{37a}", "\u{37a}", "\u{37a}", "\u{20}\u{345}", "\u{20}\u{345}"), ("\u{37e}",
        "\u{3b}", "\u{3b}", "\u{3b}", "\u{3b}"), ("\u{384}", "\u{384}", "\u{384}", "\u{20}\u{301}",
        "\u{20}\u{301}"), ("\u{385}", "\u{385}", "\u{a8}\u{301}", "\u{20}\u{308}\u{301}",
        "\u{20}\u{308}\u{301}"), ("\u{386}", "\u{386}", "\u{391}\u{301}", "\u{386}",
        "\u{391}\u{301}"), ("\u{387}", "\u{b7}", "\u{b7}", "\u{b7}", "\u{b7}"), ("\u{388}",
        "\u{388}", "\u{395}\u{301}", "\u{388}", "\u{395}\u{301}"), ("\u{389}", "\u{389}",
        "\u{397}\u{301}", "\u{389}", "\u{397}\u{301}"), ("\u{38a}", "\u{38a}", "\u{399}\u{301}",
        "\u{38a}", "\u{399}\u{301}"), ("\u{38c}", "\u{38c}", "\u{39f}\u{301}", "\u{38c}",
        "\u{39f}\u{301}"), ("\u{38e}", "\u{38e}", "\u{3a5}\u{301}", "\u{38e}", "\u{3a5}\u{301}"),
        ("\u{38f}", "\u{38f}", "\u{3a9}\u{301}", "\u{38f}", "\u{3a9}\u{301}"), ("\u{390}",
        "\u{390}", "\u{3b9}\u{308}\u{301}", "\u{390}", "\u{3b9}\u{308}\u{301}"), ("\u{3aa}",
        "\u{3aa}", "\u{399}\u{308}", "\u{3aa}", "\u{399}\u{308}"), ("\u{3ab}", "\u{3ab}",
        "\u{3a5}\u{308}", "\u{3ab}", "\u{3a5}\u{308}"), ("\u{3ac}", "\u{3ac}", "\u{3b1}\u{301}",
        "\u{3ac}", "\u{3b1}\u{301}"), ("\u{3ad}", "\u{3ad}", "\u{3b5}\u{301}", "\u{3ad}",
        "\u{3b5}\u{301}"), ("\u{3ae}", "\u{3ae}", "\u{3b7}\u{301}", "\u{3ae}", "\u{3b7}\u{301}"),
        ("\u{3af}", "\u{3af}", "\u{3b9}\u{301}", "\u{3af}", "\u{3b9}\u{301}"), ("\u{3b0}",
        "\u{3b0}", "\u{3c5}\u{308}\u{301}", "\u{3b0}", "\u{3c5}\u{308}\u{301}"), ("\u{3ca}",
        "\u{3ca}", "\u{3b9}\u{308}", "\u{3ca}", "\u{3b9}\u{308}"), ("\u{3cb}", "\u{3cb}",
        "\u{3c5}\u{308}", "\u{3cb}", "\u{3c5}\u{308}"), ("\u{3cc}", "\u{3cc}", "\u{3bf}\u{301}",
        "\u{3cc}", "\u{3bf}\u{301}"), ("\u{3cd}", "\u{3cd}", "\u{3c5}\u{301}", "\u{3cd}",
        "\u{3c5}\u{301}"), ("\u{3ce}", "\u{3ce}", "\u{3c9}\u{301}", "\u{3ce}", "\u{3c9}\u{301}"),
        ("\u{3d0}", "\u{3d0}", "\u{3d0}", "\u{3b2}", "\u{3b2}"), ("\u{3d1}", "\u{3d1}", "\u{3d1}",
        "\u{3b8}", "\u{3b8}"), ("\u{3d2}", "\u{3d2}", "\u{3d2}", "\u{3a5}", "\u{3a5}"), ("\u{3d3}",
        "\u{3d3}", "\u{3d2}\u{301}", "\u{38e}", "\u{3a5}\u{301}"), ("\u{3d4}", "\u{3d4}",
        "\u{3d2}\u{308}", "\u{3ab}", "\u{3a5}\u{308}"), ("\u{3d5}", "\u{3d5}", "\u{3d5}", "\u{3c6}",
        "\u{3c6}"), ("\u{3d6}", "\u{3d6}", "\u{3d6}", "\u{3c0}", "\u{3c0}"), ("\u{3f0}", "\u{3f0}",
        "\u{3f0}", "\u{3ba}", "\u{3ba}"), ("\u{3f1}", "\u{3f1}", "\u{3f1}", "\u{3c1}", "\u{3c1}"),
        ("\u{3f2}", "\u{3f2}", "\u{3f2}", "\u{3c2}", "\u{3c2}"), ("\u{3f4}", "\u{3f4}", "\u{3f4}",
        "\u{398}", "\u{398}"), ("\u{3f5}", "\u{3f5}", "\u{3f5}", "\u{3b5}", "\u{3b5}"), ("\u{3f9}",
        "\u{3f9}", "\u{3f9}", "\u{3a3}", "\u{3a3}"), ("\u{400}", "\u{400}", "\u{415}\u{300}",
        "\u{400}", "\u{415}\u{300}"), ("\u{401}", "\u{401}", "\u{415}\u{308}", "\u{401}",
        "\u{415}\u{308}"), ("\u{403}", "\u{403}", "\u{413}\u{301}", "\u{403}", "\u{413}\u{301}"),
        ("\u{407}", "\u{407}", "\u{406}\u{308}", "\u{407}", "\u{406}\u{308}"), ("\u{40c}",
        "\u{40c}", "\u{41a}\u{301}", "\u{40c}", "\u{41a}\u{301}"), ("\u{40d}", "\u{40d}",
        "\u{418}\u{300}", "\u{40d}", "\u{418}\u{300}"), ("\u{40e}", "\u{40e}", "\u{423}\u{306}",
        "\u{40e}", "\u{423}\u{306}"), ("\u{419}", "\u{419}", "\u{418}\u{306}", "\u{419}",
        "\u{418}\u{306}"), ("\u{439}", "\u{439}", "\u{438}\u{306}", "\u{439}", "\u{438}\u{306}"),
        ("\u{450}", "\u{450}", "\u{435}\u{300}", "\u{450}", "\u{435}\u{300}"), ("\u{451}",
        "\u{451}", "\u{435}\u{308}", "\u{451}", "\u{435}\u{308}"), ("\u{453}", "\u{453}",
        "\u{433}\u{301}", "\u{453}", "\u{433}\u{301}"), ("\u{457}", "\u{457}", "\u{456}\u{308}",
        "\u{457}", "\u{456}\u{308}"), ("\u{45c}", "\u{45c}", "\u{43a}\u{301}", "\u{45c}",
        "\u{43a}\u{301}"), ("\u{45d}", "\u{45d}", "\u{438}\u{300}", "\u{45d}", "\u{438}\u{300}"),
        ("\u{45e}", "\u{45e}", "\u{443}\u{306}", "\u{45e}", "\u{443}\u{306}"), ("\u{476}",
        "\u{476}", "\u{474}\u{30f}", "\u{476}", "\u{474}\u{30f}"), ("\u{477}", "\u{477}",
        "\u{475}\u{30f}", "\u{477}", "\u{475}\u{30f}"), ("\u{4c1}", "\u{4c1}", "\u{416}\u{306}",
        "\u{4c1}", "\u{416}\u{306}"), ("\u{4c2}", "\u{4c2}", "\u{436}\u{306}", "\u{4c2}",
        "\u{436}\u{306}"), ("\u{4d0}", "\u{4d0}", "\u{410}\u{306}", "\u{4d0}", "\u{410}\u{306}"),
        ("\u{4d1}", "\u{4d1}", "\u{430}\u{306}", "\u{4d1}", "\u{430}\u{306}"), ("\u{4d2}",
        "\u{4d2}", "\u{410}\u{308}", "\u{4d2}", "\u{410}\u{308}"), ("\u{4d3}", "\u{4d3}",
        "\u{430}\u{308}", "\u{4d3}", "\u{430}\u{308}"), ("\u{4d6}", "\u{4d6}", "\u{415}\u{306}",
        "\u{4d6}", "\u{415}\u{306}"), ("\u{4d7}", "\u{4d7}", "\u{435}\u{306}", "\u{4d7}",
        "\u{435}\u{306}"), ("\u{4da}", "\u{4da}", "\u{4d8}\u{308}", "\u{4da}", "\u{4d8}\u{308}"),
        ("\u{4db}", "\u{4db}", "\u{4d9}\u{308}", "\u{4db}", "\u{4d9}\u{308}"), ("\u{4dc}",
        "\u{4dc}", "\u{416}\u{308}", "\u{4dc}", "\u{416}\u{308}"), ("\u{4dd}", "\u{4dd}",
        "\u{436}\u{308}", "\u{4dd}", "\u{436}\u{308}"), ("\u{4de}", "\u{4de}", "\u{417}\u{308}",
        "\u{4de}", "\u{417}\u{308}"), ("\u{4df}", "\u{4df}", "\u{437}\u{308}", "\u{4df}",
        "\u{437}\u{308}"), ("\u{4e2}", "\u{4e2}", "\u{418}\u{304}", "\u{4e2}", "\u{418}\u{304}"),
        ("\u{4e3}", "\u{4e3}", "\u{438}\u{304}", "\u{4e3}", "\u{438}\u{304}"), ("\u{4e4}",
        "\u{4e4}", "\u{418}\u{308}", "\u{4e4}", "\u{418}\u{308}"), ("\u{4e5}", "\u{4e5}",
        "\u{438}\u{308}", "\u{4e5}", "\u{438}\u{308}"), ("\u{4e6}", "\u{4e6}", "\u{41e}\u{308}",
        "\u{4e6}", "\u{41e}\u{308}"), ("\u{4e7}", "\u{4e7}", "\u{43e}\u{308}", "\u{4e7}",
        "\u{43e}\u{308}"), ("\u{4ea}", "\u{4ea}", "\u{4e8}\u{308}", "\u{4ea}", "\u{4e8}\u{308}"),
        ("\u{4eb}", "\u{4eb}", "\u{4e9}\u{308}", "\u{4eb}", "\u{4e9}\u{308}"), ("\u{4ec}",
        "\u{4ec}", "\u{42d}\u{308}", "\u{4ec}", "\u{42d}\u{308}"), ("\u{4ed}", "\u{4ed}",
        "\u{44d}\u{308}", "\u{4ed}", "\u{44d}\u{308}"), ("\u{4ee}", "\u{4ee}", "\u{423}\u{304}",
        "\u{4ee}", "\u{423}\u{304}"), ("\u{4ef}", "\u{4ef}", "\u{443}\u{304}", "\u{4ef}",
        "\u{443}\u{304}"), ("\u{4f0}", "\u{4f0}", "\u{423}\u{308}", "\u{4f0}", "\u{423}\u{308}"),
        ("\u{4f1}", "\u{4f1}", "\u{443}\u{308}", "\u{4f1}", "\u{443}\u{308}"), ("\u{4f2}",
        "\u{4f2}", "\u{423}\u{30b}", "\u{4f2}", "\u{423}\u{30b}"), ("\u{4f3}", "\u{4f3}",
        "\u{443}\u{30b}", "\u{4f3}", "\u{443}\u{30b}"), ("\u{4f4}", "\u{4f4}", "\u{427}\u{308}",
        "\u{4f4}", "\u{427}\u{308}"), ("\u{4f5}", "\u{4f5}", "\u{447}\u{308}", "\u{4f5}",
        "\u{447}\u{308}"), ("\u{4f8}", "\u{4f8}", "\u{42b}\u{308}", "\u{4f8}", "\u{42b}\u{308}"),
        ("\u{4f9}", "\u{4f9}", "\u{44b}\u{308}", "\u{4f9}", "\u{44b}\u{308}"), ("\u{587}",
        "\u{587}", "\u{587}", "\u{565}\u{582}", "\u{565}\u{582}"), ("\u{622}", "\u{622}",
        "\u{627}\u{653}", "\u{622}", "\u{627}\u{653}"), ("\u{623}", "\u{623}", "\u{627}\u{654}",
        "\u{623}", "\u{627}\u{654}"), ("\u{624}", "\u{624}", "\u{648}\u{654}", "\u{624}",
        "\u{648}\u{654}"), ("\u{625}", "\u{625}", "\u{627}\u{655}", "\u{625}", "\u{627}\u{655}"),
        ("\u{626}", "\u{626}", "\u{64a}\u{654}", "\u{626}", "\u{64a}\u{654}"), ("\u{675}",
        "\u{675}", "\u{675}", "\u{627}\u{674}", "\u{627}\u{674}"), ("\u{676}", "\u{676}", "\u{676}",
        "\u{648}\u{674}", "\u{648}\u{674}"), ("\u{677}", "\u{677}", "\u{677}", "\u{6c7}\u{674}",
        "\u{6c7}\u{674}"), ("\u{678}", "\u{678}", "\u{678}", "\u{64a}\u{674}", "\u{64a}\u{674}"),
        ("\u{6c0}", "\u{6c0}", "\u{6d5}\u{654}", "\u{6c0}", "\u{6d5}\u{654}"), ("\u{6c2}",
        "\u{6c2}", "\u{6c1}\u{654}", "\u{6c2}", "\u{6c1}\u{654}"), ("\u{6d3}", "\u{6d3}",
        "\u{6d2}\u{654}", "\u{6d3}", "\u{6d2}\u{654}"), ("\u{929}", "\u{929}", "\u{928}\u{93c}",
        "\u{929}", "\u{928}\u{93c}"), ("\u{931}", "\u{931}", "\u{930}\u{93c}", "\u{931}",
        "\u{930}\u{93c}"), ("\u{934}", "\u{934}", "\u{933}\u{93c}", "\u{934}", "\u{933}\u{93c}"),
        ("\u{958}", "\u{915}\u{93c}", "\u{915}\u{93c}", "\u{915}\u{93c}", "\u{915}\u{93c}"),
        ("\u{959}", "\u{916}\u{93c}", "\u{916}\u{93c}", "\u{916}\u{93c}", "\u{916}\u{93c}"),
        ("\u{95a}", "\u{917}\u{93c}", "\u{917}\u{93c}", "\u{917}\u{93c}", "\u{917}\u{93c}"),
        ("\u{95b}", "\u{91c}\u{93c}", "\u{91c}\u{93c}", "\u{91c}\u{93c}", "\u{91c}\u{93c}"),
        ("\u{95c}", "\u{921}\u{93c}", "\u{921}\u{93c}", "\u{921}\u{93c}", "\u{921}\u{93c}"),
        ("\u{95d}", "\u{922}\u{93c}", "\u{922}\u{93c}", "\u{922}\u{93c}", "\u{922}\u{93c}"),
        ("\u{95e}", "\u{92b}\u{93c}", "\u{92b}\u{93c}", "\u{92b}\u{93c}", "\u{92b}\u{93c}"),
        ("\u{95f}", "\u{92f}\u{93c}", "\u{92f}\u{93c}", "\u{92f}\u{93c}", "\u{92f}\u{93c}"),
        ("\u{9cb}", "\u{9cb}", "\u{9c7}\u{9be}", "\u{9cb}", "\u{9c7}\u{9be}"), ("\u{9cc}",
        "\u{9cc}", "\u{9c7}\u{9d7}", "\u{9cc}", "\u{9c7}\u{9d7}"), ("\u{9dc}", "\u{9a1}\u{9bc}",
        "\u{9a1}\u{9bc}", "\u{9a1}\u{9bc}", "\u{9a1}\u{9bc}"), ("\u{9dd}", "\u{9a2}\u{9bc}",
        "\u{9a2}\u{9bc}", "\u{9a2}\u{9bc}", "\u{9a2}\u{9bc}"), ("\u{9df}", "\u{9af}\u{9bc}",
        "\u{9af}\u{9bc}", "\u{9af}\u{9bc}", "\u{9af}\u{9bc}"), ("\u{a33}", "\u{a32}\u{a3c}",
        "\u{a32}\u{a3c}", "\u{a32}\u{a3c}", "\u{a32}\u{a3c}"), ("\u{a36}", "\u{a38}\u{a3c}",
        "\u{a38}\u{a3c}", "\u{a38}\u{a3c}", "\u{a38}\u{a3c}"), ("\u{a59}", "\u{a16}\u{a3c}",
        "\u{a16}\u{a3c}", "\u{a16}\u{a3c}", "\u{a16}\u{a3c}"), ("\u{a5a}", "\u{a17}\u{a3c}",
        "\u{a17}\u{a3c}", "\u{a17}\u{a3c}", "\u{a17}\u{a3c}"), ("\u{a5b}", "\u{a1c}\u{a3c}",
        "\u{a1c}\u{a3c}", "\u{a1c}\u{a3c}", "\u{a1c}\u{a3c}"), ("\u{a5e}", "\u{a2b}\u{a3c}",
        "\u{a2b}\u{a3c}", "\u{a2b}\u{a3c}", "\u{a2b}\u{a3c}"), ("\u{b48}", "\u{b48}",
        "\u{b47}\u{b56}", "\u{b48}", "\u{b47}\u{b56}"), ("\u{b4b}", "\u{b4b}", "\u{b47}\u{b3e}",
        "\u{b4b}", "\u{b47}\u{b3e}"), ("\u{b4c}", "\u{b4c}", "\u{b47}\u{b57}", "\u{b4c}",
        "\u{b47}\u{b57}"), ("\u{b5c}", "\u{b21}\u{b3c}", "\u{b21}\u{b3c}", "\u{b21}\u{b3c}",
        "\u{b21}\u{b3c}"), ("\u{b5d}", "\u{b22}\u{b3c}", "\u{b22}\u{b3c}", "\u{b22}\u{b3c}",
        "\u{b22}\u{b3c}"), ("\u{b94}", "\u{b94}", "\u{b92}\u{bd7}", "\u{b94}", "\u{b92}\u{bd7}"),
        ("\u{bca}", "\u{bca}", "\u{bc6}\u{bbe}", "\u{bca}", "\u{bc6}\u{bbe}"), ("\u{bcb}",
        "\u{bcb}", "\u{bc7}\u{bbe}", "\u{bcb}", "\u{bc7}\u{bbe}"), ("\u{bcc}", "\u{bcc}",
        "\u{bc6}\u{bd7}", "\u{bcc}", "\u{bc6}\u{bd7}"), ("\u{c48}", "\u{c48}", "\u{c46}\u{c56}",
        "\u{c48}", "\u{c46}\u{c56}"), ("\u{cc0}", "\u{cc0}", "\u{cbf}\u{cd5}", "\u{cc0}",
        "\u{cbf}\u{cd5}"), ("\u{cc7}", "\u{cc7}", "\u{cc6}\u{cd5}", "\u{cc7}", "\u{cc6}\u{cd5}"),
        ("\u{cc8}", "\u{cc8}", "\u{cc6}\u{cd6}", "\u{cc8}", "\u{cc6}\u{cd6}"), ("\u{cca}",
        "\u{cca}", "\u{cc6}\u{cc2}", "\u{cca}", "\u{cc6}\u{cc2}"), ("\u{ccb}", "\u{ccb}",
        "\u{cc6}\u{cc2}\u{cd5}", "\u{ccb}", "\u{cc6}\u{cc2}\u{cd5}"), ("\u{d4a}", "\u{d4a}",
        "\u{d46}\u{d3e}", "\u{d4a}", "\u{d46}\u{d3e}"), ("\u{d4b}", "\u{d4b}", "\u{d47}\u{d3e}",
        "\u{d4b}", "\u{d47}\u{d3e}"), ("\u{d4c}", "\u{d4c}", "\u{d46}\u{d57}", "\u{d4c}",
        "\u{d46}\u{d57}"), ("\u{dda}", "\u{dda}", "\u{dd9}\u{dca}", "\u{dda}", "\u{dd9}\u{dca}"),
        ("\u{ddc}", "\u{ddc}", "\u{dd9}\u{dcf}", "\u{ddc}", "\u{dd9}\u{dcf}"), ("\u{ddd}",
        "\u{ddd}", "\u{dd9}\u{dcf}\u{dca}", "\u{ddd}", "\u{dd9}\u{dcf}\u{dca}"), ("\u{dde}",
        "\u{dde}", "\u{dd9}\u{ddf}", "\u{dde}", "\u{dd9}\u{ddf}"), ("\u{e33}", "\u{e33}", "\u{e33}",
        "\u{e4d}\u{e32}", "\u{e4d}\u{e32}"), ("\u{eb3}", "\u{eb3}", "\u{eb3}", "\u{ecd}\u{eb2}",
        "\u{ecd}\u{eb2}"), ("\u{edc}", "\u{edc}", "\u{edc}", "\u{eab}\u{e99}", "\u{eab}\u{e99}"),
        ("\u{edd}", "\u{edd}", "\u{edd}", "\u{eab}\u{ea1}", "\u{eab}\u{ea1}"), ("\u{f0c}",
        "\u{f0c}", "\u{f0c}", "\u{f0b}", "\u{f0b}"), ("\u{f43}", "\u{f42}\u{fb7}", "\u{f42}\u{fb7}",
        "\u{f42}\u{fb7}", "\u{f42}\u{fb7}"), ("\u{f4d}", "\u{f4c}\u{fb7}", "\u{f4c}\u{fb7}",
        "\u{f4c}\u{fb7}", "\u{f4c}\u{fb7}"), ("\u{f52}", "\u{f51}\u{fb7}", "\u{f51}\u{fb7}",
        "\u{f51}\u{fb7}", "\u{f51}\u{fb7}"), ("\u{f57}", "\u{f56}\u{fb7}", "\u{f56}\u{fb7}",
        "\u{f56}\u{fb7}", "\u{f56}\u{fb7}"), ("\u{f5c}", "\u{f5b}\u{fb7}", "\u{f5b}\u{fb7}",
        "\u{f5b}\u{fb7}", "\u{f5b}\u{fb7}"), ("\u{f69}", "\u{f40}\u{fb5}", "\u{f40}\u{fb5}",
        "\u{f40}\u{fb5}", "\u{f40}\u{fb5}"), ("\u{f73}", "\u{f71}\u{f72}", "\u{f71}\u{f72}",
        "\u{f71}\u{f72}", "\u{f71}\u{f72}"), ("\u{f75}", "\u{f71}\u{f74}", "\u{f71}\u{f74}",
        "\u{f71}\u{f74}", "\u{f71}\u{f74}"), ("\u{f76}", "\u{fb2}\u{f80}", "\u{fb2}\u{f80}",
        "\u{fb2}\u{f80}", "\u{fb2}\u{f80}"), ("\u{f77}", "\u{f77}", "\u{f77}",
        "\u{fb2}\u{f71}\u{f80}", "\u{fb2}\u{f71}\u{f80}"), ("\u{f78}", "\u{fb3}\u{f80}",
        "\u{fb3}\u{f80}", "\u{fb3}\u{f80}", "\u{fb3}\u{f80}"), ("\u{f79}", "\u{f79}", "\u{f79}",
        "\u{fb3}\u{f71}\u{f80}", "\u{fb3}\u{f71}\u{f80}"), ("\u{f81}", "\u{f71}\u{f80}",
        "\u{f71}\u{f80}", "\u{f71}\u{f80}", "\u{f71}\u{f80}"), ("\u{f93}", "\u{f92}\u{fb7}",
        "\u{f92}\u{fb7}", "\u{f92}\u{fb7}", "\u{f92}\u{fb7}"), ("\u{f9d}", "\u{f9c}\u{fb7}",
        "\u{f9c}\u{fb7}", "\u{f9c}\u{fb7}", "\u{f9c}\u{fb7}"), ("\u{fa2}", "\u{fa1}\u{fb7}",
        "\u{fa1}\u{fb7}", "\u{fa1}\u{fb7}", "\u{fa1}\u{fb7}"), ("\u{fa7}", "\u{fa6}\u{fb7}",
        "\u{fa6}\u{fb7}", "\u{fa6}\u{fb7}", "\u{fa6}\u{fb7}"), ("\u{fac}", "\u{fab}\u{fb7}",
        "\u{fab}\u{fb7}", "\u{fab}\u{fb7}", "\u{fab}\u{fb7}"), ("\u{fb9}", "\u{f90}\u{fb5}",
        "\u{f90}\u{fb5}", "\u{f90}\u{fb5}", "\u{f90}\u{fb5}"), ("\u{1026}", "\u{1026}",
        "\u{1025}\u{102e}", "\u{1026}", "\u{1025}\u{102e}"), ("\u{10fc}", "\u{10fc}", "\u{10fc}",
        "\u{10dc}", "\u{10dc}"), ("\u{1b06}", "\u{1b06}", "\u{1b05}\u{1b35}", "\u{1b06}",
        "\u{1b05}\u{1b35}"), ("\u{1b08}", "\u{1b08}", "\u{1b07}\u{1b35}", "\u{1b08}",
        "\u{1b07}\u{1b35}"), ("\u{1b0a}", "\u{1b0a}", "\u{1b09}\u{1b35}", "\u{1b0a}",
        "\u{1b09}\u{1b35}"), ("\u{1b0c}", "\u{1b0c}", "\u{1b0b}\u{1b35}", "\u{1b0c}",
        "\u{1b0b}\u{1b35}"), ("\u{1b0e}", "\u{1b0e}", "\u{1b0d}\u{1b35}", "\u{1b0e}",
        "\u{1b0d}\u{1b35}"), ("\u{1b12}", "\u{1b12}", "\u{1b11}\u{1b35}", "\u{1b12}",
        "\u{1b11}\u{1b35}"), ("\u{1b3b}", "\u{1b3b}", "\u{1b3a}\u{1b35}", "\u{1b3b}",
        "\u{1b3a}\u{1b35}"), ("\u{1b3d}", "\u{1b3d}", "\u{1b3c}\u{1b35}", "\u{1b3d}",
        "\u{1b3c}\u{1b35}"), ("\u{1b40}", "\u{1b40}", "\u{1b3e}\u{1b35}", "\u{1b40}",
        "\u{1b3e}\u{1b35}"), ("\u{1b41}", "\u{1b41}", "\u{1b3f}\u{1b35}", "\u{1b41}",
        "\u{1b3f}\u{1b35}"), ("\u{1b43}", "\u{1b43}", "\u{1b42}\u{1b35}", "\u{1b43}",
        "\u{1b42}\u{1b35}"), ("\u{1d2c}", "\u{1d2c}", "\u{1d2c}", "\u{41}", "\u{41}"), ("\u{1d2d}",
        "\u{1d2d}", "\u{1d2d}", "\u{c6}", "\u{c6}"), ("\u{1d2e}", "\u{1d2e}", "\u{1d2e}", "\u{42}",
        "\u{42}"), ("\u{1d30}", "\u{1d30}", "\u{1d30}", "\u{44}", "\u{44}"), ("\u{1d31}",
        "\u{1d31}", "\u{1d31}", "\u{45}", "\u{45}"), ("\u{1d32}", "\u{1d32}", "\u{1d32}", "\u{18e}",
        "\u{18e}"), ("\u{1d33}", "\u{1d33}", "\u{1d33}", "\u{47}", "\u{47}"), ("\u{1d34}",
        "\u{1d34}", "\u{1d34}", "\u{48}", "\u{48}"), ("\u{1d35}", "\u{1d35}", "\u{1d35}", "\u{49}",
        "\u{49}"), ("\u{1d36}", "\u{1d36}", "\u{1d36}", "\u{4a}", "\u{4a}"), ("\u{1d37}",
        "\u{1d37}", "\u{1d37}", "\u{4b}", "\u{4b}"), ("\u{1d38}", "\u{1d38}", "\u{1d38}", "\u{4c}",
        "\u{4c}"), ("\u{1d39}", "\u{1d39}", "\u{1d39}", "\u{4d}", "\u{4d}"), ("\u{1d3a}",
        "\u{1d3a}", "\u{1d3a}", "\u{4e}", "\u{4e}"), ("\u{1d3c}", "\u{1d3c}", "\u{1d3c}", "\u{4f}",
        "\u{4f}"), ("\u{1d3d}", "\u{1d3d}", "\u{1d3d}", "\u{222}", "\u{222}"), ("\u{1d3e}",
        "\u{1d3e}", "\u{1d3e}", "\u{50}", "\u{50}"), ("\u{1d3f}", "\u{1d3f}", "\u{1d3f}", "\u{52}",
        "\u{52}"), ("\u{1d40}", "\u{1d40}", "\u{1d40}", "\u{54}", "\u{54}"), ("\u{1d41}",
        "\u{1d41}", "\u{1d41}", "\u{55}", "\u{55}"), ("\u{1d42}", "\u{1d42}", "\u{1d42}", "\u{57}",
        "\u{57}"), ("\u{1d43}", "\u{1d43}", "\u{1d43}", "\u{61}", "\u{61}"), ("\u{1d44}",
        "\u{1d44}", "\u{1d44}", "\u{250}", "\u{250}"), ("\u{1d45}", "\u{1d45}", "\u{1d45}",
        "\u{251}", "\u{251}"), ("\u{1d46}", "\u{1d46}", "\u{1d46}", "\u{1d02}", "\u{1d02}"),
        ("\u{1d47}", "\u{1d47}", "\u{1d47}", "\u{62}", "\u{62}"), ("\u{1d48}", "\u{1d48}",
        "\u{1d48}", "\u{64}", "\u{64}"), ("\u{1d49}", "\u{1d49}", "\u{1d49}", "\u{65}", "\u{65}"),
        ("\u{1d4a}", "\u{1d4a}", "\u{1d4a}", "\u{259}", "\u{259}"), ("\u{1d4b}", "\u{1d4b}",
        "\u{1d4b}", "\u{25b}", "\u{25b}"), ("\u{1d4c}", "\u{1d4c}", "\u{1d4c}", "\u{25c}",
        "\u{25c}"), ("\u{1d4d}", "\u{1d4d}", "\u{1d4d}", "\u{67}", "\u{67}"), ("\u{1d4f}",
        "\u{1d4f}", "\u{1d4f}", "\u{6b}", "\u{6b}"), ("\u{1d50}", "\u{1d50}", "\u{1d50}", "\u{6d}",
        "\u{6d}"), ("\u{1d51}", "\u{1d51}", "\u{1d51}", "\u{14b}", "\u{14b}"), ("\u{1d52}",
        "\u{1d52}", "\u{1d52}", "\u{6f}", "\u{6f}"), ("\u{1d53}", "\u{1d53}", "\u{1d53}", "\u{254}",
        "\u{254}"), ("\u{1d54}", "\u{1d54}", "\u{1d54}", "\u{1d16}", "\u{1d16}"), ("\u{1d55}",
        "\u{1d55}", "\u{1d55}", "\u{1d17}", "\u{1d17}"), ("\u{1d56}", "\u{1d56}", "\u{1d56}",
        "\u{70}", "\u{70}"), ("\u{1d57}", "\u{1d57}", "\u{1d57}", "\u{74}", "\u{74}"), ("\u{1d58}",
        "\u{1d58}", "\u{1d58}", "\u{75}", "\u{75}"), ("\u{1d59}", "\u{1d59}", "\u{1d59}",
        "\u{1d1d}", "\u{1d1d}"), ("\u{1d5a}", "\u{1d5a}", "\u{1d5a}", "\u{26f}", "\u{26f}"),
        ("\u{1d5b}", "\u{1d5b}", "\u{1d5b}", "\u{76}", "\u{76}"), ("\u{1d5c}", "\u{1d5c}",
        "\u{1d5c}", "\u{1d25}", "\u{1d25}"), ("\u{1d5d}", "\u{1d5d}", "\u{1d5d}", "\u{3b2}",
        "\u{3b2}"), ("\u{1d5e}", "\u{1d5e}", "\u{1d5e}", "\u{3b3}", "\u{3b3}"), ("\u{1d5f}",
        "\u{1d5f}", "\u{1d5f}", "\u{3b4}", "\u{3b4}"), ("\u{1d60}", "\u{1d60}", "\u{1d60}",
        "\u{3c6}", "\u{3c6}"), ("\u{1d61}", "\u{1d61}", "\u{1d61}", "\u{3c7}", "\u{3c7}"),
        ("\u{1d62}", "\u{1d62}", "\u{1d62}", "\u{69}", "\u{69}"), ("\u{1d63}", "\u{1d63}",
        "\u{1d63}", "\u{72}", "\u{72}"), ("\u{1d64}", "\u{1d64}", "\u{1d64}", "\u{75}", "\u{75}"),
        ("\u{1d65}", "\u{1d65}", "\u{1d65}", "\u{76}", "\u{76}"), ("\u{1d66}", "\u{1d66}",
        "\u{1d66}", "\u{3b2}", "\u{3b2}"), ("\u{1d67}", "\u{1d67}", "\u{1d67}", "\u{3b3}",
        "\u{3b3}"), ("\u{1d68}", "\u{1d68}", "\u{1d68}", "\u{3c1}", "\u{3c1}"), ("\u{1d69}",
        "\u{1d69}", "\u{1d69}", "\u{3c6}", "\u{3c6}"), ("\u{1d6a}", "\u{1d6a}", "\u{1d6a}",
        "\u{3c7}", "\u{3c7}"), ("\u{1d78}", "\u{1d78}", "\u{1d78}", "\u{43d}", "\u{43d}"),
        ("\u{1d9b}", "\u{1d9b}", "\u{1d9b}", "\u{252}", "\u{252}"), ("\u{1d9c}", "\u{1d9c}",
        "\u{1d9c}", "\u{63}", "\u{63}"), ("\u{1d9d}", "\u{1d9d}", "\u{1d9d}", "\u{255}", "\u{255}"),
        ("\u{1d9e}", "\u{1d9e}", "\u{1d9e}", "\u{f0}", "\u{f0}"), ("\u{1d9f}", "\u{1d9f}",
        "\u{1d9f}", "\u{25c}", "\u{25c}"), ("\u{1da0}", "\u{1da0}", "\u{1da0}", "\u{66}", "\u{66}"),
        ("\u{1da1}", "\u{1da1}", "\u{1da1}", "\u{25f}", "\u{25f}"), ("\u{1da2}", "\u{1da2}",
        "\u{1da2}", "\u{261}", "\u{261}"), ("\u{1da3}", "\u{1da3}", "\u{1da3}", "\u{265}",
        "\u{265}"), ("\u{1da4}", "\u{1da4}", "\u{1da4}", "\u{268}", "\u{268}"), ("\u{1da5}",
        "\u{1da5}", "\u{1da5}", "\u{269}", "\u{269}"), ("\u{1da6}", "\u{1da6}", "\u{1da6}",
        "\u{26a}", "\u{26a}"), ("\u{1da7}", "\u{1da7}", "\u{1da7}", "\u{1d7b}", "\u{1d7b}"),
        ("\u{1da8}", "\u{1da8}", "\u{1da8}", "\u{29d}", "\u{29d}"), ("\u{1da9}", "\u{1da9}",
        "\u{1da9}", "\u{26d}", "\u{26d}"), ("\u{1daa}", "\u{1daa}", "\u{1daa}", "\u{1d85}",
        "\u{1d85}"), ("\u{1dab}", "\u{1dab}", "\u{1dab}", "\u{29f}", "\u{29f}"), ("\u{1dac}",
        "\u{1dac}", "\u{1dac}", "\u{271}", "\u{271}"), ("\u{1dad}", "\u{1dad}", "\u{1dad}",
        "\u{270}", "\u{270}"), ("\u{1dae}", "\u{1dae}", "\u{1dae}", "\u{272}", "\u{272}"),
        ("\u{1daf}", "\u{1daf}", "\u{1daf}", "\u{273}", "\u{273}"), ("\u{1db0}", "\u{1db0}",
        "\u{1db0}", "\u{274}", "\u{274}"), ("\u{1db1}", "\u{1db1}", "\u{1db1}", "\u{275}",
        "\u{275}"), ("\u{1db2}", "\u{1db2}", "\u{1db2}", "\u{278}", "\u{278}"), ("\u{1db3}",
        "\u{1db3}", "\u{1db3}", "\u{282}", "\u{282}"), ("\u{1db4}", "\u{1db4}", "\u{1db4}",
        "\u{283}", "\u{283}"), ("\u{1db5}", "\u{1db5}", "\u{1db5}", "\u{1ab}", "\u{1ab}"),
        ("\u{1db6}", "\u{1db6}", "\u{1db6}", "\u{289}", "\u{289}"), ("\u{1db7}", "\u{1db7}",
        "\u{1db7}", "\u{28a}", "\u{28a}"), ("\u{1db8}", "\u{1db8}", "\u{1db8}", "\u{1d1c}",
        "\u{1d1c}"), ("\u{1db9}", "\u{1db9}", "\u{1db9}", "\u{28b}", "\u{28b}"), ("\u{1dba}",
        "\u{1dba}", "\u{1dba}", "\u{28c}", "\u{28c}"), ("\u{1dbb}", "\u{1dbb}", "\u{1dbb}",
        "\u{7a}", "\u{7a}"), ("\u{1dbc}", "\u{1dbc}", "\u{1dbc}", "\u{290}", "\u{290}"),
        ("\u{1dbd}", "\u{1dbd}", "\u{1dbd}", "\u{291}", "\u{291}"), ("\u{1dbe}", "\u{1dbe}",
        "\u{1dbe}", "\u{292}", "\u{292}"), ("\u{1dbf}", "\u{1dbf}", "\u{1dbf}", "\u{3b8}",
        "\u{3b8}"), ("\u{1e00}", "\u{1e00}", "\u{41}\u{325}", "\u{1e00}", "\u{41}\u{325}"),
        ("\u{1e01}", "\u{1e01}", "\u{61}\u{325}", "\u{1e01}", "\u{61}\u{325}"), ("\u{1e02}",
        "\u{1e02}", "\u{42}\u{307}", "\u{1e02}", "\u{42}\u{307}"), ("\u{1e03}", "\u{1e03}",
        "\u{62}\u{307}", "\u{1e03}", "\u{62}\u{307}"), ("\u{1e04}", "\u{1e04}", "\u{42}\u{323}",
        "\u{1e04}", "\u{42}\u{323}"), ("\u{1e05}", "\u{1e05}", "\u{62}\u{323}", "\u{1e05}",
        "\u{62}\u{323}"), ("\u{1e06}", "\u{1e06}", "\u{42}\u{331}", "\u{1e06}", "\u{42}\u{331}"),
        ("\u{1e07}", "\u{1e07}", "\u{62}\u{331}", "\u{1e07}", "\u{62}\u{331}"), ("\u{1e08}",
        "\u{1e08}", "\u{43}\u{327}\u{301}", "\u{1e08}", "\u{43}\u{327}\u{301}"), ("\u{1e09}",
        "\u{1e09}", "\u{63}\u{327}\u{301}", "\u{1e09}", "\u{63}\u{327}\u{301}"), ("\u{1e0a}",
        "\u{1e0a}", "\u{44}\u{307}", "\u{1e0a}", "\u{44}\u{307}"), ("\u{1e0b}", "\u{1e0b}",
        "\u{64}\u{307}", "\u{1e0b}", "\u{64}\u{307}"), ("\u{1e0c}", "\u{1e0c}", "\u{44}\u{323}",
        "\u{1e0c}", "\u{44}\u{323}"), ("\u{1e0d}", "\u{1e0d}", "\u{64}\u{323}", "\u{1e0d}",
        "\u{64}\u{323}"), ("\u{1e0e}", "\u{1e0e}", "\u{44}\u{331}", "\u{1e0e}", "\u{44}\u{331}"),
        ("\u{1e0f}", "\u{1e0f}", "\u{64}\u{331}", "\u{1e0f}", "\u{64}\u{331}"), ("\u{1e10}",
        "\u{1e10}", "\u{44}\u{327}", "\u{1e10}", "\u{44}\u{327}"), ("\u{1e11}", "\u{1e11}",
        "\u{64}\u{327}", "\u{1e11}", "\u{64}\u{327}"), ("\u{1e12}", "\u{1e12}", "\u{44}\u{32d}",
        "\u{1e12}", "\u{44}\u{32d}"), ("\u{1e13}", "\u{1e13}", "\u{64}\u{32d}", "\u{1e13}",
        "\u{64}\u{32d}"), ("\u{1e14}", "\u{1e14}", "\u{45}\u{304}\u{300}", "\u{1e14}",
        "\u{45}\u{304}\u{300}"), ("\u{1e15}", "\u{1e15}", "\u{65}\u{304}\u{300}", "\u{1e15}",
        "\u{65}\u{304}\u{300}"), ("\u{1e16}", "\u{1e16}", "\u{45}\u{304}\u{301}", "\u{1e16}",
        "\u{45}\u{304}\u{301}"), ("\u{1e17}", "\u{1e17}", "\u{65}\u{304}\u{301}", "\u{1e17}",
        "\u{65}\u{304}\u{301}"), ("\u{1e18}", "\u{1e18}", "\u{45}\u{32d}", "\u{1e18}",
        "\u{45}\u{32d}"), ("\u{1e19}", "\u{1e19}", "\u{65}\u{32d}", "\u{1e19}", "\u{65}\u{32d}"),
        ("\u{1e1a}", "\u{1e1a}", "\u{45}\u{330}", "\u{1e1a}", "\u{45}\u{330}"), ("\u{1e1b}",
        "\u{1e1b}", "\u{65}\u{330}", "\u{1e1b}", "\u{65}\u{330}"), ("\u{1e1c}", "\u{1e1c}",
        "\u{45}\u{327}\u{306}", "\u{1e1c}", "\u{45}\u{327}\u{306}"), ("\u{1e1d}", "\u{1e1d}",
        "\u{65}\u{327}\u{306}", "\u{1e1d}", "\u{65}\u{327}\u{306}"), ("\u{1e1e}", "\u{1e1e}",
        "\u{46}\u{307}", "\u{1e1e}", "\u{46}\u{307}"), ("\u{1e1f}", "\u{1e1f}", "\u{66}\u{307}",
        "\u{1e1f}", "\u{66}\u{307}"), ("\u{1e20}", "\u{1e20}", "\u{47}\u{304}", "\u{1e20}",
        "\u{47}\u{304}"), ("\u{1e21}", "\u{1e21}", "\u{67}\u{304}", "\u{1e21}", "\u{67}\u{304}"),
        ("\u{1e22}", "\u{1e22}", "\u{48}\u{307}", "\u{1e22}", "\u{48}\u{307}"), ("\u{1e23}",
        "\u{1e23}", "\u{68}\u{307}", "\u{1e23}", "\u{68}\u{307}"), ("\u{1e24}", "\u{1e24}",
        "\u{48}\u{323}", "\u{1e24}", "\u{48}\u{323}"), ("\u{1e25}", "\u{1e25}", "\u{68}\u{323}",
        "\u{1e25}", "\u{68}\u{323}"), ("\u{1e26}", "\u{1e26}", "\u{48}\u{308}", "\u{1e26}",
        "\u{48}\u{308}"), ("\u{1e27}", "\u{1e27}", "\u{68}\u{308}", "\u{1e27}", "\u{68}\u{308}"),
        ("\u{1e28}", "\u{1e28}", "\u{48}\u{327}", "\u{1e28}", "\u{48}\u{327}"), ("\u{1e29}",
        "\u{1e29}", "\u{68}\u{327}", "\u{1e29}", "\u{68}\u{327}"), ("\u{1e2a}", "\u{1e2a}",
        "\u{48}\u{32e}", "\u{1e2a}", "\u{48}\u{32e}"), ("\u{1e2b}", "\u{1e2b}", "\u{68}\u{32e}",
        "\u{1e2b}", "\u{68}\u{32e}"), ("\u{1e2c}", "\u{1e2c}", "\u{49}\u{330}", "\u{1e2c}",
        "\u{49}\u{330}"), ("\u{1e2d}", "\u{1e2d}", "\u{69}\u{330}", "\u{1e2d}", "\u{69}\u{330}"),
        ("\u{1e2e}", "\u{1e2e}", "\u{49}\u{308}\u{301}", "\u{1e2e}", "\u{49}\u{308}\u{301}"),
        ("\u{1e2f}", "\u{1e2f}", "\u{69}\u{308}\u{301}", "\u{1e2f}", "\u{69}\u{308}\u{301}"),
        ("\u{1e30}", "\u{1e30}", "\u{4b}\u{301}", "\u{1e30}", "\u{4b}\u{301}"), ("\u{1e31}",
        "\u{1e31}", "\u{6b}\u{301}", "\u{1e31}", "\u{6b}\u{301}"), ("\u{1e32}", "\u{1e32}",
        "\u{4b}\u{323}", "\u{1e32}", "\u{4b}\u{323}"), ("\u{1e33}", "\u{1e33}", "\u{6b}\u{323}",
        "\u{1e33}", "\u{6b}\u{323}"), ("\u{1e34}", "\u{1e34}", "\u{4b}\u{331}", "\u{1e34}",
        "\u{4b}\u{331}"), ("\u{1e35}", "\u{1e35}", "\u{6b}\u{331}", "\u{1e35}", "\u{6b}\u{331}"),
        ("\u{1e36}", "\u{1e36}", "\u{4c}\u{323}", "\u{1e36}", "\u{4c}\u{323}"), ("\u{1e37}",
        "\u{1e37}", "\u{6c}\u{323}", "\u{1e37}", "\u{6c}\u{323}"), ("\u{1e38}", "\u{1e38}",
        "\u{4c}\u{323}\u{304}", "\u{1e38}", "\u{4c}\u{323}\u{304}"), ("\u{1e39}", "\u{1e39}",
        "\u{6c}\u{323}\u{304}", "\u{1e39}", "\u{6c}\u{323}\u{304}"), ("\u{1e3a}", "\u{1e3a}",
        "\u{4c}\u{331}", "\u{1e3a}", "\u{4c}\u{331}"), ("\u{1e3b}", "\u{1e3b}", "\u{6c}\u{331}",
        "\u{1e3b}", "\u{6c}\u{331}"), ("\u{1e3c}", "\u{1e3c}", "\u{4c}\u{32d}", "\u{1e3c}",
        "\u{4c}\u{32d}"), ("\u{1e3d}", "\u{1e3d}", "\u{6c}\u{32d}", "\u{1e3d}", "\u{6c}\u{32d}"),
        ("\u{1e3e}", "\u{1e3e}", "\u{4d}\u{301}", "\u{1e3e}", "\u{4d}\u{301}"), ("\u{1e3f}",
        "\u{1e3f}", "\u{6d}\u{301}", "\u{1e3f}", "\u{6d}\u{301}"), ("\u{1e40}", "\u{1e40}",
        "\u{4d}\u{307}", "\u{1e40}", "\u{4d}\u{307}"), ("\u{1e41}", "\u{1e41}", "\u{6d}\u{307}",
        "\u{1e41}", "\u{6d}\u{307}"), ("\u{1e42}", "\u{1e42}", "\u{4d}\u{323}", "\u{1e42}",
        "\u{4d}\u{323}"), ("\u{1e43}", "\u{1e43}", "\u{6d}\u{323}", "\u{1e43}", "\u{6d}\u{323}"),
        ("\u{1e44}", "\u{1e44}", "\u{4e}\u{307}", "\u{1e44}", "\u{4e}\u{307}"), ("\u{1e45}",
        "\u{1e45}", "\u{6e}\u{307}", "\u{1e45}", "\u{6e}\u{307}"), ("\u{1e46}", "\u{1e46}",
        "\u{4e}\u{323}", "\u{1e46}", "\u{4e}\u{323}"), ("\u{1e47}", "\u{1e47}", "\u{6e}\u{323}",
        "\u{1e47}", "\u{6e}\u{323}"), ("\u{1e48}", "\u{1e48}", "\u{4e}\u{331}", "\u{1e48}",
        "\u{4e}\u{331}"), ("\u{1e49}", "\u{1e49}", "\u{6e}\u{331}", "\u{1e49}", "\u{6e}\u{331}"),
        ("\u{1e4a}", "\u{1e4a}", "\u{4e}\u{32d}", "\u{1e4a}", "\u{4e}\u{32d}"), ("\u{1e4b}",
        "\u{1e4b}", "\u{6e}\u{32d}", "\u{1e4b}", "\u{6e}\u{32d}"), ("\u{1e4c}", "\u{1e4c}",
        "\u{4f}\u{303}\u{301}", "\u{1e4c}", "\u{4f}\u{303}\u{301}"), ("\u{1e4d}", "\u{1e4d}",
        "\u{6f}\u{303}\u{301}", "\u{1e4d}", "\u{6f}\u{303}\u{301}"), ("\u{1e4e}", "\u{1e4e}",
        "\u{4f}\u{303}\u{308}", "\u{1e4e}", "\u{4f}\u{303}\u{308}"), ("\u{1e4f}", "\u{1e4f}",
        "\u{6f}\u{303}\u{308}", "\u{1e4f}", "\u{6f}\u{303}\u{308}"), ("\u{1e50}", "\u{1e50}",
        "\u{4f}\u{304}\u{300}", "\u{1e50}", "\u{4f}\u{304}\u{300}"), ("\u{1e51}", "\u{1e51}",
        "\u{6f}\u{304}\u{300}", "\u{1e51}", "\u{6f}\u{304}\u{300}"), ("\u{1e52}", "\u{1e52}",
        "\u{4f}\u{304}\u{301}", "\u{1e52}", "\u{4f}\u{304}\u{301}"), ("\u{1e53}", "\u{1e53}",
        "\u{6f}\u{304}\u{301}", "\u{1e53}", "\u{6f}\u{304}\u{301}"), ("\u{1e54}", "\u{1e54}",
        "\u{50}\u{301}", "\u{1e54}", "\u{50}\u{301}"), ("\u{1e55}", "\u{1e55}", "\u{70}\u{301}",
        "\u{1e55}", "\u{70}\u{301}"), ("\u{1e56}", "\u{1e56}", "\u{50}\u{307}", "\u{1e56}",
        "\u{50}\u{307}"), ("\u{1e57}", "\u{1e57}", "\u{70}\u{307}", "\u{1e57}", "\u{70}\u{307}"),
        ("\u{1e58}", "\u{1e58}", "\u{52}\u{307}", "\u{1e58}", "\u{52}\u{307}"), ("\u{1e59}",
        "\u{1e59}", "\u{72}\u{307}", "\u{1e59}", "\u{72}\u{307}"), ("\u{1e5a}", "\u{1e5a}",
        "\u{52}\u{323}", "\u{1e5a}", "\u{52}\u{323}"), ("\u{1e5b}", "\u{1e5b}", "\u{72}\u{323}",
        "\u{1e5b}", "\u{72}\u{323}"), ("\u{1e5c}", "\u{1e5c}", "\u{52}\u{323}\u{304}", "\u{1e5c}",
        "\u{52}\u{323}\u{304}"), ("\u{1e5d}", "\u{1e5d}", "\u{72}\u{323}\u{304}", "\u{1e5d}",
        "\u{72}\u{323}\u{304}"), ("\u{1e5e}", "\u{1e5e}", "\u{52}\u{331}", "\u{1e5e}",
        "\u{52}\u{331}"), ("\u{1e5f}", "\u{1e5f}", "\u{72}\u{331}", "\u{1e5f}", "\u{72}\u{331}"),
        ("\u{1e60}", "\u{1e60}", "\u{53}\u{307}", "\u{1e60}", "\u{53}\u{307}"), ("\u{1e61}",
        "\u{1e61}", "\u{73}\u{307}", "\u{1e61}", "\u{73}\u{307}"), ("\u{1e62}", "\u{1e62}",
        "\u{53}\u{323}", "\u{1e62}", "\u{53}\u{323}"), ("\u{1e63}", "\u{1e63}", "\u{73}\u{323}",
        "\u{1e63}", "\u{73}\u{323}"), ("\u{1e64}", "\u{1e64}", "\u{53}\u{301}\u{307}", "\u{1e64}",
        "\u{53}\u{301}\u{307}"), ("\u{1e65}", "\u{1e65}", "\u{73}\u{301}\u{307}", "\u{1e65}",
        "\u{73}\u{301}\u{307}"), ("\u{1e66}", "\u{1e66}", "\u{53}\u{30c}\u{307}", "\u{1e66}",
        "\u{53}\u{30c}\u{307}"), ("\u{1e67}", "\u{1e67}", "\u{73}\u{30c}\u{307}", "\u{1e67}",
        "\u{73}\u{30c}\u{307}"), ("\u{1e68}", "\u{1e68}", "\u{53}\u{323}\u{307}", "\u{1e68}",
        "\u{53}\u{323}\u{307}"), ("\u{1e69}", "\u{1e69}", "\u{73}\u{323}\u{307}", "\u{1e69}",
        "\u{73}\u{323}\u{307}"), ("\u{1e6a}", "\u{1e6a}", "\u{54}\u{307}", "\u{1e6a}",
        "\u{54}\u{307}"), ("\u{1e6b}", "\u{1e6b}", "\u{74}\u{307}", "\u{1e6b}", "\u{74}\u{307}"),
        ("\u{1e6c}", "\u{1e6c}", "\u{54}\u{323}", "\u{1e6c}", "\u{54}\u{323}"), ("\u{1e6d}",
        "\u{1e6d}", "\u{74}\u{323}", "\u{1e6d}", "\u{74}\u{323}"), ("\u{1e6e}", "\u{1e6e}",
        "\u{54}\u{331}", "\u{1e6e}", "\u{54}\u{331}"), ("\u{1e6f}", "\u{1e6f}", "\u{74}\u{331}",
        "\u{1e6f}", "\u{74}\u{331}"), ("\u{1e70}", "\u{1e70}", "\u{54}\u{32d}", "\u{1e70}",
        "\u{54}\u{32d}"), ("\u{1e71}", "\u{1e71}", "\u{74}\u{32d}", "\u{1e71}", "\u{74}\u{32d}"),
        ("\u{1e72}", "\u{1e72}", "\u{55}\u{324}", "\u{1e72}", "\u{55}\u{324}"), ("\u{1e73}",
        "\u{1e73}", "\u{75}\u{324}", "\u{1e73}", "\u{75}\u{324}"), ("\u{1e74}", "\u{1e74}",
        "\u{55}\u{330}", "\u{1e74}", "\u{55}\u{330}"), ("\u{1e75}", "\u{1e75}", "\u{75}\u{330}",
        "\u{1e75}", "\u{75}\u{330}"), ("\u{1e76}", "\u{1e76}", "\u{55}\u{32d}", "\u{1e76}",
        "\u{55}\u{32d}"), ("\u{1e77}", "\u{1e77}", "\u{75}\u{32d}", "\u{1e77}", "\u{75}\u{32d}"),
        ("\u{1e78}", "\u{1e78}", "\u{55}\u{303}\u{301}", "\u{1e78}", "\u{55}\u{303}\u{301}"),
        ("\u{1e79}", "\u{1e79}", "\u{75}\u{303}\u{301}", "\u{1e79}", "\u{75}\u{303}\u{301}"),
        ("\u{1e7a}", "\u{1e7a}", "\u{55}\u{304}\u{308}", "\u{1e7a}", "\u{55}\u{304}\u{308}"),
        ("\u{1e7b}", "\u{1e7b}", "\u{75}\u{304}\u{308}", "\u{1e7b}", "\u{75}\u{304}\u{308}"),
        ("\u{1e7c}", "\u{1e7c}", "\u{56}\u{303}", "\u{1e7c}", "\u{56}\u{303}"), ("\u{1e7d}",
        "\u{1e7d}", "\u{76}\u{303}", "\u{1e7d}", "\u{76}\u{303}"), ("\u{1e7e}", "\u{1e7e}",
        "\u{56}\u{323}", "\u{1e7e}", "\u{56}\u{323}"), ("\u{1e7f}", "\u{1e7f}", "\u{76}\u{323}",
        "\u{1e7f}", "\u{76}\u{323}"), ("\u{1e80}", "\u{1e80}", "\u{57}\u{300}", "\u{1e80}",
        "\u{57}\u{300}"), ("\u{1e81}", "\u{1e81}", "\u{77}\u{300}", "\u{1e81}", "\u{77}\u{300}"),
        ("\u{1e82}", "\u{1e82}", "\u{57}\u{301}", "\u{1e82}", "\u{57}\u{301}"), ("\u{1e83}",
        "\u{1e83}", "\u{77}\u{301}", "\u{1e83}", "\u{77}\u{301}"), ("\u{1e84}", "\u{1e84}",
        "\u{57}\u{308}", "\u{1e84}", "\u{57}\u{308}"), ("\u{1e85}", "\u{1e85}", "\u{77}\u{308}",
        "\u{1e85}", "\u{77}\u{308}"), ("\u{1e86}", "\u{1e86}", "\u{57}\u{307}", "\u{1e86}",
        "\u{57}\u{307}"), ("\u{1e87}", "\u{1e87}", "\u{77}\u{307}", "\u{1e87}", "\u{77}\u{307}"),
        ("\u{1e88}", "\u{1e88}", "\u{57}\u{323}", "\u{1e88}", "\u{57}\u{323}"), ("\u{1e89}",
        "\u{1e89}", "\u{77}\u{323}", "\u{1e89}", "\u{77}\u{323}"), ("\u{1e8a}", "\u{1e8a}",
        "\u{58}\u{307}", "\u{1e8a}", "\u{58}\u{307}"), ("\u{1e8b}", "\u{1e8b}", "\u{78}\u{307}",
        "\u{1e8b}", "\u{78}\u{307}"), ("\u{1e8c}", "\u{1e8c}", "\u{58}\u{308}", "\u{1e8c}",
        "\u{58}\u{308}"), ("\u{1e8d}", "\u{1e8d}", "\u{78}\u{308}", "\u{1e8d}", "\u{78}\u{308}"),
        ("\u{1e8e}", "\u{1e8e}", "\u{59}\u{307}", "\u{1e8e}", "\u{59}\u{307}"), ("\u{1e8f}",
        "\u{1e8f}", "\u{79}\u{307}", "\u{1e8f}", "\u{79}\u{307}"), ("\u{1e90}", "\u{1e90}",
        "\u{5a}\u{302}", "\u{1e90}", "\u{5a}\u{302}"), ("\u{1e91}", "\u{1e91}", "\u{7a}\u{302}",
        "\u{1e91}", "\u{7a}\u{302}"), ("\u{1e92}", "\u{1e92}", "\u{5a}\u{323}", "\u{1e92}",
        "\u{5a}\u{323}"), ("\u{1e93}", "\u{1e93}", "\u{7a}\u{323}", "\u{1e93}", "\u{7a}\u{323}"),
        ("\u{1e94}", "\u{1e94}", "\u{5a}\u{331}", "\u{1e94}", "\u{5a}\u{331}"), ("\u{1e95}",
        "\u{1e95}", "\u{7a}\u{331}", "\u{1e95}", "\u{7a}\u{331}"), ("\u{1e96}", "\u{1e96}",
        "\u{68}\u{331}", "\u{1e96}", "\u{68}\u{331}"), ("\u{1e97}", "\u{1e97}", "\u{74}\u{308}",
        "\u{1e97}", "\u{74}\u{308}"), ("\u{1e98}", "\u{1e98}", "\u{77}\u{30a}", "\u{1e98}",
        "\u{77}\u{30a}"), ("\u{1e99}", "\u{1e99}", "\u{79}\u{30a}", "\u{1e99}", "\u{79}\u{30a}"),
        ("\u{1e9a}", "\u{1e9a}", "\u{1e9a}", "\u{61}\u{2be}", "\u{61}\u{2be}"), ("\u{1e9b}",
        "\u{1e9b}", "\u{17f}\u{307}", "\u{1e61}", "\u{73}\u{307}"), ("\u{1ea0}", "\u{1ea0}",
        "\u{41}\u{323}", "\u{1ea0}", "\u{41}\u{323}"), ("\u{1ea1}", "\u{1ea1}", "\u{61}\u{323}",
        "\u{1ea1}", "\u{61}\u{323}"), ("\u{1ea2}", "\u{1ea2}", "\u{41}\u{309}", "\u{1ea2}",
        "\u{41}\u{309}"), ("\u{1ea3}", "\u{1ea3}", "\u{61}\u{309}", "\u{1ea3}", "\u{61}\u{309}"),
        ("\u{1ea4}", "\u{1ea4}", "\u{41}\u{302}\u{301}", "\u{1ea4}", "\u{41}\u{302}\u{301}"),
        ("\u{1ea5}", "\u{1ea5}", "\u{61}\u{302}\u{301}", "\u{1ea5}", "\u{61}\u{302}\u{301}"),
        ("\u{1ea6}", "\u{1ea6}", "\u{41}\u{302}\u{300}", "\u{1ea6}", "\u{41}\u{302}\u{300}"),
        ("\u{1ea7}", "\u{1ea7}", "\u{61}\u{302}\u{300}", "\u{1ea7}", "\u{61}\u{302}\u{300}"),
        ("\u{1ea8}", "\u{1ea8}", "\u{41}\u{302}\u{309}", "\u{1ea8}", "\u{41}\u{302}\u{309}"),
        ("\u{1ea9}", "\u{1ea9}", "\u{61}\u{302}\u{309}", "\u{1ea9}", "\u{61}\u{302}\u{309}"),
        ("\u{1eaa}", "\u{1eaa}", "\u{41}\u{302}\u{303}", "\u{1eaa}", "\u{41}\u{302}\u{303}"),
        ("\u{1eab}", "\u{1eab}", "\u{61}\u{302}\u{303}", "\u{1eab}", "\u{61}\u{302}\u{303}"),
        ("\u{1eac}", "\u{1eac}", "\u{41}\u{323}\u{302}", "\u{1eac}", "\u{41}\u{323}\u{302}"),
        ("\u{1ead}", "\u{1ead}", "\u{61}\u{323}\u{302}", "\u{1ead}", "\u{61}\u{323}\u{302}"),
        ("\u{1eae}", "\u{1eae}", "\u{41}\u{306}\u{301}", "\u{1eae}", "\u{41}\u{306}\u{301}"),
        ("\u{1eaf}", "\u{1eaf}", "\u{61}\u{306}\u{301}", "\u{1eaf}", "\u{61}\u{306}\u{301}"),
        ("\u{1eb0}", "\u{1eb0}", "\u{41}\u{306}\u{300}", "\u{1eb0}", "\u{41}\u{306}\u{300}"),
        ("\u{1eb1}", "\u{1eb1}", "\u{61}\u{306}\u{300}", "\u{1eb1}", "\u{61}\u{306}\u{300}"),
        ("\u{1eb2}", "\u{1eb2}", "\u{41}\u{306}\u{309}", "\u{1eb2}", "\u{41}\u{306}\u{309}"),
        ("\u{1eb3}", "\u{1eb3}", "\u{61}\u{306}\u{309}", "\u{1eb3}", "\u{61}\u{306}\u{309}"),
        ("\u{1eb4}", "\u{1eb4}", "\u{41}\u{306}\u{303}", "\u{1eb4}", "\u{41}\u{306}\u{303}"),
        ("\u{1eb5}", "\u{1eb5}", "\u{61}\u{306}\u{303}", "\u{1eb5}", "\u{61}\u{306}\u{303}"),
        ("\u{1eb6}", "\u{1eb6}", "\u{41}\u{323}\u{306}", "\u{1eb6}", "\u{41}\u{323}\u{306}"),
        ("\u{1eb7}", "\u{1eb7}", "\u{61}\u{323}\u{306}", "\u{1eb7}", "\u{61}\u{323}\u{306}"),
        ("\u{1eb8}", "\u{1eb8}", "\u{45}\u{323}", "\u{1eb8}", "\u{45}\u{323}"), ("\u{1eb9}",
        "\u{1eb9}", "\u{65}\u{323}", "\u{1eb9}", "\u{65}\u{323}"), ("\u{1eba}", "\u{1eba}",
        "\u{45}\u{309}", "\u{1eba}", "\u{45}\u{309}"), ("\u{1ebb}", "\u{1ebb}", "\u{65}\u{309}",
        "\u{1ebb}", "\u{65}\u{309}"), ("\u{1ebc}", "\u{1ebc}", "\u{45}\u{303}", "\u{1ebc}",
        "\u{45}\u{303}"), ("\u{1ebd}", "\u{1ebd}", "\u{65}\u{303}", "\u{1ebd}", "\u{65}\u{303}"),
        ("\u{1ebe}", "\u{1ebe}", "\u{45}\u{302}\u{301}", "\u{1ebe}", "\u{45}\u{302}\u{301}"),
        ("\u{1ebf}", "\u{1ebf}", "\u{65}\u{302}\u{301}", "\u{1ebf}", "\u{65}\u{302}\u{301}"),
        ("\u{1ec0}", "\u{1ec0}", "\u{45}\u{302}\u{300}", "\u{1ec0}", "\u{45}\u{302}\u{300}"),
        ("\u{1ec1}", "\u{1ec1}", "\u{65}\u{302}\u{300}", "\u{1ec1}", "\u{65}\u{302}\u{300}"),
        ("\u{1ec2}", "\u{1ec2}", "\u{45}\u{302}\u{309}", "\u{1ec2}", "\u{45}\u{302}\u{309}"),
        ("\u{1ec3}", "\u{1ec3}", "\u{65}\u{302}\u{309}", "\u{1ec3}", "\u{65}\u{302}\u{309}"),
        ("\u{1ec4}", "\u{1ec4}", "\u{45}\u{302}\u{303}", "\u{1ec4}", "\u{45}\u{302}\u{303}"),
        ("\u{1ec5}", "\u{1ec5}", "\u{65}\u{302}\u{303}", "\u{1ec5}", "\u{65}\u{302}\u{303}"),
        ("\u{1ec6}", "\u{1ec6}", "\u{45}\u{323}\u{302}", "\u{1ec6}", "\u{45}\u{323}\u{302}"),
        ("\u{1ec7}", "\u{1ec7}", "\u{65}\u{323}\u{302}", "\u{1ec7}", "\u{65}\u{323}\u{302}"),
        ("\u{1ec8}", "\u{1ec8}", "\u{49}\u{309}", "\u{1ec8}", "\u{49}\u{309}"), ("\u{1ec9}",
        "\u{1ec9}", "\u{69}\u{309}", "\u{1ec9}", "\u{69}\u{309}"), ("\u{1eca}", "\u{1eca}",
        "\u{49}\u{323}", "\u{1eca}", "\u{49}\u{323}"), ("\u{1ecb}", "\u{1ecb}", "\u{69}\u{323}",
        "\u{1ecb}", "\u{69}\u{323}"), ("\u{1ecc}", "\u{1ecc}", "\u{4f}\u{323}", "\u{1ecc}",
        "\u{4f}\u{323}"), ("\u{1ecd}", "\u{1ecd}", "\u{6f}\u{323}", "\u{1ecd}", "\u{6f}\u{323}"),
        ("\u{1ece}", "\u{1ece}", "\u{4f}\u{309}", "\u{1ece}", "\u{4f}\u{309}"), ("\u{1ecf}",
        "\u{1ecf}", "\u{6f}\u{309}", "\u{1ecf}", "\u{6f}\u{309}"), ("\u{1ed0}", "\u{1ed0}",
        "\u{4f}\u{302}\u{301}", "\u{1ed0}", "\u{4f}\u{302}\u{301}"), ("\u{1ed1}", "\u{1ed1}",
        "\u{6f}\u{302}\u{301}", "\u{1ed1}", "\u{6f}\u{302}\u{301}"), ("\u{1ed2}", "\u{1ed2}",
        "\u{4f}\u{302}\u{300}", "\u{1ed2}", "\u{4f}\u{302}\u{300}"), ("\u{1ed3}", "\u{1ed3}",
        "\u{6f}\u{302}\u{300}", "\u{1ed3}", "\u{6f}\u{302}\u{300}"), ("\u{1ed4}", "\u{1ed4}",
        "\u{4f}\u{302}\u{309}", "\u{1ed4}", "\u{4f}\u{302}\u{309}"), ("\u{1ed5}", "\u{1ed5}",
        "\u{6f}\u{302}\u{309}", "\u{1ed5}", "\u{6f}\u{302}\u{309}"), ("\u{1ed6}", "\u{1ed6}",
        "\u{4f}\u{302}\u{303}", "\u{1ed6}", "\u{4f}\u{302}\u{303}"), ("\u{1ed7}", "\u{1ed7}",
        "\u{6f}\u{302}\u{303}", "\u{1ed7}", "\u{6f}\u{302}\u{303}"), ("\u{1ed8}", "\u{1ed8}",
        "\u{4f}\u{323}\u{302}", "\u{1ed8}", "\u{4f}\u{323}\u{302}"), ("\u{1ed9}", "\u{1ed9}",
        "\u{6f}\u{323}\u{302}", "\u{1ed9}", "\u{6f}\u{323}\u{302}"), ("\u{1eda}", "\u{1eda}",
        "\u{4f}\u{31b}\u{301}", "\u{1eda}", "\u{4f}\u{31b}\u{301}"), ("\u{1edb}", "\u{1edb}",
        "\u{6f}\u{31b}\u{301}", "\u{1edb}", "\u{6f}\u{31b}\u{301}"), ("\u{1edc}", "\u{1edc}",
        "\u{4f}\u{31b}\u{300}", "\u{1edc}", "\u{4f}\u{31b}\u{300}"), ("\u{1edd}", "\u{1edd}",
        "\u{6f}\u{31b}\u{300}", "\u{1edd}", "\u{6f}\u{31b}\u{300}"), ("\u{1ede}", "\u{1ede}",
        "\u{4f}\u{31b}\u{309}", "\u{1ede}", "\u{4f}\u{31b}\u{309}"), ("\u{1edf}", "\u{1edf}",
        "\u{6f}\u{31b}\u{309}", "\u{1edf}", "\u{6f}\u{31b}\u{309}"), ("\u{1ee0}", "\u{1ee0}",
        "\u{4f}\u{31b}\u{303}", "\u{1ee0}", "\u{4f}\u{31b}\u{303}"), ("\u{1ee1}", "\u{1ee1}",
        "\u{6f}\u{31b}\u{303}", "\u{1ee1}", "\u{6f}\u{31b}\u{303}"), ("\u{1ee2}", "\u{1ee2}",
        "\u{4f}\u{31b}\u{323}", "\u{1ee2}", "\u{4f}\u{31b}\u{323}"), ("\u{1ee3}", "\u{1ee3}",
        "\u{6f}\u{31b}\u{323}", "\u{1ee3}", "\u{6f}\u{31b}\u{323}"), ("\u{1ee4}", "\u{1ee4}",
        "\u{55}\u{323}", "\u{1ee4}", "\u{55}\u{323}"), ("\u{1ee5}", "\u{1ee5}", "\u{75}\u{323}",
        "\u{1ee5}", "\u{75}\u{323}"), ("\u{1ee6}", "\u{1ee6}", "\u{55}\u{309}", "\u{1ee6}",
        "\u{55}\u{309}"), ("\u{1ee7}", "\u{1ee7}", "\u{75}\u{309}", "\u{1ee7}", "\u{75}\u{309}"),
        ("\u{1ee8}", "\u{1ee8}", "\u{55}\u{31b}\u{301}", "\u{1ee8}", "\u{55}\u{31b}\u{301}"),
        ("\u{1ee9}", "\u{1ee9}", "\u{75}\u{31b}\u{301}", "\u{1ee9}", "\u{75}\u{31b}\u{301}"),
        ("\u{1eea}", "\u{1eea}", "\u{55}\u{31b}\u{300}", "\u{1eea}", "\u{55}\u{31b}\u{300}"),
        ("\u{1eeb}", "\u{1eeb}", "\u{75}\u{31b}\u{300}", "\u{1eeb}", "\u{75}\u{31b}\u{300}"),
        ("\u{1eec}", "\u{1eec}", "\u{55}\u{31b}\u{309}", "\u{1eec}", "\u{55}\u{31b}\u{309}"),
        ("\u{1eed}", "\u{1eed}", "\u{75}\u{31b}\u{309}", "\u{1eed}", "\u{75}\u{31b}\u{309}"),
        ("\u{1eee}", "\u{1eee}", "\u{55}\u{31b}\u{303}", "\u{1eee}", "\u{55}\u{31b}\u{303}"),
        ("\u{1eef}", "\u{1eef}", "\u{75}\u{31b}\u{303}", "\u{1eef}", "\u{75}\u{31b}\u{303}"),
        ("\u{1ef0}", "\u{1ef0}", "\u{55}\u{31b}\u{323}", "\u{1ef0}", "\u{55}\u{31b}\u{323}"),
        ("\u{1ef1}", "\u{1ef1}", "\u{75}\u{31b}\u{323}", "\u{1ef1}", "\u{75}\u{31b}\u{323}"),
        ("\u{1ef2}", "\u{1ef2}", "\u{59}\u{300}", "\u{1ef2}", "\u{59}\u{300}"), ("\u{1ef3}",
        "\u{1ef3}", "\u{79}\u{300}", "\u{1ef3}", "\u{79}\u{300}"), ("\u{1ef4}", "\u{1ef4}",
        "\u{59}\u{323}", "\u{1ef4}", "\u{59}\u{323}"), ("\u{1ef5}", "\u{1ef5}", "\u{79}\u{323}",
        "\u{1ef5}", "\u{79}\u{323}"), ("\u{1ef6}", "\u{1ef6}", "\u{59}\u{309}", "\u{1ef6}",
        "\u{59}\u{309}"), ("\u{1ef7}", "\u{1ef7}", "\u{79}\u{309}", "\u{1ef7}", "\u{79}\u{309}"),
        ("\u{1ef8}", "\u{1ef8}", "\u{59}\u{303}", "\u{1ef8}", "\u{59}\u{303}"), ("\u{1ef9}",
        "\u{1ef9}", "\u{79}\u{303}", "\u{1ef9}", "\u{79}\u{303}"), ("\u{1f00}", "\u{1f00}",
        "\u{3b1}\u{313}", "\u{1f00}", "\u{3b1}\u{313}"), ("\u{1f01}", "\u{1f01}", "\u{3b1}\u{314}",
        "\u{1f01}", "\u{3b1}\u{314}"), ("\u{1f02}", "\u{1f02}", "\u{3b1}\u{313}\u{300}", "\u{1f02}",
        "\u{3b1}\u{313}\u{300}"), ("\u{1f03}", "\u{1f03}", "\u{3b1}\u{314}\u{300}", "\u{1f03}",
        "\u{3b1}\u{314}\u{300}"), ("\u{1f04}", "\u{1f04}", "\u{3b1}\u{313}\u{301}", "\u{1f04}",
        "\u{3b1}\u{313}\u{301}"), ("\u{1f05}", "\u{1f05}", "\u{3b1}\u{314}\u{301}", "\u{1f05}",
        "\u{3b1}\u{314}\u{301}"), ("\u{1f06}", "\u{1f06}", "\u{3b1}\u{313}\u{342}", "\u{1f06}",
        "\u{3b1}\u{313}\u{342}"), ("\u{1f07}", "\u{1f07}", "\u{3b1}\u{314}\u{342}", "\u{1f07}",
        "\u{3b1}\u{314}\u{342}"), ("\u{1f08}", "\u{1f08}", "\u{391}\u{313}", "\u{1f08}",
        "\u{391}\u{313}"), ("\u{1f09}", "\u{1f09}", "\u{391}\u{314}", "\u{1f09}", "\u{391}\u{314}"),
        ("\u{1f0a}", "\u{1f0a}", "\u{391}\u{313}\u{300}", "\u{1f0a}", "\u{391}\u{313}\u{300}"),
        ("\u{1f0b}", "\u{1f0b}", "\u{391}\u{314}\u{300}", "\u{1f0b}", "\u{391}\u{314}\u{300}"),
        ("\u{1f0c}", "\u{1f0c}", "\u{391}\u{313}\u{301}", "\u{1f0c}", "\u{391}\u{313}\u{301}"),
        ("\u{1f0d}", "\u{1f0d}", "\u{391}\u{314}\u{301}", "\u{1f0d}", "\u{391}\u{314}\u{301}"),
        ("\u{1f0e}", "\u{1f0e}", "\u{391}\u{313}\u{342}", "\u{1f0e}", "\u{391}\u{313}\u{342}"),
        ("\u{1f0f}", "\u{1f0f}", "\u{391}\u{314}\u{342}", "\u{1f0f}", "\u{391}\u{314}\u{342}"),
        ("\u{1f10}", "\u{1f10}", "\u{3b5}\u{313}", "\u{1f10}", "\u{3b5}\u{313}"), ("\u{1f11}",
        "\u{1f11}", "\u{3b5}\u{314}", "\u{1f11}", "\u{3b5}\u{314}"), ("\u{1f12}", "\u{1f12}",
        "\u{3b5}\u{313}\u{300}", "\u{1f12}", "\u{3b5}\u{313}\u{300}"), ("\u{1f13}", "\u{1f13}",
        "\u{3b5}\u{314}\u{300}", "\u{1f13}", "\u{3b5}\u{314}\u{300}"), ("\u{1f14}", "\u{1f14}",
        "\u{3b5}\u{313}\u{301}", "\u{1f14}", "\u{3b5}\u{313}\u{301}"), ("\u{1f15}", "\u{1f15}",
        "\u{3b5}\u{314}\u{301}", "\u{1f15}", "\u{3b5}\u{314}\u{301}"), ("\u{1f18}", "\u{1f18}",
        "\u{395}\u{313}", "\u{1f18}", "\u{395}\u{313}"), ("\u{1f19}", "\u{1f19}", "\u{395}\u{314}",
        "\u{1f19}", "\u{395}\u{314}"), ("\u{1f1a}", "\u{1f1a}", "\u{395}\u{313}\u{300}", "\u{1f1a}",
        "\u{395}\u{313}\u{300}"), ("\u{1f1b}", "\u{1f1b}", "\u{395}\u{314}\u{300}", "\u{1f1b}",
        "\u{395}\u{314}\u{300}"), ("\u{1f1c}", "\u{1f1c}", "\u{395}\u{313}\u{301}", "\u{1f1c}",
        "\u{395}\u{313}\u{301}"), ("\u{1f1d}", "\u{1f1d}", "\u{395}\u{314}\u{301}", "\u{1f1d}",
        "\u{395}\u{314}\u{301}"), ("\u{1f20}", "\u{1f20}", "\u{3b7}\u{313}", "\u{1f20}",
        "\u{3b7}\u{313}"), ("\u{1f21}", "\u{1f21}", "\u{3b7}\u{314}", "\u{1f21}", "\u{3b7}\u{314}"),
        ("\u{1f22}", "\u{1f22}", "\u{3b7}\u{313}\u{300}", "\u{1f22}", "\u{3b7}\u{313}\u{300}"),
        ("\u{1f23}", "\u{1f23}", "\u{3b7}\u{314}\u{300}", "\u{1f23}", "\u{3b7}\u{314}\u{300}"),
        ("\u{1f24}", "\u{1f24}", "\u{3b7}\u{313}\u{301}", "\u{1f24}", "\u{3b7}\u{313}\u{301}"),
        ("\u{1f25}", "\u{1f25}", "\u{3b7}\u{314}\u{301}", "\u{1f25}", "\u{3b7}\u{314}\u{301}"),
        ("\u{1f26}", "\u{1f26}", "\u{3b7}\u{313}\u{342}", "\u{1f26}", "\u{3b7}\u{313}\u{342}"),
        ("\u{1f27}", "\u{1f27}", "\u{3b7}\u{314}\u{342}", "\u{1f27}", "\u{3b7}\u{314}\u{342}"),
        ("\u{1f28}", "\u{1f28}", "\u{397}\u{313}", "\u{1f28}", "\u{397}\u{313}"), ("\u{1f29}",
        "\u{1f29}", "\u{397}\u{314}", "\u{1f29}", "\u{397}\u{314}"), ("\u{1f2a}", "\u{1f2a}",
        "\u{397}\u{313}\u{300}", "\u{1f2a}", "\u{397}\u{313}\u{300}"), ("\u{1f2b}", "\u{1f2b}",
        "\u{397}\u{314}\u{300}", "\u{1f2b}", "\u{397}\u{314}\u{300}"), ("\u{1f2c}", "\u{1f2c}",
        "\u{397}\u{313}\u{301}", "\u{1f2c}", "\u{397}\u{313}\u{301}"), ("\u{1f2d}", "\u{1f2d}",
        "\u{397}\u{314}\u{301}", "\u{1f2d}", "\u{397}\u{314}\u{301}"), ("\u{1f2e}", "\u{1f2e}",
        "\u{397}\u{313}\u{342}", "\u{1f2e}", "\u{397}\u{313}\u{342}"), ("\u{1f2f}", "\u{1f2f}",
        "\u{397}\u{314}\u{342}", "\u{1f2f}", "\u{397}\u{314}\u{342}"), ("\u{1f30}", "\u{1f30}",
        "\u{3b9}\u{313}", "\u{1f30}", "\u{3b9}\u{313}"), ("\u{1f31}", "\u{1f31}", "\u{3b9}\u{314}",
        "\u{1f31}", "\u{3b9}\u{314}"), ("\u{1f32}", "\u{1f32}", "\u{3b9}\u{313}\u{300}", "\u{1f32}",
        "\u{3b9}\u{313}\u{300}"), ("\u{1f33}", "\u{1f33}", "\u{3b9}\u{314}\u{300}", "\u{1f33}",
        "\u{3b9}\u{314}\u{300}"), ("\u{1f34}", "\u{1f34}", "\u{3b9}\u{313}\u{301}", "\u{1f34}",
        "\u{3b9}\u{313}\u{301}"), ("\u{1f35}", "\u{1f35}", "\u{3b9}\u{314}\u{301}", "\u{1f35}",
        "\u{3b9}\u{314}\u{301}"), ("\u{1f36}", "\u{1f36}", "\u{3b9}\u{313}\u{342}", "\u{1f36}",
        "\u{3b9}\u{313}\u{342}"), ("\u{1f37}", "\u{1f37}", "\u{3b9}\u{314}\u{342}", "\u{1f37}",
        "\u{3b9}\u{314}\u{342}"), ("\u{1f38}", "\u{1f38}", "\u{399}\u{313}", "\u{1f38}",
        "\u{399}\u{313}"), ("\u{1f39}", "\u{1f39}", "\u{399}\u{314}", "\u{1f39}", "\u{399}\u{314}"),
        ("\u{1f3a}", "\u{1f3a}", "\u{399}\u{313}\u{300}", "\u{1f3a}", "\u{399}\u{313}\u{300}"),
        ("\u{1f3b}", "\u{1f3b}", "\u{399}\u{314}\u{300}", "\u{1f3b}", "\u{399}\u{314}\u{300}"),
        ("\u{1f3c}", "\u{1f3c}", "\u{399}\u{313}\u{301}", "\u{1f3c}", "\u{399}\u{313}\u{301}"),
        ("\u{1f3d}", "\u{1f3d}", "\u{399}\u{314}\u{301}", "\u{1f3d}", "\u{399}\u{314}\u{301}"),
        ("\u{1f3e}", "\u{1f3e}", "\u{399}\u{313}\u{342}", "\u{1f3e}", "\u{399}\u{313}\u{342}"),
        ("\u{1f3f}", "\u{1f3f}", "\u{399}\u{314}\u{342}", "\u{1f3f}", "\u{399}\u{314}\u{342}"),
        ("\u{1f40}", "\u{1f40}", "\u{3bf}\u{313}", "\u{1f40}", "\u{3bf}\u{313}"), ("\u{1f41}",
        "\u{1f41}", "\u{3bf}\u{314}", "\u{1f41}", "\u{3bf}\u{314}"), ("\u{1f42}", "\u{1f42}",
        "\u{3bf}\u{313}\u{300}", "\u{1f42}", "\u{3bf}\u{313}\u{300}"), ("\u{1f43}", "\u{1f43}",
        "\u{3bf}\u{314}\u{300}", "\u{1f43}", "\u{3bf}\u{314}\u{300}"), ("\u{1f44}", "\u{1f44}",
        "\u{3bf}\u{313}\u{301}", "\u{1f44}", "\u{3bf}\u{313}\u{301}"), ("\u{1f45}", "\u{1f45}",
        "\u{3bf}\u{314}\u{301}", "\u{1f45}", "\u{3bf}\u{314}\u{301}"), ("\u{1f48}", "\u{1f48}",
        "\u{39f}\u{313}", "\u{1f48}", "\u{39f}\u{313}"), ("\u{1f49}", "\u{1f49}", "\u{39f}\u{314}",
        "\u{1f49}", "\u{39f}\u{314}"), ("\u{1f4a}", "\u{1f4a}", "\u{39f}\u{313}\u{300}", "\u{1f4a}",
        "\u{39f}\u{313}\u{300}"), ("\u{1f4b}", "\u{1f4b}", "\u{39f}\u{314}\u{300}", "\u{1f4b}",
        "\u{39f}\u{314}\u{300}"), ("\u{1f4c}", "\u{1f4c}", "\u{39f}\u{313}\u{301}", "\u{1f4c}",
        "\u{39f}\u{313}\u{301}"), ("\u{1f4d}", "\u{1f4d}", "\u{39f}\u{314}\u{301}", "\u{1f4d}",
        "\u{39f}\u{314}\u{301}"), ("\u{1f50}", "\u{1f50}", "\u{3c5}\u{313}", "\u{1f50}",
        "\u{3c5}\u{313}"), ("\u{1f51}", "\u{1f51}", "\u{3c5}\u{314}", "\u{1f51}", "\u{3c5}\u{314}"),
        ("\u{1f52}", "\u{1f52}", "\u{3c5}\u{313}\u{300}", "\u{1f52}", "\u{3c5}\u{313}\u{300}"),
        ("\u{1f53}", "\u{1f53}", "\u{3c5}\u{314}\u{300}", "\u{1f53}", "\u{3c5}\u{314}\u{300}"),
        ("\u{1f54}", "\u{1f54}", "\u{3c5}\u{313}\u{301}", "\u{1f54}", "\u{3c5}\u{313}\u{301}"),
        ("\u{1f55}", "\u{1f55}", "\u{3c5}\u{314}\u{301}", "\u{1f55}", "\u{3c5}\u{314}\u{301}"),
        ("\u{1f56}", "\u{1f56}", "\u{3c5}\u{313}\u{342}", "\u{1f56}", "\u{3c5}\u{313}\u{342}"),
        ("\u{1f57}", "\u{1f57}", "\u{3c5}\u{314}\u{342}", "\u{1f57}", "\u{3c5}\u{314}\u{342}"),
        ("\u{1f59}", "\u{1f59}", "\u{3a5}\u{314}", "\u{1f59}", "\u{3a5}\u{314}"), ("\u{1f5b}",
        "\u{1f5b}", "\u{3a5}\u{314}\u{300}", "\u{1f5b}", "\u{3a5}\u{314}\u{300}"), ("\u{1f5d}",
        "\u{1f5d}", "\u{3a5}\u{314}\u{301}", "\u{1f5d}", "\u{3a5}\u{314}\u{301}"), ("\u{1f5f}",
        "\u{1f5f}", "\u{3a5}\u{314}\u{342}", "\u{1f5f}", "\u{3a5}\u{314}\u{342}"), ("\u{1f60}",
        "\u{1f60}", "\u{3c9}\u{313}", "\u{1f60}", "\u{3c9}\u{313}"), ("\u{1f61}", "\u{1f61}",
        "\u{3c9}\u{314}", "\u{1f61}", "\u{3c9}\u{314}"), ("\u{1f62}", "\u{1f62}",
        "\u{3c9}\u{313}\u{300}", "\u{1f62}", "\u{3c9}\u{313}\u{300}"), ("\u{1f63}", "\u{1f63}",
        "\u{3c9}\u{314}\u{300}", "\u{1f63}", "\u{3c9}\u{314}\u{300}"), ("\u{1f64}", "\u{1f64}",
        "\u{3c9}\u{313}\u{301}", "\u{1f64}", "\u{3c9}\u{313}\u{301}"), ("\u{1f65}", "\u{1f65}",
        "\u{3c9}\u{314}\u{301}", "\u{1f65}", "\u{3c9}\u{314}\u{301}"), ("\u{1f66}", "\u{1f66}",
        "\u{3c9}\u{313}\u{342}", "\u{1f66}", "\u{3c9}\u{313}\u{342}"), ("\u{1f67}", "\u{1f67}",
        "\u{3c9}\u{314}\u{342}", "\u{1f67}", "\u{3c9}\u{314}\u{342}"), ("\u{1f68}", "\u{1f68}",
        "\u{3a9}\u{313}", "\u{1f68}", "\u{3a9}\u{313}"), ("\u{1f69}", "\u{1f69}", "\u{3a9}\u{314}",
        "\u{1f69}", "\u{3a9}\u{314}"), ("\u{1f6a}", "\u{1f6a}", "\u{3a9}\u{313}\u{300}", "\u{1f6a}",
        "\u{3a9}\u{313}\u{300}"), ("\u{1f6b}", "\u{1f6b}", "\u{3a9}\u{314}\u{300}", "\u{1f6b}",
        "\u{3a9}\u{314}\u{300}"), ("\u{1f6c}", "\u{1f6c}", "\u{3a9}\u{313}\u{301}", "\u{1f6c}",
        "\u{3a9}\u{313}\u{301}"), ("\u{1f6d}", "\u{1f6d}", "\u{3a9}\u{314}\u{301}", "\u{1f6d}",
        "\u{3a9}\u{314}\u{301}"), ("\u{1f6e}", "\u{1f6e}", "\u{3a9}\u{313}\u{342}", "\u{1f6e}",
        "\u{3a9}\u{313}\u{342}"), ("\u{1f6f}", "\u{1f6f}", "\u{3a9}\u{314}\u{342}", "\u{1f6f}",
        "\u{3a9}\u{314}\u{342}"), ("\u{1f70}", "\u{1f70}", "\u{3b1}\u{300}", "\u{1f70}",
        "\u{3b1}\u{300}"), ("\u{1f71}", "\u{3ac}", "\u{3b1}\u{301}", "\u{3ac}", "\u{3b1}\u{301}"),
        ("\u{1f72}", "\u{1f72}", "\u{3b5}\u{300}", "\u{1f72}", "\u{3b5}\u{300}"), ("\u{1f73}",
        "\u{3ad}", "\u{3b5}\u{301}", "\u{3ad}", "\u{3b5}\u{301}"), ("\u{1f74}", "\u{1f74}",
        "\u{3b7}\u{300}", "\u{1f74}", "\u{3b7}\u{300}"), ("\u{1f75}", "\u{3ae}", "\u{3b7}\u{301}",
        "\u{3ae}", "\u{3b7}\u{301}"), ("\u{1f76}", "\u{1f76}", "\u{3b9}\u{300}", "\u{1f76}",
        "\u{3b9}\u{300}"), ("\u{1f77}", "\u{3af}", "\u{3b9}\u{301}", "\u{3af}", "\u{3b9}\u{301}"),
        ("\u{1f78}", "\u{1f78}", "\u{3bf}\u{300}", "\u{1f78}", "\u{3bf}\u{300}"), ("\u{1f79}",
        "\u{3cc}", "\u{3bf}\u{301}", "\u{3cc}", "\u{3bf}\u{301}"), ("\u{1f7a}", "\u{1f7a}",
        "\u{3c5}\u{300}", "\u{1f7a}", "\u{3c5}\u{300}"), ("\u{1f7b}", "\u{3cd}", "\u{3c5}\u{301}",
        "\u{3cd}", "\u{3c5}\u{301}"), ("\u{1f7c}", "\u{1f7c}", "\u{3c9}\u{300}", "\u{1f7c}",
        "\u{3c9}\u{300}"), ("\u{1f7d}", "\u{3ce}", "\u{3c9}\u{301}", "\u{3ce}", "\u{3c9}\u{301}"),
        ("\u{1f80}", "\u{1f80}", "\u{3b1}\u{313}\u{345}", "\u{1f80}", "\u{3b1}\u{313}\u{345}"),
        ("\u{1f81}", "\u{1f81}", "\u{3b1}\u{314}\u{345}", "\u{1f81}", "\u{3b1}\u{314}\u{345}"),
        ("\u{1f82}", "\u{1f82}", "\u{3b1}\u{313}\u{300}\u{345}", "\u{1f82}",
        "\u{3b1}\u{313}\u{300}\u{345}"), ("\u{1f83}", "\u{1f83}", "\u{3b1}\u{314}\u{300}\u{345}",
        "\u{1f83}", "\u{3b1}\u{314}\u{300}\u{345}"), ("\u{1f84}", "\u{1f84}",
        "\u{3b1}\u{313}\u{301}\u{345}", "\u{1f84}", "\u{3b1}\u{313}\u{301}\u{345}"), ("\u{1f85}",
        "\u{1f85}", "\u{3b1}\u{314}\u{301}\u{345}", "\u{1f85}", "\u{3b1}\u{314}\u{301}\u{345}"),
        ("\u{1f86}", "\u{1f86}", "\u{3b1}\u{313}\u{342}\u{345}", "\u{1f86}",
        "\u{3b1}\u{313}\u{342}\u{345}"), ("\u{1f87}", "\u{1f87}", "\u{3b1}\u{314}\u{342}\u{345}",
        "\u{1f87}", "\u{3b1}\u{314}\u{342}\u{345}"), ("\u{1f88}", "\u{1f88}",
        "\u{391}\u{313}\u{345}", "\u{1f88}", "\u{391}\u{313}\u{345}"), ("\u{1f89}", "\u{1f89}",
        "\u{391}\u{314}\u{345}", "\u{1f89}", "\u{391}\u{314}\u{345}"), ("\u{1f8a}", "\u{1f8a}",
        "\u{391}\u{313}\u{300}\u{345}", "\u{1f8a}", "\u{391}\u{313}\u{300}\u{345}"), ("\u{1f8b}",
        "\u{1f8b}", "\u{391}\u{314}\u{300}\u{345}", "\u{1f8b}", "\u{391}\u{314}\u{300}\u{345}"),
        ("\u{1f8c}", "\u{1f8c}", "\u{391}\u{313}\u{301}\u{345}", "\u{1f8c}",
        "\u{391}\u{313}\u{301}\u{345}"), ("\u{1f8d}", "\u{1f8d}", "\u{391}\u{314}\u{301}\u{345}",
        "\u{1f8d}", "\u{391}\u{314}\u{301}\u{345}"), ("\u{1f8e}", "\u{1f8e}",
        "\u{391}\u{313}\u{342}\u{345}", "\u{1f8e}", "\u{391}\u{313}\u{342}\u{345}"), ("\u{1f8f}",
        "\u{1f8f}", "\u{391}\u{314}\u{342}\u{345}", "\u{1f8f}", "\u{391}\u{314}\u{342}\u{345}"),
        ("\u{1f90}", "\u{1f90}", "\u{3b7}\u{313}\u{345}", "\u{1f90}", "\u{3b7}\u{313}\u{345}"),
        ("\u{1f91}", "\u{1f91}", "\u{3b7}\u{314}\u{345}", "\u{1f91}", "\u{3b7}\u{314}\u{345}"),
        ("\u{1f92}", "\u{1f92}", "\u{3b7}\u{313}\u{300}\u{345}", "\u{1f92}",
        "\u{3b7}\u{313}\u{300}\u{345}"), ("\u{1f93}", "\u{1f93}", "\u{3b7}\u{314}\u{300}\u{345}",
        "\u{1f93}", "\u{3b7}\u{314}\u{300}\u{345}"), ("\u{1f94}", "\u{1f94}",
        "\u{3b7}\u{313}\u{301}\u{345}", "\u{1f94}", "\u{3b7}\u{313}\u{301}\u{345}"), ("\u{1f95}",
        "\u{1f95}", "\u{3b7}\u{314}\u{301}\u{345}", "\u{1f95}", "\u{3b7}\u{314}\u{301}\u{345}"),
        ("\u{1f96}", "\u{1f96}", "\u{3b7}\u{313}\u{342}\u{345}", "\u{1f96}",
        "\u{3b7}\u{313}\u{342}\u{345}"), ("\u{1f97}", "\u{1f97}", "\u{3b7}\u{314}\u{342}\u{345}",
        "\u{1f97}", "\u{3b7}\u{314}\u{342}\u{345}"), ("\u{1f98}", "\u{1f98}",
        "\u{397}\u{313}\u{345}", "\u{1f98}", "\u{397}\u{313}\u{345}"), ("\u{1f99}", "\u{1f99}",
        "\u{397}\u{314}\u{345}", "\u{1f99}", "\u{397}\u{314}\u{345}"), ("\u{1f9a}", "\u{1f9a}",
        "\u{397}\u{313}\u{300}\u{345}", "\u{1f9a}", "\u{397}\u{313}\u{300}\u{345}"), ("\u{1f9b}",
        "\u{1f9b}", "\u{397}\u{314}\u{300}\u{345}", "\u{1f9b}", "\u{397}\u{314}\u{300}\u{345}"),
        ("\u{1f9c}", "\u{1f9c}", "\u{397}\u{313}\u{301}\u{345}", "\u{1f9c}",
        "\u{397}\u{313}\u{301}\u{345}"), ("\u{1f9d}", "\u{1f9d}", "\u{397}\u{314}\u{301}\u{345}",
        "\u{1f9d}", "\u{397}\u{314}\u{301}\u{345}"), ("\u{1f9e}", "\u{1f9e}",
        "\u{397}\u{313}\u{342}\u{345}", "\u{1f9e}", "\u{397}\u{313}\u{342}\u{345}"), ("\u{1f9f}",
        "\u{1f9f}", "\u{397}\u{314}\u{342}\u{345}", "\u{1f9f}", "\u{397}\u{314}\u{342}\u{345}"),
        ("\u{1fa0}", "\u{1fa0}", "\u{3c9}\u{313}\u{345}", "\u{1fa0}", "\u{3c9}\u{313}\u{345}"),
        ("\u{1fa1}", "\u{1fa1}", "\u{3c9}\u{314}\u{345}", "\u{1fa1}", "\u{3c9}\u{314}\u{345}"),
        ("\u{1fa2}", "\u{1fa2}", "\u{3c9}\u{313}\u{300}\u{345}", "\u{1fa2}",
        "\u{3c9}\u{313}\u{300}\u{345}"), ("\u{1fa3}", "\u{1fa3}", "\u{3c9}\u{314}\u{300}\u{345}",
        "\u{1fa3}", "\u{3c9}\u{314}\u{300}\u{345}"), ("\u{1fa4}", "\u{1fa4}",
        "\u{3c9}\u{313}\u{301}\u{345}", "\u{1fa4}", "\u{3c9}\u{313}\u{301}\u{345}"), ("\u{1fa5}",
        "\u{1fa5}", "\u{3c9}\u{314}\u{301}\u{345}", "\u{1fa5}", "\u{3c9}\u{314}\u{301}\u{345}"),
        ("\u{1fa6}", "\u{1fa6}", "\u{3c9}\u{313}\u{342}\u{345}", "\u{1fa6}",
        "\u{3c9}\u{313}\u{342}\u{345}"), ("\u{1fa7}", "\u{1fa7}", "\u{3c9}\u{314}\u{342}\u{345}",
        "\u{1fa7}", "\u{3c9}\u{314}\u{342}\u{345}"), ("\u{1fa8}", "\u{1fa8}",
        "\u{3a9}\u{313}\u{345}", "\u{1fa8}", "\u{3a9}\u{313}\u{345}"), ("\u{1fa9}", "\u{1fa9}",
        "\u{3a9}\u{314}\u{345}", "\u{1fa9}", "\u{3a9}\u{314}\u{345}"), ("\u{1faa}", "\u{1faa}",
        "\u{3a9}\u{313}\u{300}\u{345}", "\u{1faa}", "\u{3a9}\u{313}\u{300}\u{345}"), ("\u{1fab}",
        "\u{1fab}", "\u{3a9}\u{314}\u{300}\u{345}", "\u{1fab}", "\u{3a9}\u{314}\u{300}\u{345}"),
        ("\u{1fac}", "\u{1fac}", "\u{3a9}\u{313}\u{301}\u{345}", "\u{1fac}",
        "\u{3a9}\u{313}\u{301}\u{345}"), ("\u{1fad}", "\u{1fad}", "\u{3a9}\u{314}\u{301}\u{345}",
        "\u{1fad}", "\u{3a9}\u{314}\u{301}\u{345}"), ("\u{1fae}", "\u{1fae}",
        "\u{3a9}\u{313}\u{342}\u{345}", "\u{1fae}", "\u{3a9}\u{313}\u{342}\u{345}"), ("\u{1faf}",
        "\u{1faf}", "\u{3a9}\u{314}\u{342}\u{345}", "\u{1faf}", "\u{3a9}\u{314}\u{342}\u{345}"),
        ("\u{1fb0}", "\u{1fb0}", "\u{3b1}\u{306}", "\u{1fb0}", "\u{3b1}\u{306}"), ("\u{1fb1}",
        "\u{1fb1}", "\u{3b1}\u{304}", "\u{1fb1}", "\u{3b1}\u{304}"), ("\u{1fb2}", "\u{1fb2}",
        "\u{3b1}\u{300}\u{345}", "\u{1fb2}", "\u{3b1}\u{300}\u{345}"), ("\u{1fb3}", "\u{1fb3}",
        "\u{3b1}\u{345}", "\u{1fb3}", "\u{3b1}\u{345}"), ("\u{1fb4}", "\u{1fb4}",
        "\u{3b1}\u{301}\u{345}", "\u{1fb4}", "\u{3b1}\u{301}\u{345}"), ("\u{1fb6}", "\u{1fb6}",
        "\u{3b1}\u{342}", "\u{1fb6}", "\u{3b1}\u{342}"), ("\u{1fb7}", "\u{1fb7}",
        "\u{3b1}\u{342}\u{345}", "\u{1fb7}", "\u{3b1}\u{342}\u{345}"), ("\u{1fb8}", "\u{1fb8}",
        "\u{391}\u{306}", "\u{1fb8}", "\u{391}\u{306}"), ("\u{1fb9}", "\u{1fb9}", "\u{391}\u{304}",
        "\u{1fb9}", "\u{391}\u{304}"), ("\u{1fba}", "\u{1fba}", "\u{391}\u{300}", "\u{1fba}",
        "\u{391}\u{300}"), ("\u{1fbb}", "\u{386}", "\u{391}\u{301}", "\u{386}", "\u{391}\u{301}"),
        ("\u{1fbc}", "\u{1fbc}", "\u{391}\u{345}", "\u{1fbc}", "\u{391}\u{345}"), ("\u{1fbd}",
        "\u{1fbd}", "\u{1fbd}", "\u{20}\u{313}", "\u{20}\u{313}"), ("\u{1fbe}", "\u{3b9}",
        "\u{3b9}", "\u{3b9}", "\u{3b9}"), ("\u{1fbf}", "\u{1fbf}", "\u{1fbf}", "\u{20}\u{313}",
        "\u{20}\u{313}"), ("\u{1fc0}", "\u{1fc0}", "\u{1fc0}", "\u{20}\u{342}", "\u{20}\u{342}"),
        ("\u{1fc1}", "\u{1fc1}", "\u{a8}\u{342}", "\u{20}\u{308}\u{342}", "\u{20}\u{308}\u{342}"),
        ("\u{1fc2}", "\u{1fc2}", "\u{3b7}\u{300}\u{345}", "\u{1fc2}", "\u{3b7}\u{300}\u{345}"),
        ("\u{1fc3}", "\u{1fc3}", "\u{3b7}\u{345}", "\u{1fc3}", "\u{3b7}\u{345}"), ("\u{1fc4}",
        "\u{1fc4}", "\u{3b7}\u{301}\u{345}", "\u{1fc4}", "\u{3b7}\u{301}\u{345}"), ("\u{1fc6}",
        "\u{1fc6}", "\u{3b7}\u{342}", "\u{1fc6}", "\u{3b7}\u{342}"), ("\u{1fc7}", "\u{1fc7}",
        "\u{3b7}\u{342}\u{345}", "\u{1fc7}", "\u{3b7}\u{342}\u{345}"), ("\u{1fc8}", "\u{1fc8}",
        "\u{395}\u{300}", "\u{1fc8}", "\u{395}\u{300}"), ("\u{1fc9}", "\u{388}", "\u{395}\u{301}",
        "\u{388}", "\u{395}\u{301}"), ("\u{1fca}", "\u{1fca}", "\u{397}\u{300}", "\u{1fca}",
        "\u{397}\u{300}"), ("\u{1fcb}", "\u{389}", "\u{397}\u{301}", "\u{389}", "\u{397}\u{301}"),
        ("\u{1fcc}", "\u{1fcc}", "\u{397}\u{345}", "\u{1fcc}", "\u{397}\u{345}"), ("\u{1fcd}",
        "\u{1fcd}", "\u{1fbf}\u{300}", "\u{20}\u{313}\u{300}", "\u{20}\u{313}\u{300}"), ("\u{1fce}",
        "\u{1fce}", "\u{1fbf}\u{301}", "\u{20}\u{313}\u{301}", "\u{20}\u{313}\u{301}"), ("\u{1fcf}",
        "\u{1fcf}", "\u{1fbf}\u{342}", "\u{20}\u{313}\u{342}", "\u{20}\u{313}\u{342}"), ("\u{1fd0}",
        "\u{1fd0}", "\u{3b9}\u{306}", "\u{1fd0}", "\u{3b9}\u{306}"), ("\u{1fd1}", "\u{1fd1}",
        "\u{3b9}\u{304}", "\u{1fd1}", "\u{3b9}\u{304}"), ("\u{1fd2}", "\u{1fd2}",
        "\u{3b9}\u{308}\u{300}", "\u{1fd2}", "\u{3b9}\u{308}\u{300}"), ("\u{1fd3}", "\u{390}",
        "\u{3b9}\u{308}\u{301}", "\u{390}", "\u{3b9}\u{308}\u{301}"), ("\u{1fd6}", "\u{1fd6}",
        "\u{3b9}\u{342}", "\u{1fd6}", "\u{3b9}\u{342}"), ("\u{1fd7}", "\u{1fd7}",
        "\u{3b9}\u{308}\u{342}", "\u{1fd7}", "\u{3b9}\u{308}\u{342}"), ("\u{1fd8}", "\u{1fd8}",
        "\u{399}\u{306}", "\u{1fd8}", "\u{399}\u{306}"), ("\u{1fd9}", "\u{1fd9}", "\u{399}\u{304}",
        "\u{1fd9}", "\u{399}\u{304}"), ("\u{1fda}", "\u{1fda}", "\u{399}\u{300}", "\u{1fda}",
        "\u{399}\u{300}"), ("\u{1fdb}", "\u{38a}", "\u{399}\u{301}", "\u{38a}", "\u{399}\u{301}"),
        ("\u{1fdd}", "\u{1fdd}", "\u{1ffe}\u{300}", "\u{20}\u{314}\u{300}", "\u{20}\u{314}\u{300}"),
        ("\u{1fde}", "\u{1fde}", "\u{1ffe}\u{301}", "\u{20}\u{314}\u{301}", "\u{20}\u{314}\u{301}"),
        ("\u{1fdf}", "\u{1fdf}", "\u{1ffe}\u{342}", "\u{20}\u{314}\u{342}", "\u{20}\u{314}\u{342}"),
        ("\u{1fe0}", "\u{1fe0}", "\u{3c5}\u{306}", "\u{1fe0}", "\u{3c5}\u{306}"), ("\u{1fe1}",
        "\u{1fe1}", "\u{3c5}\u{304}", "\u{1fe1}", "\u{3c5}\u{304}"), ("\u{1fe2}", "\u{1fe2}",
        "\u{3c5}\u{308}\u{300}", "\u{1fe2}", "\u{3c5}\u{308}\u{300}"), ("\u{1fe3}", "\u{3b0}",
        "\u{3c5}\u{308}\u{301}", "\u{3b0}", "\u{3c5}\u{308}\u{301}"), ("\u{1fe4}", "\u{1fe4}",
        "\u{3c1}\u{313}", "\u{1fe4}", "\u{3c1}\u{313}"), ("\u{1fe5}", "\u{1fe5}", "\u{3c1}\u{314}",
        "\u{1fe5}", "\u{3c1}\u{314}"), ("\u{1fe6}", "\u{1fe6}", "\u{3c5}\u{342}", "\u{1fe6}",
        "\u{3c5}\u{342}"), ("\u{1fe7}", "\u{1fe7}", "\u{3c5}\u{308}\u{342}", "\u{1fe7}",
        "\u{3c5}\u{308}\u{342}"), ("\u{1fe8}", "\u{1fe8}", "\u{3a5}\u{306}", "\u{1fe8}",
        "\u{3a5}\u{306}"), ("\u{1fe9}", "\u{1fe9}", "\u{3a5}\u{304}", "\u{1fe9}", "\u{3a5}\u{304}"),
        ("\u{1fea}", "\u{1fea}", "\u{3a5}\u{300}", "\u{1fea}", "\u{3a5}\u{300}"), ("\u{1feb}",
        "\u{38e}", "\u{3a5}\u{301}", "\u{38e}", "\u{3a5}\u{301}"), ("\u{1fec}", "\u{1fec}",
        "\u{3a1}\u{314}", "\u{1fec}", "\u{3a1}\u{314}"), ("\u{1fed}", "\u{1fed}", "\u{a8}\u{300}",
        "\u{20}\u{308}\u{300}", "\u{20}\u{308}\u{300}"), ("\u{1fee}", "\u{385}", "\u{a8}\u{301}",
        "\u{20}\u{308}\u{301}", "\u{20}\u{308}\u{301}"), ("\u{1fef}", "\u{60}", "\u{60}", "\u{60}",
        "\u{60}"), ("\u{1ff2}", "\u{1ff2}", "\u{3c9}\u{300}\u{345}", "\u{1ff2}",
        "\u{3c9}\u{300}\u{345}"), ("\u{1ff3}", "\u{1ff3}", "\u{3c9}\u{345}", "\u{1ff3}",
        "\u{3c9}\u{345}"), ("\u{1ff4}", "\u{1ff4}", "\u{3c9}\u{301}\u{345}", "\u{1ff4}",
        "\u{3c9}\u{301}\u{345}"), ("\u{1ff6}", "\u{1ff6}", "\u{3c9}\u{342}", "\u{1ff6}",
        "\u{3c9}\u{342}"), ("\u{1ff7}", "\u{1ff7}", "\u{3c9}\u{342}\u{345}", "\u{1ff7}",
        "\u{3c9}\u{342}\u{345}"), ("\u{1ff8}", "\u{1ff8}", "\u{39f}\u{300}", "\u{1ff8}",
        "\u{39f}\u{300}"), ("\u{1ff9}", "\u{38c}", "\u{39f}\u{301}", "\u{38c}", "\u{39f}\u{301}"),
        ("\u{1ffa}", "\u{1ffa}", "\u{3a9}\u{300}", "\u{1ffa}", "\u{3a9}\u{300}"), ("\u{1ffb}",
        "\u{38f}", "\u{3a9}\u{301}", "\u{38f}", "\u{3a9}\u{301}"), ("\u{1ffc}", "\u{1ffc}",
        "\u{3a9}\u{345}", "\u{1ffc}", "\u{3a9}\u{345}"), ("\u{1ffd}", "\u{b4}", "\u{b4}",
        "\u{20}\u{301}", "\u{20}\u{301}"), ("\u{1ffe}", "\u{1ffe}", "\u{1ffe}", "\u{20}\u{314}",
        "\u{20}\u{314}"), ("\u{2000}", "\u{2002}", "\u{2002}", "\u{20}", "\u{20}"), ("\u{2001}",
        "\u{2003}", "\u{2003}", "\u{20}", "\u{20}"), ("\u{2002}", "\u{2002}", "\u{2002}", "\u{20}",
        "\u{20}"), ("\u{2003}", "\u{2003}", "\u{2003}", "\u{20}", "\u{20}"), ("\u{2004}",
        "\u{2004}", "\u{2004}", "\u{20}", "\u{20}"), ("\u{2005}", "\u{2005}", "\u{2005}", "\u{20}",
        "\u{20}"), ("\u{2006}", "\u{2006}", "\u{2006}", "\u{20}", "\u{20}"), ("\u{2007}",
        "\u{2007}", "\u{2007}", "\u{20}", "\u{20}"), ("\u{2008}", "\u{2008}", "\u{2008}", "\u{20}",
        "\u{20}"), ("\u{2009}", "\u{2009}", "\u{2009}", "\u{20}", "\u{20}"), ("\u{200a}",
        "\u{200a}", "\u{200a}", "\u{20}", "\u{20}"), ("\u{2011}", "\u{2011}", "\u{2011}",
        "\u{2010}", "\u{2010}"), ("\u{2017}", "\u{2017}", "\u{2017}", "\u{20}\u{333}",
        "\u{20}\u{333}"), ("\u{2024}", "\u{2024}", "\u{2024}", "\u{2e}", "\u{2e}"), ("\u{2025}",
        "\u{2025}", "\u{2025}", "\u{2e}\u{2e}", "\u{2e}\u{2e}"), ("\u{2026}", "\u{2026}",
        "\u{2026}", "\u{2e}\u{2e}\u{2e}", "\u{2e}\u{2e}\u{2e}"), ("\u{202f}", "\u{202f}",
        "\u{202f}", "\u{20}", "\u{20}"), ("\u{2033}", "\u{2033}", "\u{2033}", "\u{2032}\u{2032}",
        "\u{2032}\u{2032}"), ("\u{2034}", "\u{2034}", "\u{2034}", "\u{2032}\u{2032}\u{2032}",
        "\u{2032}\u{2032}\u{2032}"), ("\u{2036}", "\u{2036}", "\u{2036}", "\u{2035}\u{2035}",
        "\u{2035}\u{2035}"), ("\u{2037}", "\u{2037}", "\u{2037}", "\u{2035}\u{2035}\u{2035}",
        "\u{2035}\u{2035}\u{2035}"), ("\u{203c}", "\u{203c}", "\u{203c}", "\u{21}\u{21}",
        "\u{21}\u{21}"), ("\u{203e}", "\u{203e}", "\u{203e}", "\u{20}\u{305}", "\u{20}\u{305}"),
        ("\u{2047}", "\u{2047}", "\u{2047}", "\u{3f}\u{3f}", "\u{3f}\u{3f}"), ("\u{2048}",
        "\u{2048}", "\u{2048}", "\u{3f}\u{21}", "\u{3f}\u{21}"), ("\u{2049}", "\u{2049}",
        "\u{2049}", "\u{21}\u{3f}", "\u{21}\u{3f}"), ("\u{2057}", "\u{2057}", "\u{2057}",
        "\u{2032}\u{2032}\u{2032}\u{2032}", "\u{2032}\u{2032}\u{2032}\u{2032}"), ("\u{205f}",
        "\u{205f}", "\u{205f}", "\u{20}", "\u{20}"), ("\u{2070}", "\u{2070}", "\u{2070}", "\u{30}",
        "\u{30}"), ("\u{2071}", "\u{2071}", "\u{2071}", "\u{69}", "\u{69}"), ("\u{2074}",
        "\u{2074}", "\u{2074}", "\u{34}", "\u{34}"), ("\u{2075}", "\u{2075}", "\u{2075}", "\u{35}",
        "\u{35}"), ("\u{2076}", "\u{2076}", "\u{2076}", "\u{36}", "\u{36}"), ("\u{2077}",
        "\u{2077}", "\u{2077}", "\u{37}", "\u{37}"), ("\u{2078}", "\u{2078}", "\u{2078}", "\u{38}",
        "\u{38}"), ("\u{2079}", "\u{2079}", "\u{2079}", "\u{39}", "\u{39}"), ("\u{207a}",
        "\u{207a}", "\u{207a}", "\u{2b}", "\u{2b}"), ("\u{207b}", "\u{207b}", "\u{207b}",
        "\u{2212}", "\u{2212}"), ("\u{207c}", "\u{207c}", "\u{207c}", "\u{3d}", "\u{3d}"),
        ("\u{207d}", "\u{207d}", "\u{207d}", "\u{28}", "\u{28}"), ("\u{207e}", "\u{207e}",
        "\u{207e}", "\u{29}", "\u{29}"), ("\u{207f}", "\u{207f}", "\u{207f}", "\u{6e}", "\u{6e}"),
        ("\u{2080}", "\u{2080}", "\u{2080}", "\u{30}", "\u{30}"), ("\u{2081}", "\u{2081}",
        "\u{2081}", "\u{31}", "\u{31}"), ("\u{2082}", "\u{2082}", "\u{2082}", "\u{32}", "\u{32}"),
        ("\u{2083}", "\u{2083}", "\u{2083}", "\u{33}", "\u{33}"), ("\u{2084}", "\u{2084}",
        "\u{2084}", "\u{34}", "\u{34}"), ("\u{2085}", "\u{2085}", "\u{2085}", "\u{35}", "\u{35}"),
        ("\u{2086}", "\u{2086}", "\u{2086}", "\u{36}", "\u{36}"), ("\u{2087}", "\u{2087}",
        "\u{2087}", "\u{37}", "\u{37}"), ("\u{2088}", "\u{2088}", "\u{2088}", "\u{38}", "\u{38}"),
        ("\u{2089}", "\u{2089}", "\u{2089}", "\u{39}", "\u{39}"), ("\u{208a}", "\u{208a}",
        "\u{208a}", "\u{2b}", "\u{2b}"), ("\u{208b}", "\u{208b}", "\u{208b}", "\u{2212}",
        "\u{2212}"), ("\u{208c}", "\u{208c}", "\u{208c}", "\u{3d}", "\u{3d}"), ("\u{208d}",
        "\u{208d}", "\u{208d}", "\u{28}", "\u{28}"), ("\u{208e}", "\u{208e}", "\u{208e}", "\u{29}",
        "\u{29}"), ("\u{2090}", "\u{2090}", "\u{2090}", "\u{61}", "\u{61}"), ("\u{2091}",
        "\u{2091}", "\u{2091}", "\u{65}", "\u{65}"), ("\u{2092}", "\u{2092}", "\u{2092}", "\u{6f}",
        "\u{6f}"), ("\u{2093}", "\u{2093}", "\u{2093}", "\u{78}", "\u{78}"), ("\u{2094}",
        "\u{2094}", "\u{2094}", "\u{259}", "\u{259}"), ("\u{2095}", "\u{2095}", "\u{2095}",
        "\u{68}", "\u{68}"), ("\u{2096}", "\u{2096}", "\u{2096}", "\u{6b}", "\u{6b}"), ("\u{2097}",
        "\u{2097}", "\u{2097}", "\u{6c}", "\u{6c}"), ("\u{2098}", "\u{2098}", "\u{2098}", "\u{6d}",
        "\u{6d}"), ("\u{2099}", "\u{2099}", "\u{2099}", "\u{6e}", "\u{6e}"), ("\u{209a}",
        "\u{209a}", "\u{209a}", "\u{70}", "\u{70}"), ("\u{209b}", "\u{209b}", "\u{209b}", "\u{73}",
        "\u{73}"), ("\u{209c}", "\u{209c}", "\u{209c}", "\u{74}", "\u{74}"), ("\u{20a8}",
        "\u{20a8}", "\u{20a8}", "\u{52}\u{73}", "\u{52}\u{73}"), ("\u{2100}", "\u{2100}",
        "\u{2100}", "\u{61}\u{2f}\u{63}", "\u{61}\u{2f}\u{63}"), ("\u{2101}", "\u{2101}",
        "\u{2101}", "\u{61}\u{2f}\u{73}", "\u{61}\u{2f}\u{73}"), ("\u{2102}", "\u{2102}",
        "\u{2102}", "\u{43}", "\u{43}"), ("\u{2103}", "\u{2103}", "\u{2103}", "\u{b0}\u{43}",
        "\u{b0}\u{43}"), ("\u{2105}", "\u{2105}", "\u{2105}", "\u{63}\u{2f}\u{6f}",
        "\u{63}\u{2f}\u{6f}"), ("\u{2106}", "\u{2106}", "\u{2106}", "\u{63}\u{2f}\u{75}",
        "\u{63}\u{2f}\u{75}"), ("\u{2107}", "\u{2107}", "\u{2107}", "\u{190}", "\u{190}"),
        ("\u{2109}", "\u{2109}", "\u{2109}", "\u{b0}\u{46}", "\u{b0}\u{46}"), ("\u{210a}",
        "\u{210a}", "\u{210a}", "\u{67}", "\u{67}"), ("\u{210b}", "\u{210b}", "\u{210b}", "\u{48}",
        "\u{48}"), ("\u{210c}", "\u{210c}", "\u{210c}", "\u{48}", "\u{48}"), ("\u{210d}",
        "\u{210d}", "\u{210d}", "\u{48}", "\u{48}"), ("\u{210e}", "\u{210e}", "\u{210e}", "\u{68}",
        "\u{68}"), ("\u{210f}", "\u{210f}", "\u{210f}", "\u{127}", "\u{127}"), ("\u{2110}",
        "\u{2110}", "\u{2110}", "\u{49}", "\u{49}"), ("\u{2111}", "\u{2111}", "\u{2111}", "\u{49}",
        "\u{49}"), ("\u{2112}", "\u{2112}", "\u{2112}", "\u{4c}", "\u{4c}"), ("\u{2113}",
        "\u{2113}", "\u{2113}", "\u{6c}", "\u{6c}"), ("\u{2115}", "\u{2115}", "\u{2115}", "\u{4e}",
        "\u{4e}"), ("\u{2116}", "\u{2116}", "\u{2116}", "\u{4e}\u{6f}", "\u{4e}\u{6f}"),
        ("\u{2119}", "\u{2119}", "\u{2119}", "\u{50}", "\u{50}"), ("\u{211a}", "\u{211a}",
        "\u{211a}", "\u{51}", "\u{51}"), ("\u{211b}", "\u{211b}", "\u{211b}", "\u{52}", "\u{52}"),
        ("\u{211c}", "\u{211c}", "\u{211c}", "\u{52}", "\u{52}"), ("\u{211d}", "\u{211d}",
        "\u{211d}", "\u{52}", "\u{52}"), ("\u{2120}", "\u{2120}", "\u{2120}", "\u{53}\u{4d}",
        "\u{53}\u{4d}"), ("\u{2121}", "\u{2121}", "\u{2121}", "\u{54}\u{45}\u{4c}",
        "\u{54}\u{45}\u{4c}"), ("\u{2122}", "\u{2122}", "\u{2122}", "\u{54}\u{4d}", "\u{54}\u{4d}"),
        ("\u{2124}", "\u{2124}", "\u{2124}", "\u{5a}", "\u{5a}"), ("\u{2126}", "\u{3a9}", "\u{3a9}",
        "\u{3a9}", "\u{3a9}"), ("\u{2128}", "\u{2128}", "\u{2128}", "\u{5a}", "\u{5a}"),
        ("\u{212a}", "\u{4b}", "\u{4b}", "\u{4b}", "\u{4b}"), ("\u{212b}", "\u{c5}",
        "\u{41}\u{30a}", "\u{c5}", "\u{41}\u{30a}"), ("\u{212c}", "\u{212c}", "\u{212c}", "\u{42}",
        "\u{42}"), ("\u{212d}", "\u{212d}", "\u{212d}", "\u{43}", "\u{43}"), ("\u{212f}",
        "\u{212f}", "\u{212f}", "\u{65}", "\u{65}"), ("\u{2130}", "\u{2130}", "\u{2130}", "\u{45}",
        "\u{45}"), ("\u{2131}", "\u{2131}", "\u{2131}", "\u{46}", "\u{46}"), ("\u{2133}",
        "\u{2133}", "\u{2133}", "\u{4d}", "\u{4d}"), ("\u{2134}", "\u{2134}", "\u{2134}", "\u{6f}",
        "\u{6f}"), ("\u{2135}", "\u{2135}", "\u{2135}", "\u{5d0}", "\u{5d0}"), ("\u{2136}",
        "\u{2136}", "\u{2136}", "\u{5d1}", "\u{5d1}"), ("\u{2137}", "\u{2137}", "\u{2137}",
        "\u{5d2}", "\u{5d2}"), ("\u{2138}", "\u{2138}", "\u{2138}", "\u{5d3}", "\u{5d3}"),
        ("\u{2139}", "\u{2139}", "\u{2139}", "\u{69}", "\u{69}"), ("\u{213b}", "\u{213b}",
        "\u{213b}", "\u{46}\u{41}\u{58}", "\u{46}\u{41}\u{58}"), ("\u{213c}", "\u{213c}",
        "\u{213c}", "\u{3c0}", "\u{3c0}"), ("\u{213d}", "\u{213d}", "\u{213d}", "\u{3b3}",
        "\u{3b3}"), ("\u{213e}", "\u{213e}", "\u{213e}", "\u{393}", "\u{393}"), ("\u{213f}",
        "\u{213f}", "\u{213f}", "\u{3a0}", "\u{3a0}"), ("\u{2140}", "\u{2140}", "\u{2140}",
        "\u{2211}", "\u{2211}"), ("\u{2145}", "\u{2145}", "\u{2145}", "\u{44}", "\u{44}"),
        ("\u{2146}", "\u{2146}", "\u{2146}", "\u{64}", "\u{64}"), ("\u{2147}", "\u{2147}",
        "\u{2147}", "\u{65}", "\u{65}"), ("\u{2148}", "\u{2148}", "\u{2148}", "\u{69}", "\u{69}"),
        ("\u{2149}", "\u{2149}", "\u{2149}", "\u{6a}", "\u{6a}"), ("\u{2150}", "\u{2150}",
        "\u{2150}", "\u{31}\u{2044}\u{37}", "\u{31}\u{2044}\u{37}"), ("\u{2151}", "\u{2151}",
        "\u{2151}", "\u{31}\u{2044}\u{39}", "\u{31}\u{2044}\u{39}"), ("\u{2152}", "\u{2152}",
        "\u{2152}", "\u{31}\u{2044}\u{31}\u{30}", "\u{31}\u{2044}\u{31}\u{30}"), ("\u{2153}",
        "\u{2153}", "\u{2153}", "\u{31}\u{2044}\u{33}", "\u{31}\u{2044}\u{33}"), ("\u{2154}",
        "\u{2154}", "\u{2154}", "\u{32}\u{2044}\u{33}", "\u{32}\u{2044}\u{33}"), ("\u{2155}",
        "\u{2155}", "\u{2155}", "\u{31}\u{2044}\u{35}", "\u{31}\u{2044}\u{35}"), ("\u{2156}",
        "\u{2156}", "\u{2156}", "\u{32}\u{2044}\u{35}", "\u{32}\u{2044}\u{35}"), ("\u{2157}",
        "\u{2157}", "\u{2157}", "\u{33}\u{2044}\u{35}", "\u{33}\u{2044}\u{35}"), ("\u{2158}",
        "\u{2158}", "\u{2158}", "\u{34}\u{2044}\u{35}", "\u{34}\u{2044}\u{35}"), ("\u{2159}",
        "\u{2159}", "\u{2159}", "\u{31}\u{2044}\u{36}", "\u{31}\u{2044}\u{36}"), ("\u{215a}",
        "\u{215a}", "\u{215a}", "\u{35}\u{2044}\u{36}", "\u{35}\u{2044}\u{36}"), ("\u{215b}",
        "\u{215b}", "\u{215b}", "\u{31}\u{2044}\u{38}", "\u{31}\u{2044}\u{38}"), ("\u{215c}",
        "\u{215c}", "\u{215c}", "\u{33}\u{2044}\u{38}", "\u{33}\u{2044}\u{38}"), ("\u{215d}",
        "\u{215d}", "\u{215d}", "\u{35}\u{2044}\u{38}", "\u{35}\u{2044}\u{38}"), ("\u{215e}",
        "\u{215e}", "\u{215e}", "\u{37}\u{2044}\u{38}", "\u{37}\u{2044}\u{38}"), ("\u{215f}",
        "\u{215f}", "\u{215f}", "\u{31}\u{2044}", "\u{31}\u{2044}"), ("\u{2160}", "\u{2160}",
        "\u{2160}", "\u{49}", "\u{49}"), ("\u{2161}", "\u{2161}", "\u{2161}", "\u{49}\u{49}",
        "\u{49}\u{49}"), ("\u{2162}", "\u{2162}", "\u{2162}", "\u{49}\u{49}\u{49}",
        "\u{49}\u{49}\u{49}"), ("\u{2163}", "\u{2163}", "\u{2163}", "\u{49}\u{56}", "\u{49}\u{56}"),
        ("\u{2164}", "\u{2164}", "\u{2164}", "\u{56}", "\u{56}"), ("\u{2165}", "\u{2165}",
        "\u{2165}", "\u{56}\u{49}", "\u{56}\u{49}"), ("\u{2166}", "\u{2166}", "\u{2166}",
        "\u{56}\u{49}\u{49}", "\u{56}\u{49}\u{49}"), ("\u{2167}", "\u{2167}", "\u{2167}",
        "\u{56}\u{49}\u{49}\u{49}", "\u{56}\u{49}\u{49}\u{49}"), ("\u{2168}", "\u{2168}",
        "\u{2168}", "\u{49}\u{58}", "\u{49}\u{58}"), ("\u{2169}", "\u{2169}", "\u{2169}", "\u{58}",
        "\u{58}"), ("\u{216a}", "\u{216a}", "\u{216a}", "\u{58}\u{49}", "\u{58}\u{49}"),
        ("\u{216b}", "\u{216b}", "\u{216b}", "\u{58}\u{49}\u{49}", "\u{58}\u{49}\u{49}"),
        ("\u{216c}", "\u{216c}", "\u{216c}", "\u{4c}", "\u{4c}"), ("\u{216d}", "\u{216d}",
        "\u{216d}", "\u{43}", "\u{43}"), ("\u{216e}", "\u{216e}", "\u{216e}", "\u{44}", "\u{44}"),
        ("\u{216f}", "\u{216f}", "\u{216f}", "\u{4d}", "\u{4d}"), ("\u{2170}", "\u{2170}",
        "\u{2170}", "\u{69}", "\u{69}"), ("\u{2171}", "\u{2171}", "\u{2171}", "\u{69}\u{69}",
        "\u{69}\u{69}"), ("\u{2172}", "\u{2172}", "\u{2172}", "\u{69}\u{69}\u{69}",
        "\u{69}\u{69}\u{69}"), ("\u{2173}", "\u{2173}", "\u{2173}", "\u{69}\u{76}", "\u{69}\u{76}"),
        ("\u{2174}", "\u{2174}", "\u{2174}", "\u{76}", "\u{76}"), ("\u{2175}", "\u{2175}",
        "\u{2175}", "\u{76}\u{69}", "\u{76}\u{69}"), ("\u{2176}", "\u{2176}", "\u{2176}",
        "\u{76}\u{69}\u{69}", "\u{76}\u{69}\u{69}"), ("\u{2177}", "\u{2177}", "\u{2177}",
        "\u{76}\u{69}\u{69}\u{69}", "\u{76}\u{69}\u{69}\u{69}"), ("\u{2178}", "\u{2178}",
        "\u{2178}", "\u{69}\u{78}", "\u{69}\u{78}"), ("\u{2179}", "\u{2179}", "\u{2179}", "\u{78}",
        "\u{78}"), ("\u{217a}", "\u{217a}", "\u{217a}", "\u{78}\u{69}", "\u{78}\u{69}"),
        ("\u{217b}", "\u{217b}", "\u{217b}", "\u{78}\u{69}\u{69}", "\u{78}\u{69}\u{69}"),
        ("\u{217c}", "\u{217c}", "\u{217c}", "\u{6c}", "\u{6c}"), ("\u{217d}", "\u{217d}",
        "\u{217d}", "\u{63}", "\u{63}"), ("\u{217e}", "\u{217e}", "\u{217e}", "\u{64}", "\u{64}"),
        ("\u{217f}", "\u{217f}", "\u{217f}", "\u{6d}", "\u{6d}"), ("\u{2189}", "\u{2189}",
        "\u{2189}", "\u{30}\u{2044}\u{33}", "\u{30}\u{2044}\u{33}"), ("\u{219a}", "\u{219a}",
        "\u{2190}\u{338}", "\u{219a}", "\u{2190}\u{338}"), ("\u{219b}", "\u{219b}",
        "\u{2192}\u{338}", "\u{219b}", "\u{2192}\u{338}"), ("\u{21ae}", "\u{21ae}",
        "\u{2194}\u{338}", "\u{21ae}", "\u{2194}\u{338}"), ("\u{21cd}", "\u{21cd}",
        "\u{21d0}\u{338}", "\u{21cd}", "\u{21d0}\u{338}"), ("\u{21ce}", "\u{21ce}",
        "\u{21d4}\u{338}", "\u{21ce}", "\u{21d4}\u{338}"), ("\u{21cf}", "\u{21cf}",
        "\u{21d2}\u{338}", "\u{21cf}", "\u{21d2}\u{338}"), ("\u{2204}", "\u{2204}",
        "\u{2203}\u{338}", "\u{2204}", "\u{2203}\u{338}"), ("\u{2209}", "\u{2209}",
        "\u{2208}\u{338}", "\u{2209}", "\u{2208}\u{338}"), ("\u{220c}", "\u{220c}",
        "\u{220b}\u{338}", "\u{220c}", "\u{220b}\u{338}"), ("\u{2224}", "\u{2224}",
        "\u{2223}\u{338}", "\u{2224}", "\u{2223}\u{338}"), ("\u{2226}", "\u{2226}",
        "\u{2225}\u{338}", "\u{2226}", "\u{2225}\u{338}"), ("\u{222c}", "\u{222c}", "\u{222c}",
        "\u{222b}\u{222b}", "\u{222b}\u{222b}"), ("\u{222d}", "\u{222d}", "\u{222d}",
        "\u{222b}\u{222b}\u{222b}", "\u{222b}\u{222b}\u{222b}"), ("\u{222f}", "\u{222f}",
        "\u{222f}", "\u{222e}\u{222e}", "\u{222e}\u{222e}"), ("\u{2230}", "\u{2230}", "\u{2230}",
        "\u{222e}\u{222e}\u{222e}", "\u{222e}\u{222e}\u{222e}"), ("\u{2241}", "\u{2241}",
        "\u{223c}\u{338}", "\u{2241}", "\u{223c}\u{338}"), ("\u{2244}", "\u{2244}",
        "\u{2243}\u{338}", "\u{2244}", "\u{2243}\u{338}"), ("\u{2247}", "\u{2247}",
        "\u{2245}\u{338}", "\u{2247}", "\u{2245}\u{338}"), ("\u{2249}", "\u{2249}",
        "\u{2248}\u{338}", "\u{2249}", "\u{2248}\u{338}"), ("\u{2260}", "\u{2260}", "\u{3d}\u{338}",
        "\u{2260}", "\u{3d}\u{338}"), ("\u{2262}", "\u{2262}", "\u{2261}\u{338}", "\u{2262}",
        "\u{2261}\u{338}"), ("\u{226d}", "\u{226d}", "\u{224d}\u{338}", "\u{226d}",
        "\u{224d}\u{338}"), ("\u{226e}", "\u{226e}", "\u{3c}\u{338}", "\u{226e}", "\u{3c}\u{338}"),
        ("\u{226f}", "\u{226f}", "\u{3e}\u{338}", "\u{226f}", "\u{3e}\u{338}"), ("\u{2270}",
        "\u{2270}", "\u{2264}\u{338}", "\u{2270}", "\u{2264}\u{338}"), ("\u{2271}", "\u{2271}",
        "\u{2265}\u{338}", "\u{2271}", "\u{2265}\u{338}"), ("\u{2274}", "\u{2274}",
        "\u{2272}\u{338}", "\u{2274}", "\u{2272}\u{338}"), ("\u{2275}", "\u{2275}",
        "\u{2273}\u{338}", "\u{2275}", "\u{2273}\u{338}"), ("\u{2278}", "\u{2278}",
        "\u{2276}\u{338}", "\u{2278}", "\u{2276}\u{338}"), ("\u{2279}", "\u{2279}",
        "\u{2277}\u{338}", "\u{2279}", "\u{2277}\u{338}"), ("\u{2280}", "\u{2280}",
        "\u{227a}\u{338}", "\u{2280}", "\u{227a}\u{338}"), ("\u{2281}", "\u{2281}",
        "\u{227b}\u{338}", "\u{2281}", "\u{227b}\u{338}"), ("\u{2284}", "\u{2284}",
        "\u{2282}\u{338}", "\u{2284}", "\u{2282}\u{338}"), ("\u{2285}", "\u{2285}",
        "\u{2283}\u{338}", "\u{2285}", "\u{2283}\u{338}"), ("\u{2288}", "\u{2288}",
        "\u{2286}\u{338}", "\u{2288}", "\u{2286}\u{338}"), ("\u{2289}", "\u{2289}",
        "\u{2287}\u{338}", "\u{2289}", "\u{2287}\u{338}"), ("\u{22ac}", "\u{22ac}",
        "\u{22a2}\u{338}", "\u{22ac}", "\u{22a2}\u{338}"), ("\u{22ad}", "\u{22ad}",
        "\u{22a8}\u{338}", "\u{22ad}", "\u{22a8}\u{338}"), ("\u{22ae}", "\u{22ae}",
        "\u{22a9}\u{338}", "\u{22ae}", "\u{22a9}\u{338}"), ("\u{22af}", "\u{22af}",
        "\u{22ab}\u{338}", "\u{22af}", "\u{22ab}\u{338}"), ("\u{22e0}", "\u{22e0}",
        "\u{227c}\u{338}", "\u{22e0}", "\u{227c}\u{338}"), ("\u{22e1}", "\u{22e1}",
        "\u{227d}\u{338}", "\u{22e1}", "\u{227d}\u{338}"), ("\u{22e2}", "\u{22e2}",
        "\u{2291}\u{338}", "\u{22e2}", "\u{2291}\u{338}"), ("\u{22e3}", "\u{22e3}",
        "\u{2292}\u{338}", "\u{22e3}", "\u{2292}\u{338}"), ("\u{22ea}", "\u{22ea}",
        "\u{22b2}\u{338}", "\u{22ea}", "\u{22b2}\u{338}"), ("\u{22eb}", "\u{22eb}",
        "\u{22b3}\u{338}", "\u{22eb}", "\u{22b3}\u{338}"), ("\u{22ec}", "\u{22ec}",
        "\u{22b4}\u{338}", "\u{22ec}", "\u{22b4}\u{338}"), ("\u{22ed}", "\u{22ed}",
        "\u{22b5}\u{338}", "\u{22ed}", "\u{22b5}\u{338}"), ("\u{2329}", "\u{3008}", "\u{3008}",
        "\u{3008}", "\u{3008}"), ("\u{232a}", "\u{3009}", "\u{3009}", "\u{3009}", "\u{3009}"),
        ("\u{2460}", "\u{2460}", "\u{2460}", "\u{31}", "\u{31}"), ("\u{2461}", "\u{2461}",
        "\u{2461}", "\u{32}", "\u{32}"), ("\u{2462}", "\u{2462}", "\u{2462}", "\u{33}", "\u{33}"),
        ("\u{2463}", "\u{2463}", "\u{2463}", "\u{34}", "\u{34}"), ("\u{2464}", "\u{2464}",
        "\u{2464}", "\u{35}", "\u{35}"), ("\u{2465}", "\u{2465}", "\u{2465}", "\u{36}", "\u{36}"),
        ("\u{2466}", "\u{2466}", "\u{2466}", "\u{37}", "\u{37}"), ("\u{2467}", "\u{2467}",
        "\u{2467}", "\u{38}", "\u{38}"), ("\u{2468}", "\u{2468}", "\u{2468}", "\u{39}", "\u{39}"),
        ("\u{2469}", "\u{2469}", "\u{2469}", "\u{31}\u{30}", "\u{31}\u{30}"), ("\u{246a}",
        "\u{246a}", "\u{246a}", "\u{31}\u{31}", "\u{31}\u{31}"), ("\u{246b}", "\u{246b}",
        "\u{246b}", "\u{31}\u{32}", "\u{31}\u{32}"), ("\u{246c}", "\u{246c}", "\u{246c}",
        "\u{31}\u{33}", "\u{31}\u{33}"), ("\u{246d}", "\u{246d}", "\u{246d}", "\u{31}\u{34}",
        "\u{31}\u{34}"), ("\u{246e}", "\u{246e}", "\u{246e}", "\u{31}\u{35}", "\u{31}\u{35}"),
        ("\u{246f}", "\u{246f}", "\u{246f}", "\u{31}\u{36}", "\u{31}\u{36}"), ("\u{2470}",
        "\u{2470}", "\u{2470}", "\u{31}\u{37}", "\u{31}\u{37}"), ("\u{2471}", "\u{2471}",
        "\u{2471}", "\u{31}\u{38}", "\u{31}\u{38}"), ("\u{2472}", "\u{2472}", "\u{2472}",
        "\u{31}\u{39}", "\u{31}\u{39}"), ("\u{2473}", "\u{2473}", "\u{2473}", "\u{32}\u{30}",
        "\u{32}\u{30}"), ("\u{2474}", "\u{2474}", "\u{2474}", "\u{28}\u{31}\u{29}",
        "\u{28}\u{31}\u{29}"), ("\u{2475}", "\u{2475}", "\u{2475}", "\u{28}\u{32}\u{29}",
        "\u{28}\u{32}\u{29}"), ("\u{2476}", "\u{2476}", "\u{2476}", "\u{28}\u{33}\u{29}",
        "\u{28}\u{33}\u{29}"), ("\u{2477}", "\u{2477}", "\u{2477}", "\u{28}\u{34}\u{29}",
        "\u{28}\u{34}\u{29}"), ("\u{2478}", "\u{2478}", "\u{2478}", "\u{28}\u{35}\u{29}",
        "\u{28}\u{35}\u{29}"), ("\u{2479}", "\u{2479}", "\u{2479}", "\u{28}\u{36}\u{29}",
        "\u{28}\u{36}\u{29}"), ("\u{247a}", "\u{247a}", "\u{247a}", "\u{28}\u{37}\u{29}",
        "\u{28}\u{37}\u{29}"), ("\u{247b}", "\u{247b}", "\u{247b}", "\u{28}\u{38}\u{29}",
        "\u{28}\u{38}\u{29}"), ("\u{247c}", "\u{247c}", "\u{247c}", "\u{28}\u{39}\u{29}",
        "\u{28}\u{39}\u{29}"), ("\u{247d}", "\u{247d}", "\u{247d}", "\u{28}\u{31}\u{30}\u{29}",
        "\u{28}\u{31}\u{30}\u{29}"), ("\u{247e}", "\u{247e}", "\u{247e}",
        "\u{28}\u{31}\u{31}\u{29}", "\u{28}\u{31}\u{31}\u{29}"), ("\u{247f}", "\u{247f}",
        "\u{247f}", "\u{28}\u{31}\u{32}\u{29}", "\u{28}\u{31}\u{32}\u{29}"), ("\u{2480}",
        "\u{2480}", "\u{2480}", "\u{28}\u{31}\u{33}\u{29}", "\u{28}\u{31}\u{33}\u{29}"),
        ("\u{2481}", "\u{2481}", "\u{2481}", "\u{28}\u{31}\u{34}\u{29}",
        "\u{28}\u{31}\u{34}\u{29}"), ("\u{2482}", "\u{2482}", "\u{2482}",
        "\u{28}\u{31}\u{35}\u{29}", "\u{28}\u{31}\u{35}\u{29}"), ("\u{2483}", "\u{2483}",
        "\u{2483}", "\u{28}\u{31}\u{36}\u{29}", "\u{28}\u{31}\u{36}\u{29}"), ("\u{2484}",
        "\u{2484}", "\u{2484}", "\u{28}\u{31}\u{37}\u{29}", "\u{28}\u{31}\u{37}\u{29}"),
        ("\u{2485}", "\u{2485}", "\u{2485}", "\u{28}\u{31}\u{38}\u{29}",
        "\u{28}\u{31}\u{38}\u{29}"), ("\u{2486}", "\u{2486}", "\u{2486}",
        "\u{28}\u{31}\u{39}\u{29}", "\u{28}\u{31}\u{39}\u{29}"), ("\u{2487}", "\u{2487}",
        "\u{2487}", "\u{28}\u{32}\u{30}\u{29}", "\u{28}\u{32}\u{30}\u{29}"), ("\u{2488}",
        "\u{2488}", "\u{2488}", "\u{31}\u{2e}", "\u{31}\u{2e}"), ("\u{2489}", "\u{2489}",
        "\u{2489}", "\u{32}\u{2e}", "\u{32}\u{2e}"), ("\u{248a}", "\u{248a}", "\u{248a}",
        "\u{33}\u{2e}", "\u{33}\u{2e}"), ("\u{248b}", "\u{248b}", "\u{248b}", "\u{34}\u{2e}",
        "\u{34}\u{2e}"), ("\u{248c}", "\u{248c}", "\u{248c}", "\u{35}\u{2e}", "\u{35}\u{2e}"),
        ("\u{248d}", "\u{248d}", "\u{248d}", "\u{36}\u{2e}", "\u{36}\u{2e}"), ("\u{248e}",
        "\u{248e}", "\u{248e}", "\u{37}\u{2e}", "\u{37}\u{2e}"), ("\u{248f}", "\u{248f}",
        "\u{248f}", "\u{38}\u{2e}", "\u{38}\u{2e}"), ("\u{2490}", "\u{2490}", "\u{2490}",
        "\u{39}\u{2e}", "\u{39}\u{2e}"), ("\u{2491}", "\u{2491}", "\u{2491}", "\u{31}\u{30}\u{2e}",
        "\u{31}\u{30}\u{2e}"), ("\u{2492}", "\u{2492}", "\u{2492}", "\u{31}\u{31}\u{2e}",
        "\u{31}\u{31}\u{2e}"), ("\u{2493}", "\u{2493}", "\u{2493}", "\u{31}\u{32}\u{2e}",
        "\u{31}\u{32}\u{2e}"), ("\u{2494}", "\u{2494}", "\u{2494}", "\u{31}\u{33}\u{2e}",
        "\u{31}\u{33}\u{2e}"), ("\u{2495}", "\u{2495}", "\u{2495}", "\u{31}\u{34}\u{2e}",
        "\u{31}\u{34}\u{2e}"), ("\u{2496}", "\u{2496}", "\u{2496}", "\u{31}\u{35}\u{2e}",
        "\u{31}\u{35}\u{2e}"), ("\u{2497}", "\u{2497}", "\u{2497}", "\u{31}\u{36}\u{2e}",
        "\u{31}\u{36}\u{2e}"), ("\u{2498}", "\u{2498}", "\u{2498}", "\u{31}\u{37}\u{2e}",
        "\u{31}\u{37}\u{2e}"), ("\u{2499}", "\u{2499}", "\u{2499}", "\u{31}\u{38}\u{2e}",
        "\u{31}\u{38}\u{2e}"), ("\u{249a}", "\u{249a}", "\u{249a}", "\u{31}\u{39}\u{2e}",
        "\u{31}\u{39}\u{2e}"), ("\u{249b}", "\u{249b}", "\u{249b}", "\u{32}\u{30}\u{2e}",
        "\u{32}\u{30}\u{2e}"), ("\u{249c}", "\u{249c}", "\u{249c}", "\u{28}\u{61}\u{29}",
        "\u{28}\u{61}\u{29}"), ("\u{249d}", "\u{249d}", "\u{249d}", "\u{28}\u{62}\u{29}",
        "\u{28}\u{62}\u{29}"), ("\u{249e}", "\u{249e}", "\u{249e}", "\u{28}\u{63}\u{29}",
        "\u{28}\u{63}\u{29}"), ("\u{249f}", "\u{249f}", "\u{249f}", "\u{28}\u{64}\u{29}",
        "\u{28}\u{64}\u{29}"), ("\u{24a0}", "\u{24a0}", "\u{24a0}", "\u{28}\u{65}\u{29}",
        "\u{28}\u{65}\u{29}"), ("\u{24a1}", "\u{24a1}", "\u{24a1}", "\u{28}\u{66}\u{29}",
        "\u{28}\u{66}\u{29}"), ("\u{24a2}", "\u{24a2}", "\u{24a2}", "\u{28}\u{67}\u{29}",
        "\u{28}\u{67}\u{29}"), ("\u{24a3}", "\u{24a3}", "\u{24a3}", "\u{28}\u{68}\u{29}",
        "\u{28}\u{68}\u{29}"), ("\u{24a4}", "\u{24a4}", "\u{24a4}", "\u{28}\u{69}\u{29}",
        "\u{28}\u{69}\u{29}"), ("\u{24a5}", "\u{24a5}", "\u{24a5}", "\u{28}\u{6a}\u{29}",
        "\u{28}\u{6a}\u{29}"), ("\u{24a6}", "\u{24a6}", "\u{24a6}", "\u{28}\u{6b}\u{29}",
        "\u{28}\u{6b}\u{29}"), ("\u{24a7}", "\u{24a7}", "\u{24a7}", "\u{28}\u{6c}\u{29}",
        "\u{28}\u{6c}\u{29}"), ("\u{24a8}", "\u{24a8}", "\u{24a8}", "\u{28}\u{6d}\u{29}",
        "\u{28}\u{6d}\u{29}"), ("\u{24a9}", "\u{24a9}", "\u{24a9}", "\u{28}\u{6e}\u{29}",
        "\u{28}\u{6e}\u{29}"), ("\u{24aa}", "\u{24aa}", "\u{24aa}", "\u{28}\u{6f}\u{29}",
        "\u{28}\u{6f}\u{29}"), ("\u{24ab}", "\u{24ab}", "\u{24ab}", "\u{28}\u{70}\u{29}",
        "\u{28}\u{70}\u{29}"), ("\u{24ac}", "\u{24ac}", "\u{24ac}", "\u{28}\u{71}\u{29}",
        "\u{28}\u{71}\u{29}"), ("\u{24ad}", "\u{24ad}", "\u{24ad}", "\u{28}\u{72}\u{29}",
        "\u{28}\u{72}\u{29}"), ("\u{24ae}", "\u{24ae}", "\u{24ae}", "\u{28}\u{73}\u{29}",
        "\u{28}\u{73}\u{29}"), ("\u{24af}", "\u{24af}", "\u{24af}", "\u{28}\u{74}\u{29}",
        "\u{28}\u{74}\u{29}"), ("\u{24b0}", "\u{24b0}", "\u{24b0}", "\u{28}\u{75}\u{29}",
        "\u{28}\u{75}\u{29}"), ("\u{24b1}", "\u{24b1}", "\u{24b1}", "\u{28}\u{76}\u{29}",
        "\u{28}\u{76}\u{29}"), ("\u{24b2}", "\u{24b2}", "\u{24b2}", "\u{28}\u{77}\u{29}",
        "\u{28}\u{77}\u{29}"), ("\u{24b3}", "\u{24b3}", "\u{24b3}", "\u{28}\u{78}\u{29}",
        "\u{28}\u{78}\u{29}"), ("\u{24b4}", "\u{24b4}", "\u{24b4}", "\u{28}\u{79}\u{29}",
        "\u{28}\u{79}\u{29}"), ("\u{24b5}", "\u{24b5}", "\u{24b5}", "\u{28}\u{7a}\u{29}",
        "\u{28}\u{7a}\u{29}"), ("\u{24b6}", "\u{24b6}", "\u{24b6}", "\u{41}", "\u{41}"),
        ("\u{24b7}", "\u{24b7}", "\u{24b7}", "\u{42}", "\u{42}"), ("\u{24b8}", "\u{24b8}",
        "\u{24b8}", "\u{43}", "\u{43}"), ("\u{24b9}", "\u{24b9}", "\u{24b9}", "\u{44}", "\u{44}"),
        ("\u{24ba}", "\u{24ba}", "\u{24ba}", "\u{45}", "\u{45}"), ("\u{24bb}", "\u{24bb}",
        "\u{24bb}", "\u{46}", "\u{46}"), ("\u{24bc}", "\u{24bc}", "\u{24bc}", "\u{47}", "\u{47}"),
        ("\u{24bd}", "\u{24bd}", "\u{24bd}", "\u{48}", "\u{48}"), ("\u{24be}", "\u{24be}",
        "\u{24be}", "\u{49}", "\u{49}"), ("\u{24bf}", "\u{24bf}", "\u{24bf}", "\u{4a}", "\u{4a}"),
        ("\u{24c0}", "\u{24c0}", "\u{24c0}", "\u{4b}", "\u{4b}"), ("\u{24c1}", "\u{24c1}",
        "\u{24c1}", "\u{4c}", "\u{4c}"), ("\u{24c2}", "\u{24c2}", "\u{24c2}", "\u{4d}", "\u{4d}"),
        ("\u{24c3}", "\u{24c3}", "\u{24c3}", "\u{4e}", "\u{4e}"), ("\u{24c4}", "\u{24c4}",
        "\u{24c4}", "\u{4f}", "\u{4f}"), ("\u{24c5}", "\u{24c5}", "\u{24c5}", "\u{50}", "\u{50}"),
        ("\u{24c6}", "\u{24c6}", "\u{24c6}", "\u{51}", "\u{51}"), ("\u{24c7}", "\u{24c7}",
        "\u{24c7}", "\u{52}", "\u{52}"), ("\u{24c8}", "\u{24c8}", "\u{24c8}", "\u{53}", "\u{53}"),
        ("\u{24c9}", "\u{24c9}", "\u{24c9}", "\u{54}", "\u{54}"), ("\u{24ca}", "\u{24ca}",
        "\u{24ca}", "\u{55}", "\u{55}"), ("\u{24cb}", "\u{24cb}", "\u{24cb}", "\u{56}", "\u{56}"),
        ("\u{24cc}", "\u{24cc}", "\u{24cc}", "\u{57}", "\u{57}"), ("\u{24cd}", "\u{24cd}",
        "\u{24cd}", "\u{58}", "\u{58}"), ("\u{24ce}", "\u{24ce}", "\u{24ce}", "\u{59}", "\u{59}"),
        ("\u{24cf}", "\u{24cf}", "\u{24cf}", "\u{5a}", "\u{5a}"), ("\u{24d0}", "\u{24d0}",
        "\u{24d0}", "\u{61}", "\u{61}"), ("\u{24d1}", "\u{24d1}", "\u{24d1}", "\u{62}", "\u{62}"),
        ("\u{24d2}", "\u{24d2}", "\u{24d2}", "\u{63}", "\u{63}"), ("\u{24d3}", "\u{24d3}",
        "\u{24d3}", "\u{64}", "\u{64}"), ("\u{24d4}", "\u{24d4}", "\u{24d4}", "\u{65}", "\u{65}"),
        ("\u{24d5}", "\u{24d5}", "\u{24d5}", "\u{66}", "\u{66}"), ("\u{24d6}", "\u{24d6}",
        "\u{24d6}", "\u{67}", "\u{67}"), ("\u{24d7}", "\u{24d7}", "\u{24d7}", "\u{68}", "\u{68}"),
        ("\u{24d8}", "\u{24d8}", "\u{24d8}", "\u{69}", "\u{69}"), ("\u{24d9}", "\u{24d9}",
        "\u{24d9}", "\u{6a}", "\u{6a}"), ("\u{24da}", "\u{24da}", "\u{24da}", "\u{6b}", "\u{6b}"),
        ("\u{24db}", "\u{24db}", "\u{24db}", "\u{6c}", "\u{6c}"), ("\u{24dc}", "\u{24dc}",
        "\u{24dc}", "\u{6d}", "\u{6d}"), ("\u{24dd}", "\u{24dd}", "\u{24dd}", "\u{6e}", "\u{6e}"),
        ("\u{24de}", "\u{24de}", "\u{24de}", "\u{6f}", "\u{6f}"), ("\u{24df}", "\u{24df}",
        "\u{24df}", "\u{70}", "\u{70}"), ("\u{24e0}", "\u{24e0}", "\u{24e0}", "\u{71}", "\u{71}"),
        ("\u{24e1}", "\u{24e1}", "\u{24e1}", "\u{72}", "\u{72}"), ("\u{24e2}", "\u{24e2}",
        "\u{24e2}", "\u{73}", "\u{73}"), ("\u{24e3}", "\u{24e3}", "\u{24e3}", "\u{74}", "\u{74}"),
        ("\u{24e4}", "\u{24e4}", "\u{24e4}", "\u{75}", "\u{75}"), ("\u{24e5}", "\u{24e5}",
        "\u{24e5}", "\u{76}", "\u{76}"), ("\u{24e6}", "\u{24e6}", "\u{24e6}", "\u{77}", "\u{77}"),
        ("\u{24e7}", "\u{24e7}", "\u{24e7}", "\u{78}", "\u{78}"), ("\u{24e8}", "\u{24e8}",
        "\u{24e8}", "\u{79}", "\u{79}"), ("\u{24e9}", "\u{24e9}", "\u{24e9}", "\u{7a}", "\u{7a}"),
        ("\u{24ea}", "\u{24ea}", "\u{24ea}", "\u{30}", "\u{30}"), ("\u{2a0c}", "\u{2a0c}",
        "\u{2a0c}", "\u{222b}\u{222b}\u{222b}\u{222b}", "\u{222b}\u{222b}\u{222b}\u{222b}"),
        ("\u{2a74}", "\u{2a74}", "\u{2a74}", "\u{3a}\u{3a}\u{3d}", "\u{3a}\u{3a}\u{3d}"),
        ("\u{2a75}", "\u{2a75}", "\u{2a75}", "\u{3d}\u{3d}", "\u{3d}\u{3d}"), ("\u{2a76}",
        "\u{2a76}", "\u{2a76}", "\u{3d}\u{3d}\u{3d}", "\u{3d}\u{3d}\u{3d}"), ("\u{2adc}",
        "\u{2add}\u{338}", "\u{2add}\u{338}", "\u{2add}\u{338}", "\u{2add}\u{338}"), ("\u{2c7c}",
        "\u{2c7c}", "\u{2c7c}", "\u{6a}", "\u{6a}"), ("\u{2c7d}", "\u{2c7d}", "\u{2c7d}", "\u{56}",
        "\u{56}"), ("\u{2d6f}", "\u{2d6f}", "\u{2d6f}", "\u{2d61}", "\u{2d61}"), ("\u{2e9f}",
        "\u{2e9f}", "\u{2e9f}", "\u{6bcd}", "\u{6bcd}"), ("\u{2ef3}", "\u{2ef3}", "\u{2ef3}",
        "\u{9f9f}", "\u{9f9f}"), ("\u{2f00}", "\u{2f00}", "\u{2f00}", "\u{4e00}", "\u{4e00}"),
        ("\u{2f01}", "\u{2f01}", "\u{2f01}", "\u{4e28}", "\u{4e28}"), ("\u{2f02}", "\u{2f02}",
        "\u{2f02}", "\u{4e36}", "\u{4e36}"), ("\u{2f03}", "\u{2f03}", "\u{2f03}", "\u{4e3f}",
        "\u{4e3f}"), ("\u{2f04}", "\u{2f04}", "\u{2f04}", "\u{4e59}", "\u{4e59}"), ("\u{2f05}",
        "\u{2f05}", "\u{2f05}", "\u{4e85}", "\u{4e85}"), ("\u{2f06}", "\u{2f06}", "\u{2f06}",
        "\u{4e8c}", "\u{4e8c}"), ("\u{2f07}", "\u{2f07}", "\u{2f07}", "\u{4ea0}", "\u{4ea0}"),
        ("\u{2f08}", "\u{2f08}", "\u{2f08}", "\u{4eba}", "\u{4eba}"), ("\u{2f09}", "\u{2f09}",
        "\u{2f09}", "\u{513f}", "\u{513f}"), ("\u{2f0a}", "\u{2f0a}", "\u{2f0a}", "\u{5165}",
        "\u{5165}"), ("\u{2f0b}", "\u{2f0b}", "\u{2f0b}", "\u{516b}", "\u{516b}"), ("\u{2f0c}",
        "\u{2f0c}", "\u{2f0c}", "\u{5182}", "\u{5182}"), ("\u{2f0d}", "\u{2f0d}", "\u{2f0d}",
        "\u{5196}", "\u{5196}"), ("\u{2f0e}", "\u{2f0e}", "\u{2f0e}", "\u{51ab}", "\u{51ab}"),
        ("\u{2f0f}", "\u{2f0f}", "\u{2f0f}", "\u{51e0}", "\u{51e0}"), ("\u{2f10}", "\u{2f10}",
        "\u{2f10}", "\u{51f5}", "\u{51f5}"), ("\u{2f11}", "\u{2f11}", "\u{2f11}", "\u{5200}",
        "\u{5200}"), ("\u{2f12}", "\u{2f12}", "\u{2f12}", "\u{529b}", "\u{529b}"), ("\u{2f13}",
        "\u{2f13}", "\u{2f13}", "\u{52f9}", "\u{52f9}"), ("\u{2f14}", "\u{2f14}", "\u{2f14}",
        "\u{5315}", "\u{5315}"), ("\u{2f15}", "\u{2f15}", "\u{2f15}", "\u{531a}", "\u{531a}"),
        ("\u{2f16}", "\u{2f16}", "\u{2f16}", "\u{5338}", "\u{5338}"), ("\u{2f17}", "\u{2f17}",
        "\u{2f17}", "\u{5341}", "\u{5341}"), ("\u{2f18}", "\u{2f18}", "\u{2f18}", "\u{535c}",
        "\u{535c}"), ("\u{2f19}", "\u{2f19}", "\u{2f19}", "\u{5369}", "\u{5369}"), ("\u{2f1a}",
        "\u{2f1a}", "\u{2f1a}", "\u{5382}", "\u{5382}"), ("\u{2f1b}", "\u{2f1b}", "\u{2f1b}",
        "\u{53b6}", "\u{53b6}"), ("\u{2f1c}", "\u{2f1c}", "\u{2f1c}", "\u{53c8}", "\u{53c8}"),
        ("\u{2f1d}", "\u{2f1d}", "\u{2f1d}", "\u{53e3}", "\u{53e3}"), ("\u{2f1e}", "\u{2f1e}",
        "\u{2f1e}", "\u{56d7}", "\u{56d7}"), ("\u{2f1f}", "\u{2f1f}", "\u{2f1f}", "\u{571f}",
        "\u{571f}"), ("\u{2f20}", "\u{2f20}", "\u{2f20}", "\u{58eb}", "\u{58eb}"), ("\u{2f21}",
        "\u{2f21}", "\u{2f21}", "\u{5902}", "\u{5902}"), ("\u{2f22}", "\u{2f22}", "\u{2f22}",
        "\u{590a}", "\u{590a}"), ("\u{2f23}", "\u{2f23}", "\u{2f23}", "\u{5915}", "\u{5915}"),
        ("\u{2f24}", "\u{2f24}", "\u{2f24}", "\u{5927}", "\u{5927}"), ("\u{2f25}", "\u{2f25}",
        "\u{2f25}", "\u{5973}", "\u{5973}"), ("\u{2f26}", "\u{2f26}", "\u{2f26}", "\u{5b50}",
        "\u{5b50}"), ("\u{2f27}", "\u{2f27}", "\u{2f27}", "\u{5b80}", "\u{5b80}"), ("\u{2f28}",
        "\u{2f28}", "\u{2f28}", "\u{5bf8}", "\u{5bf8}"), ("\u{2f29}", "\u{2f29}", "\u{2f29}",
        "\u{5c0f}", "\u{5c0f}"), ("\u{2f2a}", "\u{2f2a}", "\u{2f2a}", "\u{5c22}", "\u{5c22}"),
        ("\u{2f2b}", "\u{2f2b}", "\u{2f2b}", "\u{5c38}", "\u{5c38}"), ("\u{2f2c}", "\u{2f2c}",
        "\u{2f2c}", "\u{5c6e}", "\u{5c6e}"), ("\u{2f2d}", "\u{2f2d}", "\u{2f2d}", "\u{5c71}",
        "\u{5c71}"), ("\u{2f2e}", "\u{2f2e}", "\u{2f2e}", "\u{5ddb}", "\u{5ddb}"), ("\u{2f2f}",
        "\u{2f2f}", "\u{2f2f}", "\u{5de5}", "\u{5de5}"), ("\u{2f30}", "\u{2f30}", "\u{2f30}",
        "\u{5df1}", "\u{5df1}"), ("\u{2f31}", "\u{2f31}", "\u{2f31}", "\u{5dfe}", "\u{5dfe}"),
        ("\u{2f32}", "\u{2f32}", "\u{2f32}", "\u{5e72}", "\u{5e72}"), ("\u{2f33}", "\u{2f33}",
        "\u{2f33}", "\u{5e7a}", "\u{5e7a}"), ("\u{2f34}", "\u{2f34}", "\u{2f34}", "\u{5e7f}",
        "\u{5e7f}"), ("\u{2f35}", "\u{2f35}", "\u{2f35}", "\u{5ef4}", "\u{5ef4}"), ("\u{2f36}",
        "\u{2f36}", "\u{2f36}", "\u{5efe}", "\u{5efe}"), ("\u{2f37}", "\u{2f37}", "\u{2f37}",
        "\u{5f0b}", "\u{5f0b}"), ("\u{2f38}", "\u{2f38}", "\u{2f38}", "\u{5f13}", "\u{5f13}"),
        ("\u{2f39}", "\u{2f39}", "\u{2f39}", "\u{5f50}", "\u{5f50}"), ("\u{2f3a}", "\u{2f3a}",
        "\u{2f3a}", "\u{5f61}", "\u{5f61}"), ("\u{2f3b}", "\u{2f3b}", "\u{2f3b}", "\u{5f73}",
        "\u{5f73}"), ("\u{2f3c}", "\u{2f3c}", "\u{2f3c}", "\u{5fc3}", "\u{5fc3}"), ("\u{2f3d}",
        "\u{2f3d}", "\u{2f3d}", "\u{6208}", "\u{6208}"), ("\u{2f3e}", "\u{2f3e}", "\u{2f3e}",
        "\u{6236}", "\u{6236}"), ("\u{2f3f}", "\u{2f3f}", "\u{2f3f}", "\u{624b}", "\u{624b}"),
        ("\u{2f40}", "\u{2f40}", "\u{2f40}", "\u{652f}", "\u{652f}"), ("\u{2f41}", "\u{2f41}",
        "\u{2f41}", "\u{6534}", "\u{6534}"), ("\u{2f42}", "\u{2f42}", "\u{2f42}", "\u{6587}",
        "\u{6587}"), ("\u{2f43}", "\u{2f43}", "\u{2f43}", "\u{6597}", "\u{6597}"), ("\u{2f44}",
        "\u{2f44}", "\u{2f44}", "\u{65a4}", "\u{65a4}"), ("\u{2f45}", "\u{2f45}", "\u{2f45}",
        "\u{65b9}", "\u{65b9}"), ("\u{2f46}", "\u{2f46}", "\u{2f46}", "\u{65e0}", "\u{65e0}"),
        ("\u{2f47}", "\u{2f47}", "\u{2f47}", "\u{65e5}", "\u{65e5}"), ("\u{2f48}", "\u{2f48}",
        "\u{2f48}", "\u{66f0}", "\u{66f0}"), ("\u{2f49}", "\u{2f49}", "\u{2f49}", "\u{6708}",
        "\u{6708}"), ("\u{2f4a}", "\u{2f4a}", "\u{2f4a}", "\u{6728}", "\u{6728}"), ("\u{2f4b}",
        "\u{2f4b}", "\u{2f4b}", "\u{6b20}", "\u{6b20}"), ("\u{2f4c}", "\u{2f4c}", "\u{2f4c}",
        "\u{6b62}", "\u{6b62}"), ("\u{2f4d}", "\u{2f4d}", "\u{2f4d}", "\u{6b79}", "\u{6b79}"),
        ("\u{2f4e}", "\u{2f4e}", "\u{2f4e}", "\u{6bb3}", "\u{6bb3}"), ("\u{2f4f}", "\u{2f4f}",
        "\u{2f4f}", "\u{6bcb}", "\u{6bcb}"), ("\u{2f50}", "\u{2f50}", "\u{2f50}", "\u{6bd4}",
        "\u{6bd4}"), ("\u{2f51}", "\u{2f51}", "\u{2f51}", "\u{6bdb}", "\u{6bdb}"), ("\u{2f52}",
        "\u{2f52}", "\u{2f52}", "\u{6c0f}", "\u{6c0f}"), ("\u{2f53}", "\u{2f53}", "\u{2f53}",
        "\u{6c14}", "\u{6c14}"), ("\u{2f54}", "\u{2f54}", "\u{2f54}", "\u{6c34}", "\u{6c34}"),
        ("\u{2f55}", "\u{2f55}", "\u{2f55}", "\u{706b}", "\u{706b}"), ("\u{2f56}", "\u{2f56}",
        "\u{2f56}", "\u{722a}", "\u{722a}"), ("\u{2f57}", "\u{2f57}", "\u{2f57}", "\u{7236}",
        "\u{7236}"), ("\u{2f58}", "\u{2f58}", "\u{2f58}", "\u{723b}", "\u{723b}"), ("\u{2f59}",
        "\u{2f59}", "\u{2f59}", "\u{723f}", "\u{723f}"), ("\u{2f5a}", "\u{2f5a}", "\u{2f5a}",
        "\u{7247}", "\u{7247}"), ("\u{2f5b}", "\u{2f5b}", "\u{2f5b}", "\u{7259}", "\u{7259}"),
        ("\u{2f5c}", "\u{2f5c}", "\u{2f5c}", "\u{725b}", "\u{725b}"), ("\u{2f5d}", "\u{2f5d}",
        "\u{2f5d}", "\u{72ac}", "\u{72ac}"), ("\u{2f5e}", "\u{2f5e}", "\u{2f5e}", "\u{7384}",
        "\u{7384}"), ("\u{2f5f}", "\u{2f5f}", "\u{2f5f}", "\u{7389}", "\u{7389}"), ("\u{2f60}",
        "\u{2f60}", "\u{2f60}", "\u{74dc}", "\u{74dc}"), ("\u{2f61}", "\u{2f61}", "\u{2f61}",
        "\u{74e6}", "\u{74e6}"), ("\u{2f62}", "\u{2f62}", "\u{2f62}", "\u{7518}", "\u{7518}"),
        ("\u{2f63}", "\u{2f63}", "\u{2f63}", "\u{751f}", "\u{751f}"), ("\u{2f64}", "\u{2f64}",
        "\u{2f64}", "\u{7528}", "\u{7528}"), ("\u{2f65}", "\u{2f65}", "\u{2f65}", "\u{7530}",
        "\u{7530}"), ("\u{2f66}", "\u{2f66}", "\u{2f66}", "\u{758b}", "\u{758b}"), ("\u{2f67}",
        "\u{2f67}", "\u{2f67}", "\u{7592}", "\u{7592}"), ("\u{2f68}", "\u{2f68}", "\u{2f68}",
        "\u{7676}", "\u{7676}"), ("\u{2f69}", "\u{2f69}", "\u{2f69}", "\u{767d}", "\u{767d}"),
        ("\u{2f6a}", "\u{2f6a}", "\u{2f6a}", "\u{76ae}", "\u{76ae}"), ("\u{2f6b}", "\u{2f6b}",
        "\u{2f6b}", "\u{76bf}", "\u{76bf}"), ("\u{2f6c}", "\u{2f6c}", "\u{2f6c}", "\u{76ee}",
        "\u{76ee}"), ("\u{2f6d}", "\u{2f6d}", "\u{2f6d}", "\u{77db}", "\u{77db}"), ("\u{2f6e}",
        "\u{2f6e}", "\u{2f6e}", "\u{77e2}", "\u{77e2}"), ("\u{2f6f}", "\u{2f6f}", "\u{2f6f}",
        "\u{77f3}", "\u{77f3}"), ("\u{2f70}", "\u{2f70}", "\u{2f70}", "\u{793a}", "\u{793a}"),
        ("\u{2f71}", "\u{2f71}", "\u{2f71}", "\u{79b8}", "\u{79b8}"), ("\u{2f72}", "\u{2f72}",
        "\u{2f72}", "\u{79be}", "\u{79be}"), ("\u{2f73}", "\u{2f73}", "\u{2f73}", "\u{7a74}",
        "\u{7a74}"), ("\u{2f74}", "\u{2f74}", "\u{2f74}", "\u{7acb}", "\u{7acb}"), ("\u{2f75}",
        "\u{2f75}", "\u{2f75}", "\u{7af9}", "\u{7af9}"), ("\u{2f76}", "\u{2f76}", "\u{2f76}",
        "\u{7c73}", "\u{7c73}"), ("\u{2f77}", "\u{2f77}", "\u{2f77}", "\u{7cf8}", "\u{7cf8}"),
        ("\u{2f78}", "\u{2f78}", "\u{2f78}", "\u{7f36}", "\u{7f36}"), ("\u{2f79}", "\u{2f79}",
        "\u{2f79}", "\u{7f51}", "\u{7f51}"), ("\u{2f7a}", "\u{2f7a}", "\u{2f7a}", "\u{7f8a}",
        "\u{7f8a}"), ("\u{2f7b}", "\u{2f7b}", "\u{2f7b}", "\u{7fbd}", "\u{7fbd}"), ("\u{2f7c}",
        "\u{2f7c}", "\u{2f7c}", "\u{8001}", "\u{8001}"), ("\u{2f7d}", "\u{2f7d}", "\u{2f7d}",
        "\u{800c}", "\u{800c}"), ("\u{2f7e}", "\u{2f7e}", "\u{2f7e}", "\u{8012}", "\u{8012}"),
        ("\u{2f7f}", "\u{2f7f}", "\u{2f7f}", "\u{8033}", "\u{8033}"), ("\u{2f80}", "\u{2f80}",
        "\u{2f80}", "\u{807f}", "\u{807f}"), ("\u{2f81}", "\u{2f81}", "\u{2f81}", "\u{8089}",
        "\u{8089}"), ("\u{2f82}", "\u{2f82}", "\u{2f82}", "\u{81e3}", "\u{81e3}"), ("\u{2f83}",
        "\u{2f83}", "\u{2f83}", "\u{81ea}", "\u{81ea}"), ("\u{2f84}", "\u{2f84}", "\u{2f84}",
        "\u{81f3}", "\u{81f3}"), ("\u{2f85}", "\u{2f85}", "\u{2f85}", "\u{81fc}", "\u{81fc}"),
        ("\u{2f86}", "\u{2f86}", "\u{2f86}", "\u{820c}", "\u{820c}"), ("\u{2f87}", "\u{2f87}",
        "\u{2f87}", "\u{821b}", "\u{821b}"), ("\u{2f88}", "\u{2f88}", "\u{2f88}", "\u{821f}",
        "\u{821f}"), ("\u{2f89}", "\u{2f89}", "\u{2f89}", "\u{826e}", "\u{826e}"), ("\u{2f8a}",
        "\u{2f8a}", "\u{2f8a}", "\u{8272}", "\u{8272}"), ("\u{2f8b}", "\u{2f8b}", "\u{2f8b}",
        "\u{8278}", "\u{8278}"), ("\u{2f8c}", "\u{2f8c}", "\u{2f8c}", "\u{864d}", "\u{864d}"),
        ("\u{2f8d}", "\u{2f8d}", "\u{2f8d}", "\u{866b}", "\u{866b}"), ("\u{2f8e}", "\u{2f8e}",
        "\u{2f8e}", "\u{8840}", "\u{8840}"), ("\u{2f8f}", "\u{2f8f}", "\u{2f8f}", "\u{884c}",
        "\u{884c}"), ("\u{2f90}", "\u{2f90}", "\u{2f90}", "\u{8863}", "\u{8863}"), ("\u{2f91}",
        "\u{2f91}", "\u{2f91}", "\u{897e}", "\u{897e}"), ("\u{2f92}", "\u{2f92}", "\u{2f92}",
        "\u{898b}", "\u{898b}"), ("\u{2f93}", "\u{2f93}", "\u{2f93}", "\u{89d2}", "\u{89d2}"),
        ("\u{2f94}", "\u{2f94}", "\u{2f94}", "\u{8a00}", "\u{8a00}"), ("\u{2f95}", "\u{2f95}",
        "\u{2f95}", "\u{8c37}", "\u{8c37}"), ("\u{2f96}", "\u{2f96}", "\u{2f96}", "\u{8c46}",
        "\u{8c46}"), ("\u{2f97}", "\u{2f97}", "\u{2f97}", "\u{8c55}", "\u{8c55}"), ("\u{2f98}",
        "\u{2f98}", "\u{2f98}", "\u{8c78}", "\u{8c78}"), ("\u{2f99}", "\u{2f99}", "\u{2f99}",
        "\u{8c9d}", "\u{8c9d}"), ("\u{2f9a}", "\u{2f9a}", "\u{2f9a}", "\u{8d64}", "\u{8d64}"),
        ("\u{2f9b}", "\u{2f9b}", "\u{2f9b}", "\u{8d70}", "\u{8d70}"), ("\u{2f9c}", "\u{2f9c}",
        "\u{2f9c}", "\u{8db3}", "\u{8db3}"), ("\u{2f9d}", "\u{2f9d}", "\u{2f9d}", "\u{8eab}",
        "\u{8eab}"), ("\u{2f9e}", "\u{2f9e}", "\u{2f9e}", "\u{8eca}", "\u{8eca}"), ("\u{2f9f}",
        "\u{2f9f}", "\u{2f9f}", "\u{8f9b}", "\u{8f9b}"), ("\u{2fa0}", "\u{2fa0}", "\u{2fa0}",
        "\u{8fb0}", "\u{8fb0}"), ("\u{2fa1}", "\u{2fa1}", "\u{2fa1}", "\u{8fb5}", "\u{8fb5}"),
        ("\u{2fa2}", "\u{2fa2}", "\u{2fa2}", "\u{9091}", "\u{9091}"), ("\u{2fa3}", "\u{2fa3}",
        "\u{2fa3}", "\u{9149}", "\u{9149}"), ("\u{2fa4}", "\u{2fa4}", "\u{2fa4}", "\u{91c6}",
        "\u{91c6}"), ("\u{2fa5}", "\u{2fa5}", "\u{2fa5}", "\u{91cc}", "\u{91cc}"), ("\u{2fa6}",
        "\u{2fa6}", "\u{2fa6}", "\u{91d1}", "\u{91d1}"), ("\u{2fa7}", "\u{2fa7}", "\u{2fa7}",
        "\u{9577}", "\u{9577}"), ("\u{2fa8}", "\u{2fa8}", "\u{2fa8}", "\u{9580}", "\u{9580}"),
        ("\u{2fa9}", "\u{2fa9}", "\u{2fa9}", "\u{961c}", "\u{961c}"), ("\u{2faa}", "\u{2faa}",
        "\u{2faa}", "\u{96b6}", "\u{96b6}"), ("\u{2fab}", "\u{2fab}", "\u{2fab}", "\u{96b9}",
        "\u{96b9}"), ("\u{2fac}", "\u{2fac}", "\u{2fac}", "\u{96e8}", "\u{96e8}"), ("\u{2fad}",
        "\u{2fad}", "\u{2fad}", "\u{9751}", "\u{9751}"), ("\u{2fae}", "\u{2fae}", "\u{2fae}",
        "\u{975e}", "\u{975e}"), ("\u{2faf}", "\u{2faf}", "\u{2faf}", "\u{9762}", "\u{9762}"),
        ("\u{2fb0}", "\u{2fb0}", "\u{2fb0}", "\u{9769}", "\u{9769}"), ("\u{2fb1}", "\u{2fb1}",
        "\u{2fb1}", "\u{97cb}", "\u{97cb}"), ("\u{2fb2}", "\u{2fb2}", "\u{2fb2}", "\u{97ed}",
        "\u{97ed}"), ("\u{2fb3}", "\u{2fb3}", "\u{2fb3}", "\u{97f3}", "\u{97f3}"), ("\u{2fb4}",
        "\u{2fb4}", "\u{2fb4}", "\u{9801}", "\u{9801}"), ("\u{2fb5}", "\u{2fb5}", "\u{2fb5}",
        "\u{98a8}", "\u{98a8}"), ("\u{2fb6}", "\u{2fb6}", "\u{2fb6}", "\u{98db}", "\u{98db}"),
        ("\u{2fb7}", "\u{2fb7}", "\u{2fb7}", "\u{98df}", "\u{98df}"), ("\u{2fb8}", "\u{2fb8}",
        "\u{2fb8}", "\u{9996}", "\u{9996}"), ("\u{2fb9}", "\u{2fb9}", "\u{2fb9}", "\u{9999}",
        "\u{9999}"), ("\u{2fba}", "\u{2fba}", "\u{2fba}", "\u{99ac}", "\u{99ac}"), ("\u{2fbb}",
        "\u{2fbb}", "\u{2fbb}", "\u{9aa8}", "\u{9aa8}"), ("\u{2fbc}", "\u{2fbc}", "\u{2fbc}",
        "\u{9ad8}", "\u{9ad8}"), ("\u{2fbd}", "\u{2fbd}", "\u{2fbd}", "\u{9adf}", "\u{9adf}"),
        ("\u{2fbe}", "\u{2fbe}", "\u{2fbe}", "\u{9b25}", "\u{9b25}"), ("\u{2fbf}", "\u{2fbf}",
        "\u{2fbf}", "\u{9b2f}", "\u{9b2f}"), ("\u{2fc0}", "\u{2fc0}", "\u{2fc0}", "\u{9b32}",
        "\u{9b32}"), ("\u{2fc1}", "\u{2fc1}", "\u{2fc1}", "\u{9b3c}", "\u{9b3c}"), ("\u{2fc2}",
        "\u{2fc2}", "\u{2fc2}", "\u{9b5a}", "\u{9b5a}"), ("\u{2fc3}", "\u{2fc3}", "\u{2fc3}",
        "\u{9ce5}", "\u{9ce5}"), ("\u{2fc4}", "\u{2fc4}", "\u{2fc4}", "\u{9e75}", "\u{9e75}"),
        ("\u{2fc5}", "\u{2fc5}", "\u{2fc5}", "\u{9e7f}", "\u{9e7f}"), ("\u{2fc6}", "\u{2fc6}",
        "\u{2fc6}", "\u{9ea5}", "\u{9ea5}"), ("\u{2fc7}", "\u{2fc7}", "\u{2fc7}", "\u{9ebb}",
        "\u{9ebb}"), ("\u{2fc8}", "\u{2fc8}", "\u{2fc8}", "\u{9ec3}", "\u{9ec3}"), ("\u{2fc9}",
        "\u{2fc9}", "\u{2fc9}", "\u{9ecd}", "\u{9ecd}"), ("\u{2fca}", "\u{2fca}", "\u{2fca}",
        "\u{9ed1}", "\u{9ed1}"), ("\u{2fcb}", "\u{2fcb}", "\u{2fcb}", "\u{9ef9}", "\u{9ef9}"),
        ("\u{2fcc}", "\u{2fcc}", "\u{2fcc}", "\u{9efd}", "\u{9efd}"), ("\u{2fcd}", "\u{2fcd}",
        "\u{2fcd}", "\u{9f0e}", "\u{9f0e}"), ("\u{2fce}", "\u{2fce}", "\u{2fce}", "\u{9f13}",
        "\u{9f13}"), ("\u{2fcf}", "\u{2fcf}", "\u{2fcf}", "\u{9f20}", "\u{9f20}"), ("\u{2fd0}",
        "\u{2fd0}", "\u{2fd0}", "\u{9f3b}", "\u{9f3b}"), ("\u{2fd1}", "\u{2fd1}", "\u{2fd1}",
        "\u{9f4a}", "\u{9f4a}"), ("\u{2fd2}", "\u{2fd2}", "\u{2fd2}", "\u{9f52}", "\u{9f52}"),
        ("\u{2fd3}", "\u{2fd3}", "\u{2fd3}", "\u{9f8d}", "\u{9f8d}"), ("\u{2fd4}", "\u{2fd4}",
        "\u{2fd4}", "\u{9f9c}", "\u{9f9c}"), ("\u{2fd5}", "\u{2fd5}", "\u{2fd5}", "\u{9fa0}",
        "\u{9fa0}"), ("\u{3000}", "\u{3000}", "\u{3000}", "\u{20}", "\u{20}"), ("\u{3036}",
        "\u{3036}", "\u{3036}", "\u{3012}", "\u{3012}"), ("\u{3038}", "\u{3038}", "\u{3038}",
        "\u{5341}", "\u{5341}"), ("\u{3039}", "\u{3039}", "\u{3039}", "\u{5344}", "\u{5344}"),
        ("\u{303a}", "\u{303a}", "\u{303a}", "\u{5345}", "\u{5345}"), ("\u{304c}", "\u{304c}",
        "\u{304b}\u{3099}", "\u{304c}", "\u{304b}\u{3099}"), ("\u{304e}", "\u{304e}",
        "\u{304d}\u{3099}", "\u{304e}", "\u{304d}\u{3099}"), ("\u{3050}", "\u{3050}",
        "\u{304f}\u{3099}", "\u{3050}", "\u{304f}\u{3099}"), ("\u{3052}", "\u{3052}",
        "\u{3051}\u{3099}", "\u{3052}", "\u{3051}\u{3099}"), ("\u{3054}", "\u{3054}",
        "\u{3053}\u{3099}", "\u{3054}", "\u{3053}\u{3099}"), ("\u{3056}", "\u{3056}",
        "\u{3055}\u{3099}", "\u{3056}", "\u{3055}\u{3099}"), ("\u{3058}", "\u{3058}",
        "\u{3057}\u{3099}", "\u{3058}", "\u{3057}\u{3099}"), ("\u{305a}", "\u{305a}",
        "\u{3059}\u{3099}", "\u{305a}", "\u{3059}\u{3099}"), ("\u{305c}", "\u{305c}",
        "\u{305b}\u{3099}", "\u{305c}", "\u{305b}\u{3099}"), ("\u{305e}", "\u{305e}",
        "\u{305d}\u{3099}", "\u{305e}", "\u{305d}\u{3099}"), ("\u{3060}", "\u{3060}",
        "\u{305f}\u{3099}", "\u{3060}", "\u{305f}\u{3099}"), ("\u{3062}", "\u{3062}",
        "\u{3061}\u{3099}", "\u{3062}", "\u{3061}\u{3099}"), ("\u{3065}", "\u{3065}",
        "\u{3064}\u{3099}", "\u{3065}", "\u{3064}\u{3099}"), ("\u{3067}", "\u{3067}",
        "\u{3066}\u{3099}", "\u{3067}", "\u{3066}\u{3099}"), ("\u{3069}", "\u{3069}",
        "\u{3068}\u{3099}", "\u{3069}", "\u{3068}\u{3099}"), ("\u{3070}", "\u{3070}",
        "\u{306f}\u{3099}", "\u{3070}", "\u{306f}\u{3099}"), ("\u{3071}", "\u{3071}",
        "\u{306f}\u{309a}", "\u{3071}", "\u{306f}\u{309a}"), ("\u{3073}", "\u{3073}",
        "\u{3072}\u{3099}", "\u{3073}", "\u{3072}\u{3099}"), ("\u{3074}", "\u{3074}",
        "\u{3072}\u{309a}", "\u{3074}", "\u{3072}\u{309a}"), ("\u{3076}", "\u{3076}",
        "\u{3075}\u{3099}", "\u{3076}", "\u{3075}\u{3099}"), ("\u{3077}", "\u{3077}",
        "\u{3075}\u{309a}", "\u{3077}", "\u{3075}\u{309a}"), ("\u{3079}", "\u{3079}",
        "\u{3078}\u{3099}", "\u{3079}", "\u{3078}\u{3099}"), ("\u{307a}", "\u{307a}",
        "\u{3078}\u{309a}", "\u{307a}", "\u{3078}\u{309a}"), ("\u{307c}", "\u{307c}",
        "\u{307b}\u{3099}", "\u{307c}", "\u{307b}\u{3099}"), ("\u{307d}", "\u{307d}",
        "\u{307b}\u{309a}", "\u{307d}", "\u{307b}\u{309a}"), ("\u{3094}", "\u{3094}",
        "\u{3046}\u{3099}", "\u{3094}", "\u{3046}\u{3099}"), ("\u{309b}", "\u{309b}", "\u{309b}",
        "\u{20}\u{3099}", "\u{20}\u{3099}"), ("\u{309c}", "\u{309c}", "\u{309c}", "\u{20}\u{309a}",
        "\u{20}\u{309a}"), ("\u{309e}", "\u{309e}", "\u{309d}\u{3099}", "\u{309e}",
        "\u{309d}\u{3099}"), ("\u{309f}", "\u{309f}", "\u{309f}", "\u{3088}\u{308a}",
        "\u{3088}\u{308a}"), ("\u{30ac}", "\u{30ac}", "\u{30ab}\u{3099}", "\u{30ac}",
        "\u{30ab}\u{3099}"), ("\u{30ae}", "\u{30ae}", "\u{30ad}\u{3099}", "\u{30ae}",
        "\u{30ad}\u{3099}"), ("\u{30b0}", "\u{30b0}", "\u{30af}\u{3099}", "\u{30b0}",
        "\u{30af}\u{3099}"), ("\u{30b2}", "\u{30b2}", "\u{30b1}\u{3099}", "\u{30b2}",
        "\u{30b1}\u{3099}"), ("\u{30b4}", "\u{30b4}", "\u{30b3}\u{3099}", "\u{30b4}",
        "\u{30b3}\u{3099}"), ("\u{30b6}", "\u{30b6}", "\u{30b5}\u{3099}", "\u{30b6}",
        "\u{30b5}\u{3099}"), ("\u{30b8}", "\u{30b8}", "\u{30b7}\u{3099}", "\u{30b8}",
        "\u{30b7}\u{3099}"), ("\u{30ba}", "\u{30ba}", "\u{30b9}\u{3099}", "\u{30ba}",
        "\u{30b9}\u{3099}"), ("\u{30bc}", "\u{30bc}", "\u{30bb}\u{3099}", "\u{30bc}",
        "\u{30bb}\u{3099}"), ("\u{30be}", "\u{30be}", "\u{30bd}\u{3099}", "\u{30be}",
        "\u{30bd}\u{3099}"), ("\u{30c0}", "\u{30c0}", "\u{30bf}\u{3099}", "\u{30c0}",
        "\u{30bf}\u{3099}"), ("\u{30c2}", "\u{30c2}", "\u{30c1}\u{3099}", "\u{30c2}",
        "\u{30c1}\u{3099}"), ("\u{30c5}", "\u{30c5}", "\u{30c4}\u{3099}", "\u{30c5}",
        "\u{30c4}\u{3099}"), ("\u{30c7}", "\u{30c7}", "\u{30c6}\u{3099}", "\u{30c7}",
        "\u{30c6}\u{3099}"), ("\u{30c9}", "\u{30c9}", "\u{30c8}\u{3099}", "\u{30c9}",
        "\u{30c8}\u{3099}"), ("\u{30d0}", "\u{30d0}", "\u{30cf}\u{3099}", "\u{30d0}",
        "\u{30cf}\u{3099}"), ("\u{30d1}", "\u{30d1}", "\u{30cf}\u{309a}", "\u{30d1}",
        "\u{30cf}\u{309a}"), ("\u{30d3}", "\u{30d3}", "\u{30d2}\u{3099}", "\u{30d3}",
        "\u{30d2}\u{3099}"), ("\u{30d4}", "\u{30d4}", "\u{30d2}\u{309a}", "\u{30d4}",
        "\u{30d2}\u{309a}"), ("\u{30d6}", "\u{30d6}", "\u{30d5}\u{3099}", "\u{30d6}",
        "\u{30d5}\u{3099}"), ("\u{30d7}", "\u{30d7}", "\u{30d5}\u{309a}", "\u{30d7}",
        "\u{30d5}\u{309a}"), ("\u{30d9}", "\u{30d9}", "\u{30d8}\u{3099}", "\u{30d9}",
        "\u{30d8}\u{3099}"), ("\u{30da}", "\u{30da}", "\u{30d8}\u{309a}", "\u{30da}",
        "\u{30d8}\u{309a}"), ("\u{30dc}", "\u{30dc}", "\u{30db}\u{3099}", "\u{30dc}",
        "\u{30db}\u{3099}"), ("\u{30dd}", "\u{30dd}", "\u{30db}\u{309a}", "\u{30dd}",
        "\u{30db}\u{309a}"), ("\u{30f4}", "\u{30f4}", "\u{30a6}\u{3099}", "\u{30f4}",
        "\u{30a6}\u{3099}"), ("\u{30f7}", "\u{30f7}", "\u{30ef}\u{3099}", "\u{30f7}",
        "\u{30ef}\u{3099}"), ("\u{30f8}", "\u{30f8}", "\u{30f0}\u{3099}", "\u{30f8}",
        "\u{30f0}\u{3099}"), ("\u{30f9}", "\u{30f9}", "\u{30f1}\u{3099}", "\u{30f9}",
        "\u{30f1}\u{3099}"), ("\u{30fa}", "\u{30fa}", "\u{30f2}\u{3099}", "\u{30fa}",
        "\u{30f2}\u{3099}"), ("\u{30fe}", "\u{30fe}", "\u{30fd}\u{3099}", "\u{30fe}",
        "\u{30fd}\u{3099}"), ("\u{30ff}", "\u{30ff}", "\u{30ff}", "\u{30b3}\u{30c8}",
        "\u{30b3}\u{30c8}"), ("\u{3131}", "\u{3131}", "\u{3131}", "\u{1100}", "\u{1100}"),
        ("\u{3132}", "\u{3132}", "\u{3132}", "\u{1101}", "\u{1101}"), ("\u{3133}", "\u{3133}",
        "\u{3133}", "\u{11aa}", "\u{11aa}"), ("\u{3134}", "\u{3134}", "\u{3134}", "\u{1102}",
        "\u{1102}"), ("\u{3135}", "\u{3135}", "\u{3135}", "\u{11ac}", "\u{11ac}"), ("\u{3136}",
        "\u{3136}", "\u{3136}", "\u{11ad}", "\u{11ad}"), ("\u{3137}", "\u{3137}", "\u{3137}",
        "\u{1103}", "\u{1103}"), ("\u{3138}", "\u{3138}", "\u{3138}", "\u{1104}", "\u{1104}"),
        ("\u{3139}", "\u{3139}", "\u{3139}", "\u{1105}", "\u{1105}"), ("\u{313a}", "\u{313a}",
        "\u{313a}", "\u{11b0}", "\u{11b0}"), ("\u{313b}", "\u{313b}", "\u{313b}", "\u{11b1}",
        "\u{11b1}"), ("\u{313c}", "\u{313c}", "\u{313c}", "\u{11b2}", "\u{11b2}"), ("\u{313d}",
        "\u{313d}", "\u{313d}", "\u{11b3}", "\u{11b3}"), ("\u{313e}", "\u{313e}", "\u{313e}",
        "\u{11b4}", "\u{11b4}"), ("\u{313f}", "\u{313f}", "\u{313f}", "\u{11b5}", "\u{11b5}"),
        ("\u{3140}", "\u{3140}", "\u{3140}", "\u{111a}", "\u{111a}"), ("\u{3141}", "\u{3141}",
        "\u{3141}", "\u{1106}", "\u{1106}"), ("\u{3142}", "\u{3142}", "\u{3142}", "\u{1107}",
        "\u{1107}"), ("\u{3143}", "\u{3143}", "\u{3143}", "\u{1108}", "\u{1108}"), ("\u{3144}",
        "\u{3144}", "\u{3144}", "\u{1121}", "\u{1121}"), ("\u{3145}", "\u{3145}", "\u{3145}",
        "\u{1109}", "\u{1109}"), ("\u{3146}", "\u{3146}", "\u{3146}", "\u{110a}", "\u{110a}"),
        ("\u{3147}", "\u{3147}", "\u{3147}", "\u{110b}", "\u{110b}"), ("\u{3148}", "\u{3148}",
        "\u{3148}", "\u{110c}", "\u{110c}"), ("\u{3149}", "\u{3149}", "\u{3149}", "\u{110d}",
        "\u{110d}"), ("\u{314a}", "\u{314a}", "\u{314a}", "\u{110e}", "\u{110e}"), ("\u{314b}",
        "\u{314b}", "\u{314b}", "\u{110f}", "\u{110f}"), ("\u{314c}", "\u{314c}", "\u{314c}",
        "\u{1110}", "\u{1110}"), ("\u{314d}", "\u{314d}", "\u{314d}", "\u{1111}", "\u{1111}"),
        ("\u{314e}", "\u{314e}", "\u{314e}", "\u{1112}", "\u{1112}"), ("\u{314f}", "\u{314f}",
        "\u{314f}", "\u{1161}", "\u{1161}"), ("\u{3150}", "\u{3150}", "\u{3150}", "\u{1162}",
        "\u{1162}"), ("\u{3151}", "\u{3151}", "\u{3151}", "\u{1163}", "\u{1163}"), ("\u{3152}",
        "\u{3152}", "\u{3152}", "\u{1164}", "\u{1164}"), ("\u{3153}", "\u{3153}", "\u{3153}",
        "\u{1165}", "\u{1165}"), ("\u{3154}", "\u{3154}", "\u{3154}", "\u{1166}", "\u{1166}"),
        ("\u{3155}", "\u{3155}", "\u{3155}", "\u{1167}", "\u{1167}"), ("\u{3156}", "\u{3156}",
        "\u{3156}", "\u{1168}", "\u{1168}"), ("\u{3157}", "\u{3157}", "\u{3157}", "\u{1169}",
        "\u{1169}"), ("\u{3158}", "\u{3158}", "\u{3158}", "\u{116a}", "\u{116a}"), ("\u{3159}",
        "\u{3159}", "\u{3159}", "\u{116b}", "\u{116b}"), ("\u{315a}", "\u{315a}", "\u{315a}",
        "\u{116c}", "\u{116c}"), ("\u{315b}", "\u{315b}", "\u{315b}", "\u{116d}", "\u{116d}"),
        ("\u{315c}", "\u{315c}", "\u{315c}", "\u{116e}", "\u{116e}"), ("\u{315d}", "\u{315d}",
        "\u{315d}", "\u{116f}", "\u{116f}"), ("\u{315e}", "\u{315e}", "\u{315e}", "\u{1170}",
        "\u{1170}"), ("\u{315f}", "\u{315f}", "\u{315f}", "\u{1171}", "\u{1171}"), ("\u{3160}",
        "\u{3160}", "\u{3160}", "\u{1172}", "\u{1172}"), ("\u{3161}", "\u{3161}", "\u{3161}",
        "\u{1173}", "\u{1173}"), ("\u{3162}", "\u{3162}", "\u{3162}", "\u{1174}", "\u{1174}"),
        ("\u{3163}", "\u{3163}", "\u{3163}", "\u{1175}", "\u{1175}"), ("\u{3164}", "\u{3164}",
        "\u{3164}", "\u{1160}", "\u{1160}"), ("\u{3165}", "\u{3165}", "\u{3165}", "\u{1114}",
        "\u{1114}"), ("\u{3166}", "\u{3166}", "\u{3166}", "\u{1115}", "\u{1115}"), ("\u{3167}",
        "\u{3167}", "\u{3167}", "\u{11c7}", "\u{11c7}"), ("\u{3168}", "\u{3168}", "\u{3168}",
        "\u{11c8}", "\u{11c8}"), ("\u{3169}", "\u{3169}", "\u{3169}", "\u{11cc}", "\u{11cc}"),
        ("\u{316a}", "\u{316a}", "\u{316a}", "\u{11ce}", "\u{11ce}"), ("\u{316b}", "\u{316b}",
        "\u{316b}", "\u{11d3}", "\u{11d3}"), ("\u{316c}", "\u{316c}", "\u{316c}", "\u{11d7}",
        "\u{11d7}"), ("\u{316d}", "\u{316d}", "\u{316d}", "\u{11d9}", "\u{11d9}"), ("\u{316e}",
        "\u{316e}", "\u{316e}", "\u{111c}", "\u{111c}"), ("\u{316f}", "\u{316f}", "\u{316f}",
        "\u{11dd}", "\u{11dd}"), ("\u{3170}", "\u{3170}", "\u{3170}", "\u{11df}", "\u{11df}"),
        ("\u{3171}", "\u{3171}", "\u{3171}", "\u{111d}", "\u{111d}"), ("\u{3172}", "\u{3172}",
        "\u{3172}", "\u{111e}", "\u{111e}"), ("\u{3173}", "\u{3173}", "\u{3173}", "\u{1120}",
        "\u{1120}"), ("\u{3174}", "\u{3174}", "\u{3174}", "\u{1122}", "\u{1122}"), ("\u{3175}",
        "\u{3175}", "\u{3175}", "\u{1123}", "\u{1123}"), ("\u{3176}", "\u{3176}", "\u{3176}",
        "\u{1127}", "\u{1127}"), ("\u{3177}", "\u{3177}", "\u{3177}", "\u{1129}", "\u{1129}"),
        ("\u{3178}", "\u{3178}", "\u{3178}", "\u{112b}", "\u{112b}"), ("\u{3179}", "\u{3179}",
        "\u{3179}", "\u{112c}", "\u{112c}"), ("\u{317a}", "\u{317a}", "\u{317a}", "\u{112d}",
        "\u{112d}"), ("\u{317b}", "\u{317b}", "\u{317b}", "\u{112e}", "\u{112e}"), ("\u{317c}",
        "\u{317c}", "\u{317c}", "\u{112f}", "\u{112f}"), ("\u{317d}", "\u{317d}", "\u{317d}",
        "\u{1132}", "\u{1132}"), ("\u{317e}", "\u{317e}", "\u{317e}", "\u{1136}", "\u{1136}"),
        ("\u{317f}", "\u{317f}", "\u{317f}", "\u{1140}", "\u{1140}"), ("\u{3180}", "\u{3180}",
        "\u{3180}", "\u{1147}", "\u{1147}"), ("\u{3181}", "\u{3181}", "\u{3181}", "\u{114c}",
        "\u{114c}"), ("\u{3182}", "\u{3182}", "\u{3182}", "\u{11f1}", "\u{11f1}"), ("\u{3183}",
        "\u{3183}", "\u{3183}", "\u{11f2}", "\u{11f2}"), ("\u{3184}", "\u{3184}", "\u{3184}",
        "\u{1157}", "\u{1157}"), ("\u{3185}", "\u{3185}", "\u{3185}", "\u{1158}", "\u{1158}"),
        ("\u{3186}", "\u{3186}", "\u{3186}", "\u{1159}", "\u{1159}"), ("\u{3187}", "\u{3187}",
        "\u{3187}", "\u{1184}", "\u{1184}"), ("\u{3188}", "\u{3188}", "\u{3188}", "\u{1185}",
        "\u{1185}"), ("\u{3189}", "\u{3189}", "\u{3189}", "\u{1188}", "\u{1188}"), ("\u{318a}",
        "\u{318a}", "\u{318a}", "\u{1191}", "\u{1191}"), ("\u{318b}", "\u{318b}", "\u{318b}",
        "\u{1192}", "\u{1192}"), ("\u{318c}", "\u{318c}", "\u{318c}", "\u{1194}", "\u{1194}"),
        ("\u{318d}", "\u{318d}", "\u{318d}", "\u{119e}", "\u{119e}"), ("\u{318e}", "\u{318e}",
        "\u{318e}", "\u{11a1}", "\u{11a1}"), ("\u{3192}", "\u{3192}", "\u{3192}", "\u{4e00}",
        "\u{4e00}"), ("\u{3193}", "\u{3193}", "\u{3193}", "\u{4e8c}", "\u{4e8c}"), ("\u{3194}",
        "\u{3194}", "\u{3194}", "\u{4e09}", "\u{4e09}"), ("\u{3195}", "\u{3195}", "\u{3195}",
        "\u{56db}", "\u{56db}"), ("\u{3196}", "\u{3196}", "\u{3196}", "\u{4e0a}", "\u{4e0a}"),
        ("\u{3197}", "\u{3197}", "\u{3197}", "\u{4e2d}", "\u{4e2d}"), ("\u{3198}", "\u{3198}",
        "\u{3198}", "\u{4e0b}", "\u{4e0b}"), ("\u{3199}", "\u{3199}", "\u{3199}", "\u{7532}",
        "\u{7532}"), ("\u{319a}", "\u{319a}", "\u{319a}", "\u{4e59}", "\u{4e59}"), ("\u{319b}",
        "\u{319b}", "\u{319b}", "\u{4e19}", "\u{4e19}"), ("\u{319c}", "\u{319c}", "\u{319c}",
        "\u{4e01}", "\u{4e01}"), ("\u{319d}", "\u{319d}", "\u{319d}", "\u{5929}", "\u{5929}"),
        ("\u{319e}", "\u{319e}", "\u{319e}", "\u{5730}", "\u{5730}"), ("\u{319f}", "\u{319f}",
        "\u{319f}", "\u{4eba}", "\u{4eba}"), ("\u{3200}", "\u{3200}", "\u{3200}",
        "\u{28}\u{1100}\u{29}", "\u{28}\u{1100}\u{29}"), ("\u{3201}", "\u{3201}", "\u{3201}",
        "\u{28}\u{1102}\u{29}", "\u{28}\u{1102}\u{29}"), ("\u{3202}", "\u{3202}", "\u{3202}",
        "\u{28}\u{1103}\u{29}", "\u{28}\u{1103}\u{29}"), ("\u{3203}", "\u{3203}", "\u{3203}",
        "\u{28}\u{1105}\u{29}", "\u{28}\u{1105}\u{29}"), ("\u{3204}", "\u{3204}", "\u{3204}",
        "\u{28}\u{1106}\u{29}", "\u{28}\u{1106}\u{29}"), ("\u{3205}", "\u{3205}", "\u{3205}",
        "\u{28}\u{1107}\u{29}", "\u{28}\u{1107}\u{29}"), ("\u{3206}", "\u{3206}", "\u{3206}",
        "\u{28}\u{1109}\u{29}", "\u{28}\u{1109}\u{29}"), ("\u{3207}", "\u{3207}", "\u{3207}",
        "\u{28}\u{110b}\u{29}", "\u{28}\u{110b}\u{29}"), ("\u{3208}", "\u{3208}", "\u{3208}",
        "\u{28}\u{110c}\u{29}", "\u{28}\u{110c}\u{29}"), ("\u{3209}", "\u{3209}", "\u{3209}",
        "\u{28}\u{110e}\u{29}", "\u{28}\u{110e}\u{29}"), ("\u{320a}", "\u{320a}", "\u{320a}",
        "\u{28}\u{110f}\u{29}", "\u{28}\u{110f}\u{29}"), ("\u{320b}", "\u{320b}", "\u{320b}",
        "\u{28}\u{1110}\u{29}", "\u{28}\u{1110}\u{29}"), ("\u{320c}", "\u{320c}", "\u{320c}",
        "\u{28}\u{1111}\u{29}", "\u{28}\u{1111}\u{29}"), ("\u{320d}", "\u{320d}", "\u{320d}",
        "\u{28}\u{1112}\u{29}", "\u{28}\u{1112}\u{29}"), ("\u{320e}", "\u{320e}", "\u{320e}",
        "\u{28}\u{ac00}\u{29}", "\u{28}\u{1100}\u{1161}\u{29}"), ("\u{320f}", "\u{320f}",
        "\u{320f}", "\u{28}\u{b098}\u{29}", "\u{28}\u{1102}\u{1161}\u{29}"), ("\u{3210}",
        "\u{3210}", "\u{3210}", "\u{28}\u{b2e4}\u{29}", "\u{28}\u{1103}\u{1161}\u{29}"),
        ("\u{3211}", "\u{3211}", "\u{3211}", "\u{28}\u{b77c}\u{29}",
        "\u{28}\u{1105}\u{1161}\u{29}"), ("\u{3212}", "\u{3212}", "\u{3212}",
        "\u{28}\u{b9c8}\u{29}", "\u{28}\u{1106}\u{1161}\u{29}"), ("\u{3213}", "\u{3213}",
        "\u{3213}", "\u{28}\u{bc14}\u{29}", "\u{28}\u{1107}\u{1161}\u{29}"), ("\u{3214}",
        "\u{3214}", "\u{3214}", "\u{28}\u{c0ac}\u{29}", "\u{28}\u{1109}\u{1161}\u{29}"),
        ("\u{3215}", "\u{3215}", "\u{3215}", "\u{28}\u{c544}\u{29}",
        "\u{28}\u{110b}\u{1161}\u{29}"), ("\u{3216}", "\u{3216}", "\u{3216}",
        "\u{28}\u{c790}\u{29}", "\u{28}\u{110c}\u{1161}\u{29}"), ("\u{3217}", "\u{3217}",
        "\u{3217}", "\u{28}\u{cc28}\u{29}", "\u{28}\u{110e}\u{1161}\u{29}"), ("\u{3218}",
        "\u{3218}", "\u{3218}", "\u{28}\u{ce74}\u{29}", "\u{28}\u{110f}\u{1161}\u{29}"),
        ("\u{3219}", "\u{3219}", "\u{3219}", "\u{28}\u{d0c0}\u{29}",
        "\u{28}\u{1110}\u{1161}\u{29}"), ("\u{321a}", "\u{321a}", "\u{321a}",
        "\u{28}\u{d30c}\u{29}", "\u{28}\u{1111}\u{1161}\u{29}"), ("\u{321b}", "\u{321b}",
        "\u{321b}", "\u{28}\u{d558}\u{29}", "\u{28}\u{1112}\u{1161}\u{29}"), ("\u{321c}",
        "\u{321c}", "\u{321c}", "\u{28}\u{c8fc}\u{29}", "\u{28}\u{110c}\u{116e}\u{29}"),
        ("\u{321d}", "\u{321d}", "\u{321d}", "\u{28}\u{c624}\u{c804}\u{29}",
        "\u{28}\u{110b}\u{1169}\u{110c}\u{1165}\u{11ab}\u{29}"), ("\u{321e}", "\u{321e}",
        "\u{321e}", "\u{28}\u{c624}\u{d6c4}\u{29}", "\u{28}\u{110b}\u{1169}\u{1112}\u{116e}\u{29}"),
        ("\u{3220}", "\u{3220}", "\u{3220}", "\u{28}\u{4e00}\u{29}", "\u{28}\u{4e00}\u{29}"),
        ("\u{3221}", "\u{3221}", "\u{3221}", "\u{28}\u{4e8c}\u{29}", "\u{28}\u{4e8c}\u{29}"),
        ("\u{3222}", "\u{3222}", "\u{3222}", "\u{28}\u{4e09}\u{29}", "\u{28}\u{4e09}\u{29}"),
        ("\u{3223}", "\u{3223}", "\u{3223}", "\u{28}\u{56db}\u{29}", "\u{28}\u{56db}\u{29}"),
        ("\u{3224}", "\u{3224}", "\u{3224}", "\u{28}\u{4e94}\u{29}", "\u{28}\u{4e94}\u{29}"),
        ("\u{3225}", "\u{3225}", "\u{3225}", "\u{28}\u{516d}\u{29}", "\u{28}\u{516d}\u{29}"),
        ("\u{3226}", "\u{3226}", "\u{3226}", "\u{28}\u{4e03}\u{29}", "\u{28}\u{4e03}\u{29}"),
        ("\u{3227}", "\u{3227}", "\u{3227}", "\u{28}\u{516b}\u{29}", "\u{28}\u{516b}\u{29}"),
        ("\u{3228}", "\u{3228}", "\u{3228}", "\u{28}\u{4e5d}\u{29}", "\u{28}\u{4e5d}\u{29}"),
        ("\u{3229}", "\u{3229}", "\u{3229}", "\u{28}\u{5341}\u{29}", "\u{28}\u{5341}\u{29}"),
        ("\u{322a}", "\u{322a}", "\u{322a}", "\u{28}\u{6708}\u{29}", "\u{28}\u{6708}\u{29}"),
        ("\u{322b}", "\u{322b}", "\u{322b}", "\u{28}\u{706b}\u{29}", "\u{28}\u{706b}\u{29}"),
        ("\u{322c}", "\u{322c}", "\u{322c}", "\u{28}\u{6c34}\u{29}", "\u{28}\u{6c34}\u{29}"),
        ("\u{322d}", "\u{322d}", "\u{322d}", "\u{28}\u{6728}\u{29}", "\u{28}\u{6728}\u{29}"),
        ("\u{322e}", "\u{322e}", "\u{322e}", "\u{28}\u{91d1}\u{29}", "\u{28}\u{91d1}\u{29}"),
        ("\u{322f}", "\u{322f}", "\u{322f}", "\u{28}\u{571f}\u{29}", "\u{28}\u{571f}\u{29}"),
        ("\u{3230}", "\u{3230}", "\u{3230}", "\u{28}\u{65e5}\u{29}", "\u{28}\u{65e5}\u{29}"),
        ("\u{3231}", "\u{3231}", "\u{3231}", "\u{28}\u{682a}\u{29}", "\u{28}\u{682a}\u{29}"),
        ("\u{3232}", "\u{3232}", "\u{3232}", "\u{28}\u{6709}\u{29}", "\u{28}\u{6709}\u{29}"),
        ("\u{3233}", "\u{3233}", "\u{3233}", "\u{28}\u{793e}\u{29}", "\u{28}\u{793e}\u{29}"),
        ("\u{3234}", "\u{3234}", "\u{3234}", "\u{28}\u{540d}\u{29}", "\u{28}\u{540d}\u{29}"),
        ("\u{3235}", "\u{3235}", "\u{3235}", "\u{28}\u{7279}\u{29}", "\u{28}\u{7279}\u{29}"),
        ("\u{3236}", "\u{3236}", "\u{3236}", "\u{28}\u{8ca1}\u{29}", "\u{28}\u{8ca1}\u{29}"),
        ("\u{3237}", "\u{3237}", "\u{3237}", "\u{28}\u{795d}\u{29}", "\u{28}\u{795d}\u{29}"),
        ("\u{3238}", "\u{3238}", "\u{3238}", "\u{28}\u{52b4}\u{29}", "\u{28}\u{52b4}\u{29}"),
        ("\u{3239}", "\u{3239}", "\u{3239}", "\u{28}\u{4ee3}\u{29}", "\u{28}\u{4ee3}\u{29}"),
        ("\u{323a}", "\u{323a}", "\u{323a}", "\u{28}\u{547c}\u{29}", "\u{28}\u{547c}\u{29}"),
        ("\u{323b}", "\u{323b}", "\u{323b}", "\u{28}\u{5b66}\u{29}", "\u{28}\u{5b66}\u{29}"),
        ("\u{323c}", "\u{323c}", "\u{323c}", "\u{28}\u{76e3}\u{29}", "\u{28}\u{76e3}\u{29}"),
        ("\u{323d}", "\u{323d}", "\u{323d}", "\u{28}\u{4f01}\u{29}", "\u{28}\u{4f01}\u{29}"),
        ("\u{323e}", "\u{323e}", "\u{323e}", "\u{28}\u{8cc7}\u{29}", "\u{28}\u{8cc7}\u{29}"),
        ("\u{323f}", "\u{323f}", "\u{323f}", "\u{28}\u{5354}\u{29}", "\u{28}\u{5354}\u{29}"),
        ("\u{3240}", "\u{3240}", "\u{3240}", "\u{28}\u{796d}\u{29}", "\u{28}\u{796d}\u{29}"),
        ("\u{3241}", "\u{3241}", "\u{3241}", "\u{28}\u{4f11}\u{29}", "\u{28}\u{4f11}\u{29}"),
        ("\u{3242}", "\u{3242}", "\u{3242}", "\u{28}\u{81ea}\u{29}", "\u{28}\u{81ea}\u{29}"),
        ("\u{3243}", "\u{3243}", "\u{3243}", "\u{28}\u{81f3}\u{29}", "\u{28}\u{81f3}\u{29}"),
        ("\u{3244}", "\u{3244}", "\u{3244}", "\u{554f}", "\u{554f}"), ("\u{3245}", "\u{3245}",
        "\u{3245}", "\u{5e7c}", "\u{5e7c}"), ("\u{3246}", "\u{3246}", "\u{3246}", "\u{6587}",
        "\u{6587}"), ("\u{3247}", "\u{3247}", "\u{3247}", "\u{7b8f}", "\u{7b8f}"), ("\u{3250}",
        "\u{3250}", "\u{3250}", "\u{50}\u{54}\u{45}", "\u{50}\u{54}\u{45}"), ("\u{3251}",
        "\u{3251}", "\u{3251}", "\u{32}\u{31}", "\u{32}\u{31}"), ("\u{3252}", "\u{3252}",
        "\u{3252}", "\u{32}\u{32}", "\u{32}\u{32}"), ("\u{3253}", "\u{3253}", "\u{3253}",
        "\u{32}\u{33}", "\u{32}\u{33}"), ("\u{3254}", "\u{3254}", "\u{3254}", "\u{32}\u{34}",
        "\u{32}\u{34}"), ("\u{3255}", "\u{3255}", "\u{3255}", "\u{32}\u{35}", "\u{32}\u{35}"),
        ("\u{3256}", "\u{3256}", "\u{3256}", "\u{32}\u{36}", "\u{32}\u{36}"), ("\u{3257}",
        "\u{3257}", "\u{3257}", "\u{32}\u{37}", "\u{32}\u{37}"), ("\u{3258}", "\u{3258}",
        "\u{3258}", "\u{32}\u{38}", "\u{32}\u{38}"), ("\u{3259}", "\u{3259}", "\u{3259}",
        "\u{32}\u{39}", "\u{32}\u{39}"), ("\u{325a}", "\u{325a}", "\u{325a}", "\u{33}\u{30}",
        "\u{33}\u{30}"), ("\u{325b}", "\u{325b}", "\u{325b}", "\u{33}\u{31}", "\u{33}\u{31}"),
        ("\u{325c}", "\u{325c}", "\u{325c}", "\u{33}\u{32}", "\u{33}\u{32}"), ("\u{325d}",
        "\u{325d}", "\u{325d}", "\u{33}\u{33}", "\u{33}\u{33}"), ("\u{325e}", "\u{325e}",
        "\u{325e}", "\u{33}\u{34}", "\u{33}\u{34}"), ("\u{325f}", "\u{325f}", "\u{325f}",
        "\u{33}\u{35}", "\u{33}\u{35}"), ("\u{3260}", "\u{3260}", "\u{3260}", "\u{1100}",
        "\u{1100}"), ("\u{3261}", "\u{3261}", "\u{3261}", "\u{1102}", "\u{1102}"), ("\u{3262}",
        "\u{3262}", "\u{3262}", "\u{1103}", "\u{1103}"), ("\u{3263}", "\u{3263}", "\u{3263}",
        "\u{1105}", "\u{1105}"), ("\u{3264}", "\u{3264}", "\u{3264}", "\u{1106}", "\u{1106}"),
        ("\u{3265}", "\u{3265}", "\u{3265}", "\u{1107}", "\u{1107}"), ("\u{3266}", "\u{3266}",
        "\u{3266}", "\u{1109}", "\u{1109}"), ("\u{3267}", "\u{3267}", "\u{3267}", "\u{110b}",
        "\u{110b}"), ("\u{3268}", "\u{3268}", "\u{3268}", "\u{110c}", "\u{110c}"), ("\u{3269}",
        "\u{3269}", "\u{3269}", "\u{110e}", "\u{110e}"), ("\u{326a}", "\u{326a}", "\u{326a}",
        "\u{110f}", "\u{110f}"), ("\u{326b}", "\u{326b}", "\u{326b}", "\u{1110}", "\u{1110}"),
        ("\u{326c}", "\u{326c}", "\u{326c}", "\u{1111}", "\u{1111}"), ("\u{326d}", "\u{326d}",
        "\u{326d}", "\u{1112}", "\u{1112}"), ("\u{326e}", "\u{326e}", "\u{326e}", "\u{ac00}",
        "\u{1100}\u{1161}"), ("\u{326f}", "\u{326f}", "\u{326f}", "\u{b098}", "\u{1102}\u{1161}"),
        ("\u{3270}", "\u{3270}", "\u{3270}", "\u{b2e4}", "\u{1103}\u{1161}"), ("\u{3271}",
        "\u{3271}", "\u{3271}", "\u{b77c}", "\u{1105}\u{1161}"), ("\u{3272}", "\u{3272}",
        "\u{3272}", "\u{b9c8}", "\u{1106}\u{1161}"), ("\u{3273}", "\u{3273}", "\u{3273}",
        "\u{bc14}", "\u{1107}\u{1161}"), ("\u{3274}", "\u{3274}", "\u{3274}", "\u{c0ac}",
        "\u{1109}\u{1161}"), ("\u{3275}", "\u{3275}", "\u{3275}", "\u{c544}", "\u{110b}\u{1161}"),
        ("\u{3276}", "\u{3276}", "\u{3276}", "\u{c790}", "\u{110c}\u{1161}"), ("\u{3277}",
        "\u{3277}", "\u{3277}", "\u{cc28}", "\u{110e}\u{1161}"), ("\u{3278}", "\u{3278}",
        "\u{3278}", "\u{ce74}", "\u{110f}\u{1161}"), ("\u{3279}", "\u{3279}", "\u{3279}",
        "\u{d0c0}", "\u{1110}\u{1161}"), ("\u{327a}", "\u{327a}", "\u{327a}", "\u{d30c}",
        "\u{1111}\u{1161}"), ("\u{327b}", "\u{327b}", "\u{327b}", "\u{d558}", "\u{1112}\u{1161}"),
        ("\u{327c}", "\u{327c}", "\u{327c}", "\u{cc38}\u{ace0}",
        "\u{110e}\u{1161}\u{11b7}\u{1100}\u{1169}"), ("\u{327d}", "\u{327d}", "\u{327d}",
        "\u{c8fc}\u{c758}", "\u{110c}\u{116e}\u{110b}\u{1174}"), ("\u{327e}", "\u{327e}",
        "\u{327e}", "\u{c6b0}", "\u{110b}\u{116e}"), ("\u{3280}", "\u{3280}", "\u{3280}",
        "\u{4e00}", "\u{4e00}"), ("\u{3281}", "\u{3281}", "\u{3281}", "\u{4e8c}", "\u{4e8c}"),
        ("\u{3282}", "\u{3282}", "\u{3282}", "\u{4e09}", "\u{4e09}"), ("\u{3283}", "\u{3283}",
        "\u{3283}", "\u{56db}", "\u{56db}"), ("\u{3284}", "\u{3284}", "\u{3284}", "\u{4e94}",
        "\u{4e94}"), ("\u{3285}", "\u{3285}", "\u{3285}", "\u{516d}", "\u{516d}"), ("\u{3286}",
        "\u{3286}", "\u{3286}", "\u{4e03}", "\u{4e03}"), ("\u{3287}", "\u{3287}", "\u{3287}",
        "\u{516b}", "\u{516b}"), ("\u{3288}", "\u{3288}", "\u{3288}", "\u{4e5d}", "\u{4e5d}"),
        ("\u{3289}", "\u{3289}", "\u{3289}", "\u{5341}", "\u{5341}"), ("\u{328a}", "\u{328a}",
        "\u{328a}", "\u{6708}", "\u{6708}"), ("\u{328b}", "\u{328b}", "\u{328b}", "\u{706b}",
        "\u{706b}"), ("\u{328c}", "\u{328c}", "\u{328c}", "\u{6c34}", "\u{6c34}"), ("\u{328d}",
        "\u{328d}", "\u{328d}", "\u{6728}", "\u{6728}"), ("\u{328e}", "\u{328e}", "\u{328e}",
        "\u{91d1}", "\u{91d1}"), ("\u{328f}", "\u{328f}", "\u{328f}", "\u{571f}", "\u{571f}"),
        ("\u{3290}", "\u{3290}", "\u{3290}", "\u{65e5}", "\u{65e5}"), ("\u{3291}", "\u{3291}",
        "\u{3291}", "\u{682a}", "\u{682a}"), ("\u{3292}", "\u{3292}", "\u{3292}", "\u{6709}",
        "\u{6709}"), ("\u{3293}", "\u{3293}", "\u{3293}", "\u{793e}", "\u{793e}"), ("\u{3294}",
        "\u{3294}", "\u{3294}", "\u{540d}", "\u{540d}"), ("\u{3295}", "\u{3295}", "\u{3295}",
        "\u{7279}", "\u{7279}"), ("\u{3296}", "\u{3296}", "\u{3296}", "\u{8ca1}", "\u{8ca1}"),
        ("\u{3297}", "\u{3297}", "\u{3297}", "\u{795d}", "\u{795d}"), ("\u{3298}", "\u{3298}",
        "\u{3298}", "\u{52b4}", "\u{52b4}"), ("\u{3299}", "\u{3299}", "\u{3299}", "\u{79d8}",
        "\u{79d8}"), ("\u{329a}", "\u{329a}", "\u{329a}", "\u{7537}", "\u{7537}"), ("\u{329b}",
        "\u{329b}", "\u{329b}", "\u{5973}", "\u{5973}"), ("\u{329c}", "\u{329c}", "\u{329c}",
        "\u{9069}", "\u{9069}"), ("\u{329d}", "\u{329d}", "\u{329d}", "\u{512a}", "\u{512a}"),
        ("\u{329e}", "\u{329e}", "\u{329e}", "\u{5370}", "\u{5370}"), ("\u{329f}", "\u{329f}",
        "\u{329f}", "\u{6ce8}", "\u{6ce8}"), ("\u{32a0}", "\u{32a0}", "\u{32a0}", "\u{9805}",
        "\u{9805}"), ("\u{32a1}", "\u{32a1}", "\u{32a1}", "\u{4f11}", "\u{4f11}"), ("\u{32a2}",
        "\u{32a2}", "\u{32a2}", "\u{5199}", "\u{5199}"), ("\u{32a3}", "\u{32a3}", "\u{32a3}",
        "\u{6b63}", "\u{6b63}"), ("\u{32a4}", "\u{32a4}", "\u{32a4}", "\u{4e0a}", "\u{4e0a}"),
        ("\u{32a5}", "\u{32a5}", "\u{32a5}", "\u{4e2d}", "\u{4e2d}"), ("\u{32a6}", "\u{32a6}",
        "\u{32a6}", "\u{4e0b}", "\u{4e0b}"), ("\u{32a7}", "\u{32a7}", "\u{32a7}", "\u{5de6}",
        "\u{5de6}"), ("\u{32a8}", "\u{32a8}", "\u{32a8}", "\u{53f3}", "\u{53f3}"), ("\u{32a9}",
        "\u{32a9}", "\u{32a9}", "\u{533b}", "\u{533b}"), ("\u{32aa}", "\u{32aa}", "\u{32aa}",
        "\u{5b97}", "\u{5b97}"), ("\u{32ab}", "\u{32ab}", "\u{32ab}", "\u{5b66}", "\u{5b66}"),
        ("\u{32ac}", "\u{32ac}", "\u{32ac}", "\u{76e3}", "\u{76e3}"), ("\u{32ad}", "\u{32ad}",
        "\u{32ad}", "\u{4f01}", "\u{4f01}"), ("\u{32ae}", "\u{32ae}", "\u{32ae}", "\u{8cc7}",
        "\u{8cc7}"), ("\u{32af}", "\u{32af}", "\u{32af}", "\u{5354}", "\u{5354}"), ("\u{32b0}",
        "\u{32b0}", "\u{32b0}", "\u{591c}", "\u{591c}"), ("\u{32b1}", "\u{32b1}", "\u{32b1}",
        "\u{33}\u{36}", "\u{33}\u{36}"), ("\u{32b2}", "\u{32b2}", "\u{32b2}", "\u{33}\u{37}",
        "\u{33}\u{37}"), ("\u{32b3}", "\u{32b3}", "\u{32b3}", "\u{33}\u{38}", "\u{33}\u{38}"),
        ("\u{32b4}", "\u{32b4}", "\u{32b4}", "\u{33}\u{39}", "\u{33}\u{39}"), ("\u{32b5}",
        "\u{32b5}", "\u{32b5}", "\u{34}\u{30}", "\u{34}\u{30}"), ("\u{32b6}", "\u{32b6}",
        "\u{32b6}", "\u{34}\u{31}", "\u{34}\u{31}"), ("\u{32b7}", "\u{32b7}", "\u{32b7}",
        "\u{34}\u{32}", "\u{34}\u{32}"), ("\u{32b8}", "\u{32b8}", "\u{32b8}", "\u{34}\u{33}",
        "\u{34}\u{33}"), ("\u{32b9}", "\u{32b9}", "\u{32b9}", "\u{34}\u{34}", "\u{34}\u{34}"),
        ("\u{32ba}", "\u{32ba}", "\u{32ba}", "\u{34}\u{35}", "\u{34}\u{35}"), ("\u{32bb}",
        "\u{32bb}", "\u{32bb}", "\u{34}\u{36}", "\u{34}\u{36}"), ("\u{32bc}", "\u{32bc}",
        "\u{32bc}", "\u{34}\u{37}", "\u{34}\u{37}"), ("\u{32bd}", "\u{32bd}", "\u{32bd}",
        "\u{34}\u{38}", "\u{34}\u{38}"), ("\u{32be}", "\u{32be}", "\u{32be}", "\u{34}\u{39}",
        "\u{34}\u{39}"), ("\u{32bf}", "\u{32bf}", "\u{32bf}", "\u{35}\u{30}", "\u{35}\u{30}"),
        ("\u{32c0}", "\u{32c0}", "\u{32c0}", "\u{31}\u{6708}", "\u{31}\u{6708}"), ("\u{32c1}",
        "\u{32c1}", "\u{32c1}", "\u{32}\u{6708}", "\u{32}\u{6708}"), ("\u{32c2}", "\u{32c2}",
        "\u{32c2}", "\u{33}\u{6708}", "\u{33}\u{6708}"), ("\u{32c3}", "\u{32c3}", "\u{32c3}",
        "\u{34}\u{6708}", "\u{34}\u{6708}"), ("\u{32c4}", "\u{32c4}", "\u{32c4}", "\u{35}\u{6708}",
        "\u{35}\u{6708}"), ("\u{32c5}", "\u{32c5}", "\u{32c5}", "\u{36}\u{6708}", "\u{36}\u{6708}"),
        ("\u{32c6}", "\u{32c6}", "\u{32c6}", "\u{37}\u{6708}", "\u{37}\u{6708}"), ("\u{32c7}",
        "\u{32c7}", "\u{32c7}", "\u{38}\u{6708}", "\u{38}\u{6708}"), ("\u{32c8}", "\u{32c8}",
        "\u{32c8}", "\u{39}\u{6708}", "\u{39}\u{6708}"), ("\u{32c9}", "\u{32c9}", "\u{32c9}",
        "\u{31}\u{30}\u{6708}", "\u{31}\u{30}\u{6708}"), ("\u{32ca}", "\u{32ca}", "\u{32ca}",
        "\u{31}\u{31}\u{6708}", "\u{31}\u{31}\u{6708}"), ("\u{32cb}", "\u{32cb}", "\u{32cb}",
        "\u{31}\u{32}\u{6708}", "\u{31}\u{32}\u{6708}"), ("\u{32cc}", "\u{32cc}", "\u{32cc}",
        "\u{48}\u{67}", "\u{48}\u{67}"), ("\u{32cd}", "\u{32cd}", "\u{32cd}", "\u{65}\u{72}\u{67}",
        "\u{65}\u{72}\u{67}"), ("\u{32ce}", "\u{32ce}", "\u{32ce}", "\u{65}\u{56}", "\u{65}\u{56}"),
        ("\u{32cf}", "\u{32cf}", "\u{32cf}", "\u{4c}\u{54}\u{44}", "\u{4c}\u{54}\u{44}"),
        ("\u{32d0}", "\u{32d0}", "\u{32d0}", "\u{30a2}", "\u{30a2}"), ("\u{32d1}", "\u{32d1}",
        "\u{32d1}", "\u{30a4}", "\u{30a4}"), ("\u{32d2}", "\u{32d2}", "\u{32d2}", "\u{30a6}",
        "\u{30a6}"), ("\u{32d3}", "\u{32d3}", "\u{32d3}", "\u{30a8}", "\u{30a8}"), ("\u{32d4}",
        "\u{32d4}", "\u{32d4}", "\u{30aa}", "\u{30aa}"), ("\u{32d5}", "\u{32d5}", "\u{32d5}",
        "\u{30ab}", "\u{30ab}"), ("\u{32d6}", "\u{32d6}", "\u{32d6}", "\u{30ad}", "\u{30ad}"),
        ("\u{32d7}", "\u{32d7}", "\u{32d7}", "\u{30af}", "\u{30af}"), ("\u{32d8}", "\u{32d8}",
        "\u{32d8}", "\u{30b1}", "\u{30b1}"), ("\u{32d9}", "\u{32d9}", "\u{32d9}", "\u{30b3}",
        "\u{30b3}"), ("\u{32da}", "\u{32da}", "\u{32da}", "\u{30b5}", "\u{30b5}"), ("\u{32db}",
        "\u{32db}", "\u{32db}", "\u{30b7}", "\u{30b7}"), ("\u{32dc}", "\u{32dc}", "\u{32dc}",
        "\u{30b9}", "\u{30b9}"), ("\u{32dd}", "\u{32dd}", "\u{32dd}", "\u{30bb}", "\u{30bb}"),
        ("\u{32de}", "\u{32de}", "\u{32de}", "\u{30bd}", "\u{30bd}"), ("\u{32df}", "\u{32df}",
        "\u{32df}", "\u{30bf}", "\u{30bf}"), ("\u{32e0}", "\u{32e0}", "\u{32e0}", "\u{30c1}",
        "\u{30c1}"), ("\u{32e1}", "\u{32e1}", "\u{32e1}", "\u{30c4}", "\u{30c4}"), ("\u{32e2}",
        "\u{32e2}", "\u{32e2}", "\u{30c6}", "\u{30c6}"), ("\u{32e3}", "\u{32e3}", "\u{32e3}",
        "\u{30c8}", "\u{30c8}"), ("\u{32e4}", "\u{32e4}", "\u{32e4}", "\u{30ca}", "\u{30ca}"),
        ("\u{32e5}", "\u{32e5}", "\u{32e5}", "\u{30cb}", "\u{30cb}"), ("\u{32e6}", "\u{32e6}",
        "\u{32e6}", "\u{30cc}", "\u{30cc}"), ("\u{32e7}", "\u{32e7}", "\u{32e7}", "\u{30cd}",
        "\u{30cd}"), ("\u{32e8}", "\u{32e8}", "\u{32e8}", "\u{30ce}", "\u{30ce}"), ("\u{32e9}",
        "\u{32e9}", "\u{32e9}", "\u{30cf}", "\u{30cf}"), ("\u{32ea}", "\u{32ea}", "\u{32ea}",
        "\u{30d2}", "\u{30d2}"), ("\u{32eb}", "\u{32eb}", "\u{32eb}", "\u{30d5}", "\u{30d5}"),
        ("\u{32ec}", "\u{32ec}", "\u{32ec}", "\u{30d8}", "\u{30d8}"), ("\u{32ed}", "\u{32ed}",
        "\u{32ed}", "\u{30db}", "\u{30db}"), ("\u{32ee}", "\u{32ee}", "\u{32ee}", "\u{30de}",
        "\u{30de}"), ("\u{32ef}", "\u{32ef}", "\u{32ef}", "\u{30df}", "\u{30df}"), ("\u{32f0}",
        "\u{32f0}", "\u{32f0}", "\u{30e0}", "\u{30e0}"), ("\u{32f1}", "\u{32f1}", "\u{32f1}",
        "\u{30e1}", "\u{30e1}"), ("\u{32f2}", "\u{32f2}", "\u{32f2}", "\u{30e2}", "\u{30e2}"),
        ("\u{32f3}", "\u{32f3}", "\u{32f3}", "\u{30e4}", "\u{30e4}"), ("\u{32f4}", "\u{32f4}",
        "\u{32f4}", "\u{30e6}", "\u{30e6}"), ("\u{32f5}", "\u{32f5}", "\u{32f5}", "\u{30e8}",
        "\u{30e8}"), ("\u{32f6}", "\u{32f6}", "\u{32f6}", "\u{30e9}", "\u{30e9}"), ("\u{32f7}",
        "\u{32f7}", "\u{32f7}", "\u{30ea}", "\u{30ea}"), ("\u{32f8}", "\u{32f8}", "\u{32f8}",
        "\u{30eb}", "\u{30eb}"), ("\u{32f9}", "\u{32f9}", "\u{32f9}", "\u{30ec}", "\u{30ec}"),
        ("\u{32fa}", "\u{32fa}", "\u{32fa}", "\u{30ed}", "\u{30ed}"), ("\u{32fb}", "\u{32fb}",
        "\u{32fb}", "\u{30ef}", "\u{30ef}"), ("\u{32fc}", "\u{32fc}", "\u{32fc}", "\u{30f0}",
        "\u{30f0}"), ("\u{32fd}", "\u{32fd}", "\u{32fd}", "\u{30f1}", "\u{30f1}"), ("\u{32fe}",
        "\u{32fe}", "\u{32fe}", "\u{30f2}", "\u{30f2}"), ("\u{3300}", "\u{3300}", "\u{3300}",
        "\u{30a2}\u{30d1}\u{30fc}\u{30c8}", "\u{30a2}\u{30cf}\u{309a}\u{30fc}\u{30c8}"),
        ("\u{3301}", "\u{3301}", "\u{3301}", "\u{30a2}\u{30eb}\u{30d5}\u{30a1}",
        "\u{30a2}\u{30eb}\u{30d5}\u{30a1}"), ("\u{3302}", "\u{3302}", "\u{3302}",
        "\u{30a2}\u{30f3}\u{30da}\u{30a2}", "\u{30a2}\u{30f3}\u{30d8}\u{309a}\u{30a2}"),
        ("\u{3303}", "\u{3303}", "\u{3303}", "\u{30a2}\u{30fc}\u{30eb}",
        "\u{30a2}\u{30fc}\u{30eb}"), ("\u{3304}", "\u{3304}", "\u{3304}",
        "\u{30a4}\u{30cb}\u{30f3}\u{30b0}", "\u{30a4}\u{30cb}\u{30f3}\u{30af}\u{3099}"),
        ("\u{3305}", "\u{3305}", "\u{3305}", "\u{30a4}\u{30f3}\u{30c1}",
        "\u{30a4}\u{30f3}\u{30c1}"), ("\u{3306}", "\u{3306}", "\u{3306}",
        "\u{30a6}\u{30a9}\u{30f3}", "\u{30a6}\u{30a9}\u{30f3}"), ("\u{3307}", "\u{3307}",
        "\u{3307}", "\u{30a8}\u{30b9}\u{30af}\u{30fc}\u{30c9}",
        "\u{30a8}\u{30b9}\u{30af}\u{30fc}\u{30c8}\u{3099}"), ("\u{3308}", "\u{3308}", "\u{3308}",
        "\u{30a8}\u{30fc}\u{30ab}\u{30fc}", "\u{30a8}\u{30fc}\u{30ab}\u{30fc}"), ("\u{3309}",
        "\u{3309}", "\u{3309}", "\u{30aa}\u{30f3}\u{30b9}", "\u{30aa}\u{30f3}\u{30b9}"),
        ("\u{330a}", "\u{330a}", "\u{330a}", "\u{30aa}\u{30fc}\u{30e0}",
        "\u{30aa}\u{30fc}\u{30e0}"), ("\u{330b}", "\u{330b}", "\u{330b}",
        "\u{30ab}\u{30a4}\u{30ea}", "\u{30ab}\u{30a4}\u{30ea}"), ("\u{330c}", "\u{330c}",
        "\u{330c}", "\u{30ab}\u{30e9}\u{30c3}\u{30c8}", "\u{30ab}\u{30e9}\u{30c3}\u{30c8}"),
        ("\u{330d}", "\u{330d}", "\u{330d}", "\u{30ab}\u{30ed}\u{30ea}\u{30fc}",
        "\u{30ab}\u{30ed}\u{30ea}\u{30fc}"), ("\u{330e}", "\u{330e}", "\u{330e}",
        "\u{30ac}\u{30ed}\u{30f3}", "\u{30ab}\u{3099}\u{30ed}\u{30f3}"), ("\u{330f}", "\u{330f}",
        "\u{330f}", "\u{30ac}\u{30f3}\u{30de}", "\u{30ab}\u{3099}\u{30f3}\u{30de}"), ("\u{3310}",
        "\u{3310}", "\u{3310}", "\u{30ae}\u{30ac}", "\u{30ad}\u{3099}\u{30ab}\u{3099}"),
        ("\u{3311}", "\u{3311}", "\u{3311}", "\u{30ae}\u{30cb}\u{30fc}",
        "\u{30ad}\u{3099}\u{30cb}\u{30fc}"), ("\u{3312}", "\u{3312}", "\u{3312}",
        "\u{30ad}\u{30e5}\u{30ea}\u{30fc}", "\u{30ad}\u{30e5}\u{30ea}\u{30fc}"), ("\u{3313}",
        "\u{3313}", "\u{3313}", "\u{30ae}\u{30eb}\u{30c0}\u{30fc}",
        "\u{30ad}\u{3099}\u{30eb}\u{30bf}\u{3099}\u{30fc}"), ("\u{3314}", "\u{3314}", "\u{3314}",
        "\u{30ad}\u{30ed}", "\u{30ad}\u{30ed}"), ("\u{3315}", "\u{3315}", "\u{3315}",
        "\u{30ad}\u{30ed}\u{30b0}\u{30e9}\u{30e0}",
        "\u{30ad}\u{30ed}\u{30af}\u{3099}\u{30e9}\u{30e0}"), ("\u{3316}", "\u{3316}", "\u{3316}",
        "\u{30ad}\u{30ed}\u{30e1}\u{30fc}\u{30c8}\u{30eb}",
        "\u{30ad}\u{30ed}\u{30e1}\u{30fc}\u{30c8}\u{30eb}"), ("\u{3317}", "\u{3317}", "\u{3317}",
        "\u{30ad}\u{30ed}\u{30ef}\u{30c3}\u{30c8}", "\u{30ad}\u{30ed}\u{30ef}\u{30c3}\u{30c8}"),
        ("\u{3318}", "\u{3318}", "\u{3318}", "\u{30b0}\u{30e9}\u{30e0}",
        "\u{30af}\u{3099}\u{30e9}\u{30e0}"), ("\u{3319}", "\u{3319}", "\u{3319}",
        "\u{30b0}\u{30e9}\u{30e0}\u{30c8}\u{30f3}",
        "\u{30af}\u{3099}\u{30e9}\u{30e0}\u{30c8}\u{30f3}"), ("\u{331a}", "\u{331a}", "\u{331a}",
        "\u{30af}\u{30eb}\u{30bc}\u{30a4}\u{30ed}",
        "\u{30af}\u{30eb}\u{30bb}\u{3099}\u{30a4}\u{30ed}"), ("\u{331b}", "\u{331b}", "\u{331b}",
        "\u{30af}\u{30ed}\u{30fc}\u{30cd}", "\u{30af}\u{30ed}\u{30fc}\u{30cd}"), ("\u{331c}",
        "\u{331c}", "\u{331c}", "\u{30b1}\u{30fc}\u{30b9}", "\u{30b1}\u{30fc}\u{30b9}"),
        ("\u{331d}", "\u{331d}", "\u{331d}", "\u{30b3}\u{30eb}\u{30ca}",
        "\u{30b3}\u{30eb}\u{30ca}"), ("\u{331e}", "\u{331e}", "\u{331e}",
        "\u{30b3}\u{30fc}\u{30dd}", "\u{30b3}\u{30fc}\u{30db}\u{309a}"), ("\u{331f}", "\u{331f}",
        "\u{331f}", "\u{30b5}\u{30a4}\u{30af}\u{30eb}", "\u{30b5}\u{30a4}\u{30af}\u{30eb}"),
        ("\u{3320}", "\u{3320}", "\u{3320}", "\u{30b5}\u{30f3}\u{30c1}\u{30fc}\u{30e0}",
        "\u{30b5}\u{30f3}\u{30c1}\u{30fc}\u{30e0}"), ("\u{3321}", "\u{3321}", "\u{3321}",
        "\u{30b7}\u{30ea}\u{30f3}\u{30b0}", "\u{30b7}\u{30ea}\u{30f3}\u{30af}\u{3099}"),
        ("\u{3322}", "\u{3322}", "\u{3322}", "\u{30bb}\u{30f3}\u{30c1}",
        "\u{30bb}\u{30f3}\u{30c1}"), ("\u{3323}", "\u{3323}", "\u{3323}",
        "\u{30bb}\u{30f3}\u{30c8}", "\u{30bb}\u{30f3}\u{30c8}"), ("\u{3324}", "\u{3324}",
        "\u{3324}", "\u{30c0}\u{30fc}\u{30b9}", "\u{30bf}\u{3099}\u{30fc}\u{30b9}"), ("\u{3325}",
        "\u{3325}", "\u{3325}", "\u{30c7}\u{30b7}", "\u{30c6}\u{3099}\u{30b7}"), ("\u{3326}",
        "\u{3326}", "\u{3326}", "\u{30c9}\u{30eb}", "\u{30c8}\u{3099}\u{30eb}"), ("\u{3327}",
        "\u{3327}", "\u{3327}", "\u{30c8}\u{30f3}", "\u{30c8}\u{30f3}"), ("\u{3328}", "\u{3328}",
        "\u{3328}", "\u{30ca}\u{30ce}", "\u{30ca}\u{30ce}"), ("\u{3329}", "\u{3329}", "\u{3329}",
        "\u{30ce}\u{30c3}\u{30c8}", "\u{30ce}\u{30c3}\u{30c8}"), ("\u{332a}", "\u{332a}",
        "\u{332a}", "\u{30cf}\u{30a4}\u{30c4}", "\u{30cf}\u{30a4}\u{30c4}"), ("\u{332b}",
        "\u{332b}", "\u{332b}", "\u{30d1}\u{30fc}\u{30bb}\u{30f3}\u{30c8}",
        "\u{30cf}\u{309a}\u{30fc}\u{30bb}\u{30f3}\u{30c8}"), ("\u{332c}", "\u{332c}", "\u{332c}",
        "\u{30d1}\u{30fc}\u{30c4}", "\u{30cf}\u{309a}\u{30fc}\u{30c4}"), ("\u{332d}", "\u{332d}",
        "\u{332d}", "\u{30d0}\u{30fc}\u{30ec}\u{30eb}", "\u{30cf}\u{3099}\u{30fc}\u{30ec}\u{30eb}"),
        ("\u{332e}", "\u{332e}", "\u{332e}", "\u{30d4}\u{30a2}\u{30b9}\u{30c8}\u{30eb}",
        "\u{30d2}\u{309a}\u{30a2}\u{30b9}\u{30c8}\u{30eb}"), ("\u{332f}", "\u{332f}", "\u{332f}",
        "\u{30d4}\u{30af}\u{30eb}", "\u{30d2}\u{309a}\u{30af}\u{30eb}"), ("\u{3330}", "\u{3330}",
        "\u{3330}", "\u{30d4}\u{30b3}", "\u{30d2}\u{309a}\u{30b3}"), ("\u{3331}", "\u{3331}",
        "\u{3331}", "\u{30d3}\u{30eb}", "\u{30d2}\u{3099}\u{30eb}"), ("\u{3332}", "\u{3332}",
        "\u{3332}", "\u{30d5}\u{30a1}\u{30e9}\u{30c3}\u{30c9}",
        "\u{30d5}\u{30a1}\u{30e9}\u{30c3}\u{30c8}\u{3099}"), ("\u{3333}", "\u{3333}", "\u{3333}",
        "\u{30d5}\u{30a3}\u{30fc}\u{30c8}", "\u{30d5}\u{30a3}\u{30fc}\u{30c8}"), ("\u{3334}",
        "\u{3334}", "\u{3334}", "\u{30d6}\u{30c3}\u{30b7}\u{30a7}\u{30eb}",
        "\u{30d5}\u{3099}\u{30c3}\u{30b7}\u{30a7}\u{30eb}"), ("\u{3335}", "\u{3335}", "\u{3335}",
        "\u{30d5}\u{30e9}\u{30f3}", "\u{30d5}\u{30e9}\u{30f3}"), ("\u{3336}", "\u{3336}",
        "\u{3336}", "\u{30d8}\u{30af}\u{30bf}\u{30fc}\u{30eb}",
        "\u{30d8}\u{30af}\u{30bf}\u{30fc}\u{30eb}"), ("\u{3337}", "\u{3337}", "\u{3337}",
        "\u{30da}\u{30bd}", "\u{30d8}\u{309a}\u{30bd}"), ("\u{3338}", "\u{3338}", "\u{3338}",
        "\u{30da}\u{30cb}\u{30d2}", "\u{30d8}\u{309a}\u{30cb}\u{30d2}"), ("\u{3339}", "\u{3339}",
        "\u{3339}", "\u{30d8}\u{30eb}\u{30c4}", "\u{30d8}\u{30eb}\u{30c4}"), ("\u{333a}",
        "\u{333a}", "\u{333a}", "\u{30da}\u{30f3}\u{30b9}", "\u{30d8}\u{309a}\u{30f3}\u{30b9}"),
        ("\u{333b}", "\u{333b}", "\u{333b}", "\u{30da}\u{30fc}\u{30b8}",
        "\u{30d8}\u{309a}\u{30fc}\u{30b7}\u{3099}"), ("\u{333c}", "\u{333c}", "\u{333c}",
        "\u{30d9}\u{30fc}\u{30bf}", "\u{30d8}\u{3099}\u{30fc}\u{30bf}"), ("\u{333d}", "\u{333d}",
        "\u{333d}", "\u{30dd}\u{30a4}\u{30f3}\u{30c8}", "\u{30db}\u{309a}\u{30a4}\u{30f3}\u{30c8}"),
        ("\u{333e}", "\u{333e}", "\u{333e}", "\u{30dc}\u{30eb}\u{30c8}",
        "\u{30db}\u{3099}\u{30eb}\u{30c8}"), ("\u{333f}", "\u{333f}", "\u{333f}",
        "\u{30db}\u{30f3}", "\u{30db}\u{30f3}"), ("\u{3340}", "\u{3340}", "\u{3340}",
        "\u{30dd}\u{30f3}\u{30c9}", "\u{30db}\u{309a}\u{30f3}\u{30c8}\u{3099}"), ("\u{3341}",
        "\u{3341}", "\u{3341}", "\u{30db}\u{30fc}\u{30eb}", "\u{30db}\u{30fc}\u{30eb}"),
        ("\u{3342}", "\u{3342}", "\u{3342}", "\u{30db}\u{30fc}\u{30f3}",
        "\u{30db}\u{30fc}\u{30f3}"), ("\u{3343}", "\u{3343}", "\u{3343}",
        "\u{30de}\u{30a4}\u{30af}\u{30ed}", "\u{30de}\u{30a4}\u{30af}\u{30ed}"), ("\u{3344}",
        "\u{3344}", "\u{3344}", "\u{30de}\u{30a4}\u{30eb}", "\u{30de}\u{30a4}\u{30eb}"),
        ("\u{3345}", "\u{3345}", "\u{3345}", "\u{30de}\u{30c3}\u{30cf}",
        "\u{30de}\u{30c3}\u{30cf}"), ("\u{3346}", "\u{3346}", "\u{3346}",
        "\u{30de}\u{30eb}\u{30af}", "\u{30de}\u{30eb}\u{30af}"), ("\u{3347}", "\u{3347}",
        "\u{3347}", "\u{30de}\u{30f3}\u{30b7}\u{30e7}\u{30f3}",
        "\u{30de}\u{30f3}\u{30b7}\u{30e7}\u{30f3}"), ("\u{3348}", "\u{3348}", "\u{3348}",
        "\u{30df}\u{30af}\u{30ed}\u{30f3}", "\u{30df}\u{30af}\u{30ed}\u{30f3}"), ("\u{3349}",
        "\u{3349}", "\u{3349}", "\u{30df}\u{30ea}", "\u{30df}\u{30ea}"), ("\u{334a}", "\u{334a}",
        "\u{334a}", "\u{30df}\u{30ea}\u{30d0}\u{30fc}\u{30eb}",
        "\u{30df}\u{30ea}\u{30cf}\u{3099}\u{30fc}\u{30eb}"), ("\u{334b}", "\u{334b}", "\u{334b}",
        "\u{30e1}\u{30ac}", "\u{30e1}\u{30ab}\u{3099}"), ("\u{334c}", "\u{334c}", "\u{334c}",
        "\u{30e1}\u{30ac}\u{30c8}\u{30f3}", "\u{30e1}\u{30ab}\u{3099}\u{30c8}\u{30f3}"),
        ("\u{334d}", "\u{334d}", "\u{334d}", "\u{30e1}\u{30fc}\u{30c8}\u{30eb}",
        "\u{30e1}\u{30fc}\u{30c8}\u{30eb}"), ("\u{334e}", "\u{334e}", "\u{334e}",
        "\u{30e4}\u{30fc}\u{30c9}", "\u{30e4}\u{30fc}\u{30c8}\u{3099}"), ("\u{334f}", "\u{334f}",
        "\u{334f}", "\u{30e4}\u{30fc}\u{30eb}", "\u{30e4}\u{30fc}\u{30eb}"), ("\u{3350}",
        "\u{3350}", "\u{3350}", "\u{30e6}\u{30a2}\u{30f3}", "\u{30e6}\u{30a2}\u{30f3}"),
        ("\u{3351}", "\u{3351}", "\u{3351}", "\u{30ea}\u{30c3}\u{30c8}\u{30eb}",
        "\u{30ea}\u{30c3}\u{30c8}\u{30eb}"), ("\u{3352}", "\u{3352}", "\u{3352}",
        "\u{30ea}\u{30e9}", "\u{30ea}\u{30e9}"), ("\u{3353}", "\u{3353}", "\u{3353}",
        "\u{30eb}\u{30d4}\u{30fc}", "\u{30eb}\u{30d2}\u{309a}\u{30fc}"), ("\u{3354}", "\u{3354}",
        "\u{3354}", "\u{30eb}\u{30fc}\u{30d6}\u{30eb}", "\u{30eb}\u{30fc}\u{30d5}\u{3099}\u{30eb}"),
        ("\u{3355}", "\u{3355}", "\u{3355}", "\u{30ec}\u{30e0}", "\u{30ec}\u{30e0}"), ("\u{3356}",
        "\u{3356}", "\u{3356}", "\u{30ec}\u{30f3}\u{30c8}\u{30b2}\u{30f3}",
        "\u{30ec}\u{30f3}\u{30c8}\u{30b1}\u{3099}\u{30f3}"), ("\u{3357}", "\u{3357}", "\u{3357}",
        "\u{30ef}\u{30c3}\u{30c8}", "\u{30ef}\u{30c3}\u{30c8}"), ("\u{3358}", "\u{3358}",
        "\u{3358}", "\u{30}\u{70b9}", "\u{30}\u{70b9}"), ("\u{3359}", "\u{3359}", "\u{3359}",
        "\u{31}\u{70b9}", "\u{31}\u{70b9}"), ("\u{335a}", "\u{335a}", "\u{335a}", "\u{32}\u{70b9}",
        "\u{32}\u{70b9}"), ("\u{335b}", "\u{335b}", "\u{335b}", "\u{33}\u{70b9}", "\u{33}\u{70b9}"),
        ("\u{335c}", "\u{335c}", "\u{335c}", "\u{34}\u{70b9}", "\u{34}\u{70b9}"), ("\u{335d}",
        "\u{335d}", "\u{335d}", "\u{35}\u{70b9}", "\u{35}\u{70b9}"), ("\u{335e}", "\u{335e}",
        "\u{335e}", "\u{36}\u{70b9}", "\u{36}\u{70b9}"), ("\u{335f}", "\u{335f}", "\u{335f}",
        "\u{37}\u{70b9}", "\u{37}\u{70b9}"), ("\u{3360}", "\u{3360}", "\u{3360}", "\u{38}\u{70b9}",
        "\u{38}\u{70b9}"), ("\u{3361}", "\u{3361}", "\u{3361}", "\u{39}\u{70b9}", "\u{39}\u{70b9}"),
        ("\u{3362}", "\u{3362}", "\u{3362}", "\u{31}\u{30}\u{70b9}", "\u{31}\u{30}\u{70b9}"),
        ("\u{3363}", "\u{3363}", "\u{3363}", "\u{31}\u{31}\u{70b9}", "\u{31}\u{31}\u{70b9}"),
        ("\u{3364}", "\u{3364}", "\u{3364}", "\u{31}\u{32}\u{70b9}", "\u{31}\u{32}\u{70b9}"),
        ("\u{3365}", "\u{3365}", "\u{3365}", "\u{31}\u{33}\u{70b9}", "\u{31}\u{33}\u{70b9}"),
        ("\u{3366}", "\u{3366}", "\u{3366}", "\u{31}\u{34}\u{70b9}", "\u{31}\u{34}\u{70b9}"),
        ("\u{3367}", "\u{3367}", "\u{3367}", "\u{31}\u{35}\u{70b9}", "\u{31}\u{35}\u{70b9}"),
        ("\u{3368}", "\u{3368}", "\u{3368}", "\u{31}\u{36}\u{70b9}", "\u{31}\u{36}\u{70b9}"),
        ("\u{3369}", "\u{3369}", "\u{3369}", "\u{31}\u{37}\u{70b9}", "\u{31}\u{37}\u{70b9}"),
        ("\u{336a}", "\u{336a}", "\u{336a}", "\u{31}\u{38}\u{70b9}", "\u{31}\u{38}\u{70b9}"),
        ("\u{336b}", "\u{336b}", "\u{336b}", "\u{31}\u{39}\u{70b9}", "\u{31}\u{39}\u{70b9}"),
        ("\u{336c}", "\u{336c}", "\u{336c}", "\u{32}\u{30}\u{70b9}", "\u{32}\u{30}\u{70b9}"),
        ("\u{336d}", "\u{336d}", "\u{336d}", "\u{32}\u{31}\u{70b9}", "\u{32}\u{31}\u{70b9}"),
        ("\u{336e}", "\u{336e}", "\u{336e}", "\u{32}\u{32}\u{70b9}", "\u{32}\u{32}\u{70b9}"),
        ("\u{336f}", "\u{336f}", "\u{336f}", "\u{32}\u{33}\u{70b9}", "\u{32}\u{33}\u{70b9}"),
        ("\u{3370}", "\u{3370}", "\u{3370}", "\u{32}\u{34}\u{70b9}", "\u{32}\u{34}\u{70b9}"),
        ("\u{3371}", "\u{3371}", "\u{3371}", "\u{68}\u{50}\u{61}", "\u{68}\u{50}\u{61}"),
        ("\u{3372}", "\u{3372}", "\u{3372}", "\u{64}\u{61}", "\u{64}\u{61}"), ("\u{3373}",
        "\u{3373}", "\u{3373}", "\u{41}\u{55}", "\u{41}\u{55}"), ("\u{3374}", "\u{3374}",
        "\u{3374}", "\u{62}\u{61}\u{72}", "\u{62}\u{61}\u{72}"), ("\u{3375}", "\u{3375}",
        "\u{3375}", "\u{6f}\u{56}", "\u{6f}\u{56}"), ("\u{3376}", "\u{3376}", "\u{3376}",
        "\u{70}\u{63}", "\u{70}\u{63}"), ("\u{3377}", "\u{3377}", "\u{3377}", "\u{64}\u{6d}",
        "\u{64}\u{6d}"), ("\u{3378}", "\u{3378}", "\u{3378}", "\u{64}\u{6d}\u{32}",
        "\u{64}\u{6d}\u{32}"), ("\u{3379}", "\u{3379}", "\u{3379}", "\u{64}\u{6d}\u{33}",
        "\u{64}\u{6d}\u{33}"), ("\u{337a}", "\u{337a}", "\u{337a}", "\u{49}\u{55}", "\u{49}\u{55}"),
        ("\u{337b}", "\u{337b}", "\u{337b}", "\u{5e73}\u{6210}", "\u{5e73}\u{6210}"), ("\u{337c}",
        "\u{337c}", "\u{337c}", "\u{662d}\u{548c}", "\u{662d}\u{548c}"), ("\u{337d}", "\u{337d}",
        "\u{337d}", "\u{5927}\u{6b63}", "\u{5927}\u{6b63}"), ("\u{337e}", "\u{337e}", "\u{337e}",
        "\u{660e}\u{6cbb}", "\u{660e}\u{6cbb}"), ("\u{337f}", "\u{337f}", "\u{337f}",
        "\u{682a}\u{5f0f}\u{4f1a}\u{793e}", "\u{682a}\u{5f0f}\u{4f1a}\u{793e}"), ("\u{3380}",
        "\u{3380}", "\u{3380}", "\u{70}\u{41}", "\u{70}\u{41}"), ("\u{3381}", "\u{3381}",
        "\u{3381}", "\u{6e}\u{41}", "\u{6e}\u{41}"), ("\u{3382}", "\u{3382}", "\u{3382}",
        "\u{3bc}\u{41}", "\u{3bc}\u{41}"), ("\u{3383}", "\u{3383}", "\u{3383}", "\u{6d}\u{41}",
        "\u{6d}\u{41}"), ("\u{3384}", "\u{3384}", "\u{3384}", "\u{6b}\u{41}", "\u{6b}\u{41}"),
        ("\u{3385}", "\u{3385}", "\u{3385}", "\u{4b}\u{42}", "\u{4b}\u{42}"), ("\u{3386}",
        "\u{3386}", "\u{3386}", "\u{4d}\u{42}", "\u{4d}\u{42}"), ("\u{3387}", "\u{3387}",
        "\u{3387}", "\u{47}\u{42}", "\u{47}\u{42}"), ("\u{3388}", "\u{3388}", "\u{3388}",
        "\u{63}\u{61}\u{6c}", "\u{63}\u{61}\u{6c}"), ("\u{3389}", "\u{3389}", "\u{3389}",
        "\u{6b}\u{63}\u{61}\u{6c}", "\u{6b}\u{63}\u{61}\u{6c}"), ("\u{338a}", "\u{338a}",
        "\u{338a}", "\u{70}\u{46}", "\u{70}\u{46}"), ("\u{338b}", "\u{338b}", "\u{338b}",
        "\u{6e}\u{46}", "\u{6e}\u{46}"), ("\u{338c}", "\u{338c}", "\u{338c}", "\u{3bc}\u{46}",
        "\u{3bc}\u{46}"), ("\u{338d}", "\u{338d}", "\u{338d}", "\u{3bc}\u{67}", "\u{3bc}\u{67}"),
        ("\u{338e}", "\u{338e}", "\u{338e}", "\u{6d}\u{67}", "\u{6d}\u{67}"), ("\u{338f}",
        "\u{338f}", "\u{338f}", "\u{6b}\u{67}", "\u{6b}\u{67}"), ("\u{3390}", "\u{3390}",
        "\u{3390}", "\u{48}\u{7a}", "\u{48}\u{7a}"), ("\u{3391}", "\u{3391}", "\u{3391}",
        "\u{6b}\u{48}\u{7a}", "\u{6b}\u{48}\u{7a}"), ("\u{3392}", "\u{3392}", "\u{3392}",
        "\u{4d}\u{48}\u{7a}", "\u{4d}\u{48}\u{7a}"), ("\u{3393}", "\u{3393}", "\u{3393}",
        "\u{47}\u{48}\u{7a}", "\u{47}\u{48}\u{7a}"), ("\u{3394}", "\u{3394}", "\u{3394}",
        "\u{54}\u{48}\u{7a}", "\u{54}\u{48}\u{7a}"), ("\u{3395}", "\u{3395}", "\u{3395}",
        "\u{3bc}\u{6c}", "\u{3bc}\u{6c}"), ("\u{3396}", "\u{3396}", "\u{3396}", "\u{6d}\u{6c}",
        "\u{6d}\u{6c}"), ("\u{3397}", "\u{3397}", "\u{3397}", "\u{64}\u{6c}", "\u{64}\u{6c}"),
        ("\u{3398}", "\u{3398}", "\u{3398}", "\u{6b}\u{6c}", "\u{6b}\u{6c}"), ("\u{3399}",
        "\u{3399}", "\u{3399}", "\u{66}\u{6d}", "\u{66}\u{6d}"), ("\u{339a}", "\u{339a}",
        "\u{339a}", "\u{6e}\u{6d}", "\u{6e}\u{6d}"), ("\u{339b}", "\u{339b}", "\u{339b}",
        "\u{3bc}\u{6d}", "\u{3bc}\u{6d}"), ("\u{339c}", "\u{339c}", "\u{339c}", "\u{6d}\u{6d}",
        "\u{6d}\u{6d}"), ("\u{339d}", "\u{339d}", "\u{339d}", "\u{63}\u{6d}", "\u{63}\u{6d}"),
        ("\u{339e}", "\u{339e}", "\u{339e}", "\u{6b}\u{6d}", "\u{6b}\u{6d}"), ("\u{339f}",
        "\u{339f}", "\u{339f}", "\u{6d}\u{6d}\u{32}", "\u{6d}\u{6d}\u{32}"), ("\u{33a0}",
        "\u{33a0}", "\u{33a0}", "\u{63}\u{6d}\u{32}", "\u{63}\u{6d}\u{32}"), ("\u{33a1}",
        "\u{33a1}", "\u{33a1}", "\u{6d}\u{32}", "\u{6d}\u{32}"), ("\u{33a2}", "\u{33a2}",
        "\u{33a2}", "\u{6b}\u{6d}\u{32}", "\u{6b}\u{6d}\u{32}"), ("\u{33a3}", "\u{33a3}",
        "\u{33a3}", "\u{6d}\u{6d}\u{33}", "\u{6d}\u{6d}\u{33}"), ("\u{33a4}", "\u{33a4}",
        "\u{33a4}", "\u{63}\u{6d}\u{33}", "\u{63}\u{6d}\u{33}"), ("\u{33a5}", "\u{33a5}",
        "\u{33a5}", "\u{6d}\u{33}", "\u{6d}\u{33}"), ("\u{33a6}", "\u{33a6}", "\u{33a6}",
        "\u{6b}\u{6d}\u{33}", "\u{6b}\u{6d}\u{33}"), ("\u{33a7}", "\u{33a7}", "\u{33a7}",
        "\u{6d}\u{2215}\u{73}", "\u{6d}\u{2215}\u{73}"), ("\u{33a8}", "\u{33a8}", "\u{33a8}",
        "\u{6d}\u{2215}\u{73}\u{32}", "\u{6d}\u{2215}\u{73}\u{32}"), ("\u{33a9}", "\u{33a9}",
        "\u{33a9}", "\u{50}\u{61}", "\u{50}\u{61}"), ("\u{33aa}", "\u{33aa}", "\u{33aa}",
        "\u{6b}\u{50}\u{61}", "\u{6b}\u{50}\u{61}"), ("\u{33ab}", "\u{33ab}", "\u{33ab}",
        "\u{4d}\u{50}\u{61}", "\u{4d}\u{50}\u{61}"), ("\u{33ac}", "\u{33ac}", "\u{33ac}",
        "\u{47}\u{50}\u{61}", "\u{47}\u{50}\u{61}"), ("\u{33ad}", "\u{33ad}", "\u{33ad}",
        "\u{72}\u{61}\u{64}", "\u{72}\u{61}\u{64}"), ("\u{33ae}", "\u{33ae}", "\u{33ae}",
        "\u{72}\u{61}\u{64}\u{2215}\u{73}", "\u{72}\u{61}\u{64}\u{2215}\u{73}"), ("\u{33af}",
        "\u{33af}", "\u{33af}", "\u{72}\u{61}\u{64}\u{2215}\u{73}\u{32}",
        "\u{72}\u{61}\u{64}\u{2215}\u{73}\u{32}"), ("\u{33b0}", "\u{33b0}", "\u{33b0}",
        "\u{70}\u{73}", "\u{70}\u{73}"), ("\u{33b1}", "\u{33b1}", "\u{33b1}", "\u{6e}\u{73}",
        "\u{6e}\u{73}"), ("\u{33b2}", "\u{33b2}", "\u{33b2}", "\u{3bc}\u{73}", "\u{3bc}\u{73}"),
        ("\u{33b3}", "\u{33b3}", "\u{33b3}", "\u{6d}\u{73}", "\u{6d}\u{73}"), ("\u{33b4}",
        "\u{33b4}", "\u{33b4}", "\u{70}\u{56}", "\u{70}\u{56}"), ("\u{33b5}", "\u{33b5}",
        "\u{33b5}", "\u{6e}\u{56}", "\u{6e}\u{56}"), ("\u{33b6}", "\u{33b6}", "\u{33b6}",
        "\u{3bc}\u{56}", "\u{3bc}\u{56}"), ("\u{33b7}", "\u{33b7}", "\u{33b7}", "\u{6d}\u{56}",
        "\u{6d}\u{56}"), ("\u{33b8}", "\u{33b8}", "\u{33b8}", "\u{6b}\u{56}", "\u{6b}\u{56}"),
        ("\u{33b9}", "\u{33b9}", "\u{33b9}", "\u{4d}\u{56}", "\u{4d}\u{56}"), ("\u{33ba}",
        "\u{33ba}", "\u{33ba}", "\u{70}\u{57}", "\u{70}\u{57}"), ("\u{33bb}", "\u{33bb}",
        "\u{33bb}", "\u{6e}\u{57}", "\u{6e}\u{57}"), ("\u{33bc}", "\u{33bc}", "\u{33bc}",
        "\u{3bc}\u{57}", "\u{3bc}\u{57}"), ("\u{33bd}", "\u{33bd}", "\u{33bd}", "\u{6d}\u{57}",
        "\u{6d}\u{57}"), ("\u{33be}", "\u{33be}", "\u{33be}", "\u{6b}\u{57}", "\u{6b}\u{57}"),
        ("\u{33bf}", "\u{33bf}", "\u{33bf}", "\u{4d}\u{57}", "\u{4d}\u{57}"), ("\u{33c0}",
        "\u{33c0}", "\u{33c0}", "\u{6b}\u{3a9}", "\u{6b}\u{3a9}"), ("\u{33c1}", "\u{33c1}",
        "\u{33c1}", "\u{4d}\u{3a9}", "\u{4d}\u{3a9}"), ("\u{33c2}", "\u{33c2}", "\u{33c2}",
        "\u{61}\u{2e}\u{6d}\u{2e}", "\u{61}\u{2e}\u{6d}\u{2e}"), ("\u{33c3}", "\u{33c3}",
        "\u{33c3}", "\u{42}\u{71}", "\u{42}\u{71}"), ("\u{33c4}", "\u{33c4}", "\u{33c4}",
        "\u{63}\u{63}", "\u{63}\u{63}"), ("\u{33c5}", "\u{33c5}", "\u{33c5}", "\u{63}\u{64}",
        "\u{63}\u{64}"), ("\u{33c6}", "\u{33c6}", "\u{33c6}", "\u{43}\u{2215}\u{6b}\u{67}",
        "\u{43}\u{2215}\u{6b}\u{67}"), ("\u{33c7}", "\u{33c7}", "\u{33c7}", "\u{43}\u{6f}\u{2e}",
        "\u{43}\u{6f}\u{2e}"), ("\u{33c8}", "\u{33c8}", "\u{33c8}", "\u{64}\u{42}", "\u{64}\u{42}"),
        ("\u{33c9}", "\u{33c9}", "\u{33c9}", "\u{47}\u{79}", "\u{47}\u{79}"), ("\u{33ca}",
        "\u{33ca}", "\u{33ca}", "\u{68}\u{61}", "\u{68}\u{61}"), ("\u{33cb}", "\u{33cb}",
        "\u{33cb}", "\u{48}\u{50}", "\u{48}\u{50}"), ("\u{33cc}", "\u{33cc}", "\u{33cc}",
        "\u{69}\u{6e}", "\u{69}\u{6e}"), ("\u{33cd}", "\u{33cd}", "\u{33cd}", "\u{4b}\u{4b}",
        "\u{4b}\u{4b}"), ("\u{33ce}", "\u{33ce}", "\u{33ce}", "\u{4b}\u{4d}", "\u{4b}\u{4d}"),
        ("\u{33cf}", "\u{33cf}", "\u{33cf}", "\u{6b}\u{74}", "\u{6b}\u{74}"), ("\u{33d0}",
        "\u{33d0}", "\u{33d0}", "\u{6c}\u{6d}", "\u{6c}\u{6d}"), ("\u{33d1}", "\u{33d1}",
        "\u{33d1}", "\u{6c}\u{6e}", "\u{6c}\u{6e}"), ("\u{33d2}", "\u{33d2}", "\u{33d2}",
        "\u{6c}\u{6f}\u{67}", "\u{6c}\u{6f}\u{67}"), ("\u{33d3}", "\u{33d3}", "\u{33d3}",
        "\u{6c}\u{78}", "\u{6c}\u{78}"), ("\u{33d4}", "\u{33d4}", "\u{33d4}", "\u{6d}\u{62}",
        "\u{6d}\u{62}"), ("\u{33d5}", "\u{33d5}", "\u{33d5}", "\u{6d}\u{69}\u{6c}",
        "\u{6d}\u{69}\u{6c}"), ("\u{33d6}", "\u{33d6}", "\u{33d6}", "\u{6d}\u{6f}\u{6c}",
        "\u{6d}\u{6f}\u{6c}"), ("\u{33d7}", "\u{33d7}", "\u{33d7}", "\u{50}\u{48}", "\u{50}\u{48}"),
        ("\u{33d8}", "\u{33d8}", "\u{33d8}", "\u{70}\u{2e}\u{6d}\u{2e}",
        "\u{70}\u{2e}\u{6d}\u{2e}"), ("\u{33d9}", "\u{33d9}", "\u{33d9}", "\u{50}\u{50}\u{4d}",
        "\u{50}\u{50}\u{4d}"), ("\u{33da}", "\u{33da}", "\u{33da}", "\u{50}\u{52}", "\u{50}\u{52}"),
        ("\u{33db}", "\u{33db}", "\u{33db}", "\u{73}\u{72}", "\u{73}\u{72}"), ("\u{33dc}",
        "\u{33dc}", "\u{33dc}", "\u{53}\u{76}", "\u{53}\u{76}"), ("\u{33dd}", "\u{33dd}",
        "\u{33dd}", "\u{57}\u{62}", "\u{57}\u{62}"), ("\u{33de}", "\u{33de}", "\u{33de}",
        "\u{56}\u{2215}\u{6d}", "\u{56}\u{2215}\u{6d}"), ("\u{33df}", "\u{33df}", "\u{33df}",
        "\u{41}\u{2215}\u{6d}", "\u{41}\u{2215}\u{6d}"), ("\u{33e0}", "\u{33e0}", "\u{33e0}",
        "\u{31}\u{65e5}", "\u{31}\u{65e5}"), ("\u{33e1}", "\u{33e1}", "\u{33e1}", "\u{32}\u{65e5}",
        "\u{32}\u{65e5}"), ("\u{33e2}", "\u{33e2}", "\u{33e2}", "\u{33}\u{65e5}", "\u{33}\u{65e5}"),
        ("\u{33e3}", "\u{33e3}", "\u{33e3}", "\u{34}\u{65e5}", "\u{34}\u{65e5}"), ("\u{33e4}",
        "\u{33e4}", "\u{33e4}", "\u{35}\u{65e5}", "\u{35}\u{65e5}"), ("\u{33e5}", "\u{33e5}",
        "\u{33e5}", "\u{36}\u{65e5}", "\u{36}\u{65e5}"), ("\u{33e6}", "\u{33e6}", "\u{33e6}",
        "\u{37}\u{65e5}", "\u{37}\u{65e5}"), ("\u{33e7}", "\u{33e7}", "\u{33e7}", "\u{38}\u{65e5}",
        "\u{38}\u{65e5}"), ("\u{33e8}", "\u{33e8}", "\u{33e8}", "\u{39}\u{65e5}", "\u{39}\u{65e5}"),
        ("\u{33e9}", "\u{33e9}", "\u{33e9}", "\u{31}\u{30}\u{65e5}", "\u{31}\u{30}\u{65e5}"),
        ("\u{33ea}", "\u{33ea}", "\u{33ea}", "\u{31}\u{31}\u{65e5}", "\u{31}\u{31}\u{65e5}"),
        ("\u{33eb}", "\u{33eb}", "\u{33eb}", "\u{31}\u{32}\u{65e5}", "\u{31}\u{32}\u{65e5}"),
        ("\u{33ec}", "\u{33ec}", "\u{33ec}", "\u{31}\u{33}\u{65e5}", "\u{31}\u{33}\u{65e5}"),
        ("\u{33ed}", "\u{33ed}", "\u{33ed}", "\u{31}\u{34}\u{65e5}", "\u{31}\u{34}\u{65e5}"),
        ("\u{33ee}", "\u{33ee}", "\u{33ee}", "\u{31}\u{35}\u{65e5}", "\u{31}\u{35}\u{65e5}"),
        ("\u{33ef}", "\u{33ef}", "\u{33ef}", "\u{31}\u{36}\u{65e5}", "\u{31}\u{36}\u{65e5}"),
        ("\u{33f0}", "\u{33f0}", "\u{33f0}", "\u{31}\u{37}\u{65e5}", "\u{31}\u{37}\u{65e5}"),
        ("\u{33f1}", "\u{33f1}", "\u{33f1}", "\u{31}\u{38}\u{65e5}", "\u{31}\u{38}\u{65e5}"),
        ("\u{33f2}", "\u{33f2}", "\u{33f2}", "\u{31}\u{39}\u{65e5}", "\u{31}\u{39}\u{65e5}"),
        ("\u{33f3}", "\u{33f3}", "\u{33f3}", "\u{32}\u{30}\u{65e5}", "\u{32}\u{30}\u{65e5}"),
        ("\u{33f4}", "\u{33f4}", "\u{33f4}", "\u{32}\u{31}\u{65e5}", "\u{32}\u{31}\u{65e5}"),
        ("\u{33f5}", "\u{33f5}", "\u{33f5}", "\u{32}\u{32}\u{65e5}", "\u{32}\u{32}\u{65e5}"),
        ("\u{33f6}", "\u{33f6}", "\u{33f6}", "\u{32}\u{33}\u{65e5}", "\u{32}\u{33}\u{65e5}"),
        ("\u{33f7}", "\u{33f7}", "\u{33f7}", "\u{32}\u{34}\u{65e5}", "\u{32}\u{34}\u{65e5}"),
        ("\u{33f8}", "\u{33f8}", "\u{33f8}", "\u{32}\u{35}\u{65e5}", "\u{32}\u{35}\u{65e5}"),
        ("\u{33f9}", "\u{33f9}", "\u{33f9}", "\u{32}\u{36}\u{65e5}", "\u{32}\u{36}\u{65e5}"),
        ("\u{33fa}", "\u{33fa}", "\u{33fa}", "\u{32}\u{37}\u{65e5}", "\u{32}\u{37}\u{65e5}"),
        ("\u{33fb}", "\u{33fb}", "\u{33fb}", "\u{32}\u{38}\u{65e5}", "\u{32}\u{38}\u{65e5}"),
        ("\u{33fc}", "\u{33fc}", "\u{33fc}", "\u{32}\u{39}\u{65e5}", "\u{32}\u{39}\u{65e5}"),
        ("\u{33fd}", "\u{33fd}", "\u{33fd}", "\u{33}\u{30}\u{65e5}", "\u{33}\u{30}\u{65e5}"),
        ("\u{33fe}", "\u{33fe}", "\u{33fe}", "\u{33}\u{31}\u{65e5}", "\u{33}\u{31}\u{65e5}"),
        ("\u{33ff}", "\u{33ff}", "\u{33ff}", "\u{67}\u{61}\u{6c}", "\u{67}\u{61}\u{6c}"),
        ("\u{a69c}", "\u{a69c}", "\u{a69c}", "\u{44a}", "\u{44a}"), ("\u{a69d}", "\u{a69d}",
        "\u{a69d}", "\u{44c}", "\u{44c}"), ("\u{a770}", "\u{a770}", "\u{a770}", "\u{a76f}",
        "\u{a76f}"), ("\u{a7f8}", "\u{a7f8}", "\u{a7f8}", "\u{126}", "\u{126}"), ("\u{a7f9}",
        "\u{a7f9}", "\u{a7f9}", "\u{153}", "\u{153}"), ("\u{ab5c}", "\u{ab5c}", "\u{ab5c}",
        "\u{a727}", "\u{a727}"), ("\u{ab5d}", "\u{ab5d}", "\u{ab5d}", "\u{ab37}", "\u{ab37}"),
        ("\u{ab5e}", "\u{ab5e}", "\u{ab5e}", "\u{26b}", "\u{26b}"), ("\u{ab5f}", "\u{ab5f}",
        "\u{ab5f}", "\u{ab52}", "\u{ab52}"), ("\u{ac00}", "\u{ac00}", "\u{1100}\u{1161}",
        "\u{ac00}", "\u{1100}\u{1161}"), ("\u{ac01}", "\u{ac01}", "\u{1100}\u{1161}\u{11a8}",
        "\u{ac01}", "\u{1100}\u{1161}\u{11a8}"), ("\u{ac02}", "\u{ac02}",
        "\u{1100}\u{1161}\u{11a9}", "\u{ac02}", "\u{1100}\u{1161}\u{11a9}"), ("\u{ac03}",
        "\u{ac03}", "\u{1100}\u{1161}\u{11aa}", "\u{ac03}", "\u{1100}\u{1161}\u{11aa}"),
        ("\u{ac04}", "\u{ac04}", "\u{1100}\u{1161}\u{11ab}", "\u{ac04}",
        "\u{1100}\u{1161}\u{11ab}"), ("\u{ac05}", "\u{ac05}", "\u{1100}\u{1161}\u{11ac}",
        "\u{ac05}", "\u{1100}\u{1161}\u{11ac}"), ("\u{ac06}", "\u{ac06}",
        "\u{1100}\u{1161}\u{11ad}", "\u{ac06}", "\u{1100}\u{1161}\u{11ad}"), ("\u{ac07}",
        "\u{ac07}", "\u{1100}\u{1161}\u{11ae}", "\u{ac07}", "\u{1100}\u{1161}\u{11ae}"),
        ("\u{ac08}", "\u{ac08}", "\u{1100}\u{1161}\u{11af}", "\u{ac08}",
        "\u{1100}\u{1161}\u{11af}"), ("\u{ac09}", "\u{ac09}", "\u{1100}\u{1161}\u{11b0}",
        "\u{ac09}", "\u{1100}\u{1161}\u{11b0}"), ("\u{ac0a}", "\u{ac0a}",
        "\u{1100}\u{1161}\u{11b1}", "\u{ac0a}", "\u{1100}\u{1161}\u{11b1}"), ("\u{ac0b}",
        "\u{ac0b}", "\u{1100}\u{1161}\u{11b2}", "\u{ac0b}", "\u{1100}\u{1161}\u{11b2}"),
        ("\u{ac0c}", "\u{ac0c}", "\u{1100}\u{1161}\u{11b3}", "\u{ac0c}",
        "\u{1100}\u{1161}\u{11b3}"), ("\u{ac0d}", "\u{ac0d}", "\u{1100}\u{1161}\u{11b4}",
        "\u{ac0d}", "\u{1100}\u{1161}\u{11b4}"), ("\u{ac0e}", "\u{ac0e}",
        "\u{1100}\u{1161}\u{11b5}", "\u{ac0e}", "\u{1100}\u{1161}\u{11b5}"), ("\u{ac0f}",
        "\u{ac0f}", "\u{1100}\u{1161}\u{11b6}", "\u{ac0f}", "\u{1100}\u{1161}\u{11b6}"),
        ("\u{ac10}", "\u{ac10}", "\u{1100}\u{1161}\u{11b7}", "\u{ac10}",
        "\u{1100}\u{1161}\u{11b7}"), ("\u{ac11}", "\u{ac11}", "\u{1100}\u{1161}\u{11b8}",
        "\u{ac11}", "\u{1100}\u{1161}\u{11b8}"), ("\u{ac12}", "\u{ac12}",
        "\u{1100}\u{1161}\u{11b9}", "\u{ac12}", "\u{1100}\u{1161}\u{11b9}"), ("\u{ac13}",
        "\u{ac13}", "\u{1100}\u{1161}\u{11ba}", "\u{ac13}", "\u{1100}\u{1161}\u{11ba}"),
        ("\u{ac14}", "\u{ac14}", "\u{1100}\u{1161}\u{11bb}", "\u{ac14}",
        "\u{1100}\u{1161}\u{11bb}"), ("\u{ac15}", "\u{ac15}", "\u{1100}\u{1161}\u{11bc}",
        "\u{ac15}", "\u{1100}\u{1161}\u{11bc}"), ("\u{ac16}", "\u{ac16}",
        "\u{1100}\u{1161}\u{11bd}", "\u{ac16}", "\u{1100}\u{1161}\u{11bd}"), ("\u{ac17}",
        "\u{ac17}", "\u{1100}\u{1161}\u{11be}", "\u{ac17}", "\u{1100}\u{1161}\u{11be}"),
        ("\u{ac18}", "\u{ac18}", "\u{1100}\u{1161}\u{11bf}", "\u{ac18}",
        "\u{1100}\u{1161}\u{11bf}"), ("\u{ac19}", "\u{ac19}", "\u{1100}\u{1161}\u{11c0}",
        "\u{ac19}", "\u{1100}\u{1161}\u{11c0}"), ("\u{ac1a}", "\u{ac1a}",
        "\u{1100}\u{1161}\u{11c1}", "\u{ac1a}", "\u{1100}\u{1161}\u{11c1}"), ("\u{ac1b}",
        "\u{ac1b}", "\u{1100}\u{1161}\u{11c2}", "\u{ac1b}", "\u{1100}\u{1161}\u{11c2}"),
        ("\u{ac1c}", "\u{ac1c}", "\u{1100}\u{1162}", "\u{ac1c}", "\u{1100}\u{1162}"), ("\u{ac1d}",
        "\u{ac1d}", "\u{1100}\u{1162}\u{11a8}", "\u{ac1d}", "\u{1100}\u{1162}\u{11a8}"),
        ("\u{ac1e}", "\u{ac1e}", "\u{1100}\u{1162}\u{11a9}", "\u{ac1e}",
        "\u{1100}\u{1162}\u{11a9}"), ("\u{ac1f}", "\u{ac1f}", "\u{1100}\u{1162}\u{11aa}",
        "\u{ac1f}", "\u{1100}\u{1162}\u{11aa}"), ("\u{ac20}", "\u{ac20}",
        "\u{1100}\u{1162}\u{11ab}", "\u{ac20}", "\u{1100}\u{1162}\u{11ab}"), ("\u{ac21}",
        "\u{ac21}", "\u{1100}\u{1162}\u{11ac}", "\u{ac21}", "\u{1100}\u{1162}\u{11ac}"),
        ("\u{ac22}", "\u{ac22}", "\u{1100}\u{1162}\u{11ad}", "\u{ac22}",
        "\u{1100}\u{1162}\u{11ad}"), ("\u{ac23}", "\u{ac23}", "\u{1100}\u{1162}\u{11ae}",
        "\u{ac23}", "\u{1100}\u{1162}\u{11ae}"), ("\u{ac24}", "\u{ac24}",
        "\u{1100}\u{1162}\u{11af}", "\u{ac24}", "\u{1100}\u{1162}\u{11af}"), ("\u{ac25}",
        "\u{ac25}", "\u{1100}\u{1162}\u{11b0}", "\u{ac25}", "\u{1100}\u{1162}\u{11b0}"),
        ("\u{ac26}", "\u{ac26}", "\u{1100}\u{1162}\u{11b1}", "\u{ac26}",
        "\u{1100}\u{1162}\u{11b1}"), ("\u{ac27}", "\u{ac27}", "\u{1100}\u{1162}\u{11b2}",
        "\u{ac27}", "\u{1100}\u{1162}\u{11b2}"), ("\u{ac28}", "\u{ac28}",
        "\u{1100}\u{1162}\u{11b3}", "\u{ac28}", "\u{1100}\u{1162}\u{11b3}"), ("\u{ac29}",
        "\u{ac29}", "\u{1100}\u{1162}\u{11b4}", "\u{ac29}", "\u{1100}\u{1162}\u{11b4}"),
        ("\u{ac2a}", "\u{ac2a}", "\u{1100}\u{1162}\u{11b5}", "\u{ac2a}",
        "\u{1100}\u{1162}\u{11b5}"), ("\u{ac2b}", "\u{ac2b}", "\u{1100}\u{1162}\u{11b6}",
        "\u{ac2b}", "\u{1100}\u{1162}\u{11b6}"), ("\u{ac2c}", "\u{ac2c}",
        "\u{1100}\u{1162}\u{11b7}", "\u{ac2c}", "\u{1100}\u{1162}\u{11b7}"), ("\u{ac2d}",
        "\u{ac2d}", "\u{1100}\u{1162}\u{11b8}", "\u{ac2d}", "\u{1100}\u{1162}\u{11b8}"),
        ("\u{ac2e}", "\u{ac2e}", "\u{1100}\u{1162}\u{11b9}", "\u{ac2e}",
        "\u{1100}\u{1162}\u{11b9}"), ("\u{ac2f}", "\u{ac2f}", "\u{1100}\u{1162}\u{11ba}",
        "\u{ac2f}", "\u{1100}\u{1162}\u{11ba}"), ("\u{ac30}", "\u{ac30}",
        "\u{1100}\u{1162}\u{11bb}", "\u{ac30}", "\u{1100}\u{1162}\u{11bb}"), ("\u{ac31}",
        "\u{ac31}", "\u{1100}\u{1162}\u{11bc}", "\u{ac31}", "\u{1100}\u{1162}\u{11bc}"),
        ("\u{ac32}", "\u{ac32}", "\u{1100}\u{1162}\u{11bd}", "\u{ac32}",
        "\u{1100}\u{1162}\u{11bd}"), ("\u{ac33}", "\u{ac33}", "\u{1100}\u{1162}\u{11be}",
        "\u{ac33}", "\u{1100}\u{1162}\u{11be}"), ("\u{ac34}", "\u{ac34}",
        "\u{1100}\u{1162}\u{11bf}", "\u{ac34}", "\u{1100}\u{1162}\u{11bf}"), ("\u{ac35}",
        "\u{ac35}", "\u{1100}\u{1162}\u{11c0}", "\u{ac35}", "\u{1100}\u{1162}\u{11c0}"),
        ("\u{ac36}", "\u{ac36}", "\u{1100}\u{1162}\u{11c1}", "\u{ac36}",
        "\u{1100}\u{1162}\u{11c1}"), ("\u{ac37}", "\u{ac37}", "\u{1100}\u{1162}\u{11c2}",
        "\u{ac37}", "\u{1100}\u{1162}\u{11c2}"), ("\u{ac38}", "\u{ac38}", "\u{1100}\u{1163}",
        "\u{ac38}", "\u{1100}\u{1163}"), ("\u{ac39}", "\u{ac39}", "\u{1100}\u{1163}\u{11a8}",
        "\u{ac39}", "\u{1100}\u{1163}\u{11a8}"), ("\u{ac3a}", "\u{ac3a}",
        "\u{1100}\u{1163}\u{11a9}", "\u{ac3a}", "\u{1100}\u{1163}\u{11a9}"), ("\u{ac3b}",
        "\u{ac3b}", "\u{1100}\u{1163}\u{11aa}", "\u{ac3b}", "\u{1100}\u{1163}\u{11aa}"),
        ("\u{ac3c}", "\u{ac3c}", "\u{1100}\u{1163}\u{11ab}", "\u{ac3c}",
        "\u{1100}\u{1163}\u{11ab}"), ("\u{ac3d}", "\u{ac3d}", "\u{1100}\u{1163}\u{11ac}",
        "\u{ac3d}", "\u{1100}\u{1163}\u{11ac}"), ("\u{ac3e}", "\u{ac3e}",
        "\u{1100}\u{1163}\u{11ad}", "\u{ac3e}", "\u{1100}\u{1163}\u{11ad}"), ("\u{ac3f}",
        "\u{ac3f}", "\u{1100}\u{1163}\u{11ae}", "\u{ac3f}", "\u{1100}\u{1163}\u{11ae}"),
        ("\u{ac40}", "\u{ac40}", "\u{1100}\u{1163}\u{11af}", "\u{ac40}",
        "\u{1100}\u{1163}\u{11af}"), ("\u{ac41}", "\u{ac41}", "\u{1100}\u{1163}\u{11b0}",
        "\u{ac41}", "\u{1100}\u{1163}\u{11b0}"), ("\u{ac42}", "\u{ac42}",
        "\u{1100}\u{1163}\u{11b1}", "\u{ac42}", "\u{1100}\u{1163}\u{11b1}"), ("\u{ac43}",
        "\u{ac43}", "\u{1100}\u{1163}\u{11b2}", "\u{ac43}", "\u{1100}\u{1163}\u{11b2}"),
        ("\u{ac44}", "\u{ac44}", "\u{1100}\u{1163}\u{11b3}", "\u{ac44}",
        "\u{1100}\u{1163}\u{11b3}"), ("\u{ac45}", "\u{ac45}", "\u{1100}\u{1163}\u{11b4}",
        "\u{ac45}", "\u{1100}\u{1163}\u{11b4}"), ("\u{ac46}", "\u{ac46}",
        "\u{1100}\u{1163}\u{11b5}", "\u{ac46}", "\u{1100}\u{1163}\u{11b5}"), ("\u{ac47}",
        "\u{ac47}", "\u{1100}\u{1163}\u{11b6}", "\u{ac47}", "\u{1100}\u{1163}\u{11b6}"),
        ("\u{ac48}", "\u{ac48}", "\u{1100}\u{1163}\u{11b7}", "\u{ac48}",
        "\u{1100}\u{1163}\u{11b7}"), ("\u{ac49}", "\u{ac49}", "\u{1100}\u{1163}\u{11b8}",
        "\u{ac49}", "\u{1100}\u{1163}\u{11b8}"), ("\u{ac4a}", "\u{ac4a}",
        "\u{1100}\u{1163}\u{11b9}", "\u{ac4a}", "\u{1100}\u{1163}\u{11b9}"), ("\u{ac4b}",
        "\u{ac4b}", "\u{1100}\u{1163}\u{11ba}", "\u{ac4b}", "\u{1100}\u{1163}\u{11ba}"),
        ("\u{ac4c}", "\u{ac4c}", "\u{1100}\u{1163}\u{11bb}", "\u{ac4c}",
        "\u{1100}\u{1163}\u{11bb}"), ("\u{ac4d}", "\u{ac4d}", "\u{1100}\u{1163}\u{11bc}",
        "\u{ac4d}", "\u{1100}\u{1163}\u{11bc}"), ("\u{ac4e}", "\u{ac4e}",
        "\u{1100}\u{1163}\u{11bd}", "\u{ac4e}", "\u{1100}\u{1163}\u{11bd}"), ("\u{ac4f}",
        "\u{ac4f}", "\u{1100}\u{1163}\u{11be}", "\u{ac4f}", "\u{1100}\u{1163}\u{11be}"),
        ("\u{ac50}", "\u{ac50}", "\u{1100}\u{1163}\u{11bf}", "\u{ac50}",
        "\u{1100}\u{1163}\u{11bf}"), ("\u{ac51}", "\u{ac51}", "\u{1100}\u{1163}\u{11c0}",
        "\u{ac51}", "\u{1100}\u{1163}\u{11c0}"), ("\u{ac52}", "\u{ac52}",
        "\u{1100}\u{1163}\u{11c1}", "\u{ac52}", "\u{1100}\u{1163}\u{11c1}"), ("\u{ac53}",
        "\u{ac53}", "\u{1100}\u{1163}\u{11c2}", "\u{ac53}", "\u{1100}\u{1163}\u{11c2}"),
        ("\u{ac54}", "\u{ac54}", "\u{1100}\u{1164}", "\u{ac54}", "\u{1100}\u{1164}"), ("\u{ac55}",
        "\u{ac55}", "\u{1100}\u{1164}\u{11a8}", "\u{ac55}", "\u{1100}\u{1164}\u{11a8}"),
        ("\u{ac56}", "\u{ac56}", "\u{1100}\u{1164}\u{11a9}", "\u{ac56}",
        "\u{1100}\u{1164}\u{11a9}"), ("\u{ac57}", "\u{ac57}", "\u{1100}\u{1164}\u{11aa}",
        "\u{ac57}", "\u{1100}\u{1164}\u{11aa}"), ("\u{ac58}", "\u{ac58}",
        "\u{1100}\u{1164}\u{11ab}", "\u{ac58}", "\u{1100}\u{1164}\u{11ab}"), ("\u{ac59}",
        "\u{ac59}", "\u{1100}\u{1164}\u{11ac}", "\u{ac59}", "\u{1100}\u{1164}\u{11ac}"),
        ("\u{ac5a}", "\u{ac5a}", "\u{1100}\u{1164}\u{11ad}", "\u{ac5a}",
        "\u{1100}\u{1164}\u{11ad}"), ("\u{ac5b}", "\u{ac5b}", "\u{1100}\u{1164}\u{11ae}",
        "\u{ac5b}", "\u{1100}\u{1164}\u{11ae}"), ("\u{ac5c}", "\u{ac5c}",
        "\u{1100}\u{1164}\u{11af}", "\u{ac5c}", "\u{1100}\u{1164}\u{11af}"), ("\u{ac5d}",
        "\u{ac5d}", "\u{1100}\u{1164}\u{11b0}", "\u{ac5d}", "\u{1100}\u{1164}\u{11b0}"),
        ("\u{ac5e}", "\u{ac5e}", "\u{1100}\u{1164}\u{11b1}", "\u{ac5e}",
        "\u{1100}\u{1164}\u{11b1}"), ("\u{ac5f}", "\u{ac5f}", "\u{1100}\u{1164}\u{11b2}",
        "\u{ac5f}", "\u{1100}\u{1164}\u{11b2}"), ("\u{ac60}", "\u{ac60}",
        "\u{1100}\u{1164}\u{11b3}", "\u{ac60}", "\u{1100}\u{1164}\u{11b3}"), ("\u{ac61}",
        "\u{ac61}", "\u{1100}\u{1164}\u{11b4}", "\u{ac61}", "\u{1100}\u{1164}\u{11b4}"),
        ("\u{ac62}", "\u{ac62}", "\u{1100}\u{1164}\u{11b5}", "\u{ac62}",
        "\u{1100}\u{1164}\u{11b5}"), ("\u{ac63}", "\u{ac63}", "\u{1100}\u{1164}\u{11b6}",
        "\u{ac63}", "\u{1100}\u{1164}\u{11b6}"), ("\u{ac64}", "\u{ac64}",
        "\u{1100}\u{1164}\u{11b7}", "\u{ac64}", "\u{1100}\u{1164}\u{11b7}"), ("\u{ac65}",
        "\u{ac65}", "\u{1100}\u{1164}\u{11b8}", "\u{ac65}", "\u{1100}\u{1164}\u{11b8}"),
        ("\u{ac66}", "\u{ac66}", "\u{1100}\u{1164}\u{11b9}", "\u{ac66}",
        "\u{1100}\u{1164}\u{11b9}"), ("\u{ac67}", "\u{ac67}", "\u{1100}\u{1164}\u{11ba}",
        "\u{ac67}", "\u{1100}\u{1164}\u{11ba}"), ("\u{ac68}", "\u{ac68}",
        "\u{1100}\u{1164}\u{11bb}", "\u{ac68}", "\u{1100}\u{1164}\u{11bb}"), ("\u{ac69}",
        "\u{ac69}", "\u{1100}\u{1164}\u{11bc}", "\u{ac69}", "\u{1100}\u{1164}\u{11bc}"),
        ("\u{ac6a}", "\u{ac6a}", "\u{1100}\u{1164}\u{11bd}", "\u{ac6a}",
        "\u{1100}\u{1164}\u{11bd}"), ("\u{ac6b}", "\u{ac6b}", "\u{1100}\u{1164}\u{11be}",
        "\u{ac6b}", "\u{1100}\u{1164}\u{11be}"), ("\u{ac6c}", "\u{ac6c}",
        "\u{1100}\u{1164}\u{11bf}", "\u{ac6c}", "\u{1100}\u{1164}\u{11bf}"), ("\u{ac6d}",
        "\u{ac6d}", "\u{1100}\u{1164}\u{11c0}", "\u{ac6d}", "\u{1100}\u{1164}\u{11c0}"),
        ("\u{ac6e}", "\u{ac6e}", "\u{1100}\u{1164}\u{11c1}", "\u{ac6e}",
        "\u{1100}\u{1164}\u{11c1}"), ("\u{ac6f}", "\u{ac6f}", "\u{1100}\u{1164}\u{11c2}",
        "\u{ac6f}", "\u{1100}\u{1164}\u{11c2}"), ("\u{ac70}", "\u{ac70}", "\u{1100}\u{1165}",
        "\u{ac70}", "\u{1100}\u{1165}"), ("\u{ac71}", "\u{ac71}", "\u{1100}\u{1165}\u{11a8}",
        "\u{ac71}", "\u{1100}\u{1165}\u{11a8}"), ("\u{ac72}", "\u{ac72}",
        "\u{1100}\u{1165}\u{11a9}", "\u{ac72}", "\u{1100}\u{1165}\u{11a9}"), ("\u{ac73}",
        "\u{ac73}", "\u{1100}\u{1165}\u{11aa}", "\u{ac73}", "\u{1100}\u{1165}\u{11aa}"),
        ("\u{ac74}", "\u{ac74}", "\u{1100}\u{1165}\u{11ab}", "\u{ac74}",
        "\u{1100}\u{1165}\u{11ab}"), ("\u{ac75}", "\u{ac75}", "\u{1100}\u{1165}\u{11ac}",
        "\u{ac75}", "\u{1100}\u{1165}\u{11ac}"), ("\u{ac76}", "\u{ac76}",
        "\u{1100}\u{1165}\u{11ad}", "\u{ac76}", "\u{1100}\u{1165}\u{11ad}"), ("\u{ac77}",
        "\u{ac77}", "\u{1100}\u{1165}\u{11ae}", "\u{ac77}", "\u{1100}\u{1165}\u{11ae}"),
        ("\u{ac78}", "\u{ac78}", "\u{1100}\u{1165}\u{11af}", "\u{ac78}",
        "\u{1100}\u{1165}\u{11af}"), ("\u{ac79}", "\u{ac79}", "\u{1100}\u{1165}\u{11b0}",
        "\u{ac79}", "\u{1100}\u{1165}\u{11b0}"), ("\u{ac7a}", "\u{ac7a}",
        "\u{1100}\u{1165}\u{11b1}", "\u{ac7a}", "\u{1100}\u{1165}\u{11b1}"), ("\u{ac7b}",
        "\u{ac7b}", "\u{1100}\u{1165}\u{11b2}", "\u{ac7b}", "\u{1100}\u{1165}\u{11b2}"),
        ("\u{ac7c}", "\u{ac7c}", "\u{1100}\u{1165}\u{11b3}", "\u{ac7c}",
        "\u{1100}\u{1165}\u{11b3}"), ("\u{ac7d}", "\u{ac7d}", "\u{1100}\u{1165}\u{11b4}",
        "\u{ac7d}", "\u{1100}\u{1165}\u{11b4}"), ("\u{ac7e}", "\u{ac7e}",
        "\u{1100}\u{1165}\u{11b5}", "\u{ac7e}", "\u{1100}\u{1165}\u{11b5}"), ("\u{ac7f}",
        "\u{ac7f}", "\u{1100}\u{1165}\u{11b6}", "\u{ac7f}", "\u{1100}\u{1165}\u{11b6}"),
        ("\u{ac80}", "\u{ac80}", "\u{1100}\u{1165}\u{11b7}", "\u{ac80}",
        "\u{1100}\u{1165}\u{11b7}"), ("\u{ac81}", "\u{ac81}", "\u{1100}\u{1165}\u{11b8}",
        "\u{ac81}", "\u{1100}\u{1165}\u{11b8}"), ("\u{ac82}", "\u{ac82}",
        "\u{1100}\u{1165}\u{11b9}", "\u{ac82}", "\u{1100}\u{1165}\u{11b9}"), ("\u{ac83}",
        "\u{ac83}", "\u{1100}\u{1165}\u{11ba}", "\u{ac83}", "\u{1100}\u{1165}\u{11ba}"),
        ("\u{ac84}", "\u{ac84}", "\u{1100}\u{1165}\u{11bb}", "\u{ac84}",
        "\u{1100}\u{1165}\u{11bb}"), ("\u{ac85}", "\u{ac85}", "\u{1100}\u{1165}\u{11bc}",
        "\u{ac85}", "\u{1100}\u{1165}\u{11bc}"), ("\u{ac86}", "\u{ac86}",
        "\u{1100}\u{1165}\u{11bd}", "\u{ac86}", "\u{1100}\u{1165}\u{11bd}"), ("\u{ac87}",
        "\u{ac87}", "\u{1100}\u{1165}\u{11be}", "\u{ac87}", "\u{1100}\u{1165}\u{11be}"),
        ("\u{ac88}", "\u{ac88}", "\u{1100}\u{1165}\u{11bf}", "\u{ac88}",
        "\u{1100}\u{1165}\u{11bf}"), ("\u{ac89}", "\u{ac89}", "\u{1100}\u{1165}\u{11c0}",
        "\u{ac89}", "\u{1100}\u{1165}\u{11c0}"), ("\u{ac8a}", "\u{ac8a}",
        "\u{1100}\u{1165}\u{11c1}", "\u{ac8a}", "\u{1100}\u{1165}\u{11c1}"), ("\u{ac8b}",
        "\u{ac8b}", "\u{1100}\u{1165}\u{11c2}", "\u{ac8b}", "\u{1100}\u{1165}\u{11c2}"),
        ("\u{ac8c}", "\u{ac8c}", "\u{1100}\u{1166}", "\u{ac8c}", "\u{1100}\u{1166}"), ("\u{ac8d}",
        "\u{ac8d}", "\u{1100}\u{1166}\u{11a8}", "\u{ac8d}", "\u{1100}\u{1166}\u{11a8}"),
        ("\u{ac8e}", "\u{ac8e}", "\u{1100}\u{1166}\u{11a9}", "\u{ac8e}",
        "\u{1100}\u{1166}\u{11a9}"), ("\u{ac8f}", "\u{ac8f}", "\u{1100}\u{1166}\u{11aa}",
        "\u{ac8f}", "\u{1100}\u{1166}\u{11aa}"), ("\u{ac90}", "\u{ac90}",
        "\u{1100}\u{1166}\u{11ab}", "\u{ac90}", "\u{1100}\u{1166}\u{11ab}"), ("\u{ac91}",
        "\u{ac91}", "\u{1100}\u{1166}\u{11ac}", "\u{ac91}", "\u{1100}\u{1166}\u{11ac}"),
        ("\u{ac92}", "\u{ac92}", "\u{1100}\u{1166}\u{11ad}", "\u{ac92}",
        "\u{1100}\u{1166}\u{11ad}"), ("\u{ac93}", "\u{ac93}", "\u{1100}\u{1166}\u{11ae}",
        "\u{ac93}", "\u{1100}\u{1166}\u{11ae}"), ("\u{ac94}", "\u{ac94}",
        "\u{1100}\u{1166}\u{11af}", "\u{ac94}", "\u{1100}\u{1166}\u{11af}"), ("\u{ac95}",
        "\u{ac95}", "\u{1100}\u{1166}\u{11b0}", "\u{ac95}", "\u{1100}\u{1166}\u{11b0}"),
        ("\u{ac96}", "\u{ac96}", "\u{1100}\u{1166}\u{11b1}", "\u{ac96}",
        "\u{1100}\u{1166}\u{11b1}"), ("\u{ac97}", "\u{ac97}", "\u{1100}\u{1166}\u{11b2}",
        "\u{ac97}", "\u{1100}\u{1166}\u{11b2}"), ("\u{ac98}", "\u{ac98}",
        "\u{1100}\u{1166}\u{11b3}", "\u{ac98}", "\u{1100}\u{1166}\u{11b3}"), ("\u{ac99}",
        "\u{ac99}", "\u{1100}\u{1166}\u{11b4}", "\u{ac99}", "\u{1100}\u{1166}\u{11b4}"),
        ("\u{ac9a}", "\u{ac9a}", "\u{1100}\u{1166}\u{11b5}", "\u{ac9a}",
        "\u{1100}\u{1166}\u{11b5}"), ("\u{ac9b}", "\u{ac9b}", "\u{1100}\u{1166}\u{11b6}",
        "\u{ac9b}", "\u{1100}\u{1166}\u{11b6}"), ("\u{ac9c}", "\u{ac9c}",
        "\u{1100}\u{1166}\u{11b7}", "\u{ac9c}", "\u{1100}\u{1166}\u{11b7}"), ("\u{ac9d}",
        "\u{ac9d}", "\u{1100}\u{1166}\u{11b8}", "\u{ac9d}", "\u{1100}\u{1166}\u{11b8}"),
        ("\u{ac9e}", "\u{ac9e}", "\u{1100}\u{1166}\u{11b9}", "\u{ac9e}",
        "\u{1100}\u{1166}\u{11b9}"), ("\u{ac9f}", "\u{ac9f}", "\u{1100}\u{1166}\u{11ba}",
        "\u{ac9f}", "\u{1100}\u{1166}\u{11ba}"), ("\u{aca0}", "\u{aca0}",
        "\u{1100}\u{1166}\u{11bb}", "\u{aca0}", "\u{1100}\u{1166}\u{11bb}"), ("\u{aca1}",
        "\u{aca1}", "\u{1100}\u{1166}\u{11bc}", "\u{aca1}", "\u{1100}\u{1166}\u{11bc}"),
        ("\u{aca2}", "\u{aca2}", "\u{1100}\u{1166}\u{11bd}", "\u{aca2}",
        "\u{1100}\u{1166}\u{11bd}"), ("\u{aca3}", "\u{aca3}", "\u{1100}\u{1166}\u{11be}",
        "\u{aca3}", "\u{1100}\u{1166}\u{11be}"), ("\u{aca4}", "\u{aca4}",
        "\u{1100}\u{1166}\u{11bf}", "\u{aca4}", "\u{1100}\u{1166}\u{11bf}"), ("\u{aca5}",
        "\u{aca5}", "\u{1100}\u{1166}\u{11c0}", "\u{aca5}", "\u{1100}\u{1166}\u{11c0}"),
        ("\u{aca6}", "\u{aca6}", "\u{1100}\u{1166}\u{11c1}", "\u{aca6}",
        "\u{1100}\u{1166}\u{11c1}"), ("\u{aca7}", "\u{aca7}", "\u{1100}\u{1166}\u{11c2}",
        "\u{aca7}", "\u{1100}\u{1166}\u{11c2}"), ("\u{aca8}", "\u{aca8}", "\u{1100}\u{1167}",
        "\u{aca8}", "\u{1100}\u{1167}"), ("\u{aca9}", "\u{aca9}", "\u{1100}\u{1167}\u{11a8}",
        "\u{aca9}", "\u{1100}\u{1167}\u{11a8}"), ("\u{acaa}", "\u{acaa}",
        "\u{1100}\u{1167}\u{11a9}", "\u{acaa}", "\u{1100}\u{1167}\u{11a9}"), ("\u{acab}",
        "\u{acab}", "\u{1100}\u{1167}\u{11aa}", "\u{acab}", "\u{1100}\u{1167}\u{11aa}"),
        ("\u{acac}", "\u{acac}", "\u{1100}\u{1167}\u{11ab}", "\u{acac}",
        "\u{1100}\u{1167}\u{11ab}"), ("\u{acad}", "\u{acad}", "\u{1100}\u{1167}\u{11ac}",
        "\u{acad}", "\u{1100}\u{1167}\u{11ac}"), ("\u{acae}", "\u{acae}",
        "\u{1100}\u{1167}\u{11ad}", "\u{acae}", "\u{1100}\u{1167}\u{11ad}"), ("\u{acaf}",
        "\u{acaf}", "\u{1100}\u{1167}\u{11ae}", "\u{acaf}", "\u{1100}\u{1167}\u{11ae}"),
        ("\u{acb0}", "\u{acb0}", "\u{1100}\u{1167}\u{11af}", "\u{acb0}",
        "\u{1100}\u{1167}\u{11af}"), ("\u{acb1}", "\u{acb1}", "\u{1100}\u{1167}\u{11b0}",
        "\u{acb1}", "\u{1100}\u{1167}\u{11b0}"), ("\u{acb2}", "\u{acb2}",
        "\u{1100}\u{1167}\u{11b1}", "\u{acb2}", "\u{1100}\u{1167}\u{11b1}"), ("\u{acb3}",
        "\u{acb3}", "\u{1100}\u{1167}\u{11b2}", "\u{acb3}", "\u{1100}\u{1167}\u{11b2}"),
        ("\u{acb4}", "\u{acb4}", "\u{1100}\u{1167}\u{11b3}", "\u{acb4}",
        "\u{1100}\u{1167}\u{11b3}"), ("\u{acb5}", "\u{acb5}", "\u{1100}\u{1167}\u{11b4}",
        "\u{acb5}", "\u{1100}\u{1167}\u{11b4}"), ("\u{acb6}", "\u{acb6}",
        "\u{1100}\u{1167}\u{11b5}", "\u{acb6}", "\u{1100}\u{1167}\u{11b5}"), ("\u{acb7}",
        "\u{acb7}", "\u{1100}\u{1167}\u{11b6}", "\u{acb7}", "\u{1100}\u{1167}\u{11b6}"),
        ("\u{acb8}", "\u{acb8}", "\u{1100}\u{1167}\u{11b7}", "\u{acb8}",
        "\u{1100}\u{1167}\u{11b7}"), ("\u{acb9}", "\u{acb9}", "\u{1100}\u{1167}\u{11b8}",
        "\u{acb9}", "\u{1100}\u{1167}\u{11b8}"), ("\u{acba}", "\u{acba}",
        "\u{1100}\u{1167}\u{11b9}", "\u{acba}", "\u{1100}\u{1167}\u{11b9}"), ("\u{acbb}",
        "\u{acbb}", "\u{1100}\u{1167}\u{11ba}", "\u{acbb}", "\u{1100}\u{1167}\u{11ba}"),
        ("\u{acbc}", "\u{acbc}", "\u{1100}\u{1167}\u{11bb}", "\u{acbc}",
        "\u{1100}\u{1167}\u{11bb}"), ("\u{acbd}", "\u{acbd}", "\u{1100}\u{1167}\u{11bc}",
        "\u{acbd}", "\u{1100}\u{1167}\u{11bc}"), ("\u{acbe}", "\u{acbe}",
        "\u{1100}\u{1167}\u{11bd}", "\u{acbe}", "\u{1100}\u{1167}\u{11bd}"), ("\u{acbf}",
        "\u{acbf}", "\u{1100}\u{1167}\u{11be}", "\u{acbf}", "\u{1100}\u{1167}\u{11be}"),
        ("\u{acc0}", "\u{acc0}", "\u{1100}\u{1167}\u{11bf}", "\u{acc0}",
        "\u{1100}\u{1167}\u{11bf}"), ("\u{acc1}", "\u{acc1}", "\u{1100}\u{1167}\u{11c0}",
        "\u{acc1}", "\u{1100}\u{1167}\u{11c0}"), ("\u{acc2}", "\u{acc2}",
        "\u{1100}\u{1167}\u{11c1}", "\u{acc2}", "\u{1100}\u{1167}\u{11c1}"), ("\u{acc3}",
        "\u{acc3}", "\u{1100}\u{1167}\u{11c2}", "\u{acc3}", "\u{1100}\u{1167}\u{11c2}"),
        ("\u{acc4}", "\u{acc4}", "\u{1100}\u{1168}", "\u{acc4}", "\u{1100}\u{1168}"), ("\u{acc5}",
        "\u{acc5}", "\u{1100}\u{1168}\u{11a8}", "\u{acc5}", "\u{1100}\u{1168}\u{11a8}"),
        ("\u{acc6}", "\u{acc6}", "\u{1100}\u{1168}\u{11a9}", "\u{acc6}",
        "\u{1100}\u{1168}\u{11a9}"), ("\u{acc7}", "\u{acc7}", "\u{1100}\u{1168}\u{11aa}",
        "\u{acc7}", "\u{1100}\u{1168}\u{11aa}"), ("\u{acc8}", "\u{acc8}",
        "\u{1100}\u{1168}\u{11ab}", "\u{acc8}", "\u{1100}\u{1168}\u{11ab}"), ("\u{acc9}",
        "\u{acc9}", "\u{1100}\u{1168}\u{11ac}", "\u{acc9}", "\u{1100}\u{1168}\u{11ac}"),
        ("\u{acca}", "\u{acca}", "\u{1100}\u{1168}\u{11ad}", "\u{acca}",
        "\u{1100}\u{1168}\u{11ad}"), ("\u{accb}", "\u{accb}", "\u{1100}\u{1168}\u{11ae}",
        "\u{accb}", "\u{1100}\u{1168}\u{11ae}"), ("\u{accc}", "\u{accc}",
        "\u{1100}\u{1168}\u{11af}", "\u{accc}", "\u{1100}\u{1168}\u{11af}"), ("\u{accd}",
        "\u{accd}", "\u{1100}\u{1168}\u{11b0}", "\u{accd}", "\u{1100}\u{1168}\u{11b0}"),
        ("\u{acce}", "\u{acce}", "\u{1100}\u{1168}\u{11b1}", "\u{acce}",
        "\u{1100}\u{1168}\u{11b1}"), ("\u{accf}", "\u{accf}", "\u{1100}\u{1168}\u{11b2}",
        "\u{accf}", "\u{1100}\u{1168}\u{11b2}"), ("\u{acd0}", "\u{acd0}",
        "\u{1100}\u{1168}\u{11b3}", "\u{acd0}", "\u{1100}\u{1168}\u{11b3}"), ("\u{acd1}",
        "\u{acd1}", "\u{1100}\u{1168}\u{11b4}", "\u{acd1}", "\u{1100}\u{1168}\u{11b4}"),
        ("\u{acd2}", "\u{acd2}", "\u{1100}\u{1168}\u{11b5}", "\u{acd2}",
        "\u{1100}\u{1168}\u{11b5}"), ("\u{acd3}", "\u{acd3}", "\u{1100}\u{1168}\u{11b6}",
        "\u{acd3}", "\u{1100}\u{1168}\u{11b6}"), ("\u{acd4}", "\u{acd4}",
        "\u{1100}\u{1168}\u{11b7}", "\u{acd4}", "\u{1100}\u{1168}\u{11b7}"), ("\u{acd5}",
        "\u{acd5}", "\u{1100}\u{1168}\u{11b8}", "\u{acd5}", "\u{1100}\u{1168}\u{11b8}"),
        ("\u{acd6}", "\u{acd6}", "\u{1100}\u{1168}\u{11b9}", "\u{acd6}",
        "\u{1100}\u{1168}\u{11b9}"), ("\u{acd7}", "\u{acd7}", "\u{1100}\u{1168}\u{11ba}",
        "\u{acd7}", "\u{1100}\u{1168}\u{11ba}"), ("\u{acd8}", "\u{acd8}",
        "\u{1100}\u{1168}\u{11bb}", "\u{acd8}", "\u{1100}\u{1168}\u{11bb}"), ("\u{acd9}",
        "\u{acd9}", "\u{1100}\u{1168}\u{11bc}", "\u{acd9}", "\u{1100}\u{1168}\u{11bc}"),
        ("\u{acda}", "\u{acda}", "\u{1100}\u{1168}\u{11bd}", "\u{acda}",
        "\u{1100}\u{1168}\u{11bd}"), ("\u{acdb}", "\u{acdb}", "\u{1100}\u{1168}\u{11be}",
        "\u{acdb}", "\u{1100}\u{1168}\u{11be}"), ("\u{acdc}", "\u{acdc}",
        "\u{1100}\u{1168}\u{11bf}", "\u{acdc}", "\u{1100}\u{1168}\u{11bf}"), ("\u{acdd}",
        "\u{acdd}", "\u{1100}\u{1168}\u{11c0}", "\u{acdd}", "\u{1100}\u{1168}\u{11c0}"),
        ("\u{acde}", "\u{acde}", "\u{1100}\u{1168}\u{11c1}", "\u{acde}",
        "\u{1100}\u{1168}\u{11c1}"), ("\u{acdf}", "\u{acdf}", "\u{1100}\u{1168}\u{11c2}",
        "\u{acdf}", "\u{1100}\u{1168}\u{11c2}"), ("\u{ace0}", "\u{ace0}", "\u{1100}\u{1169}",
        "\u{ace0}", "\u{1100}\u{1169}"), ("\u{ace1}", "\u{ace1}", "\u{1100}\u{1169}\u{11a8}",
        "\u{ace1}", "\u{1100}\u{1169}\u{11a8}"), ("\u{ace2}", "\u{ace2}",
        "\u{1100}\u{1169}\u{11a9}", "\u{ace2}", "\u{1100}\u{1169}\u{11a9}"), ("\u{ace3}",
        "\u{ace3}", "\u{1100}\u{1169}\u{11aa}", "\u{ace3}", "\u{1100}\u{1169}\u{11aa}"),
        ("\u{ace4}", "\u{ace4}", "\u{1100}\u{1169}\u{11ab}", "\u{ace4}",
        "\u{1100}\u{1169}\u{11ab}"), ("\u{ace5}", "\u{ace5}", "\u{1100}\u{1169}\u{11ac}",
        "\u{ace5}", "\u{1100}\u{1169}\u{11ac}"), ("\u{ace6}", "\u{ace6}",
        "\u{1100}\u{1169}\u{11ad}", "\u{ace6}", "\u{1100}\u{1169}\u{11ad}"), ("\u{ace7}",
        "\u{ace7}", "\u{1100}\u{1169}\u{11ae}", "\u{ace7}", "\u{1100}\u{1169}\u{11ae}"),
        ("\u{ace8}", "\u{ace8}", "\u{1100}\u{1169}\u{11af}", "\u{ace8}",
        "\u{1100}\u{1169}\u{11af}"), ("\u{ace9}", "\u{ace9}", "\u{1100}\u{1169}\u{11b0}",
        "\u{ace9}", "\u{1100}\u{1169}\u{11b0}"), ("\u{acea}", "\u{acea}",
        "\u{1100}\u{1169}\u{11b1}", "\u{acea}", "\u{1100}\u{1169}\u{11b1}"), ("\u{aceb}",
        "\u{aceb}", "\u{1100}\u{1169}\u{11b2}", "\u{aceb}", "\u{1100}\u{1169}\u{11b2}"),
        ("\u{acec}", "\u{acec}", "\u{1100}\u{1169}\u{11b3}", "\u{acec}",
        "\u{1100}\u{1169}\u{11b3}"), ("\u{aced}", "\u{aced}", "\u{1100}\u{1169}\u{11b4}",
        "\u{aced}", "\u{1100}\u{1169}\u{11b4}"), ("\u{acee}", "\u{acee}",
        "\u{1100}\u{1169}\u{11b5}", "\u{acee}", "\u{1100}\u{1169}\u{11b5}"), ("\u{acef}",
        "\u{acef}", "\u{1100}\u{1169}\u{11b6}", "\u{acef}", "\u{1100}\u{1169}\u{11b6}"),
        ("\u{acf0}", "\u{acf0}", "\u{1100}\u{1169}\u{11b7}", "\u{acf0}",
        "\u{1100}\u{1169}\u{11b7}"), ("\u{acf1}", "\u{acf1}", "\u{1100}\u{1169}\u{11b8}",
        "\u{acf1}", "\u{1100}\u{1169}\u{11b8}"), ("\u{acf2}", "\u{acf2}",
        "\u{1100}\u{1169}\u{11b9}", "\u{acf2}", "\u{1100}\u{1169}\u{11b9}"), ("\u{acf3}",
        "\u{acf3}", "\u{1100}\u{1169}\u{11ba}", "\u{acf3}", "\u{1100}\u{1169}\u{11ba}"),
        ("\u{acf4}", "\u{acf4}", "\u{1100}\u{1169}\u{11bb}", "\u{acf4}",
        "\u{1100}\u{1169}\u{11bb}"), ("\u{acf5}", "\u{acf5}", "\u{1100}\u{1169}\u{11bc}",
        "\u{acf5}", "\u{1100}\u{1169}\u{11bc}"), ("\u{acf6}", "\u{acf6}",
        "\u{1100}\u{1169}\u{11bd}", "\u{acf6}", "\u{1100}\u{1169}\u{11bd}"), ("\u{acf7}",
        "\u{acf7}", "\u{1100}\u{1169}\u{11be}", "\u{acf7}", "\u{1100}\u{1169}\u{11be}"),
        ("\u{acf8}", "\u{acf8}", "\u{1100}\u{1169}\u{11bf}", "\u{acf8}",
        "\u{1100}\u{1169}\u{11bf}"), ("\u{acf9}", "\u{acf9}", "\u{1100}\u{1169}\u{11c0}",
        "\u{acf9}", "\u{1100}\u{1169}\u{11c0}"), ("\u{acfa}", "\u{acfa}",
        "\u{1100}\u{1169}\u{11c1}", "\u{acfa}", "\u{1100}\u{1169}\u{11c1}"), ("\u{acfb}",
        "\u{acfb}", "\u{1100}\u{1169}\u{11c2}", "\u{acfb}", "\u{1100}\u{1169}\u{11c2}"),
        ("\u{acfc}", "\u{acfc}", "\u{1100}\u{116a}", "\u{acfc}", "\u{1100}\u{116a}"), ("\u{acfd}",
        "\u{acfd}", "\u{1100}\u{116a}\u{11a8}", "\u{acfd}", "\u{1100}\u{116a}\u{11a8}"),
        ("\u{acfe}", "\u{acfe}", "\u{1100}\u{116a}\u{11a9}", "\u{acfe}",
        "\u{1100}\u{116a}\u{11a9}"), ("\u{acff}", "\u{acff}", "\u{1100}\u{116a}\u{11aa}",
        "\u{acff}", "\u{1100}\u{116a}\u{11aa}"), ("\u{ad00}", "\u{ad00}",
        "\u{1100}\u{116a}\u{11ab}", "\u{ad00}", "\u{1100}\u{116a}\u{11ab}"), ("\u{ad01}",
        "\u{ad01}", "\u{1100}\u{116a}\u{11ac}", "\u{ad01}", "\u{1100}\u{116a}\u{11ac}"),
        ("\u{ad02}", "\u{ad02}", "\u{1100}\u{116a}\u{11ad}", "\u{ad02}",
        "\u{1100}\u{116a}\u{11ad}"), ("\u{ad03}", "\u{ad03}", "\u{1100}\u{116a}\u{11ae}",
        "\u{ad03}", "\u{1100}\u{116a}\u{11ae}"), ("\u{ad04}", "\u{ad04}",
        "\u{1100}\u{116a}\u{11af}", "\u{ad04}", "\u{1100}\u{116a}\u{11af}"), ("\u{ad05}",
        "\u{ad05}", "\u{1100}\u{116a}\u{11b0}", "\u{ad05}", "\u{1100}\u{116a}\u{11b0}"),
        ("\u{ad06}", "\u{ad06}", "\u{1100}\u{116a}\u{11b1}", "\u{ad06}",
        "\u{1100}\u{116a}\u{11b1}"), ("\u{ad07}", "\u{ad07}", "\u{1100}\u{116a}\u{11b2}",
        "\u{ad07}", "\u{1100}\u{116a}\u{11b2}"), ("\u{ad08}", "\u{ad08}",
        "\u{1100}\u{116a}\u{11b3}", "\u{ad08}", "\u{1100}\u{116a}\u{11b3}"), ("\u{ad09}",
        "\u{ad09}", "\u{1100}\u{116a}\u{11b4}", "\u{ad09}", "\u{1100}\u{116a}\u{11b4}"),
        ("\u{ad0a}", "\u{ad0a}", "\u{1100}\u{116a}\u{11b5}", "\u{ad0a}",
        "\u{1100}\u{116a}\u{11b5}"), ("\u{ad0b}", "\u{ad0b}", "\u{1100}\u{116a}\u{11b6}",
        "\u{ad0b}", "\u{1100}\u{116a}\u{11b6}"), ("\u{ad0c}", "\u{ad0c}",
        "\u{1100}\u{116a}\u{11b7}", "\u{ad0c}", "\u{1100}\u{116a}\u{11b7}"), ("\u{ad0d}",
        "\u{ad0d}", "\u{1100}\u{116a}\u{11b8}", "\u{ad0d}", "\u{1100}\u{116a}\u{11b8}"),
        ("\u{ad0e}", "\u{ad0e}", "\u{1100}\u{116a}\u{11b9}", "\u{ad0e}",
        "\u{1100}\u{116a}\u{11b9}"), ("\u{ad0f}", "\u{ad0f}", "\u{1100}\u{116a}\u{11ba}",
        "\u{ad0f}", "\u{1100}\u{116a}\u{11ba}"), ("\u{ad10}", "\u{ad10}",
        "\u{1100}\u{116a}\u{11bb}", "\u{ad10}", "\u{1100}\u{116a}\u{11bb}"), ("\u{ad11}",
        "\u{ad11}", "\u{1100}\u{116a}\u{11bc}", "\u{ad11}", "\u{1100}\u{116a}\u{11bc}"),
        ("\u{ad12}", "\u{ad12}", "\u{1100}\u{116a}\u{11bd}", "\u{ad12}",
        "\u{1100}\u{116a}\u{11bd}"), ("\u{ad13}", "\u{ad13}", "\u{1100}\u{116a}\u{11be}",
        "\u{ad13}", "\u{1100}\u{116a}\u{11be}"), ("\u{ad14}", "\u{ad14}",
        "\u{1100}\u{116a}\u{11bf}", "\u{ad14}", "\u{1100}\u{116a}\u{11bf}"), ("\u{ad15}",
        "\u{ad15}", "\u{1100}\u{116a}\u{11c0}", "\u{ad15}", "\u{1100}\u{116a}\u{11c0}"),
        ("\u{ad16}", "\u{ad16}", "\u{1100}\u{116a}\u{11c1}", "\u{ad16}",
        "\u{1100}\u{116a}\u{11c1}"), ("\u{ad17}", "\u{ad17}", "\u{1100}\u{116a}\u{11c2}",
        "\u{ad17}", "\u{1100}\u{116a}\u{11c2}"), ("\u{ad18}", "\u{ad18}", "\u{1100}\u{116b}",
        "\u{ad18}", "\u{1100}\u{116b}"), ("\u{ad19}", "\u{ad19}", "\u{1100}\u{116b}\u{11a8}",
        "\u{ad19}", "\u{1100}\u{116b}\u{11a8}"), ("\u{ad1a}", "\u{ad1a}",
        "\u{1100}\u{116b}\u{11a9}", "\u{ad1a}", "\u{1100}\u{116b}\u{11a9}"), ("\u{ad1b}",
        "\u{ad1b}", "\u{1100}\u{116b}\u{11aa}", "\u{ad1b}", "\u{1100}\u{116b}\u{11aa}"),
        ("\u{ad1c}", "\u{ad1c}", "\u{1100}\u{116b}\u{11ab}", "\u{ad1c}",
        "\u{1100}\u{116b}\u{11ab}"), ("\u{ad1d}", "\u{ad1d}", "\u{1100}\u{116b}\u{11ac}",
        "\u{ad1d}", "\u{1100}\u{116b}\u{11ac}"), ("\u{ad1e}", "\u{ad1e}",
        "\u{1100}\u{116b}\u{11ad}", "\u{ad1e}", "\u{1100}\u{116b}\u{11ad}"), ("\u{ad1f}",
        "\u{ad1f}", "\u{1100}\u{116b}\u{11ae}", "\u{ad1f}", "\u{1100}\u{116b}\u{11ae}"),
        ("\u{ad20}", "\u{ad20}", "\u{1100}\u{116b}\u{11af}", "\u{ad20}",
        "\u{1100}\u{116b}\u{11af}"), ("\u{ad21}", "\u{ad21}", "\u{1100}\u{116b}\u{11b0}",
        "\u{ad21}", "\u{1100}\u{116b}\u{11b0}"), ("\u{ad22}", "\u{ad22}",
        "\u{1100}\u{116b}\u{11b1}", "\u{ad22}", "\u{1100}\u{116b}\u{11b1}"), ("\u{ad23}",
        "\u{ad23}", "\u{1100}\u{116b}\u{11b2}", "\u{ad23}", "\u{1100}\u{116b}\u{11b2}"),
        ("\u{ad24}", "\u{ad24}", "\u{1100}\u{116b}\u{11b3}", "\u{ad24}",
        "\u{1100}\u{116b}\u{11b3}"), ("\u{ad25}", "\u{ad25}", "\u{1100}\u{116b}\u{11b4}",
        "\u{ad25}", "\u{1100}\u{116b}\u{11b4}"), ("\u{ad26}", "\u{ad26}",
        "\u{1100}\u{116b}\u{11b5}", "\u{ad26}", "\u{1100}\u{116b}\u{11b5}"), ("\u{ad27}",
        "\u{ad27}", "\u{1100}\u{116b}\u{11b6}", "\u{ad27}", "\u{1100}\u{116b}\u{11b6}"),
        ("\u{ad28}", "\u{ad28}", "\u{1100}\u{116b}\u{11b7}", "\u{ad28}",
        "\u{1100}\u{116b}\u{11b7}"), ("\u{ad29}", "\u{ad29}", "\u{1100}\u{116b}\u{11b8}",
        "\u{ad29}", "\u{1100}\u{116b}\u{11b8}"), ("\u{ad2a}", "\u{ad2a}",
        "\u{1100}\u{116b}\u{11b9}", "\u{ad2a}", "\u{1100}\u{116b}\u{11b9}"), ("\u{ad2b}",
        "\u{ad2b}", "\u{1100}\u{116b}\u{11ba}", "\u{ad2b}", "\u{1100}\u{116b}\u{11ba}"),
        ("\u{ad2c}", "\u{ad2c}", "\u{1100}\u{116b}\u{11bb}", "\u{ad2c}",
        "\u{1100}\u{116b}\u{11bb}"), ("\u{ad2d}", "\u{ad2d}", "\u{1100}\u{116b}\u{11bc}",
        "\u{ad2d}", "\u{1100}\u{116b}\u{11bc}"), ("\u{ad2e}", "\u{ad2e}",
        "\u{1100}\u{116b}\u{11bd}", "\u{ad2e}", "\u{1100}\u{116b}\u{11bd}"), ("\u{ad2f}",
        "\u{ad2f}", "\u{1100}\u{116b}\u{11be}", "\u{ad2f}", "\u{1100}\u{116b}\u{11be}"),
        ("\u{ad30}", "\u{ad30}", "\u{1100}\u{116b}\u{11bf}", "\u{ad30}",
        "\u{1100}\u{116b}\u{11bf}"), ("\u{ad31}", "\u{ad31}", "\u{1100}\u{116b}\u{11c0}",
        "\u{ad31}", "\u{1100}\u{116b}\u{11c0}"), ("\u{ad32}", "\u{ad32}",
        "\u{1100}\u{116b}\u{11c1}", "\u{ad32}", "\u{1100}\u{116b}\u{11c1}"), ("\u{ad33}",
        "\u{ad33}", "\u{1100}\u{116b}\u{11c2}", "\u{ad33}", "\u{1100}\u{116b}\u{11c2}"),
        ("\u{ad34}", "\u{ad34}", "\u{1100}\u{116c}", "\u{ad34}", "\u{1100}\u{116c}"), ("\u{ad35}",
        "\u{ad35}", "\u{1100}\u{116c}\u{11a8}", "\u{ad35}", "\u{1100}\u{116c}\u{11a8}"),
        ("\u{ad36}", "\u{ad36}", "\u{1100}\u{116c}\u{11a9}", "\u{ad36}",
        "\u{1100}\u{116c}\u{11a9}"), ("\u{ad37}", "\u{ad37}", "\u{1100}\u{116c}\u{11aa}",
        "\u{ad37}", "\u{1100}\u{116c}\u{11aa}"), ("\u{ad38}", "\u{ad38}",
        "\u{1100}\u{116c}\u{11ab}", "\u{ad38}", "\u{1100}\u{116c}\u{11ab}"), ("\u{ad39}",
        "\u{ad39}", "\u{1100}\u{116c}\u{11ac}", "\u{ad39}", "\u{1100}\u{116c}\u{11ac}"),
        ("\u{ad3a}", "\u{ad3a}", "\u{1100}\u{116c}\u{11ad}", "\u{ad3a}",
        "\u{1100}\u{116c}\u{11ad}"), ("\u{ad3b}", "\u{ad3b}", "\u{1100}\u{116c}\u{11ae}",
        "\u{ad3b}", "\u{1100}\u{116c}\u{11ae}"), ("\u{ad3c}", "\u{ad3c}",
        "\u{1100}\u{116c}\u{11af}", "\u{ad3c}", "\u{1100}\u{116c}\u{11af}"), ("\u{ad3d}",
        "\u{ad3d}", "\u{1100}\u{116c}\u{11b0}", "\u{ad3d}", "\u{1100}\u{116c}\u{11b0}"),
        ("\u{ad3e}", "\u{ad3e}", "\u{1100}\u{116c}\u{11b1}", "\u{ad3e}",
        "\u{1100}\u{116c}\u{11b1}"), ("\u{ad3f}", "\u{ad3f}", "\u{1100}\u{116c}\u{11b2}",
        "\u{ad3f}", "\u{1100}\u{116c}\u{11b2}"), ("\u{ad40}", "\u{ad40}",
        "\u{1100}\u{116c}\u{11b3}", "\u{ad40}", "\u{1100}\u{116c}\u{11b3}"), ("\u{ad41}",
        "\u{ad41}", "\u{1100}\u{116c}\u{11b4}", "\u{ad41}", "\u{1100}\u{116c}\u{11b4}"),
        ("\u{ad42}", "\u{ad42}", "\u{1100}\u{116c}\u{11b5}", "\u{ad42}",
        "\u{1100}\u{116c}\u{11b5}"), ("\u{ad43}", "\u{ad43}", "\u{1100}\u{116c}\u{11b6}",
        "\u{ad43}", "\u{1100}\u{116c}\u{11b6}"), ("\u{ad44}", "\u{ad44}",
        "\u{1100}\u{116c}\u{11b7}", "\u{ad44}", "\u{1100}\u{116c}\u{11b7}"), ("\u{ad45}",
        "\u{ad45}", "\u{1100}\u{116c}\u{11b8}", "\u{ad45}", "\u{1100}\u{116c}\u{11b8}"),
        ("\u{ad46}", "\u{ad46}", "\u{1100}\u{116c}\u{11b9}", "\u{ad46}",
        "\u{1100}\u{116c}\u{11b9}"), ("\u{ad47}", "\u{ad47}", "\u{1100}\u{116c}\u{11ba}",
        "\u{ad47}", "\u{1100}\u{116c}\u{11ba}"), ("\u{ad48}", "\u{ad48}",
        "\u{1100}\u{116c}\u{11bb}", "\u{ad48}", "\u{1100}\u{116c}\u{11bb}"), ("\u{ad49}",
        "\u{ad49}", "\u{1100}\u{116c}\u{11bc}", "\u{ad49}", "\u{1100}\u{116c}\u{11bc}"),
        ("\u{ad4a}", "\u{ad4a}", "\u{1100}\u{116c}\u{11bd}", "\u{ad4a}",
        "\u{1100}\u{116c}\u{11bd}"), ("\u{ad4b}", "\u{ad4b}", "\u{1100}\u{116c}\u{11be}",
        "\u{ad4b}", "\u{1100}\u{116c}\u{11be}"), ("\u{ad4c}", "\u{ad4c}",
        "\u{1100}\u{116c}\u{11bf}", "\u{ad4c}", "\u{1100}\u{116c}\u{11bf}"), ("\u{ad4d}",
        "\u{ad4d}", "\u{1100}\u{116c}\u{11c0}", "\u{ad4d}", "\u{1100}\u{116c}\u{11c0}"),
        ("\u{ad4e}", "\u{ad4e}", "\u{1100}\u{116c}\u{11c1}", "\u{ad4e}",
        "\u{1100}\u{116c}\u{11c1}"), ("\u{ad4f}", "\u{ad4f}", "\u{1100}\u{116c}\u{11c2}",
        "\u{ad4f}", "\u{1100}\u{116c}\u{11c2}"), ("\u{ad50}", "\u{ad50}", "\u{1100}\u{116d}",
        "\u{ad50}", "\u{1100}\u{116d}"), ("\u{ad51}", "\u{ad51}", "\u{1100}\u{116d}\u{11a8}",
        "\u{ad51}", "\u{1100}\u{116d}\u{11a8}"), ("\u{ad52}", "\u{ad52}",
        "\u{1100}\u{116d}\u{11a9}", "\u{ad52}", "\u{1100}\u{116d}\u{11a9}"), ("\u{ad53}",
        "\u{ad53}", "\u{1100}\u{116d}\u{11aa}", "\u{ad53}", "\u{1100}\u{116d}\u{11aa}"),
        ("\u{ad54}", "\u{ad54}", "\u{1100}\u{116d}\u{11ab}", "\u{ad54}",
        "\u{1100}\u{116d}\u{11ab}"), ("\u{ad55}", "\u{ad55}", "\u{1100}\u{116d}\u{11ac}",
        "\u{ad55}", "\u{1100}\u{116d}\u{11ac}"), ("\u{ad56}", "\u{ad56}",
        "\u{1100}\u{116d}\u{11ad}", "\u{ad56}", "\u{1100}\u{116d}\u{11ad}"), ("\u{ad57}",
        "\u{ad57}", "\u{1100}\u{116d}\u{11ae}", "\u{ad57}", "\u{1100}\u{116d}\u{11ae}"),
        ("\u{ad58}", "\u{ad58}", "\u{1100}\u{116d}\u{11af}", "\u{ad58}",
        "\u{1100}\u{116d}\u{11af}"), ("\u{ad59}", "\u{ad59}", "\u{1100}\u{116d}\u{11b0}",
        "\u{ad59}", "\u{1100}\u{116d}\u{11b0}"), ("\u{ad5a}", "\u{ad5a}",
        "\u{1100}\u{116d}\u{11b1}", "\u{ad5a}", "\u{1100}\u{116d}\u{11b1}"), ("\u{ad5b}",
        "\u{ad5b}", "\u{1100}\u{116d}\u{11b2}", "\u{ad5b}", "\u{1100}\u{116d}\u{11b2}"),
        ("\u{ad5c}", "\u{ad5c}", "\u{1100}\u{116d}\u{11b3}", "\u{ad5c}",
        "\u{1100}\u{116d}\u{11b3}"), ("\u{ad5d}", "\u{ad5d}", "\u{1100}\u{116d}\u{11b4}",
        "\u{ad5d}", "\u{1100}\u{116d}\u{11b4}"), ("\u{ad5e}", "\u{ad5e}",
        "\u{1100}\u{116d}\u{11b5}", "\u{ad5e}", "\u{1100}\u{116d}\u{11b5}"), ("\u{ad5f}",
        "\u{ad5f}", "\u{1100}\u{116d}\u{11b6}", "\u{ad5f}", "\u{1100}\u{116d}\u{11b6}"),
        ("\u{ad60}", "\u{ad60}", "\u{1100}\u{116d}\u{11b7}", "\u{ad60}",
        "\u{1100}\u{116d}\u{11b7}"), ("\u{ad61}", "\u{ad61}", "\u{1100}\u{116d}\u{11b8}",
        "\u{ad61}", "\u{1100}\u{116d}\u{11b8}"), ("\u{ad62}", "\u{ad62}",
        "\u{1100}\u{116d}\u{11b9}", "\u{ad62}", "\u{1100}\u{116d}\u{11b9}"), ("\u{ad63}",
        "\u{ad63}", "\u{1100}\u{116d}\u{11ba}", "\u{ad63}", "\u{1100}\u{116d}\u{11ba}"),
        ("\u{ad64}", "\u{ad64}", "\u{1100}\u{116d}\u{11bb}", "\u{ad64}",
        "\u{1100}\u{116d}\u{11bb}"), ("\u{ad65}", "\u{ad65}", "\u{1100}\u{116d}\u{11bc}",
        "\u{ad65}", "\u{1100}\u{116d}\u{11bc}"), ("\u{ad66}", "\u{ad66}",
        "\u{1100}\u{116d}\u{11bd}", "\u{ad66}", "\u{1100}\u{116d}\u{11bd}"), ("\u{ad67}",
        "\u{ad67}", "\u{1100}\u{116d}\u{11be}", "\u{ad67}", "\u{1100}\u{116d}\u{11be}"),
        ("\u{ad68}", "\u{ad68}", "\u{1100}\u{116d}\u{11bf}", "\u{ad68}",
        "\u{1100}\u{116d}\u{11bf}"), ("\u{ad69}", "\u{ad69}", "\u{1100}\u{116d}\u{11c0}",
        "\u{ad69}", "\u{1100}\u{116d}\u{11c0}"), ("\u{ad6a}", "\u{ad6a}",
        "\u{1100}\u{116d}\u{11c1}", "\u{ad6a}", "\u{1100}\u{116d}\u{11c1}"), ("\u{ad6b}",
        "\u{ad6b}", "\u{1100}\u{116d}\u{11c2}", "\u{ad6b}", "\u{1100}\u{116d}\u{11c2}"),
        ("\u{ad6c}", "\u{ad6c}", "\u{1100}\u{116e}", "\u{ad6c}", "\u{1100}\u{116e}"), ("\u{ad6d}",
        "\u{ad6d}", "\u{1100}\u{116e}\u{11a8}", "\u{ad6d}", "\u{1100}\u{116e}\u{11a8}"),
        ("\u{ad6e}", "\u{ad6e}", "\u{1100}\u{116e}\u{11a9}", "\u{ad6e}",
        "\u{1100}\u{116e}\u{11a9}"), ("\u{ad6f}", "\u{ad6f}", "\u{1100}\u{116e}\u{11aa}",
        "\u{ad6f}", "\u{1100}\u{116e}\u{11aa}"), ("\u{ad70}", "\u{ad70}",
        "\u{1100}\u{116e}\u{11ab}", "\u{ad70}", "\u{1100}\u{116e}\u{11ab}"), ("\u{ad71}",
        "\u{ad71}", "\u{1100}\u{116e}\u{11ac}", "\u{ad71}", "\u{1100}\u{116e}\u{11ac}"),
        ("\u{ad72}", "\u{ad72}", "\u{1100}\u{116e}\u{11ad}", "\u{ad72}",
        "\u{1100}\u{116e}\u{11ad}"), ("\u{ad73}", "\u{ad73}", "\u{1100}\u{116e}\u{11ae}",
        "\u{ad73}", "\u{1100}\u{116e}\u{11ae}"), ("\u{ad74}", "\u{ad74}",
        "\u{1100}\u{116e}\u{11af}", "\u{ad74}", "\u{1100}\u{116e}\u{11af}"), ("\u{ad75}",
        "\u{ad75}", "\u{1100}\u{116e}\u{11b0}", "\u{ad75}", "\u{1100}\u{116e}\u{11b0}"),
        ("\u{ad76}", "\u{ad76}", "\u{1100}\u{116e}\u{11b1}", "\u{ad76}",
        "\u{1100}\u{116e}\u{11b1}"), ("\u{ad77}", "\u{ad77}", "\u{1100}\u{116e}\u{11b2}",
        "\u{ad77}", "\u{1100}\u{116e}\u{11b2}"), ("\u{ad78}", "\u{ad78}",
        "\u{1100}\u{116e}\u{11b3}", "\u{ad78}", "\u{1100}\u{116e}\u{11b3}"), ("\u{ad79}",
        "\u{ad79}", "\u{1100}\u{116e}\u{11b4}", "\u{ad79}", "\u{1100}\u{116e}\u{11b4}"),
        ("\u{ad7a}", "\u{ad7a}", "\u{1100}\u{116e}\u{11b5}", "\u{ad7a}",
        "\u{1100}\u{116e}\u{11b5}"), ("\u{ad7b}", "\u{ad7b}", "\u{1100}\u{116e}\u{11b6}",
        "\u{ad7b}", "\u{1100}\u{116e}\u{11b6}"), ("\u{ad7c}", "\u{ad7c}",
        "\u{1100}\u{116e}\u{11b7}", "\u{ad7c}", "\u{1100}\u{116e}\u{11b7}"), ("\u{ad7d}",
        "\u{ad7d}", "\u{1100}\u{116e}\u{11b8}", "\u{ad7d}", "\u{1100}\u{116e}\u{11b8}"),
        ("\u{ad7e}", "\u{ad7e}", "\u{1100}\u{116e}\u{11b9}", "\u{ad7e}",
        "\u{1100}\u{116e}\u{11b9}"), ("\u{ad7f}", "\u{ad7f}", "\u{1100}\u{116e}\u{11ba}",
        "\u{ad7f}", "\u{1100}\u{116e}\u{11ba}"), ("\u{ad80}", "\u{ad80}",
        "\u{1100}\u{116e}\u{11bb}", "\u{ad80}", "\u{1100}\u{116e}\u{11bb}"), ("\u{ad81}",
        "\u{ad81}", "\u{1100}\u{116e}\u{11bc}", "\u{ad81}", "\u{1100}\u{116e}\u{11bc}"),
        ("\u{ad82}", "\u{ad82}", "\u{1100}\u{116e}\u{11bd}", "\u{ad82}",
        "\u{1100}\u{116e}\u{11bd}"), ("\u{ad83}", "\u{ad83}", "\u{1100}\u{116e}\u{11be}",
        "\u{ad83}", "\u{1100}\u{116e}\u{11be}"), ("\u{ad84}", "\u{ad84}",
        "\u{1100}\u{116e}\u{11bf}", "\u{ad84}", "\u{1100}\u{116e}\u{11bf}"), ("\u{ad85}",
        "\u{ad85}", "\u{1100}\u{116e}\u{11c0}", "\u{ad85}", "\u{1100}\u{116e}\u{11c0}"),
        ("\u{ad86}", "\u{ad86}", "\u{1100}\u{116e}\u{11c1}", "\u{ad86}",
        "\u{1100}\u{116e}\u{11c1}"), ("\u{ad87}", "\u{ad87}", "\u{1100}\u{116e}\u{11c2}",
        "\u{ad87}", "\u{1100}\u{116e}\u{11c2}"), ("\u{ad88}", "\u{ad88}", "\u{1100}\u{116f}",
        "\u{ad88}", "\u{1100}\u{116f}"), ("\u{ad89}", "\u{ad89}", "\u{1100}\u{116f}\u{11a8}",
        "\u{ad89}", "\u{1100}\u{116f}\u{11a8}"), ("\u{ad8a}", "\u{ad8a}",
        "\u{1100}\u{116f}\u{11a9}", "\u{ad8a}", "\u{1100}\u{116f}\u{11a9}"), ("\u{ad8b}",
        "\u{ad8b}", "\u{1100}\u{116f}\u{11aa}", "\u{ad8b}", "\u{1100}\u{116f}\u{11aa}"),
        ("\u{ad8c}", "\u{ad8c}", "\u{1100}\u{116f}\u{11ab}", "\u{ad8c}",
        "\u{1100}\u{116f}\u{11ab}"), ("\u{ad8d}", "\u{ad8d}", "\u{1100}\u{116f}\u{11ac}",
        "\u{ad8d}", "\u{1100}\u{116f}\u{11ac}"), ("\u{ad8e}", "\u{ad8e}",
        "\u{1100}\u{116f}\u{11ad}", "\u{ad8e}", "\u{1100}\u{116f}\u{11ad}"), ("\u{ad8f}",
        "\u{ad8f}", "\u{1100}\u{116f}\u{11ae}", "\u{ad8f}", "\u{1100}\u{116f}\u{11ae}"),
        ("\u{ad90}", "\u{ad90}", "\u{1100}\u{116f}\u{11af}", "\u{ad90}",
        "\u{1100}\u{116f}\u{11af}"), ("\u{ad91}", "\u{ad91}", "\u{1100}\u{116f}\u{11b0}",
        "\u{ad91}", "\u{1100}\u{116f}\u{11b0}"), ("\u{ad92}", "\u{ad92}",
        "\u{1100}\u{116f}\u{11b1}", "\u{ad92}", "\u{1100}\u{116f}\u{11b1}"), ("\u{ad93}",
        "\u{ad93}", "\u{1100}\u{116f}\u{11b2}", "\u{ad93}", "\u{1100}\u{116f}\u{11b2}"),
        ("\u{ad94}", "\u{ad94}", "\u{1100}\u{116f}\u{11b3}", "\u{ad94}",
        "\u{1100}\u{116f}\u{11b3}"), ("\u{ad95}", "\u{ad95}", "\u{1100}\u{116f}\u{11b4}",
        "\u{ad95}", "\u{1100}\u{116f}\u{11b4}"), ("\u{ad96}", "\u{ad96}",
        "\u{1100}\u{116f}\u{11b5}", "\u{ad96}", "\u{1100}\u{116f}\u{11b5}"), ("\u{ad97}",
        "\u{ad97}", "\u{1100}\u{116f}\u{11b6}", "\u{ad97}", "\u{1100}\u{116f}\u{11b6}"),
        ("\u{ad98}", "\u{ad98}", "\u{1100}\u{116f}\u{11b7}", "\u{ad98}",
        "\u{1100}\u{116f}\u{11b7}"), ("\u{ad99}", "\u{ad99}", "\u{1100}\u{116f}\u{11b8}",
        "\u{ad99}", "\u{1100}\u{116f}\u{11b8}"), ("\u{ad9a}", "\u{ad9a}",
        "\u{1100}\u{116f}\u{11b9}", "\u{ad9a}", "\u{1100}\u{116f}\u{11b9}"), ("\u{ad9b}",
        "\u{ad9b}", "\u{1100}\u{116f}\u{11ba}", "\u{ad9b}", "\u{1100}\u{116f}\u{11ba}"),
        ("\u{ad9c}", "\u{ad9c}", "\u{1100}\u{116f}\u{11bb}", "\u{ad9c}",
        "\u{1100}\u{116f}\u{11bb}"), ("\u{ad9d}", "\u{ad9d}", "\u{1100}\u{116f}\u{11bc}",
        "\u{ad9d}", "\u{1100}\u{116f}\u{11bc}"), ("\u{ad9e}", "\u{ad9e}",
        "\u{1100}\u{116f}\u{11bd}", "\u{ad9e}", "\u{1100}\u{116f}\u{11bd}"), ("\u{ad9f}",
        "\u{ad9f}", "\u{1100}\u{116f}\u{11be}", "\u{ad9f}", "\u{1100}\u{116f}\u{11be}"),
        ("\u{ada0}", "\u{ada0}", "\u{1100}\u{116f}\u{11bf}", "\u{ada0}",
        "\u{1100}\u{116f}\u{11bf}"), ("\u{ada1}", "\u{ada1}", "\u{1100}\u{116f}\u{11c0}",
        "\u{ada1}", "\u{1100}\u{116f}\u{11c0}"), ("\u{ada2}", "\u{ada2}",
        "\u{1100}\u{116f}\u{11c1}", "\u{ada2}", "\u{1100}\u{116f}\u{11c1}"), ("\u{ada3}",
        "\u{ada3}", "\u{1100}\u{116f}\u{11c2}", "\u{ada3}", "\u{1100}\u{116f}\u{11c2}"),
        ("\u{ada4}", "\u{ada4}", "\u{1100}\u{1170}", "\u{ada4}", "\u{1100}\u{1170}"), ("\u{ada5}",
        "\u{ada5}", "\u{1100}\u{1170}\u{11a8}", "\u{ada5}", "\u{1100}\u{1170}\u{11a8}"),
        ("\u{ada6}", "\u{ada6}", "\u{1100}\u{1170}\u{11a9}", "\u{ada6}",
        "\u{1100}\u{1170}\u{11a9}"), ("\u{ada7}", "\u{ada7}", "\u{1100}\u{1170}\u{11aa}",
        "\u{ada7}", "\u{1100}\u{1170}\u{11aa}"), ("\u{ada8}", "\u{ada8}",
        "\u{1100}\u{1170}\u{11ab}", "\u{ada8}", "\u{1100}\u{1170}\u{11ab}"), ("\u{ada9}",
        "\u{ada9}", "\u{1100}\u{1170}\u{11ac}", "\u{ada9}", "\u{1100}\u{1170}\u{11ac}"),
        ("\u{adaa}", "\u{adaa}", "\u{1100}\u{1170}\u{11ad}", "\u{adaa}",
        "\u{1100}\u{1170}\u{11ad}"), ("\u{adab}", "\u{adab}", "\u{1100}\u{1170}\u{11ae}",
        "\u{adab}", "\u{1100}\u{1170}\u{11ae}"), ("\u{adac}", "\u{adac}",
        "\u{1100}\u{1170}\u{11af}", "\u{adac}", "\u{1100}\u{1170}\u{11af}"), ("\u{adad}",
        "\u{adad}", "\u{1100}\u{1170}\u{11b0}", "\u{adad}", "\u{1100}\u{1170}\u{11b0}"),
        ("\u{adae}", "\u{adae}", "\u{1100}\u{1170}\u{11b1}", "\u{adae}",
        "\u{1100}\u{1170}\u{11b1}"), ("\u{adaf}", "\u{adaf}", "\u{1100}\u{1170}\u{11b2}",
        "\u{adaf}", "\u{1100}\u{1170}\u{11b2}"), ("\u{adb0}", "\u{adb0}",
        "\u{1100}\u{1170}\u{11b3}", "\u{adb0}", "\u{1100}\u{1170}\u{11b3}"), ("\u{adb1}",
        "\u{adb1}", "\u{1100}\u{1170}\u{11b4}", "\u{adb1}", "\u{1100}\u{1170}\u{11b4}"),
        ("\u{adb2}", "\u{adb2}", "\u{1100}\u{1170}\u{11b5}", "\u{adb2}",
        "\u{1100}\u{1170}\u{11b5}"), ("\u{adb3}", "\u{adb3}", "\u{1100}\u{1170}\u{11b6}",
        "\u{adb3}", "\u{1100}\u{1170}\u{11b6}"), ("\u{adb4}", "\u{adb4}",
        "\u{1100}\u{1170}\u{11b7}", "\u{adb4}", "\u{1100}\u{1170}\u{11b7}"), ("\u{adb5}",
        "\u{adb5}", "\u{1100}\u{1170}\u{11b8}", "\u{adb5}", "\u{1100}\u{1170}\u{11b8}"),
        ("\u{adb6}", "\u{adb6}", "\u{1100}\u{1170}\u{11b9}", "\u{adb6}",
        "\u{1100}\u{1170}\u{11b9}"), ("\u{adb7}", "\u{adb7}", "\u{1100}\u{1170}\u{11ba}",
        "\u{adb7}", "\u{1100}\u{1170}\u{11ba}"), ("\u{adb8}", "\u{adb8}",
        "\u{1100}\u{1170}\u{11bb}", "\u{adb8}", "\u{1100}\u{1170}\u{11bb}"), ("\u{adb9}",
        "\u{adb9}", "\u{1100}\u{1170}\u{11bc}", "\u{adb9}", "\u{1100}\u{1170}\u{11bc}"),
        ("\u{adba}", "\u{adba}", "\u{1100}\u{1170}\u{11bd}", "\u{adba}",
        "\u{1100}\u{1170}\u{11bd}"), ("\u{adbb}", "\u{adbb}", "\u{1100}\u{1170}\u{11be}",
        "\u{adbb}", "\u{1100}\u{1170}\u{11be}"), ("\u{adbc}", "\u{adbc}",
        "\u{1100}\u{1170}\u{11bf}", "\u{adbc}", "\u{1100}\u{1170}\u{11bf}"), ("\u{adbd}",
        "\u{adbd}", "\u{1100}\u{1170}\u{11c0}", "\u{adbd}", "\u{1100}\u{1170}\u{11c0}"),
        ("\u{adbe}", "\u{adbe}", "\u{1100}\u{1170}\u{11c1}", "\u{adbe}",
        "\u{1100}\u{1170}\u{11c1}"), ("\u{adbf}", "\u{adbf}", "\u{1100}\u{1170}\u{11c2}",
        "\u{adbf}", "\u{1100}\u{1170}\u{11c2}"), ("\u{adc0}", "\u{adc0}", "\u{1100}\u{1171}",
        "\u{adc0}", "\u{1100}\u{1171}"), ("\u{adc1}", "\u{adc1}", "\u{1100}\u{1171}\u{11a8}",
        "\u{adc1}", "\u{1100}\u{1171}\u{11a8}"), ("\u{adc2}", "\u{adc2}",
        "\u{1100}\u{1171}\u{11a9}", "\u{adc2}", "\u{1100}\u{1171}\u{11a9}"), ("\u{adc3}",
        "\u{adc3}", "\u{1100}\u{1171}\u{11aa}", "\u{adc3}", "\u{1100}\u{1171}\u{11aa}"),
        ("\u{adc4}", "\u{adc4}", "\u{1100}\u{1171}\u{11ab}", "\u{adc4}",
        "\u{1100}\u{1171}\u{11ab}"), ("\u{adc5}", "\u{adc5}", "\u{1100}\u{1171}\u{11ac}",
        "\u{adc5}", "\u{1100}\u{1171}\u{11ac}"), ("\u{adc6}", "\u{adc6}",
        "\u{1100}\u{1171}\u{11ad}", "\u{adc6}", "\u{1100}\u{1171}\u{11ad}"), ("\u{adc7}",
        "\u{adc7}", "\u{1100}\u{1171}\u{11ae}", "\u{adc7}", "\u{1100}\u{1171}\u{11ae}"),
        ("\u{adc8}", "\u{adc8}", "\u{1100}\u{1171}\u{11af}", "\u{adc8}",
        "\u{1100}\u{1171}\u{11af}"), ("\u{adc9}", "\u{adc9}", "\u{1100}\u{1171}\u{11b0}",
        "\u{adc9}", "\u{1100}\u{1171}\u{11b0}"), ("\u{adca}", "\u{adca}",
        "\u{1100}\u{1171}\u{11b1}", "\u{adca}", "\u{1100}\u{1171}\u{11b1}"), ("\u{adcb}",
        "\u{adcb}", "\u{1100}\u{1171}\u{11b2}", "\u{adcb}", "\u{1100}\u{1171}\u{11b2}"),
        ("\u{adcc}", "\u{adcc}", "\u{1100}\u{1171}\u{11b3}", "\u{adcc}",
        "\u{1100}\u{1171}\u{11b3}"), ("\u{adcd}", "\u{adcd}", "\u{1100}\u{1171}\u{11b4}",
        "\u{adcd}", "\u{1100}\u{1171}\u{11b4}"), ("\u{adce}", "\u{adce}",
        "\u{1100}\u{1171}\u{11b5}", "\u{adce}", "\u{1100}\u{1171}\u{11b5}"), ("\u{adcf}",
        "\u{adcf}", "\u{1100}\u{1171}\u{11b6}", "\u{adcf}", "\u{1100}\u{1171}\u{11b6}"),
        ("\u{add0}", "\u{add0}", "\u{1100}\u{1171}\u{11b7}", "\u{add0}",
        "\u{1100}\u{1171}\u{11b7}"), ("\u{add1}", "\u{add1}", "\u{1100}\u{1171}\u{11b8}",
        "\u{add1}", "\u{1100}\u{1171}\u{11b8}"), ("\u{add2}", "\u{add2}",
        "\u{1100}\u{1171}\u{11b9}", "\u{add2}", "\u{1100}\u{1171}\u{11b9}"), ("\u{add3}",
        "\u{add3}", "\u{1100}\u{1171}\u{11ba}", "\u{add3}", "\u{1100}\u{1171}\u{11ba}"),
        ("\u{add4}", "\u{add4}", "\u{1100}\u{1171}\u{11bb}", "\u{add4}",
        "\u{1100}\u{1171}\u{11bb}"), ("\u{add5}", "\u{add5}", "\u{1100}\u{1171}\u{11bc}",
        "\u{add5}", "\u{1100}\u{1171}\u{11bc}"), ("\u{add6}", "\u{add6}",
        "\u{1100}\u{1171}\u{11bd}", "\u{add6}", "\u{1100}\u{1171}\u{11bd}"), ("\u{add7}",
        "\u{add7}", "\u{1100}\u{1171}\u{11be}", "\u{add7}", "\u{1100}\u{1171}\u{11be}"),
        ("\u{add8}", "\u{add8}", "\u{1100}\u{1171}\u{11bf}", "\u{add8}",
        "\u{1100}\u{1171}\u{11bf}"), ("\u{add9}", "\u{add9}", "\u{1100}\u{1171}\u{11c0}",
        "\u{add9}", "\u{1100}\u{1171}\u{11c0}"), ("\u{adda}", "\u{adda}",
        "\u{1100}\u{1171}\u{11c1}", "\u{adda}", "\u{1100}\u{1171}\u{11c1}"), ("\u{addb}",
        "\u{addb}", "\u{1100}\u{1171}\u{11c2}", "\u{addb}", "\u{1100}\u{1171}\u{11c2}"),
        ("\u{addc}", "\u{addc}", "\u{1100}\u{1172}", "\u{addc}", "\u{1100}\u{1172}"), ("\u{addd}",
        "\u{addd}", "\u{1100}\u{1172}\u{11a8}", "\u{addd}", "\u{1100}\u{1172}\u{11a8}"),
        ("\u{adde}", "\u{adde}", "\u{1100}\u{1172}\u{11a9}", "\u{adde}",
        "\u{1100}\u{1172}\u{11a9}"), ("\u{addf}", "\u{addf}", "\u{1100}\u{1172}\u{11aa}",
        "\u{addf}", "\u{1100}\u{1172}\u{11aa}"), ("\u{ade0}", "\u{ade0}",
        "\u{1100}\u{1172}\u{11ab}", "\u{ade0}", "\u{1100}\u{1172}\u{11ab}"), ("\u{ade1}",
        "\u{ade1}", "\u{1100}\u{1172}\u{11ac}", "\u{ade1}", "\u{1100}\u{1172}\u{11ac}"),
        ("\u{ade2}", "\u{ade2}", "\u{1100}\u{1172}\u{11ad}", "\u{ade2}",
        "\u{1100}\u{1172}\u{11ad}"), ("\u{ade3}", "\u{ade3}", "\u{1100}\u{1172}\u{11ae}",
        "\u{ade3}", "\u{1100}\u{1172}\u{11ae}"), ("\u{ade4}", "\u{ade4}",
        "\u{1100}\u{1172}\u{11af}", "\u{ade4}", "\u{1100}\u{1172}\u{11af}"), ("\u{ade5}",
        "\u{ade5}", "\u{1100}\u{1172}\u{11b0}", "\u{ade5}", "\u{1100}\u{1172}\u{11b0}"),
        ("\u{ade6}", "\u{ade6}", "\u{1100}\u{1172}\u{11b1}", "\u{ade6}",
        "\u{1100}\u{1172}\u{11b1}"), ("\u{ade7}", "\u{ade7}", "\u{1100}\u{1172}\u{11b2}",
        "\u{ade7}", "\u{1100}\u{1172}\u{11b2}"), ("\u{ade8}", "\u{ade8}",
        "\u{1100}\u{1172}\u{11b3}", "\u{ade8}", "\u{1100}\u{1172}\u{11b3}"), ("\u{ade9}",
        "\u{ade9}", "\u{1100}\u{1172}\u{11b4}", "\u{ade9}", "\u{1100}\u{1172}\u{11b4}"),
        ("\u{adea}", "\u{adea}", "\u{1100}\u{1172}\u{11b5}", "\u{adea}",
        "\u{1100}\u{1172}\u{11b5}"), ("\u{adeb}", "\u{adeb}", "\u{1100}\u{1172}\u{11b6}",
        "\u{adeb}", "\u{1100}\u{1172}\u{11b6}"), ("\u{adec}", "\u{adec}",
        "\u{1100}\u{1172}\u{11b7}", "\u{adec}", "\u{1100}\u{1172}\u{11b7}"), ("\u{aded}",
        "\u{aded}", "\u{1100}\u{1172}\u{11b8}", "\u{aded}", "\u{1100}\u{1172}\u{11b8}"),
        ("\u{adee}", "\u{adee}", "\u{1100}\u{1172}\u{11b9}", "\u{adee}",
        "\u{1100}\u{1172}\u{11b9}"), ("\u{adef}", "\u{adef}", "\u{1100}\u{1172}\u{11ba}",
        "\u{adef}", "\u{1100}\u{1172}\u{11ba}"), ("\u{adf0}", "\u{adf0}",
        "\u{1100}\u{1172}\u{11bb}", "\u{adf0}", "\u{1100}\u{1172}\u{11bb}"), ("\u{adf1}",
        "\u{adf1}", "\u{1100}\u{1172}\u{11bc}", "\u{adf1}", "\u{1100}\u{1172}\u{11bc}"),
        ("\u{adf2}", "\u{adf2}", "\u{1100}\u{1172}\u{11bd}", "\u{adf2}",
        "\u{1100}\u{1172}\u{11bd}"), ("\u{adf3}", "\u{adf3}", "\u{1100}\u{1172}\u{11be}",
        "\u{adf3}", "\u{1100}\u{1172}\u{11be}"), ("\u{adf4}", "\u{adf4}",
        "\u{1100}\u{1172}\u{11bf}", "\u{adf4}", "\u{1100}\u{1172}\u{11bf}"), ("\u{adf5}",
        "\u{adf5}", "\u{1100}\u{1172}\u{11c0}", "\u{adf5}", "\u{1100}\u{1172}\u{11c0}"),
        ("\u{adf6}", "\u{adf6}", "\u{1100}\u{1172}\u{11c1}", "\u{adf6}",
        "\u{1100}\u{1172}\u{11c1}"), ("\u{adf7}", "\u{adf7}", "\u{1100}\u{1172}\u{11c2}",
        "\u{adf7}", "\u{1100}\u{1172}\u{11c2}"), ("\u{adf8}", "\u{adf8}", "\u{1100}\u{1173}",
        "\u{adf8}", "\u{1100}\u{1173}"), ("\u{adf9}", "\u{adf9}", "\u{1100}\u{1173}\u{11a8}",
        "\u{adf9}", "\u{1100}\u{1173}\u{11a8}"), ("\u{adfa}", "\u{adfa}",
        "\u{1100}\u{1173}\u{11a9}", "\u{adfa}", "\u{1100}\u{1173}\u{11a9}"), ("\u{adfb}",
        "\u{adfb}", "\u{1100}\u{1173}\u{11aa}", "\u{adfb}", "\u{1100}\u{1173}\u{11aa}"),
        ("\u{adfc}", "\u{adfc}", "\u{1100}\u{1173}\u{11ab}", "\u{adfc}",
        "\u{1100}\u{1173}\u{11ab}"), ("\u{adfd}", "\u{adfd}", "\u{1100}\u{1173}\u{11ac}",
        "\u{adfd}", "\u{1100}\u{1173}\u{11ac}"), ("\u{adfe}", "\u{adfe}",
        "\u{1100}\u{1173}\u{11ad}", "\u{adfe}", "\u{1100}\u{1173}\u{11ad}"), ("\u{adff}",
        "\u{adff}", "\u{1100}\u{1173}\u{11ae}", "\u{adff}", "\u{1100}\u{1173}\u{11ae}"),
        ("\u{ae00}", "\u{ae00}", "\u{1100}\u{1173}\u{11af}", "\u{ae00}",
        "\u{1100}\u{1173}\u{11af}"), ("\u{ae01}", "\u{ae01}", "\u{1100}\u{1173}\u{11b0}",
        "\u{ae01}", "\u{1100}\u{1173}\u{11b0}"), ("\u{ae02}", "\u{ae02}",
        "\u{1100}\u{1173}\u{11b1}", "\u{ae02}", "\u{1100}\u{1173}\u{11b1}"), ("\u{ae03}",
        "\u{ae03}", "\u{1100}\u{1173}\u{11b2}", "\u{ae03}", "\u{1100}\u{1173}\u{11b2}"),
        ("\u{ae04}", "\u{ae04}", "\u{1100}\u{1173}\u{11b3}", "\u{ae04}",
        "\u{1100}\u{1173}\u{11b3}"), ("\u{ae05}", "\u{ae05}", "\u{1100}\u{1173}\u{11b4}",
        "\u{ae05}", "\u{1100}\u{1173}\u{11b4}"), ("\u{ae06}", "\u{ae06}",
        "\u{1100}\u{1173}\u{11b5}", "\u{ae06}", "\u{1100}\u{1173}\u{11b5}"), ("\u{ae07}",
        "\u{ae07}", "\u{1100}\u{1173}\u{11b6}", "\u{ae07}", "\u{1100}\u{1173}\u{11b6}"),
        ("\u{ae08}", "\u{ae08}", "\u{1100}\u{1173}\u{11b7}", "\u{ae08}",
        "\u{1100}\u{1173}\u{11b7}"), ("\u{ae09}", "\u{ae09}", "\u{1100}\u{1173}\u{11b8}",
        "\u{ae09}", "\u{1100}\u{1173}\u{11b8}"), ("\u{ae0a}", "\u{ae0a}",
        "\u{1100}\u{1173}\u{11b9}", "\u{ae0a}", "\u{1100}\u{1173}\u{11b9}"), ("\u{ae0b}",
        "\u{ae0b}", "\u{1100}\u{1173}\u{11ba}", "\u{ae0b}", "\u{1100}\u{1173}\u{11ba}"),
        ("\u{ae0c}", "\u{ae0c}", "\u{1100}\u{1173}\u{11bb}", "\u{ae0c}",
        "\u{1100}\u{1173}\u{11bb}"), ("\u{ae0d}", "\u{ae0d}", "\u{1100}\u{1173}\u{11bc}",
        "\u{ae0d}", "\u{1100}\u{1173}\u{11bc}"), ("\u{ae0e}", "\u{ae0e}",
        "\u{1100}\u{1173}\u{11bd}", "\u{ae0e}", "\u{1100}\u{1173}\u{11bd}"), ("\u{ae0f}",
        "\u{ae0f}", "\u{1100}\u{1173}\u{11be}", "\u{ae0f}", "\u{1100}\u{1173}\u{11be}"),
        ("\u{ae10}", "\u{ae10}", "\u{1100}\u{1173}\u{11bf}", "\u{ae10}",
        "\u{1100}\u{1173}\u{11bf}"), ("\u{ae11}", "\u{ae11}", "\u{1100}\u{1173}\u{11c0}",
        "\u{ae11}", "\u{1100}\u{1173}\u{11c0}"), ("\u{ae12}", "\u{ae12}",
        "\u{1100}\u{1173}\u{11c1}", "\u{ae12}", "\u{1100}\u{1173}\u{11c1}"), ("\u{ae13}",
        "\u{ae13}", "\u{1100}\u{1173}\u{11c2}", "\u{ae13}", "\u{1100}\u{1173}\u{11c2}"),
        ("\u{ae14}", "\u{ae14}", "\u{1100}\u{1174}", "\u{ae14}", "\u{1100}\u{1174}"), ("\u{ae15}",
        "\u{ae15}", "\u{1100}\u{1174}\u{11a8}", "\u{ae15}", "\u{1100}\u{1174}\u{11a8}"),
        ("\u{ae16}", "\u{ae16}", "\u{1100}\u{1174}\u{11a9}", "\u{ae16}",
        "\u{1100}\u{1174}\u{11a9}"), ("\u{ae17}", "\u{ae17}", "\u{1100}\u{1174}\u{11aa}",
        "\u{ae17}", "\u{1100}\u{1174}\u{11aa}"), ("\u{ae18}", "\u{ae18}",
        "\u{1100}\u{1174}\u{11ab}", "\u{ae18}", "\u{1100}\u{1174}\u{11ab}"), ("\u{ae19}",
        "\u{ae19}", "\u{1100}\u{1174}\u{11ac}", "\u{ae19}", "\u{1100}\u{1174}\u{11ac}"),
        ("\u{ae1a}", "\u{ae1a}", "\u{1100}\u{1174}\u{11ad}", "\u{ae1a}",
        "\u{1100}\u{1174}\u{11ad}"), ("\u{ae1b}", "\u{ae1b}", "\u{1100}\u{1174}\u{11ae}",
        "\u{ae1b}", "\u{1100}\u{1174}\u{11ae}"), ("\u{ae1c}", "\u{ae1c}",
        "\u{1100}\u{1174}\u{11af}", "\u{ae1c}", "\u{1100}\u{1174}\u{11af}"), ("\u{ae1d}",
        "\u{ae1d}", "\u{1100}\u{1174}\u{11b0}", "\u{ae1d}", "\u{1100}\u{1174}\u{11b0}"),
        ("\u{ae1e}", "\u{ae1e}", "\u{1100}\u{1174}\u{11b1}", "\u{ae1e}",
        "\u{1100}\u{1174}\u{11b1}"), ("\u{ae1f}", "\u{ae1f}", "\u{1100}\u{1174}\u{11b2}",
        "\u{ae1f}", "\u{1100}\u{1174}\u{11b2}"), ("\u{ae20}", "\u{ae20}",
        "\u{1100}\u{1174}\u{11b3}", "\u{ae20}", "\u{1100}\u{1174}\u{11b3}"), ("\u{ae21}",
        "\u{ae21}", "\u{1100}\u{1174}\u{11b4}", "\u{ae21}", "\u{1100}\u{1174}\u{11b4}"),
        ("\u{ae22}", "\u{ae22}", "\u{1100}\u{1174}\u{11b5}", "\u{ae22}",
        "\u{1100}\u{1174}\u{11b5}"), ("\u{ae23}", "\u{ae23}", "\u{1100}\u{1174}\u{11b6}",
        "\u{ae23}", "\u{1100}\u{1174}\u{11b6}"), ("\u{ae24}", "\u{ae24}",
        "\u{1100}\u{1174}\u{11b7}", "\u{ae24}", "\u{1100}\u{1174}\u{11b7}"), ("\u{ae25}",
        "\u{ae25}", "\u{1100}\u{1174}\u{11b8}", "\u{ae25}", "\u{1100}\u{1174}\u{11b8}"),
        ("\u{ae26}", "\u{ae26}", "\u{1100}\u{1174}\u{11b9}", "\u{ae26}",
        "\u{1100}\u{1174}\u{11b9}"), ("\u{ae27}", "\u{ae27}", "\u{1100}\u{1174}\u{11ba}",
        "\u{ae27}", "\u{1100}\u{1174}\u{11ba}"), ("\u{ae28}", "\u{ae28}",
        "\u{1100}\u{1174}\u{11bb}", "\u{ae28}", "\u{1100}\u{1174}\u{11bb}"), ("\u{ae29}",
        "\u{ae29}", "\u{1100}\u{1174}\u{11bc}", "\u{ae29}", "\u{1100}\u{1174}\u{11bc}"),
        ("\u{ae2a}", "\u{ae2a}", "\u{1100}\u{1174}\u{11bd}", "\u{ae2a}",
        "\u{1100}\u{1174}\u{11bd}"), ("\u{ae2b}", "\u{ae2b}", "\u{1100}\u{1174}\u{11be}",
        "\u{ae2b}", "\u{1100}\u{1174}\u{11be}"), ("\u{ae2c}", "\u{ae2c}",
        "\u{1100}\u{1174}\u{11bf}", "\u{ae2c}", "\u{1100}\u{1174}\u{11bf}"), ("\u{ae2d}",
        "\u{ae2d}", "\u{1100}\u{1174}\u{11c0}", "\u{ae2d}", "\u{1100}\u{1174}\u{11c0}"),
        ("\u{ae2e}", "\u{ae2e}", "\u{1100}\u{1174}\u{11c1}", "\u{ae2e}",
        "\u{1100}\u{1174}\u{11c1}"), ("\u{ae2f}", "\u{ae2f}", "\u{1100}\u{1174}\u{11c2}",
        "\u{ae2f}", "\u{1100}\u{1174}\u{11c2}"), ("\u{ae30}", "\u{ae30}", "\u{1100}\u{1175}",
        "\u{ae30}", "\u{1100}\u{1175}"), ("\u{ae31}", "\u{ae31}", "\u{1100}\u{1175}\u{11a8}",
        "\u{ae31}", "\u{1100}\u{1175}\u{11a8}"), ("\u{ae32}", "\u{ae32}",
        "\u{1100}\u{1175}\u{11a9}", "\u{ae32}", "\u{1100}\u{1175}\u{11a9}"), ("\u{ae33}",
        "\u{ae33}", "\u{1100}\u{1175}\u{11aa}", "\u{ae33}", "\u{1100}\u{1175}\u{11aa}"),
        ("\u{ae34}", "\u{ae34}", "\u{1100}\u{1175}\u{11ab}", "\u{ae34}",
        "\u{1100}\u{1175}\u{11ab}"), ("\u{ae35}", "\u{ae35}", "\u{1100}\u{1175}\u{11ac}",
        "\u{ae35}", "\u{1100}\u{1175}\u{11ac}"), ("\u{ae36}", "\u{ae36}",
        "\u{1100}\u{1175}\u{11ad}", "\u{ae36}", "\u{1100}\u{1175}\u{11ad}"), ("\u{ae37}",
        "\u{ae37}", "\u{1100}\u{1175}\u{11ae}", "\u{ae37}", "\u{1100}\u{1175}\u{11ae}"),
        ("\u{ae38}", "\u{ae38}", "\u{1100}\u{1175}\u{11af}", "\u{ae38}",
        "\u{1100}\u{1175}\u{11af}"), ("\u{ae39}", "\u{ae39}", "\u{1100}\u{1175}\u{11b0}",
        "\u{ae39}", "\u{1100}\u{1175}\u{11b0}"), ("\u{ae3a}", "\u{ae3a}",
        "\u{1100}\u{1175}\u{11b1}", "\u{ae3a}", "\u{1100}\u{1175}\u{11b1}"), ("\u{ae3b}",
        "\u{ae3b}", "\u{1100}\u{1175}\u{11b2}", "\u{ae3b}", "\u{1100}\u{1175}\u{11b2}"),
        ("\u{ae3c}", "\u{ae3c}", "\u{1100}\u{1175}\u{11b3}", "\u{ae3c}",
        "\u{1100}\u{1175}\u{11b3}"), ("\u{ae3d}", "\u{ae3d}", "\u{1100}\u{1175}\u{11b4}",
        "\u{ae3d}", "\u{1100}\u{1175}\u{11b4}"), ("\u{ae3e}", "\u{ae3e}",
        "\u{1100}\u{1175}\u{11b5}", "\u{ae3e}", "\u{1100}\u{1175}\u{11b5}"), ("\u{ae3f}",
        "\u{ae3f}", "\u{1100}\u{1175}\u{11b6}", "\u{ae3f}", "\u{1100}\u{1175}\u{11b6}"),
        ("\u{ae40}", "\u{ae40}", "\u{1100}\u{1175}\u{11b7}", "\u{ae40}",
        "\u{1100}\u{1175}\u{11b7}"), ("\u{ae41}", "\u{ae41}", "\u{1100}\u{1175}\u{11b8}",
        "\u{ae41}", "\u{1100}\u{1175}\u{11b8}"), ("\u{ae42}", "\u{ae42}",
        "\u{1100}\u{1175}\u{11b9}", "\u{ae42}", "\u{1100}\u{1175}\u{11b9}"), ("\u{ae43}",
        "\u{ae43}", "\u{1100}\u{1175}\u{11ba}", "\u{ae43}", "\u{1100}\u{1175}\u{11ba}"),
        ("\u{ae44}", "\u{ae44}", "\u{1100}\u{1175}\u{11bb}", "\u{ae44}",
        "\u{1100}\u{1175}\u{11bb}"), ("\u{ae45}", "\u{ae45}", "\u{1100}\u{1175}\u{11bc}",
        "\u{ae45}", "\u{1100}\u{1175}\u{11bc}"), ("\u{ae46}", "\u{ae46}",
        "\u{1100}\u{1175}\u{11bd}", "\u{ae46}", "\u{1100}\u{1175}\u{11bd}"), ("\u{ae47}",
        "\u{ae47}", "\u{1100}\u{1175}\u{11be}", "\u{ae47}", "\u{1100}\u{1175}\u{11be}"),
        ("\u{ae48}", "\u{ae48}", "\u{1100}\u{1175}\u{11bf}", "\u{ae48}",
        "\u{1100}\u{1175}\u{11bf}"), ("\u{ae49}", "\u{ae49}", "\u{1100}\u{1175}\u{11c0}",
        "\u{ae49}", "\u{1100}\u{1175}\u{11c0}"), ("\u{ae4a}", "\u{ae4a}",
        "\u{1100}\u{1175}\u{11c1}", "\u{ae4a}", "\u{1100}\u{1175}\u{11c1}"), ("\u{ae4b}",
        "\u{ae4b}", "\u{1100}\u{1175}\u{11c2}", "\u{ae4b}", "\u{1100}\u{1175}\u{11c2}"),
        ("\u{ae4c}", "\u{ae4c}", "\u{1101}\u{1161}", "\u{ae4c}", "\u{1101}\u{1161}"), ("\u{ae4d}",
        "\u{ae4d}", "\u{1101}\u{1161}\u{11a8}", "\u{ae4d}", "\u{1101}\u{1161}\u{11a8}"),
        ("\u{ae4e}", "\u{ae4e}", "\u{1101}\u{1161}\u{11a9}", "\u{ae4e}",
        "\u{1101}\u{1161}\u{11a9}"), ("\u{ae4f}", "\u{ae4f}", "\u{1101}\u{1161}\u{11aa}",
        "\u{ae4f}", "\u{1101}\u{1161}\u{11aa}"), ("\u{ae50}", "\u{ae50}",
        "\u{1101}\u{1161}\u{11ab}", "\u{ae50}", "\u{1101}\u{1161}\u{11ab}"), ("\u{ae51}",
        "\u{ae51}", "\u{1101}\u{1161}\u{11ac}", "\u{ae51}", "\u{1101}\u{1161}\u{11ac}"),
        ("\u{ae52}", "\u{ae52}", "\u{1101}\u{1161}\u{11ad}", "\u{ae52}",
        "\u{1101}\u{1161}\u{11ad}"), ("\u{ae53}", "\u{ae53}", "\u{1101}\u{1161}\u{11ae}",
        "\u{ae53}", "\u{1101}\u{1161}\u{11ae}"), ("\u{ae54}", "\u{ae54}",
        "\u{1101}\u{1161}\u{11af}", "\u{ae54}", "\u{1101}\u{1161}\u{11af}"), ("\u{ae55}",
        "\u{ae55}", "\u{1101}\u{1161}\u{11b0}", "\u{ae55}", "\u{1101}\u{1161}\u{11b0}"),
        ("\u{ae56}", "\u{ae56}", "\u{1101}\u{1161}\u{11b1}", "\u{ae56}",
        "\u{1101}\u{1161}\u{11b1}"), ("\u{ae57}", "\u{ae57}", "\u{1101}\u{1161}\u{11b2}",
        "\u{ae57}", "\u{1101}\u{1161}\u{11b2}"), ("\u{ae58}", "\u{ae58}",
        "\u{1101}\u{1161}\u{11b3}", "\u{ae58}", "\u{1101}\u{1161}\u{11b3}"), ("\u{ae59}",
        "\u{ae59}", "\u{1101}\u{1161}\u{11b4}", "\u{ae59}", "\u{1101}\u{1161}\u{11b4}"),
        ("\u{ae5a}", "\u{ae5a}", "\u{1101}\u{1161}\u{11b5}", "\u{ae5a}",
        "\u{1101}\u{1161}\u{11b5}"), ("\u{ae5b}", "\u{ae5b}", "\u{1101}\u{1161}\u{11b6}",
        "\u{ae5b}", "\u{1101}\u{1161}\u{11b6}"), ("\u{ae5c}", "\u{ae5c}",
        "\u{1101}\u{1161}\u{11b7}", "\u{ae5c}", "\u{1101}\u{1161}\u{11b7}"), ("\u{ae5d}",
        "\u{ae5d}", "\u{1101}\u{1161}\u{11b8}", "\u{ae5d}", "\u{1101}\u{1161}\u{11b8}"),
        ("\u{ae5e}", "\u{ae5e}", "\u{1101}\u{1161}\u{11b9}", "\u{ae5e}",
        "\u{1101}\u{1161}\u{11b9}"), ("\u{ae5f}", "\u{ae5f}", "\u{1101}\u{1161}\u{11ba}",
        "\u{ae5f}", "\u{1101}\u{1161}\u{11ba}"), ("\u{ae60}", "\u{ae60}",
        "\u{1101}\u{1161}\u{11bb}", "\u{ae60}", "\u{1101}\u{1161}\u{11bb}"), ("\u{ae61}",
        "\u{ae61}", "\u{1101}\u{1161}\u{11bc}", "\u{ae61}", "\u{1101}\u{1161}\u{11bc}"),
        ("\u{ae62}", "\u{ae62}", "\u{1101}\u{1161}\u{11bd}", "\u{ae62}",
        "\u{1101}\u{1161}\u{11bd}"), ("\u{ae63}", "\u{ae63}", "\u{1101}\u{1161}\u{11be}",
        "\u{ae63}", "\u{1101}\u{1161}\u{11be}"), ("\u{ae64}", "\u{ae64}",
        "\u{1101}\u{1161}\u{11bf}", "\u{ae64}", "\u{1101}\u{1161}\u{11bf}"), ("\u{ae65}",
        "\u{ae65}", "\u{1101}\u{1161}\u{11c0}", "\u{ae65}", "\u{1101}\u{1161}\u{11c0}"),
        ("\u{ae66}", "\u{ae66}", "\u{1101}\u{1161}\u{11c1}", "\u{ae66}",
        "\u{1101}\u{1161}\u{11c1}"), ("\u{ae67}", "\u{ae67}", "\u{1101}\u{1161}\u{11c2}",
        "\u{ae67}", "\u{1101}\u{1161}\u{11c2}"), ("\u{ae68}", "\u{ae68}", "\u{1101}\u{1162}",
        "\u{ae68}", "\u{1101}\u{1162}"), ("\u{ae69}", "\u{ae69}", "\u{1101}\u{1162}\u{11a8}",
        "\u{ae69}", "\u{1101}\u{1162}\u{11a8}"), ("\u{ae6a}", "\u{ae6a}",
        "\u{1101}\u{1162}\u{11a9}", "\u{ae6a}", "\u{1101}\u{1162}\u{11a9}"), ("\u{ae6b}",
        "\u{ae6b}", "\u{1101}\u{1162}\u{11aa}", "\u{ae6b}", "\u{1101}\u{1162}\u{11aa}"),
        ("\u{ae6c}", "\u{ae6c}", "\u{1101}\u{1162}\u{11ab}", "\u{ae6c}",
        "\u{1101}\u{1162}\u{11ab}"), ("\u{ae6d}", "\u{ae6d}", "\u{1101}\u{1162}\u{11ac}",
        "\u{ae6d}", "\u{1101}\u{1162}\u{11ac}"), ("\u{ae6e}", "\u{ae6e}",
        "\u{1101}\u{1162}\u{11ad}", "\u{ae6e}", "\u{1101}\u{1162}\u{11ad}"), ("\u{ae6f}",
        "\u{ae6f}", "\u{1101}\u{1162}\u{11ae}", "\u{ae6f}", "\u{1101}\u{1162}\u{11ae}"),
        ("\u{ae70}", "\u{ae70}", "\u{1101}\u{1162}\u{11af}", "\u{ae70}",
        "\u{1101}\u{1162}\u{11af}"), ("\u{ae71}", "\u{ae71}", "\u{1101}\u{1162}\u{11b0}",
        "\u{ae71}", "\u{1101}\u{1162}\u{11b0}"), ("\u{ae72}", "\u{ae72}",
        "\u{1101}\u{1162}\u{11b1}", "\u{ae72}", "\u{1101}\u{1162}\u{11b1}"), ("\u{ae73}",
        "\u{ae73}", "\u{1101}\u{1162}\u{11b2}", "\u{ae73}", "\u{1101}\u{1162}\u{11b2}"),
        ("\u{ae74}", "\u{ae74}", "\u{1101}\u{1162}\u{11b3}", "\u{ae74}",
        "\u{1101}\u{1162}\u{11b3}"), ("\u{ae75}", "\u{ae75}", "\u{1101}\u{1162}\u{11b4}",
        "\u{ae75}", "\u{1101}\u{1162}\u{11b4}"), ("\u{ae76}", "\u{ae76}",
        "\u{1101}\u{1162}\u{11b5}", "\u{ae76}", "\u{1101}\u{1162}\u{11b5}"), ("\u{ae77}",
        "\u{ae77}", "\u{1101}\u{1162}\u{11b6}", "\u{ae77}", "\u{1101}\u{1162}\u{11b6}"),
        ("\u{ae78}", "\u{ae78}", "\u{1101}\u{1162}\u{11b7}", "\u{ae78}",
        "\u{1101}\u{1162}\u{11b7}"), ("\u{ae79}", "\u{ae79}", "\u{1101}\u{1162}\u{11b8}",
        "\u{ae79}", "\u{1101}\u{1162}\u{11b8}"), ("\u{ae7a}", "\u{ae7a}",
        "\u{1101}\u{1162}\u{11b9}", "\u{ae7a}", "\u{1101}\u{1162}\u{11b9}"), ("\u{ae7b}",
        "\u{ae7b}", "\u{1101}\u{1162}\u{11ba}", "\u{ae7b}", "\u{1101}\u{1162}\u{11ba}"),
        ("\u{ae7c}", "\u{ae7c}", "\u{1101}\u{1162}\u{11bb}", "\u{ae7c}",
        "\u{1101}\u{1162}\u{11bb}"), ("\u{ae7d}", "\u{ae7d}", "\u{1101}\u{1162}\u{11bc}",
        "\u{ae7d}", "\u{1101}\u{1162}\u{11bc}"), ("\u{ae7e}", "\u{ae7e}",
        "\u{1101}\u{1162}\u{11bd}", "\u{ae7e}", "\u{1101}\u{1162}\u{11bd}"), ("\u{ae7f}",
        "\u{ae7f}", "\u{1101}\u{1162}\u{11be}", "\u{ae7f}", "\u{1101}\u{1162}\u{11be}"),
        ("\u{ae80}", "\u{ae80}", "\u{1101}\u{1162}\u{11bf}", "\u{ae80}",
        "\u{1101}\u{1162}\u{11bf}"), ("\u{ae81}", "\u{ae81}", "\u{1101}\u{1162}\u{11c0}",
        "\u{ae81}", "\u{1101}\u{1162}\u{11c0}"), ("\u{ae82}", "\u{ae82}",
        "\u{1101}\u{1162}\u{11c1}", "\u{ae82}", "\u{1101}\u{1162}\u{11c1}"), ("\u{ae83}",
        "\u{ae83}", "\u{1101}\u{1162}\u{11c2}", "\u{ae83}", "\u{1101}\u{1162}\u{11c2}"),
        ("\u{ae84}", "\u{ae84}", "\u{1101}\u{1163}", "\u{ae84}", "\u{1101}\u{1163}"), ("\u{ae85}",
        "\u{ae85}", "\u{1101}\u{1163}\u{11a8}", "\u{ae85}", "\u{1101}\u{1163}\u{11a8}"),
        ("\u{ae86}", "\u{ae86}", "\u{1101}\u{1163}\u{11a9}", "\u{ae86}",
        "\u{1101}\u{1163}\u{11a9}"), ("\u{ae87}", "\u{ae87}", "\u{1101}\u{1163}\u{11aa}",
        "\u{ae87}", "\u{1101}\u{1163}\u{11aa}"), ("\u{ae88}", "\u{ae88}",
        "\u{1101}\u{1163}\u{11ab}", "\u{ae88}", "\u{1101}\u{1163}\u{11ab}"), ("\u{ae89}",
        "\u{ae89}", "\u{1101}\u{1163}\u{11ac}", "\u{ae89}", "\u{1101}\u{1163}\u{11ac}"),
        ("\u{ae8a}", "\u{ae8a}", "\u{1101}\u{1163}\u{11ad}", "\u{ae8a}",
        "\u{1101}\u{1163}\u{11ad}"), ("\u{ae8b}", "\u{ae8b}", "\u{1101}\u{1163}\u{11ae}",
        "\u{ae8b}", "\u{1101}\u{1163}\u{11ae}"), ("\u{ae8c}", "\u{ae8c}",
        "\u{1101}\u{1163}\u{11af}", "\u{ae8c}", "\u{1101}\u{1163}\u{11af}"), ("\u{ae8d}",
        "\u{ae8d}", "\u{1101}\u{1163}\u{11b0}", "\u{ae8d}", "\u{1101}\u{1163}\u{11b0}"),
        ("\u{ae8e}", "\u{ae8e}", "\u{1101}\u{1163}\u{11b1}", "\u{ae8e}",
        "\u{1101}\u{1163}\u{11b1}"), ("\u{ae8f}", "\u{ae8f}", "\u{1101}\u{1163}\u{11b2}",
        "\u{ae8f}", "\u{1101}\u{1163}\u{11b2}"), ("\u{ae90}", "\u{ae90}",
        "\u{1101}\u{1163}\u{11b3}", "\u{ae90}", "\u{1101}\u{1163}\u{11b3}"), ("\u{ae91}",
        "\u{ae91}", "\u{1101}\u{1163}\u{11b4}", "\u{ae91}", "\u{1101}\u{1163}\u{11b4}"),
        ("\u{ae92}", "\u{ae92}", "\u{1101}\u{1163}\u{11b5}", "\u{ae92}",
        "\u{1101}\u{1163}\u{11b5}"), ("\u{ae93}", "\u{ae93}", "\u{1101}\u{1163}\u{11b6}",
        "\u{ae93}", "\u{1101}\u{1163}\u{11b6}"), ("\u{ae94}", "\u{ae94}",
        "\u{1101}\u{1163}\u{11b7}", "\u{ae94}", "\u{1101}\u{1163}\u{11b7}"), ("\u{ae95}",
        "\u{ae95}", "\u{1101}\u{1163}\u{11b8}", "\u{ae95}", "\u{1101}\u{1163}\u{11b8}"),
        ("\u{ae96}", "\u{ae96}", "\u{1101}\u{1163}\u{11b9}", "\u{ae96}",
        "\u{1101}\u{1163}\u{11b9}"), ("\u{ae97}", "\u{ae97}", "\u{1101}\u{1163}\u{11ba}",
        "\u{ae97}", "\u{1101}\u{1163}\u{11ba}"), ("\u{ae98}", "\u{ae98}",
        "\u{1101}\u{1163}\u{11bb}", "\u{ae98}", "\u{1101}\u{1163}\u{11bb}"), ("\u{ae99}",
        "\u{ae99}", "\u{1101}\u{1163}\u{11bc}", "\u{ae99}", "\u{1101}\u{1163}\u{11bc}"),
        ("\u{ae9a}", "\u{ae9a}", "\u{1101}\u{1163}\u{11bd}", "\u{ae9a}",
        "\u{1101}\u{1163}\u{11bd}"), ("\u{ae9b}", "\u{ae9b}", "\u{1101}\u{1163}\u{11be}",
        "\u{ae9b}", "\u{1101}\u{1163}\u{11be}"), ("\u{ae9c}", "\u{ae9c}",
        "\u{1101}\u{1163}\u{11bf}", "\u{ae9c}", "\u{1101}\u{1163}\u{11bf}"), ("\u{ae9d}",
        "\u{ae9d}", "\u{1101}\u{1163}\u{11c0}", "\u{ae9d}", "\u{1101}\u{1163}\u{11c0}"),
        ("\u{ae9e}", "\u{ae9e}", "\u{1101}\u{1163}\u{11c1}", "\u{ae9e}",
        "\u{1101}\u{1163}\u{11c1}"), ("\u{ae9f}", "\u{ae9f}", "\u{1101}\u{1163}\u{11c2}",
        "\u{ae9f}", "\u{1101}\u{1163}\u{11c2}"), ("\u{aea0}", "\u{aea0}", "\u{1101}\u{1164}",
        "\u{aea0}", "\u{1101}\u{1164}"), ("\u{aea1}", "\u{aea1}", "\u{1101}\u{1164}\u{11a8}",
        "\u{aea1}", "\u{1101}\u{1164}\u{11a8}"), ("\u{aea2}", "\u{aea2}",
        "\u{1101}\u{1164}\u{11a9}", "\u{aea2}", "\u{1101}\u{1164}\u{11a9}"), ("\u{aea3}",
        "\u{aea3}", "\u{1101}\u{1164}\u{11aa}", "\u{aea3}", "\u{1101}\u{1164}\u{11aa}"),
        ("\u{aea4}", "\u{aea4}", "\u{1101}\u{1164}\u{11ab}", "\u{aea4}",
        "\u{1101}\u{1164}\u{11ab}"), ("\u{aea5}", "\u{aea5}", "\u{1101}\u{1164}\u{11ac}",
        "\u{aea5}", "\u{1101}\u{1164}\u{11ac}"), ("\u{aea6}", "\u{aea6}",
        "\u{1101}\u{1164}\u{11ad}", "\u{aea6}", "\u{1101}\u{1164}\u{11ad}"), ("\u{aea7}",
        "\u{aea7}", "\u{1101}\u{1164}\u{11ae}", "\u{aea7}", "\u{1101}\u{1164}\u{11ae}"),
        ("\u{aea8}", "\u{aea8}", "\u{1101}\u{1164}\u{11af}", "\u{aea8}",
        "\u{1101}\u{1164}\u{11af}"), ("\u{aea9}", "\u{aea9}", "\u{1101}\u{1164}\u{11b0}",
        "\u{aea9}", "\u{1101}\u{1164}\u{11b0}"), ("\u{aeaa}", "\u{aeaa}",
        "\u{1101}\u{1164}\u{11b1}", "\u{aeaa}", "\u{1101}\u{1164}\u{11b1}"), ("\u{aeab}",
        "\u{aeab}", "\u{1101}\u{1164}\u{11b2}", "\u{aeab}", "\u{1101}\u{1164}\u{11b2}"),
        ("\u{aeac}", "\u{aeac}", "\u{1101}\u{1164}\u{11b3}", "\u{aeac}",
        "\u{1101}\u{1164}\u{11b3}"), ("\u{aead}", "\u{aead}", "\u{1101}\u{1164}\u{11b4}",
        "\u{aead}", "\u{1101}\u{1164}\u{11b4}"), ("\u{aeae}", "\u{aeae}",
        "\u{1101}\u{1164}\u{11b5}", "\u{aeae}", "\u{1101}\u{1164}\u{11b5}"), ("\u{aeaf}",
        "\u{aeaf}", "\u{1101}\u{1164}\u{11b6}", "\u{aeaf}", "\u{1101}\u{1164}\u{11b6}"),
        ("\u{aeb0}", "\u{aeb0}", "\u{1101}\u{1164}\u{11b7}", "\u{aeb0}",
        "\u{1101}\u{1164}\u{11b7}"), ("\u{aeb1}", "\u{aeb1}", "\u{1101}\u{1164}\u{11b8}",
        "\u{aeb1}", "\u{1101}\u{1164}\u{11b8}"), ("\u{aeb2}", "\u{aeb2}",
        "\u{1101}\u{1164}\u{11b9}", "\u{aeb2}", "\u{1101}\u{1164}\u{11b9}"), ("\u{aeb3}",
        "\u{aeb3}", "\u{1101}\u{1164}\u{11ba}", "\u{aeb3}", "\u{1101}\u{1164}\u{11ba}"),
        ("\u{aeb4}", "\u{aeb4}", "\u{1101}\u{1164}\u{11bb}", "\u{aeb4}",
        "\u{1101}\u{1164}\u{11bb}"), ("\u{aeb5}", "\u{aeb5}", "\u{1101}\u{1164}\u{11bc}",
        "\u{aeb5}", "\u{1101}\u{1164}\u{11bc}"), ("\u{aeb6}", "\u{aeb6}",
        "\u{1101}\u{1164}\u{11bd}", "\u{aeb6}", "\u{1101}\u{1164}\u{11bd}"), ("\u{aeb7}",
        "\u{aeb7}", "\u{1101}\u{1164}\u{11be}", "\u{aeb7}", "\u{1101}\u{1164}\u{11be}"),
        ("\u{aeb8}", "\u{aeb8}", "\u{1101}\u{1164}\u{11bf}", "\u{aeb8}",
        "\u{1101}\u{1164}\u{11bf}"), ("\u{aeb9}", "\u{aeb9}", "\u{1101}\u{1164}\u{11c0}",
        "\u{aeb9}", "\u{1101}\u{1164}\u{11c0}"), ("\u{aeba}", "\u{aeba}",
        "\u{1101}\u{1164}\u{11c1}", "\u{aeba}", "\u{1101}\u{1164}\u{11c1}"), ("\u{aebb}",
        "\u{aebb}", "\u{1101}\u{1164}\u{11c2}", "\u{aebb}", "\u{1101}\u{1164}\u{11c2}"),
        ("\u{aebc}", "\u{aebc}", "\u{1101}\u{1165}", "\u{aebc}", "\u{1101}\u{1165}"), ("\u{aebd}",
        "\u{aebd}", "\u{1101}\u{1165}\u{11a8}", "\u{aebd}", "\u{1101}\u{1165}\u{11a8}"),
        ("\u{aebe}", "\u{aebe}", "\u{1101}\u{1165}\u{11a9}", "\u{aebe}",
        "\u{1101}\u{1165}\u{11a9}"), ("\u{aebf}", "\u{aebf}", "\u{1101}\u{1165}\u{11aa}",
        "\u{aebf}", "\u{1101}\u{1165}\u{11aa}"), ("\u{aec0}", "\u{aec0}",
        "\u{1101}\u{1165}\u{11ab}", "\u{aec0}", "\u{1101}\u{1165}\u{11ab}"), ("\u{aec1}",
        "\u{aec1}", "\u{1101}\u{1165}\u{11ac}", "\u{aec1}", "\u{1101}\u{1165}\u{11ac}"),
        ("\u{aec2}", "\u{aec2}", "\u{1101}\u{1165}\u{11ad}", "\u{aec2}",
        "\u{1101}\u{1165}\u{11ad}"), ("\u{aec3}", "\u{aec3}", "\u{1101}\u{1165}\u{11ae}",
        "\u{aec3}", "\u{1101}\u{1165}\u{11ae}"), ("\u{aec4}", "\u{aec4}",
        "\u{1101}\u{1165}\u{11af}", "\u{aec4}", "\u{1101}\u{1165}\u{11af}"), ("\u{aec5}",
        "\u{aec5}", "\u{1101}\u{1165}\u{11b0}", "\u{aec5}", "\u{1101}\u{1165}\u{11b0}"),
        ("\u{aec6}", "\u{aec6}", "\u{1101}\u{1165}\u{11b1}", "\u{aec6}",
        "\u{1101}\u{1165}\u{11b1}"), ("\u{aec7}", "\u{aec7}", "\u{1101}\u{1165}\u{11b2}",
        "\u{aec7}", "\u{1101}\u{1165}\u{11b2}"), ("\u{aec8}", "\u{aec8}",
        "\u{1101}\u{1165}\u{11b3}", "\u{aec8}", "\u{1101}\u{1165}\u{11b3}"), ("\u{aec9}",
        "\u{aec9}", "\u{1101}\u{1165}\u{11b4}", "\u{aec9}", "\u{1101}\u{1165}\u{11b4}"),
        ("\u{aeca}", "\u{aeca}", "\u{1101}\u{1165}\u{11b5}", "\u{aeca}",
        "\u{1101}\u{1165}\u{11b5}"), ("\u{aecb}", "\u{aecb}", "\u{1101}\u{1165}\u{11b6}",
        "\u{aecb}", "\u{1101}\u{1165}\u{11b6}"), ("\u{aecc}", "\u{aecc}",
        "\u{1101}\u{1165}\u{11b7}", "\u{aecc}", "\u{1101}\u{1165}\u{11b7}"), ("\u{aecd}",
        "\u{aecd}", "\u{1101}\u{1165}\u{11b8}", "\u{aecd}", "\u{1101}\u{1165}\u{11b8}"),
        ("\u{aece}", "\u{aece}", "\u{1101}\u{1165}\u{11b9}", "\u{aece}",
        "\u{1101}\u{1165}\u{11b9}"), ("\u{aecf}", "\u{aecf}", "\u{1101}\u{1165}\u{11ba}",
        "\u{aecf}", "\u{1101}\u{1165}\u{11ba}"), ("\u{aed0}", "\u{aed0}",
        "\u{1101}\u{1165}\u{11bb}", "\u{aed0}", "\u{1101}\u{1165}\u{11bb}"), ("\u{aed1}",
        "\u{aed1}", "\u{1101}\u{1165}\u{11bc}", "\u{aed1}", "\u{1101}\u{1165}\u{11bc}"),
        ("\u{aed2}", "\u{aed2}", "\u{1101}\u{1165}\u{11bd}", "\u{aed2}",
        "\u{1101}\u{1165}\u{11bd}"), ("\u{aed3}", "\u{aed3}", "\u{1101}\u{1165}\u{11be}",
        "\u{aed3}", "\u{1101}\u{1165}\u{11be}"), ("\u{aed4}", "\u{aed4}",
        "\u{1101}\u{1165}\u{11bf}", "\u{aed4}", "\u{1101}\u{1165}\u{11bf}"), ("\u{aed5}",
        "\u{aed5}", "\u{1101}\u{1165}\u{11c0}", "\u{aed5}", "\u{1101}\u{1165}\u{11c0}"),
        ("\u{aed6}", "\u{aed6}", "\u{1101}\u{1165}\u{11c1}", "\u{aed6}",
        "\u{1101}\u{1165}\u{11c1}"), ("\u{aed7}", "\u{aed7}", "\u{1101}\u{1165}\u{11c2}",
        "\u{aed7}", "\u{1101}\u{1165}\u{11c2}"), ("\u{aed8}", "\u{aed8}", "\u{1101}\u{1166}",
        "\u{aed8}", "\u{1101}\u{1166}"), ("\u{aed9}", "\u{aed9}", "\u{1101}\u{1166}\u{11a8}",
        "\u{aed9}", "\u{1101}\u{1166}\u{11a8}"), ("\u{aeda}", "\u{aeda}",
        "\u{1101}\u{1166}\u{11a9}", "\u{aeda}", "\u{1101}\u{1166}\u{11a9}"), ("\u{aedb}",
        "\u{aedb}", "\u{1101}\u{1166}\u{11aa}", "\u{aedb}", "\u{1101}\u{1166}\u{11aa}"),
        ("\u{aedc}", "\u{aedc}", "\u{1101}\u{1166}\u{11ab}", "\u{aedc}",
        "\u{1101}\u{1166}\u{11ab}"), ("\u{aedd}", "\u{aedd}", "\u{1101}\u{1166}\u{11ac}",
        "\u{aedd}", "\u{1101}\u{1166}\u{11ac}"), ("\u{aede}", "\u{aede}",
        "\u{1101}\u{1166}\u{11ad}", "\u{aede}", "\u{1101}\u{1166}\u{11ad}"), ("\u{aedf}",
        "\u{aedf}", "\u{1101}\u{1166}\u{11ae}", "\u{aedf}", "\u{1101}\u{1166}\u{11ae}"),
        ("\u{aee0}", "\u{aee0}", "\u{1101}\u{1166}\u{11af}", "\u{aee0}",
        "\u{1101}\u{1166}\u{11af}"), ("\u{aee1}", "\u{aee1}", "\u{1101}\u{1166}\u{11b0}",
        "\u{aee1}", "\u{1101}\u{1166}\u{11b0}"), ("\u{aee2}", "\u{aee2}",
        "\u{1101}\u{1166}\u{11b1}", "\u{aee2}", "\u{1101}\u{1166}\u{11b1}"), ("\u{aee3}",
        "\u{aee3}", "\u{1101}\u{1166}\u{11b2}", "\u{aee3}", "\u{1101}\u{1166}\u{11b2}"),
        ("\u{aee4}", "\u{aee4}", "\u{1101}\u{1166}\u{11b3}", "\u{aee4}",
        "\u{1101}\u{1166}\u{11b3}"), ("\u{aee5}", "\u{aee5}", "\u{1101}\u{1166}\u{11b4}",
        "\u{aee5}", "\u{1101}\u{1166}\u{11b4}"), ("\u{aee6}", "\u{aee6}",
        "\u{1101}\u{1166}\u{11b5}", "\u{aee6}", "\u{1101}\u{1166}\u{11b5}"), ("\u{aee7}",
        "\u{aee7}", "\u{1101}\u{1166}\u{11b6}", "\u{aee7}", "\u{1101}\u{1166}\u{11b6}"),
        ("\u{aee8}", "\u{aee8}", "\u{1101}\u{1166}\u{11b7}", "\u{aee8}",
        "\u{1101}\u{1166}\u{11b7}"), ("\u{aee9}", "\u{aee9}", "\u{1101}\u{1166}\u{11b8}",
        "\u{aee9}", "\u{1101}\u{1166}\u{11b8}"), ("\u{aeea}", "\u{aeea}",
        "\u{1101}\u{1166}\u{11b9}", "\u{aeea}", "\u{1101}\u{1166}\u{11b9}"), ("\u{aeeb}",
        "\u{aeeb}", "\u{1101}\u{1166}\u{11ba}", "\u{aeeb}", "\u{1101}\u{1166}\u{11ba}"),
        ("\u{aeec}", "\u{aeec}", "\u{1101}\u{1166}\u{11bb}", "\u{aeec}",
        "\u{1101}\u{1166}\u{11bb}"), ("\u{aeed}", "\u{aeed}", "\u{1101}\u{1166}\u{11bc}",
        "\u{aeed}", "\u{1101}\u{1166}\u{11bc}"), ("\u{aeee}", "\u{aeee}",
        "\u{1101}\u{1166}\u{11bd}", "\u{aeee}", "\u{1101}\u{1166}\u{11bd}"), ("\u{aeef}",
        "\u{aeef}", "\u{1101}\u{1166}\u{11be}", "\u{aeef}", "\u{1101}\u{1166}\u{11be}"),
        ("\u{aef0}", "\u{aef0}", "\u{1101}\u{1166}\u{11bf}", "\u{aef0}",
        "\u{1101}\u{1166}\u{11bf}"), ("\u{aef1}", "\u{aef1}", "\u{1101}\u{1166}\u{11c0}",
        "\u{aef1}", "\u{1101}\u{1166}\u{11c0}"), ("\u{aef2}", "\u{aef2}",
        "\u{1101}\u{1166}\u{11c1}", "\u{aef2}", "\u{1101}\u{1166}\u{11c1}"), ("\u{aef3}",
        "\u{aef3}", "\u{1101}\u{1166}\u{11c2}", "\u{aef3}", "\u{1101}\u{1166}\u{11c2}"),
        ("\u{aef4}", "\u{aef4}", "\u{1101}\u{1167}", "\u{aef4}", "\u{1101}\u{1167}"), ("\u{aef5}",
        "\u{aef5}", "\u{1101}\u{1167}\u{11a8}", "\u{aef5}", "\u{1101}\u{1167}\u{11a8}"),
        ("\u{aef6}", "\u{aef6}", "\u{1101}\u{1167}\u{11a9}", "\u{aef6}",
        "\u{1101}\u{1167}\u{11a9}"), ("\u{aef7}", "\u{aef7}", "\u{1101}\u{1167}\u{11aa}",
        "\u{aef7}", "\u{1101}\u{1167}\u{11aa}"), ("\u{aef8}", "\u{aef8}",
        "\u{1101}\u{1167}\u{11ab}", "\u{aef8}", "\u{1101}\u{1167}\u{11ab}"), ("\u{aef9}",
        "\u{aef9}", "\u{1101}\u{1167}\u{11ac}", "\u{aef9}", "\u{1101}\u{1167}\u{11ac}"),
        ("\u{aefa}", "\u{aefa}", "\u{1101}\u{1167}\u{11ad}", "\u{aefa}",
        "\u{1101}\u{1167}\u{11ad}"), ("\u{aefb}", "\u{aefb}", "\u{1101}\u{1167}\u{11ae}",
        "\u{aefb}", "\u{1101}\u{1167}\u{11ae}"), ("\u{aefc}", "\u{aefc}",
        "\u{1101}\u{1167}\u{11af}", "\u{aefc}", "\u{1101}\u{1167}\u{11af}"), ("\u{aefd}",
        "\u{aefd}", "\u{1101}\u{1167}\u{11b0}", "\u{aefd}", "\u{1101}\u{1167}\u{11b0}"),
        ("\u{aefe}", "\u{aefe}", "\u{1101}\u{1167}\u{11b1}", "\u{aefe}",
        "\u{1101}\u{1167}\u{11b1}"), ("\u{aeff}", "\u{aeff}", "\u{1101}\u{1167}\u{11b2}",
        "\u{aeff}", "\u{1101}\u{1167}\u{11b2}"), ("\u{af00}", "\u{af00}",
        "\u{1101}\u{1167}\u{11b3}", "\u{af00}", "\u{1101}\u{1167}\u{11b3}"), ("\u{af01}",
        "\u{af01}", "\u{1101}\u{1167}\u{11b4}", "\u{af01}", "\u{1101}\u{1167}\u{11b4}"),
        ("\u{af02}", "\u{af02}", "\u{1101}\u{1167}\u{11b5}", "\u{af02}",
        "\u{1101}\u{1167}\u{11b5}"), ("\u{af03}", "\u{af03}", "\u{1101}\u{1167}\u{11b6}",
        "\u{af03}", "\u{1101}\u{1167}\u{11b6}"), ("\u{af04}", "\u{af04}",
        "\u{1101}\u{1167}\u{11b7}", "\u{af04}", "\u{1101}\u{1167}\u{11b7}"), ("\u{af05}",
        "\u{af05}", "\u{1101}\u{1167}\u{11b8}", "\u{af05}", "\u{1101}\u{1167}\u{11b8}"),
        ("\u{af06}", "\u{af06}", "\u{1101}\u{1167}\u{11b9}", "\u{af06}",
        "\u{1101}\u{1167}\u{11b9}"), ("\u{af07}", "\u{af07}", "\u{1101}\u{1167}\u{11ba}",
        "\u{af07}", "\u{1101}\u{1167}\u{11ba}"), ("\u{af08}", "\u{af08}",
        "\u{1101}\u{1167}\u{11bb}", "\u{af08}", "\u{1101}\u{1167}\u{11bb}"), ("\u{af09}",
        "\u{af09}", "\u{1101}\u{1167}\u{11bc}", "\u{af09}", "\u{1101}\u{1167}\u{11bc}"),
        ("\u{af0a}", "\u{af0a}", "\u{1101}\u{1167}\u{11bd}", "\u{af0a}",
        "\u{1101}\u{1167}\u{11bd}"), ("\u{af0b}", "\u{af0b}", "\u{1101}\u{1167}\u{11be}",
        "\u{af0b}", "\u{1101}\u{1167}\u{11be}"), ("\u{af0c}", "\u{af0c}",
        "\u{1101}\u{1167}\u{11bf}", "\u{af0c}", "\u{1101}\u{1167}\u{11bf}"), ("\u{af0d}",
        "\u{af0d}", "\u{1101}\u{1167}\u{11c0}", "\u{af0d}", "\u{1101}\u{1167}\u{11c0}"),
        ("\u{af0e}", "\u{af0e}", "\u{1101}\u{1167}\u{11c1}", "\u{af0e}",
        "\u{1101}\u{1167}\u{11c1}"), ("\u{af0f}", "\u{af0f}", "\u{1101}\u{1167}\u{11c2}",
        "\u{af0f}", "\u{1101}\u{1167}\u{11c2}"), ("\u{af10}", "\u{af10}", "\u{1101}\u{1168}",
        "\u{af10}", "\u{1101}\u{1168}"), ("\u{af11}", "\u{af11}", "\u{1101}\u{1168}\u{11a8}",
        "\u{af11}", "\u{1101}\u{1168}\u{11a8}"), ("\u{af12}", "\u{af12}",
        "\u{1101}\u{1168}\u{11a9}", "\u{af12}", "\u{1101}\u{1168}\u{11a9}"), ("\u{af13}",
        "\u{af13}", "\u{1101}\u{1168}\u{11aa}", "\u{af13}", "\u{1101}\u{1168}\u{11aa}"),
        ("\u{af14}", "\u{af14}", "\u{1101}\u{1168}\u{11ab}", "\u{af14}",
        "\u{1101}\u{1168}\u{11ab}"), ("\u{af15}", "\u{af15}", "\u{1101}\u{1168}\u{11ac}",
        "\u{af15}", "\u{1101}\u{1168}\u{11ac}"), ("\u{af16}", "\u{af16}",
        "\u{1101}\u{1168}\u{11ad}", "\u{af16}", "\u{1101}\u{1168}\u{11ad}"), ("\u{af17}",
        "\u{af17}", "\u{1101}\u{1168}\u{11ae}", "\u{af17}", "\u{1101}\u{1168}\u{11ae}"),
        ("\u{af18}", "\u{af18}", "\u{1101}\u{1168}\u{11af}", "\u{af18}",
        "\u{1101}\u{1168}\u{11af}"), ("\u{af19}", "\u{af19}", "\u{1101}\u{1168}\u{11b0}",
        "\u{af19}", "\u{1101}\u{1168}\u{11b0}"), ("\u{af1a}", "\u{af1a}",
        "\u{1101}\u{1168}\u{11b1}", "\u{af1a}", "\u{1101}\u{1168}\u{11b1}"), ("\u{af1b}",
        "\u{af1b}", "\u{1101}\u{1168}\u{11b2}", "\u{af1b}", "\u{1101}\u{1168}\u{11b2}"),
        ("\u{af1c}", "\u{af1c}", "\u{1101}\u{1168}\u{11b3}", "\u{af1c}",
        "\u{1101}\u{1168}\u{11b3}"), ("\u{af1d}", "\u{af1d}", "\u{1101}\u{1168}\u{11b4}",
        "\u{af1d}", "\u{1101}\u{1168}\u{11b4}"), ("\u{af1e}", "\u{af1e}",
        "\u{1101}\u{1168}\u{11b5}", "\u{af1e}", "\u{1101}\u{1168}\u{11b5}"), ("\u{af1f}",
        "\u{af1f}", "\u{1101}\u{1168}\u{11b6}", "\u{af1f}", "\u{1101}\u{1168}\u{11b6}"),
        ("\u{af20}", "\u{af20}", "\u{1101}\u{1168}\u{11b7}", "\u{af20}",
        "\u{1101}\u{1168}\u{11b7}"), ("\u{af21}", "\u{af21}", "\u{1101}\u{1168}\u{11b8}",
        "\u{af21}", "\u{1101}\u{1168}\u{11b8}"), ("\u{af22}", "\u{af22}",
        "\u{1101}\u{1168}\u{11b9}", "\u{af22}", "\u{1101}\u{1168}\u{11b9}"), ("\u{af23}",
        "\u{af23}", "\u{1101}\u{1168}\u{11ba}", "\u{af23}", "\u{1101}\u{1168}\u{11ba}"),
        ("\u{af24}", "\u{af24}", "\u{1101}\u{1168}\u{11bb}", "\u{af24}",
        "\u{1101}\u{1168}\u{11bb}"), ("\u{af25}", "\u{af25}", "\u{1101}\u{1168}\u{11bc}",
        "\u{af25}", "\u{1101}\u{1168}\u{11bc}"), ("\u{af26}", "\u{af26}",
        "\u{1101}\u{1168}\u{11bd}", "\u{af26}", "\u{1101}\u{1168}\u{11bd}"), ("\u{af27}",
        "\u{af27}", "\u{1101}\u{1168}\u{11be}", "\u{af27}", "\u{1101}\u{1168}\u{11be}"),
        ("\u{af28}", "\u{af28}", "\u{1101}\u{1168}\u{11bf}", "\u{af28}",
        "\u{1101}\u{1168}\u{11bf}"), ("\u{af29}", "\u{af29}", "\u{1101}\u{1168}\u{11c0}",
        "\u{af29}", "\u{1101}\u{1168}\u{11c0}"), ("\u{af2a}", "\u{af2a}",
        "\u{1101}\u{1168}\u{11c1}", "\u{af2a}", "\u{1101}\u{1168}\u{11c1}"), ("\u{af2b}",
        "\u{af2b}", "\u{1101}\u{1168}\u{11c2}", "\u{af2b}", "\u{1101}\u{1168}\u{11c2}"),
        ("\u{af2c}", "\u{af2c}", "\u{1101}\u{1169}", "\u{af2c}", "\u{1101}\u{1169}"), ("\u{af2d}",
        "\u{af2d}", "\u{1101}\u{1169}\u{11a8}", "\u{af2d}", "\u{1101}\u{1169}\u{11a8}"),
        ("\u{af2e}", "\u{af2e}", "\u{1101}\u{1169}\u{11a9}", "\u{af2e}",
        "\u{1101}\u{1169}\u{11a9}"), ("\u{af2f}", "\u{af2f}", "\u{1101}\u{1169}\u{11aa}",
        "\u{af2f}", "\u{1101}\u{1169}\u{11aa}"), ("\u{af30}", "\u{af30}",
        "\u{1101}\u{1169}\u{11ab}", "\u{af30}", "\u{1101}\u{1169}\u{11ab}"), ("\u{af31}",
        "\u{af31}", "\u{1101}\u{1169}\u{11ac}", "\u{af31}", "\u{1101}\u{1169}\u{11ac}"),
        ("\u{af32}", "\u{af32}", "\u{1101}\u{1169}\u{11ad}", "\u{af32}",
        "\u{1101}\u{1169}\u{11ad}"), ("\u{af33}", "\u{af33}", "\u{1101}\u{1169}\u{11ae}",
        "\u{af33}", "\u{1101}\u{1169}\u{11ae}"), ("\u{af34}", "\u{af34}",
        "\u{1101}\u{1169}\u{11af}", "\u{af34}", "\u{1101}\u{1169}\u{11af}"), ("\u{af35}",
        "\u{af35}", "\u{1101}\u{1169}\u{11b0}", "\u{af35}", "\u{1101}\u{1169}\u{11b0}"),
        ("\u{af36}", "\u{af36}", "\u{1101}\u{1169}\u{11b1}", "\u{af36}",
        "\u{1101}\u{1169}\u{11b1}"), ("\u{af37}", "\u{af37}", "\u{1101}\u{1169}\u{11b2}",
        "\u{af37}", "\u{1101}\u{1169}\u{11b2}"), ("\u{af38}", "\u{af38}",
        "\u{1101}\u{1169}\u{11b3}", "\u{af38}", "\u{1101}\u{1169}\u{11b3}"), ("\u{af39}",
        "\u{af39}", "\u{1101}\u{1169}\u{11b4}", "\u{af39}", "\u{1101}\u{1169}\u{11b4}"),
        ("\u{af3a}", "\u{af3a}", "\u{1101}\u{1169}\u{11b5}", "\u{af3a}",
        "\u{1101}\u{1169}\u{11b5}"), ("\u{af3b}", "\u{af3b}", "\u{1101}\u{1169}\u{11b6}",
        "\u{af3b}", "\u{1101}\u{1169}\u{11b6}"), ("\u{af3c}", "\u{af3c}",
        "\u{1101}\u{1169}\u{11b7}", "\u{af3c}", "\u{1101}\u{1169}\u{11b7}"), ("\u{af3d}",
        "\u{af3d}", "\u{1101}\u{1169}\u{11b8}", "\u{af3d}", "\u{1101}\u{1169}\u{11b8}"),
        ("\u{af3e}", "\u{af3e}", "\u{1101}\u{1169}\u{11b9}", "\u{af3e}",
        "\u{1101}\u{1169}\u{11b9}"), ("\u{af3f}", "\u{af3f}", "\u{1101}\u{1169}\u{11ba}",
        "\u{af3f}", "\u{1101}\u{1169}\u{11ba}"), ("\u{af40}", "\u{af40}",
        "\u{1101}\u{1169}\u{11bb}", "\u{af40}", "\u{1101}\u{1169}\u{11bb}"), ("\u{af41}",
        "\u{af41}", "\u{1101}\u{1169}\u{11bc}", "\u{af41}", "\u{1101}\u{1169}\u{11bc}"),
        ("\u{af42}", "\u{af42}", "\u{1101}\u{1169}\u{11bd}", "\u{af42}",
        "\u{1101}\u{1169}\u{11bd}"), ("\u{af43}", "\u{af43}", "\u{1101}\u{1169}\u{11be}",
        "\u{af43}", "\u{1101}\u{1169}\u{11be}"), ("\u{af44}", "\u{af44}",
        "\u{1101}\u{1169}\u{11bf}", "\u{af44}", "\u{1101}\u{1169}\u{11bf}"), ("\u{af45}",
        "\u{af45}", "\u{1101}\u{1169}\u{11c0}", "\u{af45}", "\u{1101}\u{1169}\u{11c0}"),
        ("\u{af46}", "\u{af46}", "\u{1101}\u{1169}\u{11c1}", "\u{af46}",
        "\u{1101}\u{1169}\u{11c1}"), ("\u{af47}", "\u{af47}", "\u{1101}\u{1169}\u{11c2}",
        "\u{af47}", "\u{1101}\u{1169}\u{11c2}"), ("\u{af48}", "\u{af48}", "\u{1101}\u{116a}",
        "\u{af48}", "\u{1101}\u{116a}"), ("\u{af49}", "\u{af49}", "\u{1101}\u{116a}\u{11a8}",
        "\u{af49}", "\u{1101}\u{116a}\u{11a8}"), ("\u{af4a}", "\u{af4a}",
        "\u{1101}\u{116a}\u{11a9}", "\u{af4a}", "\u{1101}\u{116a}\u{11a9}"), ("\u{af4b}",
        "\u{af4b}", "\u{1101}\u{116a}\u{11aa}", "\u{af4b}", "\u{1101}\u{116a}\u{11aa}"),
        ("\u{af4c}", "\u{af4c}", "\u{1101}\u{116a}\u{11ab}", "\u{af4c}",
        "\u{1101}\u{116a}\u{11ab}"), ("\u{af4d}", "\u{af4d}", "\u{1101}\u{116a}\u{11ac}",
        "\u{af4d}", "\u{1101}\u{116a}\u{11ac}"), ("\u{af4e}", "\u{af4e}",
        "\u{1101}\u{116a}\u{11ad}", "\u{af4e}", "\u{1101}\u{116a}\u{11ad}"), ("\u{af4f}",
        "\u{af4f}", "\u{1101}\u{116a}\u{11ae}", "\u{af4f}", "\u{1101}\u{116a}\u{11ae}"),
        ("\u{af50}", "\u{af50}", "\u{1101}\u{116a}\u{11af}", "\u{af50}",
        "\u{1101}\u{116a}\u{11af}"), ("\u{af51}", "\u{af51}", "\u{1101}\u{116a}\u{11b0}",
        "\u{af51}", "\u{1101}\u{116a}\u{11b0}"), ("\u{af52}", "\u{af52}",
        "\u{1101}\u{116a}\u{11b1}", "\u{af52}", "\u{1101}\u{116a}\u{11b1}"), ("\u{af53}",
        "\u{af53}", "\u{1101}\u{116a}\u{11b2}", "\u{af53}", "\u{1101}\u{116a}\u{11b2}"),
        ("\u{af54}", "\u{af54}", "\u{1101}\u{116a}\u{11b3}", "\u{af54}",
        "\u{1101}\u{116a}\u{11b3}"), ("\u{af55}", "\u{af55}", "\u{1101}\u{116a}\u{11b4}",
        "\u{af55}", "\u{1101}\u{116a}\u{11b4}"), ("\u{af56}", "\u{af56}",
        "\u{1101}\u{116a}\u{11b5}", "\u{af56}", "\u{1101}\u{116a}\u{11b5}"), ("\u{af57}",
        "\u{af57}", "\u{1101}\u{116a}\u{11b6}", "\u{af57}", "\u{1101}\u{116a}\u{11b6}"),
        ("\u{af58}", "\u{af58}", "\u{1101}\u{116a}\u{11b7}", "\u{af58}",
        "\u{1101}\u{116a}\u{11b7}"), ("\u{af59}", "\u{af59}", "\u{1101}\u{116a}\u{11b8}",
        "\u{af59}", "\u{1101}\u{116a}\u{11b8}"), ("\u{af5a}", "\u{af5a}",
        "\u{1101}\u{116a}\u{11b9}", "\u{af5a}", "\u{1101}\u{116a}\u{11b9}"), ("\u{af5b}",
        "\u{af5b}", "\u{1101}\u{116a}\u{11ba}", "\u{af5b}", "\u{1101}\u{116a}\u{11ba}"),
        ("\u{af5c}", "\u{af5c}", "\u{1101}\u{116a}\u{11bb}", "\u{af5c}",
        "\u{1101}\u{116a}\u{11bb}"), ("\u{af5d}", "\u{af5d}", "\u{1101}\u{116a}\u{11bc}",
        "\u{af5d}", "\u{1101}\u{116a}\u{11bc}"), ("\u{af5e}", "\u{af5e}",
        "\u{1101}\u{116a}\u{11bd}", "\u{af5e}", "\u{1101}\u{116a}\u{11bd}"), ("\u{af5f}",
        "\u{af5f}", "\u{1101}\u{116a}\u{11be}", "\u{af5f}", "\u{1101}\u{116a}\u{11be}"),
        ("\u{af60}", "\u{af60}", "\u{1101}\u{116a}\u{11bf}", "\u{af60}",
        "\u{1101}\u{116a}\u{11bf}"), ("\u{af61}", "\u{af61}", "\u{1101}\u{116a}\u{11c0}",
        "\u{af61}", "\u{1101}\u{116a}\u{11c0}"), ("\u{af62}", "\u{af62}",
        "\u{1101}\u{116a}\u{11c1}", "\u{af62}", "\u{1101}\u{116a}\u{11c1}"), ("\u{af63}",
        "\u{af63}", "\u{1101}\u{116a}\u{11c2}", "\u{af63}", "\u{1101}\u{116a}\u{11c2}"),
        ("\u{af64}", "\u{af64}", "\u{1101}\u{116b}", "\u{af64}", "\u{1101}\u{116b}"), ("\u{af65}",
        "\u{af65}", "\u{1101}\u{116b}\u{11a8}", "\u{af65}", "\u{1101}\u{116b}\u{11a8}"),
        ("\u{af66}", "\u{af66}", "\u{1101}\u{116b}\u{11a9}", "\u{af66}",
        "\u{1101}\u{116b}\u{11a9}"), ("\u{af67}", "\u{af67}", "\u{1101}\u{116b}\u{11aa}",
        "\u{af67}", "\u{1101}\u{116b}\u{11aa}"), ("\u{af68}", "\u{af68}",
        "\u{1101}\u{116b}\u{11ab}", "\u{af68}", "\u{1101}\u{116b}\u{11ab}"), ("\u{af69}",
        "\u{af69}", "\u{1101}\u{116b}\u{11ac}", "\u{af69}", "\u{1101}\u{116b}\u{11ac}"),
        ("\u{af6a}", "\u{af6a}", "\u{1101}\u{116b}\u{11ad}", "\u{af6a}",
        "\u{1101}\u{116b}\u{11ad}"), ("\u{af6b}", "\u{af6b}", "\u{1101}\u{116b}\u{11ae}",
        "\u{af6b}", "\u{1101}\u{116b}\u{11ae}"), ("\u{af6c}", "\u{af6c}",
        "\u{1101}\u{116b}\u{11af}", "\u{af6c}", "\u{1101}\u{116b}\u{11af}"), ("\u{af6d}",
        "\u{af6d}", "\u{1101}\u{116b}\u{11b0}", "\u{af6d}", "\u{1101}\u{116b}\u{11b0}"),
        ("\u{af6e}", "\u{af6e}", "\u{1101}\u{116b}\u{11b1}", "\u{af6e}",
        "\u{1101}\u{116b}\u{11b1}"), ("\u{af6f}", "\u{af6f}", "\u{1101}\u{116b}\u{11b2}",
        "\u{af6f}", "\u{1101}\u{116b}\u{11b2}"), ("\u{af70}", "\u{af70}",
        "\u{1101}\u{116b}\u{11b3}", "\u{af70}", "\u{1101}\u{116b}\u{11b3}"), ("\u{af71}",
        "\u{af71}", "\u{1101}\u{116b}\u{11b4}", "\u{af71}", "\u{1101}\u{116b}\u{11b4}"),
        ("\u{af72}", "\u{af72}", "\u{1101}\u{116b}\u{11b5}", "\u{af72}",
        "\u{1101}\u{116b}\u{11b5}"), ("\u{af73}", "\u{af73}", "\u{1101}\u{116b}\u{11b6}",
        "\u{af73}", "\u{1101}\u{116b}\u{11b6}"), ("\u{af74}", "\u{af74}",
        "\u{1101}\u{116b}\u{11b7}", "\u{af74}", "\u{1101}\u{116b}\u{11b7}"), ("\u{af75}",
        "\u{af75}", "\u{1101}\u{116b}\u{11b8}", "\u{af75}", "\u{1101}\u{116b}\u{11b8}"),
        ("\u{af76}", "\u{af76}", "\u{1101}\u{116b}\u{11b9}", "\u{af76}",
        "\u{1101}\u{116b}\u{11b9}"), ("\u{af77}", "\u{af77}", "\u{1101}\u{116b}\u{11ba}",
        "\u{af77}", "\u{1101}\u{116b}\u{11ba}"), ("\u{af78}", "\u{af78}",
        "\u{1101}\u{116b}\u{11bb}", "\u{af78}", "\u{1101}\u{116b}\u{11bb}"), ("\u{af79}",
        "\u{af79}", "\u{1101}\u{116b}\u{11bc}", "\u{af79}", "\u{1101}\u{116b}\u{11bc}"),
        ("\u{af7a}", "\u{af7a}", "\u{1101}\u{116b}\u{11bd}", "\u{af7a}",
        "\u{1101}\u{116b}\u{11bd}"), ("\u{af7b}", "\u{af7b}", "\u{1101}\u{116b}\u{11be}",
        "\u{af7b}", "\u{1101}\u{116b}\u{11be}"), ("\u{af7c}", "\u{af7c}",
        "\u{1101}\u{116b}\u{11bf}", "\u{af7c}", "\u{1101}\u{116b}\u{11bf}"), ("\u{af7d}",
        "\u{af7d}", "\u{1101}\u{116b}\u{11c0}", "\u{af7d}", "\u{1101}\u{116b}\u{11c0}"),
        ("\u{af7e}", "\u{af7e}", "\u{1101}\u{116b}\u{11c1}", "\u{af7e}",
        "\u{1101}\u{116b}\u{11c1}"), ("\u{af7f}", "\u{af7f}", "\u{1101}\u{116b}\u{11c2}",
        "\u{af7f}", "\u{1101}\u{116b}\u{11c2}"), ("\u{af80}", "\u{af80}", "\u{1101}\u{116c}",
        "\u{af80}", "\u{1101}\u{116c}"), ("\u{af81}", "\u{af81}", "\u{1101}\u{116c}\u{11a8}",
        "\u{af81}", "\u{1101}\u{116c}\u{11a8}"), ("\u{af82}", "\u{af82}",
        "\u{1101}\u{116c}\u{11a9}", "\u{af82}", "\u{1101}\u{116c}\u{11a9}"), ("\u{af83}",
        "\u{af83}", "\u{1101}\u{116c}\u{11aa}", "\u{af83}", "\u{1101}\u{116c}\u{11aa}"),
        ("\u{af84}", "\u{af84}", "\u{1101}\u{116c}\u{11ab}", "\u{af84}",
        "\u{1101}\u{116c}\u{11ab}"), ("\u{af85}", "\u{af85}", "\u{1101}\u{116c}\u{11ac}",
        "\u{af85}", "\u{1101}\u{116c}\u{11ac}"), ("\u{af86}", "\u{af86}",
        "\u{1101}\u{116c}\u{11ad}", "\u{af86}", "\u{1101}\u{116c}\u{11ad}"), ("\u{af87}",
        "\u{af87}", "\u{1101}\u{116c}\u{11ae}", "\u{af87}", "\u{1101}\u{116c}\u{11ae}"),
        ("\u{af88}", "\u{af88}", "\u{1101}\u{116c}\u{11af}", "\u{af88}",
        "\u{1101}\u{116c}\u{11af}"), ("\u{af89}", "\u{af89}", "\u{1101}\u{116c}\u{11b0}",
        "\u{af89}", "\u{1101}\u{116c}\u{11b0}"), ("\u{af8a}", "\u{af8a}",
        "\u{1101}\u{116c}\u{11b1}", "\u{af8a}", "\u{1101}\u{116c}\u{11b1}"), ("\u{af8b}",
        "\u{af8b}", "\u{1101}\u{116c}\u{11b2}", "\u{af8b}", "\u{1101}\u{116c}\u{11b2}"),
        ("\u{af8c}", "\u{af8c}", "\u{1101}\u{116c}\u{11b3}", "\u{af8c}",
        "\u{1101}\u{116c}\u{11b3}"), ("\u{af8d}", "\u{af8d}", "\u{1101}\u{116c}\u{11b4}",
        "\u{af8d}", "\u{1101}\u{116c}\u{11b4}"), ("\u{af8e}", "\u{af8e}",
        "\u{1101}\u{116c}\u{11b5}", "\u{af8e}", "\u{1101}\u{116c}\u{11b5}"), ("\u{af8f}",
        "\u{af8f}", "\u{1101}\u{116c}\u{11b6}", "\u{af8f}", "\u{1101}\u{116c}\u{11b6}"),
        ("\u{af90}", "\u{af90}", "\u{1101}\u{116c}\u{11b7}", "\u{af90}",
        "\u{1101}\u{116c}\u{11b7}"), ("\u{af91}", "\u{af91}", "\u{1101}\u{116c}\u{11b8}",
        "\u{af91}", "\u{1101}\u{116c}\u{11b8}"), ("\u{af92}", "\u{af92}",
        "\u{1101}\u{116c}\u{11b9}", "\u{af92}", "\u{1101}\u{116c}\u{11b9}"), ("\u{af93}",
        "\u{af93}", "\u{1101}\u{116c}\u{11ba}", "\u{af93}", "\u{1101}\u{116c}\u{11ba}"),
        ("\u{af94}", "\u{af94}", "\u{1101}\u{116c}\u{11bb}", "\u{af94}",
        "\u{1101}\u{116c}\u{11bb}"), ("\u{af95}", "\u{af95}", "\u{1101}\u{116c}\u{11bc}",
        "\u{af95}", "\u{1101}\u{116c}\u{11bc}"), ("\u{af96}", "\u{af96}",
        "\u{1101}\u{116c}\u{11bd}", "\u{af96}", "\u{1101}\u{116c}\u{11bd}"), ("\u{af97}",
        "\u{af97}", "\u{1101}\u{116c}\u{11be}", "\u{af97}", "\u{1101}\u{116c}\u{11be}"),
        ("\u{af98}", "\u{af98}", "\u{1101}\u{116c}\u{11bf}", "\u{af98}",
        "\u{1101}\u{116c}\u{11bf}"), ("\u{af99}", "\u{af99}", "\u{1101}\u{116c}\u{11c0}",
        "\u{af99}", "\u{1101}\u{116c}\u{11c0}"), ("\u{af9a}", "\u{af9a}",
        "\u{1101}\u{116c}\u{11c1}", "\u{af9a}", "\u{1101}\u{116c}\u{11c1}"), ("\u{af9b}",
        "\u{af9b}", "\u{1101}\u{116c}\u{11c2}", "\u{af9b}", "\u{1101}\u{116c}\u{11c2}"),
        ("\u{af9c}", "\u{af9c}", "\u{1101}\u{116d}", "\u{af9c}", "\u{1101}\u{116d}"), ("\u{af9d}",
        "\u{af9d}", "\u{1101}\u{116d}\u{11a8}", "\u{af9d}", "\u{1101}\u{116d}\u{11a8}"),
        ("\u{af9e}", "\u{af9e}", "\u{1101}\u{116d}\u{11a9}", "\u{af9e}",
        "\u{1101}\u{116d}\u{11a9}"), ("\u{af9f}", "\u{af9f}", "\u{1101}\u{116d}\u{11aa}",
        "\u{af9f}", "\u{1101}\u{116d}\u{11aa}"), ("\u{afa0}", "\u{afa0}",
        "\u{1101}\u{116d}\u{11ab}", "\u{afa0}", "\u{1101}\u{116d}\u{11ab}"), ("\u{afa1}",
        "\u{afa1}", "\u{1101}\u{116d}\u{11ac}", "\u{afa1}", "\u{1101}\u{116d}\u{11ac}"),
        ("\u{afa2}", "\u{afa2}", "\u{1101}\u{116d}\u{11ad}", "\u{afa2}",
        "\u{1101}\u{116d}\u{11ad}"), ("\u{afa3}", "\u{afa3}", "\u{1101}\u{116d}\u{11ae}",
        "\u{afa3}", "\u{1101}\u{116d}\u{11ae}"), ("\u{afa4}", "\u{afa4}",
        "\u{1101}\u{116d}\u{11af}", "\u{afa4}", "\u{1101}\u{116d}\u{11af}"), ("\u{afa5}",
        "\u{afa5}", "\u{1101}\u{116d}\u{11b0}", "\u{afa5}", "\u{1101}\u{116d}\u{11b0}"),
        ("\u{afa6}", "\u{afa6}", "\u{1101}\u{116d}\u{11b1}", "\u{afa6}",
        "\u{1101}\u{116d}\u{11b1}"), ("\u{afa7}", "\u{afa7}", "\u{1101}\u{116d}\u{11b2}",
        "\u{afa7}", "\u{1101}\u{116d}\u{11b2}"), ("\u{afa8}", "\u{afa8}",
        "\u{1101}\u{116d}\u{11b3}", "\u{afa8}", "\u{1101}\u{116d}\u{11b3}"), ("\u{afa9}",
        "\u{afa9}", "\u{1101}\u{116d}\u{11b4}", "\u{afa9}", "\u{1101}\u{116d}\u{11b4}"),
        ("\u{afaa}", "\u{afaa}", "\u{1101}\u{116d}\u{11b5}", "\u{afaa}",
        "\u{1101}\u{116d}\u{11b5}"), ("\u{afab}", "\u{afab}", "\u{1101}\u{116d}\u{11b6}",
        "\u{afab}", "\u{1101}\u{116d}\u{11b6}"), ("\u{afac}", "\u{afac}",
        "\u{1101}\u{116d}\u{11b7}", "\u{afac}", "\u{1101}\u{116d}\u{11b7}"), ("\u{afad}",
        "\u{afad}", "\u{1101}\u{116d}\u{11b8}", "\u{afad}", "\u{1101}\u{116d}\u{11b8}"),
        ("\u{afae}", "\u{afae}", "\u{1101}\u{116d}\u{11b9}", "\u{afae}",
        "\u{1101}\u{116d}\u{11b9}"), ("\u{afaf}", "\u{afaf}", "\u{1101}\u{116d}\u{11ba}",
        "\u{afaf}", "\u{1101}\u{116d}\u{11ba}"), ("\u{afb0}", "\u{afb0}",
        "\u{1101}\u{116d}\u{11bb}", "\u{afb0}", "\u{1101}\u{116d}\u{11bb}"), ("\u{afb1}",
        "\u{afb1}", "\u{1101}\u{116d}\u{11bc}", "\u{afb1}", "\u{1101}\u{116d}\u{11bc}"),
        ("\u{afb2}", "\u{afb2}", "\u{1101}\u{116d}\u{11bd}", "\u{afb2}",
        "\u{1101}\u{116d}\u{11bd}"), ("\u{afb3}", "\u{afb3}", "\u{1101}\u{116d}\u{11be}",
        "\u{afb3}", "\u{1101}\u{116d}\u{11be}"), ("\u{afb4}", "\u{afb4}",
        "\u{1101}\u{116d}\u{11bf}", "\u{afb4}", "\u{1101}\u{116d}\u{11bf}"), ("\u{afb5}",
        "\u{afb5}", "\u{1101}\u{116d}\u{11c0}", "\u{afb5}", "\u{1101}\u{116d}\u{11c0}"),
        ("\u{afb6}", "\u{afb6}", "\u{1101}\u{116d}\u{11c1}", "\u{afb6}",
        "\u{1101}\u{116d}\u{11c1}"), ("\u{afb7}", "\u{afb7}", "\u{1101}\u{116d}\u{11c2}",
        "\u{afb7}", "\u{1101}\u{116d}\u{11c2}"), ("\u{afb8}", "\u{afb8}", "\u{1101}\u{116e}",
        "\u{afb8}", "\u{1101}\u{116e}"), ("\u{afb9}", "\u{afb9}", "\u{1101}\u{116e}\u{11a8}",
        "\u{afb9}", "\u{1101}\u{116e}\u{11a8}"), ("\u{afba}", "\u{afba}",
        "\u{1101}\u{116e}\u{11a9}", "\u{afba}", "\u{1101}\u{116e}\u{11a9}"), ("\u{afbb}",
        "\u{afbb}", "\u{1101}\u{116e}\u{11aa}", "\u{afbb}", "\u{1101}\u{116e}\u{11aa}"),
        ("\u{afbc}", "\u{afbc}", "\u{1101}\u{116e}\u{11ab}", "\u{afbc}",
        "\u{1101}\u{116e}\u{11ab}"), ("\u{afbd}", "\u{afbd}", "\u{1101}\u{116e}\u{11ac}",
        "\u{afbd}", "\u{1101}\u{116e}\u{11ac}"), ("\u{afbe}", "\u{afbe}",
        "\u{1101}\u{116e}\u{11ad}", "\u{afbe}", "\u{1101}\u{116e}\u{11ad}"), ("\u{afbf}",
        "\u{afbf}", "\u{1101}\u{116e}\u{11ae}", "\u{afbf}", "\u{1101}\u{116e}\u{11ae}"),
        ("\u{afc0}", "\u{afc0}", "\u{1101}\u{116e}\u{11af}", "\u{afc0}",
        "\u{1101}\u{116e}\u{11af}"), ("\u{afc1}", "\u{afc1}", "\u{1101}\u{116e}\u{11b0}",
        "\u{afc1}", "\u{1101}\u{116e}\u{11b0}"), ("\u{afc2}", "\u{afc2}",
        "\u{1101}\u{116e}\u{11b1}", "\u{afc2}", "\u{1101}\u{116e}\u{11b1}"), ("\u{afc3}",
        "\u{afc3}", "\u{1101}\u{116e}\u{11b2}", "\u{afc3}", "\u{1101}\u{116e}\u{11b2}"),
        ("\u{afc4}", "\u{afc4}", "\u{1101}\u{116e}\u{11b3}", "\u{afc4}",
        "\u{1101}\u{116e}\u{11b3}"), ("\u{afc5}", "\u{afc5}", "\u{1101}\u{116e}\u{11b4}",
        "\u{afc5}", "\u{1101}\u{116e}\u{11b4}"), ("\u{afc6}", "\u{afc6}",
        "\u{1101}\u{116e}\u{11b5}", "\u{afc6}", "\u{1101}\u{116e}\u{11b5}"), ("\u{afc7}",
        "\u{afc7}", "\u{1101}\u{116e}\u{11b6}", "\u{afc7}", "\u{1101}\u{116e}\u{11b6}"),
        ("\u{afc8}", "\u{afc8}", "\u{1101}\u{116e}\u{11b7}", "\u{afc8}",
        "\u{1101}\u{116e}\u{11b7}"), ("\u{afc9}", "\u{afc9}", "\u{1101}\u{116e}\u{11b8}",
        "\u{afc9}", "\u{1101}\u{116e}\u{11b8}"), ("\u{afca}", "\u{afca}",
        "\u{1101}\u{116e}\u{11b9}", "\u{afca}", "\u{1101}\u{116e}\u{11b9}"), ("\u{afcb}",
        "\u{afcb}", "\u{1101}\u{116e}\u{11ba}", "\u{afcb}", "\u{1101}\u{116e}\u{11ba}"),
        ("\u{afcc}", "\u{afcc}", "\u{1101}\u{116e}\u{11bb}", "\u{afcc}",
        "\u{1101}\u{116e}\u{11bb}"), ("\u{afcd}", "\u{afcd}", "\u{1101}\u{116e}\u{11bc}",
        "\u{afcd}", "\u{1101}\u{116e}\u{11bc}"), ("\u{afce}", "\u{afce}",
        "\u{1101}\u{116e}\u{11bd}", "\u{afce}", "\u{1101}\u{116e}\u{11bd}"), ("\u{afcf}",
        "\u{afcf}", "\u{1101}\u{116e}\u{11be}", "\u{afcf}", "\u{1101}\u{116e}\u{11be}"),
        ("\u{afd0}", "\u{afd0}", "\u{1101}\u{116e}\u{11bf}", "\u{afd0}",
        "\u{1101}\u{116e}\u{11bf}"), ("\u{afd1}", "\u{afd1}", "\u{1101}\u{116e}\u{11c0}",
        "\u{afd1}", "\u{1101}\u{116e}\u{11c0}"), ("\u{afd2}", "\u{afd2}",
        "\u{1101}\u{116e}\u{11c1}", "\u{afd2}", "\u{1101}\u{116e}\u{11c1}"), ("\u{afd3}",
        "\u{afd3}", "\u{1101}\u{116e}\u{11c2}", "\u{afd3}", "\u{1101}\u{116e}\u{11c2}"),
        ("\u{afd4}", "\u{afd4}", "\u{1101}\u{116f}", "\u{afd4}", "\u{1101}\u{116f}"), ("\u{afd5}",
        "\u{afd5}", "\u{1101}\u{116f}\u{11a8}", "\u{afd5}", "\u{1101}\u{116f}\u{11a8}"),
        ("\u{afd6}", "\u{afd6}", "\u{1101}\u{116f}\u{11a9}", "\u{afd6}",
        "\u{1101}\u{116f}\u{11a9}"), ("\u{afd7}", "\u{afd7}", "\u{1101}\u{116f}\u{11aa}",
        "\u{afd7}", "\u{1101}\u{116f}\u{11aa}"), ("\u{afd8}", "\u{afd8}",
        "\u{1101}\u{116f}\u{11ab}", "\u{afd8}", "\u{1101}\u{116f}\u{11ab}"), ("\u{afd9}",
        "\u{afd9}", "\u{1101}\u{116f}\u{11ac}", "\u{afd9}", "\u{1101}\u{116f}\u{11ac}"),
        ("\u{afda}", "\u{afda}", "\u{1101}\u{116f}\u{11ad}", "\u{afda}",
        "\u{1101}\u{116f}\u{11ad}"), ("\u{afdb}", "\u{afdb}", "\u{1101}\u{116f}\u{11ae}",
        "\u{afdb}", "\u{1101}\u{116f}\u{11ae}"), ("\u{afdc}", "\u{afdc}",
        "\u{1101}\u{116f}\u{11af}", "\u{afdc}", "\u{1101}\u{116f}\u{11af}"), ("\u{afdd}",
        "\u{afdd}", "\u{1101}\u{116f}\u{11b0}", "\u{afdd}", "\u{1101}\u{116f}\u{11b0}"),
        ("\u{afde}", "\u{afde}", "\u{1101}\u{116f}\u{11b1}", "\u{afde}",
        "\u{1101}\u{116f}\u{11b1}"), ("\u{afdf}", "\u{afdf}", "\u{1101}\u{116f}\u{11b2}",
        "\u{afdf}", "\u{1101}\u{116f}\u{11b2}"), ("\u{afe0}", "\u{afe0}",
        "\u{1101}\u{116f}\u{11b3}", "\u{afe0}", "\u{1101}\u{116f}\u{11b3}"), ("\u{afe1}",
        "\u{afe1}", "\u{1101}\u{116f}\u{11b4}", "\u{afe1}", "\u{1101}\u{116f}\u{11b4}"),
        ("\u{afe2}", "\u{afe2}", "\u{1101}\u{116f}\u{11b5}", "\u{afe2}",
        "\u{1101}\u{116f}\u{11b5}"), ("\u{afe3}", "\u{afe3}", "\u{1101}\u{116f}\u{11b6}",
        "\u{afe3}", "\u{1101}\u{116f}\u{11b6}"), ("\u{afe4}", "\u{afe4}",
        "\u{1101}\u{116f}\u{11b7}", "\u{afe4}", "\u{1101}\u{116f}\u{11b7}"), ("\u{afe5}",
        "\u{afe5}", "\u{1101}\u{116f}\u{11b8}", "\u{afe5}", "\u{1101}\u{116f}\u{11b8}"),
        ("\u{afe6}", "\u{afe6}", "\u{1101}\u{116f}\u{11b9}", "\u{afe6}",
        "\u{1101}\u{116f}\u{11b9}"), ("\u{afe7}", "\u{afe7}", "\u{1101}\u{116f}\u{11ba}",
        "\u{afe7}", "\u{1101}\u{116f}\u{11ba}"), ("\u{afe8}", "\u{afe8}",
        "\u{1101}\u{116f}\u{11bb}", "\u{afe8}", "\u{1101}\u{116f}\u{11bb}"), ("\u{afe9}",
        "\u{afe9}", "\u{1101}\u{116f}\u{11bc}", "\u{afe9}", "\u{1101}\u{116f}\u{11bc}"),
        ("\u{afea}", "\u{afea}", "\u{1101}\u{116f}\u{11bd}", "\u{afea}",
        "\u{1101}\u{116f}\u{11bd}"), ("\u{afeb}", "\u{afeb}", "\u{1101}\u{116f}\u{11be}",
        "\u{afeb}", "\u{1101}\u{116f}\u{11be}"), ("\u{afec}", "\u{afec}",
        "\u{1101}\u{116f}\u{11bf}", "\u{afec}", "\u{1101}\u{116f}\u{11bf}"), ("\u{afed}",
        "\u{afed}", "\u{1101}\u{116f}\u{11c0}", "\u{afed}", "\u{1101}\u{116f}\u{11c0}"),
        ("\u{afee}", "\u{afee}", "\u{1101}\u{116f}\u{11c1}", "\u{afee}",
        "\u{1101}\u{116f}\u{11c1}"), ("\u{afef}", "\u{afef}", "\u{1101}\u{116f}\u{11c2}",
        "\u{afef}", "\u{1101}\u{116f}\u{11c2}"), ("\u{aff0}", "\u{aff0}", "\u{1101}\u{1170}",
        "\u{aff0}", "\u{1101}\u{1170}"), ("\u{aff1}", "\u{aff1}", "\u{1101}\u{1170}\u{11a8}",
        "\u{aff1}", "\u{1101}\u{1170}\u{11a8}"), ("\u{aff2}", "\u{aff2}",
        "\u{1101}\u{1170}\u{11a9}", "\u{aff2}", "\u{1101}\u{1170}\u{11a9}"), ("\u{aff3}",
        "\u{aff3}", "\u{1101}\u{1170}\u{11aa}", "\u{aff3}", "\u{1101}\u{1170}\u{11aa}"),
        ("\u{aff4}", "\u{aff4}", "\u{1101}\u{1170}\u{11ab}", "\u{aff4}",
        "\u{1101}\u{1170}\u{11ab}"), ("\u{aff5}", "\u{aff5}", "\u{1101}\u{1170}\u{11ac}",
        "\u{aff5}", "\u{1101}\u{1170}\u{11ac}"), ("\u{aff6}", "\u{aff6}",
        "\u{1101}\u{1170}\u{11ad}", "\u{aff6}", "\u{1101}\u{1170}\u{11ad}"), ("\u{aff7}",
        "\u{aff7}", "\u{1101}\u{1170}\u{11ae}", "\u{aff7}", "\u{1101}\u{1170}\u{11ae}"),
        ("\u{aff8}", "\u{aff8}", "\u{1101}\u{1170}\u{11af}", "\u{aff8}",
        "\u{1101}\u{1170}\u{11af}"), ("\u{aff9}", "\u{aff9}", "\u{1101}\u{1170}\u{11b0}",
        "\u{aff9}", "\u{1101}\u{1170}\u{11b0}"), ("\u{affa}", "\u{affa}",
        "\u{1101}\u{1170}\u{11b1}", "\u{affa}", "\u{1101}\u{1170}\u{11b1}"), ("\u{affb}",
        "\u{affb}", "\u{1101}\u{1170}\u{11b2}", "\u{affb}", "\u{1101}\u{1170}\u{11b2}"),
        ("\u{affc}", "\u{affc}", "\u{1101}\u{1170}\u{11b3}", "\u{affc}",
        "\u{1101}\u{1170}\u{11b3}"), ("\u{affd}", "\u{affd}", "\u{1101}\u{1170}\u{11b4}",
        "\u{affd}", "\u{1101}\u{1170}\u{11b4}"), ("\u{affe}", "\u{affe}",
        "\u{1101}\u{1170}\u{11b5}", "\u{affe}", "\u{1101}\u{1170}\u{11b5}"), ("\u{afff}",
        "\u{afff}", "\u{1101}\u{1170}\u{11b6}", "\u{afff}", "\u{1101}\u{1170}\u{11b6}"),
        ("\u{b000}", "\u{b000}", "\u{1101}\u{1170}\u{11b7}", "\u{b000}",
        "\u{1101}\u{1170}\u{11b7}"), ("\u{b001}", "\u{b001}", "\u{1101}\u{1170}\u{11b8}",
        "\u{b001}", "\u{1101}\u{1170}\u{11b8}"), ("\u{b002}", "\u{b002}",
        "\u{1101}\u{1170}\u{11b9}", "\u{b002}", "\u{1101}\u{1170}\u{11b9}"), ("\u{b003}",
        "\u{b003}", "\u{1101}\u{1170}\u{11ba}", "\u{b003}", "\u{1101}\u{1170}\u{11ba}"),
        ("\u{b004}", "\u{b004}", "\u{1101}\u{1170}\u{11bb}", "\u{b004}",
        "\u{1101}\u{1170}\u{11bb}"), ("\u{b005}", "\u{b005}", "\u{1101}\u{1170}\u{11bc}",
        "\u{b005}", "\u{1101}\u{1170}\u{11bc}"), ("\u{b006}", "\u{b006}",
        "\u{1101}\u{1170}\u{11bd}", "\u{b006}", "\u{1101}\u{1170}\u{11bd}"), ("\u{b007}",
        "\u{b007}", "\u{1101}\u{1170}\u{11be}", "\u{b007}", "\u{1101}\u{1170}\u{11be}"),
        ("\u{b008}", "\u{b008}", "\u{1101}\u{1170}\u{11bf}", "\u{b008}",
        "\u{1101}\u{1170}\u{11bf}"), ("\u{b009}", "\u{b009}", "\u{1101}\u{1170}\u{11c0}",
        "\u{b009}", "\u{1101}\u{1170}\u{11c0}"), ("\u{b00a}", "\u{b00a}",
        "\u{1101}\u{1170}\u{11c1}", "\u{b00a}", "\u{1101}\u{1170}\u{11c1}"), ("\u{b00b}",
        "\u{b00b}", "\u{1101}\u{1170}\u{11c2}", "\u{b00b}", "\u{1101}\u{1170}\u{11c2}"),
        ("\u{b00c}", "\u{b00c}", "\u{1101}\u{1171}", "\u{b00c}", "\u{1101}\u{1171}"), ("\u{b00d}",
        "\u{b00d}", "\u{1101}\u{1171}\u{11a8}", "\u{b00d}", "\u{1101}\u{1171}\u{11a8}"),
        ("\u{b00e}", "\u{b00e}", "\u{1101}\u{1171}\u{11a9}", "\u{b00e}",
        "\u{1101}\u{1171}\u{11a9}"), ("\u{b00f}", "\u{b00f}", "\u{1101}\u{1171}\u{11aa}",
        "\u{b00f}", "\u{1101}\u{1171}\u{11aa}"), ("\u{b010}", "\u{b010}",
        "\u{1101}\u{1171}\u{11ab}", "\u{b010}", "\u{1101}\u{1171}\u{11ab}"), ("\u{b011}",
        "\u{b011}", "\u{1101}\u{1171}\u{11ac}", "\u{b011}", "\u{1101}\u{1171}\u{11ac}"),
        ("\u{b012}", "\u{b012}", "\u{1101}\u{1171}\u{11ad}", "\u{b012}",
        "\u{1101}\u{1171}\u{11ad}"), ("\u{b013}", "\u{b013}", "\u{1101}\u{1171}\u{11ae}",
        "\u{b013}", "\u{1101}\u{1171}\u{11ae}"), ("\u{b014}", "\u{b014}",
        "\u{1101}\u{1171}\u{11af}", "\u{b014}", "\u{1101}\u{1171}\u{11af}"), ("\u{b015}",
        "\u{b015}", "\u{1101}\u{1171}\u{11b0}", "\u{b015}", "\u{1101}\u{1171}\u{11b0}"),
        ("\u{b016}", "\u{b016}", "\u{1101}\u{1171}\u{11b1}", "\u{b016}",
        "\u{1101}\u{1171}\u{11b1}"), ("\u{b017}", "\u{b017}", "\u{1101}\u{1171}\u{11b2}",
        "\u{b017}", "\u{1101}\u{1171}\u{11b2}"), ("\u{b018}", "\u{b018}",
        "\u{1101}\u{1171}\u{11b3}", "\u{b018}", "\u{1101}\u{1171}\u{11b3}"), ("\u{b019}",
        "\u{b019}", "\u{1101}\u{1171}\u{11b4}", "\u{b019}", "\u{1101}\u{1171}\u{11b4}"),
        ("\u{b01a}", "\u{b01a}", "\u{1101}\u{1171}\u{11b5}", "\u{b01a}",
        "\u{1101}\u{1171}\u{11b5}"), ("\u{b01b}", "\u{b01b}", "\u{1101}\u{1171}\u{11b6}",
        "\u{b01b}", "\u{1101}\u{1171}\u{11b6}"), ("\u{b01c}", "\u{b01c}",
        "\u{1101}\u{1171}\u{11b7}", "\u{b01c}", "\u{1101}\u{1171}\u{11b7}"), ("\u{b01d}",
        "\u{b01d}", "\u{1101}\u{1171}\u{11b8}", "\u{b01d}", "\u{1101}\u{1171}\u{11b8}"),
        ("\u{b01e}", "\u{b01e}", "\u{1101}\u{1171}\u{11b9}", "\u{b01e}",
        "\u{1101}\u{1171}\u{11b9}"), ("\u{b01f}", "\u{b01f}", "\u{1101}\u{1171}\u{11ba}",
        "\u{b01f}", "\u{1101}\u{1171}\u{11ba}"), ("\u{b020}", "\u{b020}",
        "\u{1101}\u{1171}\u{11bb}", "\u{b020}", "\u{1101}\u{1171}\u{11bb}"), ("\u{b021}",
        "\u{b021}", "\u{1101}\u{1171}\u{11bc}", "\u{b021}", "\u{1101}\u{1171}\u{11bc}"),
        ("\u{b022}", "\u{b022}", "\u{1101}\u{1171}\u{11bd}", "\u{b022}",
        "\u{1101}\u{1171}\u{11bd}"), ("\u{b023}", "\u{b023}", "\u{1101}\u{1171}\u{11be}",
        "\u{b023}", "\u{1101}\u{1171}\u{11be}"), ("\u{b024}", "\u{b024}",
        "\u{1101}\u{1171}\u{11bf}", "\u{b024}", "\u{1101}\u{1171}\u{11bf}"), ("\u{b025}",
        "\u{b025}", "\u{1101}\u{1171}\u{11c0}", "\u{b025}", "\u{1101}\u{1171}\u{11c0}"),
        ("\u{b026}", "\u{b026}", "\u{1101}\u{1171}\u{11c1}", "\u{b026}",
        "\u{1101}\u{1171}\u{11c1}"), ("\u{b027}", "\u{b027}", "\u{1101}\u{1171}\u{11c2}",
        "\u{b027}", "\u{1101}\u{1171}\u{11c2}"), ("\u{b028}", "\u{b028}", "\u{1101}\u{1172}",
        "\u{b028}", "\u{1101}\u{1172}"), ("\u{b029}", "\u{b029}", "\u{1101}\u{1172}\u{11a8}",
        "\u{b029}", "\u{1101}\u{1172}\u{11a8}"), ("\u{b02a}", "\u{b02a}",
        "\u{1101}\u{1172}\u{11a9}", "\u{b02a}", "\u{1101}\u{1172}\u{11a9}"), ("\u{b02b}",
        "\u{b02b}", "\u{1101}\u{1172}\u{11aa}", "\u{b02b}", "\u{1101}\u{1172}\u{11aa}"),
        ("\u{b02c}", "\u{b02c}", "\u{1101}\u{1172}\u{11ab}", "\u{b02c}",
        "\u{1101}\u{1172}\u{11ab}"), ("\u{b02d}", "\u{b02d}", "\u{1101}\u{1172}\u{11ac}",
        "\u{b02d}", "\u{1101}\u{1172}\u{11ac}"), ("\u{b02e}", "\u{b02e}",
        "\u{1101}\u{1172}\u{11ad}", "\u{b02e}", "\u{1101}\u{1172}\u{11ad}"), ("\u{b02f}",
        "\u{b02f}", "\u{1101}\u{1172}\u{11ae}", "\u{b02f}", "\u{1101}\u{1172}\u{11ae}"),
        ("\u{b030}", "\u{b030}", "\u{1101}\u{1172}\u{11af}", "\u{b030}",
        "\u{1101}\u{1172}\u{11af}"), ("\u{b031}", "\u{b031}", "\u{1101}\u{1172}\u{11b0}",
        "\u{b031}", "\u{1101}\u{1172}\u{11b0}"), ("\u{b032}", "\u{b032}",
        "\u{1101}\u{1172}\u{11b1}", "\u{b032}", "\u{1101}\u{1172}\u{11b1}"), ("\u{b033}",
        "\u{b033}", "\u{1101}\u{1172}\u{11b2}", "\u{b033}", "\u{1101}\u{1172}\u{11b2}"),
        ("\u{b034}", "\u{b034}", "\u{1101}\u{1172}\u{11b3}", "\u{b034}",
        "\u{1101}\u{1172}\u{11b3}"), ("\u{b035}", "\u{b035}", "\u{1101}\u{1172}\u{11b4}",
        "\u{b035}", "\u{1101}\u{1172}\u{11b4}"), ("\u{b036}", "\u{b036}",
        "\u{1101}\u{1172}\u{11b5}", "\u{b036}", "\u{1101}\u{1172}\u{11b5}"), ("\u{b037}",
        "\u{b037}", "\u{1101}\u{1172}\u{11b6}", "\u{b037}", "\u{1101}\u{1172}\u{11b6}"),
        ("\u{b038}", "\u{b038}", "\u{1101}\u{1172}\u{11b7}", "\u{b038}",
        "\u{1101}\u{1172}\u{11b7}"), ("\u{b039}", "\u{b039}", "\u{1101}\u{1172}\u{11b8}",
        "\u{b039}", "\u{1101}\u{1172}\u{11b8}"), ("\u{b03a}", "\u{b03a}",
        "\u{1101}\u{1172}\u{11b9}", "\u{b03a}", "\u{1101}\u{1172}\u{11b9}"), ("\u{b03b}",
        "\u{b03b}", "\u{1101}\u{1172}\u{11ba}", "\u{b03b}", "\u{1101}\u{1172}\u{11ba}"),
        ("\u{b03c}", "\u{b03c}", "\u{1101}\u{1172}\u{11bb}", "\u{b03c}",
        "\u{1101}\u{1172}\u{11bb}"), ("\u{b03d}", "\u{b03d}", "\u{1101}\u{1172}\u{11bc}",
        "\u{b03d}", "\u{1101}\u{1172}\u{11bc}"), ("\u{b03e}", "\u{b03e}",
        "\u{1101}\u{1172}\u{11bd}", "\u{b03e}", "\u{1101}\u{1172}\u{11bd}"), ("\u{b03f}",
        "\u{b03f}", "\u{1101}\u{1172}\u{11be}", "\u{b03f}", "\u{1101}\u{1172}\u{11be}"),
        ("\u{b040}", "\u{b040}", "\u{1101}\u{1172}\u{11bf}", "\u{b040}",
        "\u{1101}\u{1172}\u{11bf}"), ("\u{b041}", "\u{b041}", "\u{1101}\u{1172}\u{11c0}",
        "\u{b041}", "\u{1101}\u{1172}\u{11c0}"), ("\u{b042}", "\u{b042}",
        "\u{1101}\u{1172}\u{11c1}", "\u{b042}", "\u{1101}\u{1172}\u{11c1}"), ("\u{b043}",
        "\u{b043}", "\u{1101}\u{1172}\u{11c2}", "\u{b043}", "\u{1101}\u{1172}\u{11c2}"),
        ("\u{b044}", "\u{b044}", "\u{1101}\u{1173}", "\u{b044}", "\u{1101}\u{1173}"), ("\u{b045}",
        "\u{b045}", "\u{1101}\u{1173}\u{11a8}", "\u{b045}", "\u{1101}\u{1173}\u{11a8}"),
        ("\u{b046}", "\u{b046}", "\u{1101}\u{1173}\u{11a9}", "\u{b046}",
        "\u{1101}\u{1173}\u{11a9}"), ("\u{b047}", "\u{b047}", "\u{1101}\u{1173}\u{11aa}",
        "\u{b047}", "\u{1101}\u{1173}\u{11aa}"), ("\u{b048}", "\u{b048}",
        "\u{1101}\u{1173}\u{11ab}", "\u{b048}", "\u{1101}\u{1173}\u{11ab}"), ("\u{b049}",
        "\u{b049}", "\u{1101}\u{1173}\u{11ac}", "\u{b049}", "\u{1101}\u{1173}\u{11ac}"),
        ("\u{b04a}", "\u{b04a}", "\u{1101}\u{1173}\u{11ad}", "\u{b04a}",
        "\u{1101}\u{1173}\u{11ad}"), ("\u{b04b}", "\u{b04b}", "\u{1101}\u{1173}\u{11ae}",
        "\u{b04b}", "\u{1101}\u{1173}\u{11ae}"), ("\u{b04c}", "\u{b04c}",
        "\u{1101}\u{1173}\u{11af}", "\u{b04c}", "\u{1101}\u{1173}\u{11af}"), ("\u{b04d}",
        "\u{b04d}", "\u{1101}\u{1173}\u{11b0}", "\u{b04d}", "\u{1101}\u{1173}\u{11b0}"),
        ("\u{b04e}", "\u{b04e}", "\u{1101}\u{1173}\u{11b1}", "\u{b04e}",
        "\u{1101}\u{1173}\u{11b1}"), ("\u{b04f}", "\u{b04f}", "\u{1101}\u{1173}\u{11b2}",
        "\u{b04f}", "\u{1101}\u{1173}\u{11b2}"), ("\u{b050}", "\u{b050}",
        "\u{1101}\u{1173}\u{11b3}", "\u{b050}", "\u{1101}\u{1173}\u{11b3}"), ("\u{b051}",
        "\u{b051}", "\u{1101}\u{1173}\u{11b4}", "\u{b051}", "\u{1101}\u{1173}\u{11b4}"),
        ("\u{b052}", "\u{b052}", "\u{1101}\u{1173}\u{11b5}", "\u{b052}",
        "\u{1101}\u{1173}\u{11b5}"), ("\u{b053}", "\u{b053}", "\u{1101}\u{1173}\u{11b6}",
        "\u{b053}", "\u{1101}\u{1173}\u{11b6}"), ("\u{b054}", "\u{b054}",
        "\u{1101}\u{1173}\u{11b7}", "\u{b054}", "\u{1101}\u{1173}\u{11b7}"), ("\u{b055}",
        "\u{b055}", "\u{1101}\u{1173}\u{11b8}", "\u{b055}", "\u{1101}\u{1173}\u{11b8}"),
        ("\u{b056}", "\u{b056}", "\u{1101}\u{1173}\u{11b9}", "\u{b056}",
        "\u{1101}\u{1173}\u{11b9}"), ("\u{b057}", "\u{b057}", "\u{1101}\u{1173}\u{11ba}",
        "\u{b057}", "\u{1101}\u{1173}\u{11ba}"), ("\u{b058}", "\u{b058}",
        "\u{1101}\u{1173}\u{11bb}", "\u{b058}", "\u{1101}\u{1173}\u{11bb}"), ("\u{b059}",
        "\u{b059}", "\u{1101}\u{1173}\u{11bc}", "\u{b059}", "\u{1101}\u{1173}\u{11bc}"),
        ("\u{b05a}", "\u{b05a}", "\u{1101}\u{1173}\u{11bd}", "\u{b05a}",
        "\u{1101}\u{1173}\u{11bd}"), ("\u{b05b}", "\u{b05b}", "\u{1101}\u{1173}\u{11be}",
        "\u{b05b}", "\u{1101}\u{1173}\u{11be}"), ("\u{b05c}", "\u{b05c}",
        "\u{1101}\u{1173}\u{11bf}", "\u{b05c}", "\u{1101}\u{1173}\u{11bf}"), ("\u{b05d}",
        "\u{b05d}", "\u{1101}\u{1173}\u{11c0}", "\u{b05d}", "\u{1101}\u{1173}\u{11c0}"),
        ("\u{b05e}", "\u{b05e}", "\u{1101}\u{1173}\u{11c1}", "\u{b05e}",
        "\u{1101}\u{1173}\u{11c1}"), ("\u{b05f}", "\u{b05f}", "\u{1101}\u{1173}\u{11c2}",
        "\u{b05f}", "\u{1101}\u{1173}\u{11c2}"), ("\u{b060}", "\u{b060}", "\u{1101}\u{1174}",
        "\u{b060}", "\u{1101}\u{1174}"), ("\u{b061}", "\u{b061}", "\u{1101}\u{1174}\u{11a8}",
        "\u{b061}", "\u{1101}\u{1174}\u{11a8}"), ("\u{b062}", "\u{b062}",
        "\u{1101}\u{1174}\u{11a9}", "\u{b062}", "\u{1101}\u{1174}\u{11a9}"), ("\u{b063}",
        "\u{b063}", "\u{1101}\u{1174}\u{11aa}", "\u{b063}", "\u{1101}\u{1174}\u{11aa}"),
        ("\u{b064}", "\u{b064}", "\u{1101}\u{1174}\u{11ab}", "\u{b064}",
        "\u{1101}\u{1174}\u{11ab}"), ("\u{b065}", "\u{b065}", "\u{1101}\u{1174}\u{11ac}",
        "\u{b065}", "\u{1101}\u{1174}\u{11ac}"), ("\u{b066}", "\u{b066}",
        "\u{1101}\u{1174}\u{11ad}", "\u{b066}", "\u{1101}\u{1174}\u{11ad}"), ("\u{b067}",
        "\u{b067}", "\u{1101}\u{1174}\u{11ae}", "\u{b067}", "\u{1101}\u{1174}\u{11ae}"),
        ("\u{b068}", "\u{b068}", "\u{1101}\u{1174}\u{11af}", "\u{b068}",
        "\u{1101}\u{1174}\u{11af}"), ("\u{b069}", "\u{b069}", "\u{1101}\u{1174}\u{11b0}",
        "\u{b069}", "\u{1101}\u{1174}\u{11b0}"), ("\u{b06a}", "\u{b06a}",
        "\u{1101}\u{1174}\u{11b1}", "\u{b06a}", "\u{1101}\u{1174}\u{11b1}"), ("\u{b06b}",
        "\u{b06b}", "\u{1101}\u{1174}\u{11b2}", "\u{b06b}", "\u{1101}\u{1174}\u{11b2}"),
        ("\u{b06c}", "\u{b06c}", "\u{1101}\u{1174}\u{11b3}", "\u{b06c}",
        "\u{1101}\u{1174}\u{11b3}"), ("\u{b06d}", "\u{b06d}", "\u{1101}\u{1174}\u{11b4}",
        "\u{b06d}", "\u{1101}\u{1174}\u{11b4}"), ("\u{b06e}", "\u{b06e}",
        "\u{1101}\u{1174}\u{11b5}", "\u{b06e}", "\u{1101}\u{1174}\u{11b5}"), ("\u{b06f}",
        "\u{b06f}", "\u{1101}\u{1174}\u{11b6}", "\u{b06f}", "\u{1101}\u{1174}\u{11b6}"),
        ("\u{b070}", "\u{b070}", "\u{1101}\u{1174}\u{11b7}", "\u{b070}",
        "\u{1101}\u{1174}\u{11b7}"), ("\u{b071}", "\u{b071}", "\u{1101}\u{1174}\u{11b8}",
        "\u{b071}", "\u{1101}\u{1174}\u{11b8}"), ("\u{b072}", "\u{b072}",
        "\u{1101}\u{1174}\u{11b9}", "\u{b072}", "\u{1101}\u{1174}\u{11b9}"), ("\u{b073}",
        "\u{b073}", "\u{1101}\u{1174}\u{11ba}", "\u{b073}", "\u{1101}\u{1174}\u{11ba}"),
        ("\u{b074}", "\u{b074}", "\u{1101}\u{1174}\u{11bb}", "\u{b074}",
        "\u{1101}\u{1174}\u{11bb}"), ("\u{b075}", "\u{b075}", "\u{1101}\u{1174}\u{11bc}",
        "\u{b075}", "\u{1101}\u{1174}\u{11bc}"), ("\u{b076}", "\u{b076}",
        "\u{1101}\u{1174}\u{11bd}", "\u{b076}", "\u{1101}\u{1174}\u{11bd}"), ("\u{b077}",
        "\u{b077}", "\u{1101}\u{1174}\u{11be}", "\u{b077}", "\u{1101}\u{1174}\u{11be}"),
        ("\u{b078}", "\u{b078}", "\u{1101}\u{1174}\u{11bf}", "\u{b078}",
        "\u{1101}\u{1174}\u{11bf}"), ("\u{b079}", "\u{b079}", "\u{1101}\u{1174}\u{11c0}",
        "\u{b079}", "\u{1101}\u{1174}\u{11c0}"), ("\u{b07a}", "\u{b07a}",
        "\u{1101}\u{1174}\u{11c1}", "\u{b07a}", "\u{1101}\u{1174}\u{11c1}"), ("\u{b07b}",
        "\u{b07b}", "\u{1101}\u{1174}\u{11c2}", "\u{b07b}", "\u{1101}\u{1174}\u{11c2}"),
        ("\u{b07c}", "\u{b07c}", "\u{1101}\u{1175}", "\u{b07c}", "\u{1101}\u{1175}"), ("\u{b07d}",
        "\u{b07d}", "\u{1101}\u{1175}\u{11a8}", "\u{b07d}", "\u{1101}\u{1175}\u{11a8}"),
        ("\u{b07e}", "\u{b07e}", "\u{1101}\u{1175}\u{11a9}", "\u{b07e}",
        "\u{1101}\u{1175}\u{11a9}"), ("\u{b07f}", "\u{b07f}", "\u{1101}\u{1175}\u{11aa}",
        "\u{b07f}", "\u{1101}\u{1175}\u{11aa}"), ("\u{b080}", "\u{b080}",
        "\u{1101}\u{1175}\u{11ab}", "\u{b080}", "\u{1101}\u{1175}\u{11ab}"), ("\u{b081}",
        "\u{b081}", "\u{1101}\u{1175}\u{11ac}", "\u{b081}", "\u{1101}\u{1175}\u{11ac}"),
        ("\u{b082}", "\u{b082}", "\u{1101}\u{1175}\u{11ad}", "\u{b082}",
        "\u{1101}\u{1175}\u{11ad}"), ("\u{b083}", "\u{b083}", "\u{1101}\u{1175}\u{11ae}",
        "\u{b083}", "\u{1101}\u{1175}\u{11ae}"), ("\u{b084}", "\u{b084}",
        "\u{1101}\u{1175}\u{11af}", "\u{b084}", "\u{1101}\u{1175}\u{11af}"), ("\u{b085}",
        "\u{b085}", "\u{1101}\u{1175}\u{11b0}", "\u{b085}", "\u{1101}\u{1175}\u{11b0}"),
        ("\u{b086}", "\u{b086}", "\u{1101}\u{1175}\u{11b1}", "\u{b086}",
        "\u{1101}\u{1175}\u{11b1}"), ("\u{b087}", "\u{b087}", "\u{1101}\u{1175}\u{11b2}",
        "\u{b087}", "\u{1101}\u{1175}\u{11b2}"), ("\u{b088}", "\u{b088}",
        "\u{1101}\u{1175}\u{11b3}", "\u{b088}", "\u{1101}\u{1175}\u{11b3}"), ("\u{b089}",
        "\u{b089}", "\u{1101}\u{1175}\u{11b4}", "\u{b089}", "\u{1101}\u{1175}\u{11b4}"),
        ("\u{b08a}", "\u{b08a}", "\u{1101}\u{1175}\u{11b5}", "\u{b08a}",
        "\u{1101}\u{1175}\u{11b5}"), ("\u{b08b}", "\u{b08b}", "\u{1101}\u{1175}\u{11b6}",
        "\u{b08b}", "\u{1101}\u{1175}\u{11b6}"), ("\u{b08c}", "\u{b08c}",
        "\u{1101}\u{1175}\u{11b7}", "\u{b08c}", "\u{1101}\u{1175}\u{11b7}"), ("\u{b08d}",
        "\u{b08d}", "\u{1101}\u{1175}\u{11b8}", "\u{b08d}", "\u{1101}\u{1175}\u{11b8}"),
        ("\u{b08e}", "\u{b08e}", "\u{1101}\u{1175}\u{11b9}", "\u{b08e}",
        "\u{1101}\u{1175}\u{11b9}"), ("\u{b08f}", "\u{b08f}", "\u{1101}\u{1175}\u{11ba}",
        "\u{b08f}", "\u{1101}\u{1175}\u{11ba}"), ("\u{b090}", "\u{b090}",
        "\u{1101}\u{1175}\u{11bb}", "\u{b090}", "\u{1101}\u{1175}\u{11bb}"), ("\u{b091}",
        "\u{b091}", "\u{1101}\u{1175}\u{11bc}", "\u{b091}", "\u{1101}\u{1175}\u{11bc}"),
        ("\u{b092}", "\u{b092}", "\u{1101}\u{1175}\u{11bd}", "\u{b092}",
        "\u{1101}\u{1175}\u{11bd}"), ("\u{b093}", "\u{b093}", "\u{1101}\u{1175}\u{11be}",
        "\u{b093}", "\u{1101}\u{1175}\u{11be}"), ("\u{b094}", "\u{b094}",
        "\u{1101}\u{1175}\u{11bf}", "\u{b094}", "\u{1101}\u{1175}\u{11bf}"), ("\u{b095}",
        "\u{b095}", "\u{1101}\u{1175}\u{11c0}", "\u{b095}", "\u{1101}\u{1175}\u{11c0}"),
        ("\u{b096}", "\u{b096}", "\u{1101}\u{1175}\u{11c1}", "\u{b096}",
        "\u{1101}\u{1175}\u{11c1}"), ("\u{b097}", "\u{b097}", "\u{1101}\u{1175}\u{11c2}",
        "\u{b097}", "\u{1101}\u{1175}\u{11c2}"), ("\u{b098}", "\u{b098}", "\u{1102}\u{1161}",
        "\u{b098}", "\u{1102}\u{1161}"), ("\u{b099}", "\u{b099}", "\u{1102}\u{1161}\u{11a8}",
        "\u{b099}", "\u{1102}\u{1161}\u{11a8}"), ("\u{b09a}", "\u{b09a}",
        "\u{1102}\u{1161}\u{11a9}", "\u{b09a}", "\u{1102}\u{1161}\u{11a9}"), ("\u{b09b}",
        "\u{b09b}", "\u{1102}\u{1161}\u{11aa}", "\u{b09b}", "\u{1102}\u{1161}\u{11aa}"),
        ("\u{b09c}", "\u{b09c}", "\u{1102}\u{1161}\u{11ab}", "\u{b09c}",
        "\u{1102}\u{1161}\u{11ab}"), ("\u{b09d}", "\u{b09d}", "\u{1102}\u{1161}\u{11ac}",
        "\u{b09d}", "\u{1102}\u{1161}\u{11ac}"), ("\u{b09e}", "\u{b09e}",
        "\u{1102}\u{1161}\u{11ad}", "\u{b09e}", "\u{1102}\u{1161}\u{11ad}"), ("\u{b09f}",
        "\u{b09f}", "\u{1102}\u{1161}\u{11ae}", "\u{b09f}", "\u{1102}\u{1161}\u{11ae}"),
        ("\u{b0a0}", "\u{b0a0}", "\u{1102}\u{1161}\u{11af}", "\u{b0a0}",
        "\u{1102}\u{1161}\u{11af}"), ("\u{b0a1}", "\u{b0a1}", "\u{1102}\u{1161}\u{11b0}",
        "\u{b0a1}", "\u{1102}\u{1161}\u{11b0}"), ("\u{b0a2}", "\u{b0a2}",
        "\u{1102}\u{1161}\u{11b1}", "\u{b0a2}", "\u{1102}\u{1161}\u{11b1}"), ("\u{b0a3}",
        "\u{b0a3}", "\u{1102}\u{1161}\u{11b2}", "\u{b0a3}", "\u{1102}\u{1161}\u{11b2}"),
        ("\u{b0a4}", "\u{b0a4}", "\u{1102}\u{1161}\u{11b3}", "\u{b0a4}",
        "\u{1102}\u{1161}\u{11b3}"), ("\u{b0a5}", "\u{b0a5}", "\u{1102}\u{1161}\u{11b4}",
        "\u{b0a5}", "\u{1102}\u{1161}\u{11b4}"), ("\u{b0a6}", "\u{b0a6}",
        "\u{1102}\u{1161}\u{11b5}", "\u{b0a6}", "\u{1102}\u{1161}\u{11b5}"), ("\u{b0a7}",
        "\u{b0a7}", "\u{1102}\u{1161}\u{11b6}", "\u{b0a7}", "\u{1102}\u{1161}\u{11b6}"),
        ("\u{b0a8}", "\u{b0a8}", "\u{1102}\u{1161}\u{11b7}", "\u{b0a8}",
        "\u{1102}\u{1161}\u{11b7}"), ("\u{b0a9}", "\u{b0a9}", "\u{1102}\u{1161}\u{11b8}",
        "\u{b0a9}", "\u{1102}\u{1161}\u{11b8}"), ("\u{b0aa}", "\u{b0aa}",
        "\u{1102}\u{1161}\u{11b9}", "\u{b0aa}", "\u{1102}\u{1161}\u{11b9}"), ("\u{b0ab}",
        "\u{b0ab}", "\u{1102}\u{1161}\u{11ba}", "\u{b0ab}", "\u{1102}\u{1161}\u{11ba}"),
        ("\u{b0ac}", "\u{b0ac}", "\u{1102}\u{1161}\u{11bb}", "\u{b0ac}",
        "\u{1102}\u{1161}\u{11bb}"), ("\u{b0ad}", "\u{b0ad}", "\u{1102}\u{1161}\u{11bc}",
        "\u{b0ad}", "\u{1102}\u{1161}\u{11bc}"), ("\u{b0ae}", "\u{b0ae}",
        "\u{1102}\u{1161}\u{11bd}", "\u{b0ae}", "\u{1102}\u{1161}\u{11bd}"), ("\u{b0af}",
        "\u{b0af}", "\u{1102}\u{1161}\u{11be}", "\u{b0af}", "\u{1102}\u{1161}\u{11be}"),
        ("\u{b0b0}", "\u{b0b0}", "\u{1102}\u{1161}\u{11bf}", "\u{b0b0}",
        "\u{1102}\u{1161}\u{11bf}"), ("\u{b0b1}", "\u{b0b1}", "\u{1102}\u{1161}\u{11c0}",
        "\u{b0b1}", "\u{1102}\u{1161}\u{11c0}"), ("\u{b0b2}", "\u{b0b2}",
        "\u{1102}\u{1161}\u{11c1}", "\u{b0b2}", "\u{1102}\u{1161}\u{11c1}"), ("\u{b0b3}",
        "\u{b0b3}", "\u{1102}\u{1161}\u{11c2}", "\u{b0b3}", "\u{1102}\u{1161}\u{11c2}"),
        ("\u{b0b4}", "\u{b0b4}", "\u{1102}\u{1162}", "\u{b0b4}", "\u{1102}\u{1162}"), ("\u{b0b5}",
        "\u{b0b5}", "\u{1102}\u{1162}\u{11a8}", "\u{b0b5}", "\u{1102}\u{1162}\u{11a8}"),
        ("\u{b0b6}", "\u{b0b6}", "\u{1102}\u{1162}\u{11a9}", "\u{b0b6}",
        "\u{1102}\u{1162}\u{11a9}"), ("\u{b0b7}", "\u{b0b7}", "\u{1102}\u{1162}\u{11aa}",
        "\u{b0b7}", "\u{1102}\u{1162}\u{11aa}"), ("\u{b0b8}", "\u{b0b8}",
        "\u{1102}\u{1162}\u{11ab}", "\u{b0b8}", "\u{1102}\u{1162}\u{11ab}"), ("\u{b0b9}",
        "\u{b0b9}", "\u{1102}\u{1162}\u{11ac}", "\u{b0b9}", "\u{1102}\u{1162}\u{11ac}"),
        ("\u{b0ba}", "\u{b0ba}", "\u{1102}\u{1162}\u{11ad}", "\u{b0ba}",
        "\u{1102}\u{1162}\u{11ad}"), ("\u{b0bb}", "\u{b0bb}", "\u{1102}\u{1162}\u{11ae}",
        "\u{b0bb}", "\u{1102}\u{1162}\u{11ae}"), ("\u{b0bc}", "\u{b0bc}",
        "\u{1102}\u{1162}\u{11af}", "\u{b0bc}", "\u{1102}\u{1162}\u{11af}"), ("\u{b0bd}",
        "\u{b0bd}", "\u{1102}\u{1162}\u{11b0}", "\u{b0bd}", "\u{1102}\u{1162}\u{11b0}"),
        ("\u{b0be}", "\u{b0be}", "\u{1102}\u{1162}\u{11b1}", "\u{b0be}",
        "\u{1102}\u{1162}\u{11b1}"), ("\u{b0bf}", "\u{b0bf}", "\u{1102}\u{1162}\u{11b2}",
        "\u{b0bf}", "\u{1102}\u{1162}\u{11b2}"), ("\u{b0c0}", "\u{b0c0}",
        "\u{1102}\u{1162}\u{11b3}", "\u{b0c0}", "\u{1102}\u{1162}\u{11b3}"), ("\u{b0c1}",
        "\u{b0c1}", "\u{1102}\u{1162}\u{11b4}", "\u{b0c1}", "\u{1102}\u{1162}\u{11b4}"),
        ("\u{b0c2}", "\u{b0c2}", "\u{1102}\u{1162}\u{11b5}", "\u{b0c2}",
        "\u{1102}\u{1162}\u{11b5}"), ("\u{b0c3}", "\u{b0c3}", "\u{1102}\u{1162}\u{11b6}",
        "\u{b0c3}", "\u{1102}\u{1162}\u{11b6}"), ("\u{b0c4}", "\u{b0c4}",
        "\u{1102}\u{1162}\u{11b7}", "\u{b0c4}", "\u{1102}\u{1162}\u{11b7}"), ("\u{b0c5}",
        "\u{b0c5}", "\u{1102}\u{1162}\u{11b8}", "\u{b0c5}", "\u{1102}\u{1162}\u{11b8}"),
        ("\u{b0c6}", "\u{b0c6}", "\u{1102}\u{1162}\u{11b9}", "\u{b0c6}",
        "\u{1102}\u{1162}\u{11b9}"), ("\u{b0c7}", "\u{b0c7}", "\u{1102}\u{1162}\u{11ba}",
        "\u{b0c7}", "\u{1102}\u{1162}\u{11ba}"), ("\u{b0c8}", "\u{b0c8}",
        "\u{1102}\u{1162}\u{11bb}", "\u{b0c8}", "\u{1102}\u{1162}\u{11bb}"), ("\u{b0c9}",
        "\u{b0c9}", "\u{1102}\u{1162}\u{11bc}", "\u{b0c9}", "\u{1102}\u{1162}\u{11bc}"),
        ("\u{b0ca}", "\u{b0ca}", "\u{1102}\u{1162}\u{11bd}", "\u{b0ca}",
        "\u{1102}\u{1162}\u{11bd}"), ("\u{b0cb}", "\u{b0cb}", "\u{1102}\u{1162}\u{11be}",
        "\u{b0cb}", "\u{1102}\u{1162}\u{11be}"), ("\u{b0cc}", "\u{b0cc}",
        "\u{1102}\u{1162}\u{11bf}", "\u{b0cc}", "\u{1102}\u{1162}\u{11bf}"), ("\u{b0cd}",
        "\u{b0cd}", "\u{1102}\u{1162}\u{11c0}", "\u{b0cd}", "\u{1102}\u{1162}\u{11c0}"),
        ("\u{b0ce}", "\u{b0ce}", "\u{1102}\u{1162}\u{11c1}", "\u{b0ce}",
        "\u{1102}\u{1162}\u{11c1}"), ("\u{b0cf}", "\u{b0cf}", "\u{1102}\u{1162}\u{11c2}",
        "\u{b0cf}", "\u{1102}\u{1162}\u{11c2}"), ("\u{b0d0}", "\u{b0d0}", "\u{1102}\u{1163}",
        "\u{b0d0}", "\u{1102}\u{1163}"), ("\u{b0d1}", "\u{b0d1}", "\u{1102}\u{1163}\u{11a8}",
        "\u{b0d1}", "\u{1102}\u{1163}\u{11a8}"), ("\u{b0d2}", "\u{b0d2}",
        "\u{1102}\u{1163}\u{11a9}", "\u{b0d2}", "\u{1102}\u{1163}\u{11a9}"), ("\u{b0d3}",
        "\u{b0d3}", "\u{1102}\u{1163}\u{11aa}", "\u{b0d3}", "\u{1102}\u{1163}\u{11aa}"),
        ("\u{b0d4}", "\u{b0d4}", "\u{1102}\u{1163}\u{11ab}", "\u{b0d4}",
        "\u{1102}\u{1163}\u{11ab}"), ("\u{b0d5}", "\u{b0d5}", "\u{1102}\u{1163}\u{11ac}",
        "\u{b0d5}", "\u{1102}\u{1163}\u{11ac}"), ("\u{b0d6}", "\u{b0d6}",
        "\u{1102}\u{1163}\u{11ad}", "\u{b0d6}", "\u{1102}\u{1163}\u{11ad}"), ("\u{b0d7}",
        "\u{b0d7}", "\u{1102}\u{1163}\u{11ae}", "\u{b0d7}", "\u{1102}\u{1163}\u{11ae}"),
        ("\u{b0d8}", "\u{b0d8}", "\u{1102}\u{1163}\u{11af}", "\u{b0d8}",
        "\u{1102}\u{1163}\u{11af}"), ("\u{b0d9}", "\u{b0d9}", "\u{1102}\u{1163}\u{11b0}",
        "\u{b0d9}", "\u{1102}\u{1163}\u{11b0}"), ("\u{b0da}", "\u{b0da}",
        "\u{1102}\u{1163}\u{11b1}", "\u{b0da}", "\u{1102}\u{1163}\u{11b1}"), ("\u{b0db}",
        "\u{b0db}", "\u{1102}\u{1163}\u{11b2}", "\u{b0db}", "\u{1102}\u{1163}\u{11b2}"),
        ("\u{b0dc}", "\u{b0dc}", "\u{1102}\u{1163}\u{11b3}", "\u{b0dc}",
        "\u{1102}\u{1163}\u{11b3}"), ("\u{b0dd}", "\u{b0dd}", "\u{1102}\u{1163}\u{11b4}",
        "\u{b0dd}", "\u{1102}\u{1163}\u{11b4}"), ("\u{b0de}", "\u{b0de}",
        "\u{1102}\u{1163}\u{11b5}", "\u{b0de}", "\u{1102}\u{1163}\u{11b5}"), ("\u{b0df}",
        "\u{b0df}", "\u{1102}\u{1163}\u{11b6}", "\u{b0df}", "\u{1102}\u{1163}\u{11b6}"),
        ("\u{b0e0}", "\u{b0e0}", "\u{1102}\u{1163}\u{11b7}", "\u{b0e0}",
        "\u{1102}\u{1163}\u{11b7}"), ("\u{b0e1}", "\u{b0e1}", "\u{1102}\u{1163}\u{11b8}",
        "\u{b0e1}", "\u{1102}\u{1163}\u{11b8}"), ("\u{b0e2}", "\u{b0e2}",
        "\u{1102}\u{1163}\u{11b9}", "\u{b0e2}", "\u{1102}\u{1163}\u{11b9}"), ("\u{b0e3}",
        "\u{b0e3}", "\u{1102}\u{1163}\u{11ba}", "\u{b0e3}", "\u{1102}\u{1163}\u{11ba}"),
        ("\u{b0e4}", "\u{b0e4}", "\u{1102}\u{1163}\u{11bb}", "\u{b0e4}",
        "\u{1102}\u{1163}\u{11bb}"), ("\u{b0e5}", "\u{b0e5}", "\u{1102}\u{1163}\u{11bc}",
        "\u{b0e5}", "\u{1102}\u{1163}\u{11bc}"), ("\u{b0e6}", "\u{b0e6}",
        "\u{1102}\u{1163}\u{11bd}", "\u{b0e6}", "\u{1102}\u{1163}\u{11bd}"), ("\u{b0e7}",
        "\u{b0e7}", "\u{1102}\u{1163}\u{11be}", "\u{b0e7}", "\u{1102}\u{1163}\u{11be}"),
        ("\u{b0e8}", "\u{b0e8}", "\u{1102}\u{1163}\u{11bf}", "\u{b0e8}",
        "\u{1102}\u{1163}\u{11bf}"), ("\u{b0e9}", "\u{b0e9}", "\u{1102}\u{1163}\u{11c0}",
        "\u{b0e9}", "\u{1102}\u{1163}\u{11c0}"), ("\u{b0ea}", "\u{b0ea}",
        "\u{1102}\u{1163}\u{11c1}", "\u{b0ea}", "\u{1102}\u{1163}\u{11c1}"), ("\u{b0eb}",
        "\u{b0eb}", "\u{1102}\u{1163}\u{11c2}", "\u{b0eb}", "\u{1102}\u{1163}\u{11c2}"),
        ("\u{b0ec}", "\u{b0ec}", "\u{1102}\u{1164}", "\u{b0ec}", "\u{1102}\u{1164}"), ("\u{b0ed}",
        "\u{b0ed}", "\u{1102}\u{1164}\u{11a8}", "\u{b0ed}", "\u{1102}\u{1164}\u{11a8}"),
        ("\u{b0ee}", "\u{b0ee}", "\u{1102}\u{1164}\u{11a9}", "\u{b0ee}",
        "\u{1102}\u{1164}\u{11a9}"), ("\u{b0ef}", "\u{b0ef}", "\u{1102}\u{1164}\u{11aa}",
        "\u{b0ef}", "\u{1102}\u{1164}\u{11aa}"), ("\u{b0f0}", "\u{b0f0}",
        "\u{1102}\u{1164}\u{11ab}", "\u{b0f0}", "\u{1102}\u{1164}\u{11ab}"), ("\u{b0f1}",
        "\u{b0f1}", "\u{1102}\u{1164}\u{11ac}", "\u{b0f1}", "\u{1102}\u{1164}\u{11ac}"),
        ("\u{b0f2}", "\u{b0f2}", "\u{1102}\u{1164}\u{11ad}", "\u{b0f2}",
        "\u{1102}\u{1164}\u{11ad}"), ("\u{b0f3}", "\u{b0f3}", "\u{1102}\u{1164}\u{11ae}",
        "\u{b0f3}", "\u{1102}\u{1164}\u{11ae}"), ("\u{b0f4}", "\u{b0f4}",
        "\u{1102}\u{1164}\u{11af}", "\u{b0f4}", "\u{1102}\u{1164}\u{11af}"), ("\u{b0f5}",
        "\u{b0f5}", "\u{1102}\u{1164}\u{11b0}", "\u{b0f5}", "\u{1102}\u{1164}\u{11b0}"),
        ("\u{b0f6}", "\u{b0f6}", "\u{1102}\u{1164}\u{11b1}", "\u{b0f6}",
        "\u{1102}\u{1164}\u{11b1}"), ("\u{b0f7}", "\u{b0f7}", "\u{1102}\u{1164}\u{11b2}",
        "\u{b0f7}", "\u{1102}\u{1164}\u{11b2}"), ("\u{b0f8}", "\u{b0f8}",
        "\u{1102}\u{1164}\u{11b3}", "\u{b0f8}", "\u{1102}\u{1164}\u{11b3}"), ("\u{b0f9}",
        "\u{b0f9}", "\u{1102}\u{1164}\u{11b4}", "\u{b0f9}", "\u{1102}\u{1164}\u{11b4}"),
        ("\u{b0fa}", "\u{b0fa}", "\u{1102}\u{1164}\u{11b5}", "\u{b0fa}",
        "\u{1102}\u{1164}\u{11b5}"), ("\u{b0fb}", "\u{b0fb}", "\u{1102}\u{1164}\u{11b6}",
        "\u{b0fb}", "\u{1102}\u{1164}\u{11b6}"), ("\u{b0fc}", "\u{b0fc}",
        "\u{1102}\u{1164}\u{11b7}", "\u{b0fc}", "\u{1102}\u{1164}\u{11b7}"), ("\u{b0fd}",
        "\u{b0fd}", "\u{1102}\u{1164}\u{11b8}", "\u{b0fd}", "\u{1102}\u{1164}\u{11b8}"),
        ("\u{b0fe}", "\u{b0fe}", "\u{1102}\u{1164}\u{11b9}", "\u{b0fe}",
        "\u{1102}\u{1164}\u{11b9}"), ("\u{b0ff}", "\u{b0ff}", "\u{1102}\u{1164}\u{11ba}",
        "\u{b0ff}", "\u{1102}\u{1164}\u{11ba}"), ("\u{b100}", "\u{b100}",
        "\u{1102}\u{1164}\u{11bb}", "\u{b100}", "\u{1102}\u{1164}\u{11bb}"), ("\u{b101}",
        "\u{b101}", "\u{1102}\u{1164}\u{11bc}", "\u{b101}", "\u{1102}\u{1164}\u{11bc}"),
        ("\u{b102}", "\u{b102}", "\u{1102}\u{1164}\u{11bd}", "\u{b102}",
        "\u{1102}\u{1164}\u{11bd}"), ("\u{b103}", "\u{b103}", "\u{1102}\u{1164}\u{11be}",
        "\u{b103}", "\u{1102}\u{1164}\u{11be}"), ("\u{b104}", "\u{b104}",
        "\u{1102}\u{1164}\u{11bf}", "\u{b104}", "\u{1102}\u{1164}\u{11bf}"), ("\u{b105}",
        "\u{b105}", "\u{1102}\u{1164}\u{11c0}", "\u{b105}", "\u{1102}\u{1164}\u{11c0}"),
        ("\u{b106}", "\u{b106}", "\u{1102}\u{1164}\u{11c1}", "\u{b106}",
        "\u{1102}\u{1164}\u{11c1}"), ("\u{b107}", "\u{b107}", "\u{1102}\u{1164}\u{11c2}",
        "\u{b107}", "\u{1102}\u{1164}\u{11c2}"), ("\u{b108}", "\u{b108}", "\u{1102}\u{1165}",
        "\u{b108}", "\u{1102}\u{1165}"), ("\u{b109}", "\u{b109}", "\u{1102}\u{1165}\u{11a8}",
        "\u{b109}", "\u{1102}\u{1165}\u{11a8}"), ("\u{b10a}", "\u{b10a}",
        "\u{1102}\u{1165}\u{11a9}", "\u{b10a}", "\u{1102}\u{1165}\u{11a9}"), ("\u{b10b}",
        "\u{b10b}", "\u{1102}\u{1165}\u{11aa}", "\u{b10b}", "\u{1102}\u{1165}\u{11aa}"),
        ("\u{b10c}", "\u{b10c}", "\u{1102}\u{1165}\u{11ab}", "\u{b10c}",
        "\u{1102}\u{1165}\u{11ab}"), ("\u{b10d}", "\u{b10d}", "\u{1102}\u{1165}\u{11ac}",
        "\u{b10d}", "\u{1102}\u{1165}\u{11ac}"), ("\u{b10e}", "\u{b10e}",
        "\u{1102}\u{1165}\u{11ad}", "\u{b10e}", "\u{1102}\u{1165}\u{11ad}"), ("\u{b10f}",
        "\u{b10f}", "\u{1102}\u{1165}\u{11ae}", "\u{b10f}", "\u{1102}\u{1165}\u{11ae}"),
        ("\u{b110}", "\u{b110}", "\u{1102}\u{1165}\u{11af}", "\u{b110}",
        "\u{1102}\u{1165}\u{11af}"), ("\u{b111}", "\u{b111}", "\u{1102}\u{1165}\u{11b0}",
        "\u{b111}", "\u{1102}\u{1165}\u{11b0}"), ("\u{b112}", "\u{b112}",
        "\u{1102}\u{1165}\u{11b1}", "\u{b112}", "\u{1102}\u{1165}\u{11b1}"), ("\u{b113}",
        "\u{b113}", "\u{1102}\u{1165}\u{11b2}", "\u{b113}", "\u{1102}\u{1165}\u{11b2}"),
        ("\u{b114}", "\u{b114}", "\u{1102}\u{1165}\u{11b3}", "\u{b114}",
        "\u{1102}\u{1165}\u{11b3}"), ("\u{b115}", "\u{b115}", "\u{1102}\u{1165}\u{11b4}",
        "\u{b115}", "\u{1102}\u{1165}\u{11b4}"), ("\u{b116}", "\u{b116}",
        "\u{1102}\u{1165}\u{11b5}", "\u{b116}", "\u{1102}\u{1165}\u{11b5}"), ("\u{b117}",
        "\u{b117}", "\u{1102}\u{1165}\u{11b6}", "\u{b117}", "\u{1102}\u{1165}\u{11b6}"),
        ("\u{b118}", "\u{b118}", "\u{1102}\u{1165}\u{11b7}", "\u{b118}",
        "\u{1102}\u{1165}\u{11b7}"), ("\u{b119}", "\u{b119}", "\u{1102}\u{1165}\u{11b8}",
        "\u{b119}", "\u{1102}\u{1165}\u{11b8}"), ("\u{b11a}", "\u{b11a}",
        "\u{1102}\u{1165}\u{11b9}", "\u{b11a}", "\u{1102}\u{1165}\u{11b9}"), ("\u{b11b}",
        "\u{b11b}", "\u{1102}\u{1165}\u{11ba}", "\u{b11b}", "\u{1102}\u{1165}\u{11ba}"),
        ("\u{b11c}", "\u{b11c}", "\u{1102}\u{1165}\u{11bb}", "\u{b11c}",
        "\u{1102}\u{1165}\u{11bb}"), ("\u{b11d}", "\u{b11d}", "\u{1102}\u{1165}\u{11bc}",
        "\u{b11d}", "\u{1102}\u{1165}\u{11bc}"), ("\u{b11e}", "\u{b11e}",
        "\u{1102}\u{1165}\u{11bd}", "\u{b11e}", "\u{1102}\u{1165}\u{11bd}"), ("\u{b11f}",
        "\u{b11f}", "\u{1102}\u{1165}\u{11be}", "\u{b11f}", "\u{1102}\u{1165}\u{11be}"),
        ("\u{b120}", "\u{b120}", "\u{1102}\u{1165}\u{11bf}", "\u{b120}",
        "\u{1102}\u{1165}\u{11bf}"), ("\u{b121}", "\u{b121}", "\u{1102}\u{1165}\u{11c0}",
        "\u{b121}", "\u{1102}\u{1165}\u{11c0}"), ("\u{b122}", "\u{b122}",
        "\u{1102}\u{1165}\u{11c1}", "\u{b122}", "\u{1102}\u{1165}\u{11c1}"), ("\u{b123}",
        "\u{b123}", "\u{1102}\u{1165}\u{11c2}", "\u{b123}", "\u{1102}\u{1165}\u{11c2}"),
        ("\u{b124}", "\u{b124}", "\u{1102}\u{1166}", "\u{b124}", "\u{1102}\u{1166}"), ("\u{b125}",
        "\u{b125}", "\u{1102}\u{1166}\u{11a8}", "\u{b125}", "\u{1102}\u{1166}\u{11a8}"),
        ("\u{b126}", "\u{b126}", "\u{1102}\u{1166}\u{11a9}", "\u{b126}",
        "\u{1102}\u{1166}\u{11a9}"), ("\u{b127}", "\u{b127}", "\u{1102}\u{1166}\u{11aa}",
        "\u{b127}", "\u{1102}\u{1166}\u{11aa}"), ("\u{b128}", "\u{b128}",
        "\u{1102}\u{1166}\u{11ab}", "\u{b128}", "\u{1102}\u{1166}\u{11ab}"), ("\u{b129}",
        "\u{b129}", "\u{1102}\u{1166}\u{11ac}", "\u{b129}", "\u{1102}\u{1166}\u{11ac}"),
        ("\u{b12a}", "\u{b12a}", "\u{1102}\u{1166}\u{11ad}", "\u{b12a}",
        "\u{1102}\u{1166}\u{11ad}"), ("\u{b12b}", "\u{b12b}", "\u{1102}\u{1166}\u{11ae}",
        "\u{b12b}", "\u{1102}\u{1166}\u{11ae}"), ("\u{b12c}", "\u{b12c}",
        "\u{1102}\u{1166}\u{11af}", "\u{b12c}", "\u{1102}\u{1166}\u{11af}"), ("\u{b12d}",
        "\u{b12d}", "\u{1102}\u{1166}\u{11b0}", "\u{b12d}", "\u{1102}\u{1166}\u{11b0}"),
        ("\u{b12e}", "\u{b12e}", "\u{1102}\u{1166}\u{11b1}", "\u{b12e}",
        "\u{1102}\u{1166}\u{11b1}"), ("\u{b12f}", "\u{b12f}", "\u{1102}\u{1166}\u{11b2}",
        "\u{b12f}", "\u{1102}\u{1166}\u{11b2}"), ("\u{b130}", "\u{b130}",
        "\u{1102}\u{1166}\u{11b3}", "\u{b130}", "\u{1102}\u{1166}\u{11b3}"), ("\u{b131}",
        "\u{b131}", "\u{1102}\u{1166}\u{11b4}", "\u{b131}", "\u{1102}\u{1166}\u{11b4}"),
        ("\u{b132}", "\u{b132}", "\u{1102}\u{1166}\u{11b5}", "\u{b132}",
        "\u{1102}\u{1166}\u{11b5}"), ("\u{b133}", "\u{b133}", "\u{1102}\u{1166}\u{11b6}",
        "\u{b133}", "\u{1102}\u{1166}\u{11b6}"), ("\u{b134}", "\u{b134}",
        "\u{1102}\u{1166}\u{11b7}", "\u{b134}", "\u{1102}\u{1166}\u{11b7}"), ("\u{b135}",
        "\u{b135}", "\u{1102}\u{1166}\u{11b8}", "\u{b135}", "\u{1102}\u{1166}\u{11b8}"),
        ("\u{b136}", "\u{b136}", "\u{1102}\u{1166}\u{11b9}", "\u{b136}",
        "\u{1102}\u{1166}\u{11b9}"), ("\u{b137}", "\u{b137}", "\u{1102}\u{1166}\u{11ba}",
        "\u{b137}", "\u{1102}\u{1166}\u{11ba}"), ("\u{b138}", "\u{b138}",
        "\u{1102}\u{1166}\u{11bb}", "\u{b138}", "\u{1102}\u{1166}\u{11bb}"), ("\u{b139}",
        "\u{b139}", "\u{1102}\u{1166}\u{11bc}", "\u{b139}", "\u{1102}\u{1166}\u{11bc}"),
        ("\u{b13a}", "\u{b13a}", "\u{1102}\u{1166}\u{11bd}", "\u{b13a}",
        "\u{1102}\u{1166}\u{11bd}"), ("\u{b13b}", "\u{b13b}", "\u{1102}\u{1166}\u{11be}",
        "\u{b13b}", "\u{1102}\u{1166}\u{11be}"), ("\u{b13c}", "\u{b13c}",
        "\u{1102}\u{1166}\u{11bf}", "\u{b13c}", "\u{1102}\u{1166}\u{11bf}"), ("\u{b13d}",
        "\u{b13d}", "\u{1102}\u{1166}\u{11c0}", "\u{b13d}", "\u{1102}\u{1166}\u{11c0}"),
        ("\u{b13e}", "\u{b13e}", "\u{1102}\u{1166}\u{11c1}", "\u{b13e}",
        "\u{1102}\u{1166}\u{11c1}"), ("\u{b13f}", "\u{b13f}", "\u{1102}\u{1166}\u{11c2}",
        "\u{b13f}", "\u{1102}\u{1166}\u{11c2}"), ("\u{b140}", "\u{b140}", "\u{1102}\u{1167}",
        "\u{b140}", "\u{1102}\u{1167}"), ("\u{b141}", "\u{b141}", "\u{1102}\u{1167}\u{11a8}",
        "\u{b141}", "\u{1102}\u{1167}\u{11a8}"), ("\u{b142}", "\u{b142}",
        "\u{1102}\u{1167}\u{11a9}", "\u{b142}", "\u{1102}\u{1167}\u{11a9}"), ("\u{b143}",
        "\u{b143}", "\u{1102}\u{1167}\u{11aa}", "\u{b143}", "\u{1102}\u{1167}\u{11aa}"),
        ("\u{b144}", "\u{b144}", "\u{1102}\u{1167}\u{11ab}", "\u{b144}",
        "\u{1102}\u{1167}\u{11ab}"), ("\u{b145}", "\u{b145}", "\u{1102}\u{1167}\u{11ac}",
        "\u{b145}", "\u{1102}\u{1167}\u{11ac}"), ("\u{b146}", "\u{b146}",
        "\u{1102}\u{1167}\u{11ad}", "\u{b146}", "\u{1102}\u{1167}\u{11ad}"), ("\u{b147}",
        "\u{b147}", "\u{1102}\u{1167}\u{11ae}", "\u{b147}", "\u{1102}\u{1167}\u{11ae}"),
        ("\u{b148}", "\u{b148}", "\u{1102}\u{1167}\u{11af}", "\u{b148}",
        "\u{1102}\u{1167}\u{11af}"), ("\u{b149}", "\u{b149}", "\u{1102}\u{1167}\u{11b0}",
        "\u{b149}", "\u{1102}\u{1167}\u{11b0}"), ("\u{b14a}", "\u{b14a}",
        "\u{1102}\u{1167}\u{11b1}", "\u{b14a}", "\u{1102}\u{1167}\u{11b1}"), ("\u{b14b}",
        "\u{b14b}", "\u{1102}\u{1167}\u{11b2}", "\u{b14b}", "\u{1102}\u{1167}\u{11b2}"),
        ("\u{b14c}", "\u{b14c}", "\u{1102}\u{1167}\u{11b3}", "\u{b14c}",
        "\u{1102}\u{1167}\u{11b3}"), ("\u{b14d}", "\u{b14d}", "\u{1102}\u{1167}\u{11b4}",
        "\u{b14d}", "\u{1102}\u{1167}\u{11b4}"), ("\u{b14e}", "\u{b14e}",
        "\u{1102}\u{1167}\u{11b5}", "\u{b14e}", "\u{1102}\u{1167}\u{11b5}"), ("\u{b14f}",
        "\u{b14f}", "\u{1102}\u{1167}\u{11b6}", "\u{b14f}", "\u{1102}\u{1167}\u{11b6}"),
        ("\u{b150}", "\u{b150}", "\u{1102}\u{1167}\u{11b7}", "\u{b150}",
        "\u{1102}\u{1167}\u{11b7}"), ("\u{b151}", "\u{b151}", "\u{1102}\u{1167}\u{11b8}",
        "\u{b151}", "\u{1102}\u{1167}\u{11b8}"), ("\u{b152}", "\u{b152}",
        "\u{1102}\u{1167}\u{11b9}", "\u{b152}", "\u{1102}\u{1167}\u{11b9}"), ("\u{b153}",
        "\u{b153}", "\u{1102}\u{1167}\u{11ba}", "\u{b153}", "\u{1102}\u{1167}\u{11ba}"),
        ("\u{b154}", "\u{b154}", "\u{1102}\u{1167}\u{11bb}", "\u{b154}",
        "\u{1102}\u{1167}\u{11bb}"), ("\u{b155}", "\u{b155}", "\u{1102}\u{1167}\u{11bc}",
        "\u{b155}", "\u{1102}\u{1167}\u{11bc}"), ("\u{b156}", "\u{b156}",
        "\u{1102}\u{1167}\u{11bd}", "\u{b156}", "\u{1102}\u{1167}\u{11bd}"), ("\u{b157}",
        "\u{b157}", "\u{1102}\u{1167}\u{11be}", "\u{b157}", "\u{1102}\u{1167}\u{11be}"),
        ("\u{b158}", "\u{b158}", "\u{1102}\u{1167}\u{11bf}", "\u{b158}",
        "\u{1102}\u{1167}\u{11bf}"), ("\u{b159}", "\u{b159}", "\u{1102}\u{1167}\u{11c0}",
        "\u{b159}", "\u{1102}\u{1167}\u{11c0}"), ("\u{b15a}", "\u{b15a}",
        "\u{1102}\u{1167}\u{11c1}", "\u{b15a}", "\u{1102}\u{1167}\u{11c1}"), ("\u{b15b}",
        "\u{b15b}", "\u{1102}\u{1167}\u{11c2}", "\u{b15b}", "\u{1102}\u{1167}\u{11c2}"),
        ("\u{b15c}", "\u{b15c}", "\u{1102}\u{1168}", "\u{b15c}", "\u{1102}\u{1168}"), ("\u{b15d}",
        "\u{b15d}", "\u{1102}\u{1168}\u{11a8}", "\u{b15d}", "\u{1102}\u{1168}\u{11a8}"),
        ("\u{b15e}", "\u{b15e}", "\u{1102}\u{1168}\u{11a9}", "\u{b15e}",
        "\u{1102}\u{1168}\u{11a9}"), ("\u{b15f}", "\u{b15f}", "\u{1102}\u{1168}\u{11aa}",
        "\u{b15f}", "\u{1102}\u{1168}\u{11aa}"), ("\u{b160}", "\u{b160}",
        "\u{1102}\u{1168}\u{11ab}", "\u{b160}", "\u{1102}\u{1168}\u{11ab}"), ("\u{b161}",
        "\u{b161}", "\u{1102}\u{1168}\u{11ac}", "\u{b161}", "\u{1102}\u{1168}\u{11ac}"),
        ("\u{b162}", "\u{b162}", "\u{1102}\u{1168}\u{11ad}", "\u{b162}",
        "\u{1102}\u{1168}\u{11ad}"), ("\u{b163}", "\u{b163}", "\u{1102}\u{1168}\u{11ae}",
        "\u{b163}", "\u{1102}\u{1168}\u{11ae}"), ("\u{b164}", "\u{b164}",
        "\u{1102}\u{1168}\u{11af}", "\u{b164}", "\u{1102}\u{1168}\u{11af}"), ("\u{b165}",
        "\u{b165}", "\u{1102}\u{1168}\u{11b0}", "\u{b165}", "\u{1102}\u{1168}\u{11b0}"),
        ("\u{b166}", "\u{b166}", "\u{1102}\u{1168}\u{11b1}", "\u{b166}",
        "\u{1102}\u{1168}\u{11b1}"), ("\u{b167}", "\u{b167}", "\u{1102}\u{1168}\u{11b2}",
        "\u{b167}", "\u{1102}\u{1168}\u{11b2}"), ("\u{b168}", "\u{b168}",
        "\u{1102}\u{1168}\u{11b3}", "\u{b168}", "\u{1102}\u{1168}\u{11b3}"), ("\u{b169}",
        "\u{b169}", "\u{1102}\u{1168}\u{11b4}", "\u{b169}", "\u{1102}\u{1168}\u{11b4}"),
        ("\u{b16a}", "\u{b16a}", "\u{1102}\u{1168}\u{11b5}", "\u{b16a}",
        "\u{1102}\u{1168}\u{11b5}"), ("\u{b16b}", "\u{b16b}", "\u{1102}\u{1168}\u{11b6}",
        "\u{b16b}", "\u{1102}\u{1168}\u{11b6}"), ("\u{b16c}", "\u{b16c}",
        "\u{1102}\u{1168}\u{11b7}", "\u{b16c}", "\u{1102}\u{1168}\u{11b7}"), ("\u{b16d}",
        "\u{b16d}", "\u{1102}\u{1168}\u{11b8}", "\u{b16d}", "\u{1102}\u{1168}\u{11b8}"),
        ("\u{b16e}", "\u{b16e}", "\u{1102}\u{1168}\u{11b9}", "\u{b16e}",
        "\u{1102}\u{1168}\u{11b9}"), ("\u{b16f}", "\u{b16f}", "\u{1102}\u{1168}\u{11ba}",
        "\u{b16f}", "\u{1102}\u{1168}\u{11ba}"), ("\u{b170}", "\u{b170}",
        "\u{1102}\u{1168}\u{11bb}", "\u{b170}", "\u{1102}\u{1168}\u{11bb}"), ("\u{b171}",
        "\u{b171}", "\u{1102}\u{1168}\u{11bc}", "\u{b171}", "\u{1102}\u{1168}\u{11bc}"),
        ("\u{b172}", "\u{b172}", "\u{1102}\u{1168}\u{11bd}", "\u{b172}",
        "\u{1102}\u{1168}\u{11bd}"), ("\u{b173}", "\u{b173}", "\u{1102}\u{1168}\u{11be}",
        "\u{b173}", "\u{1102}\u{1168}\u{11be}"), ("\u{b174}", "\u{b174}",
        "\u{1102}\u{1168}\u{11bf}", "\u{b174}", "\u{1102}\u{1168}\u{11bf}"), ("\u{b175}",
        "\u{b175}", "\u{1102}\u{1168}\u{11c0}", "\u{b175}", "\u{1102}\u{1168}\u{11c0}"),
        ("\u{b176}", "\u{b176}", "\u{1102}\u{1168}\u{11c1}", "\u{b176}",
        "\u{1102}\u{1168}\u{11c1}"), ("\u{b177}", "\u{b177}", "\u{1102}\u{1168}\u{11c2}",
        "\u{b177}", "\u{1102}\u{1168}\u{11c2}"), ("\u{b178}", "\u{b178}", "\u{1102}\u{1169}",
        "\u{b178}", "\u{1102}\u{1169}"), ("\u{b179}", "\u{b179}", "\u{1102}\u{1169}\u{11a8}",
        "\u{b179}", "\u{1102}\u{1169}\u{11a8}"), ("\u{b17a}", "\u{b17a}",
        "\u{1102}\u{1169}\u{11a9}", "\u{b17a}", "\u{1102}\u{1169}\u{11a9}"), ("\u{b17b}",
        "\u{b17b}", "\u{1102}\u{1169}\u{11aa}", "\u{b17b}", "\u{1102}\u{1169}\u{11aa}"),
        ("\u{b17c}", "\u{b17c}", "\u{1102}\u{1169}\u{11ab}", "\u{b17c}",
        "\u{1102}\u{1169}\u{11ab}"), ("\u{b17d}", "\u{b17d}", "\u{1102}\u{1169}\u{11ac}",
        "\u{b17d}", "\u{1102}\u{1169}\u{11ac}"), ("\u{b17e}", "\u{b17e}",
        "\u{1102}\u{1169}\u{11ad}", "\u{b17e}", "\u{1102}\u{1169}\u{11ad}"), ("\u{b17f}",
        "\u{b17f}", "\u{1102}\u{1169}\u{11ae}", "\u{b17f}", "\u{1102}\u{1169}\u{11ae}"),
        ("\u{b180}", "\u{b180}", "\u{1102}\u{1169}\u{11af}", "\u{b180}",
        "\u{1102}\u{1169}\u{11af}"), ("\u{b181}", "\u{b181}", "\u{1102}\u{1169}\u{11b0}",
        "\u{b181}", "\u{1102}\u{1169}\u{11b0}"), ("\u{b182}", "\u{b182}",
        "\u{1102}\u{1169}\u{11b1}", "\u{b182}", "\u{1102}\u{1169}\u{11b1}"), ("\u{b183}",
        "\u{b183}", "\u{1102}\u{1169}\u{11b2}", "\u{b183}", "\u{1102}\u{1169}\u{11b2}"),
        ("\u{b184}", "\u{b184}", "\u{1102}\u{1169}\u{11b3}", "\u{b184}",
        "\u{1102}\u{1169}\u{11b3}"), ("\u{b185}", "\u{b185}", "\u{1102}\u{1169}\u{11b4}",
        "\u{b185}", "\u{1102}\u{1169}\u{11b4}"), ("\u{b186}", "\u{b186}",
        "\u{1102}\u{1169}\u{11b5}", "\u{b186}", "\u{1102}\u{1169}\u{11b5}"), ("\u{b187}",
        "\u{b187}", "\u{1102}\u{1169}\u{11b6}", "\u{b187}", "\u{1102}\u{1169}\u{11b6}"),
        ("\u{b188}", "\u{b188}", "\u{1102}\u{1169}\u{11b7}", "\u{b188}",
        "\u{1102}\u{1169}\u{11b7}"), ("\u{b189}", "\u{b189}", "\u{1102}\u{1169}\u{11b8}",
        "\u{b189}", "\u{1102}\u{1169}\u{11b8}"), ("\u{b18a}", "\u{b18a}",
        "\u{1102}\u{1169}\u{11b9}", "\u{b18a}", "\u{1102}\u{1169}\u{11b9}"), ("\u{b18b}",
        "\u{b18b}", "\u{1102}\u{1169}\u{11ba}", "\u{b18b}", "\u{1102}\u{1169}\u{11ba}"),
        ("\u{b18c}", "\u{b18c}", "\u{1102}\u{1169}\u{11bb}", "\u{b18c}",
        "\u{1102}\u{1169}\u{11bb}"), ("\u{b18d}", "\u{b18d}", "\u{1102}\u{1169}\u{11bc}",
        "\u{b18d}", "\u{1102}\u{1169}\u{11bc}"), ("\u{b18e}", "\u{b18e}",
        "\u{1102}\u{1169}\u{11bd}", "\u{b18e}", "\u{1102}\u{1169}\u{11bd}"), ("\u{b18f}",
        "\u{b18f}", "\u{1102}\u{1169}\u{11be}", "\u{b18f}", "\u{1102}\u{1169}\u{11be}"),
        ("\u{b190}", "\u{b190}", "\u{1102}\u{1169}\u{11bf}", "\u{b190}",
        "\u{1102}\u{1169}\u{11bf}"), ("\u{b191}", "\u{b191}", "\u{1102}\u{1169}\u{11c0}",
        "\u{b191}", "\u{1102}\u{1169}\u{11c0}"), ("\u{b192}", "\u{b192}",
        "\u{1102}\u{1169}\u{11c1}", "\u{b192}", "\u{1102}\u{1169}\u{11c1}"), ("\u{b193}",
        "\u{b193}", "\u{1102}\u{1169}\u{11c2}", "\u{b193}", "\u{1102}\u{1169}\u{11c2}"),
        ("\u{b194}", "\u{b194}", "\u{1102}\u{116a}", "\u{b194}", "\u{1102}\u{116a}"), ("\u{b195}",
        "\u{b195}", "\u{1102}\u{116a}\u{11a8}", "\u{b195}", "\u{1102}\u{116a}\u{11a8}"),
        ("\u{b196}", "\u{b196}", "\u{1102}\u{116a}\u{11a9}", "\u{b196}",
        "\u{1102}\u{116a}\u{11a9}"), ("\u{b197}", "\u{b197}", "\u{1102}\u{116a}\u{11aa}",
        "\u{b197}", "\u{1102}\u{116a}\u{11aa}"), ("\u{b198}", "\u{b198}",
        "\u{1102}\u{116a}\u{11ab}", "\u{b198}", "\u{1102}\u{116a}\u{11ab}"), ("\u{b199}",
        "\u{b199}", "\u{1102}\u{116a}\u{11ac}", "\u{b199}", "\u{1102}\u{116a}\u{11ac}"),
        ("\u{b19a}", "\u{b19a}", "\u{1102}\u{116a}\u{11ad}", "\u{b19a}",
        "\u{1102}\u{116a}\u{11ad}"), ("\u{b19b}", "\u{b19b}", "\u{1102}\u{116a}\u{11ae}",
        "\u{b19b}", "\u{1102}\u{116a}\u{11ae}"), ("\u{b19c}", "\u{b19c}",
        "\u{1102}\u{116a}\u{11af}", "\u{b19c}", "\u{1102}\u{116a}\u{11af}"), ("\u{b19d}",
        "\u{b19d}", "\u{1102}\u{116a}\u{11b0}", "\u{b19d}", "\u{1102}\u{116a}\u{11b0}"),
        ("\u{b19e}", "\u{b19e}", "\u{1102}\u{116a}\u{11b1}", "\u{b19e}",
        "\u{1102}\u{116a}\u{11b1}"), ("\u{b19f}", "\u{b19f}", "\u{1102}\u{116a}\u{11b2}",
        "\u{b19f}", "\u{1102}\u{116a}\u{11b2}"), ("\u{b1a0}", "\u{b1a0}",
        "\u{1102}\u{116a}\u{11b3}", "\u{b1a0}", "\u{1102}\u{116a}\u{11b3}"), ("\u{b1a1}",
        "\u{b1a1}", "\u{1102}\u{116a}\u{11b4}", "\u{b1a1}", "\u{1102}\u{116a}\u{11b4}"),
        ("\u{b1a2}", "\u{b1a2}", "\u{1102}\u{116a}\u{11b5}", "\u{b1a2}",
        "\u{1102}\u{116a}\u{11b5}"), ("\u{b1a3}", "\u{b1a3}", "\u{1102}\u{116a}\u{11b6}",
        "\u{b1a3}", "\u{1102}\u{116a}\u{11b6}"), ("\u{b1a4}", "\u{b1a4}",
        "\u{1102}\u{116a}\u{11b7}", "\u{b1a4}", "\u{1102}\u{116a}\u{11b7}"), ("\u{b1a5}",
        "\u{b1a5}", "\u{1102}\u{116a}\u{11b8}", "\u{b1a5}", "\u{1102}\u{116a}\u{11b8}"),
        ("\u{b1a6}", "\u{b1a6}", "\u{1102}\u{116a}\u{11b9}", "\u{b1a6}",
        "\u{1102}\u{116a}\u{11b9}"), ("\u{b1a7}", "\u{b1a7}", "\u{1102}\u{116a}\u{11ba}",
        "\u{b1a7}", "\u{1102}\u{116a}\u{11ba}"), ("\u{b1a8}", "\u{b1a8}",
        "\u{1102}\u{116a}\u{11bb}", "\u{b1a8}", "\u{1102}\u{116a}\u{11bb}"), ("\u{b1a9}",
        "\u{b1a9}", "\u{1102}\u{116a}\u{11bc}", "\u{b1a9}", "\u{1102}\u{116a}\u{11bc}"),
        ("\u{b1aa}", "\u{b1aa}", "\u{1102}\u{116a}\u{11bd}", "\u{b1aa}",
        "\u{1102}\u{116a}\u{11bd}"), ("\u{b1ab}", "\u{b1ab}", "\u{1102}\u{116a}\u{11be}",
        "\u{b1ab}", "\u{1102}\u{116a}\u{11be}"), ("\u{b1ac}", "\u{b1ac}",
        "\u{1102}\u{116a}\u{11bf}", "\u{b1ac}", "\u{1102}\u{116a}\u{11bf}"), ("\u{b1ad}",
        "\u{b1ad}", "\u{1102}\u{116a}\u{11c0}", "\u{b1ad}", "\u{1102}\u{116a}\u{11c0}"),
        ("\u{b1ae}", "\u{b1ae}", "\u{1102}\u{116a}\u{11c1}", "\u{b1ae}",
        "\u{1102}\u{116a}\u{11c1}"), ("\u{b1af}", "\u{b1af}", "\u{1102}\u{116a}\u{11c2}",
        "\u{b1af}", "\u{1102}\u{116a}\u{11c2}"), ("\u{b1b0}", "\u{b1b0}", "\u{1102}\u{116b}",
        "\u{b1b0}", "\u{1102}\u{116b}"), ("\u{b1b1}", "\u{b1b1}", "\u{1102}\u{116b}\u{11a8}",
        "\u{b1b1}", "\u{1102}\u{116b}\u{11a8}"), ("\u{b1b2}", "\u{b1b2}",
        "\u{1102}\u{116b}\u{11a9}", "\u{b1b2}", "\u{1102}\u{116b}\u{11a9}"), ("\u{b1b3}",
        "\u{b1b3}", "\u{1102}\u{116b}\u{11aa}", "\u{b1b3}", "\u{1102}\u{116b}\u{11aa}"),
        ("\u{b1b4}", "\u{b1b4}", "\u{1102}\u{116b}\u{11ab}", "\u{b1b4}",
        "\u{1102}\u{116b}\u{11ab}"), ("\u{b1b5}", "\u{b1b5}", "\u{1102}\u{116b}\u{11ac}",
        "\u{b1b5}", "\u{1102}\u{116b}\u{11ac}"), ("\u{b1b6}", "\u{b1b6}",
        "\u{1102}\u{116b}\u{11ad}", "\u{b1b6}", "\u{1102}\u{116b}\u{11ad}"), ("\u{b1b7}",
        "\u{b1b7}", "\u{1102}\u{116b}\u{11ae}", "\u{b1b7}", "\u{1102}\u{116b}\u{11ae}"),
        ("\u{b1b8}", "\u{b1b8}", "\u{1102}\u{116b}\u{11af}", "\u{b1b8}",
        "\u{1102}\u{116b}\u{11af}"), ("\u{b1b9}", "\u{b1b9}", "\u{1102}\u{116b}\u{11b0}",
        "\u{b1b9}", "\u{1102}\u{116b}\u{11b0}"), ("\u{b1ba}", "\u{b1ba}",
        "\u{1102}\u{116b}\u{11b1}", "\u{b1ba}", "\u{1102}\u{116b}\u{11b1}"), ("\u{b1bb}",
        "\u{b1bb}", "\u{1102}\u{116b}\u{11b2}", "\u{b1bb}", "\u{1102}\u{116b}\u{11b2}"),
        ("\u{b1bc}", "\u{b1bc}", "\u{1102}\u{116b}\u{11b3}", "\u{b1bc}",
        "\u{1102}\u{116b}\u{11b3}"), ("\u{b1bd}", "\u{b1bd}", "\u{1102}\u{116b}\u{11b4}",
        "\u{b1bd}", "\u{1102}\u{116b}\u{11b4}"), ("\u{b1be}", "\u{b1be}",
        "\u{1102}\u{116b}\u{11b5}", "\u{b1be}", "\u{1102}\u{116b}\u{11b5}"), ("\u{b1bf}",
        "\u{b1bf}", "\u{1102}\u{116b}\u{11b6}", "\u{b1bf}", "\u{1102}\u{116b}\u{11b6}"),
        ("\u{b1c0}", "\u{b1c0}", "\u{1102}\u{116b}\u{11b7}", "\u{b1c0}",
        "\u{1102}\u{116b}\u{11b7}"), ("\u{b1c1}", "\u{b1c1}", "\u{1102}\u{116b}\u{11b8}",
        "\u{b1c1}", "\u{1102}\u{116b}\u{11b8}"), ("\u{b1c2}", "\u{b1c2}",
        "\u{1102}\u{116b}\u{11b9}", "\u{b1c2}", "\u{1102}\u{116b}\u{11b9}"), ("\u{b1c3}",
        "\u{b1c3}", "\u{1102}\u{116b}\u{11ba}", "\u{b1c3}", "\u{1102}\u{116b}\u{11ba}"),
        ("\u{b1c4}", "\u{b1c4}", "\u{1102}\u{116b}\u{11bb}", "\u{b1c4}",
        "\u{1102}\u{116b}\u{11bb}"), ("\u{b1c5}", "\u{b1c5}", "\u{1102}\u{116b}\u{11bc}",
        "\u{b1c5}", "\u{1102}\u{116b}\u{11bc}"), ("\u{b1c6}", "\u{b1c6}",
        "\u{1102}\u{116b}\u{11bd}", "\u{b1c6}", "\u{1102}\u{116b}\u{11bd}"), ("\u{b1c7}",
        "\u{b1c7}", "\u{1102}\u{116b}\u{11be}", "\u{b1c7}", "\u{1102}\u{116b}\u{11be}"),
        ("\u{b1c8}", "\u{b1c8}", "\u{1102}\u{116b}\u{11bf}", "\u{b1c8}",
        "\u{1102}\u{116b}\u{11bf}"), ("\u{b1c9}", "\u{b1c9}", "\u{1102}\u{116b}\u{11c0}",
        "\u{b1c9}", "\u{1102}\u{116b}\u{11c0}"), ("\u{b1ca}", "\u{b1ca}",
        "\u{1102}\u{116b}\u{11c1}", "\u{b1ca}", "\u{1102}\u{116b}\u{11c1}"), ("\u{b1cb}",
        "\u{b1cb}", "\u{1102}\u{116b}\u{11c2}", "\u{b1cb}", "\u{1102}\u{116b}\u{11c2}"),
        ("\u{b1cc}", "\u{b1cc}", "\u{1102}\u{116c}", "\u{b1cc}", "\u{1102}\u{116c}"), ("\u{b1cd}",
        "\u{b1cd}", "\u{1102}\u{116c}\u{11a8}", "\u{b1cd}", "\u{1102}\u{116c}\u{11a8}"),
        ("\u{b1ce}", "\u{b1ce}", "\u{1102}\u{116c}\u{11a9}", "\u{b1ce}",
        "\u{1102}\u{116c}\u{11a9}"), ("\u{b1cf}", "\u{b1cf}", "\u{1102}\u{116c}\u{11aa}",
        "\u{b1cf}", "\u{1102}\u{116c}\u{11aa}"), ("\u{b1d0}", "\u{b1d0}",
        "\u{1102}\u{116c}\u{11ab}", "\u{b1d0}", "\u{1102}\u{116c}\u{11ab}"), ("\u{b1d1}",
        "\u{b1d1}", "\u{1102}\u{116c}\u{11ac}", "\u{b1d1}", "\u{1102}\u{116c}\u{11ac}"),
        ("\u{b1d2}", "\u{b1d2}", "\u{1102}\u{116c}\u{11ad}", "\u{b1d2}",
        "\u{1102}\u{116c}\u{11ad}"), ("\u{b1d3}", "\u{b1d3}", "\u{1102}\u{116c}\u{11ae}",
        "\u{b1d3}", "\u{1102}\u{116c}\u{11ae}"), ("\u{b1d4}", "\u{b1d4}",
        "\u{1102}\u{116c}\u{11af}", "\u{b1d4}", "\u{1102}\u{116c}\u{11af}"), ("\u{b1d5}",
        "\u{b1d5}", "\u{1102}\u{116c}\u{11b0}", "\u{b1d5}", "\u{1102}\u{116c}\u{11b0}"),
        ("\u{b1d6}", "\u{b1d6}", "\u{1102}\u{116c}\u{11b1}", "\u{b1d6}",
        "\u{1102}\u{116c}\u{11b1}"), ("\u{b1d7}", "\u{b1d7}", "\u{1102}\u{116c}\u{11b2}",
        "\u{b1d7}", "\u{1102}\u{116c}\u{11b2}"), ("\u{b1d8}", "\u{b1d8}",
        "\u{1102}\u{116c}\u{11b3}", "\u{b1d8}", "\u{1102}\u{116c}\u{11b3}"), ("\u{b1d9}",
        "\u{b1d9}", "\u{1102}\u{116c}\u{11b4}", "\u{b1d9}", "\u{1102}\u{116c}\u{11b4}"),
        ("\u{b1da}", "\u{b1da}", "\u{1102}\u{116c}\u{11b5}", "\u{b1da}",
        "\u{1102}\u{116c}\u{11b5}"), ("\u{b1db}", "\u{b1db}", "\u{1102}\u{116c}\u{11b6}",
        "\u{b1db}", "\u{1102}\u{116c}\u{11b6}"), ("\u{b1dc}", "\u{b1dc}",
        "\u{1102}\u{116c}\u{11b7}", "\u{b1dc}", "\u{1102}\u{116c}\u{11b7}"), ("\u{b1dd}",
        "\u{b1dd}", "\u{1102}\u{116c}\u{11b8}", "\u{b1dd}", "\u{1102}\u{116c}\u{11b8}"),
        ("\u{b1de}", "\u{b1de}", "\u{1102}\u{116c}\u{11b9}", "\u{b1de}",
        "\u{1102}\u{116c}\u{11b9}"), ("\u{b1df}", "\u{b1df}", "\u{1102}\u{116c}\u{11ba}",
        "\u{b1df}", "\u{1102}\u{116c}\u{11ba}"), ("\u{b1e0}", "\u{b1e0}",
        "\u{1102}\u{116c}\u{11bb}", "\u{b1e0}", "\u{1102}\u{116c}\u{11bb}"), ("\u{b1e1}",
        "\u{b1e1}", "\u{1102}\u{116c}\u{11bc}", "\u{b1e1}", "\u{1102}\u{116c}\u{11bc}"),
        ("\u{b1e2}", "\u{b1e2}", "\u{1102}\u{116c}\u{11bd}", "\u{b1e2}",
        "\u{1102}\u{116c}\u{11bd}"), ("\u{b1e3}", "\u{b1e3}", "\u{1102}\u{116c}\u{11be}",
        "\u{b1e3}", "\u{1102}\u{116c}\u{11be}"), ("\u{b1e4}", "\u{b1e4}",
        "\u{1102}\u{116c}\u{11bf}", "\u{b1e4}", "\u{1102}\u{116c}\u{11bf}"), ("\u{b1e5}",
        "\u{b1e5}", "\u{1102}\u{116c}\u{11c0}", "\u{b1e5}", "\u{1102}\u{116c}\u{11c0}"),
        ("\u{b1e6}", "\u{b1e6}", "\u{1102}\u{116c}\u{11c1}", "\u{b1e6}",
        "\u{1102}\u{116c}\u{11c1}"), ("\u{b1e7}", "\u{b1e7}", "\u{1102}\u{116c}\u{11c2}",
        "\u{b1e7}", "\u{1102}\u{116c}\u{11c2}"), ("\u{b1e8}", "\u{b1e8}", "\u{1102}\u{116d}",
        "\u{b1e8}", "\u{1102}\u{116d}"), ("\u{b1e9}", "\u{b1e9}", "\u{1102}\u{116d}\u{11a8}",
        "\u{b1e9}", "\u{1102}\u{116d}\u{11a8}"), ("\u{b1ea}", "\u{b1ea}",
        "\u{1102}\u{116d}\u{11a9}", "\u{b1ea}", "\u{1102}\u{116d}\u{11a9}"), ("\u{b1eb}",
        "\u{b1eb}", "\u{1102}\u{116d}\u{11aa}", "\u{b1eb}", "\u{1102}\u{116d}\u{11aa}"),
        ("\u{b1ec}", "\u{b1ec}", "\u{1102}\u{116d}\u{11ab}", "\u{b1ec}",
        "\u{1102}\u{116d}\u{11ab}"), ("\u{b1ed}", "\u{b1ed}", "\u{1102}\u{116d}\u{11ac}",
        "\u{b1ed}", "\u{1102}\u{116d}\u{11ac}"), ("\u{b1ee}", "\u{b1ee}",
        "\u{1102}\u{116d}\u{11ad}", "\u{b1ee}", "\u{1102}\u{116d}\u{11ad}"), ("\u{b1ef}",
        "\u{b1ef}", "\u{1102}\u{116d}\u{11ae}", "\u{b1ef}", "\u{1102}\u{116d}\u{11ae}"),
        ("\u{b1f0}", "\u{b1f0}", "\u{1102}\u{116d}\u{11af}", "\u{b1f0}",
        "\u{1102}\u{116d}\u{11af}"), ("\u{b1f1}", "\u{b1f1}", "\u{1102}\u{116d}\u{11b0}",
        "\u{b1f1}", "\u{1102}\u{116d}\u{11b0}"), ("\u{b1f2}", "\u{b1f2}",
        "\u{1102}\u{116d}\u{11b1}", "\u{b1f2}", "\u{1102}\u{116d}\u{11b1}"), ("\u{b1f3}",
        "\u{b1f3}", "\u{1102}\u{116d}\u{11b2}", "\u{b1f3}", "\u{1102}\u{116d}\u{11b2}"),
        ("\u{b1f4}", "\u{b1f4}", "\u{1102}\u{116d}\u{11b3}", "\u{b1f4}",
        "\u{1102}\u{116d}\u{11b3}"), ("\u{b1f5}", "\u{b1f5}", "\u{1102}\u{116d}\u{11b4}",
        "\u{b1f5}", "\u{1102}\u{116d}\u{11b4}"), ("\u{b1f6}", "\u{b1f6}",
        "\u{1102}\u{116d}\u{11b5}", "\u{b1f6}", "\u{1102}\u{116d}\u{11b5}"), ("\u{b1f7}",
        "\u{b1f7}", "\u{1102}\u{116d}\u{11b6}", "\u{b1f7}", "\u{1102}\u{116d}\u{11b6}"),
        ("\u{b1f8}", "\u{b1f8}", "\u{1102}\u{116d}\u{11b7}", "\u{b1f8}",
        "\u{1102}\u{116d}\u{11b7}"), ("\u{b1f9}", "\u{b1f9}", "\u{1102}\u{116d}\u{11b8}",
        "\u{b1f9}", "\u{1102}\u{116d}\u{11b8}"), ("\u{b1fa}", "\u{b1fa}",
        "\u{1102}\u{116d}\u{11b9}", "\u{b1fa}", "\u{1102}\u{116d}\u{11b9}"), ("\u{b1fb}",
        "\u{b1fb}", "\u{1102}\u{116d}\u{11ba}", "\u{b1fb}", "\u{1102}\u{116d}\u{11ba}"),
        ("\u{b1fc}", "\u{b1fc}", "\u{1102}\u{116d}\u{11bb}", "\u{b1fc}",
        "\u{1102}\u{116d}\u{11bb}"), ("\u{b1fd}", "\u{b1fd}", "\u{1102}\u{116d}\u{11bc}",
        "\u{b1fd}", "\u{1102}\u{116d}\u{11bc}"), ("\u{b1fe}", "\u{b1fe}",
        "\u{1102}\u{116d}\u{11bd}", "\u{b1fe}", "\u{1102}\u{116d}\u{11bd}"), ("\u{b1ff}",
        "\u{b1ff}", "\u{1102}\u{116d}\u{11be}", "\u{b1ff}", "\u{1102}\u{116d}\u{11be}"),
        ("\u{b200}", "\u{b200}", "\u{1102}\u{116d}\u{11bf}", "\u{b200}",
        "\u{1102}\u{116d}\u{11bf}"), ("\u{b201}", "\u{b201}", "\u{1102}\u{116d}\u{11c0}",
        "\u{b201}", "\u{1102}\u{116d}\u{11c0}"), ("\u{b202}", "\u{b202}",
        "\u{1102}\u{116d}\u{11c1}", "\u{b202}", "\u{1102}\u{116d}\u{11c1}"), ("\u{b203}",
        "\u{b203}", "\u{1102}\u{116d}\u{11c2}", "\u{b203}", "\u{1102}\u{116d}\u{11c2}"),
        ("\u{b204}", "\u{b204}", "\u{1102}\u{116e}", "\u{b204}", "\u{1102}\u{116e}"), ("\u{b205}",
        "\u{b205}", "\u{1102}\u{116e}\u{11a8}", "\u{b205}", "\u{1102}\u{116e}\u{11a8}"),
        ("\u{b206}", "\u{b206}", "\u{1102}\u{116e}\u{11a9}", "\u{b206}",
        "\u{1102}\u{116e}\u{11a9}"), ("\u{b207}", "\u{b207}", "\u{1102}\u{116e}\u{11aa}",
        "\u{b207}", "\u{1102}\u{116e}\u{11aa}"), ("\u{b208}", "\u{b208}",
        "\u{1102}\u{116e}\u{11ab}", "\u{b208}", "\u{1102}\u{116e}\u{11ab}"), ("\u{b209}",
        "\u{b209}", "\u{1102}\u{116e}\u{11ac}", "\u{b209}", "\u{1102}\u{116e}\u{11ac}"),
        ("\u{b20a}", "\u{b20a}", "\u{1102}\u{116e}\u{11ad}", "\u{b20a}",
        "\u{1102}\u{116e}\u{11ad}"), ("\u{b20b}", "\u{b20b}", "\u{1102}\u{116e}\u{11ae}",
        "\u{b20b}", "\u{1102}\u{116e}\u{11ae}"), ("\u{b20c}", "\u{b20c}",
        "\u{1102}\u{116e}\u{11af}", "\u{b20c}", "\u{1102}\u{116e}\u{11af}"), ("\u{b20d}",
        "\u{b20d}", "\u{1102}\u{116e}\u{11b0}", "\u{b20d}", "\u{1102}\u{116e}\u{11b0}"),
        ("\u{b20e}", "\u{b20e}", "\u{1102}\u{116e}\u{11b1}", "\u{b20e}",
        "\u{1102}\u{116e}\u{11b1}"), ("\u{b20f}", "\u{b20f}", "\u{1102}\u{116e}\u{11b2}",
        "\u{b20f}", "\u{1102}\u{116e}\u{11b2}"), ("\u{b210}", "\u{b210}",
        "\u{1102}\u{116e}\u{11b3}", "\u{b210}", "\u{1102}\u{116e}\u{11b3}"), ("\u{b211}",
        "\u{b211}", "\u{1102}\u{116e}\u{11b4}", "\u{b211}", "\u{1102}\u{116e}\u{11b4}"),
        ("\u{b212}", "\u{b212}", "\u{1102}\u{116e}\u{11b5}", "\u{b212}",
        "\u{1102}\u{116e}\u{11b5}"), ("\u{b213}", "\u{b213}", "\u{1102}\u{116e}\u{11b6}",
        "\u{b213}", "\u{1102}\u{116e}\u{11b6}"), ("\u{b214}", "\u{b214}",
        "\u{1102}\u{116e}\u{11b7}", "\u{b214}", "\u{1102}\u{116e}\u{11b7}"), ("\u{b215}",
        "\u{b215}", "\u{1102}\u{116e}\u{11b8}", "\u{b215}", "\u{1102}\u{116e}\u{11b8}"),
        ("\u{b216}", "\u{b216}", "\u{1102}\u{116e}\u{11b9}", "\u{b216}",
        "\u{1102}\u{116e}\u{11b9}"), ("\u{b217}", "\u{b217}", "\u{1102}\u{116e}\u{11ba}",
        "\u{b217}", "\u{1102}\u{116e}\u{11ba}"), ("\u{b218}", "\u{b218}",
        "\u{1102}\u{116e}\u{11bb}", "\u{b218}", "\u{1102}\u{116e}\u{11bb}"), ("\u{b219}",
        "\u{b219}", "\u{1102}\u{116e}\u{11bc}", "\u{b219}", "\u{1102}\u{116e}\u{11bc}"),
        ("\u{b21a}", "\u{b21a}", "\u{1102}\u{116e}\u{11bd}", "\u{b21a}",
        "\u{1102}\u{116e}\u{11bd}"), ("\u{b21b}", "\u{b21b}", "\u{1102}\u{116e}\u{11be}",
        "\u{b21b}", "\u{1102}\u{116e}\u{11be}"), ("\u{b21c}", "\u{b21c}",
        "\u{1102}\u{116e}\u{11bf}", "\u{b21c}", "\u{1102}\u{116e}\u{11bf}"), ("\u{b21d}",
        "\u{b21d}", "\u{1102}\u{116e}\u{11c0}", "\u{b21d}", "\u{1102}\u{116e}\u{11c0}"),
        ("\u{b21e}", "\u{b21e}", "\u{1102}\u{116e}\u{11c1}", "\u{b21e}",
        "\u{1102}\u{116e}\u{11c1}"), ("\u{b21f}", "\u{b21f}", "\u{1102}\u{116e}\u{11c2}",
        "\u{b21f}", "\u{1102}\u{116e}\u{11c2}"), ("\u{b220}", "\u{b220}", "\u{1102}\u{116f}",
        "\u{b220}", "\u{1102}\u{116f}"), ("\u{b221}", "\u{b221}", "\u{1102}\u{116f}\u{11a8}",
        "\u{b221}", "\u{1102}\u{116f}\u{11a8}"), ("\u{b222}", "\u{b222}",
        "\u{1102}\u{116f}\u{11a9}", "\u{b222}", "\u{1102}\u{116f}\u{11a9}"), ("\u{b223}",
        "\u{b223}", "\u{1102}\u{116f}\u{11aa}", "\u{b223}", "\u{1102}\u{116f}\u{11aa}"),
        ("\u{b224}", "\u{b224}", "\u{1102}\u{116f}\u{11ab}", "\u{b224}",
        "\u{1102}\u{116f}\u{11ab}"), ("\u{b225}", "\u{b225}", "\u{1102}\u{116f}\u{11ac}",
        "\u{b225}", "\u{1102}\u{116f}\u{11ac}"), ("\u{b226}", "\u{b226}",
        "\u{1102}\u{116f}\u{11ad}", "\u{b226}", "\u{1102}\u{116f}\u{11ad}"), ("\u{b227}",
        "\u{b227}", "\u{1102}\u{116f}\u{11ae}", "\u{b227}", "\u{1102}\u{116f}\u{11ae}"),
        ("\u{b228}", "\u{b228}", "\u{1102}\u{116f}\u{11af}", "\u{b228}",
        "\u{1102}\u{116f}\u{11af}"), ("\u{b229}", "\u{b229}", "\u{1102}\u{116f}\u{11b0}",
        "\u{b229}", "\u{1102}\u{116f}\u{11b0}"), ("\u{b22a}", "\u{b22a}",
        "\u{1102}\u{116f}\u{11b1}", "\u{b22a}", "\u{1102}\u{116f}\u{11b1}"), ("\u{b22b}",
        "\u{b22b}", "\u{1102}\u{116f}\u{11b2}", "\u{b22b}", "\u{1102}\u{116f}\u{11b2}"),
        ("\u{b22c}", "\u{b22c}", "\u{1102}\u{116f}\u{11b3}", "\u{b22c}",
        "\u{1102}\u{116f}\u{11b3}"), ("\u{b22d}", "\u{b22d}", "\u{1102}\u{116f}\u{11b4}",
        "\u{b22d}", "\u{1102}\u{116f}\u{11b4}"), ("\u{b22e}", "\u{b22e}",
        "\u{1102}\u{116f}\u{11b5}", "\u{b22e}", "\u{1102}\u{116f}\u{11b5}"), ("\u{b22f}",
        "\u{b22f}", "\u{1102}\u{116f}\u{11b6}", "\u{b22f}", "\u{1102}\u{116f}\u{11b6}"),
        ("\u{b230}", "\u{b230}", "\u{1102}\u{116f}\u{11b7}", "\u{b230}",
        "\u{1102}\u{116f}\u{11b7}"), ("\u{b231}", "\u{b231}", "\u{1102}\u{116f}\u{11b8}",
        "\u{b231}", "\u{1102}\u{116f}\u{11b8}"), ("\u{b232}", "\u{b232}",
        "\u{1102}\u{116f}\u{11b9}", "\u{b232}", "\u{1102}\u{116f}\u{11b9}"), ("\u{b233}",
        "\u{b233}", "\u{1102}\u{116f}\u{11ba}", "\u{b233}", "\u{1102}\u{116f}\u{11ba}"),
        ("\u{b234}", "\u{b234}", "\u{1102}\u{116f}\u{11bb}", "\u{b234}",
        "\u{1102}\u{116f}\u{11bb}"), ("\u{b235}", "\u{b235}", "\u{1102}\u{116f}\u{11bc}",
        "\u{b235}", "\u{1102}\u{116f}\u{11bc}"), ("\u{b236}", "\u{b236}",
        "\u{1102}\u{116f}\u{11bd}", "\u{b236}", "\u{1102}\u{116f}\u{11bd}"), ("\u{b237}",
        "\u{b237}", "\u{1102}\u{116f}\u{11be}", "\u{b237}", "\u{1102}\u{116f}\u{11be}"),
        ("\u{b238}", "\u{b238}", "\u{1102}\u{116f}\u{11bf}", "\u{b238}",
        "\u{1102}\u{116f}\u{11bf}"), ("\u{b239}", "\u{b239}", "\u{1102}\u{116f}\u{11c0}",
        "\u{b239}", "\u{1102}\u{116f}\u{11c0}"), ("\u{b23a}", "\u{b23a}",
        "\u{1102}\u{116f}\u{11c1}", "\u{b23a}", "\u{1102}\u{116f}\u{11c1}"), ("\u{b23b}",
        "\u{b23b}", "\u{1102}\u{116f}\u{11c2}", "\u{b23b}", "\u{1102}\u{116f}\u{11c2}"),
        ("\u{b23c}", "\u{b23c}", "\u{1102}\u{1170}", "\u{b23c}", "\u{1102}\u{1170}"), ("\u{b23d}",
        "\u{b23d}", "\u{1102}\u{1170}\u{11a8}", "\u{b23d}", "\u{1102}\u{1170}\u{11a8}"),
        ("\u{b23e}", "\u{b23e}", "\u{1102}\u{1170}\u{11a9}", "\u{b23e}",
        "\u{1102}\u{1170}\u{11a9}"), ("\u{b23f}", "\u{b23f}", "\u{1102}\u{1170}\u{11aa}",
        "\u{b23f}", "\u{1102}\u{1170}\u{11aa}"), ("\u{b240}", "\u{b240}",
        "\u{1102}\u{1170}\u{11ab}", "\u{b240}", "\u{1102}\u{1170}\u{11ab}"), ("\u{b241}",
        "\u{b241}", "\u{1102}\u{1170}\u{11ac}", "\u{b241}", "\u{1102}\u{1170}\u{11ac}"),
        ("\u{b242}", "\u{b242}", "\u{1102}\u{1170}\u{11ad}", "\u{b242}",
        "\u{1102}\u{1170}\u{11ad}"), ("\u{b243}", "\u{b243}", "\u{1102}\u{1170}\u{11ae}",
        "\u{b243}", "\u{1102}\u{1170}\u{11ae}"), ("\u{b244}", "\u{b244}",
        "\u{1102}\u{1170}\u{11af}", "\u{b244}", "\u{1102}\u{1170}\u{11af}"), ("\u{b245}",
        "\u{b245}", "\u{1102}\u{1170}\u{11b0}", "\u{b245}", "\u{1102}\u{1170}\u{11b0}"),
        ("\u{b246}", "\u{b246}", "\u{1102}\u{1170}\u{11b1}", "\u{b246}",
        "\u{1102}\u{1170}\u{11b1}"), ("\u{b247}", "\u{b247}", "\u{1102}\u{1170}\u{11b2}",
        "\u{b247}", "\u{1102}\u{1170}\u{11b2}"), ("\u{b248}", "\u{b248}",
        "\u{1102}\u{1170}\u{11b3}", "\u{b248}", "\u{1102}\u{1170}\u{11b3}"), ("\u{b249}",
        "\u{b249}", "\u{1102}\u{1170}\u{11b4}", "\u{b249}", "\u{1102}\u{1170}\u{11b4}"),
        ("\u{b24a}", "\u{b24a}", "\u{1102}\u{1170}\u{11b5}", "\u{b24a}",
        "\u{1102}\u{1170}\u{11b5}"), ("\u{b24b}", "\u{b24b}", "\u{1102}\u{1170}\u{11b6}",
        "\u{b24b}", "\u{1102}\u{1170}\u{11b6}"), ("\u{b24c}", "\u{b24c}",
        "\u{1102}\u{1170}\u{11b7}", "\u{b24c}", "\u{1102}\u{1170}\u{11b7}"), ("\u{b24d}",
        "\u{b24d}", "\u{1102}\u{1170}\u{11b8}", "\u{b24d}", "\u{1102}\u{1170}\u{11b8}"),
        ("\u{b24e}", "\u{b24e}", "\u{1102}\u{1170}\u{11b9}", "\u{b24e}",
        "\u{1102}\u{1170}\u{11b9}"), ("\u{b24f}", "\u{b24f}", "\u{1102}\u{1170}\u{11ba}",
        "\u{b24f}", "\u{1102}\u{1170}\u{11ba}"), ("\u{b250}", "\u{b250}",
        "\u{1102}\u{1170}\u{11bb}", "\u{b250}", "\u{1102}\u{1170}\u{11bb}"), ("\u{b251}",
        "\u{b251}", "\u{1102}\u{1170}\u{11bc}", "\u{b251}", "\u{1102}\u{1170}\u{11bc}"),
        ("\u{b252}", "\u{b252}", "\u{1102}\u{1170}\u{11bd}", "\u{b252}",
        "\u{1102}\u{1170}\u{11bd}"), ("\u{b253}", "\u{b253}", "\u{1102}\u{1170}\u{11be}",
        "\u{b253}", "\u{1102}\u{1170}\u{11be}"), ("\u{b254}", "\u{b254}",
        "\u{1102}\u{1170}\u{11bf}", "\u{b254}", "\u{1102}\u{1170}\u{11bf}"), ("\u{b255}",
        "\u{b255}", "\u{1102}\u{1170}\u{11c0}", "\u{b255}", "\u{1102}\u{1170}\u{11c0}"),
        ("\u{b256}", "\u{b256}", "\u{1102}\u{1170}\u{11c1}", "\u{b256}",
        "\u{1102}\u{1170}\u{11c1}"), ("\u{b257}", "\u{b257}", "\u{1102}\u{1170}\u{11c2}",
        "\u{b257}", "\u{1102}\u{1170}\u{11c2}"), ("\u{b258}", "\u{b258}", "\u{1102}\u{1171}",
        "\u{b258}", "\u{1102}\u{1171}"), ("\u{b259}", "\u{b259}", "\u{1102}\u{1171}\u{11a8}",
        "\u{b259}", "\u{1102}\u{1171}\u{11a8}"), ("\u{b25a}", "\u{b25a}",
        "\u{1102}\u{1171}\u{11a9}", "\u{b25a}", "\u{1102}\u{1171}\u{11a9}"), ("\u{b25b}",
        "\u{b25b}", "\u{1102}\u{1171}\u{11aa}", "\u{b25b}", "\u{1102}\u{1171}\u{11aa}"),
        ("\u{b25c}", "\u{b25c}", "\u{1102}\u{1171}\u{11ab}", "\u{b25c}",
        "\u{1102}\u{1171}\u{11ab}"), ("\u{b25d}", "\u{b25d}", "\u{1102}\u{1171}\u{11ac}",
        "\u{b25d}", "\u{1102}\u{1171}\u{11ac}"), ("\u{b25e}", "\u{b25e}",
        "\u{1102}\u{1171}\u{11ad}", "\u{b25e}", "\u{1102}\u{1171}\u{11ad}"), ("\u{b25f}",
        "\u{b25f}", "\u{1102}\u{1171}\u{11ae}", "\u{b25f}", "\u{1102}\u{1171}\u{11ae}"),
        ("\u{b260}", "\u{b260}", "\u{1102}\u{1171}\u{11af}", "\u{b260}",
        "\u{1102}\u{1171}\u{11af}"), ("\u{b261}", "\u{b261}", "\u{1102}\u{1171}\u{11b0}",
        "\u{b261}", "\u{1102}\u{1171}\u{11b0}"), ("\u{b262}", "\u{b262}",
        "\u{1102}\u{1171}\u{11b1}", "\u{b262}", "\u{1102}\u{1171}\u{11b1}"), ("\u{b263}",
        "\u{b263}", "\u{1102}\u{1171}\u{11b2}", "\u{b263}", "\u{1102}\u{1171}\u{11b2}"),
        ("\u{b264}", "\u{b264}", "\u{1102}\u{1171}\u{11b3}", "\u{b264}",
        "\u{1102}\u{1171}\u{11b3}"), ("\u{b265}", "\u{b265}", "\u{1102}\u{1171}\u{11b4}",
        "\u{b265}", "\u{1102}\u{1171}\u{11b4}"), ("\u{b266}", "\u{b266}",
        "\u{1102}\u{1171}\u{11b5}", "\u{b266}", "\u{1102}\u{1171}\u{11b5}"), ("\u{b267}",
        "\u{b267}", "\u{1102}\u{1171}\u{11b6}", "\u{b267}", "\u{1102}\u{1171}\u{11b6}"),
        ("\u{b268}", "\u{b268}", "\u{1102}\u{1171}\u{11b7}", "\u{b268}",
        "\u{1102}\u{1171}\u{11b7}"), ("\u{b269}", "\u{b269}", "\u{1102}\u{1171}\u{11b8}",
        "\u{b269}", "\u{1102}\u{1171}\u{11b8}"), ("\u{b26a}", "\u{b26a}",
        "\u{1102}\u{1171}\u{11b9}", "\u{b26a}", "\u{1102}\u{1171}\u{11b9}"), ("\u{b26b}",
        "\u{b26b}", "\u{1102}\u{1171}\u{11ba}", "\u{b26b}", "\u{1102}\u{1171}\u{11ba}"),
        ("\u{b26c}", "\u{b26c}", "\u{1102}\u{1171}\u{11bb}", "\u{b26c}",
        "\u{1102}\u{1171}\u{11bb}"), ("\u{b26d}", "\u{b26d}", "\u{1102}\u{1171}\u{11bc}",
        "\u{b26d}", "\u{1102}\u{1171}\u{11bc}"), ("\u{b26e}", "\u{b26e}",
        "\u{1102}\u{1171}\u{11bd}", "\u{b26e}", "\u{1102}\u{1171}\u{11bd}"), ("\u{b26f}",
        "\u{b26f}", "\u{1102}\u{1171}\u{11be}", "\u{b26f}", "\u{1102}\u{1171}\u{11be}"),
        ("\u{b270}", "\u{b270}", "\u{1102}\u{1171}\u{11bf}", "\u{b270}",
        "\u{1102}\u{1171}\u{11bf}"), ("\u{b271}", "\u{b271}", "\u{1102}\u{1171}\u{11c0}",
        "\u{b271}", "\u{1102}\u{1171}\u{11c0}"), ("\u{b272}", "\u{b272}",
        "\u{1102}\u{1171}\u{11c1}", "\u{b272}", "\u{1102}\u{1171}\u{11c1}"), ("\u{b273}",
        "\u{b273}", "\u{1102}\u{1171}\u{11c2}", "\u{b273}", "\u{1102}\u{1171}\u{11c2}"),
        ("\u{b274}", "\u{b274}", "\u{1102}\u{1172}", "\u{b274}", "\u{1102}\u{1172}"), ("\u{b275}",
        "\u{b275}", "\u{1102}\u{1172}\u{11a8}", "\u{b275}", "\u{1102}\u{1172}\u{11a8}"),
        ("\u{b276}", "\u{b276}", "\u{1102}\u{1172}\u{11a9}", "\u{b276}",
        "\u{1102}\u{1172}\u{11a9}"), ("\u{b277}", "\u{b277}", "\u{1102}\u{1172}\u{11aa}",
        "\u{b277}", "\u{1102}\u{1172}\u{11aa}"), ("\u{b278}", "\u{b278}",
        "\u{1102}\u{1172}\u{11ab}", "\u{b278}", "\u{1102}\u{1172}\u{11ab}"), ("\u{b279}",
        "\u{b279}", "\u{1102}\u{1172}\u{11ac}", "\u{b279}", "\u{1102}\u{1172}\u{11ac}"),
        ("\u{b27a}", "\u{b27a}", "\u{1102}\u{1172}\u{11ad}", "\u{b27a}",
        "\u{1102}\u{1172}\u{11ad}"), ("\u{b27b}", "\u{b27b}", "\u{1102}\u{1172}\u{11ae}",
        "\u{b27b}", "\u{1102}\u{1172}\u{11ae}"), ("\u{b27c}", "\u{b27c}",
        "\u{1102}\u{1172}\u{11af}", "\u{b27c}", "\u{1102}\u{1172}\u{11af}"), ("\u{b27d}",
        "\u{b27d}", "\u{1102}\u{1172}\u{11b0}", "\u{b27d}", "\u{1102}\u{1172}\u{11b0}"),
        ("\u{b27e}", "\u{b27e}", "\u{1102}\u{1172}\u{11b1}", "\u{b27e}",
        "\u{1102}\u{1172}\u{11b1}"), ("\u{b27f}", "\u{b27f}", "\u{1102}\u{1172}\u{11b2}",
        "\u{b27f}", "\u{1102}\u{1172}\u{11b2}"), ("\u{b280}", "\u{b280}",
        "\u{1102}\u{1172}\u{11b3}", "\u{b280}", "\u{1102}\u{1172}\u{11b3}"), ("\u{b281}",
        "\u{b281}", "\u{1102}\u{1172}\u{11b4}", "\u{b281}", "\u{1102}\u{1172}\u{11b4}"),
        ("\u{b282}", "\u{b282}", "\u{1102}\u{1172}\u{11b5}", "\u{b282}",
        "\u{1102}\u{1172}\u{11b5}"), ("\u{b283}", "\u{b283}", "\u{1102}\u{1172}\u{11b6}",
        "\u{b283}", "\u{1102}\u{1172}\u{11b6}"), ("\u{b284}", "\u{b284}",
        "\u{1102}\u{1172}\u{11b7}", "\u{b284}", "\u{1102}\u{1172}\u{11b7}"), ("\u{b285}",
        "\u{b285}", "\u{1102}\u{1172}\u{11b8}", "\u{b285}", "\u{1102}\u{1172}\u{11b8}"),
        ("\u{b286}", "\u{b286}", "\u{1102}\u{1172}\u{11b9}", "\u{b286}",
        "\u{1102}\u{1172}\u{11b9}"), ("\u{b287}", "\u{b287}", "\u{1102}\u{1172}\u{11ba}",
        "\u{b287}", "\u{1102}\u{1172}\u{11ba}"), ("\u{b288}", "\u{b288}",
        "\u{1102}\u{1172}\u{11bb}", "\u{b288}", "\u{1102}\u{1172}\u{11bb}"), ("\u{b289}",
        "\u{b289}", "\u{1102}\u{1172}\u{11bc}", "\u{b289}", "\u{1102}\u{1172}\u{11bc}"),
        ("\u{b28a}", "\u{b28a}", "\u{1102}\u{1172}\u{11bd}", "\u{b28a}",
        "\u{1102}\u{1172}\u{11bd}"), ("\u{b28b}", "\u{b28b}", "\u{1102}\u{1172}\u{11be}",
        "\u{b28b}", "\u{1102}\u{1172}\u{11be}"), ("\u{b28c}", "\u{b28c}",
        "\u{1102}\u{1172}\u{11bf}", "\u{b28c}", "\u{1102}\u{1172}\u{11bf}"), ("\u{b28d}",
        "\u{b28d}", "\u{1102}\u{1172}\u{11c0}", "\u{b28d}", "\u{1102}\u{1172}\u{11c0}"),
        ("\u{b28e}", "\u{b28e}", "\u{1102}\u{1172}\u{11c1}", "\u{b28e}",
        "\u{1102}\u{1172}\u{11c1}"), ("\u{b28f}", "\u{b28f}", "\u{1102}\u{1172}\u{11c2}",
        "\u{b28f}", "\u{1102}\u{1172}\u{11c2}"), ("\u{b290}", "\u{b290}", "\u{1102}\u{1173}",
        "\u{b290}", "\u{1102}\u{1173}"), ("\u{b291}", "\u{b291}", "\u{1102}\u{1173}\u{11a8}",
        "\u{b291}", "\u{1102}\u{1173}\u{11a8}"), ("\u{b292}", "\u{b292}",
        "\u{1102}\u{1173}\u{11a9}", "\u{b292}", "\u{1102}\u{1173}\u{11a9}"), ("\u{b293}",
        "\u{b293}", "\u{1102}\u{1173}\u{11aa}", "\u{b293}", "\u{1102}\u{1173}\u{11aa}"),
        ("\u{b294}", "\u{b294}", "\u{1102}\u{1173}\u{11ab}", "\u{b294}",
        "\u{1102}\u{1173}\u{11ab}"), ("\u{b295}", "\u{b295}", "\u{1102}\u{1173}\u{11ac}",
        "\u{b295}", "\u{1102}\u{1173}\u{11ac}"), ("\u{b296}", "\u{b296}",
        "\u{1102}\u{1173}\u{11ad}", "\u{b296}", "\u{1102}\u{1173}\u{11ad}"), ("\u{b297}",
        "\u{b297}", "\u{1102}\u{1173}\u{11ae}", "\u{b297}", "\u{1102}\u{1173}\u{11ae}"),
        ("\u{b298}", "\u{b298}", "\u{1102}\u{1173}\u{11af}", "\u{b298}",
        "\u{1102}\u{1173}\u{11af}"), ("\u{b299}", "\u{b299}", "\u{1102}\u{1173}\u{11b0}",
        "\u{b299}", "\u{1102}\u{1173}\u{11b0}"), ("\u{b29a}", "\u{b29a}",
        "\u{1102}\u{1173}\u{11b1}", "\u{b29a}", "\u{1102}\u{1173}\u{11b1}"), ("\u{b29b}",
        "\u{b29b}", "\u{1102}\u{1173}\u{11b2}", "\u{b29b}", "\u{1102}\u{1173}\u{11b2}"),
        ("\u{b29c}", "\u{b29c}", "\u{1102}\u{1173}\u{11b3}", "\u{b29c}",
        "\u{1102}\u{1173}\u{11b3}"), ("\u{b29d}", "\u{b29d}", "\u{1102}\u{1173}\u{11b4}",
        "\u{b29d}", "\u{1102}\u{1173}\u{11b4}"), ("\u{b29e}", "\u{b29e}",
        "\u{1102}\u{1173}\u{11b5}", "\u{b29e}", "\u{1102}\u{1173}\u{11b5}"), ("\u{b29f}",
        "\u{b29f}", "\u{1102}\u{1173}\u{11b6}", "\u{b29f}", "\u{1102}\u{1173}\u{11b6}"),
        ("\u{b2a0}", "\u{b2a0}", "\u{1102}\u{1173}\u{11b7}", "\u{b2a0}",
        "\u{1102}\u{1173}\u{11b7}"), ("\u{b2a1}", "\u{b2a1}", "\u{1102}\u{1173}\u{11b8}",
        "\u{b2a1}", "\u{1102}\u{1173}\u{11b8}"), ("\u{b2a2}", "\u{b2a2}",
        "\u{1102}\u{1173}\u{11b9}", "\u{b2a2}", "\u{1102}\u{1173}\u{11b9}"), ("\u{b2a3}",
        "\u{b2a3}", "\u{1102}\u{1173}\u{11ba}", "\u{b2a3}", "\u{1102}\u{1173}\u{11ba}"),
        ("\u{b2a4}", "\u{b2a4}", "\u{1102}\u{1173}\u{11bb}", "\u{b2a4}",
        "\u{1102}\u{1173}\u{11bb}"), ("\u{b2a5}", "\u{b2a5}", "\u{1102}\u{1173}\u{11bc}",
        "\u{b2a5}", "\u{1102}\u{1173}\u{11bc}"), ("\u{b2a6}", "\u{b2a6}",
        "\u{1102}\u{1173}\u{11bd}", "\u{b2a6}", "\u{1102}\u{1173}\u{11bd}"), ("\u{b2a7}",
        "\u{b2a7}", "\u{1102}\u{1173}\u{11be}", "\u{b2a7}", "\u{1102}\u{1173}\u{11be}"),
        ("\u{b2a8}", "\u{b2a8}", "\u{1102}\u{1173}\u{11bf}", "\u{b2a8}",
        "\u{1102}\u{1173}\u{11bf}"), ("\u{b2a9}", "\u{b2a9}", "\u{1102}\u{1173}\u{11c0}",
        "\u{b2a9}", "\u{1102}\u{1173}\u{11c0}"), ("\u{b2aa}", "\u{b2aa}",
        "\u{1102}\u{1173}\u{11c1}", "\u{b2aa}", "\u{1102}\u{1173}\u{11c1}"), ("\u{b2ab}",
        "\u{b2ab}", "\u{1102}\u{1173}\u{11c2}", "\u{b2ab}", "\u{1102}\u{1173}\u{11c2}"),
        ("\u{b2ac}", "\u{b2ac}", "\u{1102}\u{1174}", "\u{b2ac}", "\u{1102}\u{1174}"), ("\u{b2ad}",
        "\u{b2ad}", "\u{1102}\u{1174}\u{11a8}", "\u{b2ad}", "\u{1102}\u{1174}\u{11a8}"),
        ("\u{b2ae}", "\u{b2ae}", "\u{1102}\u{1174}\u{11a9}", "\u{b2ae}",
        "\u{1102}\u{1174}\u{11a9}"), ("\u{b2af}", "\u{b2af}", "\u{1102}\u{1174}\u{11aa}",
        "\u{b2af}", "\u{1102}\u{1174}\u{11aa}"), ("\u{b2b0}", "\u{b2b0}",
        "\u{1102}\u{1174}\u{11ab}", "\u{b2b0}", "\u{1102}\u{1174}\u{11ab}"), ("\u{b2b1}",
        "\u{b2b1}", "\u{1102}\u{1174}\u{11ac}", "\u{b2b1}", "\u{1102}\u{1174}\u{11ac}"),
        ("\u{b2b2}", "\u{b2b2}", "\u{1102}\u{1174}\u{11ad}", "\u{b2b2}",
        "\u{1102}\u{1174}\u{11ad}"), ("\u{b2b3}", "\u{b2b3}", "\u{1102}\u{1174}\u{11ae}",
        "\u{b2b3}", "\u{1102}\u{1174}\u{11ae}"), ("\u{b2b4}", "\u{b2b4}",
        "\u{1102}\u{1174}\u{11af}", "\u{b2b4}", "\u{1102}\u{1174}\u{11af}"), ("\u{b2b5}",
        "\u{b2b5}", "\u{1102}\u{1174}\u{11b0}", "\u{b2b5}", "\u{1102}\u{1174}\u{11b0}"),
        ("\u{b2b6}", "\u{b2b6}", "\u{1102}\u{1174}\u{11b1}", "\u{b2b6}",
        "\u{1102}\u{1174}\u{11b1}"), ("\u{b2b7}", "\u{b2b7}", "\u{1102}\u{1174}\u{11b2}",
        "\u{b2b7}", "\u{1102}\u{1174}\u{11b2}"), ("\u{b2b8}", "\u{b2b8}",
        "\u{1102}\u{1174}\u{11b3}", "\u{b2b8}", "\u{1102}\u{1174}\u{11b3}"), ("\u{b2b9}",
        "\u{b2b9}", "\u{1102}\u{1174}\u{11b4}", "\u{b2b9}", "\u{1102}\u{1174}\u{11b4}"),
        ("\u{b2ba}", "\u{b2ba}", "\u{1102}\u{1174}\u{11b5}", "\u{b2ba}",
        "\u{1102}\u{1174}\u{11b5}"), ("\u{b2bb}", "\u{b2bb}", "\u{1102}\u{1174}\u{11b6}",
        "\u{b2bb}", "\u{1102}\u{1174}\u{11b6}"), ("\u{b2bc}", "\u{b2bc}",
        "\u{1102}\u{1174}\u{11b7}", "\u{b2bc}", "\u{1102}\u{1174}\u{11b7}"), ("\u{b2bd}",
        "\u{b2bd}", "\u{1102}\u{1174}\u{11b8}", "\u{b2bd}", "\u{1102}\u{1174}\u{11b8}"),
        ("\u{b2be}", "\u{b2be}", "\u{1102}\u{1174}\u{11b9}", "\u{b2be}",
        "\u{1102}\u{1174}\u{11b9}"), ("\u{b2bf}", "\u{b2bf}", "\u{1102}\u{1174}\u{11ba}",
        "\u{b2bf}", "\u{1102}\u{1174}\u{11ba}"), ("\u{b2c0}", "\u{b2c0}",
        "\u{1102}\u{1174}\u{11bb}", "\u{b2c0}", "\u{1102}\u{1174}\u{11bb}"), ("\u{b2c1}",
        "\u{b2c1}", "\u{1102}\u{1174}\u{11bc}", "\u{b2c1}", "\u{1102}\u{1174}\u{11bc}"),
        ("\u{b2c2}", "\u{b2c2}", "\u{1102}\u{1174}\u{11bd}", "\u{b2c2}",
        "\u{1102}\u{1174}\u{11bd}"), ("\u{b2c3}", "\u{b2c3}", "\u{1102}\u{1174}\u{11be}",
        "\u{b2c3}", "\u{1102}\u{1174}\u{11be}"), ("\u{b2c4}", "\u{b2c4}",
        "\u{1102}\u{1174}\u{11bf}", "\u{b2c4}", "\u{1102}\u{1174}\u{11bf}"), ("\u{b2c5}",
        "\u{b2c5}", "\u{1102}\u{1174}\u{11c0}", "\u{b2c5}", "\u{1102}\u{1174}\u{11c0}"),
        ("\u{b2c6}", "\u{b2c6}", "\u{1102}\u{1174}\u{11c1}", "\u{b2c6}",
        "\u{1102}\u{1174}\u{11c1}"), ("\u{b2c7}", "\u{b2c7}", "\u{1102}\u{1174}\u{11c2}",
        "\u{b2c7}", "\u{1102}\u{1174}\u{11c2}"), ("\u{b2c8}", "\u{b2c8}", "\u{1102}\u{1175}",
        "\u{b2c8}", "\u{1102}\u{1175}"), ("\u{b2c9}", "\u{b2c9}", "\u{1102}\u{1175}\u{11a8}",
        "\u{b2c9}", "\u{1102}\u{1175}\u{11a8}"), ("\u{b2ca}", "\u{b2ca}",
        "\u{1102}\u{1175}\u{11a9}", "\u{b2ca}", "\u{1102}\u{1175}\u{11a9}"), ("\u{b2cb}",
        "\u{b2cb}", "\u{1102}\u{1175}\u{11aa}", "\u{b2cb}", "\u{1102}\u{1175}\u{11aa}"),
        ("\u{b2cc}", "\u{b2cc}", "\u{1102}\u{1175}\u{11ab}", "\u{b2cc}",
        "\u{1102}\u{1175}\u{11ab}"), ("\u{b2cd}", "\u{b2cd}", "\u{1102}\u{1175}\u{11ac}",
        "\u{b2cd}", "\u{1102}\u{1175}\u{11ac}"), ("\u{b2ce}", "\u{b2ce}",
        "\u{1102}\u{1175}\u{11ad}", "\u{b2ce}", "\u{1102}\u{1175}\u{11ad}"), ("\u{b2cf}",
        "\u{b2cf}", "\u{1102}\u{1175}\u{11ae}", "\u{b2cf}", "\u{1102}\u{1175}\u{11ae}"),
        ("\u{b2d0}", "\u{b2d0}", "\u{1102}\u{1175}\u{11af}", "\u{b2d0}",
        "\u{1102}\u{1175}\u{11af}"), ("\u{b2d1}", "\u{b2d1}", "\u{1102}\u{1175}\u{11b0}",
        "\u{b2d1}", "\u{1102}\u{1175}\u{11b0}"), ("\u{b2d2}", "\u{b2d2}",
        "\u{1102}\u{1175}\u{11b1}", "\u{b2d2}", "\u{1102}\u{1175}\u{11b1}"), ("\u{b2d3}",
        "\u{b2d3}", "\u{1102}\u{1175}\u{11b2}", "\u{b2d3}", "\u{1102}\u{1175}\u{11b2}"),
        ("\u{b2d4}", "\u{b2d4}", "\u{1102}\u{1175}\u{11b3}", "\u{b2d4}",
        "\u{1102}\u{1175}\u{11b3}"), ("\u{b2d5}", "\u{b2d5}", "\u{1102}\u{1175}\u{11b4}",
        "\u{b2d5}", "\u{1102}\u{1175}\u{11b4}"), ("\u{b2d6}", "\u{b2d6}",
        "\u{1102}\u{1175}\u{11b5}", "\u{b2d6}", "\u{1102}\u{1175}\u{11b5}"), ("\u{b2d7}",
        "\u{b2d7}", "\u{1102}\u{1175}\u{11b6}", "\u{b2d7}", "\u{1102}\u{1175}\u{11b6}"),
        ("\u{b2d8}", "\u{b2d8}", "\u{1102}\u{1175}\u{11b7}", "\u{b2d8}",
        "\u{1102}\u{1175}\u{11b7}"), ("\u{b2d9}", "\u{b2d9}", "\u{1102}\u{1175}\u{11b8}",
        "\u{b2d9}", "\u{1102}\u{1175}\u{11b8}"), ("\u{b2da}", "\u{b2da}",
        "\u{1102}\u{1175}\u{11b9}", "\u{b2da}", "\u{1102}\u{1175}\u{11b9}"), ("\u{b2db}",
        "\u{b2db}", "\u{1102}\u{1175}\u{11ba}", "\u{b2db}", "\u{1102}\u{1175}\u{11ba}"),
        ("\u{b2dc}", "\u{b2dc}", "\u{1102}\u{1175}\u{11bb}", "\u{b2dc}",
        "\u{1102}\u{1175}\u{11bb}"), ("\u{b2dd}", "\u{b2dd}", "\u{1102}\u{1175}\u{11bc}",
        "\u{b2dd}", "\u{1102}\u{1175}\u{11bc}"), ("\u{b2de}", "\u{b2de}",
        "\u{1102}\u{1175}\u{11bd}", "\u{b2de}", "\u{1102}\u{1175}\u{11bd}"), ("\u{b2df}",
        "\u{b2df}", "\u{1102}\u{1175}\u{11be}", "\u{b2df}", "\u{1102}\u{1175}\u{11be}"),
        ("\u{b2e0}", "\u{b2e0}", "\u{1102}\u{1175}\u{11bf}", "\u{b2e0}",
        "\u{1102}\u{1175}\u{11bf}"), ("\u{b2e1}", "\u{b2e1}", "\u{1102}\u{1175}\u{11c0}",
        "\u{b2e1}", "\u{1102}\u{1175}\u{11c0}"), ("\u{b2e2}", "\u{b2e2}",
        "\u{1102}\u{1175}\u{11c1}", "\u{b2e2}", "\u{1102}\u{1175}\u{11c1}"), ("\u{b2e3}",
        "\u{b2e3}", "\u{1102}\u{1175}\u{11c2}", "\u{b2e3}", "\u{1102}\u{1175}\u{11c2}"),
        ("\u{b2e4}", "\u{b2e4}", "\u{1103}\u{1161}", "\u{b2e4}", "\u{1103}\u{1161}"), ("\u{b2e5}",
        "\u{b2e5}", "\u{1103}\u{1161}\u{11a8}", "\u{b2e5}", "\u{1103}\u{1161}\u{11a8}"),
        ("\u{b2e6}", "\u{b2e6}", "\u{1103}\u{1161}\u{11a9}", "\u{b2e6}",
        "\u{1103}\u{1161}\u{11a9}"), ("\u{b2e7}", "\u{b2e7}", "\u{1103}\u{1161}\u{11aa}",
        "\u{b2e7}", "\u{1103}\u{1161}\u{11aa}"), ("\u{b2e8}", "\u{b2e8}",
        "\u{1103}\u{1161}\u{11ab}", "\u{b2e8}", "\u{1103}\u{1161}\u{11ab}"), ("\u{b2e9}",
        "\u{b2e9}", "\u{1103}\u{1161}\u{11ac}", "\u{b2e9}", "\u{1103}\u{1161}\u{11ac}"),
        ("\u{b2ea}", "\u{b2ea}", "\u{1103}\u{1161}\u{11ad}", "\u{b2ea}",
        "\u{1103}\u{1161}\u{11ad}"), ("\u{b2eb}", "\u{b2eb}", "\u{1103}\u{1161}\u{11ae}",
        "\u{b2eb}", "\u{1103}\u{1161}\u{11ae}"), ("\u{b2ec}", "\u{b2ec}",
        "\u{1103}\u{1161}\u{11af}", "\u{b2ec}", "\u{1103}\u{1161}\u{11af}"), ("\u{b2ed}",
        "\u{b2ed}", "\u{1103}\u{1161}\u{11b0}", "\u{b2ed}", "\u{1103}\u{1161}\u{11b0}"),
        ("\u{b2ee}", "\u{b2ee}", "\u{1103}\u{1161}\u{11b1}", "\u{b2ee}",
        "\u{1103}\u{1161}\u{11b1}"), ("\u{b2ef}", "\u{b2ef}", "\u{1103}\u{1161}\u{11b2}",
        "\u{b2ef}", "\u{1103}\u{1161}\u{11b2}"), ("\u{b2f0}", "\u{b2f0}",
        "\u{1103}\u{1161}\u{11b3}", "\u{b2f0}", "\u{1103}\u{1161}\u{11b3}"), ("\u{b2f1}",
        "\u{b2f1}", "\u{1103}\u{1161}\u{11b4}", "\u{b2f1}", "\u{1103}\u{1161}\u{11b4}"),
        ("\u{b2f2}", "\u{b2f2}", "\u{1103}\u{1161}\u{11b5}", "\u{b2f2}",
        "\u{1103}\u{1161}\u{11b5}"), ("\u{b2f3}", "\u{b2f3}", "\u{1103}\u{1161}\u{11b6}",
        "\u{b2f3}", "\u{1103}\u{1161}\u{11b6}"), ("\u{b2f4}", "\u{b2f4}",
        "\u{1103}\u{1161}\u{11b7}", "\u{b2f4}", "\u{1103}\u{1161}\u{11b7}"), ("\u{b2f5}",
        "\u{b2f5}", "\u{1103}\u{1161}\u{11b8}", "\u{b2f5}", "\u{1103}\u{1161}\u{11b8}"),
        ("\u{b2f6}", "\u{b2f6}", "\u{1103}\u{1161}\u{11b9}", "\u{b2f6}",
        "\u{1103}\u{1161}\u{11b9}"), ("\u{b2f7}", "\u{b2f7}", "\u{1103}\u{1161}\u{11ba}",
        "\u{b2f7}", "\u{1103}\u{1161}\u{11ba}"), ("\u{b2f8}", "\u{b2f8}",
        "\u{1103}\u{1161}\u{11bb}", "\u{b2f8}", "\u{1103}\u{1161}\u{11bb}"), ("\u{b2f9}",
        "\u{b2f9}", "\u{1103}\u{1161}\u{11bc}", "\u{b2f9}", "\u{1103}\u{1161}\u{11bc}"),
        ("\u{b2fa}", "\u{b2fa}", "\u{1103}\u{1161}\u{11bd}", "\u{b2fa}",
        "\u{1103}\u{1161}\u{11bd}"), ("\u{b2fb}", "\u{b2fb}", "\u{1103}\u{1161}\u{11be}",
        "\u{b2fb}", "\u{1103}\u{1161}\u{11be}"), ("\u{b2fc}", "\u{b2fc}",
        "\u{1103}\u{1161}\u{11bf}", "\u{b2fc}", "\u{1103}\u{1161}\u{11bf}"), ("\u{b2fd}",
        "\u{b2fd}", "\u{1103}\u{1161}\u{11c0}", "\u{b2fd}", "\u{1103}\u{1161}\u{11c0}"),
        ("\u{b2fe}", "\u{b2fe}", "\u{1103}\u{1161}\u{11c1}", "\u{b2fe}",
        "\u{1103}\u{1161}\u{11c1}"), ("\u{b2ff}", "\u{b2ff}", "\u{1103}\u{1161}\u{11c2}",
        "\u{b2ff}", "\u{1103}\u{1161}\u{11c2}"), ("\u{b300}", "\u{b300}", "\u{1103}\u{1162}",
        "\u{b300}", "\u{1103}\u{1162}"), ("\u{b301}", "\u{b301}", "\u{1103}\u{1162}\u{11a8}",
        "\u{b301}", "\u{1103}\u{1162}\u{11a8}"), ("\u{b302}", "\u{b302}",
        "\u{1103}\u{1162}\u{11a9}", "\u{b302}", "\u{1103}\u{1162}\u{11a9}"), ("\u{b303}",
        "\u{b303}", "\u{1103}\u{1162}\u{11aa}", "\u{b303}", "\u{1103}\u{1162}\u{11aa}"),
        ("\u{b304}", "\u{b304}", "\u{1103}\u{1162}\u{11ab}", "\u{b304}",
        "\u{1103}\u{1162}\u{11ab}"), ("\u{b305}", "\u{b305}", "\u{1103}\u{1162}\u{11ac}",
        "\u{b305}", "\u{1103}\u{1162}\u{11ac}"), ("\u{b306}", "\u{b306}",
        "\u{1103}\u{1162}\u{11ad}", "\u{b306}", "\u{1103}\u{1162}\u{11ad}"), ("\u{b307}",
        "\u{b307}", "\u{1103}\u{1162}\u{11ae}", "\u{b307}", "\u{1103}\u{1162}\u{11ae}"),
        ("\u{b308}", "\u{b308}", "\u{1103}\u{1162}\u{11af}", "\u{b308}",
        "\u{1103}\u{1162}\u{11af}"), ("\u{b309}", "\u{b309}", "\u{1103}\u{1162}\u{11b0}",
        "\u{b309}", "\u{1103}\u{1162}\u{11b0}"), ("\u{b30a}", "\u{b30a}",
        "\u{1103}\u{1162}\u{11b1}", "\u{b30a}", "\u{1103}\u{1162}\u{11b1}"), ("\u{b30b}",
        "\u{b30b}", "\u{1103}\u{1162}\u{11b2}", "\u{b30b}", "\u{1103}\u{1162}\u{11b2}"),
        ("\u{b30c}", "\u{b30c}", "\u{1103}\u{1162}\u{11b3}", "\u{b30c}",
        "\u{1103}\u{1162}\u{11b3}"), ("\u{b30d}", "\u{b30d}", "\u{1103}\u{1162}\u{11b4}",
        "\u{b30d}", "\u{1103}\u{1162}\u{11b4}"), ("\u{b30e}", "\u{b30e}",
        "\u{1103}\u{1162}\u{11b5}", "\u{b30e}", "\u{1103}\u{1162}\u{11b5}"), ("\u{b30f}",
        "\u{b30f}", "\u{1103}\u{1162}\u{11b6}", "\u{b30f}", "\u{1103}\u{1162}\u{11b6}"),
        ("\u{b310}", "\u{b310}", "\u{1103}\u{1162}\u{11b7}", "\u{b310}",
        "\u{1103}\u{1162}\u{11b7}"), ("\u{b311}", "\u{b311}", "\u{1103}\u{1162}\u{11b8}",
        "\u{b311}", "\u{1103}\u{1162}\u{11b8}"), ("\u{b312}", "\u{b312}",
        "\u{1103}\u{1162}\u{11b9}", "\u{b312}", "\u{1103}\u{1162}\u{11b9}"), ("\u{b313}",
        "\u{b313}", "\u{1103}\u{1162}\u{11ba}", "\u{b313}", "\u{1103}\u{1162}\u{11ba}"),
        ("\u{b314}", "\u{b314}", "\u{1103}\u{1162}\u{11bb}", "\u{b314}",
        "\u{1103}\u{1162}\u{11bb}"), ("\u{b315}", "\u{b315}", "\u{1103}\u{1162}\u{11bc}",
        "\u{b315}", "\u{1103}\u{1162}\u{11bc}"), ("\u{b316}", "\u{b316}",
        "\u{1103}\u{1162}\u{11bd}", "\u{b316}", "\u{1103}\u{1162}\u{11bd}"), ("\u{b317}",
        "\u{b317}", "\u{1103}\u{1162}\u{11be}", "\u{b317}", "\u{1103}\u{1162}\u{11be}"),
        ("\u{b318}", "\u{b318}", "\u{1103}\u{1162}\u{11bf}", "\u{b318}",
        "\u{1103}\u{1162}\u{11bf}"), ("\u{b319}", "\u{b319}", "\u{1103}\u{1162}\u{11c0}",
        "\u{b319}", "\u{1103}\u{1162}\u{11c0}"), ("\u{b31a}", "\u{b31a}",
        "\u{1103}\u{1162}\u{11c1}", "\u{b31a}", "\u{1103}\u{1162}\u{11c1}"), ("\u{b31b}",
        "\u{b31b}", "\u{1103}\u{1162}\u{11c2}", "\u{b31b}", "\u{1103}\u{1162}\u{11c2}"),
        ("\u{b31c}", "\u{b31c}", "\u{1103}\u{1163}", "\u{b31c}", "\u{1103}\u{1163}"), ("\u{b31d}",
        "\u{b31d}", "\u{1103}\u{1163}\u{11a8}", "\u{b31d}", "\u{1103}\u{1163}\u{11a8}"),
        ("\u{b31e}", "\u{b31e}", "\u{1103}\u{1163}\u{11a9}", "\u{b31e}",
        "\u{1103}\u{1163}\u{11a9}"), ("\u{b31f}", "\u{b31f}", "\u{1103}\u{1163}\u{11aa}",
        "\u{b31f}", "\u{1103}\u{1163}\u{11aa}"), ("\u{b320}", "\u{b320}",
        "\u{1103}\u{1163}\u{11ab}", "\u{b320}", "\u{1103}\u{1163}\u{11ab}"), ("\u{b321}",
        "\u{b321}", "\u{1103}\u{1163}\u{11ac}", "\u{b321}", "\u{1103}\u{1163}\u{11ac}"),
        ("\u{b322}", "\u{b322}", "\u{1103}\u{1163}\u{11ad}", "\u{b322}",
        "\u{1103}\u{1163}\u{11ad}"), ("\u{b323}", "\u{b323}", "\u{1103}\u{1163}\u{11ae}",
        "\u{b323}", "\u{1103}\u{1163}\u{11ae}"), ("\u{b324}", "\u{b324}",
        "\u{1103}\u{1163}\u{11af}", "\u{b324}", "\u{1103}\u{1163}\u{11af}"), ("\u{b325}",
        "\u{b325}", "\u{1103}\u{1163}\u{11b0}", "\u{b325}", "\u{1103}\u{1163}\u{11b0}"),
        ("\u{b326}", "\u{b326}", "\u{1103}\u{1163}\u{11b1}", "\u{b326}",
        "\u{1103}\u{1163}\u{11b1}"), ("\u{b327}", "\u{b327}", "\u{1103}\u{1163}\u{11b2}",
        "\u{b327}", "\u{1103}\u{1163}\u{11b2}"), ("\u{b328}", "\u{b328}",
        "\u{1103}\u{1163}\u{11b3}", "\u{b328}", "\u{1103}\u{1163}\u{11b3}"), ("\u{b329}",
        "\u{b329}", "\u{1103}\u{1163}\u{11b4}", "\u{b329}", "\u{1103}\u{1163}\u{11b4}"),
        ("\u{b32a}", "\u{b32a}", "\u{1103}\u{1163}\u{11b5}", "\u{b32a}",
        "\u{1103}\u{1163}\u{11b5}"), ("\u{b32b}", "\u{b32b}", "\u{1103}\u{1163}\u{11b6}",
        "\u{b32b}", "\u{1103}\u{1163}\u{11b6}"), ("\u{b32c}", "\u{b32c}",
        "\u{1103}\u{1163}\u{11b7}", "\u{b32c}", "\u{1103}\u{1163}\u{11b7}"), ("\u{b32d}",
        "\u{b32d}", "\u{1103}\u{1163}\u{11b8}", "\u{b32d}", "\u{1103}\u{1163}\u{11b8}"),
        ("\u{b32e}", "\u{b32e}", "\u{1103}\u{1163}\u{11b9}", "\u{b32e}",
        "\u{1103}\u{1163}\u{11b9}"), ("\u{b32f}", "\u{b32f}", "\u{1103}\u{1163}\u{11ba}",
        "\u{b32f}", "\u{1103}\u{1163}\u{11ba}"), ("\u{b330}", "\u{b330}",
        "\u{1103}\u{1163}\u{11bb}", "\u{b330}", "\u{1103}\u{1163}\u{11bb}"), ("\u{b331}",
        "\u{b331}", "\u{1103}\u{1163}\u{11bc}", "\u{b331}", "\u{1103}\u{1163}\u{11bc}"),
        ("\u{b332}", "\u{b332}", "\u{1103}\u{1163}\u{11bd}", "\u{b332}",
        "\u{1103}\u{1163}\u{11bd}"), ("\u{b333}", "\u{b333}", "\u{1103}\u{1163}\u{11be}",
        "\u{b333}", "\u{1103}\u{1163}\u{11be}"), ("\u{b334}", "\u{b334}",
        "\u{1103}\u{1163}\u{11bf}", "\u{b334}", "\u{1103}\u{1163}\u{11bf}"), ("\u{b335}",
        "\u{b335}", "\u{1103}\u{1163}\u{11c0}", "\u{b335}", "\u{1103}\u{1163}\u{11c0}"),
        ("\u{b336}", "\u{b336}", "\u{1103}\u{1163}\u{11c1}", "\u{b336}",
        "\u{1103}\u{1163}\u{11c1}"), ("\u{b337}", "\u{b337}", "\u{1103}\u{1163}\u{11c2}",
        "\u{b337}", "\u{1103}\u{1163}\u{11c2}"), ("\u{b338}", "\u{b338}", "\u{1103}\u{1164}",
        "\u{b338}", "\u{1103}\u{1164}"), ("\u{b339}", "\u{b339}", "\u{1103}\u{1164}\u{11a8}",
        "\u{b339}", "\u{1103}\u{1164}\u{11a8}"), ("\u{b33a}", "\u{b33a}",
        "\u{1103}\u{1164}\u{11a9}", "\u{b33a}", "\u{1103}\u{1164}\u{11a9}"), ("\u{b33b}",
        "\u{b33b}", "\u{1103}\u{1164}\u{11aa}", "\u{b33b}", "\u{1103}\u{1164}\u{11aa}"),
        ("\u{b33c}", "\u{b33c}", "\u{1103}\u{1164}\u{11ab}", "\u{b33c}",
        "\u{1103}\u{1164}\u{11ab}"), ("\u{b33d}", "\u{b33d}", "\u{1103}\u{1164}\u{11ac}",
        "\u{b33d}", "\u{1103}\u{1164}\u{11ac}"), ("\u{b33e}", "\u{b33e}",
        "\u{1103}\u{1164}\u{11ad}", "\u{b33e}", "\u{1103}\u{1164}\u{11ad}"), ("\u{b33f}",
        "\u{b33f}", "\u{1103}\u{1164}\u{11ae}", "\u{b33f}", "\u{1103}\u{1164}\u{11ae}"),
        ("\u{b340}", "\u{b340}", "\u{1103}\u{1164}\u{11af}", "\u{b340}",
        "\u{1103}\u{1164}\u{11af}"), ("\u{b341}", "\u{b341}", "\u{1103}\u{1164}\u{11b0}",
        "\u{b341}", "\u{1103}\u{1164}\u{11b0}"), ("\u{b342}", "\u{b342}",
        "\u{1103}\u{1164}\u{11b1}", "\u{b342}", "\u{1103}\u{1164}\u{11b1}"), ("\u{b343}",
        "\u{b343}", "\u{1103}\u{1164}\u{11b2}", "\u{b343}", "\u{1103}\u{1164}\u{11b2}"),
        ("\u{b344}", "\u{b344}", "\u{1103}\u{1164}\u{11b3}", "\u{b344}",
        "\u{1103}\u{1164}\u{11b3}"), ("\u{b345}", "\u{b345}", "\u{1103}\u{1164}\u{11b4}",
        "\u{b345}", "\u{1103}\u{1164}\u{11b4}"), ("\u{b346}", "\u{b346}",
        "\u{1103}\u{1164}\u{11b5}", "\u{b346}", "\u{1103}\u{1164}\u{11b5}"), ("\u{b347}",
        "\u{b347}", "\u{1103}\u{1164}\u{11b6}", "\u{b347}", "\u{1103}\u{1164}\u{11b6}"),
        ("\u{b348}", "\u{b348}", "\u{1103}\u{1164}\u{11b7}", "\u{b348}",
        "\u{1103}\u{1164}\u{11b7}"), ("\u{b349}", "\u{b349}", "\u{1103}\u{1164}\u{11b8}",
        "\u{b349}", "\u{1103}\u{1164}\u{11b8}"), ("\u{b34a}", "\u{b34a}",
        "\u{1103}\u{1164}\u{11b9}", "\u{b34a}", "\u{1103}\u{1164}\u{11b9}"), ("\u{b34b}",
        "\u{b34b}", "\u{1103}\u{1164}\u{11ba}", "\u{b34b}", "\u{1103}\u{1164}\u{11ba}"),
        ("\u{b34c}", "\u{b34c}", "\u{1103}\u{1164}\u{11bb}", "\u{b34c}",
        "\u{1103}\u{1164}\u{11bb}"), ("\u{b34d}", "\u{b34d}", "\u{1103}\u{1164}\u{11bc}",
        "\u{b34d}", "\u{1103}\u{1164}\u{11bc}"), ("\u{b34e}", "\u{b34e}",
        "\u{1103}\u{1164}\u{11bd}", "\u{b34e}", "\u{1103}\u{1164}\u{11bd}"), ("\u{b34f}",
        "\u{b34f}", "\u{1103}\u{1164}\u{11be}", "\u{b34f}", "\u{1103}\u{1164}\u{11be}"),
        ("\u{b350}", "\u{b350}", "\u{1103}\u{1164}\u{11bf}", "\u{b350}",
        "\u{1103}\u{1164}\u{11bf}"), ("\u{b351}", "\u{b351}", "\u{1103}\u{1164}\u{11c0}",
        "\u{b351}", "\u{1103}\u{1164}\u{11c0}"), ("\u{b352}", "\u{b352}",
        "\u{1103}\u{1164}\u{11c1}", "\u{b352}", "\u{1103}\u{1164}\u{11c1}"), ("\u{b353}",
        "\u{b353}", "\u{1103}\u{1164}\u{11c2}", "\u{b353}", "\u{1103}\u{1164}\u{11c2}"),
        ("\u{b354}", "\u{b354}", "\u{1103}\u{1165}", "\u{b354}", "\u{1103}\u{1165}"), ("\u{b355}",
        "\u{b355}", "\u{1103}\u{1165}\u{11a8}", "\u{b355}", "\u{1103}\u{1165}\u{11a8}"),
        ("\u{b356}", "\u{b356}", "\u{1103}\u{1165}\u{11a9}", "\u{b356}",
        "\u{1103}\u{1165}\u{11a9}"), ("\u{b357}", "\u{b357}", "\u{1103}\u{1165}\u{11aa}",
        "\u{b357}", "\u{1103}\u{1165}\u{11aa}"), ("\u{b358}", "\u{b358}",
        "\u{1103}\u{1165}\u{11ab}", "\u{b358}", "\u{1103}\u{1165}\u{11ab}"), ("\u{b359}",
        "\u{b359}", "\u{1103}\u{1165}\u{11ac}", "\u{b359}", "\u{1103}\u{1165}\u{11ac}"),
        ("\u{b35a}", "\u{b35a}", "\u{1103}\u{1165}\u{11ad}", "\u{b35a}",
        "\u{1103}\u{1165}\u{11ad}"), ("\u{b35b}", "\u{b35b}", "\u{1103}\u{1165}\u{11ae}",
        "\u{b35b}", "\u{1103}\u{1165}\u{11ae}"), ("\u{b35c}", "\u{b35c}",
        "\u{1103}\u{1165}\u{11af}", "\u{b35c}", "\u{1103}\u{1165}\u{11af}"), ("\u{b35d}",
        "\u{b35d}", "\u{1103}\u{1165}\u{11b0}", "\u{b35d}", "\u{1103}\u{1165}\u{11b0}"),
        ("\u{b35e}", "\u{b35e}", "\u{1103}\u{1165}\u{11b1}", "\u{b35e}",
        "\u{1103}\u{1165}\u{11b1}"), ("\u{b35f}", "\u{b35f}", "\u{1103}\u{1165}\u{11b2}",
        "\u{b35f}", "\u{1103}\u{1165}\u{11b2}"), ("\u{b360}", "\u{b360}",
        "\u{1103}\u{1165}\u{11b3}", "\u{b360}", "\u{1103}\u{1165}\u{11b3}"), ("\u{b361}",
        "\u{b361}", "\u{1103}\u{1165}\u{11b4}", "\u{b361}", "\u{1103}\u{1165}\u{11b4}"),
        ("\u{b362}", "\u{b362}", "\u{1103}\u{1165}\u{11b5}", "\u{b362}",
        "\u{1103}\u{1165}\u{11b5}"), ("\u{b363}", "\u{b363}", "\u{1103}\u{1165}\u{11b6}",
        "\u{b363}", "\u{1103}\u{1165}\u{11b6}"), ("\u{b364}", "\u{b364}",
        "\u{1103}\u{1165}\u{11b7}", "\u{b364}", "\u{1103}\u{1165}\u{11b7}"), ("\u{b365}",
        "\u{b365}", "\u{1103}\u{1165}\u{11b8}", "\u{b365}", "\u{1103}\u{1165}\u{11b8}"),
        ("\u{b366}", "\u{b366}", "\u{1103}\u{1165}\u{11b9}", "\u{b366}",
        "\u{1103}\u{1165}\u{11b9}"), ("\u{b367}", "\u{b367}", "\u{1103}\u{1165}\u{11ba}",
        "\u{b367}", "\u{1103}\u{1165}\u{11ba}"), ("\u{b368}", "\u{b368}",
        "\u{1103}\u{1165}\u{11bb}", "\u{b368}", "\u{1103}\u{1165}\u{11bb}"), ("\u{b369}",
        "\u{b369}", "\u{1103}\u{1165}\u{11bc}", "\u{b369}", "\u{1103}\u{1165}\u{11bc}"),
        ("\u{b36a}", "\u{b36a}", "\u{1103}\u{1165}\u{11bd}", "\u{b36a}",
        "\u{1103}\u{1165}\u{11bd}"), ("\u{b36b}", "\u{b36b}", "\u{1103}\u{1165}\u{11be}",
        "\u{b36b}", "\u{1103}\u{1165}\u{11be}"), ("\u{b36c}", "\u{b36c}",
        "\u{1103}\u{1165}\u{11bf}", "\u{b36c}", "\u{1103}\u{1165}\u{11bf}"), ("\u{b36d}",
        "\u{b36d}", "\u{1103}\u{1165}\u{11c0}", "\u{b36d}", "\u{1103}\u{1165}\u{11c0}"),
        ("\u{b36e}", "\u{b36e}", "\u{1103}\u{1165}\u{11c1}", "\u{b36e}",
        "\u{1103}\u{1165}\u{11c1}"), ("\u{b36f}", "\u{b36f}", "\u{1103}\u{1165}\u{11c2}",
        "\u{b36f}", "\u{1103}\u{1165}\u{11c2}"), ("\u{b370}", "\u{b370}", "\u{1103}\u{1166}",
        "\u{b370}", "\u{1103}\u{1166}"), ("\u{b371}", "\u{b371}", "\u{1103}\u{1166}\u{11a8}",
        "\u{b371}", "\u{1103}\u{1166}\u{11a8}"), ("\u{b372}", "\u{b372}",
        "\u{1103}\u{1166}\u{11a9}", "\u{b372}", "\u{1103}\u{1166}\u{11a9}"), ("\u{b373}",
        "\u{b373}", "\u{1103}\u{1166}\u{11aa}", "\u{b373}", "\u{1103}\u{1166}\u{11aa}"),
        ("\u{b374}", "\u{b374}", "\u{1103}\u{1166}\u{11ab}", "\u{b374}",
        "\u{1103}\u{1166}\u{11ab}"), ("\u{b375}", "\u{b375}", "\u{1103}\u{1166}\u{11ac}",
        "\u{b375}", "\u{1103}\u{1166}\u{11ac}"), ("\u{b376}", "\u{b376}",
        "\u{1103}\u{1166}\u{11ad}", "\u{b376}", "\u{1103}\u{1166}\u{11ad}"), ("\u{b377}",
        "\u{b377}", "\u{1103}\u{1166}\u{11ae}", "\u{b377}", "\u{1103}\u{1166}\u{11ae}"),
        ("\u{b378}", "\u{b378}", "\u{1103}\u{1166}\u{11af}", "\u{b378}",
        "\u{1103}\u{1166}\u{11af}"), ("\u{b379}", "\u{b379}", "\u{1103}\u{1166}\u{11b0}",
        "\u{b379}", "\u{1103}\u{1166}\u{11b0}"), ("\u{b37a}", "\u{b37a}",
        "\u{1103}\u{1166}\u{11b1}", "\u{b37a}", "\u{1103}\u{1166}\u{11b1}"), ("\u{b37b}",
        "\u{b37b}", "\u{1103}\u{1166}\u{11b2}", "\u{b37b}", "\u{1103}\u{1166}\u{11b2}"),
        ("\u{b37c}", "\u{b37c}", "\u{1103}\u{1166}\u{11b3}", "\u{b37c}",
        "\u{1103}\u{1166}\u{11b3}"), ("\u{b37d}", "\u{b37d}", "\u{1103}\u{1166}\u{11b4}",
        "\u{b37d}", "\u{1103}\u{1166}\u{11b4}"), ("\u{b37e}", "\u{b37e}",
        "\u{1103}\u{1166}\u{11b5}", "\u{b37e}", "\u{1103}\u{1166}\u{11b5}"), ("\u{b37f}",
        "\u{b37f}", "\u{1103}\u{1166}\u{11b6}", "\u{b37f}", "\u{1103}\u{1166}\u{11b6}"),
        ("\u{b380}", "\u{b380}", "\u{1103}\u{1166}\u{11b7}", "\u{b380}",
        "\u{1103}\u{1166}\u{11b7}"), ("\u{b381}", "\u{b381}", "\u{1103}\u{1166}\u{11b8}",
        "\u{b381}", "\u{1103}\u{1166}\u{11b8}"), ("\u{b382}", "\u{b382}",
        "\u{1103}\u{1166}\u{11b9}", "\u{b382}", "\u{1103}\u{1166}\u{11b9}"), ("\u{b383}",
        "\u{b383}", "\u{1103}\u{1166}\u{11ba}", "\u{b383}", "\u{1103}\u{1166}\u{11ba}"),
        ("\u{b384}", "\u{b384}", "\u{1103}\u{1166}\u{11bb}", "\u{b384}",
        "\u{1103}\u{1166}\u{11bb}"), ("\u{b385}", "\u{b385}", "\u{1103}\u{1166}\u{11bc}",
        "\u{b385}", "\u{1103}\u{1166}\u{11bc}"), ("\u{b386}", "\u{b386}",
        "\u{1103}\u{1166}\u{11bd}", "\u{b386}", "\u{1103}\u{1166}\u{11bd}"), ("\u{b387}",
        "\u{b387}", "\u{1103}\u{1166}\u{11be}", "\u{b387}", "\u{1103}\u{1166}\u{11be}"),
        ("\u{b388}", "\u{b388}", "\u{1103}\u{1166}\u{11bf}", "\u{b388}",
        "\u{1103}\u{1166}\u{11bf}"), ("\u{b389}", "\u{b389}", "\u{1103}\u{1166}\u{11c0}",
        "\u{b389}", "\u{1103}\u{1166}\u{11c0}"), ("\u{b38a}", "\u{b38a}",
        "\u{1103}\u{1166}\u{11c1}", "\u{b38a}", "\u{1103}\u{1166}\u{11c1}"), ("\u{b38b}",
        "\u{b38b}", "\u{1103}\u{1166}\u{11c2}", "\u{b38b}", "\u{1103}\u{1166}\u{11c2}"),
        ("\u{b38c}", "\u{b38c}", "\u{1103}\u{1167}", "\u{b38c}", "\u{1103}\u{1167}"), ("\u{b38d}",
        "\u{b38d}", "\u{1103}\u{1167}\u{11a8}", "\u{b38d}", "\u{1103}\u{1167}\u{11a8}"),
        ("\u{b38e}", "\u{b38e}", "\u{1103}\u{1167}\u{11a9}", "\u{b38e}",
        "\u{1103}\u{1167}\u{11a9}"), ("\u{b38f}", "\u{b38f}", "\u{1103}\u{1167}\u{11aa}",
        "\u{b38f}", "\u{1103}\u{1167}\u{11aa}"), ("\u{b390}", "\u{b390}",
        "\u{1103}\u{1167}\u{11ab}", "\u{b390}", "\u{1103}\u{1167}\u{11ab}"), ("\u{b391}",
        "\u{b391}", "\u{1103}\u{1167}\u{11ac}", "\u{b391}", "\u{1103}\u{1167}\u{11ac}"),
        ("\u{b392}", "\u{b392}", "\u{1103}\u{1167}\u{11ad}", "\u{b392}",
        "\u{1103}\u{1167}\u{11ad}"), ("\u{b393}", "\u{b393}", "\u{1103}\u{1167}\u{11ae}",
        "\u{b393}", "\u{1103}\u{1167}\u{11ae}"), ("\u{b394}", "\u{b394}",
        "\u{1103}\u{1167}\u{11af}", "\u{b394}", "\u{1103}\u{1167}\u{11af}"), ("\u{b395}",
        "\u{b395}", "\u{1103}\u{1167}\u{11b0}", "\u{b395}", "\u{1103}\u{1167}\u{11b0}"),
        ("\u{b396}", "\u{b396}", "\u{1103}\u{1167}\u{11b1}", "\u{b396}",
        "\u{1103}\u{1167}\u{11b1}"), ("\u{b397}", "\u{b397}", "\u{1103}\u{1167}\u{11b2}",
        "\u{b397}", "\u{1103}\u{1167}\u{11b2}"), ("\u{b398}", "\u{b398}",
        "\u{1103}\u{1167}\u{11b3}", "\u{b398}", "\u{1103}\u{1167}\u{11b3}"), ("\u{b399}",
        "\u{b399}", "\u{1103}\u{1167}\u{11b4}", "\u{b399}", "\u{1103}\u{1167}\u{11b4}"),
        ("\u{b39a}", "\u{b39a}", "\u{1103}\u{1167}\u{11b5}", "\u{b39a}",
        "\u{1103}\u{1167}\u{11b5}"), ("\u{b39b}", "\u{b39b}", "\u{1103}\u{1167}\u{11b6}",
        "\u{b39b}", "\u{1103}\u{1167}\u{11b6}"), ("\u{b39c}", "\u{b39c}",
        "\u{1103}\u{1167}\u{11b7}", "\u{b39c}", "\u{1103}\u{1167}\u{11b7}"), ("\u{b39d}",
        "\u{b39d}", "\u{1103}\u{1167}\u{11b8}", "\u{b39d}", "\u{1103}\u{1167}\u{11b8}"),
        ("\u{b39e}", "\u{b39e}", "\u{1103}\u{1167}\u{11b9}", "\u{b39e}",
        "\u{1103}\u{1167}\u{11b9}"), ("\u{b39f}", "\u{b39f}", "\u{1103}\u{1167}\u{11ba}",
        "\u{b39f}", "\u{1103}\u{1167}\u{11ba}"), ("\u{b3a0}", "\u{b3a0}",
        "\u{1103}\u{1167}\u{11bb}", "\u{b3a0}", "\u{1103}\u{1167}\u{11bb}"), ("\u{b3a1}",
        "\u{b3a1}", "\u{1103}\u{1167}\u{11bc}", "\u{b3a1}", "\u{1103}\u{1167}\u{11bc}"),
        ("\u{b3a2}", "\u{b3a2}", "\u{1103}\u{1167}\u{11bd}", "\u{b3a2}",
        "\u{1103}\u{1167}\u{11bd}"), ("\u{b3a3}", "\u{b3a3}", "\u{1103}\u{1167}\u{11be}",
        "\u{b3a3}", "\u{1103}\u{1167}\u{11be}"), ("\u{b3a4}", "\u{b3a4}",
        "\u{1103}\u{1167}\u{11bf}", "\u{b3a4}", "\u{1103}\u{1167}\u{11bf}"), ("\u{b3a5}",
        "\u{b3a5}", "\u{1103}\u{1167}\u{11c0}", "\u{b3a5}", "\u{1103}\u{1167}\u{11c0}"),
        ("\u{b3a6}", "\u{b3a6}", "\u{1103}\u{1167}\u{11c1}", "\u{b3a6}",
        "\u{1103}\u{1167}\u{11c1}"), ("\u{b3a7}", "\u{b3a7}", "\u{1103}\u{1167}\u{11c2}",
        "\u{b3a7}", "\u{1103}\u{1167}\u{11c2}"), ("\u{b3a8}", "\u{b3a8}", "\u{1103}\u{1168}",
        "\u{b3a8}", "\u{1103}\u{1168}"), ("\u{b3a9}", "\u{b3a9}", "\u{1103}\u{1168}\u{11a8}",
        "\u{b3a9}", "\u{1103}\u{1168}\u{11a8}"), ("\u{b3aa}", "\u{b3aa}",
        "\u{1103}\u{1168}\u{11a9}", "\u{b3aa}", "\u{1103}\u{1168}\u{11a9}"), ("\u{b3ab}",
        "\u{b3ab}", "\u{1103}\u{1168}\u{11aa}", "\u{b3ab}", "\u{1103}\u{1168}\u{11aa}"),
        ("\u{b3ac}", "\u{b3ac}", "\u{1103}\u{1168}\u{11ab}", "\u{b3ac}",
        "\u{1103}\u{1168}\u{11ab}"), ("\u{b3ad}", "\u{b3ad}", "\u{1103}\u{1168}\u{11ac}",
        "\u{b3ad}", "\u{1103}\u{1168}\u{11ac}"), ("\u{b3ae}", "\u{b3ae}",
        "\u{1103}\u{1168}\u{11ad}", "\u{b3ae}", "\u{1103}\u{1168}\u{11ad}"), ("\u{b3af}",
        "\u{b3af}", "\u{1103}\u{1168}\u{11ae}", "\u{b3af}", "\u{1103}\u{1168}\u{11ae}"),
        ("\u{b3b0}", "\u{b3b0}", "\u{1103}\u{1168}\u{11af}", "\u{b3b0}",
        "\u{1103}\u{1168}\u{11af}"), ("\u{b3b1}", "\u{b3b1}", "\u{1103}\u{1168}\u{11b0}",
        "\u{b3b1}", "\u{1103}\u{1168}\u{11b0}"), ("\u{b3b2}", "\u{b3b2}",
        "\u{1103}\u{1168}\u{11b1}", "\u{b3b2}", "\u{1103}\u{1168}\u{11b1}"), ("\u{b3b3}",
        "\u{b3b3}", "\u{1103}\u{1168}\u{11b2}", "\u{b3b3}", "\u{1103}\u{1168}\u{11b2}"),
        ("\u{b3b4}", "\u{b3b4}", "\u{1103}\u{1168}\u{11b3}", "\u{b3b4}",
        "\u{1103}\u{1168}\u{11b3}"), ("\u{b3b5}", "\u{b3b5}", "\u{1103}\u{1168}\u{11b4}",
        "\u{b3b5}", "\u{1103}\u{1168}\u{11b4}"), ("\u{b3b6}", "\u{b3b6}",
        "\u{1103}\u{1168}\u{11b5}", "\u{b3b6}", "\u{1103}\u{1168}\u{11b5}"), ("\u{b3b7}",
        "\u{b3b7}", "\u{1103}\u{1168}\u{11b6}", "\u{b3b7}", "\u{1103}\u{1168}\u{11b6}"),
        ("\u{b3b8}", "\u{b3b8}", "\u{1103}\u{1168}\u{11b7}", "\u{b3b8}",
        "\u{1103}\u{1168}\u{11b7}"), ("\u{b3b9}", "\u{b3b9}", "\u{1103}\u{1168}\u{11b8}",
        "\u{b3b9}", "\u{1103}\u{1168}\u{11b8}"), ("\u{b3ba}", "\u{b3ba}",
        "\u{1103}\u{1168}\u{11b9}", "\u{b3ba}", "\u{1103}\u{1168}\u{11b9}"), ("\u{b3bb}",
        "\u{b3bb}", "\u{1103}\u{1168}\u{11ba}", "\u{b3bb}", "\u{1103}\u{1168}\u{11ba}"),
        ("\u{b3bc}", "\u{b3bc}", "\u{1103}\u{1168}\u{11bb}", "\u{b3bc}",
        "\u{1103}\u{1168}\u{11bb}"), ("\u{b3bd}", "\u{b3bd}", "\u{1103}\u{1168}\u{11bc}",
        "\u{b3bd}", "\u{1103}\u{1168}\u{11bc}"), ("\u{b3be}", "\u{b3be}",
        "\u{1103}\u{1168}\u{11bd}", "\u{b3be}", "\u{1103}\u{1168}\u{11bd}"), ("\u{b3bf}",
        "\u{b3bf}", "\u{1103}\u{1168}\u{11be}", "\u{b3bf}", "\u{1103}\u{1168}\u{11be}"),
        ("\u{b3c0}", "\u{b3c0}", "\u{1103}\u{1168}\u{11bf}", "\u{b3c0}",
        "\u{1103}\u{1168}\u{11bf}"), ("\u{b3c1}", "\u{b3c1}", "\u{1103}\u{1168}\u{11c0}",
        "\u{b3c1}", "\u{1103}\u{1168}\u{11c0}"), ("\u{b3c2}", "\u{b3c2}",
        "\u{1103}\u{1168}\u{11c1}", "\u{b3c2}", "\u{1103}\u{1168}\u{11c1}"), ("\u{b3c3}",
        "\u{b3c3}", "\u{1103}\u{1168}\u{11c2}", "\u{b3c3}", "\u{1103}\u{1168}\u{11c2}"),
        ("\u{b3c4}", "\u{b3c4}", "\u{1103}\u{1169}", "\u{b3c4}", "\u{1103}\u{1169}"), ("\u{b3c5}",
        "\u{b3c5}", "\u{1103}\u{1169}\u{11a8}", "\u{b3c5}", "\u{1103}\u{1169}\u{11a8}"),
        ("\u{b3c6}", "\u{b3c6}", "\u{1103}\u{1169}\u{11a9}", "\u{b3c6}",
        "\u{1103}\u{1169}\u{11a9}"), ("\u{b3c7}", "\u{b3c7}", "\u{1103}\u{1169}\u{11aa}",
        "\u{b3c7}", "\u{1103}\u{1169}\u{11aa}"), ("\u{b3c8}", "\u{b3c8}",
        "\u{1103}\u{1169}\u{11ab}", "\u{b3c8}", "\u{1103}\u{1169}\u{11ab}"), ("\u{b3c9}",
        "\u{b3c9}", "\u{1103}\u{1169}\u{11ac}", "\u{b3c9}", "\u{1103}\u{1169}\u{11ac}"),
        ("\u{b3ca}", "\u{b3ca}", "\u{1103}\u{1169}\u{11ad}", "\u{b3ca}",
        "\u{1103}\u{1169}\u{11ad}"), ("\u{b3cb}", "\u{b3cb}", "\u{1103}\u{1169}\u{11ae}",
        "\u{b3cb}", "\u{1103}\u{1169}\u{11ae}"), ("\u{b3cc}", "\u{b3cc}",
        "\u{1103}\u{1169}\u{11af}", "\u{b3cc}", "\u{1103}\u{1169}\u{11af}"), ("\u{b3cd}",
        "\u{b3cd}", "\u{1103}\u{1169}\u{11b0}", "\u{b3cd}", "\u{1103}\u{1169}\u{11b0}"),
        ("\u{b3ce}", "\u{b3ce}", "\u{1103}\u{1169}\u{11b1}", "\u{b3ce}",
        "\u{1103}\u{1169}\u{11b1}"), ("\u{b3cf}", "\u{b3cf}", "\u{1103}\u{1169}\u{11b2}",
        "\u{b3cf}", "\u{1103}\u{1169}\u{11b2}"), ("\u{b3d0}", "\u{b3d0}",
        "\u{1103}\u{1169}\u{11b3}", "\u{b3d0}", "\u{1103}\u{1169}\u{11b3}"), ("\u{b3d1}",
        "\u{b3d1}", "\u{1103}\u{1169}\u{11b4}", "\u{b3d1}", "\u{1103}\u{1169}\u{11b4}"),
        ("\u{b3d2}", "\u{b3d2}", "\u{1103}\u{1169}\u{11b5}", "\u{b3d2}",
        "\u{1103}\u{1169}\u{11b5}"), ("\u{b3d3}", "\u{b3d3}", "\u{1103}\u{1169}\u{11b6}",
        "\u{b3d3}", "\u{1103}\u{1169}\u{11b6}"), ("\u{b3d4}", "\u{b3d4}",
        "\u{1103}\u{1169}\u{11b7}", "\u{b3d4}", "\u{1103}\u{1169}\u{11b7}"), ("\u{b3d5}",
        "\u{b3d5}", "\u{1103}\u{1169}\u{11b8}", "\u{b3d5}", "\u{1103}\u{1169}\u{11b8}"),
        ("\u{b3d6}", "\u{b3d6}", "\u{1103}\u{1169}\u{11b9}", "\u{b3d6}",
        "\u{1103}\u{1169}\u{11b9}"), ("\u{b3d7}", "\u{b3d7}", "\u{1103}\u{1169}\u{11ba}",
        "\u{b3d7}", "\u{1103}\u{1169}\u{11ba}"), ("\u{b3d8}", "\u{b3d8}",
        "\u{1103}\u{1169}\u{11bb}", "\u{b3d8}", "\u{1103}\u{1169}\u{11bb}"), ("\u{b3d9}",
        "\u{b3d9}", "\u{1103}\u{1169}\u{11bc}", "\u{b3d9}", "\u{1103}\u{1169}\u{11bc}"),
        ("\u{b3da}", "\u{b3da}", "\u{1103}\u{1169}\u{11bd}", "\u{b3da}",
        "\u{1103}\u{1169}\u{11bd}"), ("\u{b3db}", "\u{b3db}", "\u{1103}\u{1169}\u{11be}",
        "\u{b3db}", "\u{1103}\u{1169}\u{11be}"), ("\u{b3dc}", "\u{b3dc}",
        "\u{1103}\u{1169}\u{11bf}", "\u{b3dc}", "\u{1103}\u{1169}\u{11bf}"), ("\u{b3dd}",
        "\u{b3dd}", "\u{1103}\u{1169}\u{11c0}", "\u{b3dd}", "\u{1103}\u{1169}\u{11c0}"),
        ("\u{b3de}", "\u{b3de}", "\u{1103}\u{1169}\u{11c1}", "\u{b3de}",
        "\u{1103}\u{1169}\u{11c1}"), ("\u{b3df}", "\u{b3df}", "\u{1103}\u{1169}\u{11c2}",
        "\u{b3df}", "\u{1103}\u{1169}\u{11c2}"), ("\u{b3e0}", "\u{b3e0}", "\u{1103}\u{116a}",
        "\u{b3e0}", "\u{1103}\u{116a}"), ("\u{b3e1}", "\u{b3e1}", "\u{1103}\u{116a}\u{11a8}",
        "\u{b3e1}", "\u{1103}\u{116a}\u{11a8}"), ("\u{b3e2}", "\u{b3e2}",
        "\u{1103}\u{116a}\u{11a9}", "\u{b3e2}", "\u{1103}\u{116a}\u{11a9}"), ("\u{b3e3}",
        "\u{b3e3}", "\u{1103}\u{116a}\u{11aa}", "\u{b3e3}", "\u{1103}\u{116a}\u{11aa}"),
        ("\u{b3e4}", "\u{b3e4}", "\u{1103}\u{116a}\u{11ab}", "\u{b3e4}",
        "\u{1103}\u{116a}\u{11ab}"), ("\u{b3e5}", "\u{b3e5}", "\u{1103}\u{116a}\u{11ac}",
        "\u{b3e5}", "\u{1103}\u{116a}\u{11ac}"), ("\u{b3e6}", "\u{b3e6}",
        "\u{1103}\u{116a}\u{11ad}", "\u{b3e6}", "\u{1103}\u{116a}\u{11ad}"), ("\u{b3e7}",
        "\u{b3e7}", "\u{1103}\u{116a}\u{11ae}", "\u{b3e7}", "\u{1103}\u{116a}\u{11ae}"),
        ("\u{b3e8}", "\u{b3e8}", "\u{1103}\u{116a}\u{11af}", "\u{b3e8}",
        "\u{1103}\u{116a}\u{11af}"), ("\u{b3e9}", "\u{b3e9}", "\u{1103}\u{116a}\u{11b0}",
        "\u{b3e9}", "\u{1103}\u{116a}\u{11b0}"), ("\u{b3ea}", "\u{b3ea}",
        "\u{1103}\u{116a}\u{11b1}", "\u{b3ea}", "\u{1103}\u{116a}\u{11b1}"), ("\u{b3eb}",
        "\u{b3eb}", "\u{1103}\u{116a}\u{11b2}", "\u{b3eb}", "\u{1103}\u{116a}\u{11b2}"),
        ("\u{b3ec}", "\u{b3ec}", "\u{1103}\u{116a}\u{11b3}", "\u{b3ec}",
        "\u{1103}\u{116a}\u{11b3}"), ("\u{b3ed}", "\u{b3ed}", "\u{1103}\u{116a}\u{11b4}",
        "\u{b3ed}", "\u{1103}\u{116a}\u{11b4}"), ("\u{b3ee}", "\u{b3ee}",
        "\u{1103}\u{116a}\u{11b5}", "\u{b3ee}", "\u{1103}\u{116a}\u{11b5}"), ("\u{b3ef}",
        "\u{b3ef}", "\u{1103}\u{116a}\u{11b6}", "\u{b3ef}", "\u{1103}\u{116a}\u{11b6}"),
        ("\u{b3f0}", "\u{b3f0}", "\u{1103}\u{116a}\u{11b7}", "\u{b3f0}",
        "\u{1103}\u{116a}\u{11b7}"), ("\u{b3f1}", "\u{b3f1}", "\u{1103}\u{116a}\u{11b8}",
        "\u{b3f1}", "\u{1103}\u{116a}\u{11b8}"), ("\u{b3f2}", "\u{b3f2}",
        "\u{1103}\u{116a}\u{11b9}", "\u{b3f2}", "\u{1103}\u{116a}\u{11b9}"), ("\u{b3f3}",
        "\u{b3f3}", "\u{1103}\u{116a}\u{11ba}", "\u{b3f3}", "\u{1103}\u{116a}\u{11ba}"),
        ("\u{b3f4}", "\u{b3f4}", "\u{1103}\u{116a}\u{11bb}", "\u{b3f4}",
        "\u{1103}\u{116a}\u{11bb}"), ("\u{b3f5}", "\u{b3f5}", "\u{1103}\u{116a}\u{11bc}",
        "\u{b3f5}", "\u{1103}\u{116a}\u{11bc}"), ("\u{b3f6}", "\u{b3f6}",
        "\u{1103}\u{116a}\u{11bd}", "\u{b3f6}", "\u{1103}\u{116a}\u{11bd}"), ("\u{b3f7}",
        "\u{b3f7}", "\u{1103}\u{116a}\u{11be}", "\u{b3f7}", "\u{1103}\u{116a}\u{11be}"),
        ("\u{b3f8}", "\u{b3f8}", "\u{1103}\u{116a}\u{11bf}", "\u{b3f8}",
        "\u{1103}\u{116a}\u{11bf}"), ("\u{b3f9}", "\u{b3f9}", "\u{1103}\u{116a}\u{11c0}",
        "\u{b3f9}", "\u{1103}\u{116a}\u{11c0}"), ("\u{b3fa}", "\u{b3fa}",
        "\u{1103}\u{116a}\u{11c1}", "\u{b3fa}", "\u{1103}\u{116a}\u{11c1}"), ("\u{b3fb}",
        "\u{b3fb}", "\u{1103}\u{116a}\u{11c2}", "\u{b3fb}", "\u{1103}\u{116a}\u{11c2}"),
        ("\u{b3fc}", "\u{b3fc}", "\u{1103}\u{116b}", "\u{b3fc}", "\u{1103}\u{116b}"), ("\u{b3fd}",
        "\u{b3fd}", "\u{1103}\u{116b}\u{11a8}", "\u{b3fd}", "\u{1103}\u{116b}\u{11a8}"),
        ("\u{b3fe}", "\u{b3fe}", "\u{1103}\u{116b}\u{11a9}", "\u{b3fe}",
        "\u{1103}\u{116b}\u{11a9}"), ("\u{b3ff}", "\u{b3ff}", "\u{1103}\u{116b}\u{11aa}",
        "\u{b3ff}", "\u{1103}\u{116b}\u{11aa}"), ("\u{b400}", "\u{b400}",
        "\u{1103}\u{116b}\u{11ab}", "\u{b400}", "\u{1103}\u{116b}\u{11ab}"), ("\u{b401}",
        "\u{b401}", "\u{1103}\u{116b}\u{11ac}", "\u{b401}", "\u{1103}\u{116b}\u{11ac}"),
        ("\u{b402}", "\u{b402}", "\u{1103}\u{116b}\u{11ad}", "\u{b402}",
        "\u{1103}\u{116b}\u{11ad}"), ("\u{b403}", "\u{b403}", "\u{1103}\u{116b}\u{11ae}",
        "\u{b403}", "\u{1103}\u{116b}\u{11ae}"), ("\u{b404}", "\u{b404}",
        "\u{1103}\u{116b}\u{11af}", "\u{b404}", "\u{1103}\u{116b}\u{11af}"), ("\u{b405}",
        "\u{b405}", "\u{1103}\u{116b}\u{11b0}", "\u{b405}", "\u{1103}\u{116b}\u{11b0}"),
        ("\u{b406}", "\u{b406}", "\u{1103}\u{116b}\u{11b1}", "\u{b406}",
        "\u{1103}\u{116b}\u{11b1}"), ("\u{b407}", "\u{b407}", "\u{1103}\u{116b}\u{11b2}",
        "\u{b407}", "\u{1103}\u{116b}\u{11b2}"), ("\u{b408}", "\u{b408}",
        "\u{1103}\u{116b}\u{11b3}", "\u{b408}", "\u{1103}\u{116b}\u{11b3}"), ("\u{b409}",
        "\u{b409}", "\u{1103}\u{116b}\u{11b4}", "\u{b409}", "\u{1103}\u{116b}\u{11b4}"),
        ("\u{b40a}", "\u{b40a}", "\u{1103}\u{116b}\u{11b5}", "\u{b40a}",
        "\u{1103}\u{116b}\u{11b5}"), ("\u{b40b}", "\u{b40b}", "\u{1103}\u{116b}\u{11b6}",
        "\u{b40b}", "\u{1103}\u{116b}\u{11b6}"), ("\u{b40c}", "\u{b40c}",
        "\u{1103}\u{116b}\u{11b7}", "\u{b40c}", "\u{1103}\u{116b}\u{11b7}"), ("\u{b40d}",
        "\u{b40d}", "\u{1103}\u{116b}\u{11b8}", "\u{b40d}", "\u{1103}\u{116b}\u{11b8}"),
        ("\u{b40e}", "\u{b40e}", "\u{1103}\u{116b}\u{11b9}", "\u{b40e}",
        "\u{1103}\u{116b}\u{11b9}"), ("\u{b40f}", "\u{b40f}", "\u{1103}\u{116b}\u{11ba}",
        "\u{b40f}", "\u{1103}\u{116b}\u{11ba}"), ("\u{b410}", "\u{b410}",
        "\u{1103}\u{116b}\u{11bb}", "\u{b410}", "\u{1103}\u{116b}\u{11bb}"), ("\u{b411}",
        "\u{b411}", "\u{1103}\u{116b}\u{11bc}", "\u{b411}", "\u{1103}\u{116b}\u{11bc}"),
        ("\u{b412}", "\u{b412}", "\u{1103}\u{116b}\u{11bd}", "\u{b412}",
        "\u{1103}\u{116b}\u{11bd}"), ("\u{b413}", "\u{b413}", "\u{1103}\u{116b}\u{11be}",
        "\u{b413}", "\u{1103}\u{116b}\u{11be}"), ("\u{b414}", "\u{b414}",
        "\u{1103}\u{116b}\u{11bf}", "\u{b414}", "\u{1103}\u{116b}\u{11bf}"), ("\u{b415}",
        "\u{b415}", "\u{1103}\u{116b}\u{11c0}", "\u{b415}", "\u{1103}\u{116b}\u{11c0}"),
        ("\u{b416}", "\u{b416}", "\u{1103}\u{116b}\u{11c1}", "\u{b416}",
        "\u{1103}\u{116b}\u{11c1}"), ("\u{b417}", "\u{b417}", "\u{1103}\u{116b}\u{11c2}",
        "\u{b417}", "\u{1103}\u{116b}\u{11c2}"), ("\u{b418}", "\u{b418}", "\u{1103}\u{116c}",
        "\u{b418}", "\u{1103}\u{116c}"), ("\u{b419}", "\u{b419}", "\u{1103}\u{116c}\u{11a8}",
        "\u{b419}", "\u{1103}\u{116c}\u{11a8}"), ("\u{b41a}", "\u{b41a}",
        "\u{1103}\u{116c}\u{11a9}", "\u{b41a}", "\u{1103}\u{116c}\u{11a9}"), ("\u{b41b}",
        "\u{b41b}", "\u{1103}\u{116c}\u{11aa}", "\u{b41b}", "\u{1103}\u{116c}\u{11aa}"),
        ("\u{b41c}", "\u{b41c}", "\u{1103}\u{116c}\u{11ab}", "\u{b41c}",
        "\u{1103}\u{116c}\u{11ab}"), ("\u{b41d}", "\u{b41d}", "\u{1103}\u{116c}\u{11ac}",
        "\u{b41d}", "\u{1103}\u{116c}\u{11ac}"), ("\u{b41e}", "\u{b41e}",
        "\u{1103}\u{116c}\u{11ad}", "\u{b41e}", "\u{1103}\u{116c}\u{11ad}"), ("\u{b41f}",
        "\u{b41f}", "\u{1103}\u{116c}\u{11ae}", "\u{b41f}", "\u{1103}\u{116c}\u{11ae}"),
        ("\u{b420}", "\u{b420}", "\u{1103}\u{116c}\u{11af}", "\u{b420}",
        "\u{1103}\u{116c}\u{11af}"), ("\u{b421}", "\u{b421}", "\u{1103}\u{116c}\u{11b0}",
        "\u{b421}", "\u{1103}\u{116c}\u{11b0}"), ("\u{b422}", "\u{b422}",
        "\u{1103}\u{116c}\u{11b1}", "\u{b422}", "\u{1103}\u{116c}\u{11b1}"), ("\u{b423}",
        "\u{b423}", "\u{1103}\u{116c}\u{11b2}", "\u{b423}", "\u{1103}\u{116c}\u{11b2}"),
        ("\u{b424}", "\u{b424}", "\u{1103}\u{116c}\u{11b3}", "\u{b424}",
        "\u{1103}\u{116c}\u{11b3}"), ("\u{b425}", "\u{b425}", "\u{1103}\u{116c}\u{11b4}",
        "\u{b425}", "\u{1103}\u{116c}\u{11b4}"), ("\u{b426}", "\u{b426}",
        "\u{1103}\u{116c}\u{11b5}", "\u{b426}", "\u{1103}\u{116c}\u{11b5}"), ("\u{b427}",
        "\u{b427}", "\u{1103}\u{116c}\u{11b6}", "\u{b427}", "\u{1103}\u{116c}\u{11b6}"),
        ("\u{b428}", "\u{b428}", "\u{1103}\u{116c}\u{11b7}", "\u{b428}",
        "\u{1103}\u{116c}\u{11b7}"), ("\u{b429}", "\u{b429}", "\u{1103}\u{116c}\u{11b8}",
        "\u{b429}", "\u{1103}\u{116c}\u{11b8}"), ("\u{b42a}", "\u{b42a}",
        "\u{1103}\u{116c}\u{11b9}", "\u{b42a}", "\u{1103}\u{116c}\u{11b9}"), ("\u{b42b}",
        "\u{b42b}", "\u{1103}\u{116c}\u{11ba}", "\u{b42b}", "\u{1103}\u{116c}\u{11ba}"),
        ("\u{b42c}", "\u{b42c}", "\u{1103}\u{116c}\u{11bb}", "\u{b42c}",
        "\u{1103}\u{116c}\u{11bb}"), ("\u{b42d}", "\u{b42d}", "\u{1103}\u{116c}\u{11bc}",
        "\u{b42d}", "\u{1103}\u{116c}\u{11bc}"), ("\u{b42e}", "\u{b42e}",
        "\u{1103}\u{116c}\u{11bd}", "\u{b42e}", "\u{1103}\u{116c}\u{11bd}"), ("\u{b42f}",
        "\u{b42f}", "\u{1103}\u{116c}\u{11be}", "\u{b42f}", "\u{1103}\u{116c}\u{11be}"),
        ("\u{b430}", "\u{b430}", "\u{1103}\u{116c}\u{11bf}", "\u{b430}",
        "\u{1103}\u{116c}\u{11bf}"), ("\u{b431}", "\u{b431}", "\u{1103}\u{116c}\u{11c0}",
        "\u{b431}", "\u{1103}\u{116c}\u{11c0}"), ("\u{b432}", "\u{b432}",
        "\u{1103}\u{116c}\u{11c1}", "\u{b432}", "\u{1103}\u{116c}\u{11c1}"), ("\u{b433}",
        "\u{b433}", "\u{1103}\u{116c}\u{11c2}", "\u{b433}", "\u{1103}\u{116c}\u{11c2}"),
        ("\u{b434}", "\u{b434}", "\u{1103}\u{116d}", "\u{b434}", "\u{1103}\u{116d}"), ("\u{b435}",
        "\u{b435}", "\u{1103}\u{116d}\u{11a8}", "\u{b435}", "\u{1103}\u{116d}\u{11a8}"),
        ("\u{b436}", "\u{b436}", "\u{1103}\u{116d}\u{11a9}", "\u{b436}",
        "\u{1103}\u{116d}\u{11a9}"), ("\u{b437}", "\u{b437}", "\u{1103}\u{116d}\u{11aa}",
        "\u{b437}", "\u{1103}\u{116d}\u{11aa}"), ("\u{b438}", "\u{b438}",
        "\u{1103}\u{116d}\u{11ab}", "\u{b438}", "\u{1103}\u{116d}\u{11ab}"), ("\u{b439}",
        "\u{b439}", "\u{1103}\u{116d}\u{11ac}", "\u{b439}", "\u{1103}\u{116d}\u{11ac}"),
        ("\u{b43a}", "\u{b43a}", "\u{1103}\u{116d}\u{11ad}", "\u{b43a}",
        "\u{1103}\u{116d}\u{11ad}"), ("\u{b43b}", "\u{b43b}", "\u{1103}\u{116d}\u{11ae}",
        "\u{b43b}", "\u{1103}\u{116d}\u{11ae}"), ("\u{b43c}", "\u{b43c}",
        "\u{1103}\u{116d}\u{11af}", "\u{b43c}", "\u{1103}\u{116d}\u{11af}"), ("\u{b43d}",
        "\u{b43d}", "\u{1103}\u{116d}\u{11b0}", "\u{b43d}", "\u{1103}\u{116d}\u{11b0}"),
        ("\u{b43e}", "\u{b43e}", "\u{1103}\u{116d}\u{11b1}", "\u{b43e}",
        "\u{1103}\u{116d}\u{11b1}"), ("\u{b43f}", "\u{b43f}", "\u{1103}\u{116d}\u{11b2}",
        "\u{b43f}", "\u{1103}\u{116d}\u{11b2}"), ("\u{b440}", "\u{b440}",
        "\u{1103}\u{116d}\u{11b3}", "\u{b440}", "\u{1103}\u{116d}\u{11b3}"), ("\u{b441}",
        "\u{b441}", "\u{1103}\u{116d}\u{11b4}", "\u{b441}", "\u{1103}\u{116d}\u{11b4}"),
        ("\u{b442}", "\u{b442}", "\u{1103}\u{116d}\u{11b5}", "\u{b442}",
        "\u{1103}\u{116d}\u{11b5}"), ("\u{b443}", "\u{b443}", "\u{1103}\u{116d}\u{11b6}",
        "\u{b443}", "\u{1103}\u{116d}\u{11b6}"), ("\u{b444}", "\u{b444}",
        "\u{1103}\u{116d}\u{11b7}", "\u{b444}", "\u{1103}\u{116d}\u{11b7}"), ("\u{b445}",
        "\u{b445}", "\u{1103}\u{116d}\u{11b8}", "\u{b445}", "\u{1103}\u{116d}\u{11b8}"),
        ("\u{b446}", "\u{b446}", "\u{1103}\u{116d}\u{11b9}", "\u{b446}",
        "\u{1103}\u{116d}\u{11b9}"), ("\u{b447}", "\u{b447}", "\u{1103}\u{116d}\u{11ba}",
        "\u{b447}", "\u{1103}\u{116d}\u{11ba}"), ("\u{b448}", "\u{b448}",
        "\u{1103}\u{116d}\u{11bb}", "\u{b448}", "\u{1103}\u{116d}\u{11bb}"), ("\u{b449}",
        "\u{b449}", "\u{1103}\u{116d}\u{11bc}", "\u{b449}", "\u{1103}\u{116d}\u{11bc}"),
        ("\u{b44a}", "\u{b44a}", "\u{1103}\u{116d}\u{11bd}", "\u{b44a}",
        "\u{1103}\u{116d}\u{11bd}"), ("\u{b44b}", "\u{b44b}", "\u{1103}\u{116d}\u{11be}",
        "\u{b44b}", "\u{1103}\u{116d}\u{11be}"), ("\u{b44c}", "\u{b44c}",
        "\u{1103}\u{116d}\u{11bf}", "\u{b44c}", "\u{1103}\u{116d}\u{11bf}"), ("\u{b44d}",
        "\u{b44d}", "\u{1103}\u{116d}\u{11c0}", "\u{b44d}", "\u{1103}\u{116d}\u{11c0}"),
        ("\u{b44e}", "\u{b44e}", "\u{1103}\u{116d}\u{11c1}", "\u{b44e}",
        "\u{1103}\u{116d}\u{11c1}"), ("\u{b44f}", "\u{b44f}", "\u{1103}\u{116d}\u{11c2}",
        "\u{b44f}", "\u{1103}\u{116d}\u{11c2}"), ("\u{b450}", "\u{b450}", "\u{1103}\u{116e}",
        "\u{b450}", "\u{1103}\u{116e}"), ("\u{b451}", "\u{b451}", "\u{1103}\u{116e}\u{11a8}",
        "\u{b451}", "\u{1103}\u{116e}\u{11a8}"), ("\u{b452}", "\u{b452}",
        "\u{1103}\u{116e}\u{11a9}", "\u{b452}", "\u{1103}\u{116e}\u{11a9}"), ("\u{b453}",
        "\u{b453}", "\u{1103}\u{116e}\u{11aa}", "\u{b453}", "\u{1103}\u{116e}\u{11aa}"),
        ("\u{b454}", "\u{b454}", "\u{1103}\u{116e}\u{11ab}", "\u{b454}",
        "\u{1103}\u{116e}\u{11ab}"), ("\u{b455}", "\u{b455}", "\u{1103}\u{116e}\u{11ac}",
        "\u{b455}", "\u{1103}\u{116e}\u{11ac}"), ("\u{b456}", "\u{b456}",
        "\u{1103}\u{116e}\u{11ad}", "\u{b456}", "\u{1103}\u{116e}\u{11ad}"), ("\u{b457}",
        "\u{b457}", "\u{1103}\u{116e}\u{11ae}", "\u{b457}", "\u{1103}\u{116e}\u{11ae}"),
        ("\u{b458}", "\u{b458}", "\u{1103}\u{116e}\u{11af}", "\u{b458}",
        "\u{1103}\u{116e}\u{11af}"), ("\u{b459}", "\u{b459}", "\u{1103}\u{116e}\u{11b0}",
        "\u{b459}", "\u{1103}\u{116e}\u{11b0}"), ("\u{b45a}", "\u{b45a}",
        "\u{1103}\u{116e}\u{11b1}", "\u{b45a}", "\u{1103}\u{116e}\u{11b1}"), ("\u{b45b}",
        "\u{b45b}", "\u{1103}\u{116e}\u{11b2}", "\u{b45b}", "\u{1103}\u{116e}\u{11b2}"),
        ("\u{b45c}", "\u{b45c}", "\u{1103}\u{116e}\u{11b3}", "\u{b45c}",
        "\u{1103}\u{116e}\u{11b3}"), ("\u{b45d}", "\u{b45d}", "\u{1103}\u{116e}\u{11b4}",
        "\u{b45d}", "\u{1103}\u{116e}\u{11b4}"), ("\u{b45e}", "\u{b45e}",
        "\u{1103}\u{116e}\u{11b5}", "\u{b45e}", "\u{1103}\u{116e}\u{11b5}"), ("\u{b45f}",
        "\u{b45f}", "\u{1103}\u{116e}\u{11b6}", "\u{b45f}", "\u{1103}\u{116e}\u{11b6}"),
        ("\u{b460}", "\u{b460}", "\u{1103}\u{116e}\u{11b7}", "\u{b460}",
        "\u{1103}\u{116e}\u{11b7}"), ("\u{b461}", "\u{b461}", "\u{1103}\u{116e}\u{11b8}",
        "\u{b461}", "\u{1103}\u{116e}\u{11b8}"), ("\u{b462}", "\u{b462}",
        "\u{1103}\u{116e}\u{11b9}", "\u{b462}", "\u{1103}\u{116e}\u{11b9}"), ("\u{b463}",
        "\u{b463}", "\u{1103}\u{116e}\u{11ba}", "\u{b463}", "\u{1103}\u{116e}\u{11ba}"),
        ("\u{b464}", "\u{b464}", "\u{1103}\u{116e}\u{11bb}", "\u{b464}",
        "\u{1103}\u{116e}\u{11bb}"), ("\u{b465}", "\u{b465}", "\u{1103}\u{116e}\u{11bc}",
        "\u{b465}", "\u{1103}\u{116e}\u{11bc}"), ("\u{b466}", "\u{b466}",
        "\u{1103}\u{116e}\u{11bd}", "\u{b466}", "\u{1103}\u{116e}\u{11bd}"), ("\u{b467}",
        "\u{b467}", "\u{1103}\u{116e}\u{11be}", "\u{b467}", "\u{1103}\u{116e}\u{11be}"),
        ("\u{b468}", "\u{b468}", "\u{1103}\u{116e}\u{11bf}", "\u{b468}",
        "\u{1103}\u{116e}\u{11bf}"), ("\u{b469}", "\u{b469}", "\u{1103}\u{116e}\u{11c0}",
        "\u{b469}", "\u{1103}\u{116e}\u{11c0}"), ("\u{b46a}", "\u{b46a}",
        "\u{1103}\u{116e}\u{11c1}", "\u{b46a}", "\u{1103}\u{116e}\u{11c1}"), ("\u{b46b}",
        "\u{b46b}", "\u{1103}\u{116e}\u{11c2}", "\u{b46b}", "\u{1103}\u{116e}\u{11c2}"),
        ("\u{b46c}", "\u{b46c}", "\u{1103}\u{116f}", "\u{b46c}", "\u{1103}\u{116f}"), ("\u{b46d}",
        "\u{b46d}", "\u{1103}\u{116f}\u{11a8}", "\u{b46d}", "\u{1103}\u{116f}\u{11a8}"),
        ("\u{b46e}", "\u{b46e}", "\u{1103}\u{116f}\u{11a9}", "\u{b46e}",
        "\u{1103}\u{116f}\u{11a9}"), ("\u{b46f}", "\u{b46f}", "\u{1103}\u{116f}\u{11aa}",
        "\u{b46f}", "\u{1103}\u{116f}\u{11aa}"), ("\u{b470}", "\u{b470}",
        "\u{1103}\u{116f}\u{11ab}", "\u{b470}", "\u{1103}\u{116f}\u{11ab}"), ("\u{b471}",
        "\u{b471}", "\u{1103}\u{116f}\u{11ac}", "\u{b471}", "\u{1103}\u{116f}\u{11ac}"),
        ("\u{b472}", "\u{b472}", "\u{1103}\u{116f}\u{11ad}", "\u{b472}",
        "\u{1103}\u{116f}\u{11ad}"), ("\u{b473}", "\u{b473}", "\u{1103}\u{116f}\u{11ae}",
        "\u{b473}", "\u{1103}\u{116f}\u{11ae}"), ("\u{b474}", "\u{b474}",
        "\u{1103}\u{116f}\u{11af}", "\u{b474}", "\u{1103}\u{116f}\u{11af}"), ("\u{b475}",
        "\u{b475}", "\u{1103}\u{116f}\u{11b0}", "\u{b475}", "\u{1103}\u{116f}\u{11b0}"),
        ("\u{b476}", "\u{b476}", "\u{1103}\u{116f}\u{11b1}", "\u{b476}",
        "\u{1103}\u{116f}\u{11b1}"), ("\u{b477}", "\u{b477}", "\u{1103}\u{116f}\u{11b2}",
        "\u{b477}", "\u{1103}\u{116f}\u{11b2}"), ("\u{b478}", "\u{b478}",
        "\u{1103}\u{116f}\u{11b3}", "\u{b478}", "\u{1103}\u{116f}\u{11b3}"), ("\u{b479}",
        "\u{b479}", "\u{1103}\u{116f}\u{11b4}", "\u{b479}", "\u{1103}\u{116f}\u{11b4}"),
        ("\u{b47a}", "\u{b47a}", "\u{1103}\u{116f}\u{11b5}", "\u{b47a}",
        "\u{1103}\u{116f}\u{11b5}"), ("\u{b47b}", "\u{b47b}", "\u{1103}\u{116f}\u{11b6}",
        "\u{b47b}", "\u{1103}\u{116f}\u{11b6}"), ("\u{b47c}", "\u{b47c}",
        "\u{1103}\u{116f}\u{11b7}", "\u{b47c}", "\u{1103}\u{116f}\u{11b7}"), ("\u{b47d}",
        "\u{b47d}", "\u{1103}\u{116f}\u{11b8}", "\u{b47d}", "\u{1103}\u{116f}\u{11b8}"),
        ("\u{b47e}", "\u{b47e}", "\u{1103}\u{116f}\u{11b9}", "\u{b47e}",
        "\u{1103}\u{116f}\u{11b9}"), ("\u{b47f}", "\u{b47f}", "\u{1103}\u{116f}\u{11ba}",
        "\u{b47f}", "\u{1103}\u{116f}\u{11ba}"), ("\u{b480}", "\u{b480}",
        "\u{1103}\u{116f}\u{11bb}", "\u{b480}", "\u{1103}\u{116f}\u{11bb}"), ("\u{b481}",
        "\u{b481}", "\u{1103}\u{116f}\u{11bc}", "\u{b481}", "\u{1103}\u{116f}\u{11bc}"),
        ("\u{b482}", "\u{b482}", "\u{1103}\u{116f}\u{11bd}", "\u{b482}",
        "\u{1103}\u{116f}\u{11bd}"), ("\u{b483}", "\u{b483}", "\u{1103}\u{116f}\u{11be}",
        "\u{b483}", "\u{1103}\u{116f}\u{11be}"), ("\u{b484}", "\u{b484}",
        "\u{1103}\u{116f}\u{11bf}", "\u{b484}", "\u{1103}\u{116f}\u{11bf}"), ("\u{b485}",
        "\u{b485}", "\u{1103}\u{116f}\u{11c0}", "\u{b485}", "\u{1103}\u{116f}\u{11c0}"),
        ("\u{b486}", "\u{b486}", "\u{1103}\u{116f}\u{11c1}", "\u{b486}",
        "\u{1103}\u{116f}\u{11c1}"), ("\u{b487}", "\u{b487}", "\u{1103}\u{116f}\u{11c2}",
        "\u{b487}", "\u{1103}\u{116f}\u{11c2}"), ("\u{b488}", "\u{b488}", "\u{1103}\u{1170}",
        "\u{b488}", "\u{1103}\u{1170}"), ("\u{b489}", "\u{b489}", "\u{1103}\u{1170}\u{11a8}",
        "\u{b489}", "\u{1103}\u{1170}\u{11a8}"), ("\u{b48a}", "\u{b48a}",
        "\u{1103}\u{1170}\u{11a9}", "\u{b48a}", "\u{1103}\u{1170}\u{11a9}"), ("\u{b48b}",
        "\u{b48b}", "\u{1103}\u{1170}\u{11aa}", "\u{b48b}", "\u{1103}\u{1170}\u{11aa}"),
        ("\u{b48c}", "\u{b48c}", "\u{1103}\u{1170}\u{11ab}", "\u{b48c}",
        "\u{1103}\u{1170}\u{11ab}"), ("\u{b48d}", "\u{b48d}", "\u{1103}\u{1170}\u{11ac}",
        "\u{b48d}", "\u{1103}\u{1170}\u{11ac}"), ("\u{b48e}", "\u{b48e}",
        "\u{1103}\u{1170}\u{11ad}", "\u{b48e}", "\u{1103}\u{1170}\u{11ad}"), ("\u{b48f}",
        "\u{b48f}", "\u{1103}\u{1170}\u{11ae}", "\u{b48f}", "\u{1103}\u{1170}\u{11ae}"),
        ("\u{b490}", "\u{b490}", "\u{1103}\u{1170}\u{11af}", "\u{b490}",
        "\u{1103}\u{1170}\u{11af}"), ("\u{b491}", "\u{b491}", "\u{1103}\u{1170}\u{11b0}",
        "\u{b491}", "\u{1103}\u{1170}\u{11b0}"), ("\u{b492}", "\u{b492}",
        "\u{1103}\u{1170}\u{11b1}", "\u{b492}", "\u{1103}\u{1170}\u{11b1}"), ("\u{b493}",
        "\u{b493}", "\u{1103}\u{1170}\u{11b2}", "\u{b493}", "\u{1103}\u{1170}\u{11b2}"),
        ("\u{b494}", "\u{b494}", "\u{1103}\u{1170}\u{11b3}", "\u{b494}",
        "\u{1103}\u{1170}\u{11b3}"), ("\u{b495}", "\u{b495}", "\u{1103}\u{1170}\u{11b4}",
        "\u{b495}", "\u{1103}\u{1170}\u{11b4}"), ("\u{b496}", "\u{b496}",
        "\u{1103}\u{1170}\u{11b5}", "\u{b496}", "\u{1103}\u{1170}\u{11b5}"), ("\u{b497}",
        "\u{b497}", "\u{1103}\u{1170}\u{11b6}", "\u{b497}", "\u{1103}\u{1170}\u{11b6}"),
        ("\u{b498}", "\u{b498}", "\u{1103}\u{1170}\u{11b7}", "\u{b498}",
        "\u{1103}\u{1170}\u{11b7}"), ("\u{b499}", "\u{b499}", "\u{1103}\u{1170}\u{11b8}",
        "\u{b499}", "\u{1103}\u{1170}\u{11b8}"), ("\u{b49a}", "\u{b49a}",
        "\u{1103}\u{1170}\u{11b9}", "\u{b49a}", "\u{1103}\u{1170}\u{11b9}"), ("\u{b49b}",
        "\u{b49b}", "\u{1103}\u{1170}\u{11ba}", "\u{b49b}", "\u{1103}\u{1170}\u{11ba}"),
        ("\u{b49c}", "\u{b49c}", "\u{1103}\u{1170}\u{11bb}", "\u{b49c}",
        "\u{1103}\u{1170}\u{11bb}"), ("\u{b49d}", "\u{b49d}", "\u{1103}\u{1170}\u{11bc}",
        "\u{b49d}", "\u{1103}\u{1170}\u{11bc}"), ("\u{b49e}", "\u{b49e}",
        "\u{1103}\u{1170}\u{11bd}", "\u{b49e}", "\u{1103}\u{1170}\u{11bd}"), ("\u{b49f}",
        "\u{b49f}", "\u{1103}\u{1170}\u{11be}", "\u{b49f}", "\u{1103}\u{1170}\u{11be}"),
        ("\u{b4a0}", "\u{b4a0}", "\u{1103}\u{1170}\u{11bf}", "\u{b4a0}",
        "\u{1103}\u{1170}\u{11bf}"), ("\u{b4a1}", "\u{b4a1}", "\u{1103}\u{1170}\u{11c0}",
        "\u{b4a1}", "\u{1103}\u{1170}\u{11c0}"), ("\u{b4a2}", "\u{b4a2}",
        "\u{1103}\u{1170}\u{11c1}", "\u{b4a2}", "\u{1103}\u{1170}\u{11c1}"), ("\u{b4a3}",
        "\u{b4a3}", "\u{1103}\u{1170}\u{11c2}", "\u{b4a3}", "\u{1103}\u{1170}\u{11c2}"),
        ("\u{b4a4}", "\u{b4a4}", "\u{1103}\u{1171}", "\u{b4a4}", "\u{1103}\u{1171}"), ("\u{b4a5}",
        "\u{b4a5}", "\u{1103}\u{1171}\u{11a8}", "\u{b4a5}", "\u{1103}\u{1171}\u{11a8}"),
        ("\u{b4a6}", "\u{b4a6}", "\u{1103}\u{1171}\u{11a9}", "\u{b4a6}",
        "\u{1103}\u{1171}\u{11a9}"), ("\u{b4a7}", "\u{b4a7}", "\u{1103}\u{1171}\u{11aa}",
        "\u{b4a7}", "\u{1103}\u{1171}\u{11aa}"), ("\u{b4a8}", "\u{b4a8}",
        "\u{1103}\u{1171}\u{11ab}", "\u{b4a8}", "\u{1103}\u{1171}\u{11ab}"), ("\u{b4a9}",
        "\u{b4a9}", "\u{1103}\u{1171}\u{11ac}", "\u{b4a9}", "\u{1103}\u{1171}\u{11ac}"),
        ("\u{b4aa}", "\u{b4aa}", "\u{1103}\u{1171}\u{11ad}", "\u{b4aa}",
        "\u{1103}\u{1171}\u{11ad}"), ("\u{b4ab}", "\u{b4ab}", "\u{1103}\u{1171}\u{11ae}",
        "\u{b4ab}", "\u{1103}\u{1171}\u{11ae}"), ("\u{b4ac}", "\u{b4ac}",
        "\u{1103}\u{1171}\u{11af}", "\u{b4ac}", "\u{1103}\u{1171}\u{11af}"), ("\u{b4ad}",
        "\u{b4ad}", "\u{1103}\u{1171}\u{11b0}", "\u{b4ad}", "\u{1103}\u{1171}\u{11b0}"),
        ("\u{b4ae}", "\u{b4ae}", "\u{1103}\u{1171}\u{11b1}", "\u{b4ae}",
        "\u{1103}\u{1171}\u{11b1}"), ("\u{b4af}", "\u{b4af}", "\u{1103}\u{1171}\u{11b2}",
        "\u{b4af}", "\u{1103}\u{1171}\u{11b2}"), ("\u{b4b0}", "\u{b4b0}",
        "\u{1103}\u{1171}\u{11b3}", "\u{b4b0}", "\u{1103}\u{1171}\u{11b3}"), ("\u{b4b1}",
        "\u{b4b1}", "\u{1103}\u{1171}\u{11b4}", "\u{b4b1}", "\u{1103}\u{1171}\u{11b4}"),
        ("\u{b4b2}", "\u{b4b2}", "\u{1103}\u{1171}\u{11b5}", "\u{b4b2}",
        "\u{1103}\u{1171}\u{11b5}"), ("\u{b4b3}", "\u{b4b3}", "\u{1103}\u{1171}\u{11b6}",
        "\u{b4b3}", "\u{1103}\u{1171}\u{11b6}"), ("\u{b4b4}", "\u{b4b4}",
        "\u{1103}\u{1171}\u{11b7}", "\u{b4b4}", "\u{1103}\u{1171}\u{11b7}"), ("\u{b4b5}",
        "\u{b4b5}", "\u{1103}\u{1171}\u{11b8}", "\u{b4b5}", "\u{1103}\u{1171}\u{11b8}"),
        ("\u{b4b6}", "\u{b4b6}", "\u{1103}\u{1171}\u{11b9}", "\u{b4b6}",
        "\u{1103}\u{1171}\u{11b9}"), ("\u{b4b7}", "\u{b4b7}", "\u{1103}\u{1171}\u{11ba}",
        "\u{b4b7}", "\u{1103}\u{1171}\u{11ba}"), ("\u{b4b8}", "\u{b4b8}",
        "\u{1103}\u{1171}\u{11bb}", "\u{b4b8}", "\u{1103}\u{1171}\u{11bb}"), ("\u{b4b9}",
        "\u{b4b9}", "\u{1103}\u{1171}\u{11bc}", "\u{b4b9}", "\u{1103}\u{1171}\u{11bc}"),
        ("\u{b4ba}", "\u{b4ba}", "\u{1103}\u{1171}\u{11bd}", "\u{b4ba}",
        "\u{1103}\u{1171}\u{11bd}"), ("\u{b4bb}", "\u{b4bb}", "\u{1103}\u{1171}\u{11be}",
        "\u{b4bb}", "\u{1103}\u{1171}\u{11be}"), ("\u{b4bc}", "\u{b4bc}",
        "\u{1103}\u{1171}\u{11bf}", "\u{b4bc}", "\u{1103}\u{1171}\u{11bf}"), ("\u{b4bd}",
        "\u{b4bd}", "\u{1103}\u{1171}\u{11c0}", "\u{b4bd}", "\u{1103}\u{1171}\u{11c0}"),
        ("\u{b4be}", "\u{b4be}", "\u{1103}\u{1171}\u{11c1}", "\u{b4be}",
        "\u{1103}\u{1171}\u{11c1}"), ("\u{b4bf}", "\u{b4bf}", "\u{1103}\u{1171}\u{11c2}",
        "\u{b4bf}", "\u{1103}\u{1171}\u{11c2}"), ("\u{b4c0}", "\u{b4c0}", "\u{1103}\u{1172}",
        "\u{b4c0}", "\u{1103}\u{1172}"), ("\u{b4c1}", "\u{b4c1}", "\u{1103}\u{1172}\u{11a8}",
        "\u{b4c1}", "\u{1103}\u{1172}\u{11a8}"), ("\u{b4c2}", "\u{b4c2}",
        "\u{1103}\u{1172}\u{11a9}", "\u{b4c2}", "\u{1103}\u{1172}\u{11a9}"), ("\u{b4c3}",
        "\u{b4c3}", "\u{1103}\u{1172}\u{11aa}", "\u{b4c3}", "\u{1103}\u{1172}\u{11aa}"),
        ("\u{b4c4}", "\u{b4c4}", "\u{1103}\u{1172}\u{11ab}", "\u{b4c4}",
        "\u{1103}\u{1172}\u{11ab}"), ("\u{b4c5}", "\u{b4c5}", "\u{1103}\u{1172}\u{11ac}",
        "\u{b4c5}", "\u{1103}\u{1172}\u{11ac}"), ("\u{b4c6}", "\u{b4c6}",
        "\u{1103}\u{1172}\u{11ad}", "\u{b4c6}", "\u{1103}\u{1172}\u{11ad}"), ("\u{b4c7}",
        "\u{b4c7}", "\u{1103}\u{1172}\u{11ae}", "\u{b4c7}", "\u{1103}\u{1172}\u{11ae}"),
        ("\u{b4c8}", "\u{b4c8}", "\u{1103}\u{1172}\u{11af}", "\u{b4c8}",
        "\u{1103}\u{1172}\u{11af}"), ("\u{b4c9}", "\u{b4c9}", "\u{1103}\u{1172}\u{11b0}",
        "\u{b4c9}", "\u{1103}\u{1172}\u{11b0}"), ("\u{b4ca}", "\u{b4ca}",
        "\u{1103}\u{1172}\u{11b1}", "\u{b4ca}", "\u{1103}\u{1172}\u{11b1}"), ("\u{b4cb}",
        "\u{b4cb}", "\u{1103}\u{1172}\u{11b2}", "\u{b4cb}", "\u{1103}\u{1172}\u{11b2}"),
        ("\u{b4cc}", "\u{b4cc}", "\u{1103}\u{1172}\u{11b3}", "\u{b4cc}",
        "\u{1103}\u{1172}\u{11b3}"), ("\u{b4cd}", "\u{b4cd}", "\u{1103}\u{1172}\u{11b4}",
        "\u{b4cd}", "\u{1103}\u{1172}\u{11b4}"), ("\u{b4ce}", "\u{b4ce}",
        "\u{1103}\u{1172}\u{11b5}", "\u{b4ce}", "\u{1103}\u{1172}\u{11b5}"), ("\u{b4cf}",
        "\u{b4cf}", "\u{1103}\u{1172}\u{11b6}", "\u{b4cf}", "\u{1103}\u{1172}\u{11b6}"),
        ("\u{b4d0}", "\u{b4d0}", "\u{1103}\u{1172}\u{11b7}", "\u{b4d0}",
        "\u{1103}\u{1172}\u{11b7}"), ("\u{b4d1}", "\u{b4d1}", "\u{1103}\u{1172}\u{11b8}",
        "\u{b4d1}", "\u{1103}\u{1172}\u{11b8}"), ("\u{b4d2}", "\u{b4d2}",
        "\u{1103}\u{1172}\u{11b9}", "\u{b4d2}", "\u{1103}\u{1172}\u{11b9}"), ("\u{b4d3}",
        "\u{b4d3}", "\u{1103}\u{1172}\u{11ba}", "\u{b4d3}", "\u{1103}\u{1172}\u{11ba}"),
        ("\u{b4d4}", "\u{b4d4}", "\u{1103}\u{1172}\u{11bb}", "\u{b4d4}",
        "\u{1103}\u{1172}\u{11bb}"), ("\u{b4d5}", "\u{b4d5}", "\u{1103}\u{1172}\u{11bc}",
        "\u{b4d5}", "\u{1103}\u{1172}\u{11bc}"), ("\u{b4d6}", "\u{b4d6}",
        "\u{1103}\u{1172}\u{11bd}", "\u{b4d6}", "\u{1103}\u{1172}\u{11bd}"), ("\u{b4d7}",
        "\u{b4d7}", "\u{1103}\u{1172}\u{11be}", "\u{b4d7}", "\u{1103}\u{1172}\u{11be}"),
        ("\u{b4d8}", "\u{b4d8}", "\u{1103}\u{1172}\u{11bf}", "\u{b4d8}",
        "\u{1103}\u{1172}\u{11bf}"), ("\u{b4d9}", "\u{b4d9}", "\u{1103}\u{1172}\u{11c0}",
        "\u{b4d9}", "\u{1103}\u{1172}\u{11c0}"), ("\u{b4da}", "\u{b4da}",
        "\u{1103}\u{1172}\u{11c1}", "\u{b4da}", "\u{1103}\u{1172}\u{11c1}"), ("\u{b4db}",
        "\u{b4db}", "\u{1103}\u{1172}\u{11c2}", "\u{b4db}", "\u{1103}\u{1172}\u{11c2}"),
        ("\u{b4dc}", "\u{b4dc}", "\u{1103}\u{1173}", "\u{b4dc}", "\u{1103}\u{1173}"), ("\u{b4dd}",
        "\u{b4dd}", "\u{1103}\u{1173}\u{11a8}", "\u{b4dd}", "\u{1103}\u{1173}\u{11a8}"),
        ("\u{b4de}", "\u{b4de}", "\u{1103}\u{1173}\u{11a9}", "\u{b4de}",
        "\u{1103}\u{1173}\u{11a9}"), ("\u{b4df}", "\u{b4df}", "\u{1103}\u{1173}\u{11aa}",
        "\u{b4df}", "\u{1103}\u{1173}\u{11aa}"), ("\u{b4e0}", "\u{b4e0}",
        "\u{1103}\u{1173}\u{11ab}", "\u{b4e0}", "\u{1103}\u{1173}\u{11ab}"), ("\u{b4e1}",
        "\u{b4e1}", "\u{1103}\u{1173}\u{11ac}", "\u{b4e1}", "\u{1103}\u{1173}\u{11ac}"),
        ("\u{b4e2}", "\u{b4e2}", "\u{1103}\u{1173}\u{11ad}", "\u{b4e2}",
        "\u{1103}\u{1173}\u{11ad}"), ("\u{b4e3}", "\u{b4e3}", "\u{1103}\u{1173}\u{11ae}",
        "\u{b4e3}", "\u{1103}\u{1173}\u{11ae}"), ("\u{b4e4}", "\u{b4e4}",
        "\u{1103}\u{1173}\u{11af}", "\u{b4e4}", "\u{1103}\u{1173}\u{11af}"), ("\u{b4e5}",
        "\u{b4e5}", "\u{1103}\u{1173}\u{11b0}", "\u{b4e5}", "\u{1103}\u{1173}\u{11b0}"),
        ("\u{b4e6}", "\u{b4e6}", "\u{1103}\u{1173}\u{11b1}", "\u{b4e6}",
        "\u{1103}\u{1173}\u{11b1}"), ("\u{b4e7}", "\u{b4e7}", "\u{1103}\u{1173}\u{11b2}",
        "\u{b4e7}", "\u{1103}\u{1173}\u{11b2}"), ("\u{b4e8}", "\u{b4e8}",
        "\u{1103}\u{1173}\u{11b3}", "\u{b4e8}", "\u{1103}\u{1173}\u{11b3}"), ("\u{b4e9}",
        "\u{b4e9}", "\u{1103}\u{1173}\u{11b4}", "\u{b4e9}", "\u{1103}\u{1173}\u{11b4}"),
        ("\u{b4ea}", "\u{b4ea}", "\u{1103}\u{1173}\u{11b5}", "\u{b4ea}",
        "\u{1103}\u{1173}\u{11b5}"), ("\u{b4eb}", "\u{b4eb}", "\u{1103}\u{1173}\u{11b6}",
        "\u{b4eb}", "\u{1103}\u{1173}\u{11b6}"), ("\u{b4ec}", "\u{b4ec}",
        "\u{1103}\u{1173}\u{11b7}", "\u{b4ec}", "\u{1103}\u{1173}\u{11b7}"), ("\u{b4ed}",
        "\u{b4ed}", "\u{1103}\u{1173}\u{11b8}", "\u{b4ed}", "\u{1103}\u{1173}\u{11b8}"),
        ("\u{b4ee}", "\u{b4ee}", "\u{1103}\u{1173}\u{11b9}", "\u{b4ee}",
        "\u{1103}\u{1173}\u{11b9}"), ("\u{b4ef}", "\u{b4ef}", "\u{1103}\u{1173}\u{11ba}",
        "\u{b4ef}", "\u{1103}\u{1173}\u{11ba}"), ("\u{b4f0}", "\u{b4f0}",
        "\u{1103}\u{1173}\u{11bb}", "\u{b4f0}", "\u{1103}\u{1173}\u{11bb}"), ("\u{b4f1}",
        "\u{b4f1}", "\u{1103}\u{1173}\u{11bc}", "\u{b4f1}", "\u{1103}\u{1173}\u{11bc}"),
        ("\u{b4f2}", "\u{b4f2}", "\u{1103}\u{1173}\u{11bd}", "\u{b4f2}",
        "\u{1103}\u{1173}\u{11bd}"), ("\u{b4f3}", "\u{b4f3}", "\u{1103}\u{1173}\u{11be}",
        "\u{b4f3}", "\u{1103}\u{1173}\u{11be}"), ("\u{b4f4}", "\u{b4f4}",
        "\u{1103}\u{1173}\u{11bf}", "\u{b4f4}", "\u{1103}\u{1173}\u{11bf}"), ("\u{b4f5}",
        "\u{b4f5}", "\u{1103}\u{1173}\u{11c0}", "\u{b4f5}", "\u{1103}\u{1173}\u{11c0}"),
        ("\u{b4f6}", "\u{b4f6}", "\u{1103}\u{1173}\u{11c1}", "\u{b4f6}",
        "\u{1103}\u{1173}\u{11c1}"), ("\u{b4f7}", "\u{b4f7}", "\u{1103}\u{1173}\u{11c2}",
        "\u{b4f7}", "\u{1103}\u{1173}\u{11c2}"), ("\u{b4f8}", "\u{b4f8}", "\u{1103}\u{1174}",
        "\u{b4f8}", "\u{1103}\u{1174}"), ("\u{b4f9}", "\u{b4f9}", "\u{1103}\u{1174}\u{11a8}",
        "\u{b4f9}", "\u{1103}\u{1174}\u{11a8}"), ("\u{b4fa}", "\u{b4fa}",
        "\u{1103}\u{1174}\u{11a9}", "\u{b4fa}", "\u{1103}\u{1174}\u{11a9}"), ("\u{b4fb}",
        "\u{b4fb}", "\u{1103}\u{1174}\u{11aa}", "\u{b4fb}", "\u{1103}\u{1174}\u{11aa}"),
        ("\u{b4fc}", "\u{b4fc}", "\u{1103}\u{1174}\u{11ab}", "\u{b4fc}",
        "\u{1103}\u{1174}\u{11ab}"), ("\u{b4fd}", "\u{b4fd}", "\u{1103}\u{1174}\u{11ac}",
        "\u{b4fd}", "\u{1103}\u{1174}\u{11ac}"), ("\u{b4fe}", "\u{b4fe}",
        "\u{1103}\u{1174}\u{11ad}", "\u{b4fe}", "\u{1103}\u{1174}\u{11ad}"), ("\u{b4ff}",
        "\u{b4ff}", "\u{1103}\u{1174}\u{11ae}", "\u{b4ff}", "\u{1103}\u{1174}\u{11ae}"),
        ("\u{b500}", "\u{b500}", "\u{1103}\u{1174}\u{11af}", "\u{b500}",
        "\u{1103}\u{1174}\u{11af}"), ("\u{b501}", "\u{b501}", "\u{1103}\u{1174}\u{11b0}",
        "\u{b501}", "\u{1103}\u{1174}\u{11b0}"), ("\u{b502}", "\u{b502}",
        "\u{1103}\u{1174}\u{11b1}", "\u{b502}", "\u{1103}\u{1174}\u{11b1}"), ("\u{b503}",
        "\u{b503}", "\u{1103}\u{1174}\u{11b2}", "\u{b503}", "\u{1103}\u{1174}\u{11b2}"),
        ("\u{b504}", "\u{b504}", "\u{1103}\u{1174}\u{11b3}", "\u{b504}",
        "\u{1103}\u{1174}\u{11b3}"), ("\u{b505}", "\u{b505}", "\u{1103}\u{1174}\u{11b4}",
        "\u{b505}", "\u{1103}\u{1174}\u{11b4}"), ("\u{b506}", "\u{b506}",
        "\u{1103}\u{1174}\u{11b5}", "\u{b506}", "\u{1103}\u{1174}\u{11b5}"), ("\u{b507}",
        "\u{b507}", "\u{1103}\u{1174}\u{11b6}", "\u{b507}", "\u{1103}\u{1174}\u{11b6}"),
        ("\u{b508}", "\u{b508}", "\u{1103}\u{1174}\u{11b7}", "\u{b508}",
        "\u{1103}\u{1174}\u{11b7}"), ("\u{b509}", "\u{b509}", "\u{1103}\u{1174}\u{11b8}",
        "\u{b509}", "\u{1103}\u{1174}\u{11b8}"), ("\u{b50a}", "\u{b50a}",
        "\u{1103}\u{1174}\u{11b9}", "\u{b50a}", "\u{1103}\u{1174}\u{11b9}"), ("\u{b50b}",
        "\u{b50b}", "\u{1103}\u{1174}\u{11ba}", "\u{b50b}", "\u{1103}\u{1174}\u{11ba}"),
        ("\u{b50c}", "\u{b50c}", "\u{1103}\u{1174}\u{11bb}", "\u{b50c}",
        "\u{1103}\u{1174}\u{11bb}"), ("\u{b50d}", "\u{b50d}", "\u{1103}\u{1174}\u{11bc}",
        "\u{b50d}", "\u{1103}\u{1174}\u{11bc}"), ("\u{b50e}", "\u{b50e}",
        "\u{1103}\u{1174}\u{11bd}", "\u{b50e}", "\u{1103}\u{1174}\u{11bd}"), ("\u{b50f}",
        "\u{b50f}", "\u{1103}\u{1174}\u{11be}", "\u{b50f}", "\u{1103}\u{1174}\u{11be}"),
        ("\u{b510}", "\u{b510}", "\u{1103}\u{1174}\u{11bf}", "\u{b510}",
        "\u{1103}\u{1174}\u{11bf}"), ("\u{b511}", "\u{b511}", "\u{1103}\u{1174}\u{11c0}",
        "\u{b511}", "\u{1103}\u{1174}\u{11c0}"), ("\u{b512}", "\u{b512}",
        "\u{1103}\u{1174}\u{11c1}", "\u{b512}", "\u{1103}\u{1174}\u{11c1}"), ("\u{b513}",
        "\u{b513}", "\u{1103}\u{1174}\u{11c2}", "\u{b513}", "\u{1103}\u{1174}\u{11c2}"),
        ("\u{b514}", "\u{b514}", "\u{1103}\u{1175}", "\u{b514}", "\u{1103}\u{1175}"), ("\u{b515}",
        "\u{b515}", "\u{1103}\u{1175}\u{11a8}", "\u{b515}", "\u{1103}\u{1175}\u{11a8}"),
        ("\u{b516}", "\u{b516}", "\u{1103}\u{1175}\u{11a9}", "\u{b516}",
        "\u{1103}\u{1175}\u{11a9}"), ("\u{b517}", "\u{b517}", "\u{1103}\u{1175}\u{11aa}",
        "\u{b517}", "\u{1103}\u{1175}\u{11aa}"), ("\u{b518}", "\u{b518}",
        "\u{1103}\u{1175}\u{11ab}", "\u{b518}", "\u{1103}\u{1175}\u{11ab}"), ("\u{b519}",
        "\u{b519}", "\u{1103}\u{1175}\u{11ac}", "\u{b519}", "\u{1103}\u{1175}\u{11ac}"),
        ("\u{b51a}", "\u{b51a}", "\u{1103}\u{1175}\u{11ad}", "\u{b51a}",
        "\u{1103}\u{1175}\u{11ad}"), ("\u{b51b}", "\u{b51b}", "\u{1103}\u{1175}\u{11ae}",
        "\u{b51b}", "\u{1103}\u{1175}\u{11ae}"), ("\u{b51c}", "\u{b51c}",
        "\u{1103}\u{1175}\u{11af}", "\u{b51c}", "\u{1103}\u{1175}\u{11af}"), ("\u{b51d}",
        "\u{b51d}", "\u{1103}\u{1175}\u{11b0}", "\u{b51d}", "\u{1103}\u{1175}\u{11b0}"),
        ("\u{b51e}", "\u{b51e}", "\u{1103}\u{1175}\u{11b1}", "\u{b51e}",
        "\u{1103}\u{1175}\u{11b1}"), ("\u{b51f}", "\u{b51f}", "\u{1103}\u{1175}\u{11b2}",
        "\u{b51f}", "\u{1103}\u{1175}\u{11b2}"), ("\u{b520}", "\u{b520}",
        "\u{1103}\u{1175}\u{11b3}", "\u{b520}", "\u{1103}\u{1175}\u{11b3}"), ("\u{b521}",
        "\u{b521}", "\u{1103}\u{1175}\u{11b4}", "\u{b521}", "\u{1103}\u{1175}\u{11b4}"),
        ("\u{b522}", "\u{b522}", "\u{1103}\u{1175}\u{11b5}", "\u{b522}",
        "\u{1103}\u{1175}\u{11b5}"), ("\u{b523}", "\u{b523}", "\u{1103}\u{1175}\u{11b6}",
        "\u{b523}", "\u{1103}\u{1175}\u{11b6}"), ("\u{b524}", "\u{b524}",
        "\u{1103}\u{1175}\u{11b7}", "\u{b524}", "\u{1103}\u{1175}\u{11b7}"), ("\u{b525}",
        "\u{b525}", "\u{1103}\u{1175}\u{11b8}", "\u{b525}", "\u{1103}\u{1175}\u{11b8}"),
        ("\u{b526}", "\u{b526}", "\u{1103}\u{1175}\u{11b9}", "\u{b526}",
        "\u{1103}\u{1175}\u{11b9}"), ("\u{b527}", "\u{b527}", "\u{1103}\u{1175}\u{11ba}",
        "\u{b527}", "\u{1103}\u{1175}\u{11ba}"), ("\u{b528}", "\u{b528}",
        "\u{1103}\u{1175}\u{11bb}", "\u{b528}", "\u{1103}\u{1175}\u{11bb}"), ("\u{b529}",
        "\u{b529}", "\u{1103}\u{1175}\u{11bc}", "\u{b529}", "\u{1103}\u{1175}\u{11bc}"),
        ("\u{b52a}", "\u{b52a}", "\u{1103}\u{1175}\u{11bd}", "\u{b52a}",
        "\u{1103}\u{1175}\u{11bd}"), ("\u{b52b}", "\u{b52b}", "\u{1103}\u{1175}\u{11be}",
        "\u{b52b}", "\u{1103}\u{1175}\u{11be}"), ("\u{b52c}", "\u{b52c}",
        "\u{1103}\u{1175}\u{11bf}", "\u{b52c}", "\u{1103}\u{1175}\u{11bf}"), ("\u{b52d}",
        "\u{b52d}", "\u{1103}\u{1175}\u{11c0}", "\u{b52d}", "\u{1103}\u{1175}\u{11c0}"),
        ("\u{b52e}", "\u{b52e}", "\u{1103}\u{1175}\u{11c1}", "\u{b52e}",
        "\u{1103}\u{1175}\u{11c1}"), ("\u{b52f}", "\u{b52f}", "\u{1103}\u{1175}\u{11c2}",
        "\u{b52f}", "\u{1103}\u{1175}\u{11c2}"), ("\u{b530}", "\u{b530}", "\u{1104}\u{1161}",
        "\u{b530}", "\u{1104}\u{1161}"), ("\u{b531}", "\u{b531}", "\u{1104}\u{1161}\u{11a8}",
        "\u{b531}", "\u{1104}\u{1161}\u{11a8}"), ("\u{b532}", "\u{b532}",
        "\u{1104}\u{1161}\u{11a9}", "\u{b532}", "\u{1104}\u{1161}\u{11a9}"), ("\u{b533}",
        "\u{b533}", "\u{1104}\u{1161}\u{11aa}", "\u{b533}", "\u{1104}\u{1161}\u{11aa}"),
        ("\u{b534}", "\u{b534}", "\u{1104}\u{1161}\u{11ab}", "\u{b534}",
        "\u{1104}\u{1161}\u{11ab}"), ("\u{b535}", "\u{b535}", "\u{1104}\u{1161}\u{11ac}",
        "\u{b535}", "\u{1104}\u{1161}\u{11ac}"), ("\u{b536}", "\u{b536}",
        "\u{1104}\u{1161}\u{11ad}", "\u{b536}", "\u{1104}\u{1161}\u{11ad}"), ("\u{b537}",
        "\u{b537}", "\u{1104}\u{1161}\u{11ae}", "\u{b537}", "\u{1104}\u{1161}\u{11ae}"),
        ("\u{b538}", "\u{b538}", "\u{1104}\u{1161}\u{11af}", "\u{b538}",
        "\u{1104}\u{1161}\u{11af}"), ("\u{b539}", "\u{b539}", "\u{1104}\u{1161}\u{11b0}",
        "\u{b539}", "\u{1104}\u{1161}\u{11b0}"), ("\u{b53a}", "\u{b53a}",
        "\u{1104}\u{1161}\u{11b1}", "\u{b53a}", "\u{1104}\u{1161}\u{11b1}"), ("\u{b53b}",
        "\u{b53b}", "\u{1104}\u{1161}\u{11b2}", "\u{b53b}", "\u{1104}\u{1161}\u{11b2}"),
        ("\u{b53c}", "\u{b53c}", "\u{1104}\u{1161}\u{11b3}", "\u{b53c}",
        "\u{1104}\u{1161}\u{11b3}"), ("\u{b53d}", "\u{b53d}", "\u{1104}\u{1161}\u{11b4}",
        "\u{b53d}", "\u{1104}\u{1161}\u{11b4}"), ("\u{b53e}", "\u{b53e}",
        "\u{1104}\u{1161}\u{11b5}", "\u{b53e}", "\u{1104}\u{1161}\u{11b5}"), ("\u{b53f}",
        "\u{b53f}", "\u{1104}\u{1161}\u{11b6}", "\u{b53f}", "\u{1104}\u{1161}\u{11b6}"),
        ("\u{b540}", "\u{b540}", "\u{1104}\u{1161}\u{11b7}", "\u{b540}",
        "\u{1104}\u{1161}\u{11b7}"), ("\u{b541}", "\u{b541}", "\u{1104}\u{1161}\u{11b8}",
        "\u{b541}", "\u{1104}\u{1161}\u{11b8}"), ("\u{b542}", "\u{b542}",
        "\u{1104}\u{1161}\u{11b9}", "\u{b542}", "\u{1104}\u{1161}\u{11b9}"), ("\u{b543}",
        "\u{b543}", "\u{1104}\u{1161}\u{11ba}", "\u{b543}", "\u{1104}\u{1161}\u{11ba}"),
        ("\u{b544}", "\u{b544}", "\u{1104}\u{1161}\u{11bb}", "\u{b544}",
        "\u{1104}\u{1161}\u{11bb}"), ("\u{b545}", "\u{b545}", "\u{1104}\u{1161}\u{11bc}",
        "\u{b545}", "\u{1104}\u{1161}\u{11bc}"), ("\u{b546}", "\u{b546}",
        "\u{1104}\u{1161}\u{11bd}", "\u{b546}", "\u{1104}\u{1161}\u{11bd}"), ("\u{b547}",
        "\u{b547}", "\u{1104}\u{1161}\u{11be}", "\u{b547}", "\u{1104}\u{1161}\u{11be}"),
        ("\u{b548}", "\u{b548}", "\u{1104}\u{1161}\u{11bf}", "\u{b548}",
        "\u{1104}\u{1161}\u{11bf}"), ("\u{b549}", "\u{b549}", "\u{1104}\u{1161}\u{11c0}",
        "\u{b549}", "\u{1104}\u{1161}\u{11c0}"), ("\u{b54a}", "\u{b54a}",
        "\u{1104}\u{1161}\u{11c1}", "\u{b54a}", "\u{1104}\u{1161}\u{11c1}"), ("\u{b54b}",
        "\u{b54b}", "\u{1104}\u{1161}\u{11c2}", "\u{b54b}", "\u{1104}\u{1161}\u{11c2}"),
        ("\u{b54c}", "\u{b54c}", "\u{1104}\u{1162}", "\u{b54c}", "\u{1104}\u{1162}"), ("\u{b54d}",
        "\u{b54d}", "\u{1104}\u{1162}\u{11a8}", "\u{b54d}", "\u{1104}\u{1162}\u{11a8}"),
        ("\u{b54e}", "\u{b54e}", "\u{1104}\u{1162}\u{11a9}", "\u{b54e}",
        "\u{1104}\u{1162}\u{11a9}"), ("\u{b54f}", "\u{b54f}", "\u{1104}\u{1162}\u{11aa}",
        "\u{b54f}", "\u{1104}\u{1162}\u{11aa}"), ("\u{b550}", "\u{b550}",
        "\u{1104}\u{1162}\u{11ab}", "\u{b550}", "\u{1104}\u{1162}\u{11ab}"), ("\u{b551}",
        "\u{b551}", "\u{1104}\u{1162}\u{11ac}", "\u{b551}", "\u{1104}\u{1162}\u{11ac}"),
        ("\u{b552}", "\u{b552}", "\u{1104}\u{1162}\u{11ad}", "\u{b552}",
        "\u{1104}\u{1162}\u{11ad}"), ("\u{b553}", "\u{b553}", "\u{1104}\u{1162}\u{11ae}",
        "\u{b553}", "\u{1104}\u{1162}\u{11ae}"), ("\u{b554}", "\u{b554}",
        "\u{1104}\u{1162}\u{11af}", "\u{b554}", "\u{1104}\u{1162}\u{11af}"), ("\u{b555}",
        "\u{b555}", "\u{1104}\u{1162}\u{11b0}", "\u{b555}", "\u{1104}\u{1162}\u{11b0}"),
        ("\u{b556}", "\u{b556}", "\u{1104}\u{1162}\u{11b1}", "\u{b556}",
        "\u{1104}\u{1162}\u{11b1}"), ("\u{b557}", "\u{b557}", "\u{1104}\u{1162}\u{11b2}",
        "\u{b557}", "\u{1104}\u{1162}\u{11b2}"), ("\u{b558}", "\u{b558}",
        "\u{1104}\u{1162}\u{11b3}", "\u{b558}", "\u{1104}\u{1162}\u{11b3}"), ("\u{b559}",
        "\u{b559}", "\u{1104}\u{1162}\u{11b4}", "\u{b559}", "\u{1104}\u{1162}\u{11b4}"),
        ("\u{b55a}", "\u{b55a}", "\u{1104}\u{1162}\u{11b5}", "\u{b55a}",
        "\u{1104}\u{1162}\u{11b5}"), ("\u{b55b}", "\u{b55b}", "\u{1104}\u{1162}\u{11b6}",
        "\u{b55b}", "\u{1104}\u{1162}\u{11b6}"), ("\u{b55c}", "\u{b55c}",
        "\u{1104}\u{1162}\u{11b7}", "\u{b55c}", "\u{1104}\u{1162}\u{11b7}"), ("\u{b55d}",
        "\u{b55d}", "\u{1104}\u{1162}\u{11b8}", "\u{b55d}", "\u{1104}\u{1162}\u{11b8}"),
        ("\u{b55e}", "\u{b55e}", "\u{1104}\u{1162}\u{11b9}", "\u{b55e}",
        "\u{1104}\u{1162}\u{11b9}"), ("\u{b55f}", "\u{b55f}", "\u{1104}\u{1162}\u{11ba}",
        "\u{b55f}", "\u{1104}\u{1162}\u{11ba}"), ("\u{b560}", "\u{b560}",
        "\u{1104}\u{1162}\u{11bb}", "\u{b560}", "\u{1104}\u{1162}\u{11bb}"), ("\u{b561}",
        "\u{b561}", "\u{1104}\u{1162}\u{11bc}", "\u{b561}", "\u{1104}\u{1162}\u{11bc}"),
        ("\u{b562}", "\u{b562}", "\u{1104}\u{1162}\u{11bd}", "\u{b562}",
        "\u{1104}\u{1162}\u{11bd}"), ("\u{b563}", "\u{b563}", "\u{1104}\u{1162}\u{11be}",
        "\u{b563}", "\u{1104}\u{1162}\u{11be}"), ("\u{b564}", "\u{b564}",
        "\u{1104}\u{1162}\u{11bf}", "\u{b564}", "\u{1104}\u{1162}\u{11bf}"), ("\u{b565}",
        "\u{b565}", "\u{1104}\u{1162}\u{11c0}", "\u{b565}", "\u{1104}\u{1162}\u{11c0}"),
        ("\u{b566}", "\u{b566}", "\u{1104}\u{1162}\u{11c1}", "\u{b566}",
        "\u{1104}\u{1162}\u{11c1}"), ("\u{b567}", "\u{b567}", "\u{1104}\u{1162}\u{11c2}",
        "\u{b567}", "\u{1104}\u{1162}\u{11c2}"), ("\u{b568}", "\u{b568}", "\u{1104}\u{1163}",
        "\u{b568}", "\u{1104}\u{1163}"), ("\u{b569}", "\u{b569}", "\u{1104}\u{1163}\u{11a8}",
        "\u{b569}", "\u{1104}\u{1163}\u{11a8}"), ("\u{b56a}", "\u{b56a}",
        "\u{1104}\u{1163}\u{11a9}", "\u{b56a}", "\u{1104}\u{1163}\u{11a9}"), ("\u{b56b}",
        "\u{b56b}", "\u{1104}\u{1163}\u{11aa}", "\u{b56b}", "\u{1104}\u{1163}\u{11aa}"),
        ("\u{b56c}", "\u{b56c}", "\u{1104}\u{1163}\u{11ab}", "\u{b56c}",
        "\u{1104}\u{1163}\u{11ab}"), ("\u{b56d}", "\u{b56d}", "\u{1104}\u{1163}\u{11ac}",
        "\u{b56d}", "\u{1104}\u{1163}\u{11ac}"), ("\u{b56e}", "\u{b56e}",
        "\u{1104}\u{1163}\u{11ad}", "\u{b56e}", "\u{1104}\u{1163}\u{11ad}"), ("\u{b56f}",
        "\u{b56f}", "\u{1104}\u{1163}\u{11ae}", "\u{b56f}", "\u{1104}\u{1163}\u{11ae}"),
        ("\u{b570}", "\u{b570}", "\u{1104}\u{1163}\u{11af}", "\u{b570}",
        "\u{1104}\u{1163}\u{11af}"), ("\u{b571}", "\u{b571}", "\u{1104}\u{1163}\u{11b0}",
        "\u{b571}", "\u{1104}\u{1163}\u{11b0}"), ("\u{b572}", "\u{b572}",
        "\u{1104}\u{1163}\u{11b1}", "\u{b572}", "\u{1104}\u{1163}\u{11b1}"), ("\u{b573}",
        "\u{b573}", "\u{1104}\u{1163}\u{11b2}", "\u{b573}", "\u{1104}\u{1163}\u{11b2}"),
        ("\u{b574}", "\u{b574}", "\u{1104}\u{1163}\u{11b3}", "\u{b574}",
        "\u{1104}\u{1163}\u{11b3}"), ("\u{b575}", "\u{b575}", "\u{1104}\u{1163}\u{11b4}",
        "\u{b575}", "\u{1104}\u{1163}\u{11b4}"), ("\u{b576}", "\u{b576}",
        "\u{1104}\u{1163}\u{11b5}", "\u{b576}", "\u{1104}\u{1163}\u{11b5}"), ("\u{b577}",
        "\u{b577}", "\u{1104}\u{1163}\u{11b6}", "\u{b577}", "\u{1104}\u{1163}\u{11b6}"),
        ("\u{b578}", "\u{b578}", "\u{1104}\u{1163}\u{11b7}", "\u{b578}",
        "\u{1104}\u{1163}\u{11b7}"), ("\u{b579}", "\u{b579}", "\u{1104}\u{1163}\u{11b8}",
        "\u{b579}", "\u{1104}\u{1163}\u{11b8}"), ("\u{b57a}", "\u{b57a}",
        "\u{1104}\u{1163}\u{11b9}", "\u{b57a}", "\u{1104}\u{1163}\u{11b9}"), ("\u{b57b}",
        "\u{b57b}", "\u{1104}\u{1163}\u{11ba}", "\u{b57b}", "\u{1104}\u{1163}\u{11ba}"),
        ("\u{b57c}", "\u{b57c}", "\u{1104}\u{1163}\u{11bb}", "\u{b57c}",
        "\u{1104}\u{1163}\u{11bb}"), ("\u{b57d}", "\u{b57d}", "\u{1104}\u{1163}\u{11bc}",
        "\u{b57d}", "\u{1104}\u{1163}\u{11bc}"), ("\u{b57e}", "\u{b57e}",
        "\u{1104}\u{1163}\u{11bd}", "\u{b57e}", "\u{1104}\u{1163}\u{11bd}"), ("\u{b57f}",
        "\u{b57f}", "\u{1104}\u{1163}\u{11be}", "\u{b57f}", "\u{1104}\u{1163}\u{11be}"),
        ("\u{b580}", "\u{b580}", "\u{1104}\u{1163}\u{11bf}", "\u{b580}",
        "\u{1104}\u{1163}\u{11bf}"), ("\u{b581}", "\u{b581}", "\u{1104}\u{1163}\u{11c0}",
        "\u{b581}", "\u{1104}\u{1163}\u{11c0}"), ("\u{b582}", "\u{b582}",
        "\u{1104}\u{1163}\u{11c1}", "\u{b582}", "\u{1104}\u{1163}\u{11c1}"), ("\u{b583}",
        "\u{b583}", "\u{1104}\u{1163}\u{11c2}", "\u{b583}", "\u{1104}\u{1163}\u{11c2}"),
        ("\u{b584}", "\u{b584}", "\u{1104}\u{1164}", "\u{b584}", "\u{1104}\u{1164}"), ("\u{b585}",
        "\u{b585}", "\u{1104}\u{1164}\u{11a8}", "\u{b585}", "\u{1104}\u{1164}\u{11a8}"),
        ("\u{b586}", "\u{b586}", "\u{1104}\u{1164}\u{11a9}", "\u{b586}",
        "\u{1104}\u{1164}\u{11a9}"), ("\u{b587}", "\u{b587}", "\u{1104}\u{1164}\u{11aa}",
        "\u{b587}", "\u{1104}\u{1164}\u{11aa}"), ("\u{b588}", "\u{b588}",
        "\u{1104}\u{1164}\u{11ab}", "\u{b588}", "\u{1104}\u{1164}\u{11ab}"), ("\u{b589}",
        "\u{b589}", "\u{1104}\u{1164}\u{11ac}", "\u{b589}", "\u{1104}\u{1164}\u{11ac}"),
        ("\u{b58a}", "\u{b58a}", "\u{1104}\u{1164}\u{11ad}", "\u{b58a}",
        "\u{1104}\u{1164}\u{11ad}"), ("\u{b58b}", "\u{b58b}", "\u{1104}\u{1164}\u{11ae}",
        "\u{b58b}", "\u{1104}\u{1164}\u{11ae}"), ("\u{b58c}", "\u{b58c}",
        "\u{1104}\u{1164}\u{11af}", "\u{b58c}", "\u{1104}\u{1164}\u{11af}"), ("\u{b58d}",
        "\u{b58d}", "\u{1104}\u{1164}\u{11b0}", "\u{b58d}", "\u{1104}\u{1164}\u{11b0}"),
        ("\u{b58e}", "\u{b58e}", "\u{1104}\u{1164}\u{11b1}", "\u{b58e}",
        "\u{1104}\u{1164}\u{11b1}"), ("\u{b58f}", "\u{b58f}", "\u{1104}\u{1164}\u{11b2}",
        "\u{b58f}", "\u{1104}\u{1164}\u{11b2}"), ("\u{b590}", "\u{b590}",
        "\u{1104}\u{1164}\u{11b3}", "\u{b590}", "\u{1104}\u{1164}\u{11b3}"), ("\u{b591}",
        "\u{b591}", "\u{1104}\u{1164}\u{11b4}", "\u{b591}", "\u{1104}\u{1164}\u{11b4}"),
        ("\u{b592}", "\u{b592}", "\u{1104}\u{1164}\u{11b5}", "\u{b592}",
        "\u{1104}\u{1164}\u{11b5}"), ("\u{b593}", "\u{b593}", "\u{1104}\u{1164}\u{11b6}",
        "\u{b593}", "\u{1104}\u{1164}\u{11b6}"), ("\u{b594}", "\u{b594}",
        "\u{1104}\u{1164}\u{11b7}", "\u{b594}", "\u{1104}\u{1164}\u{11b7}"), ("\u{b595}",
        "\u{b595}", "\u{1104}\u{1164}\u{11b8}", "\u{b595}", "\u{1104}\u{1164}\u{11b8}"),
        ("\u{b596}", "\u{b596}", "\u{1104}\u{1164}\u{11b9}", "\u{b596}",
        "\u{1104}\u{1164}\u{11b9}"), ("\u{b597}", "\u{b597}", "\u{1104}\u{1164}\u{11ba}",
        "\u{b597}", "\u{1104}\u{1164}\u{11ba}"), ("\u{b598}", "\u{b598}",
        "\u{1104}\u{1164}\u{11bb}", "\u{b598}", "\u{1104}\u{1164}\u{11bb}"), ("\u{b599}",
        "\u{b599}", "\u{1104}\u{1164}\u{11bc}", "\u{b599}", "\u{1104}\u{1164}\u{11bc}"),
        ("\u{b59a}", "\u{b59a}", "\u{1104}\u{1164}\u{11bd}", "\u{b59a}",
        "\u{1104}\u{1164}\u{11bd}"), ("\u{b59b}", "\u{b59b}", "\u{1104}\u{1164}\u{11be}",
        "\u{b59b}", "\u{1104}\u{1164}\u{11be}"), ("\u{b59c}", "\u{b59c}",
        "\u{1104}\u{1164}\u{11bf}", "\u{b59c}", "\u{1104}\u{1164}\u{11bf}"), ("\u{b59d}",
        "\u{b59d}", "\u{1104}\u{1164}\u{11c0}", "\u{b59d}", "\u{1104}\u{1164}\u{11c0}"),
        ("\u{b59e}", "\u{b59e}", "\u{1104}\u{1164}\u{11c1}", "\u{b59e}",
        "\u{1104}\u{1164}\u{11c1}"), ("\u{b59f}", "\u{b59f}", "\u{1104}\u{1164}\u{11c2}",
        "\u{b59f}", "\u{1104}\u{1164}\u{11c2}"), ("\u{b5a0}", "\u{b5a0}", "\u{1104}\u{1165}",
        "\u{b5a0}", "\u{1104}\u{1165}"), ("\u{b5a1}", "\u{b5a1}", "\u{1104}\u{1165}\u{11a8}",
        "\u{b5a1}", "\u{1104}\u{1165}\u{11a8}"), ("\u{b5a2}", "\u{b5a2}",
        "\u{1104}\u{1165}\u{11a9}", "\u{b5a2}", "\u{1104}\u{1165}\u{11a9}"), ("\u{b5a3}",
        "\u{b5a3}", "\u{1104}\u{1165}\u{11aa}", "\u{b5a3}", "\u{1104}\u{1165}\u{11aa}"),
        ("\u{b5a4}", "\u{b5a4}", "\u{1104}\u{1165}\u{11ab}", "\u{b5a4}",
        "\u{1104}\u{1165}\u{11ab}"), ("\u{b5a5}", "\u{b5a5}", "\u{1104}\u{1165}\u{11ac}",
        "\u{b5a5}", "\u{1104}\u{1165}\u{11ac}"), ("\u{b5a6}", "\u{b5a6}",
        "\u{1104}\u{1165}\u{11ad}", "\u{b5a6}", "\u{1104}\u{1165}\u{11ad}"), ("\u{b5a7}",
        "\u{b5a7}", "\u{1104}\u{1165}\u{11ae}", "\u{b5a7}", "\u{1104}\u{1165}\u{11ae}"),
        ("\u{b5a8}", "\u{b5a8}", "\u{1104}\u{1165}\u{11af}", "\u{b5a8}",
        "\u{1104}\u{1165}\u{11af}"), ("\u{b5a9}", "\u{b5a9}", "\u{1104}\u{1165}\u{11b0}",
        "\u{b5a9}", "\u{1104}\u{1165}\u{11b0}"), ("\u{b5aa}", "\u{b5aa}",
        "\u{1104}\u{1165}\u{11b1}", "\u{b5aa}", "\u{1104}\u{1165}\u{11b1}"), ("\u{b5ab}",
        "\u{b5ab}", "\u{1104}\u{1165}\u{11b2}", "\u{b5ab}", "\u{1104}\u{1165}\u{11b2}"),
        ("\u{b5ac}", "\u{b5ac}", "\u{1104}\u{1165}\u{11b3}", "\u{b5ac}",
        "\u{1104}\u{1165}\u{11b3}"), ("\u{b5ad}", "\u{b5ad}", "\u{1104}\u{1165}\u{11b4}",
        "\u{b5ad}", "\u{1104}\u{1165}\u{11b4}"), ("\u{b5ae}", "\u{b5ae}",
        "\u{1104}\u{1165}\u{11b5}", "\u{b5ae}", "\u{1104}\u{1165}\u{11b5}"), ("\u{b5af}",
        "\u{b5af}", "\u{1104}\u{1165}\u{11b6}", "\u{b5af}", "\u{1104}\u{1165}\u{11b6}"),
        ("\u{b5b0}", "\u{b5b0}", "\u{1104}\u{1165}\u{11b7}", "\u{b5b0}",
        "\u{1104}\u{1165}\u{11b7}"), ("\u{b5b1}", "\u{b5b1}", "\u{1104}\u{1165}\u{11b8}",
        "\u{b5b1}", "\u{1104}\u{1165}\u{11b8}"), ("\u{b5b2}", "\u{b5b2}",
        "\u{1104}\u{1165}\u{11b9}", "\u{b5b2}", "\u{1104}\u{1165}\u{11b9}"), ("\u{b5b3}",
        "\u{b5b3}", "\u{1104}\u{1165}\u{11ba}", "\u{b5b3}", "\u{1104}\u{1165}\u{11ba}"),
        ("\u{b5b4}", "\u{b5b4}", "\u{1104}\u{1165}\u{11bb}", "\u{b5b4}",
        "\u{1104}\u{1165}\u{11bb}"), ("\u{b5b5}", "\u{b5b5}", "\u{1104}\u{1165}\u{11bc}",
        "\u{b5b5}", "\u{1104}\u{1165}\u{11bc}"), ("\u{b5b6}", "\u{b5b6}",
        "\u{1104}\u{1165}\u{11bd}", "\u{b5b6}", "\u{1104}\u{1165}\u{11bd}"), ("\u{b5b7}",
        "\u{b5b7}", "\u{1104}\u{1165}\u{11be}", "\u{b5b7}", "\u{1104}\u{1165}\u{11be}"),
        ("\u{b5b8}", "\u{b5b8}", "\u{1104}\u{1165}\u{11bf}", "\u{b5b8}",
        "\u{1104}\u{1165}\u{11bf}"), ("\u{b5b9}", "\u{b5b9}", "\u{1104}\u{1165}\u{11c0}",
        "\u{b5b9}", "\u{1104}\u{1165}\u{11c0}"), ("\u{b5ba}", "\u{b5ba}",
        "\u{1104}\u{1165}\u{11c1}", "\u{b5ba}", "\u{1104}\u{1165}\u{11c1}"), ("\u{b5bb}",
        "\u{b5bb}", "\u{1104}\u{1165}\u{11c2}", "\u{b5bb}", "\u{1104}\u{1165}\u{11c2}"),
        ("\u{b5bc}", "\u{b5bc}", "\u{1104}\u{1166}", "\u{b5bc}", "\u{1104}\u{1166}"), ("\u{b5bd}",
        "\u{b5bd}", "\u{1104}\u{1166}\u{11a8}", "\u{b5bd}", "\u{1104}\u{1166}\u{11a8}"),
        ("\u{b5be}", "\u{b5be}", "\u{1104}\u{1166}\u{11a9}", "\u{b5be}",
        "\u{1104}\u{1166}\u{11a9}"), ("\u{b5bf}", "\u{b5bf}", "\u{1104}\u{1166}\u{11aa}",
        "\u{b5bf}", "\u{1104}\u{1166}\u{11aa}"), ("\u{b5c0}", "\u{b5c0}",
        "\u{1104}\u{1166}\u{11ab}", "\u{b5c0}", "\u{1104}\u{1166}\u{11ab}"), ("\u{b5c1}",
        "\u{b5c1}", "\u{1104}\u{1166}\u{11ac}", "\u{b5c1}", "\u{1104}\u{1166}\u{11ac}"),
        ("\u{b5c2}", "\u{b5c2}", "\u{1104}\u{1166}\u{11ad}", "\u{b5c2}",
        "\u{1104}\u{1166}\u{11ad}"), ("\u{b5c3}", "\u{b5c3}", "\u{1104}\u{1166}\u{11ae}",
        "\u{b5c3}", "\u{1104}\u{1166}\u{11ae}"), ("\u{b5c4}", "\u{b5c4}",
        "\u{1104}\u{1166}\u{11af}", "\u{b5c4}", "\u{1104}\u{1166}\u{11af}"), ("\u{b5c5}",
        "\u{b5c5}", "\u{1104}\u{1166}\u{11b0}", "\u{b5c5}", "\u{1104}\u{1166}\u{11b0}"),
        ("\u{b5c6}", "\u{b5c6}", "\u{1104}\u{1166}\u{11b1}", "\u{b5c6}",
        "\u{1104}\u{1166}\u{11b1}"), ("\u{b5c7}", "\u{b5c7}", "\u{1104}\u{1166}\u{11b2}",
        "\u{b5c7}", "\u{1104}\u{1166}\u{11b2}"), ("\u{b5c8}", "\u{b5c8}",
        "\u{1104}\u{1166}\u{11b3}", "\u{b5c8}", "\u{1104}\u{1166}\u{11b3}"), ("\u{b5c9}",
        "\u{b5c9}", "\u{1104}\u{1166}\u{11b4}", "\u{b5c9}", "\u{1104}\u{1166}\u{11b4}"),
        ("\u{b5ca}", "\u{b5ca}", "\u{1104}\u{1166}\u{11b5}", "\u{b5ca}",
        "\u{1104}\u{1166}\u{11b5}"), ("\u{b5cb}", "\u{b5cb}", "\u{1104}\u{1166}\u{11b6}",
        "\u{b5cb}", "\u{1104}\u{1166}\u{11b6}"), ("\u{b5cc}", "\u{b5cc}",
        "\u{1104}\u{1166}\u{11b7}", "\u{b5cc}", "\u{1104}\u{1166}\u{11b7}"), ("\u{b5cd}",
        "\u{b5cd}", "\u{1104}\u{1166}\u{11b8}", "\u{b5cd}", "\u{1104}\u{1166}\u{11b8}"),
        ("\u{b5ce}", "\u{b5ce}", "\u{1104}\u{1166}\u{11b9}", "\u{b5ce}",
        "\u{1104}\u{1166}\u{11b9}"), ("\u{b5cf}", "\u{b5cf}", "\u{1104}\u{1166}\u{11ba}",
        "\u{b5cf}", "\u{1104}\u{1166}\u{11ba}"), ("\u{b5d0}", "\u{b5d0}",
        "\u{1104}\u{1166}\u{11bb}", "\u{b5d0}", "\u{1104}\u{1166}\u{11bb}"), ("\u{b5d1}",
        "\u{b5d1}", "\u{1104}\u{1166}\u{11bc}", "\u{b5d1}", "\u{1104}\u{1166}\u{11bc}"),
        ("\u{b5d2}", "\u{b5d2}", "\u{1104}\u{1166}\u{11bd}", "\u{b5d2}",
        "\u{1104}\u{1166}\u{11bd}"), ("\u{b5d3}", "\u{b5d3}", "\u{1104}\u{1166}\u{11be}",
        "\u{b5d3}", "\u{1104}\u{1166}\u{11be}"), ("\u{b5d4}", "\u{b5d4}",
        "\u{1104}\u{1166}\u{11bf}", "\u{b5d4}", "\u{1104}\u{1166}\u{11bf}"), ("\u{b5d5}",
        "\u{b5d5}", "\u{1104}\u{1166}\u{11c0}", "\u{b5d5}", "\u{1104}\u{1166}\u{11c0}"),
        ("\u{b5d6}", "\u{b5d6}", "\u{1104}\u{1166}\u{11c1}", "\u{b5d6}",
        "\u{1104}\u{1166}\u{11c1}"), ("\u{b5d7}", "\u{b5d7}", "\u{1104}\u{1166}\u{11c2}",
        "\u{b5d7}", "\u{1104}\u{1166}\u{11c2}"), ("\u{b5d8}", "\u{b5d8}", "\u{1104}\u{1167}",
        "\u{b5d8}", "\u{1104}\u{1167}"), ("\u{b5d9}", "\u{b5d9}", "\u{1104}\u{1167}\u{11a8}",
        "\u{b5d9}", "\u{1104}\u{1167}\u{11a8}"), ("\u{b5da}", "\u{b5da}",
        "\u{1104}\u{1167}\u{11a9}", "\u{b5da}", "\u{1104}\u{1167}\u{11a9}"), ("\u{b5db}",
        "\u{b5db}", "\u{1104}\u{1167}\u{11aa}", "\u{b5db}", "\u{1104}\u{1167}\u{11aa}"),
        ("\u{b5dc}", "\u{b5dc}", "\u{1104}\u{1167}\u{11ab}", "\u{b5dc}",
        "\u{1104}\u{1167}\u{11ab}"), ("\u{b5dd}", "\u{b5dd}", "\u{1104}\u{1167}\u{11ac}",
        "\u{b5dd}", "\u{1104}\u{1167}\u{11ac}"), ("\u{b5de}", "\u{b5de}",
        "\u{1104}\u{1167}\u{11ad}", "\u{b5de}", "\u{1104}\u{1167}\u{11ad}"), ("\u{b5df}",
        "\u{b5df}", "\u{1104}\u{1167}\u{11ae}", "\u{b5df}", "\u{1104}\u{1167}\u{11ae}"),
        ("\u{b5e0}", "\u{b5e0}", "\u{1104}\u{1167}\u{11af}", "\u{b5e0}",
        "\u{1104}\u{1167}\u{11af}"), ("\u{b5e1}", "\u{b5e1}", "\u{1104}\u{1167}\u{11b0}",
        "\u{b5e1}", "\u{1104}\u{1167}\u{11b0}"), ("\u{b5e2}", "\u{b5e2}",
        "\u{1104}\u{1167}\u{11b1}", "\u{b5e2}", "\u{1104}\u{1167}\u{11b1}"), ("\u{b5e3}",
        "\u{b5e3}", "\u{1104}\u{1167}\u{11b2}", "\u{b5e3}", "\u{1104}\u{1167}\u{11b2}"),
        ("\u{b5e4}", "\u{b5e4}", "\u{1104}\u{1167}\u{11b3}", "\u{b5e4}",
        "\u{1104}\u{1167}\u{11b3}"), ("\u{b5e5}", "\u{b5e5}", "\u{1104}\u{1167}\u{11b4}",
        "\u{b5e5}", "\u{1104}\u{1167}\u{11b4}"), ("\u{b5e6}", "\u{b5e6}",
        "\u{1104}\u{1167}\u{11b5}", "\u{b5e6}", "\u{1104}\u{1167}\u{11b5}"), ("\u{b5e7}",
        "\u{b5e7}", "\u{1104}\u{1167}\u{11b6}", "\u{b5e7}", "\u{1104}\u{1167}\u{11b6}"),
        ("\u{b5e8}", "\u{b5e8}", "\u{1104}\u{1167}\u{11b7}", "\u{b5e8}",
        "\u{1104}\u{1167}\u{11b7}"), ("\u{b5e9}", "\u{b5e9}", "\u{1104}\u{1167}\u{11b8}",
        "\u{b5e9}", "\u{1104}\u{1167}\u{11b8}"), ("\u{b5ea}", "\u{b5ea}",
        "\u{1104}\u{1167}\u{11b9}", "\u{b5ea}", "\u{1104}\u{1167}\u{11b9}"), ("\u{b5eb}",
        "\u{b5eb}", "\u{1104}\u{1167}\u{11ba}", "\u{b5eb}", "\u{1104}\u{1167}\u{11ba}"),
        ("\u{b5ec}", "\u{b5ec}", "\u{1104}\u{1167}\u{11bb}", "\u{b5ec}",
        "\u{1104}\u{1167}\u{11bb}"), ("\u{b5ed}", "\u{b5ed}", "\u{1104}\u{1167}\u{11bc}",
        "\u{b5ed}", "\u{1104}\u{1167}\u{11bc}"), ("\u{b5ee}", "\u{b5ee}",
        "\u{1104}\u{1167}\u{11bd}", "\u{b5ee}", "\u{1104}\u{1167}\u{11bd}"), ("\u{b5ef}",
        "\u{b5ef}", "\u{1104}\u{1167}\u{11be}", "\u{b5ef}", "\u{1104}\u{1167}\u{11be}"),
        ("\u{b5f0}", "\u{b5f0}", "\u{1104}\u{1167}\u{11bf}", "\u{b5f0}",
        "\u{1104}\u{1167}\u{11bf}"), ("\u{b5f1}", "\u{b5f1}", "\u{1104}\u{1167}\u{11c0}",
        "\u{b5f1}", "\u{1104}\u{1167}\u{11c0}"), ("\u{b5f2}", "\u{b5f2}",
        "\u{1104}\u{1167}\u{11c1}", "\u{b5f2}", "\u{1104}\u{1167}\u{11c1}"), ("\u{b5f3}",
        "\u{b5f3}", "\u{1104}\u{1167}\u{11c2}", "\u{b5f3}", "\u{1104}\u{1167}\u{11c2}"),
        ("\u{b5f4}", "\u{b5f4}", "\u{1104}\u{1168}", "\u{b5f4}", "\u{1104}\u{1168}"), ("\u{b5f5}",
        "\u{b5f5}", "\u{1104}\u{1168}\u{11a8}", "\u{b5f5}", "\u{1104}\u{1168}\u{11a8}"),
        ("\u{b5f6}", "\u{b5f6}", "\u{1104}\u{1168}\u{11a9}", "\u{b5f6}",
        "\u{1104}\u{1168}\u{11a9}"), ("\u{b5f7}", "\u{b5f7}", "\u{1104}\u{1168}\u{11aa}",
        "\u{b5f7}", "\u{1104}\u{1168}\u{11aa}"), ("\u{b5f8}", "\u{b5f8}",
        "\u{1104}\u{1168}\u{11ab}", "\u{b5f8}", "\u{1104}\u{1168}\u{11ab}"), ("\u{b5f9}",
        "\u{b5f9}", "\u{1104}\u{1168}\u{11ac}", "\u{b5f9}", "\u{1104}\u{1168}\u{11ac}"),
        ("\u{b5fa}", "\u{b5fa}", "\u{1104}\u{1168}\u{11ad}", "\u{b5fa}",
        "\u{1104}\u{1168}\u{11ad}"), ("\u{b5fb}", "\u{b5fb}", "\u{1104}\u{1168}\u{11ae}",
        "\u{b5fb}", "\u{1104}\u{1168}\u{11ae}"), ("\u{b5fc}", "\u{b5fc}",
        "\u{1104}\u{1168}\u{11af}", "\u{b5fc}", "\u{1104}\u{1168}\u{11af}"), ("\u{b5fd}",
        "\u{b5fd}", "\u{1104}\u{1168}\u{11b0}", "\u{b5fd}", "\u{1104}\u{1168}\u{11b0}"),
        ("\u{b5fe}", "\u{b5fe}", "\u{1104}\u{1168}\u{11b1}", "\u{b5fe}",
        "\u{1104}\u{1168}\u{11b1}"), ("\u{b5ff}", "\u{b5ff}", "\u{1104}\u{1168}\u{11b2}",
        "\u{b5ff}", "\u{1104}\u{1168}\u{11b2}"), ("\u{b600}", "\u{b600}",
        "\u{1104}\u{1168}\u{11b3}", "\u{b600}", "\u{1104}\u{1168}\u{11b3}"), ("\u{b601}",
        "\u{b601}", "\u{1104}\u{1168}\u{11b4}", "\u{b601}", "\u{1104}\u{1168}\u{11b4}"),
        ("\u{b602}", "\u{b602}", "\u{1104}\u{1168}\u{11b5}", "\u{b602}",
        "\u{1104}\u{1168}\u{11b5}"), ("\u{b603}", "\u{b603}", "\u{1104}\u{1168}\u{11b6}",
        "\u{b603}", "\u{1104}\u{1168}\u{11b6}"), ("\u{b604}", "\u{b604}",
        "\u{1104}\u{1168}\u{11b7}", "\u{b604}", "\u{1104}\u{1168}\u{11b7}"), ("\u{b605}",
        "\u{b605}", "\u{1104}\u{1168}\u{11b8}", "\u{b605}", "\u{1104}\u{1168}\u{11b8}"),
        ("\u{b606}", "\u{b606}", "\u{1104}\u{1168}\u{11b9}", "\u{b606}",
        "\u{1104}\u{1168}\u{11b9}"), ("\u{b607}", "\u{b607}", "\u{1104}\u{1168}\u{11ba}",
        "\u{b607}", "\u{1104}\u{1168}\u{11ba}"), ("\u{b608}", "\u{b608}",
        "\u{1104}\u{1168}\u{11bb}", "\u{b608}", "\u{1104}\u{1168}\u{11bb}"), ("\u{b609}",
        "\u{b609}", "\u{1104}\u{1168}\u{11bc}", "\u{b609}", "\u{1104}\u{1168}\u{11bc}"),
        ("\u{b60a}", "\u{b60a}", "\u{1104}\u{1168}\u{11bd}", "\u{b60a}",
        "\u{1104}\u{1168}\u{11bd}"), ("\u{b60b}", "\u{b60b}", "\u{1104}\u{1168}\u{11be}",
        "\u{b60b}", "\u{1104}\u{1168}\u{11be}"), ("\u{b60c}", "\u{b60c}",
        "\u{1104}\u{1168}\u{11bf}", "\u{b60c}", "\u{1104}\u{1168}\u{11bf}"), ("\u{b60d}",
        "\u{b60d}", "\u{1104}\u{1168}\u{11c0}", "\u{b60d}", "\u{1104}\u{1168}\u{11c0}"),
        ("\u{b60e}", "\u{b60e}", "\u{1104}\u{1168}\u{11c1}", "\u{b60e}",
        "\u{1104}\u{1168}\u{11c1}"), ("\u{b60f}", "\u{b60f}", "\u{1104}\u{1168}\u{11c2}",
        "\u{b60f}", "\u{1104}\u{1168}\u{11c2}"), ("\u{b610}", "\u{b610}", "\u{1104}\u{1169}",
        "\u{b610}", "\u{1104}\u{1169}"), ("\u{b611}", "\u{b611}", "\u{1104}\u{1169}\u{11a8}",
        "\u{b611}", "\u{1104}\u{1169}\u{11a8}"), ("\u{b612}", "\u{b612}",
        "\u{1104}\u{1169}\u{11a9}", "\u{b612}", "\u{1104}\u{1169}\u{11a9}"), ("\u{b613}",
        "\u{b613}", "\u{1104}\u{1169}\u{11aa}", "\u{b613}", "\u{1104}\u{1169}\u{11aa}"),
        ("\u{b614}", "\u{b614}", "\u{1104}\u{1169}\u{11ab}", "\u{b614}",
        "\u{1104}\u{1169}\u{11ab}"), ("\u{b615}", "\u{b615}", "\u{1104}\u{1169}\u{11ac}",
        "\u{b615}", "\u{1104}\u{1169}\u{11ac}"), ("\u{b616}", "\u{b616}",
        "\u{1104}\u{1169}\u{11ad}", "\u{b616}", "\u{1104}\u{1169}\u{11ad}"), ("\u{b617}",
        "\u{b617}", "\u{1104}\u{1169}\u{11ae}", "\u{b617}", "\u{1104}\u{1169}\u{11ae}"),
        ("\u{b618}", "\u{b618}", "\u{1104}\u{1169}\u{11af}", "\u{b618}",
        "\u{1104}\u{1169}\u{11af}"), ("\u{b619}", "\u{b619}", "\u{1104}\u{1169}\u{11b0}",
        "\u{b619}", "\u{1104}\u{1169}\u{11b0}"), ("\u{b61a}", "\u{b61a}",
        "\u{1104}\u{1169}\u{11b1}", "\u{b61a}", "\u{1104}\u{1169}\u{11b1}"), ("\u{b61b}",
        "\u{b61b}", "\u{1104}\u{1169}\u{11b2}", "\u{b61b}", "\u{1104}\u{1169}\u{11b2}"),
        ("\u{b61c}", "\u{b61c}", "\u{1104}\u{1169}\u{11b3}", "\u{b61c}",
        "\u{1104}\u{1169}\u{11b3}"), ("\u{b61d}", "\u{b61d}", "\u{1104}\u{1169}\u{11b4}",
        "\u{b61d}", "\u{1104}\u{1169}\u{11b4}"), ("\u{b61e}", "\u{b61e}",
        "\u{1104}\u{1169}\u{11b5}", "\u{b61e}", "\u{1104}\u{1169}\u{11b5}"), ("\u{b61f}",
        "\u{b61f}", "\u{1104}\u{1169}\u{11b6}", "\u{b61f}", "\u{1104}\u{1169}\u{11b6}"),
        ("\u{b620}", "\u{b620}", "\u{1104}\u{1169}\u{11b7}", "\u{b620}",
        "\u{1104}\u{1169}\u{11b7}"), ("\u{b621}", "\u{b621}", "\u{1104}\u{1169}\u{11b8}",
        "\u{b621}", "\u{1104}\u{1169}\u{11b8}"), ("\u{b622}", "\u{b622}",
        "\u{1104}\u{1169}\u{11b9}", "\u{b622}", "\u{1104}\u{1169}\u{11b9}"), ("\u{b623}",
        "\u{b623}", "\u{1104}\u{1169}\u{11ba}", "\u{b623}", "\u{1104}\u{1169}\u{11ba}"),
        ("\u{b624}", "\u{b624}", "\u{1104}\u{1169}\u{11bb}", "\u{b624}",
        "\u{1104}\u{1169}\u{11bb}"), ("\u{b625}", "\u{b625}", "\u{1104}\u{1169}\u{11bc}",
        "\u{b625}", "\u{1104}\u{1169}\u{11bc}"), ("\u{b626}", "\u{b626}",
        "\u{1104}\u{1169}\u{11bd}", "\u{b626}", "\u{1104}\u{1169}\u{11bd}"), ("\u{b627}",
        "\u{b627}", "\u{1104}\u{1169}\u{11be}", "\u{b627}", "\u{1104}\u{1169}\u{11be}"),
        ("\u{b628}", "\u{b628}", "\u{1104}\u{1169}\u{11bf}", "\u{b628}",
        "\u{1104}\u{1169}\u{11bf}"), ("\u{b629}", "\u{b629}", "\u{1104}\u{1169}\u{11c0}",
        "\u{b629}", "\u{1104}\u{1169}\u{11c0}"), ("\u{b62a}", "\u{b62a}",
        "\u{1104}\u{1169}\u{11c1}", "\u{b62a}", "\u{1104}\u{1169}\u{11c1}"), ("\u{b62b}",
        "\u{b62b}", "\u{1104}\u{1169}\u{11c2}", "\u{b62b}", "\u{1104}\u{1169}\u{11c2}"),
        ("\u{b62c}", "\u{b62c}", "\u{1104}\u{116a}", "\u{b62c}", "\u{1104}\u{116a}"), ("\u{b62d}",
        "\u{b62d}", "\u{1104}\u{116a}\u{11a8}", "\u{b62d}", "\u{1104}\u{116a}\u{11a8}"),
        ("\u{b62e}", "\u{b62e}", "\u{1104}\u{116a}\u{11a9}", "\u{b62e}",
        "\u{1104}\u{116a}\u{11a9}"), ("\u{b62f}", "\u{b62f}", "\u{1104}\u{116a}\u{11aa}",
        "\u{b62f}", "\u{1104}\u{116a}\u{11aa}"), ("\u{b630}", "\u{b630}",
        "\u{1104}\u{116a}\u{11ab}", "\u{b630}", "\u{1104}\u{116a}\u{11ab}"), ("\u{b631}",
        "\u{b631}", "\u{1104}\u{116a}\u{11ac}", "\u{b631}", "\u{1104}\u{116a}\u{11ac}"),
        ("\u{b632}", "\u{b632}", "\u{1104}\u{116a}\u{11ad}", "\u{b632}",
        "\u{1104}\u{116a}\u{11ad}"), ("\u{b633}", "\u{b633}", "\u{1104}\u{116a}\u{11ae}",
        "\u{b633}", "\u{1104}\u{116a}\u{11ae}"), ("\u{b634}", "\u{b634}",
        "\u{1104}\u{116a}\u{11af}", "\u{b634}", "\u{1104}\u{116a}\u{11af}"), ("\u{b635}",
        "\u{b635}", "\u{1104}\u{116a}\u{11b0}", "\u{b635}", "\u{1104}\u{116a}\u{11b0}"),
        ("\u{b636}", "\u{b636}", "\u{1104}\u{116a}\u{11b1}", "\u{b636}",
        "\u{1104}\u{116a}\u{11b1}"), ("\u{b637}", "\u{b637}", "\u{1104}\u{116a}\u{11b2}",
        "\u{b637}", "\u{1104}\u{116a}\u{11b2}"), ("\u{b638}", "\u{b638}",
        "\u{1104}\u{116a}\u{11b3}", "\u{b638}", "\u{1104}\u{116a}\u{11b3}"), ("\u{b639}",
        "\u{b639}", "\u{1104}\u{116a}\u{11b4}", "\u{b639}", "\u{1104}\u{116a}\u{11b4}"),
        ("\u{b63a}", "\u{b63a}", "\u{1104}\u{116a}\u{11b5}", "\u{b63a}",
        "\u{1104}\u{116a}\u{11b5}"), ("\u{b63b}", "\u{b63b}", "\u{1104}\u{116a}\u{11b6}",
        "\u{b63b}", "\u{1104}\u{116a}\u{11b6}"), ("\u{b63c}", "\u{b63c}",
        "\u{1104}\u{116a}\u{11b7}", "\u{b63c}", "\u{1104}\u{116a}\u{11b7}"), ("\u{b63d}",
        "\u{b63d}", "\u{1104}\u{116a}\u{11b8}", "\u{b63d}", "\u{1104}\u{116a}\u{11b8}"),
        ("\u{b63e}", "\u{b63e}", "\u{1104}\u{116a}\u{11b9}", "\u{b63e}",
        "\u{1104}\u{116a}\u{11b9}"), ("\u{b63f}", "\u{b63f}", "\u{1104}\u{116a}\u{11ba}",
        "\u{b63f}", "\u{1104}\u{116a}\u{11ba}"), ("\u{b640}", "\u{b640}",
        "\u{1104}\u{116a}\u{11bb}", "\u{b640}", "\u{1104}\u{116a}\u{11bb}"), ("\u{b641}",
        "\u{b641}", "\u{1104}\u{116a}\u{11bc}", "\u{b641}", "\u{1104}\u{116a}\u{11bc}"),
        ("\u{b642}", "\u{b642}", "\u{1104}\u{116a}\u{11bd}", "\u{b642}",
        "\u{1104}\u{116a}\u{11bd}"), ("\u{b643}", "\u{b643}", "\u{1104}\u{116a}\u{11be}",
        "\u{b643}", "\u{1104}\u{116a}\u{11be}"), ("\u{b644}", "\u{b644}",
        "\u{1104}\u{116a}\u{11bf}", "\u{b644}", "\u{1104}\u{116a}\u{11bf}"), ("\u{b645}",
        "\u{b645}", "\u{1104}\u{116a}\u{11c0}", "\u{b645}", "\u{1104}\u{116a}\u{11c0}"),
        ("\u{b646}", "\u{b646}", "\u{1104}\u{116a}\u{11c1}", "\u{b646}",
        "\u{1104}\u{116a}\u{11c1}"), ("\u{b647}", "\u{b647}", "\u{1104}\u{116a}\u{11c2}",
        "\u{b647}", "\u{1104}\u{116a}\u{11c2}"), ("\u{b648}", "\u{b648}", "\u{1104}\u{116b}",
        "\u{b648}", "\u{1104}\u{116b}"), ("\u{b649}", "\u{b649}", "\u{1104}\u{116b}\u{11a8}",
        "\u{b649}", "\u{1104}\u{116b}\u{11a8}"), ("\u{b64a}", "\u{b64a}",
        "\u{1104}\u{116b}\u{11a9}", "\u{b64a}", "\u{1104}\u{116b}\u{11a9}"), ("\u{b64b}",
        "\u{b64b}", "\u{1104}\u{116b}\u{11aa}", "\u{b64b}", "\u{1104}\u{116b}\u{11aa}"),
        ("\u{b64c}", "\u{b64c}", "\u{1104}\u{116b}\u{11ab}", "\u{b64c}",
        "\u{1104}\u{116b}\u{11ab}"), ("\u{b64d}", "\u{b64d}", "\u{1104}\u{116b}\u{11ac}",
        "\u{b64d}", "\u{1104}\u{116b}\u{11ac}"), ("\u{b64e}", "\u{b64e}",
        "\u{1104}\u{116b}\u{11ad}", "\u{b64e}", "\u{1104}\u{116b}\u{11ad}"), ("\u{b64f}",
        "\u{b64f}", "\u{1104}\u{116b}\u{11ae}", "\u{b64f}", "\u{1104}\u{116b}\u{11ae}"),
        ("\u{b650}", "\u{b650}", "\u{1104}\u{116b}\u{11af}", "\u{b650}",
        "\u{1104}\u{116b}\u{11af}"), ("\u{b651}", "\u{b651}", "\u{1104}\u{116b}\u{11b0}",
        "\u{b651}", "\u{1104}\u{116b}\u{11b0}"), ("\u{b652}", "\u{b652}",
        "\u{1104}\u{116b}\u{11b1}", "\u{b652}", "\u{1104}\u{116b}\u{11b1}"), ("\u{b653}",
        "\u{b653}", "\u{1104}\u{116b}\u{11b2}", "\u{b653}", "\u{1104}\u{116b}\u{11b2}"),
        ("\u{b654}", "\u{b654}", "\u{1104}\u{116b}\u{11b3}", "\u{b654}",
        "\u{1104}\u{116b}\u{11b3}"), ("\u{b655}", "\u{b655}", "\u{1104}\u{116b}\u{11b4}",
        "\u{b655}", "\u{1104}\u{116b}\u{11b4}"), ("\u{b656}", "\u{b656}",
        "\u{1104}\u{116b}\u{11b5}", "\u{b656}", "\u{1104}\u{116b}\u{11b5}"), ("\u{b657}",
        "\u{b657}", "\u{1104}\u{116b}\u{11b6}", "\u{b657}", "\u{1104}\u{116b}\u{11b6}"),
        ("\u{b658}", "\u{b658}", "\u{1104}\u{116b}\u{11b7}", "\u{b658}",
        "\u{1104}\u{116b}\u{11b7}"), ("\u{b659}", "\u{b659}", "\u{1104}\u{116b}\u{11b8}",
        "\u{b659}", "\u{1104}\u{116b}\u{11b8}"), ("\u{b65a}", "\u{b65a}",
        "\u{1104}\u{116b}\u{11b9}", "\u{b65a}", "\u{1104}\u{116b}\u{11b9}"), ("\u{b65b}",
        "\u{b65b}", "\u{1104}\u{116b}\u{11ba}", "\u{b65b}", "\u{1104}\u{116b}\u{11ba}"),
        ("\u{b65c}", "\u{b65c}", "\u{1104}\u{116b}\u{11bb}", "\u{b65c}",
        "\u{1104}\u{116b}\u{11bb}"), ("\u{b65d}", "\u{b65d}", "\u{1104}\u{116b}\u{11bc}",
        "\u{b65d}", "\u{1104}\u{116b}\u{11bc}"), ("\u{b65e}", "\u{b65e}",
        "\u{1104}\u{116b}\u{11bd}", "\u{b65e}", "\u{1104}\u{116b}\u{11bd}"), ("\u{b65f}",
        "\u{b65f}", "\u{1104}\u{116b}\u{11be}", "\u{b65f}", "\u{1104}\u{116b}\u{11be}"),
        ("\u{b660}", "\u{b660}", "\u{1104}\u{116b}\u{11bf}", "\u{b660}",
        "\u{1104}\u{116b}\u{11bf}"), ("\u{b661}", "\u{b661}", "\u{1104}\u{116b}\u{11c0}",
        "\u{b661}", "\u{1104}\u{116b}\u{11c0}"), ("\u{b662}", "\u{b662}",
        "\u{1104}\u{116b}\u{11c1}", "\u{b662}", "\u{1104}\u{116b}\u{11c1}"), ("\u{b663}",
        "\u{b663}", "\u{1104}\u{116b}\u{11c2}", "\u{b663}", "\u{1104}\u{116b}\u{11c2}"),
        ("\u{b664}", "\u{b664}", "\u{1104}\u{116c}", "\u{b664}", "\u{1104}\u{116c}"), ("\u{b665}",
        "\u{b665}", "\u{1104}\u{116c}\u{11a8}", "\u{b665}", "\u{1104}\u{116c}\u{11a8}"),
        ("\u{b666}", "\u{b666}", "\u{1104}\u{116c}\u{11a9}", "\u{b666}",
        "\u{1104}\u{116c}\u{11a9}"), ("\u{b667}", "\u{b667}", "\u{1104}\u{116c}\u{11aa}",
        "\u{b667}", "\u{1104}\u{116c}\u{11aa}"), ("\u{b668}", "\u{b668}",
        "\u{1104}\u{116c}\u{11ab}", "\u{b668}", "\u{1104}\u{116c}\u{11ab}"), ("\u{b669}",
        "\u{b669}", "\u{1104}\u{116c}\u{11ac}", "\u{b669}", "\u{1104}\u{116c}\u{11ac}"),
        ("\u{b66a}", "\u{b66a}", "\u{1104}\u{116c}\u{11ad}", "\u{b66a}",
        "\u{1104}\u{116c}\u{11ad}"), ("\u{b66b}", "\u{b66b}", "\u{1104}\u{116c}\u{11ae}",
        "\u{b66b}", "\u{1104}\u{116c}\u{11ae}"), ("\u{b66c}", "\u{b66c}",
        "\u{1104}\u{116c}\u{11af}", "\u{b66c}", "\u{1104}\u{116c}\u{11af}"), ("\u{b66d}",
        "\u{b66d}", "\u{1104}\u{116c}\u{11b0}", "\u{b66d}", "\u{1104}\u{116c}\u{11b0}"),
        ("\u{b66e}", "\u{b66e}", "\u{1104}\u{116c}\u{11b1}", "\u{b66e}",
        "\u{1104}\u{116c}\u{11b1}"), ("\u{b66f}", "\u{b66f}", "\u{1104}\u{116c}\u{11b2}",
        "\u{b66f}", "\u{1104}\u{116c}\u{11b2}"), ("\u{b670}", "\u{b670}",
        "\u{1104}\u{116c}\u{11b3}", "\u{b670}", "\u{1104}\u{116c}\u{11b3}"), ("\u{b671}",
        "\u{b671}", "\u{1104}\u{116c}\u{11b4}", "\u{b671}", "\u{1104}\u{116c}\u{11b4}"),
        ("\u{b672}", "\u{b672}", "\u{1104}\u{116c}\u{11b5}", "\u{b672}",
        "\u{1104}\u{116c}\u{11b5}"), ("\u{b673}", "\u{b673}", "\u{1104}\u{116c}\u{11b6}",
        "\u{b673}", "\u{1104}\u{116c}\u{11b6}"), ("\u{b674}", "\u{b674}",
        "\u{1104}\u{116c}\u{11b7}", "\u{b674}", "\u{1104}\u{116c}\u{11b7}"), ("\u{b675}",
        "\u{b675}", "\u{1104}\u{116c}\u{11b8}", "\u{b675}", "\u{1104}\u{116c}\u{11b8}"),
        ("\u{b676}", "\u{b676}", "\u{1104}\u{116c}\u{11b9}", "\u{b676}",
        "\u{1104}\u{116c}\u{11b9}"), ("\u{b677}", "\u{b677}", "\u{1104}\u{116c}\u{11ba}",
        "\u{b677}", "\u{1104}\u{116c}\u{11ba}"), ("\u{b678}", "\u{b678}",
        "\u{1104}\u{116c}\u{11bb}", "\u{b678}", "\u{1104}\u{116c}\u{11bb}"), ("\u{b679}",
        "\u{b679}", "\u{1104}\u{116c}\u{11bc}", "\u{b679}", "\u{1104}\u{116c}\u{11bc}"),
        ("\u{b67a}", "\u{b67a}", "\u{1104}\u{116c}\u{11bd}", "\u{b67a}",
        "\u{1104}\u{116c}\u{11bd}"), ("\u{b67b}", "\u{b67b}", "\u{1104}\u{116c}\u{11be}",
        "\u{b67b}", "\u{1104}\u{116c}\u{11be}"), ("\u{b67c}", "\u{b67c}",
        "\u{1104}\u{116c}\u{11bf}", "\u{b67c}", "\u{1104}\u{116c}\u{11bf}"), ("\u{b67d}",
        "\u{b67d}", "\u{1104}\u{116c}\u{11c0}", "\u{b67d}", "\u{1104}\u{116c}\u{11c0}"),
        ("\u{b67e}", "\u{b67e}", "\u{1104}\u{116c}\u{11c1}", "\u{b67e}",
        "\u{1104}\u{116c}\u{11c1}"), ("\u{b67f}", "\u{b67f}", "\u{1104}\u{116c}\u{11c2}",
        "\u{b67f}", "\u{1104}\u{116c}\u{11c2}"), ("\u{b680}", "\u{b680}", "\u{1104}\u{116d}",
        "\u{b680}", "\u{1104}\u{116d}"), ("\u{b681}", "\u{b681}", "\u{1104}\u{116d}\u{11a8}",
        "\u{b681}", "\u{1104}\u{116d}\u{11a8}"), ("\u{b682}", "\u{b682}",
        "\u{1104}\u{116d}\u{11a9}", "\u{b682}", "\u{1104}\u{116d}\u{11a9}"), ("\u{b683}",
        "\u{b683}", "\u{1104}\u{116d}\u{11aa}", "\u{b683}", "\u{1104}\u{116d}\u{11aa}"),
        ("\u{b684}", "\u{b684}", "\u{1104}\u{116d}\u{11ab}", "\u{b684}",
        "\u{1104}\u{116d}\u{11ab}"), ("\u{b685}", "\u{b685}", "\u{1104}\u{116d}\u{11ac}",
        "\u{b685}", "\u{1104}\u{116d}\u{11ac}"), ("\u{b686}", "\u{b686}",
        "\u{1104}\u{116d}\u{11ad}", "\u{b686}", "\u{1104}\u{116d}\u{11ad}"), ("\u{b687}",
        "\u{b687}", "\u{1104}\u{116d}\u{11ae}", "\u{b687}", "\u{1104}\u{116d}\u{11ae}"),
        ("\u{b688}", "\u{b688}", "\u{1104}\u{116d}\u{11af}", "\u{b688}",
        "\u{1104}\u{116d}\u{11af}"), ("\u{b689}", "\u{b689}", "\u{1104}\u{116d}\u{11b0}",
        "\u{b689}", "\u{1104}\u{116d}\u{11b0}"), ("\u{b68a}", "\u{b68a}",
        "\u{1104}\u{116d}\u{11b1}", "\u{b68a}", "\u{1104}\u{116d}\u{11b1}"), ("\u{b68b}",
        "\u{b68b}", "\u{1104}\u{116d}\u{11b2}", "\u{b68b}", "\u{1104}\u{116d}\u{11b2}"),
        ("\u{b68c}", "\u{b68c}", "\u{1104}\u{116d}\u{11b3}", "\u{b68c}",
        "\u{1104}\u{116d}\u{11b3}"), ("\u{b68d}", "\u{b68d}", "\u{1104}\u{116d}\u{11b4}",
        "\u{b68d}", "\u{1104}\u{116d}\u{11b4}"), ("\u{b68e}", "\u{b68e}",
        "\u{1104}\u{116d}\u{11b5}", "\u{b68e}", "\u{1104}\u{116d}\u{11b5}"), ("\u{b68f}",
        "\u{b68f}", "\u{1104}\u{116d}\u{11b6}", "\u{b68f}", "\u{1104}\u{116d}\u{11b6}"),
        ("\u{b690}", "\u{b690}", "\u{1104}\u{116d}\u{11b7}", "\u{b690}",
        "\u{1104}\u{116d}\u{11b7}"), ("\u{b691}", "\u{b691}", "\u{1104}\u{116d}\u{11b8}",
        "\u{b691}", "\u{1104}\u{116d}\u{11b8}"), ("\u{b692}", "\u{b692}",
        "\u{1104}\u{116d}\u{11b9}", "\u{b692}", "\u{1104}\u{116d}\u{11b9}"), ("\u{b693}",
        "\u{b693}", "\u{1104}\u{116d}\u{11ba}", "\u{b693}", "\u{1104}\u{116d}\u{11ba}"),
        ("\u{b694}", "\u{b694}", "\u{1104}\u{116d}\u{11bb}", "\u{b694}",
        "\u{1104}\u{116d}\u{11bb}"), ("\u{b695}", "\u{b695}", "\u{1104}\u{116d}\u{11bc}",
        "\u{b695}", "\u{1104}\u{116d}\u{11bc}"), ("\u{b696}", "\u{b696}",
        "\u{1104}\u{116d}\u{11bd}", "\u{b696}", "\u{1104}\u{116d}\u{11bd}"), ("\u{b697}",
        "\u{b697}", "\u{1104}\u{116d}\u{11be}", "\u{b697}", "\u{1104}\u{116d}\u{11be}"),
        ("\u{b698}", "\u{b698}", "\u{1104}\u{116d}\u{11bf}", "\u{b698}",
        "\u{1104}\u{116d}\u{11bf}"), ("\u{b699}", "\u{b699}", "\u{1104}\u{116d}\u{11c0}",
        "\u{b699}", "\u{1104}\u{116d}\u{11c0}"), ("\u{b69a}", "\u{b69a}",
        "\u{1104}\u{116d}\u{11c1}", "\u{b69a}", "\u{1104}\u{116d}\u{11c1}"), ("\u{b69b}",
        "\u{b69b}", "\u{1104}\u{116d}\u{11c2}", "\u{b69b}", "\u{1104}\u{116d}\u{11c2}"),
        ("\u{b69c}", "\u{b69c}", "\u{1104}\u{116e}", "\u{b69c}", "\u{1104}\u{116e}"), ("\u{b69d}",
        "\u{b69d}", "\u{1104}\u{116e}\u{11a8}", "\u{b69d}", "\u{1104}\u{116e}\u{11a8}"),
        ("\u{b69e}", "\u{b69e}", "\u{1104}\u{116e}\u{11a9}", "\u{b69e}",
        "\u{1104}\u{116e}\u{11a9}"), ("\u{b69f}", "\u{b69f}", "\u{1104}\u{116e}\u{11aa}",
        "\u{b69f}", "\u{1104}\u{116e}\u{11aa}"), ("\u{b6a0}", "\u{b6a0}",
        "\u{1104}\u{116e}\u{11ab}", "\u{b6a0}", "\u{1104}\u{116e}\u{11ab}"), ("\u{b6a1}",
        "\u{b6a1}", "\u{1104}\u{116e}\u{11ac}", "\u{b6a1}", "\u{1104}\u{116e}\u{11ac}"),
        ("\u{b6a2}", "\u{b6a2}", "\u{1104}\u{116e}\u{11ad}", "\u{b6a2}",
        "\u{1104}\u{116e}\u{11ad}"), ("\u{b6a3}", "\u{b6a3}", "\u{1104}\u{116e}\u{11ae}",
        "\u{b6a3}", "\u{1104}\u{116e}\u{11ae}"), ("\u{b6a4}", "\u{b6a4}",
        "\u{1104}\u{116e}\u{11af}", "\u{b6a4}", "\u{1104}\u{116e}\u{11af}"), ("\u{b6a5}",
        "\u{b6a5}", "\u{1104}\u{116e}\u{11b0}", "\u{b6a5}", "\u{1104}\u{116e}\u{11b0}"),
        ("\u{b6a6}", "\u{b6a6}", "\u{1104}\u{116e}\u{11b1}", "\u{b6a6}",
        "\u{1104}\u{116e}\u{11b1}"), ("\u{b6a7}", "\u{b6a7}", "\u{1104}\u{116e}\u{11b2}",
        "\u{b6a7}", "\u{1104}\u{116e}\u{11b2}"), ("\u{b6a8}", "\u{b6a8}",
        "\u{1104}\u{116e}\u{11b3}", "\u{b6a8}", "\u{1104}\u{116e}\u{11b3}"), ("\u{b6a9}",
        "\u{b6a9}", "\u{1104}\u{116e}\u{11b4}", "\u{b6a9}", "\u{1104}\u{116e}\u{11b4}"),
        ("\u{b6aa}", "\u{b6aa}", "\u{1104}\u{116e}\u{11b5}", "\u{b6aa}",
        "\u{1104}\u{116e}\u{11b5}"), ("\u{b6ab}", "\u{b6ab}", "\u{1104}\u{116e}\u{11b6}",
        "\u{b6ab}", "\u{1104}\u{116e}\u{11b6}"), ("\u{b6ac}", "\u{b6ac}",
        "\u{1104}\u{116e}\u{11b7}", "\u{b6ac}", "\u{1104}\u{116e}\u{11b7}"), ("\u{b6ad}",
        "\u{b6ad}", "\u{1104}\u{116e}\u{11b8}", "\u{b6ad}", "\u{1104}\u{116e}\u{11b8}"),
        ("\u{b6ae}", "\u{b6ae}", "\u{1104}\u{116e}\u{11b9}", "\u{b6ae}",
        "\u{1104}\u{116e}\u{11b9}"), ("\u{b6af}", "\u{b6af}", "\u{1104}\u{116e}\u{11ba}",
        "\u{b6af}", "\u{1104}\u{116e}\u{11ba}"), ("\u{b6b0}", "\u{b6b0}",
        "\u{1104}\u{116e}\u{11bb}", "\u{b6b0}", "\u{1104}\u{116e}\u{11bb}"), ("\u{b6b1}",
        "\u{b6b1}", "\u{1104}\u{116e}\u{11bc}", "\u{b6b1}", "\u{1104}\u{116e}\u{11bc}"),
        ("\u{b6b2}", "\u{b6b2}", "\u{1104}\u{116e}\u{11bd}", "\u{b6b2}",
        "\u{1104}\u{116e}\u{11bd}"), ("\u{b6b3}", "\u{b6b3}", "\u{1104}\u{116e}\u{11be}",
        "\u{b6b3}", "\u{1104}\u{116e}\u{11be}"), ("\u{b6b4}", "\u{b6b4}",
        "\u{1104}\u{116e}\u{11bf}", "\u{b6b4}", "\u{1104}\u{116e}\u{11bf}"), ("\u{b6b5}",
        "\u{b6b5}", "\u{1104}\u{116e}\u{11c0}", "\u{b6b5}", "\u{1104}\u{116e}\u{11c0}"),
        ("\u{b6b6}", "\u{b6b6}", "\u{1104}\u{116e}\u{11c1}", "\u{b6b6}",
        "\u{1104}\u{116e}\u{11c1}"), ("\u{b6b7}", "\u{b6b7}", "\u{1104}\u{116e}\u{11c2}",
        "\u{b6b7}", "\u{1104}\u{116e}\u{11c2}"), ("\u{b6b8}", "\u{b6b8}", "\u{1104}\u{116f}",
        "\u{b6b8}", "\u{1104}\u{116f}"), ("\u{b6b9}", "\u{b6b9}", "\u{1104}\u{116f}\u{11a8}",
        "\u{b6b9}", "\u{1104}\u{116f}\u{11a8}"), ("\u{b6ba}", "\u{b6ba}",
        "\u{1104}\u{116f}\u{11a9}", "\u{b6ba}", "\u{1104}\u{116f}\u{11a9}"), ("\u{b6bb}",
        "\u{b6bb}", "\u{1104}\u{116f}\u{11aa}", "\u{b6bb}", "\u{1104}\u{116f}\u{11aa}"),
        ("\u{b6bc}", "\u{b6bc}", "\u{1104}\u{116f}\u{11ab}", "\u{b6bc}",
        "\u{1104}\u{116f}\u{11ab}"), ("\u{b6bd}", "\u{b6bd}", "\u{1104}\u{116f}\u{11ac}",
        "\u{b6bd}", "\u{1104}\u{116f}\u{11ac}"), ("\u{b6be}", "\u{b6be}",
        "\u{1104}\u{116f}\u{11ad}", "\u{b6be}", "\u{1104}\u{116f}\u{11ad}"), ("\u{b6bf}",
        "\u{b6bf}", "\u{1104}\u{116f}\u{11ae}", "\u{b6bf}", "\u{1104}\u{116f}\u{11ae}"),
        ("\u{b6c0}", "\u{b6c0}", "\u{1104}\u{116f}\u{11af}", "\u{b6c0}",
        "\u{1104}\u{116f}\u{11af}"), ("\u{b6c1}", "\u{b6c1}", "\u{1104}\u{116f}\u{11b0}",
        "\u{b6c1}", "\u{1104}\u{116f}\u{11b0}"), ("\u{b6c2}", "\u{b6c2}",
        "\u{1104}\u{116f}\u{11b1}", "\u{b6c2}", "\u{1104}\u{116f}\u{11b1}"), ("\u{b6c3}",
        "\u{b6c3}", "\u{1104}\u{116f}\u{11b2}", "\u{b6c3}", "\u{1104}\u{116f}\u{11b2}"),
        ("\u{b6c4}", "\u{b6c4}", "\u{1104}\u{116f}\u{11b3}", "\u{b6c4}",
        "\u{1104}\u{116f}\u{11b3}"), ("\u{b6c5}", "\u{b6c5}", "\u{1104}\u{116f}\u{11b4}",
        "\u{b6c5}", "\u{1104}\u{116f}\u{11b4}"), ("\u{b6c6}", "\u{b6c6}",
        "\u{1104}\u{116f}\u{11b5}", "\u{b6c6}", "\u{1104}\u{116f}\u{11b5}"), ("\u{b6c7}",
        "\u{b6c7}", "\u{1104}\u{116f}\u{11b6}", "\u{b6c7}", "\u{1104}\u{116f}\u{11b6}"),
        ("\u{b6c8}", "\u{b6c8}", "\u{1104}\u{116f}\u{11b7}", "\u{b6c8}",
        "\u{1104}\u{116f}\u{11b7}"), ("\u{b6c9}", "\u{b6c9}", "\u{1104}\u{116f}\u{11b8}",
        "\u{b6c9}", "\u{1104}\u{116f}\u{11b8}"), ("\u{b6ca}", "\u{b6ca}",
        "\u{1104}\u{116f}\u{11b9}", "\u{b6ca}", "\u{1104}\u{116f}\u{11b9}"), ("\u{b6cb}",
        "\u{b6cb}", "\u{1104}\u{116f}\u{11ba}", "\u{b6cb}", "\u{1104}\u{116f}\u{11ba}"),
        ("\u{b6cc}", "\u{b6cc}", "\u{1104}\u{116f}\u{11bb}", "\u{b6cc}",
        "\u{1104}\u{116f}\u{11bb}"), ("\u{b6cd}", "\u{b6cd}", "\u{1104}\u{116f}\u{11bc}",
        "\u{b6cd}", "\u{1104}\u{116f}\u{11bc}"), ("\u{b6ce}", "\u{b6ce}",
        "\u{1104}\u{116f}\u{11bd}", "\u{b6ce}", "\u{1104}\u{116f}\u{11bd}"), ("\u{b6cf}",
        "\u{b6cf}", "\u{1104}\u{116f}\u{11be}", "\u{b6cf}", "\u{1104}\u{116f}\u{11be}"),
        ("\u{b6d0}", "\u{b6d0}", "\u{1104}\u{116f}\u{11bf}", "\u{b6d0}",
        "\u{1104}\u{116f}\u{11bf}"), ("\u{b6d1}", "\u{b6d1}", "\u{1104}\u{116f}\u{11c0}",
        "\u{b6d1}", "\u{1104}\u{116f}\u{11c0}"), ("\u{b6d2}", "\u{b6d2}",
        "\u{1104}\u{116f}\u{11c1}", "\u{b6d2}", "\u{1104}\u{116f}\u{11c1}"), ("\u{b6d3}",
        "\u{b6d3}", "\u{1104}\u{116f}\u{11c2}", "\u{b6d3}", "\u{1104}\u{116f}\u{11c2}"),
        ("\u{b6d4}", "\u{b6d4}", "\u{1104}\u{1170}", "\u{b6d4}", "\u{1104}\u{1170}"), ("\u{b6d5}",
        "\u{b6d5}", "\u{1104}\u{1170}\u{11a8}", "\u{b6d5}", "\u{1104}\u{1170}\u{11a8}"),
        ("\u{b6d6}", "\u{b6d6}", "\u{1104}\u{1170}\u{11a9}", "\u{b6d6}",
        "\u{1104}\u{1170}\u{11a9}"), ("\u{b6d7}", "\u{b6d7}", "\u{1104}\u{1170}\u{11aa}",
        "\u{b6d7}", "\u{1104}\u{1170}\u{11aa}"), ("\u{b6d8}", "\u{b6d8}",
        "\u{1104}\u{1170}\u{11ab}", "\u{b6d8}", "\u{1104}\u{1170}\u{11ab}"), ("\u{b6d9}",
        "\u{b6d9}", "\u{1104}\u{1170}\u{11ac}", "\u{b6d9}", "\u{1104}\u{1170}\u{11ac}"),
        ("\u{b6da}", "\u{b6da}", "\u{1104}\u{1170}\u{11ad}", "\u{b6da}",
        "\u{1104}\u{1170}\u{11ad}"), ("\u{b6db}", "\u{b6db}", "\u{1104}\u{1170}\u{11ae}",
        "\u{b6db}", "\u{1104}\u{1170}\u{11ae}"), ("\u{b6dc}", "\u{b6dc}",
        "\u{1104}\u{1170}\u{11af}", "\u{b6dc}", "\u{1104}\u{1170}\u{11af}"), ("\u{b6dd}",
        "\u{b6dd}", "\u{1104}\u{1170}\u{11b0}", "\u{b6dd}", "\u{1104}\u{1170}\u{11b0}"),
        ("\u{b6de}", "\u{b6de}", "\u{1104}\u{1170}\u{11b1}", "\u{b6de}",
        "\u{1104}\u{1170}\u{11b1}"), ("\u{b6df}", "\u{b6df}", "\u{1104}\u{1170}\u{11b2}",
        "\u{b6df}", "\u{1104}\u{1170}\u{11b2}"), ("\u{b6e0}", "\u{b6e0}",
        "\u{1104}\u{1170}\u{11b3}", "\u{b6e0}", "\u{1104}\u{1170}\u{11b3}"), ("\u{b6e1}",
        "\u{b6e1}", "\u{1104}\u{1170}\u{11b4}", "\u{b6e1}", "\u{1104}\u{1170}\u{11b4}"),
        ("\u{b6e2}", "\u{b6e2}", "\u{1104}\u{1170}\u{11b5}", "\u{b6e2}",
        "\u{1104}\u{1170}\u{11b5}"), ("\u{b6e3}", "\u{b6e3}", "\u{1104}\u{1170}\u{11b6}",
        "\u{b6e3}", "\u{1104}\u{1170}\u{11b6}"), ("\u{b6e4}", "\u{b6e4}",
        "\u{1104}\u{1170}\u{11b7}", "\u{b6e4}", "\u{1104}\u{1170}\u{11b7}"), ("\u{b6e5}",
        "\u{b6e5}", "\u{1104}\u{1170}\u{11b8}", "\u{b6e5}", "\u{1104}\u{1170}\u{11b8}"),
        ("\u{b6e6}", "\u{b6e6}", "\u{1104}\u{1170}\u{11b9}", "\u{b6e6}",
        "\u{1104}\u{1170}\u{11b9}"), ("\u{b6e7}", "\u{b6e7}", "\u{1104}\u{1170}\u{11ba}",
        "\u{b6e7}", "\u{1104}\u{1170}\u{11ba}"), ("\u{b6e8}", "\u{b6e8}",
        "\u{1104}\u{1170}\u{11bb}", "\u{b6e8}", "\u{1104}\u{1170}\u{11bb}"), ("\u{b6e9}",
        "\u{b6e9}", "\u{1104}\u{1170}\u{11bc}", "\u{b6e9}", "\u{1104}\u{1170}\u{11bc}"),
        ("\u{b6ea}", "\u{b6ea}", "\u{1104}\u{1170}\u{11bd}", "\u{b6ea}",
        "\u{1104}\u{1170}\u{11bd}"), ("\u{b6eb}", "\u{b6eb}", "\u{1104}\u{1170}\u{11be}",
        "\u{b6eb}", "\u{1104}\u{1170}\u{11be}"), ("\u{b6ec}", "\u{b6ec}",
        "\u{1104}\u{1170}\u{11bf}", "\u{b6ec}", "\u{1104}\u{1170}\u{11bf}"), ("\u{b6ed}",
        "\u{b6ed}", "\u{1104}\u{1170}\u{11c0}", "\u{b6ed}", "\u{1104}\u{1170}\u{11c0}"),
        ("\u{b6ee}", "\u{b6ee}", "\u{1104}\u{1170}\u{11c1}", "\u{b6ee}",
        "\u{1104}\u{1170}\u{11c1}"), ("\u{b6ef}", "\u{b6ef}", "\u{1104}\u{1170}\u{11c2}",
        "\u{b6ef}", "\u{1104}\u{1170}\u{11c2}"), ("\u{b6f0}", "\u{b6f0}", "\u{1104}\u{1171}",
        "\u{b6f0}", "\u{1104}\u{1171}"), ("\u{b6f1}", "\u{b6f1}", "\u{1104}\u{1171}\u{11a8}",
        "\u{b6f1}", "\u{1104}\u{1171}\u{11a8}"), ("\u{b6f2}", "\u{b6f2}",
        "\u{1104}\u{1171}\u{11a9}", "\u{b6f2}", "\u{1104}\u{1171}\u{11a9}"), ("\u{b6f3}",
        "\u{b6f3}", "\u{1104}\u{1171}\u{11aa}", "\u{b6f3}", "\u{1104}\u{1171}\u{11aa}"),
        ("\u{b6f4}", "\u{b6f4}", "\u{1104}\u{1171}\u{11ab}", "\u{b6f4}",
        "\u{1104}\u{1171}\u{11ab}"), ("\u{b6f5}", "\u{b6f5}", "\u{1104}\u{1171}\u{11ac}",
        "\u{b6f5}", "\u{1104}\u{1171}\u{11ac}"), ("\u{b6f6}", "\u{b6f6}",
        "\u{1104}\u{1171}\u{11ad}", "\u{b6f6}", "\u{1104}\u{1171}\u{11ad}"), ("\u{b6f7}",
        "\u{b6f7}", "\u{1104}\u{1171}\u{11ae}", "\u{b6f7}", "\u{1104}\u{1171}\u{11ae}"),
        ("\u{b6f8}", "\u{b6f8}", "\u{1104}\u{1171}\u{11af}", "\u{b6f8}",
        "\u{1104}\u{1171}\u{11af}"), ("\u{b6f9}", "\u{b6f9}", "\u{1104}\u{1171}\u{11b0}",
        "\u{b6f9}", "\u{1104}\u{1171}\u{11b0}"), ("\u{b6fa}", "\u{b6fa}",
        "\u{1104}\u{1171}\u{11b1}", "\u{b6fa}", "\u{1104}\u{1171}\u{11b1}"), ("\u{b6fb}",
        "\u{b6fb}", "\u{1104}\u{1171}\u{11b2}", "\u{b6fb}", "\u{1104}\u{1171}\u{11b2}"),
        ("\u{b6fc}", "\u{b6fc}", "\u{1104}\u{1171}\u{11b3}", "\u{b6fc}",
        "\u{1104}\u{1171}\u{11b3}"), ("\u{b6fd}", "\u{b6fd}", "\u{1104}\u{1171}\u{11b4}",
        "\u{b6fd}", "\u{1104}\u{1171}\u{11b4}"), ("\u{b6fe}", "\u{b6fe}",
        "\u{1104}\u{1171}\u{11b5}", "\u{b6fe}", "\u{1104}\u{1171}\u{11b5}"), ("\u{b6ff}",
        "\u{b6ff}", "\u{1104}\u{1171}\u{11b6}", "\u{b6ff}", "\u{1104}\u{1171}\u{11b6}"),
        ("\u{b700}", "\u{b700}", "\u{1104}\u{1171}\u{11b7}", "\u{b700}",
        "\u{1104}\u{1171}\u{11b7}"), ("\u{b701}", "\u{b701}", "\u{1104}\u{1171}\u{11b8}",
        "\u{b701}", "\u{1104}\u{1171}\u{11b8}"), ("\u{b702}", "\u{b702}",
        "\u{1104}\u{1171}\u{11b9}", "\u{b702}", "\u{1104}\u{1171}\u{11b9}"), ("\u{b703}",
        "\u{b703}", "\u{1104}\u{1171}\u{11ba}", "\u{b703}", "\u{1104}\u{1171}\u{11ba}"),
        ("\u{b704}", "\u{b704}", "\u{1104}\u{1171}\u{11bb}", "\u{b704}",
        "\u{1104}\u{1171}\u{11bb}"), ("\u{b705}", "\u{b705}", "\u{1104}\u{1171}\u{11bc}",
        "\u{b705}", "\u{1104}\u{1171}\u{11bc}"), ("\u{b706}", "\u{b706}",
        "\u{1104}\u{1171}\u{11bd}", "\u{b706}", "\u{1104}\u{1171}\u{11bd}"), ("\u{b707}",
        "\u{b707}", "\u{1104}\u{1171}\u{11be}", "\u{b707}", "\u{1104}\u{1171}\u{11be}"),
        ("\u{b708}", "\u{b708}", "\u{1104}\u{1171}\u{11bf}", "\u{b708}",
        "\u{1104}\u{1171}\u{11bf}"), ("\u{b709}", "\u{b709}", "\u{1104}\u{1171}\u{11c0}",
        "\u{b709}", "\u{1104}\u{1171}\u{11c0}"), ("\u{b70a}", "\u{b70a}",
        "\u{1104}\u{1171}\u{11c1}", "\u{b70a}", "\u{1104}\u{1171}\u{11c1}"), ("\u{b70b}",
        "\u{b70b}", "\u{1104}\u{1171}\u{11c2}", "\u{b70b}", "\u{1104}\u{1171}\u{11c2}"),
        ("\u{b70c}", "\u{b70c}", "\u{1104}\u{1172}", "\u{b70c}", "\u{1104}\u{1172}"), ("\u{b70d}",
        "\u{b70d}", "\u{1104}\u{1172}\u{11a8}", "\u{b70d}", "\u{1104}\u{1172}\u{11a8}"),
        ("\u{b70e}", "\u{b70e}", "\u{1104}\u{1172}\u{11a9}", "\u{b70e}",
        "\u{1104}\u{1172}\u{11a9}"), ("\u{b70f}", "\u{b70f}", "\u{1104}\u{1172}\u{11aa}",
        "\u{b70f}", "\u{1104}\u{1172}\u{11aa}"), ("\u{b710}", "\u{b710}",
        "\u{1104}\u{1172}\u{11ab}", "\u{b710}", "\u{1104}\u{1172}\u{11ab}"), ("\u{b711}",
        "\u{b711}", "\u{1104}\u{1172}\u{11ac}", "\u{b711}", "\u{1104}\u{1172}\u{11ac}"),
        ("\u{b712}", "\u{b712}", "\u{1104}\u{1172}\u{11ad}", "\u{b712}",
        "\u{1104}\u{1172}\u{11ad}"), ("\u{b713}", "\u{b713}", "\u{1104}\u{1172}\u{11ae}",
        "\u{b713}", "\u{1104}\u{1172}\u{11ae}"), ("\u{b714}", "\u{b714}",
        "\u{1104}\u{1172}\u{11af}", "\u{b714}", "\u{1104}\u{1172}\u{11af}"), ("\u{b715}",
        "\u{b715}", "\u{1104}\u{1172}\u{11b0}", "\u{b715}", "\u{1104}\u{1172}\u{11b0}"),
        ("\u{b716}", "\u{b716}", "\u{1104}\u{1172}\u{11b1}", "\u{b716}",
        "\u{1104}\u{1172}\u{11b1}"), ("\u{b717}", "\u{b717}", "\u{1104}\u{1172}\u{11b2}",
        "\u{b717}", "\u{1104}\u{1172}\u{11b2}"), ("\u{b718}", "\u{b718}",
        "\u{1104}\u{1172}\u{11b3}", "\u{b718}", "\u{1104}\u{1172}\u{11b3}"), ("\u{b719}",
        "\u{b719}", "\u{1104}\u{1172}\u{11b4}", "\u{b719}", "\u{1104}\u{1172}\u{11b4}"),
        ("\u{b71a}", "\u{b71a}", "\u{1104}\u{1172}\u{11b5}", "\u{b71a}",
        "\u{1104}\u{1172}\u{11b5}"), ("\u{b71b}", "\u{b71b}", "\u{1104}\u{1172}\u{11b6}",
        "\u{b71b}", "\u{1104}\u{1172}\u{11b6}"), ("\u{b71c}", "\u{b71c}",
        "\u{1104}\u{1172}\u{11b7}", "\u{b71c}", "\u{1104}\u{1172}\u{11b7}"), ("\u{b71d}",
        "\u{b71d}", "\u{1104}\u{1172}\u{11b8}", "\u{b71d}", "\u{1104}\u{1172}\u{11b8}"),
        ("\u{b71e}", "\u{b71e}", "\u{1104}\u{1172}\u{11b9}", "\u{b71e}",
        "\u{1104}\u{1172}\u{11b9}"), ("\u{b71f}", "\u{b71f}", "\u{1104}\u{1172}\u{11ba}",
        "\u{b71f}", "\u{1104}\u{1172}\u{11ba}"), ("\u{b720}", "\u{b720}",
        "\u{1104}\u{1172}\u{11bb}", "\u{b720}", "\u{1104}\u{1172}\u{11bb}"), ("\u{b721}",
        "\u{b721}", "\u{1104}\u{1172}\u{11bc}", "\u{b721}", "\u{1104}\u{1172}\u{11bc}"),
        ("\u{b722}", "\u{b722}", "\u{1104}\u{1172}\u{11bd}", "\u{b722}",
        "\u{1104}\u{1172}\u{11bd}"), ("\u{b723}", "\u{b723}", "\u{1104}\u{1172}\u{11be}",
        "\u{b723}", "\u{1104}\u{1172}\u{11be}"), ("\u{b724}", "\u{b724}",
        "\u{1104}\u{1172}\u{11bf}", "\u{b724}", "\u{1104}\u{1172}\u{11bf}"), ("\u{b725}",
        "\u{b725}", "\u{1104}\u{1172}\u{11c0}", "\u{b725}", "\u{1104}\u{1172}\u{11c0}"),
        ("\u{b726}", "\u{b726}", "\u{1104}\u{1172}\u{11c1}", "\u{b726}",
        "\u{1104}\u{1172}\u{11c1}"), ("\u{b727}", "\u{b727}", "\u{1104}\u{1172}\u{11c2}",
        "\u{b727}", "\u{1104}\u{1172}\u{11c2}"), ("\u{b728}", "\u{b728}", "\u{1104}\u{1173}",
        "\u{b728}", "\u{1104}\u{1173}"), ("\u{b729}", "\u{b729}", "\u{1104}\u{1173}\u{11a8}",
        "\u{b729}", "\u{1104}\u{1173}\u{11a8}"), ("\u{b72a}", "\u{b72a}",
        "\u{1104}\u{1173}\u{11a9}", "\u{b72a}", "\u{1104}\u{1173}\u{11a9}"), ("\u{b72b}",
        "\u{b72b}", "\u{1104}\u{1173}\u{11aa}", "\u{b72b}", "\u{1104}\u{1173}\u{11aa}"),
        ("\u{b72c}", "\u{b72c}", "\u{1104}\u{1173}\u{11ab}", "\u{b72c}",
        "\u{1104}\u{1173}\u{11ab}"), ("\u{b72d}", "\u{b72d}", "\u{1104}\u{1173}\u{11ac}",
        "\u{b72d}", "\u{1104}\u{1173}\u{11ac}"), ("\u{b72e}", "\u{b72e}",
        "\u{1104}\u{1173}\u{11ad}", "\u{b72e}", "\u{1104}\u{1173}\u{11ad}"), ("\u{b72f}",
        "\u{b72f}", "\u{1104}\u{1173}\u{11ae}", "\u{b72f}", "\u{1104}\u{1173}\u{11ae}"),
        ("\u{b730}", "\u{b730}", "\u{1104}\u{1173}\u{11af}", "\u{b730}",
        "\u{1104}\u{1173}\u{11af}"), ("\u{b731}", "\u{b731}", "\u{1104}\u{1173}\u{11b0}",
        "\u{b731}", "\u{1104}\u{1173}\u{11b0}"), ("\u{b732}", "\u{b732}",
        "\u{1104}\u{1173}\u{11b1}", "\u{b732}", "\u{1104}\u{1173}\u{11b1}"), ("\u{b733}",
        "\u{b733}", "\u{1104}\u{1173}\u{11b2}", "\u{b733}", "\u{1104}\u{1173}\u{11b2}"),
        ("\u{b734}", "\u{b734}", "\u{1104}\u{1173}\u{11b3}", "\u{b734}",
        "\u{1104}\u{1173}\u{11b3}"), ("\u{b735}", "\u{b735}", "\u{1104}\u{1173}\u{11b4}",
        "\u{b735}", "\u{1104}\u{1173}\u{11b4}"), ("\u{b736}", "\u{b736}",
        "\u{1104}\u{1173}\u{11b5}", "\u{b736}", "\u{1104}\u{1173}\u{11b5}"), ("\u{b737}",
        "\u{b737}", "\u{1104}\u{1173}\u{11b6}", "\u{b737}", "\u{1104}\u{1173}\u{11b6}"),
        ("\u{b738}", "\u{b738}", "\u{1104}\u{1173}\u{11b7}", "\u{b738}",
        "\u{1104}\u{1173}\u{11b7}"), ("\u{b739}", "\u{b739}", "\u{1104}\u{1173}\u{11b8}",
        "\u{b739}", "\u{1104}\u{1173}\u{11b8}"), ("\u{b73a}", "\u{b73a}",
        "\u{1104}\u{1173}\u{11b9}", "\u{b73a}", "\u{1104}\u{1173}\u{11b9}"), ("\u{b73b}",
        "\u{b73b}", "\u{1104}\u{1173}\u{11ba}", "\u{b73b}", "\u{1104}\u{1173}\u{11ba}"),
        ("\u{b73c}", "\u{b73c}", "\u{1104}\u{1173}\u{11bb}", "\u{b73c}",
        "\u{1104}\u{1173}\u{11bb}"), ("\u{b73d}", "\u{b73d}", "\u{1104}\u{1173}\u{11bc}",
        "\u{b73d}", "\u{1104}\u{1173}\u{11bc}"), ("\u{b73e}", "\u{b73e}",
        "\u{1104}\u{1173}\u{11bd}", "\u{b73e}", "\u{1104}\u{1173}\u{11bd}"), ("\u{b73f}",
        "\u{b73f}", "\u{1104}\u{1173}\u{11be}", "\u{b73f}", "\u{1104}\u{1173}\u{11be}"),
        ("\u{b740}", "\u{b740}", "\u{1104}\u{1173}\u{11bf}", "\u{b740}",
        "\u{1104}\u{1173}\u{11bf}"), ("\u{b741}", "\u{b741}", "\u{1104}\u{1173}\u{11c0}",
        "\u{b741}", "\u{1104}\u{1173}\u{11c0}"), ("\u{b742}", "\u{b742}",
        "\u{1104}\u{1173}\u{11c1}", "\u{b742}", "\u{1104}\u{1173}\u{11c1}"), ("\u{b743}",
        "\u{b743}", "\u{1104}\u{1173}\u{11c2}", "\u{b743}", "\u{1104}\u{1173}\u{11c2}"),
        ("\u{b744}", "\u{b744}", "\u{1104}\u{1174}", "\u{b744}", "\u{1104}\u{1174}"), ("\u{b745}",
        "\u{b745}", "\u{1104}\u{1174}\u{11a8}", "\u{b745}", "\u{1104}\u{1174}\u{11a8}"),
        ("\u{b746}", "\u{b746}", "\u{1104}\u{1174}\u{11a9}", "\u{b746}",
        "\u{1104}\u{1174}\u{11a9}"), ("\u{b747}", "\u{b747}", "\u{1104}\u{1174}\u{11aa}",
        "\u{b747}", "\u{1104}\u{1174}\u{11aa}"), ("\u{b748}", "\u{b748}",
        "\u{1104}\u{1174}\u{11ab}", "\u{b748}", "\u{1104}\u{1174}\u{11ab}"), ("\u{b749}",
        "\u{b749}", "\u{1104}\u{1174}\u{11ac}", "\u{b749}", "\u{1104}\u{1174}\u{11ac}"),
        ("\u{b74a}", "\u{b74a}", "\u{1104}\u{1174}\u{11ad}", "\u{b74a}",
        "\u{1104}\u{1174}\u{11ad}"), ("\u{b74b}", "\u{b74b}", "\u{1104}\u{1174}\u{11ae}",
        "\u{b74b}", "\u{1104}\u{1174}\u{11ae}"), ("\u{b74c}", "\u{b74c}",
        "\u{1104}\u{1174}\u{11af}", "\u{b74c}", "\u{1104}\u{1174}\u{11af}"), ("\u{b74d}",
        "\u{b74d}", "\u{1104}\u{1174}\u{11b0}", "\u{b74d}", "\u{1104}\u{1174}\u{11b0}"),
        ("\u{b74e}", "\u{b74e}", "\u{1104}\u{1174}\u{11b1}", "\u{b74e}",
        "\u{1104}\u{1174}\u{11b1}"), ("\u{b74f}", "\u{b74f}", "\u{1104}\u{1174}\u{11b2}",
        "\u{b74f}", "\u{1104}\u{1174}\u{11b2}"), ("\u{b750}", "\u{b750}",
        "\u{1104}\u{1174}\u{11b3}", "\u{b750}", "\u{1104}\u{1174}\u{11b3}"), ("\u{b751}",
        "\u{b751}", "\u{1104}\u{1174}\u{11b4}", "\u{b751}", "\u{1104}\u{1174}\u{11b4}"),
        ("\u{b752}", "\u{b752}", "\u{1104}\u{1174}\u{11b5}", "\u{b752}",
        "\u{1104}\u{1174}\u{11b5}"), ("\u{b753}", "\u{b753}", "\u{1104}\u{1174}\u{11b6}",
        "\u{b753}", "\u{1104}\u{1174}\u{11b6}"), ("\u{b754}", "\u{b754}",
        "\u{1104}\u{1174}\u{11b7}", "\u{b754}", "\u{1104}\u{1174}\u{11b7}"), ("\u{b755}",
        "\u{b755}", "\u{1104}\u{1174}\u{11b8}", "\u{b755}", "\u{1104}\u{1174}\u{11b8}"),
        ("\u{b756}", "\u{b756}", "\u{1104}\u{1174}\u{11b9}", "\u{b756}",
        "\u{1104}\u{1174}\u{11b9}"), ("\u{b757}", "\u{b757}", "\u{1104}\u{1174}\u{11ba}",
        "\u{b757}", "\u{1104}\u{1174}\u{11ba}"), ("\u{b758}", "\u{b758}",
        "\u{1104}\u{1174}\u{11bb}", "\u{b758}", "\u{1104}\u{1174}\u{11bb}"), ("\u{b759}",
        "\u{b759}", "\u{1104}\u{1174}\u{11bc}", "\u{b759}", "\u{1104}\u{1174}\u{11bc}"),
        ("\u{b75a}", "\u{b75a}", "\u{1104}\u{1174}\u{11bd}", "\u{b75a}",
        "\u{1104}\u{1174}\u{11bd}"), ("\u{b75b}", "\u{b75b}", "\u{1104}\u{1174}\u{11be}",
        "\u{b75b}", "\u{1104}\u{1174}\u{11be}"), ("\u{b75c}", "\u{b75c}",
        "\u{1104}\u{1174}\u{11bf}", "\u{b75c}", "\u{1104}\u{1174}\u{11bf}"), ("\u{b75d}",
        "\u{b75d}", "\u{1104}\u{1174}\u{11c0}", "\u{b75d}", "\u{1104}\u{1174}\u{11c0}"),
        ("\u{b75e}", "\u{b75e}", "\u{1104}\u{1174}\u{11c1}", "\u{b75e}",
        "\u{1104}\u{1174}\u{11c1}"), ("\u{b75f}", "\u{b75f}", "\u{1104}\u{1174}\u{11c2}",
        "\u{b75f}", "\u{1104}\u{1174}\u{11c2}"), ("\u{b760}", "\u{b760}", "\u{1104}\u{1175}",
        "\u{b760}", "\u{1104}\u{1175}"), ("\u{b761}", "\u{b761}", "\u{1104}\u{1175}\u{11a8}",
        "\u{b761}", "\u{1104}\u{1175}\u{11a8}"), ("\u{b762}", "\u{b762}",
        "\u{1104}\u{1175}\u{11a9}", "\u{b762}", "\u{1104}\u{1175}\u{11a9}"), ("\u{b763}",
        "\u{b763}", "\u{1104}\u{1175}\u{11aa}", "\u{b763}", "\u{1104}\u{1175}\u{11aa}"),
        ("\u{b764}", "\u{b764}", "\u{1104}\u{1175}\u{11ab}", "\u{b764}",
        "\u{1104}\u{1175}\u{11ab}"), ("\u{b765}", "\u{b765}", "\u{1104}\u{1175}\u{11ac}",
        "\u{b765}", "\u{1104}\u{1175}\u{11ac}"), ("\u{b766}", "\u{b766}",
        "\u{1104}\u{1175}\u{11ad}", "\u{b766}", "\u{1104}\u{1175}\u{11ad}"), ("\u{b767}",
        "\u{b767}", "\u{1104}\u{1175}\u{11ae}", "\u{b767}", "\u{1104}\u{1175}\u{11ae}"),
        ("\u{b768}", "\u{b768}", "\u{1104}\u{1175}\u{11af}", "\u{b768}",
        "\u{1104}\u{1175}\u{11af}"), ("\u{b769}", "\u{b769}", "\u{1104}\u{1175}\u{11b0}",
        "\u{b769}", "\u{1104}\u{1175}\u{11b0}"), ("\u{b76a}", "\u{b76a}",
        "\u{1104}\u{1175}\u{11b1}", "\u{b76a}", "\u{1104}\u{1175}\u{11b1}"), ("\u{b76b}",
        "\u{b76b}", "\u{1104}\u{1175}\u{11b2}", "\u{b76b}", "\u{1104}\u{1175}\u{11b2}"),
        ("\u{b76c}", "\u{b76c}", "\u{1104}\u{1175}\u{11b3}", "\u{b76c}",
        "\u{1104}\u{1175}\u{11b3}"), ("\u{b76d}", "\u{b76d}", "\u{1104}\u{1175}\u{11b4}",
        "\u{b76d}", "\u{1104}\u{1175}\u{11b4}"), ("\u{b76e}", "\u{b76e}",
        "\u{1104}\u{1175}\u{11b5}", "\u{b76e}", "\u{1104}\u{1175}\u{11b5}"), ("\u{b76f}",
        "\u{b76f}", "\u{1104}\u{1175}\u{11b6}", "\u{b76f}", "\u{1104}\u{1175}\u{11b6}"),
        ("\u{b770}", "\u{b770}", "\u{1104}\u{1175}\u{11b7}", "\u{b770}",
        "\u{1104}\u{1175}\u{11b7}"), ("\u{b771}", "\u{b771}", "\u{1104}\u{1175}\u{11b8}",
        "\u{b771}", "\u{1104}\u{1175}\u{11b8}"), ("\u{b772}", "\u{b772}",
        "\u{1104}\u{1175}\u{11b9}", "\u{b772}", "\u{1104}\u{1175}\u{11b9}"), ("\u{b773}",
        "\u{b773}", "\u{1104}\u{1175}\u{11ba}", "\u{b773}", "\u{1104}\u{1175}\u{11ba}"),
        ("\u{b774}", "\u{b774}", "\u{1104}\u{1175}\u{11bb}", "\u{b774}",
        "\u{1104}\u{1175}\u{11bb}"), ("\u{b775}", "\u{b775}", "\u{1104}\u{1175}\u{11bc}",
        "\u{b775}", "\u{1104}\u{1175}\u{11bc}"), ("\u{b776}", "\u{b776}",
        "\u{1104}\u{1175}\u{11bd}", "\u{b776}", "\u{1104}\u{1175}\u{11bd}"), ("\u{b777}",
        "\u{b777}", "\u{1104}\u{1175}\u{11be}", "\u{b777}", "\u{1104}\u{1175}\u{11be}"),
        ("\u{b778}", "\u{b778}", "\u{1104}\u{1175}\u{11bf}", "\u{b778}",
        "\u{1104}\u{1175}\u{11bf}"), ("\u{b779}", "\u{b779}", "\u{1104}\u{1175}\u{11c0}",
        "\u{b779}", "\u{1104}\u{1175}\u{11c0}"), ("\u{b77a}", "\u{b77a}",
        "\u{1104}\u{1175}\u{11c1}", "\u{b77a}", "\u{1104}\u{1175}\u{11c1}"), ("\u{b77b}",
        "\u{b77b}", "\u{1104}\u{1175}\u{11c2}", "\u{b77b}", "\u{1104}\u{1175}\u{11c2}"),
        ("\u{b77c}", "\u{b77c}", "\u{1105}\u{1161}", "\u{b77c}", "\u{1105}\u{1161}"), ("\u{b77d}",
        "\u{b77d}", "\u{1105}\u{1161}\u{11a8}", "\u{b77d}", "\u{1105}\u{1161}\u{11a8}"),
        ("\u{b77e}", "\u{b77e}", "\u{1105}\u{1161}\u{11a9}", "\u{b77e}",
        "\u{1105}\u{1161}\u{11a9}"), ("\u{b77f}", "\u{b77f}", "\u{1105}\u{1161}\u{11aa}",
        "\u{b77f}", "\u{1105}\u{1161}\u{11aa}"), ("\u{b780}", "\u{b780}",
        "\u{1105}\u{1161}\u{11ab}", "\u{b780}", "\u{1105}\u{1161}\u{11ab}"), ("\u{b781}",
        "\u{b781}", "\u{1105}\u{1161}\u{11ac}", "\u{b781}", "\u{1105}\u{1161}\u{11ac}"),
        ("\u{b782}", "\u{b782}", "\u{1105}\u{1161}\u{11ad}", "\u{b782}",
        "\u{1105}\u{1161}\u{11ad}"), ("\u{b783}", "\u{b783}", "\u{1105}\u{1161}\u{11ae}",
        "\u{b783}", "\u{1105}\u{1161}\u{11ae}"), ("\u{b784}", "\u{b784}",
        "\u{1105}\u{1161}\u{11af}", "\u{b784}", "\u{1105}\u{1161}\u{11af}"), ("\u{b785}",
        "\u{b785}", "\u{1105}\u{1161}\u{11b0}", "\u{b785}", "\u{1105}\u{1161}\u{11b0}"),
        ("\u{b786}", "\u{b786}", "\u{1105}\u{1161}\u{11b1}", "\u{b786}",
        "\u{1105}\u{1161}\u{11b1}"), ("\u{b787}", "\u{b787}", "\u{1105}\u{1161}\u{11b2}",
        "\u{b787}", "\u{1105}\u{1161}\u{11b2}"), ("\u{b788}", "\u{b788}",
        "\u{1105}\u{1161}\u{11b3}", "\u{b788}", "\u{1105}\u{1161}\u{11b3}"), ("\u{b789}",
        "\u{b789}", "\u{1105}\u{1161}\u{11b4}", "\u{b789}", "\u{1105}\u{1161}\u{11b4}"),
        ("\u{b78a}", "\u{b78a}", "\u{1105}\u{1161}\u{11b5}", "\u{b78a}",
        "\u{1105}\u{1161}\u{11b5}"), ("\u{b78b}", "\u{b78b}", "\u{1105}\u{1161}\u{11b6}",
        "\u{b78b}", "\u{1105}\u{1161}\u{11b6}"), ("\u{b78c}", "\u{b78c}",
        "\u{1105}\u{1161}\u{11b7}", "\u{b78c}", "\u{1105}\u{1161}\u{11b7}"), ("\u{b78d}",
        "\u{b78d}", "\u{1105}\u{1161}\u{11b8}", "\u{b78d}", "\u{1105}\u{1161}\u{11b8}"),
        ("\u{b78e}", "\u{b78e}", "\u{1105}\u{1161}\u{11b9}", "\u{b78e}",
        "\u{1105}\u{1161}\u{11b9}"), ("\u{b78f}", "\u{b78f}", "\u{1105}\u{1161}\u{11ba}",
        "\u{b78f}", "\u{1105}\u{1161}\u{11ba}"), ("\u{b790}", "\u{b790}",
        "\u{1105}\u{1161}\u{11bb}", "\u{b790}", "\u{1105}\u{1161}\u{11bb}"), ("\u{b791}",
        "\u{b791}", "\u{1105}\u{1161}\u{11bc}", "\u{b791}", "\u{1105}\u{1161}\u{11bc}"),
        ("\u{b792}", "\u{b792}", "\u{1105}\u{1161}\u{11bd}", "\u{b792}",
        "\u{1105}\u{1161}\u{11bd}"), ("\u{b793}", "\u{b793}", "\u{1105}\u{1161}\u{11be}",
        "\u{b793}", "\u{1105}\u{1161}\u{11be}"), ("\u{b794}", "\u{b794}",
        "\u{1105}\u{1161}\u{11bf}", "\u{b794}", "\u{1105}\u{1161}\u{11bf}"), ("\u{b795}",
        "\u{b795}", "\u{1105}\u{1161}\u{11c0}", "\u{b795}", "\u{1105}\u{1161}\u{11c0}"),
        ("\u{b796}", "\u{b796}", "\u{1105}\u{1161}\u{11c1}", "\u{b796}",
        "\u{1105}\u{1161}\u{11c1}"), ("\u{b797}", "\u{b797}", "\u{1105}\u{1161}\u{11c2}",
        "\u{b797}", "\u{1105}\u{1161}\u{11c2}"), ("\u{b798}", "\u{b798}", "\u{1105}\u{1162}",
        "\u{b798}", "\u{1105}\u{1162}"), ("\u{b799}", "\u{b799}", "\u{1105}\u{1162}\u{11a8}",
        "\u{b799}", "\u{1105}\u{1162}\u{11a8}"), ("\u{b79a}", "\u{b79a}",
        "\u{1105}\u{1162}\u{11a9}", "\u{b79a}", "\u{1105}\u{1162}\u{11a9}"), ("\u{b79b}",
        "\u{b79b}", "\u{1105}\u{1162}\u{11aa}", "\u{b79b}", "\u{1105}\u{1162}\u{11aa}"),
        ("\u{b79c}", "\u{b79c}", "\u{1105}\u{1162}\u{11ab}", "\u{b79c}",
        "\u{1105}\u{1162}\u{11ab}"), ("\u{b79d}", "\u{b79d}", "\u{1105}\u{1162}\u{11ac}",
        "\u{b79d}", "\u{1105}\u{1162}\u{11ac}"), ("\u{b79e}", "\u{b79e}",
        "\u{1105}\u{1162}\u{11ad}", "\u{b79e}", "\u{1105}\u{1162}\u{11ad}"), ("\u{b79f}",
        "\u{b79f}", "\u{1105}\u{1162}\u{11ae}", "\u{b79f}", "\u{1105}\u{1162}\u{11ae}"),
        ("\u{b7a0}", "\u{b7a0}", "\u{1105}\u{1162}\u{11af}", "\u{b7a0}",
        "\u{1105}\u{1162}\u{11af}"), ("\u{b7a1}", "\u{b7a1}", "\u{1105}\u{1162}\u{11b0}",
        "\u{b7a1}", "\u{1105}\u{1162}\u{11b0}"), ("\u{b7a2}", "\u{b7a2}",
        "\u{1105}\u{1162}\u{11b1}", "\u{b7a2}", "\u{1105}\u{1162}\u{11b1}"), ("\u{b7a3}",
        "\u{b7a3}", "\u{1105}\u{1162}\u{11b2}", "\u{b7a3}", "\u{1105}\u{1162}\u{11b2}"),
        ("\u{b7a4}", "\u{b7a4}", "\u{1105}\u{1162}\u{11b3}", "\u{b7a4}",
        "\u{1105}\u{1162}\u{11b3}"), ("\u{b7a5}", "\u{b7a5}", "\u{1105}\u{1162}\u{11b4}",
        "\u{b7a5}", "\u{1105}\u{1162}\u{11b4}"), ("\u{b7a6}", "\u{b7a6}",
        "\u{1105}\u{1162}\u{11b5}", "\u{b7a6}", "\u{1105}\u{1162}\u{11b5}"), ("\u{b7a7}",
        "\u{b7a7}", "\u{1105}\u{1162}\u{11b6}", "\u{b7a7}", "\u{1105}\u{1162}\u{11b6}"),
        ("\u{b7a8}", "\u{b7a8}", "\u{1105}\u{1162}\u{11b7}", "\u{b7a8}",
        "\u{1105}\u{1162}\u{11b7}"), ("\u{b7a9}", "\u{b7a9}", "\u{1105}\u{1162}\u{11b8}",
        "\u{b7a9}", "\u{1105}\u{1162}\u{11b8}"), ("\u{b7aa}", "\u{b7aa}",
        "\u{1105}\u{1162}\u{11b9}", "\u{b7aa}", "\u{1105}\u{1162}\u{11b9}"), ("\u{b7ab}",
        "\u{b7ab}", "\u{1105}\u{1162}\u{11ba}", "\u{b7ab}", "\u{1105}\u{1162}\u{11ba}"),
        ("\u{b7ac}", "\u{b7ac}", "\u{1105}\u{1162}\u{11bb}", "\u{b7ac}",
        "\u{1105}\u{1162}\u{11bb}"), ("\u{b7ad}", "\u{b7ad}", "\u{1105}\u{1162}\u{11bc}",
        "\u{b7ad}", "\u{1105}\u{1162}\u{11bc}"), ("\u{b7ae}", "\u{b7ae}",
        "\u{1105}\u{1162}\u{11bd}", "\u{b7ae}", "\u{1105}\u{1162}\u{11bd}"), ("\u{b7af}",
        "\u{b7af}", "\u{1105}\u{1162}\u{11be}", "\u{b7af}", "\u{1105}\u{1162}\u{11be}"),
        ("\u{b7b0}", "\u{b7b0}", "\u{1105}\u{1162}\u{11bf}", "\u{b7b0}",
        "\u{1105}\u{1162}\u{11bf}"), ("\u{b7b1}", "\u{b7b1}", "\u{1105}\u{1162}\u{11c0}",
        "\u{b7b1}", "\u{1105}\u{1162}\u{11c0}"), ("\u{b7b2}", "\u{b7b2}",
        "\u{1105}\u{1162}\u{11c1}", "\u{b7b2}", "\u{1105}\u{1162}\u{11c1}"), ("\u{b7b3}",
        "\u{b7b3}", "\u{1105}\u{1162}\u{11c2}", "\u{b7b3}", "\u{1105}\u{1162}\u{11c2}"),
        ("\u{b7b4}", "\u{b7b4}", "\u{1105}\u{1163}", "\u{b7b4}", "\u{1105}\u{1163}"), ("\u{b7b5}",
        "\u{b7b5}", "\u{1105}\u{1163}\u{11a8}", "\u{b7b5}", "\u{1105}\u{1163}\u{11a8}"),
        ("\u{b7b6}", "\u{b7b6}", "\u{1105}\u{1163}\u{11a9}", "\u{b7b6}",
        "\u{1105}\u{1163}\u{11a9}"), ("\u{b7b7}", "\u{b7b7}", "\u{1105}\u{1163}\u{11aa}",
        "\u{b7b7}", "\u{1105}\u{1163}\u{11aa}"), ("\u{b7b8}", "\u{b7b8}",
        "\u{1105}\u{1163}\u{11ab}", "\u{b7b8}", "\u{1105}\u{1163}\u{11ab}"), ("\u{b7b9}",
        "\u{b7b9}", "\u{1105}\u{1163}\u{11ac}", "\u{b7b9}", "\u{1105}\u{1163}\u{11ac}"),
        ("\u{b7ba}", "\u{b7ba}", "\u{1105}\u{1163}\u{11ad}", "\u{b7ba}",
        "\u{1105}\u{1163}\u{11ad}"), ("\u{b7bb}", "\u{b7bb}", "\u{1105}\u{1163}\u{11ae}",
        "\u{b7bb}", "\u{1105}\u{1163}\u{11ae}"), ("\u{b7bc}", "\u{b7bc}",
        "\u{1105}\u{1163}\u{11af}", "\u{b7bc}", "\u{1105}\u{1163}\u{11af}"), ("\u{b7bd}",
        "\u{b7bd}", "\u{1105}\u{1163}\u{11b0}", "\u{b7bd}", "\u{1105}\u{1163}\u{11b0}"),
        ("\u{b7be}", "\u{b7be}", "\u{1105}\u{1163}\u{11b1}", "\u{b7be}",
        "\u{1105}\u{1163}\u{11b1}"), ("\u{b7bf}", "\u{b7bf}", "\u{1105}\u{1163}\u{11b2}",
        "\u{b7bf}", "\u{1105}\u{1163}\u{11b2}"), ("\u{b7c0}", "\u{b7c0}",
        "\u{1105}\u{1163}\u{11b3}", "\u{b7c0}", "\u{1105}\u{1163}\u{11b3}"), ("\u{b7c1}",
        "\u{b7c1}", "\u{1105}\u{1163}\u{11b4}", "\u{b7c1}", "\u{1105}\u{1163}\u{11b4}"),
        ("\u{b7c2}", "\u{b7c2}", "\u{1105}\u{1163}\u{11b5}", "\u{b7c2}",
        "\u{1105}\u{1163}\u{11b5}"), ("\u{b7c3}", "\u{b7c3}", "\u{1105}\u{1163}\u{11b6}",
        "\u{b7c3}", "\u{1105}\u{1163}\u{11b6}"), ("\u{b7c4}", "\u{b7c4}",
        "\u{1105}\u{1163}\u{11b7}", "\u{b7c4}", "\u{1105}\u{1163}\u{11b7}"), ("\u{b7c5}",
        "\u{b7c5}", "\u{1105}\u{1163}\u{11b8}", "\u{b7c5}", "\u{1105}\u{1163}\u{11b8}"),
        ("\u{b7c6}", "\u{b7c6}", "\u{1105}\u{1163}\u{11b9}", "\u{b7c6}",
        "\u{1105}\u{1163}\u{11b9}"), ("\u{b7c7}", "\u{b7c7}", "\u{1105}\u{1163}\u{11ba}",
        "\u{b7c7}", "\u{1105}\u{1163}\u{11ba}"), ("\u{b7c8}", "\u{b7c8}",
        "\u{1105}\u{1163}\u{11bb}", "\u{b7c8}", "\u{1105}\u{1163}\u{11bb}"), ("\u{b7c9}",
        "\u{b7c9}", "\u{1105}\u{1163}\u{11bc}", "\u{b7c9}", "\u{1105}\u{1163}\u{11bc}"),
        ("\u{b7ca}", "\u{b7ca}", "\u{1105}\u{1163}\u{11bd}", "\u{b7ca}",
        "\u{1105}\u{1163}\u{11bd}"), ("\u{b7cb}", "\u{b7cb}", "\u{1105}\u{1163}\u{11be}",
        "\u{b7cb}", "\u{1105}\u{1163}\u{11be}"), ("\u{b7cc}", "\u{b7cc}",
        "\u{1105}\u{1163}\u{11bf}", "\u{b7cc}", "\u{1105}\u{1163}\u{11bf}"), ("\u{b7cd}",
        "\u{b7cd}", "\u{1105}\u{1163}\u{11c0}", "\u{b7cd}", "\u{1105}\u{1163}\u{11c0}"),
        ("\u{b7ce}", "\u{b7ce}", "\u{1105}\u{1163}\u{11c1}", "\u{b7ce}",
        "\u{1105}\u{1163}\u{11c1}"), ("\u{b7cf}", "\u{b7cf}", "\u{1105}\u{1163}\u{11c2}",
        "\u{b7cf}", "\u{1105}\u{1163}\u{11c2}"), ("\u{b7d0}", "\u{b7d0}", "\u{1105}\u{1164}",
        "\u{b7d0}", "\u{1105}\u{1164}"), ("\u{b7d1}", "\u{b7d1}", "\u{1105}\u{1164}\u{11a8}",
        "\u{b7d1}", "\u{1105}\u{1164}\u{11a8}"), ("\u{b7d2}", "\u{b7d2}",
        "\u{1105}\u{1164}\u{11a9}", "\u{b7d2}", "\u{1105}\u{1164}\u{11a9}"), ("\u{b7d3}",
        "\u{b7d3}", "\u{1105}\u{1164}\u{11aa}", "\u{b7d3}", "\u{1105}\u{1164}\u{11aa}"),
        ("\u{b7d4}", "\u{b7d4}", "\u{1105}\u{1164}\u{11ab}", "\u{b7d4}",
        "\u{1105}\u{1164}\u{11ab}"), ("\u{b7d5}", "\u{b7d5}", "\u{1105}\u{1164}\u{11ac}",
        "\u{b7d5}", "\u{1105}\u{1164}\u{11ac}"), ("\u{b7d6}", "\u{b7d6}",
        "\u{1105}\u{1164}\u{11ad}", "\u{b7d6}", "\u{1105}\u{1164}\u{11ad}"), ("\u{b7d7}",
        "\u{b7d7}", "\u{1105}\u{1164}\u{11ae}", "\u{b7d7}", "\u{1105}\u{1164}\u{11ae}"),
        ("\u{b7d8}", "\u{b7d8}", "\u{1105}\u{1164}\u{11af}", "\u{b7d8}",
        "\u{1105}\u{1164}\u{11af}"), ("\u{b7d9}", "\u{b7d9}", "\u{1105}\u{1164}\u{11b0}",
        "\u{b7d9}", "\u{1105}\u{1164}\u{11b0}"), ("\u{b7da}", "\u{b7da}",
        "\u{1105}\u{1164}\u{11b1}", "\u{b7da}", "\u{1105}\u{1164}\u{11b1}"), ("\u{b7db}",
        "\u{b7db}", "\u{1105}\u{1164}\u{11b2}", "\u{b7db}", "\u{1105}\u{1164}\u{11b2}"),
        ("\u{b7dc}", "\u{b7dc}", "\u{1105}\u{1164}\u{11b3}", "\u{b7dc}",
        "\u{1105}\u{1164}\u{11b3}"), ("\u{b7dd}", "\u{b7dd}", "\u{1105}\u{1164}\u{11b4}",
        "\u{b7dd}", "\u{1105}\u{1164}\u{11b4}"), ("\u{b7de}", "\u{b7de}",
        "\u{1105}\u{1164}\u{11b5}", "\u{b7de}", "\u{1105}\u{1164}\u{11b5}"), ("\u{b7df}",
        "\u{b7df}", "\u{1105}\u{1164}\u{11b6}", "\u{b7df}", "\u{1105}\u{1164}\u{11b6}"),
        ("\u{b7e0}", "\u{b7e0}", "\u{1105}\u{1164}\u{11b7}", "\u{b7e0}",
        "\u{1105}\u{1164}\u{11b7}"), ("\u{b7e1}", "\u{b7e1}", "\u{1105}\u{1164}\u{11b8}",
        "\u{b7e1}", "\u{1105}\u{1164}\u{11b8}"), ("\u{b7e2}", "\u{b7e2}",
        "\u{1105}\u{1164}\u{11b9}", "\u{b7e2}", "\u{1105}\u{1164}\u{11b9}"), ("\u{b7e3}",
        "\u{b7e3}", "\u{1105}\u{1164}\u{11ba}", "\u{b7e3}", "\u{1105}\u{1164}\u{11ba}"),
        ("\u{b7e4}", "\u{b7e4}", "\u{1105}\u{1164}\u{11bb}", "\u{b7e4}",
        "\u{1105}\u{1164}\u{11bb}"), ("\u{b7e5}", "\u{b7e5}", "\u{1105}\u{1164}\u{11bc}",
        "\u{b7e5}", "\u{1105}\u{1164}\u{11bc}"), ("\u{b7e6}", "\u{b7e6}",
        "\u{1105}\u{1164}\u{11bd}", "\u{b7e6}", "\u{1105}\u{1164}\u{11bd}"), ("\u{b7e7}",
        "\u{b7e7}", "\u{1105}\u{1164}\u{11be}", "\u{b7e7}", "\u{1105}\u{1164}\u{11be}"),
        ("\u{b7e8}", "\u{b7e8}", "\u{1105}\u{1164}\u{11bf}", "\u{b7e8}",
        "\u{1105}\u{1164}\u{11bf}"), ("\u{b7e9}", "\u{b7e9}", "\u{1105}\u{1164}\u{11c0}",
        "\u{b7e9}", "\u{1105}\u{1164}\u{11c0}"), ("\u{b7ea}", "\u{b7ea}",
        "\u{1105}\u{1164}\u{11c1}", "\u{b7ea}", "\u{1105}\u{1164}\u{11c1}"), ("\u{b7eb}",
        "\u{b7eb}", "\u{1105}\u{1164}\u{11c2}", "\u{b7eb}", "\u{1105}\u{1164}\u{11c2}"),
        ("\u{b7ec}", "\u{b7ec}", "\u{1105}\u{1165}", "\u{b7ec}", "\u{1105}\u{1165}"), ("\u{b7ed}",
        "\u{b7ed}", "\u{1105}\u{1165}\u{11a8}", "\u{b7ed}", "\u{1105}\u{1165}\u{11a8}"),
        ("\u{b7ee}", "\u{b7ee}", "\u{1105}\u{1165}\u{11a9}", "\u{b7ee}",
        "\u{1105}\u{1165}\u{11a9}"), ("\u{b7ef}", "\u{b7ef}", "\u{1105}\u{1165}\u{11aa}",
        "\u{b7ef}", "\u{1105}\u{1165}\u{11aa}"), ("\u{b7f0}", "\u{b7f0}",
        "\u{1105}\u{1165}\u{11ab}", "\u{b7f0}", "\u{1105}\u{1165}\u{11ab}"), ("\u{b7f1}",
        "\u{b7f1}", "\u{1105}\u{1165}\u{11ac}", "\u{b7f1}", "\u{1105}\u{1165}\u{11ac}"),
        ("\u{b7f2}", "\u{b7f2}", "\u{1105}\u{1165}\u{11ad}", "\u{b7f2}",
        "\u{1105}\u{1165}\u{11ad}"), ("\u{b7f3}", "\u{b7f3}", "\u{1105}\u{1165}\u{11ae}",
        "\u{b7f3}", "\u{1105}\u{1165}\u{11ae}"), ("\u{b7f4}", "\u{b7f4}",
        "\u{1105}\u{1165}\u{11af}", "\u{b7f4}", "\u{1105}\u{1165}\u{11af}"), ("\u{b7f5}",
        "\u{b7f5}", "\u{1105}\u{1165}\u{11b0}", "\u{b7f5}", "\u{1105}\u{1165}\u{11b0}"),
        ("\u{b7f6}", "\u{b7f6}", "\u{1105}\u{1165}\u{11b1}", "\u{b7f6}",
        "\u{1105}\u{1165}\u{11b1}"), ("\u{b7f7}", "\u{b7f7}", "\u{1105}\u{1165}\u{11b2}",
        "\u{b7f7}", "\u{1105}\u{1165}\u{11b2}"), ("\u{b7f8}", "\u{b7f8}",
        "\u{1105}\u{1165}\u{11b3}", "\u{b7f8}", "\u{1105}\u{1165}\u{11b3}"), ("\u{b7f9}",
        "\u{b7f9}", "\u{1105}\u{1165}\u{11b4}", "\u{b7f9}", "\u{1105}\u{1165}\u{11b4}"),
        ("\u{b7fa}", "\u{b7fa}", "\u{1105}\u{1165}\u{11b5}", "\u{b7fa}",
        "\u{1105}\u{1165}\u{11b5}"), ("\u{b7fb}", "\u{b7fb}", "\u{1105}\u{1165}\u{11b6}",
        "\u{b7fb}", "\u{1105}\u{1165}\u{11b6}"), ("\u{b7fc}", "\u{b7fc}",
        "\u{1105}\u{1165}\u{11b7}", "\u{b7fc}", "\u{1105}\u{1165}\u{11b7}"), ("\u{b7fd}",
        "\u{b7fd}", "\u{1105}\u{1165}\u{11b8}", "\u{b7fd}", "\u{1105}\u{1165}\u{11b8}"),
        ("\u{b7fe}", "\u{b7fe}", "\u{1105}\u{1165}\u{11b9}", "\u{b7fe}",
        "\u{1105}\u{1165}\u{11b9}"), ("\u{b7ff}", "\u{b7ff}", "\u{1105}\u{1165}\u{11ba}",
        "\u{b7ff}", "\u{1105}\u{1165}\u{11ba}"), ("\u{b800}", "\u{b800}",
        "\u{1105}\u{1165}\u{11bb}", "\u{b800}", "\u{1105}\u{1165}\u{11bb}"), ("\u{b801}",
        "\u{b801}", "\u{1105}\u{1165}\u{11bc}", "\u{b801}", "\u{1105}\u{1165}\u{11bc}"),
        ("\u{b802}", "\u{b802}", "\u{1105}\u{1165}\u{11bd}", "\u{b802}",
        "\u{1105}\u{1165}\u{11bd}"), ("\u{b803}", "\u{b803}", "\u{1105}\u{1165}\u{11be}",
        "\u{b803}", "\u{1105}\u{1165}\u{11be}"), ("\u{b804}", "\u{b804}",
        "\u{1105}\u{1165}\u{11bf}", "\u{b804}", "\u{1105}\u{1165}\u{11bf}"), ("\u{b805}",
        "\u{b805}", "\u{1105}\u{1165}\u{11c0}", "\u{b805}", "\u{1105}\u{1165}\u{11c0}"),
        ("\u{b806}", "\u{b806}", "\u{1105}\u{1165}\u{11c1}", "\u{b806}",
        "\u{1105}\u{1165}\u{11c1}"), ("\u{b807}", "\u{b807}", "\u{1105}\u{1165}\u{11c2}",
        "\u{b807}", "\u{1105}\u{1165}\u{11c2}"), ("\u{b808}", "\u{b808}", "\u{1105}\u{1166}",
        "\u{b808}", "\u{1105}\u{1166}"), ("\u{b809}", "\u{b809}", "\u{1105}\u{1166}\u{11a8}",
        "\u{b809}", "\u{1105}\u{1166}\u{11a8}"), ("\u{b80a}", "\u{b80a}",
        "\u{1105}\u{1166}\u{11a9}", "\u{b80a}", "\u{1105}\u{1166}\u{11a9}"), ("\u{b80b}",
        "\u{b80b}", "\u{1105}\u{1166}\u{11aa}", "\u{b80b}", "\u{1105}\u{1166}\u{11aa}"),
        ("\u{b80c}", "\u{b80c}", "\u{1105}\u{1166}\u{11ab}", "\u{b80c}",
        "\u{1105}\u{1166}\u{11ab}"), ("\u{b80d}", "\u{b80d}", "\u{1105}\u{1166}\u{11ac}",
        "\u{b80d}", "\u{1105}\u{1166}\u{11ac}"), ("\u{b80e}", "\u{b80e}",
        "\u{1105}\u{1166}\u{11ad}", "\u{b80e}", "\u{1105}\u{1166}\u{11ad}"), ("\u{b80f}",
        "\u{b80f}", "\u{1105}\u{1166}\u{11ae}", "\u{b80f}", "\u{1105}\u{1166}\u{11ae}"),
        ("\u{b810}", "\u{b810}", "\u{1105}\u{1166}\u{11af}", "\u{b810}",
        "\u{1105}\u{1166}\u{11af}"), ("\u{b811}", "\u{b811}", "\u{1105}\u{1166}\u{11b0}",
        "\u{b811}", "\u{1105}\u{1166}\u{11b0}"), ("\u{b812}", "\u{b812}",
        "\u{1105}\u{1166}\u{11b1}", "\u{b812}", "\u{1105}\u{1166}\u{11b1}"), ("\u{b813}",
        "\u{b813}", "\u{1105}\u{1166}\u{11b2}", "\u{b813}", "\u{1105}\u{1166}\u{11b2}"),
        ("\u{b814}", "\u{b814}", "\u{1105}\u{1166}\u{11b3}", "\u{b814}",
        "\u{1105}\u{1166}\u{11b3}"), ("\u{b815}", "\u{b815}", "\u{1105}\u{1166}\u{11b4}",
        "\u{b815}", "\u{1105}\u{1166}\u{11b4}"), ("\u{b816}", "\u{b816}",
        "\u{1105}\u{1166}\u{11b5}", "\u{b816}", "\u{1105}\u{1166}\u{11b5}"), ("\u{b817}",
        "\u{b817}", "\u{1105}\u{1166}\u{11b6}", "\u{b817}", "\u{1105}\u{1166}\u{11b6}"),
        ("\u{b818}", "\u{b818}", "\u{1105}\u{1166}\u{11b7}", "\u{b818}",
        "\u{1105}\u{1166}\u{11b7}"), ("\u{b819}", "\u{b819}", "\u{1105}\u{1166}\u{11b8}",
        "\u{b819}", "\u{1105}\u{1166}\u{11b8}"), ("\u{b81a}", "\u{b81a}",
        "\u{1105}\u{1166}\u{11b9}", "\u{b81a}", "\u{1105}\u{1166}\u{11b9}"), ("\u{b81b}",
        "\u{b81b}", "\u{1105}\u{1166}\u{11ba}", "\u{b81b}", "\u{1105}\u{1166}\u{11ba}"),
        ("\u{b81c}", "\u{b81c}", "\u{1105}\u{1166}\u{11bb}", "\u{b81c}",
        "\u{1105}\u{1166}\u{11bb}"), ("\u{b81d}", "\u{b81d}", "\u{1105}\u{1166}\u{11bc}",
        "\u{b81d}", "\u{1105}\u{1166}\u{11bc}"), ("\u{b81e}", "\u{b81e}",
        "\u{1105}\u{1166}\u{11bd}", "\u{b81e}", "\u{1105}\u{1166}\u{11bd}"), ("\u{b81f}",
        "\u{b81f}", "\u{1105}\u{1166}\u{11be}", "\u{b81f}", "\u{1105}\u{1166}\u{11be}"),
        ("\u{b820}", "\u{b820}", "\u{1105}\u{1166}\u{11bf}", "\u{b820}",
        "\u{1105}\u{1166}\u{11bf}"), ("\u{b821}", "\u{b821}", "\u{1105}\u{1166}\u{11c0}",
        "\u{b821}", "\u{1105}\u{1166}\u{11c0}"), ("\u{b822}", "\u{b822}",
        "\u{1105}\u{1166}\u{11c1}", "\u{b822}", "\u{1105}\u{1166}\u{11c1}"), ("\u{b823}",
        "\u{b823}", "\u{1105}\u{1166}\u{11c2}", "\u{b823}", "\u{1105}\u{1166}\u{11c2}"),
        ("\u{b824}", "\u{b824}", "\u{1105}\u{1167}", "\u{b824}", "\u{1105}\u{1167}"), ("\u{b825}",
        "\u{b825}", "\u{1105}\u{1167}\u{11a8}", "\u{b825}", "\u{1105}\u{1167}\u{11a8}"),
        ("\u{b826}", "\u{b826}", "\u{1105}\u{1167}\u{11a9}", "\u{b826}",
        "\u{1105}\u{1167}\u{11a9}"), ("\u{b827}", "\u{b827}", "\u{1105}\u{1167}\u{11aa}",
        "\u{b827}", "\u{1105}\u{1167}\u{11aa}"), ("\u{b828}", "\u{b828}",
        "\u{1105}\u{1167}\u{11ab}", "\u{b828}", "\u{1105}\u{1167}\u{11ab}"), ("\u{b829}",
        "\u{b829}", "\u{1105}\u{1167}\u{11ac}", "\u{b829}", "\u{1105}\u{1167}\u{11ac}"),
        ("\u{b82a}", "\u{b82a}", "\u{1105}\u{1167}\u{11ad}", "\u{b82a}",
        "\u{1105}\u{1167}\u{11ad}"), ("\u{b82b}", "\u{b82b}", "\u{1105}\u{1167}\u{11ae}",
        "\u{b82b}", "\u{1105}\u{1167}\u{11ae}"), ("\u{b82c}", "\u{b82c}",
        "\u{1105}\u{1167}\u{11af}", "\u{b82c}", "\u{1105}\u{1167}\u{11af}"), ("\u{b82d}",
        "\u{b82d}", "\u{1105}\u{1167}\u{11b0}", "\u{b82d}", "\u{1105}\u{1167}\u{11b0}"),
        ("\u{b82e}", "\u{b82e}", "\u{1105}\u{1167}\u{11b1}", "\u{b82e}",
        "\u{1105}\u{1167}\u{11b1}"), ("\u{b82f}", "\u{b82f}", "\u{1105}\u{1167}\u{11b2}",
        "\u{b82f}", "\u{1105}\u{1167}\u{11b2}"), ("\u{b830}", "\u{b830}",
        "\u{1105}\u{1167}\u{11b3}", "\u{b830}", "\u{1105}\u{1167}\u{11b3}"), ("\u{b831}",
        "\u{b831}", "\u{1105}\u{1167}\u{11b4}", "\u{b831}", "\u{1105}\u{1167}\u{11b4}"),
        ("\u{b832}", "\u{b832}", "\u{1105}\u{1167}\u{11b5}", "\u{b832}",
        "\u{1105}\u{1167}\u{11b5}"), ("\u{b833}", "\u{b833}", "\u{1105}\u{1167}\u{11b6}",
        "\u{b833}", "\u{1105}\u{1167}\u{11b6}"), ("\u{b834}", "\u{b834}",
        "\u{1105}\u{1167}\u{11b7}", "\u{b834}", "\u{1105}\u{1167}\u{11b7}"), ("\u{b835}",
        "\u{b835}", "\u{1105}\u{1167}\u{11b8}", "\u{b835}", "\u{1105}\u{1167}\u{11b8}"),
        ("\u{b836}", "\u{b836}", "\u{1105}\u{1167}\u{11b9}", "\u{b836}",
        "\u{1105}\u{1167}\u{11b9}"), ("\u{b837}", "\u{b837}", "\u{1105}\u{1167}\u{11ba}",
        "\u{b837}", "\u{1105}\u{1167}\u{11ba}"), ("\u{b838}", "\u{b838}",
        "\u{1105}\u{1167}\u{11bb}", "\u{b838}", "\u{1105}\u{1167}\u{11bb}"), ("\u{b839}",
        "\u{b839}", "\u{1105}\u{1167}\u{11bc}", "\u{b839}", "\u{1105}\u{1167}\u{11bc}"),
        ("\u{b83a}", "\u{b83a}", "\u{1105}\u{1167}\u{11bd}", "\u{b83a}",
        "\u{1105}\u{1167}\u{11bd}"), ("\u{b83b}", "\u{b83b}", "\u{1105}\u{1167}\u{11be}",
        "\u{b83b}", "\u{1105}\u{1167}\u{11be}"), ("\u{b83c}", "\u{b83c}",
        "\u{1105}\u{1167}\u{11bf}", "\u{b83c}", "\u{1105}\u{1167}\u{11bf}"), ("\u{b83d}",
        "\u{b83d}", "\u{1105}\u{1167}\u{11c0}", "\u{b83d}", "\u{1105}\u{1167}\u{11c0}"),
        ("\u{b83e}", "\u{b83e}", "\u{1105}\u{1167}\u{11c1}", "\u{b83e}",
        "\u{1105}\u{1167}\u{11c1}"), ("\u{b83f}", "\u{b83f}", "\u{1105}\u{1167}\u{11c2}",
        "\u{b83f}", "\u{1105}\u{1167}\u{11c2}"), ("\u{b840}", "\u{b840}", "\u{1105}\u{1168}",
        "\u{b840}", "\u{1105}\u{1168}"), ("\u{b841}", "\u{b841}", "\u{1105}\u{1168}\u{11a8}",
        "\u{b841}", "\u{1105}\u{1168}\u{11a8}"), ("\u{b842}", "\u{b842}",
        "\u{1105}\u{1168}\u{11a9}", "\u{b842}", "\u{1105}\u{1168}\u{11a9}"), ("\u{b843}",
        "\u{b843}", "\u{1105}\u{1168}\u{11aa}", "\u{b843}", "\u{1105}\u{1168}\u{11aa}"),
        ("\u{b844}", "\u{b844}", "\u{1105}\u{1168}\u{11ab}", "\u{b844}",
        "\u{1105}\u{1168}\u{11ab}"), ("\u{b845}", "\u{b845}", "\u{1105}\u{1168}\u{11ac}",
        "\u{b845}", "\u{1105}\u{1168}\u{11ac}"), ("\u{b846}", "\u{b846}",
        "\u{1105}\u{1168}\u{11ad}", "\u{b846}", "\u{1105}\u{1168}\u{11ad}"), ("\u{b847}",
        "\u{b847}", "\u{1105}\u{1168}\u{11ae}", "\u{b847}", "\u{1105}\u{1168}\u{11ae}"),
        ("\u{b848}", "\u{b848}", "\u{1105}\u{1168}\u{11af}", "\u{b848}",
        "\u{1105}\u{1168}\u{11af}"), ("\u{b849}", "\u{b849}", "\u{1105}\u{1168}\u{11b0}",
        "\u{b849}", "\u{1105}\u{1168}\u{11b0}"), ("\u{b84a}", "\u{b84a}",
        "\u{1105}\u{1168}\u{11b1}", "\u{b84a}", "\u{1105}\u{1168}\u{11b1}"), ("\u{b84b}",
        "\u{b84b}", "\u{1105}\u{1168}\u{11b2}", "\u{b84b}", "\u{1105}\u{1168}\u{11b2}"),
        ("\u{b84c}", "\u{b84c}", "\u{1105}\u{1168}\u{11b3}", "\u{b84c}",
        "\u{1105}\u{1168}\u{11b3}"), ("\u{b84d}", "\u{b84d}", "\u{1105}\u{1168}\u{11b4}",
        "\u{b84d}", "\u{1105}\u{1168}\u{11b4}"), ("\u{b84e}", "\u{b84e}",
        "\u{1105}\u{1168}\u{11b5}", "\u{b84e}", "\u{1105}\u{1168}\u{11b5}"), ("\u{b84f}",
        "\u{b84f}", "\u{1105}\u{1168}\u{11b6}", "\u{b84f}", "\u{1105}\u{1168}\u{11b6}"),
        ("\u{b850}", "\u{b850}", "\u{1105}\u{1168}\u{11b7}", "\u{b850}",
        "\u{1105}\u{1168}\u{11b7}"), ("\u{b851}", "\u{b851}", "\u{1105}\u{1168}\u{11b8}",
        "\u{b851}", "\u{1105}\u{1168}\u{11b8}"), ("\u{b852}", "\u{b852}",
        "\u{1105}\u{1168}\u{11b9}", "\u{b852}", "\u{1105}\u{1168}\u{11b9}"), ("\u{b853}",
        "\u{b853}", "\u{1105}\u{1168}\u{11ba}", "\u{b853}", "\u{1105}\u{1168}\u{11ba}"),
        ("\u{b854}", "\u{b854}", "\u{1105}\u{1168}\u{11bb}", "\u{b854}",
        "\u{1105}\u{1168}\u{11bb}"), ("\u{b855}", "\u{b855}", "\u{1105}\u{1168}\u{11bc}",
        "\u{b855}", "\u{1105}\u{1168}\u{11bc}"), ("\u{b856}", "\u{b856}",
        "\u{1105}\u{1168}\u{11bd}", "\u{b856}", "\u{1105}\u{1168}\u{11bd}"), ("\u{b857}",
        "\u{b857}", "\u{1105}\u{1168}\u{11be}", "\u{b857}", "\u{1105}\u{1168}\u{11be}"),
        ("\u{b858}", "\u{b858}", "\u{1105}\u{1168}\u{11bf}", "\u{b858}",
        "\u{1105}\u{1168}\u{11bf}"), ("\u{b859}", "\u{b859}", "\u{1105}\u{1168}\u{11c0}",
        "\u{b859}", "\u{1105}\u{1168}\u{11c0}"), ("\u{b85a}", "\u{b85a}",
        "\u{1105}\u{1168}\u{11c1}", "\u{b85a}", "\u{1105}\u{1168}\u{11c1}"), ("\u{b85b}",
        "\u{b85b}", "\u{1105}\u{1168}\u{11c2}", "\u{b85b}", "\u{1105}\u{1168}\u{11c2}"),
        ("\u{b85c}", "\u{b85c}", "\u{1105}\u{1169}", "\u{b85c}", "\u{1105}\u{1169}"), ("\u{b85d}",
        "\u{b85d}", "\u{1105}\u{1169}\u{11a8}", "\u{b85d}", "\u{1105}\u{1169}\u{11a8}"),
        ("\u{b85e}", "\u{b85e}", "\u{1105}\u{1169}\u{11a9}", "\u{b85e}",
        "\u{1105}\u{1169}\u{11a9}"), ("\u{b85f}", "\u{b85f}", "\u{1105}\u{1169}\u{11aa}",
        "\u{b85f}", "\u{1105}\u{1169}\u{11aa}"), ("\u{b860}", "\u{b860}",
        "\u{1105}\u{1169}\u{11ab}", "\u{b860}", "\u{1105}\u{1169}\u{11ab}"), ("\u{b861}",
        "\u{b861}", "\u{1105}\u{1169}\u{11ac}", "\u{b861}", "\u{1105}\u{1169}\u{11ac}"),
        ("\u{b862}", "\u{b862}", "\u{1105}\u{1169}\u{11ad}", "\u{b862}",
        "\u{1105}\u{1169}\u{11ad}"), ("\u{b863}", "\u{b863}", "\u{1105}\u{1169}\u{11ae}",
        "\u{b863}", "\u{1105}\u{1169}\u{11ae}"), ("\u{b864}", "\u{b864}",
        "\u{1105}\u{1169}\u{11af}", "\u{b864}", "\u{1105}\u{1169}\u{11af}"), ("\u{b865}",
        "\u{b865}", "\u{1105}\u{1169}\u{11b0}", "\u{b865}", "\u{1105}\u{1169}\u{11b0}"),
        ("\u{b866}", "\u{b866}", "\u{1105}\u{1169}\u{11b1}", "\u{b866}",
        "\u{1105}\u{1169}\u{11b1}"), ("\u{b867}", "\u{b867}", "\u{1105}\u{1169}\u{11b2}",
        "\u{b867}", "\u{1105}\u{1169}\u{11b2}"), ("\u{b868}", "\u{b868}",
        "\u{1105}\u{1169}\u{11b3}", "\u{b868}", "\u{1105}\u{1169}\u{11b3}"), ("\u{b869}",
        "\u{b869}", "\u{1105}\u{1169}\u{11b4}", "\u{b869}", "\u{1105}\u{1169}\u{11b4}"),
        ("\u{b86a}", "\u{b86a}", "\u{1105}\u{1169}\u{11b5}", "\u{b86a}",
        "\u{1105}\u{1169}\u{11b5}"), ("\u{b86b}", "\u{b86b}", "\u{1105}\u{1169}\u{11b6}",
        "\u{b86b}", "\u{1105}\u{1169}\u{11b6}"), ("\u{b86c}", "\u{b86c}",
        "\u{1105}\u{1169}\u{11b7}", "\u{b86c}", "\u{1105}\u{1169}\u{11b7}"), ("\u{b86d}",
        "\u{b86d}", "\u{1105}\u{1169}\u{11b8}", "\u{b86d}", "\u{1105}\u{1169}\u{11b8}"),
        ("\u{b86e}", "\u{b86e}", "\u{1105}\u{1169}\u{11b9}", "\u{b86e}",
        "\u{1105}\u{1169}\u{11b9}"), ("\u{b86f}", "\u{b86f}", "\u{1105}\u{1169}\u{11ba}",
        "\u{b86f}", "\u{1105}\u{1169}\u{11ba}"), ("\u{b870}", "\u{b870}",
        "\u{1105}\u{1169}\u{11bb}", "\u{b870}", "\u{1105}\u{1169}\u{11bb}"), ("\u{b871}",
        "\u{b871}", "\u{1105}\u{1169}\u{11bc}", "\u{b871}", "\u{1105}\u{1169}\u{11bc}"),
        ("\u{b872}", "\u{b872}", "\u{1105}\u{1169}\u{11bd}", "\u{b872}",
        "\u{1105}\u{1169}\u{11bd}"), ("\u{b873}", "\u{b873}", "\u{1105}\u{1169}\u{11be}",
        "\u{b873}", "\u{1105}\u{1169}\u{11be}"), ("\u{b874}", "\u{b874}",
        "\u{1105}\u{1169}\u{11bf}", "\u{b874}", "\u{1105}\u{1169}\u{11bf}"), ("\u{b875}",
        "\u{b875}", "\u{1105}\u{1169}\u{11c0}", "\u{b875}", "\u{1105}\u{1169}\u{11c0}"),
        ("\u{b876}", "\u{b876}", "\u{1105}\u{1169}\u{11c1}", "\u{b876}",
        "\u{1105}\u{1169}\u{11c1}"), ("\u{b877}", "\u{b877}", "\u{1105}\u{1169}\u{11c2}",
        "\u{b877}", "\u{1105}\u{1169}\u{11c2}"), ("\u{b878}", "\u{b878}", "\u{1105}\u{116a}",
        "\u{b878}", "\u{1105}\u{116a}"), ("\u{b879}", "\u{b879}", "\u{1105}\u{116a}\u{11a8}",
        "\u{b879}", "\u{1105}\u{116a}\u{11a8}"), ("\u{b87a}", "\u{b87a}",
        "\u{1105}\u{116a}\u{11a9}", "\u{b87a}", "\u{1105}\u{116a}\u{11a9}"), ("\u{b87b}",
        "\u{b87b}", "\u{1105}\u{116a}\u{11aa}", "\u{b87b}", "\u{1105}\u{116a}\u{11aa}"),
        ("\u{b87c}", "\u{b87c}", "\u{1105}\u{116a}\u{11ab}", "\u{b87c}",
        "\u{1105}\u{116a}\u{11ab}"), ("\u{b87d}", "\u{b87d}", "\u{1105}\u{116a}\u{11ac}",
        "\u{b87d}", "\u{1105}\u{116a}\u{11ac}"), ("\u{b87e}", "\u{b87e}",
        "\u{1105}\u{116a}\u{11ad}", "\u{b87e}", "\u{1105}\u{116a}\u{11ad}"), ("\u{b87f}",
        "\u{b87f}", "\u{1105}\u{116a}\u{11ae}", "\u{b87f}", "\u{1105}\u{116a}\u{11ae}"),
        ("\u{b880}", "\u{b880}", "\u{1105}\u{116a}\u{11af}", "\u{b880}",
        "\u{1105}\u{116a}\u{11af}"), ("\u{b881}", "\u{b881}", "\u{1105}\u{116a}\u{11b0}",
        "\u{b881}", "\u{1105}\u{116a}\u{11b0}"), ("\u{b882}", "\u{b882}",
        "\u{1105}\u{116a}\u{11b1}", "\u{b882}", "\u{1105}\u{116a}\u{11b1}"), ("\u{b883}",
        "\u{b883}", "\u{1105}\u{116a}\u{11b2}", "\u{b883}", "\u{1105}\u{116a}\u{11b2}"),
        ("\u{b884}", "\u{b884}", "\u{1105}\u{116a}\u{11b3}", "\u{b884}",
        "\u{1105}\u{116a}\u{11b3}"), ("\u{b885}", "\u{b885}", "\u{1105}\u{116a}\u{11b4}",
        "\u{b885}", "\u{1105}\u{116a}\u{11b4}"), ("\u{b886}", "\u{b886}",
        "\u{1105}\u{116a}\u{11b5}", "\u{b886}", "\u{1105}\u{116a}\u{11b5}"), ("\u{b887}",
        "\u{b887}", "\u{1105}\u{116a}\u{11b6}", "\u{b887}", "\u{1105}\u{116a}\u{11b6}"),
        ("\u{b888}", "\u{b888}", "\u{1105}\u{116a}\u{11b7}", "\u{b888}",
        "\u{1105}\u{116a}\u{11b7}"), ("\u{b889}", "\u{b889}", "\u{1105}\u{116a}\u{11b8}",
        "\u{b889}", "\u{1105}\u{116a}\u{11b8}"), ("\u{b88a}", "\u{b88a}",
        "\u{1105}\u{116a}\u{11b9}", "\u{b88a}", "\u{1105}\u{116a}\u{11b9}"), ("\u{b88b}",
        "\u{b88b}", "\u{1105}\u{116a}\u{11ba}", "\u{b88b}", "\u{1105}\u{116a}\u{11ba}"),
        ("\u{b88c}", "\u{b88c}", "\u{1105}\u{116a}\u{11bb}", "\u{b88c}",
        "\u{1105}\u{116a}\u{11bb}"), ("\u{b88d}", "\u{b88d}", "\u{1105}\u{116a}\u{11bc}",
        "\u{b88d}", "\u{1105}\u{116a}\u{11bc}"), ("\u{b88e}", "\u{b88e}",
        "\u{1105}\u{116a}\u{11bd}", "\u{b88e}", "\u{1105}\u{116a}\u{11bd}"), ("\u{b88f}",
        "\u{b88f}", "\u{1105}\u{116a}\u{11be}", "\u{b88f}", "\u{1105}\u{116a}\u{11be}"),
        ("\u{b890}", "\u{b890}", "\u{1105}\u{116a}\u{11bf}", "\u{b890}",
        "\u{1105}\u{116a}\u{11bf}"), ("\u{b891}", "\u{b891}", "\u{1105}\u{116a}\u{11c0}",
        "\u{b891}", "\u{1105}\u{116a}\u{11c0}"), ("\u{b892}", "\u{b892}",
        "\u{1105}\u{116a}\u{11c1}", "\u{b892}", "\u{1105}\u{116a}\u{11c1}"), ("\u{b893}",
        "\u{b893}", "\u{1105}\u{116a}\u{11c2}", "\u{b893}", "\u{1105}\u{116a}\u{11c2}"),
        ("\u{b894}", "\u{b894}", "\u{1105}\u{116b}", "\u{b894}", "\u{1105}\u{116b}"), ("\u{b895}",
        "\u{b895}", "\u{1105}\u{116b}\u{11a8}", "\u{b895}", "\u{1105}\u{116b}\u{11a8}"),
        ("\u{b896}", "\u{b896}", "\u{1105}\u{116b}\u{11a9}", "\u{b896}",
        "\u{1105}\u{116b}\u{11a9}"), ("\u{b897}", "\u{b897}", "\u{1105}\u{116b}\u{11aa}",
        "\u{b897}", "\u{1105}\u{116b}\u{11aa}"), ("\u{b898}", "\u{b898}",
        "\u{1105}\u{116b}\u{11ab}", "\u{b898}", "\u{1105}\u{116b}\u{11ab}"), ("\u{b899}",
        "\u{b899}", "\u{1105}\u{116b}\u{11ac}", "\u{b899}", "\u{1105}\u{116b}\u{11ac}"),
        ("\u{b89a}", "\u{b89a}", "\u{1105}\u{116b}\u{11ad}", "\u{b89a}",
        "\u{1105}\u{116b}\u{11ad}"), ("\u{b89b}", "\u{b89b}", "\u{1105}\u{116b}\u{11ae}",
        "\u{b89b}", "\u{1105}\u{116b}\u{11ae}"), ("\u{b89c}", "\u{b89c}",
        "\u{1105}\u{116b}\u{11af}", "\u{b89c}", "\u{1105}\u{116b}\u{11af}"), ("\u{b89d}",
        "\u{b89d}", "\u{1105}\u{116b}\u{11b0}", "\u{b89d}", "\u{1105}\u{116b}\u{11b0}"),
        ("\u{b89e}", "\u{b89e}", "\u{1105}\u{116b}\u{11b1}", "\u{b89e}",
        "\u{1105}\u{116b}\u{11b1}"), ("\u{b89f}", "\u{b89f}", "\u{1105}\u{116b}\u{11b2}",
        "\u{b89f}", "\u{1105}\u{116b}\u{11b2}"), ("\u{b8a0}", "\u{b8a0}",
        "\u{1105}\u{116b}\u{11b3}", "\u{b8a0}", "\u{1105}\u{116b}\u{11b3}"), ("\u{b8a1}",
        "\u{b8a1}", "\u{1105}\u{116b}\u{11b4}", "\u{b8a1}", "\u{1105}\u{116b}\u{11b4}"),
        ("\u{b8a2}", "\u{b8a2}", "\u{1105}\u{116b}\u{11b5}", "\u{b8a2}",
        "\u{1105}\u{116b}\u{11b5}"), ("\u{b8a3}", "\u{b8a3}", "\u{1105}\u{116b}\u{11b6}",
        "\u{b8a3}", "\u{1105}\u{116b}\u{11b6}"), ("\u{b8a4}", "\u{b8a4}",
        "\u{1105}\u{116b}\u{11b7}", "\u{b8a4}", "\u{1105}\u{116b}\u{11b7}"), ("\u{b8a5}",
        "\u{b8a5}", "\u{1105}\u{116b}\u{11b8}", "\u{b8a5}", "\u{1105}\u{116b}\u{11b8}"),
        ("\u{b8a6}", "\u{b8a6}", "\u{1105}\u{116b}\u{11b9}", "\u{b8a6}",
        "\u{1105}\u{116b}\u{11b9}"), ("\u{b8a7}", "\u{b8a7}", "\u{1105}\u{116b}\u{11ba}",
        "\u{b8a7}", "\u{1105}\u{116b}\u{11ba}"), ("\u{b8a8}", "\u{b8a8}",
        "\u{1105}\u{116b}\u{11bb}", "\u{b8a8}", "\u{1105}\u{116b}\u{11bb}"), ("\u{b8a9}",
        "\u{b8a9}", "\u{1105}\u{116b}\u{11bc}", "\u{b8a9}", "\u{1105}\u{116b}\u{11bc}"),
        ("\u{b8aa}", "\u{b8aa}", "\u{1105}\u{116b}\u{11bd}", "\u{b8aa}",
        "\u{1105}\u{116b}\u{11bd}"), ("\u{b8ab}", "\u{b8ab}", "\u{1105}\u{116b}\u{11be}",
        "\u{b8ab}", "\u{1105}\u{116b}\u{11be}"), ("\u{b8ac}", "\u{b8ac}",
        "\u{1105}\u{116b}\u{11bf}", "\u{b8ac}", "\u{1105}\u{116b}\u{11bf}"), ("\u{b8ad}",
        "\u{b8ad}", "\u{1105}\u{116b}\u{11c0}", "\u{b8ad}", "\u{1105}\u{116b}\u{11c0}"),
        ("\u{b8ae}", "\u{b8ae}", "\u{1105}\u{116b}\u{11c1}", "\u{b8ae}",
        "\u{1105}\u{116b}\u{11c1}"), ("\u{b8af}", "\u{b8af}", "\u{1105}\u{116b}\u{11c2}",
        "\u{b8af}", "\u{1105}\u{116b}\u{11c2}"), ("\u{b8b0}", "\u{b8b0}", "\u{1105}\u{116c}",
        "\u{b8b0}", "\u{1105}\u{116c}"), ("\u{b8b1}", "\u{b8b1}", "\u{1105}\u{116c}\u{11a8}",
        "\u{b8b1}", "\u{1105}\u{116c}\u{11a8}"), ("\u{b8b2}", "\u{b8b2}",
        "\u{1105}\u{116c}\u{11a9}", "\u{b8b2}", "\u{1105}\u{116c}\u{11a9}"), ("\u{b8b3}",
        "\u{b8b3}", "\u{1105}\u{116c}\u{11aa}", "\u{b8b3}", "\u{1105}\u{116c}\u{11aa}"),
        ("\u{b8b4}", "\u{b8b4}", "\u{1105}\u{116c}\u{11ab}", "\u{b8b4}",
        "\u{1105}\u{116c}\u{11ab}"), ("\u{b8b5}", "\u{b8b5}", "\u{1105}\u{116c}\u{11ac}",
        "\u{b8b5}", "\u{1105}\u{116c}\u{11ac}"), ("\u{b8b6}", "\u{b8b6}",
        "\u{1105}\u{116c}\u{11ad}", "\u{b8b6}", "\u{1105}\u{116c}\u{11ad}"), ("\u{b8b7}",
        "\u{b8b7}", "\u{1105}\u{116c}\u{11ae}", "\u{b8b7}", "\u{1105}\u{116c}\u{11ae}"),
        ("\u{b8b8}", "\u{b8b8}", "\u{1105}\u{116c}\u{11af}", "\u{b8b8}",
        "\u{1105}\u{116c}\u{11af}"), ("\u{b8b9}", "\u{b8b9}", "\u{1105}\u{116c}\u{11b0}",
        "\u{b8b9}", "\u{1105}\u{116c}\u{11b0}"), ("\u{b8ba}", "\u{b8ba}",
        "\u{1105}\u{116c}\u{11b1}", "\u{b8ba}", "\u{1105}\u{116c}\u{11b1}"), ("\u{b8bb}",
        "\u{b8bb}", "\u{1105}\u{116c}\u{11b2}", "\u{b8bb}", "\u{1105}\u{116c}\u{11b2}"),
        ("\u{b8bc}", "\u{b8bc}", "\u{1105}\u{116c}\u{11b3}", "\u{b8bc}",
        "\u{1105}\u{116c}\u{11b3}"), ("\u{b8bd}", "\u{b8bd}", "\u{1105}\u{116c}\u{11b4}",
        "\u{b8bd}", "\u{1105}\u{116c}\u{11b4}"), ("\u{b8be}", "\u{b8be}",
        "\u{1105}\u{116c}\u{11b5}", "\u{b8be}", "\u{1105}\u{116c}\u{11b5}"), ("\u{b8bf}",
        "\u{b8bf}", "\u{1105}\u{116c}\u{11b6}", "\u{b8bf}", "\u{1105}\u{116c}\u{11b6}"),
        ("\u{b8c0}", "\u{b8c0}", "\u{1105}\u{116c}\u{11b7}", "\u{b8c0}",
        "\u{1105}\u{116c}\u{11b7}"), ("\u{b8c1}", "\u{b8c1}", "\u{1105}\u{116c}\u{11b8}",
        "\u{b8c1}", "\u{1105}\u{116c}\u{11b8}"), ("\u{b8c2}", "\u{b8c2}",
        "\u{1105}\u{116c}\u{11b9}", "\u{b8c2}", "\u{1105}\u{116c}\u{11b9}"), ("\u{b8c3}",
        "\u{b8c3}", "\u{1105}\u{116c}\u{11ba}", "\u{b8c3}", "\u{1105}\u{116c}\u{11ba}"),
        ("\u{b8c4}", "\u{b8c4}", "\u{1105}\u{116c}\u{11bb}", "\u{b8c4}",
        "\u{1105}\u{116c}\u{11bb}"), ("\u{b8c5}", "\u{b8c5}", "\u{1105}\u{116c}\u{11bc}",
        "\u{b8c5}", "\u{1105}\u{116c}\u{11bc}"), ("\u{b8c6}", "\u{b8c6}",
        "\u{1105}\u{116c}\u{11bd}", "\u{b8c6}", "\u{1105}\u{116c}\u{11bd}"), ("\u{b8c7}",
        "\u{b8c7}", "\u{1105}\u{116c}\u{11be}", "\u{b8c7}", "\u{1105}\u{116c}\u{11be}"),
        ("\u{b8c8}", "\u{b8c8}", "\u{1105}\u{116c}\u{11bf}", "\u{b8c8}",
        "\u{1105}\u{116c}\u{11bf}"), ("\u{b8c9}", "\u{b8c9}", "\u{1105}\u{116c}\u{11c0}",
        "\u{b8c9}", "\u{1105}\u{116c}\u{11c0}"), ("\u{b8ca}", "\u{b8ca}",
        "\u{1105}\u{116c}\u{11c1}", "\u{b8ca}", "\u{1105}\u{116c}\u{11c1}"), ("\u{b8cb}",
        "\u{b8cb}", "\u{1105}\u{116c}\u{11c2}", "\u{b8cb}", "\u{1105}\u{116c}\u{11c2}"),
        ("\u{b8cc}", "\u{b8cc}", "\u{1105}\u{116d}", "\u{b8cc}", "\u{1105}\u{116d}"), ("\u{b8cd}",
        "\u{b8cd}", "\u{1105}\u{116d}\u{11a8}", "\u{b8cd}", "\u{1105}\u{116d}\u{11a8}"),
        ("\u{b8ce}", "\u{b8ce}", "\u{1105}\u{116d}\u{11a9}", "\u{b8ce}",
        "\u{1105}\u{116d}\u{11a9}"), ("\u{b8cf}", "\u{b8cf}", "\u{1105}\u{116d}\u{11aa}",
        "\u{b8cf}", "\u{1105}\u{116d}\u{11aa}"), ("\u{b8d0}", "\u{b8d0}",
        "\u{1105}\u{116d}\u{11ab}", "\u{b8d0}", "\u{1105}\u{116d}\u{11ab}"), ("\u{b8d1}",
        "\u{b8d1}", "\u{1105}\u{116d}\u{11ac}", "\u{b8d1}", "\u{1105}\u{116d}\u{11ac}"),
        ("\u{b8d2}", "\u{b8d2}", "\u{1105}\u{116d}\u{11ad}", "\u{b8d2}",
        "\u{1105}\u{116d}\u{11ad}"), ("\u{b8d3}", "\u{b8d3}", "\u{1105}\u{116d}\u{11ae}",
        "\u{b8d3}", "\u{1105}\u{116d}\u{11ae}"), ("\u{b8d4}", "\u{b8d4}",
        "\u{1105}\u{116d}\u{11af}", "\u{b8d4}", "\u{1105}\u{116d}\u{11af}"), ("\u{b8d5}",
        "\u{b8d5}", "\u{1105}\u{116d}\u{11b0}", "\u{b8d5}", "\u{1105}\u{116d}\u{11b0}"),
        ("\u{b8d6}", "\u{b8d6}", "\u{1105}\u{116d}\u{11b1}", "\u{b8d6}",
        "\u{1105}\u{116d}\u{11b1}"), ("\u{b8d7}", "\u{b8d7}", "\u{1105}\u{116d}\u{11b2}",
        "\u{b8d7}", "\u{1105}\u{116d}\u{11b2}"), ("\u{b8d8}", "\u{b8d8}",
        "\u{1105}\u{116d}\u{11b3}", "\u{b8d8}", "\u{1105}\u{116d}\u{11b3}"), ("\u{b8d9}",
        "\u{b8d9}", "\u{1105}\u{116d}\u{11b4}", "\u{b8d9}", "\u{1105}\u{116d}\u{11b4}"),
        ("\u{b8da}", "\u{b8da}", "\u{1105}\u{116d}\u{11b5}", "\u{b8da}",
        "\u{1105}\u{116d}\u{11b5}"), ("\u{b8db}", "\u{b8db}", "\u{1105}\u{116d}\u{11b6}",
        "\u{b8db}", "\u{1105}\u{116d}\u{11b6}"), ("\u{b8dc}", "\u{b8dc}",
        "\u{1105}\u{116d}\u{11b7}", "\u{b8dc}", "\u{1105}\u{116d}\u{11b7}"), ("\u{b8dd}",
        "\u{b8dd}", "\u{1105}\u{116d}\u{11b8}", "\u{b8dd}", "\u{1105}\u{116d}\u{11b8}"),
        ("\u{b8de}", "\u{b8de}", "\u{1105}\u{116d}\u{11b9}", "\u{b8de}",
        "\u{1105}\u{116d}\u{11b9}"), ("\u{b8df}", "\u{b8df}", "\u{1105}\u{116d}\u{11ba}",
        "\u{b8df}", "\u{1105}\u{116d}\u{11ba}"), ("\u{b8e0}", "\u{b8e0}",
        "\u{1105}\u{116d}\u{11bb}", "\u{b8e0}", "\u{1105}\u{116d}\u{11bb}"), ("\u{b8e1}",
        "\u{b8e1}", "\u{1105}\u{116d}\u{11bc}", "\u{b8e1}", "\u{1105}\u{116d}\u{11bc}"),
        ("\u{b8e2}", "\u{b8e2}", "\u{1105}\u{116d}\u{11bd}", "\u{b8e2}",
        "\u{1105}\u{116d}\u{11bd}"), ("\u{b8e3}", "\u{b8e3}", "\u{1105}\u{116d}\u{11be}",
        "\u{b8e3}", "\u{1105}\u{116d}\u{11be}"), ("\u{b8e4}", "\u{b8e4}",
        "\u{1105}\u{116d}\u{11bf}", "\u{b8e4}", "\u{1105}\u{116d}\u{11bf}"), ("\u{b8e5}",
        "\u{b8e5}", "\u{1105}\u{116d}\u{11c0}", "\u{b8e5}", "\u{1105}\u{116d}\u{11c0}"),
        ("\u{b8e6}", "\u{b8e6}", "\u{1105}\u{116d}\u{11c1}", "\u{b8e6}",
        "\u{1105}\u{116d}\u{11c1}"), ("\u{b8e7}", "\u{b8e7}", "\u{1105}\u{116d}\u{11c2}",
        "\u{b8e7}", "\u{1105}\u{116d}\u{11c2}"), ("\u{b8e8}", "\u{b8e8}", "\u{1105}\u{116e}",
        "\u{b8e8}", "\u{1105}\u{116e}"), ("\u{b8e9}", "\u{b8e9}", "\u{1105}\u{116e}\u{11a8}",
        "\u{b8e9}", "\u{1105}\u{116e}\u{11a8}"), ("\u{b8ea}", "\u{b8ea}",
        "\u{1105}\u{116e}\u{11a9}", "\u{b8ea}", "\u{1105}\u{116e}\u{11a9}"), ("\u{b8eb}",
        "\u{b8eb}", "\u{1105}\u{116e}\u{11aa}", "\u{b8eb}", "\u{1105}\u{116e}\u{11aa}"),
        ("\u{b8ec}", "\u{b8ec}", "\u{1105}\u{116e}\u{11ab}", "\u{b8ec}",
        "\u{1105}\u{116e}\u{11ab}"), ("\u{b8ed}", "\u{b8ed}", "\u{1105}\u{116e}\u{11ac}",
        "\u{b8ed}", "\u{1105}\u{116e}\u{11ac}"), ("\u{b8ee}", "\u{b8ee}",
        "\u{1105}\u{116e}\u{11ad}", "\u{b8ee}", "\u{1105}\u{116e}\u{11ad}"), ("\u{b8ef}",
        "\u{b8ef}", "\u{1105}\u{116e}\u{11ae}", "\u{b8ef}", "\u{1105}\u{116e}\u{11ae}"),
        ("\u{b8f0}", "\u{b8f0}", "\u{1105}\u{116e}\u{11af}", "\u{b8f0}",
        "\u{1105}\u{116e}\u{11af}"), ("\u{b8f1}", "\u{b8f1}", "\u{1105}\u{116e}\u{11b0}",
        "\u{b8f1}", "\u{1105}\u{116e}\u{11b0}"), ("\u{b8f2}", "\u{b8f2}",
        "\u{1105}\u{116e}\u{11b1}", "\u{b8f2}", "\u{1105}\u{116e}\u{11b1}"), ("\u{b8f3}",
        "\u{b8f3}", "\u{1105}\u{116e}\u{11b2}", "\u{b8f3}", "\u{1105}\u{116e}\u{11b2}"),
        ("\u{b8f4}", "\u{b8f4}", "\u{1105}\u{116e}\u{11b3}", "\u{b8f4}",
        "\u{1105}\u{116e}\u{11b3}"), ("\u{b8f5}", "\u{b8f5}", "\u{1105}\u{116e}\u{11b4}",
        "\u{b8f5}", "\u{1105}\u{116e}\u{11b4}"), ("\u{b8f6}", "\u{b8f6}",
        "\u{1105}\u{116e}\u{11b5}", "\u{b8f6}", "\u{1105}\u{116e}\u{11b5}"), ("\u{b8f7}",
        "\u{b8f7}", "\u{1105}\u{116e}\u{11b6}", "\u{b8f7}", "\u{1105}\u{116e}\u{11b6}"),
        ("\u{b8f8}", "\u{b8f8}", "\u{1105}\u{116e}\u{11b7}", "\u{b8f8}",
        "\u{1105}\u{116e}\u{11b7}"), ("\u{b8f9}", "\u{b8f9}", "\u{1105}\u{116e}\u{11b8}",
        "\u{b8f9}", "\u{1105}\u{116e}\u{11b8}"), ("\u{b8fa}", "\u{b8fa}",
        "\u{1105}\u{116e}\u{11b9}", "\u{b8fa}", "\u{1105}\u{116e}\u{11b9}"), ("\u{b8fb}",
        "\u{b8fb}", "\u{1105}\u{116e}\u{11ba}", "\u{b8fb}", "\u{1105}\u{116e}\u{11ba}"),
        ("\u{b8fc}", "\u{b8fc}", "\u{1105}\u{116e}\u{11bb}", "\u{b8fc}",
        "\u{1105}\u{116e}\u{11bb}"), ("\u{b8fd}", "\u{b8fd}", "\u{1105}\u{116e}\u{11bc}",
        "\u{b8fd}", "\u{1105}\u{116e}\u{11bc}"), ("\u{b8fe}", "\u{b8fe}",
        "\u{1105}\u{116e}\u{11bd}", "\u{b8fe}", "\u{1105}\u{116e}\u{11bd}"), ("\u{b8ff}",
        "\u{b8ff}", "\u{1105}\u{116e}\u{11be}", "\u{b8ff}", "\u{1105}\u{116e}\u{11be}"),
        ("\u{b900}", "\u{b900}", "\u{1105}\u{116e}\u{11bf}", "\u{b900}",
        "\u{1105}\u{116e}\u{11bf}"), ("\u{b901}", "\u{b901}", "\u{1105}\u{116e}\u{11c0}",
        "\u{b901}", "\u{1105}\u{116e}\u{11c0}"), ("\u{b902}", "\u{b902}",
        "\u{1105}\u{116e}\u{11c1}", "\u{b902}", "\u{1105}\u{116e}\u{11c1}"), ("\u{b903}",
        "\u{b903}", "\u{1105}\u{116e}\u{11c2}", "\u{b903}", "\u{1105}\u{116e}\u{11c2}"),
        ("\u{b904}", "\u{b904}", "\u{1105}\u{116f}", "\u{b904}", "\u{1105}\u{116f}"), ("\u{b905}",
        "\u{b905}", "\u{1105}\u{116f}\u{11a8}", "\u{b905}", "\u{1105}\u{116f}\u{11a8}"),
        ("\u{b906}", "\u{b906}", "\u{1105}\u{116f}\u{11a9}", "\u{b906}",
        "\u{1105}\u{116f}\u{11a9}"), ("\u{b907}", "\u{b907}", "\u{1105}\u{116f}\u{11aa}",
        "\u{b907}", "\u{1105}\u{116f}\u{11aa}"), ("\u{b908}", "\u{b908}",
        "\u{1105}\u{116f}\u{11ab}", "\u{b908}", "\u{1105}\u{116f}\u{11ab}"), ("\u{b909}",
        "\u{b909}", "\u{1105}\u{116f}\u{11ac}", "\u{b909}", "\u{1105}\u{116f}\u{11ac}"),
        ("\u{b90a}", "\u{b90a}", "\u{1105}\u{116f}\u{11ad}", "\u{b90a}",
        "\u{1105}\u{116f}\u{11ad}"), ("\u{b90b}", "\u{b90b}", "\u{1105}\u{116f}\u{11ae}",
        "\u{b90b}", "\u{1105}\u{116f}\u{11ae}"), ("\u{b90c}", "\u{b90c}",
        "\u{1105}\u{116f}\u{11af}", "\u{b90c}", "\u{1105}\u{116f}\u{11af}"), ("\u{b90d}",
        "\u{b90d}", "\u{1105}\u{116f}\u{11b0}", "\u{b90d}", "\u{1105}\u{116f}\u{11b0}"),
        ("\u{b90e}", "\u{b90e}", "\u{1105}\u{116f}\u{11b1}", "\u{b90e}",
        "\u{1105}\u{116f}\u{11b1}"), ("\u{b90f}", "\u{b90f}", "\u{1105}\u{116f}\u{11b2}",
        "\u{b90f}", "\u{1105}\u{116f}\u{11b2}"), ("\u{b910}", "\u{b910}",
        "\u{1105}\u{116f}\u{11b3}", "\u{b910}", "\u{1105}\u{116f}\u{11b3}"), ("\u{b911}",
        "\u{b911}", "\u{1105}\u{116f}\u{11b4}", "\u{b911}", "\u{1105}\u{116f}\u{11b4}"),
        ("\u{b912}", "\u{b912}", "\u{1105}\u{116f}\u{11b5}", "\u{b912}",
        "\u{1105}\u{116f}\u{11b5}"), ("\u{b913}", "\u{b913}", "\u{1105}\u{116f}\u{11b6}",
        "\u{b913}", "\u{1105}\u{116f}\u{11b6}"), ("\u{b914}", "\u{b914}",
        "\u{1105}\u{116f}\u{11b7}", "\u{b914}", "\u{1105}\u{116f}\u{11b7}"), ("\u{b915}",
        "\u{b915}", "\u{1105}\u{116f}\u{11b8}", "\u{b915}", "\u{1105}\u{116f}\u{11b8}"),
        ("\u{b916}", "\u{b916}", "\u{1105}\u{116f}\u{11b9}", "\u{b916}",
        "\u{1105}\u{116f}\u{11b9}"), ("\u{b917}", "\u{b917}", "\u{1105}\u{116f}\u{11ba}",
        "\u{b917}", "\u{1105}\u{116f}\u{11ba}"), ("\u{b918}", "\u{b918}",
        "\u{1105}\u{116f}\u{11bb}", "\u{b918}", "\u{1105}\u{116f}\u{11bb}"), ("\u{b919}",
        "\u{b919}", "\u{1105}\u{116f}\u{11bc}", "\u{b919}", "\u{1105}\u{116f}\u{11bc}"),
        ("\u{b91a}", "\u{b91a}", "\u{1105}\u{116f}\u{11bd}", "\u{b91a}",
        "\u{1105}\u{116f}\u{11bd}"), ("\u{b91b}", "\u{b91b}", "\u{1105}\u{116f}\u{11be}",
        "\u{b91b}", "\u{1105}\u{116f}\u{11be}"), ("\u{b91c}", "\u{b91c}",
        "\u{1105}\u{116f}\u{11bf}", "\u{b91c}", "\u{1105}\u{116f}\u{11bf}"), ("\u{b91d}",
        "\u{b91d}", "\u{1105}\u{116f}\u{11c0}", "\u{b91d}", "\u{1105}\u{116f}\u{11c0}"),
        ("\u{b91e}", "\u{b91e}", "\u{1105}\u{116f}\u{11c1}", "\u{b91e}",
        "\u{1105}\u{116f}\u{11c1}"), ("\u{b91f}", "\u{b91f}", "\u{1105}\u{116f}\u{11c2}",
        "\u{b91f}", "\u{1105}\u{116f}\u{11c2}"), ("\u{b920}", "\u{b920}", "\u{1105}\u{1170}",
        "\u{b920}", "\u{1105}\u{1170}"), ("\u{b921}", "\u{b921}", "\u{1105}\u{1170}\u{11a8}",
        "\u{b921}", "\u{1105}\u{1170}\u{11a8}"), ("\u{b922}", "\u{b922}",
        "\u{1105}\u{1170}\u{11a9}", "\u{b922}", "\u{1105}\u{1170}\u{11a9}"), ("\u{b923}",
        "\u{b923}", "\u{1105}\u{1170}\u{11aa}", "\u{b923}", "\u{1105}\u{1170}\u{11aa}"),
        ("\u{b924}", "\u{b924}", "\u{1105}\u{1170}\u{11ab}", "\u{b924}",
        "\u{1105}\u{1170}\u{11ab}"), ("\u{b925}", "\u{b925}", "\u{1105}\u{1170}\u{11ac}",
        "\u{b925}", "\u{1105}\u{1170}\u{11ac}"), ("\u{b926}", "\u{b926}",
        "\u{1105}\u{1170}\u{11ad}", "\u{b926}", "\u{1105}\u{1170}\u{11ad}"), ("\u{b927}",
        "\u{b927}", "\u{1105}\u{1170}\u{11ae}", "\u{b927}", "\u{1105}\u{1170}\u{11ae}"),
        ("\u{b928}", "\u{b928}", "\u{1105}\u{1170}\u{11af}", "\u{b928}",
        "\u{1105}\u{1170}\u{11af}"), ("\u{b929}", "\u{b929}", "\u{1105}\u{1170}\u{11b0}",
        "\u{b929}", "\u{1105}\u{1170}\u{11b0}"), ("\u{b92a}", "\u{b92a}",
        "\u{1105}\u{1170}\u{11b1}", "\u{b92a}", "\u{1105}\u{1170}\u{11b1}"), ("\u{b92b}",
        "\u{b92b}", "\u{1105}\u{1170}\u{11b2}", "\u{b92b}", "\u{1105}\u{1170}\u{11b2}"),
        ("\u{b92c}", "\u{b92c}", "\u{1105}\u{1170}\u{11b3}", "\u{b92c}",
        "\u{1105}\u{1170}\u{11b3}"), ("\u{b92d}", "\u{b92d}", "\u{1105}\u{1170}\u{11b4}",
        "\u{b92d}", "\u{1105}\u{1170}\u{11b4}"), ("\u{b92e}", "\u{b92e}",
        "\u{1105}\u{1170}\u{11b5}", "\u{b92e}", "\u{1105}\u{1170}\u{11b5}"), ("\u{b92f}",
        "\u{b92f}", "\u{1105}\u{1170}\u{11b6}", "\u{b92f}", "\u{1105}\u{1170}\u{11b6}"),
        ("\u{b930}", "\u{b930}", "\u{1105}\u{1170}\u{11b7}", "\u{b930}",
        "\u{1105}\u{1170}\u{11b7}"), ("\u{b931}", "\u{b931}", "\u{1105}\u{1170}\u{11b8}",
        "\u{b931}", "\u{1105}\u{1170}\u{11b8}"), ("\u{b932}", "\u{b932}",
        "\u{1105}\u{1170}\u{11b9}", "\u{b932}", "\u{1105}\u{1170}\u{11b9}"), ("\u{b933}",
        "\u{b933}", "\u{1105}\u{1170}\u{11ba}", "\u{b933}", "\u{1105}\u{1170}\u{11ba}"),
        ("\u{b934}", "\u{b934}", "\u{1105}\u{1170}\u{11bb}", "\u{b934}",
        "\u{1105}\u{1170}\u{11bb}"), ("\u{b935}", "\u{b935}", "\u{1105}\u{1170}\u{11bc}",
        "\u{b935}", "\u{1105}\u{1170}\u{11bc}"), ("\u{b936}", "\u{b936}",
        "\u{1105}\u{1170}\u{11bd}", "\u{b936}", "\u{1105}\u{1170}\u{11bd}"), ("\u{b937}",
        "\u{b937}", "\u{1105}\u{1170}\u{11be}", "\u{b937}", "\u{1105}\u{1170}\u{11be}"),
        ("\u{b938}", "\u{b938}", "\u{1105}\u{1170}\u{11bf}", "\u{b938}",
        "\u{1105}\u{1170}\u{11bf}"), ("\u{b939}", "\u{b939}", "\u{1105}\u{1170}\u{11c0}",
        "\u{b939}", "\u{1105}\u{1170}\u{11c0}"), ("\u{b93a}", "\u{b93a}",
        "\u{1105}\u{1170}\u{11c1}", "\u{b93a}", "\u{1105}\u{1170}\u{11c1}"), ("\u{b93b}",
        "\u{b93b}", "\u{1105}\u{1170}\u{11c2}", "\u{b93b}", "\u{1105}\u{1170}\u{11c2}"),
        ("\u{b93c}", "\u{b93c}", "\u{1105}\u{1171}", "\u{b93c}", "\u{1105}\u{1171}"), ("\u{b93d}",
        "\u{b93d}", "\u{1105}\u{1171}\u{11a8}", "\u{b93d}", "\u{1105}\u{1171}\u{11a8}"),
        ("\u{b93e}", "\u{b93e}", "\u{1105}\u{1171}\u{11a9}", "\u{b93e}",
        "\u{1105}\u{1171}\u{11a9}"), ("\u{b93f}", "\u{b93f}", "\u{1105}\u{1171}\u{11aa}",
        "\u{b93f}", "\u{1105}\u{1171}\u{11aa}"), ("\u{b940}", "\u{b940}",
        "\u{1105}\u{1171}\u{11ab}", "\u{b940}", "\u{1105}\u{1171}\u{11ab}"), ("\u{b941}",
        "\u{b941}", "\u{1105}\u{1171}\u{11ac}", "\u{b941}", "\u{1105}\u{1171}\u{11ac}"),
        ("\u{b942}", "\u{b942}", "\u{1105}\u{1171}\u{11ad}", "\u{b942}",
        "\u{1105}\u{1171}\u{11ad}"), ("\u{b943}", "\u{b943}", "\u{1105}\u{1171}\u{11ae}",
        "\u{b943}", "\u{1105}\u{1171}\u{11ae}"), ("\u{b944}", "\u{b944}",
        "\u{1105}\u{1171}\u{11af}", "\u{b944}", "\u{1105}\u{1171}\u{11af}"), ("\u{b945}",
        "\u{b945}", "\u{1105}\u{1171}\u{11b0}", "\u{b945}", "\u{1105}\u{1171}\u{11b0}"),
        ("\u{b946}", "\u{b946}", "\u{1105}\u{1171}\u{11b1}", "\u{b946}",
        "\u{1105}\u{1171}\u{11b1}"), ("\u{b947}", "\u{b947}", "\u{1105}\u{1171}\u{11b2}",
        "\u{b947}", "\u{1105}\u{1171}\u{11b2}"), ("\u{b948}", "\u{b948}",
        "\u{1105}\u{1171}\u{11b3}", "\u{b948}", "\u{1105}\u{1171}\u{11b3}"), ("\u{b949}",
        "\u{b949}", "\u{1105}\u{1171}\u{11b4}", "\u{b949}", "\u{1105}\u{1171}\u{11b4}"),
        ("\u{b94a}", "\u{b94a}", "\u{1105}\u{1171}\u{11b5}", "\u{b94a}",
        "\u{1105}\u{1171}\u{11b5}"), ("\u{b94b}", "\u{b94b}", "\u{1105}\u{1171}\u{11b6}",
        "\u{b94b}", "\u{1105}\u{1171}\u{11b6}"), ("\u{b94c}", "\u{b94c}",
        "\u{1105}\u{1171}\u{11b7}", "\u{b94c}", "\u{1105}\u{1171}\u{11b7}"), ("\u{b94d}",
        "\u{b94d}", "\u{1105}\u{1171}\u{11b8}", "\u{b94d}", "\u{1105}\u{1171}\u{11b8}"),
        ("\u{b94e}", "\u{b94e}", "\u{1105}\u{1171}\u{11b9}", "\u{b94e}",
        "\u{1105}\u{1171}\u{11b9}"), ("\u{b94f}", "\u{b94f}", "\u{1105}\u{1171}\u{11ba}",
        "\u{b94f}", "\u{1105}\u{1171}\u{11ba}"), ("\u{b950}", "\u{b950}",
        "\u{1105}\u{1171}\u{11bb}", "\u{b950}", "\u{1105}\u{1171}\u{11bb}"), ("\u{b951}",
        "\u{b951}", "\u{1105}\u{1171}\u{11bc}", "\u{b951}", "\u{1105}\u{1171}\u{11bc}"),
        ("\u{b952}", "\u{b952}", "\u{1105}\u{1171}\u{11bd}", "\u{b952}",
        "\u{1105}\u{1171}\u{11bd}"), ("\u{b953}", "\u{b953}", "\u{1105}\u{1171}\u{11be}",
        "\u{b953}", "\u{1105}\u{1171}\u{11be}"), ("\u{b954}", "\u{b954}",
        "\u{1105}\u{1171}\u{11bf}", "\u{b954}", "\u{1105}\u{1171}\u{11bf}"), ("\u{b955}",
        "\u{b955}", "\u{1105}\u{1171}\u{11c0}", "\u{b955}", "\u{1105}\u{1171}\u{11c0}"),
        ("\u{b956}", "\u{b956}", "\u{1105}\u{1171}\u{11c1}", "\u{b956}",
        "\u{1105}\u{1171}\u{11c1}"), ("\u{b957}", "\u{b957}", "\u{1105}\u{1171}\u{11c2}",
        "\u{b957}", "\u{1105}\u{1171}\u{11c2}"), ("\u{b958}", "\u{b958}", "\u{1105}\u{1172}",
        "\u{b958}", "\u{1105}\u{1172}"), ("\u{b959}", "\u{b959}", "\u{1105}\u{1172}\u{11a8}",
        "\u{b959}", "\u{1105}\u{1172}\u{11a8}"), ("\u{b95a}", "\u{b95a}",
        "\u{1105}\u{1172}\u{11a9}", "\u{b95a}", "\u{1105}\u{1172}\u{11a9}"), ("\u{b95b}",
        "\u{b95b}", "\u{1105}\u{1172}\u{11aa}", "\u{b95b}", "\u{1105}\u{1172}\u{11aa}"),
        ("\u{b95c}", "\u{b95c}", "\u{1105}\u{1172}\u{11ab}", "\u{b95c}",
        "\u{1105}\u{1172}\u{11ab}"), ("\u{b95d}", "\u{b95d}", "\u{1105}\u{1172}\u{11ac}",
        "\u{b95d}", "\u{1105}\u{1172}\u{11ac}"), ("\u{b95e}", "\u{b95e}",
        "\u{1105}\u{1172}\u{11ad}", "\u{b95e}", "\u{1105}\u{1172}\u{11ad}"), ("\u{b95f}",
        "\u{b95f}", "\u{1105}\u{1172}\u{11ae}", "\u{b95f}", "\u{1105}\u{1172}\u{11ae}"),
        ("\u{b960}", "\u{b960}", "\u{1105}\u{1172}\u{11af}", "\u{b960}",
        "\u{1105}\u{1172}\u{11af}"), ("\u{b961}", "\u{b961}", "\u{1105}\u{1172}\u{11b0}",
        "\u{b961}", "\u{1105}\u{1172}\u{11b0}"), ("\u{b962}", "\u{b962}",
        "\u{1105}\u{1172}\u{11b1}", "\u{b962}", "\u{1105}\u{1172}\u{11b1}"), ("\u{b963}",
        "\u{b963}", "\u{1105}\u{1172}\u{11b2}", "\u{b963}", "\u{1105}\u{1172}\u{11b2}"),
        ("\u{b964}", "\u{b964}", "\u{1105}\u{1172}\u{11b3}", "\u{b964}",
        "\u{1105}\u{1172}\u{11b3}"), ("\u{b965}", "\u{b965}", "\u{1105}\u{1172}\u{11b4}",
        "\u{b965}", "\u{1105}\u{1172}\u{11b4}"), ("\u{b966}", "\u{b966}",
        "\u{1105}\u{1172}\u{11b5}", "\u{b966}", "\u{1105}\u{1172}\u{11b5}"), ("\u{b967}",
        "\u{b967}", "\u{1105}\u{1172}\u{11b6}", "\u{b967}", "\u{1105}\u{1172}\u{11b6}"),
        ("\u{b968}", "\u{b968}", "\u{1105}\u{1172}\u{11b7}", "\u{b968}",
        "\u{1105}\u{1172}\u{11b7}"), ("\u{b969}", "\u{b969}", "\u{1105}\u{1172}\u{11b8}",
        "\u{b969}", "\u{1105}\u{1172}\u{11b8}"), ("\u{b96a}", "\u{b96a}",
        "\u{1105}\u{1172}\u{11b9}", "\u{b96a}", "\u{1105}\u{1172}\u{11b9}"), ("\u{b96b}",
        "\u{b96b}", "\u{1105}\u{1172}\u{11ba}", "\u{b96b}", "\u{1105}\u{1172}\u{11ba}"),
        ("\u{b96c}", "\u{b96c}", "\u{1105}\u{1172}\u{11bb}", "\u{b96c}",
        "\u{1105}\u{1172}\u{11bb}"), ("\u{b96d}", "\u{b96d}", "\u{1105}\u{1172}\u{11bc}",
        "\u{b96d}", "\u{1105}\u{1172}\u{11bc}"), ("\u{b96e}", "\u{b96e}",
        "\u{1105}\u{1172}\u{11bd}", "\u{b96e}", "\u{1105}\u{1172}\u{11bd}"), ("\u{b96f}",
        "\u{b96f}", "\u{1105}\u{1172}\u{11be}", "\u{b96f}", "\u{1105}\u{1172}\u{11be}"),
        ("\u{b970}", "\u{b970}", "\u{1105}\u{1172}\u{11bf}", "\u{b970}",
        "\u{1105}\u{1172}\u{11bf}"), ("\u{b971}", "\u{b971}", "\u{1105}\u{1172}\u{11c0}",
        "\u{b971}", "\u{1105}\u{1172}\u{11c0}"), ("\u{b972}", "\u{b972}",
        "\u{1105}\u{1172}\u{11c1}", "\u{b972}", "\u{1105}\u{1172}\u{11c1}"), ("\u{b973}",
        "\u{b973}", "\u{1105}\u{1172}\u{11c2}", "\u{b973}", "\u{1105}\u{1172}\u{11c2}"),
        ("\u{b974}", "\u{b974}", "\u{1105}\u{1173}", "\u{b974}", "\u{1105}\u{1173}"), ("\u{b975}",
        "\u{b975}", "\u{1105}\u{1173}\u{11a8}", "\u{b975}", "\u{1105}\u{1173}\u{11a8}"),
        ("\u{b976}", "\u{b976}", "\u{1105}\u{1173}\u{11a9}", "\u{b976}",
        "\u{1105}\u{1173}\u{11a9}"), ("\u{b977}", "\u{b977}", "\u{1105}\u{1173}\u{11aa}",
        "\u{b977}", "\u{1105}\u{1173}\u{11aa}"), ("\u{b978}", "\u{b978}",
        "\u{1105}\u{1173}\u{11ab}", "\u{b978}", "\u{1105}\u{1173}\u{11ab}"), ("\u{b979}",
        "\u{b979}", "\u{1105}\u{1173}\u{11ac}", "\u{b979}", "\u{1105}\u{1173}\u{11ac}"),
        ("\u{b97a}", "\u{b97a}", "\u{1105}\u{1173}\u{11ad}", "\u{b97a}",
        "\u{1105}\u{1173}\u{11ad}"), ("\u{b97b}", "\u{b97b}", "\u{1105}\u{1173}\u{11ae}",
        "\u{b97b}", "\u{1105}\u{1173}\u{11ae}"), ("\u{b97c}", "\u{b97c}",
        "\u{1105}\u{1173}\u{11af}", "\u{b97c}", "\u{1105}\u{1173}\u{11af}"), ("\u{b97d}",
        "\u{b97d}", "\u{1105}\u{1173}\u{11b0}", "\u{b97d}", "\u{1105}\u{1173}\u{11b0}"),
        ("\u{b97e}", "\u{b97e}", "\u{1105}\u{1173}\u{11b1}", "\u{b97e}",
        "\u{1105}\u{1173}\u{11b1}"), ("\u{b97f}", "\u{b97f}", "\u{1105}\u{1173}\u{11b2}",
        "\u{b97f}", "\u{1105}\u{1173}\u{11b2}"), ("\u{b980}", "\u{b980}",
        "\u{1105}\u{1173}\u{11b3}", "\u{b980}", "\u{1105}\u{1173}\u{11b3}"), ("\u{b981}",
        "\u{b981}", "\u{1105}\u{1173}\u{11b4}", "\u{b981}", "\u{1105}\u{1173}\u{11b4}"),
        ("\u{b982}", "\u{b982}", "\u{1105}\u{1173}\u{11b5}", "\u{b982}",
        "\u{1105}\u{1173}\u{11b5}"), ("\u{b983}", "\u{b983}", "\u{1105}\u{1173}\u{11b6}",
        "\u{b983}", "\u{1105}\u{1173}\u{11b6}"), ("\u{b984}", "\u{b984}",
        "\u{1105}\u{1173}\u{11b7}", "\u{b984}", "\u{1105}\u{1173}\u{11b7}"), ("\u{b985}",
        "\u{b985}", "\u{1105}\u{1173}\u{11b8}", "\u{b985}", "\u{1105}\u{1173}\u{11b8}"),
        ("\u{b986}", "\u{b986}", "\u{1105}\u{1173}\u{11b9}", "\u{b986}",
        "\u{1105}\u{1173}\u{11b9}"), ("\u{b987}", "\u{b987}", "\u{1105}\u{1173}\u{11ba}",
        "\u{b987}", "\u{1105}\u{1173}\u{11ba}"), ("\u{b988}", "\u{b988}",
        "\u{1105}\u{1173}\u{11bb}", "\u{b988}", "\u{1105}\u{1173}\u{11bb}"), ("\u{b989}",
        "\u{b989}", "\u{1105}\u{1173}\u{11bc}", "\u{b989}", "\u{1105}\u{1173}\u{11bc}"),
        ("\u{b98a}", "\u{b98a}", "\u{1105}\u{1173}\u{11bd}", "\u{b98a}",
        "\u{1105}\u{1173}\u{11bd}"), ("\u{b98b}", "\u{b98b}", "\u{1105}\u{1173}\u{11be}",
        "\u{b98b}", "\u{1105}\u{1173}\u{11be}"), ("\u{b98c}", "\u{b98c}",
        "\u{1105}\u{1173}\u{11bf}", "\u{b98c}", "\u{1105}\u{1173}\u{11bf}"), ("\u{b98d}",
        "\u{b98d}", "\u{1105}\u{1173}\u{11c0}", "\u{b98d}", "\u{1105}\u{1173}\u{11c0}"),
        ("\u{b98e}", "\u{b98e}", "\u{1105}\u{1173}\u{11c1}", "\u{b98e}",
        "\u{1105}\u{1173}\u{11c1}"), ("\u{b98f}", "\u{b98f}", "\u{1105}\u{1173}\u{11c2}",
        "\u{b98f}", "\u{1105}\u{1173}\u{11c2}"), ("\u{b990}", "\u{b990}", "\u{1105}\u{1174}",
        "\u{b990}", "\u{1105}\u{1174}"), ("\u{b991}", "\u{b991}", "\u{1105}\u{1174}\u{11a8}",
        "\u{b991}", "\u{1105}\u{1174}\u{11a8}"), ("\u{b992}", "\u{b992}",
        "\u{1105}\u{1174}\u{11a9}", "\u{b992}", "\u{1105}\u{1174}\u{11a9}"), ("\u{b993}",
        "\u{b993}", "\u{1105}\u{1174}\u{11aa}", "\u{b993}", "\u{1105}\u{1174}\u{11aa}"),
        ("\u{b994}", "\u{b994}", "\u{1105}\u{1174}\u{11ab}", "\u{b994}",
        "\u{1105}\u{1174}\u{11ab}"), ("\u{b995}", "\u{b995}", "\u{1105}\u{1174}\u{11ac}",
        "\u{b995}", "\u{1105}\u{1174}\u{11ac}"), ("\u{b996}", "\u{b996}",
        "\u{1105}\u{1174}\u{11ad}", "\u{b996}", "\u{1105}\u{1174}\u{11ad}"), ("\u{b997}",
        "\u{b997}", "\u{1105}\u{1174}\u{11ae}", "\u{b997}", "\u{1105}\u{1174}\u{11ae}"),
        ("\u{b998}", "\u{b998}", "\u{1105}\u{1174}\u{11af}", "\u{b998}",
        "\u{1105}\u{1174}\u{11af}"), ("\u{b999}", "\u{b999}", "\u{1105}\u{1174}\u{11b0}",
        "\u{b999}", "\u{1105}\u{1174}\u{11b0}"), ("\u{b99a}", "\u{b99a}",
        "\u{1105}\u{1174}\u{11b1}", "\u{b99a}", "\u{1105}\u{1174}\u{11b1}"), ("\u{b99b}",
        "\u{b99b}", "\u{1105}\u{1174}\u{11b2}", "\u{b99b}", "\u{1105}\u{1174}\u{11b2}"),
        ("\u{b99c}", "\u{b99c}", "\u{1105}\u{1174}\u{11b3}", "\u{b99c}",
        "\u{1105}\u{1174}\u{11b3}"), ("\u{b99d}", "\u{b99d}", "\u{1105}\u{1174}\u{11b4}",
        "\u{b99d}", "\u{1105}\u{1174}\u{11b4}"), ("\u{b99e}", "\u{b99e}",
        "\u{1105}\u{1174}\u{11b5}", "\u{b99e}", "\u{1105}\u{1174}\u{11b5}"), ("\u{b99f}",
        "\u{b99f}", "\u{1105}\u{1174}\u{11b6}", "\u{b99f}", "\u{1105}\u{1174}\u{11b6}"),
        ("\u{b9a0}", "\u{b9a0}", "\u{1105}\u{1174}\u{11b7}", "\u{b9a0}",
        "\u{1105}\u{1174}\u{11b7}"), ("\u{b9a1}", "\u{b9a1}", "\u{1105}\u{1174}\u{11b8}",
        "\u{b9a1}", "\u{1105}\u{1174}\u{11b8}"), ("\u{b9a2}", "\u{b9a2}",
        "\u{1105}\u{1174}\u{11b9}", "\u{b9a2}", "\u{1105}\u{1174}\u{11b9}"), ("\u{b9a3}",
        "\u{b9a3}", "\u{1105}\u{1174}\u{11ba}", "\u{b9a3}", "\u{1105}\u{1174}\u{11ba}"),
        ("\u{b9a4}", "\u{b9a4}", "\u{1105}\u{1174}\u{11bb}", "\u{b9a4}",
        "\u{1105}\u{1174}\u{11bb}"), ("\u{b9a5}", "\u{b9a5}", "\u{1105}\u{1174}\u{11bc}",
        "\u{b9a5}", "\u{1105}\u{1174}\u{11bc}"), ("\u{b9a6}", "\u{b9a6}",
        "\u{1105}\u{1174}\u{11bd}", "\u{b9a6}", "\u{1105}\u{1174}\u{11bd}"), ("\u{b9a7}",
        "\u{b9a7}", "\u{1105}\u{1174}\u{11be}", "\u{b9a7}", "\u{1105}\u{1174}\u{11be}"),
        ("\u{b9a8}", "\u{b9a8}", "\u{1105}\u{1174}\u{11bf}", "\u{b9a8}",
        "\u{1105}\u{1174}\u{11bf}"), ("\u{b9a9}", "\u{b9a9}", "\u{1105}\u{1174}\u{11c0}",
        "\u{b9a9}", "\u{1105}\u{1174}\u{11c0}"), ("\u{b9aa}", "\u{b9aa}",
        "\u{1105}\u{1174}\u{11c1}", "\u{b9aa}", "\u{1105}\u{1174}\u{11c1}"), ("\u{b9ab}",
        "\u{b9ab}", "\u{1105}\u{1174}\u{11c2}", "\u{b9ab}", "\u{1105}\u{1174}\u{11c2}"),
        ("\u{b9ac}", "\u{b9ac}", "\u{1105}\u{1175}", "\u{b9ac}", "\u{1105}\u{1175}"), ("\u{b9ad}",
        "\u{b9ad}", "\u{1105}\u{1175}\u{11a8}", "\u{b9ad}", "\u{1105}\u{1175}\u{11a8}"),
        ("\u{b9ae}", "\u{b9ae}", "\u{1105}\u{1175}\u{11a9}", "\u{b9ae}",
        "\u{1105}\u{1175}\u{11a9}"), ("\u{b9af}", "\u{b9af}", "\u{1105}\u{1175}\u{11aa}",
        "\u{b9af}", "\u{1105}\u{1175}\u{11aa}"), ("\u{b9b0}", "\u{b9b0}",
        "\u{1105}\u{1175}\u{11ab}", "\u{b9b0}", "\u{1105}\u{1175}\u{11ab}"), ("\u{b9b1}",
        "\u{b9b1}", "\u{1105}\u{1175}\u{11ac}", "\u{b9b1}", "\u{1105}\u{1175}\u{11ac}"),
        ("\u{b9b2}", "\u{b9b2}", "\u{1105}\u{1175}\u{11ad}", "\u{b9b2}",
        "\u{1105}\u{1175}\u{11ad}"), ("\u{b9b3}", "\u{b9b3}", "\u{1105}\u{1175}\u{11ae}",
        "\u{b9b3}", "\u{1105}\u{1175}\u{11ae}"), ("\u{b9b4}", "\u{b9b4}",
        "\u{1105}\u{1175}\u{11af}", "\u{b9b4}", "\u{1105}\u{1175}\u{11af}"), ("\u{b9b5}",
        "\u{b9b5}", "\u{1105}\u{1175}\u{11b0}", "\u{b9b5}", "\u{1105}\u{1175}\u{11b0}"),
        ("\u{b9b6}", "\u{b9b6}", "\u{1105}\u{1175}\u{11b1}", "\u{b9b6}",
        "\u{1105}\u{1175}\u{11b1}"), ("\u{b9b7}", "\u{b9b7}", "\u{1105}\u{1175}\u{11b2}",
        "\u{b9b7}", "\u{1105}\u{1175}\u{11b2}"), ("\u{b9b8}", "\u{b9b8}",
        "\u{1105}\u{1175}\u{11b3}", "\u{b9b8}", "\u{1105}\u{1175}\u{11b3}"), ("\u{b9b9}",
        "\u{b9b9}", "\u{1105}\u{1175}\u{11b4}", "\u{b9b9}", "\u{1105}\u{1175}\u{11b4}"),
        ("\u{b9ba}", "\u{b9ba}", "\u{1105}\u{1175}\u{11b5}", "\u{b9ba}",
        "\u{1105}\u{1175}\u{11b5}"), ("\u{b9bb}", "\u{b9bb}", "\u{1105}\u{1175}\u{11b6}",
        "\u{b9bb}", "\u{1105}\u{1175}\u{11b6}"), ("\u{b9bc}", "\u{b9bc}",
        "\u{1105}\u{1175}\u{11b7}", "\u{b9bc}", "\u{1105}\u{1175}\u{11b7}"), ("\u{b9bd}",
        "\u{b9bd}", "\u{1105}\u{1175}\u{11b8}", "\u{b9bd}", "\u{1105}\u{1175}\u{11b8}"),
        ("\u{b9be}", "\u{b9be}", "\u{1105}\u{1175}\u{11b9}", "\u{b9be}",
        "\u{1105}\u{1175}\u{11b9}"), ("\u{b9bf}", "\u{b9bf}", "\u{1105}\u{1175}\u{11ba}",
        "\u{b9bf}", "\u{1105}\u{1175}\u{11ba}"), ("\u{b9c0}", "\u{b9c0}",
        "\u{1105}\u{1175}\u{11bb}", "\u{b9c0}", "\u{1105}\u{1175}\u{11bb}"), ("\u{b9c1}",
        "\u{b9c1}", "\u{1105}\u{1175}\u{11bc}", "\u{b9c1}", "\u{1105}\u{1175}\u{11bc}"),
        ("\u{b9c2}", "\u{b9c2}", "\u{1105}\u{1175}\u{11bd}", "\u{b9c2}",
        "\u{1105}\u{1175}\u{11bd}"), ("\u{b9c3}", "\u{b9c3}", "\u{1105}\u{1175}\u{11be}",
        "\u{b9c3}", "\u{1105}\u{1175}\u{11be}"), ("\u{b9c4}", "\u{b9c4}",
        "\u{1105}\u{1175}\u{11bf}", "\u{b9c4}", "\u{1105}\u{1175}\u{11bf}"), ("\u{b9c5}",
        "\u{b9c5}", "\u{1105}\u{1175}\u{11c0}", "\u{b9c5}", "\u{1105}\u{1175}\u{11c0}"),
        ("\u{b9c6}", "\u{b9c6}", "\u{1105}\u{1175}\u{11c1}", "\u{b9c6}",
        "\u{1105}\u{1175}\u{11c1}"), ("\u{b9c7}", "\u{b9c7}", "\u{1105}\u{1175}\u{11c2}",
        "\u{b9c7}", "\u{1105}\u{1175}\u{11c2}"), ("\u{b9c8}", "\u{b9c8}", "\u{1106}\u{1161}",
        "\u{b9c8}", "\u{1106}\u{1161}"), ("\u{b9c9}", "\u{b9c9}", "\u{1106}\u{1161}\u{11a8}",
        "\u{b9c9}", "\u{1106}\u{1161}\u{11a8}"), ("\u{b9ca}", "\u{b9ca}",
        "\u{1106}\u{1161}\u{11a9}", "\u{b9ca}", "\u{1106}\u{1161}\u{11a9}"), ("\u{b9cb}",
        "\u{b9cb}", "\u{1106}\u{1161}\u{11aa}", "\u{b9cb}", "\u{1106}\u{1161}\u{11aa}"),
        ("\u{b9cc}", "\u{b9cc}", "\u{1106}\u{1161}\u{11ab}", "\u{b9cc}",
        "\u{1106}\u{1161}\u{11ab}"), ("\u{b9cd}", "\u{b9cd}", "\u{1106}\u{1161}\u{11ac}",
        "\u{b9cd}", "\u{1106}\u{1161}\u{11ac}"), ("\u{b9ce}", "\u{b9ce}",
        "\u{1106}\u{1161}\u{11ad}", "\u{b9ce}", "\u{1106}\u{1161}\u{11ad}"), ("\u{b9cf}",
        "\u{b9cf}", "\u{1106}\u{1161}\u{11ae}", "\u{b9cf}", "\u{1106}\u{1161}\u{11ae}"),
        ("\u{b9d0}", "\u{b9d0}", "\u{1106}\u{1161}\u{11af}", "\u{b9d0}",
        "\u{1106}\u{1161}\u{11af}"), ("\u{b9d1}", "\u{b9d1}", "\u{1106}\u{1161}\u{11b0}",
        "\u{b9d1}", "\u{1106}\u{1161}\u{11b0}"), ("\u{b9d2}", "\u{b9d2}",
        "\u{1106}\u{1161}\u{11b1}", "\u{b9d2}", "\u{1106}\u{1161}\u{11b1}"), ("\u{b9d3}",
        "\u{b9d3}", "\u{1106}\u{1161}\u{11b2}", "\u{b9d3}", "\u{1106}\u{1161}\u{11b2}"),
        ("\u{b9d4}", "\u{b9d4}", "\u{1106}\u{1161}\u{11b3}", "\u{b9d4}",
        "\u{1106}\u{1161}\u{11b3}"), ("\u{b9d5}", "\u{b9d5}", "\u{1106}\u{1161}\u{11b4}",
        "\u{b9d5}", "\u{1106}\u{1161}\u{11b4}"), ("\u{b9d6}", "\u{b9d6}",
        "\u{1106}\u{1161}\u{11b5}", "\u{b9d6}", "\u{1106}\u{1161}\u{11b5}"), ("\u{b9d7}",
        "\u{b9d7}", "\u{1106}\u{1161}\u{11b6}", "\u{b9d7}", "\u{1106}\u{1161}\u{11b6}"),
        ("\u{b9d8}", "\u{b9d8}", "\u{1106}\u{1161}\u{11b7}", "\u{b9d8}",
        "\u{1106}\u{1161}\u{11b7}"), ("\u{b9d9}", "\u{b9d9}", "\u{1106}\u{1161}\u{11b8}",
        "\u{b9d9}", "\u{1106}\u{1161}\u{11b8}"), ("\u{b9da}", "\u{b9da}",
        "\u{1106}\u{1161}\u{11b9}", "\u{b9da}", "\u{1106}\u{1161}\u{11b9}"), ("\u{b9db}",
        "\u{b9db}", "\u{1106}\u{1161}\u{11ba}", "\u{b9db}", "\u{1106}\u{1161}\u{11ba}"),
        ("\u{b9dc}", "\u{b9dc}", "\u{1106}\u{1161}\u{11bb}", "\u{b9dc}",
        "\u{1106}\u{1161}\u{11bb}"), ("\u{b9dd}", "\u{b9dd}", "\u{1106}\u{1161}\u{11bc}",
        "\u{b9dd}", "\u{1106}\u{1161}\u{11bc}"), ("\u{b9de}", "\u{b9de}",
        "\u{1106}\u{1161}\u{11bd}", "\u{b9de}", "\u{1106}\u{1161}\u{11bd}"), ("\u{b9df}",
        "\u{b9df}", "\u{1106}\u{1161}\u{11be}", "\u{b9df}", "\u{1106}\u{1161}\u{11be}"),
        ("\u{b9e0}", "\u{b9e0}", "\u{1106}\u{1161}\u{11bf}", "\u{b9e0}",
        "\u{1106}\u{1161}\u{11bf}"), ("\u{b9e1}", "\u{b9e1}", "\u{1106}\u{1161}\u{11c0}",
        "\u{b9e1}", "\u{1106}\u{1161}\u{11c0}"), ("\u{b9e2}", "\u{b9e2}",
        "\u{1106}\u{1161}\u{11c1}", "\u{b9e2}", "\u{1106}\u{1161}\u{11c1}"), ("\u{b9e3}",
        "\u{b9e3}", "\u{1106}\u{1161}\u{11c2}", "\u{b9e3}", "\u{1106}\u{1161}\u{11c2}"),
        ("\u{b9e4}", "\u{b9e4}", "\u{1106}\u{1162}", "\u{b9e4}", "\u{1106}\u{1162}"), ("\u{b9e5}",
        "\u{b9e5}", "\u{1106}\u{1162}\u{11a8}", "\u{b9e5}", "\u{1106}\u{1162}\u{11a8}"),
        ("\u{b9e6}", "\u{b9e6}", "\u{1106}\u{1162}\u{11a9}", "\u{b9e6}",
        "\u{1106}\u{1162}\u{11a9}"), ("\u{b9e7}", "\u{b9e7}", "\u{1106}\u{1162}\u{11aa}",
        "\u{b9e7}", "\u{1106}\u{1162}\u{11aa}"), ("\u{b9e8}", "\u{b9e8}",
        "\u{1106}\u{1162}\u{11ab}", "\u{b9e8}", "\u{1106}\u{1162}\u{11ab}"), ("\u{b9e9}",
        "\u{b9e9}", "\u{1106}\u{1162}\u{11ac}", "\u{b9e9}", "\u{1106}\u{1162}\u{11ac}"),
        ("\u{b9ea}", "\u{b9ea}", "\u{1106}\u{1162}\u{11ad}", "\u{b9ea}",
        "\u{1106}\u{1162}\u{11ad}"), ("\u{b9eb}", "\u{b9eb}", "\u{1106}\u{1162}\u{11ae}",
        "\u{b9eb}", "\u{1106}\u{1162}\u{11ae}"), ("\u{b9ec}", "\u{b9ec}",
        "\u{1106}\u{1162}\u{11af}", "\u{b9ec}", "\u{1106}\u{1162}\u{11af}"), ("\u{b9ed}",
        "\u{b9ed}", "\u{1106}\u{1162}\u{11b0}", "\u{b9ed}", "\u{1106}\u{1162}\u{11b0}"),
        ("\u{b9ee}", "\u{b9ee}", "\u{1106}\u{1162}\u{11b1}", "\u{b9ee}",
        "\u{1106}\u{1162}\u{11b1}"), ("\u{b9ef}", "\u{b9ef}", "\u{1106}\u{1162}\u{11b2}",
        "\u{b9ef}", "\u{1106}\u{1162}\u{11b2}"), ("\u{b9f0}", "\u{b9f0}",
        "\u{1106}\u{1162}\u{11b3}", "\u{b9f0}", "\u{1106}\u{1162}\u{11b3}"), ("\u{b9f1}",
        "\u{b9f1}", "\u{1106}\u{1162}\u{11b4}", "\u{b9f1}", "\u{1106}\u{1162}\u{11b4}"),
        ("\u{b9f2}", "\u{b9f2}", "\u{1106}\u{1162}\u{11b5}", "\u{b9f2}",
        "\u{1106}\u{1162}\u{11b5}"), ("\u{b9f3}", "\u{b9f3}", "\u{1106}\u{1162}\u{11b6}",
        "\u{b9f3}", "\u{1106}\u{1162}\u{11b6}"), ("\u{b9f4}", "\u{b9f4}",
        "\u{1106}\u{1162}\u{11b7}", "\u{b9f4}", "\u{1106}\u{1162}\u{11b7}"), ("\u{b9f5}",
        "\u{b9f5}", "\u{1106}\u{1162}\u{11b8}", "\u{b9f5}", "\u{1106}\u{1162}\u{11b8}"),
        ("\u{b9f6}", "\u{b9f6}", "\u{1106}\u{1162}\u{11b9}", "\u{b9f6}",
        "\u{1106}\u{1162}\u{11b9}"), ("\u{b9f7}", "\u{b9f7}", "\u{1106}\u{1162}\u{11ba}",
        "\u{b9f7}", "\u{1106}\u{1162}\u{11ba}"), ("\u{b9f8}", "\u{b9f8}",
        "\u{1106}\u{1162}\u{11bb}", "\u{b9f8}", "\u{1106}\u{1162}\u{11bb}"), ("\u{b9f9}",
        "\u{b9f9}", "\u{1106}\u{1162}\u{11bc}", "\u{b9f9}", "\u{1106}\u{1162}\u{11bc}"),
        ("\u{b9fa}", "\u{b9fa}", "\u{1106}\u{1162}\u{11bd}", "\u{b9fa}",
        "\u{1106}\u{1162}\u{11bd}"), ("\u{b9fb}", "\u{b9fb}", "\u{1106}\u{1162}\u{11be}",
        "\u{b9fb}", "\u{1106}\u{1162}\u{11be}"), ("\u{b9fc}", "\u{b9fc}",
        "\u{1106}\u{1162}\u{11bf}", "\u{b9fc}", "\u{1106}\u{1162}\u{11bf}"), ("\u{b9fd}",
        "\u{b9fd}", "\u{1106}\u{1162}\u{11c0}", "\u{b9fd}", "\u{1106}\u{1162}\u{11c0}"),
        ("\u{b9fe}", "\u{b9fe}", "\u{1106}\u{1162}\u{11c1}", "\u{b9fe}",
        "\u{1106}\u{1162}\u{11c1}"), ("\u{b9ff}", "\u{b9ff}", "\u{1106}\u{1162}\u{11c2}",
        "\u{b9ff}", "\u{1106}\u{1162}\u{11c2}"), ("\u{ba00}", "\u{ba00}", "\u{1106}\u{1163}",
        "\u{ba00}", "\u{1106}\u{1163}"), ("\u{ba01}", "\u{ba01}", "\u{1106}\u{1163}\u{11a8}",
        "\u{ba01}", "\u{1106}\u{1163}\u{11a8}"), ("\u{ba02}", "\u{ba02}",
        "\u{1106}\u{1163}\u{11a9}", "\u{ba02}", "\u{1106}\u{1163}\u{11a9}"), ("\u{ba03}",
        "\u{ba03}", "\u{1106}\u{1163}\u{11aa}", "\u{ba03}", "\u{1106}\u{1163}\u{11aa}"),
        ("\u{ba04}", "\u{ba04}", "\u{1106}\u{1163}\u{11ab}", "\u{ba04}",
        "\u{1106}\u{1163}\u{11ab}"), ("\u{ba05}", "\u{ba05}", "\u{1106}\u{1163}\u{11ac}",
        "\u{ba05}", "\u{1106}\u{1163}\u{11ac}"), ("\u{ba06}", "\u{ba06}",
        "\u{1106}\u{1163}\u{11ad}", "\u{ba06}", "\u{1106}\u{1163}\u{11ad}"), ("\u{ba07}",
        "\u{ba07}", "\u{1106}\u{1163}\u{11ae}", "\u{ba07}", "\u{1106}\u{1163}\u{11ae}"),
        ("\u{ba08}", "\u{ba08}", "\u{1106}\u{1163}\u{11af}", "\u{ba08}",
        "\u{1106}\u{1163}\u{11af}"), ("\u{ba09}", "\u{ba09}", "\u{1106}\u{1163}\u{11b0}",
        "\u{ba09}", "\u{1106}\u{1163}\u{11b0}"), ("\u{ba0a}", "\u{ba0a}",
        "\u{1106}\u{1163}\u{11b1}", "\u{ba0a}", "\u{1106}\u{1163}\u{11b1}"), ("\u{ba0b}",
        "\u{ba0b}", "\u{1106}\u{1163}\u{11b2}", "\u{ba0b}", "\u{1106}\u{1163}\u{11b2}"),
        ("\u{ba0c}", "\u{ba0c}", "\u{1106}\u{1163}\u{11b3}", "\u{ba0c}",
        "\u{1106}\u{1163}\u{11b3}"), ("\u{ba0d}", "\u{ba0d}", "\u{1106}\u{1163}\u{11b4}",
        "\u{ba0d}", "\u{1106}\u{1163}\u{11b4}"), ("\u{ba0e}", "\u{ba0e}",
        "\u{1106}\u{1163}\u{11b5}", "\u{ba0e}", "\u{1106}\u{1163}\u{11b5}"), ("\u{ba0f}",
        "\u{ba0f}", "\u{1106}\u{1163}\u{11b6}", "\u{ba0f}", "\u{1106}\u{1163}\u{11b6}"),
        ("\u{ba10}", "\u{ba10}", "\u{1106}\u{1163}\u{11b7}", "\u{ba10}",
        "\u{1106}\u{1163}\u{11b7}"), ("\u{ba11}", "\u{ba11}", "\u{1106}\u{1163}\u{11b8}",
        "\u{ba11}", "\u{1106}\u{1163}\u{11b8}"), ("\u{ba12}", "\u{ba12}",
        "\u{1106}\u{1163}\u{11b9}", "\u{ba12}", "\u{1106}\u{1163}\u{11b9}"), ("\u{ba13}",
        "\u{ba13}", "\u{1106}\u{1163}\u{11ba}", "\u{ba13}", "\u{1106}\u{1163}\u{11ba}"),
        ("\u{ba14}", "\u{ba14}", "\u{1106}\u{1163}\u{11bb}", "\u{ba14}",
        "\u{1106}\u{1163}\u{11bb}"), ("\u{ba15}", "\u{ba15}", "\u{1106}\u{1163}\u{11bc}",
        "\u{ba15}", "\u{1106}\u{1163}\u{11bc}"), ("\u{ba16}", "\u{ba16}",
        "\u{1106}\u{1163}\u{11bd}", "\u{ba16}", "\u{1106}\u{1163}\u{11bd}"), ("\u{ba17}",
        "\u{ba17}", "\u{1106}\u{1163}\u{11be}", "\u{ba17}", "\u{1106}\u{1163}\u{11be}"),
        ("\u{ba18}", "\u{ba18}", "\u{1106}\u{1163}\u{11bf}", "\u{ba18}",
        "\u{1106}\u{1163}\u{11bf}"), ("\u{ba19}", "\u{ba19}", "\u{1106}\u{1163}\u{11c0}",
        "\u{ba19}", "\u{1106}\u{1163}\u{11c0}"), ("\u{ba1a}", "\u{ba1a}",
        "\u{1106}\u{1163}\u{11c1}", "\u{ba1a}", "\u{1106}\u{1163}\u{11c1}"), ("\u{ba1b}",
        "\u{ba1b}", "\u{1106}\u{1163}\u{11c2}", "\u{ba1b}", "\u{1106}\u{1163}\u{11c2}"),
        ("\u{ba1c}", "\u{ba1c}", "\u{1106}\u{1164}", "\u{ba1c}", "\u{1106}\u{1164}"), ("\u{ba1d}",
        "\u{ba1d}", "\u{1106}\u{1164}\u{11a8}", "\u{ba1d}", "\u{1106}\u{1164}\u{11a8}"),
        ("\u{ba1e}", "\u{ba1e}", "\u{1106}\u{1164}\u{11a9}", "\u{ba1e}",
        "\u{1106}\u{1164}\u{11a9}"), ("\u{ba1f}", "\u{ba1f}", "\u{1106}\u{1164}\u{11aa}",
        "\u{ba1f}", "\u{1106}\u{1164}\u{11aa}"), ("\u{ba20}", "\u{ba20}",
        "\u{1106}\u{1164}\u{11ab}", "\u{ba20}", "\u{1106}\u{1164}\u{11ab}"), ("\u{ba21}",
        "\u{ba21}", "\u{1106}\u{1164}\u{11ac}", "\u{ba21}", "\u{1106}\u{1164}\u{11ac}"),
        ("\u{ba22}", "\u{ba22}", "\u{1106}\u{1164}\u{11ad}", "\u{ba22}",
        "\u{1106}\u{1164}\u{11ad}"), ("\u{ba23}", "\u{ba23}", "\u{1106}\u{1164}\u{11ae}",
        "\u{ba23}", "\u{1106}\u{1164}\u{11ae}"), ("\u{ba24}", "\u{ba24}",
        "\u{1106}\u{1164}\u{11af}", "\u{ba24}", "\u{1106}\u{1164}\u{11af}"), ("\u{ba25}",
        "\u{ba25}", "\u{1106}\u{1164}\u{11b0}", "\u{ba25}", "\u{1106}\u{1164}\u{11b0}"),
        ("\u{ba26}", "\u{ba26}", "\u{1106}\u{1164}\u{11b1}", "\u{ba26}",
        "\u{1106}\u{1164}\u{11b1}"), ("\u{ba27}", "\u{ba27}", "\u{1106}\u{1164}\u{11b2}",
        "\u{ba27}", "\u{1106}\u{1164}\u{11b2}"), ("\u{ba28}", "\u{ba28}",
        "\u{1106}\u{1164}\u{11b3}", "\u{ba28}", "\u{1106}\u{1164}\u{11b3}"), ("\u{ba29}",
        "\u{ba29}", "\u{1106}\u{1164}\u{11b4}", "\u{ba29}", "\u{1106}\u{1164}\u{11b4}"),
        ("\u{ba2a}", "\u{ba2a}", "\u{1106}\u{1164}\u{11b5}", "\u{ba2a}",
        "\u{1106}\u{1164}\u{11b5}"), ("\u{ba2b}", "\u{ba2b}", "\u{1106}\u{1164}\u{11b6}",
        "\u{ba2b}", "\u{1106}\u{1164}\u{11b6}"), ("\u{ba2c}", "\u{ba2c}",
        "\u{1106}\u{1164}\u{11b7}", "\u{ba2c}", "\u{1106}\u{1164}\u{11b7}"), ("\u{ba2d}",
        "\u{ba2d}", "\u{1106}\u{1164}\u{11b8}", "\u{ba2d}", "\u{1106}\u{1164}\u{11b8}"),
        ("\u{ba2e}", "\u{ba2e}", "\u{1106}\u{1164}\u{11b9}", "\u{ba2e}",
        "\u{1106}\u{1164}\u{11b9}"), ("\u{ba2f}", "\u{ba2f}", "\u{1106}\u{1164}\u{11ba}",
        "\u{ba2f}", "\u{1106}\u{1164}\u{11ba}"), ("\u{ba30}", "\u{ba30}",
        "\u{1106}\u{1164}\u{11bb}", "\u{ba30}", "\u{1106}\u{1164}\u{11bb}"), ("\u{ba31}",
        "\u{ba31}", "\u{1106}\u{1164}\u{11bc}", "\u{ba31}", "\u{1106}\u{1164}\u{11bc}"),
        ("\u{ba32}", "\u{ba32}", "\u{1106}\u{1164}\u{11bd}", "\u{ba32}",
        "\u{1106}\u{1164}\u{11bd}"), ("\u{ba33}", "\u{ba33}", "\u{1106}\u{1164}\u{11be}",
        "\u{ba33}", "\u{1106}\u{1164}\u{11be}"), ("\u{ba34}", "\u{ba34}",
        "\u{1106}\u{1164}\u{11bf}", "\u{ba34}", "\u{1106}\u{1164}\u{11bf}"), ("\u{ba35}",
        "\u{ba35}", "\u{1106}\u{1164}\u{11c0}", "\u{ba35}", "\u{1106}\u{1164}\u{11c0}"),
        ("\u{ba36}", "\u{ba36}", "\u{1106}\u{1164}\u{11c1}", "\u{ba36}",
        "\u{1106}\u{1164}\u{11c1}"), ("\u{ba37}", "\u{ba37}", "\u{1106}\u{1164}\u{11c2}",
        "\u{ba37}", "\u{1106}\u{1164}\u{11c2}"), ("\u{ba38}", "\u{ba38}", "\u{1106}\u{1165}",
        "\u{ba38}", "\u{1106}\u{1165}"), ("\u{ba39}", "\u{ba39}", "\u{1106}\u{1165}\u{11a8}",
        "\u{ba39}", "\u{1106}\u{1165}\u{11a8}"), ("\u{ba3a}", "\u{ba3a}",
        "\u{1106}\u{1165}\u{11a9}", "\u{ba3a}", "\u{1106}\u{1165}\u{11a9}"), ("\u{ba3b}",
        "\u{ba3b}", "\u{1106}\u{1165}\u{11aa}", "\u{ba3b}", "\u{1106}\u{1165}\u{11aa}"),
        ("\u{ba3c}", "\u{ba3c}", "\u{1106}\u{1165}\u{11ab}", "\u{ba3c}",
        "\u{1106}\u{1165}\u{11ab}"), ("\u{ba3d}", "\u{ba3d}", "\u{1106}\u{1165}\u{11ac}",
        "\u{ba3d}", "\u{1106}\u{1165}\u{11ac}"), ("\u{ba3e}", "\u{ba3e}",
        "\u{1106}\u{1165}\u{11ad}", "\u{ba3e}", "\u{1106}\u{1165}\u{11ad}"), ("\u{ba3f}",
        "\u{ba3f}", "\u{1106}\u{1165}\u{11ae}", "\u{ba3f}", "\u{1106}\u{1165}\u{11ae}"),
        ("\u{ba40}", "\u{ba40}", "\u{1106}\u{1165}\u{11af}", "\u{ba40}",
        "\u{1106}\u{1165}\u{11af}"), ("\u{ba41}", "\u{ba41}", "\u{1106}\u{1165}\u{11b0}",
        "\u{ba41}", "\u{1106}\u{1165}\u{11b0}"), ("\u{ba42}", "\u{ba42}",
        "\u{1106}\u{1165}\u{11b1}", "\u{ba42}", "\u{1106}\u{1165}\u{11b1}"), ("\u{ba43}",
        "\u{ba43}", "\u{1106}\u{1165}\u{11b2}", "\u{ba43}", "\u{1106}\u{1165}\u{11b2}"),
        ("\u{ba44}", "\u{ba44}", "\u{1106}\u{1165}\u{11b3}", "\u{ba44}",
        "\u{1106}\u{1165}\u{11b3}"), ("\u{ba45}", "\u{ba45}", "\u{1106}\u{1165}\u{11b4}",
        "\u{ba45}", "\u{1106}\u{1165}\u{11b4}"), ("\u{ba46}", "\u{ba46}",
        "\u{1106}\u{1165}\u{11b5}", "\u{ba46}", "\u{1106}\u{1165}\u{11b5}"), ("\u{ba47}",
        "\u{ba47}", "\u{1106}\u{1165}\u{11b6}", "\u{ba47}", "\u{1106}\u{1165}\u{11b6}"),
        ("\u{ba48}", "\u{ba48}", "\u{1106}\u{1165}\u{11b7}", "\u{ba48}",
        "\u{1106}\u{1165}\u{11b7}"), ("\u{ba49}", "\u{ba49}", "\u{1106}\u{1165}\u{11b8}",
        "\u{ba49}", "\u{1106}\u{1165}\u{11b8}"), ("\u{ba4a}", "\u{ba4a}",
        "\u{1106}\u{1165}\u{11b9}", "\u{ba4a}", "\u{1106}\u{1165}\u{11b9}"), ("\u{ba4b}",
        "\u{ba4b}", "\u{1106}\u{1165}\u{11ba}", "\u{ba4b}", "\u{1106}\u{1165}\u{11ba}"),
        ("\u{ba4c}", "\u{ba4c}", "\u{1106}\u{1165}\u{11bb}", "\u{ba4c}",
        "\u{1106}\u{1165}\u{11bb}"), ("\u{ba4d}", "\u{ba4d}", "\u{1106}\u{1165}\u{11bc}",
        "\u{ba4d}", "\u{1106}\u{1165}\u{11bc}"), ("\u{ba4e}", "\u{ba4e}",
        "\u{1106}\u{1165}\u{11bd}", "\u{ba4e}", "\u{1106}\u{1165}\u{11bd}"), ("\u{ba4f}",
        "\u{ba4f}", "\u{1106}\u{1165}\u{11be}", "\u{ba4f}", "\u{1106}\u{1165}\u{11be}"),
        ("\u{ba50}", "\u{ba50}", "\u{1106}\u{1165}\u{11bf}", "\u{ba50}",
        "\u{1106}\u{1165}\u{11bf}"), ("\u{ba51}", "\u{ba51}", "\u{1106}\u{1165}\u{11c0}",
        "\u{ba51}", "\u{1106}\u{1165}\u{11c0}"), ("\u{ba52}", "\u{ba52}",
        "\u{1106}\u{1165}\u{11c1}", "\u{ba52}", "\u{1106}\u{1165}\u{11c1}"), ("\u{ba53}",
        "\u{ba53}", "\u{1106}\u{1165}\u{11c2}", "\u{ba53}", "\u{1106}\u{1165}\u{11c2}"),
        ("\u{ba54}", "\u{ba54}", "\u{1106}\u{1166}", "\u{ba54}", "\u{1106}\u{1166}"), ("\u{ba55}",
        "\u{ba55}", "\u{1106}\u{1166}\u{11a8}", "\u{ba55}", "\u{1106}\u{1166}\u{11a8}"),
        ("\u{ba56}", "\u{ba56}", "\u{1106}\u{1166}\u{11a9}", "\u{ba56}",
        "\u{1106}\u{1166}\u{11a9}"), ("\u{ba57}", "\u{ba57}", "\u{1106}\u{1166}\u{11aa}",
        "\u{ba57}", "\u{1106}\u{1166}\u{11aa}"), ("\u{ba58}", "\u{ba58}",
        "\u{1106}\u{1166}\u{11ab}", "\u{ba58}", "\u{1106}\u{1166}\u{11ab}"), ("\u{ba59}",
        "\u{ba59}", "\u{1106}\u{1166}\u{11ac}", "\u{ba59}", "\u{1106}\u{1166}\u{11ac}"),
        ("\u{ba5a}", "\u{ba5a}", "\u{1106}\u{1166}\u{11ad}", "\u{ba5a}",
        "\u{1106}\u{1166}\u{11ad}"), ("\u{ba5b}", "\u{ba5b}", "\u{1106}\u{1166}\u{11ae}",
        "\u{ba5b}", "\u{1106}\u{1166}\u{11ae}"), ("\u{ba5c}", "\u{ba5c}",
        "\u{1106}\u{1166}\u{11af}", "\u{ba5c}", "\u{1106}\u{1166}\u{11af}"), ("\u{ba5d}",
        "\u{ba5d}", "\u{1106}\u{1166}\u{11b0}", "\u{ba5d}", "\u{1106}\u{1166}\u{11b0}"),
        ("\u{ba5e}", "\u{ba5e}", "\u{1106}\u{1166}\u{11b1}", "\u{ba5e}",
        "\u{1106}\u{1166}\u{11b1}"), ("\u{ba5f}", "\u{ba5f}", "\u{1106}\u{1166}\u{11b2}",
        "\u{ba5f}", "\u{1106}\u{1166}\u{11b2}"), ("\u{ba60}", "\u{ba60}",
        "\u{1106}\u{1166}\u{11b3}", "\u{ba60}", "\u{1106}\u{1166}\u{11b3}"), ("\u{ba61}",
        "\u{ba61}", "\u{1106}\u{1166}\u{11b4}", "\u{ba61}", "\u{1106}\u{1166}\u{11b4}"),
        ("\u{ba62}", "\u{ba62}", "\u{1106}\u{1166}\u{11b5}", "\u{ba62}",
        "\u{1106}\u{1166}\u{11b5}"), ("\u{ba63}", "\u{ba63}", "\u{1106}\u{1166}\u{11b6}",
        "\u{ba63}", "\u{1106}\u{1166}\u{11b6}"), ("\u{ba64}", "\u{ba64}",
        "\u{1106}\u{1166}\u{11b7}", "\u{ba64}", "\u{1106}\u{1166}\u{11b7}"), ("\u{ba65}",
        "\u{ba65}", "\u{1106}\u{1166}\u{11b8}", "\u{ba65}", "\u{1106}\u{1166}\u{11b8}"),
        ("\u{ba66}", "\u{ba66}", "\u{1106}\u{1166}\u{11b9}", "\u{ba66}",
        "\u{1106}\u{1166}\u{11b9}"), ("\u{ba67}", "\u{ba67}", "\u{1106}\u{1166}\u{11ba}",
        "\u{ba67}", "\u{1106}\u{1166}\u{11ba}"), ("\u{ba68}", "\u{ba68}",
        "\u{1106}\u{1166}\u{11bb}", "\u{ba68}", "\u{1106}\u{1166}\u{11bb}"), ("\u{ba69}",
        "\u{ba69}", "\u{1106}\u{1166}\u{11bc}", "\u{ba69}", "\u{1106}\u{1166}\u{11bc}"),
        ("\u{ba6a}", "\u{ba6a}", "\u{1106}\u{1166}\u{11bd}", "\u{ba6a}",
        "\u{1106}\u{1166}\u{11bd}"), ("\u{ba6b}", "\u{ba6b}", "\u{1106}\u{1166}\u{11be}",
        "\u{ba6b}", "\u{1106}\u{1166}\u{11be}"), ("\u{ba6c}", "\u{ba6c}",
        "\u{1106}\u{1166}\u{11bf}", "\u{ba6c}", "\u{1106}\u{1166}\u{11bf}"), ("\u{ba6d}",
        "\u{ba6d}", "\u{1106}\u{1166}\u{11c0}", "\u{ba6d}", "\u{1106}\u{1166}\u{11c0}"),
        ("\u{ba6e}", "\u{ba6e}", "\u{1106}\u{1166}\u{11c1}", "\u{ba6e}",
        "\u{1106}\u{1166}\u{11c1}"), ("\u{ba6f}", "\u{ba6f}", "\u{1106}\u{1166}\u{11c2}",
        "\u{ba6f}", "\u{1106}\u{1166}\u{11c2}"), ("\u{ba70}", "\u{ba70}", "\u{1106}\u{1167}",
        "\u{ba70}", "\u{1106}\u{1167}"), ("\u{ba71}", "\u{ba71}", "\u{1106}\u{1167}\u{11a8}",
        "\u{ba71}", "\u{1106}\u{1167}\u{11a8}"), ("\u{ba72}", "\u{ba72}",
        "\u{1106}\u{1167}\u{11a9}", "\u{ba72}", "\u{1106}\u{1167}\u{11a9}"), ("\u{ba73}",
        "\u{ba73}", "\u{1106}\u{1167}\u{11aa}", "\u{ba73}", "\u{1106}\u{1167}\u{11aa}"),
        ("\u{ba74}", "\u{ba74}", "\u{1106}\u{1167}\u{11ab}", "\u{ba74}",
        "\u{1106}\u{1167}\u{11ab}"), ("\u{ba75}", "\u{ba75}", "\u{1106}\u{1167}\u{11ac}",
        "\u{ba75}", "\u{1106}\u{1167}\u{11ac}"), ("\u{ba76}", "\u{ba76}",
        "\u{1106}\u{1167}\u{11ad}", "\u{ba76}", "\u{1106}\u{1167}\u{11ad}"), ("\u{ba77}",
        "\u{ba77}", "\u{1106}\u{1167}\u{11ae}", "\u{ba77}", "\u{1106}\u{1167}\u{11ae}"),
        ("\u{ba78}", "\u{ba78}", "\u{1106}\u{1167}\u{11af}", "\u{ba78}",
        "\u{1106}\u{1167}\u{11af}"), ("\u{ba79}", "\u{ba79}", "\u{1106}\u{1167}\u{11b0}",
        "\u{ba79}", "\u{1106}\u{1167}\u{11b0}"), ("\u{ba7a}", "\u{ba7a}",
        "\u{1106}\u{1167}\u{11b1}", "\u{ba7a}", "\u{1106}\u{1167}\u{11b1}"), ("\u{ba7b}",
        "\u{ba7b}", "\u{1106}\u{1167}\u{11b2}", "\u{ba7b}", "\u{1106}\u{1167}\u{11b2}"),
        ("\u{ba7c}", "\u{ba7c}", "\u{1106}\u{1167}\u{11b3}", "\u{ba7c}",
        "\u{1106}\u{1167}\u{11b3}"), ("\u{ba7d}", "\u{ba7d}", "\u{1106}\u{1167}\u{11b4}",
        "\u{ba7d}", "\u{1106}\u{1167}\u{11b4}"), ("\u{ba7e}", "\u{ba7e}",
        "\u{1106}\u{1167}\u{11b5}", "\u{ba7e}", "\u{1106}\u{1167}\u{11b5}"), ("\u{ba7f}",
        "\u{ba7f}", "\u{1106}\u{1167}\u{11b6}", "\u{ba7f}", "\u{1106}\u{1167}\u{11b6}"),
        ("\u{ba80}", "\u{ba80}", "\u{1106}\u{1167}\u{11b7}", "\u{ba80}",
        "\u{1106}\u{1167}\u{11b7}"), ("\u{ba81}", "\u{ba81}", "\u{1106}\u{1167}\u{11b8}",
        "\u{ba81}", "\u{1106}\u{1167}\u{11b8}"), ("\u{ba82}", "\u{ba82}",
        "\u{1106}\u{1167}\u{11b9}", "\u{ba82}", "\u{1106}\u{1167}\u{11b9}"), ("\u{ba83}",
        "\u{ba83}", "\u{1106}\u{1167}\u{11ba}", "\u{ba83}", "\u{1106}\u{1167}\u{11ba}"),
        ("\u{ba84}", "\u{ba84}", "\u{1106}\u{1167}\u{11bb}", "\u{ba84}",
        "\u{1106}\u{1167}\u{11bb}"), ("\u{ba85}", "\u{ba85}", "\u{1106}\u{1167}\u{11bc}",
        "\u{ba85}", "\u{1106}\u{1167}\u{11bc}"), ("\u{ba86}", "\u{ba86}",
        "\u{1106}\u{1167}\u{11bd}", "\u{ba86}", "\u{1106}\u{1167}\u{11bd}"), ("\u{ba87}",
        "\u{ba87}", "\u{1106}\u{1167}\u{11be}", "\u{ba87}", "\u{1106}\u{1167}\u{11be}"),
        ("\u{ba88}", "\u{ba88}", "\u{1106}\u{1167}\u{11bf}", "\u{ba88}",
        "\u{1106}\u{1167}\u{11bf}"), ("\u{ba89}", "\u{ba89}", "\u{1106}\u{1167}\u{11c0}",
        "\u{ba89}", "\u{1106}\u{1167}\u{11c0}"), ("\u{ba8a}", "\u{ba8a}",
        "\u{1106}\u{1167}\u{11c1}", "\u{ba8a}", "\u{1106}\u{1167}\u{11c1}"), ("\u{ba8b}",
        "\u{ba8b}", "\u{1106}\u{1167}\u{11c2}", "\u{ba8b}", "\u{1106}\u{1167}\u{11c2}"),
        ("\u{ba8c}", "\u{ba8c}", "\u{1106}\u{1168}", "\u{ba8c}", "\u{1106}\u{1168}"), ("\u{ba8d}",
        "\u{ba8d}", "\u{1106}\u{1168}\u{11a8}", "\u{ba8d}", "\u{1106}\u{1168}\u{11a8}"),
        ("\u{ba8e}", "\u{ba8e}", "\u{1106}\u{1168}\u{11a9}", "\u{ba8e}",
        "\u{1106}\u{1168}\u{11a9}"), ("\u{ba8f}", "\u{ba8f}", "\u{1106}\u{1168}\u{11aa}",
        "\u{ba8f}", "\u{1106}\u{1168}\u{11aa}"), ("\u{ba90}", "\u{ba90}",
        "\u{1106}\u{1168}\u{11ab}", "\u{ba90}", "\u{1106}\u{1168}\u{11ab}"), ("\u{ba91}",
        "\u{ba91}", "\u{1106}\u{1168}\u{11ac}", "\u{ba91}", "\u{1106}\u{1168}\u{11ac}"),
        ("\u{ba92}", "\u{ba92}", "\u{1106}\u{1168}\u{11ad}", "\u{ba92}",
        "\u{1106}\u{1168}\u{11ad}"), ("\u{ba93}", "\u{ba93}", "\u{1106}\u{1168}\u{11ae}",
        "\u{ba93}", "\u{1106}\u{1168}\u{11ae}"), ("\u{ba94}", "\u{ba94}",
        "\u{1106}\u{1168}\u{11af}", "\u{ba94}", "\u{1106}\u{1168}\u{11af}"), ("\u{ba95}",
        "\u{ba95}", "\u{1106}\u{1168}\u{11b0}", "\u{ba95}", "\u{1106}\u{1168}\u{11b0}"),
        ("\u{ba96}", "\u{ba96}", "\u{1106}\u{1168}\u{11b1}", "\u{ba96}",
        "\u{1106}\u{1168}\u{11b1}"), ("\u{ba97}", "\u{ba97}", "\u{1106}\u{1168}\u{11b2}",
        "\u{ba97}", "\u{1106}\u{1168}\u{11b2}"), ("\u{ba98}", "\u{ba98}",
        "\u{1106}\u{1168}\u{11b3}", "\u{ba98}", "\u{1106}\u{1168}\u{11b3}"), ("\u{ba99}",
        "\u{ba99}", "\u{1106}\u{1168}\u{11b4}", "\u{ba99}", "\u{1106}\u{1168}\u{11b4}"),
        ("\u{ba9a}", "\u{ba9a}", "\u{1106}\u{1168}\u{11b5}", "\u{ba9a}",
        "\u{1106}\u{1168}\u{11b5}"), ("\u{ba9b}", "\u{ba9b}", "\u{1106}\u{1168}\u{11b6}",
        "\u{ba9b}", "\u{1106}\u{1168}\u{11b6}"), ("\u{ba9c}", "\u{ba9c}",
        "\u{1106}\u{1168}\u{11b7}", "\u{ba9c}", "\u{1106}\u{1168}\u{11b7}"), ("\u{ba9d}",
        "\u{ba9d}", "\u{1106}\u{1168}\u{11b8}", "\u{ba9d}", "\u{1106}\u{1168}\u{11b8}"),
        ("\u{ba9e}", "\u{ba9e}", "\u{1106}\u{1168}\u{11b9}", "\u{ba9e}",
        "\u{1106}\u{1168}\u{11b9}"), ("\u{ba9f}", "\u{ba9f}", "\u{1106}\u{1168}\u{11ba}",
        "\u{ba9f}", "\u{1106}\u{1168}\u{11ba}"), ("\u{baa0}", "\u{baa0}",
        "\u{1106}\u{1168}\u{11bb}", "\u{baa0}", "\u{1106}\u{1168}\u{11bb}"), ("\u{baa1}",
        "\u{baa1}", "\u{1106}\u{1168}\u{11bc}", "\u{baa1}", "\u{1106}\u{1168}\u{11bc}"),
        ("\u{baa2}", "\u{baa2}", "\u{1106}\u{1168}\u{11bd}", "\u{baa2}",
        "\u{1106}\u{1168}\u{11bd}"), ("\u{baa3}", "\u{baa3}", "\u{1106}\u{1168}\u{11be}",
        "\u{baa3}", "\u{1106}\u{1168}\u{11be}"), ("\u{baa4}", "\u{baa4}",
        "\u{1106}\u{1168}\u{11bf}", "\u{baa4}", "\u{1106}\u{1168}\u{11bf}"), ("\u{baa5}",
        "\u{baa5}", "\u{1106}\u{1168}\u{11c0}", "\u{baa5}", "\u{1106}\u{1168}\u{11c0}"),
        ("\u{baa6}", "\u{baa6}", "\u{1106}\u{1168}\u{11c1}", "\u{baa6}",
        "\u{1106}\u{1168}\u{11c1}"), ("\u{baa7}", "\u{baa7}", "\u{1106}\u{1168}\u{11c2}",
        "\u{baa7}", "\u{1106}\u{1168}\u{11c2}"), ("\u{baa8}", "\u{baa8}", "\u{1106}\u{1169}",
        "\u{baa8}", "\u{1106}\u{1169}"), ("\u{baa9}", "\u{baa9}", "\u{1106}\u{1169}\u{11a8}",
        "\u{baa9}", "\u{1106}\u{1169}\u{11a8}"), ("\u{baaa}", "\u{baaa}",
        "\u{1106}\u{1169}\u{11a9}", "\u{baaa}", "\u{1106}\u{1169}\u{11a9}"), ("\u{baab}",
        "\u{baab}", "\u{1106}\u{1169}\u{11aa}", "\u{baab}", "\u{1106}\u{1169}\u{11aa}"),
        ("\u{baac}", "\u{baac}", "\u{1106}\u{1169}\u{11ab}", "\u{baac}",
        "\u{1106}\u{1169}\u{11ab}"), ("\u{baad}", "\u{baad}", "\u{1106}\u{1169}\u{11ac}",
        "\u{baad}", "\u{1106}\u{1169}\u{11ac}"), ("\u{baae}", "\u{baae}",
        "\u{1106}\u{1169}\u{11ad}", "\u{baae}", "\u{1106}\u{1169}\u{11ad}"), ("\u{baaf}",
        "\u{baaf}", "\u{1106}\u{1169}\u{11ae}", "\u{baaf}", "\u{1106}\u{1169}\u{11ae}"),
        ("\u{bab0}", "\u{bab0}", "\u{1106}\u{1169}\u{11af}", "\u{bab0}",
        "\u{1106}\u{1169}\u{11af}"), ("\u{bab1}", "\u{bab1}", "\u{1106}\u{1169}\u{11b0}",
        "\u{bab1}", "\u{1106}\u{1169}\u{11b0}"), ("\u{bab2}", "\u{bab2}",
        "\u{1106}\u{1169}\u{11b1}", "\u{bab2}", "\u{1106}\u{1169}\u{11b1}"), ("\u{bab3}",
        "\u{bab3}", "\u{1106}\u{1169}\u{11b2}", "\u{bab3}", "\u{1106}\u{1169}\u{11b2}"),
        ("\u{bab4}", "\u{bab4}", "\u{1106}\u{1169}\u{11b3}", "\u{bab4}",
        "\u{1106}\u{1169}\u{11b3}"), ("\u{bab5}", "\u{bab5}", "\u{1106}\u{1169}\u{11b4}",
        "\u{bab5}", "\u{1106}\u{1169}\u{11b4}"), ("\u{bab6}", "\u{bab6}",
        "\u{1106}\u{1169}\u{11b5}", "\u{bab6}", "\u{1106}\u{1169}\u{11b5}"), ("\u{bab7}",
        "\u{bab7}", "\u{1106}\u{1169}\u{11b6}", "\u{bab7}", "\u{1106}\u{1169}\u{11b6}"),
        ("\u{bab8}", "\u{bab8}", "\u{1106}\u{1169}\u{11b7}", "\u{bab8}",
        "\u{1106}\u{1169}\u{11b7}"), ("\u{bab9}", "\u{bab9}", "\u{1106}\u{1169}\u{11b8}",
        "\u{bab9}", "\u{1106}\u{1169}\u{11b8}"), ("\u{baba}", "\u{baba}",
        "\u{1106}\u{1169}\u{11b9}", "\u{baba}", "\u{1106}\u{1169}\u{11b9}"), ("\u{babb}",
        "\u{babb}", "\u{1106}\u{1169}\u{11ba}", "\u{babb}", "\u{1106}\u{1169}\u{11ba}"),
        ("\u{babc}", "\u{babc}", "\u{1106}\u{1169}\u{11bb}", "\u{babc}",
        "\u{1106}\u{1169}\u{11bb}"), ("\u{babd}", "\u{babd}", "\u{1106}\u{1169}\u{11bc}",
        "\u{babd}", "\u{1106}\u{1169}\u{11bc}"), ("\u{babe}", "\u{babe}",
        "\u{1106}\u{1169}\u{11bd}", "\u{babe}", "\u{1106}\u{1169}\u{11bd}"), ("\u{babf}",
        "\u{babf}", "\u{1106}\u{1169}\u{11be}", "\u{babf}", "\u{1106}\u{1169}\u{11be}"),
        ("\u{bac0}", "\u{bac0}", "\u{1106}\u{1169}\u{11bf}", "\u{bac0}",
        "\u{1106}\u{1169}\u{11bf}"), ("\u{bac1}", "\u{bac1}", "\u{1106}\u{1169}\u{11c0}",
        "\u{bac1}", "\u{1106}\u{1169}\u{11c0}"), ("\u{bac2}", "\u{bac2}",
        "\u{1106}\u{1169}\u{11c1}", "\u{bac2}", "\u{1106}\u{1169}\u{11c1}"), ("\u{bac3}",
        "\u{bac3}", "\u{1106}\u{1169}\u{11c2}", "\u{bac3}", "\u{1106}\u{1169}\u{11c2}"),
        ("\u{bac4}", "\u{bac4}", "\u{1106}\u{116a}", "\u{bac4}", "\u{1106}\u{116a}"), ("\u{bac5}",
        "\u{bac5}", "\u{1106}\u{116a}\u{11a8}", "\u{bac5}", "\u{1106}\u{116a}\u{11a8}"),
        ("\u{bac6}", "\u{bac6}", "\u{1106}\u{116a}\u{11a9}", "\u{bac6}",
        "\u{1106}\u{116a}\u{11a9}"), ("\u{bac7}", "\u{bac7}", "\u{1106}\u{116a}\u{11aa}",
        "\u{bac7}", "\u{1106}\u{116a}\u{11aa}"), ("\u{bac8}", "\u{bac8}",
        "\u{1106}\u{116a}\u{11ab}", "\u{bac8}", "\u{1106}\u{116a}\u{11ab}"), ("\u{bac9}",
        "\u{bac9}", "\u{1106}\u{116a}\u{11ac}", "\u{bac9}", "\u{1106}\u{116a}\u{11ac}"),
        ("\u{baca}", "\u{baca}", "\u{1106}\u{116a}\u{11ad}", "\u{baca}",
        "\u{1106}\u{116a}\u{11ad}"), ("\u{bacb}", "\u{bacb}", "\u{1106}\u{116a}\u{11ae}",
        "\u{bacb}", "\u{1106}\u{116a}\u{11ae}"), ("\u{bacc}", "\u{bacc}",
        "\u{1106}\u{116a}\u{11af}", "\u{bacc}", "\u{1106}\u{116a}\u{11af}"), ("\u{bacd}",
        "\u{bacd}", "\u{1106}\u{116a}\u{11b0}", "\u{bacd}", "\u{1106}\u{116a}\u{11b0}"),
        ("\u{bace}", "\u{bace}", "\u{1106}\u{116a}\u{11b1}", "\u{bace}",
        "\u{1106}\u{116a}\u{11b1}"), ("\u{bacf}", "\u{bacf}", "\u{1106}\u{116a}\u{11b2}",
        "\u{bacf}", "\u{1106}\u{116a}\u{11b2}"), ("\u{bad0}", "\u{bad0}",
        "\u{1106}\u{116a}\u{11b3}", "\u{bad0}", "\u{1106}\u{116a}\u{11b3}"), ("\u{bad1}",
        "\u{bad1}", "\u{1106}\u{116a}\u{11b4}", "\u{bad1}", "\u{1106}\u{116a}\u{11b4}"),
        ("\u{bad2}", "\u{bad2}", "\u{1106}\u{116a}\u{11b5}", "\u{bad2}",
        "\u{1106}\u{116a}\u{11b5}"), ("\u{bad3}", "\u{bad3}", "\u{1106}\u{116a}\u{11b6}",
        "\u{bad3}", "\u{1106}\u{116a}\u{11b6}"), ("\u{bad4}", "\u{bad4}",
        "\u{1106}\u{116a}\u{11b7}", "\u{bad4}", "\u{1106}\u{116a}\u{11b7}"), ("\u{bad5}",
        "\u{bad5}", "\u{1106}\u{116a}\u{11b8}", "\u{bad5}", "\u{1106}\u{116a}\u{11b8}"),
        ("\u{bad6}", "\u{bad6}", "\u{1106}\u{116a}\u{11b9}", "\u{bad6}",
        "\u{1106}\u{116a}\u{11b9}"), ("\u{bad7}", "\u{bad7}", "\u{1106}\u{116a}\u{11ba}",
        "\u{bad7}", "\u{1106}\u{116a}\u{11ba}"), ("\u{bad8}", "\u{bad8}",
        "\u{1106}\u{116a}\u{11bb}", "\u{bad8}", "\u{1106}\u{116a}\u{11bb}"), ("\u{bad9}",
        "\u{bad9}", "\u{1106}\u{116a}\u{11bc}", "\u{bad9}", "\u{1106}\u{116a}\u{11bc}"),
        ("\u{bada}", "\u{bada}", "\u{1106}\u{116a}\u{11bd}", "\u{bada}",
        "\u{1106}\u{116a}\u{11bd}"), ("\u{badb}", "\u{badb}", "\u{1106}\u{116a}\u{11be}",
        "\u{badb}", "\u{1106}\u{116a}\u{11be}"), ("\u{badc}", "\u{badc}",
        "\u{1106}\u{116a}\u{11bf}", "\u{badc}", "\u{1106}\u{116a}\u{11bf}"), ("\u{badd}",
        "\u{badd}", "\u{1106}\u{116a}\u{11c0}", "\u{badd}", "\u{1106}\u{116a}\u{11c0}"),
        ("\u{bade}", "\u{bade}", "\u{1106}\u{116a}\u{11c1}", "\u{bade}",
        "\u{1106}\u{116a}\u{11c1}"), ("\u{badf}", "\u{badf}", "\u{1106}\u{116a}\u{11c2}",
        "\u{badf}", "\u{1106}\u{116a}\u{11c2}"), ("\u{bae0}", "\u{bae0}", "\u{1106}\u{116b}",
        "\u{bae0}", "\u{1106}\u{116b}"), ("\u{bae1}", "\u{bae1}", "\u{1106}\u{116b}\u{11a8}",
        "\u{bae1}", "\u{1106}\u{116b}\u{11a8}"), ("\u{bae2}", "\u{bae2}",
        "\u{1106}\u{116b}\u{11a9}", "\u{bae2}", "\u{1106}\u{116b}\u{11a9}"), ("\u{bae3}",
        "\u{bae3}", "\u{1106}\u{116b}\u{11aa}", "\u{bae3}", "\u{1106}\u{116b}\u{11aa}"),
        ("\u{bae4}", "\u{bae4}", "\u{1106}\u{116b}\u{11ab}", "\u{bae4}",
        "\u{1106}\u{116b}\u{11ab}"), ("\u{bae5}", "\u{bae5}", "\u{1106}\u{116b}\u{11ac}",
        "\u{bae5}", "\u{1106}\u{116b}\u{11ac}"), ("\u{bae6}", "\u{bae6}",
        "\u{1106}\u{116b}\u{11ad}", "\u{bae6}", "\u{1106}\u{116b}\u{11ad}"), ("\u{bae7}",
        "\u{bae7}", "\u{1106}\u{116b}\u{11ae}", "\u{bae7}", "\u{1106}\u{116b}\u{11ae}"),
        ("\u{bae8}", "\u{bae8}", "\u{1106}\u{116b}\u{11af}", "\u{bae8}",
        "\u{1106}\u{116b}\u{11af}"), ("\u{bae9}", "\u{bae9}", "\u{1106}\u{116b}\u{11b0}",
        "\u{bae9}", "\u{1106}\u{116b}\u{11b0}"), ("\u{baea}", "\u{baea}",
        "\u{1106}\u{116b}\u{11b1}", "\u{baea}", "\u{1106}\u{116b}\u{11b1}"), ("\u{baeb}",
        "\u{baeb}", "\u{1106}\u{116b}\u{11b2}", "\u{baeb}", "\u{1106}\u{116b}\u{11b2}"),
        ("\u{baec}", "\u{baec}", "\u{1106}\u{116b}\u{11b3}", "\u{baec}",
        "\u{1106}\u{116b}\u{11b3}"), ("\u{baed}", "\u{baed}", "\u{1106}\u{116b}\u{11b4}",
        "\u{baed}", "\u{1106}\u{116b}\u{11b4}"), ("\u{baee}", "\u{baee}",
        "\u{1106}\u{116b}\u{11b5}", "\u{baee}", "\u{1106}\u{116b}\u{11b5}"), ("\u{baef}",
        "\u{baef}", "\u{1106}\u{116b}\u{11b6}", "\u{baef}", "\u{1106}\u{116b}\u{11b6}"),
        ("\u{baf0}", "\u{baf0}", "\u{1106}\u{116b}\u{11b7}", "\u{baf0}",
        "\u{1106}\u{116b}\u{11b7}"), ("\u{baf1}", "\u{baf1}", "\u{1106}\u{116b}\u{11b8}",
        "\u{baf1}", "\u{1106}\u{116b}\u{11b8}"), ("\u{baf2}", "\u{baf2}",
        "\u{1106}\u{116b}\u{11b9}", "\u{baf2}", "\u{1106}\u{116b}\u{11b9}"), ("\u{baf3}",
        "\u{baf3}", "\u{1106}\u{116b}\u{11ba}", "\u{baf3}", "\u{1106}\u{116b}\u{11ba}"),
        ("\u{baf4}", "\u{baf4}", "\u{1106}\u{116b}\u{11bb}", "\u{baf4}",
        "\u{1106}\u{116b}\u{11bb}"), ("\u{baf5}", "\u{baf5}", "\u{1106}\u{116b}\u{11bc}",
        "\u{baf5}", "\u{1106}\u{116b}\u{11bc}"), ("\u{baf6}", "\u{baf6}",
        "\u{1106}\u{116b}\u{11bd}", "\u{baf6}", "\u{1106}\u{116b}\u{11bd}"), ("\u{baf7}",
        "\u{baf7}", "\u{1106}\u{116b}\u{11be}", "\u{baf7}", "\u{1106}\u{116b}\u{11be}"),
        ("\u{baf8}", "\u{baf8}", "\u{1106}\u{116b}\u{11bf}", "\u{baf8}",
        "\u{1106}\u{116b}\u{11bf}"), ("\u{baf9}", "\u{baf9}", "\u{1106}\u{116b}\u{11c0}",
        "\u{baf9}", "\u{1106}\u{116b}\u{11c0}"), ("\u{bafa}", "\u{bafa}",
        "\u{1106}\u{116b}\u{11c1}", "\u{bafa}", "\u{1106}\u{116b}\u{11c1}"), ("\u{bafb}",
        "\u{bafb}", "\u{1106}\u{116b}\u{11c2}", "\u{bafb}", "\u{1106}\u{116b}\u{11c2}"),
        ("\u{bafc}", "\u{bafc}", "\u{1106}\u{116c}", "\u{bafc}", "\u{1106}\u{116c}"), ("\u{bafd}",
        "\u{bafd}", "\u{1106}\u{116c}\u{11a8}", "\u{bafd}", "\u{1106}\u{116c}\u{11a8}"),
        ("\u{bafe}", "\u{bafe}", "\u{1106}\u{116c}\u{11a9}", "\u{bafe}",
        "\u{1106}\u{116c}\u{11a9}"), ("\u{baff}", "\u{baff}", "\u{1106}\u{116c}\u{11aa}",
        "\u{baff}", "\u{1106}\u{116c}\u{11aa}"), ("\u{bb00}", "\u{bb00}",
        "\u{1106}\u{116c}\u{11ab}", "\u{bb00}", "\u{1106}\u{116c}\u{11ab}"), ("\u{bb01}",
        "\u{bb01}", "\u{1106}\u{116c}\u{11ac}", "\u{bb01}", "\u{1106}\u{116c}\u{11ac}"),
        ("\u{bb02}", "\u{bb02}", "\u{1106}\u{116c}\u{11ad}", "\u{bb02}",
        "\u{1106}\u{116c}\u{11ad}"), ("\u{bb03}", "\u{bb03}", "\u{1106}\u{116c}\u{11ae}",
        "\u{bb03}", "\u{1106}\u{116c}\u{11ae}"), ("\u{bb04}", "\u{bb04}",
        "\u{1106}\u{116c}\u{11af}", "\u{bb04}", "\u{1106}\u{116c}\u{11af}"), ("\u{bb05}",
        "\u{bb05}", "\u{1106}\u{116c}\u{11b0}", "\u{bb05}", "\u{1106}\u{116c}\u{11b0}"),
        ("\u{bb06}", "\u{bb06}", "\u{1106}\u{116c}\u{11b1}", "\u{bb06}",
        "\u{1106}\u{116c}\u{11b1}"), ("\u{bb07}", "\u{bb07}", "\u{1106}\u{116c}\u{11b2}",
        "\u{bb07}", "\u{1106}\u{116c}\u{11b2}"), ("\u{bb08}", "\u{bb08}",
        "\u{1106}\u{116c}\u{11b3}", "\u{bb08}", "\u{1106}\u{116c}\u{11b3}"), ("\u{bb09}",
        "\u{bb09}", "\u{1106}\u{116c}\u{11b4}", "\u{bb09}", "\u{1106}\u{116c}\u{11b4}"),
        ("\u{bb0a}", "\u{bb0a}", "\u{1106}\u{116c}\u{11b5}", "\u{bb0a}",
        "\u{1106}\u{116c}\u{11b5}"), ("\u{bb0b}", "\u{bb0b}", "\u{1106}\u{116c}\u{11b6}",
        "\u{bb0b}", "\u{1106}\u{116c}\u{11b6}"), ("\u{bb0c}", "\u{bb0c}",
        "\u{1106}\u{116c}\u{11b7}", "\u{bb0c}", "\u{1106}\u{116c}\u{11b7}"), ("\u{bb0d}",
        "\u{bb0d}", "\u{1106}\u{116c}\u{11b8}", "\u{bb0d}", "\u{1106}\u{116c}\u{11b8}"),
        ("\u{bb0e}", "\u{bb0e}", "\u{1106}\u{116c}\u{11b9}", "\u{bb0e}",
        "\u{1106}\u{116c}\u{11b9}"), ("\u{bb0f}", "\u{bb0f}", "\u{1106}\u{116c}\u{11ba}",
        "\u{bb0f}", "\u{1106}\u{116c}\u{11ba}"), ("\u{bb10}", "\u{bb10}",
        "\u{1106}\u{116c}\u{11bb}", "\u{bb10}", "\u{1106}\u{116c}\u{11bb}"), ("\u{bb11}",
        "\u{bb11}", "\u{1106}\u{116c}\u{11bc}", "\u{bb11}", "\u{1106}\u{116c}\u{11bc}"),
        ("\u{bb12}", "\u{bb12}", "\u{1106}\u{116c}\u{11bd}", "\u{bb12}",
        "\u{1106}\u{116c}\u{11bd}"), ("\u{bb13}", "\u{bb13}", "\u{1106}\u{116c}\u{11be}",
        "\u{bb13}", "\u{1106}\u{116c}\u{11be}"), ("\u{bb14}", "\u{bb14}",
        "\u{1106}\u{116c}\u{11bf}", "\u{bb14}", "\u{1106}\u{116c}\u{11bf}"), ("\u{bb15}",
        "\u{bb15}", "\u{1106}\u{116c}\u{11c0}", "\u{bb15}", "\u{1106}\u{116c}\u{11c0}"),
        ("\u{bb16}", "\u{bb16}", "\u{1106}\u{116c}\u{11c1}", "\u{bb16}",
        "\u{1106}\u{116c}\u{11c1}"), ("\u{bb17}", "\u{bb17}", "\u{1106}\u{116c}\u{11c2}",
        "\u{bb17}", "\u{1106}\u{116c}\u{11c2}"), ("\u{bb18}", "\u{bb18}", "\u{1106}\u{116d}",
        "\u{bb18}", "\u{1106}\u{116d}"), ("\u{bb19}", "\u{bb19}", "\u{1106}\u{116d}\u{11a8}",
        "\u{bb19}", "\u{1106}\u{116d}\u{11a8}"), ("\u{bb1a}", "\u{bb1a}",
        "\u{1106}\u{116d}\u{11a9}", "\u{bb1a}", "\u{1106}\u{116d}\u{11a9}"), ("\u{bb1b}",
        "\u{bb1b}", "\u{1106}\u{116d}\u{11aa}", "\u{bb1b}", "\u{1106}\u{116d}\u{11aa}"),
        ("\u{bb1c}", "\u{bb1c}", "\u{1106}\u{116d}\u{11ab}", "\u{bb1c}",
        "\u{1106}\u{116d}\u{11ab}"), ("\u{bb1d}", "\u{bb1d}", "\u{1106}\u{116d}\u{11ac}",
        "\u{bb1d}", "\u{1106}\u{116d}\u{11ac}"), ("\u{bb1e}", "\u{bb1e}",
        "\u{1106}\u{116d}\u{11ad}", "\u{bb1e}", "\u{1106}\u{116d}\u{11ad}"), ("\u{bb1f}",
        "\u{bb1f}", "\u{1106}\u{116d}\u{11ae}", "\u{bb1f}", "\u{1106}\u{116d}\u{11ae}"),
        ("\u{bb20}", "\u{bb20}", "\u{1106}\u{116d}\u{11af}", "\u{bb20}",
        "\u{1106}\u{116d}\u{11af}"), ("\u{bb21}", "\u{bb21}", "\u{1106}\u{116d}\u{11b0}",
        "\u{bb21}", "\u{1106}\u{116d}\u{11b0}"), ("\u{bb22}", "\u{bb22}",
        "\u{1106}\u{116d}\u{11b1}", "\u{bb22}", "\u{1106}\u{116d}\u{11b1}"), ("\u{bb23}",
        "\u{bb23}", "\u{1106}\u{116d}\u{11b2}", "\u{bb23}", "\u{1106}\u{116d}\u{11b2}"),
        ("\u{bb24}", "\u{bb24}", "\u{1106}\u{116d}\u{11b3}", "\u{bb24}",
        "\u{1106}\u{116d}\u{11b3}"), ("\u{bb25}", "\u{bb25}", "\u{1106}\u{116d}\u{11b4}",
        "\u{bb25}", "\u{1106}\u{116d}\u{11b4}"), ("\u{bb26}", "\u{bb26}",
        "\u{1106}\u{116d}\u{11b5}", "\u{bb26}", "\u{1106}\u{116d}\u{11b5}"), ("\u{bb27}",
        "\u{bb27}", "\u{1106}\u{116d}\u{11b6}", "\u{bb27}", "\u{1106}\u{116d}\u{11b6}"),
        ("\u{bb28}", "\u{bb28}", "\u{1106}\u{116d}\u{11b7}", "\u{bb28}",
        "\u{1106}\u{116d}\u{11b7}"), ("\u{bb29}", "\u{bb29}", "\u{1106}\u{116d}\u{11b8}",
        "\u{bb29}", "\u{1106}\u{116d}\u{11b8}"), ("\u{bb2a}", "\u{bb2a}",
        "\u{1106}\u{116d}\u{11b9}", "\u{bb2a}", "\u{1106}\u{116d}\u{11b9}"), ("\u{bb2b}",
        "\u{bb2b}", "\u{1106}\u{116d}\u{11ba}", "\u{bb2b}", "\u{1106}\u{116d}\u{11ba}"),
        ("\u{bb2c}", "\u{bb2c}", "\u{1106}\u{116d}\u{11bb}", "\u{bb2c}",
        "\u{1106}\u{116d}\u{11bb}"), ("\u{bb2d}", "\u{bb2d}", "\u{1106}\u{116d}\u{11bc}",
        "\u{bb2d}", "\u{1106}\u{116d}\u{11bc}"), ("\u{bb2e}", "\u{bb2e}",
        "\u{1106}\u{116d}\u{11bd}", "\u{bb2e}", "\u{1106}\u{116d}\u{11bd}"), ("\u{bb2f}",
        "\u{bb2f}", "\u{1106}\u{116d}\u{11be}", "\u{bb2f}", "\u{1106}\u{116d}\u{11be}"),
        ("\u{bb30}", "\u{bb30}", "\u{1106}\u{116d}\u{11bf}", "\u{bb30}",
        "\u{1106}\u{116d}\u{11bf}"), ("\u{bb31}", "\u{bb31}", "\u{1106}\u{116d}\u{11c0}",
        "\u{bb31}", "\u{1106}\u{116d}\u{11c0}"), ("\u{bb32}", "\u{bb32}",
        "\u{1106}\u{116d}\u{11c1}", "\u{bb32}", "\u{1106}\u{116d}\u{11c1}"), ("\u{bb33}",
        "\u{bb33}", "\u{1106}\u{116d}\u{11c2}", "\u{bb33}", "\u{1106}\u{116d}\u{11c2}"),
        ("\u{bb34}", "\u{bb34}", "\u{1106}\u{116e}", "\u{bb34}", "\u{1106}\u{116e}"), ("\u{bb35}",
        "\u{bb35}", "\u{1106}\u{116e}\u{11a8}", "\u{bb35}", "\u{1106}\u{116e}\u{11a8}"),
        ("\u{bb36}", "\u{bb36}", "\u{1106}\u{116e}\u{11a9}", "\u{bb36}",
        "\u{1106}\u{116e}\u{11a9}"), ("\u{bb37}", "\u{bb37}", "\u{1106}\u{116e}\u{11aa}",
        "\u{bb37}", "\u{1106}\u{116e}\u{11aa}"), ("\u{bb38}", "\u{bb38}",
        "\u{1106}\u{116e}\u{11ab}", "\u{bb38}", "\u{1106}\u{116e}\u{11ab}"), ("\u{bb39}",
        "\u{bb39}", "\u{1106}\u{116e}\u{11ac}", "\u{bb39}", "\u{1106}\u{116e}\u{11ac}"),
        ("\u{bb3a}", "\u{bb3a}", "\u{1106}\u{116e}\u{11ad}", "\u{bb3a}",
        "\u{1106}\u{116e}\u{11ad}"), ("\u{bb3b}", "\u{bb3b}", "\u{1106}\u{116e}\u{11ae}",
        "\u{bb3b}", "\u{1106}\u{116e}\u{11ae}"), ("\u{bb3c}", "\u{bb3c}",
        "\u{1106}\u{116e}\u{11af}", "\u{bb3c}", "\u{1106}\u{116e}\u{11af}"), ("\u{bb3d}",
        "\u{bb3d}", "\u{1106}\u{116e}\u{11b0}", "\u{bb3d}", "\u{1106}\u{116e}\u{11b0}"),
        ("\u{bb3e}", "\u{bb3e}", "\u{1106}\u{116e}\u{11b1}", "\u{bb3e}",
        "\u{1106}\u{116e}\u{11b1}"), ("\u{bb3f}", "\u{bb3f}", "\u{1106}\u{116e}\u{11b2}",
        "\u{bb3f}", "\u{1106}\u{116e}\u{11b2}"), ("\u{bb40}", "\u{bb40}",
        "\u{1106}\u{116e}\u{11b3}", "\u{bb40}", "\u{1106}\u{116e}\u{11b3}"), ("\u{bb41}",
        "\u{bb41}", "\u{1106}\u{116e}\u{11b4}", "\u{bb41}", "\u{1106}\u{116e}\u{11b4}"),
        ("\u{bb42}", "\u{bb42}", "\u{1106}\u{116e}\u{11b5}", "\u{bb42}",
        "\u{1106}\u{116e}\u{11b5}"), ("\u{bb43}", "\u{bb43}", "\u{1106}\u{116e}\u{11b6}",
        "\u{bb43}", "\u{1106}\u{116e}\u{11b6}"), ("\u{bb44}", "\u{bb44}",
        "\u{1106}\u{116e}\u{11b7}", "\u{bb44}", "\u{1106}\u{116e}\u{11b7}"), ("\u{bb45}",
        "\u{bb45}", "\u{1106}\u{116e}\u{11b8}", "\u{bb45}", "\u{1106}\u{116e}\u{11b8}"),
        ("\u{bb46}", "\u{bb46}", "\u{1106}\u{116e}\u{11b9}", "\u{bb46}",
        "\u{1106}\u{116e}\u{11b9}"), ("\u{bb47}", "\u{bb47}", "\u{1106}\u{116e}\u{11ba}",
        "\u{bb47}", "\u{1106}\u{116e}\u{11ba}"), ("\u{bb48}", "\u{bb48}",
        "\u{1106}\u{116e}\u{11bb}", "\u{bb48}", "\u{1106}\u{116e}\u{11bb}"), ("\u{bb49}",
        "\u{bb49}", "\u{1106}\u{116e}\u{11bc}", "\u{bb49}", "\u{1106}\u{116e}\u{11bc}"),
        ("\u{bb4a}", "\u{bb4a}", "\u{1106}\u{116e}\u{11bd}", "\u{bb4a}",
        "\u{1106}\u{116e}\u{11bd}"), ("\u{bb4b}", "\u{bb4b}", "\u{1106}\u{116e}\u{11be}",
        "\u{bb4b}", "\u{1106}\u{116e}\u{11be}"), ("\u{bb4c}", "\u{bb4c}",
        "\u{1106}\u{116e}\u{11bf}", "\u{bb4c}", "\u{1106}\u{116e}\u{11bf}"), ("\u{bb4d}",
        "\u{bb4d}", "\u{1106}\u{116e}\u{11c0}", "\u{bb4d}", "\u{1106}\u{116e}\u{11c0}"),
        ("\u{bb4e}", "\u{bb4e}", "\u{1106}\u{116e}\u{11c1}", "\u{bb4e}",
        "\u{1106}\u{116e}\u{11c1}"), ("\u{bb4f}", "\u{bb4f}", "\u{1106}\u{116e}\u{11c2}",
        "\u{bb4f}", "\u{1106}\u{116e}\u{11c2}"), ("\u{bb50}", "\u{bb50}", "\u{1106}\u{116f}",
        "\u{bb50}", "\u{1106}\u{116f}"), ("\u{bb51}", "\u{bb51}", "\u{1106}\u{116f}\u{11a8}",
        "\u{bb51}", "\u{1106}\u{116f}\u{11a8}"), ("\u{bb52}", "\u{bb52}",
        "\u{1106}\u{116f}\u{11a9}", "\u{bb52}", "\u{1106}\u{116f}\u{11a9}"), ("\u{bb53}",
        "\u{bb53}", "\u{1106}\u{116f}\u{11aa}", "\u{bb53}", "\u{1106}\u{116f}\u{11aa}"),
        ("\u{bb54}", "\u{bb54}", "\u{1106}\u{116f}\u{11ab}", "\u{bb54}",
        "\u{1106}\u{116f}\u{11ab}"), ("\u{bb55}", "\u{bb55}", "\u{1106}\u{116f}\u{11ac}",
        "\u{bb55}", "\u{1106}\u{116f}\u{11ac}"), ("\u{bb56}", "\u{bb56}",
        "\u{1106}\u{116f}\u{11ad}", "\u{bb56}", "\u{1106}\u{116f}\u{11ad}"), ("\u{bb57}",
        "\u{bb57}", "\u{1106}\u{116f}\u{11ae}", "\u{bb57}", "\u{1106}\u{116f}\u{11ae}"),
        ("\u{bb58}", "\u{bb58}", "\u{1106}\u{116f}\u{11af}", "\u{bb58}",
        "\u{1106}\u{116f}\u{11af}"), ("\u{bb59}", "\u{bb59}", "\u{1106}\u{116f}\u{11b0}",
        "\u{bb59}", "\u{1106}\u{116f}\u{11b0}"), ("\u{bb5a}", "\u{bb5a}",
        "\u{1106}\u{116f}\u{11b1}", "\u{bb5a}", "\u{1106}\u{116f}\u{11b1}"), ("\u{bb5b}",
        "\u{bb5b}", "\u{1106}\u{116f}\u{11b2}", "\u{bb5b}", "\u{1106}\u{116f}\u{11b2}"),
        ("\u{bb5c}", "\u{bb5c}", "\u{1106}\u{116f}\u{11b3}", "\u{bb5c}",
        "\u{1106}\u{116f}\u{11b3}"), ("\u{bb5d}", "\u{bb5d}", "\u{1106}\u{116f}\u{11b4}",
        "\u{bb5d}", "\u{1106}\u{116f}\u{11b4}"), ("\u{bb5e}", "\u{bb5e}",
        "\u{1106}\u{116f}\u{11b5}", "\u{bb5e}", "\u{1106}\u{116f}\u{11b5}"), ("\u{bb5f}",
        "\u{bb5f}", "\u{1106}\u{116f}\u{11b6}", "\u{bb5f}", "\u{1106}\u{116f}\u{11b6}"),
        ("\u{bb60}", "\u{bb60}", "\u{1106}\u{116f}\u{11b7}", "\u{bb60}",
        "\u{1106}\u{116f}\u{11b7}"), ("\u{bb61}", "\u{bb61}", "\u{1106}\u{116f}\u{11b8}",
        "\u{bb61}", "\u{1106}\u{116f}\u{11b8}"), ("\u{bb62}", "\u{bb62}",
        "\u{1106}\u{116f}\u{11b9}", "\u{bb62}", "\u{1106}\u{116f}\u{11b9}"), ("\u{bb63}",
        "\u{bb63}", "\u{1106}\u{116f}\u{11ba}", "\u{bb63}", "\u{1106}\u{116f}\u{11ba}"),
        ("\u{bb64}", "\u{bb64}", "\u{1106}\u{116f}\u{11bb}", "\u{bb64}",
        "\u{1106}\u{116f}\u{11bb}"), ("\u{bb65}", "\u{bb65}", "\u{1106}\u{116f}\u{11bc}",
        "\u{bb65}", "\u{1106}\u{116f}\u{11bc}"), ("\u{bb66}", "\u{bb66}",
        "\u{1106}\u{116f}\u{11bd}", "\u{bb66}", "\u{1106}\u{116f}\u{11bd}"), ("\u{bb67}",
        "\u{bb67}", "\u{1106}\u{116f}\u{11be}", "\u{bb67}", "\u{1106}\u{116f}\u{11be}"),
        ("\u{bb68}", "\u{bb68}", "\u{1106}\u{116f}\u{11bf}", "\u{bb68}",
        "\u{1106}\u{116f}\u{11bf}"), ("\u{bb69}", "\u{bb69}", "\u{1106}\u{116f}\u{11c0}",
        "\u{bb69}", "\u{1106}\u{116f}\u{11c0}"), ("\u{bb6a}", "\u{bb6a}",
        "\u{1106}\u{116f}\u{11c1}", "\u{bb6a}", "\u{1106}\u{116f}\u{11c1}"), ("\u{bb6b}",
        "\u{bb6b}", "\u{1106}\u{116f}\u{11c2}", "\u{bb6b}", "\u{1106}\u{116f}\u{11c2}"),
        ("\u{bb6c}", "\u{bb6c}", "\u{1106}\u{1170}", "\u{bb6c}", "\u{1106}\u{1170}"), ("\u{bb6d}",
        "\u{bb6d}", "\u{1106}\u{1170}\u{11a8}", "\u{bb6d}", "\u{1106}\u{1170}\u{11a8}"),
        ("\u{bb6e}", "\u{bb6e}", "\u{1106}\u{1170}\u{11a9}", "\u{bb6e}",
        "\u{1106}\u{1170}\u{11a9}"), ("\u{bb6f}", "\u{bb6f}", "\u{1106}\u{1170}\u{11aa}",
        "\u{bb6f}", "\u{1106}\u{1170}\u{11aa}"), ("\u{bb70}", "\u{bb70}",
        "\u{1106}\u{1170}\u{11ab}", "\u{bb70}", "\u{1106}\u{1170}\u{11ab}"), ("\u{bb71}",
        "\u{bb71}", "\u{1106}\u{1170}\u{11ac}", "\u{bb71}", "\u{1106}\u{1170}\u{11ac}"),
        ("\u{bb72}", "\u{bb72}", "\u{1106}\u{1170}\u{11ad}", "\u{bb72}",
        "\u{1106}\u{1170}\u{11ad}"), ("\u{bb73}", "\u{bb73}", "\u{1106}\u{1170}\u{11ae}",
        "\u{bb73}", "\u{1106}\u{1170}\u{11ae}"), ("\u{bb74}", "\u{bb74}",
        "\u{1106}\u{1170}\u{11af}", "\u{bb74}", "\u{1106}\u{1170}\u{11af}"), ("\u{bb75}",
        "\u{bb75}", "\u{1106}\u{1170}\u{11b0}", "\u{bb75}", "\u{1106}\u{1170}\u{11b0}"),
        ("\u{bb76}", "\u{bb76}", "\u{1106}\u{1170}\u{11b1}", "\u{bb76}",
        "\u{1106}\u{1170}\u{11b1}"), ("\u{bb77}", "\u{bb77}", "\u{1106}\u{1170}\u{11b2}",
        "\u{bb77}", "\u{1106}\u{1170}\u{11b2}"), ("\u{bb78}", "\u{bb78}",
        "\u{1106}\u{1170}\u{11b3}", "\u{bb78}", "\u{1106}\u{1170}\u{11b3}"), ("\u{bb79}",
        "\u{bb79}", "\u{1106}\u{1170}\u{11b4}", "\u{bb79}", "\u{1106}\u{1170}\u{11b4}"),
        ("\u{bb7a}", "\u{bb7a}", "\u{1106}\u{1170}\u{11b5}", "\u{bb7a}",
        "\u{1106}\u{1170}\u{11b5}"), ("\u{bb7b}", "\u{bb7b}", "\u{1106}\u{1170}\u{11b6}",
        "\u{bb7b}", "\u{1106}\u{1170}\u{11b6}"), ("\u{bb7c}", "\u{bb7c}",
        "\u{1106}\u{1170}\u{11b7}", "\u{bb7c}", "\u{1106}\u{1170}\u{11b7}"), ("\u{bb7d}",
        "\u{bb7d}", "\u{1106}\u{1170}\u{11b8}", "\u{bb7d}", "\u{1106}\u{1170}\u{11b8}"),
        ("\u{bb7e}", "\u{bb7e}", "\u{1106}\u{1170}\u{11b9}", "\u{bb7e}",
        "\u{1106}\u{1170}\u{11b9}"), ("\u{bb7f}", "\u{bb7f}", "\u{1106}\u{1170}\u{11ba}",
        "\u{bb7f}", "\u{1106}\u{1170}\u{11ba}"), ("\u{bb80}", "\u{bb80}",
        "\u{1106}\u{1170}\u{11bb}", "\u{bb80}", "\u{1106}\u{1170}\u{11bb}"), ("\u{bb81}",
        "\u{bb81}", "\u{1106}\u{1170}\u{11bc}", "\u{bb81}", "\u{1106}\u{1170}\u{11bc}"),
        ("\u{bb82}", "\u{bb82}", "\u{1106}\u{1170}\u{11bd}", "\u{bb82}",
        "\u{1106}\u{1170}\u{11bd}"), ("\u{bb83}", "\u{bb83}", "\u{1106}\u{1170}\u{11be}",
        "\u{bb83}", "\u{1106}\u{1170}\u{11be}"), ("\u{bb84}", "\u{bb84}",
        "\u{1106}\u{1170}\u{11bf}", "\u{bb84}", "\u{1106}\u{1170}\u{11bf}"), ("\u{bb85}",
        "\u{bb85}", "\u{1106}\u{1170}\u{11c0}", "\u{bb85}", "\u{1106}\u{1170}\u{11c0}"),
        ("\u{bb86}", "\u{bb86}", "\u{1106}\u{1170}\u{11c1}", "\u{bb86}",
        "\u{1106}\u{1170}\u{11c1}"), ("\u{bb87}", "\u{bb87}", "\u{1106}\u{1170}\u{11c2}",
        "\u{bb87}", "\u{1106}\u{1170}\u{11c2}"), ("\u{bb88}", "\u{bb88}", "\u{1106}\u{1171}",
        "\u{bb88}", "\u{1106}\u{1171}"), ("\u{bb89}", "\u{bb89}", "\u{1106}\u{1171}\u{11a8}",
        "\u{bb89}", "\u{1106}\u{1171}\u{11a8}"), ("\u{bb8a}", "\u{bb8a}",
        "\u{1106}\u{1171}\u{11a9}", "\u{bb8a}", "\u{1106}\u{1171}\u{11a9}"), ("\u{bb8b}",
        "\u{bb8b}", "\u{1106}\u{1171}\u{11aa}", "\u{bb8b}", "\u{1106}\u{1171}\u{11aa}"),
        ("\u{bb8c}", "\u{bb8c}", "\u{1106}\u{1171}\u{11ab}", "\u{bb8c}",
        "\u{1106}\u{1171}\u{11ab}"), ("\u{bb8d}", "\u{bb8d}", "\u{1106}\u{1171}\u{11ac}",
        "\u{bb8d}", "\u{1106}\u{1171}\u{11ac}"), ("\u{bb8e}", "\u{bb8e}",
        "\u{1106}\u{1171}\u{11ad}", "\u{bb8e}", "\u{1106}\u{1171}\u{11ad}"), ("\u{bb8f}",
        "\u{bb8f}", "\u{1106}\u{1171}\u{11ae}", "\u{bb8f}", "\u{1106}\u{1171}\u{11ae}"),
        ("\u{bb90}", "\u{bb90}", "\u{1106}\u{1171}\u{11af}", "\u{bb90}",
        "\u{1106}\u{1171}\u{11af}"), ("\u{bb91}", "\u{bb91}", "\u{1106}\u{1171}\u{11b0}",
        "\u{bb91}", "\u{1106}\u{1171}\u{11b0}"), ("\u{bb92}", "\u{bb92}",
        "\u{1106}\u{1171}\u{11b1}", "\u{bb92}", "\u{1106}\u{1171}\u{11b1}"), ("\u{bb93}",
        "\u{bb93}", "\u{1106}\u{1171}\u{11b2}", "\u{bb93}", "\u{1106}\u{1171}\u{11b2}"),
        ("\u{bb94}", "\u{bb94}", "\u{1106}\u{1171}\u{11b3}", "\u{bb94}",
        "\u{1106}\u{1171}\u{11b3}"), ("\u{bb95}", "\u{bb95}", "\u{1106}\u{1171}\u{11b4}",
        "\u{bb95}", "\u{1106}\u{1171}\u{11b4}"), ("\u{bb96}", "\u{bb96}",
        "\u{1106}\u{1171}\u{11b5}", "\u{bb96}", "\u{1106}\u{1171}\u{11b5}"), ("\u{bb97}",
        "\u{bb97}", "\u{1106}\u{1171}\u{11b6}", "\u{bb97}", "\u{1106}\u{1171}\u{11b6}"),
        ("\u{bb98}", "\u{bb98}", "\u{1106}\u{1171}\u{11b7}", "\u{bb98}",
        "\u{1106}\u{1171}\u{11b7}"), ("\u{bb99}", "\u{bb99}", "\u{1106}\u{1171}\u{11b8}",
        "\u{bb99}", "\u{1106}\u{1171}\u{11b8}"), ("\u{bb9a}", "\u{bb9a}",
        "\u{1106}\u{1171}\u{11b9}", "\u{bb9a}", "\u{1106}\u{1171}\u{11b9}"), ("\u{bb9b}",
        "\u{bb9b}", "\u{1106}\u{1171}\u{11ba}", "\u{bb9b}", "\u{1106}\u{1171}\u{11ba}"),
        ("\u{bb9c}", "\u{bb9c}", "\u{1106}\u{1171}\u{11bb}", "\u{bb9c}",
        "\u{1106}\u{1171}\u{11bb}"), ("\u{bb9d}", "\u{bb9d}", "\u{1106}\u{1171}\u{11bc}",
        "\u{bb9d}", "\u{1106}\u{1171}\u{11bc}"), ("\u{bb9e}", "\u{bb9e}",
        "\u{1106}\u{1171}\u{11bd}", "\u{bb9e}", "\u{1106}\u{1171}\u{11bd}"), ("\u{bb9f}",
        "\u{bb9f}", "\u{1106}\u{1171}\u{11be}", "\u{bb9f}", "\u{1106}\u{1171}\u{11be}"),
        ("\u{bba0}", "\u{bba0}", "\u{1106}\u{1171}\u{11bf}", "\u{bba0}",
        "\u{1106}\u{1171}\u{11bf}"), ("\u{bba1}", "\u{bba1}", "\u{1106}\u{1171}\u{11c0}",
        "\u{bba1}", "\u{1106}\u{1171}\u{11c0}"), ("\u{bba2}", "\u{bba2}",
        "\u{1106}\u{1171}\u{11c1}", "\u{bba2}", "\u{1106}\u{1171}\u{11c1}"), ("\u{bba3}",
        "\u{bba3}", "\u{1106}\u{1171}\u{11c2}", "\u{bba3}", "\u{1106}\u{1171}\u{11c2}"),
        ("\u{bba4}", "\u{bba4}", "\u{1106}\u{1172}", "\u{bba4}", "\u{1106}\u{1172}"), ("\u{bba5}",
        "\u{bba5}", "\u{1106}\u{1172}\u{11a8}", "\u{bba5}", "\u{1106}\u{1172}\u{11a8}"),
        ("\u{bba6}", "\u{bba6}", "\u{1106}\u{1172}\u{11a9}", "\u{bba6}",
        "\u{1106}\u{1172}\u{11a9}"), ("\u{bba7}", "\u{bba7}", "\u{1106}\u{1172}\u{11aa}",
        "\u{bba7}", "\u{1106}\u{1172}\u{11aa}"), ("\u{bba8}", "\u{bba8}",
        "\u{1106}\u{1172}\u{11ab}", "\u{bba8}", "\u{1106}\u{1172}\u{11ab}"), ("\u{bba9}",
        "\u{bba9}", "\u{1106}\u{1172}\u{11ac}", "\u{bba9}", "\u{1106}\u{1172}\u{11ac}"),
        ("\u{bbaa}", "\u{bbaa}", "\u{1106}\u{1172}\u{11ad}", "\u{bbaa}",
        "\u{1106}\u{1172}\u{11ad}"), ("\u{bbab}", "\u{bbab}", "\u{1106}\u{1172}\u{11ae}",
        "\u{bbab}", "\u{1106}\u{1172}\u{11ae}"), ("\u{bbac}", "\u{bbac}",
        "\u{1106}\u{1172}\u{11af}", "\u{bbac}", "\u{1106}\u{1172}\u{11af}"), ("\u{bbad}",
        "\u{bbad}", "\u{1106}\u{1172}\u{11b0}", "\u{bbad}", "\u{1106}\u{1172}\u{11b0}"),
        ("\u{bbae}", "\u{bbae}", "\u{1106}\u{1172}\u{11b1}", "\u{bbae}",
        "\u{1106}\u{1172}\u{11b1}"), ("\u{bbaf}", "\u{bbaf}", "\u{1106}\u{1172}\u{11b2}",
        "\u{bbaf}", "\u{1106}\u{1172}\u{11b2}"), ("\u{bbb0}", "\u{bbb0}",
        "\u{1106}\u{1172}\u{11b3}", "\u{bbb0}", "\u{1106}\u{1172}\u{11b3}"), ("\u{bbb1}",
        "\u{bbb1}", "\u{1106}\u{1172}\u{11b4}", "\u{bbb1}", "\u{1106}\u{1172}\u{11b4}"),
        ("\u{bbb2}", "\u{bbb2}", "\u{1106}\u{1172}\u{11b5}", "\u{bbb2}",
        "\u{1106}\u{1172}\u{11b5}"), ("\u{bbb3}", "\u{bbb3}", "\u{1106}\u{1172}\u{11b6}",
        "\u{bbb3}", "\u{1106}\u{1172}\u{11b6}"), ("\u{bbb4}", "\u{bbb4}",
        "\u{1106}\u{1172}\u{11b7}", "\u{bbb4}", "\u{1106}\u{1172}\u{11b7}"), ("\u{bbb5}",
        "\u{bbb5}", "\u{1106}\u{1172}\u{11b8}", "\u{bbb5}", "\u{1106}\u{1172}\u{11b8}"),
        ("\u{bbb6}", "\u{bbb6}", "\u{1106}\u{1172}\u{11b9}", "\u{bbb6}",
        "\u{1106}\u{1172}\u{11b9}"), ("\u{bbb7}", "\u{bbb7}", "\u{1106}\u{1172}\u{11ba}",
        "\u{bbb7}", "\u{1106}\u{1172}\u{11ba}"), ("\u{bbb8}", "\u{bbb8}",
        "\u{1106}\u{1172}\u{11bb}", "\u{bbb8}", "\u{1106}\u{1172}\u{11bb}"), ("\u{bbb9}",
        "\u{bbb9}", "\u{1106}\u{1172}\u{11bc}", "\u{bbb9}", "\u{1106}\u{1172}\u{11bc}"),
        ("\u{bbba}", "\u{bbba}", "\u{1106}\u{1172}\u{11bd}", "\u{bbba}",
        "\u{1106}\u{1172}\u{11bd}"), ("\u{bbbb}", "\u{bbbb}", "\u{1106}\u{1172}\u{11be}",
        "\u{bbbb}", "\u{1106}\u{1172}\u{11be}"), ("\u{bbbc}", "\u{bbbc}",
        "\u{1106}\u{1172}\u{11bf}", "\u{bbbc}", "\u{1106}\u{1172}\u{11bf}"), ("\u{bbbd}",
        "\u{bbbd}", "\u{1106}\u{1172}\u{11c0}", "\u{bbbd}", "\u{1106}\u{1172}\u{11c0}"),
        ("\u{bbbe}", "\u{bbbe}", "\u{1106}\u{1172}\u{11c1}", "\u{bbbe}",
        "\u{1106}\u{1172}\u{11c1}"), ("\u{bbbf}", "\u{bbbf}", "\u{1106}\u{1172}\u{11c2}",
        "\u{bbbf}", "\u{1106}\u{1172}\u{11c2}"), ("\u{bbc0}", "\u{bbc0}", "\u{1106}\u{1173}",
        "\u{bbc0}", "\u{1106}\u{1173}"), ("\u{bbc1}", "\u{bbc1}", "\u{1106}\u{1173}\u{11a8}",
        "\u{bbc1}", "\u{1106}\u{1173}\u{11a8}"), ("\u{bbc2}", "\u{bbc2}",
        "\u{1106}\u{1173}\u{11a9}", "\u{bbc2}", "\u{1106}\u{1173}\u{11a9}"), ("\u{bbc3}",
        "\u{bbc3}", "\u{1106}\u{1173}\u{11aa}", "\u{bbc3}", "\u{1106}\u{1173}\u{11aa}"),
        ("\u{bbc4}", "\u{bbc4}", "\u{1106}\u{1173}\u{11ab}", "\u{bbc4}",
        "\u{1106}\u{1173}\u{11ab}"), ("\u{bbc5}", "\u{bbc5}", "\u{1106}\u{1173}\u{11ac}",
        "\u{bbc5}", "\u{1106}\u{1173}\u{11ac}"), ("\u{bbc6}", "\u{bbc6}",
        "\u{1106}\u{1173}\u{11ad}", "\u{bbc6}", "\u{1106}\u{1173}\u{11ad}"), ("\u{bbc7}",
        "\u{bbc7}", "\u{1106}\u{1173}\u{11ae}", "\u{bbc7}", "\u{1106}\u{1173}\u{11ae}"),
        ("\u{bbc8}", "\u{bbc8}", "\u{1106}\u{1173}\u{11af}", "\u{bbc8}",
        "\u{1106}\u{1173}\u{11af}"), ("\u{bbc9}", "\u{bbc9}", "\u{1106}\u{1173}\u{11b0}",
        "\u{bbc9}", "\u{1106}\u{1173}\u{11b0}"), ("\u{bbca}", "\u{bbca}",
        "\u{1106}\u{1173}\u{11b1}", "\u{bbca}", "\u{1106}\u{1173}\u{11b1}"), ("\u{bbcb}",
        "\u{bbcb}", "\u{1106}\u{1173}\u{11b2}", "\u{bbcb}", "\u{1106}\u{1173}\u{11b2}"),
        ("\u{bbcc}", "\u{bbcc}", "\u{1106}\u{1173}\u{11b3}", "\u{bbcc}",
        "\u{1106}\u{1173}\u{11b3}"), ("\u{bbcd}", "\u{bbcd}", "\u{1106}\u{1173}\u{11b4}",
        "\u{bbcd}", "\u{1106}\u{1173}\u{11b4}"), ("\u{bbce}", "\u{bbce}",
        "\u{1106}\u{1173}\u{11b5}", "\u{bbce}", "\u{1106}\u{1173}\u{11b5}"), ("\u{bbcf}",
        "\u{bbcf}", "\u{1106}\u{1173}\u{11b6}", "\u{bbcf}", "\u{1106}\u{1173}\u{11b6}"),
        ("\u{bbd0}", "\u{bbd0}", "\u{1106}\u{1173}\u{11b7}", "\u{bbd0}",
        "\u{1106}\u{1173}\u{11b7}"), ("\u{bbd1}", "\u{bbd1}", "\u{1106}\u{1173}\u{11b8}",
        "\u{bbd1}", "\u{1106}\u{1173}\u{11b8}"), ("\u{bbd2}", "\u{bbd2}",
        "\u{1106}\u{1173}\u{11b9}", "\u{bbd2}", "\u{1106}\u{1173}\u{11b9}"), ("\u{bbd3}",
        "\u{bbd3}", "\u{1106}\u{1173}\u{11ba}", "\u{bbd3}", "\u{1106}\u{1173}\u{11ba}"),
        ("\u{bbd4}", "\u{bbd4}", "\u{1106}\u{1173}\u{11bb}", "\u{bbd4}",
        "\u{1106}\u{1173}\u{11bb}"), ("\u{bbd5}", "\u{bbd5}", "\u{1106}\u{1173}\u{11bc}",
        "\u{bbd5}", "\u{1106}\u{1173}\u{11bc}"), ("\u{bbd6}", "\u{bbd6}",
        "\u{1106}\u{1173}\u{11bd}", "\u{bbd6}", "\u{1106}\u{1173}\u{11bd}"), ("\u{bbd7}",
        "\u{bbd7}", "\u{1106}\u{1173}\u{11be}", "\u{bbd7}", "\u{1106}\u{1173}\u{11be}"),
        ("\u{bbd8}", "\u{bbd8}", "\u{1106}\u{1173}\u{11bf}", "\u{bbd8}",
        "\u{1106}\u{1173}\u{11bf}"), ("\u{bbd9}", "\u{bbd9}", "\u{1106}\u{1173}\u{11c0}",
        "\u{bbd9}", "\u{1106}\u{1173}\u{11c0}"), ("\u{bbda}", "\u{bbda}",
        "\u{1106}\u{1173}\u{11c1}", "\u{bbda}", "\u{1106}\u{1173}\u{11c1}"), ("\u{bbdb}",
        "\u{bbdb}", "\u{1106}\u{1173}\u{11c2}", "\u{bbdb}", "\u{1106}\u{1173}\u{11c2}"),
        ("\u{bbdc}", "\u{bbdc}", "\u{1106}\u{1174}", "\u{bbdc}", "\u{1106}\u{1174}"), ("\u{bbdd}",
        "\u{bbdd}", "\u{1106}\u{1174}\u{11a8}", "\u{bbdd}", "\u{1106}\u{1174}\u{11a8}"),
        ("\u{bbde}", "\u{bbde}", "\u{1106}\u{1174}\u{11a9}", "\u{bbde}",
        "\u{1106}\u{1174}\u{11a9}"), ("\u{bbdf}", "\u{bbdf}", "\u{1106}\u{1174}\u{11aa}",
        "\u{bbdf}", "\u{1106}\u{1174}\u{11aa}"), ("\u{bbe0}", "\u{bbe0}",
        "\u{1106}\u{1174}\u{11ab}", "\u{bbe0}", "\u{1106}\u{1174}\u{11ab}"), ("\u{bbe1}",
        "\u{bbe1}", "\u{1106}\u{1174}\u{11ac}", "\u{bbe1}", "\u{1106}\u{1174}\u{11ac}"),
        ("\u{bbe2}", "\u{bbe2}", "\u{1106}\u{1174}\u{11ad}", "\u{bbe2}",
        "\u{1106}\u{1174}\u{11ad}"), ("\u{bbe3}", "\u{bbe3}", "\u{1106}\u{1174}\u{11ae}",
        "\u{bbe3}", "\u{1106}\u{1174}\u{11ae}"), ("\u{bbe4}", "\u{bbe4}",
        "\u{1106}\u{1174}\u{11af}", "\u{bbe4}", "\u{1106}\u{1174}\u{11af}"), ("\u{bbe5}",
        "\u{bbe5}", "\u{1106}\u{1174}\u{11b0}", "\u{bbe5}", "\u{1106}\u{1174}\u{11b0}"),
        ("\u{bbe6}", "\u{bbe6}", "\u{1106}\u{1174}\u{11b1}", "\u{bbe6}",
        "\u{1106}\u{1174}\u{11b1}"), ("\u{bbe7}", "\u{bbe7}", "\u{1106}\u{1174}\u{11b2}",
        "\u{bbe7}", "\u{1106}\u{1174}\u{11b2}"), ("\u{bbe8}", "\u{bbe8}",
        "\u{1106}\u{1174}\u{11b3}", "\u{bbe8}", "\u{1106}\u{1174}\u{11b3}"), ("\u{bbe9}",
        "\u{bbe9}", "\u{1106}\u{1174}\u{11b4}", "\u{bbe9}", "\u{1106}\u{1174}\u{11b4}"),
        ("\u{bbea}", "\u{bbea}", "\u{1106}\u{1174}\u{11b5}", "\u{bbea}",
        "\u{1106}\u{1174}\u{11b5}"), ("\u{bbeb}", "\u{bbeb}", "\u{1106}\u{1174}\u{11b6}",
        "\u{bbeb}", "\u{1106}\u{1174}\u{11b6}"), ("\u{bbec}", "\u{bbec}",
        "\u{1106}\u{1174}\u{11b7}", "\u{bbec}", "\u{1106}\u{1174}\u{11b7}"), ("\u{bbed}",
        "\u{bbed}", "\u{1106}\u{1174}\u{11b8}", "\u{bbed}", "\u{1106}\u{1174}\u{11b8}"),
        ("\u{bbee}", "\u{bbee}", "\u{1106}\u{1174}\u{11b9}", "\u{bbee}",
        "\u{1106}\u{1174}\u{11b9}"), ("\u{bbef}", "\u{bbef}", "\u{1106}\u{1174}\u{11ba}",
        "\u{bbef}", "\u{1106}\u{1174}\u{11ba}"), ("\u{bbf0}", "\u{bbf0}",
        "\u{1106}\u{1174}\u{11bb}", "\u{bbf0}", "\u{1106}\u{1174}\u{11bb}"), ("\u{bbf1}",
        "\u{bbf1}", "\u{1106}\u{1174}\u{11bc}", "\u{bbf1}", "\u{1106}\u{1174}\u{11bc}"),
        ("\u{bbf2}", "\u{bbf2}", "\u{1106}\u{1174}\u{11bd}", "\u{bbf2}",
        "\u{1106}\u{1174}\u{11bd}"), ("\u{bbf3}", "\u{bbf3}", "\u{1106}\u{1174}\u{11be}",
        "\u{bbf3}", "\u{1106}\u{1174}\u{11be}"), ("\u{bbf4}", "\u{bbf4}",
        "\u{1106}\u{1174}\u{11bf}", "\u{bbf4}", "\u{1106}\u{1174}\u{11bf}"), ("\u{bbf5}",
        "\u{bbf5}", "\u{1106}\u{1174}\u{11c0}", "\u{bbf5}", "\u{1106}\u{1174}\u{11c0}"),
        ("\u{bbf6}", "\u{bbf6}", "\u{1106}\u{1174}\u{11c1}", "\u{bbf6}",
        "\u{1106}\u{1174}\u{11c1}"), ("\u{bbf7}", "\u{bbf7}", "\u{1106}\u{1174}\u{11c2}",
        "\u{bbf7}", "\u{1106}\u{1174}\u{11c2}"), ("\u{bbf8}", "\u{bbf8}", "\u{1106}\u{1175}",
        "\u{bbf8}", "\u{1106}\u{1175}"), ("\u{bbf9}", "\u{bbf9}", "\u{1106}\u{1175}\u{11a8}",
        "\u{bbf9}", "\u{1106}\u{1175}\u{11a8}"), ("\u{bbfa}", "\u{bbfa}",
        "\u{1106}\u{1175}\u{11a9}", "\u{bbfa}", "\u{1106}\u{1175}\u{11a9}"), ("\u{bbfb}",
        "\u{bbfb}", "\u{1106}\u{1175}\u{11aa}", "\u{bbfb}", "\u{1106}\u{1175}\u{11aa}"),
        ("\u{bbfc}", "\u{bbfc}", "\u{1106}\u{1175}\u{11ab}", "\u{bbfc}",
        "\u{1106}\u{1175}\u{11ab}"), ("\u{bbfd}", "\u{bbfd}", "\u{1106}\u{1175}\u{11ac}",
        "\u{bbfd}", "\u{1106}\u{1175}\u{11ac}"), ("\u{bbfe}", "\u{bbfe}",
        "\u{1106}\u{1175}\u{11ad}", "\u{bbfe}", "\u{1106}\u{1175}\u{11ad}"), ("\u{bbff}",
        "\u{bbff}", "\u{1106}\u{1175}\u{11ae}", "\u{bbff}", "\u{1106}\u{1175}\u{11ae}"),
        ("\u{bc00}", "\u{bc00}", "\u{1106}\u{1175}\u{11af}", "\u{bc00}",
        "\u{1106}\u{1175}\u{11af}"), ("\u{bc01}", "\u{bc01}", "\u{1106}\u{1175}\u{11b0}",
        "\u{bc01}", "\u{1106}\u{1175}\u{11b0}"), ("\u{bc02}", "\u{bc02}",
        "\u{1106}\u{1175}\u{11b1}", "\u{bc02}", "\u{1106}\u{1175}\u{11b1}"), ("\u{bc03}",
        "\u{bc03}", "\u{1106}\u{1175}\u{11b2}", "\u{bc03}", "\u{1106}\u{1175}\u{11b2}"),
        ("\u{bc04}", "\u{bc04}", "\u{1106}\u{1175}\u{11b3}", "\u{bc04}",
        "\u{1106}\u{1175}\u{11b3}"), ("\u{bc05}", "\u{bc05}", "\u{1106}\u{1175}\u{11b4}",
        "\u{bc05}", "\u{1106}\u{1175}\u{11b4}"), ("\u{bc06}", "\u{bc06}",
        "\u{1106}\u{1175}\u{11b5}", "\u{bc06}", "\u{1106}\u{1175}\u{11b5}"), ("\u{bc07}",
        "\u{bc07}", "\u{1106}\u{1175}\u{11b6}", "\u{bc07}", "\u{1106}\u{1175}\u{11b6}"),
        ("\u{bc08}", "\u{bc08}", "\u{1106}\u{1175}\u{11b7}", "\u{bc08}",
        "\u{1106}\u{1175}\u{11b7}"), ("\u{bc09}", "\u{bc09}", "\u{1106}\u{1175}\u{11b8}",
        "\u{bc09}", "\u{1106}\u{1175}\u{11b8}"), ("\u{bc0a}", "\u{bc0a}",
        "\u{1106}\u{1175}\u{11b9}", "\u{bc0a}", "\u{1106}\u{1175}\u{11b9}"), ("\u{bc0b}",
        "\u{bc0b}", "\u{1106}\u{1175}\u{11ba}", "\u{bc0b}", "\u{1106}\u{1175}\u{11ba}"),
        ("\u{bc0c}", "\u{bc0c}", "\u{1106}\u{1175}\u{11bb}", "\u{bc0c}",
        "\u{1106}\u{1175}\u{11bb}"), ("\u{bc0d}", "\u{bc0d}", "\u{1106}\u{1175}\u{11bc}",
        "\u{bc0d}", "\u{1106}\u{1175}\u{11bc}"), ("\u{bc0e}", "\u{bc0e}",
        "\u{1106}\u{1175}\u{11bd}", "\u{bc0e}", "\u{1106}\u{1175}\u{11bd}"), ("\u{bc0f}",
        "\u{bc0f}", "\u{1106}\u{1175}\u{11be}", "\u{bc0f}", "\u{1106}\u{1175}\u{11be}"),
        ("\u{bc10}", "\u{bc10}", "\u{1106}\u{1175}\u{11bf}", "\u{bc10}",
        "\u{1106}\u{1175}\u{11bf}"), ("\u{bc11}", "\u{bc11}", "\u{1106}\u{1175}\u{11c0}",
        "\u{bc11}", "\u{1106}\u{1175}\u{11c0}"), ("\u{bc12}", "\u{bc12}",
        "\u{1106}\u{1175}\u{11c1}", "\u{bc12}", "\u{1106}\u{1175}\u{11c1}"), ("\u{bc13}",
        "\u{bc13}", "\u{1106}\u{1175}\u{11c2}", "\u{bc13}", "\u{1106}\u{1175}\u{11c2}"),
        ("\u{bc14}", "\u{bc14}", "\u{1107}\u{1161}", "\u{bc14}", "\u{1107}\u{1161}"), ("\u{bc15}",
        "\u{bc15}", "\u{1107}\u{1161}\u{11a8}", "\u{bc15}", "\u{1107}\u{1161}\u{11a8}"),
        ("\u{bc16}", "\u{bc16}", "\u{1107}\u{1161}\u{11a9}", "\u{bc16}",
        "\u{1107}\u{1161}\u{11a9}"), ("\u{bc17}", "\u{bc17}", "\u{1107}\u{1161}\u{11aa}",
        "\u{bc17}", "\u{1107}\u{1161}\u{11aa}"), ("\u{bc18}", "\u{bc18}",
        "\u{1107}\u{1161}\u{11ab}", "\u{bc18}", "\u{1107}\u{1161}\u{11ab}"), ("\u{bc19}",
        "\u{bc19}", "\u{1107}\u{1161}\u{11ac}", "\u{bc19}", "\u{1107}\u{1161}\u{11ac}"),
        ("\u{bc1a}", "\u{bc1a}", "\u{1107}\u{1161}\u{11ad}", "\u{bc1a}",
        "\u{1107}\u{1161}\u{11ad}"), ("\u{bc1b}", "\u{bc1b}", "\u{1107}\u{1161}\u{11ae}",
        "\u{bc1b}", "\u{1107}\u{1161}\u{11ae}"), ("\u{bc1c}", "\u{bc1c}",
        "\u{1107}\u{1161}\u{11af}", "\u{bc1c}", "\u{1107}\u{1161}\u{11af}"), ("\u{bc1d}",
        "\u{bc1d}", "\u{1107}\u{1161}\u{11b0}", "\u{bc1d}", "\u{1107}\u{1161}\u{11b0}"),
        ("\u{bc1e}", "\u{bc1e}", "\u{1107}\u{1161}\u{11b1}", "\u{bc1e}",
        "\u{1107}\u{1161}\u{11b1}"), ("\u{bc1f}", "\u{bc1f}", "\u{1107}\u{1161}\u{11b2}",
        "\u{bc1f}", "\u{1107}\u{1161}\u{11b2}"), ("\u{bc20}", "\u{bc20}",
        "\u{1107}\u{1161}\u{11b3}", "\u{bc20}", "\u{1107}\u{1161}\u{11b3}"), ("\u{bc21}",
        "\u{bc21}", "\u{1107}\u{1161}\u{11b4}", "\u{bc21}", "\u{1107}\u{1161}\u{11b4}"),
        ("\u{bc22}", "\u{bc22}", "\u{1107}\u{1161}\u{11b5}", "\u{bc22}",
        "\u{1107}\u{1161}\u{11b5}"), ("\u{bc23}", "\u{bc23}", "\u{1107}\u{1161}\u{11b6}",
        "\u{bc23}", "\u{1107}\u{1161}\u{11b6}"), ("\u{bc24}", "\u{bc24}",
        "\u{1107}\u{1161}\u{11b7}", "\u{bc24}", "\u{1107}\u{1161}\u{11b7}"), ("\u{bc25}",
        "\u{bc25}", "\u{1107}\u{1161}\u{11b8}", "\u{bc25}", "\u{1107}\u{1161}\u{11b8}"),
        ("\u{bc26}", "\u{bc26}", "\u{1107}\u{1161}\u{11b9}", "\u{bc26}",
        "\u{1107}\u{1161}\u{11b9}"), ("\u{bc27}", "\u{bc27}", "\u{1107}\u{1161}\u{11ba}",
        "\u{bc27}", "\u{1107}\u{1161}\u{11ba}"), ("\u{bc28}", "\u{bc28}",
        "\u{1107}\u{1161}\u{11bb}", "\u{bc28}", "\u{1107}\u{1161}\u{11bb}"), ("\u{bc29}",
        "\u{bc29}", "\u{1107}\u{1161}\u{11bc}", "\u{bc29}", "\u{1107}\u{1161}\u{11bc}"),
        ("\u{bc2a}", "\u{bc2a}", "\u{1107}\u{1161}\u{11bd}", "\u{bc2a}",
        "\u{1107}\u{1161}\u{11bd}"), ("\u{bc2b}", "\u{bc2b}", "\u{1107}\u{1161}\u{11be}",
        "\u{bc2b}", "\u{1107}\u{1161}\u{11be}"), ("\u{bc2c}", "\u{bc2c}",
        "\u{1107}\u{1161}\u{11bf}", "\u{bc2c}", "\u{1107}\u{1161}\u{11bf}"), ("\u{bc2d}",
        "\u{bc2d}", "\u{1107}\u{1161}\u{11c0}", "\u{bc2d}", "\u{1107}\u{1161}\u{11c0}"),
        ("\u{bc2e}", "\u{bc2e}", "\u{1107}\u{1161}\u{11c1}", "\u{bc2e}",
        "\u{1107}\u{1161}\u{11c1}"), ("\u{bc2f}", "\u{bc2f}", "\u{1107}\u{1161}\u{11c2}",
        "\u{bc2f}", "\u{1107}\u{1161}\u{11c2}"), ("\u{bc30}", "\u{bc30}", "\u{1107}\u{1162}",
        "\u{bc30}", "\u{1107}\u{1162}"), ("\u{bc31}", "\u{bc31}", "\u{1107}\u{1162}\u{11a8}",
        "\u{bc31}", "\u{1107}\u{1162}\u{11a8}"), ("\u{bc32}", "\u{bc32}",
        "\u{1107}\u{1162}\u{11a9}", "\u{bc32}", "\u{1107}\u{1162}\u{11a9}"), ("\u{bc33}",
        "\u{bc33}", "\u{1107}\u{1162}\u{11aa}", "\u{bc33}", "\u{1107}\u{1162}\u{11aa}"),
        ("\u{bc34}", "\u{bc34}", "\u{1107}\u{1162}\u{11ab}", "\u{bc34}",
        "\u{1107}\u{1162}\u{11ab}"), ("\u{bc35}", "\u{bc35}", "\u{1107}\u{1162}\u{11ac}",
        "\u{bc35}", "\u{1107}\u{1162}\u{11ac}"), ("\u{bc36}", "\u{bc36}",
        "\u{1107}\u{1162}\u{11ad}", "\u{bc36}", "\u{1107}\u{1162}\u{11ad}"), ("\u{bc37}",
        "\u{bc37}", "\u{1107}\u{1162}\u{11ae}", "\u{bc37}", "\u{1107}\u{1162}\u{11ae}"),
        ("\u{bc38}", "\u{bc38}", "\u{1107}\u{1162}\u{11af}", "\u{bc38}",
        "\u{1107}\u{1162}\u{11af}"), ("\u{bc39}", "\u{bc39}", "\u{1107}\u{1162}\u{11b0}",
        "\u{bc39}", "\u{1107}\u{1162}\u{11b0}"), ("\u{bc3a}", "\u{bc3a}",
        "\u{1107}\u{1162}\u{11b1}", "\u{bc3a}", "\u{1107}\u{1162}\u{11b1}"), ("\u{bc3b}",
        "\u{bc3b}", "\u{1107}\u{1162}\u{11b2}", "\u{bc3b}", "\u{1107}\u{1162}\u{11b2}"),
        ("\u{bc3c}", "\u{bc3c}", "\u{1107}\u{1162}\u{11b3}", "\u{bc3c}",
        "\u{1107}\u{1162}\u{11b3}"), ("\u{bc3d}", "\u{bc3d}", "\u{1107}\u{1162}\u{11b4}",
        "\u{bc3d}", "\u{1107}\u{1162}\u{11b4}"), ("\u{bc3e}", "\u{bc3e}",
        "\u{1107}\u{1162}\u{11b5}", "\u{bc3e}", "\u{1107}\u{1162}\u{11b5}"), ("\u{bc3f}",
        "\u{bc3f}", "\u{1107}\u{1162}\u{11b6}", "\u{bc3f}", "\u{1107}\u{1162}\u{11b6}"),
        ("\u{bc40}", "\u{bc40}", "\u{1107}\u{1162}\u{11b7}", "\u{bc40}",
        "\u{1107}\u{1162}\u{11b7}"), ("\u{bc41}", "\u{bc41}", "\u{1107}\u{1162}\u{11b8}",
        "\u{bc41}", "\u{1107}\u{1162}\u{11b8}"), ("\u{bc42}", "\u{bc42}",
        "\u{1107}\u{1162}\u{11b9}", "\u{bc42}", "\u{1107}\u{1162}\u{11b9}"), ("\u{bc43}",
        "\u{bc43}", "\u{1107}\u{1162}\u{11ba}", "\u{bc43}", "\u{1107}\u{1162}\u{11ba}"),
        ("\u{bc44}", "\u{bc44}", "\u{1107}\u{1162}\u{11bb}", "\u{bc44}",
        "\u{1107}\u{1162}\u{11bb}"), ("\u{bc45}", "\u{bc45}", "\u{1107}\u{1162}\u{11bc}",
        "\u{bc45}", "\u{1107}\u{1162}\u{11bc}"), ("\u{bc46}", "\u{bc46}",
        "\u{1107}\u{1162}\u{11bd}", "\u{bc46}", "\u{1107}\u{1162}\u{11bd}"), ("\u{bc47}",
        "\u{bc47}", "\u{1107}\u{1162}\u{11be}", "\u{bc47}", "\u{1107}\u{1162}\u{11be}"),
        ("\u{bc48}", "\u{bc48}", "\u{1107}\u{1162}\u{11bf}", "\u{bc48}",
        "\u{1107}\u{1162}\u{11bf}"), ("\u{bc49}", "\u{bc49}", "\u{1107}\u{1162}\u{11c0}",
        "\u{bc49}", "\u{1107}\u{1162}\u{11c0}"), ("\u{bc4a}", "\u{bc4a}",
        "\u{1107}\u{1162}\u{11c1}", "\u{bc4a}", "\u{1107}\u{1162}\u{11c1}"), ("\u{bc4b}",
        "\u{bc4b}", "\u{1107}\u{1162}\u{11c2}", "\u{bc4b}", "\u{1107}\u{1162}\u{11c2}"),
        ("\u{bc4c}", "\u{bc4c}", "\u{1107}\u{1163}", "\u{bc4c}", "\u{1107}\u{1163}"), ("\u{bc4d}",
        "\u{bc4d}", "\u{1107}\u{1163}\u{11a8}", "\u{bc4d}", "\u{1107}\u{1163}\u{11a8}"),
        ("\u{bc4e}", "\u{bc4e}", "\u{1107}\u{1163}\u{11a9}", "\u{bc4e}",
        "\u{1107}\u{1163}\u{11a9}"), ("\u{bc4f}", "\u{bc4f}", "\u{1107}\u{1163}\u{11aa}",
        "\u{bc4f}", "\u{1107}\u{1163}\u{11aa}"), ("\u{bc50}", "\u{bc50}",
        "\u{1107}\u{1163}\u{11ab}", "\u{bc50}", "\u{1107}\u{1163}\u{11ab}"), ("\u{bc51}",
        "\u{bc51}", "\u{1107}\u{1163}\u{11ac}", "\u{bc51}", "\u{1107}\u{1163}\u{11ac}"),
        ("\u{bc52}", "\u{bc52}", "\u{1107}\u{1163}\u{11ad}", "\u{bc52}",
        "\u{1107}\u{1163}\u{11ad}"), ("\u{bc53}", "\u{bc53}", "\u{1107}\u{1163}\u{11ae}",
        "\u{bc53}", "\u{1107}\u{1163}\u{11ae}"), ("\u{bc54}", "\u{bc54}",
        "\u{1107}\u{1163}\u{11af}", "\u{bc54}", "\u{1107}\u{1163}\u{11af}"), ("\u{bc55}",
        "\u{bc55}", "\u{1107}\u{1163}\u{11b0}", "\u{bc55}", "\u{1107}\u{1163}\u{11b0}"),
        ("\u{bc56}", "\u{bc56}", "\u{1107}\u{1163}\u{11b1}", "\u{bc56}",
        "\u{1107}\u{1163}\u{11b1}"), ("\u{bc57}", "\u{bc57}", "\u{1107}\u{1163}\u{11b2}",
        "\u{bc57}", "\u{1107}\u{1163}\u{11b2}"), ("\u{bc58}", "\u{bc58}",
        "\u{1107}\u{1163}\u{11b3}", "\u{bc58}", "\u{1107}\u{1163}\u{11b3}"), ("\u{bc59}",
        "\u{bc59}", "\u{1107}\u{1163}\u{11b4}", "\u{bc59}", "\u{1107}\u{1163}\u{11b4}"),
        ("\u{bc5a}", "\u{bc5a}", "\u{1107}\u{1163}\u{11b5}", "\u{bc5a}",
        "\u{1107}\u{1163}\u{11b5}"), ("\u{bc5b}", "\u{bc5b}", "\u{1107}\u{1163}\u{11b6}",
        "\u{bc5b}", "\u{1107}\u{1163}\u{11b6}"), ("\u{bc5c}", "\u{bc5c}",
        "\u{1107}\u{1163}\u{11b7}", "\u{bc5c}", "\u{1107}\u{1163}\u{11b7}"), ("\u{bc5d}",
        "\u{bc5d}", "\u{1107}\u{1163}\u{11b8}", "\u{bc5d}", "\u{1107}\u{1163}\u{11b8}"),
        ("\u{bc5e}", "\u{bc5e}", "\u{1107}\u{1163}\u{11b9}", "\u{bc5e}",
        "\u{1107}\u{1163}\u{11b9}"), ("\u{bc5f}", "\u{bc5f}", "\u{1107}\u{1163}\u{11ba}",
        "\u{bc5f}", "\u{1107}\u{1163}\u{11ba}"), ("\u{bc60}", "\u{bc60}",
        "\u{1107}\u{1163}\u{11bb}", "\u{bc60}", "\u{1107}\u{1163}\u{11bb}"), ("\u{bc61}",
        "\u{bc61}", "\u{1107}\u{1163}\u{11bc}", "\u{bc61}", "\u{1107}\u{1163}\u{11bc}"),
        ("\u{bc62}", "\u{bc62}", "\u{1107}\u{1163}\u{11bd}", "\u{bc62}",
        "\u{1107}\u{1163}\u{11bd}"), ("\u{bc63}", "\u{bc63}", "\u{1107}\u{1163}\u{11be}",
        "\u{bc63}", "\u{1107}\u{1163}\u{11be}"), ("\u{bc64}", "\u{bc64}",
        "\u{1107}\u{1163}\u{11bf}", "\u{bc64}", "\u{1107}\u{1163}\u{11bf}"), ("\u{bc65}",
        "\u{bc65}", "\u{1107}\u{1163}\u{11c0}", "\u{bc65}", "\u{1107}\u{1163}\u{11c0}"),
        ("\u{bc66}", "\u{bc66}", "\u{1107}\u{1163}\u{11c1}", "\u{bc66}",
        "\u{1107}\u{1163}\u{11c1}"), ("\u{bc67}", "\u{bc67}", "\u{1107}\u{1163}\u{11c2}",
        "\u{bc67}", "\u{1107}\u{1163}\u{11c2}"), ("\u{bc68}", "\u{bc68}", "\u{1107}\u{1164}",
        "\u{bc68}", "\u{1107}\u{1164}"), ("\u{bc69}", "\u{bc69}", "\u{1107}\u{1164}\u{11a8}",
        "\u{bc69}", "\u{1107}\u{1164}\u{11a8}"), ("\u{bc6a}", "\u{bc6a}",
        "\u{1107}\u{1164}\u{11a9}", "\u{bc6a}", "\u{1107}\u{1164}\u{11a9}"), ("\u{bc6b}",
        "\u{bc6b}", "\u{1107}\u{1164}\u{11aa}", "\u{bc6b}", "\u{1107}\u{1164}\u{11aa}"),
        ("\u{bc6c}", "\u{bc6c}", "\u{1107}\u{1164}\u{11ab}", "\u{bc6c}",
        "\u{1107}\u{1164}\u{11ab}"), ("\u{bc6d}", "\u{bc6d}", "\u{1107}\u{1164}\u{11ac}",
        "\u{bc6d}", "\u{1107}\u{1164}\u{11ac}"), ("\u{bc6e}", "\u{bc6e}",
        "\u{1107}\u{1164}\u{11ad}", "\u{bc6e}", "\u{1107}\u{1164}\u{11ad}"), ("\u{bc6f}",
        "\u{bc6f}", "\u{1107}\u{1164}\u{11ae}", "\u{bc6f}", "\u{1107}\u{1164}\u{11ae}"),
        ("\u{bc70}", "\u{bc70}", "\u{1107}\u{1164}\u{11af}", "\u{bc70}",
        "\u{1107}\u{1164}\u{11af}"), ("\u{bc71}", "\u{bc71}", "\u{1107}\u{1164}\u{11b0}",
        "\u{bc71}", "\u{1107}\u{1164}\u{11b0}"), ("\u{bc72}", "\u{bc72}",
        "\u{1107}\u{1164}\u{11b1}", "\u{bc72}", "\u{1107}\u{1164}\u{11b1}"), ("\u{bc73}",
        "\u{bc73}", "\u{1107}\u{1164}\u{11b2}", "\u{bc73}", "\u{1107}\u{1164}\u{11b2}"),
        ("\u{bc74}", "\u{bc74}", "\u{1107}\u{1164}\u{11b3}", "\u{bc74}",
        "\u{1107}\u{1164}\u{11b3}"), ("\u{bc75}", "\u{bc75}", "\u{1107}\u{1164}\u{11b4}",
        "\u{bc75}", "\u{1107}\u{1164}\u{11b4}"), ("\u{bc76}", "\u{bc76}",
        "\u{1107}\u{1164}\u{11b5}", "\u{bc76}", "\u{1107}\u{1164}\u{11b5}"), ("\u{bc77}",
        "\u{bc77}", "\u{1107}\u{1164}\u{11b6}", "\u{bc77}", "\u{1107}\u{1164}\u{11b6}"),
        ("\u{bc78}", "\u{bc78}", "\u{1107}\u{1164}\u{11b7}", "\u{bc78}",
        "\u{1107}\u{1164}\u{11b7}"), ("\u{bc79}", "\u{bc79}", "\u{1107}\u{1164}\u{11b8}",
        "\u{bc79}", "\u{1107}\u{1164}\u{11b8}"), ("\u{bc7a}", "\u{bc7a}",
        "\u{1107}\u{1164}\u{11b9}", "\u{bc7a}", "\u{1107}\u{1164}\u{11b9}"), ("\u{bc7b}",
        "\u{bc7b}", "\u{1107}\u{1164}\u{11ba}", "\u{bc7b}", "\u{1107}\u{1164}\u{11ba}"),
        ("\u{bc7c}", "\u{bc7c}", "\u{1107}\u{1164}\u{11bb}", "\u{bc7c}",
        "\u{1107}\u{1164}\u{11bb}"), ("\u{bc7d}", "\u{bc7d}", "\u{1107}\u{1164}\u{11bc}",
        "\u{bc7d}", "\u{1107}\u{1164}\u{11bc}"), ("\u{bc7e}", "\u{bc7e}",
        "\u{1107}\u{1164}\u{11bd}", "\u{bc7e}", "\u{1107}\u{1164}\u{11bd}"), ("\u{bc7f}",
        "\u{bc7f}", "\u{1107}\u{1164}\u{11be}", "\u{bc7f}", "\u{1107}\u{1164}\u{11be}"),
        ("\u{bc80}", "\u{bc80}", "\u{1107}\u{1164}\u{11bf}", "\u{bc80}",
        "\u{1107}\u{1164}\u{11bf}"), ("\u{bc81}", "\u{bc81}", "\u{1107}\u{1164}\u{11c0}",
        "\u{bc81}", "\u{1107}\u{1164}\u{11c0}"), ("\u{bc82}", "\u{bc82}",
        "\u{1107}\u{1164}\u{11c1}", "\u{bc82}", "\u{1107}\u{1164}\u{11c1}"), ("\u{bc83}",
        "\u{bc83}", "\u{1107}\u{1164}\u{11c2}", "\u{bc83}", "\u{1107}\u{1164}\u{11c2}"),
        ("\u{bc84}", "\u{bc84}", "\u{1107}\u{1165}", "\u{bc84}", "\u{1107}\u{1165}"), ("\u{bc85}",
        "\u{bc85}", "\u{1107}\u{1165}\u{11a8}", "\u{bc85}", "\u{1107}\u{1165}\u{11a8}"),
        ("\u{bc86}", "\u{bc86}", "\u{1107}\u{1165}\u{11a9}", "\u{bc86}",
        "\u{1107}\u{1165}\u{11a9}"), ("\u{bc87}", "\u{bc87}", "\u{1107}\u{1165}\u{11aa}",
        "\u{bc87}", "\u{1107}\u{1165}\u{11aa}"), ("\u{bc88}", "\u{bc88}",
        "\u{1107}\u{1165}\u{11ab}", "\u{bc88}", "\u{1107}\u{1165}\u{11ab}"), ("\u{bc89}",
        "\u{bc89}", "\u{1107}\u{1165}\u{11ac}", "\u{bc89}", "\u{1107}\u{1165}\u{11ac}"),
        ("\u{bc8a}", "\u{bc8a}", "\u{1107}\u{1165}\u{11ad}", "\u{bc8a}",
        "\u{1107}\u{1165}\u{11ad}"), ("\u{bc8b}", "\u{bc8b}", "\u{1107}\u{1165}\u{11ae}",
        "\u{bc8b}", "\u{1107}\u{1165}\u{11ae}"), ("\u{bc8c}", "\u{bc8c}",
        "\u{1107}\u{1165}\u{11af}", "\u{bc8c}", "\u{1107}\u{1165}\u{11af}"), ("\u{bc8d}",
        "\u{bc8d}", "\u{1107}\u{1165}\u{11b0}", "\u{bc8d}", "\u{1107}\u{1165}\u{11b0}"),
        ("\u{bc8e}", "\u{bc8e}", "\u{1107}\u{1165}\u{11b1}", "\u{bc8e}",
        "\u{1107}\u{1165}\u{11b1}"), ("\u{bc8f}", "\u{bc8f}", "\u{1107}\u{1165}\u{11b2}",
        "\u{bc8f}", "\u{1107}\u{1165}\u{11b2}"), ("\u{bc90}", "\u{bc90}",
        "\u{1107}\u{1165}\u{11b3}", "\u{bc90}", "\u{1107}\u{1165}\u{11b3}"), ("\u{bc91}",
        "\u{bc91}", "\u{1107}\u{1165}\u{11b4}", "\u{bc91}", "\u{1107}\u{1165}\u{11b4}"),
        ("\u{bc92}", "\u{bc92}", "\u{1107}\u{1165}\u{11b5}", "\u{bc92}",
        "\u{1107}\u{1165}\u{11b5}"), ("\u{bc93}", "\u{bc93}", "\u{1107}\u{1165}\u{11b6}",
        "\u{bc93}", "\u{1107}\u{1165}\u{11b6}"), ("\u{bc94}", "\u{bc94}",
        "\u{1107}\u{1165}\u{11b7}", "\u{bc94}", "\u{1107}\u{1165}\u{11b7}"), ("\u{bc95}",
        "\u{bc95}", "\u{1107}\u{1165}\u{11b8}", "\u{bc95}", "\u{1107}\u{1165}\u{11b8}"),
        ("\u{bc96}", "\u{bc96}", "\u{1107}\u{1165}\u{11b9}", "\u{bc96}",
        "\u{1107}\u{1165}\u{11b9}"), ("\u{bc97}", "\u{bc97}", "\u{1107}\u{1165}\u{11ba}",
        "\u{bc97}", "\u{1107}\u{1165}\u{11ba}"), ("\u{bc98}", "\u{bc98}",
        "\u{1107}\u{1165}\u{11bb}", "\u{bc98}", "\u{1107}\u{1165}\u{11bb}"), ("\u{bc99}",
        "\u{bc99}", "\u{1107}\u{1165}\u{11bc}", "\u{bc99}", "\u{1107}\u{1165}\u{11bc}"),
        ("\u{bc9a}", "\u{bc9a}", "\u{1107}\u{1165}\u{11bd}", "\u{bc9a}",
        "\u{1107}\u{1165}\u{11bd}"), ("\u{bc9b}", "\u{bc9b}", "\u{1107}\u{1165}\u{11be}",
        "\u{bc9b}", "\u{1107}\u{1165}\u{11be}"), ("\u{bc9c}", "\u{bc9c}",
        "\u{1107}\u{1165}\u{11bf}", "\u{bc9c}", "\u{1107}\u{1165}\u{11bf}"), ("\u{bc9d}",
        "\u{bc9d}", "\u{1107}\u{1165}\u{11c0}", "\u{bc9d}", "\u{1107}\u{1165}\u{11c0}"),
        ("\u{bc9e}", "\u{bc9e}", "\u{1107}\u{1165}\u{11c1}", "\u{bc9e}",
        "\u{1107}\u{1165}\u{11c1}"), ("\u{bc9f}", "\u{bc9f}", "\u{1107}\u{1165}\u{11c2}",
        "\u{bc9f}", "\u{1107}\u{1165}\u{11c2}"), ("\u{bca0}", "\u{bca0}", "\u{1107}\u{1166}",
        "\u{bca0}", "\u{1107}\u{1166}"), ("\u{bca1}", "\u{bca1}", "\u{1107}\u{1166}\u{11a8}",
        "\u{bca1}", "\u{1107}\u{1166}\u{11a8}"), ("\u{bca2}", "\u{bca2}",
        "\u{1107}\u{1166}\u{11a9}", "\u{bca2}", "\u{1107}\u{1166}\u{11a9}"), ("\u{bca3}",
        "\u{bca3}", "\u{1107}\u{1166}\u{11aa}", "\u{bca3}", "\u{1107}\u{1166}\u{11aa}"),
        ("\u{bca4}", "\u{bca4}", "\u{1107}\u{1166}\u{11ab}", "\u{bca4}",
        "\u{1107}\u{1166}\u{11ab}"), ("\u{bca5}", "\u{bca5}", "\u{1107}\u{1166}\u{11ac}",
        "\u{bca5}", "\u{1107}\u{1166}\u{11ac}"), ("\u{bca6}", "\u{bca6}",
        "\u{1107}\u{1166}\u{11ad}", "\u{bca6}", "\u{1107}\u{1166}\u{11ad}"), ("\u{bca7}",
        "\u{bca7}", "\u{1107}\u{1166}\u{11ae}", "\u{bca7}", "\u{1107}\u{1166}\u{11ae}"),
        ("\u{bca8}", "\u{bca8}", "\u{1107}\u{1166}\u{11af}", "\u{bca8}",
        "\u{1107}\u{1166}\u{11af}"), ("\u{bca9}", "\u{bca9}", "\u{1107}\u{1166}\u{11b0}",
        "\u{bca9}", "\u{1107}\u{1166}\u{11b0}"), ("\u{bcaa}", "\u{bcaa}",
        "\u{1107}\u{1166}\u{11b1}", "\u{bcaa}", "\u{1107}\u{1166}\u{11b1}"), ("\u{bcab}",
        "\u{bcab}", "\u{1107}\u{1166}\u{11b2}", "\u{bcab}", "\u{1107}\u{1166}\u{11b2}"),
        ("\u{bcac}", "\u{bcac}", "\u{1107}\u{1166}\u{11b3}", "\u{bcac}",
        "\u{1107}\u{1166}\u{11b3}"), ("\u{bcad}", "\u{bcad}", "\u{1107}\u{1166}\u{11b4}",
        "\u{bcad}", "\u{1107}\u{1166}\u{11b4}"), ("\u{bcae}", "\u{bcae}",
        "\u{1107}\u{1166}\u{11b5}", "\u{bcae}", "\u{1107}\u{1166}\u{11b5}"), ("\u{bcaf}",
        "\u{bcaf}", "\u{1107}\u{1166}\u{11b6}", "\u{bcaf}", "\u{1107}\u{1166}\u{11b6}"),
        ("\u{bcb0}", "\u{bcb0}", "\u{1107}\u{1166}\u{11b7}", "\u{bcb0}",
        "\u{1107}\u{1166}\u{11b7}"), ("\u{bcb1}", "\u{bcb1}", "\u{1107}\u{1166}\u{11b8}",
        "\u{bcb1}", "\u{1107}\u{1166}\u{11b8}"), ("\u{bcb2}", "\u{bcb2}",
        "\u{1107}\u{1166}\u{11b9}", "\u{bcb2}", "\u{1107}\u{1166}\u{11b9}"), ("\u{bcb3}",
        "\u{bcb3}", "\u{1107}\u{1166}\u{11ba}", "\u{bcb3}", "\u{1107}\u{1166}\u{11ba}"),
        ("\u{bcb4}", "\u{bcb4}", "\u{1107}\u{1166}\u{11bb}", "\u{bcb4}",
        "\u{1107}\u{1166}\u{11bb}"), ("\u{bcb5}", "\u{bcb5}", "\u{1107}\u{1166}\u{11bc}",
        "\u{bcb5}", "\u{1107}\u{1166}\u{11bc}"), ("\u{bcb6}", "\u{bcb6}",
        "\u{1107}\u{1166}\u{11bd}", "\u{bcb6}", "\u{1107}\u{1166}\u{11bd}"), ("\u{bcb7}",
        "\u{bcb7}", "\u{1107}\u{1166}\u{11be}", "\u{bcb7}", "\u{1107}\u{1166}\u{11be}"),
        ("\u{bcb8}", "\u{bcb8}", "\u{1107}\u{1166}\u{11bf}", "\u{bcb8}",
        "\u{1107}\u{1166}\u{11bf}"), ("\u{bcb9}", "\u{bcb9}", "\u{1107}\u{1166}\u{11c0}",
        "\u{bcb9}", "\u{1107}\u{1166}\u{11c0}"), ("\u{bcba}", "\u{bcba}",
        "\u{1107}\u{1166}\u{11c1}", "\u{bcba}", "\u{1107}\u{1166}\u{11c1}"), ("\u{bcbb}",
        "\u{bcbb}", "\u{1107}\u{1166}\u{11c2}", "\u{bcbb}", "\u{1107}\u{1166}\u{11c2}"),
        ("\u{bcbc}", "\u{bcbc}", "\u{1107}\u{1167}", "\u{bcbc}", "\u{1107}\u{1167}"), ("\u{bcbd}",
        "\u{bcbd}", "\u{1107}\u{1167}\u{11a8}", "\u{bcbd}", "\u{1107}\u{1167}\u{11a8}"),
        ("\u{bcbe}", "\u{bcbe}", "\u{1107}\u{1167}\u{11a9}", "\u{bcbe}",
        "\u{1107}\u{1167}\u{11a9}"), ("\u{bcbf}", "\u{bcbf}", "\u{1107}\u{1167}\u{11aa}",
        "\u{bcbf}", "\u{1107}\u{1167}\u{11aa}"), ("\u{bcc0}", "\u{bcc0}",
        "\u{1107}\u{1167}\u{11ab}", "\u{bcc0}", "\u{1107}\u{1167}\u{11ab}"), ("\u{bcc1}",
        "\u{bcc1}", "\u{1107}\u{1167}\u{11ac}", "\u{bcc1}", "\u{1107}\u{1167}\u{11ac}"),
        ("\u{bcc2}", "\u{bcc2}", "\u{1107}\u{1167}\u{11ad}", "\u{bcc2}",
        "\u{1107}\u{1167}\u{11ad}"), ("\u{bcc3}", "\u{bcc3}", "\u{1107}\u{1167}\u{11ae}",
        "\u{bcc3}", "\u{1107}\u{1167}\u{11ae}"), ("\u{bcc4}", "\u{bcc4}",
        "\u{1107}\u{1167}\u{11af}", "\u{bcc4}", "\u{1107}\u{1167}\u{11af}"), ("\u{bcc5}",
        "\u{bcc5}", "\u{1107}\u{1167}\u{11b0}", "\u{bcc5}", "\u{1107}\u{1167}\u{11b0}"),
        ("\u{bcc6}", "\u{bcc6}", "\u{1107}\u{1167}\u{11b1}", "\u{bcc6}",
        "\u{1107}\u{1167}\u{11b1}"), ("\u{bcc7}", "\u{bcc7}", "\u{1107}\u{1167}\u{11b2}",
        "\u{bcc7}", "\u{1107}\u{1167}\u{11b2}"), ("\u{bcc8}", "\u{bcc8}",
        "\u{1107}\u{1167}\u{11b3}", "\u{bcc8}", "\u{1107}\u{1167}\u{11b3}"), ("\u{bcc9}",
        "\u{bcc9}", "\u{1107}\u{1167}\u{11b4}", "\u{bcc9}", "\u{1107}\u{1167}\u{11b4}"),
        ("\u{bcca}", "\u{bcca}", "\u{1107}\u{1167}\u{11b5}", "\u{bcca}",
        "\u{1107}\u{1167}\u{11b5}"), ("\u{bccb}", "\u{bccb}", "\u{1107}\u{1167}\u{11b6}",
        "\u{bccb}", "\u{1107}\u{1167}\u{11b6}"), ("\u{bccc}", "\u{bccc}",
        "\u{1107}\u{1167}\u{11b7}", "\u{bccc}", "\u{1107}\u{1167}\u{11b7}"), ("\u{bccd}",
        "\u{bccd}", "\u{1107}\u{1167}\u{11b8}", "\u{bccd}", "\u{1107}\u{1167}\u{11b8}"),
        ("\u{bcce}", "\u{bcce}", "\u{1107}\u{1167}\u{11b9}", "\u{bcce}",
        "\u{1107}\u{1167}\u{11b9}"), ("\u{bccf}", "\u{bccf}", "\u{1107}\u{1167}\u{11ba}",
        "\u{bccf}", "\u{1107}\u{1167}\u{11ba}"), ("\u{bcd0}", "\u{bcd0}",
        "\u{1107}\u{1167}\u{11bb}", "\u{bcd0}", "\u{1107}\u{1167}\u{11bb}"), ("\u{bcd1}",
        "\u{bcd1}", "\u{1107}\u{1167}\u{11bc}", "\u{bcd1}", "\u{1107}\u{1167}\u{11bc}"),
        ("\u{bcd2}", "\u{bcd2}", "\u{1107}\u{1167}\u{11bd}", "\u{bcd2}",
        "\u{1107}\u{1167}\u{11bd}"), ("\u{bcd3}", "\u{bcd3}", "\u{1107}\u{1167}\u{11be}",
        "\u{bcd3}", "\u{1107}\u{1167}\u{11be}"), ("\u{bcd4}", "\u{bcd4}",
        "\u{1107}\u{1167}\u{11bf}", "\u{bcd4}", "\u{1107}\u{1167}\u{11bf}"), ("\u{bcd5}",
        "\u{bcd5}", "\u{1107}\u{1167}\u{11c0}", "\u{bcd5}", "\u{1107}\u{1167}\u{11c0}"),
        ("\u{bcd6}", "\u{bcd6}", "\u{1107}\u{1167}\u{11c1}", "\u{bcd6}",
        "\u{1107}\u{1167}\u{11c1}"), ("\u{bcd7}", "\u{bcd7}", "\u{1107}\u{1167}\u{11c2}",
        "\u{bcd7}", "\u{1107}\u{1167}\u{11c2}"), ("\u{bcd8}", "\u{bcd8}", "\u{1107}\u{1168}",
        "\u{bcd8}", "\u{1107}\u{1168}"), ("\u{bcd9}", "\u{bcd9}", "\u{1107}\u{1168}\u{11a8}",
        "\u{bcd9}", "\u{1107}\u{1168}\u{11a8}"), ("\u{bcda}", "\u{bcda}",
        "\u{1107}\u{1168}\u{11a9}", "\u{bcda}", "\u{1107}\u{1168}\u{11a9}"), ("\u{bcdb}",
        "\u{bcdb}", "\u{1107}\u{1168}\u{11aa}", "\u{bcdb}", "\u{1107}\u{1168}\u{11aa}"),
        ("\u{bcdc}", "\u{bcdc}", "\u{1107}\u{1168}\u{11ab}", "\u{bcdc}",
        "\u{1107}\u{1168}\u{11ab}"), ("\u{bcdd}", "\u{bcdd}", "\u{1107}\u{1168}\u{11ac}",
        "\u{bcdd}", "\u{1107}\u{1168}\u{11ac}"), ("\u{bcde}", "\u{bcde}",
        "\u{1107}\u{1168}\u{11ad}", "\u{bcde}", "\u{1107}\u{1168}\u{11ad}"), ("\u{bcdf}",
        "\u{bcdf}", "\u{1107}\u{1168}\u{11ae}", "\u{bcdf}", "\u{1107}\u{1168}\u{11ae}"),
        ("\u{bce0}", "\u{bce0}", "\u{1107}\u{1168}\u{11af}", "\u{bce0}",
        "\u{1107}\u{1168}\u{11af}"), ("\u{bce1}", "\u{bce1}", "\u{1107}\u{1168}\u{11b0}",
        "\u{bce1}", "\u{1107}\u{1168}\u{11b0}"), ("\u{bce2}", "\u{bce2}",
        "\u{1107}\u{1168}\u{11b1}", "\u{bce2}", "\u{1107}\u{1168}\u{11b1}"), ("\u{bce3}",
        "\u{bce3}", "\u{1107}\u{1168}\u{11b2}", "\u{bce3}", "\u{1107}\u{1168}\u{11b2}"),
        ("\u{bce4}", "\u{bce4}", "\u{1107}\u{1168}\u{11b3}", "\u{bce4}",
        "\u{1107}\u{1168}\u{11b3}"), ("\u{bce5}", "\u{bce5}", "\u{1107}\u{1168}\u{11b4}",
        "\u{bce5}", "\u{1107}\u{1168}\u{11b4}"), ("\u{bce6}", "\u{bce6}",
        "\u{1107}\u{1168}\u{11b5}", "\u{bce6}", "\u{1107}\u{1168}\u{11b5}"), ("\u{bce7}",
        "\u{bce7}", "\u{1107}\u{1168}\u{11b6}", "\u{bce7}", "\u{1107}\u{1168}\u{11b6}"),
        ("\u{bce8}", "\u{bce8}", "\u{1107}\u{1168}\u{11b7}", "\u{bce8}",
        "\u{1107}\u{1168}\u{11b7}"), ("\u{bce9}", "\u{bce9}", "\u{1107}\u{1168}\u{11b8}",
        "\u{bce9}", "\u{1107}\u{1168}\u{11b8}"), ("\u{bcea}", "\u{bcea}",
        "\u{1107}\u{1168}\u{11b9}", "\u{bcea}", "\u{1107}\u{1168}\u{11b9}"), ("\u{bceb}",
        "\u{bceb}", "\u{1107}\u{1168}\u{11ba}", "\u{bceb}", "\u{1107}\u{1168}\u{11ba}"),
        ("\u{bcec}", "\u{bcec}", "\u{1107}\u{1168}\u{11bb}", "\u{bcec}",
        "\u{1107}\u{1168}\u{11bb}"), ("\u{bced}", "\u{bced}", "\u{1107}\u{1168}\u{11bc}",
        "\u{bced}", "\u{1107}\u{1168}\u{11bc}"), ("\u{bcee}", "\u{bcee}",
        "\u{1107}\u{1168}\u{11bd}", "\u{bcee}", "\u{1107}\u{1168}\u{11bd}"), ("\u{bcef}",
        "\u{bcef}", "\u{1107}\u{1168}\u{11be}", "\u{bcef}", "\u{1107}\u{1168}\u{11be}"),
        ("\u{bcf0}", "\u{bcf0}", "\u{1107}\u{1168}\u{11bf}", "\u{bcf0}",
        "\u{1107}\u{1168}\u{11bf}"), ("\u{bcf1}", "\u{bcf1}", "\u{1107}\u{1168}\u{11c0}",
        "\u{bcf1}", "\u{1107}\u{1168}\u{11c0}"), ("\u{bcf2}", "\u{bcf2}",
        "\u{1107}\u{1168}\u{11c1}", "\u{bcf2}", "\u{1107}\u{1168}\u{11c1}"), ("\u{bcf3}",
        "\u{bcf3}", "\u{1107}\u{1168}\u{11c2}", "\u{bcf3}", "\u{1107}\u{1168}\u{11c2}"),
        ("\u{bcf4}", "\u{bcf4}", "\u{1107}\u{1169}", "\u{bcf4}", "\u{1107}\u{1169}"), ("\u{bcf5}",
        "\u{bcf5}", "\u{1107}\u{1169}\u{11a8}", "\u{bcf5}", "\u{1107}\u{1169}\u{11a8}"),
        ("\u{bcf6}", "\u{bcf6}", "\u{1107}\u{1169}\u{11a9}", "\u{bcf6}",
        "\u{1107}\u{1169}\u{11a9}"), ("\u{bcf7}", "\u{bcf7}", "\u{1107}\u{1169}\u{11aa}",
        "\u{bcf7}", "\u{1107}\u{1169}\u{11aa}"), ("\u{bcf8}", "\u{bcf8}",
        "\u{1107}\u{1169}\u{11ab}", "\u{bcf8}", "\u{1107}\u{1169}\u{11ab}"), ("\u{bcf9}",
        "\u{bcf9}", "\u{1107}\u{1169}\u{11ac}", "\u{bcf9}", "\u{1107}\u{1169}\u{11ac}"),
        ("\u{bcfa}", "\u{bcfa}", "\u{1107}\u{1169}\u{11ad}", "\u{bcfa}",
        "\u{1107}\u{1169}\u{11ad}"), ("\u{bcfb}", "\u{bcfb}", "\u{1107}\u{1169}\u{11ae}",
        "\u{bcfb}", "\u{1107}\u{1169}\u{11ae}"), ("\u{bcfc}", "\u{bcfc}",
        "\u{1107}\u{1169}\u{11af}", "\u{bcfc}", "\u{1107}\u{1169}\u{11af}"), ("\u{bcfd}",
        "\u{bcfd}", "\u{1107}\u{1169}\u{11b0}", "\u{bcfd}", "\u{1107}\u{1169}\u{11b0}"),
        ("\u{bcfe}", "\u{bcfe}", "\u{1107}\u{1169}\u{11b1}", "\u{bcfe}",
        "\u{1107}\u{1169}\u{11b1}"), ("\u{bcff}", "\u{bcff}", "\u{1107}\u{1169}\u{11b2}",
        "\u{bcff}", "\u{1107}\u{1169}\u{11b2}"), ("\u{bd00}", "\u{bd00}",
        "\u{1107}\u{1169}\u{11b3}", "\u{bd00}", "\u{1107}\u{1169}\u{11b3}"), ("\u{bd01}",
        "\u{bd01}", "\u{1107}\u{1169}\u{11b4}", "\u{bd01}", "\u{1107}\u{1169}\u{11b4}"),
        ("\u{bd02}", "\u{bd02}", "\u{1107}\u{1169}\u{11b5}", "\u{bd02}",
        "\u{1107}\u{1169}\u{11b5}"), ("\u{bd03}", "\u{bd03}", "\u{1107}\u{1169}\u{11b6}",
        "\u{bd03}", "\u{1107}\u{1169}\u{11b6}"), ("\u{bd04}", "\u{bd04}",
        "\u{1107}\u{1169}\u{11b7}", "\u{bd04}", "\u{1107}\u{1169}\u{11b7}"), ("\u{bd05}",
        "\u{bd05}", "\u{1107}\u{1169}\u{11b8}", "\u{bd05}", "\u{1107}\u{1169}\u{11b8}"),
        ("\u{bd06}", "\u{bd06}", "\u{1107}\u{1169}\u{11b9}", "\u{bd06}",
        "\u{1107}\u{1169}\u{11b9}"), ("\u{bd07}", "\u{bd07}", "\u{1107}\u{1169}\u{11ba}",
        "\u{bd07}", "\u{1107}\u{1169}\u{11ba}"), ("\u{bd08}", "\u{bd08}",
        "\u{1107}\u{1169}\u{11bb}", "\u{bd08}", "\u{1107}\u{1169}\u{11bb}"), ("\u{bd09}",
        "\u{bd09}", "\u{1107}\u{1169}\u{11bc}", "\u{bd09}", "\u{1107}\u{1169}\u{11bc}"),
        ("\u{bd0a}", "\u{bd0a}", "\u{1107}\u{1169}\u{11bd}", "\u{bd0a}",
        "\u{1107}\u{1169}\u{11bd}"), ("\u{bd0b}", "\u{bd0b}", "\u{1107}\u{1169}\u{11be}",
        "\u{bd0b}", "\u{1107}\u{1169}\u{11be}"), ("\u{bd0c}", "\u{bd0c}",
        "\u{1107}\u{1169}\u{11bf}", "\u{bd0c}", "\u{1107}\u{1169}\u{11bf}"), ("\u{bd0d}",
        "\u{bd0d}", "\u{1107}\u{1169}\u{11c0}", "\u{bd0d}", "\u{1107}\u{1169}\u{11c0}"),
        ("\u{bd0e}", "\u{bd0e}", "\u{1107}\u{1169}\u{11c1}", "\u{bd0e}",
        "\u{1107}\u{1169}\u{11c1}"), ("\u{bd0f}", "\u{bd0f}", "\u{1107}\u{1169}\u{11c2}",
        "\u{bd0f}", "\u{1107}\u{1169}\u{11c2}"), ("\u{bd10}", "\u{bd10}", "\u{1107}\u{116a}",
        "\u{bd10}", "\u{1107}\u{116a}"), ("\u{bd11}", "\u{bd11}", "\u{1107}\u{116a}\u{11a8}",
        "\u{bd11}", "\u{1107}\u{116a}\u{11a8}"), ("\u{bd12}", "\u{bd12}",
        "\u{1107}\u{116a}\u{11a9}", "\u{bd12}", "\u{1107}\u{116a}\u{11a9}"), ("\u{bd13}",
        "\u{bd13}", "\u{1107}\u{116a}\u{11aa}", "\u{bd13}", "\u{1107}\u{116a}\u{11aa}"),
        ("\u{bd14}", "\u{bd14}", "\u{1107}\u{116a}\u{11ab}", "\u{bd14}",
        "\u{1107}\u{116a}\u{11ab}"), ("\u{bd15}", "\u{bd15}", "\u{1107}\u{116a}\u{11ac}",
        "\u{bd15}", "\u{1107}\u{116a}\u{11ac}"), ("\u{bd16}", "\u{bd16}",
        "\u{1107}\u{116a}\u{11ad}", "\u{bd16}", "\u{1107}\u{116a}\u{11ad}"), ("\u{bd17}",
        "\u{bd17}", "\u{1107}\u{116a}\u{11ae}", "\u{bd17}", "\u{1107}\u{116a}\u{11ae}"),
        ("\u{bd18}", "\u{bd18}", "\u{1107}\u{116a}\u{11af}", "\u{bd18}",
        "\u{1107}\u{116a}\u{11af}"), ("\u{bd19}", "\u{bd19}", "\u{1107}\u{116a}\u{11b0}",
        "\u{bd19}", "\u{1107}\u{116a}\u{11b0}"), ("\u{bd1a}", "\u{bd1a}",
        "\u{1107}\u{116a}\u{11b1}", "\u{bd1a}", "\u{1107}\u{116a}\u{11b1}"), ("\u{bd1b}",
        "\u{bd1b}", "\u{1107}\u{116a}\u{11b2}", "\u{bd1b}", "\u{1107}\u{116a}\u{11b2}"),
        ("\u{bd1c}", "\u{bd1c}", "\u{1107}\u{116a}\u{11b3}", "\u{bd1c}",
        "\u{1107}\u{116a}\u{11b3}"), ("\u{bd1d}", "\u{bd1d}", "\u{1107}\u{116a}\u{11b4}",
        "\u{bd1d}", "\u{1107}\u{116a}\u{11b4}"), ("\u{bd1e}", "\u{bd1e}",
        "\u{1107}\u{116a}\u{11b5}", "\u{bd1e}", "\u{1107}\u{116a}\u{11b5}"), ("\u{bd1f}",
        "\u{bd1f}", "\u{1107}\u{116a}\u{11b6}", "\u{bd1f}", "\u{1107}\u{116a}\u{11b6}"),
        ("\u{bd20}", "\u{bd20}", "\u{1107}\u{116a}\u{11b7}", "\u{bd20}",
        "\u{1107}\u{116a}\u{11b7}"), ("\u{bd21}", "\u{bd21}", "\u{1107}\u{116a}\u{11b8}",
        "\u{bd21}", "\u{1107}\u{116a}\u{11b8}"), ("\u{bd22}", "\u{bd22}",
        "\u{1107}\u{116a}\u{11b9}", "\u{bd22}", "\u{1107}\u{116a}\u{11b9}"), ("\u{bd23}",
        "\u{bd23}", "\u{1107}\u{116a}\u{11ba}", "\u{bd23}", "\u{1107}\u{116a}\u{11ba}"),
        ("\u{bd24}", "\u{bd24}", "\u{1107}\u{116a}\u{11bb}", "\u{bd24}",
        "\u{1107}\u{116a}\u{11bb}"), ("\u{bd25}", "\u{bd25}", "\u{1107}\u{116a}\u{11bc}",
        "\u{bd25}", "\u{1107}\u{116a}\u{11bc}"), ("\u{bd26}", "\u{bd26}",
        "\u{1107}\u{116a}\u{11bd}", "\u{bd26}", "\u{1107}\u{116a}\u{11bd}"), ("\u{bd27}",
        "\u{bd27}", "\u{1107}\u{116a}\u{11be}", "\u{bd27}", "\u{1107}\u{116a}\u{11be}"),
        ("\u{bd28}", "\u{bd28}", "\u{1107}\u{116a}\u{11bf}", "\u{bd28}",
        "\u{1107}\u{116a}\u{11bf}"), ("\u{bd29}", "\u{bd29}", "\u{1107}\u{116a}\u{11c0}",
        "\u{bd29}", "\u{1107}\u{116a}\u{11c0}"), ("\u{bd2a}", "\u{bd2a}",
        "\u{1107}\u{116a}\u{11c1}", "\u{bd2a}", "\u{1107}\u{116a}\u{11c1}"), ("\u{bd2b}",
        "\u{bd2b}", "\u{1107}\u{116a}\u{11c2}", "\u{bd2b}", "\u{1107}\u{116a}\u{11c2}"),
        ("\u{bd2c}", "\u{bd2c}", "\u{1107}\u{116b}", "\u{bd2c}", "\u{1107}\u{116b}"), ("\u{bd2d}",
        "\u{bd2d}", "\u{1107}\u{116b}\u{11a8}", "\u{bd2d}", "\u{1107}\u{116b}\u{11a8}"),
        ("\u{bd2e}", "\u{bd2e}", "\u{1107}\u{116b}\u{11a9}", "\u{bd2e}",
        "\u{1107}\u{116b}\u{11a9}"), ("\u{bd2f}", "\u{bd2f}", "\u{1107}\u{116b}\u{11aa}",
        "\u{bd2f}", "\u{1107}\u{116b}\u{11aa}"), ("\u{bd30}", "\u{bd30}",
        "\u{1107}\u{116b}\u{11ab}", "\u{bd30}", "\u{1107}\u{116b}\u{11ab}"), ("\u{bd31}",
        "\u{bd31}", "\u{1107}\u{116b}\u{11ac}", "\u{bd31}", "\u{1107}\u{116b}\u{11ac}"),
        ("\u{bd32}", "\u{bd32}", "\u{1107}\u{116b}\u{11ad}", "\u{bd32}",
        "\u{1107}\u{116b}\u{11ad}"), ("\u{bd33}", "\u{bd33}", "\u{1107}\u{116b}\u{11ae}",
        "\u{bd33}", "\u{1107}\u{116b}\u{11ae}"), ("\u{bd34}", "\u{bd34}",
        "\u{1107}\u{116b}\u{11af}", "\u{bd34}", "\u{1107}\u{116b}\u{11af}"), ("\u{bd35}",
        "\u{bd35}", "\u{1107}\u{116b}\u{11b0}", "\u{bd35}", "\u{1107}\u{116b}\u{11b0}"),
        ("\u{bd36}", "\u{bd36}", "\u{1107}\u{116b}\u{11b1}", "\u{bd36}",
        "\u{1107}\u{116b}\u{11b1}"), ("\u{bd37}", "\u{bd37}", "\u{1107}\u{116b}\u{11b2}",
        "\u{bd37}", "\u{1107}\u{116b}\u{11b2}"), ("\u{bd38}", "\u{bd38}",
        "\u{1107}\u{116b}\u{11b3}", "\u{bd38}", "\u{1107}\u{116b}\u{11b3}"), ("\u{bd39}",
        "\u{bd39}", "\u{1107}\u{116b}\u{11b4}", "\u{bd39}", "\u{1107}\u{116b}\u{11b4}"),
        ("\u{bd3a}", "\u{bd3a}", "\u{1107}\u{116b}\u{11b5}", "\u{bd3a}",
        "\u{1107}\u{116b}\u{11b5}"), ("\u{bd3b}", "\u{bd3b}", "\u{1107}\u{116b}\u{11b6}",
        "\u{bd3b}", "\u{1107}\u{116b}\u{11b6}"), ("\u{bd3c}", "\u{bd3c}",
        "\u{1107}\u{116b}\u{11b7}", "\u{bd3c}", "\u{1107}\u{116b}\u{11b7}"), ("\u{bd3d}",
        "\u{bd3d}", "\u{1107}\u{116b}\u{11b8}", "\u{bd3d}", "\u{1107}\u{116b}\u{11b8}"),
        ("\u{bd3e}", "\u{bd3e}", "\u{1107}\u{116b}\u{11b9}", "\u{bd3e}",
        "\u{1107}\u{116b}\u{11b9}"), ("\u{bd3f}", "\u{bd3f}", "\u{1107}\u{116b}\u{11ba}",
        "\u{bd3f}", "\u{1107}\u{116b}\u{11ba}"), ("\u{bd40}", "\u{bd40}",
        "\u{1107}\u{116b}\u{11bb}", "\u{bd40}", "\u{1107}\u{116b}\u{11bb}"), ("\u{bd41}",
        "\u{bd41}", "\u{1107}\u{116b}\u{11bc}", "\u{bd41}", "\u{1107}\u{116b}\u{11bc}"),
        ("\u{bd42}", "\u{bd42}", "\u{1107}\u{116b}\u{11bd}", "\u{bd42}",
        "\u{1107}\u{116b}\u{11bd}"), ("\u{bd43}", "\u{bd43}", "\u{1107}\u{116b}\u{11be}",
        "\u{bd43}", "\u{1107}\u{116b}\u{11be}"), ("\u{bd44}", "\u{bd44}",
        "\u{1107}\u{116b}\u{11bf}", "\u{bd44}", "\u{1107}\u{116b}\u{11bf}"), ("\u{bd45}",
        "\u{bd45}", "\u{1107}\u{116b}\u{11c0}", "\u{bd45}", "\u{1107}\u{116b}\u{11c0}"),
        ("\u{bd46}", "\u{bd46}", "\u{1107}\u{116b}\u{11c1}", "\u{bd46}",
        "\u{1107}\u{116b}\u{11c1}"), ("\u{bd47}", "\u{bd47}", "\u{1107}\u{116b}\u{11c2}",
        "\u{bd47}", "\u{1107}\u{116b}\u{11c2}"), ("\u{bd48}", "\u{bd48}", "\u{1107}\u{116c}",
        "\u{bd48}", "\u{1107}\u{116c}"), ("\u{bd49}", "\u{bd49}", "\u{1107}\u{116c}\u{11a8}",
        "\u{bd49}", "\u{1107}\u{116c}\u{11a8}"), ("\u{bd4a}", "\u{bd4a}",
        "\u{1107}\u{116c}\u{11a9}", "\u{bd4a}", "\u{1107}\u{116c}\u{11a9}"), ("\u{bd4b}",
        "\u{bd4b}", "\u{1107}\u{116c}\u{11aa}", "\u{bd4b}", "\u{1107}\u{116c}\u{11aa}"),
        ("\u{bd4c}", "\u{bd4c}", "\u{1107}\u{116c}\u{11ab}", "\u{bd4c}",
        "\u{1107}\u{116c}\u{11ab}"), ("\u{bd4d}", "\u{bd4d}", "\u{1107}\u{116c}\u{11ac}",
        "\u{bd4d}", "\u{1107}\u{116c}\u{11ac}"), ("\u{bd4e}", "\u{bd4e}",
        "\u{1107}\u{116c}\u{11ad}", "\u{bd4e}", "\u{1107}\u{116c}\u{11ad}"), ("\u{bd4f}",
        "\u{bd4f}", "\u{1107}\u{116c}\u{11ae}", "\u{bd4f}", "\u{1107}\u{116c}\u{11ae}"),
        ("\u{bd50}", "\u{bd50}", "\u{1107}\u{116c}\u{11af}", "\u{bd50}",
        "\u{1107}\u{116c}\u{11af}"), ("\u{bd51}", "\u{bd51}", "\u{1107}\u{116c}\u{11b0}",
        "\u{bd51}", "\u{1107}\u{116c}\u{11b0}"), ("\u{bd52}", "\u{bd52}",
        "\u{1107}\u{116c}\u{11b1}", "\u{bd52}", "\u{1107}\u{116c}\u{11b1}"), ("\u{bd53}",
        "\u{bd53}", "\u{1107}\u{116c}\u{11b2}", "\u{bd53}", "\u{1107}\u{116c}\u{11b2}"),
        ("\u{bd54}", "\u{bd54}", "\u{1107}\u{116c}\u{11b3}", "\u{bd54}",
        "\u{1107}\u{116c}\u{11b3}"), ("\u{bd55}", "\u{bd55}", "\u{1107}\u{116c}\u{11b4}",
        "\u{bd55}", "\u{1107}\u{116c}\u{11b4}"), ("\u{bd56}", "\u{bd56}",
        "\u{1107}\u{116c}\u{11b5}", "\u{bd56}", "\u{1107}\u{116c}\u{11b5}"), ("\u{bd57}",
        "\u{bd57}", "\u{1107}\u{116c}\u{11b6}", "\u{bd57}", "\u{1107}\u{116c}\u{11b6}"),
        ("\u{bd58}", "\u{bd58}", "\u{1107}\u{116c}\u{11b7}", "\u{bd58}",
        "\u{1107}\u{116c}\u{11b7}"), ("\u{bd59}", "\u{bd59}", "\u{1107}\u{116c}\u{11b8}",
        "\u{bd59}", "\u{1107}\u{116c}\u{11b8}"), ("\u{bd5a}", "\u{bd5a}",
        "\u{1107}\u{116c}\u{11b9}", "\u{bd5a}", "\u{1107}\u{116c}\u{11b9}"), ("\u{bd5b}",
        "\u{bd5b}", "\u{1107}\u{116c}\u{11ba}", "\u{bd5b}", "\u{1107}\u{116c}\u{11ba}"),
        ("\u{bd5c}", "\u{bd5c}", "\u{1107}\u{116c}\u{11bb}", "\u{bd5c}",
        "\u{1107}\u{116c}\u{11bb}"), ("\u{bd5d}", "\u{bd5d}", "\u{1107}\u{116c}\u{11bc}",
        "\u{bd5d}", "\u{1107}\u{116c}\u{11bc}"), ("\u{bd5e}", "\u{bd5e}",
        "\u{1107}\u{116c}\u{11bd}", "\u{bd5e}", "\u{1107}\u{116c}\u{11bd}"), ("\u{bd5f}",
        "\u{bd5f}", "\u{1107}\u{116c}\u{11be}", "\u{bd5f}", "\u{1107}\u{116c}\u{11be}"),
        ("\u{bd60}", "\u{bd60}", "\u{1107}\u{116c}\u{11bf}", "\u{bd60}",
        "\u{1107}\u{116c}\u{11bf}"), ("\u{bd61}", "\u{bd61}", "\u{1107}\u{116c}\u{11c0}",
        "\u{bd61}", "\u{1107}\u{116c}\u{11c0}"), ("\u{bd62}", "\u{bd62}",
        "\u{1107}\u{116c}\u{11c1}", "\u{bd62}", "\u{1107}\u{116c}\u{11c1}"), ("\u{bd63}",
        "\u{bd63}", "\u{1107}\u{116c}\u{11c2}", "\u{bd63}", "\u{1107}\u{116c}\u{11c2}"),
        ("\u{bd64}", "\u{bd64}", "\u{1107}\u{116d}", "\u{bd64}", "\u{1107}\u{116d}"), ("\u{bd65}",
        "\u{bd65}", "\u{1107}\u{116d}\u{11a8}", "\u{bd65}", "\u{1107}\u{116d}\u{11a8}"),
        ("\u{bd66}", "\u{bd66}", "\u{1107}\u{116d}\u{11a9}", "\u{bd66}",
        "\u{1107}\u{116d}\u{11a9}"), ("\u{bd67}", "\u{bd67}", "\u{1107}\u{116d}\u{11aa}",
        "\u{bd67}", "\u{1107}\u{116d}\u{11aa}"), ("\u{bd68}", "\u{bd68}",
        "\u{1107}\u{116d}\u{11ab}", "\u{bd68}", "\u{1107}\u{116d}\u{11ab}"), ("\u{bd69}",
        "\u{bd69}", "\u{1107}\u{116d}\u{11ac}", "\u{bd69}", "\u{1107}\u{116d}\u{11ac}"),
        ("\u{bd6a}", "\u{bd6a}", "\u{1107}\u{116d}\u{11ad}", "\u{bd6a}",
        "\u{1107}\u{116d}\u{11ad}"), ("\u{bd6b}", "\u{bd6b}", "\u{1107}\u{116d}\u{11ae}",
        "\u{bd6b}", "\u{1107}\u{116d}\u{11ae}"), ("\u{bd6c}", "\u{bd6c}",
        "\u{1107}\u{116d}\u{11af}", "\u{bd6c}", "\u{1107}\u{116d}\u{11af}"), ("\u{bd6d}",
        "\u{bd6d}", "\u{1107}\u{116d}\u{11b0}", "\u{bd6d}", "\u{1107}\u{116d}\u{11b0}"),
        ("\u{bd6e}", "\u{bd6e}", "\u{1107}\u{116d}\u{11b1}", "\u{bd6e}",
        "\u{1107}\u{116d}\u{11b1}"), ("\u{bd6f}", "\u{bd6f}", "\u{1107}\u{116d}\u{11b2}",
        "\u{bd6f}", "\u{1107}\u{116d}\u{11b2}"), ("\u{bd70}", "\u{bd70}",
        "\u{1107}\u{116d}\u{11b3}", "\u{bd70}", "\u{1107}\u{116d}\u{11b3}"), ("\u{bd71}",
        "\u{bd71}", "\u{1107}\u{116d}\u{11b4}", "\u{bd71}", "\u{1107}\u{116d}\u{11b4}"),
        ("\u{bd72}", "\u{bd72}", "\u{1107}\u{116d}\u{11b5}", "\u{bd72}",
        "\u{1107}\u{116d}\u{11b5}"), ("\u{bd73}", "\u{bd73}", "\u{1107}\u{116d}\u{11b6}",
        "\u{bd73}", "\u{1107}\u{116d}\u{11b6}"), ("\u{bd74}", "\u{bd74}",
        "\u{1107}\u{116d}\u{11b7}", "\u{bd74}", "\u{1107}\u{116d}\u{11b7}"), ("\u{bd75}",
        "\u{bd75}", "\u{1107}\u{116d}\u{11b8}", "\u{bd75}", "\u{1107}\u{116d}\u{11b8}"),
        ("\u{bd76}", "\u{bd76}", "\u{1107}\u{116d}\u{11b9}", "\u{bd76}",
        "\u{1107}\u{116d}\u{11b9}"), ("\u{bd77}", "\u{bd77}", "\u{1107}\u{116d}\u{11ba}",
        "\u{bd77}", "\u{1107}\u{116d}\u{11ba}"), ("\u{bd78}", "\u{bd78}",
        "\u{1107}\u{116d}\u{11bb}", "\u{bd78}", "\u{1107}\u{116d}\u{11bb}"), ("\u{bd79}",
        "\u{bd79}", "\u{1107}\u{116d}\u{11bc}", "\u{bd79}", "\u{1107}\u{116d}\u{11bc}"),
        ("\u{bd7a}", "\u{bd7a}", "\u{1107}\u{116d}\u{11bd}", "\u{bd7a}",
        "\u{1107}\u{116d}\u{11bd}"), ("\u{bd7b}", "\u{bd7b}", "\u{1107}\u{116d}\u{11be}",
        "\u{bd7b}", "\u{1107}\u{116d}\u{11be}"), ("\u{bd7c}", "\u{bd7c}",
        "\u{1107}\u{116d}\u{11bf}", "\u{bd7c}", "\u{1107}\u{116d}\u{11bf}"), ("\u{bd7d}",
        "\u{bd7d}", "\u{1107}\u{116d}\u{11c0}", "\u{bd7d}", "\u{1107}\u{116d}\u{11c0}"),
        ("\u{bd7e}", "\u{bd7e}", "\u{1107}\u{116d}\u{11c1}", "\u{bd7e}",
        "\u{1107}\u{116d}\u{11c1}"), ("\u{bd7f}", "\u{bd7f}", "\u{1107}\u{116d}\u{11c2}",
        "\u{bd7f}", "\u{1107}\u{116d}\u{11c2}"), ("\u{bd80}", "\u{bd80}", "\u{1107}\u{116e}",
        "\u{bd80}", "\u{1107}\u{116e}"), ("\u{bd81}", "\u{bd81}", "\u{1107}\u{116e}\u{11a8}",
        "\u{bd81}", "\u{1107}\u{116e}\u{11a8}"), ("\u{bd82}", "\u{bd82}",
        "\u{1107}\u{116e}\u{11a9}", "\u{bd82}", "\u{1107}\u{116e}\u{11a9}"), ("\u{bd83}",
        "\u{bd83}", "\u{1107}\u{116e}\u{11aa}", "\u{bd83}", "\u{1107}\u{116e}\u{11aa}"),
        ("\u{bd84}", "\u{bd84}", "\u{1107}\u{116e}\u{11ab}", "\u{bd84}",
        "\u{1107}\u{116e}\u{11ab}"), ("\u{bd85}", "\u{bd85}", "\u{1107}\u{116e}\u{11ac}",
        "\u{bd85}", "\u{1107}\u{116e}\u{11ac}"), ("\u{bd86}", "\u{bd86}",
        "\u{1107}\u{116e}\u{11ad}", "\u{bd86}", "\u{1107}\u{116e}\u{11ad}"), ("\u{bd87}",
        "\u{bd87}", "\u{1107}\u{116e}\u{11ae}", "\u{bd87}", "\u{1107}\u{116e}\u{11ae}"),
        ("\u{bd88}", "\u{bd88}", "\u{1107}\u{116e}\u{11af}", "\u{bd88}",
        "\u{1107}\u{116e}\u{11af}"), ("\u{bd89}", "\u{bd89}", "\u{1107}\u{116e}\u{11b0}",
        "\u{bd89}", "\u{1107}\u{116e}\u{11b0}"), ("\u{bd8a}", "\u{bd8a}",
        "\u{1107}\u{116e}\u{11b1}", "\u{bd8a}", "\u{1107}\u{116e}\u{11b1}"), ("\u{bd8b}",
        "\u{bd8b}", "\u{1107}\u{116e}\u{11b2}", "\u{bd8b}", "\u{1107}\u{116e}\u{11b2}"),
        ("\u{bd8c}", "\u{bd8c}", "\u{1107}\u{116e}\u{11b3}", "\u{bd8c}",
        "\u{1107}\u{116e}\u{11b3}"), ("\u{bd8d}", "\u{bd8d}", "\u{1107}\u{116e}\u{11b4}",
        "\u{bd8d}", "\u{1107}\u{116e}\u{11b4}"), ("\u{bd8e}", "\u{bd8e}",
        "\u{1107}\u{116e}\u{11b5}", "\u{bd8e}", "\u{1107}\u{116e}\u{11b5}"), ("\u{bd8f}",
        "\u{bd8f}", "\u{1107}\u{116e}\u{11b6}", "\u{bd8f}", "\u{1107}\u{116e}\u{11b6}"),
        ("\u{bd90}", "\u{bd90}", "\u{1107}\u{116e}\u{11b7}", "\u{bd90}",
        "\u{1107}\u{116e}\u{11b7}"), ("\u{bd91}", "\u{bd91}", "\u{1107}\u{116e}\u{11b8}",
        "\u{bd91}", "\u{1107}\u{116e}\u{11b8}"), ("\u{bd92}", "\u{bd92}",
        "\u{1107}\u{116e}\u{11b9}", "\u{bd92}", "\u{1107}\u{116e}\u{11b9}"), ("\u{bd93}",
        "\u{bd93}", "\u{1107}\u{116e}\u{11ba}", "\u{bd93}", "\u{1107}\u{116e}\u{11ba}"),
        ("\u{bd94}", "\u{bd94}", "\u{1107}\u{116e}\u{11bb}", "\u{bd94}",
        "\u{1107}\u{116e}\u{11bb}"), ("\u{bd95}", "\u{bd95}", "\u{1107}\u{116e}\u{11bc}",
        "\u{bd95}", "\u{1107}\u{116e}\u{11bc}"), ("\u{bd96}", "\u{bd96}",
        "\u{1107}\u{116e}\u{11bd}", "\u{bd96}", "\u{1107}\u{116e}\u{11bd}"), ("\u{bd97}",
        "\u{bd97}", "\u{1107}\u{116e}\u{11be}", "\u{bd97}", "\u{1107}\u{116e}\u{11be}"),
        ("\u{bd98}", "\u{bd98}", "\u{1107}\u{116e}\u{11bf}", "\u{bd98}",
        "\u{1107}\u{116e}\u{11bf}"), ("\u{bd99}", "\u{bd99}", "\u{1107}\u{116e}\u{11c0}",
        "\u{bd99}", "\u{1107}\u{116e}\u{11c0}"), ("\u{bd9a}", "\u{bd9a}",
        "\u{1107}\u{116e}\u{11c1}", "\u{bd9a}", "\u{1107}\u{116e}\u{11c1}"), ("\u{bd9b}",
        "\u{bd9b}", "\u{1107}\u{116e}\u{11c2}", "\u{bd9b}", "\u{1107}\u{116e}\u{11c2}"),
        ("\u{bd9c}", "\u{bd9c}", "\u{1107}\u{116f}", "\u{bd9c}", "\u{1107}\u{116f}"), ("\u{bd9d}",
        "\u{bd9d}", "\u{1107}\u{116f}\u{11a8}", "\u{bd9d}", "\u{1107}\u{116f}\u{11a8}"),
        ("\u{bd9e}", "\u{bd9e}", "\u{1107}\u{116f}\u{11a9}", "\u{bd9e}",
        "\u{1107}\u{116f}\u{11a9}"), ("\u{bd9f}", "\u{bd9f}", "\u{1107}\u{116f}\u{11aa}",
        "\u{bd9f}", "\u{1107}\u{116f}\u{11aa}"), ("\u{bda0}", "\u{bda0}",
        "\u{1107}\u{116f}\u{11ab}", "\u{bda0}", "\u{1107}\u{116f}\u{11ab}"), ("\u{bda1}",
        "\u{bda1}", "\u{1107}\u{116f}\u{11ac}", "\u{bda1}", "\u{1107}\u{116f}\u{11ac}"),
        ("\u{bda2}", "\u{bda2}", "\u{1107}\u{116f}\u{11ad}", "\u{bda2}",
        "\u{1107}\u{116f}\u{11ad}"), ("\u{bda3}", "\u{bda3}", "\u{1107}\u{116f}\u{11ae}",
        "\u{bda3}", "\u{1107}\u{116f}\u{11ae}"), ("\u{bda4}", "\u{bda4}",
        "\u{1107}\u{116f}\u{11af}", "\u{bda4}", "\u{1107}\u{116f}\u{11af}"), ("\u{bda5}",
        "\u{bda5}", "\u{1107}\u{116f}\u{11b0}", "\u{bda5}", "\u{1107}\u{116f}\u{11b0}"),
        ("\u{bda6}", "\u{bda6}", "\u{1107}\u{116f}\u{11b1}", "\u{bda6}",
        "\u{1107}\u{116f}\u{11b1}"), ("\u{bda7}", "\u{bda7}", "\u{1107}\u{116f}\u{11b2}",
        "\u{bda7}", "\u{1107}\u{116f}\u{11b2}"), ("\u{bda8}", "\u{bda8}",
        "\u{1107}\u{116f}\u{11b3}", "\u{bda8}", "\u{1107}\u{116f}\u{11b3}"), ("\u{bda9}",
        "\u{bda9}", "\u{1107}\u{116f}\u{11b4}", "\u{bda9}", "\u{1107}\u{116f}\u{11b4}"),
        ("\u{bdaa}", "\u{bdaa}", "\u{1107}\u{116f}\u{11b5}", "\u{bdaa}",
        "\u{1107}\u{116f}\u{11b5}"), ("\u{bdab}", "\u{bdab}", "\u{1107}\u{116f}\u{11b6}",
        "\u{bdab}", "\u{1107}\u{116f}\u{11b6}"), ("\u{bdac}", "\u{bdac}",
        "\u{1107}\u{116f}\u{11b7}", "\u{bdac}", "\u{1107}\u{116f}\u{11b7}"), ("\u{bdad}",
        "\u{bdad}", "\u{1107}\u{116f}\u{11b8}", "\u{bdad}", "\u{1107}\u{116f}\u{11b8}"),
        ("\u{bdae}", "\u{bdae}", "\u{1107}\u{116f}\u{11b9}", "\u{bdae}",
        "\u{1107}\u{116f}\u{11b9}"), ("\u{bdaf}", "\u{bdaf}", "\u{1107}\u{116f}\u{11ba}",
        "\u{bdaf}", "\u{1107}\u{116f}\u{11ba}"), ("\u{bdb0}", "\u{bdb0}",
        "\u{1107}\u{116f}\u{11bb}", "\u{bdb0}", "\u{1107}\u{116f}\u{11bb}"), ("\u{bdb1}",
        "\u{bdb1}", "\u{1107}\u{116f}\u{11bc}", "\u{bdb1}", "\u{1107}\u{116f}\u{11bc}"),
        ("\u{bdb2}", "\u{bdb2}", "\u{1107}\u{116f}\u{11bd}", "\u{bdb2}",
        "\u{1107}\u{116f}\u{11bd}"), ("\u{bdb3}", "\u{bdb3}", "\u{1107}\u{116f}\u{11be}",
        "\u{bdb3}", "\u{1107}\u{116f}\u{11be}"), ("\u{bdb4}", "\u{bdb4}",
        "\u{1107}\u{116f}\u{11bf}", "\u{bdb4}", "\u{1107}\u{116f}\u{11bf}"), ("\u{bdb5}",
        "\u{bdb5}", "\u{1107}\u{116f}\u{11c0}", "\u{bdb5}", "\u{1107}\u{116f}\u{11c0}"),
        ("\u{bdb6}", "\u{bdb6}", "\u{1107}\u{116f}\u{11c1}", "\u{bdb6}",
        "\u{1107}\u{116f}\u{11c1}"), ("\u{bdb7}", "\u{bdb7}", "\u{1107}\u{116f}\u{11c2}",
        "\u{bdb7}", "\u{1107}\u{116f}\u{11c2}"), ("\u{bdb8}", "\u{bdb8}", "\u{1107}\u{1170}",
        "\u{bdb8}", "\u{1107}\u{1170}"), ("\u{bdb9}", "\u{bdb9}", "\u{1107}\u{1170}\u{11a8}",
        "\u{bdb9}", "\u{1107}\u{1170}\u{11a8}"), ("\u{bdba}", "\u{bdba}",
        "\u{1107}\u{1170}\u{11a9}", "\u{bdba}", "\u{1107}\u{1170}\u{11a9}"), ("\u{bdbb}",
        "\u{bdbb}", "\u{1107}\u{1170}\u{11aa}", "\u{bdbb}", "\u{1107}\u{1170}\u{11aa}"),
        ("\u{bdbc}", "\u{bdbc}", "\u{1107}\u{1170}\u{11ab}", "\u{bdbc}",
        "\u{1107}\u{1170}\u{11ab}"), ("\u{bdbd}", "\u{bdbd}", "\u{1107}\u{1170}\u{11ac}",
        "\u{bdbd}", "\u{1107}\u{1170}\u{11ac}"), ("\u{bdbe}", "\u{bdbe}",
        "\u{1107}\u{1170}\u{11ad}", "\u{bdbe}", "\u{1107}\u{1170}\u{11ad}"), ("\u{bdbf}",
        "\u{bdbf}", "\u{1107}\u{1170}\u{11ae}", "\u{bdbf}", "\u{1107}\u{1170}\u{11ae}"),
        ("\u{bdc0}", "\u{bdc0}", "\u{1107}\u{1170}\u{11af}", "\u{bdc0}",
        "\u{1107}\u{1170}\u{11af}"), ("\u{bdc1}", "\u{bdc1}", "\u{1107}\u{1170}\u{11b0}",
        "\u{bdc1}", "\u{1107}\u{1170}\u{11b0}"), ("\u{bdc2}", "\u{bdc2}",
        "\u{1107}\u{1170}\u{11b1}", "\u{bdc2}", "\u{1107}\u{1170}\u{11b1}"), ("\u{bdc3}",
        "\u{bdc3}", "\u{1107}\u{1170}\u{11b2}", "\u{bdc3}", "\u{1107}\u{1170}\u{11b2}"),
        ("\u{bdc4}", "\u{bdc4}", "\u{1107}\u{1170}\u{11b3}", "\u{bdc4}",
        "\u{1107}\u{1170}\u{11b3}"), ("\u{bdc5}", "\u{bdc5}", "\u{1107}\u{1170}\u{11b4}",
        "\u{bdc5}", "\u{1107}\u{1170}\u{11b4}"), ("\u{bdc6}", "\u{bdc6}",
        "\u{1107}\u{1170}\u{11b5}", "\u{bdc6}", "\u{1107}\u{1170}\u{11b5}"), ("\u{bdc7}",
        "\u{bdc7}", "\u{1107}\u{1170}\u{11b6}", "\u{bdc7}", "\u{1107}\u{1170}\u{11b6}"),
        ("\u{bdc8}", "\u{bdc8}", "\u{1107}\u{1170}\u{11b7}", "\u{bdc8}",
        "\u{1107}\u{1170}\u{11b7}"), ("\u{bdc9}", "\u{bdc9}", "\u{1107}\u{1170}\u{11b8}",
        "\u{bdc9}", "\u{1107}\u{1170}\u{11b8}"), ("\u{bdca}", "\u{bdca}",
        "\u{1107}\u{1170}\u{11b9}", "\u{bdca}", "\u{1107}\u{1170}\u{11b9}"), ("\u{bdcb}",
        "\u{bdcb}", "\u{1107}\u{1170}\u{11ba}", "\u{bdcb}", "\u{1107}\u{1170}\u{11ba}"),
        ("\u{bdcc}", "\u{bdcc}", "\u{1107}\u{1170}\u{11bb}", "\u{bdcc}",
        "\u{1107}\u{1170}\u{11bb}"), ("\u{bdcd}", "\u{bdcd}", "\u{1107}\u{1170}\u{11bc}",
        "\u{bdcd}", "\u{1107}\u{1170}\u{11bc}"), ("\u{bdce}", "\u{bdce}",
        "\u{1107}\u{1170}\u{11bd}", "\u{bdce}", "\u{1107}\u{1170}\u{11bd}"), ("\u{bdcf}",
        "\u{bdcf}", "\u{1107}\u{1170}\u{11be}", "\u{bdcf}", "\u{1107}\u{1170}\u{11be}"),
        ("\u{bdd0}", "\u{bdd0}", "\u{1107}\u{1170}\u{11bf}", "\u{bdd0}",
        "\u{1107}\u{1170}\u{11bf}"), ("\u{bdd1}", "\u{bdd1}", "\u{1107}\u{1170}\u{11c0}",
        "\u{bdd1}", "\u{1107}\u{1170}\u{11c0}"), ("\u{bdd2}", "\u{bdd2}",
        "\u{1107}\u{1170}\u{11c1}", "\u{bdd2}", "\u{1107}\u{1170}\u{11c1}"), ("\u{bdd3}",
        "\u{bdd3}", "\u{1107}\u{1170}\u{11c2}", "\u{bdd3}", "\u{1107}\u{1170}\u{11c2}"),
        ("\u{bdd4}", "\u{bdd4}", "\u{1107}\u{1171}", "\u{bdd4}", "\u{1107}\u{1171}"), ("\u{bdd5}",
        "\u{bdd5}", "\u{1107}\u{1171}\u{11a8}", "\u{bdd5}", "\u{1107}\u{1171}\u{11a8}"),
        ("\u{bdd6}", "\u{bdd6}", "\u{1107}\u{1171}\u{11a9}", "\u{bdd6}",
        "\u{1107}\u{1171}\u{11a9}"), ("\u{bdd7}", "\u{bdd7}", "\u{1107}\u{1171}\u{11aa}",
        "\u{bdd7}", "\u{1107}\u{1171}\u{11aa}"), ("\u{bdd8}", "\u{bdd8}",
        "\u{1107}\u{1171}\u{11ab}", "\u{bdd8}", "\u{1107}\u{1171}\u{11ab}"), ("\u{bdd9}",
        "\u{bdd9}", "\u{1107}\u{1171}\u{11ac}", "\u{bdd9}", "\u{1107}\u{1171}\u{11ac}"),
        ("\u{bdda}", "\u{bdda}", "\u{1107}\u{1171}\u{11ad}", "\u{bdda}",
        "\u{1107}\u{1171}\u{11ad}"), ("\u{bddb}", "\u{bddb}", "\u{1107}\u{1171}\u{11ae}",
        "\u{bddb}", "\u{1107}\u{1171}\u{11ae}"), ("\u{bddc}", "\u{bddc}",
        "\u{1107}\u{1171}\u{11af}", "\u{bddc}", "\u{1107}\u{1171}\u{11af}"), ("\u{bddd}",
        "\u{bddd}", "\u{1107}\u{1171}\u{11b0}", "\u{bddd}", "\u{1107}\u{1171}\u{11b0}"),
        ("\u{bdde}", "\u{bdde}", "\u{1107}\u{1171}\u{11b1}", "\u{bdde}",
        "\u{1107}\u{1171}\u{11b1}"), ("\u{bddf}", "\u{bddf}", "\u{1107}\u{1171}\u{11b2}",
        "\u{bddf}", "\u{1107}\u{1171}\u{11b2}"), ("\u{bde0}", "\u{bde0}",
        "\u{1107}\u{1171}\u{11b3}", "\u{bde0}", "\u{1107}\u{1171}\u{11b3}"), ("\u{bde1}",
        "\u{bde1}", "\u{1107}\u{1171}\u{11b4}", "\u{bde1}", "\u{1107}\u{1171}\u{11b4}"),
        ("\u{bde2}", "\u{bde2}", "\u{1107}\u{1171}\u{11b5}", "\u{bde2}",
        "\u{1107}\u{1171}\u{11b5}"), ("\u{bde3}", "\u{bde3}", "\u{1107}\u{1171}\u{11b6}",
        "\u{bde3}", "\u{1107}\u{1171}\u{11b6}"), ("\u{bde4}", "\u{bde4}",
        "\u{1107}\u{1171}\u{11b7}", "\u{bde4}", "\u{1107}\u{1171}\u{11b7}"), ("\u{bde5}",
        "\u{bde5}", "\u{1107}\u{1171}\u{11b8}", "\u{bde5}", "\u{1107}\u{1171}\u{11b8}"),
        ("\u{bde6}", "\u{bde6}", "\u{1107}\u{1171}\u{11b9}", "\u{bde6}",
        "\u{1107}\u{1171}\u{11b9}"), ("\u{bde7}", "\u{bde7}", "\u{1107}\u{1171}\u{11ba}",
        "\u{bde7}", "\u{1107}\u{1171}\u{11ba}"), ("\u{bde8}", "\u{bde8}",
        "\u{1107}\u{1171}\u{11bb}", "\u{bde8}", "\u{1107}\u{1171}\u{11bb}"), ("\u{bde9}",
        "\u{bde9}", "\u{1107}\u{1171}\u{11bc}", "\u{bde9}", "\u{1107}\u{1171}\u{11bc}"),
        ("\u{bdea}", "\u{bdea}", "\u{1107}\u{1171}\u{11bd}", "\u{bdea}",
        "\u{1107}\u{1171}\u{11bd}"), ("\u{bdeb}", "\u{bdeb}", "\u{1107}\u{1171}\u{11be}",
        "\u{bdeb}", "\u{1107}\u{1171}\u{11be}"), ("\u{bdec}", "\u{bdec}",
        "\u{1107}\u{1171}\u{11bf}", "\u{bdec}", "\u{1107}\u{1171}\u{11bf}"), ("\u{bded}",
        "\u{bded}", "\u{1107}\u{1171}\u{11c0}", "\u{bded}", "\u{1107}\u{1171}\u{11c0}"),
        ("\u{bdee}", "\u{bdee}", "\u{1107}\u{1171}\u{11c1}", "\u{bdee}",
        "\u{1107}\u{1171}\u{11c1}"), ("\u{bdef}", "\u{bdef}", "\u{1107}\u{1171}\u{11c2}",
        "\u{bdef}", "\u{1107}\u{1171}\u{11c2}"), ("\u{bdf0}", "\u{bdf0}", "\u{1107}\u{1172}",
        "\u{bdf0}", "\u{1107}\u{1172}"), ("\u{bdf1}", "\u{bdf1}", "\u{1107}\u{1172}\u{11a8}",
        "\u{bdf1}", "\u{1107}\u{1172}\u{11a8}"), ("\u{bdf2}", "\u{bdf2}",
        "\u{1107}\u{1172}\u{11a9}", "\u{bdf2}", "\u{1107}\u{1172}\u{11a9}"), ("\u{bdf3}",
        "\u{bdf3}", "\u{1107}\u{1172}\u{11aa}", "\u{bdf3}", "\u{1107}\u{1172}\u{11aa}"),
        ("\u{bdf4}", "\u{bdf4}", "\u{1107}\u{1172}\u{11ab}", "\u{bdf4}",
        "\u{1107}\u{1172}\u{11ab}"), ("\u{bdf5}", "\u{bdf5}", "\u{1107}\u{1172}\u{11ac}",
        "\u{bdf5}", "\u{1107}\u{1172}\u{11ac}"), ("\u{bdf6}", "\u{bdf6}",
        "\u{1107}\u{1172}\u{11ad}", "\u{bdf6}", "\u{1107}\u{1172}\u{11ad}"), ("\u{bdf7}",
        "\u{bdf7}", "\u{1107}\u{1172}\u{11ae}", "\u{bdf7}", "\u{1107}\u{1172}\u{11ae}"),
        ("\u{bdf8}", "\u{bdf8}", "\u{1107}\u{1172}\u{11af}", "\u{bdf8}",
        "\u{1107}\u{1172}\u{11af}"), ("\u{bdf9}", "\u{bdf9}", "\u{1107}\u{1172}\u{11b0}",
        "\u{bdf9}", "\u{1107}\u{1172}\u{11b0}"), ("\u{bdfa}", "\u{bdfa}",
        "\u{1107}\u{1172}\u{11b1}", "\u{bdfa}", "\u{1107}\u{1172}\u{11b1}"), ("\u{bdfb}",
        "\u{bdfb}", "\u{1107}\u{1172}\u{11b2}", "\u{bdfb}", "\u{1107}\u{1172}\u{11b2}"),
        ("\u{bdfc}", "\u{bdfc}", "\u{1107}\u{1172}\u{11b3}", "\u{bdfc}",
        "\u{1107}\u{1172}\u{11b3}"), ("\u{bdfd}", "\u{bdfd}", "\u{1107}\u{1172}\u{11b4}",
        "\u{bdfd}", "\u{1107}\u{1172}\u{11b4}"), ("\u{bdfe}", "\u{bdfe}",
        "\u{1107}\u{1172}\u{11b5}", "\u{bdfe}", "\u{1107}\u{1172}\u{11b5}"), ("\u{bdff}",
        "\u{bdff}", "\u{1107}\u{1172}\u{11b6}", "\u{bdff}", "\u{1107}\u{1172}\u{11b6}"),
        ("\u{be00}", "\u{be00}", "\u{1107}\u{1172}\u{11b7}", "\u{be00}",
        "\u{1107}\u{1172}\u{11b7}"), ("\u{be01}", "\u{be01}", "\u{1107}\u{1172}\u{11b8}",
        "\u{be01}", "\u{1107}\u{1172}\u{11b8}"), ("\u{be02}", "\u{be02}",
        "\u{1107}\u{1172}\u{11b9}", "\u{be02}", "\u{1107}\u{1172}\u{11b9}"), ("\u{be03}",
        "\u{be03}", "\u{1107}\u{1172}\u{11ba}", "\u{be03}", "\u{1107}\u{1172}\u{11ba}"),
        ("\u{be04}", "\u{be04}", "\u{1107}\u{1172}\u{11bb}", "\u{be04}",
        "\u{1107}\u{1172}\u{11bb}"), ("\u{be05}", "\u{be05}", "\u{1107}\u{1172}\u{11bc}",
        "\u{be05}", "\u{1107}\u{1172}\u{11bc}"), ("\u{be06}", "\u{be06}",
        "\u{1107}\u{1172}\u{11bd}", "\u{be06}", "\u{1107}\u{1172}\u{11bd}"), ("\u{be07}",
        "\u{be07}", "\u{1107}\u{1172}\u{11be}", "\u{be07}", "\u{1107}\u{1172}\u{11be}"),
        ("\u{be08}", "\u{be08}", "\u{1107}\u{1172}\u{11bf}", "\u{be08}",
        "\u{1107}\u{1172}\u{11bf}"), ("\u{be09}", "\u{be09}", "\u{1107}\u{1172}\u{11c0}",
        "\u{be09}", "\u{1107}\u{1172}\u{11c0}"), ("\u{be0a}", "\u{be0a}",
        "\u{1107}\u{1172}\u{11c1}", "\u{be0a}", "\u{1107}\u{1172}\u{11c1}"), ("\u{be0b}",
        "\u{be0b}", "\u{1107}\u{1172}\u{11c2}", "\u{be0b}", "\u{1107}\u{1172}\u{11c2}"),
        ("\u{be0c}", "\u{be0c}", "\u{1107}\u{1173}", "\u{be0c}", "\u{1107}\u{1173}"), ("\u{be0d}",
        "\u{be0d}", "\u{1107}\u{1173}\u{11a8}", "\u{be0d}", "\u{1107}\u{1173}\u{11a8}"),
        ("\u{be0e}", "\u{be0e}", "\u{1107}\u{1173}\u{11a9}", "\u{be0e}",
        "\u{1107}\u{1173}\u{11a9}"), ("\u{be0f}", "\u{be0f}", "\u{1107}\u{1173}\u{11aa}",
        "\u{be0f}", "\u{1107}\u{1173}\u{11aa}"), ("\u{be10}", "\u{be10}",
        "\u{1107}\u{1173}\u{11ab}", "\u{be10}", "\u{1107}\u{1173}\u{11ab}"), ("\u{be11}",
        "\u{be11}", "\u{1107}\u{1173}\u{11ac}", "\u{be11}", "\u{1107}\u{1173}\u{11ac}"),
        ("\u{be12}", "\u{be12}", "\u{1107}\u{1173}\u{11ad}", "\u{be12}",
        "\u{1107}\u{1173}\u{11ad}"), ("\u{be13}", "\u{be13}", "\u{1107}\u{1173}\u{11ae}",
        "\u{be13}", "\u{1107}\u{1173}\u{11ae}"), ("\u{be14}", "\u{be14}",
        "\u{1107}\u{1173}\u{11af}", "\u{be14}", "\u{1107}\u{1173}\u{11af}"), ("\u{be15}",
        "\u{be15}", "\u{1107}\u{1173}\u{11b0}", "\u{be15}", "\u{1107}\u{1173}\u{11b0}"),
        ("\u{be16}", "\u{be16}", "\u{1107}\u{1173}\u{11b1}", "\u{be16}",
        "\u{1107}\u{1173}\u{11b1}"), ("\u{be17}", "\u{be17}", "\u{1107}\u{1173}\u{11b2}",
        "\u{be17}", "\u{1107}\u{1173}\u{11b2}"), ("\u{be18}", "\u{be18}",
        "\u{1107}\u{1173}\u{11b3}", "\u{be18}", "\u{1107}\u{1173}\u{11b3}"), ("\u{be19}",
        "\u{be19}", "\u{1107}\u{1173}\u{11b4}", "\u{be19}", "\u{1107}\u{1173}\u{11b4}"),
        ("\u{be1a}", "\u{be1a}", "\u{1107}\u{1173}\u{11b5}", "\u{be1a}",
        "\u{1107}\u{1173}\u{11b5}"), ("\u{be1b}", "\u{be1b}", "\u{1107}\u{1173}\u{11b6}",
        "\u{be1b}", "\u{1107}\u{1173}\u{11b6}"), ("\u{be1c}", "\u{be1c}",
        "\u{1107}\u{1173}\u{11b7}", "\u{be1c}", "\u{1107}\u{1173}\u{11b7}"), ("\u{be1d}",
        "\u{be1d}", "\u{1107}\u{1173}\u{11b8}", "\u{be1d}", "\u{1107}\u{1173}\u{11b8}"),
        ("\u{be1e}", "\u{be1e}", "\u{1107}\u{1173}\u{11b9}", "\u{be1e}",
        "\u{1107}\u{1173}\u{11b9}"), ("\u{be1f}", "\u{be1f}", "\u{1107}\u{1173}\u{11ba}",
        "\u{be1f}", "\u{1107}\u{1173}\u{11ba}"), ("\u{be20}", "\u{be20}",
        "\u{1107}\u{1173}\u{11bb}", "\u{be20}", "\u{1107}\u{1173}\u{11bb}"), ("\u{be21}",
        "\u{be21}", "\u{1107}\u{1173}\u{11bc}", "\u{be21}", "\u{1107}\u{1173}\u{11bc}"),
        ("\u{be22}", "\u{be22}", "\u{1107}\u{1173}\u{11bd}", "\u{be22}",
        "\u{1107}\u{1173}\u{11bd}"), ("\u{be23}", "\u{be23}", "\u{1107}\u{1173}\u{11be}",
        "\u{be23}", "\u{1107}\u{1173}\u{11be}"), ("\u{be24}", "\u{be24}",
        "\u{1107}\u{1173}\u{11bf}", "\u{be24}", "\u{1107}\u{1173}\u{11bf}"), ("\u{be25}",
        "\u{be25}", "\u{1107}\u{1173}\u{11c0}", "\u{be25}", "\u{1107}\u{1173}\u{11c0}"),
        ("\u{be26}", "\u{be26}", "\u{1107}\u{1173}\u{11c1}", "\u{be26}",
        "\u{1107}\u{1173}\u{11c1}"), ("\u{be27}", "\u{be27}", "\u{1107}\u{1173}\u{11c2}",
        "\u{be27}", "\u{1107}\u{1173}\u{11c2}"), ("\u{be28}", "\u{be28}", "\u{1107}\u{1174}",
        "\u{be28}", "\u{1107}\u{1174}"), ("\u{be29}", "\u{be29}", "\u{1107}\u{1174}\u{11a8}",
        "\u{be29}", "\u{1107}\u{1174}\u{11a8}"), ("\u{be2a}", "\u{be2a}",
        "\u{1107}\u{1174}\u{11a9}", "\u{be2a}", "\u{1107}\u{1174}\u{11a9}"), ("\u{be2b}",
        "\u{be2b}", "\u{1107}\u{1174}\u{11aa}", "\u{be2b}", "\u{1107}\u{1174}\u{11aa}"),
        ("\u{be2c}", "\u{be2c}", "\u{1107}\u{1174}\u{11ab}", "\u{be2c}",
        "\u{1107}\u{1174}\u{11ab}"), ("\u{be2d}", "\u{be2d}", "\u{1107}\u{1174}\u{11ac}",
        "\u{be2d}", "\u{1107}\u{1174}\u{11ac}"), ("\u{be2e}", "\u{be2e}",
        "\u{1107}\u{1174}\u{11ad}", "\u{be2e}", "\u{1107}\u{1174}\u{11ad}"), ("\u{be2f}",
        "\u{be2f}", "\u{1107}\u{1174}\u{11ae}", "\u{be2f}", "\u{1107}\u{1174}\u{11ae}"),
        ("\u{be30}", "\u{be30}", "\u{1107}\u{1174}\u{11af}", "\u{be30}",
        "\u{1107}\u{1174}\u{11af}"), ("\u{be31}", "\u{be31}", "\u{1107}\u{1174}\u{11b0}",
        "\u{be31}", "\u{1107}\u{1174}\u{11b0}"), ("\u{be32}", "\u{be32}",
        "\u{1107}\u{1174}\u{11b1}", "\u{be32}", "\u{1107}\u{1174}\u{11b1}"), ("\u{be33}",
        "\u{be33}", "\u{1107}\u{1174}\u{11b2}", "\u{be33}", "\u{1107}\u{1174}\u{11b2}"),
        ("\u{be34}", "\u{be34}", "\u{1107}\u{1174}\u{11b3}", "\u{be34}",
        "\u{1107}\u{1174}\u{11b3}"), ("\u{be35}", "\u{be35}", "\u{1107}\u{1174}\u{11b4}",
        "\u{be35}", "\u{1107}\u{1174}\u{11b4}"), ("\u{be36}", "\u{be36}",
        "\u{1107}\u{1174}\u{11b5}", "\u{be36}", "\u{1107}\u{1174}\u{11b5}"), ("\u{be37}",
        "\u{be37}", "\u{1107}\u{1174}\u{11b6}", "\u{be37}", "\u{1107}\u{1174}\u{11b6}"),
        ("\u{be38}", "\u{be38}", "\u{1107}\u{1174}\u{11b7}", "\u{be38}",
        "\u{1107}\u{1174}\u{11b7}"), ("\u{be39}", "\u{be39}", "\u{1107}\u{1174}\u{11b8}",
        "\u{be39}", "\u{1107}\u{1174}\u{11b8}"), ("\u{be3a}", "\u{be3a}",
        "\u{1107}\u{1174}\u{11b9}", "\u{be3a}", "\u{1107}\u{1174}\u{11b9}"), ("\u{be3b}",
        "\u{be3b}", "\u{1107}\u{1174}\u{11ba}", "\u{be3b}", "\u{1107}\u{1174}\u{11ba}"),
        ("\u{be3c}", "\u{be3c}", "\u{1107}\u{1174}\u{11bb}", "\u{be3c}",
        "\u{1107}\u{1174}\u{11bb}"), ("\u{be3d}", "\u{be3d}", "\u{1107}\u{1174}\u{11bc}",
        "\u{be3d}", "\u{1107}\u{1174}\u{11bc}"), ("\u{be3e}", "\u{be3e}",
        "\u{1107}\u{1174}\u{11bd}", "\u{be3e}", "\u{1107}\u{1174}\u{11bd}"), ("\u{be3f}",
        "\u{be3f}", "\u{1107}\u{1174}\u{11be}", "\u{be3f}", "\u{1107}\u{1174}\u{11be}"),
        ("\u{be40}", "\u{be40}", "\u{1107}\u{1174}\u{11bf}", "\u{be40}",
        "\u{1107}\u{1174}\u{11bf}"), ("\u{be41}", "\u{be41}", "\u{1107}\u{1174}\u{11c0}",
        "\u{be41}", "\u{1107}\u{1174}\u{11c0}"), ("\u{be42}", "\u{be42}",
        "\u{1107}\u{1174}\u{11c1}", "\u{be42}", "\u{1107}\u{1174}\u{11c1}"), ("\u{be43}",
        "\u{be43}", "\u{1107}\u{1174}\u{11c2}", "\u{be43}", "\u{1107}\u{1174}\u{11c2}"),
        ("\u{be44}", "\u{be44}", "\u{1107}\u{1175}", "\u{be44}", "\u{1107}\u{1175}"), ("\u{be45}",
        "\u{be45}", "\u{1107}\u{1175}\u{11a8}", "\u{be45}", "\u{1107}\u{1175}\u{11a8}"),
        ("\u{be46}", "\u{be46}", "\u{1107}\u{1175}\u{11a9}", "\u{be46}",
        "\u{1107}\u{1175}\u{11a9}"), ("\u{be47}", "\u{be47}", "\u{1107}\u{1175}\u{11aa}",
        "\u{be47}", "\u{1107}\u{1175}\u{11aa}"), ("\u{be48}", "\u{be48}",
        "\u{1107}\u{1175}\u{11ab}", "\u{be48}", "\u{1107}\u{1175}\u{11ab}"), ("\u{be49}",
        "\u{be49}", "\u{1107}\u{1175}\u{11ac}", "\u{be49}", "\u{1107}\u{1175}\u{11ac}"),
        ("\u{be4a}", "\u{be4a}", "\u{1107}\u{1175}\u{11ad}", "\u{be4a}",
        "\u{1107}\u{1175}\u{11ad}"), ("\u{be4b}", "\u{be4b}", "\u{1107}\u{1175}\u{11ae}",
        "\u{be4b}", "\u{1107}\u{1175}\u{11ae}"), ("\u{be4c}", "\u{be4c}",
        "\u{1107}\u{1175}\u{11af}", "\u{be4c}", "\u{1107}\u{1175}\u{11af}"), ("\u{be4d}",
        "\u{be4d}", "\u{1107}\u{1175}\u{11b0}", "\u{be4d}", "\u{1107}\u{1175}\u{11b0}"),
        ("\u{be4e}", "\u{be4e}", "\u{1107}\u{1175}\u{11b1}", "\u{be4e}",
        "\u{1107}\u{1175}\u{11b1}"), ("\u{be4f}", "\u{be4f}", "\u{1107}\u{1175}\u{11b2}",
        "\u{be4f}", "\u{1107}\u{1175}\u{11b2}"), ("\u{be50}", "\u{be50}",
        "\u{1107}\u{1175}\u{11b3}", "\u{be50}", "\u{1107}\u{1175}\u{11b3}"), ("\u{be51}",
        "\u{be51}", "\u{1107}\u{1175}\u{11b4}", "\u{be51}", "\u{1107}\u{1175}\u{11b4}"),
        ("\u{be52}", "\u{be52}", "\u{1107}\u{1175}\u{11b5}", "\u{be52}",
        "\u{1107}\u{1175}\u{11b5}"), ("\u{be53}", "\u{be53}", "\u{1107}\u{1175}\u{11b6}",
        "\u{be53}", "\u{1107}\u{1175}\u{11b6}"), ("\u{be54}", "\u{be54}",
        "\u{1107}\u{1175}\u{11b7}", "\u{be54}", "\u{1107}\u{1175}\u{11b7}"), ("\u{be55}",
        "\u{be55}", "\u{1107}\u{1175}\u{11b8}", "\u{be55}", "\u{1107}\u{1175}\u{11b8}"),
        ("\u{be56}", "\u{be56}", "\u{1107}\u{1175}\u{11b9}", "\u{be56}",
        "\u{1107}\u{1175}\u{11b9}"), ("\u{be57}", "\u{be57}", "\u{1107}\u{1175}\u{11ba}",
        "\u{be57}", "\u{1107}\u{1175}\u{11ba}"), ("\u{be58}", "\u{be58}",
        "\u{1107}\u{1175}\u{11bb}", "\u{be58}", "\u{1107}\u{1175}\u{11bb}"), ("\u{be59}",
        "\u{be59}", "\u{1107}\u{1175}\u{11bc}", "\u{be59}", "\u{1107}\u{1175}\u{11bc}"),
        ("\u{be5a}", "\u{be5a}", "\u{1107}\u{1175}\u{11bd}", "\u{be5a}",
        "\u{1107}\u{1175}\u{11bd}"), ("\u{be5b}", "\u{be5b}", "\u{1107}\u{1175}\u{11be}",
        "\u{be5b}", "\u{1107}\u{1175}\u{11be}"), ("\u{be5c}", "\u{be5c}",
        "\u{1107}\u{1175}\u{11bf}", "\u{be5c}", "\u{1107}\u{1175}\u{11bf}"), ("\u{be5d}",
        "\u{be5d}", "\u{1107}\u{1175}\u{11c0}", "\u{be5d}", "\u{1107}\u{1175}\u{11c0}"),
        ("\u{be5e}", "\u{be5e}", "\u{1107}\u{1175}\u{11c1}", "\u{be5e}",
        "\u{1107}\u{1175}\u{11c1}"), ("\u{be5f}", "\u{be5f}", "\u{1107}\u{1175}\u{11c2}",
        "\u{be5f}", "\u{1107}\u{1175}\u{11c2}"), ("\u{be60}", "\u{be60}", "\u{1108}\u{1161}",
        "\u{be60}", "\u{1108}\u{1161}"), ("\u{be61}", "\u{be61}", "\u{1108}\u{1161}\u{11a8}",
        "\u{be61}", "\u{1108}\u{1161}\u{11a8}"), ("\u{be62}", "\u{be62}",
        "\u{1108}\u{1161}\u{11a9}", "\u{be62}", "\u{1108}\u{1161}\u{11a9}"), ("\u{be63}",
        "\u{be63}", "\u{1108}\u{1161}\u{11aa}", "\u{be63}", "\u{1108}\u{1161}\u{11aa}"),
        ("\u{be64}", "\u{be64}", "\u{1108}\u{1161}\u{11ab}", "\u{be64}",
        "\u{1108}\u{1161}\u{11ab}"), ("\u{be65}", "\u{be65}", "\u{1108}\u{1161}\u{11ac}",
        "\u{be65}", "\u{1108}\u{1161}\u{11ac}"), ("\u{be66}", "\u{be66}",
        "\u{1108}\u{1161}\u{11ad}", "\u{be66}", "\u{1108}\u{1161}\u{11ad}"), ("\u{be67}",
        "\u{be67}", "\u{1108}\u{1161}\u{11ae}", "\u{be67}", "\u{1108}\u{1161}\u{11ae}"),
        ("\u{be68}", "\u{be68}", "\u{1108}\u{1161}\u{11af}", "\u{be68}",
        "\u{1108}\u{1161}\u{11af}"), ("\u{be69}", "\u{be69}", "\u{1108}\u{1161}\u{11b0}",
        "\u{be69}", "\u{1108}\u{1161}\u{11b0}"), ("\u{be6a}", "\u{be6a}",
        "\u{1108}\u{1161}\u{11b1}", "\u{be6a}", "\u{1108}\u{1161}\u{11b1}"), ("\u{be6b}",
        "\u{be6b}", "\u{1108}\u{1161}\u{11b2}", "\u{be6b}", "\u{1108}\u{1161}\u{11b2}"),
        ("\u{be6c}", "\u{be6c}", "\u{1108}\u{1161}\u{11b3}", "\u{be6c}",
        "\u{1108}\u{1161}\u{11b3}"), ("\u{be6d}", "\u{be6d}", "\u{1108}\u{1161}\u{11b4}",
        "\u{be6d}", "\u{1108}\u{1161}\u{11b4}"), ("\u{be6e}", "\u{be6e}",
        "\u{1108}\u{1161}\u{11b5}", "\u{be6e}", "\u{1108}\u{1161}\u{11b5}"), ("\u{be6f}",
        "\u{be6f}", "\u{1108}\u{1161}\u{11b6}", "\u{be6f}", "\u{1108}\u{1161}\u{11b6}"),
        ("\u{be70}", "\u{be70}", "\u{1108}\u{1161}\u{11b7}", "\u{be70}",
        "\u{1108}\u{1161}\u{11b7}"), ("\u{be71}", "\u{be71}", "\u{1108}\u{1161}\u{11b8}",
        "\u{be71}", "\u{1108}\u{1161}\u{11b8}"), ("\u{be72}", "\u{be72}",
        "\u{1108}\u{1161}\u{11b9}", "\u{be72}", "\u{1108}\u{1161}\u{11b9}"), ("\u{be73}",
        "\u{be73}", "\u{1108}\u{1161}\u{11ba}", "\u{be73}", "\u{1108}\u{1161}\u{11ba}"),
        ("\u{be74}", "\u{be74}", "\u{1108}\u{1161}\u{11bb}", "\u{be74}",
        "\u{1108}\u{1161}\u{11bb}"), ("\u{be75}", "\u{be75}", "\u{1108}\u{1161}\u{11bc}",
        "\u{be75}", "\u{1108}\u{1161}\u{11bc}"), ("\u{be76}", "\u{be76}",
        "\u{1108}\u{1161}\u{11bd}", "\u{be76}", "\u{1108}\u{1161}\u{11bd}"), ("\u{be77}",
        "\u{be77}", "\u{1108}\u{1161}\u{11be}", "\u{be77}", "\u{1108}\u{1161}\u{11be}"),
        ("\u{be78}", "\u{be78}", "\u{1108}\u{1161}\u{11bf}", "\u{be78}",
        "\u{1108}\u{1161}\u{11bf}"), ("\u{be79}", "\u{be79}", "\u{1108}\u{1161}\u{11c0}",
        "\u{be79}", "\u{1108}\u{1161}\u{11c0}"), ("\u{be7a}", "\u{be7a}",
        "\u{1108}\u{1161}\u{11c1}", "\u{be7a}", "\u{1108}\u{1161}\u{11c1}"), ("\u{be7b}",
        "\u{be7b}", "\u{1108}\u{1161}\u{11c2}", "\u{be7b}", "\u{1108}\u{1161}\u{11c2}"),
        ("\u{be7c}", "\u{be7c}", "\u{1108}\u{1162}", "\u{be7c}", "\u{1108}\u{1162}"), ("\u{be7d}",
        "\u{be7d}", "\u{1108}\u{1162}\u{11a8}", "\u{be7d}", "\u{1108}\u{1162}\u{11a8}"),
        ("\u{be7e}", "\u{be7e}", "\u{1108}\u{1162}\u{11a9}", "\u{be7e}",
        "\u{1108}\u{1162}\u{11a9}"), ("\u{be7f}", "\u{be7f}", "\u{1108}\u{1162}\u{11aa}",
        "\u{be7f}", "\u{1108}\u{1162}\u{11aa}"), ("\u{be80}", "\u{be80}",
        "\u{1108}\u{1162}\u{11ab}", "\u{be80}", "\u{1108}\u{1162}\u{11ab}"), ("\u{be81}",
        "\u{be81}", "\u{1108}\u{1162}\u{11ac}", "\u{be81}", "\u{1108}\u{1162}\u{11ac}"),
        ("\u{be82}", "\u{be82}", "\u{1108}\u{1162}\u{11ad}", "\u{be82}",
        "\u{1108}\u{1162}\u{11ad}"), ("\u{be83}", "\u{be83}", "\u{1108}\u{1162}\u{11ae}",
        "\u{be83}", "\u{1108}\u{1162}\u{11ae}"), ("\u{be84}", "\u{be84}",
        "\u{1108}\u{1162}\u{11af}", "\u{be84}", "\u{1108}\u{1162}\u{11af}"), ("\u{be85}",
        "\u{be85}", "\u{1108}\u{1162}\u{11b0}", "\u{be85}", "\u{1108}\u{1162}\u{11b0}"),
        ("\u{be86}", "\u{be86}", "\u{1108}\u{1162}\u{11b1}", "\u{be86}",
        "\u{1108}\u{1162}\u{11b1}"), ("\u{be87}", "\u{be87}", "\u{1108}\u{1162}\u{11b2}",
        "\u{be87}", "\u{1108}\u{1162}\u{11b2}"), ("\u{be88}", "\u{be88}",
        "\u{1108}\u{1162}\u{11b3}", "\u{be88}", "\u{1108}\u{1162}\u{11b3}"), ("\u{be89}",
        "\u{be89}", "\u{1108}\u{1162}\u{11b4}", "\u{be89}", "\u{1108}\u{1162}\u{11b4}"),
        ("\u{be8a}", "\u{be8a}", "\u{1108}\u{1162}\u{11b5}", "\u{be8a}",
        "\u{1108}\u{1162}\u{11b5}"), ("\u{be8b}", "\u{be8b}", "\u{1108}\u{1162}\u{11b6}",
        "\u{be8b}", "\u{1108}\u{1162}\u{11b6}"), ("\u{be8c}", "\u{be8c}",
        "\u{1108}\u{1162}\u{11b7}", "\u{be8c}", "\u{1108}\u{1162}\u{11b7}"), ("\u{be8d}",
        "\u{be8d}", "\u{1108}\u{1162}\u{11b8}", "\u{be8d}", "\u{1108}\u{1162}\u{11b8}"),
        ("\u{be8e}", "\u{be8e}", "\u{1108}\u{1162}\u{11b9}", "\u{be8e}",
        "\u{1108}\u{1162}\u{11b9}"), ("\u{be8f}", "\u{be8f}", "\u{1108}\u{1162}\u{11ba}",
        "\u{be8f}", "\u{1108}\u{1162}\u{11ba}"), ("\u{be90}", "\u{be90}",
        "\u{1108}\u{1162}\u{11bb}", "\u{be90}", "\u{1108}\u{1162}\u{11bb}"), ("\u{be91}",
        "\u{be91}", "\u{1108}\u{1162}\u{11bc}", "\u{be91}", "\u{1108}\u{1162}\u{11bc}"),
        ("\u{be92}", "\u{be92}", "\u{1108}\u{1162}\u{11bd}", "\u{be92}",
        "\u{1108}\u{1162}\u{11bd}"), ("\u{be93}", "\u{be93}", "\u{1108}\u{1162}\u{11be}",
        "\u{be93}", "\u{1108}\u{1162}\u{11be}"), ("\u{be94}", "\u{be94}",
        "\u{1108}\u{1162}\u{11bf}", "\u{be94}", "\u{1108}\u{1162}\u{11bf}"), ("\u{be95}",
        "\u{be95}", "\u{1108}\u{1162}\u{11c0}", "\u{be95}", "\u{1108}\u{1162}\u{11c0}"),
        ("\u{be96}", "\u{be96}", "\u{1108}\u{1162}\u{11c1}", "\u{be96}",
        "\u{1108}\u{1162}\u{11c1}"), ("\u{be97}", "\u{be97}", "\u{1108}\u{1162}\u{11c2}",
        "\u{be97}", "\u{1108}\u{1162}\u{11c2}"), ("\u{be98}", "\u{be98}", "\u{1108}\u{1163}",
        "\u{be98}", "\u{1108}\u{1163}"), ("\u{be99}", "\u{be99}", "\u{1108}\u{1163}\u{11a8}",
        "\u{be99}", "\u{1108}\u{1163}\u{11a8}"), ("\u{be9a}", "\u{be9a}",
        "\u{1108}\u{1163}\u{11a9}", "\u{be9a}", "\u{1108}\u{1163}\u{11a9}"), ("\u{be9b}",
        "\u{be9b}", "\u{1108}\u{1163}\u{11aa}", "\u{be9b}", "\u{1108}\u{1163}\u{11aa}"),
        ("\u{be9c}", "\u{be9c}", "\u{1108}\u{1163}\u{11ab}", "\u{be9c}",
        "\u{1108}\u{1163}\u{11ab}"), ("\u{be9d}", "\u{be9d}", "\u{1108}\u{1163}\u{11ac}",
        "\u{be9d}", "\u{1108}\u{1163}\u{11ac}"), ("\u{be9e}", "\u{be9e}",
        "\u{1108}\u{1163}\u{11ad}", "\u{be9e}", "\u{1108}\u{1163}\u{11ad}"), ("\u{be9f}",
        "\u{be9f}", "\u{1108}\u{1163}\u{11ae}", "\u{be9f}", "\u{1108}\u{1163}\u{11ae}"),
        ("\u{bea0}", "\u{bea0}", "\u{1108}\u{1163}\u{11af}", "\u{bea0}",
        "\u{1108}\u{1163}\u{11af}"), ("\u{bea1}", "\u{bea1}", "\u{1108}\u{1163}\u{11b0}",
        "\u{bea1}", "\u{1108}\u{1163}\u{11b0}"), ("\u{bea2}", "\u{bea2}",
        "\u{1108}\u{1163}\u{11b1}", "\u{bea2}", "\u{1108}\u{1163}\u{11b1}"), ("\u{bea3}",
        "\u{bea3}", "\u{1108}\u{1163}\u{11b2}", "\u{bea3}", "\u{1108}\u{1163}\u{11b2}"),
        ("\u{bea4}", "\u{bea4}", "\u{1108}\u{1163}\u{11b3}", "\u{bea4}",
        "\u{1108}\u{1163}\u{11b3}"), ("\u{bea5}", "\u{bea5}", "\u{1108}\u{1163}\u{11b4}",
        "\u{bea5}", "\u{1108}\u{1163}\u{11b4}"), ("\u{bea6}", "\u{bea6}",
        "\u{1108}\u{1163}\u{11b5}", "\u{bea6}", "\u{1108}\u{1163}\u{11b5}"), ("\u{bea7}",
        "\u{bea7}", "\u{1108}\u{1163}\u{11b6}", "\u{bea7}", "\u{1108}\u{1163}\u{11b6}"),
        ("\u{bea8}", "\u{bea8}", "\u{1108}\u{1163}\u{11b7}", "\u{bea8}",
        "\u{1108}\u{1163}\u{11b7}"), ("\u{bea9}", "\u{bea9}", "\u{1108}\u{1163}\u{11b8}",
        "\u{bea9}", "\u{1108}\u{1163}\u{11b8}"), ("\u{beaa}", "\u{beaa}",
        "\u{1108}\u{1163}\u{11b9}", "\u{beaa}", "\u{1108}\u{1163}\u{11b9}"), ("\u{beab}",
        "\u{beab}", "\u{1108}\u{1163}\u{11ba}", "\u{beab}", "\u{1108}\u{1163}\u{11ba}"),
        ("\u{beac}", "\u{beac}", "\u{1108}\u{1163}\u{11bb}", "\u{beac}",
        "\u{1108}\u{1163}\u{11bb}"), ("\u{bead}", "\u{bead}", "\u{1108}\u{1163}\u{11bc}",
        "\u{bead}", "\u{1108}\u{1163}\u{11bc}"), ("\u{beae}", "\u{beae}",
        "\u{1108}\u{1163}\u{11bd}", "\u{beae}", "\u{1108}\u{1163}\u{11bd}"), ("\u{beaf}",
        "\u{beaf}", "\u{1108}\u{1163}\u{11be}", "\u{beaf}", "\u{1108}\u{1163}\u{11be}"),
        ("\u{beb0}", "\u{beb0}", "\u{1108}\u{1163}\u{11bf}", "\u{beb0}",
        "\u{1108}\u{1163}\u{11bf}"), ("\u{beb1}", "\u{beb1}", "\u{1108}\u{1163}\u{11c0}",
        "\u{beb1}", "\u{1108}\u{1163}\u{11c0}"), ("\u{beb2}", "\u{beb2}",
        "\u{1108}\u{1163}\u{11c1}", "\u{beb2}", "\u{1108}\u{1163}\u{11c1}"), ("\u{beb3}",
        "\u{beb3}", "\u{1108}\u{1163}\u{11c2}", "\u{beb3}", "\u{1108}\u{1163}\u{11c2}"),
        ("\u{beb4}", "\u{beb4}", "\u{1108}\u{1164}", "\u{beb4}", "\u{1108}\u{1164}"), ("\u{beb5}",
        "\u{beb5}", "\u{1108}\u{1164}\u{11a8}", "\u{beb5}", "\u{1108}\u{1164}\u{11a8}"),
        ("\u{beb6}", "\u{beb6}", "\u{1108}\u{1164}\u{11a9}", "\u{beb6}",
        "\u{1108}\u{1164}\u{11a9}"), ("\u{beb7}", "\u{beb7}", "\u{1108}\u{1164}\u{11aa}",
        "\u{beb7}", "\u{1108}\u{1164}\u{11aa}"), ("\u{beb8}", "\u{beb8}",
        "\u{1108}\u{1164}\u{11ab}", "\u{beb8}", "\u{1108}\u{1164}\u{11ab}"), ("\u{beb9}",
        "\u{beb9}", "\u{1108}\u{1164}\u{11ac}", "\u{beb9}", "\u{1108}\u{1164}\u{11ac}"),
        ("\u{beba}", "\u{beba}", "\u{1108}\u{1164}\u{11ad}", "\u{beba}",
        "\u{1108}\u{1164}\u{11ad}"), ("\u{bebb}", "\u{bebb}", "\u{1108}\u{1164}\u{11ae}",
        "\u{bebb}", "\u{1108}\u{1164}\u{11ae}"), ("\u{bebc}", "\u{bebc}",
        "\u{1108}\u{1164}\u{11af}", "\u{bebc}", "\u{1108}\u{1164}\u{11af}"), ("\u{bebd}",
        "\u{bebd}", "\u{1108}\u{1164}\u{11b0}", "\u{bebd}", "\u{1108}\u{1164}\u{11b0}"),
        ("\u{bebe}", "\u{bebe}", "\u{1108}\u{1164}\u{11b1}", "\u{bebe}",
        "\u{1108}\u{1164}\u{11b1}"), ("\u{bebf}", "\u{bebf}", "\u{1108}\u{1164}\u{11b2}",
        "\u{bebf}", "\u{1108}\u{1164}\u{11b2}"), ("\u{bec0}", "\u{bec0}",
        "\u{1108}\u{1164}\u{11b3}", "\u{bec0}", "\u{1108}\u{1164}\u{11b3}"), ("\u{bec1}",
        "\u{bec1}", "\u{1108}\u{1164}\u{11b4}", "\u{bec1}", "\u{1108}\u{1164}\u{11b4}"),
        ("\u{bec2}", "\u{bec2}", "\u{1108}\u{1164}\u{11b5}", "\u{bec2}",
        "\u{1108}\u{1164}\u{11b5}"), ("\u{bec3}", "\u{bec3}", "\u{1108}\u{1164}\u{11b6}",
        "\u{bec3}", "\u{1108}\u{1164}\u{11b6}"), ("\u{bec4}", "\u{bec4}",
        "\u{1108}\u{1164}\u{11b7}", "\u{bec4}", "\u{1108}\u{1164}\u{11b7}"), ("\u{bec5}",
        "\u{bec5}", "\u{1108}\u{1164}\u{11b8}", "\u{bec5}", "\u{1108}\u{1164}\u{11b8}"),
        ("\u{bec6}", "\u{bec6}", "\u{1108}\u{1164}\u{11b9}", "\u{bec6}",
        "\u{1108}\u{1164}\u{11b9}"), ("\u{bec7}", "\u{bec7}", "\u{1108}\u{1164}\u{11ba}",
        "\u{bec7}", "\u{1108}\u{1164}\u{11ba}"), ("\u{bec8}", "\u{bec8}",
        "\u{1108}\u{1164}\u{11bb}", "\u{bec8}", "\u{1108}\u{1164}\u{11bb}"), ("\u{bec9}",
        "\u{bec9}", "\u{1108}\u{1164}\u{11bc}", "\u{bec9}", "\u{1108}\u{1164}\u{11bc}"),
        ("\u{beca}", "\u{beca}", "\u{1108}\u{1164}\u{11bd}", "\u{beca}",
        "\u{1108}\u{1164}\u{11bd}"), ("\u{becb}", "\u{becb}", "\u{1108}\u{1164}\u{11be}",
        "\u{becb}", "\u{1108}\u{1164}\u{11be}"), ("\u{becc}", "\u{becc}",
        "\u{1108}\u{1164}\u{11bf}", "\u{becc}", "\u{1108}\u{1164}\u{11bf}"), ("\u{becd}",
        "\u{becd}", "\u{1108}\u{1164}\u{11c0}", "\u{becd}", "\u{1108}\u{1164}\u{11c0}"),
        ("\u{bece}", "\u{bece}", "\u{1108}\u{1164}\u{11c1}", "\u{bece}",
        "\u{1108}\u{1164}\u{11c1}"), ("\u{becf}", "\u{becf}", "\u{1108}\u{1164}\u{11c2}",
        "\u{becf}", "\u{1108}\u{1164}\u{11c2}"), ("\u{bed0}", "\u{bed0}", "\u{1108}\u{1165}",
        "\u{bed0}", "\u{1108}\u{1165}"), ("\u{bed1}", "\u{bed1}", "\u{1108}\u{1165}\u{11a8}",
        "\u{bed1}", "\u{1108}\u{1165}\u{11a8}"), ("\u{bed2}", "\u{bed2}",
        "\u{1108}\u{1165}\u{11a9}", "\u{bed2}", "\u{1108}\u{1165}\u{11a9}"), ("\u{bed3}",
        "\u{bed3}", "\u{1108}\u{1165}\u{11aa}", "\u{bed3}", "\u{1108}\u{1165}\u{11aa}"),
        ("\u{bed4}", "\u{bed4}", "\u{1108}\u{1165}\u{11ab}", "\u{bed4}",
        "\u{1108}\u{1165}\u{11ab}"), ("\u{bed5}", "\u{bed5}", "\u{1108}\u{1165}\u{11ac}",
        "\u{bed5}", "\u{1108}\u{1165}\u{11ac}"), ("\u{bed6}", "\u{bed6}",
        "\u{1108}\u{1165}\u{11ad}", "\u{bed6}", "\u{1108}\u{1165}\u{11ad}"), ("\u{bed7}",
        "\u{bed7}", "\u{1108}\u{1165}\u{11ae}", "\u{bed7}", "\u{1108}\u{1165}\u{11ae}"),
        ("\u{bed8}", "\u{bed8}", "\u{1108}\u{1165}\u{11af}", "\u{bed8}",
        "\u{1108}\u{1165}\u{11af}"), ("\u{bed9}", "\u{bed9}", "\u{1108}\u{1165}\u{11b0}",
        "\u{bed9}", "\u{1108}\u{1165}\u{11b0}"), ("\u{beda}", "\u{beda}",
        "\u{1108}\u{1165}\u{11b1}", "\u{beda}", "\u{1108}\u{1165}\u{11b1}"), ("\u{bedb}",
        "\u{bedb}", "\u{1108}\u{1165}\u{11b2}", "\u{bedb}", "\u{1108}\u{1165}\u{11b2}"),
        ("\u{bedc}", "\u{bedc}", "\u{1108}\u{1165}\u{11b3}", "\u{bedc}",
        "\u{1108}\u{1165}\u{11b3}"), ("\u{bedd}", "\u{bedd}", "\u{1108}\u{1165}\u{11b4}",
        "\u{bedd}", "\u{1108}\u{1165}\u{11b4}"), ("\u{bede}", "\u{bede}",
        "\u{1108}\u{1165}\u{11b5}", "\u{bede}", "\u{1108}\u{1165}\u{11b5}"), ("\u{bedf}",
        "\u{bedf}", "\u{1108}\u{1165}\u{11b6}", "\u{bedf}", "\u{1108}\u{1165}\u{11b6}"),
        ("\u{bee0}", "\u{bee0}", "\u{1108}\u{1165}\u{11b7}", "\u{bee0}",
        "\u{1108}\u{1165}\u{11b7}"), ("\u{bee1}", "\u{bee1}", "\u{1108}\u{1165}\u{11b8}",
        "\u{bee1}", "\u{1108}\u{1165}\u{11b8}"), ("\u{bee2}", "\u{bee2}",
        "\u{1108}\u{1165}\u{11b9}", "\u{bee2}", "\u{1108}\u{1165}\u{11b9}"), ("\u{bee3}",
        "\u{bee3}", "\u{1108}\u{1165}\u{11ba}", "\u{bee3}", "\u{1108}\u{1165}\u{11ba}"),
        ("\u{bee4}", "\u{bee4}", "\u{1108}\u{1165}\u{11bb}", "\u{bee4}",
        "\u{1108}\u{1165}\u{11bb}"), ("\u{bee5}", "\u{bee5}", "\u{1108}\u{1165}\u{11bc}",
        "\u{bee5}", "\u{1108}\u{1165}\u{11bc}"), ("\u{bee6}", "\u{bee6}",
        "\u{1108}\u{1165}\u{11bd}", "\u{bee6}", "\u{1108}\u{1165}\u{11bd}"), ("\u{bee7}",
        "\u{bee7}", "\u{1108}\u{1165}\u{11be}", "\u{bee7}", "\u{1108}\u{1165}\u{11be}"),
        ("\u{bee8}", "\u{bee8}", "\u{1108}\u{1165}\u{11bf}", "\u{bee8}",
        "\u{1108}\u{1165}\u{11bf}"), ("\u{bee9}", "\u{bee9}", "\u{1108}\u{1165}\u{11c0}",
        "\u{bee9}", "\u{1108}\u{1165}\u{11c0}"), ("\u{beea}", "\u{beea}",
        "\u{1108}\u{1165}\u{11c1}", "\u{beea}", "\u{1108}\u{1165}\u{11c1}"), ("\u{beeb}",
        "\u{beeb}", "\u{1108}\u{1165}\u{11c2}", "\u{beeb}", "\u{1108}\u{1165}\u{11c2}"),
        ("\u{beec}", "\u{beec}", "\u{1108}\u{1166}", "\u{beec}", "\u{1108}\u{1166}"), ("\u{beed}",
        "\u{beed}", "\u{1108}\u{1166}\u{11a8}", "\u{beed}", "\u{1108}\u{1166}\u{11a8}"),
        ("\u{beee}", "\u{beee}", "\u{1108}\u{1166}\u{11a9}", "\u{beee}",
        "\u{1108}\u{1166}\u{11a9}"), ("\u{beef}", "\u{beef}", "\u{1108}\u{1166}\u{11aa}",
        "\u{beef}", "\u{1108}\u{1166}\u{11aa}"), ("\u{bef0}", "\u{bef0}",
        "\u{1108}\u{1166}\u{11ab}", "\u{bef0}", "\u{1108}\u{1166}\u{11ab}"), ("\u{bef1}",
        "\u{bef1}", "\u{1108}\u{1166}\u{11ac}", "\u{bef1}", "\u{1108}\u{1166}\u{11ac}"),
        ("\u{bef2}", "\u{bef2}", "\u{1108}\u{1166}\u{11ad}", "\u{bef2}",
        "\u{1108}\u{1166}\u{11ad}"), ("\u{bef3}", "\u{bef3}", "\u{1108}\u{1166}\u{11ae}",
        "\u{bef3}", "\u{1108}\u{1166}\u{11ae}"), ("\u{bef4}", "\u{bef4}",
        "\u{1108}\u{1166}\u{11af}", "\u{bef4}", "\u{1108}\u{1166}\u{11af}"), ("\u{bef5}",
        "\u{bef5}", "\u{1108}\u{1166}\u{11b0}", "\u{bef5}", "\u{1108}\u{1166}\u{11b0}"),
        ("\u{bef6}", "\u{bef6}", "\u{1108}\u{1166}\u{11b1}", "\u{bef6}",
        "\u{1108}\u{1166}\u{11b1}"), ("\u{bef7}", "\u{bef7}", "\u{1108}\u{1166}\u{11b2}",
        "\u{bef7}", "\u{1108}\u{1166}\u{11b2}"), ("\u{bef8}", "\u{bef8}",
        "\u{1108}\u{1166}\u{11b3}", "\u{bef8}", "\u{1108}\u{1166}\u{11b3}"), ("\u{bef9}",
        "\u{bef9}", "\u{1108}\u{1166}\u{11b4}", "\u{bef9}", "\u{1108}\u{1166}\u{11b4}"),
        ("\u{befa}", "\u{befa}", "\u{1108}\u{1166}\u{11b5}", "\u{befa}",
        "\u{1108}\u{1166}\u{11b5}"), ("\u{befb}", "\u{befb}", "\u{1108}\u{1166}\u{11b6}",
        "\u{befb}", "\u{1108}\u{1166}\u{11b6}"), ("\u{befc}", "\u{befc}",
        "\u{1108}\u{1166}\u{11b7}", "\u{befc}", "\u{1108}\u{1166}\u{11b7}"), ("\u{befd}",
        "\u{befd}", "\u{1108}\u{1166}\u{11b8}", "\u{befd}", "\u{1108}\u{1166}\u{11b8}"),
        ("\u{befe}", "\u{befe}", "\u{1108}\u{1166}\u{11b9}", "\u{befe}",
        "\u{1108}\u{1166}\u{11b9}"), ("\u{beff}", "\u{beff}", "\u{1108}\u{1166}\u{11ba}",
        "\u{beff}", "\u{1108}\u{1166}\u{11ba}"), ("\u{bf00}", "\u{bf00}",
        "\u{1108}\u{1166}\u{11bb}", "\u{bf00}", "\u{1108}\u{1166}\u{11bb}"), ("\u{bf01}",
        "\u{bf01}", "\u{1108}\u{1166}\u{11bc}", "\u{bf01}", "\u{1108}\u{1166}\u{11bc}"),
        ("\u{bf02}", "\u{bf02}", "\u{1108}\u{1166}\u{11bd}", "\u{bf02}",
        "\u{1108}\u{1166}\u{11bd}"), ("\u{bf03}", "\u{bf03}", "\u{1108}\u{1166}\u{11be}",
        "\u{bf03}", "\u{1108}\u{1166}\u{11be}"), ("\u{bf04}", "\u{bf04}",
        "\u{1108}\u{1166}\u{11bf}", "\u{bf04}", "\u{1108}\u{1166}\u{11bf}"), ("\u{bf05}",
        "\u{bf05}", "\u{1108}\u{1166}\u{11c0}", "\u{bf05}", "\u{1108}\u{1166}\u{11c0}"),
        ("\u{bf06}", "\u{bf06}", "\u{1108}\u{1166}\u{11c1}", "\u{bf06}",
        "\u{1108}\u{1166}\u{11c1}"), ("\u{bf07}", "\u{bf07}", "\u{1108}\u{1166}\u{11c2}",
        "\u{bf07}", "\u{1108}\u{1166}\u{11c2}"), ("\u{bf08}", "\u{bf08}", "\u{1108}\u{1167}",
        "\u{bf08}", "\u{1108}\u{1167}"), ("\u{bf09}", "\u{bf09}", "\u{1108}\u{1167}\u{11a8}",
        "\u{bf09}", "\u{1108}\u{1167}\u{11a8}"), ("\u{bf0a}", "\u{bf0a}",
        "\u{1108}\u{1167}\u{11a9}", "\u{bf0a}", "\u{1108}\u{1167}\u{11a9}"), ("\u{bf0b}",
        "\u{bf0b}", "\u{1108}\u{1167}\u{11aa}", "\u{bf0b}", "\u{1108}\u{1167}\u{11aa}"),
        ("\u{bf0c}", "\u{bf0c}", "\u{1108}\u{1167}\u{11ab}", "\u{bf0c}",
        "\u{1108}\u{1167}\u{11ab}"), ("\u{bf0d}", "\u{bf0d}", "\u{1108}\u{1167}\u{11ac}",
        "\u{bf0d}", "\u{1108}\u{1167}\u{11ac}"), ("\u{bf0e}", "\u{bf0e}",
        "\u{1108}\u{1167}\u{11ad}", "\u{bf0e}", "\u{1108}\u{1167}\u{11ad}"), ("\u{bf0f}",
        "\u{bf0f}", "\u{1108}\u{1167}\u{11ae}", "\u{bf0f}", "\u{1108}\u{1167}\u{11ae}"),
        ("\u{bf10}", "\u{bf10}", "\u{1108}\u{1167}\u{11af}", "\u{bf10}",
        "\u{1108}\u{1167}\u{11af}"), ("\u{bf11}", "\u{bf11}", "\u{1108}\u{1167}\u{11b0}",
        "\u{bf11}", "\u{1108}\u{1167}\u{11b0}"), ("\u{bf12}", "\u{bf12}",
        "\u{1108}\u{1167}\u{11b1}", "\u{bf12}", "\u{1108}\u{1167}\u{11b1}"), ("\u{bf13}",
        "\u{bf13}", "\u{1108}\u{1167}\u{11b2}", "\u{bf13}", "\u{1108}\u{1167}\u{11b2}"),
        ("\u{bf14}", "\u{bf14}", "\u{1108}\u{1167}\u{11b3}", "\u{bf14}",
        "\u{1108}\u{1167}\u{11b3}"), ("\u{bf15}", "\u{bf15}", "\u{1108}\u{1167}\u{11b4}",
        "\u{bf15}", "\u{1108}\u{1167}\u{11b4}"), ("\u{bf16}", "\u{bf16}",
        "\u{1108}\u{1167}\u{11b5}", "\u{bf16}", "\u{1108}\u{1167}\u{11b5}"), ("\u{bf17}",
        "\u{bf17}", "\u{1108}\u{1167}\u{11b6}", "\u{bf17}", "\u{1108}\u{1167}\u{11b6}"),
        ("\u{bf18}", "\u{bf18}", "\u{1108}\u{1167}\u{11b7}", "\u{bf18}",
        "\u{1108}\u{1167}\u{11b7}"), ("\u{bf19}", "\u{bf19}", "\u{1108}\u{1167}\u{11b8}",
        "\u{bf19}", "\u{1108}\u{1167}\u{11b8}"), ("\u{bf1a}", "\u{bf1a}",
        "\u{1108}\u{1167}\u{11b9}", "\u{bf1a}", "\u{1108}\u{1167}\u{11b9}"), ("\u{bf1b}",
        "\u{bf1b}", "\u{1108}\u{1167}\u{11ba}", "\u{bf1b}", "\u{1108}\u{1167}\u{11ba}"),
        ("\u{bf1c}", "\u{bf1c}", "\u{1108}\u{1167}\u{11bb}", "\u{bf1c}",
        "\u{1108}\u{1167}\u{11bb}"), ("\u{bf1d}", "\u{bf1d}", "\u{1108}\u{1167}\u{11bc}",
        "\u{bf1d}", "\u{1108}\u{1167}\u{11bc}"), ("\u{bf1e}", "\u{bf1e}",
        "\u{1108}\u{1167}\u{11bd}", "\u{bf1e}", "\u{1108}\u{1167}\u{11bd}"), ("\u{bf1f}",
        "\u{bf1f}", "\u{1108}\u{1167}\u{11be}", "\u{bf1f}", "\u{1108}\u{1167}\u{11be}"),
        ("\u{bf20}", "\u{bf20}", "\u{1108}\u{1167}\u{11bf}", "\u{bf20}",
        "\u{1108}\u{1167}\u{11bf}"), ("\u{bf21}", "\u{bf21}", "\u{1108}\u{1167}\u{11c0}",
        "\u{bf21}", "\u{1108}\u{1167}\u{11c0}"), ("\u{bf22}", "\u{bf22}",
        "\u{1108}\u{1167}\u{11c1}", "\u{bf22}", "\u{1108}\u{1167}\u{11c1}"), ("\u{bf23}",
        "\u{bf23}", "\u{1108}\u{1167}\u{11c2}", "\u{bf23}", "\u{1108}\u{1167}\u{11c2}"),
        ("\u{bf24}", "\u{bf24}", "\u{1108}\u{1168}", "\u{bf24}", "\u{1108}\u{1168}"), ("\u{bf25}",
        "\u{bf25}", "\u{1108}\u{1168}\u{11a8}", "\u{bf25}", "\u{1108}\u{1168}\u{11a8}"),
        ("\u{bf26}", "\u{bf26}", "\u{1108}\u{1168}\u{11a9}", "\u{bf26}",
        "\u{1108}\u{1168}\u{11a9}"), ("\u{bf27}", "\u{bf27}", "\u{1108}\u{1168}\u{11aa}",
        "\u{bf27}", "\u{1108}\u{1168}\u{11aa}"), ("\u{bf28}", "\u{bf28}",
        "\u{1108}\u{1168}\u{11ab}", "\u{bf28}", "\u{1108}\u{1168}\u{11ab}"), ("\u{bf29}",
        "\u{bf29}", "\u{1108}\u{1168}\u{11ac}", "\u{bf29}", "\u{1108}\u{1168}\u{11ac}"),
        ("\u{bf2a}", "\u{bf2a}", "\u{1108}\u{1168}\u{11ad}", "\u{bf2a}",
        "\u{1108}\u{1168}\u{11ad}"), ("\u{bf2b}", "\u{bf2b}", "\u{1108}\u{1168}\u{11ae}",
        "\u{bf2b}", "\u{1108}\u{1168}\u{11ae}"), ("\u{bf2c}", "\u{bf2c}",
        "\u{1108}\u{1168}\u{11af}", "\u{bf2c}", "\u{1108}\u{1168}\u{11af}"), ("\u{bf2d}",
        "\u{bf2d}", "\u{1108}\u{1168}\u{11b0}", "\u{bf2d}", "\u{1108}\u{1168}\u{11b0}"),
        ("\u{bf2e}", "\u{bf2e}", "\u{1108}\u{1168}\u{11b1}", "\u{bf2e}",
        "\u{1108}\u{1168}\u{11b1}"), ("\u{bf2f}", "\u{bf2f}", "\u{1108}\u{1168}\u{11b2}",
        "\u{bf2f}", "\u{1108}\u{1168}\u{11b2}"), ("\u{bf30}", "\u{bf30}",
        "\u{1108}\u{1168}\u{11b3}", "\u{bf30}", "\u{1108}\u{1168}\u{11b3}"), ("\u{bf31}",
        "\u{bf31}", "\u{1108}\u{1168}\u{11b4}", "\u{bf31}", "\u{1108}\u{1168}\u{11b4}"),
        ("\u{bf32}", "\u{bf32}", "\u{1108}\u{1168}\u{11b5}", "\u{bf32}",
        "\u{1108}\u{1168}\u{11b5}"), ("\u{bf33}", "\u{bf33}", "\u{1108}\u{1168}\u{11b6}",
        "\u{bf33}", "\u{1108}\u{1168}\u{11b6}"), ("\u{bf34}", "\u{bf34}",
        "\u{1108}\u{1168}\u{11b7}", "\u{bf34}", "\u{1108}\u{1168}\u{11b7}"), ("\u{bf35}",
        "\u{bf35}", "\u{1108}\u{1168}\u{11b8}", "\u{bf35}", "\u{1108}\u{1168}\u{11b8}"),
        ("\u{bf36}", "\u{bf36}", "\u{1108}\u{1168}\u{11b9}", "\u{bf36}",
        "\u{1108}\u{1168}\u{11b9}"), ("\u{bf37}", "\u{bf37}", "\u{1108}\u{1168}\u{11ba}",
        "\u{bf37}", "\u{1108}\u{1168}\u{11ba}"), ("\u{bf38}", "\u{bf38}",
        "\u{1108}\u{1168}\u{11bb}", "\u{bf38}", "\u{1108}\u{1168}\u{11bb}"), ("\u{bf39}",
        "\u{bf39}", "\u{1108}\u{1168}\u{11bc}", "\u{bf39}", "\u{1108}\u{1168}\u{11bc}"),
        ("\u{bf3a}", "\u{bf3a}", "\u{1108}\u{1168}\u{11bd}", "\u{bf3a}",
        "\u{1108}\u{1168}\u{11bd}"), ("\u{bf3b}", "\u{bf3b}", "\u{1108}\u{1168}\u{11be}",
        "\u{bf3b}", "\u{1108}\u{1168}\u{11be}"), ("\u{bf3c}", "\u{bf3c}",
        "\u{1108}\u{1168}\u{11bf}", "\u{bf3c}", "\u{1108}\u{1168}\u{11bf}"), ("\u{bf3d}",
        "\u{bf3d}", "\u{1108}\u{1168}\u{11c0}", "\u{bf3d}", "\u{1108}\u{1168}\u{11c0}"),
        ("\u{bf3e}", "\u{bf3e}", "\u{1108}\u{1168}\u{11c1}", "\u{bf3e}",
        "\u{1108}\u{1168}\u{11c1}"), ("\u{bf3f}", "\u{bf3f}", "\u{1108}\u{1168}\u{11c2}",
        "\u{bf3f}", "\u{1108}\u{1168}\u{11c2}"), ("\u{bf40}", "\u{bf40}", "\u{1108}\u{1169}",
        "\u{bf40}", "\u{1108}\u{1169}"), ("\u{bf41}", "\u{bf41}", "\u{1108}\u{1169}\u{11a8}",
        "\u{bf41}", "\u{1108}\u{1169}\u{11a8}"), ("\u{bf42}", "\u{bf42}",
        "\u{1108}\u{1169}\u{11a9}", "\u{bf42}", "\u{1108}\u{1169}\u{11a9}"), ("\u{bf43}",
        "\u{bf43}", "\u{1108}\u{1169}\u{11aa}", "\u{bf43}", "\u{1108}\u{1169}\u{11aa}"),
        ("\u{bf44}", "\u{bf44}", "\u{1108}\u{1169}\u{11ab}", "\u{bf44}",
        "\u{1108}\u{1169}\u{11ab}"), ("\u{bf45}", "\u{bf45}", "\u{1108}\u{1169}\u{11ac}",
        "\u{bf45}", "\u{1108}\u{1169}\u{11ac}"), ("\u{bf46}", "\u{bf46}",
        "\u{1108}\u{1169}\u{11ad}", "\u{bf46}", "\u{1108}\u{1169}\u{11ad}"), ("\u{bf47}",
        "\u{bf47}", "\u{1108}\u{1169}\u{11ae}", "\u{bf47}", "\u{1108}\u{1169}\u{11ae}"),
        ("\u{bf48}", "\u{bf48}", "\u{1108}\u{1169}\u{11af}", "\u{bf48}",
        "\u{1108}\u{1169}\u{11af}"), ("\u{bf49}", "\u{bf49}", "\u{1108}\u{1169}\u{11b0}",
        "\u{bf49}", "\u{1108}\u{1169}\u{11b0}"), ("\u{bf4a}", "\u{bf4a}",
        "\u{1108}\u{1169}\u{11b1}", "\u{bf4a}", "\u{1108}\u{1169}\u{11b1}"), ("\u{bf4b}",
        "\u{bf4b}", "\u{1108}\u{1169}\u{11b2}", "\u{bf4b}", "\u{1108}\u{1169}\u{11b2}"),
        ("\u{bf4c}", "\u{bf4c}", "\u{1108}\u{1169}\u{11b3}", "\u{bf4c}",
        "\u{1108}\u{1169}\u{11b3}"), ("\u{bf4d}", "\u{bf4d}", "\u{1108}\u{1169}\u{11b4}",
        "\u{bf4d}", "\u{1108}\u{1169}\u{11b4}"), ("\u{bf4e}", "\u{bf4e}",
        "\u{1108}\u{1169}\u{11b5}", "\u{bf4e}", "\u{1108}\u{1169}\u{11b5}"), ("\u{bf4f}",
        "\u{bf4f}", "\u{1108}\u{1169}\u{11b6}", "\u{bf4f}", "\u{1108}\u{1169}\u{11b6}"),
        ("\u{bf50}", "\u{bf50}", "\u{1108}\u{1169}\u{11b7}", "\u{bf50}",
        "\u{1108}\u{1169}\u{11b7}"), ("\u{bf51}", "\u{bf51}", "\u{1108}\u{1169}\u{11b8}",
        "\u{bf51}", "\u{1108}\u{1169}\u{11b8}"), ("\u{bf52}", "\u{bf52}",
        "\u{1108}\u{1169}\u{11b9}", "\u{bf52}", "\u{1108}\u{1169}\u{11b9}"), ("\u{bf53}",
        "\u{bf53}", "\u{1108}\u{1169}\u{11ba}", "\u{bf53}", "\u{1108}\u{1169}\u{11ba}"),
        ("\u{bf54}", "\u{bf54}", "\u{1108}\u{1169}\u{11bb}", "\u{bf54}",
        "\u{1108}\u{1169}\u{11bb}"), ("\u{bf55}", "\u{bf55}", "\u{1108}\u{1169}\u{11bc}",
        "\u{bf55}", "\u{1108}\u{1169}\u{11bc}"), ("\u{bf56}", "\u{bf56}",
        "\u{1108}\u{1169}\u{11bd}", "\u{bf56}", "\u{1108}\u{1169}\u{11bd}"), ("\u{bf57}",
        "\u{bf57}", "\u{1108}\u{1169}\u{11be}", "\u{bf57}", "\u{1108}\u{1169}\u{11be}"),
        ("\u{bf58}", "\u{bf58}", "\u{1108}\u{1169}\u{11bf}", "\u{bf58}",
        "\u{1108}\u{1169}\u{11bf}"), ("\u{bf59}", "\u{bf59}", "\u{1108}\u{1169}\u{11c0}",
        "\u{bf59}", "\u{1108}\u{1169}\u{11c0}"), ("\u{bf5a}", "\u{bf5a}",
        "\u{1108}\u{1169}\u{11c1}", "\u{bf5a}", "\u{1108}\u{1169}\u{11c1}"), ("\u{bf5b}",
        "\u{bf5b}", "\u{1108}\u{1169}\u{11c2}", "\u{bf5b}", "\u{1108}\u{1169}\u{11c2}"),
        ("\u{bf5c}", "\u{bf5c}", "\u{1108}\u{116a}", "\u{bf5c}", "\u{1108}\u{116a}"), ("\u{bf5d}",
        "\u{bf5d}", "\u{1108}\u{116a}\u{11a8}", "\u{bf5d}", "\u{1108}\u{116a}\u{11a8}"),
        ("\u{bf5e}", "\u{bf5e}", "\u{1108}\u{116a}\u{11a9}", "\u{bf5e}",
        "\u{1108}\u{116a}\u{11a9}"), ("\u{bf5f}", "\u{bf5f}", "\u{1108}\u{116a}\u{11aa}",
        "\u{bf5f}", "\u{1108}\u{116a}\u{11aa}"), ("\u{bf60}", "\u{bf60}",
        "\u{1108}\u{116a}\u{11ab}", "\u{bf60}", "\u{1108}\u{116a}\u{11ab}"), ("\u{bf61}",
        "\u{bf61}", "\u{1108}\u{116a}\u{11ac}", "\u{bf61}", "\u{1108}\u{116a}\u{11ac}"),
        ("\u{bf62}", "\u{bf62}", "\u{1108}\u{116a}\u{11ad}", "\u{bf62}",
        "\u{1108}\u{116a}\u{11ad}"), ("\u{bf63}", "\u{bf63}", "\u{1108}\u{116a}\u{11ae}",
        "\u{bf63}", "\u{1108}\u{116a}\u{11ae}"), ("\u{bf64}", "\u{bf64}",
        "\u{1108}\u{116a}\u{11af}", "\u{bf64}", "\u{1108}\u{116a}\u{11af}"), ("\u{bf65}",
        "\u{bf65}", "\u{1108}\u{116a}\u{11b0}", "\u{bf65}", "\u{1108}\u{116a}\u{11b0}"),
        ("\u{bf66}", "\u{bf66}", "\u{1108}\u{116a}\u{11b1}", "\u{bf66}",
        "\u{1108}\u{116a}\u{11b1}"), ("\u{bf67}", "\u{bf67}", "\u{1108}\u{116a}\u{11b2}",
        "\u{bf67}", "\u{1108}\u{116a}\u{11b2}"), ("\u{bf68}", "\u{bf68}",
        "\u{1108}\u{116a}\u{11b3}", "\u{bf68}", "\u{1108}\u{116a}\u{11b3}"), ("\u{bf69}",
        "\u{bf69}", "\u{1108}\u{116a}\u{11b4}", "\u{bf69}", "\u{1108}\u{116a}\u{11b4}"),
        ("\u{bf6a}", "\u{bf6a}", "\u{1108}\u{116a}\u{11b5}", "\u{bf6a}",
        "\u{1108}\u{116a}\u{11b5}"), ("\u{bf6b}", "\u{bf6b}", "\u{1108}\u{116a}\u{11b6}",
        "\u{bf6b}", "\u{1108}\u{116a}\u{11b6}"), ("\u{bf6c}", "\u{bf6c}",
        "\u{1108}\u{116a}\u{11b7}", "\u{bf6c}", "\u{1108}\u{116a}\u{11b7}"), ("\u{bf6d}",
        "\u{bf6d}", "\u{1108}\u{116a}\u{11b8}", "\u{bf6d}", "\u{1108}\u{116a}\u{11b8}"),
        ("\u{bf6e}", "\u{bf6e}", "\u{1108}\u{116a}\u{11b9}", "\u{bf6e}",
        "\u{1108}\u{116a}\u{11b9}"), ("\u{bf6f}", "\u{bf6f}", "\u{1108}\u{116a}\u{11ba}",
        "\u{bf6f}", "\u{1108}\u{116a}\u{11ba}"), ("\u{bf70}", "\u{bf70}",
        "\u{1108}\u{116a}\u{11bb}", "\u{bf70}", "\u{1108}\u{116a}\u{11bb}"), ("\u{bf71}",
        "\u{bf71}", "\u{1108}\u{116a}\u{11bc}", "\u{bf71}", "\u{1108}\u{116a}\u{11bc}"),
        ("\u{bf72}", "\u{bf72}", "\u{1108}\u{116a}\u{11bd}", "\u{bf72}",
        "\u{1108}\u{116a}\u{11bd}"), ("\u{bf73}", "\u{bf73}", "\u{1108}\u{116a}\u{11be}",
        "\u{bf73}", "\u{1108}\u{116a}\u{11be}"), ("\u{bf74}", "\u{bf74}",
        "\u{1108}\u{116a}\u{11bf}", "\u{bf74}", "\u{1108}\u{116a}\u{11bf}"), ("\u{bf75}",
        "\u{bf75}", "\u{1108}\u{116a}\u{11c0}", "\u{bf75}", "\u{1108}\u{116a}\u{11c0}"),
        ("\u{bf76}", "\u{bf76}", "\u{1108}\u{116a}\u{11c1}", "\u{bf76}",
        "\u{1108}\u{116a}\u{11c1}"), ("\u{bf77}", "\u{bf77}", "\u{1108}\u{116a}\u{11c2}",
        "\u{bf77}", "\u{1108}\u{116a}\u{11c2}"), ("\u{bf78}", "\u{bf78}", "\u{1108}\u{116b}",
        "\u{bf78}", "\u{1108}\u{116b}"), ("\u{bf79}", "\u{bf79}", "\u{1108}\u{116b}\u{11a8}",
        "\u{bf79}", "\u{1108}\u{116b}\u{11a8}"), ("\u{bf7a}", "\u{bf7a}",
        "\u{1108}\u{116b}\u{11a9}", "\u{bf7a}", "\u{1108}\u{116b}\u{11a9}"), ("\u{bf7b}",
        "\u{bf7b}", "\u{1108}\u{116b}\u{11aa}", "\u{bf7b}", "\u{1108}\u{116b}\u{11aa}"),
        ("\u{bf7c}", "\u{bf7c}", "\u{1108}\u{116b}\u{11ab}", "\u{bf7c}",
        "\u{1108}\u{116b}\u{11ab}"), ("\u{bf7d}", "\u{bf7d}", "\u{1108}\u{116b}\u{11ac}",
        "\u{bf7d}", "\u{1108}\u{116b}\u{11ac}"), ("\u{bf7e}", "\u{bf7e}",
        "\u{1108}\u{116b}\u{11ad}", "\u{bf7e}", "\u{1108}\u{116b}\u{11ad}"), ("\u{bf7f}",
        "\u{bf7f}", "\u{1108}\u{116b}\u{11ae}", "\u{bf7f}", "\u{1108}\u{116b}\u{11ae}"),
        ("\u{bf80}", "\u{bf80}", "\u{1108}\u{116b}\u{11af}", "\u{bf80}",
        "\u{1108}\u{116b}\u{11af}"), ("\u{bf81}", "\u{bf81}", "\u{1108}\u{116b}\u{11b0}",
        "\u{bf81}", "\u{1108}\u{116b}\u{11b0}"), ("\u{bf82}", "\u{bf82}",
        "\u{1108}\u{116b}\u{11b1}", "\u{bf82}", "\u{1108}\u{116b}\u{11b1}"), ("\u{bf83}",
        "\u{bf83}", "\u{1108}\u{116b}\u{11b2}", "\u{bf83}", "\u{1108}\u{116b}\u{11b2}"),
        ("\u{bf84}", "\u{bf84}", "\u{1108}\u{116b}\u{11b3}", "\u{bf84}",
        "\u{1108}\u{116b}\u{11b3}"), ("\u{bf85}", "\u{bf85}", "\u{1108}\u{116b}\u{11b4}",
        "\u{bf85}", "\u{1108}\u{116b}\u{11b4}"), ("\u{bf86}", "\u{bf86}",
        "\u{1108}\u{116b}\u{11b5}", "\u{bf86}", "\u{1108}\u{116b}\u{11b5}"), ("\u{bf87}",
        "\u{bf87}", "\u{1108}\u{116b}\u{11b6}", "\u{bf87}", "\u{1108}\u{116b}\u{11b6}"),
        ("\u{bf88}", "\u{bf88}", "\u{1108}\u{116b}\u{11b7}", "\u{bf88}",
        "\u{1108}\u{116b}\u{11b7}"), ("\u{bf89}", "\u{bf89}", "\u{1108}\u{116b}\u{11b8}",
        "\u{bf89}", "\u{1108}\u{116b}\u{11b8}"), ("\u{bf8a}", "\u{bf8a}",
        "\u{1108}\u{116b}\u{11b9}", "\u{bf8a}", "\u{1108}\u{116b}\u{11b9}"), ("\u{bf8b}",
        "\u{bf8b}", "\u{1108}\u{116b}\u{11ba}", "\u{bf8b}", "\u{1108}\u{116b}\u{11ba}"),
        ("\u{bf8c}", "\u{bf8c}", "\u{1108}\u{116b}\u{11bb}", "\u{bf8c}",
        "\u{1108}\u{116b}\u{11bb}"), ("\u{bf8d}", "\u{bf8d}", "\u{1108}\u{116b}\u{11bc}",
        "\u{bf8d}", "\u{1108}\u{116b}\u{11bc}"), ("\u{bf8e}", "\u{bf8e}",
        "\u{1108}\u{116b}\u{11bd}", "\u{bf8e}", "\u{1108}\u{116b}\u{11bd}"), ("\u{bf8f}",
        "\u{bf8f}", "\u{1108}\u{116b}\u{11be}", "\u{bf8f}", "\u{1108}\u{116b}\u{11be}"),
        ("\u{bf90}", "\u{bf90}", "\u{1108}\u{116b}\u{11bf}", "\u{bf90}",
        "\u{1108}\u{116b}\u{11bf}"), ("\u{bf91}", "\u{bf91}", "\u{1108}\u{116b}\u{11c0}",
        "\u{bf91}", "\u{1108}\u{116b}\u{11c0}"), ("\u{bf92}", "\u{bf92}",
        "\u{1108}\u{116b}\u{11c1}", "\u{bf92}", "\u{1108}\u{116b}\u{11c1}"), ("\u{bf93}",
        "\u{bf93}", "\u{1108}\u{116b}\u{11c2}", "\u{bf93}", "\u{1108}\u{116b}\u{11c2}"),
        ("\u{bf94}", "\u{bf94}", "\u{1108}\u{116c}", "\u{bf94}", "\u{1108}\u{116c}"), ("\u{bf95}",
        "\u{bf95}", "\u{1108}\u{116c}\u{11a8}", "\u{bf95}", "\u{1108}\u{116c}\u{11a8}"),
        ("\u{bf96}", "\u{bf96}", "\u{1108}\u{116c}\u{11a9}", "\u{bf96}",
        "\u{1108}\u{116c}\u{11a9}"), ("\u{bf97}", "\u{bf97}", "\u{1108}\u{116c}\u{11aa}",
        "\u{bf97}", "\u{1108}\u{116c}\u{11aa}"), ("\u{bf98}", "\u{bf98}",
        "\u{1108}\u{116c}\u{11ab}", "\u{bf98}", "\u{1108}\u{116c}\u{11ab}"), ("\u{bf99}",
        "\u{bf99}", "\u{1108}\u{116c}\u{11ac}", "\u{bf99}", "\u{1108}\u{116c}\u{11ac}"),
        ("\u{bf9a}", "\u{bf9a}", "\u{1108}\u{116c}\u{11ad}", "\u{bf9a}",
        "\u{1108}\u{116c}\u{11ad}"), ("\u{bf9b}", "\u{bf9b}", "\u{1108}\u{116c}\u{11ae}",
        "\u{bf9b}", "\u{1108}\u{116c}\u{11ae}"), ("\u{bf9c}", "\u{bf9c}",
        "\u{1108}\u{116c}\u{11af}", "\u{bf9c}", "\u{1108}\u{116c}\u{11af}"), ("\u{bf9d}",
        "\u{bf9d}", "\u{1108}\u{116c}\u{11b0}", "\u{bf9d}", "\u{1108}\u{116c}\u{11b0}"),
        ("\u{bf9e}", "\u{bf9e}", "\u{1108}\u{116c}\u{11b1}", "\u{bf9e}",
        "\u{1108}\u{116c}\u{11b1}"), ("\u{bf9f}", "\u{bf9f}", "\u{1108}\u{116c}\u{11b2}",
        "\u{bf9f}", "\u{1108}\u{116c}\u{11b2}"), ("\u{bfa0}", "\u{bfa0}",
        "\u{1108}\u{116c}\u{11b3}", "\u{bfa0}", "\u{1108}\u{116c}\u{11b3}"), ("\u{bfa1}",
        "\u{bfa1}", "\u{1108}\u{116c}\u{11b4}", "\u{bfa1}", "\u{1108}\u{116c}\u{11b4}"),
        ("\u{bfa2}", "\u{bfa2}", "\u{1108}\u{116c}\u{11b5}", "\u{bfa2}",
        "\u{1108}\u{116c}\u{11b5}"), ("\u{bfa3}", "\u{bfa3}", "\u{1108}\u{116c}\u{11b6}",
        "\u{bfa3}", "\u{1108}\u{116c}\u{11b6}"), ("\u{bfa4}", "\u{bfa4}",
        "\u{1108}\u{116c}\u{11b7}", "\u{bfa4}", "\u{1108}\u{116c}\u{11b7}"), ("\u{bfa5}",
        "\u{bfa5}", "\u{1108}\u{116c}\u{11b8}", "\u{bfa5}", "\u{1108}\u{116c}\u{11b8}"),
        ("\u{bfa6}", "\u{bfa6}", "\u{1108}\u{116c}\u{11b9}", "\u{bfa6}",
        "\u{1108}\u{116c}\u{11b9}"), ("\u{bfa7}", "\u{bfa7}", "\u{1108}\u{116c}\u{11ba}",
        "\u{bfa7}", "\u{1108}\u{116c}\u{11ba}"), ("\u{bfa8}", "\u{bfa8}",
        "\u{1108}\u{116c}\u{11bb}", "\u{bfa8}", "\u{1108}\u{116c}\u{11bb}"), ("\u{bfa9}",
        "\u{bfa9}", "\u{1108}\u{116c}\u{11bc}", "\u{bfa9}", "\u{1108}\u{116c}\u{11bc}"),
        ("\u{bfaa}", "\u{bfaa}", "\u{1108}\u{116c}\u{11bd}", "\u{bfaa}",
        "\u{1108}\u{116c}\u{11bd}"), ("\u{bfab}", "\u{bfab}", "\u{1108}\u{116c}\u{11be}",
        "\u{bfab}", "\u{1108}\u{116c}\u{11be}"), ("\u{bfac}", "\u{bfac}",
        "\u{1108}\u{116c}\u{11bf}", "\u{bfac}", "\u{1108}\u{116c}\u{11bf}"), ("\u{bfad}",
        "\u{bfad}", "\u{1108}\u{116c}\u{11c0}", "\u{bfad}", "\u{1108}\u{116c}\u{11c0}"),
        ("\u{bfae}", "\u{bfae}", "\u{1108}\u{116c}\u{11c1}", "\u{bfae}",
        "\u{1108}\u{116c}\u{11c1}"), ("\u{bfaf}", "\u{bfaf}", "\u{1108}\u{116c}\u{11c2}",
        "\u{bfaf}", "\u{1108}\u{116c}\u{11c2}"), ("\u{bfb0}", "\u{bfb0}", "\u{1108}\u{116d}",
        "\u{bfb0}", "\u{1108}\u{116d}"), ("\u{bfb1}", "\u{bfb1}", "\u{1108}\u{116d}\u{11a8}",
        "\u{bfb1}", "\u{1108}\u{116d}\u{11a8}"), ("\u{bfb2}", "\u{bfb2}",
        "\u{1108}\u{116d}\u{11a9}", "\u{bfb2}", "\u{1108}\u{116d}\u{11a9}"), ("\u{bfb3}",
        "\u{bfb3}", "\u{1108}\u{116d}\u{11aa}", "\u{bfb3}", "\u{1108}\u{116d}\u{11aa}"),
        ("\u{bfb4}", "\u{bfb4}", "\u{1108}\u{116d}\u{11ab}", "\u{bfb4}",
        "\u{1108}\u{116d}\u{11ab}"), ("\u{bfb5}", "\u{bfb5}", "\u{1108}\u{116d}\u{11ac}",
        "\u{bfb5}", "\u{1108}\u{116d}\u{11ac}"), ("\u{bfb6}", "\u{bfb6}",
        "\u{1108}\u{116d}\u{11ad}", "\u{bfb6}", "\u{1108}\u{116d}\u{11ad}"), ("\u{bfb7}",
        "\u{bfb7}", "\u{1108}\u{116d}\u{11ae}", "\u{bfb7}", "\u{1108}\u{116d}\u{11ae}"),
        ("\u{bfb8}", "\u{bfb8}", "\u{1108}\u{116d}\u{11af}", "\u{bfb8}",
        "\u{1108}\u{116d}\u{11af}"), ("\u{bfb9}", "\u{bfb9}", "\u{1108}\u{116d}\u{11b0}",
        "\u{bfb9}", "\u{1108}\u{116d}\u{11b0}"), ("\u{bfba}", "\u{bfba}",
        "\u{1108}\u{116d}\u{11b1}", "\u{bfba}", "\u{1108}\u{116d}\u{11b1}"), ("\u{bfbb}",
        "\u{bfbb}", "\u{1108}\u{116d}\u{11b2}", "\u{bfbb}", "\u{1108}\u{116d}\u{11b2}"),
        ("\u{bfbc}", "\u{bfbc}", "\u{1108}\u{116d}\u{11b3}", "\u{bfbc}",
        "\u{1108}\u{116d}\u{11b3}"), ("\u{bfbd}", "\u{bfbd}", "\u{1108}\u{116d}\u{11b4}",
        "\u{bfbd}", "\u{1108}\u{116d}\u{11b4}"), ("\u{bfbe}", "\u{bfbe}",
        "\u{1108}\u{116d}\u{11b5}", "\u{bfbe}", "\u{1108}\u{116d}\u{11b5}"), ("\u{bfbf}",
        "\u{bfbf}", "\u{1108}\u{116d}\u{11b6}", "\u{bfbf}", "\u{1108}\u{116d}\u{11b6}"),
        ("\u{bfc0}", "\u{bfc0}", "\u{1108}\u{116d}\u{11b7}", "\u{bfc0}",
        "\u{1108}\u{116d}\u{11b7}"), ("\u{bfc1}", "\u{bfc1}", "\u{1108}\u{116d}\u{11b8}",
        "\u{bfc1}", "\u{1108}\u{116d}\u{11b8}"), ("\u{bfc2}", "\u{bfc2}",
        "\u{1108}\u{116d}\u{11b9}", "\u{bfc2}", "\u{1108}\u{116d}\u{11b9}"), ("\u{bfc3}",
        "\u{bfc3}", "\u{1108}\u{116d}\u{11ba}", "\u{bfc3}", "\u{1108}\u{116d}\u{11ba}"),
        ("\u{bfc4}", "\u{bfc4}", "\u{1108}\u{116d}\u{11bb}", "\u{bfc4}",
        "\u{1108}\u{116d}\u{11bb}"), ("\u{bfc5}", "\u{bfc5}", "\u{1108}\u{116d}\u{11bc}",
        "\u{bfc5}", "\u{1108}\u{116d}\u{11bc}"), ("\u{bfc6}", "\u{bfc6}",
        "\u{1108}\u{116d}\u{11bd}", "\u{bfc6}", "\u{1108}\u{116d}\u{11bd}"), ("\u{bfc7}",
        "\u{bfc7}", "\u{1108}\u{116d}\u{11be}", "\u{bfc7}", "\u{1108}\u{116d}\u{11be}"),
        ("\u{bfc8}", "\u{bfc8}", "\u{1108}\u{116d}\u{11bf}", "\u{bfc8}",
        "\u{1108}\u{116d}\u{11bf}"), ("\u{bfc9}", "\u{bfc9}", "\u{1108}\u{116d}\u{11c0}",
        "\u{bfc9}", "\u{1108}\u{116d}\u{11c0}"), ("\u{bfca}", "\u{bfca}",
        "\u{1108}\u{116d}\u{11c1}", "\u{bfca}", "\u{1108}\u{116d}\u{11c1}"), ("\u{bfcb}",
        "\u{bfcb}", "\u{1108}\u{116d}\u{11c2}", "\u{bfcb}", "\u{1108}\u{116d}\u{11c2}"),
        ("\u{bfcc}", "\u{bfcc}", "\u{1108}\u{116e}", "\u{bfcc}", "\u{1108}\u{116e}"), ("\u{bfcd}",
        "\u{bfcd}", "\u{1108}\u{116e}\u{11a8}", "\u{bfcd}", "\u{1108}\u{116e}\u{11a8}"),
        ("\u{bfce}", "\u{bfce}", "\u{1108}\u{116e}\u{11a9}", "\u{bfce}",
        "\u{1108}\u{116e}\u{11a9}"), ("\u{bfcf}", "\u{bfcf}", "\u{1108}\u{116e}\u{11aa}",
        "\u{bfcf}", "\u{1108}\u{116e}\u{11aa}"), ("\u{bfd0}", "\u{bfd0}",
        "\u{1108}\u{116e}\u{11ab}", "\u{bfd0}", "\u{1108}\u{116e}\u{11ab}"), ("\u{bfd1}",
        "\u{bfd1}", "\u{1108}\u{116e}\u{11ac}", "\u{bfd1}", "\u{1108}\u{116e}\u{11ac}"),
        ("\u{bfd2}", "\u{bfd2}", "\u{1108}\u{116e}\u{11ad}", "\u{bfd2}",
        "\u{1108}\u{116e}\u{11ad}"), ("\u{bfd3}", "\u{bfd3}", "\u{1108}\u{116e}\u{11ae}",
        "\u{bfd3}", "\u{1108}\u{116e}\u{11ae}"), ("\u{bfd4}", "\u{bfd4}",
        "\u{1108}\u{116e}\u{11af}", "\u{bfd4}", "\u{1108}\u{116e}\u{11af}"), ("\u{bfd5}",
        "\u{bfd5}", "\u{1108}\u{116e}\u{11b0}", "\u{bfd5}", "\u{1108}\u{116e}\u{11b0}"),
        ("\u{bfd6}", "\u{bfd6}", "\u{1108}\u{116e}\u{11b1}", "\u{bfd6}",
        "\u{1108}\u{116e}\u{11b1}"), ("\u{bfd7}", "\u{bfd7}", "\u{1108}\u{116e}\u{11b2}",
        "\u{bfd7}", "\u{1108}\u{116e}\u{11b2}"), ("\u{bfd8}", "\u{bfd8}",
        "\u{1108}\u{116e}\u{11b3}", "\u{bfd8}", "\u{1108}\u{116e}\u{11b3}"), ("\u{bfd9}",
        "\u{bfd9}", "\u{1108}\u{116e}\u{11b4}", "\u{bfd9}", "\u{1108}\u{116e}\u{11b4}"),
        ("\u{bfda}", "\u{bfda}", "\u{1108}\u{116e}\u{11b5}", "\u{bfda}",
        "\u{1108}\u{116e}\u{11b5}"), ("\u{bfdb}", "\u{bfdb}", "\u{1108}\u{116e}\u{11b6}",
        "\u{bfdb}", "\u{1108}\u{116e}\u{11b6}"), ("\u{bfdc}", "\u{bfdc}",
        "\u{1108}\u{116e}\u{11b7}", "\u{bfdc}", "\u{1108}\u{116e}\u{11b7}"), ("\u{bfdd}",
        "\u{bfdd}", "\u{1108}\u{116e}\u{11b8}", "\u{bfdd}", "\u{1108}\u{116e}\u{11b8}"),
        ("\u{bfde}", "\u{bfde}", "\u{1108}\u{116e}\u{11b9}", "\u{bfde}",
        "\u{1108}\u{116e}\u{11b9}"), ("\u{bfdf}", "\u{bfdf}", "\u{1108}\u{116e}\u{11ba}",
        "\u{bfdf}", "\u{1108}\u{116e}\u{11ba}"), ("\u{bfe0}", "\u{bfe0}",
        "\u{1108}\u{116e}\u{11bb}", "\u{bfe0}", "\u{1108}\u{116e}\u{11bb}"), ("\u{bfe1}",
        "\u{bfe1}", "\u{1108}\u{116e}\u{11bc}", "\u{bfe1}", "\u{1108}\u{116e}\u{11bc}"),
        ("\u{bfe2}", "\u{bfe2}", "\u{1108}\u{116e}\u{11bd}", "\u{bfe2}",
        "\u{1108}\u{116e}\u{11bd}"), ("\u{bfe3}", "\u{bfe3}", "\u{1108}\u{116e}\u{11be}",
        "\u{bfe3}", "\u{1108}\u{116e}\u{11be}"), ("\u{bfe4}", "\u{bfe4}",
        "\u{1108}\u{116e}\u{11bf}", "\u{bfe4}", "\u{1108}\u{116e}\u{11bf}"), ("\u{bfe5}",
        "\u{bfe5}", "\u{1108}\u{116e}\u{11c0}", "\u{bfe5}", "\u{1108}\u{116e}\u{11c0}"),
        ("\u{bfe6}", "\u{bfe6}", "\u{1108}\u{116e}\u{11c1}", "\u{bfe6}",
        "\u{1108}\u{116e}\u{11c1}"), ("\u{bfe7}", "\u{bfe7}", "\u{1108}\u{116e}\u{11c2}",
        "\u{bfe7}", "\u{1108}\u{116e}\u{11c2}"), ("\u{bfe8}", "\u{bfe8}", "\u{1108}\u{116f}",
        "\u{bfe8}", "\u{1108}\u{116f}"), ("\u{bfe9}", "\u{bfe9}", "\u{1108}\u{116f}\u{11a8}",
        "\u{bfe9}", "\u{1108}\u{116f}\u{11a8}"), ("\u{bfea}", "\u{bfea}",
        "\u{1108}\u{116f}\u{11a9}", "\u{bfea}", "\u{1108}\u{116f}\u{11a9}"), ("\u{bfeb}",
        "\u{bfeb}", "\u{1108}\u{116f}\u{11aa}", "\u{bfeb}", "\u{1108}\u{116f}\u{11aa}"),
        ("\u{bfec}", "\u{bfec}", "\u{1108}\u{116f}\u{11ab}", "\u{bfec}",
        "\u{1108}\u{116f}\u{11ab}"), ("\u{bfed}", "\u{bfed}", "\u{1108}\u{116f}\u{11ac}",
        "\u{bfed}", "\u{1108}\u{116f}\u{11ac}"), ("\u{bfee}", "\u{bfee}",
        "\u{1108}\u{116f}\u{11ad}", "\u{bfee}", "\u{1108}\u{116f}\u{11ad}"), ("\u{bfef}",
        "\u{bfef}", "\u{1108}\u{116f}\u{11ae}", "\u{bfef}", "\u{1108}\u{116f}\u{11ae}"),
        ("\u{bff0}", "\u{bff0}", "\u{1108}\u{116f}\u{11af}", "\u{bff0}",
        "\u{1108}\u{116f}\u{11af}"), ("\u{bff1}", "\u{bff1}", "\u{1108}\u{116f}\u{11b0}",
        "\u{bff1}", "\u{1108}\u{116f}\u{11b0}"), ("\u{bff2}", "\u{bff2}",
        "\u{1108}\u{116f}\u{11b1}", "\u{bff2}", "\u{1108}\u{116f}\u{11b1}"), ("\u{bff3}",
        "\u{bff3}", "\u{1108}\u{116f}\u{11b2}", "\u{bff3}", "\u{1108}\u{116f}\u{11b2}"),
        ("\u{bff4}", "\u{bff4}", "\u{1108}\u{116f}\u{11b3}", "\u{bff4}",
        "\u{1108}\u{116f}\u{11b3}"), ("\u{bff5}", "\u{bff5}", "\u{1108}\u{116f}\u{11b4}",
        "\u{bff5}", "\u{1108}\u{116f}\u{11b4}"), ("\u{bff6}", "\u{bff6}",
        "\u{1108}\u{116f}\u{11b5}", "\u{bff6}", "\u{1108}\u{116f}\u{11b5}"), ("\u{bff7}",
        "\u{bff7}", "\u{1108}\u{116f}\u{11b6}", "\u{bff7}", "\u{1108}\u{116f}\u{11b6}"),
        ("\u{bff8}", "\u{bff8}", "\u{1108}\u{116f}\u{11b7}", "\u{bff8}",
        "\u{1108}\u{116f}\u{11b7}"), ("\u{bff9}", "\u{bff9}", "\u{1108}\u{116f}\u{11b8}",
        "\u{bff9}", "\u{1108}\u{116f}\u{11b8}"), ("\u{bffa}", "\u{bffa}",
        "\u{1108}\u{116f}\u{11b9}", "\u{bffa}", "\u{1108}\u{116f}\u{11b9}"), ("\u{bffb}",
        "\u{bffb}", "\u{1108}\u{116f}\u{11ba}", "\u{bffb}", "\u{1108}\u{116f}\u{11ba}"),
        ("\u{bffc}", "\u{bffc}", "\u{1108}\u{116f}\u{11bb}", "\u{bffc}",
        "\u{1108}\u{116f}\u{11bb}"), ("\u{bffd}", "\u{bffd}", "\u{1108}\u{116f}\u{11bc}",
        "\u{bffd}", "\u{1108}\u{116f}\u{11bc}"), ("\u{bffe}", "\u{bffe}",
        "\u{1108}\u{116f}\u{11bd}", "\u{bffe}", "\u{1108}\u{116f}\u{11bd}"), ("\u{bfff}",
        "\u{bfff}", "\u{1108}\u{116f}\u{11be}", "\u{bfff}", "\u{1108}\u{116f}\u{11be}"),
        ("\u{c000}", "\u{c000}", "\u{1108}\u{116f}\u{11bf}", "\u{c000}",
        "\u{1108}\u{116f}\u{11bf}"), ("\u{c001}", "\u{c001}", "\u{1108}\u{116f}\u{11c0}",
        "\u{c001}", "\u{1108}\u{116f}\u{11c0}"), ("\u{c002}", "\u{c002}",
        "\u{1108}\u{116f}\u{11c1}", "\u{c002}", "\u{1108}\u{116f}\u{11c1}"), ("\u{c003}",
        "\u{c003}", "\u{1108}\u{116f}\u{11c2}", "\u{c003}", "\u{1108}\u{116f}\u{11c2}"),
        ("\u{c004}", "\u{c004}", "\u{1108}\u{1170}", "\u{c004}", "\u{1108}\u{1170}"), ("\u{c005}",
        "\u{c005}", "\u{1108}\u{1170}\u{11a8}", "\u{c005}", "\u{1108}\u{1170}\u{11a8}"),
        ("\u{c006}", "\u{c006}", "\u{1108}\u{1170}\u{11a9}", "\u{c006}",
        "\u{1108}\u{1170}\u{11a9}"), ("\u{c007}", "\u{c007}", "\u{1108}\u{1170}\u{11aa}",
        "\u{c007}", "\u{1108}\u{1170}\u{11aa}"), ("\u{c008}", "\u{c008}",
        "\u{1108}\u{1170}\u{11ab}", "\u{c008}", "\u{1108}\u{1170}\u{11ab}"), ("\u{c009}",
        "\u{c009}", "\u{1108}\u{1170}\u{11ac}", "\u{c009}", "\u{1108}\u{1170}\u{11ac}"),
        ("\u{c00a}", "\u{c00a}", "\u{1108}\u{1170}\u{11ad}", "\u{c00a}",
        "\u{1108}\u{1170}\u{11ad}"), ("\u{c00b}", "\u{c00b}", "\u{1108}\u{1170}\u{11ae}",
        "\u{c00b}", "\u{1108}\u{1170}\u{11ae}"), ("\u{c00c}", "\u{c00c}",
        "\u{1108}\u{1170}\u{11af}", "\u{c00c}", "\u{1108}\u{1170}\u{11af}"), ("\u{c00d}",
        "\u{c00d}", "\u{1108}\u{1170}\u{11b0}", "\u{c00d}", "\u{1108}\u{1170}\u{11b0}"),
        ("\u{c00e}", "\u{c00e}", "\u{1108}\u{1170}\u{11b1}", "\u{c00e}",
        "\u{1108}\u{1170}\u{11b1}"), ("\u{c00f}", "\u{c00f}", "\u{1108}\u{1170}\u{11b2}",
        "\u{c00f}", "\u{1108}\u{1170}\u{11b2}"), ("\u{c010}", "\u{c010}",
        "\u{1108}\u{1170}\u{11b3}", "\u{c010}", "\u{1108}\u{1170}\u{11b3}"), ("\u{c011}",
        "\u{c011}", "\u{1108}\u{1170}\u{11b4}", "\u{c011}", "\u{1108}\u{1170}\u{11b4}"),
        ("\u{c012}", "\u{c012}", "\u{1108}\u{1170}\u{11b5}", "\u{c012}",
        "\u{1108}\u{1170}\u{11b5}"), ("\u{c013}", "\u{c013}", "\u{1108}\u{1170}\u{11b6}",
        "\u{c013}", "\u{1108}\u{1170}\u{11b6}"), ("\u{c014}", "\u{c014}",
        "\u{1108}\u{1170}\u{11b7}", "\u{c014}", "\u{1108}\u{1170}\u{11b7}"), ("\u{c015}",
        "\u{c015}", "\u{1108}\u{1170}\u{11b8}", "\u{c015}", "\u{1108}\u{1170}\u{11b8}"),
        ("\u{c016}", "\u{c016}", "\u{1108}\u{1170}\u{11b9}", "\u{c016}",
        "\u{1108}\u{1170}\u{11b9}"), ("\u{c017}", "\u{c017}", "\u{1108}\u{1170}\u{11ba}",
        "\u{c017}", "\u{1108}\u{1170}\u{11ba}"), ("\u{c018}", "\u{c018}",
        "\u{1108}\u{1170}\u{11bb}", "\u{c018}", "\u{1108}\u{1170}\u{11bb}"), ("\u{c019}",
        "\u{c019}", "\u{1108}\u{1170}\u{11bc}", "\u{c019}", "\u{1108}\u{1170}\u{11bc}"),
        ("\u{c01a}", "\u{c01a}", "\u{1108}\u{1170}\u{11bd}", "\u{c01a}",
        "\u{1108}\u{1170}\u{11bd}"), ("\u{c01b}", "\u{c01b}", "\u{1108}\u{1170}\u{11be}",
        "\u{c01b}", "\u{1108}\u{1170}\u{11be}"), ("\u{c01c}", "\u{c01c}",
        "\u{1108}\u{1170}\u{11bf}", "\u{c01c}", "\u{1108}\u{1170}\u{11bf}"), ("\u{c01d}",
        "\u{c01d}", "\u{1108}\u{1170}\u{11c0}", "\u{c01d}", "\u{1108}\u{1170}\u{11c0}"),
        ("\u{c01e}", "\u{c01e}", "\u{1108}\u{1170}\u{11c1}", "\u{c01e}",
        "\u{1108}\u{1170}\u{11c1}"), ("\u{c01f}", "\u{c01f}", "\u{1108}\u{1170}\u{11c2}",
        "\u{c01f}", "\u{1108}\u{1170}\u{11c2}"), ("\u{c020}", "\u{c020}", "\u{1108}\u{1171}",
        "\u{c020}", "\u{1108}\u{1171}"), ("\u{c021}", "\u{c021}", "\u{1108}\u{1171}\u{11a8}",
        "\u{c021}", "\u{1108}\u{1171}\u{11a8}"), ("\u{c022}", "\u{c022}",
        "\u{1108}\u{1171}\u{11a9}", "\u{c022}", "\u{1108}\u{1171}\u{11a9}"), ("\u{c023}",
        "\u{c023}", "\u{1108}\u{1171}\u{11aa}", "\u{c023}", "\u{1108}\u{1171}\u{11aa}"),
        ("\u{c024}", "\u{c024}", "\u{1108}\u{1171}\u{11ab}", "\u{c024}",
        "\u{1108}\u{1171}\u{11ab}"), ("\u{c025}", "\u{c025}", "\u{1108}\u{1171}\u{11ac}",
        "\u{c025}", "\u{1108}\u{1171}\u{11ac}"), ("\u{c026}", "\u{c026}",
        "\u{1108}\u{1171}\u{11ad}", "\u{c026}", "\u{1108}\u{1171}\u{11ad}"), ("\u{c027}",
        "\u{c027}", "\u{1108}\u{1171}\u{11ae}", "\u{c027}", "\u{1108}\u{1171}\u{11ae}"),
        ("\u{c028}", "\u{c028}", "\u{1108}\u{1171}\u{11af}", "\u{c028}",
        "\u{1108}\u{1171}\u{11af}"), ("\u{c029}", "\u{c029}", "\u{1108}\u{1171}\u{11b0}",
        "\u{c029}", "\u{1108}\u{1171}\u{11b0}"), ("\u{c02a}", "\u{c02a}",
        "\u{1108}\u{1171}\u{11b1}", "\u{c02a}", "\u{1108}\u{1171}\u{11b1}"), ("\u{c02b}",
        "\u{c02b}", "\u{1108}\u{1171}\u{11b2}", "\u{c02b}", "\u{1108}\u{1171}\u{11b2}"),
        ("\u{c02c}", "\u{c02c}", "\u{1108}\u{1171}\u{11b3}", "\u{c02c}",
        "\u{1108}\u{1171}\u{11b3}"), ("\u{c02d}", "\u{c02d}", "\u{1108}\u{1171}\u{11b4}",
        "\u{c02d}", "\u{1108}\u{1171}\u{11b4}"), ("\u{c02e}", "\u{c02e}",
        "\u{1108}\u{1171}\u{11b5}", "\u{c02e}", "\u{1108}\u{1171}\u{11b5}"), ("\u{c02f}",
        "\u{c02f}", "\u{1108}\u{1171}\u{11b6}", "\u{c02f}", "\u{1108}\u{1171}\u{11b6}"),
        ("\u{c030}", "\u{c030}", "\u{1108}\u{1171}\u{11b7}", "\u{c030}",
        "\u{1108}\u{1171}\u{11b7}"), ("\u{c031}", "\u{c031}", "\u{1108}\u{1171}\u{11b8}",
        "\u{c031}", "\u{1108}\u{1171}\u{11b8}"), ("\u{c032}", "\u{c032}",
        "\u{1108}\u{1171}\u{11b9}", "\u{c032}", "\u{1108}\u{1171}\u{11b9}"), ("\u{c033}",
        "\u{c033}", "\u{1108}\u{1171}\u{11ba}", "\u{c033}", "\u{1108}\u{1171}\u{11ba}"),
        ("\u{c034}", "\u{c034}", "\u{1108}\u{1171}\u{11bb}", "\u{c034}",
        "\u{1108}\u{1171}\u{11bb}"), ("\u{c035}", "\u{c035}", "\u{1108}\u{1171}\u{11bc}",
        "\u{c035}", "\u{1108}\u{1171}\u{11bc}"), ("\u{c036}", "\u{c036}",
        "\u{1108}\u{1171}\u{11bd}", "\u{c036}", "\u{1108}\u{1171}\u{11bd}"), ("\u{c037}",
        "\u{c037}", "\u{1108}\u{1171}\u{11be}", "\u{c037}", "\u{1108}\u{1171}\u{11be}"),
        ("\u{c038}", "\u{c038}", "\u{1108}\u{1171}\u{11bf}", "\u{c038}",
        "\u{1108}\u{1171}\u{11bf}"), ("\u{c039}", "\u{c039}", "\u{1108}\u{1171}\u{11c0}",
        "\u{c039}", "\u{1108}\u{1171}\u{11c0}"), ("\u{c03a}", "\u{c03a}",
        "\u{1108}\u{1171}\u{11c1}", "\u{c03a}", "\u{1108}\u{1171}\u{11c1}"), ("\u{c03b}",
        "\u{c03b}", "\u{1108}\u{1171}\u{11c2}", "\u{c03b}", "\u{1108}\u{1171}\u{11c2}"),
        ("\u{c03c}", "\u{c03c}", "\u{1108}\u{1172}", "\u{c03c}", "\u{1108}\u{1172}"), ("\u{c03d}",
        "\u{c03d}", "\u{1108}\u{1172}\u{11a8}", "\u{c03d}", "\u{1108}\u{1172}\u{11a8}"),
        ("\u{c03e}", "\u{c03e}", "\u{1108}\u{1172}\u{11a9}", "\u{c03e}",
        "\u{1108}\u{1172}\u{11a9}"), ("\u{c03f}", "\u{c03f}", "\u{1108}\u{1172}\u{11aa}",
        "\u{c03f}", "\u{1108}\u{1172}\u{11aa}"), ("\u{c040}", "\u{c040}",
        "\u{1108}\u{1172}\u{11ab}", "\u{c040}", "\u{1108}\u{1172}\u{11ab}"), ("\u{c041}",
        "\u{c041}", "\u{1108}\u{1172}\u{11ac}", "\u{c041}", "\u{1108}\u{1172}\u{11ac}"),
        ("\u{c042}", "\u{c042}", "\u{1108}\u{1172}\u{11ad}", "\u{c042}",
        "\u{1108}\u{1172}\u{11ad}"), ("\u{c043}", "\u{c043}", "\u{1108}\u{1172}\u{11ae}",
        "\u{c043}", "\u{1108}\u{1172}\u{11ae}"), ("\u{c044}", "\u{c044}",
        "\u{1108}\u{1172}\u{11af}", "\u{c044}", "\u{1108}\u{1172}\u{11af}"), ("\u{c045}",
        "\u{c045}", "\u{1108}\u{1172}\u{11b0}", "\u{c045}", "\u{1108}\u{1172}\u{11b0}"),
        ("\u{c046}", "\u{c046}", "\u{1108}\u{1172}\u{11b1}", "\u{c046}",
        "\u{1108}\u{1172}\u{11b1}"), ("\u{c047}", "\u{c047}", "\u{1108}\u{1172}\u{11b2}",
        "\u{c047}", "\u{1108}\u{1172}\u{11b2}"), ("\u{c048}", "\u{c048}",
        "\u{1108}\u{1172}\u{11b3}", "\u{c048}", "\u{1108}\u{1172}\u{11b3}"), ("\u{c049}",
        "\u{c049}", "\u{1108}\u{1172}\u{11b4}", "\u{c049}", "\u{1108}\u{1172}\u{11b4}"),
        ("\u{c04a}", "\u{c04a}", "\u{1108}\u{1172}\u{11b5}", "\u{c04a}",
        "\u{1108}\u{1172}\u{11b5}"), ("\u{c04b}", "\u{c04b}", "\u{1108}\u{1172}\u{11b6}",
        "\u{c04b}", "\u{1108}\u{1172}\u{11b6}"), ("\u{c04c}", "\u{c04c}",
        "\u{1108}\u{1172}\u{11b7}", "\u{c04c}", "\u{1108}\u{1172}\u{11b7}"), ("\u{c04d}",
        "\u{c04d}", "\u{1108}\u{1172}\u{11b8}", "\u{c04d}", "\u{1108}\u{1172}\u{11b8}"),
        ("\u{c04e}", "\u{c04e}", "\u{1108}\u{1172}\u{11b9}", "\u{c04e}",
        "\u{1108}\u{1172}\u{11b9}"), ("\u{c04f}", "\u{c04f}", "\u{1108}\u{1172}\u{11ba}",
        "\u{c04f}", "\u{1108}\u{1172}\u{11ba}"), ("\u{c050}", "\u{c050}",
        "\u{1108}\u{1172}\u{11bb}", "\u{c050}", "\u{1108}\u{1172}\u{11bb}"), ("\u{c051}",
        "\u{c051}", "\u{1108}\u{1172}\u{11bc}", "\u{c051}", "\u{1108}\u{1172}\u{11bc}"),
        ("\u{c052}", "\u{c052}", "\u{1108}\u{1172}\u{11bd}", "\u{c052}",
        "\u{1108}\u{1172}\u{11bd}"), ("\u{c053}", "\u{c053}", "\u{1108}\u{1172}\u{11be}",
        "\u{c053}", "\u{1108}\u{1172}\u{11be}"), ("\u{c054}", "\u{c054}",
        "\u{1108}\u{1172}\u{11bf}", "\u{c054}", "\u{1108}\u{1172}\u{11bf}"), ("\u{c055}",
        "\u{c055}", "\u{1108}\u{1172}\u{11c0}", "\u{c055}", "\u{1108}\u{1172}\u{11c0}"),
        ("\u{c056}", "\u{c056}", "\u{1108}\u{1172}\u{11c1}", "\u{c056}",
        "\u{1108}\u{1172}\u{11c1}"), ("\u{c057}", "\u{c057}", "\u{1108}\u{1172}\u{11c2}",
        "\u{c057}", "\u{1108}\u{1172}\u{11c2}"), ("\u{c058}", "\u{c058}", "\u{1108}\u{1173}",
        "\u{c058}", "\u{1108}\u{1173}"), ("\u{c059}", "\u{c059}", "\u{1108}\u{1173}\u{11a8}",
        "\u{c059}", "\u{1108}\u{1173}\u{11a8}"), ("\u{c05a}", "\u{c05a}",
        "\u{1108}\u{1173}\u{11a9}", "\u{c05a}", "\u{1108}\u{1173}\u{11a9}"), ("\u{c05b}",
        "\u{c05b}", "\u{1108}\u{1173}\u{11aa}", "\u{c05b}", "\u{1108}\u{1173}\u{11aa}"),
        ("\u{c05c}", "\u{c05c}", "\u{1108}\u{1173}\u{11ab}", "\u{c05c}",
        "\u{1108}\u{1173}\u{11ab}"), ("\u{c05d}", "\u{c05d}", "\u{1108}\u{1173}\u{11ac}",
        "\u{c05d}", "\u{1108}\u{1173}\u{11ac}"), ("\u{c05e}", "\u{c05e}",
        "\u{1108}\u{1173}\u{11ad}", "\u{c05e}", "\u{1108}\u{1173}\u{11ad}"), ("\u{c05f}",
        "\u{c05f}", "\u{1108}\u{1173}\u{11ae}", "\u{c05f}", "\u{1108}\u{1173}\u{11ae}"),
        ("\u{c060}", "\u{c060}", "\u{1108}\u{1173}\u{11af}", "\u{c060}",
        "\u{1108}\u{1173}\u{11af}"), ("\u{c061}", "\u{c061}", "\u{1108}\u{1173}\u{11b0}",
        "\u{c061}", "\u{1108}\u{1173}\u{11b0}"), ("\u{c062}", "\u{c062}",
        "\u{1108}\u{1173}\u{11b1}", "\u{c062}", "\u{1108}\u{1173}\u{11b1}"), ("\u{c063}",
        "\u{c063}", "\u{1108}\u{1173}\u{11b2}", "\u{c063}", "\u{1108}\u{1173}\u{11b2}"),
        ("\u{c064}", "\u{c064}", "\u{1108}\u{1173}\u{11b3}", "\u{c064}",
        "\u{1108}\u{1173}\u{11b3}"), ("\u{c065}", "\u{c065}", "\u{1108}\u{1173}\u{11b4}",
        "\u{c065}", "\u{1108}\u{1173}\u{11b4}"), ("\u{c066}", "\u{c066}",
        "\u{1108}\u{1173}\u{11b5}", "\u{c066}", "\u{1108}\u{1173}\u{11b5}"), ("\u{c067}",
        "\u{c067}", "\u{1108}\u{1173}\u{11b6}", "\u{c067}", "\u{1108}\u{1173}\u{11b6}"),
        ("\u{c068}", "\u{c068}", "\u{1108}\u{1173}\u{11b7}", "\u{c068}",
        "\u{1108}\u{1173}\u{11b7}"), ("\u{c069}", "\u{c069}", "\u{1108}\u{1173}\u{11b8}",
        "\u{c069}", "\u{1108}\u{1173}\u{11b8}"), ("\u{c06a}", "\u{c06a}",
        "\u{1108}\u{1173}\u{11b9}", "\u{c06a}", "\u{1108}\u{1173}\u{11b9}"), ("\u{c06b}",
        "\u{c06b}", "\u{1108}\u{1173}\u{11ba}", "\u{c06b}", "\u{1108}\u{1173}\u{11ba}"),
        ("\u{c06c}", "\u{c06c}", "\u{1108}\u{1173}\u{11bb}", "\u{c06c}",
        "\u{1108}\u{1173}\u{11bb}"), ("\u{c06d}", "\u{c06d}", "\u{1108}\u{1173}\u{11bc}",
        "\u{c06d}", "\u{1108}\u{1173}\u{11bc}"), ("\u{c06e}", "\u{c06e}",
        "\u{1108}\u{1173}\u{11bd}", "\u{c06e}", "\u{1108}\u{1173}\u{11bd}"), ("\u{c06f}",
        "\u{c06f}", "\u{1108}\u{1173}\u{11be}", "\u{c06f}", "\u{1108}\u{1173}\u{11be}"),
        ("\u{c070}", "\u{c070}", "\u{1108}\u{1173}\u{11bf}", "\u{c070}",
        "\u{1108}\u{1173}\u{11bf}"), ("\u{c071}", "\u{c071}", "\u{1108}\u{1173}\u{11c0}",
        "\u{c071}", "\u{1108}\u{1173}\u{11c0}"), ("\u{c072}", "\u{c072}",
        "\u{1108}\u{1173}\u{11c1}", "\u{c072}", "\u{1108}\u{1173}\u{11c1}"), ("\u{c073}",
        "\u{c073}", "\u{1108}\u{1173}\u{11c2}", "\u{c073}", "\u{1108}\u{1173}\u{11c2}"),
        ("\u{c074}", "\u{c074}", "\u{1108}\u{1174}", "\u{c074}", "\u{1108}\u{1174}"), ("\u{c075}",
        "\u{c075}", "\u{1108}\u{1174}\u{11a8}", "\u{c075}", "\u{1108}\u{1174}\u{11a8}"),
        ("\u{c076}", "\u{c076}", "\u{1108}\u{1174}\u{11a9}", "\u{c076}",
        "\u{1108}\u{1174}\u{11a9}"), ("\u{c077}", "\u{c077}", "\u{1108}\u{1174}\u{11aa}",
        "\u{c077}", "\u{1108}\u{1174}\u{11aa}"), ("\u{c078}", "\u{c078}",
        "\u{1108}\u{1174}\u{11ab}", "\u{c078}", "\u{1108}\u{1174}\u{11ab}"), ("\u{c079}",
        "\u{c079}", "\u{1108}\u{1174}\u{11ac}", "\u{c079}", "\u{1108}\u{1174}\u{11ac}"),
        ("\u{c07a}", "\u{c07a}", "\u{1108}\u{1174}\u{11ad}", "\u{c07a}",
        "\u{1108}\u{1174}\u{11ad}"), ("\u{c07b}", "\u{c07b}", "\u{1108}\u{1174}\u{11ae}",
        "\u{c07b}", "\u{1108}\u{1174}\u{11ae}"), ("\u{c07c}", "\u{c07c}",
        "\u{1108}\u{1174}\u{11af}", "\u{c07c}", "\u{1108}\u{1174}\u{11af}"), ("\u{c07d}",
        "\u{c07d}", "\u{1108}\u{1174}\u{11b0}", "\u{c07d}", "\u{1108}\u{1174}\u{11b0}"),
        ("\u{c07e}", "\u{c07e}", "\u{1108}\u{1174}\u{11b1}", "\u{c07e}",
        "\u{1108}\u{1174}\u{11b1}"), ("\u{c07f}", "\u{c07f}", "\u{1108}\u{1174}\u{11b2}",
        "\u{c07f}", "\u{1108}\u{1174}\u{11b2}"), ("\u{c080}", "\u{c080}",
        "\u{1108}\u{1174}\u{11b3}", "\u{c080}", "\u{1108}\u{1174}\u{11b3}"), ("\u{c081}",
        "\u{c081}", "\u{1108}\u{1174}\u{11b4}", "\u{c081}", "\u{1108}\u{1174}\u{11b4}"),
        ("\u{c082}", "\u{c082}", "\u{1108}\u{1174}\u{11b5}", "\u{c082}",
        "\u{1108}\u{1174}\u{11b5}"), ("\u{c083}", "\u{c083}", "\u{1108}\u{1174}\u{11b6}",
        "\u{c083}", "\u{1108}\u{1174}\u{11b6}"), ("\u{c084}", "\u{c084}",
        "\u{1108}\u{1174}\u{11b7}", "\u{c084}", "\u{1108}\u{1174}\u{11b7}"), ("\u{c085}",
        "\u{c085}", "\u{1108}\u{1174}\u{11b8}", "\u{c085}", "\u{1108}\u{1174}\u{11b8}"),
        ("\u{c086}", "\u{c086}", "\u{1108}\u{1174}\u{11b9}", "\u{c086}",
        "\u{1108}\u{1174}\u{11b9}"), ("\u{c087}", "\u{c087}", "\u{1108}\u{1174}\u{11ba}",
        "\u{c087}", "\u{1108}\u{1174}\u{11ba}"), ("\u{c088}", "\u{c088}",
        "\u{1108}\u{1174}\u{11bb}", "\u{c088}", "\u{1108}\u{1174}\u{11bb}"), ("\u{c089}",
        "\u{c089}", "\u{1108}\u{1174}\u{11bc}", "\u{c089}", "\u{1108}\u{1174}\u{11bc}"),
        ("\u{c08a}", "\u{c08a}", "\u{1108}\u{1174}\u{11bd}", "\u{c08a}",
        "\u{1108}\u{1174}\u{11bd}"), ("\u{c08b}", "\u{c08b}", "\u{1108}\u{1174}\u{11be}",
        "\u{c08b}", "\u{1108}\u{1174}\u{11be}"), ("\u{c08c}", "\u{c08c}",
        "\u{1108}\u{1174}\u{11bf}", "\u{c08c}", "\u{1108}\u{1174}\u{11bf}"), ("\u{c08d}",
        "\u{c08d}", "\u{1108}\u{1174}\u{11c0}", "\u{c08d}", "\u{1108}\u{1174}\u{11c0}"),
        ("\u{c08e}", "\u{c08e}", "\u{1108}\u{1174}\u{11c1}", "\u{c08e}",
        "\u{1108}\u{1174}\u{11c1}"), ("\u{c08f}", "\u{c08f}", "\u{1108}\u{1174}\u{11c2}",
        "\u{c08f}", "\u{1108}\u{1174}\u{11c2}"), ("\u{c090}", "\u{c090}", "\u{1108}\u{1175}",
        "\u{c090}", "\u{1108}\u{1175}"), ("\u{c091}", "\u{c091}", "\u{1108}\u{1175}\u{11a8}",
        "\u{c091}", "\u{1108}\u{1175}\u{11a8}"), ("\u{c092}", "\u{c092}",
        "\u{1108}\u{1175}\u{11a9}", "\u{c092}", "\u{1108}\u{1175}\u{11a9}"), ("\u{c093}",
        "\u{c093}", "\u{1108}\u{1175}\u{11aa}", "\u{c093}", "\u{1108}\u{1175}\u{11aa}"),
        ("\u{c094}", "\u{c094}", "\u{1108}\u{1175}\u{11ab}", "\u{c094}",
        "\u{1108}\u{1175}\u{11ab}"), ("\u{c095}", "\u{c095}", "\u{1108}\u{1175}\u{11ac}",
        "\u{c095}", "\u{1108}\u{1175}\u{11ac}"), ("\u{c096}", "\u{c096}",
        "\u{1108}\u{1175}\u{11ad}", "\u{c096}", "\u{1108}\u{1175}\u{11ad}"), ("\u{c097}",
        "\u{c097}", "\u{1108}\u{1175}\u{11ae}", "\u{c097}", "\u{1108}\u{1175}\u{11ae}"),
        ("\u{c098}", "\u{c098}", "\u{1108}\u{1175}\u{11af}", "\u{c098}",
        "\u{1108}\u{1175}\u{11af}"), ("\u{c099}", "\u{c099}", "\u{1108}\u{1175}\u{11b0}",
        "\u{c099}", "\u{1108}\u{1175}\u{11b0}"), ("\u{c09a}", "\u{c09a}",
        "\u{1108}\u{1175}\u{11b1}", "\u{c09a}", "\u{1108}\u{1175}\u{11b1}"), ("\u{c09b}",
        "\u{c09b}", "\u{1108}\u{1175}\u{11b2}", "\u{c09b}", "\u{1108}\u{1175}\u{11b2}"),
        ("\u{c09c}", "\u{c09c}", "\u{1108}\u{1175}\u{11b3}", "\u{c09c}",
        "\u{1108}\u{1175}\u{11b3}"), ("\u{c09d}", "\u{c09d}", "\u{1108}\u{1175}\u{11b4}",
        "\u{c09d}", "\u{1108}\u{1175}\u{11b4}"), ("\u{c09e}", "\u{c09e}",
        "\u{1108}\u{1175}\u{11b5}", "\u{c09e}", "\u{1108}\u{1175}\u{11b5}"), ("\u{c09f}",
        "\u{c09f}", "\u{1108}\u{1175}\u{11b6}", "\u{c09f}", "\u{1108}\u{1175}\u{11b6}"),
        ("\u{c0a0}", "\u{c0a0}", "\u{1108}\u{1175}\u{11b7}", "\u{c0a0}",
        "\u{1108}\u{1175}\u{11b7}"), ("\u{c0a1}", "\u{c0a1}", "\u{1108}\u{1175}\u{11b8}",
        "\u{c0a1}", "\u{1108}\u{1175}\u{11b8}"), ("\u{c0a2}", "\u{c0a2}",
        "\u{1108}\u{1175}\u{11b9}", "\u{c0a2}", "\u{1108}\u{1175}\u{11b9}"), ("\u{c0a3}",
        "\u{c0a3}", "\u{1108}\u{1175}\u{11ba}", "\u{c0a3}", "\u{1108}\u{1175}\u{11ba}"),
        ("\u{c0a4}", "\u{c0a4}", "\u{1108}\u{1175}\u{11bb}", "\u{c0a4}",
        "\u{1108}\u{1175}\u{11bb}"), ("\u{c0a5}", "\u{c0a5}", "\u{1108}\u{1175}\u{11bc}",
        "\u{c0a5}", "\u{1108}\u{1175}\u{11bc}"), ("\u{c0a6}", "\u{c0a6}",
        "\u{1108}\u{1175}\u{11bd}", "\u{c0a6}", "\u{1108}\u{1175}\u{11bd}"), ("\u{c0a7}",
        "\u{c0a7}", "\u{1108}\u{1175}\u{11be}", "\u{c0a7}", "\u{1108}\u{1175}\u{11be}"),
        ("\u{c0a8}", "\u{c0a8}", "\u{1108}\u{1175}\u{11bf}", "\u{c0a8}",
        "\u{1108}\u{1175}\u{11bf}"), ("\u{c0a9}", "\u{c0a9}", "\u{1108}\u{1175}\u{11c0}",
        "\u{c0a9}", "\u{1108}\u{1175}\u{11c0}"), ("\u{c0aa}", "\u{c0aa}",
        "\u{1108}\u{1175}\u{11c1}", "\u{c0aa}", "\u{1108}\u{1175}\u{11c1}"), ("\u{c0ab}",
        "\u{c0ab}", "\u{1108}\u{1175}\u{11c2}", "\u{c0ab}", "\u{1108}\u{1175}\u{11c2}"),
        ("\u{c0ac}", "\u{c0ac}", "\u{1109}\u{1161}", "\u{c0ac}", "\u{1109}\u{1161}"), ("\u{c0ad}",
        "\u{c0ad}", "\u{1109}\u{1161}\u{11a8}", "\u{c0ad}", "\u{1109}\u{1161}\u{11a8}"),
        ("\u{c0ae}", "\u{c0ae}", "\u{1109}\u{1161}\u{11a9}", "\u{c0ae}",
        "\u{1109}\u{1161}\u{11a9}"), ("\u{c0af}", "\u{c0af}", "\u{1109}\u{1161}\u{11aa}",
        "\u{c0af}", "\u{1109}\u{1161}\u{11aa}"), ("\u{c0b0}", "\u{c0b0}",
        "\u{1109}\u{1161}\u{11ab}", "\u{c0b0}", "\u{1109}\u{1161}\u{11ab}"), ("\u{c0b1}",
        "\u{c0b1}", "\u{1109}\u{1161}\u{11ac}", "\u{c0b1}", "\u{1109}\u{1161}\u{11ac}"),
        ("\u{c0b2}", "\u{c0b2}", "\u{1109}\u{1161}\u{11ad}", "\u{c0b2}",
        "\u{1109}\u{1161}\u{11ad}"), ("\u{c0b3}", "\u{c0b3}", "\u{1109}\u{1161}\u{11ae}",
        "\u{c0b3}", "\u{1109}\u{1161}\u{11ae}"), ("\u{c0b4}", "\u{c0b4}",
        "\u{1109}\u{1161}\u{11af}", "\u{c0b4}", "\u{1109}\u{1161}\u{11af}"), ("\u{c0b5}",
        "\u{c0b5}", "\u{1109}\u{1161}\u{11b0}", "\u{c0b5}", "\u{1109}\u{1161}\u{11b0}"),
        ("\u{c0b6}", "\u{c0b6}", "\u{1109}\u{1161}\u{11b1}", "\u{c0b6}",
        "\u{1109}\u{1161}\u{11b1}"), ("\u{c0b7}", "\u{c0b7}", "\u{1109}\u{1161}\u{11b2}",
        "\u{c0b7}", "\u{1109}\u{1161}\u{11b2}"), ("\u{c0b8}", "\u{c0b8}",
        "\u{1109}\u{1161}\u{11b3}", "\u{c0b8}", "\u{1109}\u{1161}\u{11b3}"), ("\u{c0b9}",
        "\u{c0b9}", "\u{1109}\u{1161}\u{11b4}", "\u{c0b9}", "\u{1109}\u{1161}\u{11b4}"),
        ("\u{c0ba}", "\u{c0ba}", "\u{1109}\u{1161}\u{11b5}", "\u{c0ba}",
        "\u{1109}\u{1161}\u{11b5}"), ("\u{c0bb}", "\u{c0bb}", "\u{1109}\u{1161}\u{11b6}",
        "\u{c0bb}", "\u{1109}\u{1161}\u{11b6}"), ("\u{c0bc}", "\u{c0bc}",
        "\u{1109}\u{1161}\u{11b7}", "\u{c0bc}", "\u{1109}\u{1161}\u{11b7}"), ("\u{c0bd}",
        "\u{c0bd}", "\u{1109}\u{1161}\u{11b8}", "\u{c0bd}", "\u{1109}\u{1161}\u{11b8}"),
        ("\u{c0be}", "\u{c0be}", "\u{1109}\u{1161}\u{11b9}", "\u{c0be}",
        "\u{1109}\u{1161}\u{11b9}"), ("\u{c0bf}", "\u{c0bf}", "\u{1109}\u{1161}\u{11ba}",
        "\u{c0bf}", "\u{1109}\u{1161}\u{11ba}"), ("\u{c0c0}", "\u{c0c0}",
        "\u{1109}\u{1161}\u{11bb}", "\u{c0c0}", "\u{1109}\u{1161}\u{11bb}"), ("\u{c0c1}",
        "\u{c0c1}", "\u{1109}\u{1161}\u{11bc}", "\u{c0c1}", "\u{1109}\u{1161}\u{11bc}"),
        ("\u{c0c2}", "\u{c0c2}", "\u{1109}\u{1161}\u{11bd}", "\u{c0c2}",
        "\u{1109}\u{1161}\u{11bd}"), ("\u{c0c3}", "\u{c0c3}", "\u{1109}\u{1161}\u{11be}",
        "\u{c0c3}", "\u{1109}\u{1161}\u{11be}"), ("\u{c0c4}", "\u{c0c4}",
        "\u{1109}\u{1161}\u{11bf}", "\u{c0c4}", "\u{1109}\u{1161}\u{11bf}"), ("\u{c0c5}",
        "\u{c0c5}", "\u{1109}\u{1161}\u{11c0}", "\u{c0c5}", "\u{1109}\u{1161}\u{11c0}"),
        ("\u{c0c6}", "\u{c0c6}", "\u{1109}\u{1161}\u{11c1}", "\u{c0c6}",
        "\u{1109}\u{1161}\u{11c1}"), ("\u{c0c7}", "\u{c0c7}", "\u{1109}\u{1161}\u{11c2}",
        "\u{c0c7}", "\u{1109}\u{1161}\u{11c2}"), ("\u{c0c8}", "\u{c0c8}", "\u{1109}\u{1162}",
        "\u{c0c8}", "\u{1109}\u{1162}"), ("\u{c0c9}", "\u{c0c9}", "\u{1109}\u{1162}\u{11a8}",
        "\u{c0c9}", "\u{1109}\u{1162}\u{11a8}"), ("\u{c0ca}", "\u{c0ca}",
        "\u{1109}\u{1162}\u{11a9}", "\u{c0ca}", "\u{1109}\u{1162}\u{11a9}"), ("\u{c0cb}",
        "\u{c0cb}", "\u{1109}\u{1162}\u{11aa}", "\u{c0cb}", "\u{1109}\u{1162}\u{11aa}"),
        ("\u{c0cc}", "\u{c0cc}", "\u{1109}\u{1162}\u{11ab}", "\u{c0cc}",
        "\u{1109}\u{1162}\u{11ab}"), ("\u{c0cd}", "\u{c0cd}", "\u{1109}\u{1162}\u{11ac}",
        "\u{c0cd}", "\u{1109}\u{1162}\u{11ac}"), ("\u{c0ce}", "\u{c0ce}",
        "\u{1109}\u{1162}\u{11ad}", "\u{c0ce}", "\u{1109}\u{1162}\u{11ad}"), ("\u{c0cf}",
        "\u{c0cf}", "\u{1109}\u{1162}\u{11ae}", "\u{c0cf}", "\u{1109}\u{1162}\u{11ae}"),
        ("\u{c0d0}", "\u{c0d0}", "\u{1109}\u{1162}\u{11af}", "\u{c0d0}",
        "\u{1109}\u{1162}\u{11af}"), ("\u{c0d1}", "\u{c0d1}", "\u{1109}\u{1162}\u{11b0}",
        "\u{c0d1}", "\u{1109}\u{1162}\u{11b0}"), ("\u{c0d2}", "\u{c0d2}",
        "\u{1109}\u{1162}\u{11b1}", "\u{c0d2}", "\u{1109}\u{1162}\u{11b1}"), ("\u{c0d3}",
        "\u{c0d3}", "\u{1109}\u{1162}\u{11b2}", "\u{c0d3}", "\u{1109}\u{1162}\u{11b2}"),
        ("\u{c0d4}", "\u{c0d4}", "\u{1109}\u{1162}\u{11b3}", "\u{c0d4}",
        "\u{1109}\u{1162}\u{11b3}"), ("\u{c0d5}", "\u{c0d5}", "\u{1109}\u{1162}\u{11b4}",
        "\u{c0d5}", "\u{1109}\u{1162}\u{11b4}"), ("\u{c0d6}", "\u{c0d6}",
        "\u{1109}\u{1162}\u{11b5}", "\u{c0d6}", "\u{1109}\u{1162}\u{11b5}"), ("\u{c0d7}",
        "\u{c0d7}", "\u{1109}\u{1162}\u{11b6}", "\u{c0d7}", "\u{1109}\u{1162}\u{11b6}"),
        ("\u{c0d8}", "\u{c0d8}", "\u{1109}\u{1162}\u{11b7}", "\u{c0d8}",
        "\u{1109}\u{1162}\u{11b7}"), ("\u{c0d9}", "\u{c0d9}", "\u{1109}\u{1162}\u{11b8}",
        "\u{c0d9}", "\u{1109}\u{1162}\u{11b8}"), ("\u{c0da}", "\u{c0da}",
        "\u{1109}\u{1162}\u{11b9}", "\u{c0da}", "\u{1109}\u{1162}\u{11b9}"), ("\u{c0db}",
        "\u{c0db}", "\u{1109}\u{1162}\u{11ba}", "\u{c0db}", "\u{1109}\u{1162}\u{11ba}"),
        ("\u{c0dc}", "\u{c0dc}", "\u{1109}\u{1162}\u{11bb}", "\u{c0dc}",
        "\u{1109}\u{1162}\u{11bb}"), ("\u{c0dd}", "\u{c0dd}", "\u{1109}\u{1162}\u{11bc}",
        "\u{c0dd}", "\u{1109}\u{1162}\u{11bc}"), ("\u{c0de}", "\u{c0de}",
        "\u{1109}\u{1162}\u{11bd}", "\u{c0de}", "\u{1109}\u{1162}\u{11bd}"), ("\u{c0df}",
        "\u{c0df}", "\u{1109}\u{1162}\u{11be}", "\u{c0df}", "\u{1109}\u{1162}\u{11be}"),
        ("\u{c0e0}", "\u{c0e0}", "\u{1109}\u{1162}\u{11bf}", "\u{c0e0}",
        "\u{1109}\u{1162}\u{11bf}"), ("\u{c0e1}", "\u{c0e1}", "\u{1109}\u{1162}\u{11c0}",
        "\u{c0e1}", "\u{1109}\u{1162}\u{11c0}"), ("\u{c0e2}", "\u{c0e2}",
        "\u{1109}\u{1162}\u{11c1}", "\u{c0e2}", "\u{1109}\u{1162}\u{11c1}"), ("\u{c0e3}",
        "\u{c0e3}", "\u{1109}\u{1162}\u{11c2}", "\u{c0e3}", "\u{1109}\u{1162}\u{11c2}"),
        ("\u{c0e4}", "\u{c0e4}", "\u{1109}\u{1163}", "\u{c0e4}", "\u{1109}\u{1163}"), ("\u{c0e5}",
        "\u{c0e5}", "\u{1109}\u{1163}\u{11a8}", "\u{c0e5}", "\u{1109}\u{1163}\u{11a8}"),
        ("\u{c0e6}", "\u{c0e6}", "\u{1109}\u{1163}\u{11a9}", "\u{c0e6}",
        "\u{1109}\u{1163}\u{11a9}"), ("\u{c0e7}", "\u{c0e7}", "\u{1109}\u{1163}\u{11aa}",
        "\u{c0e7}", "\u{1109}\u{1163}\u{11aa}"), ("\u{c0e8}", "\u{c0e8}",
        "\u{1109}\u{1163}\u{11ab}", "\u{c0e8}", "\u{1109}\u{1163}\u{11ab}"), ("\u{c0e9}",
        "\u{c0e9}", "\u{1109}\u{1163}\u{11ac}", "\u{c0e9}", "\u{1109}\u{1163}\u{11ac}"),
        ("\u{c0ea}", "\u{c0ea}", "\u{1109}\u{1163}\u{11ad}", "\u{c0ea}",
        "\u{1109}\u{1163}\u{11ad}"), ("\u{c0eb}", "\u{c0eb}", "\u{1109}\u{1163}\u{11ae}",
        "\u{c0eb}", "\u{1109}\u{1163}\u{11ae}"), ("\u{c0ec}", "\u{c0ec}",
        "\u{1109}\u{1163}\u{11af}", "\u{c0ec}", "\u{1109}\u{1163}\u{11af}"), ("\u{c0ed}",
        "\u{c0ed}", "\u{1109}\u{1163}\u{11b0}", "\u{c0ed}", "\u{1109}\u{1163}\u{11b0}"),
        ("\u{c0ee}", "\u{c0ee}", "\u{1109}\u{1163}\u{11b1}", "\u{c0ee}",
        "\u{1109}\u{1163}\u{11b1}"), ("\u{c0ef}", "\u{c0ef}", "\u{1109}\u{1163}\u{11b2}",
        "\u{c0ef}", "\u{1109}\u{1163}\u{11b2}"), ("\u{c0f0}", "\u{c0f0}",
        "\u{1109}\u{1163}\u{11b3}", "\u{c0f0}", "\u{1109}\u{1163}\u{11b3}"), ("\u{c0f1}",
        "\u{c0f1}", "\u{1109}\u{1163}\u{11b4}", "\u{c0f1}", "\u{1109}\u{1163}\u{11b4}"),
        ("\u{c0f2}", "\u{c0f2}", "\u{1109}\u{1163}\u{11b5}", "\u{c0f2}",
        "\u{1109}\u{1163}\u{11b5}"), ("\u{c0f3}", "\u{c0f3}", "\u{1109}\u{1163}\u{11b6}",
        "\u{c0f3}", "\u{1109}\u{1163}\u{11b6}"), ("\u{c0f4}", "\u{c0f4}",
        "\u{1109}\u{1163}\u{11b7}", "\u{c0f4}", "\u{1109}\u{1163}\u{11b7}"), ("\u{c0f5}",
        "\u{c0f5}", "\u{1109}\u{1163}\u{11b8}", "\u{c0f5}", "\u{1109}\u{1163}\u{11b8}"),
        ("\u{c0f6}", "\u{c0f6}", "\u{1109}\u{1163}\u{11b9}", "\u{c0f6}",
        "\u{1109}\u{1163}\u{11b9}"), ("\u{c0f7}", "\u{c0f7}", "\u{1109}\u{1163}\u{11ba}",
        "\u{c0f7}", "\u{1109}\u{1163}\u{11ba}"), ("\u{c0f8}", "\u{c0f8}",
        "\u{1109}\u{1163}\u{11bb}", "\u{c0f8}", "\u{1109}\u{1163}\u{11bb}"), ("\u{c0f9}",
        "\u{c0f9}", "\u{1109}\u{1163}\u{11bc}", "\u{c0f9}", "\u{1109}\u{1163}\u{11bc}"),
        ("\u{c0fa}", "\u{c0fa}", "\u{1109}\u{1163}\u{11bd}", "\u{c0fa}",
        "\u{1109}\u{1163}\u{11bd}"), ("\u{c0fb}", "\u{c0fb}", "\u{1109}\u{1163}\u{11be}",
        "\u{c0fb}", "\u{1109}\u{1163}\u{11be}"), ("\u{c0fc}", "\u{c0fc}",
        "\u{1109}\u{1163}\u{11bf}", "\u{c0fc}", "\u{1109}\u{1163}\u{11bf}"), ("\u{c0fd}",
        "\u{c0fd}", "\u{1109}\u{1163}\u{11c0}", "\u{c0fd}", "\u{1109}\u{1163}\u{11c0}"),
        ("\u{c0fe}", "\u{c0fe}", "\u{1109}\u{1163}\u{11c1}", "\u{c0fe}",
        "\u{1109}\u{1163}\u{11c1}"), ("\u{c0ff}", "\u{c0ff}", "\u{1109}\u{1163}\u{11c2}",
        "\u{c0ff}", "\u{1109}\u{1163}\u{11c2}"), ("\u{c100}", "\u{c100}", "\u{1109}\u{1164}",
        "\u{c100}", "\u{1109}\u{1164}"), ("\u{c101}", "\u{c101}", "\u{1109}\u{1164}\u{11a8}",
        "\u{c101}", "\u{1109}\u{1164}\u{11a8}"), ("\u{c102}", "\u{c102}",
        "\u{1109}\u{1164}\u{11a9}", "\u{c102}", "\u{1109}\u{1164}\u{11a9}"), ("\u{c103}",
        "\u{c103}", "\u{1109}\u{1164}\u{11aa}", "\u{c103}", "\u{1109}\u{1164}\u{11aa}"),
        ("\u{c104}", "\u{c104}", "\u{1109}\u{1164}\u{11ab}", "\u{c104}",
        "\u{1109}\u{1164}\u{11ab}"), ("\u{c105}", "\u{c105}", "\u{1109}\u{1164}\u{11ac}",
        "\u{c105}", "\u{1109}\u{1164}\u{11ac}"), ("\u{c106}", "\u{c106}",
        "\u{1109}\u{1164}\u{11ad}", "\u{c106}", "\u{1109}\u{1164}\u{11ad}"), ("\u{c107}",
        "\u{c107}", "\u{1109}\u{1164}\u{11ae}", "\u{c107}", "\u{1109}\u{1164}\u{11ae}"),
        ("\u{c108}", "\u{c108}", "\u{1109}\u{1164}\u{11af}", "\u{c108}",
        "\u{1109}\u{1164}\u{11af}"), ("\u{c109}", "\u{c109}", "\u{1109}\u{1164}\u{11b0}",
        "\u{c109}", "\u{1109}\u{1164}\u{11b0}"), ("\u{c10a}", "\u{c10a}",
        "\u{1109}\u{1164}\u{11b1}", "\u{c10a}", "\u{1109}\u{1164}\u{11b1}"), ("\u{c10b}",
        "\u{c10b}", "\u{1109}\u{1164}\u{11b2}", "\u{c10b}", "\u{1109}\u{1164}\u{11b2}"),
        ("\u{c10c}", "\u{c10c}", "\u{1109}\u{1164}\u{11b3}", "\u{c10c}",
        "\u{1109}\u{1164}\u{11b3}"), ("\u{c10d}", "\u{c10d}", "\u{1109}\u{1164}\u{11b4}",
        "\u{c10d}", "\u{1109}\u{1164}\u{11b4}"), ("\u{c10e}", "\u{c10e}",
        "\u{1109}\u{1164}\u{11b5}", "\u{c10e}", "\u{1109}\u{1164}\u{11b5}"), ("\u{c10f}",
        "\u{c10f}", "\u{1109}\u{1164}\u{11b6}", "\u{c10f}", "\u{1109}\u{1164}\u{11b6}"),
        ("\u{c110}", "\u{c110}", "\u{1109}\u{1164}\u{11b7}", "\u{c110}",
        "\u{1109}\u{1164}\u{11b7}"), ("\u{c111}", "\u{c111}", "\u{1109}\u{1164}\u{11b8}",
        "\u{c111}", "\u{1109}\u{1164}\u{11b8}"), ("\u{c112}", "\u{c112}",
        "\u{1109}\u{1164}\u{11b9}", "\u{c112}", "\u{1109}\u{1164}\u{11b9}"), ("\u{c113}",
        "\u{c113}", "\u{1109}\u{1164}\u{11ba}", "\u{c113}", "\u{1109}\u{1164}\u{11ba}"),
        ("\u{c114}", "\u{c114}", "\u{1109}\u{1164}\u{11bb}", "\u{c114}",
        "\u{1109}\u{1164}\u{11bb}"), ("\u{c115}", "\u{c115}", "\u{1109}\u{1164}\u{11bc}",
        "\u{c115}", "\u{1109}\u{1164}\u{11bc}"), ("\u{c116}", "\u{c116}",
        "\u{1109}\u{1164}\u{11bd}", "\u{c116}", "\u{1109}\u{1164}\u{11bd}"), ("\u{c117}",
        "\u{c117}", "\u{1109}\u{1164}\u{11be}", "\u{c117}", "\u{1109}\u{1164}\u{11be}"),
        ("\u{c118}", "\u{c118}", "\u{1109}\u{1164}\u{11bf}", "\u{c118}",
        "\u{1109}\u{1164}\u{11bf}"), ("\u{c119}", "\u{c119}", "\u{1109}\u{1164}\u{11c0}",
        "\u{c119}", "\u{1109}\u{1164}\u{11c0}"), ("\u{c11a}", "\u{c11a}",
        "\u{1109}\u{1164}\u{11c1}", "\u{c11a}", "\u{1109}\u{1164}\u{11c1}"), ("\u{c11b}",
        "\u{c11b}", "\u{1109}\u{1164}\u{11c2}", "\u{c11b}", "\u{1109}\u{1164}\u{11c2}"),
        ("\u{c11c}", "\u{c11c}", "\u{1109}\u{1165}", "\u{c11c}", "\u{1109}\u{1165}"), ("\u{c11d}",
        "\u{c11d}", "\u{1109}\u{1165}\u{11a8}", "\u{c11d}", "\u{1109}\u{1165}\u{11a8}"),
        ("\u{c11e}", "\u{c11e}", "\u{1109}\u{1165}\u{11a9}", "\u{c11e}",
        "\u{1109}\u{1165}\u{11a9}"), ("\u{c11f}", "\u{c11f}", "\u{1109}\u{1165}\u{11aa}",
        "\u{c11f}", "\u{1109}\u{1165}\u{11aa}"), ("\u{c120}", "\u{c120}",
        "\u{1109}\u{1165}\u{11ab}", "\u{c120}", "\u{1109}\u{1165}\u{11ab}"), ("\u{c121}",
        "\u{c121}", "\u{1109}\u{1165}\u{11ac}", "\u{c121}", "\u{1109}\u{1165}\u{11ac}"),
        ("\u{c122}", "\u{c122}", "\u{1109}\u{1165}\u{11ad}", "\u{c122}",
        "\u{1109}\u{1165}\u{11ad}"), ("\u{c123}", "\u{c123}", "\u{1109}\u{1165}\u{11ae}",
        "\u{c123}", "\u{1109}\u{1165}\u{11ae}"), ("\u{c124}", "\u{c124}",
        "\u{1109}\u{1165}\u{11af}", "\u{c124}", "\u{1109}\u{1165}\u{11af}"), ("\u{c125}",
        "\u{c125}", "\u{1109}\u{1165}\u{11b0}", "\u{c125}", "\u{1109}\u{1165}\u{11b0}"),
        ("\u{c126}", "\u{c126}", "\u{1109}\u{1165}\u{11b1}", "\u{c126}",
        "\u{1109}\u{1165}\u{11b1}"), ("\u{c127}", "\u{c127}", "\u{1109}\u{1165}\u{11b2}",
        "\u{c127}", "\u{1109}\u{1165}\u{11b2}"), ("\u{c128}", "\u{c128}",
        "\u{1109}\u{1165}\u{11b3}", "\u{c128}", "\u{1109}\u{1165}\u{11b3}"), ("\u{c129}",
        "\u{c129}", "\u{1109}\u{1165}\u{11b4}", "\u{c129}", "\u{1109}\u{1165}\u{11b4}"),
        ("\u{c12a}", "\u{c12a}", "\u{1109}\u{1165}\u{11b5}", "\u{c12a}",
        "\u{1109}\u{1165}\u{11b5}"), ("\u{c12b}", "\u{c12b}", "\u{1109}\u{1165}\u{11b6}",
        "\u{c12b}", "\u{1109}\u{1165}\u{11b6}"), ("\u{c12c}", "\u{c12c}",
        "\u{1109}\u{1165}\u{11b7}", "\u{c12c}", "\u{1109}\u{1165}\u{11b7}"), ("\u{c12d}",
        "\u{c12d}", "\u{1109}\u{1165}\u{11b8}", "\u{c12d}", "\u{1109}\u{1165}\u{11b8}"),
        ("\u{c12e}", "\u{c12e}", "\u{1109}\u{1165}\u{11b9}", "\u{c12e}",
        "\u{1109}\u{1165}\u{11b9}"), ("\u{c12f}", "\u{c12f}", "\u{1109}\u{1165}\u{11ba}",
        "\u{c12f}", "\u{1109}\u{1165}\u{11ba}"), ("\u{c130}", "\u{c130}",
        "\u{1109}\u{1165}\u{11bb}", "\u{c130}", "\u{1109}\u{1165}\u{11bb}"), ("\u{c131}",
        "\u{c131}", "\u{1109}\u{1165}\u{11bc}", "\u{c131}", "\u{1109}\u{1165}\u{11bc}"),
        ("\u{c132}", "\u{c132}", "\u{1109}\u{1165}\u{11bd}", "\u{c132}",
        "\u{1109}\u{1165}\u{11bd}"), ("\u{c133}", "\u{c133}", "\u{1109}\u{1165}\u{11be}",
        "\u{c133}", "\u{1109}\u{1165}\u{11be}"), ("\u{c134}", "\u{c134}",
        "\u{1109}\u{1165}\u{11bf}", "\u{c134}", "\u{1109}\u{1165}\u{11bf}"), ("\u{c135}",
        "\u{c135}", "\u{1109}\u{1165}\u{11c0}", "\u{c135}", "\u{1109}\u{1165}\u{11c0}"),
        ("\u{c136}", "\u{c136}", "\u{1109}\u{1165}\u{11c1}", "\u{c136}",
        "\u{1109}\u{1165}\u{11c1}"), ("\u{c137}", "\u{c137}", "\u{1109}\u{1165}\u{11c2}",
        "\u{c137}", "\u{1109}\u{1165}\u{11c2}"), ("\u{c138}", "\u{c138}", "\u{1109}\u{1166}",
        "\u{c138}", "\u{1109}\u{1166}"), ("\u{c139}", "\u{c139}", "\u{1109}\u{1166}\u{11a8}",
        "\u{c139}", "\u{1109}\u{1166}\u{11a8}"), ("\u{c13a}", "\u{c13a}",
        "\u{1109}\u{1166}\u{11a9}", "\u{c13a}", "\u{1109}\u{1166}\u{11a9}"), ("\u{c13b}",
        "\u{c13b}", "\u{1109}\u{1166}\u{11aa}", "\u{c13b}", "\u{1109}\u{1166}\u{11aa}"),
        ("\u{c13c}", "\u{c13c}", "\u{1109}\u{1166}\u{11ab}", "\u{c13c}",
        "\u{1109}\u{1166}\u{11ab}"), ("\u{c13d}", "\u{c13d}", "\u{1109}\u{1166}\u{11ac}",
        "\u{c13d}", "\u{1109}\u{1166}\u{11ac}"), ("\u{c13e}", "\u{c13e}",
        "\u{1109}\u{1166}\u{11ad}", "\u{c13e}", "\u{1109}\u{1166}\u{11ad}"), ("\u{c13f}",
        "\u{c13f}", "\u{1109}\u{1166}\u{11ae}", "\u{c13f}", "\u{1109}\u{1166}\u{11ae}"),
        ("\u{c140}", "\u{c140}", "\u{1109}\u{1166}\u{11af}", "\u{c140}",
        "\u{1109}\u{1166}\u{11af}"), ("\u{c141}", "\u{c141}", "\u{1109}\u{1166}\u{11b0}",
        "\u{c141}", "\u{1109}\u{1166}\u{11b0}"), ("\u{c142}", "\u{c142}",
        "\u{1109}\u{1166}\u{11b1}", "\u{c142}", "\u{1109}\u{1166}\u{11b1}"), ("\u{c143}",
        "\u{c143}", "\u{1109}\u{1166}\u{11b2}", "\u{c143}", "\u{1109}\u{1166}\u{11b2}"),
        ("\u{c144}", "\u{c144}", "\u{1109}\u{1166}\u{11b3}", "\u{c144}",
        "\u{1109}\u{1166}\u{11b3}"), ("\u{c145}", "\u{c145}", "\u{1109}\u{1166}\u{11b4}",
        "\u{c145}", "\u{1109}\u{1166}\u{11b4}"), ("\u{c146}", "\u{c146}",
        "\u{1109}\u{1166}\u{11b5}", "\u{c146}", "\u{1109}\u{1166}\u{11b5}"), ("\u{c147}",
        "\u{c147}", "\u{1109}\u{1166}\u{11b6}", "\u{c147}", "\u{1109}\u{1166}\u{11b6}"),
        ("\u{c148}", "\u{c148}", "\u{1109}\u{1166}\u{11b7}", "\u{c148}",
        "\u{1109}\u{1166}\u{11b7}"), ("\u{c149}", "\u{c149}", "\u{1109}\u{1166}\u{11b8}",
        "\u{c149}", "\u{1109}\u{1166}\u{11b8}"), ("\u{c14a}", "\u{c14a}",
        "\u{1109}\u{1166}\u{11b9}", "\u{c14a}", "\u{1109}\u{1166}\u{11b9}"), ("\u{c14b}",
        "\u{c14b}", "\u{1109}\u{1166}\u{11ba}", "\u{c14b}", "\u{1109}\u{1166}\u{11ba}"),
        ("\u{c14c}", "\u{c14c}", "\u{1109}\u{1166}\u{11bb}", "\u{c14c}",
        "\u{1109}\u{1166}\u{11bb}"), ("\u{c14d}", "\u{c14d}", "\u{1109}\u{1166}\u{11bc}",
        "\u{c14d}", "\u{1109}\u{1166}\u{11bc}"), ("\u{c14e}", "\u{c14e}",
        "\u{1109}\u{1166}\u{11bd}", "\u{c14e}", "\u{1109}\u{1166}\u{11bd}"), ("\u{c14f}",
        "\u{c14f}", "\u{1109}\u{1166}\u{11be}", "\u{c14f}", "\u{1109}\u{1166}\u{11be}"),
        ("\u{c150}", "\u{c150}", "\u{1109}\u{1166}\u{11bf}", "\u{c150}",
        "\u{1109}\u{1166}\u{11bf}"), ("\u{c151}", "\u{c151}", "\u{1109}\u{1166}\u{11c0}",
        "\u{c151}", "\u{1109}\u{1166}\u{11c0}"), ("\u{c152}", "\u{c152}",
        "\u{1109}\u{1166}\u{11c1}", "\u{c152}", "\u{1109}\u{1166}\u{11c1}"), ("\u{c153}",
        "\u{c153}", "\u{1109}\u{1166}\u{11c2}", "\u{c153}", "\u{1109}\u{1166}\u{11c2}"),
        ("\u{c154}", "\u{c154}", "\u{1109}\u{1167}", "\u{c154}", "\u{1109}\u{1167}"), ("\u{c155}",
        "\u{c155}", "\u{1109}\u{1167}\u{11a8}", "\u{c155}", "\u{1109}\u{1167}\u{11a8}"),
        ("\u{c156}", "\u{c156}", "\u{1109}\u{1167}\u{11a9}", "\u{c156}",
        "\u{1109}\u{1167}\u{11a9}"), ("\u{c157}", "\u{c157}", "\u{1109}\u{1167}\u{11aa}",
        "\u{c157}", "\u{1109}\u{1167}\u{11aa}"), ("\u{c158}", "\u{c158}",
        "\u{1109}\u{1167}\u{11ab}", "\u{c158}", "\u{1109}\u{1167}\u{11ab}"), ("\u{c159}",
        "\u{c159}", "\u{1109}\u{1167}\u{11ac}", "\u{c159}", "\u{1109}\u{1167}\u{11ac}"),
        ("\u{c15a}", "\u{c15a}", "\u{1109}\u{1167}\u{11ad}", "\u{c15a}",
        "\u{1109}\u{1167}\u{11ad}"), ("\u{c15b}", "\u{c15b}", "\u{1109}\u{1167}\u{11ae}",
        "\u{c15b}", "\u{1109}\u{1167}\u{11ae}"), ("\u{c15c}", "\u{c15c}",
        "\u{1109}\u{1167}\u{11af}", "\u{c15c}", "\u{1109}\u{1167}\u{11af}"), ("\u{c15d}",
        "\u{c15d}", "\u{1109}\u{1167}\u{11b0}", "\u{c15d}", "\u{1109}\u{1167}\u{11b0}"),
        ("\u{c15e}", "\u{c15e}", "\u{1109}\u{1167}\u{11b1}", "\u{c15e}",
        "\u{1109}\u{1167}\u{11b1}"), ("\u{c15f}", "\u{c15f}", "\u{1109}\u{1167}\u{11b2}",
        "\u{c15f}", "\u{1109}\u{1167}\u{11b2}"), ("\u{c160}", "\u{c160}",
        "\u{1109}\u{1167}\u{11b3}", "\u{c160}", "\u{1109}\u{1167}\u{11b3}"), ("\u{c161}",
        "\u{c161}", "\u{1109}\u{1167}\u{11b4}", "\u{c161}", "\u{1109}\u{1167}\u{11b4}"),
        ("\u{c162}", "\u{c162}", "\u{1109}\u{1167}\u{11b5}", "\u{c162}",
        "\u{1109}\u{1167}\u{11b5}"), ("\u{c163}", "\u{c163}", "\u{1109}\u{1167}\u{11b6}",
        "\u{c163}", "\u{1109}\u{1167}\u{11b6}"), ("\u{c164}", "\u{c164}",
        "\u{1109}\u{1167}\u{11b7}", "\u{c164}", "\u{1109}\u{1167}\u{11b7}"), ("\u{c165}",
        "\u{c165}", "\u{1109}\u{1167}\u{11b8}", "\u{c165}", "\u{1109}\u{1167}\u{11b8}"),
        ("\u{c166}", "\u{c166}", "\u{1109}\u{1167}\u{11b9}", "\u{c166}",
        "\u{1109}\u{1167}\u{11b9}"), ("\u{c167}", "\u{c167}", "\u{1109}\u{1167}\u{11ba}",
        "\u{c167}", "\u{1109}\u{1167}\u{11ba}"), ("\u{c168}", "\u{c168}",
        "\u{1109}\u{1167}\u{11bb}", "\u{c168}", "\u{1109}\u{1167}\u{11bb}"), ("\u{c169}",
        "\u{c169}", "\u{1109}\u{1167}\u{11bc}", "\u{c169}", "\u{1109}\u{1167}\u{11bc}"),
        ("\u{c16a}", "\u{c16a}", "\u{1109}\u{1167}\u{11bd}", "\u{c16a}",
        "\u{1109}\u{1167}\u{11bd}"), ("\u{c16b}", "\u{c16b}", "\u{1109}\u{1167}\u{11be}",
        "\u{c16b}", "\u{1109}\u{1167}\u{11be}"), ("\u{c16c}", "\u{c16c}",
        "\u{1109}\u{1167}\u{11bf}", "\u{c16c}", "\u{1109}\u{1167}\u{11bf}"), ("\u{c16d}",
        "\u{c16d}", "\u{1109}\u{1167}\u{11c0}", "\u{c16d}", "\u{1109}\u{1167}\u{11c0}"),
        ("\u{c16e}", "\u{c16e}", "\u{1109}\u{1167}\u{11c1}", "\u{c16e}",
        "\u{1109}\u{1167}\u{11c1}"), ("\u{c16f}", "\u{c16f}", "\u{1109}\u{1167}\u{11c2}",
        "\u{c16f}", "\u{1109}\u{1167}\u{11c2}"), ("\u{c170}", "\u{c170}", "\u{1109}\u{1168}",
        "\u{c170}", "\u{1109}\u{1168}"), ("\u{c171}", "\u{c171}", "\u{1109}\u{1168}\u{11a8}",
        "\u{c171}", "\u{1109}\u{1168}\u{11a8}"), ("\u{c172}", "\u{c172}",
        "\u{1109}\u{1168}\u{11a9}", "\u{c172}", "\u{1109}\u{1168}\u{11a9}"), ("\u{c173}",
        "\u{c173}", "\u{1109}\u{1168}\u{11aa}", "\u{c173}", "\u{1109}\u{1168}\u{11aa}"),
        ("\u{c174}", "\u{c174}", "\u{1109}\u{1168}\u{11ab}", "\u{c174}",
        "\u{1109}\u{1168}\u{11ab}"), ("\u{c175}", "\u{c175}", "\u{1109}\u{1168}\u{11ac}",
        "\u{c175}", "\u{1109}\u{1168}\u{11ac}"), ("\u{c176}", "\u{c176}",
        "\u{1109}\u{1168}\u{11ad}", "\u{c176}", "\u{1109}\u{1168}\u{11ad}"), ("\u{c177}",
        "\u{c177}", "\u{1109}\u{1168}\u{11ae}", "\u{c177}", "\u{1109}\u{1168}\u{11ae}"),
        ("\u{c178}", "\u{c178}", "\u{1109}\u{1168}\u{11af}", "\u{c178}",
        "\u{1109}\u{1168}\u{11af}"), ("\u{c179}", "\u{c179}", "\u{1109}\u{1168}\u{11b0}",
        "\u{c179}", "\u{1109}\u{1168}\u{11b0}"), ("\u{c17a}", "\u{c17a}",
        "\u{1109}\u{1168}\u{11b1}", "\u{c17a}", "\u{1109}\u{1168}\u{11b1}"), ("\u{c17b}",
        "\u{c17b}", "\u{1109}\u{1168}\u{11b2}", "\u{c17b}", "\u{1109}\u{1168}\u{11b2}"),
        ("\u{c17c}", "\u{c17c}", "\u{1109}\u{1168}\u{11b3}", "\u{c17c}",
        "\u{1109}\u{1168}\u{11b3}"), ("\u{c17d}", "\u{c17d}", "\u{1109}\u{1168}\u{11b4}",
        "\u{c17d}", "\u{1109}\u{1168}\u{11b4}"), ("\u{c17e}", "\u{c17e}",
        "\u{1109}\u{1168}\u{11b5}", "\u{c17e}", "\u{1109}\u{1168}\u{11b5}"), ("\u{c17f}",
        "\u{c17f}", "\u{1109}\u{1168}\u{11b6}", "\u{c17f}", "\u{1109}\u{1168}\u{11b6}"),
        ("\u{c180}", "\u{c180}", "\u{1109}\u{1168}\u{11b7}", "\u{c180}",
        "\u{1109}\u{1168}\u{11b7}"), ("\u{c181}", "\u{c181}", "\u{1109}\u{1168}\u{11b8}",
        "\u{c181}", "\u{1109}\u{1168}\u{11b8}"), ("\u{c182}", "\u{c182}",
        "\u{1109}\u{1168}\u{11b9}", "\u{c182}", "\u{1109}\u{1168}\u{11b9}"), ("\u{c183}",
        "\u{c183}", "\u{1109}\u{1168}\u{11ba}", "\u{c183}", "\u{1109}\u{1168}\u{11ba}"),
        ("\u{c184}", "\u{c184}", "\u{1109}\u{1168}\u{11bb}", "\u{c184}",
        "\u{1109}\u{1168}\u{11bb}"), ("\u{c185}", "\u{c185}", "\u{1109}\u{1168}\u{11bc}",
        "\u{c185}", "\u{1109}\u{1168}\u{11bc}"), ("\u{c186}", "\u{c186}",
        "\u{1109}\u{1168}\u{11bd}", "\u{c186}", "\u{1109}\u{1168}\u{11bd}"), ("\u{c187}",
        "\u{c187}", "\u{1109}\u{1168}\u{11be}", "\u{c187}", "\u{1109}\u{1168}\u{11be}"),
        ("\u{c188}", "\u{c188}", "\u{1109}\u{1168}\u{11bf}", "\u{c188}",
        "\u{1109}\u{1168}\u{11bf}"), ("\u{c189}", "\u{c189}", "\u{1109}\u{1168}\u{11c0}",
        "\u{c189}", "\u{1109}\u{1168}\u{11c0}"), ("\u{c18a}", "\u{c18a}",
        "\u{1109}\u{1168}\u{11c1}", "\u{c18a}", "\u{1109}\u{1168}\u{11c1}"), ("\u{c18b}",
        "\u{c18b}", "\u{1109}\u{1168}\u{11c2}", "\u{c18b}", "\u{1109}\u{1168}\u{11c2}"),
        ("\u{c18c}", "\u{c18c}", "\u{1109}\u{1169}", "\u{c18c}", "\u{1109}\u{1169}"), ("\u{c18d}",
        "\u{c18d}", "\u{1109}\u{1169}\u{11a8}", "\u{c18d}", "\u{1109}\u{1169}\u{11a8}"),
        ("\u{c18e}", "\u{c18e}", "\u{1109}\u{1169}\u{11a9}", "\u{c18e}",
        "\u{1109}\u{1169}\u{11a9}"), ("\u{c18f}", "\u{c18f}", "\u{1109}\u{1169}\u{11aa}",
        "\u{c18f}", "\u{1109}\u{1169}\u{11aa}"), ("\u{c190}", "\u{c190}",
        "\u{1109}\u{1169}\u{11ab}", "\u{c190}", "\u{1109}\u{1169}\u{11ab}"), ("\u{c191}",
        "\u{c191}", "\u{1109}\u{1169}\u{11ac}", "\u{c191}", "\u{1109}\u{1169}\u{11ac}"),
        ("\u{c192}", "\u{c192}", "\u{1109}\u{1169}\u{11ad}", "\u{c192}",
        "\u{1109}\u{1169}\u{11ad}"), ("\u{c193}", "\u{c193}", "\u{1109}\u{1169}\u{11ae}",
        "\u{c193}", "\u{1109}\u{1169}\u{11ae}"), ("\u{c194}", "\u{c194}",
        "\u{1109}\u{1169}\u{11af}", "\u{c194}", "\u{1109}\u{1169}\u{11af}"), ("\u{c195}",
        "\u{c195}", "\u{1109}\u{1169}\u{11b0}", "\u{c195}", "\u{1109}\u{1169}\u{11b0}"),
        ("\u{c196}", "\u{c196}", "\u{1109}\u{1169}\u{11b1}", "\u{c196}",
        "\u{1109}\u{1169}\u{11b1}"), ("\u{c197}", "\u{c197}", "\u{1109}\u{1169}\u{11b2}",
        "\u{c197}", "\u{1109}\u{1169}\u{11b2}"), ("\u{c198}", "\u{c198}",
        "\u{1109}\u{1169}\u{11b3}", "\u{c198}", "\u{1109}\u{1169}\u{11b3}"), ("\u{c199}",
        "\u{c199}", "\u{1109}\u{1169}\u{11b4}", "\u{c199}", "\u{1109}\u{1169}\u{11b4}"),
        ("\u{c19a}", "\u{c19a}", "\u{1109}\u{1169}\u{11b5}", "\u{c19a}",
        "\u{1109}\u{1169}\u{11b5}"), ("\u{c19b}", "\u{c19b}", "\u{1109}\u{1169}\u{11b6}",
        "\u{c19b}", "\u{1109}\u{1169}\u{11b6}"), ("\u{c19c}", "\u{c19c}",
        "\u{1109}\u{1169}\u{11b7}", "\u{c19c}", "\u{1109}\u{1169}\u{11b7}"), ("\u{c19d}",
        "\u{c19d}", "\u{1109}\u{1169}\u{11b8}", "\u{c19d}", "\u{1109}\u{1169}\u{11b8}"),
        ("\u{c19e}", "\u{c19e}", "\u{1109}\u{1169}\u{11b9}", "\u{c19e}",
        "\u{1109}\u{1169}\u{11b9}"), ("\u{c19f}", "\u{c19f}", "\u{1109}\u{1169}\u{11ba}",
        "\u{c19f}", "\u{1109}\u{1169}\u{11ba}"), ("\u{c1a0}", "\u{c1a0}",
        "\u{1109}\u{1169}\u{11bb}", "\u{c1a0}", "\u{1109}\u{1169}\u{11bb}"), ("\u{c1a1}",
        "\u{c1a1}", "\u{1109}\u{1169}\u{11bc}", "\u{c1a1}", "\u{1109}\u{1169}\u{11bc}"),
        ("\u{c1a2}", "\u{c1a2}", "\u{1109}\u{1169}\u{11bd}", "\u{c1a2}",
        "\u{1109}\u{1169}\u{11bd}"), ("\u{c1a3}", "\u{c1a3}", "\u{1109}\u{1169}\u{11be}",
        "\u{c1a3}", "\u{1109}\u{1169}\u{11be}"), ("\u{c1a4}", "\u{c1a4}",
        "\u{1109}\u{1169}\u{11bf}", "\u{c1a4}", "\u{1109}\u{1169}\u{11bf}"), ("\u{c1a5}",
        "\u{c1a5}", "\u{1109}\u{1169}\u{11c0}", "\u{c1a5}", "\u{1109}\u{1169}\u{11c0}"),
        ("\u{c1a6}", "\u{c1a6}", "\u{1109}\u{1169}\u{11c1}", "\u{c1a6}",
        "\u{1109}\u{1169}\u{11c1}"), ("\u{c1a7}", "\u{c1a7}", "\u{1109}\u{1169}\u{11c2}",
        "\u{c1a7}", "\u{1109}\u{1169}\u{11c2}"), ("\u{c1a8}", "\u{c1a8}", "\u{1109}\u{116a}",
        "\u{c1a8}", "\u{1109}\u{116a}"), ("\u{c1a9}", "\u{c1a9}", "\u{1109}\u{116a}\u{11a8}",
        "\u{c1a9}", "\u{1109}\u{116a}\u{11a8}"), ("\u{c1aa}", "\u{c1aa}",
        "\u{1109}\u{116a}\u{11a9}", "\u{c1aa}", "\u{1109}\u{116a}\u{11a9}"), ("\u{c1ab}",
        "\u{c1ab}", "\u{1109}\u{116a}\u{11aa}", "\u{c1ab}", "\u{1109}\u{116a}\u{11aa}"),
        ("\u{c1ac}", "\u{c1ac}", "\u{1109}\u{116a}\u{11ab}", "\u{c1ac}",
        "\u{1109}\u{116a}\u{11ab}"), ("\u{c1ad}", "\u{c1ad}", "\u{1109}\u{116a}\u{11ac}",
        "\u{c1ad}", "\u{1109}\u{116a}\u{11ac}"), ("\u{c1ae}", "\u{c1ae}",
        "\u{1109}\u{116a}\u{11ad}", "\u{c1ae}", "\u{1109}\u{116a}\u{11ad}"), ("\u{c1af}",
        "\u{c1af}", "\u{1109}\u{116a}\u{11ae}", "\u{c1af}", "\u{1109}\u{116a}\u{11ae}"),
        ("\u{c1b0}", "\u{c1b0}", "\u{1109}\u{116a}\u{11af}", "\u{c1b0}",
        "\u{1109}\u{116a}\u{11af}"), ("\u{c1b1}", "\u{c1b1}", "\u{1109}\u{116a}\u{11b0}",
        "\u{c1b1}", "\u{1109}\u{116a}\u{11b0}"), ("\u{c1b2}", "\u{c1b2}",
        "\u{1109}\u{116a}\u{11b1}", "\u{c1b2}", "\u{1109}\u{116a}\u{11b1}"), ("\u{c1b3}",
        "\u{c1b3}", "\u{1109}\u{116a}\u{11b2}", "\u{c1b3}", "\u{1109}\u{116a}\u{11b2}"),
        ("\u{c1b4}", "\u{c1b4}", "\u{1109}\u{116a}\u{11b3}", "\u{c1b4}",
        "\u{1109}\u{116a}\u{11b3}"), ("\u{c1b5}", "\u{c1b5}", "\u{1109}\u{116a}\u{11b4}",
        "\u{c1b5}", "\u{1109}\u{116a}\u{11b4}"), ("\u{c1b6}", "\u{c1b6}",
        "\u{1109}\u{116a}\u{11b5}", "\u{c1b6}", "\u{1109}\u{116a}\u{11b5}"), ("\u{c1b7}",
        "\u{c1b7}", "\u{1109}\u{116a}\u{11b6}", "\u{c1b7}", "\u{1109}\u{116a}\u{11b6}"),
        ("\u{c1b8}", "\u{c1b8}", "\u{1109}\u{116a}\u{11b7}", "\u{c1b8}",
        "\u{1109}\u{116a}\u{11b7}"), ("\u{c1b9}", "\u{c1b9}", "\u{1109}\u{116a}\u{11b8}",
        "\u{c1b9}", "\u{1109}\u{116a}\u{11b8}"), ("\u{c1ba}", "\u{c1ba}",
        "\u{1109}\u{116a}\u{11b9}", "\u{c1ba}", "\u{1109}\u{116a}\u{11b9}"), ("\u{c1bb}",
        "\u{c1bb}", "\u{1109}\u{116a}\u{11ba}", "\u{c1bb}", "\u{1109}\u{116a}\u{11ba}"),
        ("\u{c1bc}", "\u{c1bc}", "\u{1109}\u{116a}\u{11bb}", "\u{c1bc}",
        "\u{1109}\u{116a}\u{11bb}"), ("\u{c1bd}", "\u{c1bd}", "\u{1109}\u{116a}\u{11bc}",
        "\u{c1bd}", "\u{1109}\u{116a}\u{11bc}"), ("\u{c1be}", "\u{c1be}",
        "\u{1109}\u{116a}\u{11bd}", "\u{c1be}", "\u{1109}\u{116a}\u{11bd}"), ("\u{c1bf}",
        "\u{c1bf}", "\u{1109}\u{116a}\u{11be}", "\u{c1bf}", "\u{1109}\u{116a}\u{11be}"),
        ("\u{c1c0}", "\u{c1c0}", "\u{1109}\u{116a}\u{11bf}", "\u{c1c0}",
        "\u{1109}\u{116a}\u{11bf}"), ("\u{c1c1}", "\u{c1c1}", "\u{1109}\u{116a}\u{11c0}",
        "\u{c1c1}", "\u{1109}\u{116a}\u{11c0}"), ("\u{c1c2}", "\u{c1c2}",
        "\u{1109}\u{116a}\u{11c1}", "\u{c1c2}", "\u{1109}\u{116a}\u{11c1}"), ("\u{c1c3}",
        "\u{c1c3}", "\u{1109}\u{116a}\u{11c2}", "\u{c1c3}", "\u{1109}\u{116a}\u{11c2}"),
        ("\u{c1c4}", "\u{c1c4}", "\u{1109}\u{116b}", "\u{c1c4}", "\u{1109}\u{116b}"), ("\u{c1c5}",
        "\u{c1c5}", "\u{1109}\u{116b}\u{11a8}", "\u{c1c5}", "\u{1109}\u{116b}\u{11a8}"),
        ("\u{c1c6}", "\u{c1c6}", "\u{1109}\u{116b}\u{11a9}", "\u{c1c6}",
        "\u{1109}\u{116b}\u{11a9}"), ("\u{c1c7}", "\u{c1c7}", "\u{1109}\u{116b}\u{11aa}",
        "\u{c1c7}", "\u{1109}\u{116b}\u{11aa}"), ("\u{c1c8}", "\u{c1c8}",
        "\u{1109}\u{116b}\u{11ab}", "\u{c1c8}", "\u{1109}\u{116b}\u{11ab}"), ("\u{c1c9}",
        "\u{c1c9}", "\u{1109}\u{116b}\u{11ac}", "\u{c1c9}", "\u{1109}\u{116b}\u{11ac}"),
        ("\u{c1ca}", "\u{c1ca}", "\u{1109}\u{116b}\u{11ad}", "\u{c1ca}",
        "\u{1109}\u{116b}\u{11ad}"), ("\u{c1cb}", "\u{c1cb}", "\u{1109}\u{116b}\u{11ae}",
        "\u{c1cb}", "\u{1109}\u{116b}\u{11ae}"), ("\u{c1cc}", "\u{c1cc}",
        "\u{1109}\u{116b}\u{11af}", "\u{c1cc}", "\u{1109}\u{116b}\u{11af}"), ("\u{c1cd}",
        "\u{c1cd}", "\u{1109}\u{116b}\u{11b0}", "\u{c1cd}", "\u{1109}\u{116b}\u{11b0}"),
        ("\u{c1ce}", "\u{c1ce}", "\u{1109}\u{116b}\u{11b1}", "\u{c1ce}",
        "\u{1109}\u{116b}\u{11b1}"), ("\u{c1cf}", "\u{c1cf}", "\u{1109}\u{116b}\u{11b2}",
        "\u{c1cf}", "\u{1109}\u{116b}\u{11b2}"), ("\u{c1d0}", "\u{c1d0}",
        "\u{1109}\u{116b}\u{11b3}", "\u{c1d0}", "\u{1109}\u{116b}\u{11b3}"), ("\u{c1d1}",
        "\u{c1d1}", "\u{1109}\u{116b}\u{11b4}", "\u{c1d1}", "\u{1109}\u{116b}\u{11b4}"),
        ("\u{c1d2}", "\u{c1d2}", "\u{1109}\u{116b}\u{11b5}", "\u{c1d2}",
        "\u{1109}\u{116b}\u{11b5}"), ("\u{c1d3}", "\u{c1d3}", "\u{1109}\u{116b}\u{11b6}",
        "\u{c1d3}", "\u{1109}\u{116b}\u{11b6}"), ("\u{c1d4}", "\u{c1d4}",
        "\u{1109}\u{116b}\u{11b7}", "\u{c1d4}", "\u{1109}\u{116b}\u{11b7}"), ("\u{c1d5}",
        "\u{c1d5}", "\u{1109}\u{116b}\u{11b8}", "\u{c1d5}", "\u{1109}\u{116b}\u{11b8}"),
        ("\u{c1d6}", "\u{c1d6}", "\u{1109}\u{116b}\u{11b9}", "\u{c1d6}",
        "\u{1109}\u{116b}\u{11b9}"), ("\u{c1d7}", "\u{c1d7}", "\u{1109}\u{116b}\u{11ba}",
        "\u{c1d7}", "\u{1109}\u{116b}\u{11ba}"), ("\u{c1d8}", "\u{c1d8}",
        "\u{1109}\u{116b}\u{11bb}", "\u{c1d8}", "\u{1109}\u{116b}\u{11bb}"), ("\u{c1d9}",
        "\u{c1d9}", "\u{1109}\u{116b}\u{11bc}", "\u{c1d9}", "\u{1109}\u{116b}\u{11bc}"),
        ("\u{c1da}", "\u{c1da}", "\u{1109}\u{116b}\u{11bd}", "\u{c1da}",
        "\u{1109}\u{116b}\u{11bd}"), ("\u{c1db}", "\u{c1db}", "\u{1109}\u{116b}\u{11be}",
        "\u{c1db}", "\u{1109}\u{116b}\u{11be}"), ("\u{c1dc}", "\u{c1dc}",
        "\u{1109}\u{116b}\u{11bf}", "\u{c1dc}", "\u{1109}\u{116b}\u{11bf}"), ("\u{c1dd}",
        "\u{c1dd}", "\u{1109}\u{116b}\u{11c0}", "\u{c1dd}", "\u{1109}\u{116b}\u{11c0}"),
        ("\u{c1de}", "\u{c1de}", "\u{1109}\u{116b}\u{11c1}", "\u{c1de}",
        "\u{1109}\u{116b}\u{11c1}"), ("\u{c1df}", "\u{c1df}", "\u{1109}\u{116b}\u{11c2}",
        "\u{c1df}", "\u{1109}\u{116b}\u{11c2}"), ("\u{c1e0}", "\u{c1e0}", "\u{1109}\u{116c}",
        "\u{c1e0}", "\u{1109}\u{116c}"), ("\u{c1e1}", "\u{c1e1}", "\u{1109}\u{116c}\u{11a8}",
        "\u{c1e1}", "\u{1109}\u{116c}\u{11a8}"), ("\u{c1e2}", "\u{c1e2}",
        "\u{1109}\u{116c}\u{11a9}", "\u{c1e2}", "\u{1109}\u{116c}\u{11a9}"), ("\u{c1e3}",
        "\u{c1e3}", "\u{1109}\u{116c}\u{11aa}", "\u{c1e3}", "\u{1109}\u{116c}\u{11aa}"),
        ("\u{c1e4}", "\u{c1e4}", "\u{1109}\u{116c}\u{11ab}", "\u{c1e4}",
        "\u{1109}\u{116c}\u{11ab}"), ("\u{c1e5}", "\u{c1e5}", "\u{1109}\u{116c}\u{11ac}",
        "\u{c1e5}", "\u{1109}\u{116c}\u{11ac}"), ("\u{c1e6}", "\u{c1e6}",
        "\u{1109}\u{116c}\u{11ad}", "\u{c1e6}", "\u{1109}\u{116c}\u{11ad}"), ("\u{c1e7}",
        "\u{c1e7}", "\u{1109}\u{116c}\u{11ae}", "\u{c1e7}", "\u{1109}\u{116c}\u{11ae}"),
        ("\u{c1e8}", "\u{c1e8}", "\u{1109}\u{116c}\u{11af}", "\u{c1e8}",
        "\u{1109}\u{116c}\u{11af}"), ("\u{c1e9}", "\u{c1e9}", "\u{1109}\u{116c}\u{11b0}",
        "\u{c1e9}", "\u{1109}\u{116c}\u{11b0}"), ("\u{c1ea}", "\u{c1ea}",
        "\u{1109}\u{116c}\u{11b1}", "\u{c1ea}", "\u{1109}\u{116c}\u{11b1}"), ("\u{c1eb}",
        "\u{c1eb}", "\u{1109}\u{116c}\u{11b2}", "\u{c1eb}", "\u{1109}\u{116c}\u{11b2}"),
        ("\u{c1ec}", "\u{c1ec}", "\u{1109}\u{116c}\u{11b3}", "\u{c1ec}",
        "\u{1109}\u{116c}\u{11b3}"), ("\u{c1ed}", "\u{c1ed}", "\u{1109}\u{116c}\u{11b4}",
        "\u{c1ed}", "\u{1109}\u{116c}\u{11b4}"), ("\u{c1ee}", "\u{c1ee}",
        "\u{1109}\u{116c}\u{11b5}", "\u{c1ee}", "\u{1109}\u{116c}\u{11b5}"), ("\u{c1ef}",
        "\u{c1ef}", "\u{1109}\u{116c}\u{11b6}", "\u{c1ef}", "\u{1109}\u{116c}\u{11b6}"),
        ("\u{c1f0}", "\u{c1f0}", "\u{1109}\u{116c}\u{11b7}", "\u{c1f0}",
        "\u{1109}\u{116c}\u{11b7}"), ("\u{c1f1}", "\u{c1f1}", "\u{1109}\u{116c}\u{11b8}",
        "\u{c1f1}", "\u{1109}\u{116c}\u{11b8}"), ("\u{c1f2}", "\u{c1f2}",
        "\u{1109}\u{116c}\u{11b9}", "\u{c1f2}", "\u{1109}\u{116c}\u{11b9}"), ("\u{c1f3}",
        "\u{c1f3}", "\u{1109}\u{116c}\u{11ba}", "\u{c1f3}", "\u{1109}\u{116c}\u{11ba}"),
        ("\u{c1f4}", "\u{c1f4}", "\u{1109}\u{116c}\u{11bb}", "\u{c1f4}",
        "\u{1109}\u{116c}\u{11bb}"), ("\u{c1f5}", "\u{c1f5}", "\u{1109}\u{116c}\u{11bc}",
        "\u{c1f5}", "\u{1109}\u{116c}\u{11bc}"), ("\u{c1f6}", "\u{c1f6}",
        "\u{1109}\u{116c}\u{11bd}", "\u{c1f6}", "\u{1109}\u{116c}\u{11bd}"), ("\u{c1f7}",
        "\u{c1f7}", "\u{1109}\u{116c}\u{11be}", "\u{c1f7}", "\u{1109}\u{116c}\u{11be}"),
        ("\u{c1f8}", "\u{c1f8}", "\u{1109}\u{116c}\u{11bf}", "\u{c1f8}",
        "\u{1109}\u{116c}\u{11bf}"), ("\u{c1f9}", "\u{c1f9}", "\u{1109}\u{116c}\u{11c0}",
        "\u{c1f9}", "\u{1109}\u{116c}\u{11c0}"), ("\u{c1fa}", "\u{c1fa}",
        "\u{1109}\u{116c}\u{11c1}", "\u{c1fa}", "\u{1109}\u{116c}\u{11c1}"), ("\u{c1fb}",
        "\u{c1fb}", "\u{1109}\u{116c}\u{11c2}", "\u{c1fb}", "\u{1109}\u{116c}\u{11c2}"),
        ("\u{c1fc}", "\u{c1fc}", "\u{1109}\u{116d}", "\u{c1fc}", "\u{1109}\u{116d}"), ("\u{c1fd}",
        "\u{c1fd}", "\u{1109}\u{116d}\u{11a8}", "\u{c1fd}", "\u{1109}\u{116d}\u{11a8}"),
        ("\u{c1fe}", "\u{c1fe}", "\u{1109}\u{116d}\u{11a9}", "\u{c1fe}",
        "\u{1109}\u{116d}\u{11a9}"), ("\u{c1ff}", "\u{c1ff}", "\u{1109}\u{116d}\u{11aa}",
        "\u{c1ff}", "\u{1109}\u{116d}\u{11aa}"), ("\u{c200}", "\u{c200}",
        "\u{1109}\u{116d}\u{11ab}", "\u{c200}", "\u{1109}\u{116d}\u{11ab}"), ("\u{c201}",
        "\u{c201}", "\u{1109}\u{116d}\u{11ac}", "\u{c201}", "\u{1109}\u{116d}\u{11ac}"),
        ("\u{c202}", "\u{c202}", "\u{1109}\u{116d}\u{11ad}", "\u{c202}",
        "\u{1109}\u{116d}\u{11ad}"), ("\u{c203}", "\u{c203}", "\u{1109}\u{116d}\u{11ae}",
        "\u{c203}", "\u{1109}\u{116d}\u{11ae}"), ("\u{c204}", "\u{c204}",
        "\u{1109}\u{116d}\u{11af}", "\u{c204}", "\u{1109}\u{116d}\u{11af}"), ("\u{c205}",
        "\u{c205}", "\u{1109}\u{116d}\u{11b0}", "\u{c205}", "\u{1109}\u{116d}\u{11b0}"),
        ("\u{c206}", "\u{c206}", "\u{1109}\u{116d}\u{11b1}", "\u{c206}",
        "\u{1109}\u{116d}\u{11b1}"), ("\u{c207}", "\u{c207}", "\u{1109}\u{116d}\u{11b2}",
        "\u{c207}", "\u{1109}\u{116d}\u{11b2}"), ("\u{c208}", "\u{c208}",
        "\u{1109}\u{116d}\u{11b3}", "\u{c208}", "\u{1109}\u{116d}\u{11b3}"), ("\u{c209}",
        "\u{c209}", "\u{1109}\u{116d}\u{11b4}", "\u{c209}", "\u{1109}\u{116d}\u{11b4}"),
        ("\u{c20a}", "\u{c20a}", "\u{1109}\u{116d}\u{11b5}", "\u{c20a}",
        "\u{1109}\u{116d}\u{11b5}"), ("\u{c20b}", "\u{c20b}", "\u{1109}\u{116d}\u{11b6}",
        "\u{c20b}", "\u{1109}\u{116d}\u{11b6}"), ("\u{c20c}", "\u{c20c}",
        "\u{1109}\u{116d}\u{11b7}", "\u{c20c}", "\u{1109}\u{116d}\u{11b7}"), ("\u{c20d}",
        "\u{c20d}", "\u{1109}\u{116d}\u{11b8}", "\u{c20d}", "\u{1109}\u{116d}\u{11b8}"),
        ("\u{c20e}", "\u{c20e}", "\u{1109}\u{116d}\u{11b9}", "\u{c20e}",
        "\u{1109}\u{116d}\u{11b9}"), ("\u{c20f}", "\u{c20f}", "\u{1109}\u{116d}\u{11ba}",
        "\u{c20f}", "\u{1109}\u{116d}\u{11ba}"), ("\u{c210}", "\u{c210}",
        "\u{1109}\u{116d}\u{11bb}", "\u{c210}", "\u{1109}\u{116d}\u{11bb}"), ("\u{c211}",
        "\u{c211}", "\u{1109}\u{116d}\u{11bc}", "\u{c211}", "\u{1109}\u{116d}\u{11bc}"),
        ("\u{c212}", "\u{c212}", "\u{1109}\u{116d}\u{11bd}", "\u{c212}",
        "\u{1109}\u{116d}\u{11bd}"), ("\u{c213}", "\u{c213}", "\u{1109}\u{116d}\u{11be}",
        "\u{c213}", "\u{1109}\u{116d}\u{11be}"), ("\u{c214}", "\u{c214}",
        "\u{1109}\u{116d}\u{11bf}", "\u{c214}", "\u{1109}\u{116d}\u{11bf}"), ("\u{c215}",
        "\u{c215}", "\u{1109}\u{116d}\u{11c0}", "\u{c215}", "\u{1109}\u{116d}\u{11c0}"),
        ("\u{c216}", "\u{c216}", "\u{1109}\u{116d}\u{11c1}", "\u{c216}",
        "\u{1109}\u{116d}\u{11c1}"), ("\u{c217}", "\u{c217}", "\u{1109}\u{116d}\u{11c2}",
        "\u{c217}", "\u{1109}\u{116d}\u{11c2}"), ("\u{c218}", "\u{c218}", "\u{1109}\u{116e}",
        "\u{c218}", "\u{1109}\u{116e}"), ("\u{c219}", "\u{c219}", "\u{1109}\u{116e}\u{11a8}",
        "\u{c219}", "\u{1109}\u{116e}\u{11a8}"), ("\u{c21a}", "\u{c21a}",
        "\u{1109}\u{116e}\u{11a9}", "\u{c21a}", "\u{1109}\u{116e}\u{11a9}"), ("\u{c21b}",
        "\u{c21b}", "\u{1109}\u{116e}\u{11aa}", "\u{c21b}", "\u{1109}\u{116e}\u{11aa}"),
        ("\u{c21c}", "\u{c21c}", "\u{1109}\u{116e}\u{11ab}", "\u{c21c}",
        "\u{1109}\u{116e}\u{11ab}"), ("\u{c21d}", "\u{c21d}", "\u{1109}\u{116e}\u{11ac}",
        "\u{c21d}", "\u{1109}\u{116e}\u{11ac}"), ("\u{c21e}", "\u{c21e}",
        "\u{1109}\u{116e}\u{11ad}", "\u{c21e}", "\u{1109}\u{116e}\u{11ad}"), ("\u{c21f}",
        "\u{c21f}", "\u{1109}\u{116e}\u{11ae}", "\u{c21f}", "\u{1109}\u{116e}\u{11ae}"),
        ("\u{c220}", "\u{c220}", "\u{1109}\u{116e}\u{11af}", "\u{c220}",
        "\u{1109}\u{116e}\u{11af}"), ("\u{c221}", "\u{c221}", "\u{1109}\u{116e}\u{11b0}",
        "\u{c221}", "\u{1109}\u{116e}\u{11b0}"), ("\u{c222}", "\u{c222}",
        "\u{1109}\u{116e}\u{11b1}", "\u{c222}", "\u{1109}\u{116e}\u{11b1}"), ("\u{c223}",
        "\u{c223}", "\u{1109}\u{116e}\u{11b2}", "\u{c223}", "\u{1109}\u{116e}\u{11b2}"),
        ("\u{c224}", "\u{c224}", "\u{1109}\u{116e}\u{11b3}", "\u{c224}",
        "\u{1109}\u{116e}\u{11b3}"), ("\u{c225}", "\u{c225}", "\u{1109}\u{116e}\u{11b4}",
        "\u{c225}", "\u{1109}\u{116e}\u{11b4}"), ("\u{c226}", "\u{c226}",
        "\u{1109}\u{116e}\u{11b5}", "\u{c226}", "\u{1109}\u{116e}\u{11b5}"), ("\u{c227}",
        "\u{c227}", "\u{1109}\u{116e}\u{11b6}", "\u{c227}", "\u{1109}\u{116e}\u{11b6}"),
        ("\u{c228}", "\u{c228}", "\u{1109}\u{116e}\u{11b7}", "\u{c228}",
        "\u{1109}\u{116e}\u{11b7}"), ("\u{c229}", "\u{c229}", "\u{1109}\u{116e}\u{11b8}",
        "\u{c229}", "\u{1109}\u{116e}\u{11b8}"), ("\u{c22a}", "\u{c22a}",
        "\u{1109}\u{116e}\u{11b9}", "\u{c22a}", "\u{1109}\u{116e}\u{11b9}"), ("\u{c22b}",
        "\u{c22b}", "\u{1109}\u{116e}\u{11ba}", "\u{c22b}", "\u{1109}\u{116e}\u{11ba}"),
        ("\u{c22c}", "\u{c22c}", "\u{1109}\u{116e}\u{11bb}", "\u{c22c}",
        "\u{1109}\u{116e}\u{11bb}"), ("\u{c22d}", "\u{c22d}", "\u{1109}\u{116e}\u{11bc}",
        "\u{c22d}", "\u{1109}\u{116e}\u{11bc}"), ("\u{c22e}", "\u{c22e}",
        "\u{1109}\u{116e}\u{11bd}", "\u{c22e}", "\u{1109}\u{116e}\u{11bd}"), ("\u{c22f}",
        "\u{c22f}", "\u{1109}\u{116e}\u{11be}", "\u{c22f}", "\u{1109}\u{116e}\u{11be}"),
        ("\u{c230}", "\u{c230}", "\u{1109}\u{116e}\u{11bf}", "\u{c230}",
        "\u{1109}\u{116e}\u{11bf}"), ("\u{c231}", "\u{c231}", "\u{1109}\u{116e}\u{11c0}",
        "\u{c231}", "\u{1109}\u{116e}\u{11c0}"), ("\u{c232}", "\u{c232}",
        "\u{1109}\u{116e}\u{11c1}", "\u{c232}", "\u{1109}\u{116e}\u{11c1}"), ("\u{c233}",
        "\u{c233}", "\u{1109}\u{116e}\u{11c2}", "\u{c233}", "\u{1109}\u{116e}\u{11c2}"),
        ("\u{c234}", "\u{c234}", "\u{1109}\u{116f}", "\u{c234}", "\u{1109}\u{116f}"), ("\u{c235}",
        "\u{c235}", "\u{1109}\u{116f}\u{11a8}", "\u{c235}", "\u{1109}\u{116f}\u{11a8}"),
        ("\u{c236}", "\u{c236}", "\u{1109}\u{116f}\u{11a9}", "\u{c236}",
        "\u{1109}\u{116f}\u{11a9}"), ("\u{c237}", "\u{c237}", "\u{1109}\u{116f}\u{11aa}",
        "\u{c237}", "\u{1109}\u{116f}\u{11aa}"), ("\u{c238}", "\u{c238}",
        "\u{1109}\u{116f}\u{11ab}", "\u{c238}", "\u{1109}\u{116f}\u{11ab}"), ("\u{c239}",
        "\u{c239}", "\u{1109}\u{116f}\u{11ac}", "\u{c239}", "\u{1109}\u{116f}\u{11ac}"),
        ("\u{c23a}", "\u{c23a}", "\u{1109}\u{116f}\u{11ad}", "\u{c23a}",
        "\u{1109}\u{116f}\u{11ad}"), ("\u{c23b}", "\u{c23b}", "\u{1109}\u{116f}\u{11ae}",
        "\u{c23b}", "\u{1109}\u{116f}\u{11ae}"), ("\u{c23c}", "\u{c23c}",
        "\u{1109}\u{116f}\u{11af}", "\u{c23c}", "\u{1109}\u{116f}\u{11af}"), ("\u{c23d}",
        "\u{c23d}", "\u{1109}\u{116f}\u{11b0}", "\u{c23d}", "\u{1109}\u{116f}\u{11b0}"),
        ("\u{c23e}", "\u{c23e}", "\u{1109}\u{116f}\u{11b1}", "\u{c23e}",
        "\u{1109}\u{116f}\u{11b1}"), ("\u{c23f}", "\u{c23f}", "\u{1109}\u{116f}\u{11b2}",
        "\u{c23f}", "\u{1109}\u{116f}\u{11b2}"), ("\u{c240}", "\u{c240}",
        "\u{1109}\u{116f}\u{11b3}", "\u{c240}", "\u{1109}\u{116f}\u{11b3}"), ("\u{c241}",
        "\u{c241}", "\u{1109}\u{116f}\u{11b4}", "\u{c241}", "\u{1109}\u{116f}\u{11b4}"),
        ("\u{c242}", "\u{c242}", "\u{1109}\u{116f}\u{11b5}", "\u{c242}",
        "\u{1109}\u{116f}\u{11b5}"), ("\u{c243}", "\u{c243}", "\u{1109}\u{116f}\u{11b6}",
        "\u{c243}", "\u{1109}\u{116f}\u{11b6}"), ("\u{c244}", "\u{c244}",
        "\u{1109}\u{116f}\u{11b7}", "\u{c244}", "\u{1109}\u{116f}\u{11b7}"), ("\u{c245}",
        "\u{c245}", "\u{1109}\u{116f}\u{11b8}", "\u{c245}", "\u{1109}\u{116f}\u{11b8}"),
        ("\u{c246}", "\u{c246}", "\u{1109}\u{116f}\u{11b9}", "\u{c246}",
        "\u{1109}\u{116f}\u{11b9}"), ("\u{c247}", "\u{c247}", "\u{1109}\u{116f}\u{11ba}",
        "\u{c247}", "\u{1109}\u{116f}\u{11ba}"), ("\u{c248}", "\u{c248}",
        "\u{1109}\u{116f}\u{11bb}", "\u{c248}", "\u{1109}\u{116f}\u{11bb}"), ("\u{c249}",
        "\u{c249}", "\u{1109}\u{116f}\u{11bc}", "\u{c249}", "\u{1109}\u{116f}\u{11bc}"),
        ("\u{c24a}", "\u{c24a}", "\u{1109}\u{116f}\u{11bd}", "\u{c24a}",
        "\u{1109}\u{116f}\u{11bd}"), ("\u{c24b}", "\u{c24b}", "\u{1109}\u{116f}\u{11be}",
        "\u{c24b}", "\u{1109}\u{116f}\u{11be}"), ("\u{c24c}", "\u{c24c}",
        "\u{1109}\u{116f}\u{11bf}", "\u{c24c}", "\u{1109}\u{116f}\u{11bf}"), ("\u{c24d}",
        "\u{c24d}", "\u{1109}\u{116f}\u{11c0}", "\u{c24d}", "\u{1109}\u{116f}\u{11c0}"),
        ("\u{c24e}", "\u{c24e}", "\u{1109}\u{116f}\u{11c1}", "\u{c24e}",
        "\u{1109}\u{116f}\u{11c1}"), ("\u{c24f}", "\u{c24f}", "\u{1109}\u{116f}\u{11c2}",
        "\u{c24f}", "\u{1109}\u{116f}\u{11c2}"), ("\u{c250}", "\u{c250}", "\u{1109}\u{1170}",
        "\u{c250}", "\u{1109}\u{1170}"), ("\u{c251}", "\u{c251}", "\u{1109}\u{1170}\u{11a8}",
        "\u{c251}", "\u{1109}\u{1170}\u{11a8}"), ("\u{c252}", "\u{c252}",
        "\u{1109}\u{1170}\u{11a9}", "\u{c252}", "\u{1109}\u{1170}\u{11a9}"), ("\u{c253}",
        "\u{c253}", "\u{1109}\u{1170}\u{11aa}", "\u{c253}", "\u{1109}\u{1170}\u{11aa}"),
        ("\u{c254}", "\u{c254}", "\u{1109}\u{1170}\u{11ab}", "\u{c254}",
        "\u{1109}\u{1170}\u{11ab}"), ("\u{c255}", "\u{c255}", "\u{1109}\u{1170}\u{11ac}",
        "\u{c255}", "\u{1109}\u{1170}\u{11ac}"), ("\u{c256}", "\u{c256}",
        "\u{1109}\u{1170}\u{11ad}", "\u{c256}", "\u{1109}\u{1170}\u{11ad}"), ("\u{c257}",
        "\u{c257}", "\u{1109}\u{1170}\u{11ae}", "\u{c257}", "\u{1109}\u{1170}\u{11ae}"),
        ("\u{c258}", "\u{c258}", "\u{1109}\u{1170}\u{11af}", "\u{c258}",
        "\u{1109}\u{1170}\u{11af}"), ("\u{c259}", "\u{c259}", "\u{1109}\u{1170}\u{11b0}",
        "\u{c259}", "\u{1109}\u{1170}\u{11b0}"), ("\u{c25a}", "\u{c25a}",
        "\u{1109}\u{1170}\u{11b1}", "\u{c25a}", "\u{1109}\u{1170}\u{11b1}"), ("\u{c25b}",
        "\u{c25b}", "\u{1109}\u{1170}\u{11b2}", "\u{c25b}", "\u{1109}\u{1170}\u{11b2}"),
        ("\u{c25c}", "\u{c25c}", "\u{1109}\u{1170}\u{11b3}", "\u{c25c}",
        "\u{1109}\u{1170}\u{11b3}"), ("\u{c25d}", "\u{c25d}", "\u{1109}\u{1170}\u{11b4}",
        "\u{c25d}", "\u{1109}\u{1170}\u{11b4}"), ("\u{c25e}", "\u{c25e}",
        "\u{1109}\u{1170}\u{11b5}", "\u{c25e}", "\u{1109}\u{1170}\u{11b5}"), ("\u{c25f}",
        "\u{c25f}", "\u{1109}\u{1170}\u{11b6}", "\u{c25f}", "\u{1109}\u{1170}\u{11b6}"),
        ("\u{c260}", "\u{c260}", "\u{1109}\u{1170}\u{11b7}", "\u{c260}",
        "\u{1109}\u{1170}\u{11b7}"), ("\u{c261}", "\u{c261}", "\u{1109}\u{1170}\u{11b8}",
        "\u{c261}", "\u{1109}\u{1170}\u{11b8}"), ("\u{c262}", "\u{c262}",
        "\u{1109}\u{1170}\u{11b9}", "\u{c262}", "\u{1109}\u{1170}\u{11b9}"), ("\u{c263}",
        "\u{c263}", "\u{1109}\u{1170}\u{11ba}", "\u{c263}", "\u{1109}\u{1170}\u{11ba}"),
        ("\u{c264}", "\u{c264}", "\u{1109}\u{1170}\u{11bb}", "\u{c264}",
        "\u{1109}\u{1170}\u{11bb}"), ("\u{c265}", "\u{c265}", "\u{1109}\u{1170}\u{11bc}",
        "\u{c265}", "\u{1109}\u{1170}\u{11bc}"), ("\u{c266}", "\u{c266}",
        "\u{1109}\u{1170}\u{11bd}", "\u{c266}", "\u{1109}\u{1170}\u{11bd}"), ("\u{c267}",
        "\u{c267}", "\u{1109}\u{1170}\u{11be}", "\u{c267}", "\u{1109}\u{1170}\u{11be}"),
        ("\u{c268}", "\u{c268}", "\u{1109}\u{1170}\u{11bf}", "\u{c268}",
        "\u{1109}\u{1170}\u{11bf}"), ("\u{c269}", "\u{c269}", "\u{1109}\u{1170}\u{11c0}",
        "\u{c269}", "\u{1109}\u{1170}\u{11c0}"), ("\u{c26a}", "\u{c26a}",
        "\u{1109}\u{1170}\u{11c1}", "\u{c26a}", "\u{1109}\u{1170}\u{11c1}"), ("\u{c26b}",
        "\u{c26b}", "\u{1109}\u{1170}\u{11c2}", "\u{c26b}", "\u{1109}\u{1170}\u{11c2}"),
        ("\u{c26c}", "\u{c26c}", "\u{1109}\u{1171}", "\u{c26c}", "\u{1109}\u{1171}"), ("\u{c26d}",
        "\u{c26d}", "\u{1109}\u{1171}\u{11a8}", "\u{c26d}", "\u{1109}\u{1171}\u{11a8}"),
        ("\u{c26e}", "\u{c26e}", "\u{1109}\u{1171}\u{11a9}", "\u{c26e}",
        "\u{1109}\u{1171}\u{11a9}"), ("\u{c26f}", "\u{c26f}", "\u{1109}\u{1171}\u{11aa}",
        "\u{c26f}", "\u{1109}\u{1171}\u{11aa}"), ("\u{c270}", "\u{c270}",
        "\u{1109}\u{1171}\u{11ab}", "\u{c270}", "\u{1109}\u{1171}\u{11ab}"), ("\u{c271}",
        "\u{c271}", "\u{1109}\u{1171}\u{11ac}", "\u{c271}", "\u{1109}\u{1171}\u{11ac}"),
        ("\u{c272}", "\u{c272}", "\u{1109}\u{1171}\u{11ad}", "\u{c272}",
        "\u{1109}\u{1171}\u{11ad}"), ("\u{c273}", "\u{c273}", "\u{1109}\u{1171}\u{11ae}",
        "\u{c273}", "\u{1109}\u{1171}\u{11ae}"), ("\u{c274}", "\u{c274}",
        "\u{1109}\u{1171}\u{11af}", "\u{c274}", "\u{1109}\u{1171}\u{11af}"), ("\u{c275}",
        "\u{c275}", "\u{1109}\u{1171}\u{11b0}", "\u{c275}", "\u{1109}\u{1171}\u{11b0}"),
        ("\u{c276}", "\u{c276}", "\u{1109}\u{1171}\u{11b1}", "\u{c276}",
        "\u{1109}\u{1171}\u{11b1}"), ("\u{c277}", "\u{c277}", "\u{1109}\u{1171}\u{11b2}",
        "\u{c277}", "\u{1109}\u{1171}\u{11b2}"), ("\u{c278}", "\u{c278}",
        "\u{1109}\u{1171}\u{11b3}", "\u{c278}", "\u{1109}\u{1171}\u{11b3}"), ("\u{c279}",
        "\u{c279}", "\u{1109}\u{1171}\u{11b4}", "\u{c279}", "\u{1109}\u{1171}\u{11b4}"),
        ("\u{c27a}", "\u{c27a}", "\u{1109}\u{1171}\u{11b5}", "\u{c27a}",
        "\u{1109}\u{1171}\u{11b5}"), ("\u{c27b}", "\u{c27b}", "\u{1109}\u{1171}\u{11b6}",
        "\u{c27b}", "\u{1109}\u{1171}\u{11b6}"), ("\u{c27c}", "\u{c27c}",
        "\u{1109}\u{1171}\u{11b7}", "\u{c27c}", "\u{1109}\u{1171}\u{11b7}"), ("\u{c27d}",
        "\u{c27d}", "\u{1109}\u{1171}\u{11b8}", "\u{c27d}", "\u{1109}\u{1171}\u{11b8}"),
        ("\u{c27e}", "\u{c27e}", "\u{1109}\u{1171}\u{11b9}", "\u{c27e}",
        "\u{1109}\u{1171}\u{11b9}"), ("\u{c27f}", "\u{c27f}", "\u{1109}\u{1171}\u{11ba}",
        "\u{c27f}", "\u{1109}\u{1171}\u{11ba}"), ("\u{c280}", "\u{c280}",
        "\u{1109}\u{1171}\u{11bb}", "\u{c280}", "\u{1109}\u{1171}\u{11bb}"), ("\u{c281}",
        "\u{c281}", "\u{1109}\u{1171}\u{11bc}", "\u{c281}", "\u{1109}\u{1171}\u{11bc}"),
        ("\u{c282}", "\u{c282}", "\u{1109}\u{1171}\u{11bd}", "\u{c282}",
        "\u{1109}\u{1171}\u{11bd}"), ("\u{c283}", "\u{c283}", "\u{1109}\u{1171}\u{11be}",
        "\u{c283}", "\u{1109}\u{1171}\u{11be}"), ("\u{c284}", "\u{c284}",
        "\u{1109}\u{1171}\u{11bf}", "\u{c284}", "\u{1109}\u{1171}\u{11bf}"), ("\u{c285}",
        "\u{c285}", "\u{1109}\u{1171}\u{11c0}", "\u{c285}", "\u{1109}\u{1171}\u{11c0}"),
        ("\u{c286}", "\u{c286}", "\u{1109}\u{1171}\u{11c1}", "\u{c286}",
        "\u{1109}\u{1171}\u{11c1}"), ("\u{c287}", "\u{c287}", "\u{1109}\u{1171}\u{11c2}",
        "\u{c287}", "\u{1109}\u{1171}\u{11c2}"), ("\u{c288}", "\u{c288}", "\u{1109}\u{1172}",
        "\u{c288}", "\u{1109}\u{1172}"), ("\u{c289}", "\u{c289}", "\u{1109}\u{1172}\u{11a8}",
        "\u{c289}", "\u{1109}\u{1172}\u{11a8}"), ("\u{c28a}", "\u{c28a}",
        "\u{1109}\u{1172}\u{11a9}", "\u{c28a}", "\u{1109}\u{1172}\u{11a9}"), ("\u{c28b}",
        "\u{c28b}", "\u{1109}\u{1172}\u{11aa}", "\u{c28b}", "\u{1109}\u{1172}\u{11aa}"),
        ("\u{c28c}", "\u{c28c}", "\u{1109}\u{1172}\u{11ab}", "\u{c28c}",
        "\u{1109}\u{1172}\u{11ab}"), ("\u{c28d}", "\u{c28d}", "\u{1109}\u{1172}\u{11ac}",
        "\u{c28d}", "\u{1109}\u{1172}\u{11ac}"), ("\u{c28e}", "\u{c28e}",
        "\u{1109}\u{1172}\u{11ad}", "\u{c28e}", "\u{1109}\u{1172}\u{11ad}"), ("\u{c28f}",
        "\u{c28f}", "\u{1109}\u{1172}\u{11ae}", "\u{c28f}", "\u{1109}\u{1172}\u{11ae}"),
        ("\u{c290}", "\u{c290}", "\u{1109}\u{1172}\u{11af}", "\u{c290}",
        "\u{1109}\u{1172}\u{11af}"), ("\u{c291}", "\u{c291}", "\u{1109}\u{1172}\u{11b0}",
        "\u{c291}", "\u{1109}\u{1172}\u{11b0}"), ("\u{c292}", "\u{c292}",
        "\u{1109}\u{1172}\u{11b1}", "\u{c292}", "\u{1109}\u{1172}\u{11b1}"), ("\u{c293}",
        "\u{c293}", "\u{1109}\u{1172}\u{11b2}", "\u{c293}", "\u{1109}\u{1172}\u{11b2}"),
        ("\u{c294}", "\u{c294}", "\u{1109}\u{1172}\u{11b3}", "\u{c294}",
        "\u{1109}\u{1172}\u{11b3}"), ("\u{c295}", "\u{c295}", "\u{1109}\u{1172}\u{11b4}",
        "\u{c295}", "\u{1109}\u{1172}\u{11b4}"), ("\u{c296}", "\u{c296}",
        "\u{1109}\u{1172}\u{11b5}", "\u{c296}", "\u{1109}\u{1172}\u{11b5}"), ("\u{c297}",
        "\u{c297}", "\u{1109}\u{1172}\u{11b6}", "\u{c297}", "\u{1109}\u{1172}\u{11b6}"),
        ("\u{c298}", "\u{c298}", "\u{1109}\u{1172}\u{11b7}", "\u{c298}",
        "\u{1109}\u{1172}\u{11b7}"), ("\u{c299}", "\u{c299}", "\u{1109}\u{1172}\u{11b8}",
        "\u{c299}", "\u{1109}\u{1172}\u{11b8}"), ("\u{c29a}", "\u{c29a}",
        "\u{1109}\u{1172}\u{11b9}", "\u{c29a}", "\u{1109}\u{1172}\u{11b9}"), ("\u{c29b}",
        "\u{c29b}", "\u{1109}\u{1172}\u{11ba}", "\u{c29b}", "\u{1109}\u{1172}\u{11ba}"),
        ("\u{c29c}", "\u{c29c}", "\u{1109}\u{1172}\u{11bb}", "\u{c29c}",
        "\u{1109}\u{1172}\u{11bb}"), ("\u{c29d}", "\u{c29d}", "\u{1109}\u{1172}\u{11bc}",
        "\u{c29d}", "\u{1109}\u{1172}\u{11bc}"), ("\u{c29e}", "\u{c29e}",
        "\u{1109}\u{1172}\u{11bd}", "\u{c29e}", "\u{1109}\u{1172}\u{11bd}"), ("\u{c29f}",
        "\u{c29f}", "\u{1109}\u{1172}\u{11be}", "\u{c29f}", "\u{1109}\u{1172}\u{11be}"),
        ("\u{c2a0}", "\u{c2a0}", "\u{1109}\u{1172}\u{11bf}", "\u{c2a0}",
        "\u{1109}\u{1172}\u{11bf}"), ("\u{c2a1}", "\u{c2a1}", "\u{1109}\u{1172}\u{11c0}",
        "\u{c2a1}", "\u{1109}\u{1172}\u{11c0}"), ("\u{c2a2}", "\u{c2a2}",
        "\u{1109}\u{1172}\u{11c1}", "\u{c2a2}", "\u{1109}\u{1172}\u{11c1}"), ("\u{c2a3}",
        "\u{c2a3}", "\u{1109}\u{1172}\u{11c2}", "\u{c2a3}", "\u{1109}\u{1172}\u{11c2}"),
        ("\u{c2a4}", "\u{c2a4}", "\u{1109}\u{1173}", "\u{c2a4}", "\u{1109}\u{1173}"), ("\u{c2a5}",
        "\u{c2a5}", "\u{1109}\u{1173}\u{11a8}", "\u{c2a5}", "\u{1109}\u{1173}\u{11a8}"),
        ("\u{c2a6}", "\u{c2a6}", "\u{1109}\u{1173}\u{11a9}", "\u{c2a6}",
        "\u{1109}\u{1173}\u{11a9}"), ("\u{c2a7}", "\u{c2a7}", "\u{1109}\u{1173}\u{11aa}",
        "\u{c2a7}", "\u{1109}\u{1173}\u{11aa}"), ("\u{c2a8}", "\u{c2a8}",
        "\u{1109}\u{1173}\u{11ab}", "\u{c2a8}", "\u{1109}\u{1173}\u{11ab}"), ("\u{c2a9}",
        "\u{c2a9}", "\u{1109}\u{1173}\u{11ac}", "\u{c2a9}", "\u{1109}\u{1173}\u{11ac}"),
        ("\u{c2aa}", "\u{c2aa}", "\u{1109}\u{1173}\u{11ad}", "\u{c2aa}",
        "\u{1109}\u{1173}\u{11ad}"), ("\u{c2ab}", "\u{c2ab}", "\u{1109}\u{1173}\u{11ae}",
        "\u{c2ab}", "\u{1109}\u{1173}\u{11ae}"), ("\u{c2ac}", "\u{c2ac}",
        "\u{1109}\u{1173}\u{11af}", "\u{c2ac}", "\u{1109}\u{1173}\u{11af}"), ("\u{c2ad}",
        "\u{c2ad}", "\u{1109}\u{1173}\u{11b0}", "\u{c2ad}", "\u{1109}\u{1173}\u{11b0}"),
        ("\u{c2ae}", "\u{c2ae}", "\u{1109}\u{1173}\u{11b1}", "\u{c2ae}",
        "\u{1109}\u{1173}\u{11b1}"), ("\u{c2af}", "\u{c2af}", "\u{1109}\u{1173}\u{11b2}",
        "\u{c2af}", "\u{1109}\u{1173}\u{11b2}"), ("\u{c2b0}", "\u{c2b0}",
        "\u{1109}\u{1173}\u{11b3}", "\u{c2b0}", "\u{1109}\u{1173}\u{11b3}"), ("\u{c2b1}",
        "\u{c2b1}", "\u{1109}\u{1173}\u{11b4}", "\u{c2b1}", "\u{1109}\u{1173}\u{11b4}"),
        ("\u{c2b2}", "\u{c2b2}", "\u{1109}\u{1173}\u{11b5}", "\u{c2b2}",
        "\u{1109}\u{1173}\u{11b5}"), ("\u{c2b3}", "\u{c2b3}", "\u{1109}\u{1173}\u{11b6}",
        "\u{c2b3}", "\u{1109}\u{1173}\u{11b6}"), ("\u{c2b4}", "\u{c2b4}",
        "\u{1109}\u{1173}\u{11b7}", "\u{c2b4}", "\u{1109}\u{1173}\u{11b7}"), ("\u{c2b5}",
        "\u{c2b5}", "\u{1109}\u{1173}\u{11b8}", "\u{c2b5}", "\u{1109}\u{1173}\u{11b8}"),
        ("\u{c2b6}", "\u{c2b6}", "\u{1109}\u{1173}\u{11b9}", "\u{c2b6}",
        "\u{1109}\u{1173}\u{11b9}"), ("\u{c2b7}", "\u{c2b7}", "\u{1109}\u{1173}\u{11ba}",
        "\u{c2b7}", "\u{1109}\u{1173}\u{11ba}"), ("\u{c2b8}", "\u{c2b8}",
        "\u{1109}\u{1173}\u{11bb}", "\u{c2b8}", "\u{1109}\u{1173}\u{11bb}"), ("\u{c2b9}",
        "\u{c2b9}", "\u{1109}\u{1173}\u{11bc}", "\u{c2b9}", "\u{1109}\u{1173}\u{11bc}"),
        ("\u{c2ba}", "\u{c2ba}", "\u{1109}\u{1173}\u{11bd}", "\u{c2ba}",
        "\u{1109}\u{1173}\u{11bd}"), ("\u{c2bb}", "\u{c2bb}", "\u{1109}\u{1173}\u{11be}",
        "\u{c2bb}", "\u{1109}\u{1173}\u{11be}"), ("\u{c2bc}", "\u{c2bc}",
        "\u{1109}\u{1173}\u{11bf}", "\u{c2bc}", "\u{1109}\u{1173}\u{11bf}"), ("\u{c2bd}",
        "\u{c2bd}", "\u{1109}\u{1173}\u{11c0}", "\u{c2bd}", "\u{1109}\u{1173}\u{11c0}"),
        ("\u{c2be}", "\u{c2be}", "\u{1109}\u{1173}\u{11c1}", "\u{c2be}",
        "\u{1109}\u{1173}\u{11c1}"), ("\u{c2bf}", "\u{c2bf}", "\u{1109}\u{1173}\u{11c2}",
        "\u{c2bf}", "\u{1109}\u{1173}\u{11c2}"), ("\u{c2c0}", "\u{c2c0}", "\u{1109}\u{1174}",
        "\u{c2c0}", "\u{1109}\u{1174}"), ("\u{c2c1}", "\u{c2c1}", "\u{1109}\u{1174}\u{11a8}",
        "\u{c2c1}", "\u{1109}\u{1174}\u{11a8}"), ("\u{c2c2}", "\u{c2c2}",
        "\u{1109}\u{1174}\u{11a9}", "\u{c2c2}", "\u{1109}\u{1174}\u{11a9}"), ("\u{c2c3}",
        "\u{c2c3}", "\u{1109}\u{1174}\u{11aa}", "\u{c2c3}", "\u{1109}\u{1174}\u{11aa}"),
        ("\u{c2c4}", "\u{c2c4}", "\u{1109}\u{1174}\u{11ab}", "\u{c2c4}",
        "\u{1109}\u{1174}\u{11ab}"), ("\u{c2c5}", "\u{c2c5}", "\u{1109}\u{1174}\u{11ac}",
        "\u{c2c5}", "\u{1109}\u{1174}\u{11ac}"), ("\u{c2c6}", "\u{c2c6}",
        "\u{1109}\u{1174}\u{11ad}", "\u{c2c6}", "\u{1109}\u{1174}\u{11ad}"), ("\u{c2c7}",
        "\u{c2c7}", "\u{1109}\u{1174}\u{11ae}", "\u{c2c7}", "\u{1109}\u{1174}\u{11ae}"),
        ("\u{c2c8}", "\u{c2c8}", "\u{1109}\u{1174}\u{11af}", "\u{c2c8}",
        "\u{1109}\u{1174}\u{11af}"), ("\u{c2c9}", "\u{c2c9}", "\u{1109}\u{1174}\u{11b0}",
        "\u{c2c9}", "\u{1109}\u{1174}\u{11b0}"), ("\u{c2ca}", "\u{c2ca}",
        "\u{1109}\u{1174}\u{11b1}", "\u{c2ca}", "\u{1109}\u{1174}\u{11b1}"), ("\u{c2cb}",
        "\u{c2cb}", "\u{1109}\u{1174}\u{11b2}", "\u{c2cb}", "\u{1109}\u{1174}\u{11b2}"),
        ("\u{c2cc}", "\u{c2cc}", "\u{1109}\u{1174}\u{11b3}", "\u{c2cc}",
        "\u{1109}\u{1174}\u{11b3}"), ("\u{c2cd}", "\u{c2cd}", "\u{1109}\u{1174}\u{11b4}",
        "\u{c2cd}", "\u{1109}\u{1174}\u{11b4}"), ("\u{c2ce}", "\u{c2ce}",
        "\u{1109}\u{1174}\u{11b5}", "\u{c2ce}", "\u{1109}\u{1174}\u{11b5}"), ("\u{c2cf}",
        "\u{c2cf}", "\u{1109}\u{1174}\u{11b6}", "\u{c2cf}", "\u{1109}\u{1174}\u{11b6}"),
        ("\u{c2d0}", "\u{c2d0}", "\u{1109}\u{1174}\u{11b7}", "\u{c2d0}",
        "\u{1109}\u{1174}\u{11b7}"), ("\u{c2d1}", "\u{c2d1}", "\u{1109}\u{1174}\u{11b8}",
        "\u{c2d1}", "\u{1109}\u{1174}\u{11b8}"), ("\u{c2d2}", "\u{c2d2}",
        "\u{1109}\u{1174}\u{11b9}", "\u{c2d2}", "\u{1109}\u{1174}\u{11b9}"), ("\u{c2d3}",
        "\u{c2d3}", "\u{1109}\u{1174}\u{11ba}", "\u{c2d3}", "\u{1109}\u{1174}\u{11ba}"),
        ("\u{c2d4}", "\u{c2d4}", "\u{1109}\u{1174}\u{11bb}", "\u{c2d4}",
        "\u{1109}\u{1174}\u{11bb}"), ("\u{c2d5}", "\u{c2d5}", "\u{1109}\u{1174}\u{11bc}",
        "\u{c2d5}", "\u{1109}\u{1174}\u{11bc}"), ("\u{c2d6}", "\u{c2d6}",
        "\u{1109}\u{1174}\u{11bd}", "\u{c2d6}", "\u{1109}\u{1174}\u{11bd}"), ("\u{c2d7}",
        "\u{c2d7}", "\u{1109}\u{1174}\u{11be}", "\u{c2d7}", "\u{1109}\u{1174}\u{11be}"),
        ("\u{c2d8}", "\u{c2d8}", "\u{1109}\u{1174}\u{11bf}", "\u{c2d8}",
        "\u{1109}\u{1174}\u{11bf}"), ("\u{c2d9}", "\u{c2d9}", "\u{1109}\u{1174}\u{11c0}",
        "\u{c2d9}", "\u{1109}\u{1174}\u{11c0}"), ("\u{c2da}", "\u{c2da}",
        "\u{1109}\u{1174}\u{11c1}", "\u{c2da}", "\u{1109}\u{1174}\u{11c1}"), ("\u{c2db}",
        "\u{c2db}", "\u{1109}\u{1174}\u{11c2}", "\u{c2db}", "\u{1109}\u{1174}\u{11c2}"),
        ("\u{c2dc}", "\u{c2dc}", "\u{1109}\u{1175}", "\u{c2dc}", "\u{1109}\u{1175}"), ("\u{c2dd}",
        "\u{c2dd}", "\u{1109}\u{1175}\u{11a8}", "\u{c2dd}", "\u{1109}\u{1175}\u{11a8}"),
        ("\u{c2de}", "\u{c2de}", "\u{1109}\u{1175}\u{11a9}", "\u{c2de}",
        "\u{1109}\u{1175}\u{11a9}"), ("\u{c2df}", "\u{c2df}", "\u{1109}\u{1175}\u{11aa}",
        "\u{c2df}", "\u{1109}\u{1175}\u{11aa}"), ("\u{c2e0}", "\u{c2e0}",
        "\u{1109}\u{1175}\u{11ab}", "\u{c2e0}", "\u{1109}\u{1175}\u{11ab}"), ("\u{c2e1}",
        "\u{c2e1}", "\u{1109}\u{1175}\u{11ac}", "\u{c2e1}", "\u{1109}\u{1175}\u{11ac}"),
        ("\u{c2e2}", "\u{c2e2}", "\u{1109}\u{1175}\u{11ad}", "\u{c2e2}",
        "\u{1109}\u{1175}\u{11ad}"), ("\u{c2e3}", "\u{c2e3}", "\u{1109}\u{1175}\u{11ae}",
        "\u{c2e3}", "\u{1109}\u{1175}\u{11ae}"), ("\u{c2e4}", "\u{c2e4}",
        "\u{1109}\u{1175}\u{11af}", "\u{c2e4}", "\u{1109}\u{1175}\u{11af}"), ("\u{c2e5}",
        "\u{c2e5}", "\u{1109}\u{1175}\u{11b0}", "\u{c2e5}", "\u{1109}\u{1175}\u{11b0}"),
        ("\u{c2e6}", "\u{c2e6}", "\u{1109}\u{1175}\u{11b1}", "\u{c2e6}",
        "\u{1109}\u{1175}\u{11b1}"), ("\u{c2e7}", "\u{c2e7}", "\u{1109}\u{1175}\u{11b2}",
        "\u{c2e7}", "\u{1109}\u{1175}\u{11b2}"), ("\u{c2e8}", "\u{c2e8}",
        "\u{1109}\u{1175}\u{11b3}", "\u{c2e8}", "\u{1109}\u{1175}\u{11b3}"), ("\u{c2e9}",
        "\u{c2e9}", "\u{1109}\u{1175}\u{11b4}", "\u{c2e9}", "\u{1109}\u{1175}\u{11b4}"),
        ("\u{c2ea}", "\u{c2ea}", "\u{1109}\u{1175}\u{11b5}", "\u{c2ea}",
        "\u{1109}\u{1175}\u{11b5}"), ("\u{c2eb}", "\u{c2eb}", "\u{1109}\u{1175}\u{11b6}",
        "\u{c2eb}", "\u{1109}\u{1175}\u{11b6}"), ("\u{c2ec}", "\u{c2ec}",
        "\u{1109}\u{1175}\u{11b7}", "\u{c2ec}", "\u{1109}\u{1175}\u{11b7}"), ("\u{c2ed}",
        "\u{c2ed}", "\u{1109}\u{1175}\u{11b8}", "\u{c2ed}", "\u{1109}\u{1175}\u{11b8}"),
        ("\u{c2ee}", "\u{c2ee}", "\u{1109}\u{1175}\u{11b9}", "\u{c2ee}",
        "\u{1109}\u{1175}\u{11b9}"), ("\u{c2ef}", "\u{c2ef}", "\u{1109}\u{1175}\u{11ba}",
        "\u{c2ef}", "\u{1109}\u{1175}\u{11ba}"), ("\u{c2f0}", "\u{c2f0}",
        "\u{1109}\u{1175}\u{11bb}", "\u{c2f0}", "\u{1109}\u{1175}\u{11bb}"), ("\u{c2f1}",
        "\u{c2f1}", "\u{1109}\u{1175}\u{11bc}", "\u{c2f1}", "\u{1109}\u{1175}\u{11bc}"),
        ("\u{c2f2}", "\u{c2f2}", "\u{1109}\u{1175}\u{11bd}", "\u{c2f2}",
        "\u{1109}\u{1175}\u{11bd}"), ("\u{c2f3}", "\u{c2f3}", "\u{1109}\u{1175}\u{11be}",
        "\u{c2f3}", "\u{1109}\u{1175}\u{11be}"), ("\u{c2f4}", "\u{c2f4}",
        "\u{1109}\u{1175}\u{11bf}", "\u{c2f4}", "\u{1109}\u{1175}\u{11bf}"), ("\u{c2f5}",
        "\u{c2f5}", "\u{1109}\u{1175}\u{11c0}", "\u{c2f5}", "\u{1109}\u{1175}\u{11c0}"),
        ("\u{c2f6}", "\u{c2f6}", "\u{1109}\u{1175}\u{11c1}", "\u{c2f6}",
        "\u{1109}\u{1175}\u{11c1}"), ("\u{c2f7}", "\u{c2f7}", "\u{1109}\u{1175}\u{11c2}",
        "\u{c2f7}", "\u{1109}\u{1175}\u{11c2}"), ("\u{c2f8}", "\u{c2f8}", "\u{110a}\u{1161}",
        "\u{c2f8}", "\u{110a}\u{1161}"), ("\u{c2f9}", "\u{c2f9}", "\u{110a}\u{1161}\u{11a8}",
        "\u{c2f9}", "\u{110a}\u{1161}\u{11a8}"), ("\u{c2fa}", "\u{c2fa}",
        "\u{110a}\u{1161}\u{11a9}", "\u{c2fa}", "\u{110a}\u{1161}\u{11a9}"), ("\u{c2fb}",
        "\u{c2fb}", "\u{110a}\u{1161}\u{11aa}", "\u{c2fb}", "\u{110a}\u{1161}\u{11aa}"),
        ("\u{c2fc}", "\u{c2fc}", "\u{110a}\u{1161}\u{11ab}", "\u{c2fc}",
        "\u{110a}\u{1161}\u{11ab}"), ("\u{c2fd}", "\u{c2fd}", "\u{110a}\u{1161}\u{11ac}",
        "\u{c2fd}", "\u{110a}\u{1161}\u{11ac}"), ("\u{c2fe}", "\u{c2fe}",
        "\u{110a}\u{1161}\u{11ad}", "\u{c2fe}", "\u{110a}\u{1161}\u{11ad}"), ("\u{c2ff}",
        "\u{c2ff}", "\u{110a}\u{1161}\u{11ae}", "\u{c2ff}", "\u{110a}\u{1161}\u{11ae}"),
        ("\u{c300}", "\u{c300}", "\u{110a}\u{1161}\u{11af}", "\u{c300}",
        "\u{110a}\u{1161}\u{11af}"), ("\u{c301}", "\u{c301}", "\u{110a}\u{1161}\u{11b0}",
        "\u{c301}", "\u{110a}\u{1161}\u{11b0}"), ("\u{c302}", "\u{c302}",
        "\u{110a}\u{1161}\u{11b1}", "\u{c302}", "\u{110a}\u{1161}\u{11b1}"), ("\u{c303}",
        "\u{c303}", "\u{110a}\u{1161}\u{11b2}", "\u{c303}", "\u{110a}\u{1161}\u{11b2}"),
        ("\u{c304}", "\u{c304}", "\u{110a}\u{1161}\u{11b3}", "\u{c304}",
        "\u{110a}\u{1161}\u{11b3}"), ("\u{c305}", "\u{c305}", "\u{110a}\u{1161}\u{11b4}",
        "\u{c305}", "\u{110a}\u{1161}\u{11b4}"), ("\u{c306}", "\u{c306}",
        "\u{110a}\u{1161}\u{11b5}", "\u{c306}", "\u{110a}\u{1161}\u{11b5}"), ("\u{c307}",
        "\u{c307}", "\u{110a}\u{1161}\u{11b6}", "\u{c307}", "\u{110a}\u{1161}\u{11b6}"),
        ("\u{c308}", "\u{c308}", "\u{110a}\u{1161}\u{11b7}", "\u{c308}",
        "\u{110a}\u{1161}\u{11b7}"), ("\u{c309}", "\u{c309}", "\u{110a}\u{1161}\u{11b8}",
        "\u{c309}", "\u{110a}\u{1161}\u{11b8}"), ("\u{c30a}", "\u{c30a}",
        "\u{110a}\u{1161}\u{11b9}", "\u{c30a}", "\u{110a}\u{1161}\u{11b9}"), ("\u{c30b}",
        "\u{c30b}", "\u{110a}\u{1161}\u{11ba}", "\u{c30b}", "\u{110a}\u{1161}\u{11ba}"),
        ("\u{c30c}", "\u{c30c}", "\u{110a}\u{1161}\u{11bb}", "\u{c30c}",
        "\u{110a}\u{1161}\u{11bb}"), ("\u{c30d}", "\u{c30d}", "\u{110a}\u{1161}\u{11bc}",
        "\u{c30d}", "\u{110a}\u{1161}\u{11bc}"), ("\u{c30e}", "\u{c30e}",
        "\u{110a}\u{1161}\u{11bd}", "\u{c30e}", "\u{110a}\u{1161}\u{11bd}"), ("\u{c30f}",
        "\u{c30f}", "\u{110a}\u{1161}\u{11be}", "\u{c30f}", "\u{110a}\u{1161}\u{11be}"),
        ("\u{c310}", "\u{c310}", "\u{110a}\u{1161}\u{11bf}", "\u{c310}",
        "\u{110a}\u{1161}\u{11bf}"), ("\u{c311}", "\u{c311}", "\u{110a}\u{1161}\u{11c0}",
        "\u{c311}", "\u{110a}\u{1161}\u{11c0}"), ("\u{c312}", "\u{c312}",
        "\u{110a}\u{1161}\u{11c1}", "\u{c312}", "\u{110a}\u{1161}\u{11c1}"), ("\u{c313}",
        "\u{c313}", "\u{110a}\u{1161}\u{11c2}", "\u{c313}", "\u{110a}\u{1161}\u{11c2}"),
        ("\u{c314}", "\u{c314}", "\u{110a}\u{1162}", "\u{c314}", "\u{110a}\u{1162}"), ("\u{c315}",
        "\u{c315}", "\u{110a}\u{1162}\u{11a8}", "\u{c315}", "\u{110a}\u{1162}\u{11a8}"),
        ("\u{c316}", "\u{c316}", "\u{110a}\u{1162}\u{11a9}", "\u{c316}",
        "\u{110a}\u{1162}\u{11a9}"), ("\u{c317}", "\u{c317}", "\u{110a}\u{1162}\u{11aa}",
        "\u{c317}", "\u{110a}\u{1162}\u{11aa}"), ("\u{c318}", "\u{c318}",
        "\u{110a}\u{1162}\u{11ab}", "\u{c318}", "\u{110a}\u{1162}\u{11ab}"), ("\u{c319}",
        "\u{c319}", "\u{110a}\u{1162}\u{11ac}", "\u{c319}", "\u{110a}\u{1162}\u{11ac}"),
        ("\u{c31a}", "\u{c31a}", "\u{110a}\u{1162}\u{11ad}", "\u{c31a}",
        "\u{110a}\u{1162}\u{11ad}"), ("\u{c31b}", "\u{c31b}", "\u{110a}\u{1162}\u{11ae}",
        "\u{c31b}", "\u{110a}\u{1162}\u{11ae}"), ("\u{c31c}", "\u{c31c}",
        "\u{110a}\u{1162}\u{11af}", "\u{c31c}", "\u{110a}\u{1162}\u{11af}"), ("\u{c31d}",
        "\u{c31d}", "\u{110a}\u{1162}\u{11b0}", "\u{c31d}", "\u{110a}\u{1162}\u{11b0}"),
        ("\u{c31e}", "\u{c31e}", "\u{110a}\u{1162}\u{11b1}", "\u{c31e}",
        "\u{110a}\u{1162}\u{11b1}"), ("\u{c31f}", "\u{c31f}", "\u{110a}\u{1162}\u{11b2}",
        "\u{c31f}", "\u{110a}\u{1162}\u{11b2}"), ("\u{c320}", "\u{c320}",
        "\u{110a}\u{1162}\u{11b3}", "\u{c320}", "\u{110a}\u{1162}\u{11b3}"), ("\u{c321}",
        "\u{c321}", "\u{110a}\u{1162}\u{11b4}", "\u{c321}", "\u{110a}\u{1162}\u{11b4}"),
        ("\u{c322}", "\u{c322}", "\u{110a}\u{1162}\u{11b5}", "\u{c322}",
        "\u{110a}\u{1162}\u{11b5}"), ("\u{c323}", "\u{c323}", "\u{110a}\u{1162}\u{11b6}",
        "\u{c323}", "\u{110a}\u{1162}\u{11b6}"), ("\u{c324}", "\u{c324}",
        "\u{110a}\u{1162}\u{11b7}", "\u{c324}", "\u{110a}\u{1162}\u{11b7}"), ("\u{c325}",
        "\u{c325}", "\u{110a}\u{1162}\u{11b8}", "\u{c325}", "\u{110a}\u{1162}\u{11b8}"),
        ("\u{c326}", "\u{c326}", "\u{110a}\u{1162}\u{11b9}", "\u{c326}",
        "\u{110a}\u{1162}\u{11b9}"), ("\u{c327}", "\u{c327}", "\u{110a}\u{1162}\u{11ba}",
        "\u{c327}", "\u{110a}\u{1162}\u{11ba}"), ("\u{c328}", "\u{c328}",
        "\u{110a}\u{1162}\u{11bb}", "\u{c328}", "\u{110a}\u{1162}\u{11bb}"), ("\u{c329}",
        "\u{c329}", "\u{110a}\u{1162}\u{11bc}", "\u{c329}", "\u{110a}\u{1162}\u{11bc}"),
        ("\u{c32a}", "\u{c32a}", "\u{110a}\u{1162}\u{11bd}", "\u{c32a}",
        "\u{110a}\u{1162}\u{11bd}"), ("\u{c32b}", "\u{c32b}", "\u{110a}\u{1162}\u{11be}",
        "\u{c32b}", "\u{110a}\u{1162}\u{11be}"), ("\u{c32c}", "\u{c32c}",
        "\u{110a}\u{1162}\u{11bf}", "\u{c32c}", "\u{110a}\u{1162}\u{11bf}"), ("\u{c32d}",
        "\u{c32d}", "\u{110a}\u{1162}\u{11c0}", "\u{c32d}", "\u{110a}\u{1162}\u{11c0}"),
        ("\u{c32e}", "\u{c32e}", "\u{110a}\u{1162}\u{11c1}", "\u{c32e}",
        "\u{110a}\u{1162}\u{11c1}"), ("\u{c32f}", "\u{c32f}", "\u{110a}\u{1162}\u{11c2}",
        "\u{c32f}", "\u{110a}\u{1162}\u{11c2}"), ("\u{c330}", "\u{c330}", "\u{110a}\u{1163}",
        "\u{c330}", "\u{110a}\u{1163}"), ("\u{c331}", "\u{c331}", "\u{110a}\u{1163}\u{11a8}",
        "\u{c331}", "\u{110a}\u{1163}\u{11a8}"), ("\u{c332}", "\u{c332}",
        "\u{110a}\u{1163}\u{11a9}", "\u{c332}", "\u{110a}\u{1163}\u{11a9}"), ("\u{c333}",
        "\u{c333}", "\u{110a}\u{1163}\u{11aa}", "\u{c333}", "\u{110a}\u{1163}\u{11aa}"),
        ("\u{c334}", "\u{c334}", "\u{110a}\u{1163}\u{11ab}", "\u{c334}",
        "\u{110a}\u{1163}\u{11ab}"), ("\u{c335}", "\u{c335}", "\u{110a}\u{1163}\u{11ac}",
        "\u{c335}", "\u{110a}\u{1163}\u{11ac}"), ("\u{c336}", "\u{c336}",
        "\u{110a}\u{1163}\u{11ad}", "\u{c336}", "\u{110a}\u{1163}\u{11ad}"), ("\u{c337}",
        "\u{c337}", "\u{110a}\u{1163}\u{11ae}", "\u{c337}", "\u{110a}\u{1163}\u{11ae}"),
        ("\u{c338}", "\u{c338}", "\u{110a}\u{1163}\u{11af}", "\u{c338}",
        "\u{110a}\u{1163}\u{11af}"), ("\u{c339}", "\u{c339}", "\u{110a}\u{1163}\u{11b0}",
        "\u{c339}", "\u{110a}\u{1163}\u{11b0}"), ("\u{c33a}", "\u{c33a}",
        "\u{110a}\u{1163}\u{11b1}", "\u{c33a}", "\u{110a}\u{1163}\u{11b1}"), ("\u{c33b}",
        "\u{c33b}", "\u{110a}\u{1163}\u{11b2}", "\u{c33b}", "\u{110a}\u{1163}\u{11b2}"),
        ("\u{c33c}", "\u{c33c}", "\u{110a}\u{1163}\u{11b3}", "\u{c33c}",
        "\u{110a}\u{1163}\u{11b3}"), ("\u{c33d}", "\u{c33d}", "\u{110a}\u{1163}\u{11b4}",
        "\u{c33d}", "\u{110a}\u{1163}\u{11b4}"), ("\u{c33e}", "\u{c33e}",
        "\u{110a}\u{1163}\u{11b5}", "\u{c33e}", "\u{110a}\u{1163}\u{11b5}"), ("\u{c33f}",
        "\u{c33f}", "\u{110a}\u{1163}\u{11b6}", "\u{c33f}", "\u{110a}\u{1163}\u{11b6}"),
        ("\u{c340}", "\u{c340}", "\u{110a}\u{1163}\u{11b7}", "\u{c340}",
        "\u{110a}\u{1163}\u{11b7}"), ("\u{c341}", "\u{c341}", "\u{110a}\u{1163}\u{11b8}",
        "\u{c341}", "\u{110a}\u{1163}\u{11b8}"), ("\u{c342}", "\u{c342}",
        "\u{110a}\u{1163}\u{11b9}", "\u{c342}", "\u{110a}\u{1163}\u{11b9}"), ("\u{c343}",
        "\u{c343}", "\u{110a}\u{1163}\u{11ba}", "\u{c343}", "\u{110a}\u{1163}\u{11ba}"),
        ("\u{c344}", "\u{c344}", "\u{110a}\u{1163}\u{11bb}", "\u{c344}",
        "\u{110a}\u{1163}\u{11bb}"), ("\u{c345}", "\u{c345}", "\u{110a}\u{1163}\u{11bc}",
        "\u{c345}", "\u{110a}\u{1163}\u{11bc}"), ("\u{c346}", "\u{c346}",
        "\u{110a}\u{1163}\u{11bd}", "\u{c346}", "\u{110a}\u{1163}\u{11bd}"), ("\u{c347}",
        "\u{c347}", "\u{110a}\u{1163}\u{11be}", "\u{c347}", "\u{110a}\u{1163}\u{11be}"),
        ("\u{c348}", "\u{c348}", "\u{110a}\u{1163}\u{11bf}", "\u{c348}",
        "\u{110a}\u{1163}\u{11bf}"), ("\u{c349}", "\u{c349}", "\u{110a}\u{1163}\u{11c0}",
        "\u{c349}", "\u{110a}\u{1163}\u{11c0}"), ("\u{c34a}", "\u{c34a}",
        "\u{110a}\u{1163}\u{11c1}", "\u{c34a}", "\u{110a}\u{1163}\u{11c1}"), ("\u{c34b}",
        "\u{c34b}", "\u{110a}\u{1163}\u{11c2}", "\u{c34b}", "\u{110a}\u{1163}\u{11c2}"),
        ("\u{c34c}", "\u{c34c}", "\u{110a}\u{1164}", "\u{c34c}", "\u{110a}\u{1164}"), ("\u{c34d}",
        "\u{c34d}", "\u{110a}\u{1164}\u{11a8}", "\u{c34d}", "\u{110a}\u{1164}\u{11a8}"),
        ("\u{c34e}", "\u{c34e}", "\u{110a}\u{1164}\u{11a9}", "\u{c34e}",
        "\u{110a}\u{1164}\u{11a9}"), ("\u{c34f}", "\u{c34f}", "\u{110a}\u{1164}\u{11aa}",
        "\u{c34f}", "\u{110a}\u{1164}\u{11aa}"), ("\u{c350}", "\u{c350}",
        "\u{110a}\u{1164}\u{11ab}", "\u{c350}", "\u{110a}\u{1164}\u{11ab}"), ("\u{c351}",
        "\u{c351}", "\u{110a}\u{1164}\u{11ac}", "\u{c351}", "\u{110a}\u{1164}\u{11ac}"),
        ("\u{c352}", "\u{c352}", "\u{110a}\u{1164}\u{11ad}", "\u{c352}",
        "\u{110a}\u{1164}\u{11ad}"), ("\u{c353}", "\u{c353}", "\u{110a}\u{1164}\u{11ae}",
        "\u{c353}", "\u{110a}\u{1164}\u{11ae}"), ("\u{c354}", "\u{c354}",
        "\u{110a}\u{1164}\u{11af}", "\u{c354}", "\u{110a}\u{1164}\u{11af}"), ("\u{c355}",
        "\u{c355}", "\u{110a}\u{1164}\u{11b0}", "\u{c355}", "\u{110a}\u{1164}\u{11b0}"),
        ("\u{c356}", "\u{c356}", "\u{110a}\u{1164}\u{11b1}", "\u{c356}",
        "\u{110a}\u{1164}\u{11b1}"), ("\u{c357}", "\u{c357}", "\u{110a}\u{1164}\u{11b2}",
        "\u{c357}", "\u{110a}\u{1164}\u{11b2}"), ("\u{c358}", "\u{c358}",
        "\u{110a}\u{1164}\u{11b3}", "\u{c358}", "\u{110a}\u{1164}\u{11b3}"), ("\u{c359}",
        "\u{c359}", "\u{110a}\u{1164}\u{11b4}", "\u{c359}", "\u{110a}\u{1164}\u{11b4}"),
        ("\u{c35a}", "\u{c35a}", "\u{110a}\u{1164}\u{11b5}", "\u{c35a}",
        "\u{110a}\u{1164}\u{11b5}"), ("\u{c35b}", "\u{c35b}", "\u{110a}\u{1164}\u{11b6}",
        "\u{c35b}", "\u{110a}\u{1164}\u{11b6}"), ("\u{c35c}", "\u{c35c}",
        "\u{110a}\u{1164}\u{11b7}", "\u{c35c}", "\u{110a}\u{1164}\u{11b7}"), ("\u{c35d}",
        "\u{c35d}", "\u{110a}\u{1164}\u{11b8}", "\u{c35d}", "\u{110a}\u{1164}\u{11b8}"),
        ("\u{c35e}", "\u{c35e}", "\u{110a}\u{1164}\u{11b9}", "\u{c35e}",
        "\u{110a}\u{1164}\u{11b9}"), ("\u{c35f}", "\u{c35f}", "\u{110a}\u{1164}\u{11ba}",
        "\u{c35f}", "\u{110a}\u{1164}\u{11ba}"), ("\u{c360}", "\u{c360}",
        "\u{110a}\u{1164}\u{11bb}", "\u{c360}", "\u{110a}\u{1164}\u{11bb}"), ("\u{c361}",
        "\u{c361}", "\u{110a}\u{1164}\u{11bc}", "\u{c361}", "\u{110a}\u{1164}\u{11bc}"),
        ("\u{c362}", "\u{c362}", "\u{110a}\u{1164}\u{11bd}", "\u{c362}",
        "\u{110a}\u{1164}\u{11bd}"), ("\u{c363}", "\u{c363}", "\u{110a}\u{1164}\u{11be}",
        "\u{c363}", "\u{110a}\u{1164}\u{11be}"), ("\u{c364}", "\u{c364}",
        "\u{110a}\u{1164}\u{11bf}", "\u{c364}", "\u{110a}\u{1164}\u{11bf}"), ("\u{c365}",
        "\u{c365}", "\u{110a}\u{1164}\u{11c0}", "\u{c365}", "\u{110a}\u{1164}\u{11c0}"),
        ("\u{c366}", "\u{c366}", "\u{110a}\u{1164}\u{11c1}", "\u{c366}",
        "\u{110a}\u{1164}\u{11c1}"), ("\u{c367}", "\u{c367}", "\u{110a}\u{1164}\u{11c2}",
        "\u{c367}", "\u{110a}\u{1164}\u{11c2}"), ("\u{c368}", "\u{c368}", "\u{110a}\u{1165}",
        "\u{c368}", "\u{110a}\u{1165}"), ("\u{c369}", "\u{c369}", "\u{110a}\u{1165}\u{11a8}",
        "\u{c369}", "\u{110a}\u{1165}\u{11a8}"), ("\u{c36a}", "\u{c36a}",
        "\u{110a}\u{1165}\u{11a9}", "\u{c36a}", "\u{110a}\u{1165}\u{11a9}"), ("\u{c36b}",
        "\u{c36b}", "\u{110a}\u{1165}\u{11aa}", "\u{c36b}", "\u{110a}\u{1165}\u{11aa}"),
        ("\u{c36c}", "\u{c36c}", "\u{110a}\u{1165}\u{11ab}", "\u{c36c}",
        "\u{110a}\u{1165}\u{11ab}"), ("\u{c36d}", "\u{c36d}", "\u{110a}\u{1165}\u{11ac}",
        "\u{c36d}", "\u{110a}\u{1165}\u{11ac}"), ("\u{c36e}", "\u{c36e}",
        "\u{110a}\u{1165}\u{11ad}", "\u{c36e}", "\u{110a}\u{1165}\u{11ad}"), ("\u{c36f}",
        "\u{c36f}", "\u{110a}\u{1165}\u{11ae}", "\u{c36f}", "\u{110a}\u{1165}\u{11ae}"),
        ("\u{c370}", "\u{c370}", "\u{110a}\u{1165}\u{11af}", "\u{c370}",
        "\u{110a}\u{1165}\u{11af}"), ("\u{c371}", "\u{c371}", "\u{110a}\u{1165}\u{11b0}",
        "\u{c371}", "\u{110a}\u{1165}\u{11b0}"), ("\u{c372}", "\u{c372}",
        "\u{110a}\u{1165}\u{11b1}", "\u{c372}", "\u{110a}\u{1165}\u{11b1}"), ("\u{c373}",
        "\u{c373}", "\u{110a}\u{1165}\u{11b2}", "\u{c373}", "\u{110a}\u{1165}\u{11b2}"),
        ("\u{c374}", "\u{c374}", "\u{110a}\u{1165}\u{11b3}", "\u{c374}",
        "\u{110a}\u{1165}\u{11b3}"), ("\u{c375}", "\u{c375}", "\u{110a}\u{1165}\u{11b4}",
        "\u{c375}", "\u{110a}\u{1165}\u{11b4}"), ("\u{c376}", "\u{c376}",
        "\u{110a}\u{1165}\u{11b5}", "\u{c376}", "\u{110a}\u{1165}\u{11b5}"), ("\u{c377}",
        "\u{c377}", "\u{110a}\u{1165}\u{11b6}", "\u{c377}", "\u{110a}\u{1165}\u{11b6}"),
        ("\u{c378}", "\u{c378}", "\u{110a}\u{1165}\u{11b7}", "\u{c378}",
        "\u{110a}\u{1165}\u{11b7}"), ("\u{c379}", "\u{c379}", "\u{110a}\u{1165}\u{11b8}",
        "\u{c379}", "\u{110a}\u{1165}\u{11b8}"), ("\u{c37a}", "\u{c37a}",
        "\u{110a}\u{1165}\u{11b9}", "\u{c37a}", "\u{110a}\u{1165}\u{11b9}"), ("\u{c37b}",
        "\u{c37b}", "\u{110a}\u{1165}\u{11ba}", "\u{c37b}", "\u{110a}\u{1165}\u{11ba}"),
        ("\u{c37c}", "\u{c37c}", "\u{110a}\u{1165}\u{11bb}", "\u{c37c}",
        "\u{110a}\u{1165}\u{11bb}"), ("\u{c37d}", "\u{c37d}", "\u{110a}\u{1165}\u{11bc}",
        "\u{c37d}", "\u{110a}\u{1165}\u{11bc}"), ("\u{c37e}", "\u{c37e}",
        "\u{110a}\u{1165}\u{11bd}", "\u{c37e}", "\u{110a}\u{1165}\u{11bd}"), ("\u{c37f}",
        "\u{c37f}", "\u{110a}\u{1165}\u{11be}", "\u{c37f}", "\u{110a}\u{1165}\u{11be}"),
        ("\u{c380}", "\u{c380}", "\u{110a}\u{1165}\u{11bf}", "\u{c380}",
        "\u{110a}\u{1165}\u{11bf}"), ("\u{c381}", "\u{c381}", "\u{110a}\u{1165}\u{11c0}",
        "\u{c381}", "\u{110a}\u{1165}\u{11c0}"), ("\u{c382}", "\u{c382}",
        "\u{110a}\u{1165}\u{11c1}", "\u{c382}", "\u{110a}\u{1165}\u{11c1}"), ("\u{c383}",
        "\u{c383}", "\u{110a}\u{1165}\u{11c2}", "\u{c383}", "\u{110a}\u{1165}\u{11c2}"),
        ("\u{c384}", "\u{c384}", "\u{110a}\u{1166}", "\u{c384}", "\u{110a}\u{1166}"), ("\u{c385}",
        "\u{c385}", "\u{110a}\u{1166}\u{11a8}", "\u{c385}", "\u{110a}\u{1166}\u{11a8}"),
        ("\u{c386}", "\u{c386}", "\u{110a}\u{1166}\u{11a9}", "\u{c386}",
        "\u{110a}\u{1166}\u{11a9}"), ("\u{c387}", "\u{c387}", "\u{110a}\u{1166}\u{11aa}",
        "\u{c387}", "\u{110a}\u{1166}\u{11aa}"), ("\u{c388}", "\u{c388}",
        "\u{110a}\u{1166}\u{11ab}", "\u{c388}", "\u{110a}\u{1166}\u{11ab}"), ("\u{c389}",
        "\u{c389}", "\u{110a}\u{1166}\u{11ac}", "\u{c389}", "\u{110a}\u{1166}\u{11ac}"),
        ("\u{c38a}", "\u{c38a}", "\u{110a}\u{1166}\u{11ad}", "\u{c38a}",
        "\u{110a}\u{1166}\u{11ad}"), ("\u{c38b}", "\u{c38b}", "\u{110a}\u{1166}\u{11ae}",
        "\u{c38b}", "\u{110a}\u{1166}\u{11ae}"), ("\u{c38c}", "\u{c38c}",
        "\u{110a}\u{1166}\u{11af}", "\u{c38c}", "\u{110a}\u{1166}\u{11af}"), ("\u{c38d}",
        "\u{c38d}", "\u{110a}\u{1166}\u{11b0}", "\u{c38d}", "\u{110a}\u{1166}\u{11b0}"),
        ("\u{c38e}", "\u{c38e}", "\u{110a}\u{1166}\u{11b1}", "\u{c38e}",
        "\u{110a}\u{1166}\u{11b1}"), ("\u{c38f}", "\u{c38f}", "\u{110a}\u{1166}\u{11b2}",
        "\u{c38f}", "\u{110a}\u{1166}\u{11b2}"), ("\u{c390}", "\u{c390}",
        "\u{110a}\u{1166}\u{11b3}", "\u{c390}", "\u{110a}\u{1166}\u{11b3}"), ("\u{c391}",
        "\u{c391}", "\u{110a}\u{1166}\u{11b4}", "\u{c391}", "\u{110a}\u{1166}\u{11b4}"),
        ("\u{c392}", "\u{c392}", "\u{110a}\u{1166}\u{11b5}", "\u{c392}",
        "\u{110a}\u{1166}\u{11b5}"), ("\u{c393}", "\u{c393}", "\u{110a}\u{1166}\u{11b6}",
        "\u{c393}", "\u{110a}\u{1166}\u{11b6}"), ("\u{c394}", "\u{c394}",
        "\u{110a}\u{1166}\u{11b7}", "\u{c394}", "\u{110a}\u{1166}\u{11b7}"), ("\u{c395}",
        "\u{c395}", "\u{110a}\u{1166}\u{11b8}", "\u{c395}", "\u{110a}\u{1166}\u{11b8}"),
        ("\u{c396}", "\u{c396}", "\u{110a}\u{1166}\u{11b9}", "\u{c396}",
        "\u{110a}\u{1166}\u{11b9}"), ("\u{c397}", "\u{c397}", "\u{110a}\u{1166}\u{11ba}",
        "\u{c397}", "\u{110a}\u{1166}\u{11ba}"), ("\u{c398}", "\u{c398}",
        "\u{110a}\u{1166}\u{11bb}", "\u{c398}", "\u{110a}\u{1166}\u{11bb}"), ("\u{c399}",
        "\u{c399}", "\u{110a}\u{1166}\u{11bc}", "\u{c399}", "\u{110a}\u{1166}\u{11bc}"),
        ("\u{c39a}", "\u{c39a}", "\u{110a}\u{1166}\u{11bd}", "\u{c39a}",
        "\u{110a}\u{1166}\u{11bd}"), ("\u{c39b}", "\u{c39b}", "\u{110a}\u{1166}\u{11be}",
        "\u{c39b}", "\u{110a}\u{1166}\u{11be}"), ("\u{c39c}", "\u{c39c}",
        "\u{110a}\u{1166}\u{11bf}", "\u{c39c}", "\u{110a}\u{1166}\u{11bf}"), ("\u{c39d}",
        "\u{c39d}", "\u{110a}\u{1166}\u{11c0}", "\u{c39d}", "\u{110a}\u{1166}\u{11c0}"),
        ("\u{c39e}", "\u{c39e}", "\u{110a}\u{1166}\u{11c1}", "\u{c39e}",
        "\u{110a}\u{1166}\u{11c1}"), ("\u{c39f}", "\u{c39f}", "\u{110a}\u{1166}\u{11c2}",
        "\u{c39f}", "\u{110a}\u{1166}\u{11c2}"), ("\u{c3a0}", "\u{c3a0}", "\u{110a}\u{1167}",
        "\u{c3a0}", "\u{110a}\u{1167}"), ("\u{c3a1}", "\u{c3a1}", "\u{110a}\u{1167}\u{11a8}",
        "\u{c3a1}", "\u{110a}\u{1167}\u{11a8}"), ("\u{c3a2}", "\u{c3a2}",
        "\u{110a}\u{1167}\u{11a9}", "\u{c3a2}", "\u{110a}\u{1167}\u{11a9}"), ("\u{c3a3}",
        "\u{c3a3}", "\u{110a}\u{1167}\u{11aa}", "\u{c3a3}", "\u{110a}\u{1167}\u{11aa}"),
        ("\u{c3a4}", "\u{c3a4}", "\u{110a}\u{1167}\u{11ab}", "\u{c3a4}",
        "\u{110a}\u{1167}\u{11ab}"), ("\u{c3a5}", "\u{c3a5}", "\u{110a}\u{1167}\u{11ac}",
        "\u{c3a5}", "\u{110a}\u{1167}\u{11ac}"), ("\u{c3a6}", "\u{c3a6}",
        "\u{110a}\u{1167}\u{11ad}", "\u{c3a6}", "\u{110a}\u{1167}\u{11ad}"), ("\u{c3a7}",
        "\u{c3a7}", "\u{110a}\u{1167}\u{11ae}", "\u{c3a7}", "\u{110a}\u{1167}\u{11ae}"),
        ("\u{c3a8}", "\u{c3a8}", "\u{110a}\u{1167}\u{11af}", "\u{c3a8}",
        "\u{110a}\u{1167}\u{11af}"), ("\u{c3a9}", "\u{c3a9}", "\u{110a}\u{1167}\u{11b0}",
        "\u{c3a9}", "\u{110a}\u{1167}\u{11b0}"), ("\u{c3aa}", "\u{c3aa}",
        "\u{110a}\u{1167}\u{11b1}", "\u{c3aa}", "\u{110a}\u{1167}\u{11b1}"), ("\u{c3ab}",
        "\u{c3ab}", "\u{110a}\u{1167}\u{11b2}", "\u{c3ab}", "\u{110a}\u{1167}\u{11b2}"),
        ("\u{c3ac}", "\u{c3ac}", "\u{110a}\u{1167}\u{11b3}", "\u{c3ac}",
        "\u{110a}\u{1167}\u{11b3}"), ("\u{c3ad}", "\u{c3ad}", "\u{110a}\u{1167}\u{11b4}",
        "\u{c3ad}", "\u{110a}\u{1167}\u{11b4}"), ("\u{c3ae}", "\u{c3ae}",
        "\u{110a}\u{1167}\u{11b5}", "\u{c3ae}", "\u{110a}\u{1167}\u{11b5}"), ("\u{c3af}",
        "\u{c3af}", "\u{110a}\u{1167}\u{11b6}", "\u{c3af}", "\u{110a}\u{1167}\u{11b6}"),
        ("\u{c3b0}", "\u{c3b0}", "\u{110a}\u{1167}\u{11b7}", "\u{c3b0}",
        "\u{110a}\u{1167}\u{11b7}"), ("\u{c3b1}", "\u{c3b1}", "\u{110a}\u{1167}\u{11b8}",
        "\u{c3b1}", "\u{110a}\u{1167}\u{11b8}"), ("\u{c3b2}", "\u{c3b2}",
        "\u{110a}\u{1167}\u{11b9}", "\u{c3b2}", "\u{110a}\u{1167}\u{11b9}"), ("\u{c3b3}",
        "\u{c3b3}", "\u{110a}\u{1167}\u{11ba}", "\u{c3b3}", "\u{110a}\u{1167}\u{11ba}"),
        ("\u{c3b4}", "\u{c3b4}", "\u{110a}\u{1167}\u{11bb}", "\u{c3b4}",
        "\u{110a}\u{1167}\u{11bb}"), ("\u{c3b5}", "\u{c3b5}", "\u{110a}\u{1167}\u{11bc}",
        "\u{c3b5}", "\u{110a}\u{1167}\u{11bc}"), ("\u{c3b6}", "\u{c3b6}",
        "\u{110a}\u{1167}\u{11bd}", "\u{c3b6}", "\u{110a}\u{1167}\u{11bd}"), ("\u{c3b7}",
        "\u{c3b7}", "\u{110a}\u{1167}\u{11be}", "\u{c3b7}", "\u{110a}\u{1167}\u{11be}"),
        ("\u{c3b8}", "\u{c3b8}", "\u{110a}\u{1167}\u{11bf}", "\u{c3b8}",
        "\u{110a}\u{1167}\u{11bf}"), ("\u{c3b9}", "\u{c3b9}", "\u{110a}\u{1167}\u{11c0}",
        "\u{c3b9}", "\u{110a}\u{1167}\u{11c0}"), ("\u{c3ba}", "\u{c3ba}",
        "\u{110a}\u{1167}\u{11c1}", "\u{c3ba}", "\u{110a}\u{1167}\u{11c1}"), ("\u{c3bb}",
        "\u{c3bb}", "\u{110a}\u{1167}\u{11c2}", "\u{c3bb}", "\u{110a}\u{1167}\u{11c2}"),
        ("\u{c3bc}", "\u{c3bc}", "\u{110a}\u{1168}", "\u{c3bc}", "\u{110a}\u{1168}"), ("\u{c3bd}",
        "\u{c3bd}", "\u{110a}\u{1168}\u{11a8}", "\u{c3bd}", "\u{110a}\u{1168}\u{11a8}"),
        ("\u{c3be}", "\u{c3be}", "\u{110a}\u{1168}\u{11a9}", "\u{c3be}",
        "\u{110a}\u{1168}\u{11a9}"), ("\u{c3bf}", "\u{c3bf}", "\u{110a}\u{1168}\u{11aa}",
        "\u{c3bf}", "\u{110a}\u{1168}\u{11aa}"), ("\u{c3c0}", "\u{c3c0}",
        "\u{110a}\u{1168}\u{11ab}", "\u{c3c0}", "\u{110a}\u{1168}\u{11ab}"), ("\u{c3c1}",
        "\u{c3c1}", "\u{110a}\u{1168}\u{11ac}", "\u{c3c1}", "\u{110a}\u{1168}\u{11ac}"),
        ("\u{c3c2}", "\u{c3c2}", "\u{110a}\u{1168}\u{11ad}", "\u{c3c2}",
        "\u{110a}\u{1168}\u{11ad}"), ("\u{c3c3}", "\u{c3c3}", "\u{110a}\u{1168}\u{11ae}",
        "\u{c3c3}", "\u{110a}\u{1168}\u{11ae}"), ("\u{c3c4}", "\u{c3c4}",
        "\u{110a}\u{1168}\u{11af}", "\u{c3c4}", "\u{110a}\u{1168}\u{11af}"), ("\u{c3c5}",
        "\u{c3c5}", "\u{110a}\u{1168}\u{11b0}", "\u{c3c5}", "\u{110a}\u{1168}\u{11b0}"),
        ("\u{c3c6}", "\u{c3c6}", "\u{110a}\u{1168}\u{11b1}", "\u{c3c6}",
        "\u{110a}\u{1168}\u{11b1}"), ("\u{c3c7}", "\u{c3c7}", "\u{110a}\u{1168}\u{11b2}",
        "\u{c3c7}", "\u{110a}\u{1168}\u{11b2}"), ("\u{c3c8}", "\u{c3c8}",
        "\u{110a}\u{1168}\u{11b3}", "\u{c3c8}", "\u{110a}\u{1168}\u{11b3}"), ("\u{c3c9}",
        "\u{c3c9}", "\u{110a}\u{1168}\u{11b4}", "\u{c3c9}", "\u{110a}\u{1168}\u{11b4}"),
        ("\u{c3ca}", "\u{c3ca}", "\u{110a}\u{1168}\u{11b5}", "\u{c3ca}",
        "\u{110a}\u{1168}\u{11b5}"), ("\u{c3cb}", "\u{c3cb}", "\u{110a}\u{1168}\u{11b6}",
        "\u{c3cb}", "\u{110a}\u{1168}\u{11b6}"), ("\u{c3cc}", "\u{c3cc}",
        "\u{110a}\u{1168}\u{11b7}", "\u{c3cc}", "\u{110a}\u{1168}\u{11b7}"), ("\u{c3cd}",
        "\u{c3cd}", "\u{110a}\u{1168}\u{11b8}", "\u{c3cd}", "\u{110a}\u{1168}\u{11b8}"),
        ("\u{c3ce}", "\u{c3ce}", "\u{110a}\u{1168}\u{11b9}", "\u{c3ce}",
        "\u{110a}\u{1168}\u{11b9}"), ("\u{c3cf}", "\u{c3cf}", "\u{110a}\u{1168}\u{11ba}",
        "\u{c3cf}", "\u{110a}\u{1168}\u{11ba}"), ("\u{c3d0}", "\u{c3d0}",
        "\u{110a}\u{1168}\u{11bb}", "\u{c3d0}", "\u{110a}\u{1168}\u{11bb}"), ("\u{c3d1}",
        "\u{c3d1}", "\u{110a}\u{1168}\u{11bc}", "\u{c3d1}", "\u{110a}\u{1168}\u{11bc}"),
        ("\u{c3d2}", "\u{c3d2}", "\u{110a}\u{1168}\u{11bd}", "\u{c3d2}",
        "\u{110a}\u{1168}\u{11bd}"), ("\u{c3d3}", "\u{c3d3}", "\u{110a}\u{1168}\u{11be}",
        "\u{c3d3}", "\u{110a}\u{1168}\u{11be}"), ("\u{c3d4}", "\u{c3d4}",
        "\u{110a}\u{1168}\u{11bf}", "\u{c3d4}", "\u{110a}\u{1168}\u{11bf}"), ("\u{c3d5}",
        "\u{c3d5}", "\u{110a}\u{1168}\u{11c0}", "\u{c3d5}", "\u{110a}\u{1168}\u{11c0}"),
        ("\u{c3d6}", "\u{c3d6}", "\u{110a}\u{1168}\u{11c1}", "\u{c3d6}",
        "\u{110a}\u{1168}\u{11c1}"), ("\u{c3d7}", "\u{c3d7}", "\u{110a}\u{1168}\u{11c2}",
        "\u{c3d7}", "\u{110a}\u{1168}\u{11c2}"), ("\u{c3d8}", "\u{c3d8}", "\u{110a}\u{1169}",
        "\u{c3d8}", "\u{110a}\u{1169}"), ("\u{c3d9}", "\u{c3d9}", "\u{110a}\u{1169}\u{11a8}",
        "\u{c3d9}", "\u{110a}\u{1169}\u{11a8}"), ("\u{c3da}", "\u{c3da}",
        "\u{110a}\u{1169}\u{11a9}", "\u{c3da}", "\u{110a}\u{1169}\u{11a9}"), ("\u{c3db}",
        "\u{c3db}", "\u{110a}\u{1169}\u{11aa}", "\u{c3db}", "\u{110a}\u{1169}\u{11aa}"),
        ("\u{c3dc}", "\u{c3dc}", "\u{110a}\u{1169}\u{11ab}", "\u{c3dc}",
        "\u{110a}\u{1169}\u{11ab}"), ("\u{c3dd}", "\u{c3dd}", "\u{110a}\u{1169}\u{11ac}",
        "\u{c3dd}", "\u{110a}\u{1169}\u{11ac}"), ("\u{c3de}", "\u{c3de}",
        "\u{110a}\u{1169}\u{11ad}", "\u{c3de}", "\u{110a}\u{1169}\u{11ad}"), ("\u{c3df}",
        "\u{c3df}", "\u{110a}\u{1169}\u{11ae}", "\u{c3df}", "\u{110a}\u{1169}\u{11ae}"),
        ("\u{c3e0}", "\u{c3e0}", "\u{110a}\u{1169}\u{11af}", "\u{c3e0}",
        "\u{110a}\u{1169}\u{11af}"), ("\u{c3e1}", "\u{c3e1}", "\u{110a}\u{1169}\u{11b0}",
        "\u{c3e1}", "\u{110a}\u{1169}\u{11b0}"), ("\u{c3e2}", "\u{c3e2}",
        "\u{110a}\u{1169}\u{11b1}", "\u{c3e2}", "\u{110a}\u{1169}\u{11b1}"), ("\u{c3e3}",
        "\u{c3e3}", "\u{110a}\u{1169}\u{11b2}", "\u{c3e3}", "\u{110a}\u{1169}\u{11b2}"),
        ("\u{c3e4}", "\u{c3e4}", "\u{110a}\u{1169}\u{11b3}", "\u{c3e4}",
        "\u{110a}\u{1169}\u{11b3}"), ("\u{c3e5}", "\u{c3e5}", "\u{110a}\u{1169}\u{11b4}",
        "\u{c3e5}", "\u{110a}\u{1169}\u{11b4}"), ("\u{c3e6}", "\u{c3e6}",
        "\u{110a}\u{1169}\u{11b5}", "\u{c3e6}", "\u{110a}\u{1169}\u{11b5}"), ("\u{c3e7}",
        "\u{c3e7}", "\u{110a}\u{1169}\u{11b6}", "\u{c3e7}", "\u{110a}\u{1169}\u{11b6}"),
        ("\u{c3e8}", "\u{c3e8}", "\u{110a}\u{1169}\u{11b7}", "\u{c3e8}",
        "\u{110a}\u{1169}\u{11b7}"), ("\u{c3e9}", "\u{c3e9}", "\u{110a}\u{1169}\u{11b8}",
        "\u{c3e9}", "\u{110a}\u{1169}\u{11b8}"), ("\u{c3ea}", "\u{c3ea}",
        "\u{110a}\u{1169}\u{11b9}", "\u{c3ea}", "\u{110a}\u{1169}\u{11b9}"), ("\u{c3eb}",
        "\u{c3eb}", "\u{110a}\u{1169}\u{11ba}", "\u{c3eb}", "\u{110a}\u{1169}\u{11ba}"),
        ("\u{c3ec}", "\u{c3ec}", "\u{110a}\u{1169}\u{11bb}", "\u{c3ec}",
        "\u{110a}\u{1169}\u{11bb}"), ("\u{c3ed}", "\u{c3ed}", "\u{110a}\u{1169}\u{11bc}",
        "\u{c3ed}", "\u{110a}\u{1169}\u{11bc}"), ("\u{c3ee}", "\u{c3ee}",
        "\u{110a}\u{1169}\u{11bd}", "\u{c3ee}", "\u{110a}\u{1169}\u{11bd}"), ("\u{c3ef}",
        "\u{c3ef}", "\u{110a}\u{1169}\u{11be}", "\u{c3ef}", "\u{110a}\u{1169}\u{11be}"),
        ("\u{c3f0}", "\u{c3f0}", "\u{110a}\u{1169}\u{11bf}", "\u{c3f0}",
        "\u{110a}\u{1169}\u{11bf}"), ("\u{c3f1}", "\u{c3f1}", "\u{110a}\u{1169}\u{11c0}",
        "\u{c3f1}", "\u{110a}\u{1169}\u{11c0}"), ("\u{c3f2}", "\u{c3f2}",
        "\u{110a}\u{1169}\u{11c1}", "\u{c3f2}", "\u{110a}\u{1169}\u{11c1}"), ("\u{c3f3}",
        "\u{c3f3}", "\u{110a}\u{1169}\u{11c2}", "\u{c3f3}", "\u{110a}\u{1169}\u{11c2}"),
        ("\u{c3f4}", "\u{c3f4}", "\u{110a}\u{116a}", "\u{c3f4}", "\u{110a}\u{116a}"), ("\u{c3f5}",
        "\u{c3f5}", "\u{110a}\u{116a}\u{11a8}", "\u{c3f5}", "\u{110a}\u{116a}\u{11a8}"),
        ("\u{c3f6}", "\u{c3f6}", "\u{110a}\u{116a}\u{11a9}", "\u{c3f6}",
        "\u{110a}\u{116a}\u{11a9}"), ("\u{c3f7}", "\u{c3f7}", "\u{110a}\u{116a}\u{11aa}",
        "\u{c3f7}", "\u{110a}\u{116a}\u{11aa}"), ("\u{c3f8}", "\u{c3f8}",
        "\u{110a}\u{116a}\u{11ab}", "\u{c3f8}", "\u{110a}\u{116a}\u{11ab}"), ("\u{c3f9}",
        "\u{c3f9}", "\u{110a}\u{116a}\u{11ac}", "\u{c3f9}", "\u{110a}\u{116a}\u{11ac}"),
        ("\u{c3fa}", "\u{c3fa}", "\u{110a}\u{116a}\u{11ad}", "\u{c3fa}",
        "\u{110a}\u{116a}\u{11ad}"), ("\u{c3fb}", "\u{c3fb}", "\u{110a}\u{116a}\u{11ae}",
        "\u{c3fb}", "\u{110a}\u{116a}\u{11ae}"), ("\u{c3fc}", "\u{c3fc}",
        "\u{110a}\u{116a}\u{11af}", "\u{c3fc}", "\u{110a}\u{116a}\u{11af}"), ("\u{c3fd}",
        "\u{c3fd}", "\u{110a}\u{116a}\u{11b0}", "\u{c3fd}", "\u{110a}\u{116a}\u{11b0}"),
        ("\u{c3fe}", "\u{c3fe}", "\u{110a}\u{116a}\u{11b1}", "\u{c3fe}",
        "\u{110a}\u{116a}\u{11b1}"), ("\u{c3ff}", "\u{c3ff}", "\u{110a}\u{116a}\u{11b2}",
        "\u{c3ff}", "\u{110a}\u{116a}\u{11b2}"), ("\u{c400}", "\u{c400}",
        "\u{110a}\u{116a}\u{11b3}", "\u{c400}", "\u{110a}\u{116a}\u{11b3}"), ("\u{c401}",
        "\u{c401}", "\u{110a}\u{116a}\u{11b4}", "\u{c401}", "\u{110a}\u{116a}\u{11b4}"),
        ("\u{c402}", "\u{c402}", "\u{110a}\u{116a}\u{11b5}", "\u{c402}",
        "\u{110a}\u{116a}\u{11b5}"), ("\u{c403}", "\u{c403}", "\u{110a}\u{116a}\u{11b6}",
        "\u{c403}", "\u{110a}\u{116a}\u{11b6}"), ("\u{c404}", "\u{c404}",
        "\u{110a}\u{116a}\u{11b7}", "\u{c404}", "\u{110a}\u{116a}\u{11b7}"), ("\u{c405}",
        "\u{c405}", "\u{110a}\u{116a}\u{11b8}", "\u{c405}", "\u{110a}\u{116a}\u{11b8}"),
        ("\u{c406}", "\u{c406}", "\u{110a}\u{116a}\u{11b9}", "\u{c406}",
        "\u{110a}\u{116a}\u{11b9}"), ("\u{c407}", "\u{c407}", "\u{110a}\u{116a}\u{11ba}",
        "\u{c407}", "\u{110a}\u{116a}\u{11ba}"), ("\u{c408}", "\u{c408}",
        "\u{110a}\u{116a}\u{11bb}", "\u{c408}", "\u{110a}\u{116a}\u{11bb}"), ("\u{c409}",
        "\u{c409}", "\u{110a}\u{116a}\u{11bc}", "\u{c409}", "\u{110a}\u{116a}\u{11bc}"),
        ("\u{c40a}", "\u{c40a}", "\u{110a}\u{116a}\u{11bd}", "\u{c40a}",
        "\u{110a}\u{116a}\u{11bd}"), ("\u{c40b}", "\u{c40b}", "\u{110a}\u{116a}\u{11be}",
        "\u{c40b}", "\u{110a}\u{116a}\u{11be}"), ("\u{c40c}", "\u{c40c}",
        "\u{110a}\u{116a}\u{11bf}", "\u{c40c}", "\u{110a}\u{116a}\u{11bf}"), ("\u{c40d}",
        "\u{c40d}", "\u{110a}\u{116a}\u{11c0}", "\u{c40d}", "\u{110a}\u{116a}\u{11c0}"),
        ("\u{c40e}", "\u{c40e}", "\u{110a}\u{116a}\u{11c1}", "\u{c40e}",
        "\u{110a}\u{116a}\u{11c1}"), ("\u{c40f}", "\u{c40f}", "\u{110a}\u{116a}\u{11c2}",
        "\u{c40f}", "\u{110a}\u{116a}\u{11c2}"), ("\u{c410}", "\u{c410}", "\u{110a}\u{116b}",
        "\u{c410}", "\u{110a}\u{116b}"), ("\u{c411}", "\u{c411}", "\u{110a}\u{116b}\u{11a8}",
        "\u{c411}", "\u{110a}\u{116b}\u{11a8}"), ("\u{c412}", "\u{c412}",
        "\u{110a}\u{116b}\u{11a9}", "\u{c412}", "\u{110a}\u{116b}\u{11a9}"), ("\u{c413}",
        "\u{c413}", "\u{110a}\u{116b}\u{11aa}", "\u{c413}", "\u{110a}\u{116b}\u{11aa}"),
        ("\u{c414}", "\u{c414}", "\u{110a}\u{116b}\u{11ab}", "\u{c414}",
        "\u{110a}\u{116b}\u{11ab}"), ("\u{c415}", "\u{c415}", "\u{110a}\u{116b}\u{11ac}",
        "\u{c415}", "\u{110a}\u{116b}\u{11ac}"), ("\u{c416}", "\u{c416}",
        "\u{110a}\u{116b}\u{11ad}", "\u{c416}", "\u{110a}\u{116b}\u{11ad}"), ("\u{c417}",
        "\u{c417}", "\u{110a}\u{116b}\u{11ae}", "\u{c417}", "\u{110a}\u{116b}\u{11ae}"),
        ("\u{c418}", "\u{c418}", "\u{110a}\u{116b}\u{11af}", "\u{c418}",
        "\u{110a}\u{116b}\u{11af}"), ("\u{c419}", "\u{c419}", "\u{110a}\u{116b}\u{11b0}",
        "\u{c419}", "\u{110a}\u{116b}\u{11b0}"), ("\u{c41a}", "\u{c41a}",
        "\u{110a}\u{116b}\u{11b1}", "\u{c41a}", "\u{110a}\u{116b}\u{11b1}"), ("\u{c41b}",
        "\u{c41b}", "\u{110a}\u{116b}\u{11b2}", "\u{c41b}", "\u{110a}\u{116b}\u{11b2}"),
        ("\u{c41c}", "\u{c41c}", "\u{110a}\u{116b}\u{11b3}", "\u{c41c}",
        "\u{110a}\u{116b}\u{11b3}"), ("\u{c41d}", "\u{c41d}", "\u{110a}\u{116b}\u{11b4}",
        "\u{c41d}", "\u{110a}\u{116b}\u{11b4}"), ("\u{c41e}", "\u{c41e}",
        "\u{110a}\u{116b}\u{11b5}", "\u{c41e}", "\u{110a}\u{116b}\u{11b5}"), ("\u{c41f}",
        "\u{c41f}", "\u{110a}\u{116b}\u{11b6}", "\u{c41f}", "\u{110a}\u{116b}\u{11b6}"),
        ("\u{c420}", "\u{c420}", "\u{110a}\u{116b}\u{11b7}", "\u{c420}",
        "\u{110a}\u{116b}\u{11b7}"), ("\u{c421}", "\u{c421}", "\u{110a}\u{116b}\u{11b8}",
        "\u{c421}", "\u{110a}\u{116b}\u{11b8}"), ("\u{c422}", "\u{c422}",
        "\u{110a}\u{116b}\u{11b9}", "\u{c422}", "\u{110a}\u{116b}\u{11b9}"), ("\u{c423}",
        "\u{c423}", "\u{110a}\u{116b}\u{11ba}", "\u{c423}", "\u{110a}\u{116b}\u{11ba}"),
        ("\u{c424}", "\u{c424}", "\u{110a}\u{116b}\u{11bb}", "\u{c424}",
        "\u{110a}\u{116b}\u{11bb}"), ("\u{c425}", "\u{c425}", "\u{110a}\u{116b}\u{11bc}",
        "\u{c425}", "\u{110a}\u{116b}\u{11bc}"), ("\u{c426}", "\u{c426}",
        "\u{110a}\u{116b}\u{11bd}", "\u{c426}", "\u{110a}\u{116b}\u{11bd}"), ("\u{c427}",
        "\u{c427}", "\u{110a}\u{116b}\u{11be}", "\u{c427}", "\u{110a}\u{116b}\u{11be}"),
        ("\u{c428}", "\u{c428}", "\u{110a}\u{116b}\u{11bf}", "\u{c428}",
        "\u{110a}\u{116b}\u{11bf}"), ("\u{c429}", "\u{c429}", "\u{110a}\u{116b}\u{11c0}",
        "\u{c429}", "\u{110a}\u{116b}\u{11c0}"), ("\u{c42a}", "\u{c42a}",
        "\u{110a}\u{116b}\u{11c1}", "\u{c42a}", "\u{110a}\u{116b}\u{11c1}"), ("\u{c42b}",
        "\u{c42b}", "\u{110a}\u{116b}\u{11c2}", "\u{c42b}", "\u{110a}\u{116b}\u{11c2}"),
        ("\u{c42c}", "\u{c42c}", "\u{110a}\u{116c}", "\u{c42c}", "\u{110a}\u{116c}"), ("\u{c42d}",
        "\u{c42d}", "\u{110a}\u{116c}\u{11a8}", "\u{c42d}", "\u{110a}\u{116c}\u{11a8}"),
        ("\u{c42e}", "\u{c42e}", "\u{110a}\u{116c}\u{11a9}", "\u{c42e}",
        "\u{110a}\u{116c}\u{11a9}"), ("\u{c42f}", "\u{c42f}", "\u{110a}\u{116c}\u{11aa}",
        "\u{c42f}", "\u{110a}\u{116c}\u{11aa}"), ("\u{c430}", "\u{c430}",
        "\u{110a}\u{116c}\u{11ab}", "\u{c430}", "\u{110a}\u{116c}\u{11ab}"), ("\u{c431}",
        "\u{c431}", "\u{110a}\u{116c}\u{11ac}", "\u{c431}", "\u{110a}\u{116c}\u{11ac}"),
        ("\u{c432}", "\u{c432}", "\u{110a}\u{116c}\u{11ad}", "\u{c432}",
        "\u{110a}\u{116c}\u{11ad}"), ("\u{c433}", "\u{c433}", "\u{110a}\u{116c}\u{11ae}",
        "\u{c433}", "\u{110a}\u{116c}\u{11ae}"), ("\u{c434}", "\u{c434}",
        "\u{110a}\u{116c}\u{11af}", "\u{c434}", "\u{110a}\u{116c}\u{11af}"), ("\u{c435}",
        "\u{c435}", "\u{110a}\u{116c}\u{11b0}", "\u{c435}", "\u{110a}\u{116c}\u{11b0}"),
        ("\u{c436}", "\u{c436}", "\u{110a}\u{116c}\u{11b1}", "\u{c436}",
        "\u{110a}\u{116c}\u{11b1}"), ("\u{c437}", "\u{c437}", "\u{110a}\u{116c}\u{11b2}",
        "\u{c437}", "\u{110a}\u{116c}\u{11b2}"), ("\u{c438}", "\u{c438}",
        "\u{110a}\u{116c}\u{11b3}", "\u{c438}", "\u{110a}\u{116c}\u{11b3}"), ("\u{c439}",
        "\u{c439}", "\u{110a}\u{116c}\u{11b4}", "\u{c439}", "\u{110a}\u{116c}\u{11b4}"),
        ("\u{c43a}", "\u{c43a}", "\u{110a}\u{116c}\u{11b5}", "\u{c43a}",
        "\u{110a}\u{116c}\u{11b5}"), ("\u{c43b}", "\u{c43b}", "\u{110a}\u{116c}\u{11b6}",
        "\u{c43b}", "\u{110a}\u{116c}\u{11b6}"), ("\u{c43c}", "\u{c43c}",
        "\u{110a}\u{116c}\u{11b7}", "\u{c43c}", "\u{110a}\u{116c}\u{11b7}"), ("\u{c43d}",
        "\u{c43d}", "\u{110a}\u{116c}\u{11b8}", "\u{c43d}", "\u{110a}\u{116c}\u{11b8}"),
        ("\u{c43e}", "\u{c43e}", "\u{110a}\u{116c}\u{11b9}", "\u{c43e}",
        "\u{110a}\u{116c}\u{11b9}"), ("\u{c43f}", "\u{c43f}", "\u{110a}\u{116c}\u{11ba}",
        "\u{c43f}", "\u{110a}\u{116c}\u{11ba}"), ("\u{c440}", "\u{c440}",
        "\u{110a}\u{116c}\u{11bb}", "\u{c440}", "\u{110a}\u{116c}\u{11bb}"), ("\u{c441}",
        "\u{c441}", "\u{110a}\u{116c}\u{11bc}", "\u{c441}", "\u{110a}\u{116c}\u{11bc}"),
        ("\u{c442}", "\u{c442}", "\u{110a}\u{116c}\u{11bd}", "\u{c442}",
        "\u{110a}\u{116c}\u{11bd}"), ("\u{c443}", "\u{c443}", "\u{110a}\u{116c}\u{11be}",
        "\u{c443}", "\u{110a}\u{116c}\u{11be}"), ("\u{c444}", "\u{c444}",
        "\u{110a}\u{116c}\u{11bf}", "\u{c444}", "\u{110a}\u{116c}\u{11bf}"), ("\u{c445}",
        "\u{c445}", "\u{110a}\u{116c}\u{11c0}", "\u{c445}", "\u{110a}\u{116c}\u{11c0}"),
        ("\u{c446}", "\u{c446}", "\u{110a}\u{116c}\u{11c1}", "\u{c446}",
        "\u{110a}\u{116c}\u{11c1}"), ("\u{c447}", "\u{c447}", "\u{110a}\u{116c}\u{11c2}",
        "\u{c447}", "\u{110a}\u{116c}\u{11c2}"), ("\u{c448}", "\u{c448}", "\u{110a}\u{116d}",
        "\u{c448}", "\u{110a}\u{116d}"), ("\u{c449}", "\u{c449}", "\u{110a}\u{116d}\u{11a8}",
        "\u{c449}", "\u{110a}\u{116d}\u{11a8}"), ("\u{c44a}", "\u{c44a}",
        "\u{110a}\u{116d}\u{11a9}", "\u{c44a}", "\u{110a}\u{116d}\u{11a9}"), ("\u{c44b}",
        "\u{c44b}", "\u{110a}\u{116d}\u{11aa}", "\u{c44b}", "\u{110a}\u{116d}\u{11aa}"),
        ("\u{c44c}", "\u{c44c}", "\u{110a}\u{116d}\u{11ab}", "\u{c44c}",
        "\u{110a}\u{116d}\u{11ab}"), ("\u{c44d}", "\u{c44d}", "\u{110a}\u{116d}\u{11ac}",
        "\u{c44d}", "\u{110a}\u{116d}\u{11ac}"), ("\u{c44e}", "\u{c44e}",
        "\u{110a}\u{116d}\u{11ad}", "\u{c44e}", "\u{110a}\u{116d}\u{11ad}"), ("\u{c44f}",
        "\u{c44f}", "\u{110a}\u{116d}\u{11ae}", "\u{c44f}", "\u{110a}\u{116d}\u{11ae}"),
        ("\u{c450}", "\u{c450}", "\u{110a}\u{116d}\u{11af}", "\u{c450}",
        "\u{110a}\u{116d}\u{11af}"), ("\u{c451}", "\u{c451}", "\u{110a}\u{116d}\u{11b0}",
        "\u{c451}", "\u{110a}\u{116d}\u{11b0}"), ("\u{c452}", "\u{c452}",
        "\u{110a}\u{116d}\u{11b1}", "\u{c452}", "\u{110a}\u{116d}\u{11b1}"), ("\u{c453}",
        "\u{c453}", "\u{110a}\u{116d}\u{11b2}", "\u{c453}", "\u{110a}\u{116d}\u{11b2}"),
        ("\u{c454}", "\u{c454}", "\u{110a}\u{116d}\u{11b3}", "\u{c454}",
        "\u{110a}\u{116d}\u{11b3}"), ("\u{c455}", "\u{c455}", "\u{110a}\u{116d}\u{11b4}",
        "\u{c455}", "\u{110a}\u{116d}\u{11b4}"), ("\u{c456}", "\u{c456}",
        "\u{110a}\u{116d}\u{11b5}", "\u{c456}", "\u{110a}\u{116d}\u{11b5}"), ("\u{c457}",
        "\u{c457}", "\u{110a}\u{116d}\u{11b6}", "\u{c457}", "\u{110a}\u{116d}\u{11b6}"),
        ("\u{c458}", "\u{c458}", "\u{110a}\u{116d}\u{11b7}", "\u{c458}",
        "\u{110a}\u{116d}\u{11b7}"), ("\u{c459}", "\u{c459}", "\u{110a}\u{116d}\u{11b8}",
        "\u{c459}", "\u{110a}\u{116d}\u{11b8}"), ("\u{c45a}", "\u{c45a}",
        "\u{110a}\u{116d}\u{11b9}", "\u{c45a}", "\u{110a}\u{116d}\u{11b9}"), ("\u{c45b}",
        "\u{c45b}", "\u{110a}\u{116d}\u{11ba}", "\u{c45b}", "\u{110a}\u{116d}\u{11ba}"),
        ("\u{c45c}", "\u{c45c}", "\u{110a}\u{116d}\u{11bb}", "\u{c45c}",
        "\u{110a}\u{116d}\u{11bb}"), ("\u{c45d}", "\u{c45d}", "\u{110a}\u{116d}\u{11bc}",
        "\u{c45d}", "\u{110a}\u{116d}\u{11bc}"), ("\u{c45e}", "\u{c45e}",
        "\u{110a}\u{116d}\u{11bd}", "\u{c45e}", "\u{110a}\u{116d}\u{11bd}"), ("\u{c45f}",
        "\u{c45f}", "\u{110a}\u{116d}\u{11be}", "\u{c45f}", "\u{110a}\u{116d}\u{11be}"),
        ("\u{c460}", "\u{c460}", "\u{110a}\u{116d}\u{11bf}", "\u{c460}",
        "\u{110a}\u{116d}\u{11bf}"), ("\u{c461}", "\u{c461}", "\u{110a}\u{116d}\u{11c0}",
        "\u{c461}", "\u{110a}\u{116d}\u{11c0}"), ("\u{c462}", "\u{c462}",
        "\u{110a}\u{116d}\u{11c1}", "\u{c462}", "\u{110a}\u{116d}\u{11c1}"), ("\u{c463}",
        "\u{c463}", "\u{110a}\u{116d}\u{11c2}", "\u{c463}", "\u{110a}\u{116d}\u{11c2}"),
        ("\u{c464}", "\u{c464}", "\u{110a}\u{116e}", "\u{c464}", "\u{110a}\u{116e}"), ("\u{c465}",
        "\u{c465}", "\u{110a}\u{116e}\u{11a8}", "\u{c465}", "\u{110a}\u{116e}\u{11a8}"),
        ("\u{c466}", "\u{c466}", "\u{110a}\u{116e}\u{11a9}", "\u{c466}",
        "\u{110a}\u{116e}\u{11a9}"), ("\u{c467}", "\u{c467}", "\u{110a}\u{116e}\u{11aa}",
        "\u{c467}", "\u{110a}\u{116e}\u{11aa}"), ("\u{c468}", "\u{c468}",
        "\u{110a}\u{116e}\u{11ab}", "\u{c468}", "\u{110a}\u{116e}\u{11ab}"), ("\u{c469}",
        "\u{c469}", "\u{110a}\u{116e}\u{11ac}", "\u{c469}", "\u{110a}\u{116e}\u{11ac}"),
        ("\u{c46a}", "\u{c46a}", "\u{110a}\u{116e}\u{11ad}", "\u{c46a}",
        "\u{110a}\u{116e}\u{11ad}"), ("\u{c46b}", "\u{c46b}", "\u{110a}\u{116e}\u{11ae}",
        "\u{c46b}", "\u{110a}\u{116e}\u{11ae}"), ("\u{c46c}", "\u{c46c}",
        "\u{110a}\u{116e}\u{11af}", "\u{c46c}", "\u{110a}\u{116e}\u{11af}"), ("\u{c46d}",
        "\u{c46d}", "\u{110a}\u{116e}\u{11b0}", "\u{c46d}", "\u{110a}\u{116e}\u{11b0}"),
        ("\u{c46e}", "\u{c46e}", "\u{110a}\u{116e}\u{11b1}", "\u{c46e}",
        "\u{110a}\u{116e}\u{11b1}"), ("\u{c46f}", "\u{c46f}", "\u{110a}\u{116e}\u{11b2}",
        "\u{c46f}", "\u{110a}\u{116e}\u{11b2}"), ("\u{c470}", "\u{c470}",
        "\u{110a}\u{116e}\u{11b3}", "\u{c470}", "\u{110a}\u{116e}\u{11b3}"), ("\u{c471}",
        "\u{c471}", "\u{110a}\u{116e}\u{11b4}", "\u{c471}", "\u{110a}\u{116e}\u{11b4}"),
        ("\u{c472}", "\u{c472}", "\u{110a}\u{116e}\u{11b5}", "\u{c472}",
        "\u{110a}\u{116e}\u{11b5}"), ("\u{c473}", "\u{c473}", "\u{110a}\u{116e}\u{11b6}",
        "\u{c473}", "\u{110a}\u{116e}\u{11b6}"), ("\u{c474}", "\u{c474}",
        "\u{110a}\u{116e}\u{11b7}", "\u{c474}", "\u{110a}\u{116e}\u{11b7}"), ("\u{c475}",
        "\u{c475}", "\u{110a}\u{116e}\u{11b8}", "\u{c475}", "\u{110a}\u{116e}\u{11b8}"),
        ("\u{c476}", "\u{c476}", "\u{110a}\u{116e}\u{11b9}", "\u{c476}",
        "\u{110a}\u{116e}\u{11b9}"), ("\u{c477}", "\u{c477}", "\u{110a}\u{116e}\u{11ba}",
        "\u{c477}", "\u{110a}\u{116e}\u{11ba}"), ("\u{c478}", "\u{c478}",
        "\u{110a}\u{116e}\u{11bb}", "\u{c478}", "\u{110a}\u{116e}\u{11bb}"), ("\u{c479}",
        "\u{c479}", "\u{110a}\u{116e}\u{11bc}", "\u{c479}", "\u{110a}\u{116e}\u{11bc}"),
        ("\u{c47a}", "\u{c47a}", "\u{110a}\u{116e}\u{11bd}", "\u{c47a}",
        "\u{110a}\u{116e}\u{11bd}"), ("\u{c47b}", "\u{c47b}", "\u{110a}\u{116e}\u{11be}",
        "\u{c47b}", "\u{110a}\u{116e}\u{11be}"), ("\u{c47c}", "\u{c47c}",
        "\u{110a}\u{116e}\u{11bf}", "\u{c47c}", "\u{110a}\u{116e}\u{11bf}"), ("\u{c47d}",
        "\u{c47d}", "\u{110a}\u{116e}\u{11c0}", "\u{c47d}", "\u{110a}\u{116e}\u{11c0}"),
        ("\u{c47e}", "\u{c47e}", "\u{110a}\u{116e}\u{11c1}", "\u{c47e}",
        "\u{110a}\u{116e}\u{11c1}"), ("\u{c47f}", "\u{c47f}", "\u{110a}\u{116e}\u{11c2}",
        "\u{c47f}", "\u{110a}\u{116e}\u{11c2}"), ("\u{c480}", "\u{c480}", "\u{110a}\u{116f}",
        "\u{c480}", "\u{110a}\u{116f}"), ("\u{c481}", "\u{c481}", "\u{110a}\u{116f}\u{11a8}",
        "\u{c481}", "\u{110a}\u{116f}\u{11a8}"), ("\u{c482}", "\u{c482}",
        "\u{110a}\u{116f}\u{11a9}", "\u{c482}", "\u{110a}\u{116f}\u{11a9}"), ("\u{c483}",
        "\u{c483}", "\u{110a}\u{116f}\u{11aa}", "\u{c483}", "\u{110a}\u{116f}\u{11aa}"),
        ("\u{c484}", "\u{c484}", "\u{110a}\u{116f}\u{11ab}", "\u{c484}",
        "\u{110a}\u{116f}\u{11ab}"), ("\u{c485}", "\u{c485}", "\u{110a}\u{116f}\u{11ac}",
        "\u{c485}", "\u{110a}\u{116f}\u{11ac}"), ("\u{c486}", "\u{c486}",
        "\u{110a}\u{116f}\u{11ad}", "\u{c486}", "\u{110a}\u{116f}\u{11ad}"), ("\u{c487}",
        "\u{c487}", "\u{110a}\u{116f}\u{11ae}", "\u{c487}", "\u{110a}\u{116f}\u{11ae}"),
        ("\u{c488}", "\u{c488}", "\u{110a}\u{116f}\u{11af}", "\u{c488}",
        "\u{110a}\u{116f}\u{11af}"), ("\u{c489}", "\u{c489}", "\u{110a}\u{116f}\u{11b0}",
        "\u{c489}", "\u{110a}\u{116f}\u{11b0}"), ("\u{c48a}", "\u{c48a}",
        "\u{110a}\u{116f}\u{11b1}", "\u{c48a}", "\u{110a}\u{116f}\u{11b1}"), ("\u{c48b}",
        "\u{c48b}", "\u{110a}\u{116f}\u{11b2}", "\u{c48b}", "\u{110a}\u{116f}\u{11b2}"),
        ("\u{c48c}", "\u{c48c}", "\u{110a}\u{116f}\u{11b3}", "\u{c48c}",
        "\u{110a}\u{116f}\u{11b3}"), ("\u{c48d}", "\u{c48d}", "\u{110a}\u{116f}\u{11b4}",
        "\u{c48d}", "\u{110a}\u{116f}\u{11b4}"), ("\u{c48e}", "\u{c48e}",
        "\u{110a}\u{116f}\u{11b5}", "\u{c48e}", "\u{110a}\u{116f}\u{11b5}"), ("\u{c48f}",
        "\u{c48f}", "\u{110a}\u{116f}\u{11b6}", "\u{c48f}", "\u{110a}\u{116f}\u{11b6}"),
        ("\u{c490}", "\u{c490}", "\u{110a}\u{116f}\u{11b7}", "\u{c490}",
        "\u{110a}\u{116f}\u{11b7}"), ("\u{c491}", "\u{c491}", "\u{110a}\u{116f}\u{11b8}",
        "\u{c491}", "\u{110a}\u{116f}\u{11b8}"), ("\u{c492}", "\u{c492}",
        "\u{110a}\u{116f}\u{11b9}", "\u{c492}", "\u{110a}\u{116f}\u{11b9}"), ("\u{c493}",
        "\u{c493}", "\u{110a}\u{116f}\u{11ba}", "\u{c493}", "\u{110a}\u{116f}\u{11ba}"),
        ("\u{c494}", "\u{c494}", "\u{110a}\u{116f}\u{11bb}", "\u{c494}",
        "\u{110a}\u{116f}\u{11bb}"), ("\u{c495}", "\u{c495}", "\u{110a}\u{116f}\u{11bc}",
        "\u{c495}", "\u{110a}\u{116f}\u{11bc}"), ("\u{c496}", "\u{c496}",
        "\u{110a}\u{116f}\u{11bd}", "\u{c496}", "\u{110a}\u{116f}\u{11bd}"), ("\u{c497}",
        "\u{c497}", "\u{110a}\u{116f}\u{11be}", "\u{c497}", "\u{110a}\u{116f}\u{11be}"),
        ("\u{c498}", "\u{c498}", "\u{110a}\u{116f}\u{11bf}", "\u{c498}",
        "\u{110a}\u{116f}\u{11bf}"), ("\u{c499}", "\u{c499}", "\u{110a}\u{116f}\u{11c0}",
        "\u{c499}", "\u{110a}\u{116f}\u{11c0}"), ("\u{c49a}", "\u{c49a}",
        "\u{110a}\u{116f}\u{11c1}", "\u{c49a}", "\u{110a}\u{116f}\u{11c1}"), ("\u{c49b}",
        "\u{c49b}", "\u{110a}\u{116f}\u{11c2}", "\u{c49b}", "\u{110a}\u{116f}\u{11c2}"),
        ("\u{c49c}", "\u{c49c}", "\u{110a}\u{1170}", "\u{c49c}", "\u{110a}\u{1170}"), ("\u{c49d}",
        "\u{c49d}", "\u{110a}\u{1170}\u{11a8}", "\u{c49d}", "\u{110a}\u{1170}\u{11a8}"),
        ("\u{c49e}", "\u{c49e}", "\u{110a}\u{1170}\u{11a9}", "\u{c49e}",
        "\u{110a}\u{1170}\u{11a9}"), ("\u{c49f}", "\u{c49f}", "\u{110a}\u{1170}\u{11aa}",
        "\u{c49f}", "\u{110a}\u{1170}\u{11aa}"), ("\u{c4a0}", "\u{c4a0}",
        "\u{110a}\u{1170}\u{11ab}", "\u{c4a0}", "\u{110a}\u{1170}\u{11ab}"), ("\u{c4a1}",
        "\u{c4a1}", "\u{110a}\u{1170}\u{11ac}", "\u{c4a1}", "\u{110a}\u{1170}\u{11ac}"),
        ("\u{c4a2}", "\u{c4a2}", "\u{110a}\u{1170}\u{11ad}", "\u{c4a2}",
        "\u{110a}\u{1170}\u{11ad}"), ("\u{c4a3}", "\u{c4a3}", "\u{110a}\u{1170}\u{11ae}",
        "\u{c4a3}", "\u{110a}\u{1170}\u{11ae}"), ("\u{c4a4}", "\u{c4a4}",
        "\u{110a}\u{1170}\u{11af}", "\u{c4a4}", "\u{110a}\u{1170}\u{11af}"), ("\u{c4a5}",
        "\u{c4a5}", "\u{110a}\u{1170}\u{11b0}", "\u{c4a5}", "\u{110a}\u{1170}\u{11b0}"),
        ("\u{c4a6}", "\u{c4a6}", "\u{110a}\u{1170}\u{11b1}", "\u{c4a6}",
        "\u{110a}\u{1170}\u{11b1}"), ("\u{c4a7}", "\u{c4a7}", "\u{110a}\u{1170}\u{11b2}",
        "\u{c4a7}", "\u{110a}\u{1170}\u{11b2}"), ("\u{c4a8}", "\u{c4a8}",
        "\u{110a}\u{1170}\u{11b3}", "\u{c4a8}", "\u{110a}\u{1170}\u{11b3}"), ("\u{c4a9}",
        "\u{c4a9}", "\u{110a}\u{1170}\u{11b4}", "\u{c4a9}", "\u{110a}\u{1170}\u{11b4}"),
        ("\u{c4aa}", "\u{c4aa}", "\u{110a}\u{1170}\u{11b5}", "\u{c4aa}",
        "\u{110a}\u{1170}\u{11b5}"), ("\u{c4ab}", "\u{c4ab}", "\u{110a}\u{1170}\u{11b6}",
        "\u{c4ab}", "\u{110a}\u{1170}\u{11b6}"), ("\u{c4ac}", "\u{c4ac}",
        "\u{110a}\u{1170}\u{11b7}", "\u{c4ac}", "\u{110a}\u{1170}\u{11b7}"), ("\u{c4ad}",
        "\u{c4ad}", "\u{110a}\u{1170}\u{11b8}", "\u{c4ad}", "\u{110a}\u{1170}\u{11b8}"),
        ("\u{c4ae}", "\u{c4ae}", "\u{110a}\u{1170}\u{11b9}", "\u{c4ae}",
        "\u{110a}\u{1170}\u{11b9}"), ("\u{c4af}", "\u{c4af}", "\u{110a}\u{1170}\u{11ba}",
        "\u{c4af}", "\u{110a}\u{1170}\u{11ba}"), ("\u{c4b0}", "\u{c4b0}",
        "\u{110a}\u{1170}\u{11bb}", "\u{c4b0}", "\u{110a}\u{1170}\u{11bb}"), ("\u{c4b1}",
        "\u{c4b1}", "\u{110a}\u{1170}\u{11bc}", "\u{c4b1}", "\u{110a}\u{1170}\u{11bc}"),
        ("\u{c4b2}", "\u{c4b2}", "\u{110a}\u{1170}\u{11bd}", "\u{c4b2}",
        "\u{110a}\u{1170}\u{11bd}"), ("\u{c4b3}", "\u{c4b3}", "\u{110a}\u{1170}\u{11be}",
        "\u{c4b3}", "\u{110a}\u{1170}\u{11be}"), ("\u{c4b4}", "\u{c4b4}",
        "\u{110a}\u{1170}\u{11bf}", "\u{c4b4}", "\u{110a}\u{1170}\u{11bf}"), ("\u{c4b5}",
        "\u{c4b5}", "\u{110a}\u{1170}\u{11c0}", "\u{c4b5}", "\u{110a}\u{1170}\u{11c0}"),
        ("\u{c4b6}", "\u{c4b6}", "\u{110a}\u{1170}\u{11c1}", "\u{c4b6}",
        "\u{110a}\u{1170}\u{11c1}"), ("\u{c4b7}", "\u{c4b7}", "\u{110a}\u{1170}\u{11c2}",
        "\u{c4b7}", "\u{110a}\u{1170}\u{11c2}"), ("\u{c4b8}", "\u{c4b8}", "\u{110a}\u{1171}",
        "\u{c4b8}", "\u{110a}\u{1171}"), ("\u{c4b9}", "\u{c4b9}", "\u{110a}\u{1171}\u{11a8}",
        "\u{c4b9}", "\u{110a}\u{1171}\u{11a8}"), ("\u{c4ba}", "\u{c4ba}",
        "\u{110a}\u{1171}\u{11a9}", "\u{c4ba}", "\u{110a}\u{1171}\u{11a9}"), ("\u{c4bb}",
        "\u{c4bb}", "\u{110a}\u{1171}\u{11aa}", "\u{c4bb}", "\u{110a}\u{1171}\u{11aa}"),
        ("\u{c4bc}", "\u{c4bc}", "\u{110a}\u{1171}\u{11ab}", "\u{c4bc}",
        "\u{110a}\u{1171}\u{11ab}"), ("\u{c4bd}", "\u{c4bd}", "\u{110a}\u{1171}\u{11ac}",
        "\u{c4bd}", "\u{110a}\u{1171}\u{11ac}"), ("\u{c4be}", "\u{c4be}",
        "\u{110a}\u{1171}\u{11ad}", "\u{c4be}", "\u{110a}\u{1171}\u{11ad}"), ("\u{c4bf}",
        "\u{c4bf}", "\u{110a}\u{1171}\u{11ae}", "\u{c4bf}", "\u{110a}\u{1171}\u{11ae}"),
        ("\u{c4c0}", "\u{c4c0}", "\u{110a}\u{1171}\u{11af}", "\u{c4c0}",
        "\u{110a}\u{1171}\u{11af}"), ("\u{c4c1}", "\u{c4c1}", "\u{110a}\u{1171}\u{11b0}",
        "\u{c4c1}", "\u{110a}\u{1171}\u{11b0}"), ("\u{c4c2}", "\u{c4c2}",
        "\u{110a}\u{1171}\u{11b1}", "\u{c4c2}", "\u{110a}\u{1171}\u{11b1}"), ("\u{c4c3}",
        "\u{c4c3}", "\u{110a}\u{1171}\u{11b2}", "\u{c4c3}", "\u{110a}\u{1171}\u{11b2}"),
        ("\u{c4c4}", "\u{c4c4}", "\u{110a}\u{1171}\u{11b3}", "\u{c4c4}",
        "\u{110a}\u{1171}\u{11b3}"), ("\u{c4c5}", "\u{c4c5}", "\u{110a}\u{1171}\u{11b4}",
        "\u{c4c5}", "\u{110a}\u{1171}\u{11b4}"), ("\u{c4c6}", "\u{c4c6}",
        "\u{110a}\u{1171}\u{11b5}", "\u{c4c6}", "\u{110a}\u{1171}\u{11b5}"), ("\u{c4c7}",
        "\u{c4c7}", "\u{110a}\u{1171}\u{11b6}", "\u{c4c7}", "\u{110a}\u{1171}\u{11b6}"),
        ("\u{c4c8}", "\u{c4c8}", "\u{110a}\u{1171}\u{11b7}", "\u{c4c8}",
        "\u{110a}\u{1171}\u{11b7}"), ("\u{c4c9}", "\u{c4c9}", "\u{110a}\u{1171}\u{11b8}",
        "\u{c4c9}", "\u{110a}\u{1171}\u{11b8}"), ("\u{c4ca}", "\u{c4ca}",
        "\u{110a}\u{1171}\u{11b9}", "\u{c4ca}", "\u{110a}\u{1171}\u{11b9}"), ("\u{c4cb}",
        "\u{c4cb}", "\u{110a}\u{1171}\u{11ba}", "\u{c4cb}", "\u{110a}\u{1171}\u{11ba}"),
        ("\u{c4cc}", "\u{c4cc}", "\u{110a}\u{1171}\u{11bb}", "\u{c4cc}",
        "\u{110a}\u{1171}\u{11bb}"), ("\u{c4cd}", "\u{c4cd}", "\u{110a}\u{1171}\u{11bc}",
        "\u{c4cd}", "\u{110a}\u{1171}\u{11bc}"), ("\u{c4ce}", "\u{c4ce}",
        "\u{110a}\u{1171}\u{11bd}", "\u{c4ce}", "\u{110a}\u{1171}\u{11bd}"), ("\u{c4cf}",
        "\u{c4cf}", "\u{110a}\u{1171}\u{11be}", "\u{c4cf}", "\u{110a}\u{1171}\u{11be}"),
        ("\u{c4d0}", "\u{c4d0}", "\u{110a}\u{1171}\u{11bf}", "\u{c4d0}",
        "\u{110a}\u{1171}\u{11bf}"), ("\u{c4d1}", "\u{c4d1}", "\u{110a}\u{1171}\u{11c0}",
        "\u{c4d1}", "\u{110a}\u{1171}\u{11c0}"), ("\u{c4d2}", "\u{c4d2}",
        "\u{110a}\u{1171}\u{11c1}", "\u{c4d2}", "\u{110a}\u{1171}\u{11c1}"), ("\u{c4d3}",
        "\u{c4d3}", "\u{110a}\u{1171}\u{11c2}", "\u{c4d3}", "\u{110a}\u{1171}\u{11c2}"),
        ("\u{c4d4}", "\u{c4d4}", "\u{110a}\u{1172}", "\u{c4d4}", "\u{110a}\u{1172}"), ("\u{c4d5}",
        "\u{c4d5}", "\u{110a}\u{1172}\u{11a8}", "\u{c4d5}", "\u{110a}\u{1172}\u{11a8}"),
        ("\u{c4d6}", "\u{c4d6}", "\u{110a}\u{1172}\u{11a9}", "\u{c4d6}",
        "\u{110a}\u{1172}\u{11a9}"), ("\u{c4d7}", "\u{c4d7}", "\u{110a}\u{1172}\u{11aa}",
        "\u{c4d7}", "\u{110a}\u{1172}\u{11aa}"), ("\u{c4d8}", "\u{c4d8}",
        "\u{110a}\u{1172}\u{11ab}", "\u{c4d8}", "\u{110a}\u{1172}\u{11ab}"), ("\u{c4d9}",
        "\u{c4d9}", "\u{110a}\u{1172}\u{11ac}", "\u{c4d9}", "\u{110a}\u{1172}\u{11ac}"),
        ("\u{c4da}", "\u{c4da}", "\u{110a}\u{1172}\u{11ad}", "\u{c4da}",
        "\u{110a}\u{1172}\u{11ad}"), ("\u{c4db}", "\u{c4db}", "\u{110a}\u{1172}\u{11ae}",
        "\u{c4db}", "\u{110a}\u{1172}\u{11ae}"), ("\u{c4dc}", "\u{c4dc}",
        "\u{110a}\u{1172}\u{11af}", "\u{c4dc}", "\u{110a}\u{1172}\u{11af}"), ("\u{c4dd}",
        "\u{c4dd}", "\u{110a}\u{1172}\u{11b0}", "\u{c4dd}", "\u{110a}\u{1172}\u{11b0}"),
        ("\u{c4de}", "\u{c4de}", "\u{110a}\u{1172}\u{11b1}", "\u{c4de}",
        "\u{110a}\u{1172}\u{11b1}"), ("\u{c4df}", "\u{c4df}", "\u{110a}\u{1172}\u{11b2}",
        "\u{c4df}", "\u{110a}\u{1172}\u{11b2}"), ("\u{c4e0}", "\u{c4e0}",
        "\u{110a}\u{1172}\u{11b3}", "\u{c4e0}", "\u{110a}\u{1172}\u{11b3}"), ("\u{c4e1}",
        "\u{c4e1}", "\u{110a}\u{1172}\u{11b4}", "\u{c4e1}", "\u{110a}\u{1172}\u{11b4}"),
        ("\u{c4e2}", "\u{c4e2}", "\u{110a}\u{1172}\u{11b5}", "\u{c4e2}",
        "\u{110a}\u{1172}\u{11b5}"), ("\u{c4e3}", "\u{c4e3}", "\u{110a}\u{1172}\u{11b6}",
        "\u{c4e3}", "\u{110a}\u{1172}\u{11b6}"), ("\u{c4e4}", "\u{c4e4}",
        "\u{110a}\u{1172}\u{11b7}", "\u{c4e4}", "\u{110a}\u{1172}\u{11b7}"), ("\u{c4e5}",
        "\u{c4e5}", "\u{110a}\u{1172}\u{11b8}", "\u{c4e5}", "\u{110a}\u{1172}\u{11b8}"),
        ("\u{c4e6}", "\u{c4e6}", "\u{110a}\u{1172}\u{11b9}", "\u{c4e6}",
        "\u{110a}\u{1172}\u{11b9}"), ("\u{c4e7}", "\u{c4e7}", "\u{110a}\u{1172}\u{11ba}",
        "\u{c4e7}", "\u{110a}\u{1172}\u{11ba}"), ("\u{c4e8}", "\u{c4e8}",
        "\u{110a}\u{1172}\u{11bb}", "\u{c4e8}", "\u{110a}\u{1172}\u{11bb}"), ("\u{c4e9}",
        "\u{c4e9}", "\u{110a}\u{1172}\u{11bc}", "\u{c4e9}", "\u{110a}\u{1172}\u{11bc}"),
        ("\u{c4ea}", "\u{c4ea}", "\u{110a}\u{1172}\u{11bd}", "\u{c4ea}",
        "\u{110a}\u{1172}\u{11bd}"), ("\u{c4eb}", "\u{c4eb}", "\u{110a}\u{1172}\u{11be}",
        "\u{c4eb}", "\u{110a}\u{1172}\u{11be}"), ("\u{c4ec}", "\u{c4ec}",
        "\u{110a}\u{1172}\u{11bf}", "\u{c4ec}", "\u{110a}\u{1172}\u{11bf}"), ("\u{c4ed}",
        "\u{c4ed}", "\u{110a}\u{1172}\u{11c0}", "\u{c4ed}", "\u{110a}\u{1172}\u{11c0}"),
        ("\u{c4ee}", "\u{c4ee}", "\u{110a}\u{1172}\u{11c1}", "\u{c4ee}",
        "\u{110a}\u{1172}\u{11c1}"), ("\u{c4ef}", "\u{c4ef}", "\u{110a}\u{1172}\u{11c2}",
        "\u{c4ef}", "\u{110a}\u{1172}\u{11c2}"), ("\u{c4f0}", "\u{c4f0}", "\u{110a}\u{1173}",
        "\u{c4f0}", "\u{110a}\u{1173}"), ("\u{c4f1}", "\u{c4f1}", "\u{110a}\u{1173}\u{11a8}",
        "\u{c4f1}", "\u{110a}\u{1173}\u{11a8}"), ("\u{c4f2}", "\u{c4f2}",
        "\u{110a}\u{1173}\u{11a9}", "\u{c4f2}", "\u{110a}\u{1173}\u{11a9}"), ("\u{c4f3}",
        "\u{c4f3}", "\u{110a}\u{1173}\u{11aa}", "\u{c4f3}", "\u{110a}\u{1173}\u{11aa}"),
        ("\u{c4f4}", "\u{c4f4}", "\u{110a}\u{1173}\u{11ab}", "\u{c4f4}",
        "\u{110a}\u{1173}\u{11ab}"), ("\u{c4f5}", "\u{c4f5}", "\u{110a}\u{1173}\u{11ac}",
        "\u{c4f5}", "\u{110a}\u{1173}\u{11ac}"), ("\u{c4f6}", "\u{c4f6}",
        "\u{110a}\u{1173}\u{11ad}", "\u{c4f6}", "\u{110a}\u{1173}\u{11ad}"), ("\u{c4f7}",
        "\u{c4f7}", "\u{110a}\u{1173}\u{11ae}", "\u{c4f7}", "\u{110a}\u{1173}\u{11ae}"),
        ("\u{c4f8}", "\u{c4f8}", "\u{110a}\u{1173}\u{11af}", "\u{c4f8}",
        "\u{110a}\u{1173}\u{11af}"), ("\u{c4f9}", "\u{c4f9}", "\u{110a}\u{1173}\u{11b0}",
        "\u{c4f9}", "\u{110a}\u{1173}\u{11b0}"), ("\u{c4fa}", "\u{c4fa}",
        "\u{110a}\u{1173}\u{11b1}", "\u{c4fa}", "\u{110a}\u{1173}\u{11b1}"), ("\u{c4fb}",
        "\u{c4fb}", "\u{110a}\u{1173}\u{11b2}", "\u{c4fb}", "\u{110a}\u{1173}\u{11b2}"),
        ("\u{c4fc}", "\u{c4fc}", "\u{110a}\u{1173}\u{11b3}", "\u{c4fc}",
        "\u{110a}\u{1173}\u{11b3}"), ("\u{c4fd}", "\u{c4fd}", "\u{110a}\u{1173}\u{11b4}",
        "\u{c4fd}", "\u{110a}\u{1173}\u{11b4}"), ("\u{c4fe}", "\u{c4fe}",
        "\u{110a}\u{1173}\u{11b5}", "\u{c4fe}", "\u{110a}\u{1173}\u{11b5}"), ("\u{c4ff}",
        "\u{c4ff}", "\u{110a}\u{1173}\u{11b6}", "\u{c4ff}", "\u{110a}\u{1173}\u{11b6}"),
        ("\u{c500}", "\u{c500}", "\u{110a}\u{1173}\u{11b7}", "\u{c500}",
        "\u{110a}\u{1173}\u{11b7}"), ("\u{c501}", "\u{c501}", "\u{110a}\u{1173}\u{11b8}",
        "\u{c501}", "\u{110a}\u{1173}\u{11b8}"), ("\u{c502}", "\u{c502}",
        "\u{110a}\u{1173}\u{11b9}", "\u{c502}", "\u{110a}\u{1173}\u{11b9}"), ("\u{c503}",
        "\u{c503}", "\u{110a}\u{1173}\u{11ba}", "\u{c503}", "\u{110a}\u{1173}\u{11ba}"),
        ("\u{c504}", "\u{c504}", "\u{110a}\u{1173}\u{11bb}", "\u{c504}",
        "\u{110a}\u{1173}\u{11bb}"), ("\u{c505}", "\u{c505}", "\u{110a}\u{1173}\u{11bc}",
        "\u{c505}", "\u{110a}\u{1173}\u{11bc}"), ("\u{c506}", "\u{c506}",
        "\u{110a}\u{1173}\u{11bd}", "\u{c506}", "\u{110a}\u{1173}\u{11bd}"), ("\u{c507}",
        "\u{c507}", "\u{110a}\u{1173}\u{11be}", "\u{c507}", "\u{110a}\u{1173}\u{11be}"),
        ("\u{c508}", "\u{c508}", "\u{110a}\u{1173}\u{11bf}", "\u{c508}",
        "\u{110a}\u{1173}\u{11bf}"), ("\u{c509}", "\u{c509}", "\u{110a}\u{1173}\u{11c0}",
        "\u{c509}", "\u{110a}\u{1173}\u{11c0}"), ("\u{c50a}", "\u{c50a}",
        "\u{110a}\u{1173}\u{11c1}", "\u{c50a}", "\u{110a}\u{1173}\u{11c1}"), ("\u{c50b}",
        "\u{c50b}", "\u{110a}\u{1173}\u{11c2}", "\u{c50b}", "\u{110a}\u{1173}\u{11c2}"),
        ("\u{c50c}", "\u{c50c}", "\u{110a}\u{1174}", "\u{c50c}", "\u{110a}\u{1174}"), ("\u{c50d}",
        "\u{c50d}", "\u{110a}\u{1174}\u{11a8}", "\u{c50d}", "\u{110a}\u{1174}\u{11a8}"),
        ("\u{c50e}", "\u{c50e}", "\u{110a}\u{1174}\u{11a9}", "\u{c50e}",
        "\u{110a}\u{1174}\u{11a9}"), ("\u{c50f}", "\u{c50f}", "\u{110a}\u{1174}\u{11aa}",
        "\u{c50f}", "\u{110a}\u{1174}\u{11aa}"), ("\u{c510}", "\u{c510}",
        "\u{110a}\u{1174}\u{11ab}", "\u{c510}", "\u{110a}\u{1174}\u{11ab}"), ("\u{c511}",
        "\u{c511}", "\u{110a}\u{1174}\u{11ac}", "\u{c511}", "\u{110a}\u{1174}\u{11ac}"),
        ("\u{c512}", "\u{c512}", "\u{110a}\u{1174}\u{11ad}", "\u{c512}",
        "\u{110a}\u{1174}\u{11ad}"), ("\u{c513}", "\u{c513}", "\u{110a}\u{1174}\u{11ae}",
        "\u{c513}", "\u{110a}\u{1174}\u{11ae}"), ("\u{c514}", "\u{c514}",
        "\u{110a}\u{1174}\u{11af}", "\u{c514}", "\u{110a}\u{1174}\u{11af}"), ("\u{c515}",
        "\u{c515}", "\u{110a}\u{1174}\u{11b0}", "\u{c515}", "\u{110a}\u{1174}\u{11b0}"),
        ("\u{c516}", "\u{c516}", "\u{110a}\u{1174}\u{11b1}", "\u{c516}",
        "\u{110a}\u{1174}\u{11b1}"), ("\u{c517}", "\u{c517}", "\u{110a}\u{1174}\u{11b2}",
        "\u{c517}", "\u{110a}\u{1174}\u{11b2}"), ("\u{c518}", "\u{c518}",
        "\u{110a}\u{1174}\u{11b3}", "\u{c518}", "\u{110a}\u{1174}\u{11b3}"), ("\u{c519}",
        "\u{c519}", "\u{110a}\u{1174}\u{11b4}", "\u{c519}", "\u{110a}\u{1174}\u{11b4}"),
        ("\u{c51a}", "\u{c51a}", "\u{110a}\u{1174}\u{11b5}", "\u{c51a}",
        "\u{110a}\u{1174}\u{11b5}"), ("\u{c51b}", "\u{c51b}", "\u{110a}\u{1174}\u{11b6}",
        "\u{c51b}", "\u{110a}\u{1174}\u{11b6}"), ("\u{c51c}", "\u{c51c}",
        "\u{110a}\u{1174}\u{11b7}", "\u{c51c}", "\u{110a}\u{1174}\u{11b7}"), ("\u{c51d}",
        "\u{c51d}", "\u{110a}\u{1174}\u{11b8}", "\u{c51d}", "\u{110a}\u{1174}\u{11b8}"),
        ("\u{c51e}", "\u{c51e}", "\u{110a}\u{1174}\u{11b9}", "\u{c51e}",
        "\u{110a}\u{1174}\u{11b9}"), ("\u{c51f}", "\u{c51f}", "\u{110a}\u{1174}\u{11ba}",
        "\u{c51f}", "\u{110a}\u{1174}\u{11ba}"), ("\u{c520}", "\u{c520}",
        "\u{110a}\u{1174}\u{11bb}", "\u{c520}", "\u{110a}\u{1174}\u{11bb}"), ("\u{c521}",
        "\u{c521}", "\u{110a}\u{1174}\u{11bc}", "\u{c521}", "\u{110a}\u{1174}\u{11bc}"),
        ("\u{c522}", "\u{c522}", "\u{110a}\u{1174}\u{11bd}", "\u{c522}",
        "\u{110a}\u{1174}\u{11bd}"), ("\u{c523}", "\u{c523}", "\u{110a}\u{1174}\u{11be}",
        "\u{c523}", "\u{110a}\u{1174}\u{11be}"), ("\u{c524}", "\u{c524}",
        "\u{110a}\u{1174}\u{11bf}", "\u{c524}", "\u{110a}\u{1174}\u{11bf}"), ("\u{c525}",
        "\u{c525}", "\u{110a}\u{1174}\u{11c0}", "\u{c525}", "\u{110a}\u{1174}\u{11c0}"),
        ("\u{c526}", "\u{c526}", "\u{110a}\u{1174}\u{11c1}", "\u{c526}",
        "\u{110a}\u{1174}\u{11c1}"), ("\u{c527}", "\u{c527}", "\u{110a}\u{1174}\u{11c2}",
        "\u{c527}", "\u{110a}\u{1174}\u{11c2}"), ("\u{c528}", "\u{c528}", "\u{110a}\u{1175}",
        "\u{c528}", "\u{110a}\u{1175}"), ("\u{c529}", "\u{c529}", "\u{110a}\u{1175}\u{11a8}",
        "\u{c529}", "\u{110a}\u{1175}\u{11a8}"), ("\u{c52a}", "\u{c52a}",
        "\u{110a}\u{1175}\u{11a9}", "\u{c52a}", "\u{110a}\u{1175}\u{11a9}"), ("\u{c52b}",
        "\u{c52b}", "\u{110a}\u{1175}\u{11aa}", "\u{c52b}", "\u{110a}\u{1175}\u{11aa}"),
        ("\u{c52c}", "\u{c52c}", "\u{110a}\u{1175}\u{11ab}", "\u{c52c}",
        "\u{110a}\u{1175}\u{11ab}"), ("\u{c52d}", "\u{c52d}", "\u{110a}\u{1175}\u{11ac}",
        "\u{c52d}", "\u{110a}\u{1175}\u{11ac}"), ("\u{c52e}", "\u{c52e}",
        "\u{110a}\u{1175}\u{11ad}", "\u{c52e}", "\u{110a}\u{1175}\u{11ad}"), ("\u{c52f}",
        "\u{c52f}", "\u{110a}\u{1175}\u{11ae}", "\u{c52f}", "\u{110a}\u{1175}\u{11ae}"),
        ("\u{c530}", "\u{c530}", "\u{110a}\u{1175}\u{11af}", "\u{c530}",
        "\u{110a}\u{1175}\u{11af}"), ("\u{c531}", "\u{c531}", "\u{110a}\u{1175}\u{11b0}",
        "\u{c531}", "\u{110a}\u{1175}\u{11b0}"), ("\u{c532}", "\u{c532}",
        "\u{110a}\u{1175}\u{11b1}", "\u{c532}", "\u{110a}\u{1175}\u{11b1}"), ("\u{c533}",
        "\u{c533}", "\u{110a}\u{1175}\u{11b2}", "\u{c533}", "\u{110a}\u{1175}\u{11b2}"),
        ("\u{c534}", "\u{c534}", "\u{110a}\u{1175}\u{11b3}", "\u{c534}",
        "\u{110a}\u{1175}\u{11b3}"), ("\u{c535}", "\u{c535}", "\u{110a}\u{1175}\u{11b4}",
        "\u{c535}", "\u{110a}\u{1175}\u{11b4}"), ("\u{c536}", "\u{c536}",
        "\u{110a}\u{1175}\u{11b5}", "\u{c536}", "\u{110a}\u{1175}\u{11b5}"), ("\u{c537}",
        "\u{c537}", "\u{110a}\u{1175}\u{11b6}", "\u{c537}", "\u{110a}\u{1175}\u{11b6}"),
        ("\u{c538}", "\u{c538}", "\u{110a}\u{1175}\u{11b7}", "\u{c538}",
        "\u{110a}\u{1175}\u{11b7}"), ("\u{c539}", "\u{c539}", "\u{110a}\u{1175}\u{11b8}",
        "\u{c539}", "\u{110a}\u{1175}\u{11b8}"), ("\u{c53a}", "\u{c53a}",
        "\u{110a}\u{1175}\u{11b9}", "\u{c53a}", "\u{110a}\u{1175}\u{11b9}"), ("\u{c53b}",
        "\u{c53b}", "\u{110a}\u{1175}\u{11ba}", "\u{c53b}", "\u{110a}\u{1175}\u{11ba}"),
        ("\u{c53c}", "\u{c53c}", "\u{110a}\u{1175}\u{11bb}", "\u{c53c}",
        "\u{110a}\u{1175}\u{11bb}"), ("\u{c53d}", "\u{c53d}", "\u{110a}\u{1175}\u{11bc}",
        "\u{c53d}", "\u{110a}\u{1175}\u{11bc}"), ("\u{c53e}", "\u{c53e}",
        "\u{110a}\u{1175}\u{11bd}", "\u{c53e}", "\u{110a}\u{1175}\u{11bd}"), ("\u{c53f}",
        "\u{c53f}", "\u{110a}\u{1175}\u{11be}", "\u{c53f}", "\u{110a}\u{1175}\u{11be}"),
        ("\u{c540}", "\u{c540}", "\u{110a}\u{1175}\u{11bf}", "\u{c540}",
        "\u{110a}\u{1175}\u{11bf}"), ("\u{c541}", "\u{c541}", "\u{110a}\u{1175}\u{11c0}",
        "\u{c541}", "\u{110a}\u{1175}\u{11c0}"), ("\u{c542}", "\u{c542}",
        "\u{110a}\u{1175}\u{11c1}", "\u{c542}", "\u{110a}\u{1175}\u{11c1}"), ("\u{c543}",
        "\u{c543}", "\u{110a}\u{1175}\u{11c2}", "\u{c543}", "\u{110a}\u{1175}\u{11c2}"),
        ("\u{c544}", "\u{c544}", "\u{110b}\u{1161}", "\u{c544}", "\u{110b}\u{1161}"), ("\u{c545}",
        "\u{c545}", "\u{110b}\u{1161}\u{11a8}", "\u{c545}", "\u{110b}\u{1161}\u{11a8}"),
        ("\u{c546}", "\u{c546}", "\u{110b}\u{1161}\u{11a9}", "\u{c546}",
        "\u{110b}\u{1161}\u{11a9}"), ("\u{c547}", "\u{c547}", "\u{110b}\u{1161}\u{11aa}",
        "\u{c547}", "\u{110b}\u{1161}\u{11aa}"), ("\u{c548}", "\u{c548}",
        "\u{110b}\u{1161}\u{11ab}", "\u{c548}", "\u{110b}\u{1161}\u{11ab}"), ("\u{c549}",
        "\u{c549}", "\u{110b}\u{1161}\u{11ac}", "\u{c549}", "\u{110b}\u{1161}\u{11ac}"),
        ("\u{c54a}", "\u{c54a}", "\u{110b}\u{1161}\u{11ad}", "\u{c54a}",
        "\u{110b}\u{1161}\u{11ad}"), ("\u{c54b}", "\u{c54b}", "\u{110b}\u{1161}\u{11ae}",
        "\u{c54b}", "\u{110b}\u{1161}\u{11ae}"), ("\u{c54c}", "\u{c54c}",
        "\u{110b}\u{1161}\u{11af}", "\u{c54c}", "\u{110b}\u{1161}\u{11af}"), ("\u{c54d}",
        "\u{c54d}", "\u{110b}\u{1161}\u{11b0}", "\u{c54d}", "\u{110b}\u{1161}\u{11b0}"),
        ("\u{c54e}", "\u{c54e}", "\u{110b}\u{1161}\u{11b1}", "\u{c54e}",
        "\u{110b}\u{1161}\u{11b1}"), ("\u{c54f}", "\u{c54f}", "\u{110b}\u{1161}\u{11b2}",
        "\u{c54f}", "\u{110b}\u{1161}\u{11b2}"), ("\u{c550}", "\u{c550}",
        "\u{110b}\u{1161}\u{11b3}", "\u{c550}", "\u{110b}\u{1161}\u{11b3}"), ("\u{c551}",
        "\u{c551}", "\u{110b}\u{1161}\u{11b4}", "\u{c551}", "\u{110b}\u{1161}\u{11b4}"),
        ("\u{c552}", "\u{c552}", "\u{110b}\u{1161}\u{11b5}", "\u{c552}",
        "\u{110b}\u{1161}\u{11b5}"), ("\u{c553}", "\u{c553}", "\u{110b}\u{1161}\u{11b6}",
        "\u{c553}", "\u{110b}\u{1161}\u{11b6}"), ("\u{c554}", "\u{c554}",
        "\u{110b}\u{1161}\u{11b7}", "\u{c554}", "\u{110b}\u{1161}\u{11b7}"), ("\u{c555}",
        "\u{c555}", "\u{110b}\u{1161}\u{11b8}", "\u{c555}", "\u{110b}\u{1161}\u{11b8}"),
        ("\u{c556}", "\u{c556}", "\u{110b}\u{1161}\u{11b9}", "\u{c556}",
        "\u{110b}\u{1161}\u{11b9}"), ("\u{c557}", "\u{c557}", "\u{110b}\u{1161}\u{11ba}",
        "\u{c557}", "\u{110b}\u{1161}\u{11ba}"), ("\u{c558}", "\u{c558}",
        "\u{110b}\u{1161}\u{11bb}", "\u{c558}", "\u{110b}\u{1161}\u{11bb}"), ("\u{c559}",
        "\u{c559}", "\u{110b}\u{1161}\u{11bc}", "\u{c559}", "\u{110b}\u{1161}\u{11bc}"),
        ("\u{c55a}", "\u{c55a}", "\u{110b}\u{1161}\u{11bd}", "\u{c55a}",
        "\u{110b}\u{1161}\u{11bd}"), ("\u{c55b}", "\u{c55b}", "\u{110b}\u{1161}\u{11be}",
        "\u{c55b}", "\u{110b}\u{1161}\u{11be}"), ("\u{c55c}", "\u{c55c}",
        "\u{110b}\u{1161}\u{11bf}", "\u{c55c}", "\u{110b}\u{1161}\u{11bf}"), ("\u{c55d}",
        "\u{c55d}", "\u{110b}\u{1161}\u{11c0}", "\u{c55d}", "\u{110b}\u{1161}\u{11c0}"),
        ("\u{c55e}", "\u{c55e}", "\u{110b}\u{1161}\u{11c1}", "\u{c55e}",
        "\u{110b}\u{1161}\u{11c1}"), ("\u{c55f}", "\u{c55f}", "\u{110b}\u{1161}\u{11c2}",
        "\u{c55f}", "\u{110b}\u{1161}\u{11c2}"), ("\u{c560}", "\u{c560}", "\u{110b}\u{1162}",
        "\u{c560}", "\u{110b}\u{1162}"), ("\u{c561}", "\u{c561}", "\u{110b}\u{1162}\u{11a8}",
        "\u{c561}", "\u{110b}\u{1162}\u{11a8}"), ("\u{c562}", "\u{c562}",
        "\u{110b}\u{1162}\u{11a9}", "\u{c562}", "\u{110b}\u{1162}\u{11a9}"), ("\u{c563}",
        "\u{c563}", "\u{110b}\u{1162}\u{11aa}", "\u{c563}", "\u{110b}\u{1162}\u{11aa}"),
        ("\u{c564}", "\u{c564}", "\u{110b}\u{1162}\u{11ab}", "\u{c564}",
        "\u{110b}\u{1162}\u{11ab}"), ("\u{c565}", "\u{c565}", "\u{110b}\u{1162}\u{11ac}",
        "\u{c565}", "\u{110b}\u{1162}\u{11ac}"), ("\u{c566}", "\u{c566}",
        "\u{110b}\u{1162}\u{11ad}", "\u{c566}", "\u{110b}\u{1162}\u{11ad}"), ("\u{c567}",
        "\u{c567}", "\u{110b}\u{1162}\u{11ae}", "\u{c567}", "\u{110b}\u{1162}\u{11ae}"),
        ("\u{c568}", "\u{c568}", "\u{110b}\u{1162}\u{11af}", "\u{c568}",
        "\u{110b}\u{1162}\u{11af}"), ("\u{c569}", "\u{c569}", "\u{110b}\u{1162}\u{11b0}",
        "\u{c569}", "\u{110b}\u{1162}\u{11b0}"), ("\u{c56a}", "\u{c56a}",
        "\u{110b}\u{1162}\u{11b1}", "\u{c56a}", "\u{110b}\u{1162}\u{11b1}"), ("\u{c56b}",
        "\u{c56b}", "\u{110b}\u{1162}\u{11b2}", "\u{c56b}", "\u{110b}\u{1162}\u{11b2}"),
        ("\u{c56c}", "\u{c56c}", "\u{110b}\u{1162}\u{11b3}", "\u{c56c}",
        "\u{110b}\u{1162}\u{11b3}"), ("\u{c56d}", "\u{c56d}", "\u{110b}\u{1162}\u{11b4}",
        "\u{c56d}", "\u{110b}\u{1162}\u{11b4}"), ("\u{c56e}", "\u{c56e}",
        "\u{110b}\u{1162}\u{11b5}", "\u{c56e}", "\u{110b}\u{1162}\u{11b5}"), ("\u{c56f}",
        "\u{c56f}", "\u{110b}\u{1162}\u{11b6}", "\u{c56f}", "\u{110b}\u{1162}\u{11b6}"),
        ("\u{c570}", "\u{c570}", "\u{110b}\u{1162}\u{11b7}", "\u{c570}",
        "\u{110b}\u{1162}\u{11b7}"), ("\u{c571}", "\u{c571}", "\u{110b}\u{1162}\u{11b8}",
        "\u{c571}", "\u{110b}\u{1162}\u{11b8}"), ("\u{c572}", "\u{c572}",
        "\u{110b}\u{1162}\u{11b9}", "\u{c572}", "\u{110b}\u{1162}\u{11b9}"), ("\u{c573}",
        "\u{c573}", "\u{110b}\u{1162}\u{11ba}", "\u{c573}", "\u{110b}\u{1162}\u{11ba}"),
        ("\u{c574}", "\u{c574}", "\u{110b}\u{1162}\u{11bb}", "\u{c574}",
        "\u{110b}\u{1162}\u{11bb}"), ("\u{c575}", "\u{c575}", "\u{110b}\u{1162}\u{11bc}",
        "\u{c575}", "\u{110b}\u{1162}\u{11bc}"), ("\u{c576}", "\u{c576}",
        "\u{110b}\u{1162}\u{11bd}", "\u{c576}", "\u{110b}\u{1162}\u{11bd}"), ("\u{c577}",
        "\u{c577}", "\u{110b}\u{1162}\u{11be}", "\u{c577}", "\u{110b}\u{1162}\u{11be}"),
        ("\u{c578}", "\u{c578}", "\u{110b}\u{1162}\u{11bf}", "\u{c578}",
        "\u{110b}\u{1162}\u{11bf}"), ("\u{c579}", "\u{c579}", "\u{110b}\u{1162}\u{11c0}",
        "\u{c579}", "\u{110b}\u{1162}\u{11c0}"), ("\u{c57a}", "\u{c57a}",
        "\u{110b}\u{1162}\u{11c1}", "\u{c57a}", "\u{110b}\u{1162}\u{11c1}"), ("\u{c57b}",
        "\u{c57b}", "\u{110b}\u{1162}\u{11c2}", "\u{c57b}", "\u{110b}\u{1162}\u{11c2}"),
        ("\u{c57c}", "\u{c57c}", "\u{110b}\u{1163}", "\u{c57c}", "\u{110b}\u{1163}"), ("\u{c57d}",
        "\u{c57d}", "\u{110b}\u{1163}\u{11a8}", "\u{c57d}", "\u{110b}\u{1163}\u{11a8}"),
        ("\u{c57e}", "\u{c57e}", "\u{110b}\u{1163}\u{11a9}", "\u{c57e}",
        "\u{110b}\u{1163}\u{11a9}"), ("\u{c57f}", "\u{c57f}", "\u{110b}\u{1163}\u{11aa}",
        "\u{c57f}", "\u{110b}\u{1163}\u{11aa}"), ("\u{c580}", "\u{c580}",
        "\u{110b}\u{1163}\u{11ab}", "\u{c580}", "\u{110b}\u{1163}\u{11ab}"), ("\u{c581}",
        "\u{c581}", "\u{110b}\u{1163}\u{11ac}", "\u{c581}", "\u{110b}\u{1163}\u{11ac}"),
        ("\u{c582}", "\u{c582}", "\u{110b}\u{1163}\u{11ad}", "\u{c582}",
        "\u{110b}\u{1163}\u{11ad}"), ("\u{c583}", "\u{c583}", "\u{110b}\u{1163}\u{11ae}",
        "\u{c583}", "\u{110b}\u{1163}\u{11ae}"), ("\u{c584}", "\u{c584}",
        "\u{110b}\u{1163}\u{11af}", "\u{c584}", "\u{110b}\u{1163}\u{11af}"), ("\u{c585}",
        "\u{c585}", "\u{110b}\u{1163}\u{11b0}", "\u{c585}", "\u{110b}\u{1163}\u{11b0}"),
        ("\u{c586}", "\u{c586}", "\u{110b}\u{1163}\u{11b1}", "\u{c586}",
        "\u{110b}\u{1163}\u{11b1}"), ("\u{c587}", "\u{c587}", "\u{110b}\u{1163}\u{11b2}",
        "\u{c587}", "\u{110b}\u{1163}\u{11b2}"), ("\u{c588}", "\u{c588}",
        "\u{110b}\u{1163}\u{11b3}", "\u{c588}", "\u{110b}\u{1163}\u{11b3}"), ("\u{c589}",
        "\u{c589}", "\u{110b}\u{1163}\u{11b4}", "\u{c589}", "\u{110b}\u{1163}\u{11b4}"),
        ("\u{c58a}", "\u{c58a}", "\u{110b}\u{1163}\u{11b5}", "\u{c58a}",
        "\u{110b}\u{1163}\u{11b5}"), ("\u{c58b}", "\u{c58b}", "\u{110b}\u{1163}\u{11b6}",
        "\u{c58b}", "\u{110b}\u{1163}\u{11b6}"), ("\u{c58c}", "\u{c58c}",
        "\u{110b}\u{1163}\u{11b7}", "\u{c58c}", "\u{110b}\u{1163}\u{11b7}"), ("\u{c58d}",
        "\u{c58d}", "\u{110b}\u{1163}\u{11b8}", "\u{c58d}", "\u{110b}\u{1163}\u{11b8}"),
        ("\u{c58e}", "\u{c58e}", "\u{110b}\u{1163}\u{11b9}", "\u{c58e}",
        "\u{110b}\u{1163}\u{11b9}"), ("\u{c58f}", "\u{c58f}", "\u{110b}\u{1163}\u{11ba}",
        "\u{c58f}", "\u{110b}\u{1163}\u{11ba}"), ("\u{c590}", "\u{c590}",
        "\u{110b}\u{1163}\u{11bb}", "\u{c590}", "\u{110b}\u{1163}\u{11bb}"), ("\u{c591}",
        "\u{c591}", "\u{110b}\u{1163}\u{11bc}", "\u{c591}", "\u{110b}\u{1163}\u{11bc}"),
        ("\u{c592}", "\u{c592}", "\u{110b}\u{1163}\u{11bd}", "\u{c592}",
        "\u{110b}\u{1163}\u{11bd}"), ("\u{c593}", "\u{c593}", "\u{110b}\u{1163}\u{11be}",
        "\u{c593}", "\u{110b}\u{1163}\u{11be}"), ("\u{c594}", "\u{c594}",
        "\u{110b}\u{1163}\u{11bf}", "\u{c594}", "\u{110b}\u{1163}\u{11bf}"), ("\u{c595}",
        "\u{c595}", "\u{110b}\u{1163}\u{11c0}", "\u{c595}", "\u{110b}\u{1163}\u{11c0}"),
        ("\u{c596}", "\u{c596}", "\u{110b}\u{1163}\u{11c1}", "\u{c596}",
        "\u{110b}\u{1163}\u{11c1}"), ("\u{c597}", "\u{c597}", "\u{110b}\u{1163}\u{11c2}",
        "\u{c597}", "\u{110b}\u{1163}\u{11c2}"), ("\u{c598}", "\u{c598}", "\u{110b}\u{1164}",
        "\u{c598}", "\u{110b}\u{1164}"), ("\u{c599}", "\u{c599}", "\u{110b}\u{1164}\u{11a8}",
        "\u{c599}", "\u{110b}\u{1164}\u{11a8}"), ("\u{c59a}", "\u{c59a}",
        "\u{110b}\u{1164}\u{11a9}", "\u{c59a}", "\u{110b}\u{1164}\u{11a9}"), ("\u{c59b}",
        "\u{c59b}", "\u{110b}\u{1164}\u{11aa}", "\u{c59b}", "\u{110b}\u{1164}\u{11aa}"),
        ("\u{c59c}", "\u{c59c}", "\u{110b}\u{1164}\u{11ab}", "\u{c59c}",
        "\u{110b}\u{1164}\u{11ab}"), ("\u{c59d}", "\u{c59d}", "\u{110b}\u{1164}\u{11ac}",
        "\u{c59d}", "\u{110b}\u{1164}\u{11ac}"), ("\u{c59e}", "\u{c59e}",
        "\u{110b}\u{1164}\u{11ad}", "\u{c59e}", "\u{110b}\u{1164}\u{11ad}"), ("\u{c59f}",
        "\u{c59f}", "\u{110b}\u{1164}\u{11ae}", "\u{c59f}", "\u{110b}\u{1164}\u{11ae}"),
        ("\u{c5a0}", "\u{c5a0}", "\u{110b}\u{1164}\u{11af}", "\u{c5a0}",
        "\u{110b}\u{1164}\u{11af}"), ("\u{c5a1}", "\u{c5a1}", "\u{110b}\u{1164}\u{11b0}",
        "\u{c5a1}", "\u{110b}\u{1164}\u{11b0}"), ("\u{c5a2}", "\u{c5a2}",
        "\u{110b}\u{1164}\u{11b1}", "\u{c5a2}", "\u{110b}\u{1164}\u{11b1}"), ("\u{c5a3}",
        "\u{c5a3}", "\u{110b}\u{1164}\u{11b2}", "\u{c5a3}", "\u{110b}\u{1164}\u{11b2}"),
        ("\u{c5a4}", "\u{c5a4}", "\u{110b}\u{1164}\u{11b3}", "\u{c5a4}",
        "\u{110b}\u{1164}\u{11b3}"), ("\u{c5a5}", "\u{c5a5}", "\u{110b}\u{1164}\u{11b4}",
        "\u{c5a5}", "\u{110b}\u{1164}\u{11b4}"), ("\u{c5a6}", "\u{c5a6}",
        "\u{110b}\u{1164}\u{11b5}", "\u{c5a6}", "\u{110b}\u{1164}\u{11b5}"), ("\u{c5a7}",
        "\u{c5a7}", "\u{110b}\u{1164}\u{11b6}", "\u{c5a7}", "\u{110b}\u{1164}\u{11b6}"),
        ("\u{c5a8}", "\u{c5a8}", "\u{110b}\u{1164}\u{11b7}", "\u{c5a8}",
        "\u{110b}\u{1164}\u{11b7}"), ("\u{c5a9}", "\u{c5a9}", "\u{110b}\u{1164}\u{11b8}",
        "\u{c5a9}", "\u{110b}\u{1164}\u{11b8}"), ("\u{c5aa}", "\u{c5aa}",
        "\u{110b}\u{1164}\u{11b9}", "\u{c5aa}", "\u{110b}\u{1164}\u{11b9}"), ("\u{c5ab}",
        "\u{c5ab}", "\u{110b}\u{1164}\u{11ba}", "\u{c5ab}", "\u{110b}\u{1164}\u{11ba}"),
        ("\u{c5ac}", "\u{c5ac}", "\u{110b}\u{1164}\u{11bb}", "\u{c5ac}",
        "\u{110b}\u{1164}\u{11bb}"), ("\u{c5ad}", "\u{c5ad}", "\u{110b}\u{1164}\u{11bc}",
        "\u{c5ad}", "\u{110b}\u{1164}\u{11bc}"), ("\u{c5ae}", "\u{c5ae}",
        "\u{110b}\u{1164}\u{11bd}", "\u{c5ae}", "\u{110b}\u{1164}\u{11bd}"), ("\u{c5af}",
        "\u{c5af}", "\u{110b}\u{1164}\u{11be}", "\u{c5af}", "\u{110b}\u{1164}\u{11be}"),
        ("\u{c5b0}", "\u{c5b0}", "\u{110b}\u{1164}\u{11bf}", "\u{c5b0}",
        "\u{110b}\u{1164}\u{11bf}"), ("\u{c5b1}", "\u{c5b1}", "\u{110b}\u{1164}\u{11c0}",
        "\u{c5b1}", "\u{110b}\u{1164}\u{11c0}"), ("\u{c5b2}", "\u{c5b2}",
        "\u{110b}\u{1164}\u{11c1}", "\u{c5b2}", "\u{110b}\u{1164}\u{11c1}"), ("\u{c5b3}",
        "\u{c5b3}", "\u{110b}\u{1164}\u{11c2}", "\u{c5b3}", "\u{110b}\u{1164}\u{11c2}"),
        ("\u{c5b4}", "\u{c5b4}", "\u{110b}\u{1165}", "\u{c5b4}", "\u{110b}\u{1165}"), ("\u{c5b5}",
        "\u{c5b5}", "\u{110b}\u{1165}\u{11a8}", "\u{c5b5}", "\u{110b}\u{1165}\u{11a8}"),
        ("\u{c5b6}", "\u{c5b6}", "\u{110b}\u{1165}\u{11a9}", "\u{c5b6}",
        "\u{110b}\u{1165}\u{11a9}"), ("\u{c5b7}", "\u{c5b7}", "\u{110b}\u{1165}\u{11aa}",
        "\u{c5b7}", "\u{110b}\u{1165}\u{11aa}"), ("\u{c5b8}", "\u{c5b8}",
        "\u{110b}\u{1165}\u{11ab}", "\u{c5b8}", "\u{110b}\u{1165}\u{11ab}"), ("\u{c5b9}",
        "\u{c5b9}", "\u{110b}\u{1165}\u{11ac}", "\u{c5b9}", "\u{110b}\u{1165}\u{11ac}"),
        ("\u{c5ba}", "\u{c5ba}", "\u{110b}\u{1165}\u{11ad}", "\u{c5ba}",
        "\u{110b}\u{1165}\u{11ad}"), ("\u{c5bb}", "\u{c5bb}", "\u{110b}\u{1165}\u{11ae}",
        "\u{c5bb}", "\u{110b}\u{1165}\u{11ae}"), ("\u{c5bc}", "\u{c5bc}",
        "\u{110b}\u{1165}\u{11af}", "\u{c5bc}", "\u{110b}\u{1165}\u{11af}"), ("\u{c5bd}",
        "\u{c5bd}", "\u{110b}\u{1165}\u{11b0}", "\u{c5bd}", "\u{110b}\u{1165}\u{11b0}"),
        ("\u{c5be}", "\u{c5be}", "\u{110b}\u{1165}\u{11b1}", "\u{c5be}",
        "\u{110b}\u{1165}\u{11b1}"), ("\u{c5bf}", "\u{c5bf}", "\u{110b}\u{1165}\u{11b2}",
        "\u{c5bf}", "\u{110b}\u{1165}\u{11b2}"), ("\u{c5c0}", "\u{c5c0}",
        "\u{110b}\u{1165}\u{11b3}", "\u{c5c0}", "\u{110b}\u{1165}\u{11b3}"), ("\u{c5c1}",
        "\u{c5c1}", "\u{110b}\u{1165}\u{11b4}", "\u{c5c1}", "\u{110b}\u{1165}\u{11b4}"),
        ("\u{c5c2}", "\u{c5c2}", "\u{110b}\u{1165}\u{11b5}", "\u{c5c2}",
        "\u{110b}\u{1165}\u{11b5}"), ("\u{c5c3}", "\u{c5c3}", "\u{110b}\u{1165}\u{11b6}",
        "\u{c5c3}", "\u{110b}\u{1165}\u{11b6}"), ("\u{c5c4}", "\u{c5c4}",
        "\u{110b}\u{1165}\u{11b7}", "\u{c5c4}", "\u{110b}\u{1165}\u{11b7}"), ("\u{c5c5}",
        "\u{c5c5}", "\u{110b}\u{1165}\u{11b8}", "\u{c5c5}", "\u{110b}\u{1165}\u{11b8}"),
        ("\u{c5c6}", "\u{c5c6}", "\u{110b}\u{1165}\u{11b9}", "\u{c5c6}",
        "\u{110b}\u{1165}\u{11b9}"), ("\u{c5c7}", "\u{c5c7}", "\u{110b}\u{1165}\u{11ba}",
        "\u{c5c7}", "\u{110b}\u{1165}\u{11ba}"), ("\u{c5c8}", "\u{c5c8}",
        "\u{110b}\u{1165}\u{11bb}", "\u{c5c8}", "\u{110b}\u{1165}\u{11bb}"), ("\u{c5c9}",
        "\u{c5c9}", "\u{110b}\u{1165}\u{11bc}", "\u{c5c9}", "\u{110b}\u{1165}\u{11bc}"),
        ("\u{c5ca}", "\u{c5ca}", "\u{110b}\u{1165}\u{11bd}", "\u{c5ca}",
        "\u{110b}\u{1165}\u{11bd}"), ("\u{c5cb}", "\u{c5cb}", "\u{110b}\u{1165}\u{11be}",
        "\u{c5cb}", "\u{110b}\u{1165}\u{11be}"), ("\u{c5cc}", "\u{c5cc}",
        "\u{110b}\u{1165}\u{11bf}", "\u{c5cc}", "\u{110b}\u{1165}\u{11bf}"), ("\u{c5cd}",
        "\u{c5cd}", "\u{110b}\u{1165}\u{11c0}", "\u{c5cd}", "\u{110b}\u{1165}\u{11c0}"),
        ("\u{c5ce}", "\u{c5ce}", "\u{110b}\u{1165}\u{11c1}", "\u{c5ce}",
        "\u{110b}\u{1165}\u{11c1}"), ("\u{c5cf}", "\u{c5cf}", "\u{110b}\u{1165}\u{11c2}",
        "\u{c5cf}", "\u{110b}\u{1165}\u{11c2}"), ("\u{c5d0}", "\u{c5d0}", "\u{110b}\u{1166}",
        "\u{c5d0}", "\u{110b}\u{1166}"), ("\u{c5d1}", "\u{c5d1}", "\u{110b}\u{1166}\u{11a8}",
        "\u{c5d1}", "\u{110b}\u{1166}\u{11a8}"), ("\u{c5d2}", "\u{c5d2}",
        "\u{110b}\u{1166}\u{11a9}", "\u{c5d2}", "\u{110b}\u{1166}\u{11a9}"), ("\u{c5d3}",
        "\u{c5d3}", "\u{110b}\u{1166}\u{11aa}", "\u{c5d3}", "\u{110b}\u{1166}\u{11aa}"),
        ("\u{c5d4}", "\u{c5d4}", "\u{110b}\u{1166}\u{11ab}", "\u{c5d4}",
        "\u{110b}\u{1166}\u{11ab}"), ("\u{c5d5}", "\u{c5d5}", "\u{110b}\u{1166}\u{11ac}",
        "\u{c5d5}", "\u{110b}\u{1166}\u{11ac}"), ("\u{c5d6}", "\u{c5d6}",
        "\u{110b}\u{1166}\u{11ad}", "\u{c5d6}", "\u{110b}\u{1166}\u{11ad}"), ("\u{c5d7}",
        "\u{c5d7}", "\u{110b}\u{1166}\u{11ae}", "\u{c5d7}", "\u{110b}\u{1166}\u{11ae}"),
        ("\u{c5d8}", "\u{c5d8}", "\u{110b}\u{1166}\u{11af}", "\u{c5d8}",
        "\u{110b}\u{1166}\u{11af}"), ("\u{c5d9}", "\u{c5d9}", "\u{110b}\u{1166}\u{11b0}",
        "\u{c5d9}", "\u{110b}\u{1166}\u{11b0}"), ("\u{c5da}", "\u{c5da}",
        "\u{110b}\u{1166}\u{11b1}", "\u{c5da}", "\u{110b}\u{1166}\u{11b1}"), ("\u{c5db}",
        "\u{c5db}", "\u{110b}\u{1166}\u{11b2}", "\u{c5db}", "\u{110b}\u{1166}\u{11b2}"),
        ("\u{c5dc}", "\u{c5dc}", "\u{110b}\u{1166}\u{11b3}", "\u{c5dc}",
        "\u{110b}\u{1166}\u{11b3}"), ("\u{c5dd}", "\u{c5dd}", "\u{110b}\u{1166}\u{11b4}",
        "\u{c5dd}", "\u{110b}\u{1166}\u{11b4}"), ("\u{c5de}", "\u{c5de}",
        "\u{110b}\u{1166}\u{11b5}", "\u{c5de}", "\u{110b}\u{1166}\u{11b5}"), ("\u{c5df}",
        "\u{c5df}", "\u{110b}\u{1166}\u{11b6}", "\u{c5df}", "\u{110b}\u{1166}\u{11b6}"),
        ("\u{c5e0}", "\u{c5e0}", "\u{110b}\u{1166}\u{11b7}", "\u{c5e0}",
        "\u{110b}\u{1166}\u{11b7}"), ("\u{c5e1}", "\u{c5e1}", "\u{110b}\u{1166}\u{11b8}",
        "\u{c5e1}", "\u{110b}\u{1166}\u{11b8}"), ("\u{c5e2}", "\u{c5e2}",
        "\u{110b}\u{1166}\u{11b9}", "\u{c5e2}", "\u{110b}\u{1166}\u{11b9}"), ("\u{c5e3}",
        "\u{c5e3}", "\u{110b}\u{1166}\u{11ba}", "\u{c5e3}", "\u{110b}\u{1166}\u{11ba}"),
        ("\u{c5e4}", "\u{c5e4}", "\u{110b}\u{1166}\u{11bb}", "\u{c5e4}",
        "\u{110b}\u{1166}\u{11bb}"), ("\u{c5e5}", "\u{c5e5}", "\u{110b}\u{1166}\u{11bc}",
        "\u{c5e5}", "\u{110b}\u{1166}\u{11bc}"), ("\u{c5e6}", "\u{c5e6}",
        "\u{110b}\u{1166}\u{11bd}", "\u{c5e6}", "\u{110b}\u{1166}\u{11bd}"), ("\u{c5e7}",
        "\u{c5e7}", "\u{110b}\u{1166}\u{11be}", "\u{c5e7}", "\u{110b}\u{1166}\u{11be}"),
        ("\u{c5e8}", "\u{c5e8}", "\u{110b}\u{1166}\u{11bf}", "\u{c5e8}",
        "\u{110b}\u{1166}\u{11bf}"), ("\u{c5e9}", "\u{c5e9}", "\u{110b}\u{1166}\u{11c0}",
        "\u{c5e9}", "\u{110b}\u{1166}\u{11c0}"), ("\u{c5ea}", "\u{c5ea}",
        "\u{110b}\u{1166}\u{11c1}", "\u{c5ea}", "\u{110b}\u{1166}\u{11c1}"), ("\u{c5eb}",
        "\u{c5eb}", "\u{110b}\u{1166}\u{11c2}", "\u{c5eb}", "\u{110b}\u{1166}\u{11c2}"),
        ("\u{c5ec}", "\u{c5ec}", "\u{110b}\u{1167}", "\u{c5ec}", "\u{110b}\u{1167}"), ("\u{c5ed}",
        "\u{c5ed}", "\u{110b}\u{1167}\u{11a8}", "\u{c5ed}", "\u{110b}\u{1167}\u{11a8}"),
        ("\u{c5ee}", "\u{c5ee}", "\u{110b}\u{1167}\u{11a9}", "\u{c5ee}",
        "\u{110b}\u{1167}\u{11a9}"), ("\u{c5ef}", "\u{c5ef}", "\u{110b}\u{1167}\u{11aa}",
        "\u{c5ef}", "\u{110b}\u{1167}\u{11aa}"), ("\u{c5f0}", "\u{c5f0}",
        "\u{110b}\u{1167}\u{11ab}", "\u{c5f0}", "\u{110b}\u{1167}\u{11ab}"), ("\u{c5f1}",
        "\u{c5f1}", "\u{110b}\u{1167}\u{11ac}", "\u{c5f1}", "\u{110b}\u{1167}\u{11ac}"),
        ("\u{c5f2}", "\u{c5f2}", "\u{110b}\u{1167}\u{11ad}", "\u{c5f2}",
        "\u{110b}\u{1167}\u{11ad}"), ("\u{c5f3}", "\u{c5f3}", "\u{110b}\u{1167}\u{11ae}",
        "\u{c5f3}", "\u{110b}\u{1167}\u{11ae}"), ("\u{c5f4}", "\u{c5f4}",
        "\u{110b}\u{1167}\u{11af}", "\u{c5f4}", "\u{110b}\u{1167}\u{11af}"), ("\u{c5f5}",
        "\u{c5f5}", "\u{110b}\u{1167}\u{11b0}", "\u{c5f5}", "\u{110b}\u{1167}\u{11b0}"),
        ("\u{c5f6}", "\u{c5f6}", "\u{110b}\u{1167}\u{11b1}", "\u{c5f6}",
        "\u{110b}\u{1167}\u{11b1}"), ("\u{c5f7}", "\u{c5f7}", "\u{110b}\u{1167}\u{11b2}",
        "\u{c5f7}", "\u{110b}\u{1167}\u{11b2}"), ("\u{c5f8}", "\u{c5f8}",
        "\u{110b}\u{1167}\u{11b3}", "\u{c5f8}", "\u{110b}\u{1167}\u{11b3}"), ("\u{c5f9}",
        "\u{c5f9}", "\u{110b}\u{1167}\u{11b4}", "\u{c5f9}", "\u{110b}\u{1167}\u{11b4}"),
        ("\u{c5fa}", "\u{c5fa}", "\u{110b}\u{1167}\u{11b5}", "\u{c5fa}",
        "\u{110b}\u{1167}\u{11b5}"), ("\u{c5fb}", "\u{c5fb}", "\u{110b}\u{1167}\u{11b6}",
        "\u{c5fb}", "\u{110b}\u{1167}\u{11b6}"), ("\u{c5fc}", "\u{c5fc}",
        "\u{110b}\u{1167}\u{11b7}", "\u{c5fc}", "\u{110b}\u{1167}\u{11b7}"), ("\u{c5fd}",
        "\u{c5fd}", "\u{110b}\u{1167}\u{11b8}", "\u{c5fd}", "\u{110b}\u{1167}\u{11b8}"),
        ("\u{c5fe}", "\u{c5fe}", "\u{110b}\u{1167}\u{11b9}", "\u{c5fe}",
        "\u{110b}\u{1167}\u{11b9}"), ("\u{c5ff}", "\u{c5ff}", "\u{110b}\u{1167}\u{11ba}",
        "\u{c5ff}", "\u{110b}\u{1167}\u{11ba}"), ("\u{c600}", "\u{c600}",
        "\u{110b}\u{1167}\u{11bb}", "\u{c600}", "\u{110b}\u{1167}\u{11bb}"), ("\u{c601}",
        "\u{c601}", "\u{110b}\u{1167}\u{11bc}", "\u{c601}", "\u{110b}\u{1167}\u{11bc}"),
        ("\u{c602}", "\u{c602}", "\u{110b}\u{1167}\u{11bd}", "\u{c602}",
        "\u{110b}\u{1167}\u{11bd}"), ("\u{c603}", "\u{c603}", "\u{110b}\u{1167}\u{11be}",
        "\u{c603}", "\u{110b}\u{1167}\u{11be}"), ("\u{c604}", "\u{c604}",
        "\u{110b}\u{1167}\u{11bf}", "\u{c604}", "\u{110b}\u{1167}\u{11bf}"), ("\u{c605}",
        "\u{c605}", "\u{110b}\u{1167}\u{11c0}", "\u{c605}", "\u{110b}\u{1167}\u{11c0}"),
        ("\u{c606}", "\u{c606}", "\u{110b}\u{1167}\u{11c1}", "\u{c606}",
        "\u{110b}\u{1167}\u{11c1}"), ("\u{c607}", "\u{c607}", "\u{110b}\u{1167}\u{11c2}",
        "\u{c607}", "\u{110b}\u{1167}\u{11c2}"), ("\u{c608}", "\u{c608}", "\u{110b}\u{1168}",
        "\u{c608}", "\u{110b}\u{1168}"), ("\u{c609}", "\u{c609}", "\u{110b}\u{1168}\u{11a8}",
        "\u{c609}", "\u{110b}\u{1168}\u{11a8}"), ("\u{c60a}", "\u{c60a}",
        "\u{110b}\u{1168}\u{11a9}", "\u{c60a}", "\u{110b}\u{1168}\u{11a9}"), ("\u{c60b}",
        "\u{c60b}", "\u{110b}\u{1168}\u{11aa}", "\u{c60b}", "\u{110b}\u{1168}\u{11aa}"),
        ("\u{c60c}", "\u{c60c}", "\u{110b}\u{1168}\u{11ab}", "\u{c60c}",
        "\u{110b}\u{1168}\u{11ab}"), ("\u{c60d}", "\u{c60d}", "\u{110b}\u{1168}\u{11ac}",
        "\u{c60d}", "\u{110b}\u{1168}\u{11ac}"), ("\u{c60e}", "\u{c60e}",
        "\u{110b}\u{1168}\u{11ad}", "\u{c60e}", "\u{110b}\u{1168}\u{11ad}"), ("\u{c60f}",
        "\u{c60f}", "\u{110b}\u{1168}\u{11ae}", "\u{c60f}", "\u{110b}\u{1168}\u{11ae}"),
        ("\u{c610}", "\u{c610}", "\u{110b}\u{1168}\u{11af}", "\u{c610}",
        "\u{110b}\u{1168}\u{11af}"), ("\u{c611}", "\u{c611}", "\u{110b}\u{1168}\u{11b0}",
        "\u{c611}", "\u{110b}\u{1168}\u{11b0}"), ("\u{c612}", "\u{c612}",
        "\u{110b}\u{1168}\u{11b1}", "\u{c612}", "\u{110b}\u{1168}\u{11b1}"), ("\u{c613}",
        "\u{c613}", "\u{110b}\u{1168}\u{11b2}", "\u{c613}", "\u{110b}\u{1168}\u{11b2}"),
        ("\u{c614}", "\u{c614}", "\u{110b}\u{1168}\u{11b3}", "\u{c614}",
        "\u{110b}\u{1168}\u{11b3}"), ("\u{c615}", "\u{c615}", "\u{110b}\u{1168}\u{11b4}",
        "\u{c615}", "\u{110b}\u{1168}\u{11b4}"), ("\u{c616}", "\u{c616}",
        "\u{110b}\u{1168}\u{11b5}", "\u{c616}", "\u{110b}\u{1168}\u{11b5}"), ("\u{c617}",
        "\u{c617}", "\u{110b}\u{1168}\u{11b6}", "\u{c617}", "\u{110b}\u{1168}\u{11b6}"),
        ("\u{c618}", "\u{c618}", "\u{110b}\u{1168}\u{11b7}", "\u{c618}",
        "\u{110b}\u{1168}\u{11b7}"), ("\u{c619}", "\u{c619}", "\u{110b}\u{1168}\u{11b8}",
        "\u{c619}", "\u{110b}\u{1168}\u{11b8}"), ("\u{c61a}", "\u{c61a}",
        "\u{110b}\u{1168}\u{11b9}", "\u{c61a}", "\u{110b}\u{1168}\u{11b9}"), ("\u{c61b}",
        "\u{c61b}", "\u{110b}\u{1168}\u{11ba}", "\u{c61b}", "\u{110b}\u{1168}\u{11ba}"),
        ("\u{c61c}", "\u{c61c}", "\u{110b}\u{1168}\u{11bb}", "\u{c61c}",
        "\u{110b}\u{1168}\u{11bb}"), ("\u{c61d}", "\u{c61d}", "\u{110b}\u{1168}\u{11bc}",
        "\u{c61d}", "\u{110b}\u{1168}\u{11bc}"), ("\u{c61e}", "\u{c61e}",
        "\u{110b}\u{1168}\u{11bd}", "\u{c61e}", "\u{110b}\u{1168}\u{11bd}"), ("\u{c61f}",
        "\u{c61f}", "\u{110b}\u{1168}\u{11be}", "\u{c61f}", "\u{110b}\u{1168}\u{11be}"),
        ("\u{c620}", "\u{c620}", "\u{110b}\u{1168}\u{11bf}", "\u{c620}",
        "\u{110b}\u{1168}\u{11bf}"), ("\u{c621}", "\u{c621}", "\u{110b}\u{1168}\u{11c0}",
        "\u{c621}", "\u{110b}\u{1168}\u{11c0}"), ("\u{c622}", "\u{c622}",
        "\u{110b}\u{1168}\u{11c1}", "\u{c622}", "\u{110b}\u{1168}\u{11c1}"), ("\u{c623}",
        "\u{c623}", "\u{110b}\u{1168}\u{11c2}", "\u{c623}", "\u{110b}\u{1168}\u{11c2}"),
        ("\u{c624}", "\u{c624}", "\u{110b}\u{1169}", "\u{c624}", "\u{110b}\u{1169}"), ("\u{c625}",
        "\u{c625}", "\u{110b}\u{1169}\u{11a8}", "\u{c625}", "\u{110b}\u{1169}\u{11a8}"),
        ("\u{c626}", "\u{c626}", "\u{110b}\u{1169}\u{11a9}", "\u{c626}",
        "\u{110b}\u{1169}\u{11a9}"), ("\u{c627}", "\u{c627}", "\u{110b}\u{1169}\u{11aa}",
        "\u{c627}", "\u{110b}\u{1169}\u{11aa}"), ("\u{c628}", "\u{c628}",
        "\u{110b}\u{1169}\u{11ab}", "\u{c628}", "\u{110b}\u{1169}\u{11ab}"), ("\u{c629}",
        "\u{c629}", "\u{110b}\u{1169}\u{11ac}", "\u{c629}", "\u{110b}\u{1169}\u{11ac}"),
        ("\u{c62a}", "\u{c62a}", "\u{110b}\u{1169}\u{11ad}", "\u{c62a}",
        "\u{110b}\u{1169}\u{11ad}"), ("\u{c62b}", "\u{c62b}", "\u{110b}\u{1169}\u{11ae}",
        "\u{c62b}", "\u{110b}\u{1169}\u{11ae}"), ("\u{c62c}", "\u{c62c}",
        "\u{110b}\u{1169}\u{11af}", "\u{c62c}", "\u{110b}\u{1169}\u{11af}"), ("\u{c62d}",
        "\u{c62d}", "\u{110b}\u{1169}\u{11b0}", "\u{c62d}", "\u{110b}\u{1169}\u{11b0}"),
        ("\u{c62e}", "\u{c62e}", "\u{110b}\u{1169}\u{11b1}", "\u{c62e}",
        "\u{110b}\u{1169}\u{11b1}"), ("\u{c62f}", "\u{c62f}", "\u{110b}\u{1169}\u{11b2}",
        "\u{c62f}", "\u{110b}\u{1169}\u{11b2}"), ("\u{c630}", "\u{c630}",
        "\u{110b}\u{1169}\u{11b3}", "\u{c630}", "\u{110b}\u{1169}\u{11b3}"), ("\u{c631}",
        "\u{c631}", "\u{110b}\u{1169}\u{11b4}", "\u{c631}", "\u{110b}\u{1169}\u{11b4}"),
        ("\u{c632}", "\u{c632}", "\u{110b}\u{1169}\u{11b5}", "\u{c632}",
        "\u{110b}\u{1169}\u{11b5}"), ("\u{c633}", "\u{c633}", "\u{110b}\u{1169}\u{11b6}",
        "\u{c633}", "\u{110b}\u{1169}\u{11b6}"), ("\u{c634}", "\u{c634}",
        "\u{110b}\u{1169}\u{11b7}", "\u{c634}", "\u{110b}\u{1169}\u{11b7}"), ("\u{c635}",
        "\u{c635}", "\u{110b}\u{1169}\u{11b8}", "\u{c635}", "\u{110b}\u{1169}\u{11b8}"),
        ("\u{c636}", "\u{c636}", "\u{110b}\u{1169}\u{11b9}", "\u{c636}",
        "\u{110b}\u{1169}\u{11b9}"), ("\u{c637}", "\u{c637}", "\u{110b}\u{1169}\u{11ba}",
        "\u{c637}", "\u{110b}\u{1169}\u{11ba}"), ("\u{c638}", "\u{c638}",
        "\u{110b}\u{1169}\u{11bb}", "\u{c638}", "\u{110b}\u{1169}\u{11bb}"), ("\u{c639}",
        "\u{c639}", "\u{110b}\u{1169}\u{11bc}", "\u{c639}", "\u{110b}\u{1169}\u{11bc}"),
        ("\u{c63a}", "\u{c63a}", "\u{110b}\u{1169}\u{11bd}", "\u{c63a}",
        "\u{110b}\u{1169}\u{11bd}"), ("\u{c63b}", "\u{c63b}", "\u{110b}\u{1169}\u{11be}",
        "\u{c63b}", "\u{110b}\u{1169}\u{11be}"), ("\u{c63c}", "\u{c63c}",
        "\u{110b}\u{1169}\u{11bf}", "\u{c63c}", "\u{110b}\u{1169}\u{11bf}"), ("\u{c63d}",
        "\u{c63d}", "\u{110b}\u{1169}\u{11c0}", "\u{c63d}", "\u{110b}\u{1169}\u{11c0}"),
        ("\u{c63e}", "\u{c63e}", "\u{110b}\u{1169}\u{11c1}", "\u{c63e}",
        "\u{110b}\u{1169}\u{11c1}"), ("\u{c63f}", "\u{c63f}", "\u{110b}\u{1169}\u{11c2}",
        "\u{c63f}", "\u{110b}\u{1169}\u{11c2}"), ("\u{c640}", "\u{c640}", "\u{110b}\u{116a}",
        "\u{c640}", "\u{110b}\u{116a}"), ("\u{c641}", "\u{c641}", "\u{110b}\u{116a}\u{11a8}",
        "\u{c641}", "\u{110b}\u{116a}\u{11a8}"), ("\u{c642}", "\u{c642}",
        "\u{110b}\u{116a}\u{11a9}", "\u{c642}", "\u{110b}\u{116a}\u{11a9}"), ("\u{c643}",
        "\u{c643}", "\u{110b}\u{116a}\u{11aa}", "\u{c643}", "\u{110b}\u{116a}\u{11aa}"),
        ("\u{c644}", "\u{c644}", "\u{110b}\u{116a}\u{11ab}", "\u{c644}",
        "\u{110b}\u{116a}\u{11ab}"), ("\u{c645}", "\u{c645}", "\u{110b}\u{116a}\u{11ac}",
        "\u{c645}", "\u{110b}\u{116a}\u{11ac}"), ("\u{c646}", "\u{c646}",
        "\u{110b}\u{116a}\u{11ad}", "\u{c646}", "\u{110b}\u{116a}\u{11ad}"), ("\u{c647}",
        "\u{c647}", "\u{110b}\u{116a}\u{11ae}", "\u{c647}", "\u{110b}\u{116a}\u{11ae}"),
        ("\u{c648}", "\u{c648}", "\u{110b}\u{116a}\u{11af}", "\u{c648}",
        "\u{110b}\u{116a}\u{11af}"), ("\u{c649}", "\u{c649}", "\u{110b}\u{116a}\u{11b0}",
        "\u{c649}", "\u{110b}\u{116a}\u{11b0}"), ("\u{c64a}", "\u{c64a}",
        "\u{110b}\u{116a}\u{11b1}", "\u{c64a}", "\u{110b}\u{116a}\u{11b1}"), ("\u{c64b}",
        "\u{c64b}", "\u{110b}\u{116a}\u{11b2}", "\u{c64b}", "\u{110b}\u{116a}\u{11b2}"),
        ("\u{c64c}", "\u{c64c}", "\u{110b}\u{116a}\u{11b3}", "\u{c64c}",
        "\u{110b}\u{116a}\u{11b3}"), ("\u{c64d}", "\u{c64d}", "\u{110b}\u{116a}\u{11b4}",
        "\u{c64d}", "\u{110b}\u{116a}\u{11b4}"), ("\u{c64e}", "\u{c64e}",
        "\u{110b}\u{116a}\u{11b5}", "\u{c64e}", "\u{110b}\u{116a}\u{11b5}"), ("\u{c64f}",
        "\u{c64f}", "\u{110b}\u{116a}\u{11b6}", "\u{c64f}", "\u{110b}\u{116a}\u{11b6}"),
        ("\u{c650}", "\u{c650}", "\u{110b}\u{116a}\u{11b7}", "\u{c650}",
        "\u{110b}\u{116a}\u{11b7}"), ("\u{c651}", "\u{c651}", "\u{110b}\u{116a}\u{11b8}",
        "\u{c651}", "\u{110b}\u{116a}\u{11b8}"), ("\u{c652}", "\u{c652}",
        "\u{110b}\u{116a}\u{11b9}", "\u{c652}", "\u{110b}\u{116a}\u{11b9}"), ("\u{c653}",
        "\u{c653}", "\u{110b}\u{116a}\u{11ba}", "\u{c653}", "\u{110b}\u{116a}\u{11ba}"),
        ("\u{c654}", "\u{c654}", "\u{110b}\u{116a}\u{11bb}", "\u{c654}",
        "\u{110b}\u{116a}\u{11bb}"), ("\u{c655}", "\u{c655}", "\u{110b}\u{116a}\u{11bc}",
        "\u{c655}", "\u{110b}\u{116a}\u{11bc}"), ("\u{c656}", "\u{c656}",
        "\u{110b}\u{116a}\u{11bd}", "\u{c656}", "\u{110b}\u{116a}\u{11bd}"), ("\u{c657}",
        "\u{c657}", "\u{110b}\u{116a}\u{11be}", "\u{c657}", "\u{110b}\u{116a}\u{11be}"),
        ("\u{c658}", "\u{c658}", "\u{110b}\u{116a}\u{11bf}", "\u{c658}",
        "\u{110b}\u{116a}\u{11bf}"), ("\u{c659}", "\u{c659}", "\u{110b}\u{116a}\u{11c0}",
        "\u{c659}", "\u{110b}\u{116a}\u{11c0}"), ("\u{c65a}", "\u{c65a}",
        "\u{110b}\u{116a}\u{11c1}", "\u{c65a}", "\u{110b}\u{116a}\u{11c1}"), ("\u{c65b}",
        "\u{c65b}", "\u{110b}\u{116a}\u{11c2}", "\u{c65b}", "\u{110b}\u{116a}\u{11c2}"),
        ("\u{c65c}", "\u{c65c}", "\u{110b}\u{116b}", "\u{c65c}", "\u{110b}\u{116b}"), ("\u{c65d}",
        "\u{c65d}", "\u{110b}\u{116b}\u{11a8}", "\u{c65d}", "\u{110b}\u{116b}\u{11a8}"),
        ("\u{c65e}", "\u{c65e}", "\u{110b}\u{116b}\u{11a9}", "\u{c65e}",
        "\u{110b}\u{116b}\u{11a9}"), ("\u{c65f}", "\u{c65f}", "\u{110b}\u{116b}\u{11aa}",
        "\u{c65f}", "\u{110b}\u{116b}\u{11aa}"), ("\u{c660}", "\u{c660}",
        "\u{110b}\u{116b}\u{11ab}", "\u{c660}", "\u{110b}\u{116b}\u{11ab}"), ("\u{c661}",
        "\u{c661}", "\u{110b}\u{116b}\u{11ac}", "\u{c661}", "\u{110b}\u{116b}\u{11ac}"),
        ("\u{c662}", "\u{c662}", "\u{110b}\u{116b}\u{11ad}", "\u{c662}",
        "\u{110b}\u{116b}\u{11ad}"), ("\u{c663}", "\u{c663}", "\u{110b}\u{116b}\u{11ae}",
        "\u{c663}", "\u{110b}\u{116b}\u{11ae}"), ("\u{c664}", "\u{c664}",
        "\u{110b}\u{116b}\u{11af}", "\u{c664}", "\u{110b}\u{116b}\u{11af}"), ("\u{c665}",
        "\u{c665}", "\u{110b}\u{116b}\u{11b0}", "\u{c665}", "\u{110b}\u{116b}\u{11b0}"),
        ("\u{c666}", "\u{c666}", "\u{110b}\u{116b}\u{11b1}", "\u{c666}",
        "\u{110b}\u{116b}\u{11b1}"), ("\u{c667}", "\u{c667}", "\u{110b}\u{116b}\u{11b2}",
        "\u{c667}", "\u{110b}\u{116b}\u{11b2}"), ("\u{c668}", "\u{c668}",
        "\u{110b}\u{116b}\u{11b3}", "\u{c668}", "\u{110b}\u{116b}\u{11b3}"), ("\u{c669}",
        "\u{c669}", "\u{110b}\u{116b}\u{11b4}", "\u{c669}", "\u{110b}\u{116b}\u{11b4}"),
        ("\u{c66a}", "\u{c66a}", "\u{110b}\u{116b}\u{11b5}", "\u{c66a}",
        "\u{110b}\u{116b}\u{11b5}"), ("\u{c66b}", "\u{c66b}", "\u{110b}\u{116b}\u{11b6}",
        "\u{c66b}", "\u{110b}\u{116b}\u{11b6}"), ("\u{c66c}", "\u{c66c}",
        "\u{110b}\u{116b}\u{11b7}", "\u{c66c}", "\u{110b}\u{116b}\u{11b7}"), ("\u{c66d}",
        "\u{c66d}", "\u{110b}\u{116b}\u{11b8}", "\u{c66d}", "\u{110b}\u{116b}\u{11b8}"),
        ("\u{c66e}", "\u{c66e}", "\u{110b}\u{116b}\u{11b9}", "\u{c66e}",
        "\u{110b}\u{116b}\u{11b9}"), ("\u{c66f}", "\u{c66f}", "\u{110b}\u{116b}\u{11ba}",
        "\u{c66f}", "\u{110b}\u{116b}\u{11ba}"), ("\u{c670}", "\u{c670}",
        "\u{110b}\u{116b}\u{11bb}", "\u{c670}", "\u{110b}\u{116b}\u{11bb}"), ("\u{c671}",
        "\u{c671}", "\u{110b}\u{116b}\u{11bc}", "\u{c671}", "\u{110b}\u{116b}\u{11bc}"),
        ("\u{c672}", "\u{c672}", "\u{110b}\u{116b}\u{11bd}", "\u{c672}",
        "\u{110b}\u{116b}\u{11bd}"), ("\u{c673}", "\u{c673}", "\u{110b}\u{116b}\u{11be}",
        "\u{c673}", "\u{110b}\u{116b}\u{11be}"), ("\u{c674}", "\u{c674}",
        "\u{110b}\u{116b}\u{11bf}", "\u{c674}", "\u{110b}\u{116b}\u{11bf}"), ("\u{c675}",
        "\u{c675}", "\u{110b}\u{116b}\u{11c0}", "\u{c675}", "\u{110b}\u{116b}\u{11c0}"),
        ("\u{c676}", "\u{c676}", "\u{110b}\u{116b}\u{11c1}", "\u{c676}",
        "\u{110b}\u{116b}\u{11c1}"), ("\u{c677}", "\u{c677}", "\u{110b}\u{116b}\u{11c2}",
        "\u{c677}", "\u{110b}\u{116b}\u{11c2}"), ("\u{c678}", "\u{c678}", "\u{110b}\u{116c}",
        "\u{c678}", "\u{110b}\u{116c}"), ("\u{c679}", "\u{c679}", "\u{110b}\u{116c}\u{11a8}",
        "\u{c679}", "\u{110b}\u{116c}\u{11a8}"), ("\u{c67a}", "\u{c67a}",
        "\u{110b}\u{116c}\u{11a9}", "\u{c67a}", "\u{110b}\u{116c}\u{11a9}"), ("\u{c67b}",
        "\u{c67b}", "\u{110b}\u{116c}\u{11aa}", "\u{c67b}", "\u{110b}\u{116c}\u{11aa}"),
        ("\u{c67c}", "\u{c67c}", "\u{110b}\u{116c}\u{11ab}", "\u{c67c}",
        "\u{110b}\u{116c}\u{11ab}"), ("\u{c67d}", "\u{c67d}", "\u{110b}\u{116c}\u{11ac}",
        "\u{c67d}", "\u{110b}\u{116c}\u{11ac}"), ("\u{c67e}", "\u{c67e}",
        "\u{110b}\u{116c}\u{11ad}", "\u{c67e}", "\u{110b}\u{116c}\u{11ad}"), ("\u{c67f}",
        "\u{c67f}", "\u{110b}\u{116c}\u{11ae}", "\u{c67f}", "\u{110b}\u{116c}\u{11ae}"),
        ("\u{c680}", "\u{c680}", "\u{110b}\u{116c}\u{11af}", "\u{c680}",
        "\u{110b}\u{116c}\u{11af}"), ("\u{c681}", "\u{c681}", "\u{110b}\u{116c}\u{11b0}",
        "\u{c681}", "\u{110b}\u{116c}\u{11b0}"), ("\u{c682}", "\u{c682}",
        "\u{110b}\u{116c}\u{11b1}", "\u{c682}", "\u{110b}\u{116c}\u{11b1}"), ("\u{c683}",
        "\u{c683}", "\u{110b}\u{116c}\u{11b2}", "\u{c683}", "\u{110b}\u{116c}\u{11b2}"),
        ("\u{c684}", "\u{c684}", "\u{110b}\u{116c}\u{11b3}", "\u{c684}",
        "\u{110b}\u{116c}\u{11b3}"), ("\u{c685}", "\u{c685}", "\u{110b}\u{116c}\u{11b4}",
        "\u{c685}", "\u{110b}\u{116c}\u{11b4}"), ("\u{c686}", "\u{c686}",
        "\u{110b}\u{116c}\u{11b5}", "\u{c686}", "\u{110b}\u{116c}\u{11b5}"), ("\u{c687}",
        "\u{c687}", "\u{110b}\u{116c}\u{11b6}", "\u{c687}", "\u{110b}\u{116c}\u{11b6}"),
        ("\u{c688}", "\u{c688}", "\u{110b}\u{116c}\u{11b7}", "\u{c688}",
        "\u{110b}\u{116c}\u{11b7}"), ("\u{c689}", "\u{c689}", "\u{110b}\u{116c}\u{11b8}",
        "\u{c689}", "\u{110b}\u{116c}\u{11b8}"), ("\u{c68a}", "\u{c68a}",
        "\u{110b}\u{116c}\u{11b9}", "\u{c68a}", "\u{110b}\u{116c}\u{11b9}"), ("\u{c68b}",
        "\u{c68b}", "\u{110b}\u{116c}\u{11ba}", "\u{c68b}", "\u{110b}\u{116c}\u{11ba}"),
        ("\u{c68c}", "\u{c68c}", "\u{110b}\u{116c}\u{11bb}", "\u{c68c}",
        "\u{110b}\u{116c}\u{11bb}"), ("\u{c68d}", "\u{c68d}", "\u{110b}\u{116c}\u{11bc}",
        "\u{c68d}", "\u{110b}\u{116c}\u{11bc}"), ("\u{c68e}", "\u{c68e}",
        "\u{110b}\u{116c}\u{11bd}", "\u{c68e}", "\u{110b}\u{116c}\u{11bd}"), ("\u{c68f}",
        "\u{c68f}", "\u{110b}\u{116c}\u{11be}", "\u{c68f}", "\u{110b}\u{116c}\u{11be}"),
        ("\u{c690}", "\u{c690}", "\u{110b}\u{116c}\u{11bf}", "\u{c690}",
        "\u{110b}\u{116c}\u{11bf}"), ("\u{c691}", "\u{c691}", "\u{110b}\u{116c}\u{11c0}",
        "\u{c691}", "\u{110b}\u{116c}\u{11c0}"), ("\u{c692}", "\u{c692}",
        "\u{110b}\u{116c}\u{11c1}", "\u{c692}", "\u{110b}\u{116c}\u{11c1}"), ("\u{c693}",
        "\u{c693}", "\u{110b}\u{116c}\u{11c2}", "\u{c693}", "\u{110b}\u{116c}\u{11c2}"),
        ("\u{c694}", "\u{c694}", "\u{110b}\u{116d}", "\u{c694}", "\u{110b}\u{116d}"), ("\u{c695}",
        "\u{c695}", "\u{110b}\u{116d}\u{11a8}", "\u{c695}", "\u{110b}\u{116d}\u{11a8}"),
        ("\u{c696}", "\u{c696}", "\u{110b}\u{116d}\u{11a9}", "\u{c696}",
        "\u{110b}\u{116d}\u{11a9}"), ("\u{c697}", "\u{c697}", "\u{110b}\u{116d}\u{11aa}",
        "\u{c697}", "\u{110b}\u{116d}\u{11aa}"), ("\u{c698}", "\u{c698}",
        "\u{110b}\u{116d}\u{11ab}", "\u{c698}", "\u{110b}\u{116d}\u{11ab}"), ("\u{c699}",
        "\u{c699}", "\u{110b}\u{116d}\u{11ac}", "\u{c699}", "\u{110b}\u{116d}\u{11ac}"),
        ("\u{c69a}", "\u{c69a}", "\u{110b}\u{116d}\u{11ad}", "\u{c69a}",
        "\u{110b}\u{116d}\u{11ad}"), ("\u{c69b}", "\u{c69b}", "\u{110b}\u{116d}\u{11ae}",
        "\u{c69b}", "\u{110b}\u{116d}\u{11ae}"), ("\u{c69c}", "\u{c69c}",
        "\u{110b}\u{116d}\u{11af}", "\u{c69c}", "\u{110b}\u{116d}\u{11af}"), ("\u{c69d}",
        "\u{c69d}", "\u{110b}\u{116d}\u{11b0}", "\u{c69d}", "\u{110b}\u{116d}\u{11b0}"),
        ("\u{c69e}", "\u{c69e}", "\u{110b}\u{116d}\u{11b1}", "\u{c69e}",
        "\u{110b}\u{116d}\u{11b1}"), ("\u{c69f}", "\u{c69f}", "\u{110b}\u{116d}\u{11b2}",
        "\u{c69f}", "\u{110b}\u{116d}\u{11b2}"), ("\u{c6a0}", "\u{c6a0}",
        "\u{110b}\u{116d}\u{11b3}", "\u{c6a0}", "\u{110b}\u{116d}\u{11b3}"), ("\u{c6a1}",
        "\u{c6a1}", "\u{110b}\u{116d}\u{11b4}", "\u{c6a1}", "\u{110b}\u{116d}\u{11b4}"),
        ("\u{c6a2}", "\u{c6a2}", "\u{110b}\u{116d}\u{11b5}", "\u{c6a2}",
        "\u{110b}\u{116d}\u{11b5}"), ("\u{c6a3}", "\u{c6a3}", "\u{110b}\u{116d}\u{11b6}",
        "\u{c6a3}", "\u{110b}\u{116d}\u{11b6}"), ("\u{c6a4}", "\u{c6a4}",
        "\u{110b}\u{116d}\u{11b7}", "\u{c6a4}", "\u{110b}\u{116d}\u{11b7}"), ("\u{c6a5}",
        "\u{c6a5}", "\u{110b}\u{116d}\u{11b8}", "\u{c6a5}", "\u{110b}\u{116d}\u{11b8}"),
        ("\u{c6a6}", "\u{c6a6}", "\u{110b}\u{116d}\u{11b9}", "\u{c6a6}",
        "\u{110b}\u{116d}\u{11b9}"), ("\u{c6a7}", "\u{c6a7}", "\u{110b}\u{116d}\u{11ba}",
        "\u{c6a7}", "\u{110b}\u{116d}\u{11ba}"), ("\u{c6a8}", "\u{c6a8}",
        "\u{110b}\u{116d}\u{11bb}", "\u{c6a8}", "\u{110b}\u{116d}\u{11bb}"), ("\u{c6a9}",
        "\u{c6a9}", "\u{110b}\u{116d}\u{11bc}", "\u{c6a9}", "\u{110b}\u{116d}\u{11bc}"),
        ("\u{c6aa}", "\u{c6aa}", "\u{110b}\u{116d}\u{11bd}", "\u{c6aa}",
        "\u{110b}\u{116d}\u{11bd}"), ("\u{c6ab}", "\u{c6ab}", "\u{110b}\u{116d}\u{11be}",
        "\u{c6ab}", "\u{110b}\u{116d}\u{11be}"), ("\u{c6ac}", "\u{c6ac}",
        "\u{110b}\u{116d}\u{11bf}", "\u{c6ac}", "\u{110b}\u{116d}\u{11bf}"), ("\u{c6ad}",
        "\u{c6ad}", "\u{110b}\u{116d}\u{11c0}", "\u{c6ad}", "\u{110b}\u{116d}\u{11c0}"),
        ("\u{c6ae}", "\u{c6ae}", "\u{110b}\u{116d}\u{11c1}", "\u{c6ae}",
        "\u{110b}\u{116d}\u{11c1}"), ("\u{c6af}", "\u{c6af}", "\u{110b}\u{116d}\u{11c2}",
        "\u{c6af}", "\u{110b}\u{116d}\u{11c2}"), ("\u{c6b0}", "\u{c6b0}", "\u{110b}\u{116e}",
        "\u{c6b0}", "\u{110b}\u{116e}"), ("\u{c6b1}", "\u{c6b1}", "\u{110b}\u{116e}\u{11a8}",
        "\u{c6b1}", "\u{110b}\u{116e}\u{11a8}"), ("\u{c6b2}", "\u{c6b2}",
        "\u{110b}\u{116e}\u{11a9}", "\u{c6b2}", "\u{110b}\u{116e}\u{11a9}"), ("\u{c6b3}",
        "\u{c6b3}", "\u{110b}\u{116e}\u{11aa}", "\u{c6b3}", "\u{110b}\u{116e}\u{11aa}"),
        ("\u{c6b4}", "\u{c6b4}", "\u{110b}\u{116e}\u{11ab}", "\u{c6b4}",
        "\u{110b}\u{116e}\u{11ab}"), ("\u{c6b5}", "\u{c6b5}", "\u{110b}\u{116e}\u{11ac}",
        "\u{c6b5}", "\u{110b}\u{116e}\u{11ac}"), ("\u{c6b6}", "\u{c6b6}",
        "\u{110b}\u{116e}\u{11ad}", "\u{c6b6}", "\u{110b}\u{116e}\u{11ad}"), ("\u{c6b7}",
        "\u{c6b7}", "\u{110b}\u{116e}\u{11ae}", "\u{c6b7}", "\u{110b}\u{116e}\u{11ae}"),
        ("\u{c6b8}", "\u{c6b8}", "\u{110b}\u{116e}\u{11af}", "\u{c6b8}",
        "\u{110b}\u{116e}\u{11af}"), ("\u{c6b9}", "\u{c6b9}", "\u{110b}\u{116e}\u{11b0}",
        "\u{c6b9}", "\u{110b}\u{116e}\u{11b0}"), ("\u{c6ba}", "\u{c6ba}",
        "\u{110b}\u{116e}\u{11b1}", "\u{c6ba}", "\u{110b}\u{116e}\u{11b1}"), ("\u{c6bb}",
        "\u{c6bb}", "\u{110b}\u{116e}\u{11b2}", "\u{c6bb}", "\u{110b}\u{116e}\u{11b2}"),
        ("\u{c6bc}", "\u{c6bc}", "\u{110b}\u{116e}\u{11b3}", "\u{c6bc}",
        "\u{110b}\u{116e}\u{11b3}"), ("\u{c6bd}", "\u{c6bd}", "\u{110b}\u{116e}\u{11b4}",
        "\u{c6bd}", "\u{110b}\u{116e}\u{11b4}"), ("\u{c6be}", "\u{c6be}",
        "\u{110b}\u{116e}\u{11b5}", "\u{c6be}", "\u{110b}\u{116e}\u{11b5}"), ("\u{c6bf}",
        "\u{c6bf}", "\u{110b}\u{116e}\u{11b6}", "\u{c6bf}", "\u{110b}\u{116e}\u{11b6}"),
        ("\u{c6c0}", "\u{c6c0}", "\u{110b}\u{116e}\u{11b7}", "\u{c6c0}",
        "\u{110b}\u{116e}\u{11b7}"), ("\u{c6c1}", "\u{c6c1}", "\u{110b}\u{116e}\u{11b8}",
        "\u{c6c1}", "\u{110b}\u{116e}\u{11b8}"), ("\u{c6c2}", "\u{c6c2}",
        "\u{110b}\u{116e}\u{11b9}", "\u{c6c2}", "\u{110b}\u{116e}\u{11b9}"), ("\u{c6c3}",
        "\u{c6c3}", "\u{110b}\u{116e}\u{11ba}", "\u{c6c3}", "\u{110b}\u{116e}\u{11ba}"),
        ("\u{c6c4}", "\u{c6c4}", "\u{110b}\u{116e}\u{11bb}", "\u{c6c4}",
        "\u{110b}\u{116e}\u{11bb}"), ("\u{c6c5}", "\u{c6c5}", "\u{110b}\u{116e}\u{11bc}",
        "\u{c6c5}", "\u{110b}\u{116e}\u{11bc}"), ("\u{c6c6}", "\u{c6c6}",
        "\u{110b}\u{116e}\u{11bd}", "\u{c6c6}", "\u{110b}\u{116e}\u{11bd}"), ("\u{c6c7}",
        "\u{c6c7}", "\u{110b}\u{116e}\u{11be}", "\u{c6c7}", "\u{110b}\u{116e}\u{11be}"),
        ("\u{c6c8}", "\u{c6c8}", "\u{110b}\u{116e}\u{11bf}", "\u{c6c8}",
        "\u{110b}\u{116e}\u{11bf}"), ("\u{c6c9}", "\u{c6c9}", "\u{110b}\u{116e}\u{11c0}",
        "\u{c6c9}", "\u{110b}\u{116e}\u{11c0}"), ("\u{c6ca}", "\u{c6ca}",
        "\u{110b}\u{116e}\u{11c1}", "\u{c6ca}", "\u{110b}\u{116e}\u{11c1}"), ("\u{c6cb}",
        "\u{c6cb}", "\u{110b}\u{116e}\u{11c2}", "\u{c6cb}", "\u{110b}\u{116e}\u{11c2}"),
        ("\u{c6cc}", "\u{c6cc}", "\u{110b}\u{116f}", "\u{c6cc}", "\u{110b}\u{116f}"), ("\u{c6cd}",
        "\u{c6cd}", "\u{110b}\u{116f}\u{11a8}", "\u{c6cd}", "\u{110b}\u{116f}\u{11a8}"),
        ("\u{c6ce}", "\u{c6ce}", "\u{110b}\u{116f}\u{11a9}", "\u{c6ce}",
        "\u{110b}\u{116f}\u{11a9}"), ("\u{c6cf}", "\u{c6cf}", "\u{110b}\u{116f}\u{11aa}",
        "\u{c6cf}", "\u{110b}\u{116f}\u{11aa}"), ("\u{c6d0}", "\u{c6d0}",
        "\u{110b}\u{116f}\u{11ab}", "\u{c6d0}", "\u{110b}\u{116f}\u{11ab}"), ("\u{c6d1}",
        "\u{c6d1}", "\u{110b}\u{116f}\u{11ac}", "\u{c6d1}", "\u{110b}\u{116f}\u{11ac}"),
        ("\u{c6d2}", "\u{c6d2}", "\u{110b}\u{116f}\u{11ad}", "\u{c6d2}",
        "\u{110b}\u{116f}\u{11ad}"), ("\u{c6d3}", "\u{c6d3}", "\u{110b}\u{116f}\u{11ae}",
        "\u{c6d3}", "\u{110b}\u{116f}\u{11ae}"), ("\u{c6d4}", "\u{c6d4}",
        "\u{110b}\u{116f}\u{11af}", "\u{c6d4}", "\u{110b}\u{116f}\u{11af}"), ("\u{c6d5}",
        "\u{c6d5}", "\u{110b}\u{116f}\u{11b0}", "\u{c6d5}", "\u{110b}\u{116f}\u{11b0}"),
        ("\u{c6d6}", "\u{c6d6}", "\u{110b}\u{116f}\u{11b1}", "\u{c6d6}",
        "\u{110b}\u{116f}\u{11b1}"), ("\u{c6d7}", "\u{c6d7}", "\u{110b}\u{116f}\u{11b2}",
        "\u{c6d7}", "\u{110b}\u{116f}\u{11b2}"), ("\u{c6d8}", "\u{c6d8}",
        "\u{110b}\u{116f}\u{11b3}", "\u{c6d8}", "\u{110b}\u{116f}\u{11b3}"), ("\u{c6d9}",
        "\u{c6d9}", "\u{110b}\u{116f}\u{11b4}", "\u{c6d9}", "\u{110b}\u{116f}\u{11b4}"),
        ("\u{c6da}", "\u{c6da}", "\u{110b}\u{116f}\u{11b5}", "\u{c6da}",
        "\u{110b}\u{116f}\u{11b5}"), ("\u{c6db}", "\u{c6db}", "\u{110b}\u{116f}\u{11b6}",
        "\u{c6db}", "\u{110b}\u{116f}\u{11b6}"), ("\u{c6dc}", "\u{c6dc}",
        "\u{110b}\u{116f}\u{11b7}", "\u{c6dc}", "\u{110b}\u{116f}\u{11b7}"), ("\u{c6dd}",
        "\u{c6dd}", "\u{110b}\u{116f}\u{11b8}", "\u{c6dd}", "\u{110b}\u{116f}\u{11b8}"),
        ("\u{c6de}", "\u{c6de}", "\u{110b}\u{116f}\u{11b9}", "\u{c6de}",
        "\u{110b}\u{116f}\u{11b9}"), ("\u{c6df}", "\u{c6df}", "\u{110b}\u{116f}\u{11ba}",
        "\u{c6df}", "\u{110b}\u{116f}\u{11ba}"), ("\u{c6e0}", "\u{c6e0}",
        "\u{110b}\u{116f}\u{11bb}", "\u{c6e0}", "\u{110b}\u{116f}\u{11bb}"), ("\u{c6e1}",
        "\u{c6e1}", "\u{110b}\u{116f}\u{11bc}", "\u{c6e1}", "\u{110b}\u{116f}\u{11bc}"),
        ("\u{c6e2}", "\u{c6e2}", "\u{110b}\u{116f}\u{11bd}", "\u{c6e2}",
        "\u{110b}\u{116f}\u{11bd}"), ("\u{c6e3}", "\u{c6e3}", "\u{110b}\u{116f}\u{11be}",
        "\u{c6e3}", "\u{110b}\u{116f}\u{11be}"), ("\u{c6e4}", "\u{c6e4}",
        "\u{110b}\u{116f}\u{11bf}", "\u{c6e4}", "\u{110b}\u{116f}\u{11bf}"), ("\u{c6e5}",
        "\u{c6e5}", "\u{110b}\u{116f}\u{11c0}", "\u{c6e5}", "\u{110b}\u{116f}\u{11c0}"),
        ("\u{c6e6}", "\u{c6e6}", "\u{110b}\u{116f}\u{11c1}", "\u{c6e6}",
        "\u{110b}\u{116f}\u{11c1}"), ("\u{c6e7}", "\u{c6e7}", "\u{110b}\u{116f}\u{11c2}",
        "\u{c6e7}", "\u{110b}\u{116f}\u{11c2}"), ("\u{c6e8}", "\u{c6e8}", "\u{110b}\u{1170}",
        "\u{c6e8}", "\u{110b}\u{1170}"), ("\u{c6e9}", "\u{c6e9}", "\u{110b}\u{1170}\u{11a8}",
        "\u{c6e9}", "\u{110b}\u{1170}\u{11a8}"), ("\u{c6ea}", "\u{c6ea}",
        "\u{110b}\u{1170}\u{11a9}", "\u{c6ea}", "\u{110b}\u{1170}\u{11a9}"), ("\u{c6eb}",
        "\u{c6eb}", "\u{110b}\u{1170}\u{11aa}", "\u{c6eb}", "\u{110b}\u{1170}\u{11aa}"),
        ("\u{c6ec}", "\u{c6ec}", "\u{110b}\u{1170}\u{11ab}", "\u{c6ec}",
        "\u{110b}\u{1170}\u{11ab}"), ("\u{c6ed}", "\u{c6ed}", "\u{110b}\u{1170}\u{11ac}",
        "\u{c6ed}", "\u{110b}\u{1170}\u{11ac}"), ("\u{c6ee}", "\u{c6ee}",
        "\u{110b}\u{1170}\u{11ad}", "\u{c6ee}", "\u{110b}\u{1170}\u{11ad}"), ("\u{c6ef}",
        "\u{c6ef}", "\u{110b}\u{1170}\u{11ae}", "\u{c6ef}", "\u{110b}\u{1170}\u{11ae}"),
        ("\u{c6f0}", "\u{c6f0}", "\u{110b}\u{1170}\u{11af}", "\u{c6f0}",
        "\u{110b}\u{1170}\u{11af}"), ("\u{c6f1}", "\u{c6f1}", "\u{110b}\u{1170}\u{11b0}",
        "\u{c6f1}", "\u{110b}\u{1170}\u{11b0}"), ("\u{c6f2}", "\u{c6f2}",
        "\u{110b}\u{1170}\u{11b1}", "\u{c6f2}", "\u{110b}\u{1170}\u{11b1}"), ("\u{c6f3}",
        "\u{c6f3}", "\u{110b}\u{1170}\u{11b2}", "\u{c6f3}", "\u{110b}\u{1170}\u{11b2}"),
        ("\u{c6f4}", "\u{c6f4}", "\u{110b}\u{1170}\u{11b3}", "\u{c6f4}",
        "\u{110b}\u{1170}\u{11b3}"), ("\u{c6f5}", "\u{c6f5}", "\u{110b}\u{1170}\u{11b4}",
        "\u{c6f5}", "\u{110b}\u{1170}\u{11b4}"), ("\u{c6f6}", "\u{c6f6}",
        "\u{110b}\u{1170}\u{11b5}", "\u{c6f6}", "\u{110b}\u{1170}\u{11b5}"), ("\u{c6f7}",
        "\u{c6f7}", "\u{110b}\u{1170}\u{11b6}", "\u{c6f7}", "\u{110b}\u{1170}\u{11b6}"),
        ("\u{c6f8}", "\u{c6f8}", "\u{110b}\u{1170}\u{11b7}", "\u{c6f8}",
        "\u{110b}\u{1170}\u{11b7}"), ("\u{c6f9}", "\u{c6f9}", "\u{110b}\u{1170}\u{11b8}",
        "\u{c6f9}", "\u{110b}\u{1170}\u{11b8}"), ("\u{c6fa}", "\u{c6fa}",
        "\u{110b}\u{1170}\u{11b9}", "\u{c6fa}", "\u{110b}\u{1170}\u{11b9}"), ("\u{c6fb}",
        "\u{c6fb}", "\u{110b}\u{1170}\u{11ba}", "\u{c6fb}", "\u{110b}\u{1170}\u{11ba}"),
        ("\u{c6fc}", "\u{c6fc}", "\u{110b}\u{1170}\u{11bb}", "\u{c6fc}",
        "\u{110b}\u{1170}\u{11bb}"), ("\u{c6fd}", "\u{c6fd}", "\u{110b}\u{1170}\u{11bc}",
        "\u{c6fd}", "\u{110b}\u{1170}\u{11bc}"), ("\u{c6fe}", "\u{c6fe}",
        "\u{110b}\u{1170}\u{11bd}", "\u{c6fe}", "\u{110b}\u{1170}\u{11bd}"), ("\u{c6ff}",
        "\u{c6ff}", "\u{110b}\u{1170}\u{11be}", "\u{c6ff}", "\u{110b}\u{1170}\u{11be}"),
        ("\u{c700}", "\u{c700}", "\u{110b}\u{1170}\u{11bf}", "\u{c700}",
        "\u{110b}\u{1170}\u{11bf}"), ("\u{c701}", "\u{c701}", "\u{110b}\u{1170}\u{11c0}",
        "\u{c701}", "\u{110b}\u{1170}\u{11c0}"), ("\u{c702}", "\u{c702}",
        "\u{110b}\u{1170}\u{11c1}", "\u{c702}", "\u{110b}\u{1170}\u{11c1}"), ("\u{c703}",
        "\u{c703}", "\u{110b}\u{1170}\u{11c2}", "\u{c703}", "\u{110b}\u{1170}\u{11c2}"),
        ("\u{c704}", "\u{c704}", "\u{110b}\u{1171}", "\u{c704}", "\u{110b}\u{1171}"), ("\u{c705}",
        "\u{c705}", "\u{110b}\u{1171}\u{11a8}", "\u{c705}", "\u{110b}\u{1171}\u{11a8}"),
        ("\u{c706}", "\u{c706}", "\u{110b}\u{1171}\u{11a9}", "\u{c706}",
        "\u{110b}\u{1171}\u{11a9}"), ("\u{c707}", "\u{c707}", "\u{110b}\u{1171}\u{11aa}",
        "\u{c707}", "\u{110b}\u{1171}\u{11aa}"), ("\u{c708}", "\u{c708}",
        "\u{110b}\u{1171}\u{11ab}", "\u{c708}", "\u{110b}\u{1171}\u{11ab}"), ("\u{c709}",
        "\u{c709}", "\u{110b}\u{1171}\u{11ac}", "\u{c709}", "\u{110b}\u{1171}\u{11ac}"),
        ("\u{c70a}", "\u{c70a}", "\u{110b}\u{1171}\u{11ad}", "\u{c70a}",
        "\u{110b}\u{1171}\u{11ad}"), ("\u{c70b}", "\u{c70b}", "\u{110b}\u{1171}\u{11ae}",
        "\u{c70b}", "\u{110b}\u{1171}\u{11ae}"), ("\u{c70c}", "\u{c70c}",
        "\u{110b}\u{1171}\u{11af}", "\u{c70c}", "\u{110b}\u{1171}\u{11af}"), ("\u{c70d}",
        "\u{c70d}", "\u{110b}\u{1171}\u{11b0}", "\u{c70d}", "\u{110b}\u{1171}\u{11b0}"),
        ("\u{c70e}", "\u{c70e}", "\u{110b}\u{1171}\u{11b1}", "\u{c70e}",
        "\u{110b}\u{1171}\u{11b1}"), ("\u{c70f}", "\u{c70f}", "\u{110b}\u{1171}\u{11b2}",
        "\u{c70f}", "\u{110b}\u{1171}\u{11b2}"), ("\u{c710}", "\u{c710}",
        "\u{110b}\u{1171}\u{11b3}", "\u{c710}", "\u{110b}\u{1171}\u{11b3}"), ("\u{c711}",
        "\u{c711}", "\u{110b}\u{1171}\u{11b4}", "\u{c711}", "\u{110b}\u{1171}\u{11b4}"),
        ("\u{c712}", "\u{c712}", "\u{110b}\u{1171}\u{11b5}", "\u{c712}",
        "\u{110b}\u{1171}\u{11b5}"), ("\u{c713}", "\u{c713}", "\u{110b}\u{1171}\u{11b6}",
        "\u{c713}", "\u{110b}\u{1171}\u{11b6}"), ("\u{c714}", "\u{c714}",
        "\u{110b}\u{1171}\u{11b7}", "\u{c714}", "\u{110b}\u{1171}\u{11b7}"), ("\u{c715}",
        "\u{c715}", "\u{110b}\u{1171}\u{11b8}", "\u{c715}", "\u{110b}\u{1171}\u{11b8}"),
        ("\u{c716}", "\u{c716}", "\u{110b}\u{1171}\u{11b9}", "\u{c716}",
        "\u{110b}\u{1171}\u{11b9}"), ("\u{c717}", "\u{c717}", "\u{110b}\u{1171}\u{11ba}",
        "\u{c717}", "\u{110b}\u{1171}\u{11ba}"), ("\u{c718}", "\u{c718}",
        "\u{110b}\u{1171}\u{11bb}", "\u{c718}", "\u{110b}\u{1171}\u{11bb}"), ("\u{c719}",
        "\u{c719}", "\u{110b}\u{1171}\u{11bc}", "\u{c719}", "\u{110b}\u{1171}\u{11bc}"),
        ("\u{c71a}", "\u{c71a}", "\u{110b}\u{1171}\u{11bd}", "\u{c71a}",
        "\u{110b}\u{1171}\u{11bd}"), ("\u{c71b}", "\u{c71b}", "\u{110b}\u{1171}\u{11be}",
        "\u{c71b}", "\u{110b}\u{1171}\u{11be}"), ("\u{c71c}", "\u{c71c}",
        "\u{110b}\u{1171}\u{11bf}", "\u{c71c}", "\u{110b}\u{1171}\u{11bf}"), ("\u{c71d}",
        "\u{c71d}", "\u{110b}\u{1171}\u{11c0}", "\u{c71d}", "\u{110b}\u{1171}\u{11c0}"),
        ("\u{c71e}", "\u{c71e}", "\u{110b}\u{1171}\u{11c1}", "\u{c71e}",
        "\u{110b}\u{1171}\u{11c1}"), ("\u{c71f}", "\u{c71f}", "\u{110b}\u{1171}\u{11c2}",
        "\u{c71f}", "\u{110b}\u{1171}\u{11c2}"), ("\u{c720}", "\u{c720}", "\u{110b}\u{1172}",
        "\u{c720}", "\u{110b}\u{1172}"), ("\u{c721}", "\u{c721}", "\u{110b}\u{1172}\u{11a8}",
        "\u{c721}", "\u{110b}\u{1172}\u{11a8}"), ("\u{c722}", "\u{c722}",
        "\u{110b}\u{1172}\u{11a9}", "\u{c722}", "\u{110b}\u{1172}\u{11a9}"), ("\u{c723}",
        "\u{c723}", "\u{110b}\u{1172}\u{11aa}", "\u{c723}", "\u{110b}\u{1172}\u{11aa}"),
        ("\u{c724}", "\u{c724}", "\u{110b}\u{1172}\u{11ab}", "\u{c724}",
        "\u{110b}\u{1172}\u{11ab}"), ("\u{c725}", "\u{c725}", "\u{110b}\u{1172}\u{11ac}",
        "\u{c725}", "\u{110b}\u{1172}\u{11ac}"), ("\u{c726}", "\u{c726}",
        "\u{110b}\u{1172}\u{11ad}", "\u{c726}", "\u{110b}\u{1172}\u{11ad}"), ("\u{c727}",
        "\u{c727}", "\u{110b}\u{1172}\u{11ae}", "\u{c727}", "\u{110b}\u{1172}\u{11ae}"),
        ("\u{c728}", "\u{c728}", "\u{110b}\u{1172}\u{11af}", "\u{c728}",
        "\u{110b}\u{1172}\u{11af}"), ("\u{c729}", "\u{c729}", "\u{110b}\u{1172}\u{11b0}",
        "\u{c729}", "\u{110b}\u{1172}\u{11b0}"), ("\u{c72a}", "\u{c72a}",
        "\u{110b}\u{1172}\u{11b1}", "\u{c72a}", "\u{110b}\u{1172}\u{11b1}"), ("\u{c72b}",
        "\u{c72b}", "\u{110b}\u{1172}\u{11b2}", "\u{c72b}", "\u{110b}\u{1172}\u{11b2}"),
        ("\u{c72c}", "\u{c72c}", "\u{110b}\u{1172}\u{11b3}", "\u{c72c}",
        "\u{110b}\u{1172}\u{11b3}"), ("\u{c72d}", "\u{c72d}", "\u{110b}\u{1172}\u{11b4}",
        "\u{c72d}", "\u{110b}\u{1172}\u{11b4}"), ("\u{c72e}", "\u{c72e}",
        "\u{110b}\u{1172}\u{11b5}", "\u{c72e}", "\u{110b}\u{1172}\u{11b5}"), ("\u{c72f}",
        "\u{c72f}", "\u{110b}\u{1172}\u{11b6}", "\u{c72f}", "\u{110b}\u{1172}\u{11b6}"),
        ("\u{c730}", "\u{c730}", "\u{110b}\u{1172}\u{11b7}", "\u{c730}",
        "\u{110b}\u{1172}\u{11b7}"), ("\u{c731}", "\u{c731}", "\u{110b}\u{1172}\u{11b8}",
        "\u{c731}", "\u{110b}\u{1172}\u{11b8}"), ("\u{c732}", "\u{c732}",
        "\u{110b}\u{1172}\u{11b9}", "\u{c732}", "\u{110b}\u{1172}\u{11b9}"), ("\u{c733}",
        "\u{c733}", "\u{110b}\u{1172}\u{11ba}", "\u{c733}", "\u{110b}\u{1172}\u{11ba}"),
        ("\u{c734}", "\u{c734}", "\u{110b}\u{1172}\u{11bb}", "\u{c734}",
        "\u{110b}\u{1172}\u{11bb}"), ("\u{c735}", "\u{c735}", "\u{110b}\u{1172}\u{11bc}",
        "\u{c735}", "\u{110b}\u{1172}\u{11bc}"), ("\u{c736}", "\u{c736}",
        "\u{110b}\u{1172}\u{11bd}", "\u{c736}", "\u{110b}\u{1172}\u{11bd}"), ("\u{c737}",
        "\u{c737}", "\u{110b}\u{1172}\u{11be}", "\u{c737}", "\u{110b}\u{1172}\u{11be}"),
        ("\u{c738}", "\u{c738}", "\u{110b}\u{1172}\u{11bf}", "\u{c738}",
        "\u{110b}\u{1172}\u{11bf}"), ("\u{c739}", "\u{c739}", "\u{110b}\u{1172}\u{11c0}",
        "\u{c739}", "\u{110b}\u{1172}\u{11c0}"), ("\u{c73a}", "\u{c73a}",
        "\u{110b}\u{1172}\u{11c1}", "\u{c73a}", "\u{110b}\u{1172}\u{11c1}"), ("\u{c73b}",
        "\u{c73b}", "\u{110b}\u{1172}\u{11c2}", "\u{c73b}", "\u{110b}\u{1172}\u{11c2}"),
        ("\u{c73c}", "\u{c73c}", "\u{110b}\u{1173}", "\u{c73c}", "\u{110b}\u{1173}"), ("\u{c73d}",
        "\u{c73d}", "\u{110b}\u{1173}\u{11a8}", "\u{c73d}", "\u{110b}\u{1173}\u{11a8}"),
        ("\u{c73e}", "\u{c73e}", "\u{110b}\u{1173}\u{11a9}", "\u{c73e}",
        "\u{110b}\u{1173}\u{11a9}"), ("\u{c73f}", "\u{c73f}", "\u{110b}\u{1173}\u{11aa}",
        "\u{c73f}", "\u{110b}\u{1173}\u{11aa}"), ("\u{c740}", "\u{c740}",
        "\u{110b}\u{1173}\u{11ab}", "\u{c740}", "\u{110b}\u{1173}\u{11ab}"), ("\u{c741}",
        "\u{c741}", "\u{110b}\u{1173}\u{11ac}", "\u{c741}", "\u{110b}\u{1173}\u{11ac}"),
        ("\u{c742}", "\u{c742}", "\u{110b}\u{1173}\u{11ad}", "\u{c742}",
        "\u{110b}\u{1173}\u{11ad}"), ("\u{c743}", "\u{c743}", "\u{110b}\u{1173}\u{11ae}",
        "\u{c743}", "\u{110b}\u{1173}\u{11ae}"), ("\u{c744}", "\u{c744}",
        "\u{110b}\u{1173}\u{11af}", "\u{c744}", "\u{110b}\u{1173}\u{11af}"), ("\u{c745}",
        "\u{c745}", "\u{110b}\u{1173}\u{11b0}", "\u{c745}", "\u{110b}\u{1173}\u{11b0}"),
        ("\u{c746}", "\u{c746}", "\u{110b}\u{1173}\u{11b1}", "\u{c746}",
        "\u{110b}\u{1173}\u{11b1}"), ("\u{c747}", "\u{c747}", "\u{110b}\u{1173}\u{11b2}",
        "\u{c747}", "\u{110b}\u{1173}\u{11b2}"), ("\u{c748}", "\u{c748}",
        "\u{110b}\u{1173}\u{11b3}", "\u{c748}", "\u{110b}\u{1173}\u{11b3}"), ("\u{c749}",
        "\u{c749}", "\u{110b}\u{1173}\u{11b4}", "\u{c749}", "\u{110b}\u{1173}\u{11b4}"),
        ("\u{c74a}", "\u{c74a}", "\u{110b}\u{1173}\u{11b5}", "\u{c74a}",
        "\u{110b}\u{1173}\u{11b5}"), ("\u{c74b}", "\u{c74b}", "\u{110b}\u{1173}\u{11b6}",
        "\u{c74b}", "\u{110b}\u{1173}\u{11b6}"), ("\u{c74c}", "\u{c74c}",
        "\u{110b}\u{1173}\u{11b7}", "\u{c74c}", "\u{110b}\u{1173}\u{11b7}"), ("\u{c74d}",
        "\u{c74d}", "\u{110b}\u{1173}\u{11b8}", "\u{c74d}", "\u{110b}\u{1173}\u{11b8}"),
        ("\u{c74e}", "\u{c74e}", "\u{110b}\u{1173}\u{11b9}", "\u{c74e}",
        "\u{110b}\u{1173}\u{11b9}"), ("\u{c74f}", "\u{c74f}", "\u{110b}\u{1173}\u{11ba}",
        "\u{c74f}", "\u{110b}\u{1173}\u{11ba}"), ("\u{c750}", "\u{c750}",
        "\u{110b}\u{1173}\u{11bb}", "\u{c750}", "\u{110b}\u{1173}\u{11bb}"), ("\u{c751}",
        "\u{c751}", "\u{110b}\u{1173}\u{11bc}", "\u{c751}", "\u{110b}\u{1173}\u{11bc}"),
        ("\u{c752}", "\u{c752}", "\u{110b}\u{1173}\u{11bd}", "\u{c752}",
        "\u{110b}\u{1173}\u{11bd}"), ("\u{c753}", "\u{c753}", "\u{110b}\u{1173}\u{11be}",
        "\u{c753}", "\u{110b}\u{1173}\u{11be}"), ("\u{c754}", "\u{c754}",
        "\u{110b}\u{1173}\u{11bf}", "\u{c754}", "\u{110b}\u{1173}\u{11bf}"), ("\u{c755}",
        "\u{c755}", "\u{110b}\u{1173}\u{11c0}", "\u{c755}", "\u{110b}\u{1173}\u{11c0}"),
        ("\u{c756}", "\u{c756}", "\u{110b}\u{1173}\u{11c1}", "\u{c756}",
        "\u{110b}\u{1173}\u{11c1}"), ("\u{c757}", "\u{c757}", "\u{110b}\u{1173}\u{11c2}",
        "\u{c757}", "\u{110b}\u{1173}\u{11c2}"), ("\u{c758}", "\u{c758}", "\u{110b}\u{1174}",
        "\u{c758}", "\u{110b}\u{1174}"), ("\u{c759}", "\u{c759}", "\u{110b}\u{1174}\u{11a8}",
        "\u{c759}", "\u{110b}\u{1174}\u{11a8}"), ("\u{c75a}", "\u{c75a}",
        "\u{110b}\u{1174}\u{11a9}", "\u{c75a}", "\u{110b}\u{1174}\u{11a9}"), ("\u{c75b}",
        "\u{c75b}", "\u{110b}\u{1174}\u{11aa}", "\u{c75b}", "\u{110b}\u{1174}\u{11aa}"),
        ("\u{c75c}", "\u{c75c}", "\u{110b}\u{1174}\u{11ab}", "\u{c75c}",
        "\u{110b}\u{1174}\u{11ab}"), ("\u{c75d}", "\u{c75d}", "\u{110b}\u{1174}\u{11ac}",
        "\u{c75d}", "\u{110b}\u{1174}\u{11ac}"), ("\u{c75e}", "\u{c75e}",
        "\u{110b}\u{1174}\u{11ad}", "\u{c75e}", "\u{110b}\u{1174}\u{11ad}"), ("\u{c75f}",
        "\u{c75f}", "\u{110b}\u{1174}\u{11ae}", "\u{c75f}", "\u{110b}\u{1174}\u{11ae}"),
        ("\u{c760}", "\u{c760}", "\u{110b}\u{1174}\u{11af}", "\u{c760}",
        "\u{110b}\u{1174}\u{11af}"), ("\u{c761}", "\u{c761}", "\u{110b}\u{1174}\u{11b0}",
        "\u{c761}", "\u{110b}\u{1174}\u{11b0}"), ("\u{c762}", "\u{c762}",
        "\u{110b}\u{1174}\u{11b1}", "\u{c762}", "\u{110b}\u{1174}\u{11b1}"), ("\u{c763}",
        "\u{c763}", "\u{110b}\u{1174}\u{11b2}", "\u{c763}", "\u{110b}\u{1174}\u{11b2}"),
        ("\u{c764}", "\u{c764}", "\u{110b}\u{1174}\u{11b3}", "\u{c764}",
        "\u{110b}\u{1174}\u{11b3}"), ("\u{c765}", "\u{c765}", "\u{110b}\u{1174}\u{11b4}",
        "\u{c765}", "\u{110b}\u{1174}\u{11b4}"), ("\u{c766}", "\u{c766}",
        "\u{110b}\u{1174}\u{11b5}", "\u{c766}", "\u{110b}\u{1174}\u{11b5}"), ("\u{c767}",
        "\u{c767}", "\u{110b}\u{1174}\u{11b6}", "\u{c767}", "\u{110b}\u{1174}\u{11b6}"),
        ("\u{c768}", "\u{c768}", "\u{110b}\u{1174}\u{11b7}", "\u{c768}",
        "\u{110b}\u{1174}\u{11b7}"), ("\u{c769}", "\u{c769}", "\u{110b}\u{1174}\u{11b8}",
        "\u{c769}", "\u{110b}\u{1174}\u{11b8}"), ("\u{c76a}", "\u{c76a}",
        "\u{110b}\u{1174}\u{11b9}", "\u{c76a}", "\u{110b}\u{1174}\u{11b9}"), ("\u{c76b}",
        "\u{c76b}", "\u{110b}\u{1174}\u{11ba}", "\u{c76b}", "\u{110b}\u{1174}\u{11ba}"),
        ("\u{c76c}", "\u{c76c}", "\u{110b}\u{1174}\u{11bb}", "\u{c76c}",
        "\u{110b}\u{1174}\u{11bb}"), ("\u{c76d}", "\u{c76d}", "\u{110b}\u{1174}\u{11bc}",
        "\u{c76d}", "\u{110b}\u{1174}\u{11bc}"), ("\u{c76e}", "\u{c76e}",
        "\u{110b}\u{1174}\u{11bd}", "\u{c76e}", "\u{110b}\u{1174}\u{11bd}"), ("\u{c76f}",
        "\u{c76f}", "\u{110b}\u{1174}\u{11be}", "\u{c76f}", "\u{110b}\u{1174}\u{11be}"),
        ("\u{c770}", "\u{c770}", "\u{110b}\u{1174}\u{11bf}", "\u{c770}",
        "\u{110b}\u{1174}\u{11bf}"), ("\u{c771}", "\u{c771}", "\u{110b}\u{1174}\u{11c0}",
        "\u{c771}", "\u{110b}\u{1174}\u{11c0}"), ("\u{c772}", "\u{c772}",
        "\u{110b}\u{1174}\u{11c1}", "\u{c772}", "\u{110b}\u{1174}\u{11c1}"), ("\u{c773}",
        "\u{c773}", "\u{110b}\u{1174}\u{11c2}", "\u{c773}", "\u{110b}\u{1174}\u{11c2}"),
        ("\u{c774}", "\u{c774}", "\u{110b}\u{1175}", "\u{c774}", "\u{110b}\u{1175}"), ("\u{c775}",
        "\u{c775}", "\u{110b}\u{1175}\u{11a8}", "\u{c775}", "\u{110b}\u{1175}\u{11a8}"),
        ("\u{c776}", "\u{c776}", "\u{110b}\u{1175}\u{11a9}", "\u{c776}",
        "\u{110b}\u{1175}\u{11a9}"), ("\u{c777}", "\u{c777}", "\u{110b}\u{1175}\u{11aa}",
        "\u{c777}", "\u{110b}\u{1175}\u{11aa}"), ("\u{c778}", "\u{c778}",
        "\u{110b}\u{1175}\u{11ab}", "\u{c778}", "\u{110b}\u{1175}\u{11ab}"), ("\u{c779}",
        "\u{c779}", "\u{110b}\u{1175}\u{11ac}", "\u{c779}", "\u{110b}\u{1175}\u{11ac}"),
        ("\u{c77a}", "\u{c77a}", "\u{110b}\u{1175}\u{11ad}", "\u{c77a}",
        "\u{110b}\u{1175}\u{11ad}"), ("\u{c77b}", "\u{c77b}", "\u{110b}\u{1175}\u{11ae}",
        "\u{c77b}", "\u{110b}\u{1175}\u{11ae}"), ("\u{c77c}", "\u{c77c}",
        "\u{110b}\u{1175}\u{11af}", "\u{c77c}", "\u{110b}\u{1175}\u{11af}"), ("\u{c77d}",
        "\u{c77d}", "\u{110b}\u{1175}\u{11b0}", "\u{c77d}", "\u{110b}\u{1175}\u{11b0}"),
        ("\u{c77e}", "\u{c77e}", "\u{110b}\u{1175}\u{11b1}", "\u{c77e}",
        "\u{110b}\u{1175}\u{11b1}"), ("\u{c77f}", "\u{c77f}", "\u{110b}\u{1175}\u{11b2}",
        "\u{c77f}", "\u{110b}\u{1175}\u{11b2}"), ("\u{c780}", "\u{c780}",
        "\u{110b}\u{1175}\u{11b3}", "\u{c780}", "\u{110b}\u{1175}\u{11b3}"), ("\u{c781}",
        "\u{c781}", "\u{110b}\u{1175}\u{11b4}", "\u{c781}", "\u{110b}\u{1175}\u{11b4}"),
        ("\u{c782}", "\u{c782}", "\u{110b}\u{1175}\u{11b5}", "\u{c782}",
        "\u{110b}\u{1175}\u{11b5}"), ("\u{c783}", "\u{c783}", "\u{110b}\u{1175}\u{11b6}",
        "\u{c783}", "\u{110b}\u{1175}\u{11b6}"), ("\u{c784}", "\u{c784}",
        "\u{110b}\u{1175}\u{11b7}", "\u{c784}", "\u{110b}\u{1175}\u{11b7}"), ("\u{c785}",
        "\u{c785}", "\u{110b}\u{1175}\u{11b8}", "\u{c785}", "\u{110b}\u{1175}\u{11b8}"),
        ("\u{c786}", "\u{c786}", "\u{110b}\u{1175}\u{11b9}", "\u{c786}",
        "\u{110b}\u{1175}\u{11b9}"), ("\u{c787}", "\u{c787}", "\u{110b}\u{1175}\u{11ba}",
        "\u{c787}", "\u{110b}\u{1175}\u{11ba}"), ("\u{c788}", "\u{c788}",
        "\u{110b}\u{1175}\u{11bb}", "\u{c788}", "\u{110b}\u{1175}\u{11bb}"), ("\u{c789}",
        "\u{c789}", "\u{110b}\u{1175}\u{11bc}", "\u{c789}", "\u{110b}\u{1175}\u{11bc}"),
        ("\u{c78a}", "\u{c78a}", "\u{110b}\u{1175}\u{11bd}", "\u{c78a}",
        "\u{110b}\u{1175}\u{11bd}"), ("\u{c78b}", "\u{c78b}", "\u{110b}\u{1175}\u{11be}",
        "\u{c78b}", "\u{110b}\u{1175}\u{11be}"), ("\u{c78c}", "\u{c78c}",
        "\u{110b}\u{1175}\u{11bf}", "\u{c78c}", "\u{110b}\u{1175}\u{11bf}"), ("\u{c78d}",
        "\u{c78d}", "\u{110b}\u{1175}\u{11c0}", "\u{c78d}", "\u{110b}\u{1175}\u{11c0}"),
        ("\u{c78e}", "\u{c78e}", "\u{110b}\u{1175}\u{11c1}", "\u{c78e}",
        "\u{110b}\u{1175}\u{11c1}"), ("\u{c78f}", "\u{c78f}", "\u{110b}\u{1175}\u{11c2}",
        "\u{c78f}", "\u{110b}\u{1175}\u{11c2}"), ("\u{c790}", "\u{c790}", "\u{110c}\u{1161}",
        "\u{c790}", "\u{110c}\u{1161}"), ("\u{c791}", "\u{c791}", "\u{110c}\u{1161}\u{11a8}",
        "\u{c791}", "\u{110c}\u{1161}\u{11a8}"), ("\u{c792}", "\u{c792}",
        "\u{110c}\u{1161}\u{11a9}", "\u{c792}", "\u{110c}\u{1161}\u{11a9}"), ("\u{c793}",
        "\u{c793}", "\u{110c}\u{1161}\u{11aa}", "\u{c793}", "\u{110c}\u{1161}\u{11aa}"),
        ("\u{c794}", "\u{c794}", "\u{110c}\u{1161}\u{11ab}", "\u{c794}",
        "\u{110c}\u{1161}\u{11ab}"), ("\u{c795}", "\u{c795}", "\u{110c}\u{1161}\u{11ac}",
        "\u{c795}", "\u{110c}\u{1161}\u{11ac}"), ("\u{c796}", "\u{c796}",
        "\u{110c}\u{1161}\u{11ad}", "\u{c796}", "\u{110c}\u{1161}\u{11ad}"), ("\u{c797}",
        "\u{c797}", "\u{110c}\u{1161}\u{11ae}", "\u{c797}", "\u{110c}\u{1161}\u{11ae}"),
        ("\u{c798}", "\u{c798}", "\u{110c}\u{1161}\u{11af}", "\u{c798}",
        "\u{110c}\u{1161}\u{11af}"), ("\u{c799}", "\u{c799}", "\u{110c}\u{1161}\u{11b0}",
        "\u{c799}", "\u{110c}\u{1161}\u{11b0}"), ("\u{c79a}", "\u{c79a}",
        "\u{110c}\u{1161}\u{11b1}", "\u{c79a}", "\u{110c}\u{1161}\u{11b1}"), ("\u{c79b}",
        "\u{c79b}", "\u{110c}\u{1161}\u{11b2}", "\u{c79b}", "\u{110c}\u{1161}\u{11b2}"),
        ("\u{c79c}", "\u{c79c}", "\u{110c}\u{1161}\u{11b3}", "\u{c79c}",
        "\u{110c}\u{1161}\u{11b3}"), ("\u{c79d}", "\u{c79d}", "\u{110c}\u{1161}\u{11b4}",
        "\u{c79d}", "\u{110c}\u{1161}\u{11b4}"), ("\u{c79e}", "\u{c79e}",
        "\u{110c}\u{1161}\u{11b5}", "\u{c79e}", "\u{110c}\u{1161}\u{11b5}"), ("\u{c79f}",
        "\u{c79f}", "\u{110c}\u{1161}\u{11b6}", "\u{c79f}", "\u{110c}\u{1161}\u{11b6}"),
        ("\u{c7a0}", "\u{c7a0}", "\u{110c}\u{1161}\u{11b7}", "\u{c7a0}",
        "\u{110c}\u{1161}\u{11b7}"), ("\u{c7a1}", "\u{c7a1}", "\u{110c}\u{1161}\u{11b8}",
        "\u{c7a1}", "\u{110c}\u{1161}\u{11b8}"), ("\u{c7a2}", "\u{c7a2}",
        "\u{110c}\u{1161}\u{11b9}", "\u{c7a2}", "\u{110c}\u{1161}\u{11b9}"), ("\u{c7a3}",
        "\u{c7a3}", "\u{110c}\u{1161}\u{11ba}", "\u{c7a3}", "\u{110c}\u{1161}\u{11ba}"),
        ("\u{c7a4}", "\u{c7a4}", "\u{110c}\u{1161}\u{11bb}", "\u{c7a4}",
        "\u{110c}\u{1161}\u{11bb}"), ("\u{c7a5}", "\u{c7a5}", "\u{110c}\u{1161}\u{11bc}",
        "\u{c7a5}", "\u{110c}\u{1161}\u{11bc}"), ("\u{c7a6}", "\u{c7a6}",
        "\u{110c}\u{1161}\u{11bd}", "\u{c7a6}", "\u{110c}\u{1161}\u{11bd}"), ("\u{c7a7}",
        "\u{c7a7}", "\u{110c}\u{1161}\u{11be}", "\u{c7a7}", "\u{110c}\u{1161}\u{11be}"),
        ("\u{c7a8}", "\u{c7a8}", "\u{110c}\u{1161}\u{11bf}", "\u{c7a8}",
        "\u{110c}\u{1161}\u{11bf}"), ("\u{c7a9}", "\u{c7a9}", "\u{110c}\u{1161}\u{11c0}",
        "\u{c7a9}", "\u{110c}\u{1161}\u{11c0}"), ("\u{c7aa}", "\u{c7aa}",
        "\u{110c}\u{1161}\u{11c1}", "\u{c7aa}", "\u{110c}\u{1161}\u{11c1}"), ("\u{c7ab}",
        "\u{c7ab}", "\u{110c}\u{1161}\u{11c2}", "\u{c7ab}", "\u{110c}\u{1161}\u{11c2}"),
        ("\u{c7ac}", "\u{c7ac}", "\u{110c}\u{1162}", "\u{c7ac}", "\u{110c}\u{1162}"), ("\u{c7ad}",
        "\u{c7ad}", "\u{110c}\u{1162}\u{11a8}", "\u{c7ad}", "\u{110c}\u{1162}\u{11a8}"),
        ("\u{c7ae}", "\u{c7ae}", "\u{110c}\u{1162}\u{11a9}", "\u{c7ae}",
        "\u{110c}\u{1162}\u{11a9}"), ("\u{c7af}", "\u{c7af}", "\u{110c}\u{1162}\u{11aa}",
        "\u{c7af}", "\u{110c}\u{1162}\u{11aa}"), ("\u{c7b0}", "\u{c7b0}",
        "\u{110c}\u{1162}\u{11ab}", "\u{c7b0}", "\u{110c}\u{1162}\u{11ab}"), ("\u{c7b1}",
        "\u{c7b1}", "\u{110c}\u{1162}\u{11ac}", "\u{c7b1}", "\u{110c}\u{1162}\u{11ac}"),
        ("\u{c7b2}", "\u{c7b2}", "\u{110c}\u{1162}\u{11ad}", "\u{c7b2}",
        "\u{110c}\u{1162}\u{11ad}"), ("\u{c7b3}", "\u{c7b3}", "\u{110c}\u{1162}\u{11ae}",
        "\u{c7b3}", "\u{110c}\u{1162}\u{11ae}"), ("\u{c7b4}", "\u{c7b4}",
        "\u{110c}\u{1162}\u{11af}", "\u{c7b4}", "\u{110c}\u{1162}\u{11af}"), ("\u{c7b5}",
        "\u{c7b5}", "\u{110c}\u{1162}\u{11b0}", "\u{c7b5}", "\u{110c}\u{1162}\u{11b0}"),
        ("\u{c7b6}", "\u{c7b6}", "\u{110c}\u{1162}\u{11b1}", "\u{c7b6}",
        "\u{110c}\u{1162}\u{11b1}"), ("\u{c7b7}", "\u{c7b7}", "\u{110c}\u{1162}\u{11b2}",
        "\u{c7b7}", "\u{110c}\u{1162}\u{11b2}"), ("\u{c7b8}", "\u{c7b8}",
        "\u{110c}\u{1162}\u{11b3}", "\u{c7b8}", "\u{110c}\u{1162}\u{11b3}"), ("\u{c7b9}",
        "\u{c7b9}", "\u{110c}\u{1162}\u{11b4}", "\u{c7b9}", "\u{110c}\u{1162}\u{11b4}"),
        ("\u{c7ba}", "\u{c7ba}", "\u{110c}\u{1162}\u{11b5}", "\u{c7ba}",
        "\u{110c}\u{1162}\u{11b5}"), ("\u{c7bb}", "\u{c7bb}", "\u{110c}\u{1162}\u{11b6}",
        "\u{c7bb}", "\u{110c}\u{1162}\u{11b6}"), ("\u{c7bc}", "\u{c7bc}",
        "\u{110c}\u{1162}\u{11b7}", "\u{c7bc}", "\u{110c}\u{1162}\u{11b7}"), ("\u{c7bd}",
        "\u{c7bd}", "\u{110c}\u{1162}\u{11b8}", "\u{c7bd}", "\u{110c}\u{1162}\u{11b8}"),
        ("\u{c7be}", "\u{c7be}", "\u{110c}\u{1162}\u{11b9}", "\u{c7be}",
        "\u{110c}\u{1162}\u{11b9}"), ("\u{c7bf}", "\u{c7bf}", "\u{110c}\u{1162}\u{11ba}",
        "\u{c7bf}", "\u{110c}\u{1162}\u{11ba}"), ("\u{c7c0}", "\u{c7c0}",
        "\u{110c}\u{1162}\u{11bb}", "\u{c7c0}", "\u{110c}\u{1162}\u{11bb}"), ("\u{c7c1}",
        "\u{c7c1}", "\u{110c}\u{1162}\u{11bc}", "\u{c7c1}", "\u{110c}\u{1162}\u{11bc}"),
        ("\u{c7c2}", "\u{c7c2}", "\u{110c}\u{1162}\u{11bd}", "\u{c7c2}",
        "\u{110c}\u{1162}\u{11bd}"), ("\u{c7c3}", "\u{c7c3}", "\u{110c}\u{1162}\u{11be}",
        "\u{c7c3}", "\u{110c}\u{1162}\u{11be}"), ("\u{c7c4}", "\u{c7c4}",
        "\u{110c}\u{1162}\u{11bf}", "\u{c7c4}", "\u{110c}\u{1162}\u{11bf}"), ("\u{c7c5}",
        "\u{c7c5}", "\u{110c}\u{1162}\u{11c0}", "\u{c7c5}", "\u{110c}\u{1162}\u{11c0}"),
        ("\u{c7c6}", "\u{c7c6}", "\u{110c}\u{1162}\u{11c1}", "\u{c7c6}",
        "\u{110c}\u{1162}\u{11c1}"), ("\u{c7c7}", "\u{c7c7}", "\u{110c}\u{1162}\u{11c2}",
        "\u{c7c7}", "\u{110c}\u{1162}\u{11c2}"), ("\u{c7c8}", "\u{c7c8}", "\u{110c}\u{1163}",
        "\u{c7c8}", "\u{110c}\u{1163}"), ("\u{c7c9}", "\u{c7c9}", "\u{110c}\u{1163}\u{11a8}",
        "\u{c7c9}", "\u{110c}\u{1163}\u{11a8}"), ("\u{c7ca}", "\u{c7ca}",
        "\u{110c}\u{1163}\u{11a9}", "\u{c7ca}", "\u{110c}\u{1163}\u{11a9}"), ("\u{c7cb}",
        "\u{c7cb}", "\u{110c}\u{1163}\u{11aa}", "\u{c7cb}", "\u{110c}\u{1163}\u{11aa}"),
        ("\u{c7cc}", "\u{c7cc}", "\u{110c}\u{1163}\u{11ab}", "\u{c7cc}",
        "\u{110c}\u{1163}\u{11ab}"), ("\u{c7cd}", "\u{c7cd}", "\u{110c}\u{1163}\u{11ac}",
        "\u{c7cd}", "\u{110c}\u{1163}\u{11ac}"), ("\u{c7ce}", "\u{c7ce}",
        "\u{110c}\u{1163}\u{11ad}", "\u{c7ce}", "\u{110c}\u{1163}\u{11ad}"), ("\u{c7cf}",
        "\u{c7cf}", "\u{110c}\u{1163}\u{11ae}", "\u{c7cf}", "\u{110c}\u{1163}\u{11ae}"),
        ("\u{c7d0}", "\u{c7d0}", "\u{110c}\u{1163}\u{11af}", "\u{c7d0}",
        "\u{110c}\u{1163}\u{11af}"), ("\u{c7d1}", "\u{c7d1}", "\u{110c}\u{1163}\u{11b0}",
        "\u{c7d1}", "\u{110c}\u{1163}\u{11b0}"), ("\u{c7d2}", "\u{c7d2}",
        "\u{110c}\u{1163}\u{11b1}", "\u{c7d2}", "\u{110c}\u{1163}\u{11b1}"), ("\u{c7d3}",
        "\u{c7d3}", "\u{110c}\u{1163}\u{11b2}", "\u{c7d3}", "\u{110c}\u{1163}\u{11b2}"),
        ("\u{c7d4}", "\u{c7d4}", "\u{110c}\u{1163}\u{11b3}", "\u{c7d4}",
        "\u{110c}\u{1163}\u{11b3}"), ("\u{c7d5}", "\u{c7d5}", "\u{110c}\u{1163}\u{11b4}",
        "\u{c7d5}", "\u{110c}\u{1163}\u{11b4}"), ("\u{c7d6}", "\u{c7d6}",
        "\u{110c}\u{1163}\u{11b5}", "\u{c7d6}", "\u{110c}\u{1163}\u{11b5}"), ("\u{c7d7}",
        "\u{c7d7}", "\u{110c}\u{1163}\u{11b6}", "\u{c7d7}", "\u{110c}\u{1163}\u{11b6}"),
        ("\u{c7d8}", "\u{c7d8}", "\u{110c}\u{1163}\u{11b7}", "\u{c7d8}",
        "\u{110c}\u{1163}\u{11b7}"), ("\u{c7d9}", "\u{c7d9}", "\u{110c}\u{1163}\u{11b8}",
        "\u{c7d9}", "\u{110c}\u{1163}\u{11b8}"), ("\u{c7da}", "\u{c7da}",
        "\u{110c}\u{1163}\u{11b9}", "\u{c7da}", "\u{110c}\u{1163}\u{11b9}"), ("\u{c7db}",
        "\u{c7db}", "\u{110c}\u{1163}\u{11ba}", "\u{c7db}", "\u{110c}\u{1163}\u{11ba}"),
        ("\u{c7dc}", "\u{c7dc}", "\u{110c}\u{1163}\u{11bb}", "\u{c7dc}",
        "\u{110c}\u{1163}\u{11bb}"), ("\u{c7dd}", "\u{c7dd}", "\u{110c}\u{1163}\u{11bc}",
        "\u{c7dd}", "\u{110c}\u{1163}\u{11bc}"), ("\u{c7de}", "\u{c7de}",
        "\u{110c}\u{1163}\u{11bd}", "\u{c7de}", "\u{110c}\u{1163}\u{11bd}"), ("\u{c7df}",
        "\u{c7df}", "\u{110c}\u{1163}\u{11be}", "\u{c7df}", "\u{110c}\u{1163}\u{11be}"),
        ("\u{c7e0}", "\u{c7e0}", "\u{110c}\u{1163}\u{11bf}", "\u{c7e0}",
        "\u{110c}\u{1163}\u{11bf}"), ("\u{c7e1}", "\u{c7e1}", "\u{110c}\u{1163}\u{11c0}",
        "\u{c7e1}", "\u{110c}\u{1163}\u{11c0}"), ("\u{c7e2}", "\u{c7e2}",
        "\u{110c}\u{1163}\u{11c1}", "\u{c7e2}", "\u{110c}\u{1163}\u{11c1}"), ("\u{c7e3}",
        "\u{c7e3}", "\u{110c}\u{1163}\u{11c2}", "\u{c7e3}", "\u{110c}\u{1163}\u{11c2}"),
        ("\u{c7e4}", "\u{c7e4}", "\u{110c}\u{1164}", "\u{c7e4}", "\u{110c}\u{1164}"), ("\u{c7e5}",
        "\u{c7e5}", "\u{110c}\u{1164}\u{11a8}", "\u{c7e5}", "\u{110c}\u{1164}\u{11a8}"),
        ("\u{c7e6}", "\u{c7e6}", "\u{110c}\u{1164}\u{11a9}", "\u{c7e6}",
        "\u{110c}\u{1164}\u{11a9}"), ("\u{c7e7}", "\u{c7e7}", "\u{110c}\u{1164}\u{11aa}",
        "\u{c7e7}", "\u{110c}\u{1164}\u{11aa}"), ("\u{c7e8}", "\u{c7e8}",
        "\u{110c}\u{1164}\u{11ab}", "\u{c7e8}", "\u{110c}\u{1164}\u{11ab}"), ("\u{c7e9}",
        "\u{c7e9}", "\u{110c}\u{1164}\u{11ac}", "\u{c7e9}", "\u{110c}\u{1164}\u{11ac}"),
        ("\u{c7ea}", "\u{c7ea}", "\u{110c}\u{1164}\u{11ad}", "\u{c7ea}",
        "\u{110c}\u{1164}\u{11ad}"), ("\u{c7eb}", "\u{c7eb}", "\u{110c}\u{1164}\u{11ae}",
        "\u{c7eb}", "\u{110c}\u{1164}\u{11ae}"), ("\u{c7ec}", "\u{c7ec}",
        "\u{110c}\u{1164}\u{11af}", "\u{c7ec}", "\u{110c}\u{1164}\u{11af}"), ("\u{c7ed}",
        "\u{c7ed}", "\u{110c}\u{1164}\u{11b0}", "\u{c7ed}", "\u{110c}\u{1164}\u{11b0}"),
        ("\u{c7ee}", "\u{c7ee}", "\u{110c}\u{1164}\u{11b1}", "\u{c7ee}",
        "\u{110c}\u{1164}\u{11b1}"), ("\u{c7ef}", "\u{c7ef}", "\u{110c}\u{1164}\u{11b2}",
        "\u{c7ef}", "\u{110c}\u{1164}\u{11b2}"), ("\u{c7f0}", "\u{c7f0}",
        "\u{110c}\u{1164}\u{11b3}", "\u{c7f0}", "\u{110c}\u{1164}\u{11b3}"), ("\u{c7f1}",
        "\u{c7f1}", "\u{110c}\u{1164}\u{11b4}", "\u{c7f1}", "\u{110c}\u{1164}\u{11b4}"),
        ("\u{c7f2}", "\u{c7f2}", "\u{110c}\u{1164}\u{11b5}", "\u{c7f2}",
        "\u{110c}\u{1164}\u{11b5}"), ("\u{c7f3}", "\u{c7f3}", "\u{110c}\u{1164}\u{11b6}",
        "\u{c7f3}", "\u{110c}\u{1164}\u{11b6}"), ("\u{c7f4}", "\u{c7f4}",
        "\u{110c}\u{1164}\u{11b7}", "\u{c7f4}", "\u{110c}\u{1164}\u{11b7}"), ("\u{c7f5}",
        "\u{c7f5}", "\u{110c}\u{1164}\u{11b8}", "\u{c7f5}", "\u{110c}\u{1164}\u{11b8}"),
        ("\u{c7f6}", "\u{c7f6}", "\u{110c}\u{1164}\u{11b9}", "\u{c7f6}",
        "\u{110c}\u{1164}\u{11b9}"), ("\u{c7f7}", "\u{c7f7}", "\u{110c}\u{1164}\u{11ba}",
        "\u{c7f7}", "\u{110c}\u{1164}\u{11ba}"), ("\u{c7f8}", "\u{c7f8}",
        "\u{110c}\u{1164}\u{11bb}", "\u{c7f8}", "\u{110c}\u{1164}\u{11bb}"), ("\u{c7f9}",
        "\u{c7f9}", "\u{110c}\u{1164}\u{11bc}", "\u{c7f9}", "\u{110c}\u{1164}\u{11bc}"),
        ("\u{c7fa}", "\u{c7fa}", "\u{110c}\u{1164}\u{11bd}", "\u{c7fa}",
        "\u{110c}\u{1164}\u{11bd}"), ("\u{c7fb}", "\u{c7fb}", "\u{110c}\u{1164}\u{11be}",
        "\u{c7fb}", "\u{110c}\u{1164}\u{11be}"), ("\u{c7fc}", "\u{c7fc}",
        "\u{110c}\u{1164}\u{11bf}", "\u{c7fc}", "\u{110c}\u{1164}\u{11bf}"), ("\u{c7fd}",
        "\u{c7fd}", "\u{110c}\u{1164}\u{11c0}", "\u{c7fd}", "\u{110c}\u{1164}\u{11c0}"),
        ("\u{c7fe}", "\u{c7fe}", "\u{110c}\u{1164}\u{11c1}", "\u{c7fe}",
        "\u{110c}\u{1164}\u{11c1}"), ("\u{c7ff}", "\u{c7ff}", "\u{110c}\u{1164}\u{11c2}",
        "\u{c7ff}", "\u{110c}\u{1164}\u{11c2}"), ("\u{c800}", "\u{c800}", "\u{110c}\u{1165}",
        "\u{c800}", "\u{110c}\u{1165}"), ("\u{c801}", "\u{c801}", "\u{110c}\u{1165}\u{11a8}",
        "\u{c801}", "\u{110c}\u{1165}\u{11a8}"), ("\u{c802}", "\u{c802}",
        "\u{110c}\u{1165}\u{11a9}", "\u{c802}", "\u{110c}\u{1165}\u{11a9}"), ("\u{c803}",
        "\u{c803}", "\u{110c}\u{1165}\u{11aa}", "\u{c803}", "\u{110c}\u{1165}\u{11aa}"),
        ("\u{c804}", "\u{c804}", "\u{110c}\u{1165}\u{11ab}", "\u{c804}",
        "\u{110c}\u{1165}\u{11ab}"), ("\u{c805}", "\u{c805}", "\u{110c}\u{1165}\u{11ac}",
        "\u{c805}", "\u{110c}\u{1165}\u{11ac}"), ("\u{c806}", "\u{c806}",
        "\u{110c}\u{1165}\u{11ad}", "\u{c806}", "\u{110c}\u{1165}\u{11ad}"), ("\u{c807}",
        "\u{c807}", "\u{110c}\u{1165}\u{11ae}", "\u{c807}", "\u{110c}\u{1165}\u{11ae}"),
        ("\u{c808}", "\u{c808}", "\u{110c}\u{1165}\u{11af}", "\u{c808}",
        "\u{110c}\u{1165}\u{11af}"), ("\u{c809}", "\u{c809}", "\u{110c}\u{1165}\u{11b0}",
        "\u{c809}", "\u{110c}\u{1165}\u{11b0}"), ("\u{c80a}", "\u{c80a}",
        "\u{110c}\u{1165}\u{11b1}", "\u{c80a}", "\u{110c}\u{1165}\u{11b1}"), ("\u{c80b}",
        "\u{c80b}", "\u{110c}\u{1165}\u{11b2}", "\u{c80b}", "\u{110c}\u{1165}\u{11b2}"),
        ("\u{c80c}", "\u{c80c}", "\u{110c}\u{1165}\u{11b3}", "\u{c80c}",
        "\u{110c}\u{1165}\u{11b3}"), ("\u{c80d}", "\u{c80d}", "\u{110c}\u{1165}\u{11b4}",
        "\u{c80d}", "\u{110c}\u{1165}\u{11b4}"), ("\u{c80e}", "\u{c80e}",
        "\u{110c}\u{1165}\u{11b5}", "\u{c80e}", "\u{110c}\u{1165}\u{11b5}"), ("\u{c80f}",
        "\u{c80f}", "\u{110c}\u{1165}\u{11b6}", "\u{c80f}", "\u{110c}\u{1165}\u{11b6}"),
        ("\u{c810}", "\u{c810}", "\u{110c}\u{1165}\u{11b7}", "\u{c810}",
        "\u{110c}\u{1165}\u{11b7}"), ("\u{c811}", "\u{c811}", "\u{110c}\u{1165}\u{11b8}",
        "\u{c811}", "\u{110c}\u{1165}\u{11b8}"), ("\u{c812}", "\u{c812}",
        "\u{110c}\u{1165}\u{11b9}", "\u{c812}", "\u{110c}\u{1165}\u{11b9}"), ("\u{c813}",
        "\u{c813}", "\u{110c}\u{1165}\u{11ba}", "\u{c813}", "\u{110c}\u{1165}\u{11ba}"),
        ("\u{c814}", "\u{c814}", "\u{110c}\u{1165}\u{11bb}", "\u{c814}",
        "\u{110c}\u{1165}\u{11bb}"), ("\u{c815}", "\u{c815}", "\u{110c}\u{1165}\u{11bc}",
        "\u{c815}", "\u{110c}\u{1165}\u{11bc}"), ("\u{c816}", "\u{c816}",
        "\u{110c}\u{1165}\u{11bd}", "\u{c816}", "\u{110c}\u{1165}\u{11bd}"), ("\u{c817}",
        "\u{c817}", "\u{110c}\u{1165}\u{11be}", "\u{c817}", "\u{110c}\u{1165}\u{11be}"),
        ("\u{c818}", "\u{c818}", "\u{110c}\u{1165}\u{11bf}", "\u{c818}",
        "\u{110c}\u{1165}\u{11bf}"), ("\u{c819}", "\u{c819}", "\u{110c}\u{1165}\u{11c0}",
        "\u{c819}", "\u{110c}\u{1165}\u{11c0}"), ("\u{c81a}", "\u{c81a}",
        "\u{110c}\u{1165}\u{11c1}", "\u{c81a}", "\u{110c}\u{1165}\u{11c1}"), ("\u{c81b}",
        "\u{c81b}", "\u{110c}\u{1165}\u{11c2}", "\u{c81b}", "\u{110c}\u{1165}\u{11c2}"),
        ("\u{c81c}", "\u{c81c}", "\u{110c}\u{1166}", "\u{c81c}", "\u{110c}\u{1166}"), ("\u{c81d}",
        "\u{c81d}", "\u{110c}\u{1166}\u{11a8}", "\u{c81d}", "\u{110c}\u{1166}\u{11a8}"),
        ("\u{c81e}", "\u{c81e}", "\u{110c}\u{1166}\u{11a9}", "\u{c81e}",
        "\u{110c}\u{1166}\u{11a9}"), ("\u{c81f}", "\u{c81f}", "\u{110c}\u{1166}\u{11aa}",
        "\u{c81f}", "\u{110c}\u{1166}\u{11aa}"), ("\u{c820}", "\u{c820}",
        "\u{110c}\u{1166}\u{11ab}", "\u{c820}", "\u{110c}\u{1166}\u{11ab}"), ("\u{c821}",
        "\u{c821}", "\u{110c}\u{1166}\u{11ac}", "\u{c821}", "\u{110c}\u{1166}\u{11ac}"),
        ("\u{c822}", "\u{c822}", "\u{110c}\u{1166}\u{11ad}", "\u{c822}",
        "\u{110c}\u{1166}\u{11ad}"), ("\u{c823}", "\u{c823}", "\u{110c}\u{1166}\u{11ae}",
        "\u{c823}", "\u{110c}\u{1166}\u{11ae}"), ("\u{c824}", "\u{c824}",
        "\u{110c}\u{1166}\u{11af}", "\u{c824}", "\u{110c}\u{1166}\u{11af}"), ("\u{c825}",
        "\u{c825}", "\u{110c}\u{1166}\u{11b0}", "\u{c825}", "\u{110c}\u{1166}\u{11b0}"),
        ("\u{c826}", "\u{c826}", "\u{110c}\u{1166}\u{11b1}", "\u{c826}",
        "\u{110c}\u{1166}\u{11b1}"), ("\u{c827}", "\u{c827}", "\u{110c}\u{1166}\u{11b2}",
        "\u{c827}", "\u{110c}\u{1166}\u{11b2}"), ("\u{c828}", "\u{c828}",
        "\u{110c}\u{1166}\u{11b3}", "\u{c828}", "\u{110c}\u{1166}\u{11b3}"), ("\u{c829}",
        "\u{c829}", "\u{110c}\u{1166}\u{11b4}", "\u{c829}", "\u{110c}\u{1166}\u{11b4}"),
        ("\u{c82a}", "\u{c82a}", "\u{110c}\u{1166}\u{11b5}", "\u{c82a}",
        "\u{110c}\u{1166}\u{11b5}"), ("\u{c82b}", "\u{c82b}", "\u{110c}\u{1166}\u{11b6}",
        "\u{c82b}", "\u{110c}\u{1166}\u{11b6}"), ("\u{c82c}", "\u{c82c}",
        "\u{110c}\u{1166}\u{11b7}", "\u{c82c}", "\u{110c}\u{1166}\u{11b7}"), ("\u{c82d}",
        "\u{c82d}", "\u{110c}\u{1166}\u{11b8}", "\u{c82d}", "\u{110c}\u{1166}\u{11b8}"),
        ("\u{c82e}", "\u{c82e}", "\u{110c}\u{1166}\u{11b9}", "\u{c82e}",
        "\u{110c}\u{1166}\u{11b9}"), ("\u{c82f}", "\u{c82f}", "\u{110c}\u{1166}\u{11ba}",
        "\u{c82f}", "\u{110c}\u{1166}\u{11ba}"), ("\u{c830}", "\u{c830}",
        "\u{110c}\u{1166}\u{11bb}", "\u{c830}", "\u{110c}\u{1166}\u{11bb}"), ("\u{c831}",
        "\u{c831}", "\u{110c}\u{1166}\u{11bc}", "\u{c831}", "\u{110c}\u{1166}\u{11bc}"),
        ("\u{c832}", "\u{c832}", "\u{110c}\u{1166}\u{11bd}", "\u{c832}",
        "\u{110c}\u{1166}\u{11bd}"), ("\u{c833}", "\u{c833}", "\u{110c}\u{1166}\u{11be}",
        "\u{c833}", "\u{110c}\u{1166}\u{11be}"), ("\u{c834}", "\u{c834}",
        "\u{110c}\u{1166}\u{11bf}", "\u{c834}", "\u{110c}\u{1166}\u{11bf}"), ("\u{c835}",
        "\u{c835}", "\u{110c}\u{1166}\u{11c0}", "\u{c835}", "\u{110c}\u{1166}\u{11c0}"),
        ("\u{c836}", "\u{c836}", "\u{110c}\u{1166}\u{11c1}", "\u{c836}",
        "\u{110c}\u{1166}\u{11c1}"), ("\u{c837}", "\u{c837}", "\u{110c}\u{1166}\u{11c2}",
        "\u{c837}", "\u{110c}\u{1166}\u{11c2}"), ("\u{c838}", "\u{c838}", "\u{110c}\u{1167}",
        "\u{c838}", "\u{110c}\u{1167}"), ("\u{c839}", "\u{c839}", "\u{110c}\u{1167}\u{11a8}",
        "\u{c839}", "\u{110c}\u{1167}\u{11a8}"), ("\u{c83a}", "\u{c83a}",
        "\u{110c}\u{1167}\u{11a9}", "\u{c83a}", "\u{110c}\u{1167}\u{11a9}"), ("\u{c83b}",
        "\u{c83b}", "\u{110c}\u{1167}\u{11aa}", "\u{c83b}", "\u{110c}\u{1167}\u{11aa}"),
        ("\u{c83c}", "\u{c83c}", "\u{110c}\u{1167}\u{11ab}", "\u{c83c}",
        "\u{110c}\u{1167}\u{11ab}"), ("\u{c83d}", "\u{c83d}", "\u{110c}\u{1167}\u{11ac}",
        "\u{c83d}", "\u{110c}\u{1167}\u{11ac}"), ("\u{c83e}", "\u{c83e}",
        "\u{110c}\u{1167}\u{11ad}", "\u{c83e}", "\u{110c}\u{1167}\u{11ad}"), ("\u{c83f}",
        "\u{c83f}", "\u{110c}\u{1167}\u{11ae}", "\u{c83f}", "\u{110c}\u{1167}\u{11ae}"),
        ("\u{c840}", "\u{c840}", "\u{110c}\u{1167}\u{11af}", "\u{c840}",
        "\u{110c}\u{1167}\u{11af}"), ("\u{c841}", "\u{c841}", "\u{110c}\u{1167}\u{11b0}",
        "\u{c841}", "\u{110c}\u{1167}\u{11b0}"), ("\u{c842}", "\u{c842}",
        "\u{110c}\u{1167}\u{11b1}", "\u{c842}", "\u{110c}\u{1167}\u{11b1}"), ("\u{c843}",
        "\u{c843}", "\u{110c}\u{1167}\u{11b2}", "\u{c843}", "\u{110c}\u{1167}\u{11b2}"),
        ("\u{c844}", "\u{c844}", "\u{110c}\u{1167}\u{11b3}", "\u{c844}",
        "\u{110c}\u{1167}\u{11b3}"), ("\u{c845}", "\u{c845}", "\u{110c}\u{1167}\u{11b4}",
        "\u{c845}", "\u{110c}\u{1167}\u{11b4}"), ("\u{c846}", "\u{c846}",
        "\u{110c}\u{1167}\u{11b5}", "\u{c846}", "\u{110c}\u{1167}\u{11b5}"), ("\u{c847}",
        "\u{c847}", "\u{110c}\u{1167}\u{11b6}", "\u{c847}", "\u{110c}\u{1167}\u{11b6}"),
        ("\u{c848}", "\u{c848}", "\u{110c}\u{1167}\u{11b7}", "\u{c848}",
        "\u{110c}\u{1167}\u{11b7}"), ("\u{c849}", "\u{c849}", "\u{110c}\u{1167}\u{11b8}",
        "\u{c849}", "\u{110c}\u{1167}\u{11b8}"), ("\u{c84a}", "\u{c84a}",
        "\u{110c}\u{1167}\u{11b9}", "\u{c84a}", "\u{110c}\u{1167}\u{11b9}"), ("\u{c84b}",
        "\u{c84b}", "\u{110c}\u{1167}\u{11ba}", "\u{c84b}", "\u{110c}\u{1167}\u{11ba}"),
        ("\u{c84c}", "\u{c84c}", "\u{110c}\u{1167}\u{11bb}", "\u{c84c}",
        "\u{110c}\u{1167}\u{11bb}"), ("\u{c84d}", "\u{c84d}", "\u{110c}\u{1167}\u{11bc}",
        "\u{c84d}", "\u{110c}\u{1167}\u{11bc}"), ("\u{c84e}", "\u{c84e}",
        "\u{110c}\u{1167}\u{11bd}", "\u{c84e}", "\u{110c}\u{1167}\u{11bd}"), ("\u{c84f}",
        "\u{c84f}", "\u{110c}\u{1167}\u{11be}", "\u{c84f}", "\u{110c}\u{1167}\u{11be}"),
        ("\u{c850}", "\u{c850}", "\u{110c}\u{1167}\u{11bf}", "\u{c850}",
        "\u{110c}\u{1167}\u{11bf}"), ("\u{c851}", "\u{c851}", "\u{110c}\u{1167}\u{11c0}",
        "\u{c851}", "\u{110c}\u{1167}\u{11c0}"), ("\u{c852}", "\u{c852}",
        "\u{110c}\u{1167}\u{11c1}", "\u{c852}", "\u{110c}\u{1167}\u{11c1}"), ("\u{c853}",
        "\u{c853}", "\u{110c}\u{1167}\u{11c2}", "\u{c853}", "\u{110c}\u{1167}\u{11c2}"),
        ("\u{c854}", "\u{c854}", "\u{110c}\u{1168}", "\u{c854}", "\u{110c}\u{1168}"), ("\u{c855}",
        "\u{c855}", "\u{110c}\u{1168}\u{11a8}", "\u{c855}", "\u{110c}\u{1168}\u{11a8}"),
        ("\u{c856}", "\u{c856}", "\u{110c}\u{1168}\u{11a9}", "\u{c856}",
        "\u{110c}\u{1168}\u{11a9}"), ("\u{c857}", "\u{c857}", "\u{110c}\u{1168}\u{11aa}",
        "\u{c857}", "\u{110c}\u{1168}\u{11aa}"), ("\u{c858}", "\u{c858}",
        "\u{110c}\u{1168}\u{11ab}", "\u{c858}", "\u{110c}\u{1168}\u{11ab}"), ("\u{c859}",
        "\u{c859}", "\u{110c}\u{1168}\u{11ac}", "\u{c859}", "\u{110c}\u{1168}\u{11ac}"),
        ("\u{c85a}", "\u{c85a}", "\u{110c}\u{1168}\u{11ad}", "\u{c85a}",
        "\u{110c}\u{1168}\u{11ad}"), ("\u{c85b}", "\u{c85b}", "\u{110c}\u{1168}\u{11ae}",
        "\u{c85b}", "\u{110c}\u{1168}\u{11ae}"), ("\u{c85c}", "\u{c85c}",
        "\u{110c}\u{1168}\u{11af}", "\u{c85c}", "\u{110c}\u{1168}\u{11af}"), ("\u{c85d}",
        "\u{c85d}", "\u{110c}\u{1168}\u{11b0}", "\u{c85d}", "\u{110c}\u{1168}\u{11b0}"),
        ("\u{c85e}", "\u{c85e}", "\u{110c}\u{1168}\u{11b1}", "\u{c85e}",
        "\u{110c}\u{1168}\u{11b1}"), ("\u{c85f}", "\u{c85f}", "\u{110c}\u{1168}\u{11b2}",
        "\u{c85f}", "\u{110c}\u{1168}\u{11b2}"), ("\u{c860}", "\u{c860}",
        "\u{110c}\u{1168}\u{11b3}", "\u{c860}", "\u{110c}\u{1168}\u{11b3}"), ("\u{c861}",
        "\u{c861}", "\u{110c}\u{1168}\u{11b4}", "\u{c861}", "\u{110c}\u{1168}\u{11b4}"),
        ("\u{c862}", "\u{c862}", "\u{110c}\u{1168}\u{11b5}", "\u{c862}",
        "\u{110c}\u{1168}\u{11b5}"), ("\u{c863}", "\u{c863}", "\u{110c}\u{1168}\u{11b6}",
        "\u{c863}", "\u{110c}\u{1168}\u{11b6}"), ("\u{c864}", "\u{c864}",
        "\u{110c}\u{1168}\u{11b7}", "\u{c864}", "\u{110c}\u{1168}\u{11b7}"), ("\u{c865}",
        "\u{c865}", "\u{110c}\u{1168}\u{11b8}", "\u{c865}", "\u{110c}\u{1168}\u{11b8}"),
        ("\u{c866}", "\u{c866}", "\u{110c}\u{1168}\u{11b9}", "\u{c866}",
        "\u{110c}\u{1168}\u{11b9}"), ("\u{c867}", "\u{c867}", "\u{110c}\u{1168}\u{11ba}",
        "\u{c867}", "\u{110c}\u{1168}\u{11ba}"), ("\u{c868}", "\u{c868}",
        "\u{110c}\u{1168}\u{11bb}", "\u{c868}", "\u{110c}\u{1168}\u{11bb}"), ("\u{c869}",
        "\u{c869}", "\u{110c}\u{1168}\u{11bc}", "\u{c869}", "\u{110c}\u{1168}\u{11bc}"),
        ("\u{c86a}", "\u{c86a}", "\u{110c}\u{1168}\u{11bd}", "\u{c86a}",
        "\u{110c}\u{1168}\u{11bd}"), ("\u{c86b}", "\u{c86b}", "\u{110c}\u{1168}\u{11be}",
        "\u{c86b}", "\u{110c}\u{1168}\u{11be}"), ("\u{c86c}", "\u{c86c}",
        "\u{110c}\u{1168}\u{11bf}", "\u{c86c}", "\u{110c}\u{1168}\u{11bf}"), ("\u{c86d}",
        "\u{c86d}", "\u{110c}\u{1168}\u{11c0}", "\u{c86d}", "\u{110c}\u{1168}\u{11c0}"),
        ("\u{c86e}", "\u{c86e}", "\u{110c}\u{1168}\u{11c1}", "\u{c86e}",
        "\u{110c}\u{1168}\u{11c1}"), ("\u{c86f}", "\u{c86f}", "\u{110c}\u{1168}\u{11c2}",
        "\u{c86f}", "\u{110c}\u{1168}\u{11c2}"), ("\u{c870}", "\u{c870}", "\u{110c}\u{1169}",
        "\u{c870}", "\u{110c}\u{1169}"), ("\u{c871}", "\u{c871}", "\u{110c}\u{1169}\u{11a8}",
        "\u{c871}", "\u{110c}\u{1169}\u{11a8}"), ("\u{c872}", "\u{c872}",
        "\u{110c}\u{1169}\u{11a9}", "\u{c872}", "\u{110c}\u{1169}\u{11a9}"), ("\u{c873}",
        "\u{c873}", "\u{110c}\u{1169}\u{11aa}", "\u{c873}", "\u{110c}\u{1169}\u{11aa}"),
        ("\u{c874}", "\u{c874}", "\u{110c}\u{1169}\u{11ab}", "\u{c874}",
        "\u{110c}\u{1169}\u{11ab}"), ("\u{c875}", "\u{c875}", "\u{110c}\u{1169}\u{11ac}",
        "\u{c875}", "\u{110c}\u{1169}\u{11ac}"), ("\u{c876}", "\u{c876}",
        "\u{110c}\u{1169}\u{11ad}", "\u{c876}", "\u{110c}\u{1169}\u{11ad}"), ("\u{c877}",
        "\u{c877}", "\u{110c}\u{1169}\u{11ae}", "\u{c877}", "\u{110c}\u{1169}\u{11ae}"),
        ("\u{c878}", "\u{c878}", "\u{110c}\u{1169}\u{11af}", "\u{c878}",
        "\u{110c}\u{1169}\u{11af}"), ("\u{c879}", "\u{c879}", "\u{110c}\u{1169}\u{11b0}",
        "\u{c879}", "\u{110c}\u{1169}\u{11b0}"), ("\u{c87a}", "\u{c87a}",
        "\u{110c}\u{1169}\u{11b1}", "\u{c87a}", "\u{110c}\u{1169}\u{11b1}"), ("\u{c87b}",
        "\u{c87b}", "\u{110c}\u{1169}\u{11b2}", "\u{c87b}", "\u{110c}\u{1169}\u{11b2}"),
        ("\u{c87c}", "\u{c87c}", "\u{110c}\u{1169}\u{11b3}", "\u{c87c}",
        "\u{110c}\u{1169}\u{11b3}"), ("\u{c87d}", "\u{c87d}", "\u{110c}\u{1169}\u{11b4}",
        "\u{c87d}", "\u{110c}\u{1169}\u{11b4}"), ("\u{c87e}", "\u{c87e}",
        "\u{110c}\u{1169}\u{11b5}", "\u{c87e}", "\u{110c}\u{1169}\u{11b5}"), ("\u{c87f}",
        "\u{c87f}", "\u{110c}\u{1169}\u{11b6}", "\u{c87f}", "\u{110c}\u{1169}\u{11b6}"),
        ("\u{c880}", "\u{c880}", "\u{110c}\u{1169}\u{11b7}", "\u{c880}",
        "\u{110c}\u{1169}\u{11b7}"), ("\u{c881}", "\u{c881}", "\u{110c}\u{1169}\u{11b8}",
        "\u{c881}", "\u{110c}\u{1169}\u{11b8}"), ("\u{c882}", "\u{c882}",
        "\u{110c}\u{1169}\u{11b9}", "\u{c882}", "\u{110c}\u{1169}\u{11b9}"), ("\u{c883}",
        "\u{c883}", "\u{110c}\u{1169}\u{11ba}", "\u{c883}", "\u{110c}\u{1169}\u{11ba}"),
        ("\u{c884}", "\u{c884}", "\u{110c}\u{1169}\u{11bb}", "\u{c884}",
        "\u{110c}\u{1169}\u{11bb}"), ("\u{c885}", "\u{c885}", "\u{110c}\u{1169}\u{11bc}",
        "\u{c885}", "\u{110c}\u{1169}\u{11bc}"), ("\u{c886}", "\u{c886}",
        "\u{110c}\u{1169}\u{11bd}", "\u{c886}", "\u{110c}\u{1169}\u{11bd}"), ("\u{c887}",
        "\u{c887}", "\u{110c}\u{1169}\u{11be}", "\u{c887}", "\u{110c}\u{1169}\u{11be}"),
        ("\u{c888}", "\u{c888}", "\u{110c}\u{1169}\u{11bf}", "\u{c888}",
        "\u{110c}\u{1169}\u{11bf}"), ("\u{c889}", "\u{c889}", "\u{110c}\u{1169}\u{11c0}",
        "\u{c889}", "\u{110c}\u{1169}\u{11c0}"), ("\u{c88a}", "\u{c88a}",
        "\u{110c}\u{1169}\u{11c1}", "\u{c88a}", "\u{110c}\u{1169}\u{11c1}"), ("\u{c88b}",
        "\u{c88b}", "\u{110c}\u{1169}\u{11c2}", "\u{c88b}", "\u{110c}\u{1169}\u{11c2}"),
        ("\u{c88c}", "\u{c88c}", "\u{110c}\u{116a}", "\u{c88c}", "\u{110c}\u{116a}"), ("\u{c88d}",
        "\u{c88d}", "\u{110c}\u{116a}\u{11a8}", "\u{c88d}", "\u{110c}\u{116a}\u{11a8}"),
        ("\u{c88e}", "\u{c88e}", "\u{110c}\u{116a}\u{11a9}", "\u{c88e}",
        "\u{110c}\u{116a}\u{11a9}"), ("\u{c88f}", "\u{c88f}", "\u{110c}\u{116a}\u{11aa}",
        "\u{c88f}", "\u{110c}\u{116a}\u{11aa}"), ("\u{c890}", "\u{c890}",
        "\u{110c}\u{116a}\u{11ab}", "\u{c890}", "\u{110c}\u{116a}\u{11ab}"), ("\u{c891}",
        "\u{c891}", "\u{110c}\u{116a}\u{11ac}", "\u{c891}", "\u{110c}\u{116a}\u{11ac}"),
        ("\u{c892}", "\u{c892}", "\u{110c}\u{116a}\u{11ad}", "\u{c892}",
        "\u{110c}\u{116a}\u{11ad}"), ("\u{c893}", "\u{c893}", "\u{110c}\u{116a}\u{11ae}",
        "\u{c893}", "\u{110c}\u{116a}\u{11ae}"), ("\u{c894}", "\u{c894}",
        "\u{110c}\u{116a}\u{11af}", "\u{c894}", "\u{110c}\u{116a}\u{11af}"), ("\u{c895}",
        "\u{c895}", "\u{110c}\u{116a}\u{11b0}", "\u{c895}", "\u{110c}\u{116a}\u{11b0}"),
        ("\u{c896}", "\u{c896}", "\u{110c}\u{116a}\u{11b1}", "\u{c896}",
        "\u{110c}\u{116a}\u{11b1}"), ("\u{c897}", "\u{c897}", "\u{110c}\u{116a}\u{11b2}",
        "\u{c897}", "\u{110c}\u{116a}\u{11b2}"), ("\u{c898}", "\u{c898}",
        "\u{110c}\u{116a}\u{11b3}", "\u{c898}", "\u{110c}\u{116a}\u{11b3}"), ("\u{c899}",
        "\u{c899}", "\u{110c}\u{116a}\u{11b4}", "\u{c899}", "\u{110c}\u{116a}\u{11b4}"),
        ("\u{c89a}", "\u{c89a}", "\u{110c}\u{116a}\u{11b5}", "\u{c89a}",
        "\u{110c}\u{116a}\u{11b5}"), ("\u{c89b}", "\u{c89b}", "\u{110c}\u{116a}\u{11b6}",
        "\u{c89b}", "\u{110c}\u{116a}\u{11b6}"), ("\u{c89c}", "\u{c89c}",
        "\u{110c}\u{116a}\u{11b7}", "\u{c89c}", "\u{110c}\u{116a}\u{11b7}"), ("\u{c89d}",
        "\u{c89d}", "\u{110c}\u{116a}\u{11b8}", "\u{c89d}", "\u{110c}\u{116a}\u{11b8}"),
        ("\u{c89e}", "\u{c89e}", "\u{110c}\u{116a}\u{11b9}", "\u{c89e}",
        "\u{110c}\u{116a}\u{11b9}"), ("\u{c89f}", "\u{c89f}", "\u{110c}\u{116a}\u{11ba}",
        "\u{c89f}", "\u{110c}\u{116a}\u{11ba}"), ("\u{c8a0}", "\u{c8a0}",
        "\u{110c}\u{116a}\u{11bb}", "\u{c8a0}", "\u{110c}\u{116a}\u{11bb}"), ("\u{c8a1}",
        "\u{c8a1}", "\u{110c}\u{116a}\u{11bc}", "\u{c8a1}", "\u{110c}\u{116a}\u{11bc}"),
        ("\u{c8a2}", "\u{c8a2}", "\u{110c}\u{116a}\u{11bd}", "\u{c8a2}",
        "\u{110c}\u{116a}\u{11bd}"), ("\u{c8a3}", "\u{c8a3}", "\u{110c}\u{116a}\u{11be}",
        "\u{c8a3}", "\u{110c}\u{116a}\u{11be}"), ("\u{c8a4}", "\u{c8a4}",
        "\u{110c}\u{116a}\u{11bf}", "\u{c8a4}", "\u{110c}\u{116a}\u{11bf}"), ("\u{c8a5}",
        "\u{c8a5}", "\u{110c}\u{116a}\u{11c0}", "\u{c8a5}", "\u{110c}\u{116a}\u{11c0}"),
        ("\u{c8a6}", "\u{c8a6}", "\u{110c}\u{116a}\u{11c1}", "\u{c8a6}",
        "\u{110c}\u{116a}\u{11c1}"), ("\u{c8a7}", "\u{c8a7}", "\u{110c}\u{116a}\u{11c2}",
        "\u{c8a7}", "\u{110c}\u{116a}\u{11c2}"), ("\u{c8a8}", "\u{c8a8}", "\u{110c}\u{116b}",
        "\u{c8a8}", "\u{110c}\u{116b}"), ("\u{c8a9}", "\u{c8a9}", "\u{110c}\u{116b}\u{11a8}",
        "\u{c8a9}", "\u{110c}\u{116b}\u{11a8}"), ("\u{c8aa}", "\u{c8aa}",
        "\u{110c}\u{116b}\u{11a9}", "\u{c8aa}", "\u{110c}\u{116b}\u{11a9}"), ("\u{c8ab}",
        "\u{c8ab}", "\u{110c}\u{116b}\u{11aa}", "\u{c8ab}", "\u{110c}\u{116b}\u{11aa}"),
        ("\u{c8ac}", "\u{c8ac}", "\u{110c}\u{116b}\u{11ab}", "\u{c8ac}",
        "\u{110c}\u{116b}\u{11ab}"), ("\u{c8ad}", "\u{c8ad}", "\u{110c}\u{116b}\u{11ac}",
        "\u{c8ad}", "\u{110c}\u{116b}\u{11ac}"), ("\u{c8ae}", "\u{c8ae}",
        "\u{110c}\u{116b}\u{11ad}", "\u{c8ae}", "\u{110c}\u{116b}\u{11ad}"), ("\u{c8af}",
        "\u{c8af}", "\u{110c}\u{116b}\u{11ae}", "\u{c8af}", "\u{110c}\u{116b}\u{11ae}"),
        ("\u{c8b0}", "\u{c8b0}", "\u{110c}\u{116b}\u{11af}", "\u{c8b0}",
        "\u{110c}\u{116b}\u{11af}"), ("\u{c8b1}", "\u{c8b1}", "\u{110c}\u{116b}\u{11b0}",
        "\u{c8b1}", "\u{110c}\u{116b}\u{11b0}"), ("\u{c8b2}", "\u{c8b2}",
        "\u{110c}\u{116b}\u{11b1}", "\u{c8b2}", "\u{110c}\u{116b}\u{11b1}"), ("\u{c8b3}",
        "\u{c8b3}", "\u{110c}\u{116b}\u{11b2}", "\u{c8b3}", "\u{110c}\u{116b}\u{11b2}"),
        ("\u{c8b4}", "\u{c8b4}", "\u{110c}\u{116b}\u{11b3}", "\u{c8b4}",
        "\u{110c}\u{116b}\u{11b3}"), ("\u{c8b5}", "\u{c8b5}", "\u{110c}\u{116b}\u{11b4}",
        "\u{c8b5}", "\u{110c}\u{116b}\u{11b4}"), ("\u{c8b6}", "\u{c8b6}",
        "\u{110c}\u{116b}\u{11b5}", "\u{c8b6}", "\u{110c}\u{116b}\u{11b5}"), ("\u{c8b7}",
        "\u{c8b7}", "\u{110c}\u{116b}\u{11b6}", "\u{c8b7}", "\u{110c}\u{116b}\u{11b6}"),
        ("\u{c8b8}", "\u{c8b8}", "\u{110c}\u{116b}\u{11b7}", "\u{c8b8}",
        "\u{110c}\u{116b}\u{11b7}"), ("\u{c8b9}", "\u{c8b9}", "\u{110c}\u{116b}\u{11b8}",
        "\u{c8b9}", "\u{110c}\u{116b}\u{11b8}"), ("\u{c8ba}", "\u{c8ba}",
        "\u{110c}\u{116b}\u{11b9}", "\u{c8ba}", "\u{110c}\u{116b}\u{11b9}"), ("\u{c8bb}",
        "\u{c8bb}", "\u{110c}\u{116b}\u{11ba}", "\u{c8bb}", "\u{110c}\u{116b}\u{11ba}"),
        ("\u{c8bc}", "\u{c8bc}", "\u{110c}\u{116b}\u{11bb}", "\u{c8bc}",
        "\u{110c}\u{116b}\u{11bb}"), ("\u{c8bd}", "\u{c8bd}", "\u{110c}\u{116b}\u{11bc}",
        "\u{c8bd}", "\u{110c}\u{116b}\u{11bc}"), ("\u{c8be}", "\u{c8be}",
        "\u{110c}\u{116b}\u{11bd}", "\u{c8be}", "\u{110c}\u{116b}\u{11bd}"), ("\u{c8bf}",
        "\u{c8bf}", "\u{110c}\u{116b}\u{11be}", "\u{c8bf}", "\u{110c}\u{116b}\u{11be}"),
        ("\u{c8c0}", "\u{c8c0}", "\u{110c}\u{116b}\u{11bf}", "\u{c8c0}",
        "\u{110c}\u{116b}\u{11bf}"), ("\u{c8c1}", "\u{c8c1}", "\u{110c}\u{116b}\u{11c0}",
        "\u{c8c1}", "\u{110c}\u{116b}\u{11c0}"), ("\u{c8c2}", "\u{c8c2}",
        "\u{110c}\u{116b}\u{11c1}", "\u{c8c2}", "\u{110c}\u{116b}\u{11c1}"), ("\u{c8c3}",
        "\u{c8c3}", "\u{110c}\u{116b}\u{11c2}", "\u{c8c3}", "\u{110c}\u{116b}\u{11c2}"),
        ("\u{c8c4}", "\u{c8c4}", "\u{110c}\u{116c}", "\u{c8c4}", "\u{110c}\u{116c}"), ("\u{c8c5}",
        "\u{c8c5}", "\u{110c}\u{116c}\u{11a8}", "\u{c8c5}", "\u{110c}\u{116c}\u{11a8}"),
        ("\u{c8c6}", "\u{c8c6}", "\u{110c}\u{116c}\u{11a9}", "\u{c8c6}",
        "\u{110c}\u{116c}\u{11a9}"), ("\u{c8c7}", "\u{c8c7}", "\u{110c}\u{116c}\u{11aa}",
        "\u{c8c7}", "\u{110c}\u{116c}\u{11aa}"), ("\u{c8c8}", "\u{c8c8}",
        "\u{110c}\u{116c}\u{11ab}", "\u{c8c8}", "\u{110c}\u{116c}\u{11ab}"), ("\u{c8c9}",
        "\u{c8c9}", "\u{110c}\u{116c}\u{11ac}", "\u{c8c9}", "\u{110c}\u{116c}\u{11ac}"),
        ("\u{c8ca}", "\u{c8ca}", "\u{110c}\u{116c}\u{11ad}", "\u{c8ca}",
        "\u{110c}\u{116c}\u{11ad}"), ("\u{c8cb}", "\u{c8cb}", "\u{110c}\u{116c}\u{11ae}",
        "\u{c8cb}", "\u{110c}\u{116c}\u{11ae}"), ("\u{c8cc}", "\u{c8cc}",
        "\u{110c}\u{116c}\u{11af}", "\u{c8cc}", "\u{110c}\u{116c}\u{11af}"), ("\u{c8cd}",
        "\u{c8cd}", "\u{110c}\u{116c}\u{11b0}", "\u{c8cd}", "\u{110c}\u{116c}\u{11b0}"),
        ("\u{c8ce}", "\u{c8ce}", "\u{110c}\u{116c}\u{11b1}", "\u{c8ce}",
        "\u{110c}\u{116c}\u{11b1}"), ("\u{c8cf}", "\u{c8cf}", "\u{110c}\u{116c}\u{11b2}",
        "\u{c8cf}", "\u{110c}\u{116c}\u{11b2}"), ("\u{c8d0}", "\u{c8d0}",
        "\u{110c}\u{116c}\u{11b3}", "\u{c8d0}", "\u{110c}\u{116c}\u{11b3}"), ("\u{c8d1}",
        "\u{c8d1}", "\u{110c}\u{116c}\u{11b4}", "\u{c8d1}", "\u{110c}\u{116c}\u{11b4}"),
        ("\u{c8d2}", "\u{c8d2}", "\u{110c}\u{116c}\u{11b5}", "\u{c8d2}",
        "\u{110c}\u{116c}\u{11b5}"), ("\u{c8d3}", "\u{c8d3}", "\u{110c}\u{116c}\u{11b6}",
        "\u{c8d3}", "\u{110c}\u{116c}\u{11b6}"), ("\u{c8d4}", "\u{c8d4}",
        "\u{110c}\u{116c}\u{11b7}", "\u{c8d4}", "\u{110c}\u{116c}\u{11b7}"), ("\u{c8d5}",
        "\u{c8d5}", "\u{110c}\u{116c}\u{11b8}", "\u{c8d5}", "\u{110c}\u{116c}\u{11b8}"),
        ("\u{c8d6}", "\u{c8d6}", "\u{110c}\u{116c}\u{11b9}", "\u{c8d6}",
        "\u{110c}\u{116c}\u{11b9}"), ("\u{c8d7}", "\u{c8d7}", "\u{110c}\u{116c}\u{11ba}",
        "\u{c8d7}", "\u{110c}\u{116c}\u{11ba}"), ("\u{c8d8}", "\u{c8d8}",
        "\u{110c}\u{116c}\u{11bb}", "\u{c8d8}", "\u{110c}\u{116c}\u{11bb}"), ("\u{c8d9}",
        "\u{c8d9}", "\u{110c}\u{116c}\u{11bc}", "\u{c8d9}", "\u{110c}\u{116c}\u{11bc}"),
        ("\u{c8da}", "\u{c8da}", "\u{110c}\u{116c}\u{11bd}", "\u{c8da}",
        "\u{110c}\u{116c}\u{11bd}"), ("\u{c8db}", "\u{c8db}", "\u{110c}\u{116c}\u{11be}",
        "\u{c8db}", "\u{110c}\u{116c}\u{11be}"), ("\u{c8dc}", "\u{c8dc}",
        "\u{110c}\u{116c}\u{11bf}", "\u{c8dc}", "\u{110c}\u{116c}\u{11bf}"), ("\u{c8dd}",
        "\u{c8dd}", "\u{110c}\u{116c}\u{11c0}", "\u{c8dd}", "\u{110c}\u{116c}\u{11c0}"),
        ("\u{c8de}", "\u{c8de}", "\u{110c}\u{116c}\u{11c1}", "\u{c8de}",
        "\u{110c}\u{116c}\u{11c1}"), ("\u{c8df}", "\u{c8df}", "\u{110c}\u{116c}\u{11c2}",
        "\u{c8df}", "\u{110c}\u{116c}\u{11c2}"), ("\u{c8e0}", "\u{c8e0}", "\u{110c}\u{116d}",
        "\u{c8e0}", "\u{110c}\u{116d}"), ("\u{c8e1}", "\u{c8e1}", "\u{110c}\u{116d}\u{11a8}",
        "\u{c8e1}", "\u{110c}\u{116d}\u{11a8}"), ("\u{c8e2}", "\u{c8e2}",
        "\u{110c}\u{116d}\u{11a9}", "\u{c8e2}", "\u{110c}\u{116d}\u{11a9}"), ("\u{c8e3}",
        "\u{c8e3}", "\u{110c}\u{116d}\u{11aa}", "\u{c8e3}", "\u{110c}\u{116d}\u{11aa}"),
        ("\u{c8e4}", "\u{c8e4}", "\u{110c}\u{116d}\u{11ab}", "\u{c8e4}",
        "\u{110c}\u{116d}\u{11ab}"), ("\u{c8e5}", "\u{c8e5}", "\u{110c}\u{116d}\u{11ac}",
        "\u{c8e5}", "\u{110c}\u{116d}\u{11ac}"), ("\u{c8e6}", "\u{c8e6}",
        "\u{110c}\u{116d}\u{11ad}", "\u{c8e6}", "\u{110c}\u{116d}\u{11ad}"), ("\u{c8e7}",
        "\u{c8e7}", "\u{110c}\u{116d}\u{11ae}", "\u{c8e7}", "\u{110c}\u{116d}\u{11ae}"),
        ("\u{c8e8}", "\u{c8e8}", "\u{110c}\u{116d}\u{11af}", "\u{c8e8}",
        "\u{110c}\u{116d}\u{11af}"), ("\u{c8e9}", "\u{c8e9}", "\u{110c}\u{116d}\u{11b0}",
        "\u{c8e9}", "\u{110c}\u{116d}\u{11b0}"), ("\u{c8ea}", "\u{c8ea}",
        "\u{110c}\u{116d}\u{11b1}", "\u{c8ea}", "\u{110c}\u{116d}\u{11b1}"), ("\u{c8eb}",
        "\u{c8eb}", "\u{110c}\u{116d}\u{11b2}", "\u{c8eb}", "\u{110c}\u{116d}\u{11b2}"),
        ("\u{c8ec}", "\u{c8ec}", "\u{110c}\u{116d}\u{11b3}", "\u{c8ec}",
        "\u{110c}\u{116d}\u{11b3}"), ("\u{c8ed}", "\u{c8ed}", "\u{110c}\u{116d}\u{11b4}",
        "\u{c8ed}", "\u{110c}\u{116d}\u{11b4}"), ("\u{c8ee}", "\u{c8ee}",
        "\u{110c}\u{116d}\u{11b5}", "\u{c8ee}", "\u{110c}\u{116d}\u{11b5}"), ("\u{c8ef}",
        "\u{c8ef}", "\u{110c}\u{116d}\u{11b6}", "\u{c8ef}", "\u{110c}\u{116d}\u{11b6}"),
        ("\u{c8f0}", "\u{c8f0}", "\u{110c}\u{116d}\u{11b7}", "\u{c8f0}",
        "\u{110c}\u{116d}\u{11b7}"), ("\u{c8f1}", "\u{c8f1}", "\u{110c}\u{116d}\u{11b8}",
        "\u{c8f1}", "\u{110c}\u{116d}\u{11b8}"), ("\u{c8f2}", "\u{c8f2}",
        "\u{110c}\u{116d}\u{11b9}", "\u{c8f2}", "\u{110c}\u{116d}\u{11b9}"), ("\u{c8f3}",
        "\u{c8f3}", "\u{110c}\u{116d}\u{11ba}", "\u{c8f3}", "\u{110c}\u{116d}\u{11ba}"),
        ("\u{c8f4}", "\u{c8f4}", "\u{110c}\u{116d}\u{11bb}", "\u{c8f4}",
        "\u{110c}\u{116d}\u{11bb}"), ("\u{c8f5}", "\u{c8f5}", "\u{110c}\u{116d}\u{11bc}",
        "\u{c8f5}", "\u{110c}\u{116d}\u{11bc}"), ("\u{c8f6}", "\u{c8f6}",
        "\u{110c}\u{116d}\u{11bd}", "\u{c8f6}", "\u{110c}\u{116d}\u{11bd}"), ("\u{c8f7}",
        "\u{c8f7}", "\u{110c}\u{116d}\u{11be}", "\u{c8f7}", "\u{110c}\u{116d}\u{11be}"),
        ("\u{c8f8}", "\u{c8f8}", "\u{110c}\u{116d}\u{11bf}", "\u{c8f8}",
        "\u{110c}\u{116d}\u{11bf}"), ("\u{c8f9}", "\u{c8f9}", "\u{110c}\u{116d}\u{11c0}",
        "\u{c8f9}", "\u{110c}\u{116d}\u{11c0}"), ("\u{c8fa}", "\u{c8fa}",
        "\u{110c}\u{116d}\u{11c1}", "\u{c8fa}", "\u{110c}\u{116d}\u{11c1}"), ("\u{c8fb}",
        "\u{c8fb}", "\u{110c}\u{116d}\u{11c2}", "\u{c8fb}", "\u{110c}\u{116d}\u{11c2}"),
        ("\u{c8fc}", "\u{c8fc}", "\u{110c}\u{116e}", "\u{c8fc}", "\u{110c}\u{116e}"), ("\u{c8fd}",
        "\u{c8fd}", "\u{110c}\u{116e}\u{11a8}", "\u{c8fd}", "\u{110c}\u{116e}\u{11a8}"),
        ("\u{c8fe}", "\u{c8fe}", "\u{110c}\u{116e}\u{11a9}", "\u{c8fe}",
        "\u{110c}\u{116e}\u{11a9}"), ("\u{c8ff}", "\u{c8ff}", "\u{110c}\u{116e}\u{11aa}",
        "\u{c8ff}", "\u{110c}\u{116e}\u{11aa}"), ("\u{c900}", "\u{c900}",
        "\u{110c}\u{116e}\u{11ab}", "\u{c900}", "\u{110c}\u{116e}\u{11ab}"), ("\u{c901}",
        "\u{c901}", "\u{110c}\u{116e}\u{11ac}", "\u{c901}", "\u{110c}\u{116e}\u{11ac}"),
        ("\u{c902}", "\u{c902}", "\u{110c}\u{116e}\u{11ad}", "\u{c902}",
        "\u{110c}\u{116e}\u{11ad}"), ("\u{c903}", "\u{c903}", "\u{110c}\u{116e}\u{11ae}",
        "\u{c903}", "\u{110c}\u{116e}\u{11ae}"), ("\u{c904}", "\u{c904}",
        "\u{110c}\u{116e}\u{11af}", "\u{c904}", "\u{110c}\u{116e}\u{11af}"), ("\u{c905}",
        "\u{c905}", "\u{110c}\u{116e}\u{11b0}", "\u{c905}", "\u{110c}\u{116e}\u{11b0}"),
        ("\u{c906}", "\u{c906}", "\u{110c}\u{116e}\u{11b1}", "\u{c906}",
        "\u{110c}\u{116e}\u{11b1}"), ("\u{c907}", "\u{c907}", "\u{110c}\u{116e}\u{11b2}",
        "\u{c907}", "\u{110c}\u{116e}\u{11b2}"), ("\u{c908}", "\u{c908}",
        "\u{110c}\u{116e}\u{11b3}", "\u{c908}", "\u{110c}\u{116e}\u{11b3}"), ("\u{c909}",
        "\u{c909}", "\u{110c}\u{116e}\u{11b4}", "\u{c909}", "\u{110c}\u{116e}\u{11b4}"),
        ("\u{c90a}", "\u{c90a}", "\u{110c}\u{116e}\u{11b5}", "\u{c90a}",
        "\u{110c}\u{116e}\u{11b5}"), ("\u{c90b}", "\u{c90b}", "\u{110c}\u{116e}\u{11b6}",
        "\u{c90b}", "\u{110c}\u{116e}\u{11b6}"), ("\u{c90c}", "\u{c90c}",
        "\u{110c}\u{116e}\u{11b7}", "\u{c90c}", "\u{110c}\u{116e}\u{11b7}"), ("\u{c90d}",
        "\u{c90d}", "\u{110c}\u{116e}\u{11b8}", "\u{c90d}", "\u{110c}\u{116e}\u{11b8}"),
        ("\u{c90e}", "\u{c90e}", "\u{110c}\u{116e}\u{11b9}", "\u{c90e}",
        "\u{110c}\u{116e}\u{11b9}"), ("\u{c90f}", "\u{c90f}", "\u{110c}\u{116e}\u{11ba}",
        "\u{c90f}", "\u{110c}\u{116e}\u{11ba}"), ("\u{c910}", "\u{c910}",
        "\u{110c}\u{116e}\u{11bb}", "\u{c910}", "\u{110c}\u{116e}\u{11bb}"), ("\u{c911}",
        "\u{c911}", "\u{110c}\u{116e}\u{11bc}", "\u{c911}", "\u{110c}\u{116e}\u{11bc}"),
        ("\u{c912}", "\u{c912}", "\u{110c}\u{116e}\u{11bd}", "\u{c912}",
        "\u{110c}\u{116e}\u{11bd}"), ("\u{c913}", "\u{c913}", "\u{110c}\u{116e}\u{11be}",
        "\u{c913}", "\u{110c}\u{116e}\u{11be}"), ("\u{c914}", "\u{c914}",
        "\u{110c}\u{116e}\u{11bf}", "\u{c914}", "\u{110c}\u{116e}\u{11bf}"), ("\u{c915}",
        "\u{c915}", "\u{110c}\u{116e}\u{11c0}", "\u{c915}", "\u{110c}\u{116e}\u{11c0}"),
        ("\u{c916}", "\u{c916}", "\u{110c}\u{116e}\u{11c1}", "\u{c916}",
        "\u{110c}\u{116e}\u{11c1}"), ("\u{c917}", "\u{c917}", "\u{110c}\u{116e}\u{11c2}",
        "\u{c917}", "\u{110c}\u{116e}\u{11c2}"), ("\u{c918}", "\u{c918}", "\u{110c}\u{116f}",
        "\u{c918}", "\u{110c}\u{116f}"), ("\u{c919}", "\u{c919}", "\u{110c}\u{116f}\u{11a8}",
        "\u{c919}", "\u{110c}\u{116f}\u{11a8}"), ("\u{c91a}", "\u{c91a}",
        "\u{110c}\u{116f}\u{11a9}", "\u{c91a}", "\u{110c}\u{116f}\u{11a9}"), ("\u{c91b}",
        "\u{c91b}", "\u{110c}\u{116f}\u{11aa}", "\u{c91b}", "\u{110c}\u{116f}\u{11aa}"),
        ("\u{c91c}", "\u{c91c}", "\u{110c}\u{116f}\u{11ab}", "\u{c91c}",
        "\u{110c}\u{116f}\u{11ab}"), ("\u{c91d}", "\u{c91d}", "\u{110c}\u{116f}\u{11ac}",
        "\u{c91d}", "\u{110c}\u{116f}\u{11ac}"), ("\u{c91e}", "\u{c91e}",
        "\u{110c}\u{116f}\u{11ad}", "\u{c91e}", "\u{110c}\u{116f}\u{11ad}"), ("\u{c91f}",
        "\u{c91f}", "\u{110c}\u{116f}\u{11ae}", "\u{c91f}", "\u{110c}\u{116f}\u{11ae}"),
        ("\u{c920}", "\u{c920}", "\u{110c}\u{116f}\u{11af}", "\u{c920}",
        "\u{110c}\u{116f}\u{11af}"), ("\u{c921}", "\u{c921}", "\u{110c}\u{116f}\u{11b0}",
        "\u{c921}", "\u{110c}\u{116f}\u{11b0}"), ("\u{c922}", "\u{c922}",
        "\u{110c}\u{116f}\u{11b1}", "\u{c922}", "\u{110c}\u{116f}\u{11b1}"), ("\u{c923}",
        "\u{c923}", "\u{110c}\u{116f}\u{11b2}", "\u{c923}", "\u{110c}\u{116f}\u{11b2}"),
        ("\u{c924}", "\u{c924}", "\u{110c}\u{116f}\u{11b3}", "\u{c924}",
        "\u{110c}\u{116f}\u{11b3}"), ("\u{c925}", "\u{c925}", "\u{110c}\u{116f}\u{11b4}",
        "\u{c925}", "\u{110c}\u{116f}\u{11b4}"), ("\u{c926}", "\u{c926}",
        "\u{110c}\u{116f}\u{11b5}", "\u{c926}", "\u{110c}\u{116f}\u{11b5}"), ("\u{c927}",
        "\u{c927}", "\u{110c}\u{116f}\u{11b6}", "\u{c927}", "\u{110c}\u{116f}\u{11b6}"),
        ("\u{c928}", "\u{c928}", "\u{110c}\u{116f}\u{11b7}", "\u{c928}",
        "\u{110c}\u{116f}\u{11b7}"), ("\u{c929}", "\u{c929}", "\u{110c}\u{116f}\u{11b8}",
        "\u{c929}", "\u{110c}\u{116f}\u{11b8}"), ("\u{c92a}", "\u{c92a}",
        "\u{110c}\u{116f}\u{11b9}", "\u{c92a}", "\u{110c}\u{116f}\u{11b9}"), ("\u{c92b}",
        "\u{c92b}", "\u{110c}\u{116f}\u{11ba}", "\u{c92b}", "\u{110c}\u{116f}\u{11ba}"),
        ("\u{c92c}", "\u{c92c}", "\u{110c}\u{116f}\u{11bb}", "\u{c92c}",
        "\u{110c}\u{116f}\u{11bb}"), ("\u{c92d}", "\u{c92d}", "\u{110c}\u{116f}\u{11bc}",
        "\u{c92d}", "\u{110c}\u{116f}\u{11bc}"), ("\u{c92e}", "\u{c92e}",
        "\u{110c}\u{116f}\u{11bd}", "\u{c92e}", "\u{110c}\u{116f}\u{11bd}"), ("\u{c92f}",
        "\u{c92f}", "\u{110c}\u{116f}\u{11be}", "\u{c92f}", "\u{110c}\u{116f}\u{11be}"),
        ("\u{c930}", "\u{c930}", "\u{110c}\u{116f}\u{11bf}", "\u{c930}",
        "\u{110c}\u{116f}\u{11bf}"), ("\u{c931}", "\u{c931}", "\u{110c}\u{116f}\u{11c0}",
        "\u{c931}", "\u{110c}\u{116f}\u{11c0}"), ("\u{c932}", "\u{c932}",
        "\u{110c}\u{116f}\u{11c1}", "\u{c932}", "\u{110c}\u{116f}\u{11c1}"), ("\u{c933}",
        "\u{c933}", "\u{110c}\u{116f}\u{11c2}", "\u{c933}", "\u{110c}\u{116f}\u{11c2}"),
        ("\u{c934}", "\u{c934}", "\u{110c}\u{1170}", "\u{c934}", "\u{110c}\u{1170}"), ("\u{c935}",
        "\u{c935}", "\u{110c}\u{1170}\u{11a8}", "\u{c935}", "\u{110c}\u{1170}\u{11a8}"),
        ("\u{c936}", "\u{c936}", "\u{110c}\u{1170}\u{11a9}", "\u{c936}",
        "\u{110c}\u{1170}\u{11a9}"), ("\u{c937}", "\u{c937}", "\u{110c}\u{1170}\u{11aa}",
        "\u{c937}", "\u{110c}\u{1170}\u{11aa}"), ("\u{c938}", "\u{c938}",
        "\u{110c}\u{1170}\u{11ab}", "\u{c938}", "\u{110c}\u{1170}\u{11ab}"), ("\u{c939}",
        "\u{c939}", "\u{110c}\u{1170}\u{11ac}", "\u{c939}", "\u{110c}\u{1170}\u{11ac}"),
        ("\u{c93a}", "\u{c93a}", "\u{110c}\u{1170}\u{11ad}", "\u{c93a}",
        "\u{110c}\u{1170}\u{11ad}"), ("\u{c93b}", "\u{c93b}", "\u{110c}\u{1170}\u{11ae}",
        "\u{c93b}", "\u{110c}\u{1170}\u{11ae}"), ("\u{c93c}", "\u{c93c}",
        "\u{110c}\u{1170}\u{11af}", "\u{c93c}", "\u{110c}\u{1170}\u{11af}"), ("\u{c93d}",
        "\u{c93d}", "\u{110c}\u{1170}\u{11b0}", "\u{c93d}", "\u{110c}\u{1170}\u{11b0}"),
        ("\u{c93e}", "\u{c93e}", "\u{110c}\u{1170}\u{11b1}", "\u{c93e}",
        "\u{110c}\u{1170}\u{11b1}"), ("\u{c93f}", "\u{c93f}", "\u{110c}\u{1170}\u{11b2}",
        "\u{c93f}", "\u{110c}\u{1170}\u{11b2}"), ("\u{c940}", "\u{c940}",
        "\u{110c}\u{1170}\u{11b3}", "\u{c940}", "\u{110c}\u{1170}\u{11b3}"), ("\u{c941}",
        "\u{c941}", "\u{110c}\u{1170}\u{11b4}", "\u{c941}", "\u{110c}\u{1170}\u{11b4}"),
        ("\u{c942}", "\u{c942}", "\u{110c}\u{1170}\u{11b5}", "\u{c942}",
        "\u{110c}\u{1170}\u{11b5}"), ("\u{c943}", "\u{c943}", "\u{110c}\u{1170}\u{11b6}",
        "\u{c943}", "\u{110c}\u{1170}\u{11b6}"), ("\u{c944}", "\u{c944}",
        "\u{110c}\u{1170}\u{11b7}", "\u{c944}", "\u{110c}\u{1170}\u{11b7}"), ("\u{c945}",
        "\u{c945}", "\u{110c}\u{1170}\u{11b8}", "\u{c945}", "\u{110c}\u{1170}\u{11b8}"),
        ("\u{c946}", "\u{c946}", "\u{110c}\u{1170}\u{11b9}", "\u{c946}",
        "\u{110c}\u{1170}\u{11b9}"), ("\u{c947}", "\u{c947}", "\u{110c}\u{1170}\u{11ba}",
        "\u{c947}", "\u{110c}\u{1170}\u{11ba}"), ("\u{c948}", "\u{c948}",
        "\u{110c}\u{1170}\u{11bb}", "\u{c948}", "\u{110c}\u{1170}\u{11bb}"), ("\u{c949}",
        "\u{c949}", "\u{110c}\u{1170}\u{11bc}", "\u{c949}", "\u{110c}\u{1170}\u{11bc}"),
        ("\u{c94a}", "\u{c94a}", "\u{110c}\u{1170}\u{11bd}", "\u{c94a}",
        "\u{110c}\u{1170}\u{11bd}"), ("\u{c94b}", "\u{c94b}", "\u{110c}\u{1170}\u{11be}",
        "\u{c94b}", "\u{110c}\u{1170}\u{11be}"), ("\u{c94c}", "\u{c94c}",
        "\u{110c}\u{1170}\u{11bf}", "\u{c94c}", "\u{110c}\u{1170}\u{11bf}"), ("\u{c94d}",
        "\u{c94d}", "\u{110c}\u{1170}\u{11c0}", "\u{c94d}", "\u{110c}\u{1170}\u{11c0}"),
        ("\u{c94e}", "\u{c94e}", "\u{110c}\u{1170}\u{11c1}", "\u{c94e}",
        "\u{110c}\u{1170}\u{11c1}"), ("\u{c94f}", "\u{c94f}", "\u{110c}\u{1170}\u{11c2}",
        "\u{c94f}", "\u{110c}\u{1170}\u{11c2}"), ("\u{c950}", "\u{c950}", "\u{110c}\u{1171}",
        "\u{c950}", "\u{110c}\u{1171}"), ("\u{c951}", "\u{c951}", "\u{110c}\u{1171}\u{11a8}",
        "\u{c951}", "\u{110c}\u{1171}\u{11a8}"), ("\u{c952}", "\u{c952}",
        "\u{110c}\u{1171}\u{11a9}", "\u{c952}", "\u{110c}\u{1171}\u{11a9}"), ("\u{c953}",
        "\u{c953}", "\u{110c}\u{1171}\u{11aa}", "\u{c953}", "\u{110c}\u{1171}\u{11aa}"),
        ("\u{c954}", "\u{c954}", "\u{110c}\u{1171}\u{11ab}", "\u{c954}",
        "\u{110c}\u{1171}\u{11ab}"), ("\u{c955}", "\u{c955}", "\u{110c}\u{1171}\u{11ac}",
        "\u{c955}", "\u{110c}\u{1171}\u{11ac}"), ("\u{c956}", "\u{c956}",
        "\u{110c}\u{1171}\u{11ad}", "\u{c956}", "\u{110c}\u{1171}\u{11ad}"), ("\u{c957}",
        "\u{c957}", "\u{110c}\u{1171}\u{11ae}", "\u{c957}", "\u{110c}\u{1171}\u{11ae}"),
        ("\u{c958}", "\u{c958}", "\u{110c}\u{1171}\u{11af}", "\u{c958}",
        "\u{110c}\u{1171}\u{11af}"), ("\u{c959}", "\u{c959}", "\u{110c}\u{1171}\u{11b0}",
        "\u{c959}", "\u{110c}\u{1171}\u{11b0}"), ("\u{c95a}", "\u{c95a}",
        "\u{110c}\u{1171}\u{11b1}", "\u{c95a}", "\u{110c}\u{1171}\u{11b1}"), ("\u{c95b}",
        "\u{c95b}", "\u{110c}\u{1171}\u{11b2}", "\u{c95b}", "\u{110c}\u{1171}\u{11b2}"),
        ("\u{c95c}", "\u{c95c}", "\u{110c}\u{1171}\u{11b3}", "\u{c95c}",
        "\u{110c}\u{1171}\u{11b3}"), ("\u{c95d}", "\u{c95d}", "\u{110c}\u{1171}\u{11b4}",
        "\u{c95d}", "\u{110c}\u{1171}\u{11b4}"), ("\u{c95e}", "\u{c95e}",
        "\u{110c}\u{1171}\u{11b5}", "\u{c95e}", "\u{110c}\u{1171}\u{11b5}"), ("\u{c95f}",
        "\u{c95f}", "\u{110c}\u{1171}\u{11b6}", "\u{c95f}", "\u{110c}\u{1171}\u{11b6}"),
        ("\u{c960}", "\u{c960}", "\u{110c}\u{1171}\u{11b7}", "\u{c960}",
        "\u{110c}\u{1171}\u{11b7}"), ("\u{c961}", "\u{c961}", "\u{110c}\u{1171}\u{11b8}",
        "\u{c961}", "\u{110c}\u{1171}\u{11b8}"), ("\u{c962}", "\u{c962}",
        "\u{110c}\u{1171}\u{11b9}", "\u{c962}", "\u{110c}\u{1171}\u{11b9}"), ("\u{c963}",
        "\u{c963}", "\u{110c}\u{1171}\u{11ba}", "\u{c963}", "\u{110c}\u{1171}\u{11ba}"),
        ("\u{c964}", "\u{c964}", "\u{110c}\u{1171}\u{11bb}", "\u{c964}",
        "\u{110c}\u{1171}\u{11bb}"), ("\u{c965}", "\u{c965}", "\u{110c}\u{1171}\u{11bc}",
        "\u{c965}", "\u{110c}\u{1171}\u{11bc}"), ("\u{c966}", "\u{c966}",
        "\u{110c}\u{1171}\u{11bd}", "\u{c966}", "\u{110c}\u{1171}\u{11bd}"), ("\u{c967}",
        "\u{c967}", "\u{110c}\u{1171}\u{11be}", "\u{c967}", "\u{110c}\u{1171}\u{11be}"),
        ("\u{c968}", "\u{c968}", "\u{110c}\u{1171}\u{11bf}", "\u{c968}",
        "\u{110c}\u{1171}\u{11bf}"), ("\u{c969}", "\u{c969}", "\u{110c}\u{1171}\u{11c0}",
        "\u{c969}", "\u{110c}\u{1171}\u{11c0}"), ("\u{c96a}", "\u{c96a}",
        "\u{110c}\u{1171}\u{11c1}", "\u{c96a}", "\u{110c}\u{1171}\u{11c1}"), ("\u{c96b}",
        "\u{c96b}", "\u{110c}\u{1171}\u{11c2}", "\u{c96b}", "\u{110c}\u{1171}\u{11c2}"),
        ("\u{c96c}", "\u{c96c}", "\u{110c}\u{1172}", "\u{c96c}", "\u{110c}\u{1172}"), ("\u{c96d}",
        "\u{c96d}", "\u{110c}\u{1172}\u{11a8}", "\u{c96d}", "\u{110c}\u{1172}\u{11a8}"),
        ("\u{c96e}", "\u{c96e}", "\u{110c}\u{1172}\u{11a9}", "\u{c96e}",
        "\u{110c}\u{1172}\u{11a9}"), ("\u{c96f}", "\u{c96f}", "\u{110c}\u{1172}\u{11aa}",
        "\u{c96f}", "\u{110c}\u{1172}\u{11aa}"), ("\u{c970}", "\u{c970}",
        "\u{110c}\u{1172}\u{11ab}", "\u{c970}", "\u{110c}\u{1172}\u{11ab}"), ("\u{c971}",
        "\u{c971}", "\u{110c}\u{1172}\u{11ac}", "\u{c971}", "\u{110c}\u{1172}\u{11ac}"),
        ("\u{c972}", "\u{c972}", "\u{110c}\u{1172}\u{11ad}", "\u{c972}",
        "\u{110c}\u{1172}\u{11ad}"), ("\u{c973}", "\u{c973}", "\u{110c}\u{1172}\u{11ae}",
        "\u{c973}", "\u{110c}\u{1172}\u{11ae}"), ("\u{c974}", "\u{c974}",
        "\u{110c}\u{1172}\u{11af}", "\u{c974}", "\u{110c}\u{1172}\u{11af}"), ("\u{c975}",
        "\u{c975}", "\u{110c}\u{1172}\u{11b0}", "\u{c975}", "\u{110c}\u{1172}\u{11b0}"),
        ("\u{c976}", "\u{c976}", "\u{110c}\u{1172}\u{11b1}", "\u{c976}",
        "\u{110c}\u{1172}\u{11b1}"), ("\u{c977}", "\u{c977}", "\u{110c}\u{1172}\u{11b2}",
        "\u{c977}", "\u{110c}\u{1172}\u{11b2}"), ("\u{c978}", "\u{c978}",
        "\u{110c}\u{1172}\u{11b3}", "\u{c978}", "\u{110c}\u{1172}\u{11b3}"), ("\u{c979}",
        "\u{c979}", "\u{110c}\u{1172}\u{11b4}", "\u{c979}", "\u{110c}\u{1172}\u{11b4}"),
        ("\u{c97a}", "\u{c97a}", "\u{110c}\u{1172}\u{11b5}", "\u{c97a}",
        "\u{110c}\u{1172}\u{11b5}"), ("\u{c97b}", "\u{c97b}", "\u{110c}\u{1172}\u{11b6}",
        "\u{c97b}", "\u{110c}\u{1172}\u{11b6}"), ("\u{c97c}", "\u{c97c}",
        "\u{110c}\u{1172}\u{11b7}", "\u{c97c}", "\u{110c}\u{1172}\u{11b7}"), ("\u{c97d}",
        "\u{c97d}", "\u{110c}\u{1172}\u{11b8}", "\u{c97d}", "\u{110c}\u{1172}\u{11b8}"),
        ("\u{c97e}", "\u{c97e}", "\u{110c}\u{1172}\u{11b9}", "\u{c97e}",
        "\u{110c}\u{1172}\u{11b9}"), ("\u{c97f}", "\u{c97f}", "\u{110c}\u{1172}\u{11ba}",
        "\u{c97f}", "\u{110c}\u{1172}\u{11ba}"), ("\u{c980}", "\u{c980}",
        "\u{110c}\u{1172}\u{11bb}", "\u{c980}", "\u{110c}\u{1172}\u{11bb}"), ("\u{c981}",
        "\u{c981}", "\u{110c}\u{1172}\u{11bc}", "\u{c981}", "\u{110c}\u{1172}\u{11bc}"),
        ("\u{c982}", "\u{c982}", "\u{110c}\u{1172}\u{11bd}", "\u{c982}",
        "\u{110c}\u{1172}\u{11bd}"), ("\u{c983}", "\u{c983}", "\u{110c}\u{1172}\u{11be}",
        "\u{c983}", "\u{110c}\u{1172}\u{11be}"), ("\u{c984}", "\u{c984}",
        "\u{110c}\u{1172}\u{11bf}", "\u{c984}", "\u{110c}\u{1172}\u{11bf}"), ("\u{c985}",
        "\u{c985}", "\u{110c}\u{1172}\u{11c0}", "\u{c985}", "\u{110c}\u{1172}\u{11c0}"),
        ("\u{c986}", "\u{c986}", "\u{110c}\u{1172}\u{11c1}", "\u{c986}",
        "\u{110c}\u{1172}\u{11c1}"), ("\u{c987}", "\u{c987}", "\u{110c}\u{1172}\u{11c2}",
        "\u{c987}", "\u{110c}\u{1172}\u{11c2}"), ("\u{c988}", "\u{c988}", "\u{110c}\u{1173}",
        "\u{c988}", "\u{110c}\u{1173}"), ("\u{c989}", "\u{c989}", "\u{110c}\u{1173}\u{11a8}",
        "\u{c989}", "\u{110c}\u{1173}\u{11a8}"), ("\u{c98a}", "\u{c98a}",
        "\u{110c}\u{1173}\u{11a9}", "\u{c98a}", "\u{110c}\u{1173}\u{11a9}"), ("\u{c98b}",
        "\u{c98b}", "\u{110c}\u{1173}\u{11aa}", "\u{c98b}", "\u{110c}\u{1173}\u{11aa}"),
        ("\u{c98c}", "\u{c98c}", "\u{110c}\u{1173}\u{11ab}", "\u{c98c}",
        "\u{110c}\u{1173}\u{11ab}"), ("\u{c98d}", "\u{c98d}", "\u{110c}\u{1173}\u{11ac}",
        "\u{c98d}", "\u{110c}\u{1173}\u{11ac}"), ("\u{c98e}", "\u{c98e}",
        "\u{110c}\u{1173}\u{11ad}", "\u{c98e}", "\u{110c}\u{1173}\u{11ad}"), ("\u{c98f}",
        "\u{c98f}", "\u{110c}\u{1173}\u{11ae}", "\u{c98f}", "\u{110c}\u{1173}\u{11ae}"),
        ("\u{c990}", "\u{c990}", "\u{110c}\u{1173}\u{11af}", "\u{c990}",
        "\u{110c}\u{1173}\u{11af}"), ("\u{c991}", "\u{c991}", "\u{110c}\u{1173}\u{11b0}",
        "\u{c991}", "\u{110c}\u{1173}\u{11b0}"), ("\u{c992}", "\u{c992}",
        "\u{110c}\u{1173}\u{11b1}", "\u{c992}", "\u{110c}\u{1173}\u{11b1}"), ("\u{c993}",
        "\u{c993}", "\u{110c}\u{1173}\u{11b2}", "\u{c993}", "\u{110c}\u{1173}\u{11b2}"),
        ("\u{c994}", "\u{c994}", "\u{110c}\u{1173}\u{11b3}", "\u{c994}",
        "\u{110c}\u{1173}\u{11b3}"), ("\u{c995}", "\u{c995}", "\u{110c}\u{1173}\u{11b4}",
        "\u{c995}", "\u{110c}\u{1173}\u{11b4}"), ("\u{c996}", "\u{c996}",
        "\u{110c}\u{1173}\u{11b5}", "\u{c996}", "\u{110c}\u{1173}\u{11b5}"), ("\u{c997}",
        "\u{c997}", "\u{110c}\u{1173}\u{11b6}", "\u{c997}", "\u{110c}\u{1173}\u{11b6}"),
        ("\u{c998}", "\u{c998}", "\u{110c}\u{1173}\u{11b7}", "\u{c998}",
        "\u{110c}\u{1173}\u{11b7}"), ("\u{c999}", "\u{c999}", "\u{110c}\u{1173}\u{11b8}",
        "\u{c999}", "\u{110c}\u{1173}\u{11b8}"), ("\u{c99a}", "\u{c99a}",
        "\u{110c}\u{1173}\u{11b9}", "\u{c99a}", "\u{110c}\u{1173}\u{11b9}"), ("\u{c99b}",
        "\u{c99b}", "\u{110c}\u{1173}\u{11ba}", "\u{c99b}", "\u{110c}\u{1173}\u{11ba}"),
        ("\u{c99c}", "\u{c99c}", "\u{110c}\u{1173}\u{11bb}", "\u{c99c}",
        "\u{110c}\u{1173}\u{11bb}"), ("\u{c99d}", "\u{c99d}", "\u{110c}\u{1173}\u{11bc}",
        "\u{c99d}", "\u{110c}\u{1173}\u{11bc}"), ("\u{c99e}", "\u{c99e}",
        "\u{110c}\u{1173}\u{11bd}", "\u{c99e}", "\u{110c}\u{1173}\u{11bd}"), ("\u{c99f}",
        "\u{c99f}", "\u{110c}\u{1173}\u{11be}", "\u{c99f}", "\u{110c}\u{1173}\u{11be}"),
        ("\u{c9a0}", "\u{c9a0}", "\u{110c}\u{1173}\u{11bf}", "\u{c9a0}",
        "\u{110c}\u{1173}\u{11bf}"), ("\u{c9a1}", "\u{c9a1}", "\u{110c}\u{1173}\u{11c0}",
        "\u{c9a1}", "\u{110c}\u{1173}\u{11c0}"), ("\u{c9a2}", "\u{c9a2}",
        "\u{110c}\u{1173}\u{11c1}", "\u{c9a2}", "\u{110c}\u{1173}\u{11c1}"), ("\u{c9a3}",
        "\u{c9a3}", "\u{110c}\u{1173}\u{11c2}", "\u{c9a3}", "\u{110c}\u{1173}\u{11c2}"),
        ("\u{c9a4}", "\u{c9a4}", "\u{110c}\u{1174}", "\u{c9a4}", "\u{110c}\u{1174}"), ("\u{c9a5}",
        "\u{c9a5}", "\u{110c}\u{1174}\u{11a8}", "\u{c9a5}", "\u{110c}\u{1174}\u{11a8}"),
        ("\u{c9a6}", "\u{c9a6}", "\u{110c}\u{1174}\u{11a9}", "\u{c9a6}",
        "\u{110c}\u{1174}\u{11a9}"), ("\u{c9a7}", "\u{c9a7}", "\u{110c}\u{1174}\u{11aa}",
        "\u{c9a7}", "\u{110c}\u{1174}\u{11aa}"), ("\u{c9a8}", "\u{c9a8}",
        "\u{110c}\u{1174}\u{11ab}", "\u{c9a8}", "\u{110c}\u{1174}\u{11ab}"), ("\u{c9a9}",
        "\u{c9a9}", "\u{110c}\u{1174}\u{11ac}", "\u{c9a9}", "\u{110c}\u{1174}\u{11ac}"),
        ("\u{c9aa}", "\u{c9aa}", "\u{110c}\u{1174}\u{11ad}", "\u{c9aa}",
        "\u{110c}\u{1174}\u{11ad}"), ("\u{c9ab}", "\u{c9ab}", "\u{110c}\u{1174}\u{11ae}",
        "\u{c9ab}", "\u{110c}\u{1174}\u{11ae}"), ("\u{c9ac}", "\u{c9ac}",
        "\u{110c}\u{1174}\u{11af}", "\u{c9ac}", "\u{110c}\u{1174}\u{11af}"), ("\u{c9ad}",
        "\u{c9ad}", "\u{110c}\u{1174}\u{11b0}", "\u{c9ad}", "\u{110c}\u{1174}\u{11b0}"),
        ("\u{c9ae}", "\u{c9ae}", "\u{110c}\u{1174}\u{11b1}", "\u{c9ae}",
        "\u{110c}\u{1174}\u{11b1}"), ("\u{c9af}", "\u{c9af}", "\u{110c}\u{1174}\u{11b2}",
        "\u{c9af}", "\u{110c}\u{1174}\u{11b2}"), ("\u{c9b0}", "\u{c9b0}",
        "\u{110c}\u{1174}\u{11b3}", "\u{c9b0}", "\u{110c}\u{1174}\u{11b3}"), ("\u{c9b1}",
        "\u{c9b1}", "\u{110c}\u{1174}\u{11b4}", "\u{c9b1}", "\u{110c}\u{1174}\u{11b4}"),
        ("\u{c9b2}", "\u{c9b2}", "\u{110c}\u{1174}\u{11b5}", "\u{c9b2}",
        "\u{110c}\u{1174}\u{11b5}"), ("\u{c9b3}", "\u{c9b3}", "\u{110c}\u{1174}\u{11b6}",
        "\u{c9b3}", "\u{110c}\u{1174}\u{11b6}"), ("\u{c9b4}", "\u{c9b4}",
        "\u{110c}\u{1174}\u{11b7}", "\u{c9b4}", "\u{110c}\u{1174}\u{11b7}"), ("\u{c9b5}",
        "\u{c9b5}", "\u{110c}\u{1174}\u{11b8}", "\u{c9b5}", "\u{110c}\u{1174}\u{11b8}"),
        ("\u{c9b6}", "\u{c9b6}", "\u{110c}\u{1174}\u{11b9}", "\u{c9b6}",
        "\u{110c}\u{1174}\u{11b9}"), ("\u{c9b7}", "\u{c9b7}", "\u{110c}\u{1174}\u{11ba}",
        "\u{c9b7}", "\u{110c}\u{1174}\u{11ba}"), ("\u{c9b8}", "\u{c9b8}",
        "\u{110c}\u{1174}\u{11bb}", "\u{c9b8}", "\u{110c}\u{1174}\u{11bb}"), ("\u{c9b9}",
        "\u{c9b9}", "\u{110c}\u{1174}\u{11bc}", "\u{c9b9}", "\u{110c}\u{1174}\u{11bc}"),
        ("\u{c9ba}", "\u{c9ba}", "\u{110c}\u{1174}\u{11bd}", "\u{c9ba}",
        "\u{110c}\u{1174}\u{11bd}"), ("\u{c9bb}", "\u{c9bb}", "\u{110c}\u{1174}\u{11be}",
        "\u{c9bb}", "\u{110c}\u{1174}\u{11be}"), ("\u{c9bc}", "\u{c9bc}",
        "\u{110c}\u{1174}\u{11bf}", "\u{c9bc}", "\u{110c}\u{1174}\u{11bf}"), ("\u{c9bd}",
        "\u{c9bd}", "\u{110c}\u{1174}\u{11c0}", "\u{c9bd}", "\u{110c}\u{1174}\u{11c0}"),
        ("\u{c9be}", "\u{c9be}", "\u{110c}\u{1174}\u{11c1}", "\u{c9be}",
        "\u{110c}\u{1174}\u{11c1}"), ("\u{c9bf}", "\u{c9bf}", "\u{110c}\u{1174}\u{11c2}",
        "\u{c9bf}", "\u{110c}\u{1174}\u{11c2}"), ("\u{c9c0}", "\u{c9c0}", "\u{110c}\u{1175}",
        "\u{c9c0}", "\u{110c}\u{1175}"), ("\u{c9c1}", "\u{c9c1}", "\u{110c}\u{1175}\u{11a8}",
        "\u{c9c1}", "\u{110c}\u{1175}\u{11a8}"), ("\u{c9c2}", "\u{c9c2}",
        "\u{110c}\u{1175}\u{11a9}", "\u{c9c2}", "\u{110c}\u{1175}\u{11a9}"), ("\u{c9c3}",
        "\u{c9c3}", "\u{110c}\u{1175}\u{11aa}", "\u{c9c3}", "\u{110c}\u{1175}\u{11aa}"),
        ("\u{c9c4}", "\u{c9c4}", "\u{110c}\u{1175}\u{11ab}", "\u{c9c4}",
        "\u{110c}\u{1175}\u{11ab}"), ("\u{c9c5}", "\u{c9c5}", "\u{110c}\u{1175}\u{11ac}",
        "\u{c9c5}", "\u{110c}\u{1175}\u{11ac}"), ("\u{c9c6}", "\u{c9c6}",
        "\u{110c}\u{1175}\u{11ad}", "\u{c9c6}", "\u{110c}\u{1175}\u{11ad}"), ("\u{c9c7}",
        "\u{c9c7}", "\u{110c}\u{1175}\u{11ae}", "\u{c9c7}", "\u{110c}\u{1175}\u{11ae}"),
        ("\u{c9c8}", "\u{c9c8}", "\u{110c}\u{1175}\u{11af}", "\u{c9c8}",
        "\u{110c}\u{1175}\u{11af}"), ("\u{c9c9}", "\u{c9c9}", "\u{110c}\u{1175}\u{11b0}",
        "\u{c9c9}", "\u{110c}\u{1175}\u{11b0}"), ("\u{c9ca}", "\u{c9ca}",
        "\u{110c}\u{1175}\u{11b1}", "\u{c9ca}", "\u{110c}\u{1175}\u{11b1}"), ("\u{c9cb}",
        "\u{c9cb}", "\u{110c}\u{1175}\u{11b2}", "\u{c9cb}", "\u{110c}\u{1175}\u{11b2}"),
        ("\u{c9cc}", "\u{c9cc}", "\u{110c}\u{1175}\u{11b3}", "\u{c9cc}",
        "\u{110c}\u{1175}\u{11b3}"), ("\u{c9cd}", "\u{c9cd}", "\u{110c}\u{1175}\u{11b4}",
        "\u{c9cd}", "\u{110c}\u{1175}\u{11b4}"), ("\u{c9ce}", "\u{c9ce}",
        "\u{110c}\u{1175}\u{11b5}", "\u{c9ce}", "\u{110c}\u{1175}\u{11b5}"), ("\u{c9cf}",
        "\u{c9cf}", "\u{110c}\u{1175}\u{11b6}", "\u{c9cf}", "\u{110c}\u{1175}\u{11b6}"),
        ("\u{c9d0}", "\u{c9d0}", "\u{110c}\u{1175}\u{11b7}", "\u{c9d0}",
        "\u{110c}\u{1175}\u{11b7}"), ("\u{c9d1}", "\u{c9d1}", "\u{110c}\u{1175}\u{11b8}",
        "\u{c9d1}", "\u{110c}\u{1175}\u{11b8}"), ("\u{c9d2}", "\u{c9d2}",
        "\u{110c}\u{1175}\u{11b9}", "\u{c9d2}", "\u{110c}\u{1175}\u{11b9}"), ("\u{c9d3}",
        "\u{c9d3}", "\u{110c}\u{1175}\u{11ba}", "\u{c9d3}", "\u{110c}\u{1175}\u{11ba}"),
        ("\u{c9d4}", "\u{c9d4}", "\u{110c}\u{1175}\u{11bb}", "\u{c9d4}",
        "\u{110c}\u{1175}\u{11bb}"), ("\u{c9d5}", "\u{c9d5}", "\u{110c}\u{1175}\u{11bc}",
        "\u{c9d5}", "\u{110c}\u{1175}\u{11bc}"), ("\u{c9d6}", "\u{c9d6}",
        "\u{110c}\u{1175}\u{11bd}", "\u{c9d6}", "\u{110c}\u{1175}\u{11bd}"), ("\u{c9d7}",
        "\u{c9d7}", "\u{110c}\u{1175}\u{11be}", "\u{c9d7}", "\u{110c}\u{1175}\u{11be}"),
        ("\u{c9d8}", "\u{c9d8}", "\u{110c}\u{1175}\u{11bf}", "\u{c9d8}",
        "\u{110c}\u{1175}\u{11bf}"), ("\u{c9d9}", "\u{c9d9}", "\u{110c}\u{1175}\u{11c0}",
        "\u{c9d9}", "\u{110c}\u{1175}\u{11c0}"), ("\u{c9da}", "\u{c9da}",
        "\u{110c}\u{1175}\u{11c1}", "\u{c9da}", "\u{110c}\u{1175}\u{11c1}"), ("\u{c9db}",
        "\u{c9db}", "\u{110c}\u{1175}\u{11c2}", "\u{c9db}", "\u{110c}\u{1175}\u{11c2}"),
        ("\u{c9dc}", "\u{c9dc}", "\u{110d}\u{1161}", "\u{c9dc}", "\u{110d}\u{1161}"), ("\u{c9dd}",
        "\u{c9dd}", "\u{110d}\u{1161}\u{11a8}", "\u{c9dd}", "\u{110d}\u{1161}\u{11a8}"),
        ("\u{c9de}", "\u{c9de}", "\u{110d}\u{1161}\u{11a9}", "\u{c9de}",
        "\u{110d}\u{1161}\u{11a9}"), ("\u{c9df}", "\u{c9df}", "\u{110d}\u{1161}\u{11aa}",
        "\u{c9df}", "\u{110d}\u{1161}\u{11aa}"), ("\u{c9e0}", "\u{c9e0}",
        "\u{110d}\u{1161}\u{11ab}", "\u{c9e0}", "\u{110d}\u{1161}\u{11ab}"), ("\u{c9e1}",
        "\u{c9e1}", "\u{110d}\u{1161}\u{11ac}", "\u{c9e1}", "\u{110d}\u{1161}\u{11ac}"),
        ("\u{c9e2}", "\u{c9e2}", "\u{110d}\u{1161}\u{11ad}", "\u{c9e2}",
        "\u{110d}\u{1161}\u{11ad}"), ("\u{c9e3}", "\u{c9e3}", "\u{110d}\u{1161}\u{11ae}",
        "\u{c9e3}", "\u{110d}\u{1161}\u{11ae}"), ("\u{c9e4}", "\u{c9e4}",
        "\u{110d}\u{1161}\u{11af}", "\u{c9e4}", "\u{110d}\u{1161}\u{11af}"), ("\u{c9e5}",
        "\u{c9e5}", "\u{110d}\u{1161}\u{11b0}", "\u{c9e5}", "\u{110d}\u{1161}\u{11b0}"),
        ("\u{c9e6}", "\u{c9e6}", "\u{110d}\u{1161}\u{11b1}", "\u{c9e6}",
        "\u{110d}\u{1161}\u{11b1}"), ("\u{c9e7}", "\u{c9e7}", "\u{110d}\u{1161}\u{11b2}",
        "\u{c9e7}", "\u{110d}\u{1161}\u{11b2}"), ("\u{c9e8}", "\u{c9e8}",
        "\u{110d}\u{1161}\u{11b3}", "\u{c9e8}", "\u{110d}\u{1161}\u{11b3}"), ("\u{c9e9}",
        "\u{c9e9}", "\u{110d}\u{1161}\u{11b4}", "\u{c9e9}", "\u{110d}\u{1161}\u{11b4}"),
        ("\u{c9ea}", "\u{c9ea}", "\u{110d}\u{1161}\u{11b5}", "\u{c9ea}",
        "\u{110d}\u{1161}\u{11b5}"), ("\u{c9eb}", "\u{c9eb}", "\u{110d}\u{1161}\u{11b6}",
        "\u{c9eb}", "\u{110d}\u{1161}\u{11b6}"), ("\u{c9ec}", "\u{c9ec}",
        "\u{110d}\u{1161}\u{11b7}", "\u{c9ec}", "\u{110d}\u{1161}\u{11b7}"), ("\u{c9ed}",
        "\u{c9ed}", "\u{110d}\u{1161}\u{11b8}", "\u{c9ed}", "\u{110d}\u{1161}\u{11b8}"),
        ("\u{c9ee}", "\u{c9ee}", "\u{110d}\u{1161}\u{11b9}", "\u{c9ee}",
        "\u{110d}\u{1161}\u{11b9}"), ("\u{c9ef}", "\u{c9ef}", "\u{110d}\u{1161}\u{11ba}",
        "\u{c9ef}", "\u{110d}\u{1161}\u{11ba}"), ("\u{c9f0}", "\u{c9f0}",
        "\u{110d}\u{1161}\u{11bb}", "\u{c9f0}", "\u{110d}\u{1161}\u{11bb}"), ("\u{c9f1}",
        "\u{c9f1}", "\u{110d}\u{1161}\u{11bc}", "\u{c9f1}", "\u{110d}\u{1161}\u{11bc}"),
        ("\u{c9f2}", "\u{c9f2}", "\u{110d}\u{1161}\u{11bd}", "\u{c9f2}",
        "\u{110d}\u{1161}\u{11bd}"), ("\u{c9f3}", "\u{c9f3}", "\u{110d}\u{1161}\u{11be}",
        "\u{c9f3}", "\u{110d}\u{1161}\u{11be}"), ("\u{c9f4}", "\u{c9f4}",
        "\u{110d}\u{1161}\u{11bf}", "\u{c9f4}", "\u{110d}\u{1161}\u{11bf}"), ("\u{c9f5}",
        "\u{c9f5}", "\u{110d}\u{1161}\u{11c0}", "\u{c9f5}", "\u{110d}\u{1161}\u{11c0}"),
        ("\u{c9f6}", "\u{c9f6}", "\u{110d}\u{1161}\u{11c1}", "\u{c9f6}",
        "\u{110d}\u{1161}\u{11c1}"), ("\u{c9f7}", "\u{c9f7}", "\u{110d}\u{1161}\u{11c2}",
        "\u{c9f7}", "\u{110d}\u{1161}\u{11c2}"), ("\u{c9f8}", "\u{c9f8}", "\u{110d}\u{1162}",
        "\u{c9f8}", "\u{110d}\u{1162}"), ("\u{c9f9}", "\u{c9f9}", "\u{110d}\u{1162}\u{11a8}",
        "\u{c9f9}", "\u{110d}\u{1162}\u{11a8}"), ("\u{c9fa}", "\u{c9fa}",
        "\u{110d}\u{1162}\u{11a9}", "\u{c9fa}", "\u{110d}\u{1162}\u{11a9}"), ("\u{c9fb}",
        "\u{c9fb}", "\u{110d}\u{1162}\u{11aa}", "\u{c9fb}", "\u{110d}\u{1162}\u{11aa}"),
        ("\u{c9fc}", "\u{c9fc}", "\u{110d}\u{1162}\u{11ab}", "\u{c9fc}",
        "\u{110d}\u{1162}\u{11ab}"), ("\u{c9fd}", "\u{c9fd}", "\u{110d}\u{1162}\u{11ac}",
        "\u{c9fd}", "\u{110d}\u{1162}\u{11ac}"), ("\u{c9fe}", "\u{c9fe}",
        "\u{110d}\u{1162}\u{11ad}", "\u{c9fe}", "\u{110d}\u{1162}\u{11ad}"), ("\u{c9ff}",
        "\u{c9ff}", "\u{110d}\u{1162}\u{11ae}", "\u{c9ff}", "\u{110d}\u{1162}\u{11ae}"),
        ("\u{ca00}", "\u{ca00}", "\u{110d}\u{1162}\u{11af}", "\u{ca00}",
        "\u{110d}\u{1162}\u{11af}"), ("\u{ca01}", "\u{ca01}", "\u{110d}\u{1162}\u{11b0}",
        "\u{ca01}", "\u{110d}\u{1162}\u{11b0}"), ("\u{ca02}", "\u{ca02}",
        "\u{110d}\u{1162}\u{11b1}", "\u{ca02}", "\u{110d}\u{1162}\u{11b1}"), ("\u{ca03}",
        "\u{ca03}", "\u{110d}\u{1162}\u{11b2}", "\u{ca03}", "\u{110d}\u{1162}\u{11b2}"),
        ("\u{ca04}", "\u{ca04}", "\u{110d}\u{1162}\u{11b3}", "\u{ca04}",
        "\u{110d}\u{1162}\u{11b3}"), ("\u{ca05}", "\u{ca05}", "\u{110d}\u{1162}\u{11b4}",
        "\u{ca05}", "\u{110d}\u{1162}\u{11b4}"), ("\u{ca06}", "\u{ca06}",
        "\u{110d}\u{1162}\u{11b5}", "\u{ca06}", "\u{110d}\u{1162}\u{11b5}"), ("\u{ca07}",
        "\u{ca07}", "\u{110d}\u{1162}\u{11b6}", "\u{ca07}", "\u{110d}\u{1162}\u{11b6}"),
        ("\u{ca08}", "\u{ca08}", "\u{110d}\u{1162}\u{11b7}", "\u{ca08}",
        "\u{110d}\u{1162}\u{11b7}"), ("\u{ca09}", "\u{ca09}", "\u{110d}\u{1162}\u{11b8}",
        "\u{ca09}", "\u{110d}\u{1162}\u{11b8}"), ("\u{ca0a}", "\u{ca0a}",
        "\u{110d}\u{1162}\u{11b9}", "\u{ca0a}", "\u{110d}\u{1162}\u{11b9}"), ("\u{ca0b}",
        "\u{ca0b}", "\u{110d}\u{1162}\u{11ba}", "\u{ca0b}", "\u{110d}\u{1162}\u{11ba}"),
        ("\u{ca0c}", "\u{ca0c}", "\u{110d}\u{1162}\u{11bb}", "\u{ca0c}",
        "\u{110d}\u{1162}\u{11bb}"), ("\u{ca0d}", "\u{ca0d}", "\u{110d}\u{1162}\u{11bc}",
        "\u{ca0d}", "\u{110d}\u{1162}\u{11bc}"), ("\u{ca0e}", "\u{ca0e}",
        "\u{110d}\u{1162}\u{11bd}", "\u{ca0e}", "\u{110d}\u{1162}\u{11bd}"), ("\u{ca0f}",
        "\u{ca0f}", "\u{110d}\u{1162}\u{11be}", "\u{ca0f}", "\u{110d}\u{1162}\u{11be}"),
        ("\u{ca10}", "\u{ca10}", "\u{110d}\u{1162}\u{11bf}", "\u{ca10}",
        "\u{110d}\u{1162}\u{11bf}"), ("\u{ca11}", "\u{ca11}", "\u{110d}\u{1162}\u{11c0}",
        "\u{ca11}", "\u{110d}\u{1162}\u{11c0}"), ("\u{ca12}", "\u{ca12}",
        "\u{110d}\u{1162}\u{11c1}", "\u{ca12}", "\u{110d}\u{1162}\u{11c1}"), ("\u{ca13}",
        "\u{ca13}", "\u{110d}\u{1162}\u{11c2}", "\u{ca13}", "\u{110d}\u{1162}\u{11c2}"),
        ("\u{ca14}", "\u{ca14}", "\u{110d}\u{1163}", "\u{ca14}", "\u{110d}\u{1163}"), ("\u{ca15}",
        "\u{ca15}", "\u{110d}\u{1163}\u{11a8}", "\u{ca15}", "\u{110d}\u{1163}\u{11a8}"),
        ("\u{ca16}", "\u{ca16}", "\u{110d}\u{1163}\u{11a9}", "\u{ca16}",
        "\u{110d}\u{1163}\u{11a9}"), ("\u{ca17}", "\u{ca17}", "\u{110d}\u{1163}\u{11aa}",
        "\u{ca17}", "\u{110d}\u{1163}\u{11aa}"), ("\u{ca18}", "\u{ca18}",
        "\u{110d}\u{1163}\u{11ab}", "\u{ca18}", "\u{110d}\u{1163}\u{11ab}"), ("\u{ca19}",
        "\u{ca19}", "\u{110d}\u{1163}\u{11ac}", "\u{ca19}", "\u{110d}\u{1163}\u{11ac}"),
        ("\u{ca1a}", "\u{ca1a}", "\u{110d}\u{1163}\u{11ad}", "\u{ca1a}",
        "\u{110d}\u{1163}\u{11ad}"), ("\u{ca1b}", "\u{ca1b}", "\u{110d}\u{1163}\u{11ae}",
        "\u{ca1b}", "\u{110d}\u{1163}\u{11ae}"), ("\u{ca1c}", "\u{ca1c}",
        "\u{110d}\u{1163}\u{11af}", "\u{ca1c}", "\u{110d}\u{1163}\u{11af}"), ("\u{ca1d}",
        "\u{ca1d}", "\u{110d}\u{1163}\u{11b0}", "\u{ca1d}", "\u{110d}\u{1163}\u{11b0}"),
        ("\u{ca1e}", "\u{ca1e}", "\u{110d}\u{1163}\u{11b1}", "\u{ca1e}",
        "\u{110d}\u{1163}\u{11b1}"), ("\u{ca1f}", "\u{ca1f}", "\u{110d}\u{1163}\u{11b2}",
        "\u{ca1f}", "\u{110d}\u{1163}\u{11b2}"), ("\u{ca20}", "\u{ca20}",
        "\u{110d}\u{1163}\u{11b3}", "\u{ca20}", "\u{110d}\u{1163}\u{11b3}"), ("\u{ca21}",
        "\u{ca21}", "\u{110d}\u{1163}\u{11b4}", "\u{ca21}", "\u{110d}\u{1163}\u{11b4}"),
        ("\u{ca22}", "\u{ca22}", "\u{110d}\u{1163}\u{11b5}", "\u{ca22}",
        "\u{110d}\u{1163}\u{11b5}"), ("\u{ca23}", "\u{ca23}", "\u{110d}\u{1163}\u{11b6}",
        "\u{ca23}", "\u{110d}\u{1163}\u{11b6}"), ("\u{ca24}", "\u{ca24}",
        "\u{110d}\u{1163}\u{11b7}", "\u{ca24}", "\u{110d}\u{1163}\u{11b7}"), ("\u{ca25}",
        "\u{ca25}", "\u{110d}\u{1163}\u{11b8}", "\u{ca25}", "\u{110d}\u{1163}\u{11b8}"),
        ("\u{ca26}", "\u{ca26}", "\u{110d}\u{1163}\u{11b9}", "\u{ca26}",
        "\u{110d}\u{1163}\u{11b9}"), ("\u{ca27}", "\u{ca27}", "\u{110d}\u{1163}\u{11ba}",
        "\u{ca27}", "\u{110d}\u{1163}\u{11ba}"), ("\u{ca28}", "\u{ca28}",
        "\u{110d}\u{1163}\u{11bb}", "\u{ca28}", "\u{110d}\u{1163}\u{11bb}"), ("\u{ca29}",
        "\u{ca29}", "\u{110d}\u{1163}\u{11bc}", "\u{ca29}", "\u{110d}\u{1163}\u{11bc}"),
        ("\u{ca2a}", "\u{ca2a}", "\u{110d}\u{1163}\u{11bd}", "\u{ca2a}",
        "\u{110d}\u{1163}\u{11bd}"), ("\u{ca2b}", "\u{ca2b}", "\u{110d}\u{1163}\u{11be}",
        "\u{ca2b}", "\u{110d}\u{1163}\u{11be}"), ("\u{ca2c}", "\u{ca2c}",
        "\u{110d}\u{1163}\u{11bf}", "\u{ca2c}", "\u{110d}\u{1163}\u{11bf}"), ("\u{ca2d}",
        "\u{ca2d}", "\u{110d}\u{1163}\u{11c0}", "\u{ca2d}", "\u{110d}\u{1163}\u{11c0}"),
        ("\u{ca2e}", "\u{ca2e}", "\u{110d}\u{1163}\u{11c1}", "\u{ca2e}",
        "\u{110d}\u{1163}\u{11c1}"), ("\u{ca2f}", "\u{ca2f}", "\u{110d}\u{1163}\u{11c2}",
        "\u{ca2f}", "\u{110d}\u{1163}\u{11c2}"), ("\u{ca30}", "\u{ca30}", "\u{110d}\u{1164}",
        "\u{ca30}", "\u{110d}\u{1164}"), ("\u{ca31}", "\u{ca31}", "\u{110d}\u{1164}\u{11a8}",
        "\u{ca31}", "\u{110d}\u{1164}\u{11a8}"), ("\u{ca32}", "\u{ca32}",
        "\u{110d}\u{1164}\u{11a9}", "\u{ca32}", "\u{110d}\u{1164}\u{11a9}"), ("\u{ca33}",
        "\u{ca33}", "\u{110d}\u{1164}\u{11aa}", "\u{ca33}", "\u{110d}\u{1164}\u{11aa}"),
        ("\u{ca34}", "\u{ca34}", "\u{110d}\u{1164}\u{11ab}", "\u{ca34}",
        "\u{110d}\u{1164}\u{11ab}"), ("\u{ca35}", "\u{ca35}", "\u{110d}\u{1164}\u{11ac}",
        "\u{ca35}", "\u{110d}\u{1164}\u{11ac}"), ("\u{ca36}", "\u{ca36}",
        "\u{110d}\u{1164}\u{11ad}", "\u{ca36}", "\u{110d}\u{1164}\u{11ad}"), ("\u{ca37}",
        "\u{ca37}", "\u{110d}\u{1164}\u{11ae}", "\u{ca37}", "\u{110d}\u{1164}\u{11ae}"),
        ("\u{ca38}", "\u{ca38}", "\u{110d}\u{1164}\u{11af}", "\u{ca38}",
        "\u{110d}\u{1164}\u{11af}"), ("\u{ca39}", "\u{ca39}", "\u{110d}\u{1164}\u{11b0}",
        "\u{ca39}", "\u{110d}\u{1164}\u{11b0}"), ("\u{ca3a}", "\u{ca3a}",
        "\u{110d}\u{1164}\u{11b1}", "\u{ca3a}", "\u{110d}\u{1164}\u{11b1}"), ("\u{ca3b}",
        "\u{ca3b}", "\u{110d}\u{1164}\u{11b2}", "\u{ca3b}", "\u{110d}\u{1164}\u{11b2}"),
        ("\u{ca3c}", "\u{ca3c}", "\u{110d}\u{1164}\u{11b3}", "\u{ca3c}",
        "\u{110d}\u{1164}\u{11b3}"), ("\u{ca3d}", "\u{ca3d}", "\u{110d}\u{1164}\u{11b4}",
        "\u{ca3d}", "\u{110d}\u{1164}\u{11b4}"), ("\u{ca3e}", "\u{ca3e}",
        "\u{110d}\u{1164}\u{11b5}", "\u{ca3e}", "\u{110d}\u{1164}\u{11b5}"), ("\u{ca3f}",
        "\u{ca3f}", "\u{110d}\u{1164}\u{11b6}", "\u{ca3f}", "\u{110d}\u{1164}\u{11b6}"),
        ("\u{ca40}", "\u{ca40}", "\u{110d}\u{1164}\u{11b7}", "\u{ca40}",
        "\u{110d}\u{1164}\u{11b7}"), ("\u{ca41}", "\u{ca41}", "\u{110d}\u{1164}\u{11b8}",
        "\u{ca41}", "\u{110d}\u{1164}\u{11b8}"), ("\u{ca42}", "\u{ca42}",
        "\u{110d}\u{1164}\u{11b9}", "\u{ca42}", "\u{110d}\u{1164}\u{11b9}"), ("\u{ca43}",
        "\u{ca43}", "\u{110d}\u{1164}\u{11ba}", "\u{ca43}", "\u{110d}\u{1164}\u{11ba}"),
        ("\u{ca44}", "\u{ca44}", "\u{110d}\u{1164}\u{11bb}", "\u{ca44}",
        "\u{110d}\u{1164}\u{11bb}"), ("\u{ca45}", "\u{ca45}", "\u{110d}\u{1164}\u{11bc}",
        "\u{ca45}", "\u{110d}\u{1164}\u{11bc}"), ("\u{ca46}", "\u{ca46}",
        "\u{110d}\u{1164}\u{11bd}", "\u{ca46}", "\u{110d}\u{1164}\u{11bd}"), ("\u{ca47}",
        "\u{ca47}", "\u{110d}\u{1164}\u{11be}", "\u{ca47}", "\u{110d}\u{1164}\u{11be}"),
        ("\u{ca48}", "\u{ca48}", "\u{110d}\u{1164}\u{11bf}", "\u{ca48}",
        "\u{110d}\u{1164}\u{11bf}"), ("\u{ca49}", "\u{ca49}", "\u{110d}\u{1164}\u{11c0}",
        "\u{ca49}", "\u{110d}\u{1164}\u{11c0}"), ("\u{ca4a}", "\u{ca4a}",
        "\u{110d}\u{1164}\u{11c1}", "\u{ca4a}", "\u{110d}\u{1164}\u{11c1}"), ("\u{ca4b}",
        "\u{ca4b}", "\u{110d}\u{1164}\u{11c2}", "\u{ca4b}", "\u{110d}\u{1164}\u{11c2}"),
        ("\u{ca4c}", "\u{ca4c}", "\u{110d}\u{1165}", "\u{ca4c}", "\u{110d}\u{1165}"), ("\u{ca4d}",
        "\u{ca4d}", "\u{110d}\u{1165}\u{11a8}", "\u{ca4d}", "\u{110d}\u{1165}\u{11a8}"),
        ("\u{ca4e}", "\u{ca4e}", "\u{110d}\u{1165}\u{11a9}", "\u{ca4e}",
        "\u{110d}\u{1165}\u{11a9}"), ("\u{ca4f}", "\u{ca4f}", "\u{110d}\u{1165}\u{11aa}",
        "\u{ca4f}", "\u{110d}\u{1165}\u{11aa}"), ("\u{ca50}", "\u{ca50}",
        "\u{110d}\u{1165}\u{11ab}", "\u{ca50}", "\u{110d}\u{1165}\u{11ab}"), ("\u{ca51}",
        "\u{ca51}", "\u{110d}\u{1165}\u{11ac}", "\u{ca51}", "\u{110d}\u{1165}\u{11ac}"),
        ("\u{ca52}", "\u{ca52}", "\u{110d}\u{1165}\u{11ad}", "\u{ca52}",
        "\u{110d}\u{1165}\u{11ad}"), ("\u{ca53}", "\u{ca53}", "\u{110d}\u{1165}\u{11ae}",
        "\u{ca53}", "\u{110d}\u{1165}\u{11ae}"), ("\u{ca54}", "\u{ca54}",
        "\u{110d}\u{1165}\u{11af}", "\u{ca54}", "\u{110d}\u{1165}\u{11af}"), ("\u{ca55}",
        "\u{ca55}", "\u{110d}\u{1165}\u{11b0}", "\u{ca55}", "\u{110d}\u{1165}\u{11b0}"),
        ("\u{ca56}", "\u{ca56}", "\u{110d}\u{1165}\u{11b1}", "\u{ca56}",
        "\u{110d}\u{1165}\u{11b1}"), ("\u{ca57}", "\u{ca57}", "\u{110d}\u{1165}\u{11b2}",
        "\u{ca57}", "\u{110d}\u{1165}\u{11b2}"), ("\u{ca58}", "\u{ca58}",
        "\u{110d}\u{1165}\u{11b3}", "\u{ca58}", "\u{110d}\u{1165}\u{11b3}"), ("\u{ca59}",
        "\u{ca59}", "\u{110d}\u{1165}\u{11b4}", "\u{ca59}", "\u{110d}\u{1165}\u{11b4}"),
        ("\u{ca5a}", "\u{ca5a}", "\u{110d}\u{1165}\u{11b5}", "\u{ca5a}",
        "\u{110d}\u{1165}\u{11b5}"), ("\u{ca5b}", "\u{ca5b}", "\u{110d}\u{1165}\u{11b6}",
        "\u{ca5b}", "\u{110d}\u{1165}\u{11b6}"), ("\u{ca5c}", "\u{ca5c}",
        "\u{110d}\u{1165}\u{11b7}", "\u{ca5c}", "\u{110d}\u{1165}\u{11b7}"), ("\u{ca5d}",
        "\u{ca5d}", "\u{110d}\u{1165}\u{11b8}", "\u{ca5d}", "\u{110d}\u{1165}\u{11b8}"),
        ("\u{ca5e}", "\u{ca5e}", "\u{110d}\u{1165}\u{11b9}", "\u{ca5e}",
        "\u{110d}\u{1165}\u{11b9}"), ("\u{ca5f}", "\u{ca5f}", "\u{110d}\u{1165}\u{11ba}",
        "\u{ca5f}", "\u{110d}\u{1165}\u{11ba}"), ("\u{ca60}", "\u{ca60}",
        "\u{110d}\u{1165}\u{11bb}", "\u{ca60}", "\u{110d}\u{1165}\u{11bb}"), ("\u{ca61}",
        "\u{ca61}", "\u{110d}\u{1165}\u{11bc}", "\u{ca61}", "\u{110d}\u{1165}\u{11bc}"),
        ("\u{ca62}", "\u{ca62}", "\u{110d}\u{1165}\u{11bd}", "\u{ca62}",
        "\u{110d}\u{1165}\u{11bd}"), ("\u{ca63}", "\u{ca63}", "\u{110d}\u{1165}\u{11be}",
        "\u{ca63}", "\u{110d}\u{1165}\u{11be}"), ("\u{ca64}", "\u{ca64}",
        "\u{110d}\u{1165}\u{11bf}", "\u{ca64}", "\u{110d}\u{1165}\u{11bf}"), ("\u{ca65}",
        "\u{ca65}", "\u{110d}\u{1165}\u{11c0}", "\u{ca65}", "\u{110d}\u{1165}\u{11c0}"),
        ("\u{ca66}", "\u{ca66}", "\u{110d}\u{1165}\u{11c1}", "\u{ca66}",
        "\u{110d}\u{1165}\u{11c1}"), ("\u{ca67}", "\u{ca67}", "\u{110d}\u{1165}\u{11c2}",
        "\u{ca67}", "\u{110d}\u{1165}\u{11c2}"), ("\u{ca68}", "\u{ca68}", "\u{110d}\u{1166}",
        "\u{ca68}", "\u{110d}\u{1166}"), ("\u{ca69}", "\u{ca69}", "\u{110d}\u{1166}\u{11a8}",
        "\u{ca69}", "\u{110d}\u{1166}\u{11a8}"), ("\u{ca6a}", "\u{ca6a}",
        "\u{110d}\u{1166}\u{11a9}", "\u{ca6a}", "\u{110d}\u{1166}\u{11a9}"), ("\u{ca6b}",
        "\u{ca6b}", "\u{110d}\u{1166}\u{11aa}", "\u{ca6b}", "\u{110d}\u{1166}\u{11aa}"),
        ("\u{ca6c}", "\u{ca6c}", "\u{110d}\u{1166}\u{11ab}", "\u{ca6c}",
        "\u{110d}\u{1166}\u{11ab}"), ("\u{ca6d}", "\u{ca6d}", "\u{110d}\u{1166}\u{11ac}",
        "\u{ca6d}", "\u{110d}\u{1166}\u{11ac}"), ("\u{ca6e}", "\u{ca6e}",
        "\u{110d}\u{1166}\u{11ad}", "\u{ca6e}", "\u{110d}\u{1166}\u{11ad}"), ("\u{ca6f}",
        "\u{ca6f}", "\u{110d}\u{1166}\u{11ae}", "\u{ca6f}", "\u{110d}\u{1166}\u{11ae}"),
        ("\u{ca70}", "\u{ca70}", "\u{110d}\u{1166}\u{11af}", "\u{ca70}",
        "\u{110d}\u{1166}\u{11af}"), ("\u{ca71}", "\u{ca71}", "\u{110d}\u{1166}\u{11b0}",
        "\u{ca71}", "\u{110d}\u{1166}\u{11b0}"), ("\u{ca72}", "\u{ca72}",
        "\u{110d}\u{1166}\u{11b1}", "\u{ca72}", "\u{110d}\u{1166}\u{11b1}"), ("\u{ca73}",
        "\u{ca73}", "\u{110d}\u{1166}\u{11b2}", "\u{ca73}", "\u{110d}\u{1166}\u{11b2}"),
        ("\u{ca74}", "\u{ca74}", "\u{110d}\u{1166}\u{11b3}", "\u{ca74}",
        "\u{110d}\u{1166}\u{11b3}"), ("\u{ca75}", "\u{ca75}", "\u{110d}\u{1166}\u{11b4}",
        "\u{ca75}", "\u{110d}\u{1166}\u{11b4}"), ("\u{ca76}", "\u{ca76}",
        "\u{110d}\u{1166}\u{11b5}", "\u{ca76}", "\u{110d}\u{1166}\u{11b5}"), ("\u{ca77}",
        "\u{ca77}", "\u{110d}\u{1166}\u{11b6}", "\u{ca77}", "\u{110d}\u{1166}\u{11b6}"),
        ("\u{ca78}", "\u{ca78}", "\u{110d}\u{1166}\u{11b7}", "\u{ca78}",
        "\u{110d}\u{1166}\u{11b7}"), ("\u{ca79}", "\u{ca79}", "\u{110d}\u{1166}\u{11b8}",
        "\u{ca79}", "\u{110d}\u{1166}\u{11b8}"), ("\u{ca7a}", "\u{ca7a}",
        "\u{110d}\u{1166}\u{11b9}", "\u{ca7a}", "\u{110d}\u{1166}\u{11b9}"), ("\u{ca7b}",
        "\u{ca7b}", "\u{110d}\u{1166}\u{11ba}", "\u{ca7b}", "\u{110d}\u{1166}\u{11ba}"),
        ("\u{ca7c}", "\u{ca7c}", "\u{110d}\u{1166}\u{11bb}", "\u{ca7c}",
        "\u{110d}\u{1166}\u{11bb}"), ("\u{ca7d}", "\u{ca7d}", "\u{110d}\u{1166}\u{11bc}",
        "\u{ca7d}", "\u{110d}\u{1166}\u{11bc}"), ("\u{ca7e}", "\u{ca7e}",
        "\u{110d}\u{1166}\u{11bd}", "\u{ca7e}", "\u{110d}\u{1166}\u{11bd}"), ("\u{ca7f}",
        "\u{ca7f}", "\u{110d}\u{1166}\u{11be}", "\u{ca7f}", "\u{110d}\u{1166}\u{11be}"),
        ("\u{ca80}", "\u{ca80}", "\u{110d}\u{1166}\u{11bf}", "\u{ca80}",
        "\u{110d}\u{1166}\u{11bf}"), ("\u{ca81}", "\u{ca81}", "\u{110d}\u{1166}\u{11c0}",
        "\u{ca81}", "\u{110d}\u{1166}\u{11c0}"), ("\u{ca82}", "\u{ca82}",
        "\u{110d}\u{1166}\u{11c1}", "\u{ca82}", "\u{110d}\u{1166}\u{11c1}"), ("\u{ca83}",
        "\u{ca83}", "\u{110d}\u{1166}\u{11c2}", "\u{ca83}", "\u{110d}\u{1166}\u{11c2}"),
        ("\u{ca84}", "\u{ca84}", "\u{110d}\u{1167}", "\u{ca84}", "\u{110d}\u{1167}"), ("\u{ca85}",
        "\u{ca85}", "\u{110d}\u{1167}\u{11a8}", "\u{ca85}", "\u{110d}\u{1167}\u{11a8}"),
        ("\u{ca86}", "\u{ca86}", "\u{110d}\u{1167}\u{11a9}", "\u{ca86}",
        "\u{110d}\u{1167}\u{11a9}"), ("\u{ca87}", "\u{ca87}", "\u{110d}\u{1167}\u{11aa}",
        "\u{ca87}", "\u{110d}\u{1167}\u{11aa}"), ("\u{ca88}", "\u{ca88}",
        "\u{110d}\u{1167}\u{11ab}", "\u{ca88}", "\u{110d}\u{1167}\u{11ab}"), ("\u{ca89}",
        "\u{ca89}", "\u{110d}\u{1167}\u{11ac}", "\u{ca89}", "\u{110d}\u{1167}\u{11ac}"),
        ("\u{ca8a}", "\u{ca8a}", "\u{110d}\u{1167}\u{11ad}", "\u{ca8a}",
        "\u{110d}\u{1167}\u{11ad}"), ("\u{ca8b}", "\u{ca8b}", "\u{110d}\u{1167}\u{11ae}",
        "\u{ca8b}", "\u{110d}\u{1167}\u{11ae}"), ("\u{ca8c}", "\u{ca8c}",
        "\u{110d}\u{1167}\u{11af}", "\u{ca8c}", "\u{110d}\u{1167}\u{11af}"), ("\u{ca8d}",
        "\u{ca8d}", "\u{110d}\u{1167}\u{11b0}", "\u{ca8d}", "\u{110d}\u{1167}\u{11b0}"),
        ("\u{ca8e}", "\u{ca8e}", "\u{110d}\u{1167}\u{11b1}", "\u{ca8e}",
        "\u{110d}\u{1167}\u{11b1}"), ("\u{ca8f}", "\u{ca8f}", "\u{110d}\u{1167}\u{11b2}",
        "\u{ca8f}", "\u{110d}\u{1167}\u{11b2}"), ("\u{ca90}", "\u{ca90}",
        "\u{110d}\u{1167}\u{11b3}", "\u{ca90}", "\u{110d}\u{1167}\u{11b3}"), ("\u{ca91}",
        "\u{ca91}", "\u{110d}\u{1167}\u{11b4}", "\u{ca91}", "\u{110d}\u{1167}\u{11b4}"),
        ("\u{ca92}", "\u{ca92}", "\u{110d}\u{1167}\u{11b5}", "\u{ca92}",
        "\u{110d}\u{1167}\u{11b5}"), ("\u{ca93}", "\u{ca93}", "\u{110d}\u{1167}\u{11b6}",
        "\u{ca93}", "\u{110d}\u{1167}\u{11b6}"), ("\u{ca94}", "\u{ca94}",
        "\u{110d}\u{1167}\u{11b7}", "\u{ca94}", "\u{110d}\u{1167}\u{11b7}"), ("\u{ca95}",
        "\u{ca95}", "\u{110d}\u{1167}\u{11b8}", "\u{ca95}", "\u{110d}\u{1167}\u{11b8}"),
        ("\u{ca96}", "\u{ca96}", "\u{110d}\u{1167}\u{11b9}", "\u{ca96}",
        "\u{110d}\u{1167}\u{11b9}"), ("\u{ca97}", "\u{ca97}", "\u{110d}\u{1167}\u{11ba}",
        "\u{ca97}", "\u{110d}\u{1167}\u{11ba}"), ("\u{ca98}", "\u{ca98}",
        "\u{110d}\u{1167}\u{11bb}", "\u{ca98}", "\u{110d}\u{1167}\u{11bb}"), ("\u{ca99}",
        "\u{ca99}", "\u{110d}\u{1167}\u{11bc}", "\u{ca99}", "\u{110d}\u{1167}\u{11bc}"),
        ("\u{ca9a}", "\u{ca9a}", "\u{110d}\u{1167}\u{11bd}", "\u{ca9a}",
        